/* UserSettingsView.c generated by valac 0.56.3, the Vala compiler
 * generated from UserSettingsView.vala, do not modify */

/*
* Copyright (c) 2014-2017 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "useraccounts.h"
#include <act/act.h>
#include <gtk/gtk.h>
#include <handy.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <polkit/polkit.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libgnome-desktop/gnome-languages.h>
#include "run-passwd.h"
#include <granite.h>

#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING _ ("You do not have permission to change this")
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_CURRENT_USER_STRING _ ("You cannot change this for the currently active user")
#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_LAST_ADMIN_STRING _ ("You cannot remove the last administrator's privileges")

enum  {
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_0_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_user_accounts_widgets_user_settings_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NUM_PROPERTIES];
#define _switchboard_plug_user_accounts_user_utils_unref0(var) ((var == NULL) ? NULL : (var = (switchboard_plug_user_accounts_user_utils_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;

struct _SwitchboardPlugUserAccountsWidgetsUserSettingsViewPrivate {
	ActUser* _user;
	SwitchboardPlugUserAccountsUserUtils* utils;
	SwitchboardPlugUserAccountsDeltaUser* delta_user;
	GtkListStore* language_store;
	GtkListStore* region_store;
	HdyAvatar* avatar;
	GtkToggleButton* avatar_button;
	GtkEntry* full_name_entry;
	GtkButton* password_button;
	GtkButton* enable_user_button;
	GtkComboBoxText* user_type_box;
	GtkComboBox* language_box;
	GtkComboBox* region_box;
	GtkButton* language_button;
	GtkSwitch* autologin_switch;
	GtkImage* full_name_lock;
	GtkImage* user_type_lock;
	GtkImage* language_lock;
	GtkImage* autologin_lock;
	GtkImage* password_lock;
	GtkImage* enable_lock;
	GeeHashMap* default_regions;
};

struct _Block4Data {
	int _ref_count_;
	SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
	gchar* language;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	GtkTreeIter* active_iter;
};

struct _Block6Data {
	int _ref_count_;
	SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
	GtkRevealer* region_revealer;
};

static gint SwitchboardPlugUserAccountsWidgetsUserSettingsView_private_offset;
static gpointer switchboard_plug_user_accounts_widgets_user_settings_view_parent_class = NULL;

static void switchboard_plug_user_accounts_widgets_user_settings_view_update_permission (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void switchboard_plug_user_accounts_widgets_user_settings_view_update_ui (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static GdkPixbuf* switchboard_plug_user_accounts_widgets_user_settings_view_avatar_image_load_func (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                                                                                             gint size);
static GdkPixbuf* _switchboard_plug_user_accounts_widgets_user_settings_view_avatar_image_load_func_hdy_avatar_image_load_func (gint size,
                                                                                                                         gpointer self);
static gboolean _act_user_account_type_equal (const ActUserAccountType * s1,
                                       const ActUserAccountType * s2);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean ___lambda8_ (Block5Data* _data5_,
                      GtkTreeModel* model,
                      GtkTreePath* path,
                      GtkTreeIter* iter);
static gboolean ____lambda8__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                   GtkTreePath* path,
                                                   GtkTreeIter* iter,
                                                   gpointer self);
static void switchboard_plug_user_accounts_widgets_user_settings_view_change_lock (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void switchboard_plug_user_accounts_widgets_user_settings_view_change_password (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                                                                                ActUserPasswordMode mode,
                                                                                const gchar* new_password);
static void _____lambda9_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                     PasswdHandler* h,
                    GError* e);
static void _gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void ______lambda9__passwd_passwd_callback ( PasswdHandler* handler,
                                            GError* e,
                                            gpointer self);
static GObject * switchboard_plug_user_accounts_widgets_user_settings_view_constructor (GType type,
                                                                                 guint n_construct_properties,
                                                                                 GObjectConstructParam * construct_properties);
static void _switchboard_plug_user_accounts_widgets_user_settings_view___lambda10_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void ___lambda14_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void ____lambda14__gtk_widget_hide (GtkWidget* _sender,
                                    gpointer self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view___lambda10__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                                        gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view___lambda15_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view___lambda15__gtk_entry_activate (GtkEntry* _sender,
                                                                                                 gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view___lambda16_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view___lambda16__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                                    gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _switchboard_plug_user_accounts_widgets_user_settings_view____lambda17_ (Block6Data* _data6_);
static void __switchboard_plug_user_accounts_widgets_user_settings_view____lambda17__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                                     gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view____lambda18_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view____lambda18__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                                     gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view___lambda19_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view___lambda19__g_object_notify (GObject* _sender,
                                                                                              GParamSpec* pspec,
                                                                                              gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view___lambda20_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view_change_password_switchboard_plug_user_accounts_change_password_dialog_request_password_change (SwitchboardPlugUserAccountsChangePasswordDialog* _sender,
                                                                                                                                                               ActUserPasswordMode mode,
                                                                                                                                                               const gchar* new_password,
                                                                                                                                                               gpointer self);
static void __switchboard_plug_user_accounts_widgets_user_settings_view___lambda20__gtk_button_clicked (GtkButton* _sender,
                                                                                                 gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view_change_lock_gtk_button_clicked (GtkButton* _sender,
                                                                                                gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_g_object_notify (GObject* _sender,
                                                                                                   GParamSpec* pspec,
                                                                                                   gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view_update_ui_act_user_changed (ActUser* _sender,
                                                                                            gpointer self);
static void _switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_act_user_changed (ActUser* _sender,
                                                                                                    gpointer self);
static void switchboard_plug_user_accounts_widgets_user_settings_view_finalize (GObject * obj);
static GType switchboard_plug_user_accounts_widgets_user_settings_view_get_type_once (void);
static void _vala_switchboard_plug_user_accounts_widgets_user_settings_view_get_property (GObject * object,
                                                                                   guint property_id,
                                                                                   GValue * value,
                                                                                   GParamSpec * pspec);
static void _vala_switchboard_plug_user_accounts_widgets_user_settings_view_set_property (GObject * object,
                                                                                   guint property_id,
                                                                                   const GValue * value,
                                                                                   GParamSpec * pspec);

static inline gpointer
switchboard_plug_user_accounts_widgets_user_settings_view_get_instance_private (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugUserAccountsWidgetsUserSettingsView_private_offset);
}

SwitchboardPlugUserAccountsWidgetsUserSettingsView*
switchboard_plug_user_accounts_widgets_user_settings_view_construct (GType object_type,
                                                                     ActUser* user)
{
	SwitchboardPlugUserAccountsWidgetsUserSettingsView * self = NULL;
	g_return_val_if_fail (user != NULL, NULL);
	self = (SwitchboardPlugUserAccountsWidgetsUserSettingsView*) g_object_new (object_type, "column-spacing", 12, "halign", GTK_ALIGN_CENTER, "margin", 24, "row-spacing", 6, "user", user, NULL);
	return self;
}

SwitchboardPlugUserAccountsWidgetsUserSettingsView*
switchboard_plug_user_accounts_widgets_user_settings_view_new (ActUser* user)
{
	return switchboard_plug_user_accounts_widgets_user_settings_view_construct (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, user);
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_update_permission (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	gboolean allowed = FALSE;
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean current_user = FALSE;
	ActUser* _tmp5_;
	ActUser* _tmp6_;
	gboolean user_locked = FALSE;
	ActUser* _tmp7_;
	gboolean last_admin = FALSE;
	ActUser* _tmp8_;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_user_accounts_get_permission ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	allowed = _tmp4_;
	_tmp5_ = switchboard_plug_user_accounts_get_current_user ();
	_tmp6_ = self->priv->_user;
	current_user = _tmp5_ == _tmp6_;
	_tmp7_ = self->priv->_user;
	user_locked = act_user_get_locked (_tmp7_);
	_tmp8_ = self->priv->_user;
	last_admin = switchboard_plug_user_accounts_is_last_admin (_tmp8_);
	if (!allowed) {
		GtkComboBoxText* _tmp9_;
		GtkButton* _tmp10_;
		GtkSwitch* _tmp11_;
		GtkImage* _tmp12_;
		GtkImage* _tmp13_;
		GtkImage* _tmp14_;
		GtkImage* _tmp15_;
		_tmp9_ = self->priv->user_type_box;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
		_tmp10_ = self->priv->password_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
		_tmp11_ = self->priv->autologin_switch;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
		_tmp12_ = self->priv->user_type_lock;
		gtk_widget_set_opacity ((GtkWidget*) _tmp12_, (gdouble) 1);
		_tmp13_ = self->priv->autologin_lock;
		gtk_widget_set_opacity ((GtkWidget*) _tmp13_, (gdouble) 1);
		_tmp14_ = self->priv->password_lock;
		gtk_widget_set_opacity ((GtkWidget*) _tmp14_, (gdouble) 1);
		_tmp15_ = self->priv->user_type_lock;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
	}
	if (current_user) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = allowed;
	}
	if (_tmp16_) {
		GtkEntry* _tmp17_;
		GtkImage* _tmp18_;
		GtkImage* _tmp19_;
		_tmp17_ = self->priv->full_name_entry;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, TRUE);
		_tmp18_ = self->priv->full_name_lock;
		gtk_widget_set_opacity ((GtkWidget*) _tmp18_, (gdouble) 0);
		_tmp19_ = self->priv->language_lock;
		gtk_widget_set_opacity ((GtkWidget*) _tmp19_, (gdouble) 0);
		if (!user_locked) {
			GtkButton* _tmp20_;
			GtkImage* _tmp21_;
			_tmp20_ = self->priv->password_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, TRUE);
			_tmp21_ = self->priv->password_lock;
			gtk_widget_set_opacity ((GtkWidget*) _tmp21_, (gdouble) 0);
		} else {
			GtkButton* _tmp22_;
			GtkImage* _tmp23_;
			_tmp22_ = self->priv->password_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp22_, FALSE);
			_tmp23_ = self->priv->password_lock;
			gtk_widget_set_opacity ((GtkWidget*) _tmp23_, (gdouble) 1);
		}
		if (allowed) {
			gboolean _tmp28_ = FALSE;
			if (!user_locked) {
				GtkSwitch* _tmp24_;
				GtkImage* _tmp25_;
				_tmp24_ = self->priv->autologin_switch;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, TRUE);
				_tmp25_ = self->priv->autologin_lock;
				gtk_widget_set_opacity ((GtkWidget*) _tmp25_, (gdouble) 0);
			} else {
				GtkSwitch* _tmp26_;
				GtkImage* _tmp27_;
				_tmp26_ = self->priv->autologin_switch;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp26_, FALSE);
				_tmp27_ = self->priv->autologin_lock;
				gtk_widget_set_opacity ((GtkWidget*) _tmp27_, (gdouble) 1);
			}
			if (!last_admin) {
				_tmp28_ = !current_user;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				GtkComboBoxText* _tmp29_;
				GtkImage* _tmp30_;
				_tmp29_ = self->priv->user_type_box;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp29_, TRUE);
				_tmp30_ = self->priv->user_type_lock;
				gtk_widget_set_opacity ((GtkWidget*) _tmp30_, (gdouble) 0);
			}
		}
		if (!current_user) {
			GtkComboBox* _tmp31_;
			GtkComboBox* _tmp32_;
			_tmp31_ = self->priv->language_box;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp31_, TRUE);
			_tmp32_ = self->priv->region_box;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp32_, TRUE);
		}
	} else {
		GtkEntry* _tmp33_;
		_tmp33_ = self->priv->full_name_entry;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp33_, FALSE);
		if (!current_user) {
			GtkComboBox* _tmp34_;
			GtkComboBox* _tmp35_;
			_tmp34_ = self->priv->language_box;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp34_, FALSE);
			_tmp35_ = self->priv->region_box;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp35_, FALSE);
		}
	}
}

static GdkPixbuf*
_switchboard_plug_user_accounts_widgets_user_settings_view_avatar_image_load_func_hdy_avatar_image_load_func (gint size,
                                                                                                              gpointer self)
{
	GdkPixbuf* result;
	result = switchboard_plug_user_accounts_widgets_user_settings_view_avatar_image_load_func ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self, size);
	return result;
}

static gboolean
_act_user_account_type_equal (const ActUserAccountType * s1,
                              const ActUserAccountType * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_update_ui (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	SwitchboardPlugUserAccountsDeltaUser* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ActUser* _tmp3_;
	const gchar* _tmp4_;
	HdyAvatar* _tmp5_;
	SwitchboardPlugUserAccountsDeltaUser* _tmp6_;
	ActUserAccountType* _tmp7_;
	ActUserAccountType* _tmp8_;
	ActUser* _tmp9_;
	ActUserAccountType _tmp10_;
	gboolean user_automatic_login = FALSE;
	ActUser* _tmp11_;
	SwitchboardPlugUserAccountsDeltaUser* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean user_locked = FALSE;
	ActUser* _tmp25_;
	SwitchboardPlugUserAccountsDeltaUser* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	ActUser* _tmp39_;
	const gchar* _tmp40_;
	SwitchboardPlugUserAccountsDeltaUser* _tmp41_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->delta_user;
	_tmp1_ = switchboard_plug_user_accounts_delta_user_get_real_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_user;
	_tmp4_ = act_user_get_real_name (_tmp3_);
	if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
		switchboard_plug_user_accounts_widgets_user_settings_view_update_real_name (self);
	}
	_tmp5_ = self->priv->avatar;
	hdy_avatar_set_image_load_func (_tmp5_, _switchboard_plug_user_accounts_widgets_user_settings_view_avatar_image_load_func_hdy_avatar_image_load_func, g_object_ref (self), g_object_unref);
	_tmp6_ = self->priv->delta_user;
	_tmp7_ = switchboard_plug_user_accounts_delta_user_get_account_type (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_user;
	_tmp10_ = act_user_get_account_type (_tmp9_);
	if (_act_user_account_type_equal (_tmp8_, &_tmp10_) != TRUE) {
		switchboard_plug_user_accounts_widgets_user_settings_view_update_account_type (self);
	}
	_tmp11_ = self->priv->_user;
	user_automatic_login = act_user_get_automatic_login (_tmp11_);
	_tmp12_ = self->priv->delta_user;
	_tmp13_ = switchboard_plug_user_accounts_delta_user_get_automatic_login (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != user_automatic_login) {
		gboolean _tmp15_ = FALSE;
		if (user_automatic_login) {
			GtkSwitch* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = self->priv->autologin_switch;
			_tmp17_ = gtk_switch_get_active (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp15_ = !_tmp18_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			GtkSwitch* _tmp19_;
			_tmp19_ = self->priv->autologin_switch;
			gtk_switch_set_active (_tmp19_, TRUE);
		} else {
			gboolean _tmp20_ = FALSE;
			if (!user_automatic_login) {
				GtkSwitch* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp21_ = self->priv->autologin_switch;
				_tmp22_ = gtk_switch_get_active (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp20_ = _tmp23_;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				GtkSwitch* _tmp24_;
				_tmp24_ = self->priv->autologin_switch;
				gtk_switch_set_active (_tmp24_, FALSE);
			}
		}
	}
	_tmp25_ = self->priv->_user;
	user_locked = act_user_get_locked (_tmp25_);
	if (user_locked) {
		GtkButton* _tmp26_;
		GtkButton* _tmp27_;
		GtkStyleContext* _tmp28_;
		GtkButton* _tmp29_;
		GtkStyleContext* _tmp30_;
		_tmp26_ = self->priv->enable_user_button;
		gtk_button_set_label (_tmp26_, _ ("Enable User Account"));
		_tmp27_ = self->priv->enable_user_button;
		_tmp28_ = gtk_widget_get_style_context ((GtkWidget*) _tmp27_);
		gtk_style_context_add_class (_tmp28_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
		_tmp29_ = self->priv->enable_user_button;
		_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) _tmp29_);
		gtk_style_context_remove_class (_tmp30_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	} else {
		GtkButton* _tmp31_;
		GtkButton* _tmp32_;
		GtkStyleContext* _tmp33_;
		GtkButton* _tmp34_;
		GtkStyleContext* _tmp35_;
		_tmp31_ = self->priv->enable_user_button;
		gtk_button_set_label (_tmp31_, _ ("Disable User Account"));
		_tmp32_ = self->priv->enable_user_button;
		_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) _tmp32_);
		gtk_style_context_add_class (_tmp33_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
		_tmp34_ = self->priv->enable_user_button;
		_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
		gtk_style_context_remove_class (_tmp35_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	}
	_tmp36_ = self->priv->delta_user;
	_tmp37_ = switchboard_plug_user_accounts_delta_user_get_language (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = self->priv->_user;
	_tmp40_ = act_user_get_language (_tmp39_);
	if (g_strcmp0 (_tmp38_, _tmp40_) != 0) {
		switchboard_plug_user_accounts_widgets_user_settings_view_update_language (self);
	}
	_tmp41_ = self->priv->delta_user;
	switchboard_plug_user_accounts_delta_user_update (_tmp41_);
	gtk_widget_show_all ((GtkWidget*) self);
}

void
switchboard_plug_user_accounts_widgets_user_settings_view_update_real_name (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	GtkEntry* _tmp0_;
	ActUser* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->full_name_entry;
	_tmp1_ = self->priv->_user;
	_tmp2_ = act_user_get_real_name (_tmp1_);
	gtk_entry_set_text (_tmp0_, _tmp2_);
}

void
switchboard_plug_user_accounts_widgets_user_settings_view_update_account_type (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	ActUser* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_user;
	if (act_user_get_account_type (_tmp0_) == ACT_USER_ACCOUNT_TYPE_ADMINISTRATOR) {
		GtkComboBoxText* _tmp1_;
		_tmp1_ = self->priv->user_type_box;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp1_, 1);
	} else {
		GtkComboBoxText* _tmp2_;
		_tmp2_ = self->priv->user_type_box;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp2_, 0);
	}
}

static GdkPixbuf*
switchboard_plug_user_accounts_widgets_user_settings_view_avatar_image_load_func (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                                                                                  gint size)
{
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GdkPixbuf* _tmp0_ = NULL;
		ActUser* _tmp1_;
		const gchar* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp1_ = self->priv->_user;
		_tmp2_ = act_user_get_icon_file (_tmp1_);
		_tmp3_ = gdk_pixbuf_new_from_file_at_scale (_tmp2_, size, size, TRUE, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp4_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
switchboard_plug_user_accounts_widgets_user_settings_view_update_language (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	gchar* user_lang = NULL;
	ActUser* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gchar* user_lang_code = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gboolean _tmp14_;
	ActUser* _tmp16_;
	ActUser* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_user;
	_tmp1_ = act_user_get_language (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	user_lang = _tmp2_;
	_tmp4_ = user_lang;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = user_lang;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ == 0;
	}
	if (_tmp3_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp11_;
		_tmp9_ = switchboard_plug_user_accounts_get_system_locale ();
		_tmp8_ = _tmp9_;
		if (_tmp8_ == NULL) {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("en_US.UTF-8");
			_g_free0 (_tmp8_);
			_tmp8_ = _tmp10_;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (user_lang);
		user_lang = _tmp11_;
		_g_free0 (_tmp8_);
	}
	_tmp12_ = user_lang;
	_tmp14_ = gnome_parse_locale (_tmp12_, &_tmp13_, NULL, NULL, NULL);
	_g_free0 (user_lang_code);
	user_lang_code = _tmp13_;
	if (!_tmp14_) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup ("en");
		_g_free0 (user_lang_code);
		user_lang_code = _tmp15_;
	}
	_tmp16_ = self->priv->_user;
	_tmp17_ = switchboard_plug_user_accounts_get_current_user ();
	if (_tmp16_ != _tmp17_) {
		GeeArrayList* languages = NULL;
		GeeArrayList* _tmp18_;
		GtkListStore* _tmp19_;
		GtkTreeIter iter = {0};
		GtkComboBox* _tmp20_;
		GtkListStore* _tmp21_;
		_tmp18_ = switchboard_plug_user_accounts_get_languages ();
		languages = _tmp18_;
		_tmp19_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
		_g_object_unref0 (self->priv->language_store);
		self->priv->language_store = _tmp19_;
		_tmp20_ = self->priv->language_box;
		_tmp21_ = self->priv->language_store;
		gtk_combo_box_set_model (_tmp20_, (GtkTreeModel*) _tmp21_);
		{
			GeeArrayList* _language_list = NULL;
			GeeArrayList* _tmp22_;
			gint _language_size = 0;
			GeeArrayList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _language_index = 0;
			_tmp22_ = languages;
			_language_list = _tmp22_;
			_tmp23_ = _language_list;
			_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_language_size = _tmp25_;
			_language_index = -1;
			while (TRUE) {
				gint _tmp26_;
				gint _tmp27_;
				gchar* language = NULL;
				GeeArrayList* _tmp28_;
				gpointer _tmp29_;
				GtkListStore* _tmp30_;
				GtkTreeIter _tmp31_ = {0};
				GtkListStore* _tmp32_;
				GtkTreeIter _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				_language_index = _language_index + 1;
				_tmp26_ = _language_index;
				_tmp27_ = _language_size;
				if (!(_tmp26_ < _tmp27_)) {
					break;
				}
				_tmp28_ = _language_list;
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _language_index);
				language = (gchar*) _tmp29_;
				_tmp30_ = self->priv->language_store;
				gtk_list_store_insert (_tmp30_, &_tmp31_, 0);
				iter = _tmp31_;
				_tmp32_ = self->priv->language_store;
				_tmp33_ = iter;
				_tmp34_ = language;
				_tmp35_ = language;
				_tmp36_ = gnome_get_language_from_code (_tmp35_, NULL);
				_tmp37_ = _tmp36_;
				gtk_list_store_set (_tmp32_, &_tmp33_, 0, _tmp34_, 1, _tmp37_, -1);
				_g_free0 (_tmp37_);
				_tmp38_ = user_lang_code;
				_tmp39_ = language;
				if (g_strcmp0 (_tmp38_, _tmp39_) == 0) {
					GtkComboBox* _tmp40_;
					GtkTreeIter _tmp41_;
					_tmp40_ = self->priv->language_box;
					_tmp41_ = iter;
					gtk_combo_box_set_active_iter (_tmp40_, &_tmp41_);
				}
				_g_free0 (language);
			}
		}
		_g_object_unref0 (languages);
	} else {
		gchar* language = NULL;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		GtkButton* _tmp44_;
		const gchar* _tmp45_;
		_tmp42_ = user_lang_code;
		_tmp43_ = gnome_get_language_from_code (_tmp42_, NULL);
		language = _tmp43_;
		_tmp44_ = self->priv->language_button;
		_tmp45_ = language;
		gtk_button_set_label (_tmp44_, _tmp45_);
		_g_free0 (language);
	}
	_g_free0 (user_lang_code);
	_g_free0 (user_lang);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
		self = _data4_->self;
		_g_free0 (_data4_->language);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
		self = _data5_->_data4_->self;
		__vala_GtkTreeIter_free0 (_data5_->active_iter);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
___lambda8_ (Block5Data* _data5_,
             GtkTreeModel* model,
             GtkTreePath* path,
             GtkTreeIter* iter)
{
	Block4Data* _data4_;
	SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
	GValue cell = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GeeHashMap* _tmp5_;
	gboolean result;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->region_store;
	_tmp1_ = *iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, 0, &_tmp2_);
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	cell = _tmp2_;
	_tmp5_ = self->priv->default_regions;
	if (_tmp5_ != NULL) {
		GeeHashMap* _tmp6_;
		_tmp6_ = self->priv->default_regions;
		_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, _data4_->language);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GeeHashMap* _tmp7_;
		gpointer _tmp8_;
		gchar* _tmp9_;
		GValue _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp7_ = self->priv->default_regions;
		_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _data4_->language);
		_tmp9_ = (gchar*) _tmp8_;
		_tmp10_ = cell;
		_tmp11_ = g_strdup_printf ("%s_%s", _data4_->language, g_value_get_string (&_tmp10_));
		_tmp12_ = _tmp11_;
		_tmp3_ = g_strcmp0 (_tmp9_, _tmp12_) == 0;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkTreeIter _tmp13_;
		GtkTreeIter* _tmp14_;
		_tmp13_ = *iter;
		_tmp14_ = __vala_GtkTreeIter_copy0 (&_tmp13_);
		__vala_GtkTreeIter_free0 (_data5_->active_iter);
		_data5_->active_iter = _tmp14_;
	}
	result = FALSE;
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	return result;
}

static gboolean
____lambda8__gtk_tree_model_foreach_func (GtkTreeModel* model,
                                          GtkTreePath* path,
                                          GtkTreeIter* iter,
                                          gpointer self)
{
	gboolean result;
	result = ___lambda8_ (self, model, path, iter);
	return result;
}

void
switchboard_plug_user_accounts_widgets_user_settings_view_update_region (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                                                                         const gchar* language)
{
	Block4Data* _data4_;
	gchar* _tmp0_;
	GtkTreeIter* iter = NULL;
	GeeArrayList* regions = NULL;
	GeeArrayList* _tmp11_;
	GtkListStore* _tmp12_;
	gboolean iter_set = FALSE;
	GtkComboBox* _tmp13_;
	GtkListStore* _tmp14_;
	gchar* user_lang = NULL;
	ActUser* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gchar* user_region_code = NULL;
	const gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gboolean _tmp29_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = g_strdup (language);
	_g_free0 (_data4_->language);
	_data4_->language = _tmp0_;
	if (_data4_->language == NULL) {
		GValue cell = {0};
		GtkComboBox* _tmp1_;
		GtkTreeIter _tmp2_ = {0};
		GtkTreeIter _tmp3_;
		GtkTreeIter* _tmp4_;
		GtkListStore* _tmp5_;
		GtkTreeIter* _tmp6_;
		GtkTreeIter _tmp7_;
		GValue _tmp8_ = {0};
		GValue _tmp9_;
		gchar* _tmp10_;
		_tmp1_ = self->priv->language_box;
		gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
		__vala_GtkTreeIter_free0 (iter);
		_tmp3_ = _tmp2_;
		_tmp4_ = __vala_GtkTreeIter_copy0 (&_tmp3_);
		iter = _tmp4_;
		_tmp5_ = self->priv->language_store;
		_tmp6_ = iter;
		_tmp7_ = *_tmp6_;
		gtk_tree_model_get_value ((GtkTreeModel*) _tmp5_, &_tmp7_, 0, &_tmp8_);
		G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
		cell = _tmp8_;
		_tmp9_ = cell;
		_tmp10_ = g_strdup (g_value_get_string (&_tmp9_));
		_g_free0 (_data4_->language);
		_data4_->language = _tmp10_;
		G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	}
	_tmp11_ = switchboard_plug_user_accounts_get_regions (_data4_->language);
	regions = _tmp11_;
	_tmp12_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->region_store);
	self->priv->region_store = _tmp12_;
	iter_set = FALSE;
	_tmp13_ = self->priv->region_box;
	_tmp14_ = self->priv->region_store;
	gtk_combo_box_set_model (_tmp13_, (GtkTreeModel*) _tmp14_);
	_tmp15_ = self->priv->_user;
	_tmp16_ = act_user_get_language (_tmp15_);
	_tmp17_ = g_strdup (_tmp16_);
	user_lang = _tmp17_;
	_tmp19_ = user_lang;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp20_ = user_lang;
		_tmp21_ = strlen (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp18_ = _tmp22_ == 0;
	}
	if (_tmp18_) {
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* _tmp26_;
		_tmp24_ = switchboard_plug_user_accounts_get_system_locale ();
		_tmp23_ = _tmp24_;
		if (_tmp23_ == NULL) {
			gchar* _tmp25_;
			_tmp25_ = g_strdup ("en_US.UTF-8");
			_g_free0 (_tmp23_);
			_tmp23_ = _tmp25_;
		}
		_tmp26_ = _tmp23_;
		_tmp23_ = NULL;
		_g_free0 (user_lang);
		user_lang = _tmp26_;
		_g_free0 (_tmp23_);
	}
	_tmp27_ = user_lang;
	_tmp29_ = gnome_parse_locale (_tmp27_, NULL, &_tmp28_, NULL, NULL);
	_g_free0 (user_region_code);
	user_region_code = _tmp28_;
	if (!_tmp29_) {
		gchar* _tmp30_;
		_tmp30_ = g_strdup ("US");
		_g_free0 (user_region_code);
		user_region_code = _tmp30_;
	}
	{
		GeeArrayList* _region_list = NULL;
		GeeArrayList* _tmp31_;
		gint _region_size = 0;
		GeeArrayList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _region_index = 0;
		_tmp31_ = regions;
		_region_list = _tmp31_;
		_tmp32_ = _region_list;
		_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_region_size = _tmp34_;
		_region_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			gchar* region = NULL;
			GeeArrayList* _tmp37_;
			gpointer _tmp38_;
			GtkListStore* _tmp39_;
			GtkTreeIter _tmp40_ = {0};
			GtkTreeIter _tmp41_;
			GtkTreeIter* _tmp42_;
			GtkListStore* _tmp43_;
			GtkTreeIter* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			GtkTreeIter _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			_region_index = _region_index + 1;
			_tmp35_ = _region_index;
			_tmp36_ = _region_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _region_list;
			_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _region_index);
			region = (gchar*) _tmp38_;
			_tmp39_ = self->priv->region_store;
			gtk_list_store_insert (_tmp39_, &_tmp40_, 0);
			__vala_GtkTreeIter_free0 (iter);
			_tmp41_ = _tmp40_;
			_tmp42_ = __vala_GtkTreeIter_copy0 (&_tmp41_);
			iter = _tmp42_;
			_tmp43_ = self->priv->region_store;
			_tmp44_ = iter;
			_tmp45_ = region;
			_tmp46_ = region;
			_tmp47_ = gnome_get_country_from_code (_tmp46_, NULL);
			_tmp48_ = _tmp47_;
			_tmp49_ = *_tmp44_;
			gtk_list_store_set (_tmp43_, &_tmp49_, 0, _tmp45_, 1, _tmp48_, -1);
			_g_free0 (_tmp48_);
			_tmp50_ = user_region_code;
			_tmp51_ = region;
			if (g_strcmp0 (_tmp50_, _tmp51_) == 0) {
				GtkComboBox* _tmp52_;
				GtkTreeIter* _tmp53_;
				_tmp52_ = self->priv->region_box;
				_tmp53_ = iter;
				gtk_combo_box_set_active_iter (_tmp52_, _tmp53_);
				iter_set = TRUE;
			}
			_g_free0 (region);
		}
	}
	if (!iter_set) {
		Block5Data* _data5_;
		GtkTreeModelForeachFunc check_region_store = NULL;
		gpointer check_region_store_target;
		GDestroyNotify check_region_store_target_destroy_notify;
		GtkListStore* _tmp54_;
		GtkTreeModelForeachFunc _tmp55_;
		gpointer _tmp55__target;
		GtkTreeIter* _tmp56_;
		GtkComboBox* _tmp61_;
		GtkTreeIter* _tmp62_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		_data5_->active_iter = NULL;
		check_region_store = ____lambda8__gtk_tree_model_foreach_func;
		check_region_store_target = block5_data_ref (_data5_);
		check_region_store_target_destroy_notify = block5_data_unref;
		_tmp54_ = self->priv->region_store;
		_tmp55_ = check_region_store;
		_tmp55__target = check_region_store_target;
		gtk_tree_model_foreach ((GtkTreeModel*) _tmp54_, _tmp55_, _tmp55__target);
		_tmp56_ = _data5_->active_iter;
		if (_tmp56_ == NULL) {
			GtkListStore* _tmp57_;
			GtkTreeIter _tmp58_ = {0};
			GtkTreeIter _tmp59_;
			GtkTreeIter* _tmp60_;
			_tmp57_ = self->priv->region_store;
			gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp57_, &_tmp58_);
			__vala_GtkTreeIter_free0 (_data5_->active_iter);
			_tmp59_ = _tmp58_;
			_tmp60_ = __vala_GtkTreeIter_copy0 (&_tmp59_);
			_data5_->active_iter = _tmp60_;
		}
		_tmp61_ = self->priv->region_box;
		_tmp62_ = _data5_->active_iter;
		gtk_combo_box_set_active_iter (_tmp61_, _tmp62_);
		(check_region_store_target_destroy_notify == NULL) ? NULL : (check_region_store_target_destroy_notify (check_region_store_target), NULL);
		check_region_store = NULL;
		check_region_store_target = NULL;
		check_region_store_target_destroy_notify = NULL;
		block5_data_unref (_data5_);
		_data5_ = NULL;
	}
	_g_free0 (user_region_code);
	_g_free0 (user_lang);
	_g_object_unref0 (regions);
	__vala_GtkTreeIter_free0 (iter);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_change_lock (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	PolkitPermission* permission = NULL;
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean user_locked = FALSE;
	ActUser* _tmp7_;
	ActUser* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_user_accounts_get_permission ();
	permission = _tmp0_;
	_tmp1_ = permission;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		{
			PolkitPermission* _tmp4_;
			_tmp4_ = permission;
			g_permission_acquire ((GPermission*) _tmp4_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_critical ("UserSettingsView.vala:498: %s", _tmp6_);
			_g_error_free0 (e);
			_g_object_unref0 (permission);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (permission);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp7_ = self->priv->_user;
	user_locked = act_user_get_locked (_tmp7_);
	if (user_locked) {
		ActUser* _tmp8_;
		_tmp8_ = self->priv->_user;
		act_user_set_password_mode (_tmp8_, ACT_USER_PASSWORD_MODE_REGULAR);
	} else {
		ActUser* _tmp9_;
		_tmp9_ = self->priv->_user;
		act_user_set_automatic_login (_tmp9_, FALSE);
	}
	_tmp10_ = self->priv->_user;
	act_user_set_locked (_tmp10_, !user_locked);
	_g_object_unref0 (permission);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gtk_widget_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
_____lambda9_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                PasswdHandler* h,
               GError* e)
{
	g_return_if_fail (h != NULL);
	if (e != NULL) {
		GraniteMessageDialog* dialog = NULL;
		ActUser* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		GThemedIcon* _tmp5_;
		GThemedIcon* _tmp6_;
		GThemedIcon* _tmp7_;
		GtkWidget* _tmp8_;
		GtkWindow* _tmp9_;
		GraniteMessageDialog* _tmp10_ = NULL;
		GraniteMessageDialog* _tmp11_;
		GraniteMessageDialog* _tmp12_;
		GraniteMessageDialog* _tmp13_;
		GraniteMessageDialog* _tmp14_;
		_tmp0_ = self->priv->_user;
		_tmp1_ = act_user_get_real_name (_tmp0_);
		_tmp2_ = g_strdup_printf (_ ("Unable to change the password for %s"), _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = e->message;
		_tmp5_ = (GThemedIcon*) g_themed_icon_new ("dialog-password");
		_tmp6_ = _tmp5_;
		_tmp7_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp8_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_window_get_type (), GtkWindow));
		_tmp10_ = granite_message_dialog_new (_tmp3_, _tmp4_, (GIcon*) _tmp6_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp10_, (GIcon*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		gtk_window_set_transient_for ((GtkWindow*) _tmp10_, _tmp9_);
		_g_object_unref0 (_tmp9_);
		g_object_ref_sink (_tmp10_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp6_);
		_g_free0 (_tmp3_);
		dialog = _tmp11_;
		_tmp12_ = dialog;
		gtk_widget_show_all ((GtkWidget*) _tmp12_);
		_tmp13_ = dialog;
		_tmp14_ = dialog;
		g_signal_connect_object ((GtkDialog*) _tmp13_, "response", (GCallback) _gtk_widget_destroy_gtk_dialog_response, (GtkWidget*) _tmp14_, 0);
		_g_object_unref0 (dialog);
	} else {
		ActUser* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = self->priv->_user;
		_tmp16_ = act_user_get_user_name (_tmp15_);
		_tmp17_ = g_strdup_printf ("Setting new password for %s (user context)", _tmp16_);
		_tmp18_ = _tmp17_;
		g_debug ("UserSettingsView.vala:549: %s", _tmp18_);
		_g_free0 (_tmp18_);
	}
}

static void
______lambda9__passwd_passwd_callback ( PasswdHandler* handler,
                                       GError* e,
                                       gpointer self)
{
	_____lambda9_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self, handler, e);
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_change_password (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                                                                           ActUserPasswordMode mode,
                                                                           const gchar* new_password)
{
	PolkitPermission* _tmp0_;
	PolkitPermission* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = switchboard_plug_user_accounts_get_permission ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_permission_get_allowed ((GPermission*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		switch (mode) {
			case ACT_USER_PASSWORD_MODE_REGULAR:
			{
				if (new_password != NULL) {
					ActUser* _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					ActUser* _tmp9_;
					_tmp5_ = self->priv->_user;
					_tmp6_ = act_user_get_user_name (_tmp5_);
					_tmp7_ = g_strdup_printf ("Setting new password for %s", _tmp6_);
					_tmp8_ = _tmp7_;
					g_debug ("UserSettingsView.vala:518: %s", _tmp8_);
					_g_free0 (_tmp8_);
					_tmp9_ = self->priv->_user;
					act_user_set_password (_tmp9_, new_password, "");
				}
				break;
			}
			case ACT_USER_PASSWORD_MODE_NONE:
			{
				ActUser* _tmp10_;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				ActUser* _tmp14_;
				_tmp10_ = self->priv->_user;
				_tmp11_ = act_user_get_user_name (_tmp10_);
				_tmp12_ = g_strdup_printf ("Setting no password for %s", _tmp11_);
				_tmp13_ = _tmp12_;
				g_debug ("UserSettingsView.vala:523: %s", _tmp13_);
				_g_free0 (_tmp13_);
				_tmp14_ = self->priv->_user;
				act_user_set_password_mode (_tmp14_, ACT_USER_PASSWORD_MODE_NONE);
				break;
			}
			case ACT_USER_PASSWORD_MODE_SET_AT_LOGIN:
			{
				ActUser* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				ActUser* _tmp19_;
				_tmp15_ = self->priv->_user;
				_tmp16_ = act_user_get_user_name (_tmp15_);
				_tmp17_ = g_strdup_printf ("Setting password mode to SET_AT_LOGIN for %s", _tmp16_);
				_tmp18_ = _tmp17_;
				g_debug ("UserSettingsView.vala:527: %s", _tmp18_);
				_g_free0 (_tmp18_);
				_tmp19_ = self->priv->_user;
				act_user_set_password_mode (_tmp19_, ACT_USER_PASSWORD_MODE_SET_AT_LOGIN);
				break;
			}
			default:
			{
				break;
			}
		}
	} else {
		ActUser* _tmp20_;
		ActUser* _tmp21_;
		_tmp20_ = self->priv->_user;
		_tmp21_ = switchboard_plug_user_accounts_get_current_user ();
		if (_tmp20_ == _tmp21_) {
			if (new_password != NULL) {
				 PasswdHandler* _tmp22_;
				_tmp22_ = switchboard_plug_user_accounts_get_passwd_handler (FALSE);
				passwd_change_password (_tmp22_, new_password, ______lambda9__passwd_passwd_callback, self);
			}
		}
	}
}

ActUser*
switchboard_plug_user_accounts_widgets_user_settings_view_get_user (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	ActUser* result;
	ActUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_set_user (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self,
                                                                    ActUser* value)
{
	ActUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_user_accounts_widgets_user_settings_view_get_user (self);
	if (old_value != value) {
		self->priv->_user = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_user_accounts_widgets_user_settings_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY]);
	}
}

static void
___lambda14_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	GtkToggleButton* _tmp0_;
	_tmp0_ = self->priv->avatar_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
}

static void
____lambda14__gtk_widget_hide (GtkWidget* _sender,
                               gpointer self)
{
	___lambda14_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view___lambda10_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->avatar_button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		SwitchboardPlugUserAccountsWidgetsAvatarPopover* avatar_popover = NULL;
		GtkToggleButton* _tmp3_;
		ActUser* _tmp4_;
		SwitchboardPlugUserAccountsUserUtils* _tmp5_;
		SwitchboardPlugUserAccountsWidgetsAvatarPopover* _tmp6_;
		SwitchboardPlugUserAccountsWidgetsAvatarPopover* _tmp7_;
		SwitchboardPlugUserAccountsWidgetsAvatarPopover* _tmp8_;
		_tmp3_ = self->priv->avatar_button;
		_tmp4_ = self->priv->_user;
		_tmp5_ = self->priv->utils;
		_tmp6_ = switchboard_plug_user_accounts_widgets_avatar_popover_new ((GtkWidget*) _tmp3_, _tmp4_, _tmp5_);
		g_object_ref_sink (_tmp6_);
		avatar_popover = _tmp6_;
		_tmp7_ = avatar_popover;
		gtk_widget_show_all ((GtkWidget*) _tmp7_);
		_tmp8_ = avatar_popover;
		g_signal_connect_object ((GtkWidget*) _tmp8_, "hide", (GCallback) ____lambda14__gtk_widget_hide, self, 0);
		_g_object_unref0 (avatar_popover);
	}
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view___lambda10__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                                   gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view___lambda10_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view___lambda15_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	SwitchboardPlugUserAccountsUserUtils* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->priv->utils;
	_tmp1_ = self->priv->full_name_entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	switchboard_plug_user_accounts_user_utils_change_full_name (_tmp0_, _tmp2_);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view___lambda15__gtk_entry_activate (GtkEntry* _sender,
                                                                                            gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view___lambda15_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view___lambda16_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	SwitchboardPlugUserAccountsUserUtils* _tmp0_;
	GtkComboBoxText* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = self->priv->utils;
	_tmp1_ = self->priv->user_type_box;
	_tmp2_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp1_);
	_tmp3_ = _tmp2_;
	switchboard_plug_user_accounts_user_utils_change_user_type (_tmp0_, _tmp3_);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view___lambda16__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                               gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view___lambda16_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->region_revealer);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view____lambda17_ (Block6Data* _data6_)
{
	SwitchboardPlugUserAccountsWidgetsUserSettingsView* self;
	GtkTreeIter* iter = NULL;
	GValue cell = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkTreeIter _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkListStore* _tmp4_;
	GtkTreeIter* _tmp5_;
	GtkTreeIter _tmp6_;
	GValue _tmp7_ = {0};
	GValue _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_;
	self = _data6_->self;
	_tmp0_ = self->priv->language_box;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	__vala_GtkTreeIter_free0 (iter);
	_tmp2_ = _tmp1_;
	_tmp3_ = __vala_GtkTreeIter_copy0 (&_tmp2_);
	iter = _tmp3_;
	_tmp4_ = self->priv->language_store;
	_tmp5_ = iter;
	_tmp6_ = *_tmp5_;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp4_, &_tmp6_, 0, &_tmp7_);
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	cell = _tmp7_;
	_tmp8_ = cell;
	_tmp9_ = switchboard_plug_user_accounts_get_regions (g_value_get_string (&_tmp8_));
	_tmp10_ = _tmp9_;
	_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_ == 0;
	_g_object_unref0 (_tmp10_);
	if (_tmp13_) {
		GtkRevealer* _tmp14_;
		ActUser* _tmp15_;
		const gchar* _tmp16_;
		GValue _tmp17_;
		_tmp14_ = _data6_->region_revealer;
		gtk_revealer_set_reveal_child (_tmp14_, FALSE);
		_tmp15_ = self->priv->_user;
		_tmp16_ = act_user_get_language (_tmp15_);
		_tmp17_ = cell;
		if (g_strcmp0 (_tmp16_, g_value_get_string (&_tmp17_)) != 0) {
			SwitchboardPlugUserAccountsUserUtils* _tmp18_;
			GValue _tmp19_;
			_tmp18_ = self->priv->utils;
			_tmp19_ = cell;
			switchboard_plug_user_accounts_user_utils_change_language (_tmp18_, g_value_get_string (&_tmp19_));
		}
	} else {
		GtkRevealer* _tmp20_;
		GValue _tmp21_;
		_tmp20_ = _data6_->region_revealer;
		gtk_revealer_set_reveal_child (_tmp20_, TRUE);
		_tmp21_ = cell;
		switchboard_plug_user_accounts_widgets_user_settings_view_update_region (self, g_value_get_string (&_tmp21_));
	}
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	__vala_GtkTreeIter_free0 (iter);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view____lambda17__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                                gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view____lambda17_ (self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view____lambda18_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	gchar* new_language = NULL;
	GtkTreeIter* iter = NULL;
	GValue cell = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkTreeIter _tmp2_;
	GtkTreeIter* _tmp3_;
	GtkListStore* _tmp4_;
	GtkTreeIter* _tmp5_;
	GtkTreeIter _tmp6_;
	GValue _tmp7_ = {0};
	GValue _tmp8_;
	gchar* _tmp9_;
	GtkComboBox* _tmp10_;
	GtkTreeIter _tmp11_ = {0};
	GtkTreeIter _tmp12_;
	GtkTreeIter* _tmp13_;
	GtkListStore* _tmp14_;
	GtkTreeIter* _tmp15_;
	GtkTreeIter _tmp16_;
	GValue _tmp17_ = {0};
	const gchar* _tmp18_;
	GValue _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp24_;
	_tmp0_ = self->priv->language_box;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	__vala_GtkTreeIter_free0 (iter);
	_tmp2_ = _tmp1_;
	_tmp3_ = __vala_GtkTreeIter_copy0 (&_tmp2_);
	iter = _tmp3_;
	_tmp4_ = self->priv->language_store;
	_tmp5_ = iter;
	_tmp6_ = *_tmp5_;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp4_, &_tmp6_, 0, &_tmp7_);
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	cell = _tmp7_;
	_tmp8_ = cell;
	_tmp9_ = g_strdup (g_value_get_string (&_tmp8_));
	_g_free0 (new_language);
	new_language = _tmp9_;
	_tmp10_ = self->priv->region_box;
	gtk_combo_box_get_active_iter (_tmp10_, &_tmp11_);
	__vala_GtkTreeIter_free0 (iter);
	_tmp12_ = _tmp11_;
	_tmp13_ = __vala_GtkTreeIter_copy0 (&_tmp12_);
	iter = _tmp13_;
	_tmp14_ = self->priv->region_store;
	_tmp15_ = iter;
	_tmp16_ = *_tmp15_;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp14_, &_tmp16_, 0, &_tmp17_);
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	cell = _tmp17_;
	_tmp18_ = new_language;
	_tmp19_ = cell;
	_tmp20_ = g_strdup_printf ("_%s", g_value_get_string (&_tmp19_));
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
	_g_free0 (new_language);
	new_language = _tmp22_;
	_g_free0 (_tmp21_);
	_tmp24_ = new_language;
	if (g_strcmp0 (_tmp24_, "") != 0) {
		const gchar* _tmp25_;
		ActUser* _tmp26_;
		const gchar* _tmp27_;
		_tmp25_ = new_language;
		_tmp26_ = self->priv->_user;
		_tmp27_ = act_user_get_language (_tmp26_);
		_tmp23_ = g_strcmp0 (_tmp25_, _tmp27_) != 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		SwitchboardPlugUserAccountsUserUtils* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = self->priv->utils;
		_tmp29_ = new_language;
		switchboard_plug_user_accounts_user_utils_change_language (_tmp28_, _tmp29_);
	}
	G_IS_VALUE (&cell) ? (g_value_unset (&cell), NULL) : NULL;
	__vala_GtkTreeIter_free0 (iter);
	_g_free0 (new_language);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view____lambda18__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                                gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view____lambda18_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view___lambda19_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	SwitchboardPlugUserAccountsUserUtils* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->utils;
	_tmp1_ = self->priv->autologin_switch;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	switchboard_plug_user_accounts_user_utils_change_autologin (_tmp0_, _tmp3_);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view___lambda19__g_object_notify (GObject* _sender,
                                                                                         GParamSpec* pspec,
                                                                                         gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view___lambda19_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view_change_password_switchboard_plug_user_accounts_change_password_dialog_request_password_change (SwitchboardPlugUserAccountsChangePasswordDialog* _sender,
                                                                                                                                                          ActUserPasswordMode mode,
                                                                                                                                                          const gchar* new_password,
                                                                                                                                                          gpointer self)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_change_password ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self, mode, new_password);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view___lambda20_ (SwitchboardPlugUserAccountsWidgetsUserSettingsView* self)
{
	PolkitPermission* permission = NULL;
	PolkitPermission* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ActUser* _tmp2_;
	ActUser* _tmp3_;
	SwitchboardPlugUserAccountsChangePasswordDialog* change_password_dialog = NULL;
	GtkWidget* _tmp10_;
	ActUser* _tmp11_;
	SwitchboardPlugUserAccountsChangePasswordDialog* _tmp12_;
	SwitchboardPlugUserAccountsChangePasswordDialog* _tmp13_;
	SwitchboardPlugUserAccountsChangePasswordDialog* _tmp14_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = switchboard_plug_user_accounts_get_permission ();
	permission = _tmp0_;
	_tmp2_ = self->priv->_user;
	_tmp3_ = switchboard_plug_user_accounts_get_current_user ();
	if (_tmp2_ == _tmp3_) {
		PolkitPermission* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = permission;
		_tmp5_ = g_permission_get_allowed ((GPermission*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			PolkitPermission* _tmp7_;
			_tmp7_ = permission;
			g_permission_release ((GPermission*) _tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_critical ("UserSettingsView.vala:199: Error releasing privileges: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (permission);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp11_ = self->priv->_user;
	_tmp12_ = switchboard_plug_user_accounts_change_password_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow), _tmp11_);
	g_object_ref_sink (_tmp12_);
	change_password_dialog = _tmp12_;
	_tmp13_ = change_password_dialog;
	gtk_window_present ((GtkWindow*) _tmp13_);
	_tmp14_ = change_password_dialog;
	g_signal_connect_object (_tmp14_, "request-password-change", (GCallback) _switchboard_plug_user_accounts_widgets_user_settings_view_change_password_switchboard_plug_user_accounts_change_password_dialog_request_password_change, self, 0);
	_g_object_unref0 (change_password_dialog);
	_g_object_unref0 (permission);
}

static void
__switchboard_plug_user_accounts_widgets_user_settings_view___lambda20__gtk_button_clicked (GtkButton* _sender,
                                                                                            gpointer self)
{
	_switchboard_plug_user_accounts_widgets_user_settings_view___lambda20_ ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view_change_lock_gtk_button_clicked (GtkButton* _sender,
                                                                                           gpointer self)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_change_lock ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_g_object_notify (GObject* _sender,
                                                                                              GParamSpec* pspec,
                                                                                              gpointer self)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_update_permission ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view_update_ui_act_user_changed (ActUser* _sender,
                                                                                       gpointer self)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_update_ui ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static void
_switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_act_user_changed (ActUser* _sender,
                                                                                               gpointer self)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_update_permission ((SwitchboardPlugUserAccountsWidgetsUserSettingsView*) self);
}

static GObject *
switchboard_plug_user_accounts_widgets_user_settings_view_constructor (GType type,
                                                                       guint n_construct_properties,
                                                                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugUserAccountsWidgetsUserSettingsView * self;
	ActUser* _tmp0_;
	SwitchboardPlugUserAccountsUserUtils* _tmp1_;
	ActUser* _tmp2_;
	SwitchboardPlugUserAccountsDeltaUser* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	ActUser* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	HdyAvatar* _tmp9_;
	HdyAvatar* _tmp10_;
	GtkToggleButton* _tmp11_ = NULL;
	GtkToggleButton* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkToggleButton* _tmp14_;
	HdyAvatar* _tmp15_;
	GtkToggleButton* _tmp16_;
	GtkEntry* _tmp17_ = NULL;
	GtkEntry* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkEntry* _tmp20_;
	GtkLabel* user_type_label = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkComboBoxText* _tmp22_;
	GtkComboBoxText* _tmp23_;
	GtkComboBoxText* _tmp24_;
	GtkComboBoxText* _tmp25_;
	GtkLabel* lang_label = NULL;
	GtkLabel* _tmp26_ = NULL;
	ActUser* _tmp27_;
	ActUser* _tmp28_;
	GtkLabel* login_label = NULL;
	GtkLabel* _tmp51_ = NULL;
	GtkSwitch* _tmp52_ = NULL;
	GtkSwitch* _tmp53_;
	GtkButton* _tmp54_;
	GtkButton* _tmp55_;
	GtkButton* _tmp56_ = NULL;
	GtkButton* _tmp57_;
	gchar* _tmp58_;
	GtkImage* _tmp59_ = NULL;
	GtkImage* _tmp60_;
	GtkStyleContext* _tmp61_;
	gchar* _tmp62_;
	GtkImage* _tmp63_ = NULL;
	GtkImage* _tmp64_;
	GtkStyleContext* _tmp65_;
	gchar* _tmp66_;
	GtkImage* _tmp67_ = NULL;
	GtkImage* _tmp68_;
	GtkStyleContext* _tmp69_;
	gchar* _tmp70_;
	GtkImage* _tmp71_ = NULL;
	GtkImage* _tmp72_;
	GtkStyleContext* _tmp73_;
	gchar* _tmp74_;
	GtkImage* _tmp75_ = NULL;
	GtkImage* _tmp76_;
	GtkStyleContext* _tmp77_;
	GtkImage* _tmp78_;
	GtkImage* _tmp79_;
	GtkStyleContext* _tmp80_;
	GtkToggleButton* _tmp81_;
	GtkEntry* _tmp82_;
	GtkLabel* _tmp83_;
	GtkComboBoxText* _tmp84_;
	GtkLabel* _tmp85_;
	GtkLabel* _tmp86_;
	GtkSwitch* _tmp87_;
	GtkButton* _tmp88_;
	GtkButton* _tmp89_;
	GtkImage* _tmp90_;
	GtkImage* _tmp91_;
	GtkImage* _tmp92_;
	GtkImage* _tmp93_;
	GtkImage* _tmp94_;
	GtkImage* _tmp95_;
	ActUser* _tmp96_;
	ActUser* _tmp97_;
	PolkitPermission* _tmp105_;
	PolkitPermission* _tmp106_;
	ActUser* _tmp107_;
	ActUser* _tmp108_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_user_settings_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, SwitchboardPlugUserAccountsWidgetsUserSettingsView);
	_tmp0_ = self->priv->_user;
	_tmp1_ = switchboard_plug_user_accounts_user_utils_new (_tmp0_, self);
	_switchboard_plug_user_accounts_user_utils_unref0 (self->priv->utils);
	self->priv->utils = _tmp1_;
	_tmp2_ = self->priv->_user;
	_tmp3_ = switchboard_plug_user_accounts_delta_user_new (_tmp2_);
	_g_object_unref0 (self->priv->delta_user);
	self->priv->delta_user = _tmp3_;
	_tmp4_ = switchboard_plug_user_accounts_get_default_regions ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->default_regions);
	self->priv->default_regions = _tmp5_;
	_tmp6_ = self->priv->_user;
	_tmp7_ = act_user_get_real_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = (HdyAvatar*) hdy_avatar_new (64, _tmp8_, TRUE);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->avatar);
	self->priv->avatar = _tmp9_;
	_tmp10_ = self->priv->avatar;
	hdy_avatar_set_image_load_func (_tmp10_, _switchboard_plug_user_accounts_widgets_user_settings_view_avatar_image_load_func_hdy_avatar_image_load_func, g_object_ref (self), g_object_unref);
	_tmp11_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->avatar_button);
	self->priv->avatar_button = _tmp11_;
	_tmp12_ = self->priv->avatar_button;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, GTK_STYLE_CLASS_FLAT);
	_tmp14_ = self->priv->avatar_button;
	_tmp15_ = self->priv->avatar;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->avatar_button;
	g_signal_connect_object (_tmp16_, "toggled", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view___lambda10__gtk_toggle_button_toggled, self, 0);
	_tmp17_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->full_name_entry);
	self->priv->full_name_entry = _tmp17_;
	_tmp18_ = self->priv->full_name_entry;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp20_ = self->priv->full_name_entry;
	g_signal_connect_object (_tmp20_, "activate", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view___lambda15__gtk_entry_activate, self, 0);
	_tmp21_ = (GtkLabel*) gtk_label_new (_ ("Account type:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp21_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp21_);
	user_type_label = _tmp21_;
	_tmp22_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->user_type_box);
	self->priv->user_type_box = _tmp22_;
	_tmp23_ = self->priv->user_type_box;
	gtk_combo_box_text_append_text (_tmp23_, _ ("Standard"));
	_tmp24_ = self->priv->user_type_box;
	gtk_combo_box_text_append_text (_tmp24_, _ ("Administrator"));
	_tmp25_ = self->priv->user_type_box;
	g_signal_connect_object ((GtkComboBox*) _tmp25_, "changed", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view___lambda16__gtk_combo_box_changed, self, 0);
	_tmp26_ = (GtkLabel*) gtk_label_new (_ ("Language:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp26_, GTK_ALIGN_END);
	g_object_ref_sink (_tmp26_);
	lang_label = _tmp26_;
	_tmp27_ = self->priv->_user;
	_tmp28_ = switchboard_plug_user_accounts_get_current_user ();
	if (_tmp27_ != _tmp28_) {
		Block6Data* _data6_;
		GtkCellRendererText* renderer = NULL;
		GtkCellRendererText* _tmp29_;
		GtkComboBox* _tmp30_ = NULL;
		GtkComboBox* _tmp31_;
		GtkCellRendererText* _tmp32_;
		GtkComboBox* _tmp33_;
		GtkCellRendererText* _tmp34_;
		GtkCellRendererText* _tmp35_;
		GtkComboBox* _tmp36_ = NULL;
		GtkComboBox* _tmp37_;
		GtkCellRendererText* _tmp38_;
		GtkComboBox* _tmp39_;
		GtkCellRendererText* _tmp40_;
		GtkRevealer* _tmp41_ = NULL;
		GtkRevealer* _tmp42_;
		GtkComboBox* _tmp43_;
		GtkComboBox* _tmp44_;
		GtkRevealer* _tmp45_;
		GtkComboBox* _tmp46_;
		GtkComboBox* _tmp47_;
		_data6_ = g_slice_new0 (Block6Data);
		_data6_->_ref_count_ = 1;
		_data6_->self = g_object_ref (self);
		_tmp29_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp29_);
		renderer = _tmp29_;
		_tmp30_ = (GtkComboBox*) gtk_combo_box_new ();
		gtk_widget_set_sensitive ((GtkWidget*) _tmp30_, FALSE);
		g_object_ref_sink (_tmp30_);
		_g_object_unref0 (self->priv->language_box);
		self->priv->language_box = _tmp30_;
		_tmp31_ = self->priv->language_box;
		_tmp32_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp31_, (GtkCellRenderer*) _tmp32_, TRUE);
		_tmp33_ = self->priv->language_box;
		_tmp34_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp33_, (GtkCellRenderer*) _tmp34_, "text", 1);
		_tmp35_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp35_);
		_g_object_unref0 (renderer);
		renderer = _tmp35_;
		_tmp36_ = (GtkComboBox*) gtk_combo_box_new ();
		gtk_widget_set_sensitive ((GtkWidget*) _tmp36_, FALSE);
		g_object_ref_sink (_tmp36_);
		_g_object_unref0 (self->priv->region_box);
		self->priv->region_box = _tmp36_;
		_tmp37_ = self->priv->region_box;
		_tmp38_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp37_, (GtkCellRenderer*) _tmp38_, TRUE);
		_tmp39_ = self->priv->region_box;
		_tmp40_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp39_, (GtkCellRenderer*) _tmp40_, "text", 1);
		_tmp41_ = (GtkRevealer*) gtk_revealer_new ();
		gtk_revealer_set_transition_type (_tmp41_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
		gtk_revealer_set_reveal_child (_tmp41_, TRUE);
		g_object_ref_sink (_tmp41_);
		_data6_->region_revealer = _tmp41_;
		_tmp42_ = _data6_->region_revealer;
		_tmp43_ = self->priv->region_box;
		gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
		_tmp44_ = self->priv->language_box;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp44_, 1, 2, 1, 1);
		_tmp45_ = _data6_->region_revealer;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp45_, 1, 3, 1, 1);
		_tmp46_ = self->priv->language_box;
		g_signal_connect_data (_tmp46_, "changed", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view____lambda17__gtk_combo_box_changed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
		_tmp47_ = self->priv->region_box;
		g_signal_connect_object (_tmp47_, "changed", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view____lambda18__gtk_combo_box_changed, self, 0);
		_g_object_unref0 (renderer);
		block6_data_unref (_data6_);
		_data6_ = NULL;
	} else {
		gchar* _tmp48_;
		GtkLinkButton* _tmp49_ = NULL;
		GtkButton* _tmp50_;
		_tmp48_ = g_strdup (_ ("Click to switch to Language & Locale Settings"));
		_tmp49_ = (GtkLinkButton*) gtk_link_button_new_with_label ("settings://language", "Language");
		gtk_widget_set_halign ((GtkWidget*) _tmp49_, GTK_ALIGN_START);
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp49_, _tmp48_);
		_g_free0 (_tmp48_);
		g_object_ref_sink (_tmp49_);
		_g_object_unref0 (self->priv->language_button);
		self->priv->language_button = (GtkButton*) _tmp49_;
		_tmp50_ = self->priv->language_button;
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp50_, 1, 2, 1, 1);
	}
	_tmp51_ = (GtkLabel*) gtk_label_new (_ ("Log In automatically:"));
	gtk_widget_set_halign ((GtkWidget*) _tmp51_, GTK_ALIGN_END);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp51_, 20);
	g_object_ref_sink (_tmp51_);
	login_label = _tmp51_;
	_tmp52_ = (GtkSwitch*) gtk_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp52_, GTK_ALIGN_START);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp52_, 24);
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->autologin_switch);
	self->priv->autologin_switch = _tmp52_;
	_tmp53_ = self->priv->autologin_switch;
	g_signal_connect_object ((GObject*) _tmp53_, "notify::active", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view___lambda19__g_object_notify, self, 0);
	_tmp54_ = (GtkButton*) gtk_button_new_with_label (_ ("Change Password…"));
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->password_button);
	self->priv->password_button = _tmp54_;
	_tmp55_ = self->priv->password_button;
	g_signal_connect_object (_tmp55_, "clicked", (GCallback) __switchboard_plug_user_accounts_widgets_user_settings_view___lambda20__gtk_button_clicked, self, 0);
	_tmp56_ = (GtkButton*) gtk_button_new ();
	gtk_widget_set_sensitive ((GtkWidget*) _tmp56_, FALSE);
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->enable_user_button);
	self->priv->enable_user_button = _tmp56_;
	_tmp57_ = self->priv->enable_user_button;
	g_signal_connect_object (_tmp57_, "clicked", (GCallback) _switchboard_plug_user_accounts_widgets_user_settings_view_change_lock_gtk_button_clicked, self, 0);
	_tmp58_ = g_strdup (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
	_tmp59_ = (GtkImage*) gtk_image_new_from_icon_name ("changes-prevent-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp59_, _tmp58_);
	_g_free0 (_tmp58_);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->full_name_lock);
	self->priv->full_name_lock = _tmp59_;
	_tmp60_ = self->priv->full_name_lock;
	_tmp61_ = gtk_widget_get_style_context ((GtkWidget*) _tmp60_);
	gtk_style_context_add_class (_tmp61_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp62_ = g_strdup (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
	_tmp63_ = (GtkImage*) gtk_image_new_from_icon_name ("changes-prevent-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp63_, _tmp62_);
	_g_free0 (_tmp62_);
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->user_type_lock);
	self->priv->user_type_lock = _tmp63_;
	_tmp64_ = self->priv->user_type_lock;
	_tmp65_ = gtk_widget_get_style_context ((GtkWidget*) _tmp64_);
	gtk_style_context_add_class (_tmp65_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp66_ = g_strdup (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
	_tmp67_ = (GtkImage*) gtk_image_new_from_icon_name ("changes-prevent-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp67_, _tmp66_);
	_g_free0 (_tmp66_);
	g_object_ref_sink (_tmp67_);
	_g_object_unref0 (self->priv->language_lock);
	self->priv->language_lock = _tmp67_;
	_tmp68_ = self->priv->language_lock;
	_tmp69_ = gtk_widget_get_style_context ((GtkWidget*) _tmp68_);
	gtk_style_context_add_class (_tmp69_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp70_ = g_strdup (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
	_tmp71_ = (GtkImage*) gtk_image_new_from_icon_name ("changes-prevent-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp71_, 20);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp71_, _tmp70_);
	_g_free0 (_tmp70_);
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (self->priv->autologin_lock);
	self->priv->autologin_lock = _tmp71_;
	_tmp72_ = self->priv->autologin_lock;
	_tmp73_ = gtk_widget_get_style_context ((GtkWidget*) _tmp72_);
	gtk_style_context_add_class (_tmp73_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp74_ = g_strdup (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_NO_PERMISSION_STRING);
	_tmp75_ = (GtkImage*) gtk_image_new_from_icon_name ("changes-prevent-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp75_, _tmp74_);
	_g_free0 (_tmp74_);
	g_object_ref_sink (_tmp75_);
	_g_object_unref0 (self->priv->password_lock);
	self->priv->password_lock = _tmp75_;
	_tmp76_ = self->priv->password_lock;
	_tmp77_ = gtk_widget_get_style_context ((GtkWidget*) _tmp76_);
	gtk_style_context_add_class (_tmp77_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp78_ = (GtkImage*) gtk_image_new_from_icon_name ("changes-prevent-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp78_);
	_g_object_unref0 (self->priv->enable_lock);
	self->priv->enable_lock = _tmp78_;
	_tmp79_ = self->priv->enable_lock;
	_tmp80_ = gtk_widget_get_style_context ((GtkWidget*) _tmp79_);
	gtk_style_context_add_class (_tmp80_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp81_ = self->priv->avatar_button;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp81_, 0, 0, 1, 1);
	_tmp82_ = self->priv->full_name_entry;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp82_, 1, 0, 1, 1);
	_tmp83_ = user_type_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp83_, 0, 1, 1, 1);
	_tmp84_ = self->priv->user_type_box;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp84_, 1, 1, 1, 1);
	_tmp85_ = lang_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp85_, 0, 2, 1, 1);
	_tmp86_ = login_label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp86_, 0, 4, 1, 1);
	_tmp87_ = self->priv->autologin_switch;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp87_, 1, 4, 1, 1);
	_tmp88_ = self->priv->password_button;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp88_, 1, 5, 1, 1);
	_tmp89_ = self->priv->enable_user_button;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp89_, 1, 6, 1, 1);
	_tmp90_ = self->priv->full_name_lock;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp90_, 2, 0, 1, 1);
	_tmp91_ = self->priv->user_type_lock;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp91_, 2, 1, 1, 1);
	_tmp92_ = self->priv->language_lock;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp92_, 2, 2, 1, 2);
	_tmp93_ = self->priv->autologin_lock;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp93_, 2, 4, 1, 1);
	_tmp94_ = self->priv->password_lock;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp94_, 2, 5, 1, 1);
	_tmp95_ = self->priv->enable_lock;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp95_, 2, 6, 1, 1);
	switchboard_plug_user_accounts_widgets_user_settings_view_update_ui (self);
	switchboard_plug_user_accounts_widgets_user_settings_view_update_permission (self);
	_tmp96_ = switchboard_plug_user_accounts_get_current_user ();
	_tmp97_ = self->priv->_user;
	if (_tmp96_ == _tmp97_) {
		GtkImage* _tmp98_;
		GtkImage* _tmp99_;
		_tmp98_ = self->priv->enable_lock;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp98_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_CURRENT_USER_STRING);
		_tmp99_ = self->priv->user_type_lock;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp99_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_CURRENT_USER_STRING);
	} else {
		ActUser* _tmp100_;
		_tmp100_ = self->priv->_user;
		if (switchboard_plug_user_accounts_is_last_admin (_tmp100_)) {
			GtkImage* _tmp101_;
			GtkImage* _tmp102_;
			_tmp101_ = self->priv->enable_lock;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp101_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_LAST_ADMIN_STRING);
			_tmp102_ = self->priv->user_type_lock;
			gtk_widget_set_tooltip_text ((GtkWidget*) _tmp102_, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_LAST_ADMIN_STRING);
		} else {
			GtkButton* _tmp103_;
			GtkImage* _tmp104_;
			_tmp103_ = self->priv->enable_user_button;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp103_, TRUE);
			_tmp104_ = self->priv->enable_lock;
			gtk_widget_set_opacity ((GtkWidget*) _tmp104_, (gdouble) 0);
		}
	}
	_tmp105_ = switchboard_plug_user_accounts_get_permission ();
	_tmp106_ = _tmp105_;
	g_signal_connect_object ((GObject*) _tmp106_, "notify::allowed", (GCallback) _switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_g_object_notify, self, 0);
	_g_object_unref0 (_tmp106_);
	_tmp107_ = self->priv->_user;
	g_signal_connect_object (_tmp107_, "changed", (GCallback) _switchboard_plug_user_accounts_widgets_user_settings_view_update_ui_act_user_changed, self, 0);
	_tmp108_ = self->priv->_user;
	g_signal_connect_object (_tmp108_, "changed", (GCallback) _switchboard_plug_user_accounts_widgets_user_settings_view_update_permission_act_user_changed, self, 0);
	_g_object_unref0 (login_label);
	_g_object_unref0 (lang_label);
	_g_object_unref0 (user_type_label);
	return obj;
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_class_init (SwitchboardPlugUserAccountsWidgetsUserSettingsViewClass * klass,
                                                                      gpointer klass_data)
{
	switchboard_plug_user_accounts_widgets_user_settings_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugUserAccountsWidgetsUserSettingsView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_user_accounts_widgets_user_settings_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_user_accounts_widgets_user_settings_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_user_accounts_widgets_user_settings_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_user_accounts_widgets_user_settings_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY, switchboard_plug_user_accounts_widgets_user_settings_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", act_user_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_instance_init (SwitchboardPlugUserAccountsWidgetsUserSettingsView * self,
                                                                         gpointer klass)
{
	self->priv = switchboard_plug_user_accounts_widgets_user_settings_view_get_instance_private (self);
}

static void
switchboard_plug_user_accounts_widgets_user_settings_view_finalize (GObject * obj)
{
	SwitchboardPlugUserAccountsWidgetsUserSettingsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, SwitchboardPlugUserAccountsWidgetsUserSettingsView);
	_switchboard_plug_user_accounts_user_utils_unref0 (self->priv->utils);
	_g_object_unref0 (self->priv->delta_user);
	_g_object_unref0 (self->priv->language_store);
	_g_object_unref0 (self->priv->region_store);
	_g_object_unref0 (self->priv->avatar);
	_g_object_unref0 (self->priv->avatar_button);
	_g_object_unref0 (self->priv->full_name_entry);
	_g_object_unref0 (self->priv->password_button);
	_g_object_unref0 (self->priv->enable_user_button);
	_g_object_unref0 (self->priv->user_type_box);
	_g_object_unref0 (self->priv->language_box);
	_g_object_unref0 (self->priv->region_box);
	_g_object_unref0 (self->priv->language_button);
	_g_object_unref0 (self->priv->autologin_switch);
	_g_object_unref0 (self->priv->full_name_lock);
	_g_object_unref0 (self->priv->user_type_lock);
	_g_object_unref0 (self->priv->language_lock);
	_g_object_unref0 (self->priv->autologin_lock);
	_g_object_unref0 (self->priv->password_lock);
	_g_object_unref0 (self->priv->enable_lock);
	_g_object_unref0 (self->priv->default_regions);
	G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_user_settings_view_parent_class)->finalize (obj);
}

static GType
switchboard_plug_user_accounts_widgets_user_settings_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugUserAccountsWidgetsUserSettingsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_user_accounts_widgets_user_settings_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugUserAccountsWidgetsUserSettingsView), 0, (GInstanceInitFunc) switchboard_plug_user_accounts_widgets_user_settings_view_instance_init, NULL };
	GType switchboard_plug_user_accounts_widgets_user_settings_view_type_id;
	switchboard_plug_user_accounts_widgets_user_settings_view_type_id = g_type_register_static (gtk_grid_get_type (), "SwitchboardPlugUserAccountsWidgetsUserSettingsView", &g_define_type_info, 0);
	SwitchboardPlugUserAccountsWidgetsUserSettingsView_private_offset = g_type_add_instance_private (switchboard_plug_user_accounts_widgets_user_settings_view_type_id, sizeof (SwitchboardPlugUserAccountsWidgetsUserSettingsViewPrivate));
	return switchboard_plug_user_accounts_widgets_user_settings_view_type_id;
}

GType
switchboard_plug_user_accounts_widgets_user_settings_view_get_type (void)
{
	static volatile gsize switchboard_plug_user_accounts_widgets_user_settings_view_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_user_accounts_widgets_user_settings_view_type_id__once)) {
		GType switchboard_plug_user_accounts_widgets_user_settings_view_type_id;
		switchboard_plug_user_accounts_widgets_user_settings_view_type_id = switchboard_plug_user_accounts_widgets_user_settings_view_get_type_once ();
		g_once_init_leave (&switchboard_plug_user_accounts_widgets_user_settings_view_type_id__once, switchboard_plug_user_accounts_widgets_user_settings_view_type_id);
	}
	return switchboard_plug_user_accounts_widgets_user_settings_view_type_id__once;
}

static void
_vala_switchboard_plug_user_accounts_widgets_user_settings_view_get_property (GObject * object,
                                                                              guint property_id,
                                                                              GValue * value,
                                                                              GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsUserSettingsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, SwitchboardPlugUserAccountsWidgetsUserSettingsView);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY:
		g_value_set_object (value, switchboard_plug_user_accounts_widgets_user_settings_view_get_user (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_user_accounts_widgets_user_settings_view_set_property (GObject * object,
                                                                              guint property_id,
                                                                              const GValue * value,
                                                                              GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsUserSettingsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_USER_SETTINGS_VIEW, SwitchboardPlugUserAccountsWidgetsUserSettingsView);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_USER_SETTINGS_VIEW_USER_PROPERTY:
		switchboard_plug_user_accounts_widgets_user_settings_view_set_user (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

