// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from AT91SAM9M10.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && at91sam9m10
// +build sam,at91sam9m10

// Atmel AT91SAM9M10 device: ARM926EJ Embedded Microprocessor Unit, 400MHz, DDR2/LPDDR, Video Decoder, LCD, HS USB, 10/100 Ethernet, Dual EBI, 324 Pins (refer to http://www.atmel.com/devices/SAM9M10.aspx for more)
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device = "AT91SAM9M10"
)

// Interrupt numbers.
const (
	// Advanced Interrupt Controller
	IRQ_FIQ = 0

	// Parallel Input/Output Controller A
	IRQ_PIOA = 2

	// Parallel Input/Output Controller B
	IRQ_PIOB = 3

	// Parallel Input/Output Controller C
	IRQ_PIOC = 4

	// Parallel Input/Output Controller D
	IRQ_PIOD = 5

	// True Random Number Generator
	IRQ_TRNG = 6

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 7

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 8

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	IRQ_USART2 = 9

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	IRQ_USART3 = 10

	// High Speed MultiMedia Card Interface 0
	IRQ_HSMCI0 = 11

	// Two-wire Interface 0
	IRQ_TWI0 = 12

	// Two-wire Interface 1
	IRQ_TWI1 = 13

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 14

	// Serial Peripheral Interface 1
	IRQ_SPI1 = 15

	// Synchronous Serial Controller 0
	IRQ_SSC0 = 16

	// Synchronous Serial Controller 1
	IRQ_SSC1 = 17

	// Timer Counter 0
	IRQ_TC0 = 18

	// Pulse Width Modulation Controller
	IRQ_PWM = 19

	// Touch Screen ADC Controller
	IRQ_TSADCC = 20

	// DMA Controller
	IRQ_DMAC = 21

	// LCD Controller
	IRQ_LCDC = 23

	// AC97 Controller
	IRQ_AC97C = 24

	// Ethernet MAC 10/100
	IRQ_EMAC = 25

	// Image Sensor Interface
	IRQ_ISI = 26

	// USB High Speed Device Port
	IRQ_UDPHS = 27

	// High Speed MultiMedia Card Interface 1
	IRQ_HSMCI1 = 29

	// Video Decoder
	IRQ_VDEC = 30

	// Advanced Interrupt Controller
	IRQ_IRQ = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export FIQ_IRQHandler
func interruptFIQ() {
	callHandlers(IRQ_FIQ)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export PIOC_IRQHandler
func interruptPIOC() {
	callHandlers(IRQ_PIOC)
}

//export PIOD_IRQHandler
func interruptPIOD() {
	callHandlers(IRQ_PIOD)
}

//export TRNG_IRQHandler
func interruptTRNG() {
	callHandlers(IRQ_TRNG)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export HSMCI0_IRQHandler
func interruptHSMCI0() {
	callHandlers(IRQ_HSMCI0)
}

//export TWI0_IRQHandler
func interruptTWI0() {
	callHandlers(IRQ_TWI0)
}

//export TWI1_IRQHandler
func interruptTWI1() {
	callHandlers(IRQ_TWI1)
}

//export SPI0_IRQHandler
func interruptSPI0() {
	callHandlers(IRQ_SPI0)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SSC0_IRQHandler
func interruptSSC0() {
	callHandlers(IRQ_SSC0)
}

//export SSC1_IRQHandler
func interruptSSC1() {
	callHandlers(IRQ_SSC1)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export PWM_IRQHandler
func interruptPWM() {
	callHandlers(IRQ_PWM)
}

//export TSADCC_IRQHandler
func interruptTSADCC() {
	callHandlers(IRQ_TSADCC)
}

//export DMAC_IRQHandler
func interruptDMAC() {
	callHandlers(IRQ_DMAC)
}

//export LCDC_IRQHandler
func interruptLCDC() {
	callHandlers(IRQ_LCDC)
}

//export AC97C_IRQHandler
func interruptAC97C() {
	callHandlers(IRQ_AC97C)
}

//export EMAC_IRQHandler
func interruptEMAC() {
	callHandlers(IRQ_EMAC)
}

//export ISI_IRQHandler
func interruptISI() {
	callHandlers(IRQ_ISI)
}

//export UDPHS_IRQHandler
func interruptUDPHS() {
	callHandlers(IRQ_UDPHS)
}

//export HSMCI1_IRQHandler
func interruptHSMCI1() {
	callHandlers(IRQ_HSMCI1)
}

//export VDEC_IRQHandler
func interruptVDEC() {
	callHandlers(IRQ_VDEC)
}

//export IRQ_IRQHandler
func interruptIRQ() {
	callHandlers(IRQ_IRQ)
}

// Peripherals.
var (
	// LCD Controller
	LCDC = (*LCDC_Type)(unsafe.Pointer(uintptr(0x500000)))

	// Video Decoder
	VDEC = (*VDEC_Type)(unsafe.Pointer(uintptr(0x900000)))

	// USB High Speed Device Port
	UDPHS = (*UDPHS_Type)(unsafe.Pointer(uintptr(0xfff78000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0xfff7c000)))

	// High Speed MultiMedia Card Interface 0
	HSMCI0 = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xfff80000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0xfff84000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0xfff88000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0xfff8c000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0xfff90000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 2
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0xfff94000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 3
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0xfff98000)))

	// Synchronous Serial Controller 0
	SSC0 = (*SSC_Type)(unsafe.Pointer(uintptr(0xfff9c000)))

	// Synchronous Serial Controller 1
	SSC1 = (*SSC_Type)(unsafe.Pointer(uintptr(0xfffa0000)))

	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0xfffa4000)))

	// Serial Peripheral Interface 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0xfffa8000)))

	// AC97 Controller
	AC97C = (*AC97C_Type)(unsafe.Pointer(uintptr(0xfffac000)))

	// Touch Screen ADC Controller
	TSADCC = (*TSADCC_Type)(unsafe.Pointer(uintptr(0xfffb0000)))

	// Image Sensor Interface
	ISI = (*ISI_Type)(unsafe.Pointer(uintptr(0xfffb4000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0xfffb8000)))

	// Ethernet MAC 10/100
	EMAC = (*EMAC_Type)(unsafe.Pointer(uintptr(0xfffbc000)))

	// True Random Number Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0xfffcc000)))

	// High Speed MultiMedia Card Interface 1
	HSMCI1 = (*HSMCI_Type)(unsafe.Pointer(uintptr(0xfffd0000)))

	// Timer Counter 1
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0xfffd4000)))

	// DDR_SDR SDRAM Controller 1
	DDRSDRC1 = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe400)))

	// DDR_SDR SDRAM Controller 0
	DDRSDRC0 = (*DDRSDRC_Type)(unsafe.Pointer(uintptr(0xffffe600)))

	// Static Memory Controller
	SMC = (*EBI_Type)(unsafe.Pointer(uintptr(0xffffe800)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0xffffea00)))

	// DMA Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0xffffec00)))

	// Debug Unit
	DBGU = (*DBGU_Type)(unsafe.Pointer(uintptr(0xffffee00)))

	// Advanced Interrupt Controller
	AIC = (*AIC_Type)(unsafe.Pointer(uintptr(0xfffff000)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff200)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff400)))

	// Parallel Input/Output Controller C
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff600)))

	// Parallel Input/Output Controller D
	PIOD = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffff800)))

	// Parallel Input/Output Controller E
	PIOE = (*PIO_Type)(unsafe.Pointer(uintptr(0xfffffa00)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0xfffffc00)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd00)))

	// Shutdown Controller
	SHDWC = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd10)))

	// Real-time Timer
	RTT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd20)))

	// Periodic Interval Timer
	PIT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd30)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd40)))

	// General Purpose Backup Register
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0xfffffd60)))

	// Real-time Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0xfffffdb0)))
)

// LCD Controller
type LCDC_Type struct {
	DMABADDR1    volatile.Register32 // 0x0
	DMABADDR2    volatile.Register32 // 0x4
	DMAFRMPT1    volatile.Register32 // 0x8
	DMAFRMPT2    volatile.Register32 // 0xC
	DMAFRMADD1   volatile.Register32 // 0x10
	DMAFRMADD2   volatile.Register32 // 0x14
	DMAFRMCFG    volatile.Register32 // 0x18
	DMACON       volatile.Register32 // 0x1C
	DMA2DCFG     volatile.Register32 // 0x20
	_            [2012]byte
	LCDCON1      volatile.Register32 // 0x800
	LCDCON2      volatile.Register32 // 0x804
	LCDTIM1      volatile.Register32 // 0x808
	LCDTIM2      volatile.Register32 // 0x80C
	LCDFRMCFG    volatile.Register32 // 0x810
	LCDFIFO      volatile.Register32 // 0x814
	_            [4]byte
	DP1_2        volatile.Register32 // 0x81C
	DP4_7        volatile.Register32 // 0x820
	DP3_5        volatile.Register32 // 0x824
	DP2_3        volatile.Register32 // 0x828
	DP5_7        volatile.Register32 // 0x82C
	DP3_4        volatile.Register32 // 0x830
	DP4_5        volatile.Register32 // 0x834
	DP6_7        volatile.Register32 // 0x838
	PWRCON       volatile.Register32 // 0x83C
	CONTRAST_CTR volatile.Register32 // 0x840
	CONTRAST_VAL volatile.Register32 // 0x844
	LCD_IER      volatile.Register32 // 0x848
	LCD_IDR      volatile.Register32 // 0x84C
	LCD_IMR      volatile.Register32 // 0x850
	LCD_ISR      volatile.Register32 // 0x854
	LCD_ICR      volatile.Register32 // 0x858
	_            [4]byte
	LCD_ITR      volatile.Register32 // 0x860
	LCD_IRR      volatile.Register32 // 0x864
	_            [124]byte
	LCD_WPCR     volatile.Register32 // 0x8E4
	LCD_WPSR     volatile.Register32 // 0x8E8
	_            [788]byte
	LUTENTRY     [256]volatile.Register32 // 0xC00
}

// LCDC.DMABADDR1: DMA Base Address Register 1
func (o *LCDC_Type) SetDMABADDR1_BADDR_U(value uint32) {
	volatile.StoreUint32(&o.DMABADDR1.Reg, volatile.LoadUint32(&o.DMABADDR1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCDC_Type) GetDMABADDR1_BADDR_U() uint32 {
	return (volatile.LoadUint32(&o.DMABADDR1.Reg) & 0xfffffffc) >> 2
}

// LCDC.DMABADDR2: DMA Base Address Register 2
func (o *LCDC_Type) SetDMABADDR2(value uint32) {
	volatile.StoreUint32(&o.DMABADDR2.Reg, value)
}
func (o *LCDC_Type) GetDMABADDR2() uint32 {
	return volatile.LoadUint32(&o.DMABADDR2.Reg)
}

// LCDC.DMAFRMPT1: DMA Frame Pointer Register 1
func (o *LCDC_Type) SetDMAFRMPT1_FRMPT_U(value uint32) {
	volatile.StoreUint32(&o.DMAFRMPT1.Reg, volatile.LoadUint32(&o.DMAFRMPT1.Reg)&^(0x7fffff)|value)
}
func (o *LCDC_Type) GetDMAFRMPT1_FRMPT_U() uint32 {
	return volatile.LoadUint32(&o.DMAFRMPT1.Reg) & 0x7fffff
}

// LCDC.DMAFRMPT2: DMA Frame Pointer Register 2
func (o *LCDC_Type) SetDMAFRMPT2_FRMPT_L(value uint32) {
	volatile.StoreUint32(&o.DMAFRMPT2.Reg, volatile.LoadUint32(&o.DMAFRMPT2.Reg)&^(0x7fffff)|value)
}
func (o *LCDC_Type) GetDMAFRMPT2_FRMPT_L() uint32 {
	return volatile.LoadUint32(&o.DMAFRMPT2.Reg) & 0x7fffff
}

// LCDC.DMAFRMADD1: DMA Frame Address Register 1
func (o *LCDC_Type) SetDMAFRMADD1(value uint32) {
	volatile.StoreUint32(&o.DMAFRMADD1.Reg, value)
}
func (o *LCDC_Type) GetDMAFRMADD1() uint32 {
	return volatile.LoadUint32(&o.DMAFRMADD1.Reg)
}

// LCDC.DMAFRMADD2: DMA Frame Address Register 2
func (o *LCDC_Type) SetDMAFRMADD2(value uint32) {
	volatile.StoreUint32(&o.DMAFRMADD2.Reg, value)
}
func (o *LCDC_Type) GetDMAFRMADD2() uint32 {
	return volatile.LoadUint32(&o.DMAFRMADD2.Reg)
}

// LCDC.DMAFRMCFG: DMA Frame Configuration Register
func (o *LCDC_Type) SetDMAFRMCFG_FRMSIZE(value uint32) {
	volatile.StoreUint32(&o.DMAFRMCFG.Reg, volatile.LoadUint32(&o.DMAFRMCFG.Reg)&^(0x7fffff)|value)
}
func (o *LCDC_Type) GetDMAFRMCFG_FRMSIZE() uint32 {
	return volatile.LoadUint32(&o.DMAFRMCFG.Reg) & 0x7fffff
}
func (o *LCDC_Type) SetDMAFRMCFG_BRSTLN(value uint32) {
	volatile.StoreUint32(&o.DMAFRMCFG.Reg, volatile.LoadUint32(&o.DMAFRMCFG.Reg)&^(0x7f000000)|value<<24)
}
func (o *LCDC_Type) GetDMAFRMCFG_BRSTLN() uint32 {
	return (volatile.LoadUint32(&o.DMAFRMCFG.Reg) & 0x7f000000) >> 24
}

// LCDC.DMACON: DMA Control Register
func (o *LCDC_Type) SetDMACON_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DMACON.Reg, volatile.LoadUint32(&o.DMACON.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetDMACON_DMAEN() uint32 {
	return volatile.LoadUint32(&o.DMACON.Reg) & 0x1
}
func (o *LCDC_Type) SetDMACON_DMARST(value uint32) {
	volatile.StoreUint32(&o.DMACON.Reg, volatile.LoadUint32(&o.DMACON.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetDMACON_DMARST() uint32 {
	return (volatile.LoadUint32(&o.DMACON.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetDMACON_DMABUSY(value uint32) {
	volatile.StoreUint32(&o.DMACON.Reg, volatile.LoadUint32(&o.DMACON.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetDMACON_DMABUSY() uint32 {
	return (volatile.LoadUint32(&o.DMACON.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetDMACON_DMAUPDT(value uint32) {
	volatile.StoreUint32(&o.DMACON.Reg, volatile.LoadUint32(&o.DMACON.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetDMACON_DMAUPDT() uint32 {
	return (volatile.LoadUint32(&o.DMACON.Reg) & 0x8) >> 3
}
func (o *LCDC_Type) SetDMACON_DMA2DEN(value uint32) {
	volatile.StoreUint32(&o.DMACON.Reg, volatile.LoadUint32(&o.DMACON.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetDMACON_DMA2DEN() uint32 {
	return (volatile.LoadUint32(&o.DMACON.Reg) & 0x10) >> 4
}

// LCDC.DMA2DCFG: DMA Control Register
func (o *LCDC_Type) SetDMA2DCFG_ADDRINC(value uint32) {
	volatile.StoreUint32(&o.DMA2DCFG.Reg, volatile.LoadUint32(&o.DMA2DCFG.Reg)&^(0xffff)|value)
}
func (o *LCDC_Type) GetDMA2DCFG_ADDRINC() uint32 {
	return volatile.LoadUint32(&o.DMA2DCFG.Reg) & 0xffff
}
func (o *LCDC_Type) SetDMA2DCFG_PIXELOFF(value uint32) {
	volatile.StoreUint32(&o.DMA2DCFG.Reg, volatile.LoadUint32(&o.DMA2DCFG.Reg)&^(0x1f000000)|value<<24)
}
func (o *LCDC_Type) GetDMA2DCFG_PIXELOFF() uint32 {
	return (volatile.LoadUint32(&o.DMA2DCFG.Reg) & 0x1f000000) >> 24
}

// LCDC.LCDCON1: LCD Control Register 1
func (o *LCDC_Type) SetLCDCON1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.LCDCON1.Reg, volatile.LoadUint32(&o.LCDCON1.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCDCON1_BYPASS() uint32 {
	return volatile.LoadUint32(&o.LCDCON1.Reg) & 0x1
}
func (o *LCDC_Type) SetLCDCON1_CLKVAL(value uint32) {
	volatile.StoreUint32(&o.LCDCON1.Reg, volatile.LoadUint32(&o.LCDCON1.Reg)&^(0x1ff000)|value<<12)
}
func (o *LCDC_Type) GetLCDCON1_CLKVAL() uint32 {
	return (volatile.LoadUint32(&o.LCDCON1.Reg) & 0x1ff000) >> 12
}
func (o *LCDC_Type) SetLCDCON1_LINECNT(value uint32) {
	volatile.StoreUint32(&o.LCDCON1.Reg, volatile.LoadUint32(&o.LCDCON1.Reg)&^(0xffe00000)|value<<21)
}
func (o *LCDC_Type) GetLCDCON1_LINECNT() uint32 {
	return (volatile.LoadUint32(&o.LCDCON1.Reg) & 0xffe00000) >> 21
}

// LCDC.LCDCON2: LCD Control Register 2
func (o *LCDC_Type) SetLCDCON2_DISTYPE(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x3)|value)
}
func (o *LCDC_Type) GetLCDCON2_DISTYPE() uint32 {
	return volatile.LoadUint32(&o.LCDCON2.Reg) & 0x3
}
func (o *LCDC_Type) SetLCDCON2_SCANMOD(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCDCON2_SCANMOD() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCDCON2_IFWIDTH(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x18)|value<<3)
}
func (o *LCDC_Type) GetLCDCON2_IFWIDTH() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x18) >> 3
}
func (o *LCDC_Type) SetLCDCON2_PIXELSIZE(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0xe0)|value<<5)
}
func (o *LCDC_Type) GetLCDCON2_PIXELSIZE() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0xe0) >> 5
}
func (o *LCDC_Type) SetLCDCON2_INVVD(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x100)|value<<8)
}
func (o *LCDC_Type) GetLCDCON2_INVVD() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x100) >> 8
}
func (o *LCDC_Type) SetLCDCON2_INVFRAME(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x200)|value<<9)
}
func (o *LCDC_Type) GetLCDCON2_INVFRAME() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x200) >> 9
}
func (o *LCDC_Type) SetLCDCON2_INVLINE(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x400)|value<<10)
}
func (o *LCDC_Type) GetLCDCON2_INVLINE() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x400) >> 10
}
func (o *LCDC_Type) SetLCDCON2_INVCLK(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x800)|value<<11)
}
func (o *LCDC_Type) GetLCDCON2_INVCLK() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x800) >> 11
}
func (o *LCDC_Type) SetLCDCON2_INVDVAL(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x1000)|value<<12)
}
func (o *LCDC_Type) GetLCDCON2_INVDVAL() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x1000) >> 12
}
func (o *LCDC_Type) SetLCDCON2_CLKMOD(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0x8000)|value<<15)
}
func (o *LCDC_Type) GetLCDCON2_CLKMOD() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0x8000) >> 15
}
func (o *LCDC_Type) SetLCDCON2_MEMOR(value uint32) {
	volatile.StoreUint32(&o.LCDCON2.Reg, volatile.LoadUint32(&o.LCDCON2.Reg)&^(0xc0000000)|value<<30)
}
func (o *LCDC_Type) GetLCDCON2_MEMOR() uint32 {
	return (volatile.LoadUint32(&o.LCDCON2.Reg) & 0xc0000000) >> 30
}

// LCDC.LCDTIM1: LCD Timing Register 1
func (o *LCDC_Type) SetLCDTIM1_VFP(value uint32) {
	volatile.StoreUint32(&o.LCDTIM1.Reg, volatile.LoadUint32(&o.LCDTIM1.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetLCDTIM1_VFP() uint32 {
	return volatile.LoadUint32(&o.LCDTIM1.Reg) & 0xff
}
func (o *LCDC_Type) SetLCDTIM1_VBP(value uint32) {
	volatile.StoreUint32(&o.LCDTIM1.Reg, volatile.LoadUint32(&o.LCDTIM1.Reg)&^(0xff00)|value<<8)
}
func (o *LCDC_Type) GetLCDTIM1_VBP() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM1.Reg) & 0xff00) >> 8
}
func (o *LCDC_Type) SetLCDTIM1_VPW(value uint32) {
	volatile.StoreUint32(&o.LCDTIM1.Reg, volatile.LoadUint32(&o.LCDTIM1.Reg)&^(0x3f0000)|value<<16)
}
func (o *LCDC_Type) GetLCDTIM1_VPW() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM1.Reg) & 0x3f0000) >> 16
}
func (o *LCDC_Type) SetLCDTIM1_VHDLY(value uint32) {
	volatile.StoreUint32(&o.LCDTIM1.Reg, volatile.LoadUint32(&o.LCDTIM1.Reg)&^(0xf000000)|value<<24)
}
func (o *LCDC_Type) GetLCDTIM1_VHDLY() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM1.Reg) & 0xf000000) >> 24
}
func (o *LCDC_Type) SetLCDTIM1_STUCKTO1(value uint32) {
	volatile.StoreUint32(&o.LCDTIM1.Reg, volatile.LoadUint32(&o.LCDTIM1.Reg)&^(0x80000000)|value<<31)
}
func (o *LCDC_Type) GetLCDTIM1_STUCKTO1() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM1.Reg) & 0x80000000) >> 31
}

// LCDC.LCDTIM2: LCD Timing Register 2
func (o *LCDC_Type) SetLCDTIM2_HBP(value uint32) {
	volatile.StoreUint32(&o.LCDTIM2.Reg, volatile.LoadUint32(&o.LCDTIM2.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetLCDTIM2_HBP() uint32 {
	return volatile.LoadUint32(&o.LCDTIM2.Reg) & 0xff
}
func (o *LCDC_Type) SetLCDTIM2_HPW(value uint32) {
	volatile.StoreUint32(&o.LCDTIM2.Reg, volatile.LoadUint32(&o.LCDTIM2.Reg)&^(0x3f00)|value<<8)
}
func (o *LCDC_Type) GetLCDTIM2_HPW() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM2.Reg) & 0x3f00) >> 8
}
func (o *LCDC_Type) SetLCDTIM2_HFP(value uint32) {
	volatile.StoreUint32(&o.LCDTIM2.Reg, volatile.LoadUint32(&o.LCDTIM2.Reg)&^(0xffe00000)|value<<21)
}
func (o *LCDC_Type) GetLCDTIM2_HFP() uint32 {
	return (volatile.LoadUint32(&o.LCDTIM2.Reg) & 0xffe00000) >> 21
}

// LCDC.LCDFRMCFG: LCD Frame Configuration Register
func (o *LCDC_Type) SetLCDFRMCFG_LINEVAL(value uint32) {
	volatile.StoreUint32(&o.LCDFRMCFG.Reg, volatile.LoadUint32(&o.LCDFRMCFG.Reg)&^(0x7ff)|value)
}
func (o *LCDC_Type) GetLCDFRMCFG_LINEVAL() uint32 {
	return volatile.LoadUint32(&o.LCDFRMCFG.Reg) & 0x7ff
}
func (o *LCDC_Type) SetLCDFRMCFG_LINESIZE(value uint32) {
	volatile.StoreUint32(&o.LCDFRMCFG.Reg, volatile.LoadUint32(&o.LCDFRMCFG.Reg)&^(0xffe00000)|value<<21)
}
func (o *LCDC_Type) GetLCDFRMCFG_LINESIZE() uint32 {
	return (volatile.LoadUint32(&o.LCDFRMCFG.Reg) & 0xffe00000) >> 21
}

// LCDC.LCDFIFO: LCD FIFO Register
func (o *LCDC_Type) SetLCDFIFO_FIFOTH(value uint32) {
	volatile.StoreUint32(&o.LCDFIFO.Reg, volatile.LoadUint32(&o.LCDFIFO.Reg)&^(0xffff)|value)
}
func (o *LCDC_Type) GetLCDFIFO_FIFOTH() uint32 {
	return volatile.LoadUint32(&o.LCDFIFO.Reg) & 0xffff
}

// LCDC.DP1_2: Dithering Pattern DP1_2
func (o *LCDC_Type) SetDP1_2(value uint32) {
	volatile.StoreUint32(&o.DP1_2.Reg, volatile.LoadUint32(&o.DP1_2.Reg)&^(0xff)|value)
}
func (o *LCDC_Type) GetDP1_2() uint32 {
	return volatile.LoadUint32(&o.DP1_2.Reg) & 0xff
}

// LCDC.DP4_7: Dithering Pattern DP4_7
func (o *LCDC_Type) SetDP4_7(value uint32) {
	volatile.StoreUint32(&o.DP4_7.Reg, volatile.LoadUint32(&o.DP4_7.Reg)&^(0xfffffff)|value)
}
func (o *LCDC_Type) GetDP4_7() uint32 {
	return volatile.LoadUint32(&o.DP4_7.Reg) & 0xfffffff
}

// LCDC.DP3_5: Dithering Pattern DP3_5
func (o *LCDC_Type) SetDP3_5(value uint32) {
	volatile.StoreUint32(&o.DP3_5.Reg, volatile.LoadUint32(&o.DP3_5.Reg)&^(0xfffff)|value)
}
func (o *LCDC_Type) GetDP3_5() uint32 {
	return volatile.LoadUint32(&o.DP3_5.Reg) & 0xfffff
}

// LCDC.DP2_3: Dithering Pattern DP2_3
func (o *LCDC_Type) SetDP2_3(value uint32) {
	volatile.StoreUint32(&o.DP2_3.Reg, volatile.LoadUint32(&o.DP2_3.Reg)&^(0xfff)|value)
}
func (o *LCDC_Type) GetDP2_3() uint32 {
	return volatile.LoadUint32(&o.DP2_3.Reg) & 0xfff
}

// LCDC.DP5_7: Dithering Pattern DP5_7
func (o *LCDC_Type) SetDP5_7(value uint32) {
	volatile.StoreUint32(&o.DP5_7.Reg, volatile.LoadUint32(&o.DP5_7.Reg)&^(0xfffffff)|value)
}
func (o *LCDC_Type) GetDP5_7() uint32 {
	return volatile.LoadUint32(&o.DP5_7.Reg) & 0xfffffff
}

// LCDC.DP3_4: Dithering Pattern DP3_4
func (o *LCDC_Type) SetDP3_4(value uint32) {
	volatile.StoreUint32(&o.DP3_4.Reg, volatile.LoadUint32(&o.DP3_4.Reg)&^(0xffff)|value)
}
func (o *LCDC_Type) GetDP3_4() uint32 {
	return volatile.LoadUint32(&o.DP3_4.Reg) & 0xffff
}

// LCDC.DP4_5: Dithering Pattern DP4_5
func (o *LCDC_Type) SetDP4_5(value uint32) {
	volatile.StoreUint32(&o.DP4_5.Reg, volatile.LoadUint32(&o.DP4_5.Reg)&^(0xfffff)|value)
}
func (o *LCDC_Type) GetDP4_5() uint32 {
	return volatile.LoadUint32(&o.DP4_5.Reg) & 0xfffff
}

// LCDC.DP6_7: Dithering Pattern DP6_7
func (o *LCDC_Type) SetDP6_7(value uint32) {
	volatile.StoreUint32(&o.DP6_7.Reg, volatile.LoadUint32(&o.DP6_7.Reg)&^(0xfffffff)|value)
}
func (o *LCDC_Type) GetDP6_7() uint32 {
	return volatile.LoadUint32(&o.DP6_7.Reg) & 0xfffffff
}

// LCDC.PWRCON: Power Control Register
func (o *LCDC_Type) SetPWRCON_LCD_PWR(value uint32) {
	volatile.StoreUint32(&o.PWRCON.Reg, volatile.LoadUint32(&o.PWRCON.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetPWRCON_LCD_PWR() uint32 {
	return volatile.LoadUint32(&o.PWRCON.Reg) & 0x1
}
func (o *LCDC_Type) SetPWRCON_GUARD_TIME(value uint32) {
	volatile.StoreUint32(&o.PWRCON.Reg, volatile.LoadUint32(&o.PWRCON.Reg)&^(0xfe)|value<<1)
}
func (o *LCDC_Type) GetPWRCON_GUARD_TIME() uint32 {
	return (volatile.LoadUint32(&o.PWRCON.Reg) & 0xfe) >> 1
}
func (o *LCDC_Type) SetPWRCON_LCD_BUSY(value uint32) {
	volatile.StoreUint32(&o.PWRCON.Reg, volatile.LoadUint32(&o.PWRCON.Reg)&^(0x80000000)|value<<31)
}
func (o *LCDC_Type) GetPWRCON_LCD_BUSY() uint32 {
	return (volatile.LoadUint32(&o.PWRCON.Reg) & 0x80000000) >> 31
}

// LCDC.CONTRAST_CTR: Contrast Control Register
func (o *LCDC_Type) SetCONTRAST_CTR_PS(value uint32) {
	volatile.StoreUint32(&o.CONTRAST_CTR.Reg, volatile.LoadUint32(&o.CONTRAST_CTR.Reg)&^(0x3)|value)
}
func (o *LCDC_Type) GetCONTRAST_CTR_PS() uint32 {
	return volatile.LoadUint32(&o.CONTRAST_CTR.Reg) & 0x3
}
func (o *LCDC_Type) SetCONTRAST_CTR_POL(value uint32) {
	volatile.StoreUint32(&o.CONTRAST_CTR.Reg, volatile.LoadUint32(&o.CONTRAST_CTR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetCONTRAST_CTR_POL() uint32 {
	return (volatile.LoadUint32(&o.CONTRAST_CTR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetCONTRAST_CTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CONTRAST_CTR.Reg, volatile.LoadUint32(&o.CONTRAST_CTR.Reg)&^(0x8)|value<<3)
}
func (o *LCDC_Type) GetCONTRAST_CTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CONTRAST_CTR.Reg) & 0x8) >> 3
}

// LCDC.LCD_IER: LCD Interrupt Enable Register
func (o *LCDC_Type) SetLCD_IER_LNIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_IER_LNIE() uint32 {
	return volatile.LoadUint32(&o.LCD_IER.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_IER_LSTLNIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_IER_LSTLNIE() uint32 {
	return (volatile.LoadUint32(&o.LCD_IER.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_IER_EOFIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_IER_EOFIE() uint32 {
	return (volatile.LoadUint32(&o.LCD_IER.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_IER_UFLWIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_IER_UFLWIE() uint32 {
	return (volatile.LoadUint32(&o.LCD_IER.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_IER_OWRIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_IER_OWRIE() uint32 {
	return (volatile.LoadUint32(&o.LCD_IER.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_IER_MERIE(value uint32) {
	volatile.StoreUint32(&o.LCD_IER.Reg, volatile.LoadUint32(&o.LCD_IER.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_IER_MERIE() uint32 {
	return (volatile.LoadUint32(&o.LCD_IER.Reg) & 0x40) >> 6
}

// LCDC.LCD_IDR: LCD Interrupt Disable Register
func (o *LCDC_Type) SetLCD_IDR_LNID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_IDR_LNID() uint32 {
	return volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_IDR_LSTLNID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_IDR_LSTLNID() uint32 {
	return (volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_IDR_EOFID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_IDR_EOFID() uint32 {
	return (volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_IDR_UFLWID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_IDR_UFLWID() uint32 {
	return (volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_IDR_OWRID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_IDR_OWRID() uint32 {
	return (volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_IDR_MERID(value uint32) {
	volatile.StoreUint32(&o.LCD_IDR.Reg, volatile.LoadUint32(&o.LCD_IDR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_IDR_MERID() uint32 {
	return (volatile.LoadUint32(&o.LCD_IDR.Reg) & 0x40) >> 6
}

// LCDC.LCD_IMR: LCD Interrupt Mask Register
func (o *LCDC_Type) SetLCD_IMR_LNIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_IMR_LNIM() uint32 {
	return volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_IMR_LSTLNIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_IMR_LSTLNIM() uint32 {
	return (volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_IMR_EOFIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_IMR_EOFIM() uint32 {
	return (volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_IMR_UFLWIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_IMR_UFLWIM() uint32 {
	return (volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_IMR_OWRIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_IMR_OWRIM() uint32 {
	return (volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_IMR_MERIM(value uint32) {
	volatile.StoreUint32(&o.LCD_IMR.Reg, volatile.LoadUint32(&o.LCD_IMR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_IMR_MERIM() uint32 {
	return (volatile.LoadUint32(&o.LCD_IMR.Reg) & 0x40) >> 6
}

// LCDC.LCD_ISR: LCD Interrupt Status Register
func (o *LCDC_Type) SetLCD_ISR_LNIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_ISR_LNIS() uint32 {
	return volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_ISR_LSTLNIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_ISR_LSTLNIS() uint32 {
	return (volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_ISR_EOFIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_ISR_EOFIS() uint32 {
	return (volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_ISR_UFLWIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_ISR_UFLWIS() uint32 {
	return (volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_ISR_OWRIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_ISR_OWRIS() uint32 {
	return (volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_ISR_MERIS(value uint32) {
	volatile.StoreUint32(&o.LCD_ISR.Reg, volatile.LoadUint32(&o.LCD_ISR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_ISR_MERIS() uint32 {
	return (volatile.LoadUint32(&o.LCD_ISR.Reg) & 0x40) >> 6
}

// LCDC.LCD_ICR: LCD Interrupt Clear Register
func (o *LCDC_Type) SetLCD_ICR_LNIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_ICR_LNIC() uint32 {
	return volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_ICR_LSTLNIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_ICR_LSTLNIC() uint32 {
	return (volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_ICR_EOFIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_ICR_EOFIC() uint32 {
	return (volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_ICR_UFLWIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_ICR_UFLWIC() uint32 {
	return (volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_ICR_OWRIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_ICR_OWRIC() uint32 {
	return (volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_ICR_MERIC(value uint32) {
	volatile.StoreUint32(&o.LCD_ICR.Reg, volatile.LoadUint32(&o.LCD_ICR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_ICR_MERIC() uint32 {
	return (volatile.LoadUint32(&o.LCD_ICR.Reg) & 0x40) >> 6
}

// LCDC.LCD_ITR: LCD Interrupt Test Register
func (o *LCDC_Type) SetLCD_ITR_LNIT(value uint32) {
	volatile.StoreUint32(&o.LCD_ITR.Reg, volatile.LoadUint32(&o.LCD_ITR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_ITR_LNIT() uint32 {
	return volatile.LoadUint32(&o.LCD_ITR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_ITR_LSTLNIT(value uint32) {
	volatile.StoreUint32(&o.LCD_ITR.Reg, volatile.LoadUint32(&o.LCD_ITR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_ITR_LSTLNIT() uint32 {
	return (volatile.LoadUint32(&o.LCD_ITR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_ITR_EOFIT(value uint32) {
	volatile.StoreUint32(&o.LCD_ITR.Reg, volatile.LoadUint32(&o.LCD_ITR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_ITR_EOFIT() uint32 {
	return (volatile.LoadUint32(&o.LCD_ITR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_ITR_UFLWIT(value uint32) {
	volatile.StoreUint32(&o.LCD_ITR.Reg, volatile.LoadUint32(&o.LCD_ITR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_ITR_UFLWIT() uint32 {
	return (volatile.LoadUint32(&o.LCD_ITR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_ITR_OWRIT(value uint32) {
	volatile.StoreUint32(&o.LCD_ITR.Reg, volatile.LoadUint32(&o.LCD_ITR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_ITR_OWRIT() uint32 {
	return (volatile.LoadUint32(&o.LCD_ITR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_ITR_MERIT(value uint32) {
	volatile.StoreUint32(&o.LCD_ITR.Reg, volatile.LoadUint32(&o.LCD_ITR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_ITR_MERIT() uint32 {
	return (volatile.LoadUint32(&o.LCD_ITR.Reg) & 0x40) >> 6
}

// LCDC.LCD_IRR: LCD Interrupt Raw Status Register
func (o *LCDC_Type) SetLCD_IRR_LNIR(value uint32) {
	volatile.StoreUint32(&o.LCD_IRR.Reg, volatile.LoadUint32(&o.LCD_IRR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_IRR_LNIR() uint32 {
	return volatile.LoadUint32(&o.LCD_IRR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_IRR_LSTLNIR(value uint32) {
	volatile.StoreUint32(&o.LCD_IRR.Reg, volatile.LoadUint32(&o.LCD_IRR.Reg)&^(0x2)|value<<1)
}
func (o *LCDC_Type) GetLCD_IRR_LSTLNIR() uint32 {
	return (volatile.LoadUint32(&o.LCD_IRR.Reg) & 0x2) >> 1
}
func (o *LCDC_Type) SetLCD_IRR_EOFIR(value uint32) {
	volatile.StoreUint32(&o.LCD_IRR.Reg, volatile.LoadUint32(&o.LCD_IRR.Reg)&^(0x4)|value<<2)
}
func (o *LCDC_Type) GetLCD_IRR_EOFIR() uint32 {
	return (volatile.LoadUint32(&o.LCD_IRR.Reg) & 0x4) >> 2
}
func (o *LCDC_Type) SetLCD_IRR_UFLWIR(value uint32) {
	volatile.StoreUint32(&o.LCD_IRR.Reg, volatile.LoadUint32(&o.LCD_IRR.Reg)&^(0x10)|value<<4)
}
func (o *LCDC_Type) GetLCD_IRR_UFLWIR() uint32 {
	return (volatile.LoadUint32(&o.LCD_IRR.Reg) & 0x10) >> 4
}
func (o *LCDC_Type) SetLCD_IRR_OWRIR(value uint32) {
	volatile.StoreUint32(&o.LCD_IRR.Reg, volatile.LoadUint32(&o.LCD_IRR.Reg)&^(0x20)|value<<5)
}
func (o *LCDC_Type) GetLCD_IRR_OWRIR() uint32 {
	return (volatile.LoadUint32(&o.LCD_IRR.Reg) & 0x20) >> 5
}
func (o *LCDC_Type) SetLCD_IRR_MERIR(value uint32) {
	volatile.StoreUint32(&o.LCD_IRR.Reg, volatile.LoadUint32(&o.LCD_IRR.Reg)&^(0x40)|value<<6)
}
func (o *LCDC_Type) GetLCD_IRR_MERIR() uint32 {
	return (volatile.LoadUint32(&o.LCD_IRR.Reg) & 0x40) >> 6
}

// LCDC.LCD_WPSR: Write Protection Status Register
func (o *LCDC_Type) SetLCD_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.LCD_WPSR.Reg, volatile.LoadUint32(&o.LCD_WPSR.Reg)&^(0x1)|value)
}
func (o *LCDC_Type) GetLCD_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.LCD_WPSR.Reg) & 0x1
}
func (o *LCDC_Type) SetLCD_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.LCD_WPSR.Reg, volatile.LoadUint32(&o.LCD_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *LCDC_Type) GetLCD_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.LCD_WPSR.Reg) & 0xffff00) >> 8
}

// Video Decoder
type VDEC_Type struct {
	IDR      volatile.Register32     // 0x0
	DIR      volatile.Register32     // 0x4
	DDCR     volatile.Register32     // 0x8
	CTLR0    volatile.Register32     // 0xC
	CTLR1    volatile.Register32     // 0x10
	CTLR2    volatile.Register32     // 0x14
	CTLR3    volatile.Register32     // 0x18
	CTLR4    volatile.Register32     // 0x1C
	CTLR5    volatile.Register32     // 0x20
	CTLR6    volatile.Register32     // 0x24
	DMVBA    volatile.Register32     // 0x28
	CTLR7    volatile.Register32     // 0x2C
	RLCVLCBA volatile.Register32     // 0x30
	PICTBA   volatile.Register32     // 0x34
	PIDXBA   [16]volatile.Register32 // 0x38
	PNR0     volatile.Register32     // 0x78
	PNR1     volatile.Register32     // 0x7C
	PNR2     volatile.Register32     // 0x80
	PNR3     volatile.Register32     // 0x84
	PNR4     volatile.Register32     // 0x88
	PNR5     volatile.Register32     // 0x8C
	PNR6     volatile.Register32     // 0x90
	PNR7     volatile.Register32     // 0x94
	PLTFR    volatile.Register32     // 0x98
	PVFR     volatile.Register32     // 0x9C
	SDTBA    volatile.Register32     // 0xA0
	DMMVBA   volatile.Register32     // 0xA4
	IRPLR0   volatile.Register32     // 0xA8
	IRPLR1   volatile.Register32     // 0xAC
	IRPLR2   volatile.Register32     // 0xB0
	IRPLR3   volatile.Register32     // 0xB4
	IRPLR4   volatile.Register32     // 0xB8
	IRPLR5   volatile.Register32     // 0xBC
	ECR      volatile.Register32     // 0xC0
}

// VDEC.IDR: ID Register
func (o *VDEC_Type) SetIDR_BUILD_VER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf)|value)
}
func (o *VDEC_Type) GetIDR_BUILD_VER() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xf
}
func (o *VDEC_Type) SetIDR_MINOR_VER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xff0)|value<<4)
}
func (o *VDEC_Type) GetIDR_MINOR_VER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xff0) >> 4
}
func (o *VDEC_Type) SetIDR_MAJOR_VER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xf000)|value<<12)
}
func (o *VDEC_Type) GetIDR_MAJOR_VER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xf000) >> 12
}
func (o *VDEC_Type) SetIDR_PROD_ID(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xffff0000)|value<<16)
}
func (o *VDEC_Type) GetIDR_PROD_ID() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0xffff0000) >> 16
}

// VDEC.DIR: Decoder Interrupt Register
func (o *VDEC_Type) SetDIR_DE(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1)|value)
}
func (o *VDEC_Type) GetDIR_DE() uint32 {
	return volatile.LoadUint32(&o.DIR.Reg) & 0x1
}
func (o *VDEC_Type) SetDIR_ID(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10)|value<<4)
}
func (o *VDEC_Type) GetDIR_ID() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10) >> 4
}
func (o *VDEC_Type) SetDIR_ISET(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x100)|value<<8)
}
func (o *VDEC_Type) GetDIR_ISET() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x100) >> 8
}
func (o *VDEC_Type) SetDIR_DR(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1000)|value<<12)
}
func (o *VDEC_Type) GetDIR_DR() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1000) >> 12
}
func (o *VDEC_Type) SetDIR_BE(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2000)|value<<13)
}
func (o *VDEC_Type) GetDIR_BE() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2000) >> 13
}
func (o *VDEC_Type) SetDIR_SBE(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4000)|value<<14)
}
func (o *VDEC_Type) GetDIR_SBE() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4000) >> 14
}
func (o *VDEC_Type) SetDIR_ASOD(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8000)|value<<15)
}
func (o *VDEC_Type) GetDIR_ASOD() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8000) >> 15
}
func (o *VDEC_Type) SetDIR_ISE(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10000)|value<<16)
}
func (o *VDEC_Type) GetDIR_ISE() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10000) >> 16
}
func (o *VDEC_Type) SetDIR_JPEGSD(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20000)|value<<17)
}
func (o *VDEC_Type) GetDIR_JPEGSD() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20000) >> 17
}
func (o *VDEC_Type) SetDIR_TO(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40000)|value<<18)
}
func (o *VDEC_Type) GetDIR_TO() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40000) >> 18
}

// VDEC.DDCR: Decoder Device Configuration Register
func (o *VDEC_Type) SetDDCR_MAX_BURST_LEN(value uint32) {
	volatile.StoreUint32(&o.DDCR.Reg, volatile.LoadUint32(&o.DDCR.Reg)&^(0x1f)|value)
}
func (o *VDEC_Type) GetDDCR_MAX_BURST_LEN() uint32 {
	return volatile.LoadUint32(&o.DDCR.Reg) & 0x1f
}
func (o *VDEC_Type) SetDDCR_PRIOR(value uint32) {
	volatile.StoreUint32(&o.DDCR.Reg, volatile.LoadUint32(&o.DDCR.Reg)&^(0xe0)|value<<5)
}
func (o *VDEC_Type) GetDDCR_PRIOR() uint32 {
	return (volatile.LoadUint32(&o.DDCR.Reg) & 0xe0) >> 5
}
func (o *VDEC_Type) SetDDCR_DO_LE(value uint32) {
	volatile.StoreUint32(&o.DDCR.Reg, volatile.LoadUint32(&o.DDCR.Reg)&^(0x100)|value<<8)
}
func (o *VDEC_Type) GetDDCR_DO_LE() uint32 {
	return (volatile.LoadUint32(&o.DDCR.Reg) & 0x100) >> 8
}
func (o *VDEC_Type) SetDDCR_INTCE_LE(value uint32) {
	volatile.StoreUint32(&o.DDCR.Reg, volatile.LoadUint32(&o.DDCR.Reg)&^(0x200)|value<<9)
}
func (o *VDEC_Type) GetDDCR_INTCE_LE() uint32 {
	return (volatile.LoadUint32(&o.DDCR.Reg) & 0x200) >> 9
}
func (o *VDEC_Type) SetDDCR_DDCGE(value uint32) {
	volatile.StoreUint32(&o.DDCR.Reg, volatile.LoadUint32(&o.DDCR.Reg)&^(0x400)|value<<10)
}
func (o *VDEC_Type) GetDDCR_DDCGE() uint32 {
	return (volatile.LoadUint32(&o.DDCR.Reg) & 0x400) >> 10
}
func (o *VDEC_Type) SetDDCR_LAT_COMP(value uint32) {
	volatile.StoreUint32(&o.DDCR.Reg, volatile.LoadUint32(&o.DDCR.Reg)&^(0x1f800)|value<<11)
}
func (o *VDEC_Type) GetDDCR_LAT_COMP() uint32 {
	return (volatile.LoadUint32(&o.DDCR.Reg) & 0x1f800) >> 11
}
func (o *VDEC_Type) SetDDCR_DOPF(value uint32) {
	volatile.StoreUint32(&o.DDCR.Reg, volatile.LoadUint32(&o.DDCR.Reg)&^(0x20000)|value<<17)
}
func (o *VDEC_Type) GetDDCR_DOPF() uint32 {
	return (volatile.LoadUint32(&o.DDCR.Reg) & 0x20000) >> 17
}
func (o *VDEC_Type) SetDDCR_AHB_BURST(value uint32) {
	volatile.StoreUint32(&o.DDCR.Reg, volatile.LoadUint32(&o.DDCR.Reg)&^(0x40000)|value<<18)
}
func (o *VDEC_Type) GetDDCR_AHB_BURST() uint32 {
	return (volatile.LoadUint32(&o.DDCR.Reg) & 0x40000) >> 18
}
func (o *VDEC_Type) SetDDCR_DI_LE(value uint32) {
	volatile.StoreUint32(&o.DDCR.Reg, volatile.LoadUint32(&o.DDCR.Reg)&^(0x200000)|value<<21)
}
func (o *VDEC_Type) GetDDCR_DI_LE() uint32 {
	return (volatile.LoadUint32(&o.DDCR.Reg) & 0x200000) >> 21
}
func (o *VDEC_Type) SetDDCR_HTI(value uint32) {
	volatile.StoreUint32(&o.DDCR.Reg, volatile.LoadUint32(&o.DDCR.Reg)&^(0x800000)|value<<23)
}
func (o *VDEC_Type) GetDDCR_HTI() uint32 {
	return (volatile.LoadUint32(&o.DDCR.Reg) & 0x800000) >> 23
}

// VDEC.CTLR0: Decoder Control Register 0
func (o *VDEC_Type) SetCTLR0_HLOCK(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x100)|value<<8)
}
func (o *VDEC_Type) GetCTLR0_HLOCK() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x100) >> 8
}
func (o *VDEC_Type) SetCTLR0_REFFIRST(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x800)|value<<11)
}
func (o *VDEC_Type) GetCTLR0_REFFIRST() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x800) >> 11
}
func (o *VDEC_Type) SetCTLR0_MV(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x1000)|value<<12)
}
func (o *VDEC_Type) GetCTLR0_MV() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x1000) >> 12
}
func (o *VDEC_Type) SetCTLR0_QUANT(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x2000)|value<<13)
}
func (o *VDEC_Type) GetCTLR0_QUANT() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x2000) >> 13
}
func (o *VDEC_Type) SetCTLR0_FILTDIS(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x4000)|value<<14)
}
func (o *VDEC_Type) GetCTLR0_FILTDIS() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x4000) >> 14
}
func (o *VDEC_Type) SetCTLR0_OUTDIS(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x8000)|value<<15)
}
func (o *VDEC_Type) GetCTLR0_OUTDIS() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x8000) >> 15
}
func (o *VDEC_Type) SetCTLR0_REFFIELD(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x10000)|value<<16)
}
func (o *VDEC_Type) GetCTLR0_REFFIELD() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x10000) >> 16
}
func (o *VDEC_Type) SetCTLR0_FORWMODE(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x40000)|value<<18)
}
func (o *VDEC_Type) GetCTLR0_FORWMODE() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x40000) >> 18
}
func (o *VDEC_Type) SetCTLR0_PICFIELD(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x80000)|value<<19)
}
func (o *VDEC_Type) GetCTLR0_PICFIELD() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x80000) >> 19
}
func (o *VDEC_Type) SetCTLR0_PICTYPE(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x100000)|value<<20)
}
func (o *VDEC_Type) GetCTLR0_PICTYPE() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x100000) >> 20
}
func (o *VDEC_Type) SetCTLR0_PICBEN(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x200000)|value<<21)
}
func (o *VDEC_Type) GetCTLR0_PICBEN() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x200000) >> 21
}
func (o *VDEC_Type) SetCTLR0_PICSTRUCT(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x400000)|value<<22)
}
func (o *VDEC_Type) GetCTLR0_PICSTRUCT() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x400000) >> 22
}
func (o *VDEC_Type) SetCTLR0_PICMODE(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x800000)|value<<23)
}
func (o *VDEC_Type) GetCTLR0_PICMODE() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x800000) >> 23
}
func (o *VDEC_Type) SetCTLR0_RLCEN(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0x8000000)|value<<27)
}
func (o *VDEC_Type) GetCTLR0_RLCEN() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0x8000000) >> 27
}
func (o *VDEC_Type) SetCTLR0_DEC_MODE(value uint32) {
	volatile.StoreUint32(&o.CTLR0.Reg, volatile.LoadUint32(&o.CTLR0.Reg)&^(0xf0000000)|value<<28)
}
func (o *VDEC_Type) GetCTLR0_DEC_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTLR0.Reg) & 0xf0000000) >> 28
}

// VDEC.CTLR1: Decoder Control Register 1
func (o *VDEC_Type) SetCTLR1_REF_FRAMES(value uint32) {
	volatile.StoreUint32(&o.CTLR1.Reg, volatile.LoadUint32(&o.CTLR1.Reg)&^(0x1f)|value)
}
func (o *VDEC_Type) GetCTLR1_REF_FRAMES() uint32 {
	return volatile.LoadUint32(&o.CTLR1.Reg) & 0x1f
}
func (o *VDEC_Type) SetCTLR1_TOPF(value uint32) {
	volatile.StoreUint32(&o.CTLR1.Reg, volatile.LoadUint32(&o.CTLR1.Reg)&^(0x20)|value<<5)
}
func (o *VDEC_Type) GetCTLR1_TOPF() uint32 {
	return (volatile.LoadUint32(&o.CTLR1.Reg) & 0x20) >> 5
}
func (o *VDEC_Type) SetCTLR1_AVSM(value uint32) {
	volatile.StoreUint32(&o.CTLR1.Reg, volatile.LoadUint32(&o.CTLR1.Reg)&^(0x40)|value<<6)
}
func (o *VDEC_Type) GetCTLR1_AVSM() uint32 {
	return (volatile.LoadUint32(&o.CTLR1.Reg) & 0x40) >> 6
}
func (o *VDEC_Type) SetCTLR1_HEIGHT_OFF(value uint32) {
	volatile.StoreUint32(&o.CTLR1.Reg, volatile.LoadUint32(&o.CTLR1.Reg)&^(0x780)|value<<7)
}
func (o *VDEC_Type) GetCTLR1_HEIGHT_OFF() uint32 {
	return (volatile.LoadUint32(&o.CTLR1.Reg) & 0x780) >> 7
}
func (o *VDEC_Type) SetCTLR1_PIC_HEIGHT(value uint32) {
	volatile.StoreUint32(&o.CTLR1.Reg, volatile.LoadUint32(&o.CTLR1.Reg)&^(0x7f800)|value<<11)
}
func (o *VDEC_Type) GetCTLR1_PIC_HEIGHT() uint32 {
	return (volatile.LoadUint32(&o.CTLR1.Reg) & 0x7f800) >> 11
}
func (o *VDEC_Type) SetCTLR1_WIDTH_OFF(value uint32) {
	volatile.StoreUint32(&o.CTLR1.Reg, volatile.LoadUint32(&o.CTLR1.Reg)&^(0x780000)|value<<19)
}
func (o *VDEC_Type) GetCTLR1_WIDTH_OFF() uint32 {
	return (volatile.LoadUint32(&o.CTLR1.Reg) & 0x780000) >> 19
}
func (o *VDEC_Type) SetCTLR1_PIC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTLR1.Reg, volatile.LoadUint32(&o.CTLR1.Reg)&^(0xff800000)|value<<23)
}
func (o *VDEC_Type) GetCTLR1_PIC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTLR1.Reg) & 0xff800000) >> 23
}

// VDEC.CTLR2: Decoder Control Register 2
func (o *VDEC_Type) SetCTLR2_FIELDPIC(value uint32) {
	volatile.StoreUint32(&o.CTLR2.Reg, volatile.LoadUint32(&o.CTLR2.Reg)&^(0x1)|value)
}
func (o *VDEC_Type) GetCTLR2_FIELDPIC() uint32 {
	return volatile.LoadUint32(&o.CTLR2.Reg) & 0x1
}
func (o *VDEC_Type) SetCTLR2_QP_FILT_CR_OFF(value uint32) {
	volatile.StoreUint32(&o.CTLR2.Reg, volatile.LoadUint32(&o.CTLR2.Reg)&^(0x7c000)|value<<14)
}
func (o *VDEC_Type) GetCTLR2_QP_FILT_CR_OFF() uint32 {
	return (volatile.LoadUint32(&o.CTLR2.Reg) & 0x7c000) >> 14
}
func (o *VDEC_Type) SetCTLR2_QP_FILT_CB_OFF(value uint32) {
	volatile.StoreUint32(&o.CTLR2.Reg, volatile.LoadUint32(&o.CTLR2.Reg)&^(0xf80000)|value<<19)
}
func (o *VDEC_Type) GetCTLR2_QP_FILT_CB_OFF() uint32 {
	return (volatile.LoadUint32(&o.CTLR2.Reg) & 0xf80000) >> 19
}
func (o *VDEC_Type) SetCTLR2_STREAM_START_BIT(value uint32) {
	volatile.StoreUint32(&o.CTLR2.Reg, volatile.LoadUint32(&o.CTLR2.Reg)&^(0xfc000000)|value<<26)
}
func (o *VDEC_Type) GetCTLR2_STREAM_START_BIT() uint32 {
	return (volatile.LoadUint32(&o.CTLR2.Reg) & 0xfc000000) >> 26
}

// VDEC.CTLR3: Decoder Control Register 3
func (o *VDEC_Type) SetCTLR3_STREAM_LEN(value uint32) {
	volatile.StoreUint32(&o.CTLR3.Reg, volatile.LoadUint32(&o.CTLR3.Reg)&^(0xffffff)|value)
}
func (o *VDEC_Type) GetCTLR3_STREAM_LEN() uint32 {
	return volatile.LoadUint32(&o.CTLR3.Reg) & 0xffffff
}
func (o *VDEC_Type) SetCTLR3_INIT_QP(value uint32) {
	volatile.StoreUint32(&o.CTLR3.Reg, volatile.LoadUint32(&o.CTLR3.Reg)&^(0x7e000000)|value<<25)
}
func (o *VDEC_Type) GetCTLR3_INIT_QP() uint32 {
	return (volatile.LoadUint32(&o.CTLR3.Reg) & 0x7e000000) >> 25
}
func (o *VDEC_Type) SetCTLR3_ST_COD_EN(value uint32) {
	volatile.StoreUint32(&o.CTLR3.Reg, volatile.LoadUint32(&o.CTLR3.Reg)&^(0x80000000)|value<<31)
}
func (o *VDEC_Type) GetCTLR3_ST_COD_EN() uint32 {
	return (volatile.LoadUint32(&o.CTLR3.Reg) & 0x80000000) >> 31
}

// VDEC.CTLR4: Decoder Control Register 4
func (o *VDEC_Type) SetCTLR4_FRAME_NUM(value uint32) {
	volatile.StoreUint32(&o.CTLR4.Reg, volatile.LoadUint32(&o.CTLR4.Reg)&^(0xffff)|value)
}
func (o *VDEC_Type) GetCTLR4_FRAME_NUM() uint32 {
	return volatile.LoadUint32(&o.CTLR4.Reg) & 0xffff
}
func (o *VDEC_Type) SetCTLR4_FRAME_NUM_LEN(value uint32) {
	volatile.StoreUint32(&o.CTLR4.Reg, volatile.LoadUint32(&o.CTLR4.Reg)&^(0x1f0000)|value<<16)
}
func (o *VDEC_Type) GetCTLR4_FRAME_NUM_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTLR4.Reg) & 0x1f0000) >> 16
}
func (o *VDEC_Type) SetCTLR4_W_BIPR(value uint32) {
	volatile.StoreUint32(&o.CTLR4.Reg, volatile.LoadUint32(&o.CTLR4.Reg)&^(0xc000000)|value<<26)
}
func (o *VDEC_Type) GetCTLR4_W_BIPR() uint32 {
	return (volatile.LoadUint32(&o.CTLR4.Reg) & 0xc000000) >> 26
}
func (o *VDEC_Type) SetCTLR4_W_PRED(value uint32) {
	volatile.StoreUint32(&o.CTLR4.Reg, volatile.LoadUint32(&o.CTLR4.Reg)&^(0x10000000)|value<<28)
}
func (o *VDEC_Type) GetCTLR4_W_PRED() uint32 {
	return (volatile.LoadUint32(&o.CTLR4.Reg) & 0x10000000) >> 28
}
func (o *VDEC_Type) SetCTLR4_DIRMV_PRED(value uint32) {
	volatile.StoreUint32(&o.CTLR4.Reg, volatile.LoadUint32(&o.CTLR4.Reg)&^(0x20000000)|value<<29)
}
func (o *VDEC_Type) GetCTLR4_DIRMV_PRED() uint32 {
	return (volatile.LoadUint32(&o.CTLR4.Reg) & 0x20000000) >> 29
}
func (o *VDEC_Type) SetCTLR4_BW(value uint32) {
	volatile.StoreUint32(&o.CTLR4.Reg, volatile.LoadUint32(&o.CTLR4.Reg)&^(0x40000000)|value<<30)
}
func (o *VDEC_Type) GetCTLR4_BW() uint32 {
	return (volatile.LoadUint32(&o.CTLR4.Reg) & 0x40000000) >> 30
}
func (o *VDEC_Type) SetCTLR4_CABAC(value uint32) {
	volatile.StoreUint32(&o.CTLR4.Reg, volatile.LoadUint32(&o.CTLR4.Reg)&^(0x80000000)|value<<31)
}
func (o *VDEC_Type) GetCTLR4_CABAC() uint32 {
	return (volatile.LoadUint32(&o.CTLR4.Reg) & 0x80000000) >> 31
}

// VDEC.CTLR5: Decoder Control Register 5
func (o *VDEC_Type) SetCTLR5_IDR_PIC_ID(value uint32) {
	volatile.StoreUint32(&o.CTLR5.Reg, volatile.LoadUint32(&o.CTLR5.Reg)&^(0xffff)|value)
}
func (o *VDEC_Type) GetCTLR5_IDR_PIC_ID() uint32 {
	return volatile.LoadUint32(&o.CTLR5.Reg) & 0xffff
}
func (o *VDEC_Type) SetCTLR5_IDREN(value uint32) {
	volatile.StoreUint32(&o.CTLR5.Reg, volatile.LoadUint32(&o.CTLR5.Reg)&^(0x10000)|value<<16)
}
func (o *VDEC_Type) GetCTLR5_IDREN() uint32 {
	return (volatile.LoadUint32(&o.CTLR5.Reg) & 0x10000) >> 16
}
func (o *VDEC_Type) SetCTLR5_REF_PIC_LEN(value uint32) {
	volatile.StoreUint32(&o.CTLR5.Reg, volatile.LoadUint32(&o.CTLR5.Reg)&^(0xffe0000)|value<<17)
}
func (o *VDEC_Type) GetCTLR5_REF_PIC_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTLR5.Reg) & 0xffe0000) >> 17
}
func (o *VDEC_Type) SetCTLR5_EIGHT58(value uint32) {
	volatile.StoreUint32(&o.CTLR5.Reg, volatile.LoadUint32(&o.CTLR5.Reg)&^(0x10000000)|value<<28)
}
func (o *VDEC_Type) GetCTLR5_EIGHT58() uint32 {
	return (volatile.LoadUint32(&o.CTLR5.Reg) & 0x10000000) >> 28
}
func (o *VDEC_Type) SetCTLR5_RD_PIC(value uint32) {
	volatile.StoreUint32(&o.CTLR5.Reg, volatile.LoadUint32(&o.CTLR5.Reg)&^(0x20000000)|value<<29)
}
func (o *VDEC_Type) GetCTLR5_RD_PIC() uint32 {
	return (volatile.LoadUint32(&o.CTLR5.Reg) & 0x20000000) >> 29
}
func (o *VDEC_Type) SetCTLR5_FILT_CTRL(value uint32) {
	volatile.StoreUint32(&o.CTLR5.Reg, volatile.LoadUint32(&o.CTLR5.Reg)&^(0x40000000)|value<<30)
}
func (o *VDEC_Type) GetCTLR5_FILT_CTRL() uint32 {
	return (volatile.LoadUint32(&o.CTLR5.Reg) & 0x40000000) >> 30
}
func (o *VDEC_Type) SetCTLR5_CONS_INTRA(value uint32) {
	volatile.StoreUint32(&o.CTLR5.Reg, volatile.LoadUint32(&o.CTLR5.Reg)&^(0x80000000)|value<<31)
}
func (o *VDEC_Type) GetCTLR5_CONS_INTRA() uint32 {
	return (volatile.LoadUint32(&o.CTLR5.Reg) & 0x80000000) >> 31
}

// VDEC.CTLR6: Decoder Control Register 6
func (o *VDEC_Type) SetCTLR6_POC_LEN(value uint32) {
	volatile.StoreUint32(&o.CTLR6.Reg, volatile.LoadUint32(&o.CTLR6.Reg)&^(0xff)|value)
}
func (o *VDEC_Type) GetCTLR6_POC_LEN() uint32 {
	return volatile.LoadUint32(&o.CTLR6.Reg) & 0xff
}
func (o *VDEC_Type) SetCTLR6_REF_IDX0(value uint32) {
	volatile.StoreUint32(&o.CTLR6.Reg, volatile.LoadUint32(&o.CTLR6.Reg)&^(0x7c000)|value<<14)
}
func (o *VDEC_Type) GetCTLR6_REF_IDX0() uint32 {
	return (volatile.LoadUint32(&o.CTLR6.Reg) & 0x7c000) >> 14
}
func (o *VDEC_Type) SetCTLR6_REF_IDX1(value uint32) {
	volatile.StoreUint32(&o.CTLR6.Reg, volatile.LoadUint32(&o.CTLR6.Reg)&^(0xf80000)|value<<19)
}
func (o *VDEC_Type) GetCTLR6_REF_IDX1() uint32 {
	return (volatile.LoadUint32(&o.CTLR6.Reg) & 0xf80000) >> 19
}
func (o *VDEC_Type) SetCTLR6_PPS_ID(value uint32) {
	volatile.StoreUint32(&o.CTLR6.Reg, volatile.LoadUint32(&o.CTLR6.Reg)&^(0xff000000)|value<<24)
}
func (o *VDEC_Type) GetCTLR6_PPS_ID() uint32 {
	return (volatile.LoadUint32(&o.CTLR6.Reg) & 0xff000000) >> 24
}

// VDEC.DMVBA: Base Address for Differential Motion Vector
func (o *VDEC_Type) SetDMVBA_MV_CONTROL_BASE(value uint32) {
	volatile.StoreUint32(&o.DMVBA.Reg, volatile.LoadUint32(&o.DMVBA.Reg)&^(0xfffffffc)|value<<2)
}
func (o *VDEC_Type) GetDMVBA_MV_CONTROL_BASE() uint32 {
	return (volatile.LoadUint32(&o.DMVBA.Reg) & 0xfffffffc) >> 2
}

// VDEC.CTLR7: Decoder Control Register 7
func (o *VDEC_Type) SetCTLR7_BA(value uint32) {
	volatile.StoreUint32(&o.CTLR7.Reg, volatile.LoadUint32(&o.CTLR7.Reg)&^(0xfffffffc)|value<<2)
}
func (o *VDEC_Type) GetCTLR7_BA() uint32 {
	return (volatile.LoadUint32(&o.CTLR7.Reg) & 0xfffffffc) >> 2
}

// VDEC.RLCVLCBA: RLC/VLC Data Base Address
func (o *VDEC_Type) SetRLCVLCBA_BA(value uint32) {
	volatile.StoreUint32(&o.RLCVLCBA.Reg, volatile.LoadUint32(&o.RLCVLCBA.Reg)&^(0xfffffffc)|value<<2)
}
func (o *VDEC_Type) GetRLCVLCBA_BA() uint32 {
	return (volatile.LoadUint32(&o.RLCVLCBA.Reg) & 0xfffffffc) >> 2
}

// VDEC.PICTBA: Decoded Picture Base Address
func (o *VDEC_Type) SetPICTBA_BA(value uint32) {
	volatile.StoreUint32(&o.PICTBA.Reg, volatile.LoadUint32(&o.PICTBA.Reg)&^(0xfffffffc)|value<<2)
}
func (o *VDEC_Type) GetPICTBA_BA() uint32 {
	return (volatile.LoadUint32(&o.PICTBA.Reg) & 0xfffffffc) >> 2
}

// VDEC.PIDXBA: Reference Picture Index 0 Base Address
func (o *VDEC_Type) SetPIDXBA_BA(idx int, value uint32) {
	volatile.StoreUint32(&o.PIDXBA[idx].Reg, volatile.LoadUint32(&o.PIDXBA[idx].Reg)&^(0xfffffffc)|value<<2)
}
func (o *VDEC_Type) GetPIDXBA_BA(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIDXBA[idx].Reg) & 0xfffffffc) >> 2
}

// VDEC.PNR0: Reference Picture Numbers Register 0
func (o *VDEC_Type) SetPNR0_REFER0(value uint32) {
	volatile.StoreUint32(&o.PNR0.Reg, volatile.LoadUint32(&o.PNR0.Reg)&^(0xffff)|value)
}
func (o *VDEC_Type) GetPNR0_REFER0() uint32 {
	return volatile.LoadUint32(&o.PNR0.Reg) & 0xffff
}
func (o *VDEC_Type) SetPNR0_REFER1(value uint32) {
	volatile.StoreUint32(&o.PNR0.Reg, volatile.LoadUint32(&o.PNR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *VDEC_Type) GetPNR0_REFER1() uint32 {
	return (volatile.LoadUint32(&o.PNR0.Reg) & 0xffff0000) >> 16
}

// VDEC.PNR1: Reference Picture Numbers Register 1
func (o *VDEC_Type) SetPNR1_REFER2(value uint32) {
	volatile.StoreUint32(&o.PNR1.Reg, volatile.LoadUint32(&o.PNR1.Reg)&^(0xffff)|value)
}
func (o *VDEC_Type) GetPNR1_REFER2() uint32 {
	return volatile.LoadUint32(&o.PNR1.Reg) & 0xffff
}
func (o *VDEC_Type) SetPNR1_REFER3(value uint32) {
	volatile.StoreUint32(&o.PNR1.Reg, volatile.LoadUint32(&o.PNR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *VDEC_Type) GetPNR1_REFER3() uint32 {
	return (volatile.LoadUint32(&o.PNR1.Reg) & 0xffff0000) >> 16
}

// VDEC.PNR3: Reference Picture Numbers Register 3
func (o *VDEC_Type) SetPNR3_REFER4(value uint32) {
	volatile.StoreUint32(&o.PNR3.Reg, volatile.LoadUint32(&o.PNR3.Reg)&^(0xffff)|value)
}
func (o *VDEC_Type) GetPNR3_REFER4() uint32 {
	return volatile.LoadUint32(&o.PNR3.Reg) & 0xffff
}
func (o *VDEC_Type) SetPNR3_REFER5(value uint32) {
	volatile.StoreUint32(&o.PNR3.Reg, volatile.LoadUint32(&o.PNR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *VDEC_Type) GetPNR3_REFER5() uint32 {
	return (volatile.LoadUint32(&o.PNR3.Reg) & 0xffff0000) >> 16
}

// VDEC.PNR4: Reference Picture Numbers Register 4
func (o *VDEC_Type) SetPNR4_REFER8(value uint32) {
	volatile.StoreUint32(&o.PNR4.Reg, volatile.LoadUint32(&o.PNR4.Reg)&^(0xffff)|value)
}
func (o *VDEC_Type) GetPNR4_REFER8() uint32 {
	return volatile.LoadUint32(&o.PNR4.Reg) & 0xffff
}
func (o *VDEC_Type) SetPNR4_REFER9(value uint32) {
	volatile.StoreUint32(&o.PNR4.Reg, volatile.LoadUint32(&o.PNR4.Reg)&^(0xffff0000)|value<<16)
}
func (o *VDEC_Type) GetPNR4_REFER9() uint32 {
	return (volatile.LoadUint32(&o.PNR4.Reg) & 0xffff0000) >> 16
}

// VDEC.PNR5: Reference Picture Numbers Register 5
func (o *VDEC_Type) SetPNR5_REFER10(value uint32) {
	volatile.StoreUint32(&o.PNR5.Reg, volatile.LoadUint32(&o.PNR5.Reg)&^(0xffff)|value)
}
func (o *VDEC_Type) GetPNR5_REFER10() uint32 {
	return volatile.LoadUint32(&o.PNR5.Reg) & 0xffff
}
func (o *VDEC_Type) SetPNR5_REFER11(value uint32) {
	volatile.StoreUint32(&o.PNR5.Reg, volatile.LoadUint32(&o.PNR5.Reg)&^(0xffff0000)|value<<16)
}
func (o *VDEC_Type) GetPNR5_REFER11() uint32 {
	return (volatile.LoadUint32(&o.PNR5.Reg) & 0xffff0000) >> 16
}

// VDEC.PNR6: Reference Picture Numbers Register 6
func (o *VDEC_Type) SetPNR6_REFER12(value uint32) {
	volatile.StoreUint32(&o.PNR6.Reg, volatile.LoadUint32(&o.PNR6.Reg)&^(0xffff)|value)
}
func (o *VDEC_Type) GetPNR6_REFER12() uint32 {
	return volatile.LoadUint32(&o.PNR6.Reg) & 0xffff
}
func (o *VDEC_Type) SetPNR6_REFER13(value uint32) {
	volatile.StoreUint32(&o.PNR6.Reg, volatile.LoadUint32(&o.PNR6.Reg)&^(0xffff0000)|value<<16)
}
func (o *VDEC_Type) GetPNR6_REFER13() uint32 {
	return (volatile.LoadUint32(&o.PNR6.Reg) & 0xffff0000) >> 16
}

// VDEC.PNR7: Reference Picture Numbers Register 7
func (o *VDEC_Type) SetPNR7_REFER14(value uint32) {
	volatile.StoreUint32(&o.PNR7.Reg, volatile.LoadUint32(&o.PNR7.Reg)&^(0xffff)|value)
}
func (o *VDEC_Type) GetPNR7_REFER14() uint32 {
	return volatile.LoadUint32(&o.PNR7.Reg) & 0xffff
}
func (o *VDEC_Type) SetPNR7_REFER15(value uint32) {
	volatile.StoreUint32(&o.PNR7.Reg, volatile.LoadUint32(&o.PNR7.Reg)&^(0xffff0000)|value<<16)
}
func (o *VDEC_Type) GetPNR7_REFER15() uint32 {
	return (volatile.LoadUint32(&o.PNR7.Reg) & 0xffff0000) >> 16
}

// VDEC.PLTFR: Reference Picture Long Term Flag Register
func (o *VDEC_Type) SetPLTFR(value uint32) {
	volatile.StoreUint32(&o.PLTFR.Reg, value)
}
func (o *VDEC_Type) GetPLTFR() uint32 {
	return volatile.LoadUint32(&o.PLTFR.Reg)
}

// VDEC.SDTBA: Standard Dependent Tables Base Address
func (o *VDEC_Type) SetSDTBA_BA(value uint32) {
	volatile.StoreUint32(&o.SDTBA.Reg, volatile.LoadUint32(&o.SDTBA.Reg)&^(0xfffffffc)|value<<2)
}
func (o *VDEC_Type) GetSDTBA_BA() uint32 {
	return (volatile.LoadUint32(&o.SDTBA.Reg) & 0xfffffffc) >> 2
}

// VDEC.DMMVBA: Direct Mode Motion Vector Base Address
func (o *VDEC_Type) SetDMMVBA_BA(value uint32) {
	volatile.StoreUint32(&o.DMMVBA.Reg, volatile.LoadUint32(&o.DMMVBA.Reg)&^(0xfffffffc)|value<<2)
}
func (o *VDEC_Type) GetDMMVBA_BA() uint32 {
	return (volatile.LoadUint32(&o.DMMVBA.Reg) & 0xfffffffc) >> 2
}

// VDEC.IRPLR0: H264 Initial Reference Picture List Register 0
func (o *VDEC_Type) SetIRPLR0_IREFL_FW0(value uint32) {
	volatile.StoreUint32(&o.IRPLR0.Reg, volatile.LoadUint32(&o.IRPLR0.Reg)&^(0x1f)|value)
}
func (o *VDEC_Type) GetIRPLR0_IREFL_FW0() uint32 {
	return volatile.LoadUint32(&o.IRPLR0.Reg) & 0x1f
}
func (o *VDEC_Type) SetIRPLR0_IREFL_BW0(value uint32) {
	volatile.StoreUint32(&o.IRPLR0.Reg, volatile.LoadUint32(&o.IRPLR0.Reg)&^(0x3e0)|value<<5)
}
func (o *VDEC_Type) GetIRPLR0_IREFL_BW0() uint32 {
	return (volatile.LoadUint32(&o.IRPLR0.Reg) & 0x3e0) >> 5
}
func (o *VDEC_Type) SetIRPLR0_IREFL_FW1(value uint32) {
	volatile.StoreUint32(&o.IRPLR0.Reg, volatile.LoadUint32(&o.IRPLR0.Reg)&^(0x7c00)|value<<10)
}
func (o *VDEC_Type) GetIRPLR0_IREFL_FW1() uint32 {
	return (volatile.LoadUint32(&o.IRPLR0.Reg) & 0x7c00) >> 10
}
func (o *VDEC_Type) SetIRPLR0_IREFL_BW1(value uint32) {
	volatile.StoreUint32(&o.IRPLR0.Reg, volatile.LoadUint32(&o.IRPLR0.Reg)&^(0xf8000)|value<<15)
}
func (o *VDEC_Type) GetIRPLR0_IREFL_BW1() uint32 {
	return (volatile.LoadUint32(&o.IRPLR0.Reg) & 0xf8000) >> 15
}
func (o *VDEC_Type) SetIRPLR0_IREFL_FW2(value uint32) {
	volatile.StoreUint32(&o.IRPLR0.Reg, volatile.LoadUint32(&o.IRPLR0.Reg)&^(0x1f00000)|value<<20)
}
func (o *VDEC_Type) GetIRPLR0_IREFL_FW2() uint32 {
	return (volatile.LoadUint32(&o.IRPLR0.Reg) & 0x1f00000) >> 20
}
func (o *VDEC_Type) SetIRPLR0_IREFL_BW2(value uint32) {
	volatile.StoreUint32(&o.IRPLR0.Reg, volatile.LoadUint32(&o.IRPLR0.Reg)&^(0x3e000000)|value<<25)
}
func (o *VDEC_Type) GetIRPLR0_IREFL_BW2() uint32 {
	return (volatile.LoadUint32(&o.IRPLR0.Reg) & 0x3e000000) >> 25
}

// VDEC.IRPLR1: H264 Initial Reference Picture List Register 1
func (o *VDEC_Type) SetIRPLR1_IREFL_FW3(value uint32) {
	volatile.StoreUint32(&o.IRPLR1.Reg, volatile.LoadUint32(&o.IRPLR1.Reg)&^(0x1f)|value)
}
func (o *VDEC_Type) GetIRPLR1_IREFL_FW3() uint32 {
	return volatile.LoadUint32(&o.IRPLR1.Reg) & 0x1f
}
func (o *VDEC_Type) SetIRPLR1_IREFL_BW3(value uint32) {
	volatile.StoreUint32(&o.IRPLR1.Reg, volatile.LoadUint32(&o.IRPLR1.Reg)&^(0x3e0)|value<<5)
}
func (o *VDEC_Type) GetIRPLR1_IREFL_BW3() uint32 {
	return (volatile.LoadUint32(&o.IRPLR1.Reg) & 0x3e0) >> 5
}
func (o *VDEC_Type) SetIRPLR1_IREFL_FW4(value uint32) {
	volatile.StoreUint32(&o.IRPLR1.Reg, volatile.LoadUint32(&o.IRPLR1.Reg)&^(0x7c00)|value<<10)
}
func (o *VDEC_Type) GetIRPLR1_IREFL_FW4() uint32 {
	return (volatile.LoadUint32(&o.IRPLR1.Reg) & 0x7c00) >> 10
}
func (o *VDEC_Type) SetIRPLR1_IREFL_BW4(value uint32) {
	volatile.StoreUint32(&o.IRPLR1.Reg, volatile.LoadUint32(&o.IRPLR1.Reg)&^(0xf8000)|value<<15)
}
func (o *VDEC_Type) GetIRPLR1_IREFL_BW4() uint32 {
	return (volatile.LoadUint32(&o.IRPLR1.Reg) & 0xf8000) >> 15
}
func (o *VDEC_Type) SetIRPLR1_IREFL_FW5(value uint32) {
	volatile.StoreUint32(&o.IRPLR1.Reg, volatile.LoadUint32(&o.IRPLR1.Reg)&^(0x1f00000)|value<<20)
}
func (o *VDEC_Type) GetIRPLR1_IREFL_FW5() uint32 {
	return (volatile.LoadUint32(&o.IRPLR1.Reg) & 0x1f00000) >> 20
}
func (o *VDEC_Type) SetIRPLR1_IREFL_BW5(value uint32) {
	volatile.StoreUint32(&o.IRPLR1.Reg, volatile.LoadUint32(&o.IRPLR1.Reg)&^(0x3e000000)|value<<25)
}
func (o *VDEC_Type) GetIRPLR1_IREFL_BW5() uint32 {
	return (volatile.LoadUint32(&o.IRPLR1.Reg) & 0x3e000000) >> 25
}

// VDEC.IRPLR2: H264 Initial Reference Picture List Register 2
func (o *VDEC_Type) SetIRPLR2_IREFL_FW6(value uint32) {
	volatile.StoreUint32(&o.IRPLR2.Reg, volatile.LoadUint32(&o.IRPLR2.Reg)&^(0x1f)|value)
}
func (o *VDEC_Type) GetIRPLR2_IREFL_FW6() uint32 {
	return volatile.LoadUint32(&o.IRPLR2.Reg) & 0x1f
}
func (o *VDEC_Type) SetIRPLR2_IREFL_BW6(value uint32) {
	volatile.StoreUint32(&o.IRPLR2.Reg, volatile.LoadUint32(&o.IRPLR2.Reg)&^(0x3e0)|value<<5)
}
func (o *VDEC_Type) GetIRPLR2_IREFL_BW6() uint32 {
	return (volatile.LoadUint32(&o.IRPLR2.Reg) & 0x3e0) >> 5
}
func (o *VDEC_Type) SetIRPLR2_IREFL_FW7(value uint32) {
	volatile.StoreUint32(&o.IRPLR2.Reg, volatile.LoadUint32(&o.IRPLR2.Reg)&^(0x7c00)|value<<10)
}
func (o *VDEC_Type) GetIRPLR2_IREFL_FW7() uint32 {
	return (volatile.LoadUint32(&o.IRPLR2.Reg) & 0x7c00) >> 10
}
func (o *VDEC_Type) SetIRPLR2_IREFL_BW7(value uint32) {
	volatile.StoreUint32(&o.IRPLR2.Reg, volatile.LoadUint32(&o.IRPLR2.Reg)&^(0xf8000)|value<<15)
}
func (o *VDEC_Type) GetIRPLR2_IREFL_BW7() uint32 {
	return (volatile.LoadUint32(&o.IRPLR2.Reg) & 0xf8000) >> 15
}
func (o *VDEC_Type) SetIRPLR2_IREFL_FW8(value uint32) {
	volatile.StoreUint32(&o.IRPLR2.Reg, volatile.LoadUint32(&o.IRPLR2.Reg)&^(0x1f00000)|value<<20)
}
func (o *VDEC_Type) GetIRPLR2_IREFL_FW8() uint32 {
	return (volatile.LoadUint32(&o.IRPLR2.Reg) & 0x1f00000) >> 20
}
func (o *VDEC_Type) SetIRPLR2_IREFL_BW8(value uint32) {
	volatile.StoreUint32(&o.IRPLR2.Reg, volatile.LoadUint32(&o.IRPLR2.Reg)&^(0x3e000000)|value<<25)
}
func (o *VDEC_Type) GetIRPLR2_IREFL_BW8() uint32 {
	return (volatile.LoadUint32(&o.IRPLR2.Reg) & 0x3e000000) >> 25
}

// VDEC.IRPLR3: H264 Initial Reference Picture List Register 3
func (o *VDEC_Type) SetIRPLR3_IREFL_FW9(value uint32) {
	volatile.StoreUint32(&o.IRPLR3.Reg, volatile.LoadUint32(&o.IRPLR3.Reg)&^(0x1f)|value)
}
func (o *VDEC_Type) GetIRPLR3_IREFL_FW9() uint32 {
	return volatile.LoadUint32(&o.IRPLR3.Reg) & 0x1f
}
func (o *VDEC_Type) SetIRPLR3_IREFL_BW9(value uint32) {
	volatile.StoreUint32(&o.IRPLR3.Reg, volatile.LoadUint32(&o.IRPLR3.Reg)&^(0x3e0)|value<<5)
}
func (o *VDEC_Type) GetIRPLR3_IREFL_BW9() uint32 {
	return (volatile.LoadUint32(&o.IRPLR3.Reg) & 0x3e0) >> 5
}
func (o *VDEC_Type) SetIRPLR3_IREFL_FW10(value uint32) {
	volatile.StoreUint32(&o.IRPLR3.Reg, volatile.LoadUint32(&o.IRPLR3.Reg)&^(0x7c00)|value<<10)
}
func (o *VDEC_Type) GetIRPLR3_IREFL_FW10() uint32 {
	return (volatile.LoadUint32(&o.IRPLR3.Reg) & 0x7c00) >> 10
}
func (o *VDEC_Type) SetIRPLR3_IREFL_BW10(value uint32) {
	volatile.StoreUint32(&o.IRPLR3.Reg, volatile.LoadUint32(&o.IRPLR3.Reg)&^(0xf8000)|value<<15)
}
func (o *VDEC_Type) GetIRPLR3_IREFL_BW10() uint32 {
	return (volatile.LoadUint32(&o.IRPLR3.Reg) & 0xf8000) >> 15
}
func (o *VDEC_Type) SetIRPLR3_IREFL_FW11(value uint32) {
	volatile.StoreUint32(&o.IRPLR3.Reg, volatile.LoadUint32(&o.IRPLR3.Reg)&^(0x1f00000)|value<<20)
}
func (o *VDEC_Type) GetIRPLR3_IREFL_FW11() uint32 {
	return (volatile.LoadUint32(&o.IRPLR3.Reg) & 0x1f00000) >> 20
}
func (o *VDEC_Type) SetIRPLR3_IREFL_BW11(value uint32) {
	volatile.StoreUint32(&o.IRPLR3.Reg, volatile.LoadUint32(&o.IRPLR3.Reg)&^(0x3e000000)|value<<25)
}
func (o *VDEC_Type) GetIRPLR3_IREFL_BW11() uint32 {
	return (volatile.LoadUint32(&o.IRPLR3.Reg) & 0x3e000000) >> 25
}

// VDEC.IRPLR4: H264 Initial Reference Picture List Register 4
func (o *VDEC_Type) SetIRPLR4_IREFL_FW12(value uint32) {
	volatile.StoreUint32(&o.IRPLR4.Reg, volatile.LoadUint32(&o.IRPLR4.Reg)&^(0x1f)|value)
}
func (o *VDEC_Type) GetIRPLR4_IREFL_FW12() uint32 {
	return volatile.LoadUint32(&o.IRPLR4.Reg) & 0x1f
}
func (o *VDEC_Type) SetIRPLR4_IREFL_BW12(value uint32) {
	volatile.StoreUint32(&o.IRPLR4.Reg, volatile.LoadUint32(&o.IRPLR4.Reg)&^(0x3e0)|value<<5)
}
func (o *VDEC_Type) GetIRPLR4_IREFL_BW12() uint32 {
	return (volatile.LoadUint32(&o.IRPLR4.Reg) & 0x3e0) >> 5
}
func (o *VDEC_Type) SetIRPLR4_IREFL_FW13(value uint32) {
	volatile.StoreUint32(&o.IRPLR4.Reg, volatile.LoadUint32(&o.IRPLR4.Reg)&^(0x7c00)|value<<10)
}
func (o *VDEC_Type) GetIRPLR4_IREFL_FW13() uint32 {
	return (volatile.LoadUint32(&o.IRPLR4.Reg) & 0x7c00) >> 10
}
func (o *VDEC_Type) SetIRPLR4_IREFL_BW13(value uint32) {
	volatile.StoreUint32(&o.IRPLR4.Reg, volatile.LoadUint32(&o.IRPLR4.Reg)&^(0xf8000)|value<<15)
}
func (o *VDEC_Type) GetIRPLR4_IREFL_BW13() uint32 {
	return (volatile.LoadUint32(&o.IRPLR4.Reg) & 0xf8000) >> 15
}
func (o *VDEC_Type) SetIRPLR4_IREFL_FW14(value uint32) {
	volatile.StoreUint32(&o.IRPLR4.Reg, volatile.LoadUint32(&o.IRPLR4.Reg)&^(0x1f00000)|value<<20)
}
func (o *VDEC_Type) GetIRPLR4_IREFL_FW14() uint32 {
	return (volatile.LoadUint32(&o.IRPLR4.Reg) & 0x1f00000) >> 20
}
func (o *VDEC_Type) SetIRPLR4_IREFL_BW14(value uint32) {
	volatile.StoreUint32(&o.IRPLR4.Reg, volatile.LoadUint32(&o.IRPLR4.Reg)&^(0x3e000000)|value<<25)
}
func (o *VDEC_Type) GetIRPLR4_IREFL_BW14() uint32 {
	return (volatile.LoadUint32(&o.IRPLR4.Reg) & 0x3e000000) >> 25
}

// VDEC.IRPLR5: H264 Initial Reference Picture List Register 5
func (o *VDEC_Type) SetIRPLR5_IREFL_FW15(value uint32) {
	volatile.StoreUint32(&o.IRPLR5.Reg, volatile.LoadUint32(&o.IRPLR5.Reg)&^(0x1f)|value)
}
func (o *VDEC_Type) GetIRPLR5_IREFL_FW15() uint32 {
	return volatile.LoadUint32(&o.IRPLR5.Reg) & 0x1f
}
func (o *VDEC_Type) SetIRPLR5_IREFL_BW15(value uint32) {
	volatile.StoreUint32(&o.IRPLR5.Reg, volatile.LoadUint32(&o.IRPLR5.Reg)&^(0x3e0)|value<<5)
}
func (o *VDEC_Type) GetIRPLR5_IREFL_BW15() uint32 {
	return (volatile.LoadUint32(&o.IRPLR5.Reg) & 0x3e0) >> 5
}

// VDEC.ECR: Error Concealment Register
func (o *VDEC_Type) SetECR_STARTMB_Y(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0x7f8000)|value<<15)
}
func (o *VDEC_Type) GetECR_STARTMB_Y() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0x7f8000) >> 15
}
func (o *VDEC_Type) SetECR_STARTMB_X(value uint32) {
	volatile.StoreUint32(&o.ECR.Reg, volatile.LoadUint32(&o.ECR.Reg)&^(0xff800000)|value<<23)
}
func (o *VDEC_Type) GetECR_STARTMB_X() uint32 {
	return (volatile.LoadUint32(&o.ECR.Reg) & 0xff800000) >> 23
}

// USB High Speed Device Port
type UDPHS_Type struct {
	CTRL        volatile.Register32 // 0x0
	FNUM        volatile.Register32 // 0x4
	_           [8]byte
	IEN         volatile.Register32 // 0x10
	INTSTA      volatile.Register32 // 0x14
	CLRINT      volatile.Register32 // 0x18
	EPTRST      volatile.Register32 // 0x1C
	_           [192]byte
	TST         volatile.Register32 // 0xE0
	_           [28]byte
	EPTCFG0     volatile.Register32 // 0x100
	EPTCTLENB0  volatile.Register32 // 0x104
	EPTCTLDIS0  volatile.Register32 // 0x108
	EPTCTL0     volatile.Register32 // 0x10C
	_           [4]byte
	EPTSETSTA0  volatile.Register32 // 0x114
	EPTCLRSTA0  volatile.Register32 // 0x118
	EPTSTA0     volatile.Register32 // 0x11C
	EPTCFG1     volatile.Register32 // 0x120
	EPTCTLENB1  volatile.Register32 // 0x124
	EPTCTLDIS1  volatile.Register32 // 0x128
	EPTCTL1     volatile.Register32 // 0x12C
	_           [4]byte
	EPTSETSTA1  volatile.Register32 // 0x134
	EPTCLRSTA1  volatile.Register32 // 0x138
	EPTSTA1     volatile.Register32 // 0x13C
	EPTCFG2     volatile.Register32 // 0x140
	EPTCTLENB2  volatile.Register32 // 0x144
	EPTCTLDIS2  volatile.Register32 // 0x148
	EPTCTL2     volatile.Register32 // 0x14C
	_           [4]byte
	EPTSETSTA2  volatile.Register32 // 0x154
	EPTCLRSTA2  volatile.Register32 // 0x158
	EPTSTA2     volatile.Register32 // 0x15C
	EPTCFG3     volatile.Register32 // 0x160
	EPTCTLENB3  volatile.Register32 // 0x164
	EPTCTLDIS3  volatile.Register32 // 0x168
	EPTCTL3     volatile.Register32 // 0x16C
	_           [4]byte
	EPTSETSTA3  volatile.Register32 // 0x174
	EPTCLRSTA3  volatile.Register32 // 0x178
	EPTSTA3     volatile.Register32 // 0x17C
	EPTCFG4     volatile.Register32 // 0x180
	EPTCTLENB4  volatile.Register32 // 0x184
	EPTCTLDIS4  volatile.Register32 // 0x188
	EPTCTL4     volatile.Register32 // 0x18C
	_           [4]byte
	EPTSETSTA4  volatile.Register32 // 0x194
	EPTCLRSTA4  volatile.Register32 // 0x198
	EPTSTA4     volatile.Register32 // 0x19C
	EPTCFG5     volatile.Register32 // 0x1A0
	EPTCTLENB5  volatile.Register32 // 0x1A4
	EPTCTLDIS5  volatile.Register32 // 0x1A8
	EPTCTL5     volatile.Register32 // 0x1AC
	_           [4]byte
	EPTSETSTA5  volatile.Register32 // 0x1B4
	EPTCLRSTA5  volatile.Register32 // 0x1B8
	EPTSTA5     volatile.Register32 // 0x1BC
	EPTCFG6     volatile.Register32 // 0x1C0
	EPTCTLENB6  volatile.Register32 // 0x1C4
	EPTCTLDIS6  volatile.Register32 // 0x1C8
	EPTCTL6     volatile.Register32 // 0x1CC
	_           [4]byte
	EPTSETSTA6  volatile.Register32 // 0x1D4
	EPTCLRSTA6  volatile.Register32 // 0x1D8
	EPTSTA6     volatile.Register32 // 0x1DC
	_           [288]byte
	DMANXTDSC0  volatile.Register32 // 0x300
	DMAADDRESS0 volatile.Register32 // 0x304
	DMACONTROL0 volatile.Register32 // 0x308
	DMASTATUS0  volatile.Register32 // 0x30C
	DMANXTDSC1  volatile.Register32 // 0x310
	DMAADDRESS1 volatile.Register32 // 0x314
	DMACONTROL1 volatile.Register32 // 0x318
	DMASTATUS1  volatile.Register32 // 0x31C
	DMANXTDSC2  volatile.Register32 // 0x320
	DMAADDRESS2 volatile.Register32 // 0x324
	DMACONTROL2 volatile.Register32 // 0x328
	DMASTATUS2  volatile.Register32 // 0x32C
	DMANXTDSC3  volatile.Register32 // 0x330
	DMAADDRESS3 volatile.Register32 // 0x334
	DMACONTROL3 volatile.Register32 // 0x338
	DMASTATUS3  volatile.Register32 // 0x33C
	DMANXTDSC4  volatile.Register32 // 0x340
	DMAADDRESS4 volatile.Register32 // 0x344
	DMACONTROL4 volatile.Register32 // 0x348
	DMASTATUS4  volatile.Register32 // 0x34C
	DMANXTDSC5  volatile.Register32 // 0x350
	DMAADDRESS5 volatile.Register32 // 0x354
	DMACONTROL5 volatile.Register32 // 0x358
	DMASTATUS5  volatile.Register32 // 0x35C
}

// UDPHS.CTRL: UDPHS Control Register
func (o *UDPHS_Type) SetCTRL_DEV_ADDR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7f)|value)
}
func (o *UDPHS_Type) GetCTRL_DEV_ADDR() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x7f
}
func (o *UDPHS_Type) SetCTRL_FADDR_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetCTRL_FADDR_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetCTRL_EN_UDPHS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetCTRL_EN_UDPHS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetCTRL_DETACH(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetCTRL_DETACH() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetCTRL_REWAKEUP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetCTRL_REWAKEUP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetCTRL_PULLD_DIS(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetCTRL_PULLD_DIS() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800) >> 11
}

// UDPHS.FNUM: UDPHS Frame Number Register
func (o *UDPHS_Type) SetFNUM_MICRO_FRAME_NUM(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetFNUM_MICRO_FRAME_NUM() uint32 {
	return volatile.LoadUint32(&o.FNUM.Reg) & 0x7
}
func (o *UDPHS_Type) SetFNUM_FRAME_NUMBER(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x3ff8)|value<<3)
}
func (o *UDPHS_Type) GetFNUM_FRAME_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.FNUM.Reg) & 0x3ff8) >> 3
}
func (o *UDPHS_Type) SetFNUM_FNUM_ERR(value uint32) {
	volatile.StoreUint32(&o.FNUM.Reg, volatile.LoadUint32(&o.FNUM.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetFNUM_FNUM_ERR() uint32 {
	return (volatile.LoadUint32(&o.FNUM.Reg) & 0x80000000) >> 31
}

// UDPHS.IEN: UDPHS Interrupt Enable Register
func (o *UDPHS_Type) SetIEN_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetIEN_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetIEN_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetIEN_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetIEN_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetIEN_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetIEN_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetIEN_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetIEN_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetIEN_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetIEN_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetIEN_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetIEN_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetIEN_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetIEN_EPT_0(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetIEN_EPT_0() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetIEN_EPT_1(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetIEN_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetIEN_EPT_2(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetIEN_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetIEN_EPT_3(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetIEN_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetIEN_EPT_4(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetIEN_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetIEN_EPT_5(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetIEN_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetIEN_EPT_6(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetIEN_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetIEN_DMA_1(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x2000000)|value<<25)
}
func (o *UDPHS_Type) GetIEN_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x2000000) >> 25
}
func (o *UDPHS_Type) SetIEN_DMA_2(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x4000000)|value<<26)
}
func (o *UDPHS_Type) GetIEN_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x4000000) >> 26
}
func (o *UDPHS_Type) SetIEN_DMA_3(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x8000000)|value<<27)
}
func (o *UDPHS_Type) GetIEN_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x8000000) >> 27
}
func (o *UDPHS_Type) SetIEN_DMA_4(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x10000000)|value<<28)
}
func (o *UDPHS_Type) GetIEN_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x10000000) >> 28
}
func (o *UDPHS_Type) SetIEN_DMA_5(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x20000000)|value<<29)
}
func (o *UDPHS_Type) GetIEN_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x20000000) >> 29
}
func (o *UDPHS_Type) SetIEN_DMA_6(value uint32) {
	volatile.StoreUint32(&o.IEN.Reg, volatile.LoadUint32(&o.IEN.Reg)&^(0x40000000)|value<<30)
}
func (o *UDPHS_Type) GetIEN_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.IEN.Reg) & 0x40000000) >> 30
}

// UDPHS.INTSTA: UDPHS Interrupt Status Register
func (o *UDPHS_Type) SetINTSTA_SPEED(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetINTSTA_SPEED() uint32 {
	return volatile.LoadUint32(&o.INTSTA.Reg) & 0x1
}
func (o *UDPHS_Type) SetINTSTA_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetINTSTA_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetINTSTA_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetINTSTA_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetINTSTA_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetINTSTA_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetINTSTA_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetINTSTA_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetINTSTA_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetINTSTA_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetINTSTA_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetINTSTA_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetINTSTA_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetINTSTA_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetINTSTA_EPT_0(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetINTSTA_EPT_0() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetINTSTA_EPT_1(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetINTSTA_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetINTSTA_EPT_2(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetINTSTA_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetINTSTA_EPT_3(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetINTSTA_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetINTSTA_EPT_4(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetINTSTA_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetINTSTA_EPT_5(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetINTSTA_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetINTSTA_EPT_6(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetINTSTA_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetINTSTA_DMA_1(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x2000000)|value<<25)
}
func (o *UDPHS_Type) GetINTSTA_DMA_1() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x2000000) >> 25
}
func (o *UDPHS_Type) SetINTSTA_DMA_2(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x4000000)|value<<26)
}
func (o *UDPHS_Type) GetINTSTA_DMA_2() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x4000000) >> 26
}
func (o *UDPHS_Type) SetINTSTA_DMA_3(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x8000000)|value<<27)
}
func (o *UDPHS_Type) GetINTSTA_DMA_3() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x8000000) >> 27
}
func (o *UDPHS_Type) SetINTSTA_DMA_4(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x10000000)|value<<28)
}
func (o *UDPHS_Type) GetINTSTA_DMA_4() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x10000000) >> 28
}
func (o *UDPHS_Type) SetINTSTA_DMA_5(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x20000000)|value<<29)
}
func (o *UDPHS_Type) GetINTSTA_DMA_5() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x20000000) >> 29
}
func (o *UDPHS_Type) SetINTSTA_DMA_6(value uint32) {
	volatile.StoreUint32(&o.INTSTA.Reg, volatile.LoadUint32(&o.INTSTA.Reg)&^(0x40000000)|value<<30)
}
func (o *UDPHS_Type) GetINTSTA_DMA_6() uint32 {
	return (volatile.LoadUint32(&o.INTSTA.Reg) & 0x40000000) >> 30
}

// UDPHS.CLRINT: UDPHS Clear Interrupt Register
func (o *UDPHS_Type) SetCLRINT_DET_SUSPD(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetCLRINT_DET_SUSPD() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetCLRINT_MICRO_SOF(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetCLRINT_MICRO_SOF() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetCLRINT_INT_SOF(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetCLRINT_INT_SOF() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetCLRINT_ENDRESET(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetCLRINT_ENDRESET() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetCLRINT_WAKE_UP(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetCLRINT_WAKE_UP() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetCLRINT_ENDOFRSM(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetCLRINT_ENDOFRSM() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetCLRINT_UPSTR_RES(value uint32) {
	volatile.StoreUint32(&o.CLRINT.Reg, volatile.LoadUint32(&o.CLRINT.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetCLRINT_UPSTR_RES() uint32 {
	return (volatile.LoadUint32(&o.CLRINT.Reg) & 0x80) >> 7
}

// UDPHS.EPTRST: UDPHS Endpoints Reset Register
func (o *UDPHS_Type) SetEPTRST_EPT_0(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTRST_EPT_0() uint32 {
	return volatile.LoadUint32(&o.EPTRST.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTRST_EPT_1(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTRST_EPT_1() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTRST_EPT_2(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetEPTRST_EPT_2() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetEPTRST_EPT_3(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTRST_EPT_3() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTRST_EPT_4(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTRST_EPT_4() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTRST_EPT_5(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTRST_EPT_5() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTRST_EPT_6(value uint32) {
	volatile.StoreUint32(&o.EPTRST.Reg, volatile.LoadUint32(&o.EPTRST.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTRST_EPT_6() uint32 {
	return (volatile.LoadUint32(&o.EPTRST.Reg) & 0x40) >> 6
}

// UDPHS.TST: UDPHS Test Register
func (o *UDPHS_Type) SetTST_SPEED_CFG(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x3)|value)
}
func (o *UDPHS_Type) GetTST_SPEED_CFG() uint32 {
	return volatile.LoadUint32(&o.TST.Reg) & 0x3
}
func (o *UDPHS_Type) SetTST_TST_J(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetTST_TST_J() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetTST_TST_K(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetTST_TST_K() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetTST_TST_PKT(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetTST_TST_PKT() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetTST_OPMODE2(value uint32) {
	volatile.StoreUint32(&o.TST.Reg, volatile.LoadUint32(&o.TST.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetTST_OPMODE2() uint32 {
	return (volatile.LoadUint32(&o.TST.Reg) & 0x20) >> 5
}

// UDPHS.EPTCFG0: UDPHS Endpoint Configuration Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCFG0_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG0_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG0_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG0_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG0_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG0_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG0.Reg, volatile.LoadUint32(&o.EPTCFG0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG0_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB0: UDPHS Endpoint Control Enable Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTLENB0_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB0_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB0.Reg, volatile.LoadUint32(&o.EPTCTLENB0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS0: UDPHS Endpoint Control Disable Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTLDIS0_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS0.Reg, volatile.LoadUint32(&o.EPTCTLDIS0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL0: UDPHS Endpoint Control Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCTL0_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL0_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL0_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL0_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL0_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL0_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL0_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL0_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL0_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL0_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL0.Reg, volatile.LoadUint32(&o.EPTCTL0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA0: UDPHS Endpoint Set Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTSETSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA0.Reg, volatile.LoadUint32(&o.EPTSETSTA0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA0.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA0: UDPHS Endpoint Clear Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTCLRSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA0_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA0.Reg, volatile.LoadUint32(&o.EPTCLRSTA0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA0.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA0: UDPHS Endpoint Status Register (endpoint = 0)
func (o *UDPHS_Type) SetEPTSTA0_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA0_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA0_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA0_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA0_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA0_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA0_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA0_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA0_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA0_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA0_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA0_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA0_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA0_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA0_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA0_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA0_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA0_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA0_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA0_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA0_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA0_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA0_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA0_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA0_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA0_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA0_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA0.Reg, volatile.LoadUint32(&o.EPTSTA0.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA0_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA0.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG1: UDPHS Endpoint Configuration Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCFG1_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG1_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG1_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG1_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG1_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG1_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG1.Reg, volatile.LoadUint32(&o.EPTCFG1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG1_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB1: UDPHS Endpoint Control Enable Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTLENB1_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB1_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB1.Reg, volatile.LoadUint32(&o.EPTCTLENB1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS1: UDPHS Endpoint Control Disable Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTLDIS1_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS1.Reg, volatile.LoadUint32(&o.EPTCTLDIS1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL1: UDPHS Endpoint Control Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCTL1_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL1_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL1_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL1_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL1_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL1_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL1_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL1_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL1_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL1_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL1.Reg, volatile.LoadUint32(&o.EPTCTL1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA1: UDPHS Endpoint Set Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTSETSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA1.Reg, volatile.LoadUint32(&o.EPTSETSTA1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA1.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA1: UDPHS Endpoint Clear Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTCLRSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA1_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA1.Reg, volatile.LoadUint32(&o.EPTCLRSTA1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA1.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA1: UDPHS Endpoint Status Register (endpoint = 1)
func (o *UDPHS_Type) SetEPTSTA1_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA1_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA1_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA1_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA1_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA1_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA1_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA1_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA1_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA1_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA1_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA1_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA1_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA1_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA1_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA1_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA1_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA1_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA1_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA1_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA1_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA1_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA1_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA1_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA1_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA1_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA1_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA1.Reg, volatile.LoadUint32(&o.EPTSTA1.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA1_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA1.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG2: UDPHS Endpoint Configuration Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCFG2_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG2_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG2_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG2_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG2_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG2_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG2.Reg, volatile.LoadUint32(&o.EPTCFG2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG2_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB2: UDPHS Endpoint Control Enable Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTLENB2_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB2_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB2.Reg, volatile.LoadUint32(&o.EPTCTLENB2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS2: UDPHS Endpoint Control Disable Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTLDIS2_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS2.Reg, volatile.LoadUint32(&o.EPTCTLDIS2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL2: UDPHS Endpoint Control Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCTL2_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL2_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL2_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL2_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL2_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL2_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL2_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL2_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL2_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL2_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL2.Reg, volatile.LoadUint32(&o.EPTCTL2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA2: UDPHS Endpoint Set Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTSETSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA2.Reg, volatile.LoadUint32(&o.EPTSETSTA2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA2.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA2: UDPHS Endpoint Clear Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTCLRSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA2_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA2.Reg, volatile.LoadUint32(&o.EPTCLRSTA2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA2.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA2: UDPHS Endpoint Status Register (endpoint = 2)
func (o *UDPHS_Type) SetEPTSTA2_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA2_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA2_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA2_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA2_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA2_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA2_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA2_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA2_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA2_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA2_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA2_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA2_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA2_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA2_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA2_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA2_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA2_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA2_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA2_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA2_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA2_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA2_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA2_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA2_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA2_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA2_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA2.Reg, volatile.LoadUint32(&o.EPTSTA2.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA2_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA2.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG3: UDPHS Endpoint Configuration Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCFG3_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG3_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG3_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG3_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG3_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG3_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG3.Reg, volatile.LoadUint32(&o.EPTCFG3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG3_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB3: UDPHS Endpoint Control Enable Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTLENB3_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB3_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB3.Reg, volatile.LoadUint32(&o.EPTCTLENB3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS3: UDPHS Endpoint Control Disable Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTLDIS3_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS3.Reg, volatile.LoadUint32(&o.EPTCTLDIS3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL3: UDPHS Endpoint Control Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCTL3_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL3_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL3_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL3_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL3_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL3_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL3_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL3_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL3_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL3_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL3.Reg, volatile.LoadUint32(&o.EPTCTL3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA3: UDPHS Endpoint Set Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTSETSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA3.Reg, volatile.LoadUint32(&o.EPTSETSTA3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA3.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA3: UDPHS Endpoint Clear Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTCLRSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA3_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA3.Reg, volatile.LoadUint32(&o.EPTCLRSTA3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA3.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA3: UDPHS Endpoint Status Register (endpoint = 3)
func (o *UDPHS_Type) SetEPTSTA3_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA3_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA3_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA3_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA3_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA3_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA3_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA3_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA3_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA3_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA3_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA3_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA3_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA3_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA3_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA3_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA3_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA3_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA3_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA3_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA3_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA3_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA3_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA3_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA3_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA3_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA3_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA3.Reg, volatile.LoadUint32(&o.EPTSTA3.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA3_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA3.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG4: UDPHS Endpoint Configuration Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCFG4_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG4_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG4_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG4_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG4_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG4_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG4.Reg, volatile.LoadUint32(&o.EPTCFG4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG4_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB4: UDPHS Endpoint Control Enable Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTLENB4_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB4_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB4.Reg, volatile.LoadUint32(&o.EPTCTLENB4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS4: UDPHS Endpoint Control Disable Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTLDIS4_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS4.Reg, volatile.LoadUint32(&o.EPTCTLDIS4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL4: UDPHS Endpoint Control Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCTL4_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL4_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL4_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL4_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL4_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL4_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL4_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL4_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL4_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL4_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL4.Reg, volatile.LoadUint32(&o.EPTCTL4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA4: UDPHS Endpoint Set Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTSETSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA4.Reg, volatile.LoadUint32(&o.EPTSETSTA4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA4.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA4: UDPHS Endpoint Clear Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTCLRSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA4_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA4.Reg, volatile.LoadUint32(&o.EPTCLRSTA4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA4.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA4: UDPHS Endpoint Status Register (endpoint = 4)
func (o *UDPHS_Type) SetEPTSTA4_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA4_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA4_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA4_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA4_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA4_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA4_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA4_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA4_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA4_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA4_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA4_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA4_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA4_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA4_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA4_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA4_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA4_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA4_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA4_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA4_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA4_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA4_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA4_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA4_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA4_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA4_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA4.Reg, volatile.LoadUint32(&o.EPTSTA4.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA4_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA4.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG5: UDPHS Endpoint Configuration Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCFG5_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG5_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG5_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG5_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG5_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG5_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG5.Reg, volatile.LoadUint32(&o.EPTCFG5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG5_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB5: UDPHS Endpoint Control Enable Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTLENB5_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB5_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB5.Reg, volatile.LoadUint32(&o.EPTCTLENB5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS5: UDPHS Endpoint Control Disable Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTLDIS5_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS5.Reg, volatile.LoadUint32(&o.EPTCTLDIS5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL5: UDPHS Endpoint Control Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCTL5_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL5_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL5_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL5_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL5_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL5_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL5_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL5_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL5_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL5_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL5.Reg, volatile.LoadUint32(&o.EPTCTL5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA5: UDPHS Endpoint Set Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTSETSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA5.Reg, volatile.LoadUint32(&o.EPTSETSTA5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA5.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA5: UDPHS Endpoint Clear Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTCLRSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA5_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA5.Reg, volatile.LoadUint32(&o.EPTCLRSTA5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA5.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA5: UDPHS Endpoint Status Register (endpoint = 5)
func (o *UDPHS_Type) SetEPTSTA5_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA5_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA5_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA5_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA5_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA5_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA5_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA5_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA5_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA5_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA5_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA5_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA5_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA5_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA5_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA5_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA5_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA5_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA5_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA5_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA5_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA5_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA5_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA5_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA5_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA5_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA5_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA5.Reg, volatile.LoadUint32(&o.EPTSTA5.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA5_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA5.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCFG6: UDPHS Endpoint Configuration Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCFG6_EPT_SIZE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x7)|value)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_SIZE() uint32 {
	return volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x7
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_DIR(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_DIR() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_TYPE(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x30)|value<<4)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x30) >> 4
}
func (o *UDPHS_Type) SetEPTCFG6_BK_NUMBER(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTCFG6_BK_NUMBER() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTCFG6_NB_TRANS(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x300)|value<<8)
}
func (o *UDPHS_Type) GetEPTCFG6_NB_TRANS() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x300) >> 8
}
func (o *UDPHS_Type) SetEPTCFG6_EPT_MAPD(value uint32) {
	volatile.StoreUint32(&o.EPTCFG6.Reg, volatile.LoadUint32(&o.EPTCFG6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCFG6_EPT_MAPD() uint32 {
	return (volatile.LoadUint32(&o.EPTCFG6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLENB6: UDPHS Endpoint Control Enable Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTLENB6_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLENB6_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLENB6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLENB6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLENB6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLENB6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLENB6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLENB6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLENB6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLENB6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLENB6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLENB6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLENB6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLENB6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLENB6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLENB6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLENB6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLENB6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLENB6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLENB6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLENB6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLENB6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLENB6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLENB6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLENB6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLENB6.Reg, volatile.LoadUint32(&o.EPTCTLENB6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLENB6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLENB6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTLDIS6: UDPHS Endpoint Control Disable Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTLDIS6_EPT_DISABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_EPT_DISABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTLDIS6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTLDIS6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTLDIS6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTLDIS6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTLDIS6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTLDIS6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTLDIS6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTLDIS6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTLDIS6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTLDIS6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTLDIS6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTLDIS6.Reg, volatile.LoadUint32(&o.EPTCTLDIS6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTLDIS6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTLDIS6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTCTL6: UDPHS Endpoint Control Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCTL6_EPT_ENABL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetEPTCTL6_EPT_ENABL() uint32 {
	return volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x1
}
func (o *UDPHS_Type) SetEPTCTL6_AUTO_VALID(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetEPTCTL6_AUTO_VALID() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetEPTCTL6_INTDIS_DMA(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetEPTCTL6_INTDIS_DMA() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetEPTCTL6_NYET_DIS(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetEPTCTL6_NYET_DIS() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetEPTCTL6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTCTL6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTCTL6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCTL6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCTL6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCTL6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCTL6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTCTL6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTCTL6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCTL6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCTL6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCTL6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCTL6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCTL6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCTL6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCTL6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTCTL6_BUSY_BANK(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x40000)|value<<18)
}
func (o *UDPHS_Type) GetEPTCTL6_BUSY_BANK() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x40000) >> 18
}
func (o *UDPHS_Type) SetEPTCTL6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTCTL6.Reg, volatile.LoadUint32(&o.EPTCTL6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTCTL6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTCTL6.Reg) & 0x80000000) >> 31
}

// UDPHS.EPTSETSTA6: UDPHS Endpoint Set Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTSETSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSETSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSETSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSETSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSETSTA6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSETSTA6.Reg, volatile.LoadUint32(&o.EPTSETSTA6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSETSTA6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSETSTA6.Reg) & 0x800) >> 11
}

// UDPHS.EPTCLRSTA6: UDPHS Endpoint Clear Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTCLRSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTCLRSTA6_TOGGLESQ(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_TOGGLESQ() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetEPTCLRSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTCLRSTA6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTCLRSTA6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTCLRSTA6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTCLRSTA6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTCLRSTA6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTCLRSTA6.Reg, volatile.LoadUint32(&o.EPTCLRSTA6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTCLRSTA6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTCLRSTA6.Reg) & 0x8000) >> 15
}

// UDPHS.EPTSTA6: UDPHS Endpoint Status Register (endpoint = 6)
func (o *UDPHS_Type) SetEPTSTA6_FRCESTALL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetEPTSTA6_FRCESTALL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetEPTSTA6_TOGGLESQ_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0xc0)|value<<6)
}
func (o *UDPHS_Type) GetEPTSTA6_TOGGLESQ_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0xc0) >> 6
}
func (o *UDPHS_Type) SetEPTSTA6_ERR_OVFLW(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x100)|value<<8)
}
func (o *UDPHS_Type) GetEPTSTA6_ERR_OVFLW() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x100) >> 8
}
func (o *UDPHS_Type) SetEPTSTA6_RXRDY_TXKL(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x200)|value<<9)
}
func (o *UDPHS_Type) GetEPTSTA6_RXRDY_TXKL() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x200) >> 9
}
func (o *UDPHS_Type) SetEPTSTA6_TX_COMPLT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x400)|value<<10)
}
func (o *UDPHS_Type) GetEPTSTA6_TX_COMPLT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x400) >> 10
}
func (o *UDPHS_Type) SetEPTSTA6_TXRDY(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x800)|value<<11)
}
func (o *UDPHS_Type) GetEPTSTA6_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x800) >> 11
}
func (o *UDPHS_Type) SetEPTSTA6_RX_SETUP(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x1000)|value<<12)
}
func (o *UDPHS_Type) GetEPTSTA6_RX_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x1000) >> 12
}
func (o *UDPHS_Type) SetEPTSTA6_STALL_SNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x2000)|value<<13)
}
func (o *UDPHS_Type) GetEPTSTA6_STALL_SNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x2000) >> 13
}
func (o *UDPHS_Type) SetEPTSTA6_NAK_IN(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x4000)|value<<14)
}
func (o *UDPHS_Type) GetEPTSTA6_NAK_IN() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x4000) >> 14
}
func (o *UDPHS_Type) SetEPTSTA6_NAK_OUT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x8000)|value<<15)
}
func (o *UDPHS_Type) GetEPTSTA6_NAK_OUT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x8000) >> 15
}
func (o *UDPHS_Type) SetEPTSTA6_CURBK_CTLDIR(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x30000)|value<<16)
}
func (o *UDPHS_Type) GetEPTSTA6_CURBK_CTLDIR() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x30000) >> 16
}
func (o *UDPHS_Type) SetEPTSTA6_BUSY_BANK_STA(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0xc0000)|value<<18)
}
func (o *UDPHS_Type) GetEPTSTA6_BUSY_BANK_STA() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0xc0000) >> 18
}
func (o *UDPHS_Type) SetEPTSTA6_BYTE_COUNT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x7ff00000)|value<<20)
}
func (o *UDPHS_Type) GetEPTSTA6_BYTE_COUNT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x7ff00000) >> 20
}
func (o *UDPHS_Type) SetEPTSTA6_SHRT_PCKT(value uint32) {
	volatile.StoreUint32(&o.EPTSTA6.Reg, volatile.LoadUint32(&o.EPTSTA6.Reg)&^(0x80000000)|value<<31)
}
func (o *UDPHS_Type) GetEPTSTA6_SHRT_PCKT() uint32 {
	return (volatile.LoadUint32(&o.EPTSTA6.Reg) & 0x80000000) >> 31
}

// UDPHS.DMANXTDSC0: UDPHS DMA Next Descriptor Address Register (channel = 0)
func (o *UDPHS_Type) SetDMANXTDSC0(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC0.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC0() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC0.Reg)
}

// UDPHS.DMAADDRESS0: UDPHS DMA Channel Address Register (channel = 0)
func (o *UDPHS_Type) SetDMAADDRESS0(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS0.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS0() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS0.Reg)
}

// UDPHS.DMACONTROL0: UDPHS DMA Channel Control Register (channel = 0)
func (o *UDPHS_Type) SetDMACONTROL0_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL0_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL0_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL0_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL0_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL0_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL0_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL0_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL0_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL0_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL0_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL0_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL0_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL0_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL0.Reg, volatile.LoadUint32(&o.DMACONTROL0.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL0_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL0.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS0: UDPHS DMA Channel Status Register (channel = 0)
func (o *UDPHS_Type) SetDMASTATUS0_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS0_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS0_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS0_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS0_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS0_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS0_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS0_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS0_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS0_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS0_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS0.Reg, volatile.LoadUint32(&o.DMASTATUS0.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS0_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS0.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC1: UDPHS DMA Next Descriptor Address Register (channel = 1)
func (o *UDPHS_Type) SetDMANXTDSC1(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC1.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC1() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC1.Reg)
}

// UDPHS.DMAADDRESS1: UDPHS DMA Channel Address Register (channel = 1)
func (o *UDPHS_Type) SetDMAADDRESS1(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS1.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS1() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS1.Reg)
}

// UDPHS.DMACONTROL1: UDPHS DMA Channel Control Register (channel = 1)
func (o *UDPHS_Type) SetDMACONTROL1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL1_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL1_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL1_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL1_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL1_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL1_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL1_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL1_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL1_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL1_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL1_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL1_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL1.Reg, volatile.LoadUint32(&o.DMACONTROL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL1_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL1.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS1: UDPHS DMA Channel Status Register (channel = 1)
func (o *UDPHS_Type) SetDMASTATUS1_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS1_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS1_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS1_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS1_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS1_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS1_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS1_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS1_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS1_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS1_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS1.Reg, volatile.LoadUint32(&o.DMASTATUS1.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS1_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS1.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC2: UDPHS DMA Next Descriptor Address Register (channel = 2)
func (o *UDPHS_Type) SetDMANXTDSC2(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC2.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC2() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC2.Reg)
}

// UDPHS.DMAADDRESS2: UDPHS DMA Channel Address Register (channel = 2)
func (o *UDPHS_Type) SetDMAADDRESS2(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS2.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS2() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS2.Reg)
}

// UDPHS.DMACONTROL2: UDPHS DMA Channel Control Register (channel = 2)
func (o *UDPHS_Type) SetDMACONTROL2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL2_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL2_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL2_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL2_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL2_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL2_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL2_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL2_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL2_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL2_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL2_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL2_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL2.Reg, volatile.LoadUint32(&o.DMACONTROL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL2_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL2.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS2: UDPHS DMA Channel Status Register (channel = 2)
func (o *UDPHS_Type) SetDMASTATUS2_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS2_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS2_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS2_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS2_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS2_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS2_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS2_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS2_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS2_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS2_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS2.Reg, volatile.LoadUint32(&o.DMASTATUS2.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS2_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS2.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC3: UDPHS DMA Next Descriptor Address Register (channel = 3)
func (o *UDPHS_Type) SetDMANXTDSC3(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC3.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC3() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC3.Reg)
}

// UDPHS.DMAADDRESS3: UDPHS DMA Channel Address Register (channel = 3)
func (o *UDPHS_Type) SetDMAADDRESS3(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS3.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS3() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS3.Reg)
}

// UDPHS.DMACONTROL3: UDPHS DMA Channel Control Register (channel = 3)
func (o *UDPHS_Type) SetDMACONTROL3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL3_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL3_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL3_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL3_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL3_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL3_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL3_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL3_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL3_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL3_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL3_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL3_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL3.Reg, volatile.LoadUint32(&o.DMACONTROL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL3_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL3.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS3: UDPHS DMA Channel Status Register (channel = 3)
func (o *UDPHS_Type) SetDMASTATUS3_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS3_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS3_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS3_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS3_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS3_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS3_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS3_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS3_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS3_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS3_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS3.Reg, volatile.LoadUint32(&o.DMASTATUS3.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS3_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS3.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC4: UDPHS DMA Next Descriptor Address Register (channel = 4)
func (o *UDPHS_Type) SetDMANXTDSC4(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC4.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC4() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC4.Reg)
}

// UDPHS.DMAADDRESS4: UDPHS DMA Channel Address Register (channel = 4)
func (o *UDPHS_Type) SetDMAADDRESS4(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS4.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS4() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS4.Reg)
}

// UDPHS.DMACONTROL4: UDPHS DMA Channel Control Register (channel = 4)
func (o *UDPHS_Type) SetDMACONTROL4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL4_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL4_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL4_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL4_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL4_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL4_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL4_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL4_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL4_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL4_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL4_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL4_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL4.Reg, volatile.LoadUint32(&o.DMACONTROL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL4_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL4.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS4: UDPHS DMA Channel Status Register (channel = 4)
func (o *UDPHS_Type) SetDMASTATUS4_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS4_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS4_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS4_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS4_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS4_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS4_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS4_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS4_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS4_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS4_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS4.Reg, volatile.LoadUint32(&o.DMASTATUS4.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS4_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS4.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMANXTDSC5: UDPHS DMA Next Descriptor Address Register (channel = 5)
func (o *UDPHS_Type) SetDMANXTDSC5(value uint32) {
	volatile.StoreUint32(&o.DMANXTDSC5.Reg, value)
}
func (o *UDPHS_Type) GetDMANXTDSC5() uint32 {
	return volatile.LoadUint32(&o.DMANXTDSC5.Reg)
}

// UDPHS.DMAADDRESS5: UDPHS DMA Channel Address Register (channel = 5)
func (o *UDPHS_Type) SetDMAADDRESS5(value uint32) {
	volatile.StoreUint32(&o.DMAADDRESS5.Reg, value)
}
func (o *UDPHS_Type) GetDMAADDRESS5() uint32 {
	return volatile.LoadUint32(&o.DMAADDRESS5.Reg)
}

// UDPHS.DMACONTROL5: UDPHS DMA Channel Control Register (channel = 5)
func (o *UDPHS_Type) SetDMACONTROL5_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMACONTROL5_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMACONTROL5_LDNXT_DSC(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMACONTROL5_LDNXT_DSC() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMACONTROL5_END_TR_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x4)|value<<2)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_TR_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x4) >> 2
}
func (o *UDPHS_Type) SetDMACONTROL5_END_B_EN(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x8)|value<<3)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_B_EN() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x8) >> 3
}
func (o *UDPHS_Type) SetDMACONTROL5_END_TR_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_TR_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMACONTROL5_END_BUFFIT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMACONTROL5_END_BUFFIT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMACONTROL5_DESC_LD_IT(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMACONTROL5_DESC_LD_IT() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMACONTROL5_BURST_LCK(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0x80)|value<<7)
}
func (o *UDPHS_Type) GetDMACONTROL5_BURST_LCK() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0x80) >> 7
}
func (o *UDPHS_Type) SetDMACONTROL5_BUFF_LENGTH(value uint32) {
	volatile.StoreUint32(&o.DMACONTROL5.Reg, volatile.LoadUint32(&o.DMACONTROL5.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMACONTROL5_BUFF_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.DMACONTROL5.Reg) & 0xffff0000) >> 16
}

// UDPHS.DMASTATUS5: UDPHS DMA Channel Status Register (channel = 5)
func (o *UDPHS_Type) SetDMASTATUS5_CHANN_ENB(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x1)|value)
}
func (o *UDPHS_Type) GetDMASTATUS5_CHANN_ENB() uint32 {
	return volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x1
}
func (o *UDPHS_Type) SetDMASTATUS5_CHANN_ACT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x2)|value<<1)
}
func (o *UDPHS_Type) GetDMASTATUS5_CHANN_ACT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x2) >> 1
}
func (o *UDPHS_Type) SetDMASTATUS5_END_TR_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x10)|value<<4)
}
func (o *UDPHS_Type) GetDMASTATUS5_END_TR_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x10) >> 4
}
func (o *UDPHS_Type) SetDMASTATUS5_END_BF_ST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x20)|value<<5)
}
func (o *UDPHS_Type) GetDMASTATUS5_END_BF_ST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x20) >> 5
}
func (o *UDPHS_Type) SetDMASTATUS5_DESC_LDST(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0x40)|value<<6)
}
func (o *UDPHS_Type) GetDMASTATUS5_DESC_LDST() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0x40) >> 6
}
func (o *UDPHS_Type) SetDMASTATUS5_BUFF_COUNT(value uint32) {
	volatile.StoreUint32(&o.DMASTATUS5.Reg, volatile.LoadUint32(&o.DMASTATUS5.Reg)&^(0xffff0000)|value<<16)
}
func (o *UDPHS_Type) GetDMASTATUS5_BUFF_COUNT() uint32 {
	return (volatile.LoadUint32(&o.DMASTATUS5.Reg) & 0xffff0000) >> 16
}

// Timer Counter 0
type TC_Type struct {
	CCR0 volatile.Register32 // 0x0
	CMR0 volatile.Register32 // 0x4
	_    [8]byte
	CV0  volatile.Register32 // 0x10
	RA0  volatile.Register32 // 0x14
	RB0  volatile.Register32 // 0x18
	RC0  volatile.Register32 // 0x1C
	SR0  volatile.Register32 // 0x20
	IER0 volatile.Register32 // 0x24
	IDR0 volatile.Register32 // 0x28
	IMR0 volatile.Register32 // 0x2C
	_    [16]byte
	CCR1 volatile.Register32 // 0x40
	CMR1 volatile.Register32 // 0x44
	_    [8]byte
	CV1  volatile.Register32 // 0x50
	RA1  volatile.Register32 // 0x54
	RB1  volatile.Register32 // 0x58
	RC1  volatile.Register32 // 0x5C
	SR1  volatile.Register32 // 0x60
	IER1 volatile.Register32 // 0x64
	IDR1 volatile.Register32 // 0x68
	IMR1 volatile.Register32 // 0x6C
	_    [16]byte
	CCR2 volatile.Register32 // 0x80
	CMR2 volatile.Register32 // 0x84
	_    [8]byte
	CV2  volatile.Register32 // 0x90
	RA2  volatile.Register32 // 0x94
	RB2  volatile.Register32 // 0x98
	RC2  volatile.Register32 // 0x9C
	SR2  volatile.Register32 // 0xA0
	IER2 volatile.Register32 // 0xA4
	IDR2 volatile.Register32 // 0xA8
	IMR2 volatile.Register32 // 0xAC
	_    [16]byte
	BCR  volatile.Register32 // 0xC0
	BMR  volatile.Register32 // 0xC4
}

// TC.CCR0: Channel Control Register (channel = 0)
func (o *TC_Type) SetCCR0_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR0_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0x1
}
func (o *TC_Type) SetCCR0_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR0_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR0_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR0_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x4) >> 2
}

// TC.CMR0: Channel Mode Register (channel = 0)
func (o *TC_Type) SetCMR0_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR0_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0x7
}
func (o *TC_Type) SetCMR0_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR0_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR0_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR0_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR0_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR0_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR0_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR0_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR0_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR0_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR0_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR0_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR0_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR0_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR0_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR0_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR0_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR0_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR0_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR0_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0xc0000) >> 18
}

// TC.CV0: Counter Value (channel = 0)
func (o *TC_Type) SetCV0_CV(value uint32) {
	volatile.StoreUint32(&o.CV0.Reg, volatile.LoadUint32(&o.CV0.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetCV0_CV() uint32 {
	return volatile.LoadUint32(&o.CV0.Reg) & 0xffff
}

// TC.RA0: Register A (channel = 0)
func (o *TC_Type) SetRA0_RA(value uint32) {
	volatile.StoreUint32(&o.RA0.Reg, volatile.LoadUint32(&o.RA0.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetRA0_RA() uint32 {
	return volatile.LoadUint32(&o.RA0.Reg) & 0xffff
}

// TC.RB0: Register B (channel = 0)
func (o *TC_Type) SetRB0_RB(value uint32) {
	volatile.StoreUint32(&o.RB0.Reg, volatile.LoadUint32(&o.RB0.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetRB0_RB() uint32 {
	return volatile.LoadUint32(&o.RB0.Reg) & 0xffff
}

// TC.RC0: Register C (channel = 0)
func (o *TC_Type) SetRC0_RC(value uint32) {
	volatile.StoreUint32(&o.RC0.Reg, volatile.LoadUint32(&o.RC0.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetRC0_RC() uint32 {
	return volatile.LoadUint32(&o.RC0.Reg) & 0xffff
}

// TC.SR0: Status Register (channel = 0)
func (o *TC_Type) SetSR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR0.Reg) & 0x1
}
func (o *TC_Type) SetSR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR0_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR0_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR0_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR0_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR0_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR0_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40000) >> 18
}

// TC.IER0: Interrupt Enable Register (channel = 0)
func (o *TC_Type) SetIER0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER0.Reg) & 0x1
}
func (o *TC_Type) SetIER0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x80) >> 7
}

// TC.IDR0: Interrupt Disable Register (channel = 0)
func (o *TC_Type) SetIDR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR0.Reg) & 0x1
}
func (o *TC_Type) SetIDR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x80) >> 7
}

// TC.IMR0: Interrupt Mask Register (channel = 0)
func (o *TC_Type) SetIMR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR0.Reg) & 0x1
}
func (o *TC_Type) SetIMR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x80) >> 7
}

// TC.CCR1: Channel Control Register (channel = 1)
func (o *TC_Type) SetCCR1_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR1_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}
func (o *TC_Type) SetCCR1_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR1_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR1_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR1_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}

// TC.CMR1: Channel Mode Register (channel = 1)
func (o *TC_Type) SetCMR1_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR1_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0x7
}
func (o *TC_Type) SetCMR1_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR1_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR1_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR1_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR1_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR1_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR1_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR1_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR1_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR1_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR1_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR1_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR1_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR1_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR1_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR1_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR1_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR1_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR1_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR1_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0xc0000) >> 18
}

// TC.CV1: Counter Value (channel = 1)
func (o *TC_Type) SetCV1_CV(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, volatile.LoadUint32(&o.CV1.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetCV1_CV() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg) & 0xffff
}

// TC.RA1: Register A (channel = 1)
func (o *TC_Type) SetRA1_RA(value uint32) {
	volatile.StoreUint32(&o.RA1.Reg, volatile.LoadUint32(&o.RA1.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetRA1_RA() uint32 {
	return volatile.LoadUint32(&o.RA1.Reg) & 0xffff
}

// TC.RB1: Register B (channel = 1)
func (o *TC_Type) SetRB1_RB(value uint32) {
	volatile.StoreUint32(&o.RB1.Reg, volatile.LoadUint32(&o.RB1.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetRB1_RB() uint32 {
	return volatile.LoadUint32(&o.RB1.Reg) & 0xffff
}

// TC.RC1: Register C (channel = 1)
func (o *TC_Type) SetRC1_RC(value uint32) {
	volatile.StoreUint32(&o.RC1.Reg, volatile.LoadUint32(&o.RC1.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetRC1_RC() uint32 {
	return volatile.LoadUint32(&o.RC1.Reg) & 0xffff
}

// TC.SR1: Status Register (channel = 1)
func (o *TC_Type) SetSR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}
func (o *TC_Type) SetSR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR1_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR1_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR1_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR1_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR1_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR1_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40000) >> 18
}

// TC.IER1: Interrupt Enable Register (channel = 1)
func (o *TC_Type) SetIER1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *TC_Type) SetIER1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}

// TC.IDR1: Interrupt Disable Register (channel = 1)
func (o *TC_Type) SetIDR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *TC_Type) SetIDR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80) >> 7
}

// TC.IMR1: Interrupt Mask Register (channel = 1)
func (o *TC_Type) SetIMR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *TC_Type) SetIMR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}

// TC.CCR2: Channel Control Register (channel = 2)
func (o *TC_Type) SetCCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR2_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}
func (o *TC_Type) SetCCR2_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR2_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR2_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR2_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}

// TC.CMR2: Channel Mode Register (channel = 2)
func (o *TC_Type) SetCMR2_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR2_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0x7
}
func (o *TC_Type) SetCMR2_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR2_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR2_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR2_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR2_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR2_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR2_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR2_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR2_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR2_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR2_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR2_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR2_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR2_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR2_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR2_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR2_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR2_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR2_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR2_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0xc0000) >> 18
}

// TC.CV2: Counter Value (channel = 2)
func (o *TC_Type) SetCV2_CV(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, volatile.LoadUint32(&o.CV2.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetCV2_CV() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg) & 0xffff
}

// TC.RA2: Register A (channel = 2)
func (o *TC_Type) SetRA2_RA(value uint32) {
	volatile.StoreUint32(&o.RA2.Reg, volatile.LoadUint32(&o.RA2.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetRA2_RA() uint32 {
	return volatile.LoadUint32(&o.RA2.Reg) & 0xffff
}

// TC.RB2: Register B (channel = 2)
func (o *TC_Type) SetRB2_RB(value uint32) {
	volatile.StoreUint32(&o.RB2.Reg, volatile.LoadUint32(&o.RB2.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetRB2_RB() uint32 {
	return volatile.LoadUint32(&o.RB2.Reg) & 0xffff
}

// TC.RC2: Register C (channel = 2)
func (o *TC_Type) SetRC2_RC(value uint32) {
	volatile.StoreUint32(&o.RC2.Reg, volatile.LoadUint32(&o.RC2.Reg)&^(0xffff)|value)
}
func (o *TC_Type) GetRC2_RC() uint32 {
	return volatile.LoadUint32(&o.RC2.Reg) & 0xffff
}

// TC.SR2: Status Register (channel = 2)
func (o *TC_Type) SetSR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}
func (o *TC_Type) SetSR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR2_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR2_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR2_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR2_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR2_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR2_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40000) >> 18
}

// TC.IER2: Interrupt Enable Register (channel = 2)
func (o *TC_Type) SetIER2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *TC_Type) SetIER2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80) >> 7
}

// TC.IDR2: Interrupt Disable Register (channel = 2)
func (o *TC_Type) SetIDR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *TC_Type) SetIDR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80) >> 7
}

// TC.IMR2: Interrupt Mask Register (channel = 2)
func (o *TC_Type) SetIMR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *TC_Type) SetIMR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}

// TC.BCR: Block Control Register
func (o *TC_Type) SetBCR_SYNC(value uint32) {
	volatile.StoreUint32(&o.BCR.Reg, volatile.LoadUint32(&o.BCR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetBCR_SYNC() uint32 {
	return volatile.LoadUint32(&o.BCR.Reg) & 0x1
}

// TC.BMR: Block Mode Register
func (o *TC_Type) SetBMR_TC0XC0S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3)|value)
}
func (o *TC_Type) GetBMR_TC0XC0S() uint32 {
	return volatile.LoadUint32(&o.BMR.Reg) & 0x3
}
func (o *TC_Type) SetBMR_TC1XC1S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0xc)|value<<2)
}
func (o *TC_Type) GetBMR_TC1XC1S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0xc) >> 2
}
func (o *TC_Type) SetBMR_TC2XC2S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetBMR_TC2XC2S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x30) >> 4
}

// High Speed MultiMedia Card Interface 0
type HSMCI_Type struct {
	CR    volatile.Register32    // 0x0
	MR    volatile.Register32    // 0x4
	DTOR  volatile.Register32    // 0x8
	SDCR  volatile.Register32    // 0xC
	ARGR  volatile.Register32    // 0x10
	CMDR  volatile.Register32    // 0x14
	BLKR  volatile.Register32    // 0x18
	CSTOR volatile.Register32    // 0x1C
	RSPR  [4]volatile.Register32 // 0x20
	RDR   volatile.Register32    // 0x30
	TDR   volatile.Register32    // 0x34
	_     [8]byte
	SR    volatile.Register32 // 0x40
	IER   volatile.Register32 // 0x44
	IDR   volatile.Register32 // 0x48
	IMR   volatile.Register32 // 0x4C
	DMA   volatile.Register32 // 0x50
	CFG   volatile.Register32 // 0x54
	_     [140]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// HSMCI.CR: Control Register
func (o *HSMCI_Type) SetCR_MCIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCR_MCIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *HSMCI_Type) SetCR_MCIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetCR_MCIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetCR_PWSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetCR_PWSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetCR_PWSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetCR_PWSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *HSMCI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// HSMCI.MR: Mode Register
func (o *HSMCI_Type) SetMR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *HSMCI_Type) GetMR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *HSMCI_Type) SetMR_PWSDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetMR_PWSDIV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetMR_RDPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetMR_RDPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetMR_WRPROOF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetMR_WRPROOF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetMR_FBYTE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetMR_FBYTE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetMR_PADV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4000)|value<<14)
}
func (o *HSMCI_Type) GetMR_PADV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4000) >> 14
}
func (o *HSMCI_Type) SetMR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSMCI_Type) GetMR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xffff0000) >> 16
}

// HSMCI.DTOR: Data Timeout Register
func (o *HSMCI_Type) SetDTOR_DTOCYC(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetDTOR_DTOCYC() uint32 {
	return volatile.LoadUint32(&o.DTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetDTOR_DTOMUL(value uint32) {
	volatile.StoreUint32(&o.DTOR.Reg, volatile.LoadUint32(&o.DTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetDTOR_DTOMUL() uint32 {
	return (volatile.LoadUint32(&o.DTOR.Reg) & 0x70) >> 4
}

// HSMCI.SDCR: SD/SDIO Card Register
func (o *HSMCI_Type) SetSDCR_SDCSEL(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetSDCR_SDCSEL() uint32 {
	return volatile.LoadUint32(&o.SDCR.Reg) & 0x3
}
func (o *HSMCI_Type) SetSDCR_SDCBUS(value uint32) {
	volatile.StoreUint32(&o.SDCR.Reg, volatile.LoadUint32(&o.SDCR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetSDCR_SDCBUS() uint32 {
	return (volatile.LoadUint32(&o.SDCR.Reg) & 0xc0) >> 6
}

// HSMCI.ARGR: Argument Register
func (o *HSMCI_Type) SetARGR(value uint32) {
	volatile.StoreUint32(&o.ARGR.Reg, value)
}
func (o *HSMCI_Type) GetARGR() uint32 {
	return volatile.LoadUint32(&o.ARGR.Reg)
}

// HSMCI.CMDR: Command Register
func (o *HSMCI_Type) SetCMDR_CMDNB(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3f)|value)
}
func (o *HSMCI_Type) GetCMDR_CMDNB() uint32 {
	return volatile.LoadUint32(&o.CMDR.Reg) & 0x3f
}
func (o *HSMCI_Type) SetCMDR_RSPTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0xc0)|value<<6)
}
func (o *HSMCI_Type) GetCMDR_RSPTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0xc0) >> 6
}
func (o *HSMCI_Type) SetCMDR_SPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x700)|value<<8)
}
func (o *HSMCI_Type) GetCMDR_SPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x700) >> 8
}
func (o *HSMCI_Type) SetCMDR_OPDCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x800)|value<<11)
}
func (o *HSMCI_Type) GetCMDR_OPDCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x800) >> 11
}
func (o *HSMCI_Type) SetCMDR_MAXLAT(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCMDR_MAXLAT() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetCMDR_TRCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x30000)|value<<16)
}
func (o *HSMCI_Type) GetCMDR_TRCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x30000) >> 16
}
func (o *HSMCI_Type) SetCMDR_TRDIR(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetCMDR_TRDIR() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetCMDR_TRTYP(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x380000)|value<<19)
}
func (o *HSMCI_Type) GetCMDR_TRTYP() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x380000) >> 19
}
func (o *HSMCI_Type) SetCMDR_IOSPCMD(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x3000000)|value<<24)
}
func (o *HSMCI_Type) GetCMDR_IOSPCMD() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x3000000) >> 24
}
func (o *HSMCI_Type) SetCMDR_ATACS(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetCMDR_ATACS() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetCMDR_BOOT_ACK(value uint32) {
	volatile.StoreUint32(&o.CMDR.Reg, volatile.LoadUint32(&o.CMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetCMDR_BOOT_ACK() uint32 {
	return (volatile.LoadUint32(&o.CMDR.Reg) & 0x8000000) >> 27
}

// HSMCI.BLKR: Block Register
func (o *HSMCI_Type) SetBLKR_BCNT(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff)|value)
}
func (o *HSMCI_Type) GetBLKR_BCNT() uint32 {
	return volatile.LoadUint32(&o.BLKR.Reg) & 0xffff
}
func (o *HSMCI_Type) SetBLKR_BLKLEN(value uint32) {
	volatile.StoreUint32(&o.BLKR.Reg, volatile.LoadUint32(&o.BLKR.Reg)&^(0xffff0000)|value<<16)
}
func (o *HSMCI_Type) GetBLKR_BLKLEN() uint32 {
	return (volatile.LoadUint32(&o.BLKR.Reg) & 0xffff0000) >> 16
}

// HSMCI.CSTOR: Completion Signal Timeout Register
func (o *HSMCI_Type) SetCSTOR_CSTOCYC(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetCSTOR_CSTOCYC() uint32 {
	return volatile.LoadUint32(&o.CSTOR.Reg) & 0xf
}
func (o *HSMCI_Type) SetCSTOR_CSTOMUL(value uint32) {
	volatile.StoreUint32(&o.CSTOR.Reg, volatile.LoadUint32(&o.CSTOR.Reg)&^(0x70)|value<<4)
}
func (o *HSMCI_Type) GetCSTOR_CSTOMUL() uint32 {
	return (volatile.LoadUint32(&o.CSTOR.Reg) & 0x70) >> 4
}

// HSMCI.RSPR: Response Register
func (o *HSMCI_Type) SetRSPR(idx int, value uint32) {
	volatile.StoreUint32(&o.RSPR[idx].Reg, value)
}
func (o *HSMCI_Type) GetRSPR(idx int) uint32 {
	return volatile.LoadUint32(&o.RSPR[idx].Reg)
}

// HSMCI.RDR: Receive Data Register
func (o *HSMCI_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, value)
}
func (o *HSMCI_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg)
}

// HSMCI.TDR: Transmit Data Register
func (o *HSMCI_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, value)
}
func (o *HSMCI_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg)
}

// HSMCI.SR: Status Register
func (o *HSMCI_Type) SetSR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetSR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *HSMCI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetSR_BLKE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetSR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetSR_DTIP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetSR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetSR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetSR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetSR_MCI_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetSR_MCI_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetSR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetSR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetSR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetSR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetSR_RINDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetSR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetSR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetSR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetSR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetSR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetSR_RENDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetSR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetSR_RTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetSR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetSR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetSR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetSR_DTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetSR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetSR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetSR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetSR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetSR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetSR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetSR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetSR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetSR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetSR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetSR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetSR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetSR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetSR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetSR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetSR_UNRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetSR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// HSMCI.IER: Interrupt Enable Register
func (o *HSMCI_Type) SetIER_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIER_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *HSMCI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIER_BLKE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIER_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIER_DTIP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIER_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIER_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIER_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIER_MCI_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIER_MCI_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIER_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIER_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIER_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIER_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIER_RINDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIER_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIER_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIER_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIER_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIER_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIER_RENDE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIER_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIER_RTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIER_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIER_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIER_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIER_DTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIER_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIER_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIER_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIER_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIER_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIER_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIER_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIER_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIER_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIER_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIER_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIER_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIER_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIER_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIER_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIER_UNRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIER_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// HSMCI.IDR: Interrupt Disable Register
func (o *HSMCI_Type) SetIDR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIDR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIDR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIDR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIDR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIDR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIDR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIDR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIDR_MCI_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIDR_MCI_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIDR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIDR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIDR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIDR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIDR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIDR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIDR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIDR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIDR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIDR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIDR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIDR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIDR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIDR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIDR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIDR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIDR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIDR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIDR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIDR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIDR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIDR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIDR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIDR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIDR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIDR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIDR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIDR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIDR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIDR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIDR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIDR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIDR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIDR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// HSMCI.IMR: Interrupt Mask Register
func (o *HSMCI_Type) SetIMR_CMDRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetIMR_CMDRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *HSMCI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *HSMCI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *HSMCI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *HSMCI_Type) SetIMR_BLKE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *HSMCI_Type) GetIMR_BLKE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *HSMCI_Type) SetIMR_DTIP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetIMR_DTIP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetIMR_NOTBUSY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *HSMCI_Type) GetIMR_NOTBUSY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *HSMCI_Type) SetIMR_MCI_SDIOIRQA(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetIMR_MCI_SDIOIRQA() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetIMR_SDIOWAIT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetIMR_SDIOWAIT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *HSMCI_Type) SetIMR_CSRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *HSMCI_Type) GetIMR_CSRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *HSMCI_Type) SetIMR_RINDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *HSMCI_Type) GetIMR_RINDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *HSMCI_Type) SetIMR_RDIRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *HSMCI_Type) GetIMR_RDIRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *HSMCI_Type) SetIMR_RCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *HSMCI_Type) GetIMR_RCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *HSMCI_Type) SetIMR_RENDE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *HSMCI_Type) GetIMR_RENDE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *HSMCI_Type) SetIMR_RTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *HSMCI_Type) GetIMR_RTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *HSMCI_Type) SetIMR_DCRCE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *HSMCI_Type) GetIMR_DCRCE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *HSMCI_Type) SetIMR_DTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *HSMCI_Type) GetIMR_DTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *HSMCI_Type) SetIMR_CSTOE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *HSMCI_Type) GetIMR_CSTOE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *HSMCI_Type) SetIMR_BLKOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *HSMCI_Type) GetIMR_BLKOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *HSMCI_Type) SetIMR_DMADONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *HSMCI_Type) GetIMR_DMADONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *HSMCI_Type) SetIMR_FIFOEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *HSMCI_Type) GetIMR_FIFOEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *HSMCI_Type) SetIMR_XFRDONE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *HSMCI_Type) GetIMR_XFRDONE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *HSMCI_Type) SetIMR_ACKRCV(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *HSMCI_Type) GetIMR_ACKRCV() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *HSMCI_Type) SetIMR_ACKRCVE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *HSMCI_Type) GetIMR_ACKRCVE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *HSMCI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *HSMCI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *HSMCI_Type) SetIMR_UNRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *HSMCI_Type) GetIMR_UNRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// HSMCI.DMA: DMA Configuration Register
func (o *HSMCI_Type) SetDMA_OFFSET(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x3)|value)
}
func (o *HSMCI_Type) GetDMA_OFFSET() uint32 {
	return volatile.LoadUint32(&o.DMA.Reg) & 0x3
}
func (o *HSMCI_Type) SetDMA_CHKSIZE(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x30)|value<<4)
}
func (o *HSMCI_Type) GetDMA_CHKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x30) >> 4
}
func (o *HSMCI_Type) SetDMA_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetDMA_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetDMA_ROPT(value uint32) {
	volatile.StoreUint32(&o.DMA.Reg, volatile.LoadUint32(&o.DMA.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetDMA_ROPT() uint32 {
	return (volatile.LoadUint32(&o.DMA.Reg) & 0x1000) >> 12
}

// HSMCI.CFG: Configuration Register
func (o *HSMCI_Type) SetCFG_FIFOMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetCFG_FIFOMODE() uint32 {
	return volatile.LoadUint32(&o.CFG.Reg) & 0x1
}
func (o *HSMCI_Type) SetCFG_FERRCTRL(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x10)|value<<4)
}
func (o *HSMCI_Type) GetCFG_FERRCTRL() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x10) >> 4
}
func (o *HSMCI_Type) SetCFG_HSMODE(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x100)|value<<8)
}
func (o *HSMCI_Type) GetCFG_HSMODE() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x100) >> 8
}
func (o *HSMCI_Type) SetCFG_LSYNC(value uint32) {
	volatile.StoreUint32(&o.CFG.Reg, volatile.LoadUint32(&o.CFG.Reg)&^(0x1000)|value<<12)
}
func (o *HSMCI_Type) GetCFG_LSYNC() uint32 {
	return (volatile.LoadUint32(&o.CFG.Reg) & 0x1000) >> 12
}

// HSMCI.WPMR: Write Protection Mode Register
func (o *HSMCI_Type) SetWPMR_WP_EN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *HSMCI_Type) GetWPMR_WP_EN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *HSMCI_Type) SetWPMR_WP_KEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPMR_WP_KEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// HSMCI.WPSR: Write Protection Status Register
func (o *HSMCI_Type) SetWPSR_WP_VS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xf)|value)
}
func (o *HSMCI_Type) GetWPSR_WP_VS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0xf
}
func (o *HSMCI_Type) SetWPSR_WP_VSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *HSMCI_Type) GetWPSR_WP_VSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
}

// TWI.CR: Control Register
func (o *TWI_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TWI_Type) SetCR_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetCR_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetCR_MSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetCR_MSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetCR_MSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetCR_MSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetCR_SVEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetCR_SVEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetCR_SVDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetCR_SVDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetCR_QUICK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetCR_QUICK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// TWI.MMR: Master Mode Register
func (o *TWI_Type) SetMMR_IADRSZ(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x300)|value<<8)
}
func (o *TWI_Type) GetMMR_IADRSZ() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x300) >> 8
}
func (o *TWI_Type) SetMMR_MREAD(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetMMR_MREAD() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetMMR_DADR(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetMMR_DADR() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x7f0000) >> 16
}

// TWI.SMR: Slave Mode Register
func (o *TWI_Type) SetSMR_SADR(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetSMR_SADR() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f0000) >> 16
}

// TWI.IADR: Internal Address Register
func (o *TWI_Type) SetIADR(value uint32) {
	volatile.StoreUint32(&o.IADR.Reg, volatile.LoadUint32(&o.IADR.Reg)&^(0xffffff)|value)
}
func (o *TWI_Type) GetIADR() uint32 {
	return volatile.LoadUint32(&o.IADR.Reg) & 0xffffff
}

// TWI.CWGR: Clock Waveform Generator Register
func (o *TWI_Type) SetCWGR_CLDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetCWGR_CLDIV() uint32 {
	return volatile.LoadUint32(&o.CWGR.Reg) & 0xff
}
func (o *TWI_Type) SetCWGR_CHDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff00)|value<<8)
}
func (o *TWI_Type) GetCWGR_CHDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0xff00) >> 8
}
func (o *TWI_Type) SetCWGR_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x70000)|value<<16)
}
func (o *TWI_Type) GetCWGR_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x70000) >> 16
}

// TWI.SR: Status Register
func (o *TWI_Type) SetSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetSR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TWI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetSR_SVREAD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetSR_SVREAD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetSR_SVACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetSR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetSR_GACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetSR_GACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetSR_NACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetSR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetSR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetSR_SCLWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetSR_SCLWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetSR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetSR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}

// TWI.IER: Interrupt Enable Register
func (o *TWI_Type) SetIER_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIER_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TWI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIER_SVACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIER_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIER_GACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIER_GACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIER_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIER_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIER_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIER_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIER_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIER_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// TWI.IDR: Interrupt Disable Register
func (o *TWI_Type) SetIDR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIDR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TWI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIDR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIDR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIDR_GACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIDR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIDR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIDR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIDR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIDR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIDR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIDR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// TWI.IMR: Interrupt Mask Register
func (o *TWI_Type) SetIMR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIMR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TWI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIMR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIMR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIMR_GACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIMR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIMR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIMR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIMR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIMR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIMR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIMR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// TWI.RHR: Receive Holding Register
func (o *TWI_Type) SetRHR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetRHR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// TWI.THR: Transmit Holding Register
func (o *TWI_Type) SetTHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetTHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	MAN  volatile.Register32 // 0x50
	_    [172]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// USART.CR: Control Register
func (o *USART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR_STTBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR_STTBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR_STPBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR_STPBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR_STTTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR_STTTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR_SENDA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR_SENDA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR_RSTIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR_RSTIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR_RSTNACK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR_RSTNACK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR_RETTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR_RETTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR_RTSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR_RTSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}

// USART.MR: Mode Register
func (o *USART_Type) SetMR_USART_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMR_USART_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xf
}
func (o *USART_Type) SetMR_USCLKS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetMR_USCLKS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetMR_CHRL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetMR_CHRL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetMR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetMR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *USART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *USART_Type) SetMR_NBSTOP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetMR_NBSTOP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *USART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}
func (o *USART_Type) SetMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetMR_MODE9(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetMR_MODE9() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetMR_CLKO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetMR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetMR_OVER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetMR_OVER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetMR_INACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetMR_INACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetMR_DSNACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetMR_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetMR_VAR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetMR_VAR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetMR_MAX_ITERATION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *USART_Type) GetMR_MAX_ITERATION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *USART_Type) SetMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMR_MAN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMR_MAN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMR_MODSYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMR_MODSYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000000) >> 30
}
func (o *USART_Type) SetMR_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *USART_Type) GetMR_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// USART.IER: Interrupt Enable Register
func (o *USART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *USART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIER_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIER_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIER_ITER(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIER_ITER() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIER_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIER_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIER_MANE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIER_MANE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}

// USART.IDR: Interrupt Disable Register
func (o *USART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *USART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIDR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIDR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIDR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIDR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIDR_ITER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIDR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIDR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIDR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIDR_MANE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIDR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}

// USART.IMR: Interrupt Mask Register
func (o *USART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *USART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIMR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIMR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIMR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIMR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIMR_ITER(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIMR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIMR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIMR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetIMR_MANE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetIMR_MANE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}

// USART.CSR: Channel Status Register
func (o *USART_Type) SetCSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *USART_Type) SetCSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCSR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCSR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCSR_PARE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCSR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCSR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCSR_ITER(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCSR_ITER() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCSR_NACK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCSR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCSR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCSR_CTS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCSR_MANERR(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCSR_MANERR() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}

// USART.RHR: Receiver Holding Register
func (o *USART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0x1ff
}
func (o *USART_Type) SetRHR_RXSYNH(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetRHR_RXSYNH() uint32 {
	return (volatile.LoadUint32(&o.RHR.Reg) & 0x8000) >> 15
}

// USART.THR: Transmitter Holding Register
func (o *USART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0x1ff
}
func (o *USART_Type) SetTHR_TXSYNH(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetTHR_TXSYNH() uint32 {
	return (volatile.LoadUint32(&o.THR.Reg) & 0x8000) >> 15
}

// USART.BRGR: Baud Rate Generator Register
func (o *USART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}
func (o *USART_Type) SetBRGR_FP(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetBRGR_FP() uint32 {
	return (volatile.LoadUint32(&o.BRGR.Reg) & 0x70000) >> 16
}

// USART.RTOR: Receiver Time-out Register
func (o *USART_Type) SetRTOR_TO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRTOR_TO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffff
}

// USART.TTGR: Transmitter Timeguard Register
func (o *USART_Type) SetTTGR_TG(value uint32) {
	volatile.StoreUint32(&o.TTGR.Reg, volatile.LoadUint32(&o.TTGR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetTTGR_TG() uint32 {
	return volatile.LoadUint32(&o.TTGR.Reg) & 0xff
}

// USART.FIDI: FI DI Ratio Register
func (o *USART_Type) SetFIDI_FI_DI_RATIO(value uint32) {
	volatile.StoreUint32(&o.FIDI.Reg, volatile.LoadUint32(&o.FIDI.Reg)&^(0x7ff)|value)
}
func (o *USART_Type) GetFIDI_FI_DI_RATIO() uint32 {
	return volatile.LoadUint32(&o.FIDI.Reg) & 0x7ff
}

// USART.NER: Number of Errors Register
func (o *USART_Type) SetNER_NB_ERRORS(value uint32) {
	volatile.StoreUint32(&o.NER.Reg, volatile.LoadUint32(&o.NER.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetNER_NB_ERRORS() uint32 {
	return volatile.LoadUint32(&o.NER.Reg) & 0xff
}

// USART.IF: IrDA Filter Register
func (o *USART_Type) SetIF_IRDA_FILTER(value uint32) {
	volatile.StoreUint32(&o.IF.Reg, volatile.LoadUint32(&o.IF.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetIF_IRDA_FILTER() uint32 {
	return volatile.LoadUint32(&o.IF.Reg) & 0xff
}

// USART.MAN: Manchester Encoder Decoder Register
func (o *USART_Type) SetMAN_TX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMAN_TX_PL() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xf
}
func (o *USART_Type) SetMAN_TX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x300)|value<<8)
}
func (o *USART_Type) GetMAN_TX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x300) >> 8
}
func (o *USART_Type) SetMAN_TX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetMAN_TX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetMAN_RX_PL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf0000)|value<<16)
}
func (o *USART_Type) GetMAN_RX_PL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf0000) >> 16
}
func (o *USART_Type) SetMAN_RX_PP(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x3000000)|value<<24)
}
func (o *USART_Type) GetMAN_RX_PP() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x3000000) >> 24
}
func (o *USART_Type) SetMAN_RX_MPOL(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMAN_RX_MPOL() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetMAN_ONE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x20000000)|value<<29)
}
func (o *USART_Type) GetMAN_ONE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x20000000) >> 29
}
func (o *USART_Type) SetMAN_DRIFT(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x40000000)|value<<30)
}
func (o *USART_Type) GetMAN_DRIFT() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x40000000) >> 30
}

// USART.RPR: Receive Pointer Register
func (o *USART_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *USART_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// USART.RCR: Receive Counter Register
func (o *USART_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// USART.TPR: Transmit Pointer Register
func (o *USART_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *USART_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// USART.TCR: Transmit Counter Register
func (o *USART_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// USART.RNPR: Receive Next Pointer Register
func (o *USART_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *USART_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// USART.RNCR: Receive Next Counter Register
func (o *USART_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// USART.TNPR: Transmit Next Pointer Register
func (o *USART_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *USART_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// USART.TNCR: Transmit Next Counter Register
func (o *USART_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// USART.PTCR: Transfer Control Register
func (o *USART_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *USART_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// USART.PTSR: Transfer Status Register
func (o *USART_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *USART_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Synchronous Serial Controller 0
type SSC_Type struct {
	CR   volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	_    [8]byte
	RCMR volatile.Register32 // 0x10
	RFMR volatile.Register32 // 0x14
	TCMR volatile.Register32 // 0x18
	TFMR volatile.Register32 // 0x1C
	RHR  volatile.Register32 // 0x20
	THR  volatile.Register32 // 0x24
	_    [8]byte
	RSHR volatile.Register32 // 0x30
	TSHR volatile.Register32 // 0x34
	RC0R volatile.Register32 // 0x38
	RC1R volatile.Register32 // 0x3C
	SR   volatile.Register32 // 0x40
	IER  volatile.Register32 // 0x44
	IDR  volatile.Register32 // 0x48
	IMR  volatile.Register32 // 0x4C
	_    [176]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// SSC.CR: Control Register
func (o *SSC_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetCR_RXEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SSC_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *SSC_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}

// SSC.CMR: Clock Mode Register
func (o *SSC_Type) SetCMR_DIV(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xfff)|value)
}
func (o *SSC_Type) GetCMR_DIV() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0xfff
}

// SSC.RCMR: Receive Clock Mode Register
func (o *SSC_Type) SetRCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetRCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.RCMR.Reg) & 0x3
}
func (o *SSC_Type) SetRCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetRCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetRCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetRCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetRCMR_START(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRCMR_START() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRCMR_STOP(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0x1000)|value<<12)
}
func (o *SSC_Type) GetRCMR_STOP() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0x1000) >> 12
}
func (o *SSC_Type) SetRCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetRCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetRCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.RCMR.Reg, volatile.LoadUint32(&o.RCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetRCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.RCMR.Reg) & 0xff000000) >> 24
}

// SSC.RFMR: Receive Frame Mode Register
func (o *SSC_Type) SetRFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetRFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.RFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetRFMR_LOOP(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetRFMR_LOOP() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetRFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetRFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetRFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetRFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetRFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetRFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetRFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetRFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetRFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetRFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetRFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.RFMR.Reg, volatile.LoadUint32(&o.RFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetRFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.RFMR.Reg) & 0xf0000000) >> 28
}

// SSC.TCMR: Transmit Clock Mode Register
func (o *SSC_Type) SetTCMR_CKS(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x3)|value)
}
func (o *SSC_Type) GetTCMR_CKS() uint32 {
	return volatile.LoadUint32(&o.TCMR.Reg) & 0x3
}
func (o *SSC_Type) SetTCMR_CKO(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x1c)|value<<2)
}
func (o *SSC_Type) GetTCMR_CKO() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x1c) >> 2
}
func (o *SSC_Type) SetTCMR_CKI(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTCMR_CKI() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTCMR_CKG(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xc0)|value<<6)
}
func (o *SSC_Type) GetTCMR_CKG() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xc0) >> 6
}
func (o *SSC_Type) SetTCMR_START(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTCMR_START() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTCMR_STTDLY(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff0000)|value<<16)
}
func (o *SSC_Type) GetTCMR_STTDLY() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff0000) >> 16
}
func (o *SSC_Type) SetTCMR_PERIOD(value uint32) {
	volatile.StoreUint32(&o.TCMR.Reg, volatile.LoadUint32(&o.TCMR.Reg)&^(0xff000000)|value<<24)
}
func (o *SSC_Type) GetTCMR_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.TCMR.Reg) & 0xff000000) >> 24
}

// SSC.TFMR: Transmit Frame Mode Register
func (o *SSC_Type) SetTFMR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1f)|value)
}
func (o *SSC_Type) GetTFMR_DATLEN() uint32 {
	return volatile.LoadUint32(&o.TFMR.Reg) & 0x1f
}
func (o *SSC_Type) SetTFMR_DATDEF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetTFMR_DATDEF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetTFMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetTFMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetTFMR_DATNB(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf00)|value<<8)
}
func (o *SSC_Type) GetTFMR_DATNB() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf00) >> 8
}
func (o *SSC_Type) SetTFMR_FSLEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000)|value<<16)
}
func (o *SSC_Type) GetTFMR_FSLEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000) >> 16
}
func (o *SSC_Type) SetTFMR_FSOS(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x700000)|value<<20)
}
func (o *SSC_Type) GetTFMR_FSOS() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x700000) >> 20
}
func (o *SSC_Type) SetTFMR_FSDEN(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x800000)|value<<23)
}
func (o *SSC_Type) GetTFMR_FSDEN() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x800000) >> 23
}
func (o *SSC_Type) SetTFMR_FSEDGE(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0x1000000)|value<<24)
}
func (o *SSC_Type) GetTFMR_FSEDGE() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0x1000000) >> 24
}
func (o *SSC_Type) SetTFMR_FSLEN_EXT(value uint32) {
	volatile.StoreUint32(&o.TFMR.Reg, volatile.LoadUint32(&o.TFMR.Reg)&^(0xf0000000)|value<<28)
}
func (o *SSC_Type) GetTFMR_FSLEN_EXT() uint32 {
	return (volatile.LoadUint32(&o.TFMR.Reg) & 0xf0000000) >> 28
}

// SSC.RHR: Receive Holding Register
func (o *SSC_Type) SetRHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, value)
}
func (o *SSC_Type) GetRHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg)
}

// SSC.THR: Transmit Holding Register
func (o *SSC_Type) SetTHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, value)
}
func (o *SSC_Type) GetTHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg)
}

// SSC.RSHR: Receive Sync. Holding Register
func (o *SSC_Type) SetRSHR_RSDAT(value uint32) {
	volatile.StoreUint32(&o.RSHR.Reg, volatile.LoadUint32(&o.RSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRSHR_RSDAT() uint32 {
	return volatile.LoadUint32(&o.RSHR.Reg) & 0xffff
}

// SSC.TSHR: Transmit Sync. Holding Register
func (o *SSC_Type) SetTSHR_TSDAT(value uint32) {
	volatile.StoreUint32(&o.TSHR.Reg, volatile.LoadUint32(&o.TSHR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTSHR_TSDAT() uint32 {
	return volatile.LoadUint32(&o.TSHR.Reg) & 0xffff
}

// SSC.RC0R: Receive Compare 0 Register
func (o *SSC_Type) SetRC0R_CP0(value uint32) {
	volatile.StoreUint32(&o.RC0R.Reg, volatile.LoadUint32(&o.RC0R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC0R_CP0() uint32 {
	return volatile.LoadUint32(&o.RC0R.Reg) & 0xffff
}

// SSC.RC1R: Receive Compare 1 Register
func (o *SSC_Type) SetRC1R_CP1(value uint32) {
	volatile.StoreUint32(&o.RC1R.Reg, volatile.LoadUint32(&o.RC1R.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRC1R_CP1() uint32 {
	return volatile.LoadUint32(&o.RC1R.Reg) & 0xffff
}

// SSC.SR: Status Register
func (o *SSC_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSC_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetSR_CP0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetSR_CP0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetSR_CP1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetSR_CP1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetSR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetSR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetSR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetSR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *SSC_Type) SetSR_TXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SSC_Type) GetSR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SSC_Type) SetSR_RXEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SSC_Type) GetSR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SSC.IER: Interrupt Enable Register
func (o *SSC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SSC_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIER_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIER_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetIER_CP0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIER_CP0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIER_CP1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIER_CP1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIER_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIER_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIER_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIER_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}

// SSC.IDR: Interrupt Disable Register
func (o *SSC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SSC_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIDR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIDR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetIDR_CP0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIDR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIDR_CP1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIDR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIDR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIDR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIDR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIDR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}

// SSC.IMR: Interrupt Mask Register
func (o *SSC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SSC_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SSC_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SSC_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SSC_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SSC_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SSC_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SSC_Type) SetIMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SSC_Type) GetIMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SSC_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *SSC_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *SSC_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *SSC_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *SSC_Type) SetIMR_CP0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetIMR_CP0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetIMR_CP1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetIMR_CP1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SSC_Type) SetIMR_TXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SSC_Type) GetIMR_TXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *SSC_Type) SetIMR_RXSYN(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *SSC_Type) GetIMR_RXSYN() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}

// SSC.RPR: Receive Pointer Register
func (o *SSC_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *SSC_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// SSC.RCR: Receive Counter Register
func (o *SSC_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// SSC.TPR: Transmit Pointer Register
func (o *SSC_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *SSC_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// SSC.TCR: Transmit Counter Register
func (o *SSC_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// SSC.RNPR: Receive Next Pointer Register
func (o *SSC_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *SSC_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// SSC.RNCR: Receive Next Counter Register
func (o *SSC_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// SSC.TNPR: Transmit Next Pointer Register
func (o *SSC_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *SSC_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// SSC.TNCR: Transmit Next Counter Register
func (o *SSC_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *SSC_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// SSC.PTCR: Transfer Control Register
func (o *SSC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *SSC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *SSC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *SSC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *SSC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *SSC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// SSC.PTSR: Transfer Status Register
func (o *SSC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *SSC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *SSC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *SSC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [192]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// SPI.CR: Control Register
func (o *SPI_Type) SetCR_SPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR_SPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SPI_Type) SetCR_SPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR_SPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// SPI.MR: Mode Register
func (o *SPI_Type) SetMR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMR_MSTR() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SPI_Type) SetMR_PS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetMR_PS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetMR_PCSDEC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetMR_PCSDEC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetMR_MODFDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetMR_MODFDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetMR_PCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetMR_PCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetMR_DLYBCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetMR_DLYBCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SPI.RDR: Receive Data Register
func (o *SPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}
func (o *SPI_Type) SetRDR_PCS(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetRDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.RDR.Reg) & 0xf0000) >> 16
}

// SPI.TDR: Transmit Data Register
func (o *SPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}
func (o *SPI_Type) SetTDR_PCS(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetTDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetTDR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetTDR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0x1000000) >> 24
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_NSSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetSR_SPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetSR_SPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// SPI.IER: Interrupt Enable Register
func (o *SPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIER_MODF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIER_MODF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIER_NSSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIER_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}

// SPI.IDR: Interrupt Disable Register
func (o *SPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIDR_MODF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIDR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIDR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIDR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}

// SPI.IMR: Interrupt Mask Register
func (o *SPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIMR_MODF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIMR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetIMR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIMR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}

// SPI.CSR: Chip Select Register
func (o *SPI_Type) SetCSR_CPOL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCSR_CPOL(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *SPI_Type) SetCSR_NCPHA(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCSR_NCPHA(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCSR_CSAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCSR_CSAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCSR_BITS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCSR_BITS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCSR_SCBR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetCSR_SCBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff00) >> 8
}
func (o *SPI_Type) SetCSR_DLYBS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *SPI_Type) GetCSR_DLYBS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff0000) >> 16
}
func (o *SPI_Type) SetCSR_DLYBCT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetCSR_DLYBCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff000000) >> 24
}

// SPI.RPR: Receive Pointer Register
func (o *SPI_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *SPI_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// SPI.RCR: Receive Counter Register
func (o *SPI_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// SPI.TPR: Transmit Pointer Register
func (o *SPI_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *SPI_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// SPI.TCR: Transmit Counter Register
func (o *SPI_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// SPI.RNPR: Receive Next Pointer Register
func (o *SPI_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *SPI_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// SPI.RNCR: Receive Next Counter Register
func (o *SPI_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// SPI.TNPR: Transmit Next Pointer Register
func (o *SPI_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *SPI_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// SPI.TNCR: Transmit Next Counter Register
func (o *SPI_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// SPI.PTCR: Transfer Control Register
func (o *SPI_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *SPI_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// SPI.PTSR: Transfer Status Register
func (o *SPI_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *SPI_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// AC97 Controller
type AC97C_Type struct {
	_     [8]byte
	MR    volatile.Register32 // 0x8
	_     [4]byte
	ICA   volatile.Register32 // 0x10
	OCA   volatile.Register32 // 0x14
	_     [8]byte
	CARHR volatile.Register32 // 0x20
	CATHR volatile.Register32 // 0x24
	CASR  volatile.Register32 // 0x28
	CAMR  volatile.Register32 // 0x2C
	CBRHR volatile.Register32 // 0x30
	CBTHR volatile.Register32 // 0x34
	CBSR  volatile.Register32 // 0x38
	CBMR  volatile.Register32 // 0x3C
	CORHR volatile.Register32 // 0x40
	COTHR volatile.Register32 // 0x44
	COSR  volatile.Register32 // 0x48
	COMR  volatile.Register32 // 0x4C
	SR    volatile.Register32 // 0x50
	IER   volatile.Register32 // 0x54
	IDR   volatile.Register32 // 0x58
	IMR   volatile.Register32 // 0x5C
	_     [160]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	TPR   volatile.Register32 // 0x108
	TCR   volatile.Register32 // 0x10C
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	TNPR  volatile.Register32 // 0x118
	TNCR  volatile.Register32 // 0x11C
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
}

// AC97C.MR: Mode Register
func (o *AC97C_Type) SetMR_ENA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetMR_ENA() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *AC97C_Type) SetMR_WRST(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetMR_WRST() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetMR_VRA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetMR_VRA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}

// AC97C.ICA: Input Channel Assignment Register
func (o *AC97C_Type) SetICA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ICA.Reg, volatile.LoadUint32(&o.ICA.Reg)&^(0x7)|value)
}
func (o *AC97C_Type) GetICA_CHID3() uint32 {
	return volatile.LoadUint32(&o.ICA.Reg) & 0x7
}
func (o *AC97C_Type) SetICA_CHID4(value uint32) {
	volatile.StoreUint32(&o.ICA.Reg, volatile.LoadUint32(&o.ICA.Reg)&^(0x38)|value<<3)
}
func (o *AC97C_Type) GetICA_CHID4() uint32 {
	return (volatile.LoadUint32(&o.ICA.Reg) & 0x38) >> 3
}
func (o *AC97C_Type) SetICA_CHID5(value uint32) {
	volatile.StoreUint32(&o.ICA.Reg, volatile.LoadUint32(&o.ICA.Reg)&^(0x1c0)|value<<6)
}
func (o *AC97C_Type) GetICA_CHID5() uint32 {
	return (volatile.LoadUint32(&o.ICA.Reg) & 0x1c0) >> 6
}
func (o *AC97C_Type) SetICA_CHID6(value uint32) {
	volatile.StoreUint32(&o.ICA.Reg, volatile.LoadUint32(&o.ICA.Reg)&^(0xe00)|value<<9)
}
func (o *AC97C_Type) GetICA_CHID6() uint32 {
	return (volatile.LoadUint32(&o.ICA.Reg) & 0xe00) >> 9
}
func (o *AC97C_Type) SetICA_CHID7(value uint32) {
	volatile.StoreUint32(&o.ICA.Reg, volatile.LoadUint32(&o.ICA.Reg)&^(0x7000)|value<<12)
}
func (o *AC97C_Type) GetICA_CHID7() uint32 {
	return (volatile.LoadUint32(&o.ICA.Reg) & 0x7000) >> 12
}
func (o *AC97C_Type) SetICA_CHID8(value uint32) {
	volatile.StoreUint32(&o.ICA.Reg, volatile.LoadUint32(&o.ICA.Reg)&^(0x38000)|value<<15)
}
func (o *AC97C_Type) GetICA_CHID8() uint32 {
	return (volatile.LoadUint32(&o.ICA.Reg) & 0x38000) >> 15
}
func (o *AC97C_Type) SetICA_CHID9(value uint32) {
	volatile.StoreUint32(&o.ICA.Reg, volatile.LoadUint32(&o.ICA.Reg)&^(0x1c0000)|value<<18)
}
func (o *AC97C_Type) GetICA_CHID9() uint32 {
	return (volatile.LoadUint32(&o.ICA.Reg) & 0x1c0000) >> 18
}
func (o *AC97C_Type) SetICA_CHID10(value uint32) {
	volatile.StoreUint32(&o.ICA.Reg, volatile.LoadUint32(&o.ICA.Reg)&^(0xe00000)|value<<21)
}
func (o *AC97C_Type) GetICA_CHID10() uint32 {
	return (volatile.LoadUint32(&o.ICA.Reg) & 0xe00000) >> 21
}
func (o *AC97C_Type) SetICA_CHID11(value uint32) {
	volatile.StoreUint32(&o.ICA.Reg, volatile.LoadUint32(&o.ICA.Reg)&^(0x7000000)|value<<24)
}
func (o *AC97C_Type) GetICA_CHID11() uint32 {
	return (volatile.LoadUint32(&o.ICA.Reg) & 0x7000000) >> 24
}
func (o *AC97C_Type) SetICA_CHID12(value uint32) {
	volatile.StoreUint32(&o.ICA.Reg, volatile.LoadUint32(&o.ICA.Reg)&^(0x38000000)|value<<27)
}
func (o *AC97C_Type) GetICA_CHID12() uint32 {
	return (volatile.LoadUint32(&o.ICA.Reg) & 0x38000000) >> 27
}

// AC97C.OCA: Output Channel Assignment Register
func (o *AC97C_Type) SetOCA_CHID3(value uint32) {
	volatile.StoreUint32(&o.OCA.Reg, volatile.LoadUint32(&o.OCA.Reg)&^(0x7)|value)
}
func (o *AC97C_Type) GetOCA_CHID3() uint32 {
	return volatile.LoadUint32(&o.OCA.Reg) & 0x7
}
func (o *AC97C_Type) SetOCA_CHID4(value uint32) {
	volatile.StoreUint32(&o.OCA.Reg, volatile.LoadUint32(&o.OCA.Reg)&^(0x38)|value<<3)
}
func (o *AC97C_Type) GetOCA_CHID4() uint32 {
	return (volatile.LoadUint32(&o.OCA.Reg) & 0x38) >> 3
}
func (o *AC97C_Type) SetOCA_CHID5(value uint32) {
	volatile.StoreUint32(&o.OCA.Reg, volatile.LoadUint32(&o.OCA.Reg)&^(0x1c0)|value<<6)
}
func (o *AC97C_Type) GetOCA_CHID5() uint32 {
	return (volatile.LoadUint32(&o.OCA.Reg) & 0x1c0) >> 6
}
func (o *AC97C_Type) SetOCA_CHID6(value uint32) {
	volatile.StoreUint32(&o.OCA.Reg, volatile.LoadUint32(&o.OCA.Reg)&^(0xe00)|value<<9)
}
func (o *AC97C_Type) GetOCA_CHID6() uint32 {
	return (volatile.LoadUint32(&o.OCA.Reg) & 0xe00) >> 9
}
func (o *AC97C_Type) SetOCA_CHID7(value uint32) {
	volatile.StoreUint32(&o.OCA.Reg, volatile.LoadUint32(&o.OCA.Reg)&^(0x7000)|value<<12)
}
func (o *AC97C_Type) GetOCA_CHID7() uint32 {
	return (volatile.LoadUint32(&o.OCA.Reg) & 0x7000) >> 12
}
func (o *AC97C_Type) SetOCA_CHID8(value uint32) {
	volatile.StoreUint32(&o.OCA.Reg, volatile.LoadUint32(&o.OCA.Reg)&^(0x38000)|value<<15)
}
func (o *AC97C_Type) GetOCA_CHID8() uint32 {
	return (volatile.LoadUint32(&o.OCA.Reg) & 0x38000) >> 15
}
func (o *AC97C_Type) SetOCA_CHID9(value uint32) {
	volatile.StoreUint32(&o.OCA.Reg, volatile.LoadUint32(&o.OCA.Reg)&^(0x1c0000)|value<<18)
}
func (o *AC97C_Type) GetOCA_CHID9() uint32 {
	return (volatile.LoadUint32(&o.OCA.Reg) & 0x1c0000) >> 18
}
func (o *AC97C_Type) SetOCA_CHID10(value uint32) {
	volatile.StoreUint32(&o.OCA.Reg, volatile.LoadUint32(&o.OCA.Reg)&^(0xe00000)|value<<21)
}
func (o *AC97C_Type) GetOCA_CHID10() uint32 {
	return (volatile.LoadUint32(&o.OCA.Reg) & 0xe00000) >> 21
}
func (o *AC97C_Type) SetOCA_CHID11(value uint32) {
	volatile.StoreUint32(&o.OCA.Reg, volatile.LoadUint32(&o.OCA.Reg)&^(0x7000000)|value<<24)
}
func (o *AC97C_Type) GetOCA_CHID11() uint32 {
	return (volatile.LoadUint32(&o.OCA.Reg) & 0x7000000) >> 24
}
func (o *AC97C_Type) SetOCA_CHID12(value uint32) {
	volatile.StoreUint32(&o.OCA.Reg, volatile.LoadUint32(&o.OCA.Reg)&^(0x38000000)|value<<27)
}
func (o *AC97C_Type) GetOCA_CHID12() uint32 {
	return (volatile.LoadUint32(&o.OCA.Reg) & 0x38000000) >> 27
}

// AC97C.CARHR: Channel A Receive Holding Register
func (o *AC97C_Type) SetCARHR_RDATA(value uint32) {
	volatile.StoreUint32(&o.CARHR.Reg, volatile.LoadUint32(&o.CARHR.Reg)&^(0xfffff)|value)
}
func (o *AC97C_Type) GetCARHR_RDATA() uint32 {
	return volatile.LoadUint32(&o.CARHR.Reg) & 0xfffff
}

// AC97C.CATHR: Channel A Transmit Holding Register
func (o *AC97C_Type) SetCATHR_TDATA(value uint32) {
	volatile.StoreUint32(&o.CATHR.Reg, volatile.LoadUint32(&o.CATHR.Reg)&^(0xfffff)|value)
}
func (o *AC97C_Type) GetCATHR_TDATA() uint32 {
	return volatile.LoadUint32(&o.CATHR.Reg) & 0xfffff
}

// AC97C.CASR: Channel A Status Register
func (o *AC97C_Type) SetCASR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CASR.Reg, volatile.LoadUint32(&o.CASR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetCASR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.CASR.Reg) & 0x1
}
func (o *AC97C_Type) SetCASR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CASR.Reg, volatile.LoadUint32(&o.CASR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetCASR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CASR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetCASR_UNRUN(value uint32) {
	volatile.StoreUint32(&o.CASR.Reg, volatile.LoadUint32(&o.CASR.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetCASR_UNRUN() uint32 {
	return (volatile.LoadUint32(&o.CASR.Reg) & 0x4) >> 2
}
func (o *AC97C_Type) SetCASR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CASR.Reg, volatile.LoadUint32(&o.CASR.Reg)&^(0x10)|value<<4)
}
func (o *AC97C_Type) GetCASR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.CASR.Reg) & 0x10) >> 4
}
func (o *AC97C_Type) SetCASR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.CASR.Reg, volatile.LoadUint32(&o.CASR.Reg)&^(0x20)|value<<5)
}
func (o *AC97C_Type) GetCASR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.CASR.Reg) & 0x20) >> 5
}
func (o *AC97C_Type) SetCASR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.CASR.Reg, volatile.LoadUint32(&o.CASR.Reg)&^(0x400)|value<<10)
}
func (o *AC97C_Type) GetCASR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.CASR.Reg) & 0x400) >> 10
}
func (o *AC97C_Type) SetCASR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.CASR.Reg, volatile.LoadUint32(&o.CASR.Reg)&^(0x800)|value<<11)
}
func (o *AC97C_Type) GetCASR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.CASR.Reg) & 0x800) >> 11
}
func (o *AC97C_Type) SetCASR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.CASR.Reg, volatile.LoadUint32(&o.CASR.Reg)&^(0x4000)|value<<14)
}
func (o *AC97C_Type) GetCASR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.CASR.Reg) & 0x4000) >> 14
}
func (o *AC97C_Type) SetCASR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.CASR.Reg, volatile.LoadUint32(&o.CASR.Reg)&^(0x8000)|value<<15)
}
func (o *AC97C_Type) GetCASR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.CASR.Reg) & 0x8000) >> 15
}

// AC97C.CAMR: Channel A Mode Register
func (o *AC97C_Type) SetCAMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetCAMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.CAMR.Reg) & 0x1
}
func (o *AC97C_Type) SetCAMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetCAMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetCAMR_UNRUN(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetCAMR_UNRUN() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x4) >> 2
}
func (o *AC97C_Type) SetCAMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x10)|value<<4)
}
func (o *AC97C_Type) GetCAMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x10) >> 4
}
func (o *AC97C_Type) SetCAMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x20)|value<<5)
}
func (o *AC97C_Type) GetCAMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x20) >> 5
}
func (o *AC97C_Type) SetCAMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x400)|value<<10)
}
func (o *AC97C_Type) GetCAMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x400) >> 10
}
func (o *AC97C_Type) SetCAMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x800)|value<<11)
}
func (o *AC97C_Type) GetCAMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x800) >> 11
}
func (o *AC97C_Type) SetCAMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x4000)|value<<14)
}
func (o *AC97C_Type) GetCAMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x4000) >> 14
}
func (o *AC97C_Type) SetCAMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x8000)|value<<15)
}
func (o *AC97C_Type) GetCAMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x8000) >> 15
}
func (o *AC97C_Type) SetCAMR_SIZE(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x30000)|value<<16)
}
func (o *AC97C_Type) GetCAMR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x30000) >> 16
}
func (o *AC97C_Type) SetCAMR_CEM(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x40000)|value<<18)
}
func (o *AC97C_Type) GetCAMR_CEM() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x40000) >> 18
}
func (o *AC97C_Type) SetCAMR_CEN(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x200000)|value<<21)
}
func (o *AC97C_Type) GetCAMR_CEN() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x200000) >> 21
}
func (o *AC97C_Type) SetCAMR_PDCEN(value uint32) {
	volatile.StoreUint32(&o.CAMR.Reg, volatile.LoadUint32(&o.CAMR.Reg)&^(0x400000)|value<<22)
}
func (o *AC97C_Type) GetCAMR_PDCEN() uint32 {
	return (volatile.LoadUint32(&o.CAMR.Reg) & 0x400000) >> 22
}

// AC97C.CBRHR: Channel B Receive Holding Register
func (o *AC97C_Type) SetCBRHR_RDATA(value uint32) {
	volatile.StoreUint32(&o.CBRHR.Reg, volatile.LoadUint32(&o.CBRHR.Reg)&^(0xfffff)|value)
}
func (o *AC97C_Type) GetCBRHR_RDATA() uint32 {
	return volatile.LoadUint32(&o.CBRHR.Reg) & 0xfffff
}

// AC97C.CBTHR: Channel B Transmit Holding Register
func (o *AC97C_Type) SetCBTHR_TDATA(value uint32) {
	volatile.StoreUint32(&o.CBTHR.Reg, volatile.LoadUint32(&o.CBTHR.Reg)&^(0xfffff)|value)
}
func (o *AC97C_Type) GetCBTHR_TDATA() uint32 {
	return volatile.LoadUint32(&o.CBTHR.Reg) & 0xfffff
}

// AC97C.CBSR: Channel B Status Register
func (o *AC97C_Type) SetCBSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CBSR.Reg, volatile.LoadUint32(&o.CBSR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetCBSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.CBSR.Reg) & 0x1
}
func (o *AC97C_Type) SetCBSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CBSR.Reg, volatile.LoadUint32(&o.CBSR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetCBSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CBSR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetCBSR_UNRUN(value uint32) {
	volatile.StoreUint32(&o.CBSR.Reg, volatile.LoadUint32(&o.CBSR.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetCBSR_UNRUN() uint32 {
	return (volatile.LoadUint32(&o.CBSR.Reg) & 0x4) >> 2
}
func (o *AC97C_Type) SetCBSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CBSR.Reg, volatile.LoadUint32(&o.CBSR.Reg)&^(0x10)|value<<4)
}
func (o *AC97C_Type) GetCBSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.CBSR.Reg) & 0x10) >> 4
}
func (o *AC97C_Type) SetCBSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.CBSR.Reg, volatile.LoadUint32(&o.CBSR.Reg)&^(0x20)|value<<5)
}
func (o *AC97C_Type) GetCBSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.CBSR.Reg) & 0x20) >> 5
}
func (o *AC97C_Type) SetCBSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.CBSR.Reg, volatile.LoadUint32(&o.CBSR.Reg)&^(0x200)|value<<9)
}
func (o *AC97C_Type) GetCBSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.CBSR.Reg) & 0x200) >> 9
}
func (o *AC97C_Type) SetCBSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.CBSR.Reg, volatile.LoadUint32(&o.CBSR.Reg)&^(0x400)|value<<10)
}
func (o *AC97C_Type) GetCBSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.CBSR.Reg) & 0x400) >> 10
}
func (o *AC97C_Type) SetCBSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.CBSR.Reg, volatile.LoadUint32(&o.CBSR.Reg)&^(0x4000)|value<<14)
}
func (o *AC97C_Type) GetCBSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.CBSR.Reg) & 0x4000) >> 14
}
func (o *AC97C_Type) SetCBSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.CBSR.Reg, volatile.LoadUint32(&o.CBSR.Reg)&^(0x8000)|value<<15)
}
func (o *AC97C_Type) GetCBSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.CBSR.Reg) & 0x8000) >> 15
}

// AC97C.CBMR: Channel B Mode Register
func (o *AC97C_Type) SetCBMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetCBMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.CBMR.Reg) & 0x1
}
func (o *AC97C_Type) SetCBMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetCBMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetCBMR_UNRUN(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetCBMR_UNRUN() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x4) >> 2
}
func (o *AC97C_Type) SetCBMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x10)|value<<4)
}
func (o *AC97C_Type) GetCBMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x10) >> 4
}
func (o *AC97C_Type) SetCBMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x20)|value<<5)
}
func (o *AC97C_Type) GetCBMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x20) >> 5
}
func (o *AC97C_Type) SetCBMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x400)|value<<10)
}
func (o *AC97C_Type) GetCBMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x400) >> 10
}
func (o *AC97C_Type) SetCBMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x800)|value<<11)
}
func (o *AC97C_Type) GetCBMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x800) >> 11
}
func (o *AC97C_Type) SetCBMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x4000)|value<<14)
}
func (o *AC97C_Type) GetCBMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x4000) >> 14
}
func (o *AC97C_Type) SetCBMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x8000)|value<<15)
}
func (o *AC97C_Type) GetCBMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x8000) >> 15
}
func (o *AC97C_Type) SetCBMR_SIZE(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x30000)|value<<16)
}
func (o *AC97C_Type) GetCBMR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x30000) >> 16
}
func (o *AC97C_Type) SetCBMR_CEM(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x40000)|value<<18)
}
func (o *AC97C_Type) GetCBMR_CEM() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x40000) >> 18
}
func (o *AC97C_Type) SetCBMR_CEN(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x200000)|value<<21)
}
func (o *AC97C_Type) GetCBMR_CEN() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x200000) >> 21
}
func (o *AC97C_Type) SetCBMR_PDCEN(value uint32) {
	volatile.StoreUint32(&o.CBMR.Reg, volatile.LoadUint32(&o.CBMR.Reg)&^(0x400000)|value<<22)
}
func (o *AC97C_Type) GetCBMR_PDCEN() uint32 {
	return (volatile.LoadUint32(&o.CBMR.Reg) & 0x400000) >> 22
}

// AC97C.CORHR: Codec Channel Receive Holding Register
func (o *AC97C_Type) SetCORHR_SDATA(value uint32) {
	volatile.StoreUint32(&o.CORHR.Reg, volatile.LoadUint32(&o.CORHR.Reg)&^(0xffff)|value)
}
func (o *AC97C_Type) GetCORHR_SDATA() uint32 {
	return volatile.LoadUint32(&o.CORHR.Reg) & 0xffff
}

// AC97C.COTHR: Codec Channel Transmit Holding Register
func (o *AC97C_Type) SetCOTHR_CDATA(value uint32) {
	volatile.StoreUint32(&o.COTHR.Reg, volatile.LoadUint32(&o.COTHR.Reg)&^(0xffff)|value)
}
func (o *AC97C_Type) GetCOTHR_CDATA() uint32 {
	return volatile.LoadUint32(&o.COTHR.Reg) & 0xffff
}
func (o *AC97C_Type) SetCOTHR_CADDR(value uint32) {
	volatile.StoreUint32(&o.COTHR.Reg, volatile.LoadUint32(&o.COTHR.Reg)&^(0x7f0000)|value<<16)
}
func (o *AC97C_Type) GetCOTHR_CADDR() uint32 {
	return (volatile.LoadUint32(&o.COTHR.Reg) & 0x7f0000) >> 16
}
func (o *AC97C_Type) SetCOTHR_READ(value uint32) {
	volatile.StoreUint32(&o.COTHR.Reg, volatile.LoadUint32(&o.COTHR.Reg)&^(0x800000)|value<<23)
}
func (o *AC97C_Type) GetCOTHR_READ() uint32 {
	return (volatile.LoadUint32(&o.COTHR.Reg) & 0x800000) >> 23
}

// AC97C.COSR: Codec Status Register
func (o *AC97C_Type) SetCOSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.COSR.Reg, volatile.LoadUint32(&o.COSR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetCOSR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.COSR.Reg) & 0x1
}
func (o *AC97C_Type) SetCOSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.COSR.Reg, volatile.LoadUint32(&o.COSR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetCOSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.COSR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetCOSR_UNRUN(value uint32) {
	volatile.StoreUint32(&o.COSR.Reg, volatile.LoadUint32(&o.COSR.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetCOSR_UNRUN() uint32 {
	return (volatile.LoadUint32(&o.COSR.Reg) & 0x4) >> 2
}
func (o *AC97C_Type) SetCOSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.COSR.Reg, volatile.LoadUint32(&o.COSR.Reg)&^(0x10)|value<<4)
}
func (o *AC97C_Type) GetCOSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.COSR.Reg) & 0x10) >> 4
}
func (o *AC97C_Type) SetCOSR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.COSR.Reg, volatile.LoadUint32(&o.COSR.Reg)&^(0x20)|value<<5)
}
func (o *AC97C_Type) GetCOSR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.COSR.Reg) & 0x20) >> 5
}

// AC97C.COMR: Codec Mode Register
func (o *AC97C_Type) SetCOMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.COMR.Reg, volatile.LoadUint32(&o.COMR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetCOMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.COMR.Reg) & 0x1
}
func (o *AC97C_Type) SetCOMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.COMR.Reg, volatile.LoadUint32(&o.COMR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetCOMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.COMR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetCOMR_UNRUN(value uint32) {
	volatile.StoreUint32(&o.COMR.Reg, volatile.LoadUint32(&o.COMR.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetCOMR_UNRUN() uint32 {
	return (volatile.LoadUint32(&o.COMR.Reg) & 0x4) >> 2
}
func (o *AC97C_Type) SetCOMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.COMR.Reg, volatile.LoadUint32(&o.COMR.Reg)&^(0x10)|value<<4)
}
func (o *AC97C_Type) GetCOMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.COMR.Reg) & 0x10) >> 4
}
func (o *AC97C_Type) SetCOMR_OVRUN(value uint32) {
	volatile.StoreUint32(&o.COMR.Reg, volatile.LoadUint32(&o.COMR.Reg)&^(0x20)|value<<5)
}
func (o *AC97C_Type) GetCOMR_OVRUN() uint32 {
	return (volatile.LoadUint32(&o.COMR.Reg) & 0x20) >> 5
}

// AC97C.SR: Status Register
func (o *AC97C_Type) SetSR_SOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetSR_SOF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *AC97C_Type) SetSR_WKUP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetSR_WKUP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetSR_COEVT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetSR_COEVT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *AC97C_Type) SetSR_CAEVT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *AC97C_Type) GetSR_CAEVT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *AC97C_Type) SetSR_CBEVT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *AC97C_Type) GetSR_CBEVT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}

// AC97C.IER: Interrupt Enable Register
func (o *AC97C_Type) SetIER_SOF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetIER_SOF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *AC97C_Type) SetIER_WKUP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetIER_WKUP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetIER_COEVT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetIER_COEVT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *AC97C_Type) SetIER_CAEVT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *AC97C_Type) GetIER_CAEVT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *AC97C_Type) SetIER_CBEVT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *AC97C_Type) GetIER_CBEVT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}

// AC97C.IDR: Interrupt Disable Register
func (o *AC97C_Type) SetIDR_SOF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetIDR_SOF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *AC97C_Type) SetIDR_WKUP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetIDR_WKUP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetIDR_COEVT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetIDR_COEVT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *AC97C_Type) SetIDR_CAEVT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *AC97C_Type) GetIDR_CAEVT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *AC97C_Type) SetIDR_CBEVT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *AC97C_Type) GetIDR_CBEVT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}

// AC97C.IMR: Interrupt Mask Register
func (o *AC97C_Type) SetIMR_SOF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetIMR_SOF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *AC97C_Type) SetIMR_WKUP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetIMR_WKUP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetIMR_COEVT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *AC97C_Type) GetIMR_COEVT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *AC97C_Type) SetIMR_CAEVT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *AC97C_Type) GetIMR_CAEVT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *AC97C_Type) SetIMR_CBEVT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *AC97C_Type) GetIMR_CBEVT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}

// AC97C.RPR: Receive Pointer Register
func (o *AC97C_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *AC97C_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// AC97C.RCR: Receive Counter Register
func (o *AC97C_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *AC97C_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// AC97C.TPR: Transmit Pointer Register
func (o *AC97C_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *AC97C_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// AC97C.TCR: Transmit Counter Register
func (o *AC97C_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *AC97C_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// AC97C.RNPR: Receive Next Pointer Register
func (o *AC97C_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *AC97C_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// AC97C.RNCR: Receive Next Counter Register
func (o *AC97C_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *AC97C_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// AC97C.TNPR: Transmit Next Pointer Register
func (o *AC97C_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *AC97C_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// AC97C.TNCR: Transmit Next Counter Register
func (o *AC97C_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *AC97C_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// AC97C.PTCR: Transfer Control Register
func (o *AC97C_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *AC97C_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *AC97C_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *AC97C_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *AC97C_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *AC97C_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *AC97C_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// AC97C.PTSR: Transfer Status Register
func (o *AC97C_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *AC97C_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *AC97C_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *AC97C_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Touch Screen ADC Controller
type TSADCC_Type struct {
	CR   volatile.Register32    // 0x0
	MR   volatile.Register32    // 0x4
	TRGR volatile.Register32    // 0x8
	TSR  volatile.Register32    // 0xC
	CHER volatile.Register32    // 0x10
	CHDR volatile.Register32    // 0x14
	CHSR volatile.Register32    // 0x18
	SR   volatile.Register32    // 0x1C
	LCDR volatile.Register32    // 0x20
	IER  volatile.Register32    // 0x24
	IDR  volatile.Register32    // 0x28
	IMR  volatile.Register32    // 0x2C
	CDR  [8]volatile.Register32 // 0x30
	XPDR volatile.Register32    // 0x50
	Z1DR volatile.Register32    // 0x54
	Z2DR volatile.Register32    // 0x58
	_    [4]byte
	MSCR volatile.Register32 // 0x60
	_    [128]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	_    [8]byte
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	_    [8]byte
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// TSADCC.CR: Control Register
func (o *TSADCC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TSADCC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TSADCC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}

// TSADCC.MR: Mode Register
func (o *TSADCC_Type) SetMR_TSAMOD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3)|value)
}
func (o *TSADCC_Type) GetMR_TSAMOD() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x3
}
func (o *TSADCC_Type) SetMR_PDCEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x8)|value<<3)
}
func (o *TSADCC_Type) GetMR_PDCEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x8) >> 3
}
func (o *TSADCC_Type) SetMR_LOWRES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *TSADCC_Type) GetMR_LOWRES() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *TSADCC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *TSADCC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *TSADCC_Type) SetMR_PENDET(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *TSADCC_Type) GetMR_PENDET() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *TSADCC_Type) SetMR_PRES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *TSADCC_Type) GetMR_PRES() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *TSADCC_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *TSADCC_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *TSADCC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TSADCC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7f0000) >> 16
}
func (o *TSADCC_Type) SetMR_SHTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *TSADCC_Type) GetMR_SHTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}
func (o *TSADCC_Type) SetMR_PENDBC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000000)|value<<28)
}
func (o *TSADCC_Type) GetMR_PENDBC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000000) >> 28
}

// TSADCC.TRGR: Trigger Register
func (o *TSADCC_Type) SetTRGR_TRGMOD(value uint32) {
	volatile.StoreUint32(&o.TRGR.Reg, volatile.LoadUint32(&o.TRGR.Reg)&^(0x7)|value)
}
func (o *TSADCC_Type) GetTRGR_TRGMOD() uint32 {
	return volatile.LoadUint32(&o.TRGR.Reg) & 0x7
}
func (o *TSADCC_Type) SetTRGR_TRGPER(value uint32) {
	volatile.StoreUint32(&o.TRGR.Reg, volatile.LoadUint32(&o.TRGR.Reg)&^(0xffff0000)|value<<16)
}
func (o *TSADCC_Type) GetTRGR_TRGPER() uint32 {
	return (volatile.LoadUint32(&o.TRGR.Reg) & 0xffff0000) >> 16
}

// TSADCC.TSR: Touch Screen Register
func (o *TSADCC_Type) SetTSR_TSFREQ(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0xf)|value)
}
func (o *TSADCC_Type) GetTSR_TSFREQ() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0xf
}
func (o *TSADCC_Type) SetTSR_TSSHTIM(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0xf000000)|value<<24)
}
func (o *TSADCC_Type) GetTSR_TSSHTIM() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0xf000000) >> 24
}

// TSADCC.CHER: Channel Enable Register
func (o *TSADCC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *TSADCC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *TSADCC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *TSADCC_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *TSADCC_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *TSADCC_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *TSADCC_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *TSADCC_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *TSADCC_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *TSADCC_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *TSADCC_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *TSADCC_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *TSADCC_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *TSADCC_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *TSADCC_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}

// TSADCC.CHDR: Channel Disable Register
func (o *TSADCC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *TSADCC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *TSADCC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *TSADCC_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *TSADCC_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *TSADCC_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *TSADCC_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *TSADCC_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *TSADCC_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *TSADCC_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *TSADCC_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *TSADCC_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *TSADCC_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *TSADCC_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *TSADCC_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}

// TSADCC.CHSR: Channel Status Register
func (o *TSADCC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *TSADCC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *TSADCC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *TSADCC_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *TSADCC_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *TSADCC_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *TSADCC_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *TSADCC_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *TSADCC_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *TSADCC_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *TSADCC_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *TSADCC_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *TSADCC_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *TSADCC_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *TSADCC_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}

// TSADCC.SR: Status Register
func (o *TSADCC_Type) SetSR_EOC0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetSR_EOC0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TSADCC_Type) SetSR_EOC1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TSADCC_Type) GetSR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TSADCC_Type) SetSR_EOC2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TSADCC_Type) GetSR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TSADCC_Type) SetSR_EOC3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TSADCC_Type) GetSR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TSADCC_Type) SetSR_EOC4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TSADCC_Type) GetSR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TSADCC_Type) SetSR_EOC5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TSADCC_Type) GetSR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TSADCC_Type) SetSR_EOC6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TSADCC_Type) GetSR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TSADCC_Type) SetSR_EOC7(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TSADCC_Type) GetSR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TSADCC_Type) SetSR_OVRE0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TSADCC_Type) GetSR_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TSADCC_Type) SetSR_OVRE1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TSADCC_Type) GetSR_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TSADCC_Type) SetSR_OVRE2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TSADCC_Type) GetSR_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TSADCC_Type) SetSR_OVRE3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TSADCC_Type) GetSR_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TSADCC_Type) SetSR_OVRE4(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TSADCC_Type) GetSR_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TSADCC_Type) SetSR_OVRE5(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *TSADCC_Type) GetSR_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *TSADCC_Type) SetSR_OVRE6(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *TSADCC_Type) GetSR_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *TSADCC_Type) SetSR_OVRE7(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *TSADCC_Type) GetSR_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *TSADCC_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *TSADCC_Type) GetSR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *TSADCC_Type) SetSR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *TSADCC_Type) GetSR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *TSADCC_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *TSADCC_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *TSADCC_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *TSADCC_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *TSADCC_Type) SetSR_PENCNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *TSADCC_Type) GetSR_PENCNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *TSADCC_Type) SetSR_NOCNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *TSADCC_Type) GetSR_NOCNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *TSADCC_Type) SetSR_EOCXP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSADCC_Type) GetSR_EOCXP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000000) >> 24
}
func (o *TSADCC_Type) SetSR_EOCZ1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSADCC_Type) GetSR_EOCZ1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000000) >> 25
}
func (o *TSADCC_Type) SetSR_EOCZ2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSADCC_Type) GetSR_EOCZ2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000000) >> 26
}
func (o *TSADCC_Type) SetSR_OVREXP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSADCC_Type) GetSR_OVREXP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000000) >> 28
}
func (o *TSADCC_Type) SetSR_OVREZ1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSADCC_Type) GetSR_OVREZ1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *TSADCC_Type) SetSR_OVREZ2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSADCC_Type) GetSR_OVREZ2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}

// TSADCC.LCDR: Last Converted Data Register
func (o *TSADCC_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0x3ff)|value)
}
func (o *TSADCC_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0x3ff
}

// TSADCC.IER: Interrupt Enable Register
func (o *TSADCC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TSADCC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TSADCC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TSADCC_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TSADCC_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TSADCC_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *TSADCC_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *TSADCC_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TSADCC_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TSADCC_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TSADCC_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TSADCC_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TSADCC_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TSADCC_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *TSADCC_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *TSADCC_Type) SetIER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TSADCC_Type) GetIER_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TSADCC_Type) SetIER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TSADCC_Type) GetIER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TSADCC_Type) SetIER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TSADCC_Type) GetIER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TSADCC_Type) SetIER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TSADCC_Type) GetIER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *TSADCC_Type) SetIER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *TSADCC_Type) GetIER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *TSADCC_Type) SetIER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *TSADCC_Type) GetIER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *TSADCC_Type) SetIER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *TSADCC_Type) GetIER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *TSADCC_Type) SetIER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *TSADCC_Type) GetIER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *TSADCC_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *TSADCC_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *TSADCC_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *TSADCC_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *TSADCC_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *TSADCC_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *TSADCC_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *TSADCC_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *TSADCC_Type) SetIER_PENCNT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *TSADCC_Type) GetIER_PENCNT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *TSADCC_Type) SetIER_NOCNT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *TSADCC_Type) GetIER_NOCNT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *TSADCC_Type) SetIER_EOCXP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *TSADCC_Type) GetIER_EOCXP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *TSADCC_Type) SetIER_EOCZ1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *TSADCC_Type) GetIER_EOCZ1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *TSADCC_Type) SetIER_EOCZ2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *TSADCC_Type) GetIER_EOCZ2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *TSADCC_Type) SetIER_OVREXP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *TSADCC_Type) GetIER_OVREXP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *TSADCC_Type) SetIER_OVREZ1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *TSADCC_Type) GetIER_OVREZ1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *TSADCC_Type) SetIER_OVREZ2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *TSADCC_Type) GetIER_OVREZ2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}

// TSADCC.IDR: Interrupt Disable Register
func (o *TSADCC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TSADCC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TSADCC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TSADCC_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TSADCC_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TSADCC_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *TSADCC_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *TSADCC_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TSADCC_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TSADCC_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TSADCC_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TSADCC_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TSADCC_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TSADCC_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *TSADCC_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *TSADCC_Type) SetIDR_OVRE0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TSADCC_Type) GetIDR_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TSADCC_Type) SetIDR_OVRE1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TSADCC_Type) GetIDR_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TSADCC_Type) SetIDR_OVRE2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TSADCC_Type) GetIDR_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TSADCC_Type) SetIDR_OVRE3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TSADCC_Type) GetIDR_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *TSADCC_Type) SetIDR_OVRE4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *TSADCC_Type) GetIDR_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *TSADCC_Type) SetIDR_OVRE5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *TSADCC_Type) GetIDR_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *TSADCC_Type) SetIDR_OVRE6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *TSADCC_Type) GetIDR_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *TSADCC_Type) SetIDR_OVRE7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *TSADCC_Type) GetIDR_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *TSADCC_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *TSADCC_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *TSADCC_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *TSADCC_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *TSADCC_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *TSADCC_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *TSADCC_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *TSADCC_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *TSADCC_Type) SetIDR_PENCNT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *TSADCC_Type) GetIDR_PENCNT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *TSADCC_Type) SetIDR_NOCNT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *TSADCC_Type) GetIDR_NOCNT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *TSADCC_Type) SetIDR_EOCXP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSADCC_Type) GetIDR_EOCXP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *TSADCC_Type) SetIDR_EOCZ1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSADCC_Type) GetIDR_EOCZ1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *TSADCC_Type) SetIDR_EOCZ2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSADCC_Type) GetIDR_EOCZ2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *TSADCC_Type) SetIDR_OVREXP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSADCC_Type) GetIDR_OVREXP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *TSADCC_Type) SetIDR_OVREZ1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSADCC_Type) GetIDR_OVREZ1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *TSADCC_Type) SetIDR_OVREZ2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSADCC_Type) GetIDR_OVREZ2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}

// TSADCC.IMR: Interrupt Mask Register
func (o *TSADCC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TSADCC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TSADCC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TSADCC_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TSADCC_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TSADCC_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *TSADCC_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *TSADCC_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TSADCC_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TSADCC_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TSADCC_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TSADCC_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TSADCC_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TSADCC_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *TSADCC_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *TSADCC_Type) SetIMR_OVRE0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TSADCC_Type) GetIMR_OVRE0() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TSADCC_Type) SetIMR_OVRE1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TSADCC_Type) GetIMR_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TSADCC_Type) SetIMR_OVRE2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TSADCC_Type) GetIMR_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TSADCC_Type) SetIMR_OVRE3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TSADCC_Type) GetIMR_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *TSADCC_Type) SetIMR_OVRE4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *TSADCC_Type) GetIMR_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *TSADCC_Type) SetIMR_OVRE5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *TSADCC_Type) GetIMR_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *TSADCC_Type) SetIMR_OVRE6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *TSADCC_Type) GetIMR_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *TSADCC_Type) SetIMR_OVRE7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *TSADCC_Type) GetIMR_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *TSADCC_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *TSADCC_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *TSADCC_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *TSADCC_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *TSADCC_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *TSADCC_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *TSADCC_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *TSADCC_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *TSADCC_Type) SetIMR_PENCNT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *TSADCC_Type) GetIMR_PENCNT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *TSADCC_Type) SetIMR_NOCNT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *TSADCC_Type) GetIMR_NOCNT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *TSADCC_Type) SetIMR_EOCXP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSADCC_Type) GetIMR_EOCXP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *TSADCC_Type) SetIMR_EOCZ1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSADCC_Type) GetIMR_EOCZ1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *TSADCC_Type) SetIMR_EOCZ2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSADCC_Type) GetIMR_EOCZ2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *TSADCC_Type) SetIMR_OVREXP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSADCC_Type) GetIMR_OVREXP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *TSADCC_Type) SetIMR_OVREZ1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSADCC_Type) GetIMR_OVREZ1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *TSADCC_Type) SetIMR_OVREZ2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSADCC_Type) GetIMR_OVREZ2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}

// TSADCC.CDR: Channel Data Register
func (o *TSADCC_Type) SetCDR_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0x3ff)|value)
}
func (o *TSADCC_Type) GetCDR_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0x3ff
}

// TSADCC.XPDR: X Position Data Register
func (o *TSADCC_Type) SetXPDR_DATA(value uint32) {
	volatile.StoreUint32(&o.XPDR.Reg, volatile.LoadUint32(&o.XPDR.Reg)&^(0x3ff)|value)
}
func (o *TSADCC_Type) GetXPDR_DATA() uint32 {
	return volatile.LoadUint32(&o.XPDR.Reg) & 0x3ff
}

// TSADCC.Z1DR: Z1 Data Register
func (o *TSADCC_Type) SetZ1DR_DATA(value uint32) {
	volatile.StoreUint32(&o.Z1DR.Reg, volatile.LoadUint32(&o.Z1DR.Reg)&^(0x3ff)|value)
}
func (o *TSADCC_Type) GetZ1DR_DATA() uint32 {
	return volatile.LoadUint32(&o.Z1DR.Reg) & 0x3ff
}

// TSADCC.Z2DR: Z2 Data Register
func (o *TSADCC_Type) SetZ2DR_Z2(value uint32) {
	volatile.StoreUint32(&o.Z2DR.Reg, volatile.LoadUint32(&o.Z2DR.Reg)&^(0x3ff)|value)
}
func (o *TSADCC_Type) GetZ2DR_Z2() uint32 {
	return volatile.LoadUint32(&o.Z2DR.Reg) & 0x3ff
}

// TSADCC.MSCR: Manual Switch Command Register
func (o *TSADCC_Type) SetMSCR_XP(value uint32) {
	volatile.StoreUint32(&o.MSCR.Reg, volatile.LoadUint32(&o.MSCR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetMSCR_XP() uint32 {
	return volatile.LoadUint32(&o.MSCR.Reg) & 0x1
}
func (o *TSADCC_Type) SetMSCR_XM(value uint32) {
	volatile.StoreUint32(&o.MSCR.Reg, volatile.LoadUint32(&o.MSCR.Reg)&^(0x2)|value<<1)
}
func (o *TSADCC_Type) GetMSCR_XM() uint32 {
	return (volatile.LoadUint32(&o.MSCR.Reg) & 0x2) >> 1
}
func (o *TSADCC_Type) SetMSCR_YP(value uint32) {
	volatile.StoreUint32(&o.MSCR.Reg, volatile.LoadUint32(&o.MSCR.Reg)&^(0x4)|value<<2)
}
func (o *TSADCC_Type) GetMSCR_YP() uint32 {
	return (volatile.LoadUint32(&o.MSCR.Reg) & 0x4) >> 2
}
func (o *TSADCC_Type) SetMSCR_YM(value uint32) {
	volatile.StoreUint32(&o.MSCR.Reg, volatile.LoadUint32(&o.MSCR.Reg)&^(0x8)|value<<3)
}
func (o *TSADCC_Type) GetMSCR_YM() uint32 {
	return (volatile.LoadUint32(&o.MSCR.Reg) & 0x8) >> 3
}

// TSADCC.WPMR: Write Protection Mode Register
func (o *TSADCC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *TSADCC_Type) SetWPMR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TSADCC_Type) GetWPMR_KEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// TSADCC.WPSR: Write Protection Status Register
func (o *TSADCC_Type) SetWPSR_WPS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetWPSR_WPS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *TSADCC_Type) SetWPSR_OFFSET_ERR(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TSADCC_Type) GetWPSR_OFFSET_ERR() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffffff00) >> 8
}

// TSADCC.RPR: Receive Pointer Register
func (o *TSADCC_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *TSADCC_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// TSADCC.RCR: Receive Counter Register
func (o *TSADCC_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *TSADCC_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// TSADCC.RNPR: Receive Next Pointer Register
func (o *TSADCC_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *TSADCC_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// TSADCC.RNCR: Receive Next Counter Register
func (o *TSADCC_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *TSADCC_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// TSADCC.PTCR: Transfer Control Register
func (o *TSADCC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *TSADCC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *TSADCC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *TSADCC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *TSADCC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *TSADCC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *TSADCC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// TSADCC.PTSR: Transfer Status Register
func (o *TSADCC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *TSADCC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *TSADCC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *TSADCC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Image Sensor Interface
type ISI_Type struct {
	ISI_CFG1     volatile.Register32 // 0x0
	ISI_CFG2     volatile.Register32 // 0x4
	ISI_PSIZE    volatile.Register32 // 0x8
	ISI_PDECF    volatile.Register32 // 0xC
	ISI_Y2R_SET0 volatile.Register32 // 0x10
	ISI_Y2R_SET1 volatile.Register32 // 0x14
	ISI_R2Y_SET0 volatile.Register32 // 0x18
	ISI_R2Y_SET1 volatile.Register32 // 0x1C
	ISI_R2Y_SET2 volatile.Register32 // 0x20
	ISI_CR       volatile.Register32 // 0x24
	ISI_SR       volatile.Register32 // 0x28
	ISI_IER      volatile.Register32 // 0x2C
	ISI_IDR      volatile.Register32 // 0x30
	ISI_IMR      volatile.Register32 // 0x34
	DMA_CHER     volatile.Register32 // 0x38
	DMA_CHDR     volatile.Register32 // 0x3C
	DMA_CHSR     volatile.Register32 // 0x40
	DMA_P_ADDR   volatile.Register32 // 0x44
	DMA_P_CTRL   volatile.Register32 // 0x48
	DMA_P_DSCR   volatile.Register32 // 0x4C
	DMA_C_ADDR   volatile.Register32 // 0x50
	DMA_C_CTRL   volatile.Register32 // 0x54
	DMA_C_DSCR   volatile.Register32 // 0x58
	_            [136]byte
	ISI_WPCR     volatile.Register32 // 0xE4
	ISI_WPSR     volatile.Register32 // 0xE8
}

// ISI.ISI_CFG1: ISI Configuration 1 Register
func (o *ISI_Type) SetISI_CFG1_HSYNC_POL(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_CFG1_HSYNC_POL() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_CFG1_VSYNC_POL(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetISI_CFG1_VSYNC_POL() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x8) >> 3
}
func (o *ISI_Type) SetISI_CFG1_PIXCLK_POL(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x10)|value<<4)
}
func (o *ISI_Type) GetISI_CFG1_PIXCLK_POL() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x10) >> 4
}
func (o *ISI_Type) SetISI_CFG1_EMB_SYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x40)|value<<6)
}
func (o *ISI_Type) GetISI_CFG1_EMB_SYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x40) >> 6
}
func (o *ISI_Type) SetISI_CFG1_CRC_SYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x80)|value<<7)
}
func (o *ISI_Type) GetISI_CFG1_CRC_SYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x80) >> 7
}
func (o *ISI_Type) SetISI_CFG1_FRATE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x700)|value<<8)
}
func (o *ISI_Type) GetISI_CFG1_FRATE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x700) >> 8
}
func (o *ISI_Type) SetISI_CFG1_DISCR(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x800)|value<<11)
}
func (o *ISI_Type) GetISI_CFG1_DISCR() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x800) >> 11
}
func (o *ISI_Type) SetISI_CFG1_FULL(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetISI_CFG1_FULL() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetISI_CFG1_THMASK(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0x6000)|value<<13)
}
func (o *ISI_Type) GetISI_CFG1_THMASK() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0x6000) >> 13
}
func (o *ISI_Type) SetISI_CFG1_SLD(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetISI_CFG1_SLD() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetISI_CFG1_SFD(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG1.Reg, volatile.LoadUint32(&o.ISI_CFG1.Reg)&^(0xff000000)|value<<24)
}
func (o *ISI_Type) GetISI_CFG1_SFD() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG1.Reg) & 0xff000000) >> 24
}

// ISI.ISI_CFG2: ISI Configuration 2 Register
func (o *ISI_Type) SetISI_CFG2_IM_VSIZE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x7ff)|value)
}
func (o *ISI_Type) GetISI_CFG2_IM_VSIZE() uint32 {
	return volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x7ff
}
func (o *ISI_Type) SetISI_CFG2_GS_MODE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x800)|value<<11)
}
func (o *ISI_Type) GetISI_CFG2_GS_MODE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x800) >> 11
}
func (o *ISI_Type) SetISI_CFG2_RGB_MODE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetISI_CFG2_RGB_MODE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetISI_CFG2_GRAYSCALE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x2000)|value<<13)
}
func (o *ISI_Type) GetISI_CFG2_GRAYSCALE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x2000) >> 13
}
func (o *ISI_Type) SetISI_CFG2_RGB_SWAP(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x4000)|value<<14)
}
func (o *ISI_Type) GetISI_CFG2_RGB_SWAP() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x4000) >> 14
}
func (o *ISI_Type) SetISI_CFG2_COL_SPACE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x8000)|value<<15)
}
func (o *ISI_Type) GetISI_CFG2_COL_SPACE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x8000) >> 15
}
func (o *ISI_Type) SetISI_CFG2_IM_HSIZE(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x7ff0000)|value<<16)
}
func (o *ISI_Type) GetISI_CFG2_IM_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x7ff0000) >> 16
}
func (o *ISI_Type) SetISI_CFG2_YCC_SWAP(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0x30000000)|value<<28)
}
func (o *ISI_Type) GetISI_CFG2_YCC_SWAP() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0x30000000) >> 28
}
func (o *ISI_Type) SetISI_CFG2_RGB_CFG(value uint32) {
	volatile.StoreUint32(&o.ISI_CFG2.Reg, volatile.LoadUint32(&o.ISI_CFG2.Reg)&^(0xc0000000)|value<<30)
}
func (o *ISI_Type) GetISI_CFG2_RGB_CFG() uint32 {
	return (volatile.LoadUint32(&o.ISI_CFG2.Reg) & 0xc0000000) >> 30
}

// ISI.ISI_PSIZE: ISI Preview Size Register
func (o *ISI_Type) SetISI_PSIZE_PREV_VSIZE(value uint32) {
	volatile.StoreUint32(&o.ISI_PSIZE.Reg, volatile.LoadUint32(&o.ISI_PSIZE.Reg)&^(0x3ff)|value)
}
func (o *ISI_Type) GetISI_PSIZE_PREV_VSIZE() uint32 {
	return volatile.LoadUint32(&o.ISI_PSIZE.Reg) & 0x3ff
}
func (o *ISI_Type) SetISI_PSIZE_PREV_HSIZE(value uint32) {
	volatile.StoreUint32(&o.ISI_PSIZE.Reg, volatile.LoadUint32(&o.ISI_PSIZE.Reg)&^(0x3ff0000)|value<<16)
}
func (o *ISI_Type) GetISI_PSIZE_PREV_HSIZE() uint32 {
	return (volatile.LoadUint32(&o.ISI_PSIZE.Reg) & 0x3ff0000) >> 16
}

// ISI.ISI_PDECF: ISI Preview Decimation Factor Register
func (o *ISI_Type) SetISI_PDECF_DEC_FACTOR(value uint32) {
	volatile.StoreUint32(&o.ISI_PDECF.Reg, volatile.LoadUint32(&o.ISI_PDECF.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetISI_PDECF_DEC_FACTOR() uint32 {
	return volatile.LoadUint32(&o.ISI_PDECF.Reg) & 0xff
}

// ISI.ISI_Y2R_SET0: ISI CSC YCrCb To RGB Set 0 Register
func (o *ISI_Type) SetISI_Y2R_SET0_C0(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET0.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetISI_Y2R_SET0_C0() uint32 {
	return volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg) & 0xff
}
func (o *ISI_Type) SetISI_Y2R_SET0_C1(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET0.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg)&^(0xff00)|value<<8)
}
func (o *ISI_Type) GetISI_Y2R_SET0_C1() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg) & 0xff00) >> 8
}
func (o *ISI_Type) SetISI_Y2R_SET0_C2(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET0.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetISI_Y2R_SET0_C2() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetISI_Y2R_SET0_C3(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET0.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg)&^(0xff000000)|value<<24)
}
func (o *ISI_Type) GetISI_Y2R_SET0_C3() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET0.Reg) & 0xff000000) >> 24
}

// ISI.ISI_Y2R_SET1: ISI CSC YCrCb To RGB Set 1 Register
func (o *ISI_Type) SetISI_Y2R_SET1_C4(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET1.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg)&^(0x1ff)|value)
}
func (o *ISI_Type) GetISI_Y2R_SET1_C4() uint32 {
	return volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg) & 0x1ff
}
func (o *ISI_Type) SetISI_Y2R_SET1_Yoff(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET1.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg)&^(0x1000)|value<<12)
}
func (o *ISI_Type) GetISI_Y2R_SET1_Yoff() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg) & 0x1000) >> 12
}
func (o *ISI_Type) SetISI_Y2R_SET1_Croff(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET1.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg)&^(0x2000)|value<<13)
}
func (o *ISI_Type) GetISI_Y2R_SET1_Croff() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg) & 0x2000) >> 13
}
func (o *ISI_Type) SetISI_Y2R_SET1_Cboff(value uint32) {
	volatile.StoreUint32(&o.ISI_Y2R_SET1.Reg, volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg)&^(0x4000)|value<<14)
}
func (o *ISI_Type) GetISI_Y2R_SET1_Cboff() uint32 {
	return (volatile.LoadUint32(&o.ISI_Y2R_SET1.Reg) & 0x4000) >> 14
}

// ISI.ISI_R2Y_SET0: ISI CSC RGB To YCrCb Set 0 Register
func (o *ISI_Type) SetISI_R2Y_SET0_C0(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET0.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetISI_R2Y_SET0_C0() uint32 {
	return volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg) & 0xff
}
func (o *ISI_Type) SetISI_R2Y_SET0_C1(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET0.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg)&^(0xff00)|value<<8)
}
func (o *ISI_Type) GetISI_R2Y_SET0_C1() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg) & 0xff00) >> 8
}
func (o *ISI_Type) SetISI_R2Y_SET0_C2(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET0.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetISI_R2Y_SET0_C2() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetISI_R2Y_SET0_Roff(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET0.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_R2Y_SET0_Roff() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET0.Reg) & 0x1000000) >> 24
}

// ISI.ISI_R2Y_SET1: ISI CSC RGB To YCrCb Set 1 Register
func (o *ISI_Type) SetISI_R2Y_SET1_C3(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET1.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetISI_R2Y_SET1_C3() uint32 {
	return volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg) & 0xff
}
func (o *ISI_Type) SetISI_R2Y_SET1_C4(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET1.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg)&^(0xff00)|value<<8)
}
func (o *ISI_Type) GetISI_R2Y_SET1_C4() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg) & 0xff00) >> 8
}
func (o *ISI_Type) SetISI_R2Y_SET1_C5(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET1.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetISI_R2Y_SET1_C5() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetISI_R2Y_SET1_Goff(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET1.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_R2Y_SET1_Goff() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET1.Reg) & 0x1000000) >> 24
}

// ISI.ISI_R2Y_SET2: ISI CSC RGB To YCrCb Set 2 Register
func (o *ISI_Type) SetISI_R2Y_SET2_C6(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET2.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg)&^(0xff)|value)
}
func (o *ISI_Type) GetISI_R2Y_SET2_C6() uint32 {
	return volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg) & 0xff
}
func (o *ISI_Type) SetISI_R2Y_SET2_C7(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET2.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg)&^(0xff00)|value<<8)
}
func (o *ISI_Type) GetISI_R2Y_SET2_C7() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg) & 0xff00) >> 8
}
func (o *ISI_Type) SetISI_R2Y_SET2_C8(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET2.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg)&^(0xff0000)|value<<16)
}
func (o *ISI_Type) GetISI_R2Y_SET2_C8() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg) & 0xff0000) >> 16
}
func (o *ISI_Type) SetISI_R2Y_SET2_Boff(value uint32) {
	volatile.StoreUint32(&o.ISI_R2Y_SET2.Reg, volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_R2Y_SET2_Boff() uint32 {
	return (volatile.LoadUint32(&o.ISI_R2Y_SET2.Reg) & 0x1000000) >> 24
}

// ISI.ISI_CR: ISI Control Register
func (o *ISI_Type) SetISI_CR_ISI_EN(value uint32) {
	volatile.StoreUint32(&o.ISI_CR.Reg, volatile.LoadUint32(&o.ISI_CR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_CR_ISI_EN() uint32 {
	return volatile.LoadUint32(&o.ISI_CR.Reg) & 0x1
}
func (o *ISI_Type) SetISI_CR_ISI_DIS(value uint32) {
	volatile.StoreUint32(&o.ISI_CR.Reg, volatile.LoadUint32(&o.ISI_CR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_CR_ISI_DIS() uint32 {
	return (volatile.LoadUint32(&o.ISI_CR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_CR_ISI_SRST(value uint32) {
	volatile.StoreUint32(&o.ISI_CR.Reg, volatile.LoadUint32(&o.ISI_CR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_CR_ISI_SRST() uint32 {
	return (volatile.LoadUint32(&o.ISI_CR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_CR_ISI_CDC(value uint32) {
	volatile.StoreUint32(&o.ISI_CR.Reg, volatile.LoadUint32(&o.ISI_CR.Reg)&^(0x100)|value<<8)
}
func (o *ISI_Type) GetISI_CR_ISI_CDC() uint32 {
	return (volatile.LoadUint32(&o.ISI_CR.Reg) & 0x100) >> 8
}

// ISI.ISI_SR: ISI Status Register
func (o *ISI_Type) SetISI_SR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_SR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.ISI_SR.Reg) & 0x1
}
func (o *ISI_Type) SetISI_SR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_SR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_SR_SRST(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_SR_SRST() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_SR_CDC_PND(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x100)|value<<8)
}
func (o *ISI_Type) GetISI_SR_CDC_PND() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x100) >> 8
}
func (o *ISI_Type) SetISI_SR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetISI_SR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetISI_SR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetISI_SR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetISI_SR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetISI_SR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetISI_SR_SIP(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x80000)|value<<19)
}
func (o *ISI_Type) GetISI_SR_SIP() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x80000) >> 19
}
func (o *ISI_Type) SetISI_SR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_SR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetISI_SR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetISI_SR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetISI_SR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetISI_SR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetISI_SR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_SR.Reg, volatile.LoadUint32(&o.ISI_SR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetISI_SR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_SR.Reg) & 0x8000000) >> 27
}

// ISI.ISI_IER: ISI Interrupt Enable Register
func (o *ISI_Type) SetISI_IER_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_IER_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_IER_SRST(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_IER_SRST() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_IER_VSYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetISI_IER_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetISI_IER_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetISI_IER_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetISI_IER_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetISI_IER_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetISI_IER_P_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_IER_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetISI_IER_C_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetISI_IER_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetISI_IER_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetISI_IER_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetISI_IER_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IER.Reg, volatile.LoadUint32(&o.ISI_IER.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetISI_IER_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IER.Reg) & 0x8000000) >> 27
}

// ISI.ISI_IDR: ISI Interrupt Disable Register
func (o *ISI_Type) SetISI_IDR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_IDR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_IDR_SRST(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_IDR_SRST() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_IDR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetISI_IDR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetISI_IDR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetISI_IDR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetISI_IDR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetISI_IDR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetISI_IDR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_IDR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetISI_IDR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetISI_IDR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetISI_IDR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetISI_IDR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetISI_IDR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IDR.Reg, volatile.LoadUint32(&o.ISI_IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetISI_IDR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IDR.Reg) & 0x8000000) >> 27
}

// ISI.ISI_IMR: ISI Interrupt Mask Register
func (o *ISI_Type) SetISI_IMR_DIS_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetISI_IMR_DIS_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetISI_IMR_SRST(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetISI_IMR_SRST() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetISI_IMR_VSYNC(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x400)|value<<10)
}
func (o *ISI_Type) GetISI_IMR_VSYNC() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x400) >> 10
}
func (o *ISI_Type) SetISI_IMR_PXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *ISI_Type) GetISI_IMR_PXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x10000) >> 16
}
func (o *ISI_Type) SetISI_IMR_CXFR_DONE(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x20000)|value<<17)
}
func (o *ISI_Type) GetISI_IMR_CXFR_DONE() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x20000) >> 17
}
func (o *ISI_Type) SetISI_IMR_P_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ISI_Type) GetISI_IMR_P_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x1000000) >> 24
}
func (o *ISI_Type) SetISI_IMR_C_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ISI_Type) GetISI_IMR_C_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x2000000) >> 25
}
func (o *ISI_Type) SetISI_IMR_CRC_ERR(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ISI_Type) GetISI_IMR_CRC_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x4000000) >> 26
}
func (o *ISI_Type) SetISI_IMR_FR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISI_IMR.Reg, volatile.LoadUint32(&o.ISI_IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *ISI_Type) GetISI_IMR_FR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISI_IMR.Reg) & 0x8000000) >> 27
}

// ISI.DMA_CHER: DMA Channel Enable Register
func (o *ISI_Type) SetDMA_CHER_P_CH_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CHER.Reg, volatile.LoadUint32(&o.DMA_CHER.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHER_P_CH_EN() uint32 {
	return volatile.LoadUint32(&o.DMA_CHER.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHER_C_CH_EN(value uint32) {
	volatile.StoreUint32(&o.DMA_CHER.Reg, volatile.LoadUint32(&o.DMA_CHER.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHER_C_CH_EN() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHER.Reg) & 0x2) >> 1
}

// ISI.DMA_CHDR: DMA Channel Disable Register
func (o *ISI_Type) SetDMA_CHDR_P_CH_DIS(value uint32) {
	volatile.StoreUint32(&o.DMA_CHDR.Reg, volatile.LoadUint32(&o.DMA_CHDR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHDR_P_CH_DIS() uint32 {
	return volatile.LoadUint32(&o.DMA_CHDR.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHDR_C_CH_DIS(value uint32) {
	volatile.StoreUint32(&o.DMA_CHDR.Reg, volatile.LoadUint32(&o.DMA_CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHDR_C_CH_DIS() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHDR.Reg) & 0x2) >> 1
}

// ISI.DMA_CHSR: DMA Channel Status Register
func (o *ISI_Type) SetDMA_CHSR_P_CH_S(value uint32) {
	volatile.StoreUint32(&o.DMA_CHSR.Reg, volatile.LoadUint32(&o.DMA_CHSR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_CHSR_P_CH_S() uint32 {
	return volatile.LoadUint32(&o.DMA_CHSR.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_CHSR_C_CH_S(value uint32) {
	volatile.StoreUint32(&o.DMA_CHSR.Reg, volatile.LoadUint32(&o.DMA_CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_CHSR_C_CH_S() uint32 {
	return (volatile.LoadUint32(&o.DMA_CHSR.Reg) & 0x2) >> 1
}

// ISI.DMA_P_ADDR: DMA Preview Base Address Register
func (o *ISI_Type) SetDMA_P_ADDR_P_ADDR(value uint32) {
	volatile.StoreUint32(&o.DMA_P_ADDR.Reg, volatile.LoadUint32(&o.DMA_P_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_P_ADDR_P_ADDR() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_ADDR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_P_CTRL: DMA Preview Control Register
func (o *ISI_Type) SetDMA_P_CTRL_P_FETCH(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_FETCH() uint32 {
	return volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_P_CTRL_P_WB(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_WB() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetDMA_P_CTRL_P_IEN(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_IEN() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetDMA_P_CTRL_P_DONE(value uint32) {
	volatile.StoreUint32(&o.DMA_P_CTRL.Reg, volatile.LoadUint32(&o.DMA_P_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetDMA_P_CTRL_P_DONE() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_CTRL.Reg) & 0x8) >> 3
}

// ISI.DMA_P_DSCR: DMA Preview Descriptor Address Register
func (o *ISI_Type) SetDMA_P_DSCR_P_DSCR(value uint32) {
	volatile.StoreUint32(&o.DMA_P_DSCR.Reg, volatile.LoadUint32(&o.DMA_P_DSCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_P_DSCR_P_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DMA_P_DSCR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_C_ADDR: DMA Codec Base Address Register
func (o *ISI_Type) SetDMA_C_ADDR_C_ADDR(value uint32) {
	volatile.StoreUint32(&o.DMA_C_ADDR.Reg, volatile.LoadUint32(&o.DMA_C_ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_C_ADDR_C_ADDR() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_ADDR.Reg) & 0xfffffffc) >> 2
}

// ISI.DMA_C_CTRL: DMA Codec Control Register
func (o *ISI_Type) SetDMA_C_CTRL_C_FETCH(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_FETCH() uint32 {
	return volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x1
}
func (o *ISI_Type) SetDMA_C_CTRL_C_WB(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_WB() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x2) >> 1
}
func (o *ISI_Type) SetDMA_C_CTRL_C_IEN(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_IEN() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x4) >> 2
}
func (o *ISI_Type) SetDMA_C_CTRL_C_DONE(value uint32) {
	volatile.StoreUint32(&o.DMA_C_CTRL.Reg, volatile.LoadUint32(&o.DMA_C_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *ISI_Type) GetDMA_C_CTRL_C_DONE() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_CTRL.Reg) & 0x8) >> 3
}

// ISI.DMA_C_DSCR: DMA Codec Descriptor Address Register
func (o *ISI_Type) SetDMA_C_DSCR_C_DSCR(value uint32) {
	volatile.StoreUint32(&o.DMA_C_DSCR.Reg, volatile.LoadUint32(&o.DMA_C_DSCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ISI_Type) GetDMA_C_DSCR_C_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DMA_C_DSCR.Reg) & 0xfffffffc) >> 2
}

// ISI.ISI_WPCR: Write Protection Control Register
func (o *ISI_Type) SetISI_WPCR_WP_EN(value uint32) {
	volatile.StoreUint32(&o.ISI_WPCR.Reg, volatile.LoadUint32(&o.ISI_WPCR.Reg)&^(0x1)|value)
}
func (o *ISI_Type) GetISI_WPCR_WP_EN() uint32 {
	return volatile.LoadUint32(&o.ISI_WPCR.Reg) & 0x1
}
func (o *ISI_Type) SetISI_WPCR_WP_KEY(value uint32) {
	volatile.StoreUint32(&o.ISI_WPCR.Reg, volatile.LoadUint32(&o.ISI_WPCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ISI_Type) GetISI_WPCR_WP_KEY() uint32 {
	return (volatile.LoadUint32(&o.ISI_WPCR.Reg) & 0xffffff00) >> 8
}

// ISI.ISI_WPSR: Write Protection Status Register
func (o *ISI_Type) SetISI_WPSR_WP_VS(value uint32) {
	volatile.StoreUint32(&o.ISI_WPSR.Reg, volatile.LoadUint32(&o.ISI_WPSR.Reg)&^(0xf)|value)
}
func (o *ISI_Type) GetISI_WPSR_WP_VS() uint32 {
	return volatile.LoadUint32(&o.ISI_WPSR.Reg) & 0xf
}
func (o *ISI_Type) SetISI_WPSR_WP_VSRC(value uint32) {
	volatile.StoreUint32(&o.ISI_WPSR.Reg, volatile.LoadUint32(&o.ISI_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ISI_Type) GetISI_WPSR_WP_VSRC() uint32 {
	return (volatile.LoadUint32(&o.ISI_WPSR.Reg) & 0xffff00) >> 8
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	MR    volatile.Register32 // 0x0
	ENA   volatile.Register32 // 0x4
	DIS   volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [480]byte
	CMR0  volatile.Register32 // 0x200
	CDTY0 volatile.Register32 // 0x204
	CPRD0 volatile.Register32 // 0x208
	CCNT0 volatile.Register32 // 0x20C
	CUPD0 volatile.Register32 // 0x210
	_     [12]byte
	CMR1  volatile.Register32 // 0x220
	CDTY1 volatile.Register32 // 0x224
	CPRD1 volatile.Register32 // 0x228
	CCNT1 volatile.Register32 // 0x22C
	CUPD1 volatile.Register32 // 0x230
	_     [12]byte
	CMR2  volatile.Register32 // 0x240
	CDTY2 volatile.Register32 // 0x244
	CPRD2 volatile.Register32 // 0x248
	CCNT2 volatile.Register32 // 0x24C
	CUPD2 volatile.Register32 // 0x250
	_     [12]byte
	CMR3  volatile.Register32 // 0x260
	CDTY3 volatile.Register32 // 0x264
	CPRD3 volatile.Register32 // 0x268
	CCNT3 volatile.Register32 // 0x26C
	CUPD3 volatile.Register32 // 0x270
}

// PWM.MR: PWM Mode Register
func (o *PWM_Type) SetMR_DIVA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetMR_DIVA() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *PWM_Type) SetMR_PREA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetMR_PREA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetMR_DIVB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetMR_DIVB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetMR_PREB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *PWM_Type) GetMR_PREB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}

// PWM.ENA: PWM Enable Register
func (o *PWM_Type) SetENA_CHID0(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENA_CHID0() uint32 {
	return volatile.LoadUint32(&o.ENA.Reg) & 0x1
}
func (o *PWM_Type) SetENA_CHID1(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetENA_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetENA_CHID2(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetENA_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetENA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetENA_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x8) >> 3
}

// PWM.DIS: PWM Disable Register
func (o *PWM_Type) SetDIS_CHID0(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetDIS_CHID0() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}
func (o *PWM_Type) SetDIS_CHID1(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetDIS_CHID1() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetDIS_CHID2(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetDIS_CHID2() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetDIS_CHID3(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetDIS_CHID3() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x8) >> 3
}

// PWM.SR: PWM Status Register
func (o *PWM_Type) SetSR_CHID0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSR_CHID0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PWM_Type) SetSR_CHID1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSR_CHID2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSR_CHID3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}

// PWM.IER: PWM Interrupt Enable Register
func (o *PWM_Type) SetIER_CHID0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER_CHID0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PWM_Type) SetIER_CHID1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER_CHID2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER_CHID3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}

// PWM.IDR: PWM Interrupt Disable Register
func (o *PWM_Type) SetIDR_CHID0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR_CHID0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PWM_Type) SetIDR_CHID1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR_CHID2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR_CHID3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}

// PWM.IMR: PWM Interrupt Mask Register
func (o *PWM_Type) SetIMR_CHID0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR_CHID0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PWM_Type) SetIMR_CHID1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR_CHID2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR_CHID3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}

// PWM.ISR: PWM Interrupt Status Register
func (o *PWM_Type) SetISR_CHID0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR_CHID0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PWM_Type) SetISR_CHID1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR_CHID2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR_CHID3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}

// PWM.CMR0: PWM Channel Mode Register (ch_num = 0)
func (o *PWM_Type) SetCMR0_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR0_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0xf
}
func (o *PWM_Type) SetCMR0_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR0_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR0_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR0_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}

// PWM.CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
func (o *PWM_Type) SetCDTY0(value uint32) {
	volatile.StoreUint32(&o.CDTY0.Reg, value)
}
func (o *PWM_Type) GetCDTY0() uint32 {
	return volatile.LoadUint32(&o.CDTY0.Reg)
}

// PWM.CPRD0: PWM Channel Period Register (ch_num = 0)
func (o *PWM_Type) SetCPRD0(value uint32) {
	volatile.StoreUint32(&o.CPRD0.Reg, value)
}
func (o *PWM_Type) GetCPRD0() uint32 {
	return volatile.LoadUint32(&o.CPRD0.Reg)
}

// PWM.CCNT0: PWM Channel Counter Register (ch_num = 0)
func (o *PWM_Type) SetCCNT0(value uint32) {
	volatile.StoreUint32(&o.CCNT0.Reg, value)
}
func (o *PWM_Type) GetCCNT0() uint32 {
	return volatile.LoadUint32(&o.CCNT0.Reg)
}

// PWM.CUPD0: PWM Channel Update Register (ch_num = 0)
func (o *PWM_Type) SetCUPD0(value uint32) {
	volatile.StoreUint32(&o.CUPD0.Reg, value)
}
func (o *PWM_Type) GetCUPD0() uint32 {
	return volatile.LoadUint32(&o.CUPD0.Reg)
}

// PWM.CMR1: PWM Channel Mode Register (ch_num = 1)
func (o *PWM_Type) SetCMR1_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR1_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0xf
}
func (o *PWM_Type) SetCMR1_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR1_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR1_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR1_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}

// PWM.CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
func (o *PWM_Type) SetCDTY1(value uint32) {
	volatile.StoreUint32(&o.CDTY1.Reg, value)
}
func (o *PWM_Type) GetCDTY1() uint32 {
	return volatile.LoadUint32(&o.CDTY1.Reg)
}

// PWM.CPRD1: PWM Channel Period Register (ch_num = 1)
func (o *PWM_Type) SetCPRD1(value uint32) {
	volatile.StoreUint32(&o.CPRD1.Reg, value)
}
func (o *PWM_Type) GetCPRD1() uint32 {
	return volatile.LoadUint32(&o.CPRD1.Reg)
}

// PWM.CCNT1: PWM Channel Counter Register (ch_num = 1)
func (o *PWM_Type) SetCCNT1(value uint32) {
	volatile.StoreUint32(&o.CCNT1.Reg, value)
}
func (o *PWM_Type) GetCCNT1() uint32 {
	return volatile.LoadUint32(&o.CCNT1.Reg)
}

// PWM.CUPD1: PWM Channel Update Register (ch_num = 1)
func (o *PWM_Type) SetCUPD1(value uint32) {
	volatile.StoreUint32(&o.CUPD1.Reg, value)
}
func (o *PWM_Type) GetCUPD1() uint32 {
	return volatile.LoadUint32(&o.CUPD1.Reg)
}

// PWM.CMR2: PWM Channel Mode Register (ch_num = 2)
func (o *PWM_Type) SetCMR2_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR2_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0xf
}
func (o *PWM_Type) SetCMR2_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR2_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR2_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR2_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}

// PWM.CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
func (o *PWM_Type) SetCDTY2(value uint32) {
	volatile.StoreUint32(&o.CDTY2.Reg, value)
}
func (o *PWM_Type) GetCDTY2() uint32 {
	return volatile.LoadUint32(&o.CDTY2.Reg)
}

// PWM.CPRD2: PWM Channel Period Register (ch_num = 2)
func (o *PWM_Type) SetCPRD2(value uint32) {
	volatile.StoreUint32(&o.CPRD2.Reg, value)
}
func (o *PWM_Type) GetCPRD2() uint32 {
	return volatile.LoadUint32(&o.CPRD2.Reg)
}

// PWM.CCNT2: PWM Channel Counter Register (ch_num = 2)
func (o *PWM_Type) SetCCNT2(value uint32) {
	volatile.StoreUint32(&o.CCNT2.Reg, value)
}
func (o *PWM_Type) GetCCNT2() uint32 {
	return volatile.LoadUint32(&o.CCNT2.Reg)
}

// PWM.CUPD2: PWM Channel Update Register (ch_num = 2)
func (o *PWM_Type) SetCUPD2(value uint32) {
	volatile.StoreUint32(&o.CUPD2.Reg, value)
}
func (o *PWM_Type) GetCUPD2() uint32 {
	return volatile.LoadUint32(&o.CUPD2.Reg)
}

// PWM.CMR3: PWM Channel Mode Register (ch_num = 3)
func (o *PWM_Type) SetCMR3_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR3_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR3.Reg) & 0xf
}
func (o *PWM_Type) SetCMR3_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR3_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR3_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR3_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR3_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR3_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x400) >> 10
}

// PWM.CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
func (o *PWM_Type) SetCDTY3(value uint32) {
	volatile.StoreUint32(&o.CDTY3.Reg, value)
}
func (o *PWM_Type) GetCDTY3() uint32 {
	return volatile.LoadUint32(&o.CDTY3.Reg)
}

// PWM.CPRD3: PWM Channel Period Register (ch_num = 3)
func (o *PWM_Type) SetCPRD3(value uint32) {
	volatile.StoreUint32(&o.CPRD3.Reg, value)
}
func (o *PWM_Type) GetCPRD3() uint32 {
	return volatile.LoadUint32(&o.CPRD3.Reg)
}

// PWM.CCNT3: PWM Channel Counter Register (ch_num = 3)
func (o *PWM_Type) SetCCNT3(value uint32) {
	volatile.StoreUint32(&o.CCNT3.Reg, value)
}
func (o *PWM_Type) GetCCNT3() uint32 {
	return volatile.LoadUint32(&o.CCNT3.Reg)
}

// PWM.CUPD3: PWM Channel Update Register (ch_num = 3)
func (o *PWM_Type) SetCUPD3(value uint32) {
	volatile.StoreUint32(&o.CUPD3.Reg, value)
}
func (o *PWM_Type) GetCUPD3() uint32 {
	return volatile.LoadUint32(&o.CUPD3.Reg)
}

// Ethernet MAC 10/100
type EMAC_Type struct {
	NCR   volatile.Register32 // 0x0
	NCFG  volatile.Register32 // 0x4
	NSR   volatile.Register32 // 0x8
	_     [8]byte
	TSR   volatile.Register32 // 0x14
	RBQP  volatile.Register32 // 0x18
	TBQP  volatile.Register32 // 0x1C
	RSR   volatile.Register32 // 0x20
	ISR   volatile.Register32 // 0x24
	IER   volatile.Register32 // 0x28
	IDR   volatile.Register32 // 0x2C
	IMR   volatile.Register32 // 0x30
	MAN   volatile.Register32 // 0x34
	PTR   volatile.Register32 // 0x38
	PFR   volatile.Register32 // 0x3C
	FTO   volatile.Register32 // 0x40
	SCF   volatile.Register32 // 0x44
	MCF   volatile.Register32 // 0x48
	FRO   volatile.Register32 // 0x4C
	FCSE  volatile.Register32 // 0x50
	ALE   volatile.Register32 // 0x54
	DTF   volatile.Register32 // 0x58
	LCOL  volatile.Register32 // 0x5C
	ECOL  volatile.Register32 // 0x60
	TUND  volatile.Register32 // 0x64
	CSE   volatile.Register32 // 0x68
	RRE   volatile.Register32 // 0x6C
	ROV   volatile.Register32 // 0x70
	RSE   volatile.Register32 // 0x74
	ELE   volatile.Register32 // 0x78
	RJA   volatile.Register32 // 0x7C
	USF   volatile.Register32 // 0x80
	STE   volatile.Register32 // 0x84
	RLE   volatile.Register32 // 0x88
	_     [4]byte
	HRB   volatile.Register32 // 0x90
	HRT   volatile.Register32 // 0x94
	SA1B  volatile.Register32 // 0x98
	SA1T  volatile.Register32 // 0x9C
	SA2B  volatile.Register32 // 0xA0
	SA2T  volatile.Register32 // 0xA4
	SA3B  volatile.Register32 // 0xA8
	SA3T  volatile.Register32 // 0xAC
	SA4B  volatile.Register32 // 0xB0
	SA4T  volatile.Register32 // 0xB4
	TID   volatile.Register32 // 0xB8
	_     [4]byte
	USRIO volatile.Register32 // 0xC0
}

// EMAC.NCR: Network Control Register
func (o *EMAC_Type) SetNCR_LB(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetNCR_LB() uint32 {
	return volatile.LoadUint32(&o.NCR.Reg) & 0x1
}
func (o *EMAC_Type) SetNCR_LLB(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNCR_LLB() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNCR_RE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetNCR_RE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetNCR_TE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetNCR_TE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetNCR_MPE(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetNCR_MPE() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetNCR_CLRSTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetNCR_CLRSTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetNCR_INCSTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetNCR_INCSTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetNCR_WESTAT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetNCR_WESTAT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetNCR_BP(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_Type) GetNCR_BP() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x100) >> 8
}
func (o *EMAC_Type) SetNCR_TSTART(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x200)|value<<9)
}
func (o *EMAC_Type) GetNCR_TSTART() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x200) >> 9
}
func (o *EMAC_Type) SetNCR_THALT(value uint32) {
	volatile.StoreUint32(&o.NCR.Reg, volatile.LoadUint32(&o.NCR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetNCR_THALT() uint32 {
	return (volatile.LoadUint32(&o.NCR.Reg) & 0x400) >> 10
}

// EMAC.NCFG: Network Configuration Register
func (o *EMAC_Type) SetNCFG_SPD(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetNCFG_SPD() uint32 {
	return volatile.LoadUint32(&o.NCFG.Reg) & 0x1
}
func (o *EMAC_Type) SetNCFG_FD(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNCFG_FD() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNCFG_JFRAME(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetNCFG_JFRAME() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetNCFG_CAF(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetNCFG_CAF() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetNCFG_NBC(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetNCFG_NBC() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetNCFG_MTI(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetNCFG_MTI() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetNCFG_UNI(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetNCFG_UNI() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetNCFG_BIG(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x100)|value<<8)
}
func (o *EMAC_Type) GetNCFG_BIG() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x100) >> 8
}
func (o *EMAC_Type) SetNCFG_CLK(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0xc00)|value<<10)
}
func (o *EMAC_Type) GetNCFG_CLK() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0xc00) >> 10
}
func (o *EMAC_Type) SetNCFG_RTY(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetNCFG_RTY() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetNCFG_PAE(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetNCFG_PAE() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x2000) >> 13
}
func (o *EMAC_Type) SetNCFG_RBOF(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0xc000)|value<<14)
}
func (o *EMAC_Type) GetNCFG_RBOF() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0xc000) >> 14
}
func (o *EMAC_Type) SetNCFG_RLCE(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x10000)|value<<16)
}
func (o *EMAC_Type) GetNCFG_RLCE() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x10000) >> 16
}
func (o *EMAC_Type) SetNCFG_DRFCS(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x20000)|value<<17)
}
func (o *EMAC_Type) GetNCFG_DRFCS() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x20000) >> 17
}
func (o *EMAC_Type) SetNCFG_EFRHD(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x40000)|value<<18)
}
func (o *EMAC_Type) GetNCFG_EFRHD() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x40000) >> 18
}
func (o *EMAC_Type) SetNCFG_IRXFCS(value uint32) {
	volatile.StoreUint32(&o.NCFG.Reg, volatile.LoadUint32(&o.NCFG.Reg)&^(0x80000)|value<<19)
}
func (o *EMAC_Type) GetNCFG_IRXFCS() uint32 {
	return (volatile.LoadUint32(&o.NCFG.Reg) & 0x80000) >> 19
}

// EMAC.NSR: Network Status Register
func (o *EMAC_Type) SetNSR_MDIO(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetNSR_MDIO() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetNSR_IDLE(value uint32) {
	volatile.StoreUint32(&o.NSR.Reg, volatile.LoadUint32(&o.NSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetNSR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.NSR.Reg) & 0x4) >> 2
}

// EMAC.TSR: Transmit Status Register
func (o *EMAC_Type) SetTSR_UBR(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetTSR_UBR() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}
func (o *EMAC_Type) SetTSR_COL(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetTSR_COL() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetTSR_RLE(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetTSR_RLE() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetTSR_TGO(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetTSR_TGO() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetTSR_BEX(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetTSR_BEX() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetTSR_COMP(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetTSR_COMP() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetTSR_UND(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetTSR_UND() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40) >> 6
}

// EMAC.RBQP: Receive Buffer Queue Pointer Register
func (o *EMAC_Type) SetRBQP_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBQP.Reg, volatile.LoadUint32(&o.RBQP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EMAC_Type) GetRBQP_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBQP.Reg) & 0xfffffffc) >> 2
}

// EMAC.TBQP: Transmit Buffer Queue Pointer Register
func (o *EMAC_Type) SetTBQP_ADDR(value uint32) {
	volatile.StoreUint32(&o.TBQP.Reg, volatile.LoadUint32(&o.TBQP.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EMAC_Type) GetTBQP_ADDR() uint32 {
	return (volatile.LoadUint32(&o.TBQP.Reg) & 0xfffffffc) >> 2
}

// EMAC.RSR: Receive Status Register
func (o *EMAC_Type) SetRSR_BNA(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetRSR_BNA() uint32 {
	return volatile.LoadUint32(&o.RSR.Reg) & 0x1
}
func (o *EMAC_Type) SetRSR_REC(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetRSR_REC() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetRSR_OVR(value uint32) {
	volatile.StoreUint32(&o.RSR.Reg, volatile.LoadUint32(&o.RSR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetRSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.RSR.Reg) & 0x4) >> 2
}

// EMAC.ISR: Interrupt Status Register
func (o *EMAC_Type) SetISR_MFD(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetISR_MFD() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *EMAC_Type) SetISR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetISR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetISR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetISR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetISR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetISR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetISR_TUND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetISR_TUND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetISR_RLE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetISR_RLE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetISR_TXERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetISR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetISR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetISR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetISR_ROVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetISR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetISR_HRESP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetISR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetISR_PFR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetISR_PFR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetISR_PTZ(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetISR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}

// EMAC.IER: Interrupt Enable Register
func (o *EMAC_Type) SetIER_MFD(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIER_MFD() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *EMAC_Type) SetIER_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIER_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIER_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIER_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIER_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIER_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIER_TUND(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIER_TUND() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIER_RLE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIER_RLE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIER_TXERR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIER_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIER_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIER_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIER_ROVR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIER_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIER_HRESP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIER_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIER_PFR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIER_PFR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIER_PTZ(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIER_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}

// EMAC.IDR: Interrupt Disable Register
func (o *EMAC_Type) SetIDR_MFD(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIDR_MFD() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *EMAC_Type) SetIDR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIDR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIDR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIDR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIDR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIDR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIDR_TUND(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIDR_TUND() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIDR_RLE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIDR_RLE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIDR_TXERR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIDR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIDR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIDR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIDR_ROVR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIDR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIDR_HRESP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIDR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIDR_PFR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIDR_PFR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIDR_PTZ(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIDR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}

// EMAC.IMR: Interrupt Mask Register
func (o *EMAC_Type) SetIMR_MFD(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetIMR_MFD() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *EMAC_Type) SetIMR_RCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetIMR_RCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *EMAC_Type) SetIMR_RXUBR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *EMAC_Type) GetIMR_RXUBR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *EMAC_Type) SetIMR_TXUBR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *EMAC_Type) GetIMR_TXUBR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *EMAC_Type) SetIMR_TUND(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EMAC_Type) GetIMR_TUND() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EMAC_Type) SetIMR_RLE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EMAC_Type) GetIMR_RLE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EMAC_Type) SetIMR_TXERR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *EMAC_Type) GetIMR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *EMAC_Type) SetIMR_TCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *EMAC_Type) GetIMR_TCOMP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *EMAC_Type) SetIMR_ROVR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *EMAC_Type) GetIMR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *EMAC_Type) SetIMR_HRESP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *EMAC_Type) GetIMR_HRESP() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *EMAC_Type) SetIMR_PFR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *EMAC_Type) GetIMR_PFR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *EMAC_Type) SetIMR_PTZ(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *EMAC_Type) GetIMR_PTZ() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}

// EMAC.MAN: Phy Maintenance Register
func (o *EMAC_Type) SetMAN_DATA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetMAN_DATA() uint32 {
	return volatile.LoadUint32(&o.MAN.Reg) & 0xffff
}
func (o *EMAC_Type) SetMAN_CODE(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x30000)|value<<16)
}
func (o *EMAC_Type) GetMAN_CODE() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x30000) >> 16
}
func (o *EMAC_Type) SetMAN_REGA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x7c0000)|value<<18)
}
func (o *EMAC_Type) GetMAN_REGA() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x7c0000) >> 18
}
func (o *EMAC_Type) SetMAN_PHYA(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xf800000)|value<<23)
}
func (o *EMAC_Type) GetMAN_PHYA() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xf800000) >> 23
}
func (o *EMAC_Type) SetMAN_RW(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0x30000000)|value<<28)
}
func (o *EMAC_Type) GetMAN_RW() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0x30000000) >> 28
}
func (o *EMAC_Type) SetMAN_SOF(value uint32) {
	volatile.StoreUint32(&o.MAN.Reg, volatile.LoadUint32(&o.MAN.Reg)&^(0xc0000000)|value<<30)
}
func (o *EMAC_Type) GetMAN_SOF() uint32 {
	return (volatile.LoadUint32(&o.MAN.Reg) & 0xc0000000) >> 30
}

// EMAC.PTR: Pause Time Register
func (o *EMAC_Type) SetPTR_PTIME(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, volatile.LoadUint32(&o.PTR.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetPTR_PTIME() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg) & 0xffff
}

// EMAC.PFR: Pause Frames Received Register
func (o *EMAC_Type) SetPFR_FROK(value uint32) {
	volatile.StoreUint32(&o.PFR.Reg, volatile.LoadUint32(&o.PFR.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetPFR_FROK() uint32 {
	return volatile.LoadUint32(&o.PFR.Reg) & 0xffff
}

// EMAC.FTO: Frames Transmitted Ok Register
func (o *EMAC_Type) SetFTO_FTOK(value uint32) {
	volatile.StoreUint32(&o.FTO.Reg, volatile.LoadUint32(&o.FTO.Reg)&^(0xffffff)|value)
}
func (o *EMAC_Type) GetFTO_FTOK() uint32 {
	return volatile.LoadUint32(&o.FTO.Reg) & 0xffffff
}

// EMAC.SCF: Single Collision Frames Register
func (o *EMAC_Type) SetSCF(value uint32) {
	volatile.StoreUint32(&o.SCF.Reg, volatile.LoadUint32(&o.SCF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSCF() uint32 {
	return volatile.LoadUint32(&o.SCF.Reg) & 0xffff
}

// EMAC.MCF: Multiple Collision Frames Register
func (o *EMAC_Type) SetMCF(value uint32) {
	volatile.StoreUint32(&o.MCF.Reg, volatile.LoadUint32(&o.MCF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetMCF() uint32 {
	return volatile.LoadUint32(&o.MCF.Reg) & 0xffff
}

// EMAC.FRO: Frames Received Ok Register
func (o *EMAC_Type) SetFRO_FROK(value uint32) {
	volatile.StoreUint32(&o.FRO.Reg, volatile.LoadUint32(&o.FRO.Reg)&^(0xffffff)|value)
}
func (o *EMAC_Type) GetFRO_FROK() uint32 {
	return volatile.LoadUint32(&o.FRO.Reg) & 0xffffff
}

// EMAC.FCSE: Frame Check Sequence Errors Register
func (o *EMAC_Type) SetFCSE(value uint32) {
	volatile.StoreUint32(&o.FCSE.Reg, volatile.LoadUint32(&o.FCSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetFCSE() uint32 {
	return volatile.LoadUint32(&o.FCSE.Reg) & 0xff
}

// EMAC.ALE: Alignment Errors Register
func (o *EMAC_Type) SetALE(value uint32) {
	volatile.StoreUint32(&o.ALE.Reg, volatile.LoadUint32(&o.ALE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetALE() uint32 {
	return volatile.LoadUint32(&o.ALE.Reg) & 0xff
}

// EMAC.DTF: Deferred Transmission Frames Register
func (o *EMAC_Type) SetDTF(value uint32) {
	volatile.StoreUint32(&o.DTF.Reg, volatile.LoadUint32(&o.DTF.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetDTF() uint32 {
	return volatile.LoadUint32(&o.DTF.Reg) & 0xffff
}

// EMAC.LCOL: Late Collisions Register
func (o *EMAC_Type) SetLCOL(value uint32) {
	volatile.StoreUint32(&o.LCOL.Reg, volatile.LoadUint32(&o.LCOL.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetLCOL() uint32 {
	return volatile.LoadUint32(&o.LCOL.Reg) & 0xff
}

// EMAC.ECOL: Excessive Collisions Register
func (o *EMAC_Type) SetECOL_EXCOL(value uint32) {
	volatile.StoreUint32(&o.ECOL.Reg, volatile.LoadUint32(&o.ECOL.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetECOL_EXCOL() uint32 {
	return volatile.LoadUint32(&o.ECOL.Reg) & 0xff
}

// EMAC.TUND: Transmit Underrun Errors Register
func (o *EMAC_Type) SetTUND(value uint32) {
	volatile.StoreUint32(&o.TUND.Reg, volatile.LoadUint32(&o.TUND.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetTUND() uint32 {
	return volatile.LoadUint32(&o.TUND.Reg) & 0xff
}

// EMAC.CSE: Carrier Sense Errors Register
func (o *EMAC_Type) SetCSE(value uint32) {
	volatile.StoreUint32(&o.CSE.Reg, volatile.LoadUint32(&o.CSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetCSE() uint32 {
	return volatile.LoadUint32(&o.CSE.Reg) & 0xff
}

// EMAC.RRE: Receive Resource Errors Register
func (o *EMAC_Type) SetRRE(value uint32) {
	volatile.StoreUint32(&o.RRE.Reg, volatile.LoadUint32(&o.RRE.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetRRE() uint32 {
	return volatile.LoadUint32(&o.RRE.Reg) & 0xffff
}

// EMAC.ROV: Receive Overrun Errors Register
func (o *EMAC_Type) SetROV_ROVR(value uint32) {
	volatile.StoreUint32(&o.ROV.Reg, volatile.LoadUint32(&o.ROV.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetROV_ROVR() uint32 {
	return volatile.LoadUint32(&o.ROV.Reg) & 0xff
}

// EMAC.RSE: Receive Symbol Errors Register
func (o *EMAC_Type) SetRSE(value uint32) {
	volatile.StoreUint32(&o.RSE.Reg, volatile.LoadUint32(&o.RSE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRSE() uint32 {
	return volatile.LoadUint32(&o.RSE.Reg) & 0xff
}

// EMAC.ELE: Excessive Length Errors Register
func (o *EMAC_Type) SetELE_EXL(value uint32) {
	volatile.StoreUint32(&o.ELE.Reg, volatile.LoadUint32(&o.ELE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetELE_EXL() uint32 {
	return volatile.LoadUint32(&o.ELE.Reg) & 0xff
}

// EMAC.RJA: Receive Jabbers Register
func (o *EMAC_Type) SetRJA_RJB(value uint32) {
	volatile.StoreUint32(&o.RJA.Reg, volatile.LoadUint32(&o.RJA.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRJA_RJB() uint32 {
	return volatile.LoadUint32(&o.RJA.Reg) & 0xff
}

// EMAC.USF: Undersize Frames Register
func (o *EMAC_Type) SetUSF(value uint32) {
	volatile.StoreUint32(&o.USF.Reg, volatile.LoadUint32(&o.USF.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetUSF() uint32 {
	return volatile.LoadUint32(&o.USF.Reg) & 0xff
}

// EMAC.STE: SQE Test Errors Register
func (o *EMAC_Type) SetSTE_SQER(value uint32) {
	volatile.StoreUint32(&o.STE.Reg, volatile.LoadUint32(&o.STE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetSTE_SQER() uint32 {
	return volatile.LoadUint32(&o.STE.Reg) & 0xff
}

// EMAC.RLE: Received Length Field Mismatch Register
func (o *EMAC_Type) SetRLE_RLFM(value uint32) {
	volatile.StoreUint32(&o.RLE.Reg, volatile.LoadUint32(&o.RLE.Reg)&^(0xff)|value)
}
func (o *EMAC_Type) GetRLE_RLFM() uint32 {
	return volatile.LoadUint32(&o.RLE.Reg) & 0xff
}

// EMAC.HRB: Hash Register Bottom [31:0] Register
func (o *EMAC_Type) SetHRB(value uint32) {
	volatile.StoreUint32(&o.HRB.Reg, value)
}
func (o *EMAC_Type) GetHRB() uint32 {
	return volatile.LoadUint32(&o.HRB.Reg)
}

// EMAC.HRT: Hash Register Top [63:32] Register
func (o *EMAC_Type) SetHRT(value uint32) {
	volatile.StoreUint32(&o.HRT.Reg, value)
}
func (o *EMAC_Type) GetHRT() uint32 {
	return volatile.LoadUint32(&o.HRT.Reg)
}

// EMAC.SA1B: Specific Address 1 Bottom Register
func (o *EMAC_Type) SetSA1B(value uint32) {
	volatile.StoreUint32(&o.SA1B.Reg, value)
}
func (o *EMAC_Type) GetSA1B() uint32 {
	return volatile.LoadUint32(&o.SA1B.Reg)
}

// EMAC.SA1T: Specific Address 1 Top Register
func (o *EMAC_Type) SetSA1T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA1T.Reg, volatile.LoadUint32(&o.SA1T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA1T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA1T.Reg) & 0xffff
}

// EMAC.SA2B: Specific Address 2 Bottom Register
func (o *EMAC_Type) SetSA2B(value uint32) {
	volatile.StoreUint32(&o.SA2B.Reg, value)
}
func (o *EMAC_Type) GetSA2B() uint32 {
	return volatile.LoadUint32(&o.SA2B.Reg)
}

// EMAC.SA2T: Specific Address 2 Top Register
func (o *EMAC_Type) SetSA2T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA2T.Reg, volatile.LoadUint32(&o.SA2T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA2T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA2T.Reg) & 0xffff
}

// EMAC.SA3B: Specific Address 3 Bottom Register
func (o *EMAC_Type) SetSA3B(value uint32) {
	volatile.StoreUint32(&o.SA3B.Reg, value)
}
func (o *EMAC_Type) GetSA3B() uint32 {
	return volatile.LoadUint32(&o.SA3B.Reg)
}

// EMAC.SA3T: Specific Address 3 Top Register
func (o *EMAC_Type) SetSA3T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA3T.Reg, volatile.LoadUint32(&o.SA3T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA3T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA3T.Reg) & 0xffff
}

// EMAC.SA4B: Specific Address 4 Bottom Register
func (o *EMAC_Type) SetSA4B(value uint32) {
	volatile.StoreUint32(&o.SA4B.Reg, value)
}
func (o *EMAC_Type) GetSA4B() uint32 {
	return volatile.LoadUint32(&o.SA4B.Reg)
}

// EMAC.SA4T: Specific Address 4 Top Register
func (o *EMAC_Type) SetSA4T_ADDR(value uint32) {
	volatile.StoreUint32(&o.SA4T.Reg, volatile.LoadUint32(&o.SA4T.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetSA4T_ADDR() uint32 {
	return volatile.LoadUint32(&o.SA4T.Reg) & 0xffff
}

// EMAC.TID: Type ID Checking Register
func (o *EMAC_Type) SetTID(value uint32) {
	volatile.StoreUint32(&o.TID.Reg, volatile.LoadUint32(&o.TID.Reg)&^(0xffff)|value)
}
func (o *EMAC_Type) GetTID() uint32 {
	return volatile.LoadUint32(&o.TID.Reg) & 0xffff
}

// EMAC.USRIO: User Input/Output Register
func (o *EMAC_Type) SetUSRIO_RMII(value uint32) {
	volatile.StoreUint32(&o.USRIO.Reg, volatile.LoadUint32(&o.USRIO.Reg)&^(0x1)|value)
}
func (o *EMAC_Type) GetUSRIO_RMII() uint32 {
	return volatile.LoadUint32(&o.USRIO.Reg) & 0x1
}
func (o *EMAC_Type) SetUSRIO_CLKEN(value uint32) {
	volatile.StoreUint32(&o.USRIO.Reg, volatile.LoadUint32(&o.USRIO.Reg)&^(0x2)|value<<1)
}
func (o *EMAC_Type) GetUSRIO_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.USRIO.Reg) & 0x2) >> 1
}

// True Random Number Generator
type TRNG_Type struct {
	CR    volatile.Register32 // 0x0
	_     [12]byte
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [48]byte
	ODATA volatile.Register32 // 0x50
}

// TRNG.CR: Control Register
func (o *TRNG_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// TRNG.IER: Interrupt Enable Register
func (o *TRNG_Type) SetIER_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIER_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// TRNG.IDR: Interrupt Disable Register
func (o *TRNG_Type) SetIDR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIDR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// TRNG.IMR: Interrupt Mask Register
func (o *TRNG_Type) SetIMR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetIMR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}

// TRNG.ISR: Interrupt Status Register
func (o *TRNG_Type) SetISR_DATRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetISR_DATRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// TRNG.ODATA: Output Data Register
func (o *TRNG_Type) SetODATA(value uint32) {
	volatile.StoreUint32(&o.ODATA.Reg, value)
}
func (o *TRNG_Type) GetODATA() uint32 {
	return volatile.LoadUint32(&o.ODATA.Reg)
}

// DDR_SDR SDRAM Controller 1
type EBI_Type struct {
	MR    volatile.Register32 // 0x0
	RTR   volatile.Register32 // 0x4
	CR    volatile.Register32 // 0x8
	TPR0  volatile.Register32 // 0xC
	TPR1  volatile.Register32 // 0x10
	TPR2  volatile.Register32 // 0x14
	_     [4]byte
	LPR   volatile.Register32 // 0x1C
	MD    volatile.Register32 // 0x20
	DLL   volatile.Register32 // 0x24
	_     [4]byte
	HS    volatile.Register32 // 0x2C
	_     [16]byte
	DELAY [4]volatile.Register32 // 0x40
	_     [148]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// EBI.MR: DDRSDRC Mode Register
func (o *EBI_Type) SetMR_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetMR_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x7
}

// EBI.RTR: DDRSDRC Refresh Timer Register
func (o *EBI_Type) SetRTR_COUNT(value uint32) {
	volatile.StoreUint32(&o.RTR.Reg, volatile.LoadUint32(&o.RTR.Reg)&^(0xfff)|value)
}
func (o *EBI_Type) GetRTR_COUNT() uint32 {
	return volatile.LoadUint32(&o.RTR.Reg) & 0xfff
}

// EBI.CR: DDRSDRC Configuration Register
func (o *EBI_Type) SetCR_NC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3)|value)
}
func (o *EBI_Type) GetCR_NC() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x3
}
func (o *EBI_Type) SetCR_NR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc)|value<<2)
}
func (o *EBI_Type) GetCR_NR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc) >> 2
}
func (o *EBI_Type) SetCR_CAS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x70)|value<<4)
}
func (o *EBI_Type) GetCR_CAS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x70) >> 4
}
func (o *EBI_Type) SetCR_DLL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *EBI_Type) GetCR_DLL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *EBI_Type) SetCR_DIC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *EBI_Type) GetCR_DIC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *EBI_Type) SetCR_DIS_DLL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *EBI_Type) GetCR_DIS_DLL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *EBI_Type) SetCR_OCD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7000)|value<<12)
}
func (o *EBI_Type) GetCR_OCD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x7000) >> 12
}
func (o *EBI_Type) SetCR_EBISHARE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetCR_EBISHARE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetCR_ACTBST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *EBI_Type) GetCR_ACTBST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}

// EBI.TPR0: DDRSDRC Timing Parameter 0 Register
func (o *EBI_Type) SetTPR0_TRAS(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf)|value)
}
func (o *EBI_Type) GetTPR0_TRAS() uint32 {
	return volatile.LoadUint32(&o.TPR0.Reg) & 0xf
}
func (o *EBI_Type) SetTPR0_TRCD(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf0)|value<<4)
}
func (o *EBI_Type) GetTPR0_TRCD() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf0) >> 4
}
func (o *EBI_Type) SetTPR0_TWR(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf00)|value<<8)
}
func (o *EBI_Type) GetTPR0_TWR() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf00) >> 8
}
func (o *EBI_Type) SetTPR0_TRC(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf000)|value<<12)
}
func (o *EBI_Type) GetTPR0_TRC() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf000) >> 12
}
func (o *EBI_Type) SetTPR0_TRP(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetTPR0_TRP() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetTPR0_TRRD(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf00000)|value<<20)
}
func (o *EBI_Type) GetTPR0_TRRD() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf00000) >> 20
}
func (o *EBI_Type) SetTPR0_TWTR(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0x7000000)|value<<24)
}
func (o *EBI_Type) GetTPR0_TWTR() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0x7000000) >> 24
}
func (o *EBI_Type) SetTPR0_REDUCE_WRRD(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0x8000000)|value<<27)
}
func (o *EBI_Type) GetTPR0_REDUCE_WRRD() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0x8000000) >> 27
}
func (o *EBI_Type) SetTPR0_TMRD(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf0000000)|value<<28)
}
func (o *EBI_Type) GetTPR0_TMRD() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf0000000) >> 28
}

// EBI.TPR1: DDRSDRC Timing Parameter 1 Register
func (o *EBI_Type) SetTPR1_TRFC(value uint32) {
	volatile.StoreUint32(&o.TPR1.Reg, volatile.LoadUint32(&o.TPR1.Reg)&^(0x1f)|value)
}
func (o *EBI_Type) GetTPR1_TRFC() uint32 {
	return volatile.LoadUint32(&o.TPR1.Reg) & 0x1f
}
func (o *EBI_Type) SetTPR1_TXSNR(value uint32) {
	volatile.StoreUint32(&o.TPR1.Reg, volatile.LoadUint32(&o.TPR1.Reg)&^(0xff00)|value<<8)
}
func (o *EBI_Type) GetTPR1_TXSNR() uint32 {
	return (volatile.LoadUint32(&o.TPR1.Reg) & 0xff00) >> 8
}
func (o *EBI_Type) SetTPR1_TXSRD(value uint32) {
	volatile.StoreUint32(&o.TPR1.Reg, volatile.LoadUint32(&o.TPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *EBI_Type) GetTPR1_TXSRD() uint32 {
	return (volatile.LoadUint32(&o.TPR1.Reg) & 0xff0000) >> 16
}
func (o *EBI_Type) SetTPR1_TXP(value uint32) {
	volatile.StoreUint32(&o.TPR1.Reg, volatile.LoadUint32(&o.TPR1.Reg)&^(0xf000000)|value<<24)
}
func (o *EBI_Type) GetTPR1_TXP() uint32 {
	return (volatile.LoadUint32(&o.TPR1.Reg) & 0xf000000) >> 24
}

// EBI.TPR2: DDRSDRC Timing Parameter 2 Register
func (o *EBI_Type) SetTPR2_TXARD(value uint32) {
	volatile.StoreUint32(&o.TPR2.Reg, volatile.LoadUint32(&o.TPR2.Reg)&^(0xf)|value)
}
func (o *EBI_Type) GetTPR2_TXARD() uint32 {
	return volatile.LoadUint32(&o.TPR2.Reg) & 0xf
}
func (o *EBI_Type) SetTPR2_TXARDS(value uint32) {
	volatile.StoreUint32(&o.TPR2.Reg, volatile.LoadUint32(&o.TPR2.Reg)&^(0xf0)|value<<4)
}
func (o *EBI_Type) GetTPR2_TXARDS() uint32 {
	return (volatile.LoadUint32(&o.TPR2.Reg) & 0xf0) >> 4
}
func (o *EBI_Type) SetTPR2_TRPA(value uint32) {
	volatile.StoreUint32(&o.TPR2.Reg, volatile.LoadUint32(&o.TPR2.Reg)&^(0xf00)|value<<8)
}
func (o *EBI_Type) GetTPR2_TRPA() uint32 {
	return (volatile.LoadUint32(&o.TPR2.Reg) & 0xf00) >> 8
}
func (o *EBI_Type) SetTPR2_TRTP(value uint32) {
	volatile.StoreUint32(&o.TPR2.Reg, volatile.LoadUint32(&o.TPR2.Reg)&^(0x7000)|value<<12)
}
func (o *EBI_Type) GetTPR2_TRTP() uint32 {
	return (volatile.LoadUint32(&o.TPR2.Reg) & 0x7000) >> 12
}

// EBI.LPR: DDRSDRC Low-power Register
func (o *EBI_Type) SetLPR_LPCB(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x3)|value)
}
func (o *EBI_Type) GetLPR_LPCB() uint32 {
	return volatile.LoadUint32(&o.LPR.Reg) & 0x3
}
func (o *EBI_Type) SetLPR_CLK_FR(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x4)|value<<2)
}
func (o *EBI_Type) GetLPR_CLK_FR() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x4) >> 2
}
func (o *EBI_Type) SetLPR_PASR(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x70)|value<<4)
}
func (o *EBI_Type) GetLPR_PASR() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x70) >> 4
}
func (o *EBI_Type) SetLPR_TCR(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x300)|value<<8)
}
func (o *EBI_Type) GetLPR_TCR() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x300) >> 8
}
func (o *EBI_Type) SetLPR_DS(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0xc00)|value<<10)
}
func (o *EBI_Type) GetLPR_DS() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0xc00) >> 10
}
func (o *EBI_Type) SetLPR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x3000)|value<<12)
}
func (o *EBI_Type) GetLPR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x3000) >> 12
}
func (o *EBI_Type) SetLPR_APDE(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x10000)|value<<16)
}
func (o *EBI_Type) GetLPR_APDE() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x10000) >> 16
}
func (o *EBI_Type) SetLPR_UPD_MR(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x300000)|value<<20)
}
func (o *EBI_Type) GetLPR_UPD_MR() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x300000) >> 20
}

// EBI.MD: DDRSDRC Memory Device Register
func (o *EBI_Type) SetMD(value uint32) {
	volatile.StoreUint32(&o.MD.Reg, volatile.LoadUint32(&o.MD.Reg)&^(0x7)|value)
}
func (o *EBI_Type) GetMD() uint32 {
	return volatile.LoadUint32(&o.MD.Reg) & 0x7
}
func (o *EBI_Type) SetMD_DBW(value uint32) {
	volatile.StoreUint32(&o.MD.Reg, volatile.LoadUint32(&o.MD.Reg)&^(0x10)|value<<4)
}
func (o *EBI_Type) GetMD_DBW() uint32 {
	return (volatile.LoadUint32(&o.MD.Reg) & 0x10) >> 4
}

// EBI.DLL: DDRSDRC DLL Information Register
func (o *EBI_Type) SetDLL_MDINC(value uint32) {
	volatile.StoreUint32(&o.DLL.Reg, volatile.LoadUint32(&o.DLL.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetDLL_MDINC() uint32 {
	return volatile.LoadUint32(&o.DLL.Reg) & 0x1
}
func (o *EBI_Type) SetDLL_MDDEC(value uint32) {
	volatile.StoreUint32(&o.DLL.Reg, volatile.LoadUint32(&o.DLL.Reg)&^(0x2)|value<<1)
}
func (o *EBI_Type) GetDLL_MDDEC() uint32 {
	return (volatile.LoadUint32(&o.DLL.Reg) & 0x2) >> 1
}
func (o *EBI_Type) SetDLL_MDOVF(value uint32) {
	volatile.StoreUint32(&o.DLL.Reg, volatile.LoadUint32(&o.DLL.Reg)&^(0x4)|value<<2)
}
func (o *EBI_Type) GetDLL_MDOVF() uint32 {
	return (volatile.LoadUint32(&o.DLL.Reg) & 0x4) >> 2
}
func (o *EBI_Type) SetDLL_MDVAL(value uint32) {
	volatile.StoreUint32(&o.DLL.Reg, volatile.LoadUint32(&o.DLL.Reg)&^(0xff00)|value<<8)
}
func (o *EBI_Type) GetDLL_MDVAL() uint32 {
	return (volatile.LoadUint32(&o.DLL.Reg) & 0xff00) >> 8
}

// EBI.HS: DDRSDRC High Speed Register
func (o *EBI_Type) SetHS_DIS_ANTICIP_READ(value uint32) {
	volatile.StoreUint32(&o.HS.Reg, volatile.LoadUint32(&o.HS.Reg)&^(0x4)|value<<2)
}
func (o *EBI_Type) GetHS_DIS_ANTICIP_READ() uint32 {
	return (volatile.LoadUint32(&o.HS.Reg) & 0x4) >> 2
}

// EBI.DELAY: DDRSDRC Delay I/O Register
func (o *EBI_Type) SetDELAY_DELAY1(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf)|value)
}
func (o *EBI_Type) GetDELAY_DELAY1(idx int) uint32 {
	return volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf
}
func (o *EBI_Type) SetDELAY_DELAY2(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf0)|value<<4)
}
func (o *EBI_Type) GetDELAY_DELAY2(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf0) >> 4
}
func (o *EBI_Type) SetDELAY_DELAY3(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf00)|value<<8)
}
func (o *EBI_Type) GetDELAY_DELAY3(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf00) >> 8
}
func (o *EBI_Type) SetDELAY_DELAY4(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf000)|value<<12)
}
func (o *EBI_Type) GetDELAY_DELAY4(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf000) >> 12
}
func (o *EBI_Type) SetDELAY_DELAY5(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf0000)|value<<16)
}
func (o *EBI_Type) GetDELAY_DELAY5(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf0000) >> 16
}
func (o *EBI_Type) SetDELAY_DELAY6(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf00000)|value<<20)
}
func (o *EBI_Type) GetDELAY_DELAY6(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf00000) >> 20
}
func (o *EBI_Type) SetDELAY_DELAY7(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf000000)|value<<24)
}
func (o *EBI_Type) GetDELAY_DELAY7(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf000000) >> 24
}
func (o *EBI_Type) SetDELAY_DELAY8(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf0000000)|value<<28)
}
func (o *EBI_Type) GetDELAY_DELAY8(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf0000000) >> 28
}

// EBI.WPMR: DDRSDRC Write Protect Mode Register
func (o *EBI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *EBI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *EBI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// EBI.WPSR: DDRSDRC Write Protect Status Register
func (o *EBI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *EBI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *EBI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *EBI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// DDR_SDR SDRAM Controller 0
type DDRSDRC_Type struct {
	MR    volatile.Register32 // 0x0
	RTR   volatile.Register32 // 0x4
	CR    volatile.Register32 // 0x8
	TPR0  volatile.Register32 // 0xC
	TPR1  volatile.Register32 // 0x10
	TPR2  volatile.Register32 // 0x14
	_     [4]byte
	LPR   volatile.Register32 // 0x1C
	MD    volatile.Register32 // 0x20
	DLL   volatile.Register32 // 0x24
	_     [4]byte
	HS    volatile.Register32 // 0x2C
	_     [16]byte
	DELAY [4]volatile.Register32 // 0x40
	_     [148]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
}

// DDRSDRC.MR: DDRSDRC Mode Register
func (o *DDRSDRC_Type) SetMR_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7)|value)
}
func (o *DDRSDRC_Type) GetMR_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x7
}

// DDRSDRC.RTR: DDRSDRC Refresh Timer Register
func (o *DDRSDRC_Type) SetRTR_COUNT(value uint32) {
	volatile.StoreUint32(&o.RTR.Reg, volatile.LoadUint32(&o.RTR.Reg)&^(0xfff)|value)
}
func (o *DDRSDRC_Type) GetRTR_COUNT() uint32 {
	return volatile.LoadUint32(&o.RTR.Reg) & 0xfff
}

// DDRSDRC.CR: DDRSDRC Configuration Register
func (o *DDRSDRC_Type) SetCR_NC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3)|value)
}
func (o *DDRSDRC_Type) GetCR_NC() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x3
}
func (o *DDRSDRC_Type) SetCR_NR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc)|value<<2)
}
func (o *DDRSDRC_Type) GetCR_NR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc) >> 2
}
func (o *DDRSDRC_Type) SetCR_CAS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x70)|value<<4)
}
func (o *DDRSDRC_Type) GetCR_CAS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x70) >> 4
}
func (o *DDRSDRC_Type) SetCR_DLL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DDRSDRC_Type) GetCR_DLL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DDRSDRC_Type) SetCR_DIC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DDRSDRC_Type) GetCR_DIC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DDRSDRC_Type) SetCR_DIS_DLL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DDRSDRC_Type) GetCR_DIS_DLL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DDRSDRC_Type) SetCR_OCD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7000)|value<<12)
}
func (o *DDRSDRC_Type) GetCR_OCD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x7000) >> 12
}
func (o *DDRSDRC_Type) SetCR_EBISHARE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DDRSDRC_Type) GetCR_EBISHARE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DDRSDRC_Type) SetCR_ACTBST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DDRSDRC_Type) GetCR_ACTBST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}

// DDRSDRC.TPR0: DDRSDRC Timing Parameter 0 Register
func (o *DDRSDRC_Type) SetTPR0_TRAS(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf)|value)
}
func (o *DDRSDRC_Type) GetTPR0_TRAS() uint32 {
	return volatile.LoadUint32(&o.TPR0.Reg) & 0xf
}
func (o *DDRSDRC_Type) SetTPR0_TRCD(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf0)|value<<4)
}
func (o *DDRSDRC_Type) GetTPR0_TRCD() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf0) >> 4
}
func (o *DDRSDRC_Type) SetTPR0_TWR(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf00)|value<<8)
}
func (o *DDRSDRC_Type) GetTPR0_TWR() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf00) >> 8
}
func (o *DDRSDRC_Type) SetTPR0_TRC(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf000)|value<<12)
}
func (o *DDRSDRC_Type) GetTPR0_TRC() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf000) >> 12
}
func (o *DDRSDRC_Type) SetTPR0_TRP(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf0000)|value<<16)
}
func (o *DDRSDRC_Type) GetTPR0_TRP() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf0000) >> 16
}
func (o *DDRSDRC_Type) SetTPR0_TRRD(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf00000)|value<<20)
}
func (o *DDRSDRC_Type) GetTPR0_TRRD() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf00000) >> 20
}
func (o *DDRSDRC_Type) SetTPR0_TWTR(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0x7000000)|value<<24)
}
func (o *DDRSDRC_Type) GetTPR0_TWTR() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0x7000000) >> 24
}
func (o *DDRSDRC_Type) SetTPR0_REDUCE_WRRD(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0x8000000)|value<<27)
}
func (o *DDRSDRC_Type) GetTPR0_REDUCE_WRRD() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0x8000000) >> 27
}
func (o *DDRSDRC_Type) SetTPR0_TMRD(value uint32) {
	volatile.StoreUint32(&o.TPR0.Reg, volatile.LoadUint32(&o.TPR0.Reg)&^(0xf0000000)|value<<28)
}
func (o *DDRSDRC_Type) GetTPR0_TMRD() uint32 {
	return (volatile.LoadUint32(&o.TPR0.Reg) & 0xf0000000) >> 28
}

// DDRSDRC.TPR1: DDRSDRC Timing Parameter 1 Register
func (o *DDRSDRC_Type) SetTPR1_TRFC(value uint32) {
	volatile.StoreUint32(&o.TPR1.Reg, volatile.LoadUint32(&o.TPR1.Reg)&^(0x1f)|value)
}
func (o *DDRSDRC_Type) GetTPR1_TRFC() uint32 {
	return volatile.LoadUint32(&o.TPR1.Reg) & 0x1f
}
func (o *DDRSDRC_Type) SetTPR1_TXSNR(value uint32) {
	volatile.StoreUint32(&o.TPR1.Reg, volatile.LoadUint32(&o.TPR1.Reg)&^(0xff00)|value<<8)
}
func (o *DDRSDRC_Type) GetTPR1_TXSNR() uint32 {
	return (volatile.LoadUint32(&o.TPR1.Reg) & 0xff00) >> 8
}
func (o *DDRSDRC_Type) SetTPR1_TXSRD(value uint32) {
	volatile.StoreUint32(&o.TPR1.Reg, volatile.LoadUint32(&o.TPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *DDRSDRC_Type) GetTPR1_TXSRD() uint32 {
	return (volatile.LoadUint32(&o.TPR1.Reg) & 0xff0000) >> 16
}
func (o *DDRSDRC_Type) SetTPR1_TXP(value uint32) {
	volatile.StoreUint32(&o.TPR1.Reg, volatile.LoadUint32(&o.TPR1.Reg)&^(0xf000000)|value<<24)
}
func (o *DDRSDRC_Type) GetTPR1_TXP() uint32 {
	return (volatile.LoadUint32(&o.TPR1.Reg) & 0xf000000) >> 24
}

// DDRSDRC.TPR2: DDRSDRC Timing Parameter 2 Register
func (o *DDRSDRC_Type) SetTPR2_TXARD(value uint32) {
	volatile.StoreUint32(&o.TPR2.Reg, volatile.LoadUint32(&o.TPR2.Reg)&^(0xf)|value)
}
func (o *DDRSDRC_Type) GetTPR2_TXARD() uint32 {
	return volatile.LoadUint32(&o.TPR2.Reg) & 0xf
}
func (o *DDRSDRC_Type) SetTPR2_TXARDS(value uint32) {
	volatile.StoreUint32(&o.TPR2.Reg, volatile.LoadUint32(&o.TPR2.Reg)&^(0xf0)|value<<4)
}
func (o *DDRSDRC_Type) GetTPR2_TXARDS() uint32 {
	return (volatile.LoadUint32(&o.TPR2.Reg) & 0xf0) >> 4
}
func (o *DDRSDRC_Type) SetTPR2_TRPA(value uint32) {
	volatile.StoreUint32(&o.TPR2.Reg, volatile.LoadUint32(&o.TPR2.Reg)&^(0xf00)|value<<8)
}
func (o *DDRSDRC_Type) GetTPR2_TRPA() uint32 {
	return (volatile.LoadUint32(&o.TPR2.Reg) & 0xf00) >> 8
}
func (o *DDRSDRC_Type) SetTPR2_TRTP(value uint32) {
	volatile.StoreUint32(&o.TPR2.Reg, volatile.LoadUint32(&o.TPR2.Reg)&^(0x7000)|value<<12)
}
func (o *DDRSDRC_Type) GetTPR2_TRTP() uint32 {
	return (volatile.LoadUint32(&o.TPR2.Reg) & 0x7000) >> 12
}

// DDRSDRC.LPR: DDRSDRC Low-power Register
func (o *DDRSDRC_Type) SetLPR_LPCB(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x3)|value)
}
func (o *DDRSDRC_Type) GetLPR_LPCB() uint32 {
	return volatile.LoadUint32(&o.LPR.Reg) & 0x3
}
func (o *DDRSDRC_Type) SetLPR_CLK_FR(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x4)|value<<2)
}
func (o *DDRSDRC_Type) GetLPR_CLK_FR() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x4) >> 2
}
func (o *DDRSDRC_Type) SetLPR_PASR(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x70)|value<<4)
}
func (o *DDRSDRC_Type) GetLPR_PASR() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x70) >> 4
}
func (o *DDRSDRC_Type) SetLPR_TCR(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x300)|value<<8)
}
func (o *DDRSDRC_Type) GetLPR_TCR() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x300) >> 8
}
func (o *DDRSDRC_Type) SetLPR_DS(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0xc00)|value<<10)
}
func (o *DDRSDRC_Type) GetLPR_DS() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0xc00) >> 10
}
func (o *DDRSDRC_Type) SetLPR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x3000)|value<<12)
}
func (o *DDRSDRC_Type) GetLPR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x3000) >> 12
}
func (o *DDRSDRC_Type) SetLPR_APDE(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x10000)|value<<16)
}
func (o *DDRSDRC_Type) GetLPR_APDE() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x10000) >> 16
}
func (o *DDRSDRC_Type) SetLPR_UPD_MR(value uint32) {
	volatile.StoreUint32(&o.LPR.Reg, volatile.LoadUint32(&o.LPR.Reg)&^(0x300000)|value<<20)
}
func (o *DDRSDRC_Type) GetLPR_UPD_MR() uint32 {
	return (volatile.LoadUint32(&o.LPR.Reg) & 0x300000) >> 20
}

// DDRSDRC.MD: DDRSDRC Memory Device Register
func (o *DDRSDRC_Type) SetMD(value uint32) {
	volatile.StoreUint32(&o.MD.Reg, volatile.LoadUint32(&o.MD.Reg)&^(0x7)|value)
}
func (o *DDRSDRC_Type) GetMD() uint32 {
	return volatile.LoadUint32(&o.MD.Reg) & 0x7
}
func (o *DDRSDRC_Type) SetMD_DBW(value uint32) {
	volatile.StoreUint32(&o.MD.Reg, volatile.LoadUint32(&o.MD.Reg)&^(0x10)|value<<4)
}
func (o *DDRSDRC_Type) GetMD_DBW() uint32 {
	return (volatile.LoadUint32(&o.MD.Reg) & 0x10) >> 4
}

// DDRSDRC.DLL: DDRSDRC DLL Information Register
func (o *DDRSDRC_Type) SetDLL_MDINC(value uint32) {
	volatile.StoreUint32(&o.DLL.Reg, volatile.LoadUint32(&o.DLL.Reg)&^(0x1)|value)
}
func (o *DDRSDRC_Type) GetDLL_MDINC() uint32 {
	return volatile.LoadUint32(&o.DLL.Reg) & 0x1
}
func (o *DDRSDRC_Type) SetDLL_MDDEC(value uint32) {
	volatile.StoreUint32(&o.DLL.Reg, volatile.LoadUint32(&o.DLL.Reg)&^(0x2)|value<<1)
}
func (o *DDRSDRC_Type) GetDLL_MDDEC() uint32 {
	return (volatile.LoadUint32(&o.DLL.Reg) & 0x2) >> 1
}
func (o *DDRSDRC_Type) SetDLL_MDOVF(value uint32) {
	volatile.StoreUint32(&o.DLL.Reg, volatile.LoadUint32(&o.DLL.Reg)&^(0x4)|value<<2)
}
func (o *DDRSDRC_Type) GetDLL_MDOVF() uint32 {
	return (volatile.LoadUint32(&o.DLL.Reg) & 0x4) >> 2
}
func (o *DDRSDRC_Type) SetDLL_MDVAL(value uint32) {
	volatile.StoreUint32(&o.DLL.Reg, volatile.LoadUint32(&o.DLL.Reg)&^(0xff00)|value<<8)
}
func (o *DDRSDRC_Type) GetDLL_MDVAL() uint32 {
	return (volatile.LoadUint32(&o.DLL.Reg) & 0xff00) >> 8
}

// DDRSDRC.HS: DDRSDRC High Speed Register
func (o *DDRSDRC_Type) SetHS_DIS_ANTICIP_READ(value uint32) {
	volatile.StoreUint32(&o.HS.Reg, volatile.LoadUint32(&o.HS.Reg)&^(0x4)|value<<2)
}
func (o *DDRSDRC_Type) GetHS_DIS_ANTICIP_READ() uint32 {
	return (volatile.LoadUint32(&o.HS.Reg) & 0x4) >> 2
}

// DDRSDRC.DELAY: DDRSDRC Delay I/O Register
func (o *DDRSDRC_Type) SetDELAY_DELAY1(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf)|value)
}
func (o *DDRSDRC_Type) GetDELAY_DELAY1(idx int) uint32 {
	return volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf
}
func (o *DDRSDRC_Type) SetDELAY_DELAY2(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf0)|value<<4)
}
func (o *DDRSDRC_Type) GetDELAY_DELAY2(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf0) >> 4
}
func (o *DDRSDRC_Type) SetDELAY_DELAY3(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf00)|value<<8)
}
func (o *DDRSDRC_Type) GetDELAY_DELAY3(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf00) >> 8
}
func (o *DDRSDRC_Type) SetDELAY_DELAY4(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf000)|value<<12)
}
func (o *DDRSDRC_Type) GetDELAY_DELAY4(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf000) >> 12
}
func (o *DDRSDRC_Type) SetDELAY_DELAY5(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf0000)|value<<16)
}
func (o *DDRSDRC_Type) GetDELAY_DELAY5(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf0000) >> 16
}
func (o *DDRSDRC_Type) SetDELAY_DELAY6(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf00000)|value<<20)
}
func (o *DDRSDRC_Type) GetDELAY_DELAY6(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf00000) >> 20
}
func (o *DDRSDRC_Type) SetDELAY_DELAY7(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf000000)|value<<24)
}
func (o *DDRSDRC_Type) GetDELAY_DELAY7(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf000000) >> 24
}
func (o *DDRSDRC_Type) SetDELAY_DELAY8(idx int, value uint32) {
	volatile.StoreUint32(&o.DELAY[idx].Reg, volatile.LoadUint32(&o.DELAY[idx].Reg)&^(0xf0000000)|value<<28)
}
func (o *DDRSDRC_Type) GetDELAY_DELAY8(idx int) uint32 {
	return (volatile.LoadUint32(&o.DELAY[idx].Reg) & 0xf0000000) >> 28
}

// DDRSDRC.WPMR: DDRSDRC Write Protect Mode Register
func (o *DDRSDRC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DDRSDRC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DDRSDRC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DDRSDRC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DDRSDRC.WPSR: DDRSDRC Write Protect Status Register
func (o *DDRSDRC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DDRSDRC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DDRSDRC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *DDRSDRC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MCFG  [11]volatile.Register32 // 0x0
	_     [20]byte
	SCFG  [8]volatile.Register32 // 0x40
	_     [32]byte
	PRAS0 volatile.Register32 // 0x80
	PRBS0 volatile.Register32 // 0x84
	PRAS1 volatile.Register32 // 0x88
	PRBS1 volatile.Register32 // 0x8C
	PRAS2 volatile.Register32 // 0x90
	PRBS2 volatile.Register32 // 0x94
	PRAS3 volatile.Register32 // 0x98
	PRBS3 volatile.Register32 // 0x9C
	PRAS4 volatile.Register32 // 0xA0
	PRBS4 volatile.Register32 // 0xA4
	PRAS5 volatile.Register32 // 0xA8
	PRBS5 volatile.Register32 // 0xAC
	PRAS6 volatile.Register32 // 0xB0
	PRBS6 volatile.Register32 // 0xB4
	PRAS7 volatile.Register32 // 0xB8
	PRBS7 volatile.Register32 // 0xBC
	_     [64]byte
	MRCR  volatile.Register32 // 0x100
	_     [224]byte
	WPMR  volatile.Register32 // 0x1E4
	WPSR  volatile.Register32 // 0x1E8
}

// MATRIX.MCFG: Master Configuration Register
func (o *MATRIX_Type) SetMCFG_ULBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MCFG[idx].Reg, volatile.LoadUint32(&o.MCFG[idx].Reg)&^(0x7)|value)
}
func (o *MATRIX_Type) GetMCFG_ULBT(idx int) uint32 {
	return volatile.LoadUint32(&o.MCFG[idx].Reg) & 0x7
}

// MATRIX.SCFG: Slave Configuration Register
func (o *MATRIX_Type) SetSCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x1ff)|value)
}
func (o *MATRIX_Type) GetSCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x1ff
}
func (o *MATRIX_Type) SetSCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetSCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetSCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.SCFG[idx].Reg, volatile.LoadUint32(&o.SCFG[idx].Reg)&^(0x3c0000)|value<<18)
}
func (o *MATRIX_Type) GetSCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.SCFG[idx].Reg) & 0x3c0000) >> 18
}

// MATRIX.PRAS0: Priority Register A for Slave 0
func (o *MATRIX_Type) SetPRAS0_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS0_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS0.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS0_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS0_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS0_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS0_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS0_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS0_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS0_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS0_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS0_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS0_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS0_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS0_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS0_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS0.Reg, volatile.LoadUint32(&o.PRAS0.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS0_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS0.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS0: Priority Register B for Slave 0
func (o *MATRIX_Type) SetPRBS0_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS0.Reg, volatile.LoadUint32(&o.PRBS0.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS0_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS0.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS0_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS0.Reg, volatile.LoadUint32(&o.PRBS0.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS0_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS0.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS0_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS0.Reg, volatile.LoadUint32(&o.PRBS0.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS0_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS0.Reg) & 0x300) >> 8
}

// MATRIX.PRAS1: Priority Register A for Slave 1
func (o *MATRIX_Type) SetPRAS1_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS1_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS1.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS1_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS1_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS1_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS1_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS1_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS1_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS1_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS1_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS1_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS1_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS1_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS1_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS1_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS1.Reg, volatile.LoadUint32(&o.PRAS1.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS1_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS1.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS1: Priority Register B for Slave 1
func (o *MATRIX_Type) SetPRBS1_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS1.Reg, volatile.LoadUint32(&o.PRBS1.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS1_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS1.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS1_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS1.Reg, volatile.LoadUint32(&o.PRBS1.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS1_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS1.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS1_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS1.Reg, volatile.LoadUint32(&o.PRBS1.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS1_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS1.Reg) & 0x300) >> 8
}

// MATRIX.PRAS2: Priority Register A for Slave 2
func (o *MATRIX_Type) SetPRAS2_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS2_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS2.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS2_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS2_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS2_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS2_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS2_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS2_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS2_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS2_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS2_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS2_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS2_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS2_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS2_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS2.Reg, volatile.LoadUint32(&o.PRAS2.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS2_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS2.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS2: Priority Register B for Slave 2
func (o *MATRIX_Type) SetPRBS2_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS2.Reg, volatile.LoadUint32(&o.PRBS2.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS2_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS2.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS2_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS2.Reg, volatile.LoadUint32(&o.PRBS2.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS2_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS2.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS2_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS2.Reg, volatile.LoadUint32(&o.PRBS2.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS2_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS2.Reg) & 0x300) >> 8
}

// MATRIX.PRAS3: Priority Register A for Slave 3
func (o *MATRIX_Type) SetPRAS3_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS3_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS3.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS3_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS3_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS3_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS3_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS3_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS3_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS3_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS3_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS3_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS3_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS3_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS3_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS3_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS3.Reg, volatile.LoadUint32(&o.PRAS3.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS3_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS3.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS3: Priority Register B for Slave 3
func (o *MATRIX_Type) SetPRBS3_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS3.Reg, volatile.LoadUint32(&o.PRBS3.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS3_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS3.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS3_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS3.Reg, volatile.LoadUint32(&o.PRBS3.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS3_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS3.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS3_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS3.Reg, volatile.LoadUint32(&o.PRBS3.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS3_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS3.Reg) & 0x300) >> 8
}

// MATRIX.PRAS4: Priority Register A for Slave 4
func (o *MATRIX_Type) SetPRAS4_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS4_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS4.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS4_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS4_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS4_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS4_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS4_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS4_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS4_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS4_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS4_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS4_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS4_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS4_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS4_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS4.Reg, volatile.LoadUint32(&o.PRAS4.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS4_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS4.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS4: Priority Register B for Slave 4
func (o *MATRIX_Type) SetPRBS4_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS4.Reg, volatile.LoadUint32(&o.PRBS4.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS4_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS4.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS4_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS4.Reg, volatile.LoadUint32(&o.PRBS4.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS4_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS4.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS4_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS4.Reg, volatile.LoadUint32(&o.PRBS4.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS4_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS4.Reg) & 0x300) >> 8
}

// MATRIX.PRAS5: Priority Register A for Slave 5
func (o *MATRIX_Type) SetPRAS5_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS5_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS5.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS5_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS5_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS5_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS5_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS5_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS5_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS5_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS5_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS5_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS5_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS5_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS5_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS5_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS5.Reg, volatile.LoadUint32(&o.PRAS5.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS5_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS5.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS5: Priority Register B for Slave 5
func (o *MATRIX_Type) SetPRBS5_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS5.Reg, volatile.LoadUint32(&o.PRBS5.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS5_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS5.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS5_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS5.Reg, volatile.LoadUint32(&o.PRBS5.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS5_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS5.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS5_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS5.Reg, volatile.LoadUint32(&o.PRBS5.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS5_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS5.Reg) & 0x300) >> 8
}

// MATRIX.PRAS6: Priority Register A for Slave 6
func (o *MATRIX_Type) SetPRAS6_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS6_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS6.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS6_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS6_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS6_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS6_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS6_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS6_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS6_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS6_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS6_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS6_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS6_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS6_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS6_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS6.Reg, volatile.LoadUint32(&o.PRAS6.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS6_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS6.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS6: Priority Register B for Slave 6
func (o *MATRIX_Type) SetPRBS6_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS6.Reg, volatile.LoadUint32(&o.PRBS6.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS6_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS6.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS6_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS6.Reg, volatile.LoadUint32(&o.PRBS6.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS6_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS6.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS6_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS6.Reg, volatile.LoadUint32(&o.PRBS6.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS6_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS6.Reg) & 0x300) >> 8
}

// MATRIX.PRAS7: Priority Register A for Slave 7
func (o *MATRIX_Type) SetPRAS7_M0PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRAS7_M0PR() uint32 {
	return volatile.LoadUint32(&o.PRAS7.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRAS7_M1PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRAS7_M1PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRAS7_M2PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRAS7_M2PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetPRAS7_M3PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetPRAS7_M3PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x3000) >> 12
}
func (o *MATRIX_Type) SetPRAS7_M4PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetPRAS7_M4PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetPRAS7_M5PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x300000)|value<<20)
}
func (o *MATRIX_Type) GetPRAS7_M5PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x300000) >> 20
}
func (o *MATRIX_Type) SetPRAS7_M6PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetPRAS7_M6PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x3000000) >> 24
}
func (o *MATRIX_Type) SetPRAS7_M7PR(value uint32) {
	volatile.StoreUint32(&o.PRAS7.Reg, volatile.LoadUint32(&o.PRAS7.Reg)&^(0x30000000)|value<<28)
}
func (o *MATRIX_Type) GetPRAS7_M7PR() uint32 {
	return (volatile.LoadUint32(&o.PRAS7.Reg) & 0x30000000) >> 28
}

// MATRIX.PRBS7: Priority Register B for Slave 7
func (o *MATRIX_Type) SetPRBS7_M8PR(value uint32) {
	volatile.StoreUint32(&o.PRBS7.Reg, volatile.LoadUint32(&o.PRBS7.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetPRBS7_M8PR() uint32 {
	return volatile.LoadUint32(&o.PRBS7.Reg) & 0x3
}
func (o *MATRIX_Type) SetPRBS7_M9PR(value uint32) {
	volatile.StoreUint32(&o.PRBS7.Reg, volatile.LoadUint32(&o.PRBS7.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetPRBS7_M9PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS7.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetPRBS7_M10PR(value uint32) {
	volatile.StoreUint32(&o.PRBS7.Reg, volatile.LoadUint32(&o.PRBS7.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetPRBS7_M10PR() uint32 {
	return (volatile.LoadUint32(&o.PRBS7.Reg) & 0x300) >> 8
}

// MATRIX.MRCR: Master Remap Control Register
func (o *MATRIX_Type) SetMRCR_RCB0(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMRCR_RCB0() uint32 {
	return volatile.LoadUint32(&o.MRCR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMRCR_RCB1(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x2)|value<<1)
}
func (o *MATRIX_Type) GetMRCR_RCB1() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x2) >> 1
}
func (o *MATRIX_Type) SetMRCR_RCB2(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x4)|value<<2)
}
func (o *MATRIX_Type) GetMRCR_RCB2() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x4) >> 2
}
func (o *MATRIX_Type) SetMRCR_RCB3(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x8)|value<<3)
}
func (o *MATRIX_Type) GetMRCR_RCB3() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x8) >> 3
}
func (o *MATRIX_Type) SetMRCR_RCB4(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetMRCR_RCB4() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetMRCR_RCB5(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetMRCR_RCB5() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetMRCR_RCB6(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetMRCR_RCB6() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x40) >> 6
}
func (o *MATRIX_Type) SetMRCR_RCB7(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x80)|value<<7)
}
func (o *MATRIX_Type) GetMRCR_RCB7() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x80) >> 7
}
func (o *MATRIX_Type) SetMRCR_RCB8(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x100)|value<<8)
}
func (o *MATRIX_Type) GetMRCR_RCB8() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x100) >> 8
}
func (o *MATRIX_Type) SetMRCR_RCB9(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x200)|value<<9)
}
func (o *MATRIX_Type) GetMRCR_RCB9() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x200) >> 9
}
func (o *MATRIX_Type) SetMRCR_RCB10(value uint32) {
	volatile.StoreUint32(&o.MRCR.Reg, volatile.LoadUint32(&o.MRCR.Reg)&^(0x400)|value<<10)
}
func (o *MATRIX_Type) GetMRCR_RCB10() uint32 {
	return (volatile.LoadUint32(&o.MRCR.Reg) & 0x400) >> 10
}

// MATRIX.WPMR: Write Protect Mode Register
func (o *MATRIX_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// MATRIX.WPSR: Write Protect Status Register
func (o *MATRIX_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *MATRIX_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *MATRIX_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// DMA Controller
type DMAC_Type struct {
	GCFG   volatile.Register32 // 0x0
	EN     volatile.Register32 // 0x4
	SREQ   volatile.Register32 // 0x8
	CREQ   volatile.Register32 // 0xC
	LAST   volatile.Register32 // 0x10
	_      [4]byte
	EBCIER volatile.Register32 // 0x18
	EBCIDR volatile.Register32 // 0x1C
	EBCIMR volatile.Register32 // 0x20
	EBCISR volatile.Register32 // 0x24
	CHER   volatile.Register32 // 0x28
	CHDR   volatile.Register32 // 0x2C
	CHSR   volatile.Register32 // 0x30
	_      [8]byte
	SADDR0 volatile.Register32 // 0x3C
	DADDR0 volatile.Register32 // 0x40
	DSCR0  volatile.Register32 // 0x44
	CTRLA0 volatile.Register32 // 0x48
	CTRLB0 volatile.Register32 // 0x4C
	CFG0   volatile.Register32 // 0x50
	_      [16]byte
	SADDR1 volatile.Register32 // 0x64
	DADDR1 volatile.Register32 // 0x68
	DSCR1  volatile.Register32 // 0x6C
	CTRLA1 volatile.Register32 // 0x70
	CTRLB1 volatile.Register32 // 0x74
	CFG1   volatile.Register32 // 0x78
	_      [16]byte
	SADDR2 volatile.Register32 // 0x8C
	DADDR2 volatile.Register32 // 0x90
	DSCR2  volatile.Register32 // 0x94
	CTRLA2 volatile.Register32 // 0x98
	CTRLB2 volatile.Register32 // 0x9C
	CFG2   volatile.Register32 // 0xA0
	_      [16]byte
	SADDR3 volatile.Register32 // 0xB4
	DADDR3 volatile.Register32 // 0xB8
	DSCR3  volatile.Register32 // 0xBC
	CTRLA3 volatile.Register32 // 0xC0
	CTRLB3 volatile.Register32 // 0xC4
	CFG3   volatile.Register32 // 0xC8
	_      [16]byte
	SADDR4 volatile.Register32 // 0xDC
	DADDR4 volatile.Register32 // 0xE0
	DSCR4  volatile.Register32 // 0xE4
	CTRLA4 volatile.Register32 // 0xE8
	CTRLB4 volatile.Register32 // 0xEC
	CFG4   volatile.Register32 // 0xF0
	_      [16]byte
	SADDR5 volatile.Register32 // 0x104
	DADDR5 volatile.Register32 // 0x108
	DSCR5  volatile.Register32 // 0x10C
	CTRLA5 volatile.Register32 // 0x110
	CTRLB5 volatile.Register32 // 0x114
	CFG5   volatile.Register32 // 0x118
	_      [16]byte
	SADDR6 volatile.Register32 // 0x12C
	DADDR6 volatile.Register32 // 0x130
	DSCR6  volatile.Register32 // 0x134
	CTRLA6 volatile.Register32 // 0x138
	CTRLB6 volatile.Register32 // 0x13C
	CFG6   volatile.Register32 // 0x140
	_      [16]byte
	SADDR7 volatile.Register32 // 0x154
	DADDR7 volatile.Register32 // 0x158
	DSCR7  volatile.Register32 // 0x15C
	CTRLA7 volatile.Register32 // 0x160
	CTRLB7 volatile.Register32 // 0x164
	CFG7   volatile.Register32 // 0x168
	_      [120]byte
	WPMR   volatile.Register32 // 0x1E4
	WPSR   volatile.Register32 // 0x1E8
}

// DMAC.GCFG: DMAC Global Configuration Register
func (o *DMAC_Type) SetGCFG_ARB_CFG(value uint32) {
	volatile.StoreUint32(&o.GCFG.Reg, volatile.LoadUint32(&o.GCFG.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetGCFG_ARB_CFG() uint32 {
	return (volatile.LoadUint32(&o.GCFG.Reg) & 0x10) >> 4
}

// DMAC.EN: DMAC Enable Register
func (o *DMAC_Type) SetEN_ENABLE(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEN_ENABLE() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// DMAC.SREQ: DMAC Software Single Request Register
func (o *DMAC_Type) SetSREQ_SSREQ0(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetSREQ_SSREQ0() uint32 {
	return volatile.LoadUint32(&o.SREQ.Reg) & 0x1
}
func (o *DMAC_Type) SetSREQ_DSREQ0(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetSREQ_DSREQ0() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetSREQ_SSREQ1(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetSREQ_SSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetSREQ_DSREQ1(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetSREQ_DSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetSREQ_SSREQ2(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetSREQ_SSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetSREQ_DSREQ2(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetSREQ_DSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetSREQ_SSREQ3(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetSREQ_SSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetSREQ_DSREQ3(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetSREQ_DSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetSREQ_SSREQ4(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetSREQ_SSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetSREQ_DSREQ4(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetSREQ_DSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetSREQ_SSREQ5(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetSREQ_SSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetSREQ_DSREQ5(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetSREQ_DSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetSREQ_SSREQ6(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetSREQ_SSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetSREQ_DSREQ6(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetSREQ_DSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetSREQ_SSREQ7(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetSREQ_SSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetSREQ_DSREQ7(value uint32) {
	volatile.StoreUint32(&o.SREQ.Reg, volatile.LoadUint32(&o.SREQ.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetSREQ_DSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SREQ.Reg) & 0x8000) >> 15
}

// DMAC.CREQ: DMAC Software Chunk Transfer Request Register
func (o *DMAC_Type) SetCREQ_SCREQ0(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCREQ_SCREQ0() uint32 {
	return volatile.LoadUint32(&o.CREQ.Reg) & 0x1
}
func (o *DMAC_Type) SetCREQ_DCREQ0(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCREQ_DCREQ0() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCREQ_SCREQ1(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCREQ_SCREQ1() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCREQ_DCREQ1(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCREQ_DCREQ1() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCREQ_SCREQ2(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCREQ_SCREQ2() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCREQ_DCREQ2(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCREQ_DCREQ2() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCREQ_SCREQ3(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCREQ_SCREQ3() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCREQ_DCREQ3(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCREQ_DCREQ3() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCREQ_SCREQ4(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCREQ_SCREQ4() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCREQ_DCREQ4(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCREQ_DCREQ4() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCREQ_SCREQ5(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCREQ_SCREQ5() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCREQ_DCREQ5(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCREQ_DCREQ5() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCREQ_SCREQ6(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCREQ_SCREQ6() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCREQ_DCREQ6(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCREQ_DCREQ6() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCREQ_SCREQ7(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCREQ_SCREQ7() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCREQ_DCREQ7(value uint32) {
	volatile.StoreUint32(&o.CREQ.Reg, volatile.LoadUint32(&o.CREQ.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCREQ_DCREQ7() uint32 {
	return (volatile.LoadUint32(&o.CREQ.Reg) & 0x8000) >> 15
}

// DMAC.LAST: DMAC Software Last Transfer Flag Register
func (o *DMAC_Type) SetLAST_SLAST0(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetLAST_SLAST0() uint32 {
	return volatile.LoadUint32(&o.LAST.Reg) & 0x1
}
func (o *DMAC_Type) SetLAST_DLAST0(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetLAST_DLAST0() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetLAST_SLAST1(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetLAST_SLAST1() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetLAST_DLAST1(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetLAST_DLAST1() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetLAST_SLAST2(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetLAST_SLAST2() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetLAST_DLAST2(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetLAST_DLAST2() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetLAST_SLAST3(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetLAST_SLAST3() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetLAST_DLAST3(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetLAST_DLAST3() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetLAST_SLAST4(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetLAST_SLAST4() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetLAST_DLAST4(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetLAST_DLAST4() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetLAST_SLAST5(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetLAST_SLAST5() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetLAST_DLAST5(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetLAST_DLAST5() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetLAST_SLAST6(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetLAST_SLAST6() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetLAST_DLAST6(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetLAST_DLAST6() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetLAST_SLAST7(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetLAST_SLAST7() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetLAST_DLAST7(value uint32) {
	volatile.StoreUint32(&o.LAST.Reg, volatile.LoadUint32(&o.LAST.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetLAST_DLAST7() uint32 {
	return (volatile.LoadUint32(&o.LAST.Reg) & 0x8000) >> 15
}

// DMAC.EBCIER: DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Enable register.
func (o *DMAC_Type) SetEBCIER_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIER_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIER.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIER_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIER_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIER_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIER_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIER_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIER_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIER_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIER_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIER_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIER_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIER_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCIER_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCIER_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCIER_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCIER_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIER_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIER_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIER_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIER_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIER_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIER_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIER_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIER_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIER_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIER_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIER_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIER_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCIER_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCIER_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCIER_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCIER_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIER_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIER_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIER_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIER_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIER_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIER_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIER_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIER_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIER_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIER_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIER_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCIER_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCIER_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCIER_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIER.Reg, volatile.LoadUint32(&o.EBCIER.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCIER_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIER.Reg) & 0x800000) >> 23
}

// DMAC.EBCIDR: DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Interrupt Disable register.
func (o *DMAC_Type) SetEBCIDR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIDR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIDR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIDR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIDR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIDR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIDR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIDR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIDR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIDR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIDR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIDR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIDR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIDR_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCIDR_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCIDR_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCIDR_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCIDR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIDR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIDR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIDR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIDR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIDR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIDR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIDR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIDR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIDR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIDR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIDR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIDR_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCIDR_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCIDR_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCIDR_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCIDR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIDR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIDR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIDR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIDR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIDR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIDR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIDR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIDR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIDR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIDR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIDR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCIDR_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCIDR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCIDR_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIDR.Reg, volatile.LoadUint32(&o.EBCIDR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCIDR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIDR.Reg) & 0x800000) >> 23
}

// DMAC.EBCIMR: DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Mask Register.
func (o *DMAC_Type) SetEBCIMR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCIMR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCIMR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCIMR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCIMR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCIMR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCIMR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCIMR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCIMR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCIMR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCIMR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCIMR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCIMR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCIMR_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCIMR_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCIMR_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCIMR_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCIMR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCIMR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCIMR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCIMR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCIMR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCIMR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCIMR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCIMR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCIMR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCIMR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCIMR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCIMR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCIMR_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCIMR_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCIMR_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCIMR_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCIMR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCIMR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCIMR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCIMR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCIMR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCIMR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCIMR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCIMR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCIMR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCIMR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCIMR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCIMR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCIMR_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCIMR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCIMR_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCIMR.Reg, volatile.LoadUint32(&o.EBCIMR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCIMR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCIMR.Reg) & 0x800000) >> 23
}

// DMAC.EBCISR: DMAC Error, Chained Buffer transfer completed and Buffer transfer completed Status Register.
func (o *DMAC_Type) SetEBCISR_BTC0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetEBCISR_BTC0() uint32 {
	return volatile.LoadUint32(&o.EBCISR.Reg) & 0x1
}
func (o *DMAC_Type) SetEBCISR_BTC1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetEBCISR_BTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetEBCISR_BTC2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetEBCISR_BTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetEBCISR_BTC3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetEBCISR_BTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetEBCISR_BTC4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetEBCISR_BTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetEBCISR_BTC5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetEBCISR_BTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetEBCISR_BTC6(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetEBCISR_BTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetEBCISR_BTC7(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetEBCISR_BTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetEBCISR_CBTC0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetEBCISR_CBTC0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetEBCISR_CBTC1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetEBCISR_CBTC1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetEBCISR_CBTC2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetEBCISR_CBTC2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetEBCISR_CBTC3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetEBCISR_CBTC3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetEBCISR_CBTC4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetEBCISR_CBTC4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetEBCISR_CBTC5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetEBCISR_CBTC5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetEBCISR_CBTC6(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetEBCISR_CBTC6() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetEBCISR_CBTC7(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetEBCISR_CBTC7() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetEBCISR_ERR0(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetEBCISR_ERR0() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetEBCISR_ERR1(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetEBCISR_ERR1() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetEBCISR_ERR2(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetEBCISR_ERR2() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetEBCISR_ERR3(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetEBCISR_ERR3() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetEBCISR_ERR4(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetEBCISR_ERR4() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetEBCISR_ERR5(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetEBCISR_ERR5() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetEBCISR_ERR6(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetEBCISR_ERR6() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetEBCISR_ERR7(value uint32) {
	volatile.StoreUint32(&o.EBCISR.Reg, volatile.LoadUint32(&o.EBCISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetEBCISR_ERR7() uint32 {
	return (volatile.LoadUint32(&o.EBCISR.Reg) & 0x800000) >> 23
}

// DMAC.CHER: DMAC Channel Handler Enable Register
func (o *DMAC_Type) SetCHER_ENA0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHER_ENA0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *DMAC_Type) SetCHER_ENA1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHER_ENA1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHER_ENA2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHER_ENA2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHER_ENA3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHER_ENA3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHER_ENA4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHER_ENA4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHER_ENA5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHER_ENA5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHER_ENA6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHER_ENA6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCHER_ENA7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCHER_ENA7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCHER_SUSP0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHER_SUSP0() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHER_SUSP1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHER_SUSP1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHER_SUSP2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHER_SUSP2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHER_SUSP3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHER_SUSP3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHER_SUSP4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHER_SUSP4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHER_SUSP5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHER_SUSP5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHER_SUSP6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCHER_SUSP6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCHER_SUSP7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCHER_SUSP7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetCHER_KEEP0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHER_KEEP0() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHER_KEEP1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetCHER_KEEP1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetCHER_KEEP2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetCHER_KEEP2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetCHER_KEEP3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetCHER_KEEP3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetCHER_KEEP4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetCHER_KEEP4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetCHER_KEEP5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetCHER_KEEP5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20000000) >> 29
}
func (o *DMAC_Type) SetCHER_KEEP6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCHER_KEEP6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCHER_KEEP7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCHER_KEEP7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80000000) >> 31
}

// DMAC.CHDR: DMAC Channel Handler Disable Register
func (o *DMAC_Type) SetCHDR_DIS0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHDR_DIS0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHDR_DIS1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHDR_DIS1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHDR_DIS2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHDR_DIS2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHDR_DIS3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHDR_DIS3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHDR_DIS4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHDR_DIS4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHDR_DIS5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHDR_DIS5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHDR_DIS6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHDR_DIS6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCHDR_DIS7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCHDR_DIS7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCHDR_RES0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHDR_RES0() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHDR_RES1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHDR_RES1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHDR_RES2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHDR_RES2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHDR_RES3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHDR_RES3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHDR_RES4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHDR_RES4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHDR_RES5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHDR_RES5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHDR_RES6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCHDR_RES6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCHDR_RES7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCHDR_RES7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8000) >> 15
}

// DMAC.CHSR: DMAC Channel Handler Status Register
func (o *DMAC_Type) SetCHSR_ENA0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHSR_ENA0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHSR_ENA1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHSR_ENA1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHSR_ENA2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHSR_ENA2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCHSR_ENA3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHSR_ENA3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHSR_ENA4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHSR_ENA4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHSR_ENA5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetCHSR_ENA5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetCHSR_ENA6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHSR_ENA6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetCHSR_ENA7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetCHSR_ENA7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetCHSR_SUSP0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCHSR_SUSP0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCHSR_SUSP1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCHSR_SUSP1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCHSR_SUSP2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCHSR_SUSP2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCHSR_SUSP3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCHSR_SUSP3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetCHSR_SUSP4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCHSR_SUSP4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCHSR_SUSP5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCHSR_SUSP5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCHSR_SUSP6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetCHSR_SUSP6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetCHSR_SUSP7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetCHSR_SUSP7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetCHSR_EMPT0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCHSR_EMPT0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCHSR_EMPT1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20000)|value<<17)
}
func (o *DMAC_Type) GetCHSR_EMPT1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20000) >> 17
}
func (o *DMAC_Type) SetCHSR_EMPT2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40000)|value<<18)
}
func (o *DMAC_Type) GetCHSR_EMPT2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40000) >> 18
}
func (o *DMAC_Type) SetCHSR_EMPT3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80000)|value<<19)
}
func (o *DMAC_Type) GetCHSR_EMPT3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80000) >> 19
}
func (o *DMAC_Type) SetCHSR_EMPT4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCHSR_EMPT4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCHSR_EMPT5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCHSR_EMPT5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCHSR_EMPT6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCHSR_EMPT6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCHSR_EMPT7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetCHSR_EMPT7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800000) >> 23
}
func (o *DMAC_Type) SetCHSR_STAL0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMAC_Type) GetCHSR_STAL0() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000000) >> 24
}
func (o *DMAC_Type) SetCHSR_STAL1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMAC_Type) GetCHSR_STAL1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000000) >> 25
}
func (o *DMAC_Type) SetCHSR_STAL2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMAC_Type) GetCHSR_STAL2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000000) >> 26
}
func (o *DMAC_Type) SetCHSR_STAL3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMAC_Type) GetCHSR_STAL3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000000) >> 27
}
func (o *DMAC_Type) SetCHSR_STAL4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10000000)|value<<28)
}
func (o *DMAC_Type) GetCHSR_STAL4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10000000) >> 28
}
func (o *DMAC_Type) SetCHSR_STAL5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20000000)|value<<29)
}
func (o *DMAC_Type) GetCHSR_STAL5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20000000) >> 29
}
func (o *DMAC_Type) SetCHSR_STAL6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCHSR_STAL6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCHSR_STAL7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCHSR_STAL7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80000000) >> 31
}

// DMAC.SADDR0: DMAC Channel Source Address Register (ch_num = 0)
func (o *DMAC_Type) SetSADDR0(value uint32) {
	volatile.StoreUint32(&o.SADDR0.Reg, value)
}
func (o *DMAC_Type) GetSADDR0() uint32 {
	return volatile.LoadUint32(&o.SADDR0.Reg)
}

// DMAC.DADDR0: DMAC Channel Destination Address Register (ch_num = 0)
func (o *DMAC_Type) SetDADDR0(value uint32) {
	volatile.StoreUint32(&o.DADDR0.Reg, value)
}
func (o *DMAC_Type) GetDADDR0() uint32 {
	return volatile.LoadUint32(&o.DADDR0.Reg)
}

// DMAC.DSCR0: DMAC Channel Descriptor Address Register (ch_num = 0)
func (o *DMAC_Type) SetDSCR0_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR0.Reg, volatile.LoadUint32(&o.DSCR0.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR0_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR0.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR0_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR0.Reg, volatile.LoadUint32(&o.DSCR0.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR0_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR0.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA0: DMAC Channel Control A Register (ch_num = 0)
func (o *DMAC_Type) SetCTRLA0_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA0_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA0.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA0_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA0_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA0_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA0_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA0_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA0_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA0_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA0_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA0_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA0.Reg, volatile.LoadUint32(&o.CTRLA0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA0_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA0.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB0: DMAC Channel Control B Register (ch_num = 0)
func (o *DMAC_Type) SetCTRLB0_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB0_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB0.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB0_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB0_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB0_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB0_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB0_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB0_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB0_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB0_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB0_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB0_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB0_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB0_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB0_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB0_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB0_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB0.Reg, volatile.LoadUint32(&o.CTRLB0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB0_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB0.Reg) & 0x80000000) >> 31
}

// DMAC.CFG0: DMAC Channel Configuration Register (ch_num = 0)
func (o *DMAC_Type) SetCFG0_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG0_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG0.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG0_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG0_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG0_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG0_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG0_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG0_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG0_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG0_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG0_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG0_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG0_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG0_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG0_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG0_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG0_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG0_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG0_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG0_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG0_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG0_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG0_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG0.Reg, volatile.LoadUint32(&o.CFG0.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG0_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG0.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR1: DMAC Channel Source Address Register (ch_num = 1)
func (o *DMAC_Type) SetSADDR1(value uint32) {
	volatile.StoreUint32(&o.SADDR1.Reg, value)
}
func (o *DMAC_Type) GetSADDR1() uint32 {
	return volatile.LoadUint32(&o.SADDR1.Reg)
}

// DMAC.DADDR1: DMAC Channel Destination Address Register (ch_num = 1)
func (o *DMAC_Type) SetDADDR1(value uint32) {
	volatile.StoreUint32(&o.DADDR1.Reg, value)
}
func (o *DMAC_Type) GetDADDR1() uint32 {
	return volatile.LoadUint32(&o.DADDR1.Reg)
}

// DMAC.DSCR1: DMAC Channel Descriptor Address Register (ch_num = 1)
func (o *DMAC_Type) SetDSCR1_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR1.Reg, volatile.LoadUint32(&o.DSCR1.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR1_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR1.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR1_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR1.Reg, volatile.LoadUint32(&o.DSCR1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR1_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR1.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA1: DMAC Channel Control A Register (ch_num = 1)
func (o *DMAC_Type) SetCTRLA1_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA1_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA1.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA1_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA1_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA1_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA1_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA1_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA1_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA1_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA1_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA1_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA1.Reg, volatile.LoadUint32(&o.CTRLA1.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA1_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA1.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB1: DMAC Channel Control B Register (ch_num = 1)
func (o *DMAC_Type) SetCTRLB1_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB1_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB1.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB1_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB1_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB1_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB1_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB1_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB1_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB1_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB1_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB1_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB1_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB1_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB1_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB1_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB1_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB1_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB1.Reg, volatile.LoadUint32(&o.CTRLB1.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB1_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB1.Reg) & 0x80000000) >> 31
}

// DMAC.CFG1: DMAC Channel Configuration Register (ch_num = 1)
func (o *DMAC_Type) SetCFG1_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG1_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG1.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG1_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG1_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG1_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG1_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG1_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG1_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG1_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG1_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG1_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG1_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG1_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG1_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG1_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG1_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG1_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG1_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG1_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG1_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG1_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG1_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG1_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG1.Reg, volatile.LoadUint32(&o.CFG1.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG1_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG1.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR2: DMAC Channel Source Address Register (ch_num = 2)
func (o *DMAC_Type) SetSADDR2(value uint32) {
	volatile.StoreUint32(&o.SADDR2.Reg, value)
}
func (o *DMAC_Type) GetSADDR2() uint32 {
	return volatile.LoadUint32(&o.SADDR2.Reg)
}

// DMAC.DADDR2: DMAC Channel Destination Address Register (ch_num = 2)
func (o *DMAC_Type) SetDADDR2(value uint32) {
	volatile.StoreUint32(&o.DADDR2.Reg, value)
}
func (o *DMAC_Type) GetDADDR2() uint32 {
	return volatile.LoadUint32(&o.DADDR2.Reg)
}

// DMAC.DSCR2: DMAC Channel Descriptor Address Register (ch_num = 2)
func (o *DMAC_Type) SetDSCR2_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR2.Reg, volatile.LoadUint32(&o.DSCR2.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR2_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR2.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR2_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR2.Reg, volatile.LoadUint32(&o.DSCR2.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR2_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR2.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA2: DMAC Channel Control A Register (ch_num = 2)
func (o *DMAC_Type) SetCTRLA2_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA2_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA2.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA2_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA2_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA2_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA2_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA2_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA2_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA2_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA2_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA2_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA2.Reg, volatile.LoadUint32(&o.CTRLA2.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA2_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA2.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB2: DMAC Channel Control B Register (ch_num = 2)
func (o *DMAC_Type) SetCTRLB2_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB2_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB2.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB2_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB2_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB2_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB2_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB2_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB2_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB2_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB2_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB2_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB2_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB2_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB2_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB2_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB2_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB2_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB2.Reg, volatile.LoadUint32(&o.CTRLB2.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB2_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB2.Reg) & 0x80000000) >> 31
}

// DMAC.CFG2: DMAC Channel Configuration Register (ch_num = 2)
func (o *DMAC_Type) SetCFG2_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG2_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG2.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG2_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG2_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG2_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG2_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG2_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG2_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG2_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG2_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG2_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG2_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG2_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG2_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG2_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG2_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG2_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG2_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG2_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG2_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG2_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG2_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG2_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG2.Reg, volatile.LoadUint32(&o.CFG2.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG2_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG2.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR3: DMAC Channel Source Address Register (ch_num = 3)
func (o *DMAC_Type) SetSADDR3(value uint32) {
	volatile.StoreUint32(&o.SADDR3.Reg, value)
}
func (o *DMAC_Type) GetSADDR3() uint32 {
	return volatile.LoadUint32(&o.SADDR3.Reg)
}

// DMAC.DADDR3: DMAC Channel Destination Address Register (ch_num = 3)
func (o *DMAC_Type) SetDADDR3(value uint32) {
	volatile.StoreUint32(&o.DADDR3.Reg, value)
}
func (o *DMAC_Type) GetDADDR3() uint32 {
	return volatile.LoadUint32(&o.DADDR3.Reg)
}

// DMAC.DSCR3: DMAC Channel Descriptor Address Register (ch_num = 3)
func (o *DMAC_Type) SetDSCR3_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR3.Reg, volatile.LoadUint32(&o.DSCR3.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR3_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR3.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR3_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR3.Reg, volatile.LoadUint32(&o.DSCR3.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR3_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR3.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA3: DMAC Channel Control A Register (ch_num = 3)
func (o *DMAC_Type) SetCTRLA3_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA3_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA3.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA3_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA3_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA3_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA3_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA3_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA3_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA3_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA3_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA3_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA3.Reg, volatile.LoadUint32(&o.CTRLA3.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA3_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA3.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB3: DMAC Channel Control B Register (ch_num = 3)
func (o *DMAC_Type) SetCTRLB3_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB3_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB3.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB3_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB3_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB3_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB3_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB3_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB3_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB3_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB3_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB3_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB3_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB3_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB3_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB3_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB3_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB3_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB3.Reg, volatile.LoadUint32(&o.CTRLB3.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB3_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB3.Reg) & 0x80000000) >> 31
}

// DMAC.CFG3: DMAC Channel Configuration Register (ch_num = 3)
func (o *DMAC_Type) SetCFG3_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG3_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG3.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG3_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG3_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG3_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG3_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG3_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG3_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG3_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG3_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG3_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG3_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG3_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG3_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG3_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG3_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG3_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG3_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG3_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG3_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG3_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG3_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG3_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG3.Reg, volatile.LoadUint32(&o.CFG3.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG3_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG3.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR4: DMAC Channel Source Address Register (ch_num = 4)
func (o *DMAC_Type) SetSADDR4(value uint32) {
	volatile.StoreUint32(&o.SADDR4.Reg, value)
}
func (o *DMAC_Type) GetSADDR4() uint32 {
	return volatile.LoadUint32(&o.SADDR4.Reg)
}

// DMAC.DADDR4: DMAC Channel Destination Address Register (ch_num = 4)
func (o *DMAC_Type) SetDADDR4(value uint32) {
	volatile.StoreUint32(&o.DADDR4.Reg, value)
}
func (o *DMAC_Type) GetDADDR4() uint32 {
	return volatile.LoadUint32(&o.DADDR4.Reg)
}

// DMAC.DSCR4: DMAC Channel Descriptor Address Register (ch_num = 4)
func (o *DMAC_Type) SetDSCR4_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR4.Reg, volatile.LoadUint32(&o.DSCR4.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR4_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR4.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR4_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR4.Reg, volatile.LoadUint32(&o.DSCR4.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR4_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR4.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA4: DMAC Channel Control A Register (ch_num = 4)
func (o *DMAC_Type) SetCTRLA4_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA4_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA4.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA4_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA4_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA4_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA4_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA4_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA4_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA4_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA4_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA4_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA4.Reg, volatile.LoadUint32(&o.CTRLA4.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA4_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA4.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB4: DMAC Channel Control B Register (ch_num = 4)
func (o *DMAC_Type) SetCTRLB4_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB4_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB4.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB4_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB4_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB4_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB4_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB4_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB4_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB4_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB4_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB4_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB4_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB4_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB4_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB4_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB4_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB4_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB4.Reg, volatile.LoadUint32(&o.CTRLB4.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB4_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB4.Reg) & 0x80000000) >> 31
}

// DMAC.CFG4: DMAC Channel Configuration Register (ch_num = 4)
func (o *DMAC_Type) SetCFG4_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG4_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG4.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG4_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG4_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG4_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG4_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG4_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG4_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG4_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG4_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG4_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG4_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG4_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG4_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG4_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG4_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG4_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG4_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG4_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG4_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG4_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG4_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG4_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG4.Reg, volatile.LoadUint32(&o.CFG4.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG4_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG4.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR5: DMAC Channel Source Address Register (ch_num = 5)
func (o *DMAC_Type) SetSADDR5(value uint32) {
	volatile.StoreUint32(&o.SADDR5.Reg, value)
}
func (o *DMAC_Type) GetSADDR5() uint32 {
	return volatile.LoadUint32(&o.SADDR5.Reg)
}

// DMAC.DADDR5: DMAC Channel Destination Address Register (ch_num = 5)
func (o *DMAC_Type) SetDADDR5(value uint32) {
	volatile.StoreUint32(&o.DADDR5.Reg, value)
}
func (o *DMAC_Type) GetDADDR5() uint32 {
	return volatile.LoadUint32(&o.DADDR5.Reg)
}

// DMAC.DSCR5: DMAC Channel Descriptor Address Register (ch_num = 5)
func (o *DMAC_Type) SetDSCR5_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR5.Reg, volatile.LoadUint32(&o.DSCR5.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR5_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR5.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR5_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR5.Reg, volatile.LoadUint32(&o.DSCR5.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR5_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR5.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA5: DMAC Channel Control A Register (ch_num = 5)
func (o *DMAC_Type) SetCTRLA5_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA5_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA5.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA5_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA5_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA5_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA5_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA5_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA5_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA5_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA5_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA5_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA5.Reg, volatile.LoadUint32(&o.CTRLA5.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA5_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA5.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB5: DMAC Channel Control B Register (ch_num = 5)
func (o *DMAC_Type) SetCTRLB5_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB5_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB5.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB5_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB5_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB5_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB5_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB5_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB5_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB5_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB5_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB5_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB5_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB5_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB5_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB5_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB5_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB5_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB5.Reg, volatile.LoadUint32(&o.CTRLB5.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB5_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB5.Reg) & 0x80000000) >> 31
}

// DMAC.CFG5: DMAC Channel Configuration Register (ch_num = 5)
func (o *DMAC_Type) SetCFG5_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG5_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG5.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG5_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG5_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG5_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG5_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG5_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG5_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG5_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG5_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG5_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG5_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG5_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG5_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG5_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG5_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG5_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG5_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG5_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG5_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG5_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG5_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG5_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG5.Reg, volatile.LoadUint32(&o.CFG5.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG5_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG5.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR6: DMAC Channel Source Address Register (ch_num = 6)
func (o *DMAC_Type) SetSADDR6(value uint32) {
	volatile.StoreUint32(&o.SADDR6.Reg, value)
}
func (o *DMAC_Type) GetSADDR6() uint32 {
	return volatile.LoadUint32(&o.SADDR6.Reg)
}

// DMAC.DADDR6: DMAC Channel Destination Address Register (ch_num = 6)
func (o *DMAC_Type) SetDADDR6(value uint32) {
	volatile.StoreUint32(&o.DADDR6.Reg, value)
}
func (o *DMAC_Type) GetDADDR6() uint32 {
	return volatile.LoadUint32(&o.DADDR6.Reg)
}

// DMAC.DSCR6: DMAC Channel Descriptor Address Register (ch_num = 6)
func (o *DMAC_Type) SetDSCR6_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR6.Reg, volatile.LoadUint32(&o.DSCR6.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR6_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR6.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR6_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR6.Reg, volatile.LoadUint32(&o.DSCR6.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR6_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR6.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA6: DMAC Channel Control A Register (ch_num = 6)
func (o *DMAC_Type) SetCTRLA6_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA6_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA6.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA6_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA6_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA6_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA6_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA6_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA6_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA6_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA6_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA6_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA6.Reg, volatile.LoadUint32(&o.CTRLA6.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA6_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA6.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB6: DMAC Channel Control B Register (ch_num = 6)
func (o *DMAC_Type) SetCTRLB6_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB6_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB6.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB6_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB6_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB6_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB6_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB6_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB6_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB6_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB6_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB6_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB6_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB6_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB6_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB6_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB6_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB6_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB6.Reg, volatile.LoadUint32(&o.CTRLB6.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB6_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB6.Reg) & 0x80000000) >> 31
}

// DMAC.CFG6: DMAC Channel Configuration Register (ch_num = 6)
func (o *DMAC_Type) SetCFG6_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG6_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG6.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG6_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG6_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG6_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG6_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG6_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG6_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG6_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG6_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG6_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG6_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG6_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG6_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG6_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG6_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG6_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG6_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG6_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG6_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG6_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG6_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG6_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG6.Reg, volatile.LoadUint32(&o.CFG6.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG6_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG6.Reg) & 0x30000000) >> 28
}

// DMAC.SADDR7: DMAC Channel Source Address Register (ch_num = 7)
func (o *DMAC_Type) SetSADDR7(value uint32) {
	volatile.StoreUint32(&o.SADDR7.Reg, value)
}
func (o *DMAC_Type) GetSADDR7() uint32 {
	return volatile.LoadUint32(&o.SADDR7.Reg)
}

// DMAC.DADDR7: DMAC Channel Destination Address Register (ch_num = 7)
func (o *DMAC_Type) SetDADDR7(value uint32) {
	volatile.StoreUint32(&o.DADDR7.Reg, value)
}
func (o *DMAC_Type) GetDADDR7() uint32 {
	return volatile.LoadUint32(&o.DADDR7.Reg)
}

// DMAC.DSCR7: DMAC Channel Descriptor Address Register (ch_num = 7)
func (o *DMAC_Type) SetDSCR7_DSCR_IF(value uint32) {
	volatile.StoreUint32(&o.DSCR7.Reg, volatile.LoadUint32(&o.DSCR7.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetDSCR7_DSCR_IF() uint32 {
	return volatile.LoadUint32(&o.DSCR7.Reg) & 0x3
}
func (o *DMAC_Type) SetDSCR7_DSCR(value uint32) {
	volatile.StoreUint32(&o.DSCR7.Reg, volatile.LoadUint32(&o.DSCR7.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DMAC_Type) GetDSCR7_DSCR() uint32 {
	return (volatile.LoadUint32(&o.DSCR7.Reg) & 0xfffffffc) >> 2
}

// DMAC.CTRLA7: DMAC Channel Control A Register (ch_num = 7)
func (o *DMAC_Type) SetCTRLA7_BTSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0xffff)|value)
}
func (o *DMAC_Type) GetCTRLA7_BTSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLA7.Reg) & 0xffff
}
func (o *DMAC_Type) SetCTRLA7_SCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x70000)|value<<16)
}
func (o *DMAC_Type) GetCTRLA7_SCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x70000) >> 16
}
func (o *DMAC_Type) SetCTRLA7_DCSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x700000)|value<<20)
}
func (o *DMAC_Type) GetCTRLA7_DCSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x700000) >> 20
}
func (o *DMAC_Type) SetCTRLA7_SRC_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLA7_SRC_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLA7_DST_WIDTH(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLA7_DST_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLA7_DONE(value uint32) {
	volatile.StoreUint32(&o.CTRLA7.Reg, volatile.LoadUint32(&o.CTRLA7.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLA7_DONE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA7.Reg) & 0x80000000) >> 31
}

// DMAC.CTRLB7: DMAC Channel Control B Register (ch_num = 7)
func (o *DMAC_Type) SetCTRLB7_SIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCTRLB7_SIF() uint32 {
	return volatile.LoadUint32(&o.CTRLB7.Reg) & 0x3
}
func (o *DMAC_Type) SetCTRLB7_DIF(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetCTRLB7_DIF() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x30) >> 4
}
func (o *DMAC_Type) SetCTRLB7_SRC_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCTRLB7_SRC_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCTRLB7_DST_DSCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCTRLB7_DST_DSCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCTRLB7_FC(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0xe00000)|value<<21)
}
func (o *DMAC_Type) GetCTRLB7_FC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0xe00000) >> 21
}
func (o *DMAC_Type) SetCTRLB7_SRC_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCTRLB7_SRC_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x3000000) >> 24
}
func (o *DMAC_Type) SetCTRLB7_DST_INCR(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCTRLB7_DST_INCR() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x30000000) >> 28
}
func (o *DMAC_Type) SetCTRLB7_IEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x40000000)|value<<30)
}
func (o *DMAC_Type) GetCTRLB7_IEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x40000000) >> 30
}
func (o *DMAC_Type) SetCTRLB7_AUTO(value uint32) {
	volatile.StoreUint32(&o.CTRLB7.Reg, volatile.LoadUint32(&o.CTRLB7.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetCTRLB7_AUTO() uint32 {
	return (volatile.LoadUint32(&o.CTRLB7.Reg) & 0x80000000) >> 31
}

// DMAC.CFG7: DMAC Channel Configuration Register (ch_num = 7)
func (o *DMAC_Type) SetCFG7_SRC_PER(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCFG7_SRC_PER() uint32 {
	return volatile.LoadUint32(&o.CFG7.Reg) & 0xf
}
func (o *DMAC_Type) SetCFG7_DST_PER(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0xf0)|value<<4)
}
func (o *DMAC_Type) GetCFG7_DST_PER() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0xf0) >> 4
}
func (o *DMAC_Type) SetCFG7_SRC_REP(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCFG7_SRC_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCFG7_SRC_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCFG7_SRC_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCFG7_DST_REP(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetCFG7_DST_REP() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetCFG7_DST_H2SEL(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetCFG7_DST_H2SEL() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetCFG7_SOD(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x10000)|value<<16)
}
func (o *DMAC_Type) GetCFG7_SOD() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x10000) >> 16
}
func (o *DMAC_Type) SetCFG7_LOCK_IF(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x100000)|value<<20)
}
func (o *DMAC_Type) GetCFG7_LOCK_IF() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x100000) >> 20
}
func (o *DMAC_Type) SetCFG7_LOCK_B(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x200000)|value<<21)
}
func (o *DMAC_Type) GetCFG7_LOCK_B() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x200000) >> 21
}
func (o *DMAC_Type) SetCFG7_LOCK_IF_L(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x400000)|value<<22)
}
func (o *DMAC_Type) GetCFG7_LOCK_IF_L() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x400000) >> 22
}
func (o *DMAC_Type) SetCFG7_AHB_PROT(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x7000000)|value<<24)
}
func (o *DMAC_Type) GetCFG7_AHB_PROT() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x7000000) >> 24
}
func (o *DMAC_Type) SetCFG7_FIFOCFG(value uint32) {
	volatile.StoreUint32(&o.CFG7.Reg, volatile.LoadUint32(&o.CFG7.Reg)&^(0x30000000)|value<<28)
}
func (o *DMAC_Type) GetCFG7_FIFOCFG() uint32 {
	return (volatile.LoadUint32(&o.CFG7.Reg) & 0x30000000) >> 28
}

// DMAC.WPMR: Write Protect Mode Register
func (o *DMAC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DMAC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DMAC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DMAC.WPSR: Write Protect Status Register
func (o *DMAC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DMAC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *DMAC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// Debug Unit
type DBGU_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [28]byte
	CIDR volatile.Register32 // 0x40
	EXID volatile.Register32 // 0x44
	FNR  volatile.Register32 // 0x48
	_    [180]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// DBGU.CR: Control Register
func (o *DBGU_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBGU_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBGU_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DBGU_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// DBGU.MR: Mode Register
func (o *DBGU_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *DBGU_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *DBGU_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *DBGU_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// DBGU.IER: Interrupt Enable Register
func (o *DBGU_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *DBGU_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *DBGU_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *DBGU_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *DBGU_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *DBGU_Type) SetIER_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIER_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIER_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIER_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// DBGU.IDR: Interrupt Disable Register
func (o *DBGU_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *DBGU_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *DBGU_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *DBGU_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *DBGU_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *DBGU_Type) SetIDR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIDR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIDR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIDR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// DBGU.IMR: Interrupt Mask Register
func (o *DBGU_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *DBGU_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *DBGU_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *DBGU_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *DBGU_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *DBGU_Type) SetIMR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetIMR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetIMR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetIMR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// DBGU.SR: Status Register
func (o *DBGU_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *DBGU_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *DBGU_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *DBGU_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *DBGU_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *DBGU_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *DBGU_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *DBGU_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *DBGU_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *DBGU_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *DBGU_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *DBGU_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *DBGU_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *DBGU_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *DBGU_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *DBGU_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *DBGU_Type) SetSR_COMMTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000000)|value<<30)
}
func (o *DBGU_Type) GetSR_COMMTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000000) >> 30
}
func (o *DBGU_Type) SetSR_COMMRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetSR_COMMRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000000) >> 31
}

// DBGU.RHR: Receive Holding Register
func (o *DBGU_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *DBGU_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// DBGU.THR: Transmit Holding Register
func (o *DBGU_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *DBGU_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// DBGU.BRGR: Baud Rate Generator Register
func (o *DBGU_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// DBGU.CIDR: Chip ID Register
func (o *DBGU_Type) SetCIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x1f)|value)
}
func (o *DBGU_Type) GetCIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CIDR.Reg) & 0x1f
}
func (o *DBGU_Type) SetCIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *DBGU_Type) GetCIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xe0) >> 5
}
func (o *DBGU_Type) SetCIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *DBGU_Type) GetCIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf00) >> 8
}
func (o *DBGU_Type) SetCIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *DBGU_Type) GetCIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf000) >> 12
}
func (o *DBGU_Type) SetCIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *DBGU_Type) GetCIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf0000) >> 16
}
func (o *DBGU_Type) SetCIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *DBGU_Type) GetCIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xff00000) >> 20
}
func (o *DBGU_Type) SetCIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *DBGU_Type) GetCIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x70000000) >> 28
}
func (o *DBGU_Type) SetCIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *DBGU_Type) GetCIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x80000000) >> 31
}

// DBGU.EXID: Chip ID Extension Register
func (o *DBGU_Type) SetEXID(value uint32) {
	volatile.StoreUint32(&o.EXID.Reg, value)
}
func (o *DBGU_Type) GetEXID() uint32 {
	return volatile.LoadUint32(&o.EXID.Reg)
}

// DBGU.FNR: Force NTRST Register
func (o *DBGU_Type) SetFNR_FNTRST(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetFNR_FNTRST() uint32 {
	return volatile.LoadUint32(&o.FNR.Reg) & 0x1
}

// DBGU.RPR: Receive Pointer Register
func (o *DBGU_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *DBGU_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// DBGU.RCR: Receive Counter Register
func (o *DBGU_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// DBGU.TPR: Transmit Pointer Register
func (o *DBGU_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *DBGU_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// DBGU.TCR: Transmit Counter Register
func (o *DBGU_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// DBGU.RNPR: Receive Next Pointer Register
func (o *DBGU_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *DBGU_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// DBGU.RNCR: Receive Next Counter Register
func (o *DBGU_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// DBGU.TNPR: Transmit Next Pointer Register
func (o *DBGU_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *DBGU_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// DBGU.TNCR: Transmit Next Counter Register
func (o *DBGU_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *DBGU_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// DBGU.PTCR: Transfer Control Register
func (o *DBGU_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *DBGU_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *DBGU_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *DBGU_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *DBGU_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *DBGU_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *DBGU_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// DBGU.PTSR: Transfer Status Register
func (o *DBGU_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *DBGU_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *DBGU_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *DBGU_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Advanced Interrupt Controller
type AIC_Type struct {
	SMR   [32]volatile.Register32 // 0x0
	SVR   [32]volatile.Register32 // 0x80
	IVR   volatile.Register32     // 0x100
	FVR   volatile.Register32     // 0x104
	ISR   volatile.Register32     // 0x108
	IPR   volatile.Register32     // 0x10C
	IMR   volatile.Register32     // 0x110
	CISR  volatile.Register32     // 0x114
	_     [8]byte
	IECR  volatile.Register32 // 0x120
	IDCR  volatile.Register32 // 0x124
	ICCR  volatile.Register32 // 0x128
	ISCR  volatile.Register32 // 0x12C
	EOICR volatile.Register32 // 0x130
	SPU   volatile.Register32 // 0x134
	DCR   volatile.Register32 // 0x138
	_     [4]byte
	FFER  volatile.Register32 // 0x140
	FFDR  volatile.Register32 // 0x144
	FFSR  volatile.Register32 // 0x148
}

// AIC.SMR: Source Mode Register
func (o *AIC_Type) SetSMR_PRIOR(idx int, value uint32) {
	volatile.StoreUint32(&o.SMR[idx].Reg, volatile.LoadUint32(&o.SMR[idx].Reg)&^(0x7)|value)
}
func (o *AIC_Type) GetSMR_PRIOR(idx int) uint32 {
	return volatile.LoadUint32(&o.SMR[idx].Reg) & 0x7
}
func (o *AIC_Type) SetSMR_SRCTYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.SMR[idx].Reg, volatile.LoadUint32(&o.SMR[idx].Reg)&^(0x60)|value<<5)
}
func (o *AIC_Type) GetSMR_SRCTYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.SMR[idx].Reg) & 0x60) >> 5
}

// AIC.SVR: Source Vector Register
func (o *AIC_Type) SetSVR(idx int, value uint32) {
	volatile.StoreUint32(&o.SVR[idx].Reg, value)
}
func (o *AIC_Type) GetSVR(idx int) uint32 {
	return volatile.LoadUint32(&o.SVR[idx].Reg)
}

// AIC.IVR: Interrupt Vector Register
func (o *AIC_Type) SetIVR(value uint32) {
	volatile.StoreUint32(&o.IVR.Reg, value)
}
func (o *AIC_Type) GetIVR() uint32 {
	return volatile.LoadUint32(&o.IVR.Reg)
}

// AIC.FVR: FIQ Interrupt Vector Register
func (o *AIC_Type) SetFVR(value uint32) {
	volatile.StoreUint32(&o.FVR.Reg, value)
}
func (o *AIC_Type) GetFVR() uint32 {
	return volatile.LoadUint32(&o.FVR.Reg)
}

// AIC.ISR: Interrupt Status Register
func (o *AIC_Type) SetISR_IRQID(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1f)|value)
}
func (o *AIC_Type) GetISR_IRQID() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1f
}

// AIC.IPR: Interrupt Pending Register
func (o *AIC_Type) SetIPR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIPR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IPR.Reg) & 0x1
}
func (o *AIC_Type) SetIPR_SYS(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIPR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIPR_PID2(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIPR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIPR_PID3(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIPR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIPR_PID4(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIPR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIPR_PID5(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIPR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIPR_PID6(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIPR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIPR_PID7(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIPR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIPR_PID8(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIPR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIPR_PID9(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIPR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIPR_PID10(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIPR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIPR_PID11(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIPR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIPR_PID12(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIPR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIPR_PID13(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIPR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIPR_PID14(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIPR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIPR_PID15(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIPR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIPR_PID16(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIPR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIPR_PID17(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIPR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIPR_PID18(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIPR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIPR_PID19(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIPR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIPR_PID20(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIPR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIPR_PID21(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIPR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIPR_PID22(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIPR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIPR_PID23(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIPR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIPR_PID24(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIPR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIPR_PID25(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIPR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIPR_PID26(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIPR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIPR_PID27(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIPR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIPR_PID28(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIPR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIPR_PID29(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIPR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIPR_PID30(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIPR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIPR_PID31(value uint32) {
	volatile.StoreUint32(&o.IPR.Reg, volatile.LoadUint32(&o.IPR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIPR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IPR.Reg) & 0x80000000) >> 31
}

// AIC.IMR: Interrupt Mask Register
func (o *AIC_Type) SetIMR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIMR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *AIC_Type) SetIMR_SYS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIMR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIMR_PID2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIMR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIMR_PID3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIMR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIMR_PID4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIMR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIMR_PID5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIMR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIMR_PID6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIMR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIMR_PID7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIMR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIMR_PID8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIMR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIMR_PID9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIMR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIMR_PID10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIMR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIMR_PID11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIMR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIMR_PID12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIMR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIMR_PID13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIMR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIMR_PID14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIMR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIMR_PID15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIMR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIMR_PID16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIMR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIMR_PID17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIMR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIMR_PID18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIMR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIMR_PID19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIMR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIMR_PID20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIMR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIMR_PID21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIMR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIMR_PID22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIMR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIMR_PID23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIMR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIMR_PID24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIMR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIMR_PID25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIMR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIMR_PID26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIMR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIMR_PID27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIMR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIMR_PID28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIMR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIMR_PID29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIMR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIMR_PID30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIMR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIMR_PID31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIMR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// AIC.CISR: Core Interrupt Status Register
func (o *AIC_Type) SetCISR_NFIQ(value uint32) {
	volatile.StoreUint32(&o.CISR.Reg, volatile.LoadUint32(&o.CISR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetCISR_NFIQ() uint32 {
	return volatile.LoadUint32(&o.CISR.Reg) & 0x1
}
func (o *AIC_Type) SetCISR_NIRQ(value uint32) {
	volatile.StoreUint32(&o.CISR.Reg, volatile.LoadUint32(&o.CISR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetCISR_NIRQ() uint32 {
	return (volatile.LoadUint32(&o.CISR.Reg) & 0x2) >> 1
}

// AIC.IECR: Interrupt Enable Command Register
func (o *AIC_Type) SetIECR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIECR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IECR.Reg) & 0x1
}
func (o *AIC_Type) SetIECR_SYS(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIECR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIECR_PID2(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIECR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIECR_PID3(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIECR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIECR_PID4(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIECR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIECR_PID5(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIECR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIECR_PID6(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIECR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIECR_PID7(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIECR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIECR_PID8(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIECR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIECR_PID9(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIECR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIECR_PID10(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIECR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIECR_PID11(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIECR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIECR_PID12(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIECR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIECR_PID13(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIECR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIECR_PID14(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIECR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIECR_PID15(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIECR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIECR_PID16(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIECR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIECR_PID17(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIECR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIECR_PID18(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIECR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIECR_PID19(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIECR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIECR_PID20(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIECR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIECR_PID21(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIECR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIECR_PID22(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIECR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIECR_PID23(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIECR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIECR_PID24(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIECR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIECR_PID25(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIECR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIECR_PID26(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIECR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIECR_PID27(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIECR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIECR_PID28(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIECR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIECR_PID29(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIECR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIECR_PID30(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIECR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIECR_PID31(value uint32) {
	volatile.StoreUint32(&o.IECR.Reg, volatile.LoadUint32(&o.IECR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIECR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IECR.Reg) & 0x80000000) >> 31
}

// AIC.IDCR: Interrupt Disable Command Register
func (o *AIC_Type) SetIDCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetIDCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.IDCR.Reg) & 0x1
}
func (o *AIC_Type) SetIDCR_SYS(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetIDCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetIDCR_PID2(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetIDCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetIDCR_PID3(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetIDCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetIDCR_PID4(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetIDCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetIDCR_PID5(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetIDCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetIDCR_PID6(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetIDCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetIDCR_PID7(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetIDCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetIDCR_PID8(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetIDCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetIDCR_PID9(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetIDCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetIDCR_PID10(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetIDCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetIDCR_PID11(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetIDCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetIDCR_PID12(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetIDCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetIDCR_PID13(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetIDCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetIDCR_PID14(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetIDCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetIDCR_PID15(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetIDCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetIDCR_PID16(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetIDCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetIDCR_PID17(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetIDCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetIDCR_PID18(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetIDCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetIDCR_PID19(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetIDCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetIDCR_PID20(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetIDCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetIDCR_PID21(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetIDCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetIDCR_PID22(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetIDCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetIDCR_PID23(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetIDCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetIDCR_PID24(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetIDCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetIDCR_PID25(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetIDCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetIDCR_PID26(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetIDCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetIDCR_PID27(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetIDCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetIDCR_PID28(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetIDCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetIDCR_PID29(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetIDCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetIDCR_PID30(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetIDCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetIDCR_PID31(value uint32) {
	volatile.StoreUint32(&o.IDCR.Reg, volatile.LoadUint32(&o.IDCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetIDCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.IDCR.Reg) & 0x80000000) >> 31
}

// AIC.ICCR: Interrupt Clear Command Register
func (o *AIC_Type) SetICCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetICCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.ICCR.Reg) & 0x1
}
func (o *AIC_Type) SetICCR_SYS(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetICCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetICCR_PID2(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetICCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetICCR_PID3(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetICCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetICCR_PID4(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetICCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetICCR_PID5(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetICCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetICCR_PID6(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetICCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetICCR_PID7(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetICCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetICCR_PID8(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetICCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetICCR_PID9(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetICCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetICCR_PID10(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetICCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetICCR_PID11(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetICCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetICCR_PID12(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetICCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetICCR_PID13(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetICCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetICCR_PID14(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetICCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetICCR_PID15(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetICCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetICCR_PID16(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetICCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetICCR_PID17(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetICCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetICCR_PID18(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetICCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetICCR_PID19(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetICCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetICCR_PID20(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetICCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetICCR_PID21(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetICCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetICCR_PID22(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetICCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetICCR_PID23(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetICCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetICCR_PID24(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetICCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetICCR_PID25(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetICCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetICCR_PID26(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetICCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetICCR_PID27(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetICCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetICCR_PID28(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetICCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetICCR_PID29(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetICCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetICCR_PID30(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetICCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetICCR_PID31(value uint32) {
	volatile.StoreUint32(&o.ICCR.Reg, volatile.LoadUint32(&o.ICCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetICCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.ICCR.Reg) & 0x80000000) >> 31
}

// AIC.ISCR: Interrupt Set Command Register
func (o *AIC_Type) SetISCR_FIQ(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetISCR_FIQ() uint32 {
	return volatile.LoadUint32(&o.ISCR.Reg) & 0x1
}
func (o *AIC_Type) SetISCR_SYS(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetISCR_SYS() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetISCR_PID2(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetISCR_PID2() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetISCR_PID3(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetISCR_PID3() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetISCR_PID4(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetISCR_PID4() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetISCR_PID5(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetISCR_PID5() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetISCR_PID6(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetISCR_PID6() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetISCR_PID7(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetISCR_PID7() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetISCR_PID8(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetISCR_PID8() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetISCR_PID9(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetISCR_PID9() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetISCR_PID10(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetISCR_PID10() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetISCR_PID11(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetISCR_PID11() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetISCR_PID12(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetISCR_PID12() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetISCR_PID13(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetISCR_PID13() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetISCR_PID14(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetISCR_PID14() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetISCR_PID15(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetISCR_PID15() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetISCR_PID16(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetISCR_PID16() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetISCR_PID17(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetISCR_PID17() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetISCR_PID18(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetISCR_PID18() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetISCR_PID19(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetISCR_PID19() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetISCR_PID20(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetISCR_PID20() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetISCR_PID21(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetISCR_PID21() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetISCR_PID22(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetISCR_PID22() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetISCR_PID23(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetISCR_PID23() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetISCR_PID24(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetISCR_PID24() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetISCR_PID25(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetISCR_PID25() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetISCR_PID26(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetISCR_PID26() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetISCR_PID27(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetISCR_PID27() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetISCR_PID28(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetISCR_PID28() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetISCR_PID29(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetISCR_PID29() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetISCR_PID30(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetISCR_PID30() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetISCR_PID31(value uint32) {
	volatile.StoreUint32(&o.ISCR.Reg, volatile.LoadUint32(&o.ISCR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetISCR_PID31() uint32 {
	return (volatile.LoadUint32(&o.ISCR.Reg) & 0x80000000) >> 31
}

// AIC.SPU: Spurious Interrupt Vector Register
func (o *AIC_Type) SetSPU(value uint32) {
	volatile.StoreUint32(&o.SPU.Reg, value)
}
func (o *AIC_Type) GetSPU() uint32 {
	return volatile.LoadUint32(&o.SPU.Reg)
}

// AIC.DCR: Debug Control Register
func (o *AIC_Type) SetDCR_PROT(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1)|value)
}
func (o *AIC_Type) GetDCR_PROT() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1
}
func (o *AIC_Type) SetDCR_GMSK(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetDCR_GMSK() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x2) >> 1
}

// AIC.FFER: Fast Forcing Enable Register
func (o *AIC_Type) SetFFER_SYS(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFER_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFER_PID2(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFER_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFER_PID3(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFER_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFER_PID4(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFER_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFER_PID5(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFER_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFER_PID6(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFER_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFER_PID7(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFER_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFER_PID8(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFER_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFER_PID9(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFER_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFER_PID10(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFER_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFER_PID11(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFER_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFER_PID12(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFER_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFER_PID13(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFER_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFER_PID14(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFER_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFER_PID15(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFER_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFER_PID16(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFER_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFER_PID17(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFER_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFER_PID18(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFER_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFER_PID19(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFER_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFER_PID20(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFER_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFER_PID21(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFER_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFER_PID22(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFER_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFER_PID23(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFER_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFER_PID24(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFER_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFER_PID25(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFER_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFER_PID26(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFER_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFER_PID27(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFER_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFER_PID28(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFER_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFER_PID29(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFER_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFER_PID30(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFER_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFER_PID31(value uint32) {
	volatile.StoreUint32(&o.FFER.Reg, volatile.LoadUint32(&o.FFER.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFER_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFER.Reg) & 0x80000000) >> 31
}

// AIC.FFDR: Fast Forcing Disable Register
func (o *AIC_Type) SetFFDR_SYS(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFDR_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFDR_PID2(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFDR_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFDR_PID3(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFDR_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFDR_PID4(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFDR_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFDR_PID5(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFDR_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFDR_PID6(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFDR_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFDR_PID7(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFDR_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFDR_PID8(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFDR_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFDR_PID9(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFDR_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFDR_PID10(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFDR_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFDR_PID11(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFDR_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFDR_PID12(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFDR_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFDR_PID13(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFDR_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFDR_PID14(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFDR_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFDR_PID15(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFDR_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFDR_PID16(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFDR_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFDR_PID17(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFDR_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFDR_PID18(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFDR_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFDR_PID19(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFDR_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFDR_PID20(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFDR_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFDR_PID21(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFDR_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFDR_PID22(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFDR_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFDR_PID23(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFDR_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFDR_PID24(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFDR_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFDR_PID25(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFDR_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFDR_PID26(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFDR_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFDR_PID27(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFDR_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFDR_PID28(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFDR_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFDR_PID29(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFDR_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFDR_PID30(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFDR_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFDR_PID31(value uint32) {
	volatile.StoreUint32(&o.FFDR.Reg, volatile.LoadUint32(&o.FFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFDR_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFDR.Reg) & 0x80000000) >> 31
}

// AIC.FFSR: Fast Forcing Status Register
func (o *AIC_Type) SetFFSR_SYS(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2)|value<<1)
}
func (o *AIC_Type) GetFFSR_SYS() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2) >> 1
}
func (o *AIC_Type) SetFFSR_PID2(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4)|value<<2)
}
func (o *AIC_Type) GetFFSR_PID2() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4) >> 2
}
func (o *AIC_Type) SetFFSR_PID3(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8)|value<<3)
}
func (o *AIC_Type) GetFFSR_PID3() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8) >> 3
}
func (o *AIC_Type) SetFFSR_PID4(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10)|value<<4)
}
func (o *AIC_Type) GetFFSR_PID4() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10) >> 4
}
func (o *AIC_Type) SetFFSR_PID5(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20)|value<<5)
}
func (o *AIC_Type) GetFFSR_PID5() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20) >> 5
}
func (o *AIC_Type) SetFFSR_PID6(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40)|value<<6)
}
func (o *AIC_Type) GetFFSR_PID6() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40) >> 6
}
func (o *AIC_Type) SetFFSR_PID7(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80)|value<<7)
}
func (o *AIC_Type) GetFFSR_PID7() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80) >> 7
}
func (o *AIC_Type) SetFFSR_PID8(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x100)|value<<8)
}
func (o *AIC_Type) GetFFSR_PID8() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x100) >> 8
}
func (o *AIC_Type) SetFFSR_PID9(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x200)|value<<9)
}
func (o *AIC_Type) GetFFSR_PID9() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x200) >> 9
}
func (o *AIC_Type) SetFFSR_PID10(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x400)|value<<10)
}
func (o *AIC_Type) GetFFSR_PID10() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x400) >> 10
}
func (o *AIC_Type) SetFFSR_PID11(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x800)|value<<11)
}
func (o *AIC_Type) GetFFSR_PID11() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x800) >> 11
}
func (o *AIC_Type) SetFFSR_PID12(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x1000)|value<<12)
}
func (o *AIC_Type) GetFFSR_PID12() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x1000) >> 12
}
func (o *AIC_Type) SetFFSR_PID13(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2000)|value<<13)
}
func (o *AIC_Type) GetFFSR_PID13() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2000) >> 13
}
func (o *AIC_Type) SetFFSR_PID14(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4000)|value<<14)
}
func (o *AIC_Type) GetFFSR_PID14() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4000) >> 14
}
func (o *AIC_Type) SetFFSR_PID15(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8000)|value<<15)
}
func (o *AIC_Type) GetFFSR_PID15() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8000) >> 15
}
func (o *AIC_Type) SetFFSR_PID16(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10000)|value<<16)
}
func (o *AIC_Type) GetFFSR_PID16() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10000) >> 16
}
func (o *AIC_Type) SetFFSR_PID17(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20000)|value<<17)
}
func (o *AIC_Type) GetFFSR_PID17() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20000) >> 17
}
func (o *AIC_Type) SetFFSR_PID18(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40000)|value<<18)
}
func (o *AIC_Type) GetFFSR_PID18() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40000) >> 18
}
func (o *AIC_Type) SetFFSR_PID19(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80000)|value<<19)
}
func (o *AIC_Type) GetFFSR_PID19() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80000) >> 19
}
func (o *AIC_Type) SetFFSR_PID20(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x100000)|value<<20)
}
func (o *AIC_Type) GetFFSR_PID20() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x100000) >> 20
}
func (o *AIC_Type) SetFFSR_PID21(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x200000)|value<<21)
}
func (o *AIC_Type) GetFFSR_PID21() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x200000) >> 21
}
func (o *AIC_Type) SetFFSR_PID22(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x400000)|value<<22)
}
func (o *AIC_Type) GetFFSR_PID22() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x400000) >> 22
}
func (o *AIC_Type) SetFFSR_PID23(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x800000)|value<<23)
}
func (o *AIC_Type) GetFFSR_PID23() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x800000) >> 23
}
func (o *AIC_Type) SetFFSR_PID24(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *AIC_Type) GetFFSR_PID24() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x1000000) >> 24
}
func (o *AIC_Type) SetFFSR_PID25(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *AIC_Type) GetFFSR_PID25() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x2000000) >> 25
}
func (o *AIC_Type) SetFFSR_PID26(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *AIC_Type) GetFFSR_PID26() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x4000000) >> 26
}
func (o *AIC_Type) SetFFSR_PID27(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *AIC_Type) GetFFSR_PID27() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x8000000) >> 27
}
func (o *AIC_Type) SetFFSR_PID28(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *AIC_Type) GetFFSR_PID28() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x10000000) >> 28
}
func (o *AIC_Type) SetFFSR_PID29(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *AIC_Type) GetFFSR_PID29() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x20000000) >> 29
}
func (o *AIC_Type) SetFFSR_PID30(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *AIC_Type) GetFFSR_PID30() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x40000000) >> 30
}
func (o *AIC_Type) SetFFSR_PID31(value uint32) {
	volatile.StoreUint32(&o.FFSR.Reg, volatile.LoadUint32(&o.FFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *AIC_Type) GetFFSR_PID31() uint32 {
	return (volatile.LoadUint32(&o.FFSR.Reg) & 0x80000000) >> 31
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER    volatile.Register32 // 0x0
	PDR    volatile.Register32 // 0x4
	PSR    volatile.Register32 // 0x8
	_      [4]byte
	OER    volatile.Register32 // 0x10
	ODR    volatile.Register32 // 0x14
	OSR    volatile.Register32 // 0x18
	_      [4]byte
	IFER   volatile.Register32 // 0x20
	IFDR   volatile.Register32 // 0x24
	IFSR   volatile.Register32 // 0x28
	_      [4]byte
	SODR   volatile.Register32 // 0x30
	CODR   volatile.Register32 // 0x34
	ODSR   volatile.Register32 // 0x38
	PDSR   volatile.Register32 // 0x3C
	IER    volatile.Register32 // 0x40
	IDR    volatile.Register32 // 0x44
	IMR    volatile.Register32 // 0x48
	ISR    volatile.Register32 // 0x4C
	MDER   volatile.Register32 // 0x50
	MDDR   volatile.Register32 // 0x54
	MDSR   volatile.Register32 // 0x58
	_      [4]byte
	PUDR   volatile.Register32 // 0x60
	PUER   volatile.Register32 // 0x64
	PUSR   volatile.Register32 // 0x68
	_      [4]byte
	ASR    volatile.Register32 // 0x70
	BSR    volatile.Register32 // 0x74
	ABSR   volatile.Register32 // 0x78
	_      [36]byte
	OWER   volatile.Register32 // 0xA0
	OWDR   volatile.Register32 // 0xA4
	OWSR   volatile.Register32 // 0xA8
	_      [20]byte
	DELAYR [4]volatile.Register32 // 0xC0
	_      [20]byte
	WPMR   volatile.Register32 // 0xE4
	WPSR   volatile.Register32 // 0xE8
}

// PIO.PER: PIO Enable Register
func (o *PIO_Type) SetPER_P0(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPER_P0() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0x1
}
func (o *PIO_Type) SetPER_P1(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPER_P1() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPER_P2(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPER_P2() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPER_P3(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPER_P3() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPER_P4(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPER_P4() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPER_P5(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPER_P5() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPER_P6(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPER_P6() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPER_P7(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPER_P7() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPER_P8(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPER_P8() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPER_P9(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPER_P9() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPER_P10(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPER_P10() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPER_P11(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPER_P11() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPER_P12(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPER_P12() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPER_P13(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPER_P13() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPER_P14(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPER_P14() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPER_P15(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPER_P15() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPER_P16(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPER_P16() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPER_P17(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPER_P17() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPER_P18(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPER_P18() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPER_P19(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPER_P19() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPER_P20(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPER_P20() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPER_P21(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPER_P21() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPER_P22(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPER_P22() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPER_P23(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPER_P23() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPER_P24(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPER_P24() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPER_P25(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPER_P25() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPER_P26(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPER_P26() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPER_P27(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPER_P27() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPER_P28(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPER_P28() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPER_P29(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPER_P29() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPER_P30(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPER_P30() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPER_P31(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPER_P31() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000000) >> 31
}

// PIO.PDR: PIO Disable Register
func (o *PIO_Type) SetPDR_P0(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDR_P0() uint32 {
	return volatile.LoadUint32(&o.PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPDR_P1(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDR_P2(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDR_P3(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDR_P4(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDR_P5(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDR_P6(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDR_P7(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDR_P8(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDR_P9(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDR_P10(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDR_P11(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDR_P12(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDR_P13(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDR_P14(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDR_P15(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDR_P16(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDR_P17(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDR_P18(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDR_P19(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDR_P20(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDR_P21(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDR_P22(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDR_P23(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDR_P24(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDR_P25(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDR_P26(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDR_P27(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDR_P28(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDR_P29(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDR_P30(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDR_P31(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000000) >> 31
}

// PIO.PSR: PIO Status Register
func (o *PIO_Type) SetPSR_P0(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPSR_P0() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPSR_P1(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPSR_P2(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPSR_P3(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPSR_P4(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPSR_P5(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPSR_P6(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPSR_P7(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPSR_P8(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPSR_P9(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPSR_P10(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPSR_P11(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPSR_P12(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPSR_P13(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPSR_P14(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPSR_P15(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPSR_P16(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPSR_P17(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPSR_P18(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPSR_P19(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPSR_P20(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPSR_P21(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPSR_P22(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPSR_P23(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPSR_P24(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPSR_P25(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPSR_P26(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPSR_P27(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPSR_P28(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPSR_P29(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPSR_P30(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPSR_P31(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000000) >> 31
}

// PIO.OER: Output Enable Register
func (o *PIO_Type) SetOER_P0(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOER_P0() uint32 {
	return volatile.LoadUint32(&o.OER.Reg) & 0x1
}
func (o *PIO_Type) SetOER_P1(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOER_P1() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOER_P2(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOER_P2() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOER_P3(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOER_P3() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOER_P4(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOER_P4() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOER_P5(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOER_P5() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOER_P6(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOER_P6() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOER_P7(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOER_P7() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOER_P8(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOER_P8() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOER_P9(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOER_P9() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOER_P10(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOER_P10() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOER_P11(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOER_P11() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOER_P12(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOER_P12() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOER_P13(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOER_P13() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOER_P14(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOER_P14() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOER_P15(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOER_P15() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOER_P16(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOER_P16() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOER_P17(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOER_P17() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOER_P18(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOER_P18() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOER_P19(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOER_P19() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOER_P20(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOER_P20() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOER_P21(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOER_P21() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOER_P22(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOER_P22() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOER_P23(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOER_P23() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOER_P24(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOER_P24() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOER_P25(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOER_P25() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOER_P26(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOER_P26() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOER_P27(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOER_P27() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOER_P28(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOER_P28() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOER_P29(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOER_P29() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOER_P30(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOER_P30() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOER_P31(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOER_P31() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000000) >> 31
}

// PIO.ODR: Output Disable Register
func (o *PIO_Type) SetODR_P0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODR_P0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *PIO_Type) SetODR_P1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODR_P2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODR_P3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODR_P4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODR_P5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODR_P6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODR_P7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODR_P8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODR_P9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODR_P10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODR_P11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODR_P12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODR_P13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODR_P14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODR_P15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODR_P16(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODR_P17(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODR_P18(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODR_P19(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODR_P20(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODR_P21(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODR_P22(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODR_P23(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODR_P24(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODR_P25(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODR_P26(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODR_P27(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODR_P28(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODR_P29(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODR_P30(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODR_P31(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000000) >> 31
}

// PIO.OSR: Output Status Register
func (o *PIO_Type) SetOSR_P0(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOSR_P0() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *PIO_Type) SetOSR_P1(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOSR_P2(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOSR_P3(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOSR_P4(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOSR_P5(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOSR_P6(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOSR_P7(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOSR_P8(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOSR_P9(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOSR_P10(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOSR_P11(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOSR_P12(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOSR_P13(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOSR_P14(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOSR_P15(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOSR_P16(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOSR_P17(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOSR_P18(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOSR_P19(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOSR_P20(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOSR_P21(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOSR_P22(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOSR_P23(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOSR_P24(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOSR_P25(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOSR_P26(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOSR_P27(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOSR_P28(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOSR_P29(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOSR_P30(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOSR_P31(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000000) >> 31
}

// PIO.IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetIFER_P0(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFER_P0() uint32 {
	return volatile.LoadUint32(&o.IFER.Reg) & 0x1
}
func (o *PIO_Type) SetIFER_P1(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFER_P2(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFER_P3(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFER_P4(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFER_P5(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFER_P6(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFER_P7(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFER_P8(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFER_P9(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFER_P10(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFER_P11(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFER_P12(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFER_P13(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFER_P14(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFER_P15(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFER_P16(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFER_P17(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFER_P18(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFER_P19(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFER_P20(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFER_P21(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFER_P22(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFER_P23(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFER_P24(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFER_P25(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFER_P26(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFER_P27(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFER_P28(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFER_P29(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFER_P30(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFER_P31(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000000) >> 31
}

// PIO.IFDR: Glitch Input Filter Disable Register
func (o *PIO_Type) SetIFDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSR: Glitch Input Filter Status Register
func (o *PIO_Type) SetIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000000) >> 31
}

// PIO.SODR: Set Output Data Register
func (o *PIO_Type) SetSODR_P0(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSODR_P0() uint32 {
	return volatile.LoadUint32(&o.SODR.Reg) & 0x1
}
func (o *PIO_Type) SetSODR_P1(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSODR_P1() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSODR_P2(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSODR_P2() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSODR_P3(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSODR_P3() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSODR_P4(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSODR_P4() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSODR_P5(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSODR_P5() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSODR_P6(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSODR_P6() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSODR_P7(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSODR_P7() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSODR_P8(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSODR_P8() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSODR_P9(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSODR_P9() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSODR_P10(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSODR_P10() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSODR_P11(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSODR_P11() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSODR_P12(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSODR_P12() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSODR_P13(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSODR_P13() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSODR_P14(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSODR_P14() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSODR_P15(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSODR_P15() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSODR_P16(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSODR_P16() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSODR_P17(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSODR_P17() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSODR_P18(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSODR_P18() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSODR_P19(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSODR_P19() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSODR_P20(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSODR_P20() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSODR_P21(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSODR_P21() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSODR_P22(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSODR_P22() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSODR_P23(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSODR_P23() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSODR_P24(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSODR_P24() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSODR_P25(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSODR_P25() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSODR_P26(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSODR_P26() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSODR_P27(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSODR_P27() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSODR_P28(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSODR_P28() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSODR_P29(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSODR_P29() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSODR_P30(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSODR_P30() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSODR_P31(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSODR_P31() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000000) >> 31
}

// PIO.CODR: Clear Output Data Register
func (o *PIO_Type) SetCODR_P0(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetCODR_P0() uint32 {
	return volatile.LoadUint32(&o.CODR.Reg) & 0x1
}
func (o *PIO_Type) SetCODR_P1(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetCODR_P1() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetCODR_P2(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetCODR_P2() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetCODR_P3(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetCODR_P3() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetCODR_P4(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetCODR_P4() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetCODR_P5(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetCODR_P5() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetCODR_P6(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetCODR_P6() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetCODR_P7(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetCODR_P7() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetCODR_P8(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetCODR_P8() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetCODR_P9(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetCODR_P9() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetCODR_P10(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetCODR_P10() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetCODR_P11(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetCODR_P11() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetCODR_P12(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetCODR_P12() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetCODR_P13(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetCODR_P13() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetCODR_P14(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetCODR_P14() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetCODR_P15(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetCODR_P15() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetCODR_P16(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetCODR_P16() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetCODR_P17(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetCODR_P17() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetCODR_P18(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetCODR_P18() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetCODR_P19(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetCODR_P19() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetCODR_P20(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetCODR_P20() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetCODR_P21(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetCODR_P21() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetCODR_P22(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetCODR_P22() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetCODR_P23(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetCODR_P23() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetCODR_P24(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetCODR_P24() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetCODR_P25(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetCODR_P25() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetCODR_P26(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetCODR_P26() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetCODR_P27(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetCODR_P27() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetCODR_P28(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetCODR_P28() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetCODR_P29(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetCODR_P29() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetCODR_P30(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetCODR_P30() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetCODR_P31(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetCODR_P31() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000000) >> 31
}

// PIO.ODSR: Output Data Status Register
func (o *PIO_Type) SetODSR_P0(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODSR_P0() uint32 {
	return volatile.LoadUint32(&o.ODSR.Reg) & 0x1
}
func (o *PIO_Type) SetODSR_P1(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODSR_P2(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODSR_P3(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODSR_P4(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODSR_P5(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODSR_P6(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODSR_P7(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODSR_P8(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODSR_P9(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODSR_P10(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODSR_P11(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODSR_P12(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODSR_P13(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODSR_P14(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODSR_P15(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODSR_P16(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODSR_P17(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODSR_P18(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODSR_P19(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODSR_P20(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODSR_P21(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODSR_P22(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODSR_P23(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODSR_P24(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODSR_P25(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODSR_P26(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODSR_P27(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODSR_P28(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODSR_P29(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODSR_P30(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODSR_P31(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000000) >> 31
}

// PIO.PDSR: Pin Data Status Register
func (o *PIO_Type) SetPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000000) >> 31
}

// PIO.IER: Interrupt Enable Register
func (o *PIO_Type) SetIER_P0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIER_P0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PIO_Type) SetIER_P1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIER_P1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIER_P2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIER_P2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIER_P3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIER_P3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIER_P4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIER_P4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIER_P5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIER_P5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIER_P6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIER_P6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIER_P7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIER_P7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIER_P8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIER_P8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIER_P9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIER_P9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIER_P10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIER_P10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIER_P11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIER_P11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIER_P12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIER_P12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIER_P13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIER_P13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIER_P14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIER_P14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIER_P15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIER_P15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIER_P16(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIER_P16() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIER_P17(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIER_P17() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIER_P18(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIER_P18() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIER_P19(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIER_P19() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIER_P20(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIER_P20() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIER_P21(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIER_P21() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIER_P22(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIER_P22() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIER_P23(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIER_P23() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIER_P24(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIER_P24() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIER_P25(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIER_P25() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIER_P26(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIER_P26() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIER_P27(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIER_P27() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIER_P28(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIER_P28() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIER_P29(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIER_P29() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIER_P30(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIER_P30() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIER_P31(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIER_P31() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// PIO.IDR: Interrupt Disable Register
func (o *PIO_Type) SetIDR_P0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIDR_P0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PIO_Type) SetIDR_P1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIDR_P2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIDR_P3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIDR_P4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIDR_P5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIDR_P6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIDR_P7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIDR_P8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIDR_P9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIDR_P10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIDR_P11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIDR_P12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIDR_P13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIDR_P14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIDR_P15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIDR_P16(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIDR_P17(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIDR_P18(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIDR_P19(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIDR_P20(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIDR_P21(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIDR_P22(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIDR_P23(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIDR_P24(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIDR_P25(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIDR_P26(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIDR_P27(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIDR_P28(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIDR_P29(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIDR_P30(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIDR_P31(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// PIO.IMR: Interrupt Mask Register
func (o *PIO_Type) SetIMR_P0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIMR_P0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PIO_Type) SetIMR_P1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIMR_P1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIMR_P2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIMR_P2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIMR_P3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIMR_P3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIMR_P4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIMR_P4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIMR_P5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIMR_P5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIMR_P6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIMR_P6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIMR_P7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIMR_P7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIMR_P8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIMR_P8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIMR_P9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIMR_P9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIMR_P10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIMR_P10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIMR_P11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIMR_P11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIMR_P12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIMR_P12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIMR_P13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIMR_P13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIMR_P14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIMR_P14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIMR_P15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIMR_P15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIMR_P16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIMR_P16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIMR_P17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIMR_P17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIMR_P18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIMR_P18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIMR_P19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIMR_P19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIMR_P20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIMR_P20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIMR_P21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIMR_P21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIMR_P22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIMR_P22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIMR_P23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIMR_P23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIMR_P24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIMR_P24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIMR_P25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIMR_P25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIMR_P26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIMR_P26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIMR_P27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIMR_P27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIMR_P28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIMR_P28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIMR_P29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIMR_P29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIMR_P30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIMR_P30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIMR_P31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIMR_P31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// PIO.ISR: Interrupt Status Register
func (o *PIO_Type) SetISR_P0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetISR_P0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PIO_Type) SetISR_P1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetISR_P1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetISR_P2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetISR_P2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetISR_P3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetISR_P3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetISR_P4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetISR_P4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetISR_P5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetISR_P5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetISR_P6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetISR_P6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetISR_P7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetISR_P7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetISR_P8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetISR_P8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetISR_P9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetISR_P9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetISR_P10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetISR_P10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetISR_P11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetISR_P11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetISR_P12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetISR_P12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetISR_P13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetISR_P13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetISR_P14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetISR_P14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetISR_P15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetISR_P15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetISR_P16(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetISR_P16() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetISR_P17(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetISR_P17() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetISR_P18(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetISR_P18() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetISR_P19(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetISR_P19() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetISR_P20(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetISR_P20() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetISR_P21(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volati