// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32l151.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32l151
// +build stm32,stm32l151

// STM32L151
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32L151"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Window watchdog
	IRQ_WWDG = 0

	// Power control
	IRQ_PVD = 1

	// External interrupt/event controller
	IRQ_TAMPER_STAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// Flash
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// Direct memory access controller
	IRQ_DMA1_Channel1 = 11

	// Direct memory access controller
	IRQ_DMA1_Channel2 = 12

	// Direct memory access controller
	IRQ_DMA1_Channel3 = 13

	// Direct memory access controller
	IRQ_DMA1_Channel4 = 14

	// Direct memory access controller
	IRQ_DMA1_Channel5 = 15

	// Direct memory access controller
	IRQ_DMA1_Channel6 = 16

	// Direct memory access controller
	IRQ_DMA1_Channel7 = 17

	// Analog-to-digital converter
	IRQ_ADC1 = 18

	// Universal serial bus full-speed device interface
	IRQ_USB_HP = 19

	// Universal serial bus full-speed device interface
	IRQ_USB_LP = 20

	// Digital-to-analog converter
	IRQ_DAC = 21

	// External interrupt/event controller
	IRQ_COMP_CA = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// Liquid crystal display controller
	IRQ_LCD = 24

	// General-purpose timers
	IRQ_TIM9 = 25

	// General-purpose timers
	IRQ_TIM10 = 26

	// General-purpose timers
	IRQ_TIM11 = 27

	// General-purpose timers
	IRQ_TIM2 = 28

	IRQ_TIM3 = 29

	IRQ_TIM4 = 30

	// Inter-integrated circuit
	IRQ_I2C1_EV = 31

	// Inter-integrated circuit
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Real-time clock
	IRQ_RTC_Alarm = 41

	// Universal serial bus full-speed device interface
	IRQ_USB_FS_WKUP = 42

	// Basic timers
	IRQ_TIM6 = 43

	IRQ_TIM7 = 44

	// Secure digital input/output interface
	IRQ_SDIO = 45

	IRQ_TIM5 = 46

	IRQ_SPI3 = 47

	IRQ_UART4 = 48

	IRQ_UART5 = 49

	IRQ_DMA2_CH1 = 50

	IRQ_DMA2_CH2 = 51

	IRQ_DMA2_CH3 = 52

	IRQ_DMA2_CH4 = 53

	IRQ_DMA2_CH5 = 54

	// Advanced encrytion standard hardware accelerator
	IRQ_AES = 55

	// Comparators
	IRQ_COMP_ACQ = 56

	// Highest interrupt number on this device.
	IRQ_max = 56
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export TAMPER_STAMP_IRQHandler
func interruptTAMPER_STAMP() {
	callHandlers(IRQ_TAMPER_STAMP)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_Channel1_IRQHandler
func interruptDMA1_Channel1() {
	callHandlers(IRQ_DMA1_Channel1)
}

//export DMA1_Channel2_IRQHandler
func interruptDMA1_Channel2() {
	callHandlers(IRQ_DMA1_Channel2)
}

//export DMA1_Channel3_IRQHandler
func interruptDMA1_Channel3() {
	callHandlers(IRQ_DMA1_Channel3)
}

//export DMA1_Channel4_IRQHandler
func interruptDMA1_Channel4() {
	callHandlers(IRQ_DMA1_Channel4)
}

//export DMA1_Channel5_IRQHandler
func interruptDMA1_Channel5() {
	callHandlers(IRQ_DMA1_Channel5)
}

//export DMA1_Channel6_IRQHandler
func interruptDMA1_Channel6() {
	callHandlers(IRQ_DMA1_Channel6)
}

//export DMA1_Channel7_IRQHandler
func interruptDMA1_Channel7() {
	callHandlers(IRQ_DMA1_Channel7)
}

//export ADC1_IRQHandler
func interruptADC1() {
	callHandlers(IRQ_ADC1)
}

//export USB_HP_IRQHandler
func interruptUSB_HP() {
	callHandlers(IRQ_USB_HP)
}

//export USB_LP_IRQHandler
func interruptUSB_LP() {
	callHandlers(IRQ_USB_LP)
}

//export DAC_IRQHandler
func interruptDAC() {
	callHandlers(IRQ_DAC)
}

//export COMP_CA_IRQHandler
func interruptCOMP_CA() {
	callHandlers(IRQ_COMP_CA)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export LCD_IRQHandler
func interruptLCD() {
	callHandlers(IRQ_LCD)
}

//export TIM9_IRQHandler
func interruptTIM9() {
	callHandlers(IRQ_TIM9)
}

//export TIM10_IRQHandler
func interruptTIM10() {
	callHandlers(IRQ_TIM10)
}

//export TIM11_IRQHandler
func interruptTIM11() {
	callHandlers(IRQ_TIM11)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_Alarm_IRQHandler
func interruptRTC_Alarm() {
	callHandlers(IRQ_RTC_Alarm)
}

//export USB_FS_WKUP_IRQHandler
func interruptUSB_FS_WKUP() {
	callHandlers(IRQ_USB_FS_WKUP)
}

//export TIM6_IRQHandler
func interruptTIM6() {
	callHandlers(IRQ_TIM6)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export SDIO_IRQHandler
func interruptSDIO() {
	callHandlers(IRQ_SDIO)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export DMA2_CH1_IRQHandler
func interruptDMA2_CH1() {
	callHandlers(IRQ_DMA2_CH1)
}

//export DMA2_CH2_IRQHandler
func interruptDMA2_CH2() {
	callHandlers(IRQ_DMA2_CH2)
}

//export DMA2_CH3_IRQHandler
func interruptDMA2_CH3() {
	callHandlers(IRQ_DMA2_CH3)
}

//export DMA2_CH4_IRQHandler
func interruptDMA2_CH4() {
	callHandlers(IRQ_DMA2_CH4)
}

//export DMA2_CH5_IRQHandler
func interruptDMA2_CH5() {
	callHandlers(IRQ_DMA2_CH5)
}

//export AES_IRQHandler
func interruptAES() {
	callHandlers(IRQ_AES)
}

//export COMP_ACQ_IRQHandler
func interruptCOMP_ACQ() {
	callHandlers(IRQ_COMP_ACQ)
}

// Peripherals.
var (
	// Advanced encrytion standard hardware accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x50060000)))

	// Comparators
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// CRC calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Direct memory access controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// Flash
	Flash = (*Flash_Type)(unsafe.Pointer(uintptr(0x40023c00)))

	// Flexible static memory controller
	FSMC = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Liquid crystal display controller
	LCD = (*LCD_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Operational amplifiers
	OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x40007c5c)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))

	// Routing interface
	RI = (*RI_Type)(unsafe.Pointer(uintptr(0x40007c04)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Secure digital input/output interface
	SDIO = (*SDIO_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General-purpose timers
	TIM10 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010c00)))

	// General-purpose timers
	TIM11 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// General-purpose timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// General-purpose timers
	TIM9 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010800)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Universal serial bus full-speed device interface
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Universal serial bus full-speed device interface
	USB_SRAM = (*USB_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Analog-to-digital converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012400)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// debug support
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Direct memory access controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021800)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021400)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// General-purpose timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General-purpose timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General-purpose timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))
)

// Advanced encrytion standard hardware accelerator
type AES_Type struct {
	CR    volatile.Register32 // 0x0
	SR    volatile.Register32 // 0x4
	DINR  volatile.Register32 // 0x8
	DOUTR volatile.Register32 // 0xC
	KEYR0 volatile.Register32 // 0x10
	KEYR1 volatile.Register32 // 0x14
	KEYR2 volatile.Register32 // 0x18
	KEYR3 volatile.Register32 // 0x1C
	IVR0  volatile.Register32 // 0x20
	IVR1  volatile.Register32 // 0x24
	IVR2  volatile.Register32 // 0x28
	IVR3  volatile.Register32 // 0x2C
}

// AES.CR: control register
func (o *AES_Type) SetCR_DMAOUTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *AES_Type) GetCR_DMAOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *AES_Type) SetCR_DMAINEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *AES_Type) GetCR_DMAINEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *AES_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *AES_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *AES_Type) SetCR_CCFIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *AES_Type) GetCR_CCFIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *AES_Type) SetCR_ERRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetCR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetCR_CCFC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *AES_Type) GetCR_CCFC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *AES_Type) SetCR_CHMOD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *AES_Type) GetCR_CHMOD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *AES_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *AES_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *AES_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6)|value<<1)
}
func (o *AES_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6) >> 1
}
func (o *AES_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// AES.SR: Status register
func (o *AES_Type) SetSR_WRERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *AES_Type) GetSR_WRERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *AES_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetSR_CCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetSR_CCF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// AES.DINR: Data input register
func (o *AES_Type) SetDINR(value uint32) {
	volatile.StoreUint32(&o.DINR.Reg, value)
}
func (o *AES_Type) GetDINR() uint32 {
	return volatile.LoadUint32(&o.DINR.Reg)
}

// AES.DOUTR: Data output register
func (o *AES_Type) SetDOUTR(value uint32) {
	volatile.StoreUint32(&o.DOUTR.Reg, value)
}
func (o *AES_Type) GetDOUTR() uint32 {
	return volatile.LoadUint32(&o.DOUTR.Reg)
}

// AES.KEYR0: AES Key register 0
func (o *AES_Type) SetKEYR0(value uint32) {
	volatile.StoreUint32(&o.KEYR0.Reg, value)
}
func (o *AES_Type) GetKEYR0() uint32 {
	return volatile.LoadUint32(&o.KEYR0.Reg)
}

// AES.KEYR1: AES Key register 1
func (o *AES_Type) SetKEYR1(value uint32) {
	volatile.StoreUint32(&o.KEYR1.Reg, value)
}
func (o *AES_Type) GetKEYR1() uint32 {
	return volatile.LoadUint32(&o.KEYR1.Reg)
}

// AES.KEYR2: AES Key register 2
func (o *AES_Type) SetKEYR2(value uint32) {
	volatile.StoreUint32(&o.KEYR2.Reg, value)
}
func (o *AES_Type) GetKEYR2() uint32 {
	return volatile.LoadUint32(&o.KEYR2.Reg)
}

// AES.KEYR3: AES Key register 3
func (o *AES_Type) SetKEYR3(value uint32) {
	volatile.StoreUint32(&o.KEYR3.Reg, value)
}
func (o *AES_Type) GetKEYR3() uint32 {
	return volatile.LoadUint32(&o.KEYR3.Reg)
}

// AES.IVR0: Initialization Vector Register 0
func (o *AES_Type) SetIVR0(value uint32) {
	volatile.StoreUint32(&o.IVR0.Reg, value)
}
func (o *AES_Type) GetIVR0() uint32 {
	return volatile.LoadUint32(&o.IVR0.Reg)
}

// AES.IVR1: Initialization Vector Register 1
func (o *AES_Type) SetIVR1(value uint32) {
	volatile.StoreUint32(&o.IVR1.Reg, value)
}
func (o *AES_Type) GetIVR1() uint32 {
	return volatile.LoadUint32(&o.IVR1.Reg)
}

// AES.IVR2: Initialization Vector Register 2
func (o *AES_Type) SetIVR2(value uint32) {
	volatile.StoreUint32(&o.IVR2.Reg, value)
}
func (o *AES_Type) GetIVR2() uint32 {
	return volatile.LoadUint32(&o.IVR2.Reg)
}

// AES.IVR3: Initialization Vector Register 3
func (o *AES_Type) SetIVR3(value uint32) {
	volatile.StoreUint32(&o.IVR3.Reg, value)
}
func (o *AES_Type) GetIVR3() uint32 {
	return volatile.LoadUint32(&o.IVR3.Reg)
}

// Comparators
type COMP_Type struct {
	CSR volatile.Register32 // 0x0
}

// COMP.CSR: comparator control and status register
func (o *COMP_Type) SetCSR_TSUSP(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCSR_TSUSP() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *COMP_Type) SetCSR_CAIF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCSR_CAIF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCSR_CAIE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *COMP_Type) GetCSR_CAIE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *COMP_Type) SetCSR_RCH13(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *COMP_Type) GetCSR_RCH13() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *COMP_Type) SetCSR_FCH8(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *COMP_Type) GetCSR_FCH8() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *COMP_Type) SetCSR_FCH3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *COMP_Type) GetCSR_FCH3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *COMP_Type) SetCSR_OUTSEL(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0xe00000)|value<<21)
}
func (o *COMP_Type) GetCSR_OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0xe00000) >> 21
}
func (o *COMP_Type) SetCSR_INSEL(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1c0000)|value<<18)
}
func (o *COMP_Type) GetCSR_INSEL() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1c0000) >> 18
}
func (o *COMP_Type) SetCSR_WNDWE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000)|value<<17)
}
func (o *COMP_Type) GetCSR_WNDWE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000) >> 17
}
func (o *COMP_Type) SetCSR_VREFOUTEN(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000)|value<<16)
}
func (o *COMP_Type) GetCSR_VREFOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000) >> 16
}
func (o *COMP_Type) SetCSR_CMP2OUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *COMP_Type) GetCSR_CMP2OUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *COMP_Type) SetCSR_SPEED(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *COMP_Type) GetCSR_SPEED() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *COMP_Type) SetCSR_CMP1OUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *COMP_Type) GetCSR_CMP1OUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *COMP_Type) SetCSR_SW1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *COMP_Type) GetCSR_SW1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *COMP_Type) SetCSR_CMP1EN(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *COMP_Type) GetCSR_CMP1EN() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *COMP_Type) SetCSR_PD400K(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *COMP_Type) GetCSR_PD400K() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *COMP_Type) SetCSR_PD10K(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *COMP_Type) GetCSR_PD10K() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *COMP_Type) SetCSR_PU400K(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetCSR_PU400K() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetCSR_PU10K(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCSR_PU10K() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// CRC calculation unit
type CRC_Type struct {
	DR  volatile.Register32 // 0x0
	IDR volatile.Register32 // 0x4
	CR  volatile.Register32 // 0x8
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xff)|value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xff
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// DAC.CR: control register
func (o *DAC_Type) SetCR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetCR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetCR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetCR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetCR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetCR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetCR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x380000)|value<<19)
}
func (o *DAC_Type) GetCR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x380000) >> 19
}
func (o *DAC_Type) SetCR_TEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DAC_Type) GetCR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DAC_Type) SetCR_BOFF2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetCR_BOFF2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *DAC_Type) SetCR_EN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_EN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetCR_BOFF1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCR_BOFF1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DAC.SWTRIGR: software trigger register
func (o *DAC_Type) SetSWTRIGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetSWTRIGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x1
}

// DAC.DHR12R1: channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12R2: channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R2.Reg, volatile.LoadUint32(&o.DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R2.Reg) & 0xfff
}

// DAC.DHR12L2: channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L2.Reg, volatile.LoadUint32(&o.DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L2.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R2: channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R2.Reg, volatile.LoadUint32(&o.DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R2.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff0000) >> 16
}
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}

// DAC.DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff00000) >> 20
}
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}

// DAC.DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff00) >> 8
}
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}

// DAC.DOR1: channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.DOR2: channel2 data output register
func (o *DAC_Type) SetDOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DOR2.Reg, volatile.LoadUint32(&o.DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DOR2.Reg) & 0xfff
}

// DAC.SR: status register
func (o *DAC_Type) SetSR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetSR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}

// Direct memory access controller
type DMA_Type struct {
	ISR    volatile.Register32 // 0x0
	IFCR   volatile.Register32 // 0x4
	CCR1   volatile.Register32 // 0x8
	CNDTR1 volatile.Register32 // 0xC
	CPAR1  volatile.Register32 // 0x10
	CMAR1  volatile.Register32 // 0x14
	_      [4]byte
	CCR2   volatile.Register32 // 0x1C
	CNDTR2 volatile.Register32 // 0x20
	CPAR2  volatile.Register32 // 0x24
	CMAR2  volatile.Register32 // 0x28
	_      [4]byte
	CCR3   volatile.Register32 // 0x30
	CNDTR3 volatile.Register32 // 0x34
	CPAR3  volatile.Register32 // 0x38
	CMAR3  volatile.Register32 // 0x3C
	_      [4]byte
	CCR4   volatile.Register32 // 0x44
	CNDTR4 volatile.Register32 // 0x48
	CPAR4  volatile.Register32 // 0x4C
	CMAR4  volatile.Register32 // 0x50
	_      [4]byte
	CCR5   volatile.Register32 // 0x58
	CNDTR5 volatile.Register32 // 0x5C
	CPAR5  volatile.Register32 // 0x60
	CMAR5  volatile.Register32 // 0x64
	_      [4]byte
	CCR6   volatile.Register32 // 0x6C
	CNDTR6 volatile.Register32 // 0x70
	CPAR6  volatile.Register32 // 0x74
	CMAR6  volatile.Register32 // 0x78
	_      [4]byte
	CCR7   volatile.Register32 // 0x80
	CNDTR7 volatile.Register32 // 0x84
	CPAR7  volatile.Register32 // 0x88
	CMAR7  volatile.Register32 // 0x8C
}

// DMA.ISR: interrupt status register
func (o *DMA_Type) SetISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetISR_GIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetISR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetISR_GIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetISR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// DMA.IFCR: interrupt flag clear register
func (o *DMA_Type) SetIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetIFCR_CGIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIFCR_CGIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIFCR_CGIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIFCR_CGIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetIFCR_CGIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetIFCR_CGIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetIFCR_CGIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIFCR_CGIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetIFCR_CGIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIFCR_CGIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIFCR_CGIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIFCR_CGIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIFCR_CGIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIFCR_CGIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}

// DMA.CCR1: channel x configuration register
func (o *DMA_Type) SetCCR1_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR1_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR1_PL(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR1_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR1_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR1_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR1_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR1_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR1_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR1_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR1_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR1_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR1_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR1_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR1_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR1_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR1_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR1_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR1_EN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR1_EN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}

// DMA.CNDTR1: channel x number of data register
func (o *DMA_Type) SetCNDTR1_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR1.Reg, volatile.LoadUint32(&o.CNDTR1.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR1_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR1.Reg) & 0xffff
}

// DMA.CPAR1: channel x peripheral address register
func (o *DMA_Type) SetCPAR1(value uint32) {
	volatile.StoreUint32(&o.CPAR1.Reg, value)
}
func (o *DMA_Type) GetCPAR1() uint32 {
	return volatile.LoadUint32(&o.CPAR1.Reg)
}

// DMA.CMAR1: channel x memory address register
func (o *DMA_Type) SetCMAR1(value uint32) {
	volatile.StoreUint32(&o.CMAR1.Reg, value)
}
func (o *DMA_Type) GetCMAR1() uint32 {
	return volatile.LoadUint32(&o.CMAR1.Reg)
}

// DMA.CCR2: channel x configuration register
func (o *DMA_Type) SetCCR2_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR2_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR2_PL(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR2_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR2_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR2_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR2_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR2_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR2_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR2_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR2_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR2_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR2_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR2_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR2_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR2_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR2_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR2_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR2_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR2_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR2_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR2_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR2_EN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR2_EN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}

// DMA.CNDTR2: channel x number of data register
func (o *DMA_Type) SetCNDTR2_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR2.Reg, volatile.LoadUint32(&o.CNDTR2.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR2_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR2.Reg) & 0xffff
}

// DMA.CPAR2: channel x peripheral address register
func (o *DMA_Type) SetCPAR2(value uint32) {
	volatile.StoreUint32(&o.CPAR2.Reg, value)
}
func (o *DMA_Type) GetCPAR2() uint32 {
	return volatile.LoadUint32(&o.CPAR2.Reg)
}

// DMA.CMAR2: channel x memory address register
func (o *DMA_Type) SetCMAR2(value uint32) {
	volatile.StoreUint32(&o.CMAR2.Reg, value)
}
func (o *DMA_Type) GetCMAR2() uint32 {
	return volatile.LoadUint32(&o.CMAR2.Reg)
}

// DMA.CCR3: channel x configuration register
func (o *DMA_Type) SetCCR3_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR3_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR3_PL(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR3_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR3_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR3_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR3_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR3_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR3_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR3_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR3_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR3_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR3_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR3_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR3_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR3_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR3_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR3_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR3_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR3_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR3_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR3_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR3.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR3_EN(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR3_EN() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0x1
}

// DMA.CNDTR3: channel x number of data register
func (o *DMA_Type) SetCNDTR3_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR3.Reg, volatile.LoadUint32(&o.CNDTR3.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR3_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR3.Reg) & 0xffff
}

// DMA.CPAR3: channel x peripheral address register
func (o *DMA_Type) SetCPAR3(value uint32) {
	volatile.StoreUint32(&o.CPAR3.Reg, value)
}
func (o *DMA_Type) GetCPAR3() uint32 {
	return volatile.LoadUint32(&o.CPAR3.Reg)
}

// DMA.CMAR3: channel x memory address register
func (o *DMA_Type) SetCMAR3(value uint32) {
	volatile.StoreUint32(&o.CMAR3.Reg, value)
}
func (o *DMA_Type) GetCMAR3() uint32 {
	return volatile.LoadUint32(&o.CMAR3.Reg)
}

// DMA.CCR4: channel x configuration register
func (o *DMA_Type) SetCCR4_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR4_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR4_PL(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR4_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR4_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR4_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR4_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR4_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR4_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR4_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR4_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR4_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR4_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR4_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR4_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR4_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR4_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR4_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR4_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR4_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR4_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR4_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR4.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR4_EN(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR4_EN() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0x1
}

// DMA.CNDTR4: channel x number of data register
func (o *DMA_Type) SetCNDTR4_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR4.Reg, volatile.LoadUint32(&o.CNDTR4.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR4_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR4.Reg) & 0xffff
}

// DMA.CPAR4: channel x peripheral address register
func (o *DMA_Type) SetCPAR4(value uint32) {
	volatile.StoreUint32(&o.CPAR4.Reg, value)
}
func (o *DMA_Type) GetCPAR4() uint32 {
	return volatile.LoadUint32(&o.CPAR4.Reg)
}

// DMA.CMAR4: channel x memory address register
func (o *DMA_Type) SetCMAR4(value uint32) {
	volatile.StoreUint32(&o.CMAR4.Reg, value)
}
func (o *DMA_Type) GetCMAR4() uint32 {
	return volatile.LoadUint32(&o.CMAR4.Reg)
}

// DMA.CCR5: channel x configuration register
func (o *DMA_Type) SetCCR5_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR5_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR5_PL(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR5_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR5_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR5_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR5_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR5_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR5_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR5_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR5_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR5_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR5_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR5_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR5_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR5_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR5_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR5_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR5_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR5_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR5_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR5_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR5_EN(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR5_EN() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0x1
}

// DMA.CNDTR5: channel x number of data register
func (o *DMA_Type) SetCNDTR5_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR5.Reg, volatile.LoadUint32(&o.CNDTR5.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR5_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR5.Reg) & 0xffff
}

// DMA.CPAR5: channel x peripheral address register
func (o *DMA_Type) SetCPAR5(value uint32) {
	volatile.StoreUint32(&o.CPAR5.Reg, value)
}
func (o *DMA_Type) GetCPAR5() uint32 {
	return volatile.LoadUint32(&o.CPAR5.Reg)
}

// DMA.CMAR5: channel x memory address register
func (o *DMA_Type) SetCMAR5(value uint32) {
	volatile.StoreUint32(&o.CMAR5.Reg, value)
}
func (o *DMA_Type) GetCMAR5() uint32 {
	return volatile.LoadUint32(&o.CMAR5.Reg)
}

// DMA.CCR6: channel x configuration register
func (o *DMA_Type) SetCCR6_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR6_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR6_PL(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR6_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR6_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR6_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR6_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR6_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR6_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR6_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR6_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR6_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR6_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR6_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR6_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR6_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR6_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR6_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR6_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR6_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR6_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR6_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR6.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR6_EN(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR6_EN() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0x1
}

// DMA.CNDTR6: channel x number of data register
func (o *DMA_Type) SetCNDTR6_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR6.Reg, volatile.LoadUint32(&o.CNDTR6.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR6_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR6.Reg) & 0xffff
}

// DMA.CPAR6: channel x peripheral address register
func (o *DMA_Type) SetCPAR6(value uint32) {
	volatile.StoreUint32(&o.CPAR6.Reg, value)
}
func (o *DMA_Type) GetCPAR6() uint32 {
	return volatile.LoadUint32(&o.CPAR6.Reg)
}

// DMA.CMAR6: channel x memory address register
func (o *DMA_Type) SetCMAR6(value uint32) {
	volatile.StoreUint32(&o.CMAR6.Reg, value)
}
func (o *DMA_Type) GetCMAR6() uint32 {
	return volatile.LoadUint32(&o.CMAR6.Reg)
}

// DMA.CCR7: channel x configuration register
func (o *DMA_Type) SetCCR7_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetCCR7_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetCCR7_PL(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_Type) GetCCR7_PL() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x3000) >> 12
}
func (o *DMA_Type) SetCCR7_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_Type) GetCCR7_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0xc00) >> 10
}
func (o *DMA_Type) SetCCR7_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x300)|value<<8)
}
func (o *DMA_Type) GetCCR7_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x300) >> 8
}
func (o *DMA_Type) SetCCR7_MINC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetCCR7_MINC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetCCR7_PINC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetCCR7_PINC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetCCR7_CIRC(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetCCR7_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetCCR7_DIR(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetCCR7_DIR() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetCCR7_TEIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetCCR7_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetCCR7_HTIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetCCR7_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetCCR7_TCIE(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetCCR7_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CCR7.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetCCR7_EN(value uint32) {
	volatile.StoreUint32(&o.CCR7.Reg, volatile.LoadUint32(&o.CCR7.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetCCR7_EN() uint32 {
	return volatile.LoadUint32(&o.CCR7.Reg) & 0x1
}

// DMA.CNDTR7: channel x number of data register
func (o *DMA_Type) SetCNDTR7_NDT(value uint32) {
	volatile.StoreUint32(&o.CNDTR7.Reg, volatile.LoadUint32(&o.CNDTR7.Reg)&^(0xffff)|value)
}
func (o *DMA_Type) GetCNDTR7_NDT() uint32 {
	return volatile.LoadUint32(&o.CNDTR7.Reg) & 0xffff
}

// DMA.CPAR7: channel x peripheral address register
func (o *DMA_Type) SetCPAR7(value uint32) {
	volatile.StoreUint32(&o.CPAR7.Reg, value)
}
func (o *DMA_Type) GetCPAR7() uint32 {
	return volatile.LoadUint32(&o.CPAR7.Reg)
}

// DMA.CMAR7: channel x memory address register
func (o *DMA_Type) SetCMAR7(value uint32) {
	volatile.StoreUint32(&o.CMAR7.Reg, value)
}
func (o *DMA_Type) GetCMAR7() uint32 {
	return volatile.LoadUint32(&o.CMAR7.Reg)
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// EXTI.IMR: IMR
func (o *EXTI_Type) SetIMR_MR0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR_MR0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR_MR1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR_MR1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR_MR2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR_MR2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR_MR3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR_MR3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR_MR4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR_MR4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR_MR5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR_MR5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR_MR6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR_MR6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR_MR7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR_MR7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR_MR8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR_MR8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR_MR9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR_MR9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR_MR10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR_MR10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR_MR11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR_MR11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR_MR12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR_MR12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR_MR13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR_MR13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR_MR14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR_MR14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR_MR15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR_MR15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR_MR16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR_MR16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR_MR17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR_MR17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR_MR18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR_MR18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR_MR19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR_MR19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR_MR20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR_MR20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR_MR21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR_MR21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR_MR22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR_MR22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}

// EXTI.EMR: EMR
func (o *EXTI_Type) SetEMR_MR0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR_MR0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR_MR1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR_MR1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR_MR2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR_MR2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR_MR3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR_MR3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR_MR4(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR_MR4() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR_MR5(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR_MR5() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR_MR6(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR_MR6() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR_MR7(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR_MR7() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR_MR8(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR_MR8() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR_MR9(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR_MR9() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR_MR10(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR_MR10() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR_MR11(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR_MR11() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR_MR12(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR_MR12() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR_MR13(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR_MR13() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR_MR14(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR_MR14() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR_MR15(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR_MR15() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR_MR16(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR_MR16() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR_MR17(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR_MR17() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR_MR18(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR_MR18() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR_MR19(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR_MR19() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR_MR20(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetEMR_MR20() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetEMR_MR21(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR_MR21() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR_MR22(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetEMR_MR22() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400000) >> 22
}

// EXTI.RTSR: RTSR
func (o *EXTI_Type) SetRTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.RTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400000) >> 22
}

// EXTI.FTSR: FTSR
func (o *EXTI_Type) SetFTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.FTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400000) >> 22
}

// EXTI.SWIER: SWIER
func (o *EXTI_Type) SetSWIER_SWIER0(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER_SWIER0() uint32 {
	return volatile.LoadUint32(&o.SWIER.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER_SWIER1(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER_SWIER1() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER_SWIER2(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER_SWIER2() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER_SWIER3(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER_SWIER3() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER_SWIER4(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER_SWIER4() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER_SWIER5(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER_SWIER5() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER_SWIER6(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER_SWIER6() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER_SWIER7(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER_SWIER7() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER_SWIER8(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER_SWIER8() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER_SWIER9(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER_SWIER9() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER_SWIER10(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER_SWIER10() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER_SWIER11(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER_SWIER11() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER_SWIER12(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER_SWIER12() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER_SWIER13(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER_SWIER13() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER_SWIER14(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER_SWIER14() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER_SWIER15(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER_SWIER15() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER_SWIER16(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER_SWIER16() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER_SWIER17(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER_SWIER17() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER_SWIER18(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER_SWIER18() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER_SWIER19(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER_SWIER19() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER_SWIER20(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER_SWIER20() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER_SWIER21(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER_SWIER21() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER_SWIER22(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER_SWIER22() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400000) >> 22
}

// EXTI.PR: PR
func (o *EXTI_Type) SetPR_PR0(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR_PR0() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x1
}
func (o *EXTI_Type) SetPR_PR1(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR_PR1() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR_PR2(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR_PR2() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR_PR3(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR_PR3() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR_PR4(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR_PR4() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR_PR5(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR_PR5() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR_PR6(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR_PR6() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR_PR7(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR_PR7() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR_PR8(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR_PR8() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR_PR9(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR_PR9() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR_PR10(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR_PR10() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR_PR11(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR_PR11() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR_PR12(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR_PR12() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR_PR13(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR_PR13() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR_PR14(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR_PR14() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR_PR15(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR_PR15() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR_PR16(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR_PR16() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPR_PR17(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetPR_PR17() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetPR_PR18(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetPR_PR18() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetPR_PR19(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPR_PR19() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPR_PR20(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPR_PR20() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPR_PR21(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR_PR21() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPR_PR22(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPR_PR22() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400000) >> 22
}

// Flash
type Flash_Type struct {
	ACR     volatile.Register32 // 0x0
	PECR    volatile.Register32 // 0x4
	PDKEYR  volatile.Register32 // 0x8
	PEKEYR  volatile.Register32 // 0xC
	PRGKEYR volatile.Register32 // 0x10
	OPTKEYR volatile.Register32 // 0x14
	SR      volatile.Register32 // 0x18
	OBR     volatile.Register32 // 0x1C
	WRPR1   volatile.Register32 // 0x20
	_       [92]byte
	WRPR2   volatile.Register32 // 0x80
	WRPR3   volatile.Register32 // 0x84
}

// Flash.ACR: Access control register
func (o *Flash_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *Flash_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetACR_ACC64(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetACR_ACC64() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetACR_SLEEP_PD(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetACR_SLEEP_PD() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetACR_RUN_PD(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetACR_RUN_PD() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x10) >> 4
}

// Flash.PECR: Program/erase control register
func (o *Flash_Type) SetPECR_PELOCK(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetPECR_PELOCK() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0x1
}
func (o *Flash_Type) SetPECR_PRGLOCK(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetPECR_PRGLOCK() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetPECR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetPECR_OPTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetPECR_PROG(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetPECR_PROG() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetPECR_DATA(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetPECR_DATA() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetPECR_FTDW(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetPECR_FTDW() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetPECR_ERASE(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetPECR_ERASE() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetPECR_FPRG(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x400)|value<<10)
}
func (o *Flash_Type) GetPECR_FPRG() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x400) >> 10
}
func (o *Flash_Type) SetPECR_PARALLELBANK(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x8000)|value<<15)
}
func (o *Flash_Type) GetPECR_PARALLELBANK() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x8000) >> 15
}
func (o *Flash_Type) SetPECR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x10000)|value<<16)
}
func (o *Flash_Type) GetPECR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x10000) >> 16
}
func (o *Flash_Type) SetPECR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x20000)|value<<17)
}
func (o *Flash_Type) GetPECR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x20000) >> 17
}
func (o *Flash_Type) SetPECR_OBL_LAUNCH(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0x40000)|value<<18)
}
func (o *Flash_Type) GetPECR_OBL_LAUNCH() uint32 {
	return (volatile.LoadUint32(&o.PECR.Reg) & 0x40000) >> 18
}

// Flash.PDKEYR: Power down key register
func (o *Flash_Type) SetPDKEYR(value uint32) {
	volatile.StoreUint32(&o.PDKEYR.Reg, value)
}
func (o *Flash_Type) GetPDKEYR() uint32 {
	return volatile.LoadUint32(&o.PDKEYR.Reg)
}

// Flash.PEKEYR: Program/erase key register
func (o *Flash_Type) SetPEKEYR(value uint32) {
	volatile.StoreUint32(&o.PEKEYR.Reg, value)
}
func (o *Flash_Type) GetPEKEYR() uint32 {
	return volatile.LoadUint32(&o.PEKEYR.Reg)
}

// Flash.PRGKEYR: Program memory key register
func (o *Flash_Type) SetPRGKEYR(value uint32) {
	volatile.StoreUint32(&o.PRGKEYR.Reg, value)
}
func (o *Flash_Type) GetPRGKEYR() uint32 {
	return volatile.LoadUint32(&o.PRGKEYR.Reg)
}

// Flash.OPTKEYR: Option byte key register
func (o *Flash_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *Flash_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// Flash.SR: Status register
func (o *Flash_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSR_BSY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *Flash_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetSR_EOP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetSR_ENDHV(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetSR_ENDHV() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetSR_READY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetSR_READY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *Flash_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetSR_SIZERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *Flash_Type) GetSR_SIZERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *Flash_Type) SetSR_OPTVERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *Flash_Type) GetSR_OPTVERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *Flash_Type) SetSR_OPTVERRUSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetSR_OPTVERRUSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}

// Flash.OBR: Option byte register
func (o *Flash_Type) SetOBR_RDPRT(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0xff)|value)
}
func (o *Flash_Type) GetOBR_RDPRT() uint32 {
	return volatile.LoadUint32(&o.OBR.Reg) & 0xff
}
func (o *Flash_Type) SetOBR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0xf0000)|value<<16)
}
func (o *Flash_Type) GetOBR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0xf0000) >> 16
}
func (o *Flash_Type) SetOBR_IWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x100000)|value<<20)
}
func (o *Flash_Type) GetOBR_IWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0x100000) >> 20
}
func (o *Flash_Type) SetOBR_NRTS_STOP(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x200000)|value<<21)
}
func (o *Flash_Type) GetOBR_NRTS_STOP() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0x200000) >> 21
}
func (o *Flash_Type) SetOBR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x400000)|value<<22)
}
func (o *Flash_Type) GetOBR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0x400000) >> 22
}
func (o *Flash_Type) SetOBR_BFB2(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x800000)|value<<23)
}
func (o *Flash_Type) GetOBR_BFB2() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0x800000) >> 23
}

// Flash.WRPR1: Write protection register
func (o *Flash_Type) SetWRPR1(value uint32) {
	volatile.StoreUint32(&o.WRPR1.Reg, value)
}
func (o *Flash_Type) GetWRPR1() uint32 {
	return volatile.LoadUint32(&o.WRPR1.Reg)
}

// Flash.WRPR2: Write protection register
func (o *Flash_Type) SetWRPR2(value uint32) {
	volatile.StoreUint32(&o.WRPR2.Reg, value)
}
func (o *Flash_Type) GetWRPR2() uint32 {
	return volatile.LoadUint32(&o.WRPR2.Reg)
}

// Flash.WRPR3: Write protection register
func (o *Flash_Type) SetWRPR3(value uint32) {
	volatile.StoreUint32(&o.WRPR3.Reg, value)
}
func (o *Flash_Type) GetWRPR3() uint32 {
	return volatile.LoadUint32(&o.WRPR3.Reg)
}

// Flexible static memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [228]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
}

// FSMC.BCR1: BCR1
func (o *FSMC_Type) SetBCR1_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR1_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR1_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR1_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR1_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR1_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR1_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR1_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR1_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR1_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR1_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR1_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR1_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR1_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR1_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR1_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR1_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR1_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR1_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR1_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR1_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR1_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR1_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR1_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR1_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR1_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR1_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR1_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR1.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR1_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR1_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x70000) >> 16
}

// FSMC.BTR1: BTR1
func (o *FSMC_Type) SetBTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR1.Reg) & 0xf
}

// FSMC.BCR2: BCR2
func (o *FSMC_Type) SetBCR2_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR2_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR2_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR2_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR2_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR2_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR2_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR2_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR2_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR2_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR2_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR2_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR2_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR2_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR2_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR2_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR2_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR2_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR2_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR2_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR2_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR2_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR2_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR2_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR2_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR2_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR2_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR2_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR2.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR2_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR2_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x70000) >> 16
}

// FSMC.BTR2: BTR1
func (o *FSMC_Type) SetBTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR2.Reg) & 0xf
}

// FSMC.BCR3: BCR2
func (o *FSMC_Type) SetBCR3_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR3_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR3_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR3_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR3_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR3_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR3_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR3_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR3_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR3_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR3_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR3_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR3_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR3_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR3_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR3_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR3_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR3_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR3_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR3_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR3_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR3_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR3_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR3_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR3_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR3_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR3_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR3_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR3.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR3_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR3_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x70000) >> 16
}

// FSMC.BTR3: BTR1
func (o *FSMC_Type) SetBTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR3.Reg) & 0xf
}

// FSMC.BCR4: BCR2
func (o *FSMC_Type) SetBCR4_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR4_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR4_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR4_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR4_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR4_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR4_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR4_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR4_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR4_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR4_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR4_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR4_WRAPMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x400)|value<<10)
}
func (o *FSMC_Type) GetBCR4_WRAPMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x400) >> 10
}
func (o *FSMC_Type) SetBCR4_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR4_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR4_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR4_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR4_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR4_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR4_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR4_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR4_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR4_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR4_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR4_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR4_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR4_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR4.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR4_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR4_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x70000) >> 16
}

// FSMC.BTR4: BTR1
func (o *FSMC_Type) SetBTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR4.Reg) & 0xf
}

// FSMC.BWTR1: BWTR1
func (o *FSMC_Type) SetBWTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR1.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR2: BWTR1
func (o *FSMC_Type) SetBWTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR2.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR3: BWTR1
func (o *FSMC_Type) SetBWTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR3.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR4: BWTR1
func (o *FSMC_Type) SetBWTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBWTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBWTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBWTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBWTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR4.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0000) >> 16
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: AFRL
func (o *GPIO_Type) SetAFRL_AFRL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFRL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFRL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFRL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFRL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFRL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFRL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFRL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFRL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFRL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFRL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFRL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFRL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFRL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFRL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFRL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFRH15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFRH15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFRH14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFRH14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFRH13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFRH13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFRH12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFRH12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFRH11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFRH11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFRH10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFRH10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFRH9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFRH9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFRH8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFRH8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1   volatile.Register32 // 0x0
	CR2   volatile.Register32 // 0x4
	OAR1  volatile.Register32 // 0x8
	OAR2  volatile.Register32 // 0xC
	DR    volatile.Register32 // 0x10
	SR1   volatile.Register32 // 0x14
	SR2   volatile.Register32 // 0x18
	CCR   volatile.Register32 // 0x1C
	TRISE volatile.Register32 // 0x20
}

// I2C.CR1: CR1
func (o *I2C_Type) SetCR1_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_ALERT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR1_ALERT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR1_PEC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_PEC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_POS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR1_POS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR1_ACK(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR1_ACK() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR1_STOP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCR1_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCR1_START(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCR1_START() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_ENGC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_ENGC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ENPEC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_ENPEC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_ENARP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_ENARP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_SMBTYPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_SMBTYPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_SMBUS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_SMBUS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// I2C.CR2: CR2
func (o *I2C_Type) SetCR2_LAST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_LAST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_ITBUFEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_ITBUFEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_ITEVTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCR2_ITEVTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCR2_ITERREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCR2_ITERREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCR2_FREQ(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3f)|value)
}
func (o *I2C_Type) GetCR2_FREQ() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3f
}

// I2C.OAR1: OAR1
func (o *I2C_Type) SetOAR1_ADDMODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_ADDMODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetOAR1_ADD(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_ADD() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}

// I2C.OAR2: OAR2
func (o *I2C_Type) SetOAR2_ADD2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_ADD2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_ENDUAL(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetOAR2_ENDUAL() uint32 {
	return volatile.LoadUint32(&o.OAR2.Reg) & 0x1
}

// I2C.DR: DR
func (o *I2C_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xff
}

// I2C.SR1: SR1
func (o *I2C_Type) SetSR1_SMBALERT(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetSR1_SMBALERT() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetSR1_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetSR1_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetSR1_PECERR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetSR1_PECERR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetSR1_OVR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetSR1_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetSR1_AF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetSR1_AF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetSR1_ARLO(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetSR1_ARLO() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetSR1_BERR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetSR1_BERR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetSR1_TxE(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSR1_TxE() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetSR1_RxNE(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSR1_RxNE() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSR1_STOPF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR1_STOPF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR1_ADD10(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSR1_ADD10() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSR1_BTF(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSR1_BTF() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSR1_ADDR(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSR1_ADDR() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSR1_SB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR1_SB() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}

// I2C.SR2: SR2
func (o *I2C_Type) SetSR2_PEC(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetSR2_PEC() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetSR2_DUALF(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSR2_DUALF() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetSR2_SMBHOST(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSR2_SMBHOST() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSR2_SMBDEFAULT(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSR2_SMBDEFAULT() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSR2_GENCALL(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR2_GENCALL() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR2_TRA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSR2_TRA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSR2_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSR2_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSR2_MSL(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR2_MSL() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}

// I2C.CCR: CCR
func (o *I2C_Type) SetCCR_F_S(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCCR_F_S() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCCR_DUTY(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCCR_DUTY() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCCR(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetCCR() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0xfff
}

// I2C.TRISE: TRISE
func (o *I2C_Type) SetTRISE(value uint32) {
	volatile.StoreUint32(&o.TRISE.Reg, volatile.LoadUint32(&o.TRISE.Reg)&^(0x3f)|value)
}
func (o *I2C_Type) GetTRISE() uint32 {
	return volatile.LoadUint32(&o.TRISE.Reg) & 0x3f
}

// Independent watchdog
type IWDG_Type struct {
	KR  volatile.Register32 // 0x0
	PR  volatile.Register32 // 0x4
	RLR volatile.Register32 // 0x8
	SR  volatile.Register32 // 0xC
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Liquid crystal display controller
type LCD_Type struct {
	CR       volatile.Register32 // 0x0
	FCR      volatile.Register32 // 0x4
	SR       volatile.Register32 // 0x8
	CLR      volatile.Register32 // 0xC
	_        [4]byte
	RAM_COM0 volatile.Register32 // 0x14
	_        [4]byte
	RAM_COM1 volatile.Register32 // 0x1C
	_        [4]byte
	RAM_COM2 volatile.Register32 // 0x24
	_        [4]byte
	RAM_COM3 volatile.Register32 // 0x2C
	_        [4]byte
	RAM_COM4 volatile.Register32 // 0x34
	_        [4]byte
	RAM_COM5 volatile.Register32 // 0x3C
	_        [4]byte
	RAM_COM6 volatile.Register32 // 0x44
	_        [4]byte
	RAM_COM7 volatile.Register32 // 0x4C
}

// LCD.CR: control register
func (o *LCD_Type) SetCR_MUX_SEG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetCR_MUX_SEG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetCR_BIAS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *LCD_Type) GetCR_BIAS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *LCD_Type) SetCR_DUTY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1c)|value<<2)
}
func (o *LCD_Type) GetCR_DUTY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1c) >> 2
}
func (o *LCD_Type) SetCR_VSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetCR_VSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetCR_LCDEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCR_LCDEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LCD.FCR: frame control register
func (o *LCD_Type) SetFCR_PS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3c00000)|value<<22)
}
func (o *LCD_Type) GetFCR_PS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x3c00000) >> 22
}
func (o *LCD_Type) SetFCR_DIV(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3c0000)|value<<18)
}
func (o *LCD_Type) GetFCR_DIV() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x3c0000) >> 18
}
func (o *LCD_Type) SetFCR_BLINK(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x30000)|value<<16)
}
func (o *LCD_Type) GetFCR_BLINK() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x30000) >> 16
}
func (o *LCD_Type) SetFCR_BLINKF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xe000)|value<<13)
}
func (o *LCD_Type) GetFCR_BLINKF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xe000) >> 13
}
func (o *LCD_Type) SetFCR_CC(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1c00)|value<<10)
}
func (o *LCD_Type) GetFCR_CC() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x1c00) >> 10
}
func (o *LCD_Type) SetFCR_DEAD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x380)|value<<7)
}
func (o *LCD_Type) GetFCR_DEAD() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x380) >> 7
}
func (o *LCD_Type) SetFCR_PON(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x70)|value<<4)
}
func (o *LCD_Type) GetFCR_PON() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x70) >> 4
}
func (o *LCD_Type) SetFCR_UDDIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetFCR_UDDIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetFCR_SOFIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetFCR_SOFIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetFCR_HD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetFCR_HD() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x1
}

// LCD.SR: status register
func (o *LCD_Type) SetSR_FCRSF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetSR_FCRSF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetSR_RDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetSR_RDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetSR_UDD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetSR_UDD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetSR_SOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetSR_SOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetSR_ENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetSR_ENS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// LCD.CLR: clear register
func (o *LCD_Type) SetCLR_UDDC(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetCLR_UDDC() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetCLR_SOFC(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetCLR_SOFC() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x2) >> 1
}

// LCD.RAM_COM0: display memory
func (o *LCD_Type) SetRAM_COM0_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM0_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM0_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM0_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM0_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM0_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM0_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM0_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM0_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM0_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM0_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM0_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM0_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM0_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM0_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM0_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM0_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM0_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM0_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM0_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM0_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM0_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM0_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM0_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM0_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM0_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM0_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM0_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM0_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM0_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM0_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM0_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM0_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM0_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM0_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM0_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM0_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM0_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM0_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM0_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM0_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM0_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM0_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM0_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM0_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM0_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM0_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM0_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM0_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM0_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM0_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM0_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM0_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM0_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM0_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM0_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM0_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM0_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM0_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM0_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM0_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM0_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM0_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM0.Reg, volatile.LoadUint32(&o.RAM_COM0.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM0_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM0.Reg) & 0x1
}

// LCD.RAM_COM1: display memory
func (o *LCD_Type) SetRAM_COM1_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM1_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM1_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM1_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM1_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM1_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM1_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM1_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM1_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM1_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM1_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM1_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM1_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM1_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM1_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM1_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM1_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM1_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM1_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM1_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM1_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM1_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM1_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM1_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM1_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM1_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM1_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM1_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM1_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM1_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM1_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM1_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM1_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM1_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM1_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM1_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM1_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM1_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM1_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM1_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM1_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM1_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM1_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM1_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM1_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM1_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM1_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM1_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM1_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM1_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM1_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM1_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM1_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM1_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM1_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM1_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM1_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM1_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM1_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM1_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM1_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM1_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM1_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM1.Reg, volatile.LoadUint32(&o.RAM_COM1.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM1_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM1.Reg) & 0x1
}

// LCD.RAM_COM2: display memory
func (o *LCD_Type) SetRAM_COM2_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM2_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM2_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM2_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM2_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM2_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM2_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM2_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM2_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM2_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM2_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM2_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM2_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM2_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM2_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM2_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM2_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM2_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM2_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM2_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM2_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM2_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM2_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM2_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM2_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM2_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM2_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM2_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM2_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM2_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM2_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM2_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM2_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM2_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM2_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM2_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM2_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM2_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM2_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM2_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM2_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM2_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM2_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM2_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM2_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM2_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM2_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM2_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM2_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM2_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM2_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM2_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM2_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM2_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM2_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM2_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM2_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM2_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM2_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM2_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM2_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM2_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM2_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM2.Reg, volatile.LoadUint32(&o.RAM_COM2.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM2_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM2.Reg) & 0x1
}

// LCD.RAM_COM3: display memory
func (o *LCD_Type) SetRAM_COM3_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM3_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM3_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM3_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM3_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM3_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM3_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM3_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM3_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM3_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM3_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM3_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM3_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM3_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM3_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM3_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM3_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM3_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM3_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM3_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM3_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM3_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM3_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM3_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM3_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM3_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM3_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM3_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM3_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM3_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM3_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM3_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM3_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM3_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM3_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM3_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM3_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM3_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM3_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM3_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM3_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM3_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM3_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM3_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM3_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM3_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM3_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM3_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM3_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM3_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM3_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM3_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM3_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM3_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM3_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM3_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM3_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM3_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM3_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM3_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM3_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM3_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM3_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM3.Reg, volatile.LoadUint32(&o.RAM_COM3.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM3_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM3.Reg) & 0x1
}

// LCD.RAM_COM4: display memory
func (o *LCD_Type) SetRAM_COM4_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM4_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM4_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM4_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM4_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM4_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM4_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM4_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM4_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM4_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM4_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM4_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM4_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM4_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM4_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM4_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM4_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM4_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM4_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM4_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM4_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM4_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM4_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM4_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM4_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM4_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM4_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM4_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM4_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM4_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM4_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM4_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM4_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM4_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM4_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM4_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM4_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM4_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM4_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM4_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM4_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM4_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM4_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM4_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM4_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM4_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM4_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM4_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM4_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM4_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM4_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM4_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM4_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM4_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM4_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM4_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM4_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM4_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM4_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM4_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM4_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM4_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM4_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM4.Reg, volatile.LoadUint32(&o.RAM_COM4.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM4_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM4.Reg) & 0x1
}

// LCD.RAM_COM5: display memory
func (o *LCD_Type) SetRAM_COM5_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM5_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM5_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM5_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM5_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM5_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM5_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM5_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM5_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM5_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM5_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM5_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM5_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM5_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM5_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM5_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM5_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM5_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM5_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM5_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM5_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM5_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM5_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM5_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM5_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM5_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM5_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM5_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM5_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM5_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM5_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM5_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM5_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM5_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM5_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM5_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM5_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM5_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM5_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM5_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM5_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM5_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM5_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM5_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM5_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM5_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM5_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM5_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM5_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM5_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM5_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM5_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM5_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM5_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM5_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM5_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM5_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM5_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM5_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM5_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM5_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM5_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM5_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM5.Reg, volatile.LoadUint32(&o.RAM_COM5.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM5_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM5.Reg) & 0x1
}

// LCD.RAM_COM6: display memory
func (o *LCD_Type) SetRAM_COM6_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM6_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM6_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM6_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM6_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM6_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM6_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM6_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM6_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM6_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM6_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM6_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM6_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM6_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM6_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM6_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM6_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM6_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM6_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM6_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM6_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM6_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM6_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM6_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM6_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM6_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM6_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM6_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM6_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM6_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM6_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM6_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM6_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM6_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM6_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM6_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM6_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM6_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM6_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM6_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM6_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM6_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM6_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM6_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM6_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM6_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM6_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM6_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM6_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM6_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM6_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM6_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM6_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM6_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM6_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM6_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM6_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM6_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM6_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM6_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM6_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM6_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM6_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM6.Reg, volatile.LoadUint32(&o.RAM_COM6.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM6_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM6.Reg) & 0x1
}

// LCD.RAM_COM7: display memory
func (o *LCD_Type) SetRAM_COM7_S31(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetRAM_COM7_S31() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x80000000) >> 31
}
func (o *LCD_Type) SetRAM_COM7_S30(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x40000000)|value<<30)
}
func (o *LCD_Type) GetRAM_COM7_S30() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x40000000) >> 30
}
func (o *LCD_Type) SetRAM_COM7_S29(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x20000000)|value<<29)
}
func (o *LCD_Type) GetRAM_COM7_S29() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x20000000) >> 29
}
func (o *LCD_Type) SetRAM_COM7_S28(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x10000000)|value<<28)
}
func (o *LCD_Type) GetRAM_COM7_S28() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x10000000) >> 28
}
func (o *LCD_Type) SetRAM_COM7_S27(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x8000000)|value<<27)
}
func (o *LCD_Type) GetRAM_COM7_S27() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x8000000) >> 27
}
func (o *LCD_Type) SetRAM_COM7_S26(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetRAM_COM7_S26() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetRAM_COM7_S25(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x2000000)|value<<25)
}
func (o *LCD_Type) GetRAM_COM7_S25() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x2000000) >> 25
}
func (o *LCD_Type) SetRAM_COM7_S24(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x1000000)|value<<24)
}
func (o *LCD_Type) GetRAM_COM7_S24() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x1000000) >> 24
}
func (o *LCD_Type) SetRAM_COM7_S23(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x800000)|value<<23)
}
func (o *LCD_Type) GetRAM_COM7_S23() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x800000) >> 23
}
func (o *LCD_Type) SetRAM_COM7_S22(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x400000)|value<<22)
}
func (o *LCD_Type) GetRAM_COM7_S22() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x400000) >> 22
}
func (o *LCD_Type) SetRAM_COM7_S21(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x200000)|value<<21)
}
func (o *LCD_Type) GetRAM_COM7_S21() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x200000) >> 21
}
func (o *LCD_Type) SetRAM_COM7_S20(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x100000)|value<<20)
}
func (o *LCD_Type) GetRAM_COM7_S20() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x100000) >> 20
}
func (o *LCD_Type) SetRAM_COM7_S19(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x80000)|value<<19)
}
func (o *LCD_Type) GetRAM_COM7_S19() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x80000) >> 19
}
func (o *LCD_Type) SetRAM_COM7_S18(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x40000)|value<<18)
}
func (o *LCD_Type) GetRAM_COM7_S18() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x40000) >> 18
}
func (o *LCD_Type) SetRAM_COM7_S17(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x20000)|value<<17)
}
func (o *LCD_Type) GetRAM_COM7_S17() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x20000) >> 17
}
func (o *LCD_Type) SetRAM_COM7_S16(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetRAM_COM7_S16() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetRAM_COM7_S15(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetRAM_COM7_S15() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetRAM_COM7_S14(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetRAM_COM7_S14() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetRAM_COM7_S13(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetRAM_COM7_S13() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetRAM_COM7_S12(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetRAM_COM7_S12() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetRAM_COM7_S11(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetRAM_COM7_S11() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetRAM_COM7_S10(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetRAM_COM7_S10() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetRAM_COM7_S09(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetRAM_COM7_S09() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetRAM_COM7_S08(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetRAM_COM7_S08() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetRAM_COM7_S07(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetRAM_COM7_S07() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetRAM_COM7_S06(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetRAM_COM7_S06() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetRAM_COM7_S05(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetRAM_COM7_S05() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetRAM_COM7_S04(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetRAM_COM7_S04() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetRAM_COM7_S03(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetRAM_COM7_S03() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetRAM_COM7_S02(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetRAM_COM7_S02() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetRAM_COM7_S01(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetRAM_COM7_S01() uint32 {
	return (volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetRAM_COM7_S00(value uint32) {
	volatile.StoreUint32(&o.RAM_COM7.Reg, volatile.LoadUint32(&o.RAM_COM7.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetRAM_COM7_S00() uint32 {
	return volatile.LoadUint32(&o.RAM_COM7.Reg) & 0x1
}

// Operational amplifiers
type OPAMP_Type struct {
	CSR   volatile.Register32 // 0x0
	OTR   volatile.Register32 // 0x4
	LPOTR volatile.Register32 // 0x8
}

// OPAMP.CSR: control/status register
func (o *OPAMP_Type) SetCSR_OPA3CALOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetCSR_OPA3CALOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *OPAMP_Type) SetCSR_OPA2CALOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *OPAMP_Type) GetCSR_OPA2CALOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *OPAMP_Type) SetCSR_OPA1CALOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *OPAMP_Type) GetCSR_OPA1CALOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *OPAMP_Type) SetCSR_AOP_RANGE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *OPAMP_Type) GetCSR_AOP_RANGE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *OPAMP_Type) SetCSR_S7SEL2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *OPAMP_Type) GetCSR_S7SEL2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *OPAMP_Type) SetCSR_ANAWSEL3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *OPAMP_Type) GetCSR_ANAWSEL3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *OPAMP_Type) SetCSR_ANAWSEL2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *OPAMP_Type) GetCSR_ANAWSEL2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *OPAMP_Type) SetCSR_ANAWSEL1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *OPAMP_Type) GetCSR_ANAWSEL1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}
func (o *OPAMP_Type) SetCSR_OPA3LPM(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *OPAMP_Type) GetCSR_OPA3LPM() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *OPAMP_Type) SetCSR_OPA3CAL_H(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400000)|value<<22)
}
func (o *OPAMP_Type) GetCSR_OPA3CAL_H() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400000) >> 22
}
func (o *OPAMP_Type) SetCSR_OPA3CAL_L(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200000)|value<<21)
}
func (o *OPAMP_Type) GetCSR_OPA3CAL_L() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200000) >> 21
}
func (o *OPAMP_Type) SetCSR_S6SEL3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100000)|value<<20)
}
func (o *OPAMP_Type) GetCSR_S6SEL3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100000) >> 20
}
func (o *OPAMP_Type) SetCSR_S5SEL3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *OPAMP_Type) GetCSR_S5SEL3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *OPAMP_Type) SetCSR_S4SEL3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000)|value<<18)
}
func (o *OPAMP_Type) GetCSR_S4SEL3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000) >> 18
}
func (o *OPAMP_Type) SetCSR_S3SEL3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000)|value<<17)
}
func (o *OPAMP_Type) GetCSR_S3SEL3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000) >> 17
}
func (o *OPAMP_Type) SetCSR_OPA3PD(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000)|value<<16)
}
func (o *OPAMP_Type) GetCSR_OPA3PD() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000) >> 16
}
func (o *OPAMP_Type) SetCSR_OPA2LPM(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000)|value<<15)
}
func (o *OPAMP_Type) GetCSR_OPA2LPM() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000) >> 15
}
func (o *OPAMP_Type) SetCSR_OPA2CAL_H(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000)|value<<14)
}
func (o *OPAMP_Type) GetCSR_OPA2CAL_H() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000) >> 14
}
func (o *OPAMP_Type) SetCSR_OPA2CAL_L(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *OPAMP_Type) GetCSR_OPA2CAL_L() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *OPAMP_Type) SetCSR_S6SEL2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *OPAMP_Type) GetCSR_S6SEL2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *OPAMP_Type) SetCSR_S5SEL2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *OPAMP_Type) GetCSR_S5SEL2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *OPAMP_Type) SetCSR_S4SEL2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *OPAMP_Type) GetCSR_S4SEL2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *OPAMP_Type) SetCSR_S3SEL2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *OPAMP_Type) GetCSR_S3SEL2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *OPAMP_Type) SetCSR_OPA2PD(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *OPAMP_Type) GetCSR_OPA2PD() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *OPAMP_Type) SetCSR_OPA1LPM(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *OPAMP_Type) GetCSR_OPA1LPM() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *OPAMP_Type) SetCSR_OPA1CAL_H(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *OPAMP_Type) GetCSR_OPA1CAL_H() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *OPAMP_Type) SetCSR_OPA1CAL_L(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *OPAMP_Type) GetCSR_OPA1CAL_L() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *OPAMP_Type) SetCSR_S6SEL1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *OPAMP_Type) GetCSR_S6SEL1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *OPAMP_Type) SetCSR_S5SEL1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *OPAMP_Type) GetCSR_S5SEL1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *OPAMP_Type) SetCSR_S4SEL1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *OPAMP_Type) GetCSR_S4SEL1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *OPAMP_Type) SetCSR_S3SEL1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetCSR_S3SEL1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetCSR_OPA1PD(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetCSR_OPA1PD() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// OPAMP.OTR: offset trimming register for normal mode
func (o *OPAMP_Type) SetOTR_OT_USER(value uint32) {
	volatile.StoreUint32(&o.OTR.Reg, volatile.LoadUint32(&o.OTR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOTR_OT_USER() uint32 {
	return (volatile.LoadUint32(&o.OTR.Reg) & 0x80000000) >> 31
}
func (o *OPAMP_Type) SetOTR_AO3_OPT_OFFSET_TRIM(value uint32) {
	volatile.StoreUint32(&o.OTR.Reg, volatile.LoadUint32(&o.OTR.Reg)&^(0x3ff00000)|value<<20)
}
func (o *OPAMP_Type) GetOTR_AO3_OPT_OFFSET_TRIM() uint32 {
	return (volatile.LoadUint32(&o.OTR.Reg) & 0x3ff00000) >> 20
}
func (o *OPAMP_Type) SetOTR_AO2_OPT_OFFSET_TRIM(value uint32) {
	volatile.StoreUint32(&o.OTR.Reg, volatile.LoadUint32(&o.OTR.Reg)&^(0xffc00)|value<<10)
}
func (o *OPAMP_Type) GetOTR_AO2_OPT_OFFSET_TRIM() uint32 {
	return (volatile.LoadUint32(&o.OTR.Reg) & 0xffc00) >> 10
}
func (o *OPAMP_Type) SetOTR_AO1_OPT_OFFSET_TRIM(value uint32) {
	volatile.StoreUint32(&o.OTR.Reg, volatile.LoadUint32(&o.OTR.Reg)&^(0x3ff)|value)
}
func (o *OPAMP_Type) GetOTR_AO1_OPT_OFFSET_TRIM() uint32 {
	return volatile.LoadUint32(&o.OTR.Reg) & 0x3ff
}

// OPAMP.LPOTR: OPAMP offset trimming register for low power mode
func (o *OPAMP_Type) SetLPOTR_AO3_OPT_OFFSET_TRIM_LP(value uint32) {
	volatile.StoreUint32(&o.LPOTR.Reg, volatile.LoadUint32(&o.LPOTR.Reg)&^(0x3ff00000)|value<<20)
}
func (o *OPAMP_Type) GetLPOTR_AO3_OPT_OFFSET_TRIM_LP() uint32 {
	return (volatile.LoadUint32(&o.LPOTR.Reg) & 0x3ff00000) >> 20
}
func (o *OPAMP_Type) SetLPOTR_AO2_OPT_OFFSET_TRIM_LP(value uint32) {
	volatile.StoreUint32(&o.LPOTR.Reg, volatile.LoadUint32(&o.LPOTR.Reg)&^(0xffc00)|value<<10)
}
func (o *OPAMP_Type) GetLPOTR_AO2_OPT_OFFSET_TRIM_LP() uint32 {
	return (volatile.LoadUint32(&o.LPOTR.Reg) & 0xffc00) >> 10
}
func (o *OPAMP_Type) SetLPOTR_AO1_OPT_OFFSET_TRIM_LP(value uint32) {
	volatile.StoreUint32(&o.LPOTR.Reg, volatile.LoadUint32(&o.LPOTR.Reg)&^(0x3ff)|value)
}
func (o *OPAMP_Type) GetLPOTR_AO1_OPT_OFFSET_TRIM_LP() uint32 {
	return volatile.LoadUint32(&o.LPOTR.Reg) & 0x3ff
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// PWR.CR: power control register
func (o *PWR_Type) SetCR_LPRUN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCR_LPRUN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCR_VOS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800)|value<<11)
}
func (o *PWR_Type) GetCR_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800) >> 11
}
func (o *PWR_Type) SetCR_FWU(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR_FWU() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR_ULP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR_ULP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR_DBP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR_PLS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe0)|value<<5)
}
func (o *PWR_Type) GetCR_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe0) >> 5
}
func (o *PWR_Type) SetCR_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR_PVDE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR_CSBF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR_CSBF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR_CWUF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR_CWUF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR_PDDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR_PDDS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR_LPSDSR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR_LPSDSR() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// PWR.CSR: power control/status register
func (o *PWR_Type) SetCSR_EWUP3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCSR_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCSR_EWUP2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCSR_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCSR_EWUP1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCSR_EWUP1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCSR_REGLPF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCSR_REGLPF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCSR_VOSF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCSR_VOSF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCSR_VREFINTRDYF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCSR_VREFINTRDYF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCSR_PVDO(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCSR_PVDO() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCSR_SBF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCSR_SBF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCSR_WUF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCSR_WUF() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// Reset and clock control
type RCC_Type struct {
	CR        volatile.Register32 // 0x0
	ICSCR     volatile.Register32 // 0x4
	CFGR      volatile.Register32 // 0x8
	CIR       volatile.Register32 // 0xC
	AHBRSTR   volatile.Register32 // 0x10
	APB2RSTR  volatile.Register32 // 0x14
	APB1RSTR  volatile.Register32 // 0x18
	AHBENR    volatile.Register32 // 0x1C
	APB2ENR   volatile.Register32 // 0x20
	APB1ENR   volatile.Register32 // 0x24
	AHBLPENR  volatile.Register32 // 0x28
	APB2LPENR volatile.Register32 // 0x2C
	APB1LPENR volatile.Register32 // 0x30
	CSR       volatile.Register32 // 0x34
}

// RCC.CR: Clock control register
func (o *RCC_Type) SetCR_RTCPRE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCR_RTCPRE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCR_RTCPRE0(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCR_RTCPRE0() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_MSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCR_MSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCR_MSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCR_MSION() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// RCC.ICSCR: Internal clock sources calibration register
func (o *RCC_Type) SetICSCR_MSITRIM(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff000000)|value<<24)
}
func (o *RCC_Type) GetICSCR_MSITRIM() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0xff000000) >> 24
}
func (o *RCC_Type) SetICSCR_MSICAL(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff0000)|value<<16)
}
func (o *RCC_Type) GetICSCR_MSICAL() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0xff0000) >> 16
}
func (o *RCC_Type) SetICSCR_MSIRANGE(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xe000)|value<<13)
}
func (o *RCC_Type) GetICSCR_MSIRANGE() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0xe000) >> 13
}
func (o *RCC_Type) SetICSCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0x1f00)|value<<8)
}
func (o *RCC_Type) GetICSCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.ICSCR.Reg) & 0x1f00) >> 8
}
func (o *RCC_Type) SetICSCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.ICSCR.Reg, volatile.LoadUint32(&o.ICSCR.Reg)&^(0xff)|value)
}
func (o *RCC_Type) GetICSCR_HSICAL() uint32 {
	return volatile.LoadUint32(&o.ICSCR.Reg) & 0xff
}

// RCC.CFGR: Clock configuration register
func (o *RCC_Type) SetCFGR_MCOPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetCFGR_MCOPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetCFGR_MCOSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCOSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *RCC_Type) SetCFGR_PLLDIV(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetCFGR_PLLDIV() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetCFGR_PLLMUL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3c0000)|value<<18)
}
func (o *RCC_Type) GetCFGR_PLLMUL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3c0000) >> 18
}
func (o *RCC_Type) SetCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCFGR_PLLSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3800)|value<<11)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3800) >> 11
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x700)|value<<8)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x700) >> 8
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}

// RCC.CIR: Clock interrupt register
func (o *RCC_Type) SetCIR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCIR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCIR_MSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetCIR_MSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetCIR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetCIR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetCIR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCIR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCIR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCIR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCIR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCIR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCIR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCIR_LSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCIR_MSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetCIR_MSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetCIR_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCIR_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetCIR_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCIR_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCIR_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIR_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCIR_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIR_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIR_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIR_LSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIR_MSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIR_MSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIR.Reg) & 0x1
}

// RCC.AHBRSTR: AHB peripheral reset register
func (o *RCC_Type) SetAHBRSTR_FSMCRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHBRSTR_FSMCRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHBRSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHBRSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHBRSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHBRSTR_DMA1RST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHBRSTR_FLITFRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHBRSTR_FLITFRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHBRSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHBRSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHBRSTR_GPIOGRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHBRSTR_GPIOGRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHBRSTR_GPIOFRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHBRSTR_GPIOFRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHBRSTR_GPIOHRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHBRSTR_GPIOHRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHBRSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHBRSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHBRSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHBRSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHBRSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHBRSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHBRSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHBRSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHBRSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHBRSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x1
}

// RCC.APB2RSTR: APB2 peripheral reset register
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_SDIORST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_SDIORST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2RSTR_ADC1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2RSTR_ADC1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB2RSTR_TM11RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2RSTR_TM11RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2RSTR_TM10RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB2RSTR_TM10RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB2RSTR_TIM9RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB2RSTR_TIM9RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB2RSTR_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2RSTR_SYSCFGRST() uint32 {
	return volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1
}

// RCC.APB1RSTR: APB1 peripheral reset register
func (o *RCC_Type) SetAPB1RSTR_COMPRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1RSTR_COMPRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1RSTR_DACRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1RSTR_DACRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1RSTR_PWRRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1RSTR_PWRRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1RSTR_USBRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1RSTR_USBRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1RSTR_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1RSTR_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1RSTR_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR_UART5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1RSTR_UART5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1RSTR_UART4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1RSTR_UART4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1RSTR_USART3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1RSTR_USART3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1RSTR_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1RSTR_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1RSTR_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1RSTR_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1RSTR_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR_WWDRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1RSTR_WWDRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1RSTR_LCDRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1RSTR_LCDRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1RSTR_TIM7RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1RSTR_TIM7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1RSTR_TIM6RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1RSTR_TIM6RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1RSTR_TIM5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1RSTR_TIM5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1RSTR_TIM4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1RSTR_TIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1RSTR_TIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1RSTR_TIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1RSTR_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x1
}

// RCC.AHBENR: AHB peripheral clock enable register
func (o *RCC_Type) SetAHBENR_FSMCEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHBENR_FSMCEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHBENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHBENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHBENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHBENR_DMA1EN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHBENR_FLITFEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHBENR_FLITFEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHBENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHBENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHBENR_GPIOPGEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHBENR_GPIOPGEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHBENR_GPIOPFEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHBENR_GPIOPFEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHBENR_GPIOPHEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHBENR_GPIOPHEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHBENR_GPIOPEEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHBENR_GPIOPEEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHBENR_GPIOPDEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHBENR_GPIOPDEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHBENR_GPIOPCEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHBENR_GPIOPCEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHBENR_GPIOPBEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHBENR_GPIOPBEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHBENR_GPIOPAEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHBENR_GPIOPAEN() uint32 {
	return volatile.LoadUint32(&o.AHBENR.Reg) & 0x1
}

// RCC.APB2ENR: APB2 peripheral clock enable register
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2ENR_ADC1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2ENR_ADC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB2ENR_TIM11EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2ENR_TIM11EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2ENR_TIM10EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB2ENR_TIM10EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB2ENR_TIM9EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB2ENR_TIM9EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB2ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2ENR_SYSCFGEN() uint32 {
	return volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1
}

// RCC.APB1ENR: APB1 peripheral clock enable register
func (o *RCC_Type) SetAPB1ENR_COMPEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1ENR_COMPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1ENR_DACEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1ENR_DACEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1ENR_PWREN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1ENR_PWREN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1ENR_USBEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1ENR_USBEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1ENR_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1ENR_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1ENR_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR_USART5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1ENR_USART5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1ENR_USART4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1ENR_USART4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1ENR_USART3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1ENR_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1ENR_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1ENR_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1ENR_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1ENR_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1ENR_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR_LCDEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1ENR_LCDEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1ENR_TIM7EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1ENR_TIM7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1ENR_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1ENR_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1ENR_TIM5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1ENR_TIM5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1ENR_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1ENR_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1ENR_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1ENR_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1ENR_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR.Reg) & 0x1
}

// RCC.AHBLPENR: AHB peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHBLPENR_DMA2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAHBLPENR_DMA2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAHBLPENR_DMA1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHBLPENR_DMA1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHBLPENR_SRAMLPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHBLPENR_SRAMLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHBLPENR_FLITFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHBLPENR_FLITFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHBLPENR_CRCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHBLPENR_CRCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHBLPENR_GPIOGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHBLPENR_GPIOGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHBLPENR_GPIOFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHBLPENR_GPIOFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHBLPENR_GPIOHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHBLPENR_GPIOHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHBLPENR_GPIOELPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHBLPENR_GPIOELPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHBLPENR_GPIODLPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHBLPENR_GPIODLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHBLPENR_GPIOCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHBLPENR_GPIOCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHBLPENR_GPIOBLPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHBLPENR_GPIOBLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHBLPENR_GPIOALPEN(value uint32) {
	volatile.StoreUint32(&o.AHBLPENR.Reg, volatile.LoadUint32(&o.AHBLPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHBLPENR_GPIOALPEN() uint32 {
	return volatile.LoadUint32(&o.AHBLPENR.Reg) & 0x1
}

// RCC.APB2LPENR: APB2 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAPB2LPENR_USART1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2LPENR_USART1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2LPENR_SPI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2LPENR_SPI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2LPENR_SDIOLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2LPENR_SDIOLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2LPENR_ADC1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2LPENR_ADC1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB2LPENR_TIM11LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2LPENR_TIM11LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2LPENR_TIM10LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB2LPENR_TIM10LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB2LPENR_TIM9LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB2LPENR_TIM9LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB2LPENR_SYSCFGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2LPENR_SYSCFGLPEN() uint32 {
	return volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1
}

// RCC.APB1LPENR: APB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAPB1LPENR_COMPLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1LPENR_COMPLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1LPENR_DACLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1LPENR_DACLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1LPENR_PWRLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1LPENR_PWRLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1LPENR_USBLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1LPENR_USBLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1LPENR_I2C2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1LPENR_I2C2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1LPENR_I2C1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1LPENR_I2C1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1LPENR_USART3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1LPENR_USART3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1LPENR_USART2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1LPENR_USART2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1LPENR_SPI2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1LPENR_SPI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1LPENR_WWDGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1LPENR_WWDGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1LPENR_LCDLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1LPENR_LCDLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1LPENR_TIM7LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1LPENR_TIM7LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1LPENR_TIM6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1LPENR_TIM6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1LPENR_TIM4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1LPENR_TIM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1LPENR_TIM3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1LPENR_TIM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1LPENR_TIM2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1LPENR_TIM2LPEN() uint32 {
	return volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x1
}

// RCC.CSR: Control/status register
func (o *RCC_Type) SetCSR_LPWRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_IWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_IWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_PORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_PORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_PINRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PINRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCSR_RTCRST(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCSR_RTCRST() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCSR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetCSR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetCSR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetCSR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetCSR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCSR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCSR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCSR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCSR_LSEON(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCSR_LSEON() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// Routing interface
type RI_Type struct {
	_      [4]byte
	ICR    volatile.Register32 // 0x4
	ASCR1  volatile.Register32 // 0x8
	ASCR2  volatile.Register32 // 0xC
	HYSCR1 volatile.Register32 // 0x10
	HYSCR2 volatile.Register32 // 0x14
	HYSCR3 volatile.Register32 // 0x18
	HYSCR4 volatile.Register32 // 0x1C
}

// RI.ICR: RI input capture register
func (o *RI_Type) SetICR_IC4(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200000)|value<<21)
}
func (o *RI_Type) GetICR_IC4() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200000) >> 21
}
func (o *RI_Type) SetICR_IC3(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *RI_Type) GetICR_IC3() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}
func (o *RI_Type) SetICR_IC2(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80000)|value<<19)
}
func (o *RI_Type) GetICR_IC2() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80000) >> 19
}
func (o *RI_Type) SetICR_IC1(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40000)|value<<18)
}
func (o *RI_Type) GetICR_IC1() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40000) >> 18
}
func (o *RI_Type) SetICR_TIM(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x30000)|value<<16)
}
func (o *RI_Type) GetICR_TIM() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x30000) >> 16
}
func (o *RI_Type) SetICR_IC4IOS(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xf000)|value<<12)
}
func (o *RI_Type) GetICR_IC4IOS() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xf000) >> 12
}
func (o *RI_Type) SetICR_IC3IOS(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xf00)|value<<8)
}
func (o *RI_Type) GetICR_IC3IOS() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xf00) >> 8
}
func (o *RI_Type) SetICR_IC2IOS(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xf0)|value<<4)
}
func (o *RI_Type) GetICR_IC2IOS() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xf0) >> 4
}
func (o *RI_Type) SetICR_IC1IOS(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xf)|value)
}
func (o *RI_Type) GetICR_IC1IOS() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0xf
}

// RI.ASCR1: RI analog switches control register 1
func (o *RI_Type) SetASCR1_SCM(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x80000000)|value<<31)
}
func (o *RI_Type) GetASCR1_SCM() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x80000000) >> 31
}
func (o *RI_Type) SetASCR1_CH30GR11_4(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x40000000)|value<<30)
}
func (o *RI_Type) GetASCR1_CH30GR11_4() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x40000000) >> 30
}
func (o *RI_Type) SetASCR1_CH29GR11_3(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x20000000)|value<<29)
}
func (o *RI_Type) GetASCR1_CH29GR11_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x20000000) >> 29
}
func (o *RI_Type) SetASCR1_CH28GR11_2(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x10000000)|value<<28)
}
func (o *RI_Type) GetASCR1_CH28GR11_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x10000000) >> 28
}
func (o *RI_Type) SetASCR1_CH27GR11_1(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x8000000)|value<<27)
}
func (o *RI_Type) GetASCR1_CH27GR11_1() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x8000000) >> 27
}
func (o *RI_Type) SetASCR1_VCOMP(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x4000000)|value<<26)
}
func (o *RI_Type) GetASCR1_VCOMP() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x4000000) >> 26
}
func (o *RI_Type) SetASCR1_CH25(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x2000000)|value<<25)
}
func (o *RI_Type) GetASCR1_CH25() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x2000000) >> 25
}
func (o *RI_Type) SetASCR1_CH24(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RI_Type) GetASCR1_CH24() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x1000000) >> 24
}
func (o *RI_Type) SetASCR1_CH23(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x800000)|value<<23)
}
func (o *RI_Type) GetASCR1_CH23() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x800000) >> 23
}
func (o *RI_Type) SetASCR1_CH22(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x400000)|value<<22)
}
func (o *RI_Type) GetASCR1_CH22() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x400000) >> 22
}
func (o *RI_Type) SetASCR1_CH21GR7_4(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x200000)|value<<21)
}
func (o *RI_Type) GetASCR1_CH21GR7_4() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x200000) >> 21
}
func (o *RI_Type) SetASCR1_CH20GR7_3(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x100000)|value<<20)
}
func (o *RI_Type) GetASCR1_CH20GR7_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x100000) >> 20
}
func (o *RI_Type) SetASCR1_CH19GR7_2(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x80000)|value<<19)
}
func (o *RI_Type) GetASCR1_CH19GR7_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x80000) >> 19
}
func (o *RI_Type) SetASCR1_CH18GR7_1(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x40000)|value<<18)
}
func (o *RI_Type) GetASCR1_CH18GR7_1() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x40000) >> 18
}
func (o *RI_Type) SetASCR1_CH31GR7_1(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x10000)|value<<16)
}
func (o *RI_Type) GetASCR1_CH31GR7_1() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x10000) >> 16
}
func (o *RI_Type) SetASCR1_CH15GR9_2(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x8000)|value<<15)
}
func (o *RI_Type) GetASCR1_CH15GR9_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x8000) >> 15
}
func (o *RI_Type) SetASCR1_CH14GR9_1(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x4000)|value<<14)
}
func (o *RI_Type) GetASCR1_CH14GR9_1() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x4000) >> 14
}
func (o *RI_Type) SetASCR1_CH13GR8_4(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x2000)|value<<13)
}
func (o *RI_Type) GetASCR1_CH13GR8_4() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x2000) >> 13
}
func (o *RI_Type) SetASCR1_CH12GR8_3(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x1000)|value<<12)
}
func (o *RI_Type) GetASCR1_CH12GR8_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x1000) >> 12
}
func (o *RI_Type) SetASCR1_CH11GR8_2(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x800)|value<<11)
}
func (o *RI_Type) GetASCR1_CH11GR8_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x800) >> 11
}
func (o *RI_Type) SetASCR1_CH10GR8_1(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x400)|value<<10)
}
func (o *RI_Type) GetASCR1_CH10GR8_1() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x400) >> 10
}
func (o *RI_Type) SetASCR1_CH9GR3_2(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x200)|value<<9)
}
func (o *RI_Type) GetASCR1_CH9GR3_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x200) >> 9
}
func (o *RI_Type) SetASCR1_CH8GR3_1(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x100)|value<<8)
}
func (o *RI_Type) GetASCR1_CH8GR3_1() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x100) >> 8
}
func (o *RI_Type) SetASCR1_CH7GR2_2(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x80)|value<<7)
}
func (o *RI_Type) GetASCR1_CH7GR2_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x80) >> 7
}
func (o *RI_Type) SetASCR1_CH6GR2_1(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x40)|value<<6)
}
func (o *RI_Type) GetASCR1_CH6GR2_1() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x40) >> 6
}
func (o *RI_Type) SetASCR1_COMP1_SW1(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x20)|value<<5)
}
func (o *RI_Type) GetASCR1_COMP1_SW1() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x20) >> 5
}
func (o *RI_Type) SetASCR1_CH31GR11_5(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x10)|value<<4)
}
func (o *RI_Type) GetASCR1_CH31GR11_5() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x10) >> 4
}
func (o *RI_Type) SetASCR1_CH3GR1_4(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x8)|value<<3)
}
func (o *RI_Type) GetASCR1_CH3GR1_4() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x8) >> 3
}
func (o *RI_Type) SetASCR1_CH2GR1_3(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x4)|value<<2)
}
func (o *RI_Type) GetASCR1_CH2GR1_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x4) >> 2
}
func (o *RI_Type) SetASCR1_CH1GR1_2(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x2)|value<<1)
}
func (o *RI_Type) GetASCR1_CH1GR1_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR1.Reg) & 0x2) >> 1
}
func (o *RI_Type) SetASCR1_CH0GR1_1(value uint32) {
	volatile.StoreUint32(&o.ASCR1.Reg, volatile.LoadUint32(&o.ASCR1.Reg)&^(0x1)|value)
}
func (o *RI_Type) GetASCR1_CH0GR1_1() uint32 {
	return volatile.LoadUint32(&o.ASCR1.Reg) & 0x1
}

// RI.ASCR2: RI analog switches control register 2
func (o *RI_Type) SetASCR2_GR5_4(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x20000000)|value<<29)
}
func (o *RI_Type) GetASCR2_GR5_4() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x20000000) >> 29
}
func (o *RI_Type) SetASCR2_GR6_4(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x10000000)|value<<28)
}
func (o *RI_Type) GetASCR2_GR6_4() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x10000000) >> 28
}
func (o *RI_Type) SetASCR2_GR6_3(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x8000000)|value<<27)
}
func (o *RI_Type) GetASCR2_GR6_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x8000000) >> 27
}
func (o *RI_Type) SetASCR2_GR7_7(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x4000000)|value<<26)
}
func (o *RI_Type) GetASCR2_GR7_7() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x4000000) >> 26
}
func (o *RI_Type) SetASCR2_GR7_6(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x2000000)|value<<25)
}
func (o *RI_Type) GetASCR2_GR7_6() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x2000000) >> 25
}
func (o *RI_Type) SetASCR2_GR7_5(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x1000000)|value<<24)
}
func (o *RI_Type) GetASCR2_GR7_5() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x1000000) >> 24
}
func (o *RI_Type) SetASCR2_GR2_5(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x800000)|value<<23)
}
func (o *RI_Type) GetASCR2_GR2_5() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x800000) >> 23
}
func (o *RI_Type) SetASCR2_GR2_4(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x400000)|value<<22)
}
func (o *RI_Type) GetASCR2_GR2_4() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x400000) >> 22
}
func (o *RI_Type) SetASCR2_GR2_3(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x200000)|value<<21)
}
func (o *RI_Type) GetASCR2_GR2_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x200000) >> 21
}
func (o *RI_Type) SetASCR2_GR9_4(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x100000)|value<<20)
}
func (o *RI_Type) GetASCR2_GR9_4() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x100000) >> 20
}
func (o *RI_Type) SetASCR2_GR9_3(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x80000)|value<<19)
}
func (o *RI_Type) GetASCR2_GR9_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x80000) >> 19
}
func (o *RI_Type) SetASCR2_GR3_5(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x40000)|value<<18)
}
func (o *RI_Type) GetASCR2_GR3_5() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x40000) >> 18
}
func (o *RI_Type) SetASCR2_GR3_4(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x20000)|value<<17)
}
func (o *RI_Type) GetASCR2_GR3_4() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x20000) >> 17
}
func (o *RI_Type) SetASCR2_GR3_3(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x10000)|value<<16)
}
func (o *RI_Type) GetASCR2_GR3_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x10000) >> 16
}
func (o *RI_Type) SetASCR2_GR4_3(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x800)|value<<11)
}
func (o *RI_Type) GetASCR2_GR4_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x800) >> 11
}
func (o *RI_Type) SetASCR2_GR4_2(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x400)|value<<10)
}
func (o *RI_Type) GetASCR2_GR4_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x400) >> 10
}
func (o *RI_Type) SetASCR2_GR4_1(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x200)|value<<9)
}
func (o *RI_Type) GetASCR2_GR4_1() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x200) >> 9
}
func (o *RI_Type) SetASCR2_GR5_3(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x100)|value<<8)
}
func (o *RI_Type) GetASCR2_GR5_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x100) >> 8
}
func (o *RI_Type) SetASCR2_GR5_2(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x80)|value<<7)
}
func (o *RI_Type) GetASCR2_GR5_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x80) >> 7
}
func (o *RI_Type) SetASCR2_GR5_1(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x40)|value<<6)
}
func (o *RI_Type) GetASCR2_GR5_1() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x40) >> 6
}
func (o *RI_Type) SetASCR2_GR6_2(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x20)|value<<5)
}
func (o *RI_Type) GetASCR2_GR6_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x20) >> 5
}
func (o *RI_Type) SetASCR2_GR6_1(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x10)|value<<4)
}
func (o *RI_Type) GetASCR2_GR6_1() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x10) >> 4
}
func (o *RI_Type) SetASCR2_GR10_4(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x8)|value<<3)
}
func (o *RI_Type) GetASCR2_GR10_4() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x8) >> 3
}
func (o *RI_Type) SetASCR2_GR10_3(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x4)|value<<2)
}
func (o *RI_Type) GetASCR2_GR10_3() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x4) >> 2
}
func (o *RI_Type) SetASCR2_GR10_2(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x2)|value<<1)
}
func (o *RI_Type) GetASCR2_GR10_2() uint32 {
	return (volatile.LoadUint32(&o.ASCR2.Reg) & 0x2) >> 1
}
func (o *RI_Type) SetASCR2_GR10_1(value uint32) {
	volatile.StoreUint32(&o.ASCR2.Reg, volatile.LoadUint32(&o.ASCR2.Reg)&^(0x1)|value)
}
func (o *RI_Type) GetASCR2_GR10_1() uint32 {
	return volatile.LoadUint32(&o.ASCR2.Reg) & 0x1
}

// RI.HYSCR1: RI hysteresis control register 1
func (o *RI_Type) SetHYSCR1_PB(value uint32) {
	volatile.StoreUint32(&o.HYSCR1.Reg, volatile.LoadUint32(&o.HYSCR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *RI_Type) GetHYSCR1_PB() uint32 {
	return (volatile.LoadUint32(&o.HYSCR1.Reg) & 0xffff0000) >> 16
}
func (o *RI_Type) SetHYSCR1_PA(value uint32) {
	volatile.StoreUint32(&o.HYSCR1.Reg, volatile.LoadUint32(&o.HYSCR1.Reg)&^(0xffff)|value)
}
func (o *RI_Type) GetHYSCR1_PA() uint32 {
	return volatile.LoadUint32(&o.HYSCR1.Reg) & 0xffff
}

// RI.HYSCR2: RI hysteresis control register 2
func (o *RI_Type) SetHYSCR2_PD(value uint32) {
	volatile.StoreUint32(&o.HYSCR2.Reg, volatile.LoadUint32(&o.HYSCR2.Reg)&^(0xffff0000)|value<<16)
}
func (o *RI_Type) GetHYSCR2_PD() uint32 {
	return (volatile.LoadUint32(&o.HYSCR2.Reg) & 0xffff0000) >> 16
}
func (o *RI_Type) SetHYSCR2_PC(value uint32) {
	volatile.StoreUint32(&o.HYSCR2.Reg, volatile.LoadUint32(&o.HYSCR2.Reg)&^(0xffff)|value)
}
func (o *RI_Type) GetHYSCR2_PC() uint32 {
	return volatile.LoadUint32(&o.HYSCR2.Reg) & 0xffff
}

// RI.HYSCR3: RI hysteresis control register 3
func (o *RI_Type) SetHYSCR3_PF(value uint32) {
	volatile.StoreUint32(&o.HYSCR3.Reg, volatile.LoadUint32(&o.HYSCR3.Reg)&^(0xffff0000)|value<<16)
}
func (o *RI_Type) GetHYSCR3_PF() uint32 {
	return (volatile.LoadUint32(&o.HYSCR3.Reg) & 0xffff0000) >> 16
}
func (o *RI_Type) SetHYSCR3_PE(value uint32) {
	volatile.StoreUint32(&o.HYSCR3.Reg, volatile.LoadUint32(&o.HYSCR3.Reg)&^(0xffff)|value)
}
func (o *RI_Type) GetHYSCR3_PE() uint32 {
	return volatile.LoadUint32(&o.HYSCR3.Reg) & 0xffff
}

// RI.HYSCR4: Hysteresis control register
func (o *RI_Type) SetHYSCR4_PG(value uint32) {
	volatile.StoreUint32(&o.HYSCR4.Reg, volatile.LoadUint32(&o.HYSCR4.Reg)&^(0xffff)|value)
}
func (o *RI_Type) GetHYSCR4_PG() uint32 {
	return volatile.LoadUint32(&o.HYSCR4.Reg) & 0xffff
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	CALIBR   volatile.Register32 // 0x18
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	_        [4]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// RTC.TR: time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.CR: control register
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_DCE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCR_DCE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}

// RTC.ISR: initialization and status register
func (o *RTC_Type) SetISR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetISR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetISR_TAMP3F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetISR_TAMP3F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetISR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetISR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetISR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetISR_TAMP1F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetISR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetISR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetISR_TSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetISR_TSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetISR_WUTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetISR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetISR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetISR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetISR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetISR_ALRAF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetISR_INIT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetISR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetISR_INITF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetISR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetISR_RSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetISR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetISR_INITS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetISR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetISR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetISR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetISR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetISR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetISR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetISR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetISR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetISR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// RTC.PRER: prescaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}

// RTC.WUTR: wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.CALIBR: calibration register
func (o *RTC_Type) SetCALIBR_DCS(value uint32) {
	volatile.StoreUint32(&o.CALIBR.Reg, volatile.LoadUint32(&o.CALIBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCALIBR_DCS() uint32 {
	return (volatile.LoadUint32(&o.CALIBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCALIBR_DC(value uint32) {
	volatile.StoreUint32(&o.CALIBR.Reg, volatile.LoadUint32(&o.CALIBR.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetCALIBR_DC() uint32 {
	return volatile.LoadUint32(&o.CALIBR.Reg) & 0x1f
}

// RTC.ALRMAR: alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMBR: alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.WPR: write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.SSR: sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.SHIFTR: shift control register
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}

// RTC.TSTR: TSTR
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}

// RTC.TSDR: time stamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TSSSR: timestamp sub second register
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.CALR: calibration register
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}

// RTC.TAFCR: tamper and alternate function configuration register
func (o *RTC_Type) SetTAFCR_ALARMOUTTYPE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetTAFCR_ALARMOUTTYPE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetTAFCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTAFCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTAFCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x6000)|value<<13)
}
func (o *RTC_Type) GetTAFCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x6000) >> 13
}
func (o *RTC_Type) SetTAFCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x1800)|value<<11)
}
func (o *RTC_Type) GetTAFCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x1800) >> 11
}
func (o *RTC_Type) SetTAFCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x700)|value<<8)
}
func (o *RTC_Type) GetTAFCR_TAMPFREQ() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x700) >> 8
}
func (o *RTC_Type) SetTAFCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTAFCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTAFCR_TAMP3TRG(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetTAFCR_TAMP3TRG() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetTAFCR_TAMP3E(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetTAFCR_TAMP3E() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetTAFCR_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetTAFCR_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetTAFCR_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetTAFCR_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetTAFCR_TAMPIE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetTAFCR_TAMPIE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetTAFCR_TAMP1ETRG(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetTAFCR_TAMP1ETRG() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetTAFCR_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTAFCR_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.TAFCR.Reg) & 0x1
}

// RTC.ALRMASSR: alarm A sub second register
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}

// RTC.ALRMBSSR: alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}

// RTC.BKP0R: backup register
func (o *RTC_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *RTC_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// RTC.BKP1R: backup register
func (o *RTC_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *RTC_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// RTC.BKP2R: backup register
func (o *RTC_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *RTC_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// RTC.BKP3R: backup register
func (o *RTC_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *RTC_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// RTC.BKP4R: backup register
func (o *RTC_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *RTC_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// RTC.BKP5R: backup register
func (o *RTC_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *RTC_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// RTC.BKP6R: backup register
func (o *RTC_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *RTC_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// RTC.BKP7R: backup register
func (o *RTC_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *RTC_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// RTC.BKP8R: backup register
func (o *RTC_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *RTC_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// RTC.BKP9R: backup register
func (o *RTC_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *RTC_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// RTC.BKP10R: backup register
func (o *RTC_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *RTC_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// RTC.BKP11R: backup register
func (o *RTC_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *RTC_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// RTC.BKP12R: backup register
func (o *RTC_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *RTC_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// RTC.BKP13R: backup register
func (o *RTC_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *RTC_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// RTC.BKP14R: backup register
func (o *RTC_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *RTC_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// RTC.BKP15R: backup register
func (o *RTC_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *RTC_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// RTC.BKP16R: backup register
func (o *RTC_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *RTC_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// RTC.BKP17R: backup register
func (o *RTC_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *RTC_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// RTC.BKP18R: backup register
func (o *RTC_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *RTC_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// RTC.BKP19R: backup register
func (o *RTC_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *RTC_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// RTC.BKP20R: backup register
func (o *RTC_Type) SetBKP20R(value uint32) {
	volatile.StoreUint32(&o.BKP20R.Reg, value)
}
func (o *RTC_Type) GetBKP20R() uint32 {
	return volatile.LoadUint32(&o.BKP20R.Reg)
}

// RTC.BKP21R: backup register
func (o *RTC_Type) SetBKP21R(value uint32) {
	volatile.StoreUint32(&o.BKP21R.Reg, value)
}
func (o *RTC_Type) GetBKP21R() uint32 {
	return volatile.LoadUint32(&o.BKP21R.Reg)
}

// RTC.BKP22R: backup register
func (o *RTC_Type) SetBKP22R(value uint32) {
	volatile.StoreUint32(&o.BKP22R.Reg, value)
}
func (o *RTC_Type) GetBKP22R() uint32 {
	return volatile.LoadUint32(&o.BKP22R.Reg)
}

// RTC.BKP23R: backup register
func (o *RTC_Type) SetBKP23R(value uint32) {
	volatile.StoreUint32(&o.BKP23R.Reg, value)
}
func (o *RTC_Type) GetBKP23R() uint32 {
	return volatile.LoadUint32(&o.BKP23R.Reg)
}

// RTC.BKP24R: backup register
func (o *RTC_Type) SetBKP24R(value uint32) {
	volatile.StoreUint32(&o.BKP24R.Reg, value)
}
func (o *RTC_Type) GetBKP24R() uint32 {
	return volatile.LoadUint32(&o.BKP24R.Reg)
}

// RTC.BKP25R: backup register
func (o *RTC_Type) SetBKP25R(value uint32) {
	volatile.StoreUint32(&o.BKP25R.Reg, value)
}
func (o *RTC_Type) GetBKP25R() uint32 {
	return volatile.LoadUint32(&o.BKP25R.Reg)
}

// RTC.BKP26R: backup register
func (o *RTC_Type) SetBKP26R(value uint32) {
	volatile.StoreUint32(&o.BKP26R.Reg, value)
}
func (o *RTC_Type) GetBKP26R() uint32 {
	return volatile.LoadUint32(&o.BKP26R.Reg)
}

// RTC.BKP27R: backup register
func (o *RTC_Type) SetBKP27R(value uint32) {
	volatile.StoreUint32(&o.BKP27R.Reg, value)
}
func (o *RTC_Type) GetBKP27R() uint32 {
	return volatile.LoadUint32(&o.BKP27R.Reg)
}

// RTC.BKP28R: backup register
func (o *RTC_Type) SetBKP28R(value uint32) {
	volatile.StoreUint32(&o.BKP28R.Reg, value)
}
func (o *RTC_Type) GetBKP28R() uint32 {
	return volatile.LoadUint32(&o.BKP28R.Reg)
}

// RTC.BKP29R: backup register
func (o *RTC_Type) SetBKP29R(value uint32) {
	volatile.StoreUint32(&o.BKP29R.Reg, value)
}
func (o *RTC_Type) GetBKP29R() uint32 {
	return volatile.LoadUint32(&o.BKP29R.Reg)
}

// RTC.BKP30R: backup register
func (o *RTC_Type) SetBKP30R(value uint32) {
	volatile.StoreUint32(&o.BKP30R.Reg, value)
}
func (o *RTC_Type) GetBKP30R() uint32 {
	return volatile.LoadUint32(&o.BKP30R.Reg)
}

// RTC.BKP31R: backup register
func (o *RTC_Type) SetBKP31R(value uint32) {
	volatile.StoreUint32(&o.BKP31R.Reg, value)
}
func (o *RTC_Type) GetBKP31R() uint32 {
	return volatile.LoadUint32(&o.BKP31R.Reg)
}

// Secure digital input/output interface
type SDIO_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// SDIO.POWER: power control register
func (o *SDIO_Type) SetPOWER_PWRCTRL(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x3)|value)
}
func (o *SDIO_Type) GetPOWER_PWRCTRL() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x3
}

// SDIO.CLKCR: SDI clock control register
func (o *SDIO_Type) SetCLKCR_HWFC_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetCLKCR_HWFC_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetCLKCR_NEGEDGE(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetCLKCR_NEGEDGE() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetCLKCR_WIDBUS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x1800)|value<<11)
}
func (o *SDIO_Type) GetCLKCR_WIDBUS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x1800) >> 11
}
func (o *SDIO_Type) SetCLKCR_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetCLKCR_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetCLKCR_PWRSAV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetCLKCR_PWRSAV() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetCLKCR_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetCLKCR_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetCLKCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0xff)|value)
}
func (o *SDIO_Type) GetCLKCR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKCR.Reg) & 0xff
}

// SDIO.ARG: argument register
func (o *SDIO_Type) SetARG(value uint32) {
	volatile.StoreUint32(&o.ARG.Reg, value)
}
func (o *SDIO_Type) GetARG() uint32 {
	return volatile.LoadUint32(&o.ARG.Reg)
}

// SDIO.CMD: command register
func (o *SDIO_Type) SetCMD_CE_ATACMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetCMD_CE_ATACMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetCMD_NIEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetCMD_NIEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetCMD_ENCMDcompl(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetCMD_ENCMDcompl() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetCMD_SDIOSuspend(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetCMD_SDIOSuspend() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetCMD_CPSMEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetCMD_CPSMEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetCMD_WAITPEND(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetCMD_WAITPEND() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetCMD_WAITINT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetCMD_WAITINT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetCMD_WAITRESP(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xc0)|value<<6)
}
func (o *SDIO_Type) GetCMD_WAITRESP() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xc0) >> 6
}
func (o *SDIO_Type) SetCMD_CMDINDEX(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3f)|value)
}
func (o *SDIO_Type) GetCMD_CMDINDEX() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x3f
}

// SDIO.RESPCMD: command response register
func (o *SDIO_Type) SetRESPCMD(value uint32) {
	volatile.StoreUint32(&o.RESPCMD.Reg, volatile.LoadUint32(&o.RESPCMD.Reg)&^(0x3f)|value)
}
func (o *SDIO_Type) GetRESPCMD() uint32 {
	return volatile.LoadUint32(&o.RESPCMD.Reg) & 0x3f
}

// SDIO.RESP1: response 1..4 register
func (o *SDIO_Type) SetRESP1(value uint32) {
	volatile.StoreUint32(&o.RESP1.Reg, value)
}
func (o *SDIO_Type) GetRESP1() uint32 {
	return volatile.LoadUint32(&o.RESP1.Reg)
}

// SDIO.RESP2: response 1..4 register
func (o *SDIO_Type) SetRESP2(value uint32) {
	volatile.StoreUint32(&o.RESP2.Reg, value)
}
func (o *SDIO_Type) GetRESP2() uint32 {
	return volatile.LoadUint32(&o.RESP2.Reg)
}

// SDIO.RESP3: response 1..4 register
func (o *SDIO_Type) SetRESP3(value uint32) {
	volatile.StoreUint32(&o.RESP3.Reg, value)
}
func (o *SDIO_Type) GetRESP3() uint32 {
	return volatile.LoadUint32(&o.RESP3.Reg)
}

// SDIO.RESP4: response 1..4 register
func (o *SDIO_Type) SetRESP4(value uint32) {
	volatile.StoreUint32(&o.RESP4.Reg, value)
}
func (o *SDIO_Type) GetRESP4() uint32 {
	return volatile.LoadUint32(&o.RESP4.Reg)
}

// SDIO.DTIMER: data timer register
func (o *SDIO_Type) SetDTIMER(value uint32) {
	volatile.StoreUint32(&o.DTIMER.Reg, value)
}
func (o *SDIO_Type) GetDTIMER() uint32 {
	return volatile.LoadUint32(&o.DTIMER.Reg)
}

// SDIO.DLEN: data length register
func (o *SDIO_Type) SetDLEN_DATALENGTH(value uint32) {
	volatile.StoreUint32(&o.DLEN.Reg, volatile.LoadUint32(&o.DLEN.Reg)&^(0x1ffffff)|value)
}
func (o *SDIO_Type) GetDLEN_DATALENGTH() uint32 {
	return volatile.LoadUint32(&o.DLEN.Reg) & 0x1ffffff
}

// SDIO.DCTRL: data control register
func (o *SDIO_Type) SetDCTRL_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetDCTRL_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetDCTRL_RWMOD(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetDCTRL_RWMOD() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetDCTRL_RWSTOP(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetDCTRL_RWSTOP() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetDCTRL_RWSTART(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetDCTRL_RWSTART() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetDCTRL_DBLOCKSIZE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0xf0)|value<<4)
}
func (o *SDIO_Type) GetDCTRL_DBLOCKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0xf0) >> 4
}
func (o *SDIO_Type) SetDCTRL_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetDCTRL_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetDCTRL_DTMODE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetDCTRL_DTMODE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetDCTRL_DTDIR(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetDCTRL_DTDIR() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetDCTRL_DTEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetDCTRL_DTEN() uint32 {
	return volatile.LoadUint32(&o.DCTRL.Reg) & 0x1
}

// SDIO.DCOUNT: data counter register
func (o *SDIO_Type) SetDCOUNT_DATACOUNT(value uint32) {
	volatile.StoreUint32(&o.DCOUNT.Reg, volatile.LoadUint32(&o.DCOUNT.Reg)&^(0x1ffffff)|value)
}
func (o *SDIO_Type) GetDCOUNT_DATACOUNT() uint32 {
	return volatile.LoadUint32(&o.DCOUNT.Reg) & 0x1ffffff
}

// SDIO.STA: status register
func (o *SDIO_Type) SetSTA_CEATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetSTA_CEATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetSTA_SDIOIT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetSTA_SDIOIT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetSTA_RXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200000)|value<<21)
}
func (o *SDIO_Type) GetSTA_RXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200000) >> 21
}
func (o *SDIO_Type) SetSTA_TXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100000)|value<<20)
}
func (o *SDIO_Type) GetSTA_TXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100000) >> 20
}
func (o *SDIO_Type) SetSTA_RXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80000)|value<<19)
}
func (o *SDIO_Type) GetSTA_RXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80000) >> 19
}
func (o *SDIO_Type) SetSTA_TXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40000)|value<<18)
}
func (o *SDIO_Type) GetSTA_TXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40000) >> 18
}
func (o *SDIO_Type) SetSTA_RXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20000)|value<<17)
}
func (o *SDIO_Type) GetSTA_RXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20000) >> 17
}
func (o *SDIO_Type) SetSTA_TXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10000)|value<<16)
}
func (o *SDIO_Type) GetSTA_TXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10000) >> 16
}
func (o *SDIO_Type) SetSTA_RXFIFOHF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8000)|value<<15)
}
func (o *SDIO_Type) GetSTA_RXFIFOHF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8000) >> 15
}
func (o *SDIO_Type) SetSTA_TXFIFOHE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetSTA_TXFIFOHE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetSTA_RXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetSTA_RXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetSTA_TXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetSTA_TXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetSTA_CMDACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetSTA_CMDACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetSTA_DBCKEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetSTA_DBCKEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetSTA_STBITERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetSTA_STBITERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetSTA_DATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetSTA_DATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetSTA_CMDSENT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetSTA_CMDSENT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetSTA_CMDREND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetSTA_CMDREND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetSTA_RXOVERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetSTA_RXOVERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetSTA_TXUNDERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetSTA_TXUNDERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetSTA_DTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetSTA_DTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetSTA_CTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetSTA_CTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetSTA_DCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetSTA_DCRCFAIL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetSTA_CCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetSTA_CCRCFAIL() uint32 {
	return volatile.LoadUint32(&o.STA.Reg) & 0x1
}

// SDIO.ICR: interrupt clear register
func (o *SDIO_Type) SetICR_CEATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetICR_CEATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetICR_SDIOITC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetICR_SDIOITC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetICR_DBCKENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetICR_DBCKENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetICR_STBITERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetICR_STBITERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetICR_DATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetICR_DATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetICR_CMDSENTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetICR_CMDSENTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetICR_CMDRENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetICR_CMDRENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetICR_RXOVERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetICR_RXOVERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetICR_TXUNDERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetICR_TXUNDERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetICR_DTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetICR_DTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetICR_CTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetICR_CTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetICR_DCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetICR_DCRCFAILC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetICR_CCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetICR_CCRCFAILC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// SDIO.MASK: mask register
func (o *SDIO_Type) SetMASK_CEATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800000)|value<<23)
}
func (o *SDIO_Type) GetMASK_CEATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800000) >> 23
}
func (o *SDIO_Type) SetMASK_SDIOITIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400000)|value<<22)
}
func (o *SDIO_Type) GetMASK_SDIOITIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400000) >> 22
}
func (o *SDIO_Type) SetMASK_RXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200000)|value<<21)
}
func (o *SDIO_Type) GetMASK_RXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200000) >> 21
}
func (o *SDIO_Type) SetMASK_TXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100000)|value<<20)
}
func (o *SDIO_Type) GetMASK_TXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100000) >> 20
}
func (o *SDIO_Type) SetMASK_RXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80000)|value<<19)
}
func (o *SDIO_Type) GetMASK_RXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80000) >> 19
}
func (o *SDIO_Type) SetMASK_TXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40000)|value<<18)
}
func (o *SDIO_Type) GetMASK_TXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40000) >> 18
}
func (o *SDIO_Type) SetMASK_RXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20000)|value<<17)
}
func (o *SDIO_Type) GetMASK_RXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20000) >> 17
}
func (o *SDIO_Type) SetMASK_TXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10000)|value<<16)
}
func (o *SDIO_Type) GetMASK_TXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10000) >> 16
}
func (o *SDIO_Type) SetMASK_RXFIFOHFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8000)|value<<15)
}
func (o *SDIO_Type) GetMASK_RXFIFOHFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8000) >> 15
}
func (o *SDIO_Type) SetMASK_TXFIFOHEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4000)|value<<14)
}
func (o *SDIO_Type) GetMASK_TXFIFOHEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4000) >> 14
}
func (o *SDIO_Type) SetMASK_RXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2000)|value<<13)
}
func (o *SDIO_Type) GetMASK_RXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2000) >> 13
}
func (o *SDIO_Type) SetMASK_TXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1000)|value<<12)
}
func (o *SDIO_Type) GetMASK_TXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x1000) >> 12
}
func (o *SDIO_Type) SetMASK_CMDACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800)|value<<11)
}
func (o *SDIO_Type) GetMASK_CMDACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800) >> 11
}
func (o *SDIO_Type) SetMASK_DBCKENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400)|value<<10)
}
func (o *SDIO_Type) GetMASK_DBCKENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400) >> 10
}
func (o *SDIO_Type) SetMASK_STBITERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200)|value<<9)
}
func (o *SDIO_Type) GetMASK_STBITERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200) >> 9
}
func (o *SDIO_Type) SetMASK_DATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100)|value<<8)
}
func (o *SDIO_Type) GetMASK_DATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100) >> 8
}
func (o *SDIO_Type) SetMASK_CMDSENTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80)|value<<7)
}
func (o *SDIO_Type) GetMASK_CMDSENTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80) >> 7
}
func (o *SDIO_Type) SetMASK_CMDRENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40)|value<<6)
}
func (o *SDIO_Type) GetMASK_CMDRENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40) >> 6
}
func (o *SDIO_Type) SetMASK_RXOVERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20)|value<<5)
}
func (o *SDIO_Type) GetMASK_RXOVERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20) >> 5
}
func (o *SDIO_Type) SetMASK_TXUNDERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10)|value<<4)
}
func (o *SDIO_Type) GetMASK_TXUNDERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10) >> 4
}
func (o *SDIO_Type) SetMASK_DTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8)|value<<3)
}
func (o *SDIO_Type) GetMASK_DTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8) >> 3
}
func (o *SDIO_Type) SetMASK_CTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4)|value<<2)
}
func (o *SDIO_Type) GetMASK_CTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4) >> 2
}
func (o *SDIO_Type) SetMASK_DCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2)|value<<1)
}
func (o *SDIO_Type) GetMASK_DCRCFAILIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2) >> 1
}
func (o *SDIO_Type) SetMASK_CCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1)|value)
}
func (o *SDIO_Type) GetMASK_CCRCFAILIE() uint32 {
	return volatile.LoadUint32(&o.MASK.Reg) & 0x1
}

// SDIO.FIFOCNT: FIFO counter register
func (o *SDIO_Type) SetFIFOCNT_FIFOCOUNT(value uint32) {
	volatile.StoreUint32(&o.FIFOCNT.Reg, volatile.LoadUint32(&o.FIFOCNT.Reg)&^(0xffffff)|value)
}
func (o *SDIO_Type) GetFIFOCNT_FIFOCOUNT() uint32 {
	return volatile.LoadUint32(&o.FIFOCNT.Reg) & 0xffffff
}

// SDIO.FIFO: data FIFO register
func (o *SDIO_Type) SetFIFO(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, value)
}
func (o *SDIO_Type) GetFIFO() uint32 {
	return volatile.LoadUint32(&o.FIFO.Reg)
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_DFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_DFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_TIFRFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_TIFRFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_CHSIDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_CHSIDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// SPI.I2SCFGR: I2S configuration register
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetI2SCFGR_I2SE(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_I2SE() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x6)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x6) >> 1
}
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint32 {
	return volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1
}

// SPI.I2SPR: I2S prescaler register
func (o *SPI_Type) SetI2SPR_MCKOE(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetI2SPR_MCKOE() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetI2SPR_ODD(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetI2SPR_ODD() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetI2SPR_I2SDIV(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetI2SPR_I2SDIV() uint32 {
	return volatile.LoadUint32(&o.I2SPR.Reg) & 0xff
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
}

// SYSCFG.MEMRMP: memory remap register
func (o *SYSCFG_Type) SetMEMRMP_MEM_MODE(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x3)|value)
}
func (o *SYSCFG_Type) GetMEMRMP_MEM_MODE() uint32 {
	return volatile.LoadUint32(&o.MEMRMP.Reg) & 0x3
}
func (o *SYSCFG_Type) SetMEMRMP_BOOT_MODE(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x300)|value<<8)
}
func (o *SYSCFG_Type) GetMEMRMP_BOOT_MODE() uint32 {
	return (volatile.LoadUint32(&o.MEMRMP.Reg) & 0x300) >> 8
}

// SYSCFG.PMC: peripheral mode configuration register
func (o *SYSCFG_Type) SetPMC_USB_PU(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetPMC_USB_PU() uint32 {
	return volatile.LoadUint32(&o.PMC.Reg) & 0x1
}
func (o *SYSCFG_Type) SetPMC_LCD_CAPA(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x3e)|value<<1)
}
func (o *SYSCFG_Type) GetPMC_LCD_CAPA() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x3e) >> 1
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf
}

// General-purpose timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	_            [4]byte
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	_            [20]byte
	OR           volatile.Register32 // 0x50
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}

// TIM.CR2: TIM10 control register 2
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}

// TIM.SMCR: TIM10 slave mode control register
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}

// TIM.DIER: Interrupt enable register
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}

// TIM.CCMR1_Output: capture/compare mode register
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIM.CCR1: capture/compare register
func (o *TIM_Type) SetCCR1_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR1_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIM.CCR2: capture/compare register
func (o *TIM_Type) SetCCR2_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR2_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIM.OR: option register
func (o *TIM_Type) SetOR_TI1_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetOR_TI1_RMP() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x3
}
func (o *TIM_Type) SetOR_ETR_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetOR_ETR_RMP() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetOR_TI1_RMP_RI(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetOR_TI1_RMP_RI() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x8) >> 3
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	SR   volatile.Register32 // 0x0
	DR   volatile.Register32 // 0x4
	BRR  volatile.Register32 // 0x8
	CR1  volatile.Register32 // 0xC
	CR2  volatile.Register32 // 0x10
	CR3  volatile.Register32 // 0x14
	GTPR volatile.Register32 // 0x18
}

// USART.SR: Status register
func (o *USART_Type) SetSR_CTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetSR_LBD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetSR_LBD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetSR_TC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetSR_TC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetSR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetSR_IDLE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetSR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetSR_ORE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetSR_ORE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetSR_NF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetSR_NF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetSR_FE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetSR_FE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetSR_PE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetSR_PE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// USART.DR: Data register
func (o *USART_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0x1ff
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR_DIV_Mantissa(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xfff0)|value<<4)
}
func (o *USART_Type) GetBRR_DIV_Mantissa() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0xfff0) >> 4
}
func (o *USART_Type) SetBRR_DIV_Fraction(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetBRR_DIV_Fraction() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xf
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_RWU(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_RWU() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_SBK(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_SBK() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0xf
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// Universal serial bus full-speed device interface
type USB_Type struct {
	EP0R   volatile.Register32 // 0x0
	EP1R   volatile.Register32 // 0x4
	EP2R   volatile.Register32 // 0x8
	EP3R   volatile.Register32 // 0xC
	EP4R   volatile.Register32 // 0x10
	EP5R   volatile.Register32 // 0x14
	EP6R   volatile.Register32 // 0x18
	EP7R   volatile.Register32 // 0x1C
	_      [32]byte
	CNTR   volatile.Register32 // 0x40
	ISTR   volatile.Register32 // 0x44
	FNR    volatile.Register32 // 0x48
	DADDR  volatile.Register32 // 0x4C
	BTABLE volatile.Register32 // 0x50
}

// USB.EP0R: endpoint 0 register
func (o *USB_Type) SetEP0R_EA(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP0R_EA() uint32 {
	return volatile.LoadUint32(&o.EP0R.Reg) & 0xf
}
func (o *USB_Type) SetEP0R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP0R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP0R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP0R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP0R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP0R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP0R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP0R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP0R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP0R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP0R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP0R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP0R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP0R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP0R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP0R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP0R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP0R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x8000) >> 15
}

// USB.EP1R: endpoint 1 register
func (o *USB_Type) SetEP1R_EA(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP1R_EA() uint32 {
	return volatile.LoadUint32(&o.EP1R.Reg) & 0xf
}
func (o *USB_Type) SetEP1R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP1R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP1R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP1R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP1R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP1R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP1R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP1R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP1R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP1R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP1R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP1R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP1R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP1R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP1R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP1R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP1R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP1R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x8000) >> 15
}

// USB.EP2R: endpoint 2 register
func (o *USB_Type) SetEP2R_EA(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP2R_EA() uint32 {
	return volatile.LoadUint32(&o.EP2R.Reg) & 0xf
}
func (o *USB_Type) SetEP2R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP2R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP2R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP2R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP2R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP2R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP2R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP2R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP2R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP2R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP2R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP2R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP2R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP2R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP2R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP2R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP2R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP2R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x8000) >> 15
}

// USB.EP3R: endpoint 3 register
func (o *USB_Type) SetEP3R_EA(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP3R_EA() uint32 {
	return volatile.LoadUint32(&o.EP3R.Reg) & 0xf
}
func (o *USB_Type) SetEP3R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP3R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP3R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP3R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP3R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP3R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP3R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP3R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP3R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP3R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP3R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP3R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP3R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP3R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP3R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP3R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP3R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP3R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x8000) >> 15
}

// USB.EP4R: endpoint 4 register
func (o *USB_Type) SetEP4R_EA(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP4R_EA() uint32 {
	return volatile.LoadUint32(&o.EP4R.Reg) & 0xf
}
func (o *USB_Type) SetEP4R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP4R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP4R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP4R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP4R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP4R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP4R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP4R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP4R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP4R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP4R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP4R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP4R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP4R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP4R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP4R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP4R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP4R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x8000) >> 15
}

// USB.EP5R: endpoint 5 register
func (o *USB_Type) SetEP5R_EA(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP5R_EA() uint32 {
	return volatile.LoadUint32(&o.EP5R.Reg) & 0xf
}
func (o *USB_Type) SetEP5R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP5R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP5R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP5R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP5R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP5R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP5R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP5R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP5R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP5R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP5R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP5R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP5R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP5R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP5R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP5R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP5R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP5R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x8000) >> 15
}

// USB.EP6R: endpoint 6 register
func (o *USB_Type) SetEP6R_EA(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP6R_EA() uint32 {
	return volatile.LoadUint32(&o.EP6R.Reg) & 0xf
}
func (o *USB_Type) SetEP6R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP6R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP6R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP6R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP6R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP6R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP6R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP6R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP6R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP6R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP6R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP6R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP6R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP6R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP6R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP6R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP6R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP6R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x8000) >> 15
}

// USB.EP7R: endpoint 7 register
func (o *USB_Type) SetEP7R_EA(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP7R_EA() uint32 {
	return volatile.LoadUint32(&o.EP7R.Reg) & 0xf
}
func (o *USB_Type) SetEP7R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP7R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP7R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP7R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP7R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP7R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP7R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP7R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP7R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP7R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP7R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP7R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP7R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP7R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP7R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP7R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP7R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP7R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x8000) >> 15
}

// USB.CNTR: control register
func (o *USB_Type) SetCNTR_FRES(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetCNTR_FRES() uint32 {
	return volatile.LoadUint32(&o.CNTR.Reg) & 0x1
}
func (o *USB_Type) SetCNTR_PDWN(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetCNTR_PDWN() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetCNTR_LPMODE(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetCNTR_LPMODE() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetCNTR_FSUSP(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetCNTR_FSUSP() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetCNTR_RESUME(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetCNTR_RESUME() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetCNTR_ESOFM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCNTR_ESOFM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCNTR_SOFM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetCNTR_SOFM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetCNTR_RESETM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetCNTR_RESETM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetCNTR_SUSPM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCNTR_SUSPM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCNTR_WKUPM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetCNTR_WKUPM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetCNTR_ERRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetCNTR_ERRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetCNTR_PMAOVRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCNTR_PMAOVRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCNTR_CTRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCNTR_CTRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x8000) >> 15
}

// USB.ISTR: interrupt status register
func (o *USB_Type) SetISTR_EP_ID(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetISTR_EP_ID() uint32 {
	return volatile.LoadUint32(&o.ISTR.Reg) & 0xf
}
func (o *USB_Type) SetISTR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetISTR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetISTR_ESOF(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetISTR_ESOF() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetISTR_SOF(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetISTR_SOF() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetISTR_RESET(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetISTR_RESET() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetISTR_SUSP(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetISTR_SUSP() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetISTR_WKUP(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetISTR_WKUP() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetISTR_ERR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetISTR_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetISTR_PMAOVR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetISTR_PMAOVR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetISTR_CTR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetISTR_CTR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x8000) >> 15
}

// USB.FNR: frame number register
func (o *USB_Type) SetFNR_FN(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x7ff)|value)
}
func (o *USB_Type) GetFNR_FN() uint32 {
	return volatile.LoadUint32(&o.FNR.Reg) & 0x7ff
}
func (o *USB_Type) SetFNR_LSOF(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x1800)|value<<11)
}
func (o *USB_Type) GetFNR_LSOF() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x1800) >> 11
}
func (o *USB_Type) SetFNR_LCK(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetFNR_LCK() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetFNR_RXDM(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetFNR_RXDM() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetFNR_RXDP(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetFNR_RXDP() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x8000) >> 15
}

// USB.DADDR: device address
func (o *USB_Type) SetDADDR_ADD(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x7f)|value)
}
func (o *USB_Type) GetDADDR_ADD() uint32 {
	return volatile.LoadUint32(&o.DADDR.Reg) & 0x7f
}
func (o *USB_Type) SetDADDR_EF(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDADDR_EF() uint32 {
	return (volatile.LoadUint32(&o.DADDR.Reg) & 0x80) >> 7
}

// USB.BTABLE: Buffer table address
func (o *USB_Type) SetBTABLE(value uint32) {
	volatile.StoreUint32(&o.BTABLE.Reg, volatile.LoadUint32(&o.BTABLE.Reg)&^(0xfff8)|value<<3)
}
func (o *USB_Type) GetBTABLE() uint32 {
	return (volatile.LoadUint32(&o.BTABLE.Reg) & 0xfff8) >> 3
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x180)|value<<7)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x180) >> 7
}

// WWDG.SR: SR
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Analog-to-digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	SMPR3 volatile.Register32 // 0x14
	JOFR1 volatile.Register32 // 0x18
	JOFR2 volatile.Register32 // 0x1C
	JOFR3 volatile.Register32 // 0x20
	JOFR4 volatile.Register32 // 0x24
	HTR   volatile.Register32 // 0x28
	LTR   volatile.Register32 // 0x2C
	SQR1  volatile.Register32 // 0x30
	SQR2  volatile.Register32 // 0x34
	SQR3  volatile.Register32 // 0x38
	SQR4  volatile.Register32 // 0x3C
	SQR5  volatile.Register32 // 0x40
	JSQR  volatile.Register32 // 0x44
	JDR1  volatile.Register32 // 0x48
	JDR2  volatile.Register32 // 0x4C
	JDR3  volatile.Register32 // 0x50
	JDR4  volatile.Register32 // 0x54
	DR    volatile.Register32 // 0x58
	SMPR0 volatile.Register32 // 0x5C
	_     [672]byte
	CSR   volatile.Register32 // 0x300
	CCR   volatile.Register32 // 0x304
}

// ADC.SR: status register
func (o *ADC_Type) SetSR_JCNR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetSR_JCNR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetSR_RCNR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetSR_RCNR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetSR_ADONS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSR_ADONS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSR_STRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetSR_STRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetSR_JSTRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSR_JSTRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSR_JEOC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSR_EOC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSR_EOC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetSR_AWD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSR_AWD() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// ADC.CR1: control register 1
func (o *ADC_Type) SetCR1_OVRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCR1_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCR1_RES(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3000000)|value<<24)
}
func (o *ADC_Type) GetCR1_RES() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3000000) >> 24
}
func (o *ADC_Type) SetCR1_AWDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCR1_AWDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCR1_JAWDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR1_JAWDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR1_PDI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetCR1_PDI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetCR1_PDD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCR1_PDD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCR1_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe000)|value<<13)
}
func (o *ADC_Type) GetCR1_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe000) >> 13
}
func (o *ADC_Type) SetCR1_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCR1_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCR1_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCR1_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCR1_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCR1_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCR1_AWDSGL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCR1_AWDSGL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCR1_SCAN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCR1_SCAN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCR1_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCR1_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCR1_AWDIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCR1_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCR1_EOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR1_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR1_AWDCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetCR1_AWDCH() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1f
}

// ADC.CR2: control register 2
func (o *ADC_Type) SetCR2_SWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR2_SWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR2_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetCR2_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetCR2_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetCR2_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetCR2_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR2_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR2_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetCR2_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetCR2_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetCR2_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetCR2_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCR2_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCR2_EOCS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCR2_EOCS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCR2_DDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCR2_DDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCR2_DMA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCR2_DMA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCR2_DELS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *ADC_Type) GetCR2_DELS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *ADC_Type) SetCR2_ADC_CFG(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR2_ADC_CFG() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCR2_CONT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR2_CONT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR2_ADON(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR2_ADON() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// ADC.SMPR1: sample time register 1
func (o *ADC_Type) SetSMPR1_SMP(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x3fffffff)|value)
}
func (o *ADC_Type) GetSMPR1_SMP() uint32 {
	return volatile.LoadUint32(&o.SMPR1.Reg) & 0x3fffffff
}

// ADC.SMPR2: sample time register 2
func (o *ADC_Type) SetSMPR2_SMP(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x3fffffff)|value)
}
func (o *ADC_Type) GetSMPR2_SMP() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg) & 0x3fffffff
}

// ADC.SMPR3: sample time register 3
func (o *ADC_Type) SetSMPR3_SMP(value uint32) {
	volatile.StoreUint32(&o.SMPR3.Reg, volatile.LoadUint32(&o.SMPR3.Reg)&^(0x3fffffff)|value)
}
func (o *ADC_Type) GetSMPR3_SMP() uint32 {
	return volatile.LoadUint32(&o.SMPR3.Reg) & 0x3fffffff
}

// ADC.JOFR1: injected channel data offset register x
func (o *ADC_Type) SetJOFR1_JOFFSET1(value uint32) {
	volatile.StoreUint32(&o.JOFR1.Reg, volatile.LoadUint32(&o.JOFR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR1_JOFFSET1() uint32 {
	return volatile.LoadUint32(&o.JOFR1.Reg) & 0xfff
}

// ADC.JOFR2: injected channel data offset register x
func (o *ADC_Type) SetJOFR2_JOFFSET2(value uint32) {
	volatile.StoreUint32(&o.JOFR2.Reg, volatile.LoadUint32(&o.JOFR2.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR2_JOFFSET2() uint32 {
	return volatile.LoadUint32(&o.JOFR2.Reg) & 0xfff
}

// ADC.JOFR3: injected channel data offset register x
func (o *ADC_Type) SetJOFR3_JOFFSET3(value uint32) {
	volatile.StoreUint32(&o.JOFR3.Reg, volatile.LoadUint32(&o.JOFR3.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR3_JOFFSET3() uint32 {
	return volatile.LoadUint32(&o.JOFR3.Reg) & 0xfff
}

// ADC.JOFR4: injected channel data offset register x
func (o *ADC_Type) SetJOFR4_JOFFSET4(value uint32) {
	volatile.StoreUint32(&o.JOFR4.Reg, volatile.LoadUint32(&o.JOFR4.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR4_JOFFSET4() uint32 {
	return volatile.LoadUint32(&o.JOFR4.Reg) & 0xfff
}

// ADC.HTR: watchdog higher threshold register
func (o *ADC_Type) SetHTR_HT(value uint32) {
	volatile.StoreUint32(&o.HTR.Reg, volatile.LoadUint32(&o.HTR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetHTR_HT() uint32 {
	return volatile.LoadUint32(&o.HTR.Reg) & 0xfff
}

// ADC.LTR: watchdog lower threshold register
func (o *ADC_Type) SetLTR_LT(value uint32) {
	volatile.StoreUint32(&o.LTR.Reg, volatile.LoadUint32(&o.LTR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLTR_LT() uint32 {
	return volatile.LoadUint32(&o.LTR.Reg) & 0xfff
}

// ADC.SQR1: regular sequence register 1
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSQR1_SQ28(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR1_SQ28() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR1_SQ27(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR1_SQ27() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR1_SQ26(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR1_SQ26() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR1_SQ25(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR1_SQ25() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0x1f
}

// ADC.SQR2: regular sequence register 2
func (o *ADC_Type) SetSQR2_SQ24(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR2_SQ24() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR2_SQ23(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR2_SQ23() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR2_SQ22(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR2_SQ22() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR2_SQ21(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR2_SQ21() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR2_SQ20(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR2_SQ20() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR2_SQ19(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ19() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: regular sequence register 3
func (o *ADC_Type) SetSQR3_SQ18(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR3_SQ18() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR3_SQ17(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR3_SQ17() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR3_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR3_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR3_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR3_SQ15() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR3_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR3_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR3_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ13() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.SQR4: regular sequence register 4
func (o *ADC_Type) SetSQR4_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR4_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR4_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR4_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR4_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR4_SQ10() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR4_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR4_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR4_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR4_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR4_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR4_SQ7() uint32 {
	return volatile.LoadUint32(&o.SQR4.Reg) & 0x1f
}

// ADC.SQR5: regular sequence register 5
func (o *ADC_Type) SetSQR5_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR5.Reg, volatile.LoadUint32(&o.SQR5.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR5_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR5.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR5_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR5.Reg, volatile.LoadUint32(&o.SQR5.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR5_SQ5() uint32 {
	return (volatile.LoadUint32(&o.SQR5.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR5_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR5.Reg, volatile.LoadUint32(&o.SQR5.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR5_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR5.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR5_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR5.Reg, volatile.LoadUint32(&o.SQR5.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR5_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR5.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR5_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR5.Reg, volatile.LoadUint32(&o.SQR5.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR5_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR5.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR5_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR5.Reg, volatile.LoadUint32(&o.SQR5.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR5_SQ1() uint32 {
	return volatile.LoadUint32(&o.SQR5.Reg) & 0x1f
}

// ADC.JSQR: injected sequence register
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x1f
}

// ADC.JDR1: injected data register x
func (o *ADC_Type) SetJDR1_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, volatile.LoadUint32(&o.JDR1.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR1_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg) & 0xffff
}

// ADC.JDR2: injected data register x
func (o *ADC_Type) SetJDR2_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, volatile.LoadUint32(&o.JDR2.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR2_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg) & 0xffff
}

// ADC.JDR3: injected data register x
func (o *ADC_Type) SetJDR3_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, volatile.LoadUint32(&o.JDR3.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR3_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg) & 0xffff
}

// ADC.JDR4: injected data register x
func (o *ADC_Type) SetJDR4_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, volatile.LoadUint32(&o.JDR4.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR4_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg) & 0xffff
}

// ADC.DR: regular data register
func (o *ADC_Type) SetDR_RegularDATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_RegularDATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// ADC.SMPR0: sample time register 0
func (o *ADC_Type) SetSMPR0_SMP(value uint32) {
	volatile.StoreUint32(&o.SMPR0.Reg, volatile.LoadUint32(&o.SMPR0.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetSMPR0_SMP() uint32 {
	return volatile.LoadUint32(&o.SMPR0.Reg) & 0x3f
}

// ADC.CSR: ADC common status register
func (o *ADC_Type) SetCSR_AWD1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCSR_AWD1() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *ADC_Type) SetCSR_EOC1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCSR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCSR_JEOC1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCSR_JEOC1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCSR_JSTRT1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCSR_JSTRT1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCSR_STRT1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCSR_STRT1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCSR_OVR1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCSR_OVR1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCSR_ADONS1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCSR_ADONS1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}

// ADC.CCR: ADC common control register
func (o *ADC_Type) SetCCR_ADCPRE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x30000)|value<<16)
}
func (o *ADC_Type) GetCCR_ADCPRE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x30000) >> 16
}
func (o *ADC_Type) SetCCR_TSVREFE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCCR_TSVREFE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x800000) >> 23
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	_     [120]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	_     [120]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	_     [120]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	_     [120]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	_     [248]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// debug support
type DBGMCU_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2_FZ volatile.Register32 // 0xC
}

// DBGMCU.IDCODE: DBGMCU_IDCODE
func (o *DBGMCU_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xfff)|value)
}
func (o *DBGMCU_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xfff
}
func (o *DBGMCU_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBGMCU_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBGMCU.CR: Debug MCU configuration register
func (o *DBGMCU_Type) SetCR_DBG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetCR_DBG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBGMCU_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetCR_TRACE_IOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetCR_TRACE_IOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetCR_TRACE_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DBGMCU_Type) GetCR_TRACE_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}

// DBGMCU.APB1_FZ: Debug MCU APB1 freeze register1
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM4_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM4_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM5_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x8)|value<<3)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM5_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x8) >> 3
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM6_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x10)|value<<4)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM6_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x10) >> 4
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM7_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM7_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_RTC_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400)|value<<10)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_RTC_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400) >> 10
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1000)|value<<12)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1000) >> 12
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_I2C1_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x200000)|value<<21)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_I2C1_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x200000) >> 21
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_I2C2_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400000)|value<<22)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_I2C2_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400000) >> 22
}

// DBGMCU.APB2_FZ: Debug MCU APB1 freeze register 2
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_TIM9_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_TIM9_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_TIM10_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x8)|value<<3)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_TIM10_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x8) >> 3
}
func (o *DBGMCU_Type) SetAPB2_FZ_DBG_TIM11_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x10)|value<<4)
}
func (o *DBGMCU_Type) GetAPB2_FZ_DBG_TIM11_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x10) >> 4
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// System control block ACTLR
type SCB_Type struct {
	ACTRL volatile.Register32 // 0x0
}

// SCB.ACTRL: Auxiliary control register
func (o *SCB_Type) SetACTRL_DISFOLD(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetACTRL_DISFOLD() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetACTRL_FPEXCODIS(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetACTRL_FPEXCODIS() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetACTRL_DISRAMODE(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetACTRL_DISRAMODE() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetACTRL_DISITMATBFLUSH(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetACTRL_DISITMATBFLUSH() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x1000) >> 12
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD_ volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// STK.CTRL: SysTick control and status register
func (o *STK_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *STK_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *STK_Type) SetCTRL_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *STK_Type) GetCTRL_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *STK_Type) SetCTRL_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *STK_Type) GetCTRL_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *STK_Type) SetCTRL_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *STK_Type) GetCTRL_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}

// STK.LOAD_: SysTick reload value register
func (o *STK_Type) SetLOAD__RELOAD(value uint32) {
	volatile.StoreUint32(&o.LOAD_.Reg, volatile.LoadUint32(&o.LOAD_.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetLOAD__RELOAD() uint32 {
	return volatile.LoadUint32(&o.LOAD_.Reg) & 0xffffff
}

// STK.VAL: SysTick current value register
func (o *STK_Type) SetVAL_CURRENT(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetVAL_CURRENT() uint32 {
	return volatile.LoadUint32(&o.VAL.Reg) & 0xffffff
}

// STK.CALIB: SysTick calibration value register
func (o *STK_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}

// Constants for AES: Advanced encrytion standard hardware accelerator
const (
	// CR: control register
	// Position of DMAOUTEN field.
	AES_CR_DMAOUTEN_Pos = 0xc
	// Bit mask of DMAOUTEN field.
	AES_CR_DMAOUTEN_Msk = 0x1000
	// Bit DMAOUTEN.
	AES_CR_DMAOUTEN = 0x1000
	// Position of DMAINEN field.
	AES_CR_DMAINEN_Pos = 0xb
	// Bit mask of DMAINEN field.
	AES_CR_DMAINEN_Msk = 0x800
	// Bit DMAINEN.
	AES_CR_DMAINEN = 0x800
	// Position of ERRIE field.
	AES_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	AES_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	AES_CR_ERRIE = 0x400
	// Position of CCFIE field.
	AES_CR_CCFIE_Pos = 0x9
	// Bit mask of CCFIE field.
	AES_CR_CCFIE_Msk = 0x200
	// Bit CCFIE.
	AES_CR_CCFIE = 0x200
	// Position of ERRC field.
	AES_CR_ERRC_Pos = 0x8
	// Bit mask of ERRC field.
	AES_CR_ERRC_Msk = 0x100
	// Bit ERRC.
	AES_CR_ERRC = 0x100
	// Position of CCFC field.
	AES_CR_CCFC_Pos = 0x7
	// Bit mask of CCFC field.
	AES_CR_CCFC_Msk = 0x80
	// Bit CCFC.
	AES_CR_CCFC = 0x80
	// Position of CHMOD field.
	AES_CR_CHMOD_Pos = 0x5
	// Bit mask of CHMOD field.
	AES_CR_CHMOD_Msk = 0x60
	// Position of MODE field.
	AES_CR_MODE_Pos = 0x3
	// Bit mask of MODE field.
	AES_CR_MODE_Msk = 0x18
	// Position of DATATYPE field.
	AES_CR_DATATYPE_Pos = 0x1
	// Bit mask of DATATYPE field.
	AES_CR_DATATYPE_Msk = 0x6
	// Position of EN field.
	AES_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	AES_CR_EN_Msk = 0x1
	// Bit EN.
	AES_CR_EN = 0x1

	// SR: Status register
	// Position of WRERR field.
	AES_SR_WRERR_Pos = 0x2
	// Bit mask of WRERR field.
	AES_SR_WRERR_Msk = 0x4
	// Bit WRERR.
	AES_SR_WRERR = 0x4
	// Position of RDERR field.
	AES_SR_RDERR_Pos = 0x1
	// Bit mask of RDERR field.
	AES_SR_RDERR_Msk = 0x2
	// Bit RDERR.
	AES_SR_RDERR = 0x2
	// Position of CCF field.
	AES_SR_CCF_Pos = 0x0
	// Bit mask of CCF field.
	AES_SR_CCF_Msk = 0x1
	// Bit CCF.
	AES_SR_CCF = 0x1

	// DINR: Data input register
	// Position of DINR field.
	AES_DINR_DINR_Pos = 0x0
	// Bit mask of DINR field.
	AES_DINR_DINR_Msk = 0xffffffff

	// DOUTR: Data output register
	// Position of DOUTR field.
	AES_DOUTR_DOUTR_Pos = 0x0
	// Bit mask of DOUTR field.
	AES_DOUTR_DOUTR_Msk = 0xffffffff

	// KEYR0: AES Key register 0
	// Position of KEYR0 field.
	AES_KEYR0_KEYR0_Pos = 0x0
	// Bit mask of KEYR0 field.
	AES_KEYR0_KEYR0_Msk = 0xffffffff

	// KEYR1: AES Key register 1
	// Position of KEYR1 field.
	AES_KEYR1_KEYR1_Pos = 0x0
	// Bit mask of KEYR1 field.
	AES_KEYR1_KEYR1_Msk = 0xffffffff

	// KEYR2: AES Key register 2
	// Position of KEYR2 field.
	AES_KEYR2_KEYR2_Pos = 0x0
	// Bit mask of KEYR2 field.
	AES_KEYR2_KEYR2_Msk = 0xffffffff

	// KEYR3: AES Key register 3
	// Position of KEYR3 field.
	AES_KEYR3_KEYR3_Pos = 0x0
	// Bit mask of KEYR3 field.
	AES_KEYR3_KEYR3_Msk = 0xffffffff

	// IVR0: Initialization Vector Register 0
	// Position of IVR0 field.
	AES_IVR0_IVR0_Pos = 0x0
	// Bit mask of IVR0 field.
	AES_IVR0_IVR0_Msk = 0xffffffff

	// IVR1: Initialization Vector Register 1
	// Position of IVR1 field.
	AES_IVR1_IVR1_Pos = 0x0
	// Bit mask of IVR1 field.
	AES_IVR1_IVR1_Msk = 0xffffffff

	// IVR2: Initialization Vector Register 2
	// Position of IVR2 field.
	AES_IVR2_IVR2_Pos = 0x0
	// Bit mask of IVR2 field.
	AES_IVR2_IVR2_Msk = 0xffffffff

	// IVR3: Initialization Vector Register 3
	// Position of IVR3 field.
	AES_IVR3_IVR3_Pos = 0x0
	// Bit mask of IVR3 field.
	AES_IVR3_IVR3_Msk = 0xffffffff
)

// Constants for COMP: Comparators
const (
	// CSR: comparator control and status register
	// Position of TSUSP field.
	COMP_CSR_TSUSP_Pos = 0x1f
	// Bit mask of TSUSP field.
	COMP_CSR_TSUSP_Msk = 0x80000000
	// Bit TSUSP.
	COMP_CSR_TSUSP = 0x80000000
	// Position of CAIF field.
	COMP_CSR_CAIF_Pos = 0x1e
	// Bit mask of CAIF field.
	COMP_CSR_CAIF_Msk = 0x40000000
	// Bit CAIF.
	COMP_CSR_CAIF = 0x40000000
	// Position of CAIE field.
	COMP_CSR_CAIE_Pos = 0x1d
	// Bit mask of CAIE field.
	COMP_CSR_CAIE_Msk = 0x20000000
	// Bit CAIE.
	COMP_CSR_CAIE = 0x20000000
	// Position of RCH13 field.
	COMP_CSR_RCH13_Pos = 0x1c
	// Bit mask of RCH13 field.
	COMP_CSR_RCH13_Msk = 0x10000000
	// Bit RCH13.
	COMP_CSR_RCH13 = 0x10000000
	// Position of FCH8 field.
	COMP_CSR_FCH8_Pos = 0x1b
	// Bit mask of FCH8 field.
	COMP_CSR_FCH8_Msk = 0x8000000
	// Bit FCH8.
	COMP_CSR_FCH8 = 0x8000000
	// Position of FCH3 field.
	COMP_CSR_FCH3_Pos = 0x1a
	// Bit mask of FCH3 field.
	COMP_CSR_FCH3_Msk = 0x4000000
	// Bit FCH3.
	COMP_CSR_FCH3 = 0x4000000
	// Position of OUTSEL field.
	COMP_CSR_OUTSEL_Pos = 0x15
	// Bit mask of OUTSEL field.
	COMP_CSR_OUTSEL_Msk = 0xe00000
	// Position of INSEL field.
	COMP_CSR_INSEL_Pos = 0x12
	// Bit mask of INSEL field.
	COMP_CSR_INSEL_Msk = 0x1c0000
	// Position of WNDWE field.
	COMP_CSR_WNDWE_Pos = 0x11
	// Bit mask of WNDWE field.
	COMP_CSR_WNDWE_Msk = 0x20000
	// Bit WNDWE.
	COMP_CSR_WNDWE = 0x20000
	// Position of VREFOUTEN field.
	COMP_CSR_VREFOUTEN_Pos = 0x10
	// Bit mask of VREFOUTEN field.
	COMP_CSR_VREFOUTEN_Msk = 0x10000
	// Bit VREFOUTEN.
	COMP_CSR_VREFOUTEN = 0x10000
	// Position of CMP2OUT field.
	COMP_CSR_CMP2OUT_Pos = 0xd
	// Bit mask of CMP2OUT field.
	COMP_CSR_CMP2OUT_Msk = 0x2000
	// Bit CMP2OUT.
	COMP_CSR_CMP2OUT = 0x2000
	// Position of SPEED field.
	COMP_CSR_SPEED_Pos = 0xc
	// Bit mask of SPEED field.
	COMP_CSR_SPEED_Msk = 0x1000
	// Bit SPEED.
	COMP_CSR_SPEED = 0x1000
	// Position of CMP1OUT field.
	COMP_CSR_CMP1OUT_Pos = 0x7
	// Bit mask of CMP1OUT field.
	COMP_CSR_CMP1OUT_Msk = 0x80
	// Bit CMP1OUT.
	COMP_CSR_CMP1OUT = 0x80
	// Position of SW1 field.
	COMP_CSR_SW1_Pos = 0x5
	// Bit mask of SW1 field.
	COMP_CSR_SW1_Msk = 0x20
	// Bit SW1.
	COMP_CSR_SW1 = 0x20
	// Position of CMP1EN field.
	COMP_CSR_CMP1EN_Pos = 0x4
	// Bit mask of CMP1EN field.
	COMP_CSR_CMP1EN_Msk = 0x10
	// Bit CMP1EN.
	COMP_CSR_CMP1EN = 0x10
	// Position of PD400K field.
	COMP_CSR_PD400K_Pos = 0x3
	// Bit mask of PD400K field.
	COMP_CSR_PD400K_Msk = 0x8
	// Bit PD400K.
	COMP_CSR_PD400K = 0x8
	// Position of PD10K field.
	COMP_CSR_PD10K_Pos = 0x2
	// Bit mask of PD10K field.
	COMP_CSR_PD10K_Msk = 0x4
	// Bit PD10K.
	COMP_CSR_PD10K = 0x4
	// Position of PU400K field.
	COMP_CSR_PU400K_Pos = 0x1
	// Bit mask of PU400K field.
	COMP_CSR_PU400K_Msk = 0x2
	// Bit PU400K.
	COMP_CSR_PU400K = 0x2
	// Position of PU10K field.
	COMP_CSR_PU10K_Pos = 0x0
	// Bit mask of PU10K field.
	COMP_CSR_PU10K_Msk = 0x1
	// Bit PU10K.
	COMP_CSR_PU10K = 0x1
)

// Constants for CRC: CRC calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1
)

// Constants for DAC: Digital-to-analog converter
const (
	// CR: control register
	// Position of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Pos = 0x1d
	// Bit mask of DMAUDRIE2 field.
	DAC_CR_DMAUDRIE2_Msk = 0x20000000
	// Bit DMAUDRIE2.
	DAC_CR_DMAUDRIE2 = 0x20000000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE2_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE2_Enabled = 0x1
	// Position of DMAEN2 field.
	DAC_CR_DMAEN2_Pos = 0x1c
	// Bit mask of DMAEN2 field.
	DAC_CR_DMAEN2_Msk = 0x10000000
	// Bit DMAEN2.
	DAC_CR_DMAEN2 = 0x10000000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN2_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN2_Enabled = 0x1
	// Position of MAMP2 field.
	DAC_CR_MAMP2_Pos = 0x18
	// Bit mask of MAMP2 field.
	DAC_CR_MAMP2_Msk = 0xf000000
	// Position of WAVE2 field.
	DAC_CR_WAVE2_Pos = 0x16
	// Bit mask of WAVE2 field.
	DAC_CR_WAVE2_Msk = 0xc00000
	// Wave generation disabled
	DAC_CR_WAVE2_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE2_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE2_Triangle = 0x2
	// Position of TSEL2 field.
	DAC_CR_TSEL2_Pos = 0x13
	// Bit mask of TSEL2 field.
	DAC_CR_TSEL2_Msk = 0x380000
	// Timer 6 TRGO event
	DAC_CR_TSEL2_TIM6_TRGO = 0x0
	// Timer 8 TRGO event
	DAC_CR_TSEL2_TIM8_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL2_TIM7_TRGO = 0x2
	// Timer 5 TRGO event
	DAC_CR_TSEL2_TIM5_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL2_TIM2_TRGO = 0x4
	// Timer 4 TRGO event
	DAC_CR_TSEL2_TIM4_TRGO = 0x5
	// EXTI line9
	DAC_CR_TSEL2_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL2_SOFTWARE = 0x7
	// Position of TEN2 field.
	DAC_CR_TEN2_Pos = 0x12
	// Bit mask of TEN2 field.
	DAC_CR_TEN2_Msk = 0x40000
	// Bit TEN2.
	DAC_CR_TEN2 = 0x40000
	// DAC channel X trigger disabled
	DAC_CR_TEN2_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN2_Enabled = 0x1
	// Position of BOFF2 field.
	DAC_CR_BOFF2_Pos = 0x11
	// Bit mask of BOFF2 field.
	DAC_CR_BOFF2_Msk = 0x20000
	// Bit BOFF2.
	DAC_CR_BOFF2 = 0x20000
	// DAC channel X output buffer enabled
	DAC_CR_BOFF2_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF2_Disabled = 0x1
	// Position of EN2 field.
	DAC_CR_EN2_Pos = 0x10
	// Bit mask of EN2 field.
	DAC_CR_EN2_Msk = 0x10000
	// Bit EN2.
	DAC_CR_EN2 = 0x10000
	// DAC channel X disabled
	DAC_CR_EN2_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN2_Enabled = 0x1
	// Position of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Pos = 0xd
	// Bit mask of DMAUDRIE1 field.
	DAC_CR_DMAUDRIE1_Msk = 0x2000
	// Bit DMAUDRIE1.
	DAC_CR_DMAUDRIE1 = 0x2000
	// DAC channel X DMA Underrun Interrupt disabled
	DAC_CR_DMAUDRIE1_Disabled = 0x0
	// DAC channel X DMA Underrun Interrupt enabled
	DAC_CR_DMAUDRIE1_Enabled = 0x1
	// Position of DMAEN1 field.
	DAC_CR_DMAEN1_Pos = 0xc
	// Bit mask of DMAEN1 field.
	DAC_CR_DMAEN1_Msk = 0x1000
	// Bit DMAEN1.
	DAC_CR_DMAEN1 = 0x1000
	// DAC channel X DMA mode disabled
	DAC_CR_DMAEN1_Disabled = 0x0
	// DAC channel X DMA mode enabled
	DAC_CR_DMAEN1_Enabled = 0x1
	// Position of MAMP1 field.
	DAC_CR_MAMP1_Pos = 0x8
	// Bit mask of MAMP1 field.
	DAC_CR_MAMP1_Msk = 0xf00
	// Position of WAVE1 field.
	DAC_CR_WAVE1_Pos = 0x6
	// Bit mask of WAVE1 field.
	DAC_CR_WAVE1_Msk = 0xc0
	// Wave generation disabled
	DAC_CR_WAVE1_Disabled = 0x0
	// Noise wave generation enabled
	DAC_CR_WAVE1_Noise = 0x1
	// Triangle wave generation enabled
	DAC_CR_WAVE1_Triangle = 0x2
	// Position of TSEL1 field.
	DAC_CR_TSEL1_Pos = 0x3
	// Bit mask of TSEL1 field.
	DAC_CR_TSEL1_Msk = 0x38
	// Timer 6 TRGO event
	DAC_CR_TSEL1_TIM6_TRGO = 0x0
	// Timer 3 TRGO event
	DAC_CR_TSEL1_TIM3_TRGO = 0x1
	// Timer 7 TRGO event
	DAC_CR_TSEL1_TIM7_TRGO = 0x2
	// Timer 15 TRGO event
	DAC_CR_TSEL1_TIM15_TRGO = 0x3
	// Timer 2 TRGO event
	DAC_CR_TSEL1_TIM2_TRGO = 0x4
	// EXTI line9
	DAC_CR_TSEL1_EXTI9 = 0x6
	// Software trigger
	DAC_CR_TSEL1_SOFTWARE = 0x7
	// Position of TEN1 field.
	DAC_CR_TEN1_Pos = 0x2
	// Bit mask of TEN1 field.
	DAC_CR_TEN1_Msk = 0x4
	// Bit TEN1.
	DAC_CR_TEN1 = 0x4
	// DAC channel X trigger disabled
	DAC_CR_TEN1_Disabled = 0x0
	// DAC channel X trigger enabled
	DAC_CR_TEN1_Enabled = 0x1
	// Position of BOFF1 field.
	DAC_CR_BOFF1_Pos = 0x1
	// Bit mask of BOFF1 field.
	DAC_CR_BOFF1_Msk = 0x2
	// Bit BOFF1.
	DAC_CR_BOFF1 = 0x2
	// DAC channel X output buffer enabled
	DAC_CR_BOFF1_Enabled = 0x0
	// DAC channel X output buffer disabled
	DAC_CR_BOFF1_Disabled = 0x1
	// Position of EN1 field.
	DAC_CR_EN1_Pos = 0x0
	// Bit mask of EN1 field.
	DAC_CR_EN1_Msk = 0x1
	// Bit EN1.
	DAC_CR_EN1 = 0x1
	// DAC channel X disabled
	DAC_CR_EN1_Disabled = 0x0
	// DAC channel X enabled
	DAC_CR_EN1_Enabled = 0x1

	// SWTRIGR: software trigger register
	// Position of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Pos = 0x1
	// Bit mask of SWTRIG2 field.
	DAC_SWTRIGR_SWTRIG2_Msk = 0x2
	// Bit SWTRIG2.
	DAC_SWTRIGR_SWTRIG2 = 0x2
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG2_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG2_Enabled = 0x1
	// Position of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Pos = 0x0
	// Bit mask of SWTRIG1 field.
	DAC_SWTRIGR_SWTRIG1_Msk = 0x1
	// Bit SWTRIG1.
	DAC_SWTRIGR_SWTRIG1 = 0x1
	// DAC channel X software trigger disabled
	DAC_SWTRIGR_SWTRIG1_Disabled = 0x0
	// DAC channel X software trigger enabled
	DAC_SWTRIGR_SWTRIG1_Enabled = 0x1

	// DHR12R1: channel1 12-bit right-aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12R1_DACC1DHR_Msk = 0xfff

	// DHR12L1: channel1 12-bit left aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12L1_DACC1DHR_Msk = 0xfff0

	// DHR8R1: channel1 8-bit right aligned data holding register
	// Position of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8R1_DACC1DHR_Msk = 0xff

	// DHR12R2: channel2 12-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR12R2_DACC2DHR_Msk = 0xfff

	// DHR12L2: channel2 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Pos = 0x4
	// Bit mask of DACC2DHR field.
	DAC_DHR12L2_DACC2DHR_Msk = 0xfff0

	// DHR8R2: channel2 8-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Pos = 0x0
	// Bit mask of DACC2DHR field.
	DAC_DHR8R2_DACC2DHR_Msk = 0xff

	// DHR12RD: Dual DAC 12-bit right-aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Pos = 0x10
	// Bit mask of DACC2DHR field.
	DAC_DHR12RD_DACC2DHR_Msk = 0xfff0000
	// Position of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR12RD_DACC1DHR_Msk = 0xfff

	// DHR12LD: DUAL DAC 12-bit left aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Pos = 0x14
	// Bit mask of DACC2DHR field.
	DAC_DHR12LD_DACC2DHR_Msk = 0xfff00000
	// Position of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Pos = 0x4
	// Bit mask of DACC1DHR field.
	DAC_DHR12LD_DACC1DHR_Msk = 0xfff0

	// DHR8RD: DUAL DAC 8-bit right aligned data holding register
	// Position of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Pos = 0x8
	// Bit mask of DACC2DHR field.
	DAC_DHR8RD_DACC2DHR_Msk = 0xff00
	// Position of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Pos = 0x0
	// Bit mask of DACC1DHR field.
	DAC_DHR8RD_DACC1DHR_Msk = 0xff

	// DOR1: channel1 data output register
	// Position of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Pos = 0x0
	// Bit mask of DACC1DOR field.
	DAC_DOR1_DACC1DOR_Msk = 0xfff

	// DOR2: channel2 data output register
	// Position of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Pos = 0x0
	// Bit mask of DACC2DOR field.
	DAC_DOR2_DACC2DOR_Msk = 0xfff

	// SR: status register
	// Position of DMAUDR2 field.
	DAC_SR_DMAUDR2_Pos = 0x1d
	// Bit mask of DMAUDR2 field.
	DAC_SR_DMAUDR2_Msk = 0x20000000
	// Bit DMAUDR2.
	DAC_SR_DMAUDR2 = 0x20000000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR2_Underrun = 0x1
	// Position of DMAUDR1 field.
	DAC_SR_DMAUDR1_Pos = 0xd
	// Bit mask of DMAUDR1 field.
	DAC_SR_DMAUDR1_Msk = 0x2000
	// Bit DMAUDR1.
	DAC_SR_DMAUDR1 = 0x2000
	// No DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_NoUnderrun = 0x0
	// DMA underrun error condition occurred for DAC channel X
	DAC_SR_DMAUDR1_Underrun = 0x1
)

// Constants for DMA1: Direct memory access controller
const (
	// ISR: interrupt status register
	// Position of TEIF7 field.
	DMA_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_ISR_TEIF7 = 0x8000000
	// Position of HTIF7 field.
	DMA_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_ISR_HTIF7 = 0x4000000
	// Position of TCIF7 field.
	DMA_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_ISR_TCIF7 = 0x2000000
	// Position of GIF7 field.
	DMA_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_ISR_GIF7 = 0x1000000
	// Position of TEIF6 field.
	DMA_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_ISR_TEIF6 = 0x800000
	// Position of HTIF6 field.
	DMA_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_ISR_HTIF6 = 0x400000
	// Position of TCIF6 field.
	DMA_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_ISR_TCIF6 = 0x200000
	// Position of GIF6 field.
	DMA_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_ISR_GIF6 = 0x100000
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1

	// IFCR: interrupt flag clear register
	// Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Pos = 0x1b
	// Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000
	// Bit CTEIF7.
	DMA_IFCR_CTEIF7 = 0x8000000
	// Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_IFCR_CHTIF7 = 0x4000000
	// Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Pos = 0x19
	// Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000
	// Bit CTCIF7.
	DMA_IFCR_CTCIF7 = 0x2000000
	// Position of CGIF7 field.
	DMA_IFCR_CGIF7_Pos = 0x18
	// Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7_Msk = 0x1000000
	// Bit CGIF7.
	DMA_IFCR_CGIF7 = 0x1000000
	// Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Pos = 0x17
	// Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000
	// Bit CTEIF6.
	DMA_IFCR_CTEIF6 = 0x800000
	// Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Pos = 0x16
	// Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000
	// Bit CHTIF6.
	DMA_IFCR_CHTIF6 = 0x400000
	// Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_IFCR_CTCIF6 = 0x200000
	// Position of CGIF6 field.
	DMA_IFCR_CGIF6_Pos = 0x14
	// Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6_Msk = 0x100000
	// Bit CGIF6.
	DMA_IFCR_CGIF6 = 0x100000
	// Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA_IFCR_CTEIF5 = 0x80000
	// Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA_IFCR_CHTIF5 = 0x40000
	// Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA_IFCR_CTCIF5 = 0x20000
	// Position of CGIF5 field.
	DMA_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA_IFCR_CGIF5 = 0x10000
	// Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Pos = 0xf
	// Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000
	// Bit CTEIF4.
	DMA_IFCR_CTEIF4 = 0x8000
	// Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA_IFCR_CHTIF4 = 0x4000
	// Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA_IFCR_CTCIF4 = 0x2000
	// Position of CGIF4 field.
	DMA_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA_IFCR_CGIF4 = 0x1000
	// Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA_IFCR_CTEIF3 = 0x800
	// Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA_IFCR_CHTIF3 = 0x400
	// Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA_IFCR_CTCIF3 = 0x200
	// Position of CGIF3 field.
	DMA_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA_IFCR_CGIF3 = 0x100
	// Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA_IFCR_CTEIF2 = 0x80
	// Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA_IFCR_CHTIF2 = 0x40
	// Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA_IFCR_CTCIF2 = 0x20
	// Position of CGIF2 field.
	DMA_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA_IFCR_CGIF2 = 0x10
	// Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA_IFCR_CTEIF1 = 0x8
	// Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA_IFCR_CHTIF1 = 0x4
	// Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA_IFCR_CTCIF1 = 0x2
	// Position of CGIF1 field.
	DMA_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA_IFCR_CGIF1 = 0x1

	// CCR1: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR1_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR1_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR1_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR1_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR1_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR1_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR1_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR1_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR1_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR1_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR1_MINC = 0x80
	// Position of PINC field.
	DMA_CCR1_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR1_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR1_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR1_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR1_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR1_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR1_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR1_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR1_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR1_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR1_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR1_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR1_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR1_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR1_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR1_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR1_TCIE = 0x2
	// Position of EN field.
	DMA_CCR1_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR1_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR1_EN = 0x1

	// CNDTR1: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR1_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR1_NDT_Msk = 0xffff

	// CPAR1: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR1_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR1_PA_Msk = 0xffffffff

	// CMAR1: channel x memory address register
	// Position of MA field.
	DMA_CMAR1_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR1_MA_Msk = 0xffffffff

	// CCR2: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR2_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR2_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR2_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR2_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR2_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR2_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR2_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR2_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR2_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR2_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR2_MINC = 0x80
	// Position of PINC field.
	DMA_CCR2_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR2_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR2_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR2_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR2_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR2_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR2_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR2_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR2_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR2_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR2_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR2_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR2_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR2_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR2_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR2_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR2_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR2_TCIE = 0x2
	// Position of EN field.
	DMA_CCR2_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR2_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR2_EN = 0x1

	// CNDTR2: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR2_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR2_NDT_Msk = 0xffff

	// CPAR2: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR2_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR2_PA_Msk = 0xffffffff

	// CMAR2: channel x memory address register
	// Position of MA field.
	DMA_CMAR2_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR2_MA_Msk = 0xffffffff

	// CCR3: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR3_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR3_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR3_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR3_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR3_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR3_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR3_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR3_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR3_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR3_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR3_MINC = 0x80
	// Position of PINC field.
	DMA_CCR3_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR3_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR3_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR3_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR3_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR3_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR3_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR3_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR3_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR3_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR3_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR3_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR3_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR3_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR3_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR3_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR3_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR3_TCIE = 0x2
	// Position of EN field.
	DMA_CCR3_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR3_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR3_EN = 0x1

	// CNDTR3: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR3_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR3_NDT_Msk = 0xffff

	// CPAR3: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR3_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR3_PA_Msk = 0xffffffff

	// CMAR3: channel x memory address register
	// Position of MA field.
	DMA_CMAR3_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR3_MA_Msk = 0xffffffff

	// CCR4: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR4_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR4_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR4_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR4_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR4_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR4_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR4_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR4_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR4_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR4_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR4_MINC = 0x80
	// Position of PINC field.
	DMA_CCR4_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR4_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR4_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR4_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR4_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR4_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR4_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR4_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR4_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR4_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR4_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR4_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR4_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR4_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR4_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR4_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR4_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR4_TCIE = 0x2
	// Position of EN field.
	DMA_CCR4_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR4_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR4_EN = 0x1

	// CNDTR4: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR4_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR4_NDT_Msk = 0xffff

	// CPAR4: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR4_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR4_PA_Msk = 0xffffffff

	// CMAR4: channel x memory address register
	// Position of MA field.
	DMA_CMAR4_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR4_MA_Msk = 0xffffffff

	// CCR5: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR5_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR5_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR5_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR5_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR5_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR5_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR5_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR5_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR5_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR5_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR5_MINC = 0x80
	// Position of PINC field.
	DMA_CCR5_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR5_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR5_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR5_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR5_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR5_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR5_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR5_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR5_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR5_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR5_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR5_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR5_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR5_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR5_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR5_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR5_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR5_TCIE = 0x2
	// Position of EN field.
	DMA_CCR5_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR5_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR5_EN = 0x1

	// CNDTR5: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR5_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR5_NDT_Msk = 0xffff

	// CPAR5: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR5_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR5_PA_Msk = 0xffffffff

	// CMAR5: channel x memory address register
	// Position of MA field.
	DMA_CMAR5_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR5_MA_Msk = 0xffffffff

	// CCR6: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR6_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR6_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR6_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR6_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR6_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR6_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR6_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR6_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR6_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR6_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR6_MINC = 0x80
	// Position of PINC field.
	DMA_CCR6_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR6_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR6_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR6_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR6_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR6_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR6_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR6_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR6_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR6_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR6_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR6_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR6_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR6_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR6_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR6_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR6_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR6_TCIE = 0x2
	// Position of EN field.
	DMA_CCR6_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR6_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR6_EN = 0x1

	// CNDTR6: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR6_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR6_NDT_Msk = 0xffff

	// CPAR6: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR6_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR6_PA_Msk = 0xffffffff

	// CMAR6: channel x memory address register
	// Position of MA field.
	DMA_CMAR6_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR6_MA_Msk = 0xffffffff

	// CCR7: channel x configuration register
	// Position of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CCR7_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CCR7_MEM2MEM = 0x4000
	// Position of PL field.
	DMA_CCR7_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CCR7_PL_Msk = 0x3000
	// Position of MSIZE field.
	DMA_CCR7_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CCR7_MSIZE_Msk = 0xc00
	// Position of PSIZE field.
	DMA_CCR7_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CCR7_PSIZE_Msk = 0x300
	// Position of MINC field.
	DMA_CCR7_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CCR7_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CCR7_MINC = 0x80
	// Position of PINC field.
	DMA_CCR7_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CCR7_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CCR7_PINC = 0x40
	// Position of CIRC field.
	DMA_CCR7_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CCR7_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CCR7_CIRC = 0x20
	// Position of DIR field.
	DMA_CCR7_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CCR7_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CCR7_DIR = 0x10
	// Position of TEIE field.
	DMA_CCR7_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CCR7_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CCR7_TEIE = 0x8
	// Position of HTIE field.
	DMA_CCR7_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CCR7_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CCR7_HTIE = 0x4
	// Position of TCIE field.
	DMA_CCR7_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CCR7_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CCR7_TCIE = 0x2
	// Position of EN field.
	DMA_CCR7_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CCR7_EN_Msk = 0x1
	// Bit EN.
	DMA_CCR7_EN = 0x1

	// CNDTR7: channel x number of data register
	// Position of NDT field.
	DMA_CNDTR7_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CNDTR7_NDT_Msk = 0xffff

	// CPAR7: channel x peripheral address register
	// Position of PA field.
	DMA_CPAR7_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CPAR7_PA_Msk = 0xffffffff

	// CMAR7: channel x memory address register
	// Position of MA field.
	DMA_CMAR7_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CMAR7_MA_Msk = 0xffffffff
)

// Constants for EXTI: External interrupt/event controller
const (
	// IMR: IMR
	// Position of MR0 field.
	EXTI_IMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_IMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_IMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_IMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_IMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_IMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_IMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_IMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_IMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_IMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_IMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_IMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_IMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_IMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_IMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_IMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_IMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_IMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_IMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_IMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_IMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_IMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_IMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_IMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_IMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_IMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_IMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_IMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_IMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_IMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_IMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_IMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_IMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_IMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_IMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_IMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_IMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_IMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_IMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_IMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_IMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_IMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_IMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_IMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_IMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_IMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_IMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_IMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_IMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_IMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_IMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_IMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_IMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_IMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_IMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_IMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_IMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_IMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_IMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_IMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_IMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_IMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_IMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_IMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_IMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_IMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_IMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_IMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_IMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_IMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_IMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_IMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_IMR_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_IMR_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_IMR_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_IMR_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_IMR_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_IMR_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_IMR_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_IMR_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_IMR_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_IMR_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_IMR_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_IMR_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_IMR_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_IMR_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_IMR_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_IMR_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_IMR_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_IMR_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_IMR_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_IMR_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_IMR_MR22_Unmasked = 0x1

	// EMR: EMR
	// Position of MR0 field.
	EXTI_EMR_MR0_Pos = 0x0
	// Bit mask of MR0 field.
	EXTI_EMR_MR0_Msk = 0x1
	// Bit MR0.
	EXTI_EMR_MR0 = 0x1
	// Interrupt request line is masked
	EXTI_EMR_MR0_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR0_Unmasked = 0x1
	// Position of MR1 field.
	EXTI_EMR_MR1_Pos = 0x1
	// Bit mask of MR1 field.
	EXTI_EMR_MR1_Msk = 0x2
	// Bit MR1.
	EXTI_EMR_MR1 = 0x2
	// Interrupt request line is masked
	EXTI_EMR_MR1_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR1_Unmasked = 0x1
	// Position of MR2 field.
	EXTI_EMR_MR2_Pos = 0x2
	// Bit mask of MR2 field.
	EXTI_EMR_MR2_Msk = 0x4
	// Bit MR2.
	EXTI_EMR_MR2 = 0x4
	// Interrupt request line is masked
	EXTI_EMR_MR2_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR2_Unmasked = 0x1
	// Position of MR3 field.
	EXTI_EMR_MR3_Pos = 0x3
	// Bit mask of MR3 field.
	EXTI_EMR_MR3_Msk = 0x8
	// Bit MR3.
	EXTI_EMR_MR3 = 0x8
	// Interrupt request line is masked
	EXTI_EMR_MR3_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR3_Unmasked = 0x1
	// Position of MR4 field.
	EXTI_EMR_MR4_Pos = 0x4
	// Bit mask of MR4 field.
	EXTI_EMR_MR4_Msk = 0x10
	// Bit MR4.
	EXTI_EMR_MR4 = 0x10
	// Interrupt request line is masked
	EXTI_EMR_MR4_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR4_Unmasked = 0x1
	// Position of MR5 field.
	EXTI_EMR_MR5_Pos = 0x5
	// Bit mask of MR5 field.
	EXTI_EMR_MR5_Msk = 0x20
	// Bit MR5.
	EXTI_EMR_MR5 = 0x20
	// Interrupt request line is masked
	EXTI_EMR_MR5_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR5_Unmasked = 0x1
	// Position of MR6 field.
	EXTI_EMR_MR6_Pos = 0x6
	// Bit mask of MR6 field.
	EXTI_EMR_MR6_Msk = 0x40
	// Bit MR6.
	EXTI_EMR_MR6 = 0x40
	// Interrupt request line is masked
	EXTI_EMR_MR6_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR6_Unmasked = 0x1
	// Position of MR7 field.
	EXTI_EMR_MR7_Pos = 0x7
	// Bit mask of MR7 field.
	EXTI_EMR_MR7_Msk = 0x80
	// Bit MR7.
	EXTI_EMR_MR7 = 0x80
	// Interrupt request line is masked
	EXTI_EMR_MR7_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR7_Unmasked = 0x1
	// Position of MR8 field.
	EXTI_EMR_MR8_Pos = 0x8
	// Bit mask of MR8 field.
	EXTI_EMR_MR8_Msk = 0x100
	// Bit MR8.
	EXTI_EMR_MR8 = 0x100
	// Interrupt request line is masked
	EXTI_EMR_MR8_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR8_Unmasked = 0x1
	// Position of MR9 field.
	EXTI_EMR_MR9_Pos = 0x9
	// Bit mask of MR9 field.
	EXTI_EMR_MR9_Msk = 0x200
	// Bit MR9.
	EXTI_EMR_MR9 = 0x200
	// Interrupt request line is masked
	EXTI_EMR_MR9_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR9_Unmasked = 0x1
	// Position of MR10 field.
	EXTI_EMR_MR10_Pos = 0xa
	// Bit mask of MR10 field.
	EXTI_EMR_MR10_Msk = 0x400
	// Bit MR10.
	EXTI_EMR_MR10 = 0x400
	// Interrupt request line is masked
	EXTI_EMR_MR10_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR10_Unmasked = 0x1
	// Position of MR11 field.
	EXTI_EMR_MR11_Pos = 0xb
	// Bit mask of MR11 field.
	EXTI_EMR_MR11_Msk = 0x800
	// Bit MR11.
	EXTI_EMR_MR11 = 0x800
	// Interrupt request line is masked
	EXTI_EMR_MR11_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR11_Unmasked = 0x1
	// Position of MR12 field.
	EXTI_EMR_MR12_Pos = 0xc
	// Bit mask of MR12 field.
	EXTI_EMR_MR12_Msk = 0x1000
	// Bit MR12.
	EXTI_EMR_MR12 = 0x1000
	// Interrupt request line is masked
	EXTI_EMR_MR12_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR12_Unmasked = 0x1
	// Position of MR13 field.
	EXTI_EMR_MR13_Pos = 0xd
	// Bit mask of MR13 field.
	EXTI_EMR_MR13_Msk = 0x2000
	// Bit MR13.
	EXTI_EMR_MR13 = 0x2000
	// Interrupt request line is masked
	EXTI_EMR_MR13_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR13_Unmasked = 0x1
	// Position of MR14 field.
	EXTI_EMR_MR14_Pos = 0xe
	// Bit mask of MR14 field.
	EXTI_EMR_MR14_Msk = 0x4000
	// Bit MR14.
	EXTI_EMR_MR14 = 0x4000
	// Interrupt request line is masked
	EXTI_EMR_MR14_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR14_Unmasked = 0x1
	// Position of MR15 field.
	EXTI_EMR_MR15_Pos = 0xf
	// Bit mask of MR15 field.
	EXTI_EMR_MR15_Msk = 0x8000
	// Bit MR15.
	EXTI_EMR_MR15 = 0x8000
	// Interrupt request line is masked
	EXTI_EMR_MR15_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR15_Unmasked = 0x1
	// Position of MR16 field.
	EXTI_EMR_MR16_Pos = 0x10
	// Bit mask of MR16 field.
	EXTI_EMR_MR16_Msk = 0x10000
	// Bit MR16.
	EXTI_EMR_MR16 = 0x10000
	// Interrupt request line is masked
	EXTI_EMR_MR16_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR16_Unmasked = 0x1
	// Position of MR17 field.
	EXTI_EMR_MR17_Pos = 0x11
	// Bit mask of MR17 field.
	EXTI_EMR_MR17_Msk = 0x20000
	// Bit MR17.
	EXTI_EMR_MR17 = 0x20000
	// Interrupt request line is masked
	EXTI_EMR_MR17_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR17_Unmasked = 0x1
	// Position of MR18 field.
	EXTI_EMR_MR18_Pos = 0x12
	// Bit mask of MR18 field.
	EXTI_EMR_MR18_Msk = 0x40000
	// Bit MR18.
	EXTI_EMR_MR18 = 0x40000
	// Interrupt request line is masked
	EXTI_EMR_MR18_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR18_Unmasked = 0x1
	// Position of MR19 field.
	EXTI_EMR_MR19_Pos = 0x13
	// Bit mask of MR19 field.
	EXTI_EMR_MR19_Msk = 0x80000
	// Bit MR19.
	EXTI_EMR_MR19 = 0x80000
	// Interrupt request line is masked
	EXTI_EMR_MR19_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR19_Unmasked = 0x1
	// Position of MR20 field.
	EXTI_EMR_MR20_Pos = 0x14
	// Bit mask of MR20 field.
	EXTI_EMR_MR20_Msk = 0x100000
	// Bit MR20.
	EXTI_EMR_MR20 = 0x100000
	// Interrupt request line is masked
	EXTI_EMR_MR20_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR20_Unmasked = 0x1
	// Position of MR21 field.
	EXTI_EMR_MR21_Pos = 0x15
	// Bit mask of MR21 field.
	EXTI_EMR_MR21_Msk = 0x200000
	// Bit MR21.
	EXTI_EMR_MR21 = 0x200000
	// Interrupt request line is masked
	EXTI_EMR_MR21_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR21_Unmasked = 0x1
	// Position of MR22 field.
	EXTI_EMR_MR22_Pos = 0x16
	// Bit mask of MR22 field.
	EXTI_EMR_MR22_Msk = 0x400000
	// Bit MR22.
	EXTI_EMR_MR22 = 0x400000
	// Interrupt request line is masked
	EXTI_EMR_MR22_Masked = 0x0
	// Interrupt request line is unmasked
	EXTI_EMR_MR22_Unmasked = 0x1

	// RTSR: RTSR
	// Position of TR0 field.
	EXTI_RTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_RTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_RTSR_TR0 = 0x1
	// Rising edge trigger is disabled
	EXTI_RTSR_TR0_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_RTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_RTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_RTSR_TR1 = 0x2
	// Rising edge trigger is disabled
	EXTI_RTSR_TR1_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_RTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_RTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_RTSR_TR2 = 0x4
	// Rising edge trigger is disabled
	EXTI_RTSR_TR2_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_RTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_RTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_RTSR_TR3 = 0x8
	// Rising edge trigger is disabled
	EXTI_RTSR_TR3_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_RTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_RTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_RTSR_TR4 = 0x10
	// Rising edge trigger is disabled
	EXTI_RTSR_TR4_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_RTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_RTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_RTSR_TR5 = 0x20
	// Rising edge trigger is disabled
	EXTI_RTSR_TR5_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_RTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_RTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_RTSR_TR6 = 0x40
	// Rising edge trigger is disabled
	EXTI_RTSR_TR6_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_RTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_RTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_RTSR_TR7 = 0x80
	// Rising edge trigger is disabled
	EXTI_RTSR_TR7_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_RTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_RTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_RTSR_TR8 = 0x100
	// Rising edge trigger is disabled
	EXTI_RTSR_TR8_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_RTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_RTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_RTSR_TR9 = 0x200
	// Rising edge trigger is disabled
	EXTI_RTSR_TR9_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_RTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_RTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_RTSR_TR10 = 0x400
	// Rising edge trigger is disabled
	EXTI_RTSR_TR10_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_RTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_RTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_RTSR_TR11 = 0x800
	// Rising edge trigger is disabled
	EXTI_RTSR_TR11_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_RTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_RTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_RTSR_TR12 = 0x1000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR12_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_RTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_RTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_RTSR_TR13 = 0x2000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR13_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_RTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_RTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_RTSR_TR14 = 0x4000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR14_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_RTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_RTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_RTSR_TR15 = 0x8000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR15_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_RTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_RTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_RTSR_TR16 = 0x10000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR16_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_RTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_RTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_RTSR_TR17 = 0x20000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR17_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_RTSR_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_RTSR_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_RTSR_TR18 = 0x40000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR18_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_RTSR_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_RTSR_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_RTSR_TR19 = 0x80000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR19_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_RTSR_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_RTSR_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_RTSR_TR20 = 0x100000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR20_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_RTSR_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_RTSR_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_RTSR_TR21 = 0x200000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR21_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_RTSR_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_RTSR_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_RTSR_TR22 = 0x400000
	// Rising edge trigger is disabled
	EXTI_RTSR_TR22_Disabled = 0x0
	// Rising edge trigger is enabled
	EXTI_RTSR_TR22_Enabled = 0x1

	// FTSR: FTSR
	// Position of TR0 field.
	EXTI_FTSR_TR0_Pos = 0x0
	// Bit mask of TR0 field.
	EXTI_FTSR_TR0_Msk = 0x1
	// Bit TR0.
	EXTI_FTSR_TR0 = 0x1
	// Falling edge trigger is disabled
	EXTI_FTSR_TR0_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR0_Enabled = 0x1
	// Position of TR1 field.
	EXTI_FTSR_TR1_Pos = 0x1
	// Bit mask of TR1 field.
	EXTI_FTSR_TR1_Msk = 0x2
	// Bit TR1.
	EXTI_FTSR_TR1 = 0x2
	// Falling edge trigger is disabled
	EXTI_FTSR_TR1_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR1_Enabled = 0x1
	// Position of TR2 field.
	EXTI_FTSR_TR2_Pos = 0x2
	// Bit mask of TR2 field.
	EXTI_FTSR_TR2_Msk = 0x4
	// Bit TR2.
	EXTI_FTSR_TR2 = 0x4
	// Falling edge trigger is disabled
	EXTI_FTSR_TR2_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR2_Enabled = 0x1
	// Position of TR3 field.
	EXTI_FTSR_TR3_Pos = 0x3
	// Bit mask of TR3 field.
	EXTI_FTSR_TR3_Msk = 0x8
	// Bit TR3.
	EXTI_FTSR_TR3 = 0x8
	// Falling edge trigger is disabled
	EXTI_FTSR_TR3_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR3_Enabled = 0x1
	// Position of TR4 field.
	EXTI_FTSR_TR4_Pos = 0x4
	// Bit mask of TR4 field.
	EXTI_FTSR_TR4_Msk = 0x10
	// Bit TR4.
	EXTI_FTSR_TR4 = 0x10
	// Falling edge trigger is disabled
	EXTI_FTSR_TR4_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR4_Enabled = 0x1
	// Position of TR5 field.
	EXTI_FTSR_TR5_Pos = 0x5
	// Bit mask of TR5 field.
	EXTI_FTSR_TR5_Msk = 0x20
	// Bit TR5.
	EXTI_FTSR_TR5 = 0x20
	// Falling edge trigger is disabled
	EXTI_FTSR_TR5_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR5_Enabled = 0x1
	// Position of TR6 field.
	EXTI_FTSR_TR6_Pos = 0x6
	// Bit mask of TR6 field.
	EXTI_FTSR_TR6_Msk = 0x40
	// Bit TR6.
	EXTI_FTSR_TR6 = 0x40
	// Falling edge trigger is disabled
	EXTI_FTSR_TR6_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR6_Enabled = 0x1
	// Position of TR7 field.
	EXTI_FTSR_TR7_Pos = 0x7
	// Bit mask of TR7 field.
	EXTI_FTSR_TR7_Msk = 0x80
	// Bit TR7.
	EXTI_FTSR_TR7 = 0x80
	// Falling edge trigger is disabled
	EXTI_FTSR_TR7_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR7_Enabled = 0x1
	// Position of TR8 field.
	EXTI_FTSR_TR8_Pos = 0x8
	// Bit mask of TR8 field.
	EXTI_FTSR_TR8_Msk = 0x100
	// Bit TR8.
	EXTI_FTSR_TR8 = 0x100
	// Falling edge trigger is disabled
	EXTI_FTSR_TR8_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR8_Enabled = 0x1
	// Position of TR9 field.
	EXTI_FTSR_TR9_Pos = 0x9
	// Bit mask of TR9 field.
	EXTI_FTSR_TR9_Msk = 0x200
	// Bit TR9.
	EXTI_FTSR_TR9 = 0x200
	// Falling edge trigger is disabled
	EXTI_FTSR_TR9_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR9_Enabled = 0x1
	// Position of TR10 field.
	EXTI_FTSR_TR10_Pos = 0xa
	// Bit mask of TR10 field.
	EXTI_FTSR_TR10_Msk = 0x400
	// Bit TR10.
	EXTI_FTSR_TR10 = 0x400
	// Falling edge trigger is disabled
	EXTI_FTSR_TR10_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR10_Enabled = 0x1
	// Position of TR11 field.
	EXTI_FTSR_TR11_Pos = 0xb
	// Bit mask of TR11 field.
	EXTI_FTSR_TR11_Msk = 0x800
	// Bit TR11.
	EXTI_FTSR_TR11 = 0x800
	// Falling edge trigger is disabled
	EXTI_FTSR_TR11_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR11_Enabled = 0x1
	// Position of TR12 field.
	EXTI_FTSR_TR12_Pos = 0xc
	// Bit mask of TR12 field.
	EXTI_FTSR_TR12_Msk = 0x1000
	// Bit TR12.
	EXTI_FTSR_TR12 = 0x1000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR12_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR12_Enabled = 0x1
	// Position of TR13 field.
	EXTI_FTSR_TR13_Pos = 0xd
	// Bit mask of TR13 field.
	EXTI_FTSR_TR13_Msk = 0x2000
	// Bit TR13.
	EXTI_FTSR_TR13 = 0x2000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR13_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR13_Enabled = 0x1
	// Position of TR14 field.
	EXTI_FTSR_TR14_Pos = 0xe
	// Bit mask of TR14 field.
	EXTI_FTSR_TR14_Msk = 0x4000
	// Bit TR14.
	EXTI_FTSR_TR14 = 0x4000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR14_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR14_Enabled = 0x1
	// Position of TR15 field.
	EXTI_FTSR_TR15_Pos = 0xf
	// Bit mask of TR15 field.
	EXTI_FTSR_TR15_Msk = 0x8000
	// Bit TR15.
	EXTI_FTSR_TR15 = 0x8000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR15_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR15_Enabled = 0x1
	// Position of TR16 field.
	EXTI_FTSR_TR16_Pos = 0x10
	// Bit mask of TR16 field.
	EXTI_FTSR_TR16_Msk = 0x10000
	// Bit TR16.
	EXTI_FTSR_TR16 = 0x10000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR16_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR16_Enabled = 0x1
	// Position of TR17 field.
	EXTI_FTSR_TR17_Pos = 0x11
	// Bit mask of TR17 field.
	EXTI_FTSR_TR17_Msk = 0x20000
	// Bit TR17.
	EXTI_FTSR_TR17 = 0x20000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR17_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR17_Enabled = 0x1
	// Position of TR18 field.
	EXTI_FTSR_TR18_Pos = 0x12
	// Bit mask of TR18 field.
	EXTI_FTSR_TR18_Msk = 0x40000
	// Bit TR18.
	EXTI_FTSR_TR18 = 0x40000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR18_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR18_Enabled = 0x1
	// Position of TR19 field.
	EXTI_FTSR_TR19_Pos = 0x13
	// Bit mask of TR19 field.
	EXTI_FTSR_TR19_Msk = 0x80000
	// Bit TR19.
	EXTI_FTSR_TR19 = 0x80000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR19_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR19_Enabled = 0x1
	// Position of TR20 field.
	EXTI_FTSR_TR20_Pos = 0x14
	// Bit mask of TR20 field.
	EXTI_FTSR_TR20_Msk = 0x100000
	// Bit TR20.
	EXTI_FTSR_TR20 = 0x100000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR20_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR20_Enabled = 0x1
	// Position of TR21 field.
	EXTI_FTSR_TR21_Pos = 0x15
	// Bit mask of TR21 field.
	EXTI_FTSR_TR21_Msk = 0x200000
	// Bit TR21.
	EXTI_FTSR_TR21 = 0x200000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR21_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR21_Enabled = 0x1
	// Position of TR22 field.
	EXTI_FTSR_TR22_Pos = 0x16
	// Bit mask of TR22 field.
	EXTI_FTSR_TR22_Msk = 0x400000
	// Bit TR22.
	EXTI_FTSR_TR22 = 0x400000
	// Falling edge trigger is disabled
	EXTI_FTSR_TR22_Disabled = 0x0
	// Falling edge trigger is enabled
	EXTI_FTSR_TR22_Enabled = 0x1

	// SWIER: SWIER
	// Position of SWIER0 field.
	EXTI_SWIER_SWIER0_Pos = 0x0
	// Bit mask of SWIER0 field.
	EXTI_SWIER_SWIER0_Msk = 0x1
	// Bit SWIER0.
	EXTI_SWIER_SWIER0 = 0x1
	// Generates an interrupt request
	EXTI_SWIER_SWIER0_Pend = 0x1
	// Position of SWIER1 field.
	EXTI_SWIER_SWIER1_Pos = 0x1
	// Bit mask of SWIER1 field.
	EXTI_SWIER_SWIER1_Msk = 0x2
	// Bit SWIER1.
	EXTI_SWIER_SWIER1 = 0x2
	// Generates an interrupt request
	EXTI_SWIER_SWIER1_Pend = 0x1
	// Position of SWIER2 field.
	EXTI_SWIER_SWIER2_Pos = 0x2
	// Bit mask of SWIER2 field.
	EXTI_SWIER_SWIER2_Msk = 0x4
	// Bit SWIER2.
	EXTI_SWIER_SWIER2 = 0x4
	// Generates an interrupt request
	EXTI_SWIER_SWIER2_Pend = 0x1
	// Position of SWIER3 field.
	EXTI_SWIER_SWIER3_Pos = 0x3
	// Bit mask of SWIER3 field.
	EXTI_SWIER_SWIER3_Msk = 0x8
	// Bit SWIER3.
	EXTI_SWIER_SWIER3 = 0x8
	// Generates an interrupt request
	EXTI_SWIER_SWIER3_Pend = 0x1
	// Position of SWIER4 field.
	EXTI_SWIER_SWIER4_Pos = 0x4
	// Bit mask of SWIER4 field.
	EXTI_SWIER_SWIER4_Msk = 0x10
	// Bit SWIER4.
	EXTI_SWIER_SWIER4 = 0x10
	// Generates an interrupt request
	EXTI_SWIER_SWIER4_Pend = 0x1
	// Position of SWIER5 field.
	EXTI_SWIER_SWIER5_Pos = 0x5
	// Bit mask of SWIER5 field.
	EXTI_SWIER_SWIER5_Msk = 0x20
	// Bit SWIER5.
	EXTI_SWIER_SWIER5 = 0x20
	// Generates an interrupt request
	EXTI_SWIER_SWIER5_Pend = 0x1
	// Position of SWIER6 field.
	EXTI_SWIER_SWIER6_Pos = 0x6
	// Bit mask of SWIER6 field.
	EXTI_SWIER_SWIER6_Msk = 0x40
	// Bit SWIER6.
	EXTI_SWIER_SWIER6 = 0x40
	// Generates an interrupt request
	EXTI_SWIER_SWIER6_Pend = 0x1
	// Position of SWIER7 field.
	EXTI_SWIER_SWIER7_Pos = 0x7
	// Bit mask of SWIER7 field.
	EXTI_SWIER_SWIER7_Msk = 0x80
	// Bit SWIER7.
	EXTI_SWIER_SWIER7 = 0x80
	// Generates an interrupt request
	EXTI_SWIER_SWIER7_Pend = 0x1
	// Position of SWIER8 field.
	EXTI_SWIER_SWIER8_Pos = 0x8
	// Bit mask of SWIER8 field.
	EXTI_SWIER_SWIER8_Msk = 0x100
	// Bit SWIER8.
	EXTI_SWIER_SWIER8 = 0x100
	// Generates an interrupt request
	EXTI_SWIER_SWIER8_Pend = 0x1
	// Position of SWIER9 field.
	EXTI_SWIER_SWIER9_Pos = 0x9
	// Bit mask of SWIER9 field.
	EXTI_SWIER_SWIER9_Msk = 0x200
	// Bit SWIER9.
	EXTI_SWIER_SWIER9 = 0x200
	// Generates an interrupt request
	EXTI_SWIER_SWIER9_Pend = 0x1
	// Position of SWIER10 field.
	EXTI_SWIER_SWIER10_Pos = 0xa
	// Bit mask of SWIER10 field.
	EXTI_SWIER_SWIER10_Msk = 0x400
	// Bit SWIER10.
	EXTI_SWIER_SWIER10 = 0x400
	// Generates an interrupt request
	EXTI_SWIER_SWIER10_Pend = 0x1
	// Position of SWIER11 field.
	EXTI_SWIER_SWIER11_Pos = 0xb
	// Bit mask of SWIER11 field.
	EXTI_SWIER_SWIER11_Msk = 0x800
	// Bit SWIER11.
	EXTI_SWIER_SWIER11 = 0x800
	// Generates an interrupt request
	EXTI_SWIER_SWIER11_Pend = 0x1
	// Position of SWIER12 field.
	EXTI_SWIER_SWIER12_Pos = 0xc
	// Bit mask of SWIER12 field.
	EXTI_SWIER_SWIER12_Msk = 0x1000
	// Bit SWIER12.
	EXTI_SWIER_SWIER12 = 0x1000
	// Generates an interrupt request
	EXTI_SWIER_SWIER12_Pend = 0x1
	// Position of SWIER13 field.
	EXTI_SWIER_SWIER13_Pos = 0xd
	// Bit mask of SWIER13 field.
	EXTI_SWIER_SWIER13_Msk = 0x2000
	// Bit SWIER13.
	EXTI_SWIER_SWIER13 = 0x2000
	// Generates an interrupt request
	EXTI_SWIER_SWIER13_Pend = 0x1
	// Position of SWIER14 field.
	EXTI_SWIER_SWIER14_Pos = 0xe
	// Bit mask of SWIER14 field.
	EXTI_SWIER_SWIER14_Msk = 0x4000
	// Bit SWIER14.
	EXTI_SWIER_SWIER14 = 0x4000
	// Generates an interrupt request
	EXTI_SWIER_SWIER14_Pend = 0x1
	// Position of SWIER15 field.
	EXTI_SWIER_SWIER15_Pos = 0xf
	// Bit mask of SWIER15 field.
	EXTI_SWIER_SWIER15_Msk = 0x8000
	// Bit SWIER15.
	EXTI_SWIER_SWIER15 = 0x8000
	// Generates an interrupt request
	EXTI_SWIER_SWIER15_Pend = 0x1
	// Position of SWIER16 field.
	EXTI_SWIER_SWIER16_Pos = 0x10
	// Bit mask of SWIER16 field.
	EXTI_SWIER_SWIER16_Msk = 0x10000
	// Bit SWIER16.
	EXTI_SWIER_SWIER16 = 0x10000
	// Generates an interrupt request
	EXTI_SWIER_SWIER16_Pend = 0x1
	// Position of SWIER17 field.
	EXTI_SWIER_SWIER17_Pos = 0x11
	// Bit mask of SWIER17 field.
	EXTI_SWIER_SWIER17_Msk = 0x20000
	// Bit SWIER17.
	EXTI_SWIER_SWIER17 = 0x20000
	// Generates an interrupt request
	EXTI_SWIER_SWIER17_Pend = 0x1
	// Position of SWIER18 field.
	EXTI_SWIER_SWIER18_Pos = 0x12
	// Bit mask of SWIER18 field.
	EXTI_SWIER_SWIER18_Msk = 0x40000
	// Bit SWIER18.
	EXTI_SWIER_SWIER18 = 0x40000
	// Generates an interrupt request
	EXTI_SWIER_SWIER18_Pend = 0x1
	// Position of SWIER19 field.
	EXTI_SWIER_SWIER19_Pos = 0x13
	// Bit mask of SWIER19 field.
	EXTI_SWIER_SWIER19_Msk = 0x80000
	// Bit SWIER19.
	EXTI_SWIER_SWIER19 = 0x80000
	// Generates an interrupt request
	EXTI_SWIER_SWIER19_Pend = 0x1
	// Position of SWIER20 field.
	EXTI_SWIER_SWIER20_Pos = 0x14
	// Bit mask of SWIER20 field.
	EXTI_SWIER_SWIER20_Msk = 0x100000
	// Bit SWIER20.
	EXTI_SWIER_SWIER20 = 0x100000
	// Generates an interrupt request
	EXTI_SWIER_SWIER20_Pend = 0x1
	// Position of SWIER21 field.
	EXTI_SWIER_SWIER21_Pos = 0x15
	// Bit mask of SWIER21 field.
	EXTI_SWIER_SWIER21_Msk = 0x200000
	// Bit SWIER21.
	EXTI_SWIER_SWIER21 = 0x200000
	// Generates an interrupt request
	EXTI_SWIER_SWIER21_Pend = 0x1
	// Position of SWIER22 field.
	EXTI_SWIER_SWIER22_Pos = 0x16
	// Bit mask of SWIER22 field.
	EXTI_SWIER_SWIER22_Msk = 0x400000
	// Bit SWIER22.
	EXTI_SWIER_SWIER22 = 0x400000
	// Generates an interrupt request
	EXTI_SWIER_SWIER22_Pend = 0x1

	// PR: PR
	// Position of PR0 field.
	EXTI_PR_PR0_Pos = 0x0
	// Bit mask of PR0 field.
	EXTI_PR_PR0_Msk = 0x1
	// Bit PR0.
	EXTI_PR_PR0 = 0x1
	// No trigger request occurred
	EXTI_PR_PR0_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR0_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR0_Clear = 0x1
	// Position of PR1 field.
	EXTI_PR_PR1_Pos = 0x1
	// Bit mask of PR1 field.
	EXTI_PR_PR1_Msk = 0x2
	// Bit PR1.
	EXTI_PR_PR1 = 0x2
	// No trigger request occurred
	EXTI_PR_PR1_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR1_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR1_Clear = 0x1
	// Position of PR2 field.
	EXTI_PR_PR2_Pos = 0x2
	// Bit mask of PR2 field.
	EXTI_PR_PR2_Msk = 0x4
	// Bit PR2.
	EXTI_PR_PR2 = 0x4
	// No trigger request occurred
	EXTI_PR_PR2_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR2_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR2_Clear = 0x1
	// Position of PR3 field.
	EXTI_PR_PR3_Pos = 0x3
	// Bit mask of PR3 field.
	EXTI_PR_PR3_Msk = 0x8
	// Bit PR3.
	EXTI_PR_PR3 = 0x8
	// No trigger request occurred
	EXTI_PR_PR3_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR3_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR3_Clear = 0x1
	// Position of PR4 field.
	EXTI_PR_PR4_Pos = 0x4
	// Bit mask of PR4 field.
	EXTI_PR_PR4_Msk = 0x10
	// Bit PR4.
	EXTI_PR_PR4 = 0x10
	// No trigger request occurred
	EXTI_PR_PR4_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR4_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR4_Clear = 0x1
	// Position of PR5 field.
	EXTI_PR_PR5_Pos = 0x5
	// Bit mask of PR5 field.
	EXTI_PR_PR5_Msk = 0x20
	// Bit PR5.
	EXTI_PR_PR5 = 0x20
	// No trigger request occurred
	EXTI_PR_PR5_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR5_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR5_Clear = 0x1
	// Position of PR6 field.
	EXTI_PR_PR6_Pos = 0x6
	// Bit mask of PR6 field.
	EXTI_PR_PR6_Msk = 0x40
	// Bit PR6.
	EXTI_PR_PR6 = 0x40
	// No trigger request occurred
	EXTI_PR_PR6_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR6_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR6_Clear = 0x1
	// Position of PR7 field.
	EXTI_PR_PR7_Pos = 0x7
	// Bit mask of PR7 field.
	EXTI_PR_PR7_Msk = 0x80
	// Bit PR7.
	EXTI_PR_PR7 = 0x80
	// No trigger request occurred
	EXTI_PR_PR7_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR7_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR7_Clear = 0x1
	// Position of PR8 field.
	EXTI_PR_PR8_Pos = 0x8
	// Bit mask of PR8 field.
	EXTI_PR_PR8_Msk = 0x100
	// Bit PR8.
	EXTI_PR_PR8 = 0x100
	// No trigger request occurred
	EXTI_PR_PR8_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR8_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR8_Clear = 0x1
	// Position of PR9 field.
	EXTI_PR_PR9_Pos = 0x9
	// Bit mask of PR9 field.
	EXTI_PR_PR9_Msk = 0x200
	// Bit PR9.
	EXTI_PR_PR9 = 0x200
	// No trigger request occurred
	EXTI_PR_PR9_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR9_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR9_Clear = 0x1
	// Position of PR10 field.
	EXTI_PR_PR10_Pos = 0xa
	// Bit mask of PR10 field.
	EXTI_PR_PR10_Msk = 0x400
	// Bit PR10.
	EXTI_PR_PR10 = 0x400
	// No trigger request occurred
	EXTI_PR_PR10_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR10_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR10_Clear = 0x1
	// Position of PR11 field.
	EXTI_PR_PR11_Pos = 0xb
	// Bit mask of PR11 field.
	EXTI_PR_PR11_Msk = 0x800
	// Bit PR11.
	EXTI_PR_PR11 = 0x800
	// No trigger request occurred
	EXTI_PR_PR11_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR11_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR11_Clear = 0x1
	// Position of PR12 field.
	EXTI_PR_PR12_Pos = 0xc
	// Bit mask of PR12 field.
	EXTI_PR_PR12_Msk = 0x1000
	// Bit PR12.
	EXTI_PR_PR12 = 0x1000
	// No trigger request occurred
	EXTI_PR_PR12_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR12_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR12_Clear = 0x1
	// Position of PR13 field.
	EXTI_PR_PR13_Pos = 0xd
	// Bit mask of PR13 field.
	EXTI_PR_PR13_Msk = 0x2000
	// Bit PR13.
	EXTI_PR_PR13 = 0x2000
	// No trigger request occurred
	EXTI_PR_PR13_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR13_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR13_Clear = 0x1
	// Position of PR14 field.
	EXTI_PR_PR14_Pos = 0xe
	// Bit mask of PR14 field.
	EXTI_PR_PR14_Msk = 0x4000
	// Bit PR14.
	EXTI_PR_PR14 = 0x4000
	// No trigger request occurred
	EXTI_PR_PR14_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR14_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR14_Clear = 0x1
	// Position of PR15 field.
	EXTI_PR_PR15_Pos = 0xf
	// Bit mask of PR15 field.
	EXTI_PR_PR15_Msk = 0x8000
	// Bit PR15.
	EXTI_PR_PR15 = 0x8000
	// No trigger request occurred
	EXTI_PR_PR15_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR15_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR15_Clear = 0x1
	// Position of PR16 field.
	EXTI_PR_PR16_Pos = 0x10
	// Bit mask of PR16 field.
	EXTI_PR_PR16_Msk = 0x10000
	// Bit PR16.
	EXTI_PR_PR16 = 0x10000
	// No trigger request occurred
	EXTI_PR_PR16_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR16_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR16_Clear = 0x1
	// Position of PR17 field.
	EXTI_PR_PR17_Pos = 0x11
	// Bit mask of PR17 field.
	EXTI_PR_PR17_Msk = 0x20000
	// Bit PR17.
	EXTI_PR_PR17 = 0x20000
	// No trigger request occurred
	EXTI_PR_PR17_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR17_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR17_Clear = 0x1
	// Position of PR18 field.
	EXTI_PR_PR18_Pos = 0x12
	// Bit mask of PR18 field.
	EXTI_PR_PR18_Msk = 0x40000
	// Bit PR18.
	EXTI_PR_PR18 = 0x40000
	// No trigger request occurred
	EXTI_PR_PR18_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR18_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR18_Clear = 0x1
	// Position of PR19 field.
	EXTI_PR_PR19_Pos = 0x13
	// Bit mask of PR19 field.
	EXTI_PR_PR19_Msk = 0x80000
	// Bit PR19.
	EXTI_PR_PR19 = 0x80000
	// No trigger request occurred
	EXTI_PR_PR19_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR19_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR19_Clear = 0x1
	// Position of PR20 field.
	EXTI_PR_PR20_Pos = 0x14
	// Bit mask of PR20 field.
	EXTI_PR_PR20_Msk = 0x100000
	// Bit PR20.
	EXTI_PR_PR20 = 0x100000
	// No trigger request occurred
	EXTI_PR_PR20_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR20_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR20_Clear = 0x1
	// Position of PR21 field.
	EXTI_PR_PR21_Pos = 0x15
	// Bit mask of PR21 field.
	EXTI_PR_PR21_Msk = 0x200000
	// Bit PR21.
	EXTI_PR_PR21 = 0x200000
	// No trigger request occurred
	EXTI_PR_PR21_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR21_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR21_Clear = 0x1
	// Position of PR22 field.
	EXTI_PR_PR22_Pos = 0x16
	// Bit mask of PR22 field.
	EXTI_PR_PR22_Msk = 0x400000
	// Bit PR22.
	EXTI_PR_PR22 = 0x400000
	// No trigger request occurred
	EXTI_PR_PR22_NotPending = 0x0
	// Selected trigger request occurred
	EXTI_PR_PR22_Pending = 0x1
	// Clears pending bit
	EXTI_PR_PR22_Clear = 0x1
)

// Constants for Flash: Flash
const (
	// ACR: Access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x1
	// Bit LATENCY.
	Flash_ACR_LATENCY = 0x1
	// Position of PRFTEN field.
	Flash_ACR_PRFTEN_Pos = 0x1
	// Bit mask of PRFTEN field.
	Flash_ACR_PRFTEN_Msk = 0x2
	// Bit PRFTEN.
	Flash_ACR_PRFTEN = 0x2
	// Position of ACC64 field.
	Flash_ACR_ACC64_Pos = 0x2
	// Bit mask of ACC64 field.
	Flash_ACR_ACC64_Msk = 0x4
	// Bit ACC64.
	Flash_ACR_ACC64 = 0x4
	// Position of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Pos = 0x3
	// Bit mask of SLEEP_PD field.
	Flash_ACR_SLEEP_PD_Msk = 0x8
	// Bit SLEEP_PD.
	Flash_ACR_SLEEP_PD = 0x8
	// Position of RUN_PD field.
	Flash_ACR_RUN_PD_Pos = 0x4
	// Bit mask of RUN_PD field.
	Flash_ACR_RUN_PD_Msk = 0x10
	// Bit RUN_PD.
	Flash_ACR_RUN_PD = 0x10

	// PECR: Program/erase control register
	// Position of PELOCK field.
	Flash_PECR_PELOCK_Pos = 0x0
	// Bit mask of PELOCK field.
	Flash_PECR_PELOCK_Msk = 0x1
	// Bit PELOCK.
	Flash_PECR_PELOCK = 0x1
	// Position of PRGLOCK field.
	Flash_PECR_PRGLOCK_Pos = 0x1
	// Bit mask of PRGLOCK field.
	Flash_PECR_PRGLOCK_Msk = 0x2
	// Bit PRGLOCK.
	Flash_PECR_PRGLOCK = 0x2
	// Position of OPTLOCK field.
	Flash_PECR_OPTLOCK_Pos = 0x2
	// Bit mask of OPTLOCK field.
	Flash_PECR_OPTLOCK_Msk = 0x4
	// Bit OPTLOCK.
	Flash_PECR_OPTLOCK = 0x4
	// Position of PROG field.
	Flash_PECR_PROG_Pos = 0x3
	// Bit mask of PROG field.
	Flash_PECR_PROG_Msk = 0x8
	// Bit PROG.
	Flash_PECR_PROG = 0x8
	// Position of DATA field.
	Flash_PECR_DATA_Pos = 0x4
	// Bit mask of DATA field.
	Flash_PECR_DATA_Msk = 0x10
	// Bit DATA.
	Flash_PECR_DATA = 0x10
	// Position of FTDW field.
	Flash_PECR_FTDW_Pos = 0x8
	// Bit mask of FTDW field.
	Flash_PECR_FTDW_Msk = 0x100
	// Bit FTDW.
	Flash_PECR_FTDW = 0x100
	// Position of ERASE field.
	Flash_PECR_ERASE_Pos = 0x9
	// Bit mask of ERASE field.
	Flash_PECR_ERASE_Msk = 0x200
	// Bit ERASE.
	Flash_PECR_ERASE = 0x200
	// Position of FPRG field.
	Flash_PECR_FPRG_Pos = 0xa
	// Bit mask of FPRG field.
	Flash_PECR_FPRG_Msk = 0x400
	// Bit FPRG.
	Flash_PECR_FPRG = 0x400
	// Position of PARALLELBANK field.
	Flash_PECR_PARALLELBANK_Pos = 0xf
	// Bit mask of PARALLELBANK field.
	Flash_PECR_PARALLELBANK_Msk = 0x8000
	// Bit PARALLELBANK.
	Flash_PECR_PARALLELBANK = 0x8000
	// Position of EOPIE field.
	Flash_PECR_EOPIE_Pos = 0x10
	// Bit mask of EOPIE field.
	Flash_PECR_EOPIE_Msk = 0x10000
	// Bit EOPIE.
	Flash_PECR_EOPIE = 0x10000
	// Position of ERRIE field.
	Flash_PECR_ERRIE_Pos = 0x11
	// Bit mask of ERRIE field.
	Flash_PECR_ERRIE_Msk = 0x20000
	// Bit ERRIE.
	Flash_PECR_ERRIE = 0x20000
	// Position of OBL_LAUNCH field.
	Flash_PECR_OBL_LAUNCH_Pos = 0x12
	// Bit mask of OBL_LAUNCH field.
	Flash_PECR_OBL_LAUNCH_Msk = 0x40000
	// Bit OBL_LAUNCH.
	Flash_PECR_OBL_LAUNCH = 0x40000

	// PDKEYR: Power down key register
	// Position of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Pos = 0x0
	// Bit mask of PDKEYR field.
	Flash_PDKEYR_PDKEYR_Msk = 0xffffffff

	// PEKEYR: Program/erase key register
	// Position of PEKEYR field.
	Flash_PEKEYR_PEKEYR_Pos = 0x0
	// Bit mask of PEKEYR field.
	Flash_PEKEYR_PEKEYR_Msk = 0xffffffff

	// PRGKEYR: Program memory key register
	// Position of PRGKEYR field.
	Flash_PRGKEYR_PRGKEYR_Pos = 0x0
	// Bit mask of PRGKEYR field.
	Flash_PRGKEYR_PRGKEYR_Msk = 0xffffffff

	// OPTKEYR: Option byte key register
	// Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0
	// Bit mask of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff

	// SR: Status register
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x0
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x1
	// Bit BSY.
	Flash_SR_BSY = 0x1
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x1
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x2
	// Bit EOP.
	Flash_SR_EOP = 0x2
	// Position of ENDHV field.
	Flash_SR_ENDHV_Pos = 0x2
	// Bit mask of ENDHV field.
	Flash_SR_ENDHV_Msk = 0x4
	// Bit ENDHV.
	Flash_SR_ENDHV = 0x4
	// Position of READY field.
	Flash_SR_READY_Pos = 0x3
	// Bit mask of READY field.
	Flash_SR_READY_Msk = 0x8
	// Bit READY.
	Flash_SR_READY = 0x8
	// Position of WRPERR field.
	Flash_SR_WRPERR_Pos = 0x8
	// Bit mask of WRPERR field.
	Flash_SR_WRPERR_Msk = 0x100
	// Bit WRPERR.
	Flash_SR_WRPERR = 0x100
	// Position of PGAERR field.
	Flash_SR_PGAERR_Pos = 0x9
	// Bit mask of PGAERR field.
	Flash_SR_PGAERR_Msk = 0x200
	// Bit PGAERR.
	Flash_SR_PGAERR = 0x200
	// Position of SIZERR field.
	Flash_SR_SIZERR_Pos = 0xa
	// Bit mask of SIZERR field.
	Flash_SR_SIZERR_Msk = 0x400
	// Bit SIZERR.
	Flash_SR_SIZERR = 0x400
	// Position of OPTVERR field.
	Flash_SR_OPTVERR_Pos = 0xb
	// Bit mask of OPTVERR field.
	Flash_SR_OPTVERR_Msk = 0x800
	// Bit OPTVERR.
	Flash_SR_OPTVERR = 0x800
	// Position of OPTVERRUSR field.
	Flash_SR_OPTVERRUSR_Pos = 0xc
	// Bit mask of OPTVERRUSR field.
	Flash_SR_OPTVERRUSR_Msk = 0x1000
	// Bit OPTVERRUSR.
	Flash_SR_OPTVERRUSR = 0x1000

	// OBR: Option byte register
	// Position of RDPRT field.
	Flash_OBR_RDPRT_Pos = 0x0
	// Bit mask of RDPRT field.
	Flash_OBR_RDPRT_Msk = 0xff
	// Position of BOR_LEV field.
	Flash_OBR_BOR_LEV_Pos = 0x10
	// Bit mask of BOR_LEV field.
	Flash_OBR_BOR_LEV_Msk = 0xf0000
	// Position of IWDG_SW field.
	Flash_OBR_IWDG_SW_Pos = 0x14
	// Bit mask of IWDG_SW field.
	Flash_OBR_IWDG_SW_Msk = 0x100000
	// Bit IWDG_SW.
	Flash_OBR_IWDG_SW = 0x100000
	// Position of NRTS_STOP field.
	Flash_OBR_NRTS_STOP_Pos = 0x15
	// Bit mask of NRTS_STOP field.
	Flash_OBR_NRTS_STOP_Msk = 0x200000
	// Bit NRTS_STOP.
	Flash_OBR_NRTS_STOP = 0x200000
	// Position of NRST_STDBY field.
	Flash_OBR_NRST_STDBY_Pos = 0x16
	// Bit mask of NRST_STDBY field.
	Flash_OBR_NRST_STDBY_Msk = 0x400000
	// Bit NRST_STDBY.
	Flash_OBR_NRST_STDBY = 0x400000
	// Position of BFB2 field.
	Flash_OBR_BFB2_Pos = 0x17
	// Bit mask of BFB2 field.
	Flash_OBR_BFB2_Msk = 0x800000
	// Bit BFB2.
	Flash_OBR_BFB2 = 0x800000

	// WRPR1: Write protection register
	// Position of WRP1 field.
	Flash_WRPR1_WRP1_Pos = 0x0
	// Bit mask of WRP1 field.
	Flash_WRPR1_WRP1_Msk = 0xffffffff

	// WRPR2: Write protection register
	// Position of WRP2 field.
	Flash_WRPR2_WRP2_Pos = 0x0
	// Bit mask of WRP2 field.
	Flash_WRPR2_WRP2_Msk = 0xffffffff

	// WRPR3: Write protection register
	// Position of WRP3 field.
	Flash_WRPR3_WRP3_Pos = 0x0
	// Bit mask of WRP3 field.
	Flash_WRPR3_WRP3_Msk = 0xffffffff
)

// Constants for FSMC: Flexible static memory controller
const (
	// BCR1: BCR1
	// Position of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR1_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR1_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR1_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR1_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR1_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR1_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR1_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR1_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR1_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR1_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR1_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR1_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR1_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR1_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR1_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR1_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR1_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR1_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR1_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR1_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR1_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR1_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR1_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR1_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR1_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR1_WAITCFG_DuringWaitState = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR1_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR1_WRAPMOD = 0x400
	// Position of WAITPOL field.
	FSMC_BCR1_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR1_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR1_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR1_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR1_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR1_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR1_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR1_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR1_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR1_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR1_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR1_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR1_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR1_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR1_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR1_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR1_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR1_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR1_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR1_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR1_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR1_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR1_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR1_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR1_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR1_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR1_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR1_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR1_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR1_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR1_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR1_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR1_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR1_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR1_MBKEN_Enabled = 0x1
	// Position of CPSIZE field.
	FSMC_BCR1_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR1_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR1_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR1_CPSIZE_Bytes1024 = 0x4

	// BTR1: BTR1
	// Position of ACCMOD field.
	FSMC_BTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BTR_CLKDIV_Msk = 0xf00000
	// Position of BUSTURN field.
	FSMC_BTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BTR_BUSTURN_Msk = 0xf0000
	// Position of DATAST field.
	FSMC_BTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BTR_ADDSET_Msk = 0xf

	// BCR2: BCR2
	// Position of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Pos = 0x13
	// Bit mask of CBURSTRW field.
	FSMC_BCR_CBURSTRW_Msk = 0x80000
	// Bit CBURSTRW.
	FSMC_BCR_CBURSTRW = 0x80000
	// Write operations are performed in synchronous mode
	FSMC_BCR_CBURSTRW_Enabled = 0x1
	// Write operations are always performed in asynchronous mode
	FSMC_BCR_CBURSTRW_Disabled = 0x0
	// Position of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Pos = 0xf
	// Bit mask of ASYNCWAIT field.
	FSMC_BCR_ASYNCWAIT_Msk = 0x8000
	// Bit ASYNCWAIT.
	FSMC_BCR_ASYNCWAIT = 0x8000
	// Wait signal not used in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Disabled = 0x0
	// Wait signal used even in asynchronous mode
	FSMC_BCR_ASYNCWAIT_Enabled = 0x1
	// Position of EXTMOD field.
	FSMC_BCR_EXTMOD_Pos = 0xe
	// Bit mask of EXTMOD field.
	FSMC_BCR_EXTMOD_Msk = 0x4000
	// Bit EXTMOD.
	FSMC_BCR_EXTMOD = 0x4000
	// Values inside the FMC_BWTR are not taken into account
	FSMC_BCR_EXTMOD_Disabled = 0x0
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_EXTMOD_Enabled = 0x1
	// Position of WAITEN field.
	FSMC_BCR_WAITEN_Pos = 0xd
	// Bit mask of WAITEN field.
	FSMC_BCR_WAITEN_Msk = 0x2000
	// Bit WAITEN.
	FSMC_BCR_WAITEN = 0x2000
	// Values inside the FMC_BWTR are taken into account
	FSMC_BCR_WAITEN_Disabled = 0x0
	// NWAIT signal enabled
	FSMC_BCR_WAITEN_Enabled = 0x1
	// Position of WREN field.
	FSMC_BCR_WREN_Pos = 0xc
	// Bit mask of WREN field.
	FSMC_BCR_WREN_Msk = 0x1000
	// Bit WREN.
	FSMC_BCR_WREN = 0x1000
	// Write operations disabled for the bank by the FMC
	FSMC_BCR_WREN_Disabled = 0x0
	// Write operations enabled for the bank by the FMC
	FSMC_BCR_WREN_Enabled = 0x1
	// Position of WAITCFG field.
	FSMC_BCR_WAITCFG_Pos = 0xb
	// Bit mask of WAITCFG field.
	FSMC_BCR_WAITCFG_Msk = 0x800
	// Bit WAITCFG.
	FSMC_BCR_WAITCFG = 0x800
	// NWAIT signal is active one data cycle before wait state
	FSMC_BCR_WAITCFG_BeforeWaitState = 0x0
	// NWAIT signal is active during wait state
	FSMC_BCR_WAITCFG_DuringWaitState = 0x1
	// Position of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Pos = 0xa
	// Bit mask of WRAPMOD field.
	FSMC_BCR_WRAPMOD_Msk = 0x400
	// Bit WRAPMOD.
	FSMC_BCR_WRAPMOD = 0x400
	// Position of WAITPOL field.
	FSMC_BCR_WAITPOL_Pos = 0x9
	// Bit mask of WAITPOL field.
	FSMC_BCR_WAITPOL_Msk = 0x200
	// Bit WAITPOL.
	FSMC_BCR_WAITPOL = 0x200
	// NWAIT active low
	FSMC_BCR_WAITPOL_ActiveLow = 0x0
	// NWAIT active high
	FSMC_BCR_WAITPOL_ActiveHigh = 0x1
	// Position of BURSTEN field.
	FSMC_BCR_BURSTEN_Pos = 0x8
	// Bit mask of BURSTEN field.
	FSMC_BCR_BURSTEN_Msk = 0x100
	// Bit BURSTEN.
	FSMC_BCR_BURSTEN = 0x100
	// Burst mode disabled
	FSMC_BCR_BURSTEN_Disabled = 0x0
	// Burst mode enabled
	FSMC_BCR_BURSTEN_Enabled = 0x1
	// Position of FACCEN field.
	FSMC_BCR_FACCEN_Pos = 0x6
	// Bit mask of FACCEN field.
	FSMC_BCR_FACCEN_Msk = 0x40
	// Bit FACCEN.
	FSMC_BCR_FACCEN = 0x40
	// Corresponding NOR Flash memory access is disabled
	FSMC_BCR_FACCEN_Disabled = 0x0
	// Corresponding NOR Flash memory access is enabled
	FSMC_BCR_FACCEN_Enabled = 0x1
	// Position of MWID field.
	FSMC_BCR_MWID_Pos = 0x4
	// Bit mask of MWID field.
	FSMC_BCR_MWID_Msk = 0x30
	// Memory data bus width 8 bits
	FSMC_BCR_MWID_Bits8 = 0x0
	// Memory data bus width 16 bits
	FSMC_BCR_MWID_Bits16 = 0x1
	// Memory data bus width 32 bits
	FSMC_BCR_MWID_Bits32 = 0x2
	// Position of MTYP field.
	FSMC_BCR_MTYP_Pos = 0x2
	// Bit mask of MTYP field.
	FSMC_BCR_MTYP_Msk = 0xc
	// SRAM memory type
	FSMC_BCR_MTYP_SRAM = 0x0
	// PSRAM (CRAM) memory type
	FSMC_BCR_MTYP_PSRAM = 0x1
	// NOR Flash/OneNAND Flash
	FSMC_BCR_MTYP_Flash = 0x2
	// Position of MUXEN field.
	FSMC_BCR_MUXEN_Pos = 0x1
	// Bit mask of MUXEN field.
	FSMC_BCR_MUXEN_Msk = 0x2
	// Bit MUXEN.
	FSMC_BCR_MUXEN = 0x2
	// Address/Data non-multiplexed
	FSMC_BCR_MUXEN_Disabled = 0x0
	// Address/Data multiplexed on databus
	FSMC_BCR_MUXEN_Enabled = 0x1
	// Position of MBKEN field.
	FSMC_BCR_MBKEN_Pos = 0x0
	// Bit mask of MBKEN field.
	FSMC_BCR_MBKEN_Msk = 0x1
	// Bit MBKEN.
	FSMC_BCR_MBKEN = 0x1
	// Corresponding memory bank is disabled
	FSMC_BCR_MBKEN_Disabled = 0x0
	// Corresponding memory bank is enabled
	FSMC_BCR_MBKEN_Enabled = 0x1
	// Position of CPSIZE field.
	FSMC_BCR_CPSIZE_Pos = 0x10
	// Bit mask of CPSIZE field.
	FSMC_BCR_CPSIZE_Msk = 0x70000
	// No burst split when crossing page boundary
	FSMC_BCR_CPSIZE_NoBurstSplit = 0x0
	// 128 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes128 = 0x1
	// 256 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes256 = 0x2
	// 512 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes512 = 0x3
	// 1024 bytes CRAM page size
	FSMC_BCR_CPSIZE_Bytes1024 = 0x4

	// BWTR1: BWTR1
	// Position of ACCMOD field.
	FSMC_BWTR_ACCMOD_Pos = 0x1c
	// Bit mask of ACCMOD field.
	FSMC_BWTR_ACCMOD_Msk = 0x30000000
	// Access mode A
	FSMC_BWTR_ACCMOD_A = 0x0
	// Access mode B
	FSMC_BWTR_ACCMOD_B = 0x1
	// Access mode C
	FSMC_BWTR_ACCMOD_C = 0x2
	// Access mode D
	FSMC_BWTR_ACCMOD_D = 0x3
	// Position of DATLAT field.
	FSMC_BWTR_DATLAT_Pos = 0x18
	// Bit mask of DATLAT field.
	FSMC_BWTR_DATLAT_Msk = 0xf000000
	// Position of CLKDIV field.
	FSMC_BWTR_CLKDIV_Pos = 0x14
	// Bit mask of CLKDIV field.
	FSMC_BWTR_CLKDIV_Msk = 0xf00000
	// Position of DATAST field.
	FSMC_BWTR_DATAST_Pos = 0x8
	// Bit mask of DATAST field.
	FSMC_BWTR_DATAST_Msk = 0xff00
	// Position of ADDHLD field.
	FSMC_BWTR_ADDHLD_Pos = 0x4
	// Bit mask of ADDHLD field.
	FSMC_BWTR_ADDHLD_Msk = 0xf0
	// Position of ADDSET field.
	FSMC_BWTR_ADDSET_Pos = 0x0
	// Bit mask of ADDSET field.
	FSMC_BWTR_ADDSET_Msk = 0xf
	// Position of BUSTURN field.
	FSMC_BWTR_BUSTURN_Pos = 0x10
	// Bit mask of BUSTURN field.
	FSMC_BWTR_BUSTURN_Msk = 0xf0000
)

// Constants for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODER15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER15_Analog = 0x3
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODER14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER14_Analog = 0x3
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODER13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER13_Analog = 0x3
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODER12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER12_Analog = 0x3
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Input mode (reset state)
	GPIO_MODER_MODER11_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER11_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER11_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER11_Analog = 0x3
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Input mode (reset state)
	GPIO_MODER_MODER10_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER10_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER10_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER10_Analog = 0x3
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Input mode (reset state)
	GPIO_MODER_MODER9_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER9_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER9_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER9_Analog = 0x3
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Input mode (reset state)
	GPIO_MODER_MODER8_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER8_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER8_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER8_Analog = 0x3
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Input mode (reset state)
	GPIO_MODER_MODER7_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER7_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER7_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER7_Analog = 0x3
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Input mode (reset state)
	GPIO_MODER_MODER6_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER6_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER6_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER6_Analog = 0x3
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Input mode (reset state)
	GPIO_MODER_MODER5_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER5_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER5_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER5_Analog = 0x3
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Input mode (reset state)
	GPIO_MODER_MODER4_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER4_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER4_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER4_Analog = 0x3
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Input mode (reset state)
	GPIO_MODER_MODER3_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER3_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER3_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER3_Analog = 0x3
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Input mode (reset state)
	GPIO_MODER_MODER2_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER2_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER2_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER2_Analog = 0x3
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Input mode (reset state)
	GPIO_MODER_MODER1_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER1_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER1_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER1_Analog = 0x3
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3
	// Input mode (reset state)
	GPIO_MODER_MODER0_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER0_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER0_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER0_Analog = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT15_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT15_OpenDrain = 0x1
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT14_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT14_OpenDrain = 0x1
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT13_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT13_OpenDrain = 0x1
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT12_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT12_OpenDrain = 0x1
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Output push-pull (reset state)
	GPIO_OTYPER_OT11_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT11_OpenDrain = 0x1
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Output push-pull (reset state)
	GPIO_OTYPER_OT10_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT10_OpenDrain = 0x1
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Output push-pull (reset state)
	GPIO_OTYPER_OT9_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT9_OpenDrain = 0x1
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Output push-pull (reset state)
	GPIO_OTYPER_OT8_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT8_OpenDrain = 0x1
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Output push-pull (reset state)
	GPIO_OTYPER_OT7_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT7_OpenDrain = 0x1
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Output push-pull (reset state)
	GPIO_OTYPER_OT6_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT6_OpenDrain = 0x1
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Output push-pull (reset state)
	GPIO_OTYPER_OT5_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT5_OpenDrain = 0x1
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Output push-pull (reset state)
	GPIO_OTYPER_OT4_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT4_OpenDrain = 0x1
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Output push-pull (reset state)
	GPIO_OTYPER_OT3_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT3_OpenDrain = 0x1
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Output push-pull (reset state)
	GPIO_OTYPER_OT2_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT2_OpenDrain = 0x1
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Output push-pull (reset state)
	GPIO_OTYPER_OT1_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT1_OpenDrain = 0x1
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1
	// Output push-pull (reset state)
	GPIO_OTYPER_OT0_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT0_OpenDrain = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR15_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR15_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR15_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR15_VeryHighSpeed = 0x3
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR14_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR14_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR14_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR14_VeryHighSpeed = 0x3
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR13_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR13_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR13_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR13_VeryHighSpeed = 0x3
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR12_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR12_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR12_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR12_VeryHighSpeed = 0x3
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR11_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR11_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR11_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR11_VeryHighSpeed = 0x3
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR10_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR10_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR10_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR10_VeryHighSpeed = 0x3
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR9_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR9_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR9_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR9_VeryHighSpeed = 0x3
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR8_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR8_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR8_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR8_VeryHighSpeed = 0x3
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR7_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR7_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR7_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR7_VeryHighSpeed = 0x3
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR6_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR6_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR6_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR6_VeryHighSpeed = 0x3
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Low speed
	GPIO_OSPEEDR_OSPEEDR5_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR5_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR5_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR5_VeryHighSpeed = 0x3
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Low speed
	GPIO_OSPEEDR_OSPEEDR4_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR4_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR4_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR4_VeryHighSpeed = 0x3
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Low speed
	GPIO_OSPEEDR_OSPEEDR3_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR3_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR3_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR3_VeryHighSpeed = 0x3
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Low speed
	GPIO_OSPEEDR_OSPEEDR2_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR2_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR2_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR2_VeryHighSpeed = 0x3
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Low speed
	GPIO_OSPEEDR_OSPEEDR1_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR1_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR1_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR1_VeryHighSpeed = 0x3
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3
	// Low speed
	GPIO_OSPEEDR_OSPEEDR0_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR0_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR0_HighSpeed = 0x2
	// Very high speed
	GPIO_OSPEEDR_OSPEEDR0_VeryHighSpeed = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR15_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR15_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR15_PullDown = 0x2
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR14_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR14_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR14_PullDown = 0x2
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR13_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR13_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR13_PullDown = 0x2
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR12_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR12_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR12_PullDown = 0x2
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR11_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR11_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR11_PullDown = 0x2
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR10_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR10_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR10_PullDown = 0x2
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR9_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR9_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR9_PullDown = 0x2
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR8_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR8_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR8_PullDown = 0x2
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR7_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR7_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR7_PullDown = 0x2
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR6_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR6_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR6_PullDown = 0x2
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR5_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR5_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR5_PullDown = 0x2
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR4_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR4_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR4_PullDown = 0x2
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR3_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR3_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR3_PullDown = 0x2
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR2_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR2_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR2_PullDown = 0x2
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR1_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR1_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR1_PullDown = 0x2
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR0_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR0_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR0_PullDown = 0x2

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Input is logic high
	GPIO_IDR_IDR15_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR15_Low = 0x0
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Input is logic high
	GPIO_IDR_IDR14_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR14_Low = 0x0
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Input is logic high
	GPIO_IDR_IDR13_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR13_Low = 0x0
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Input is logic high
	GPIO_IDR_IDR12_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR12_Low = 0x0
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Input is logic high
	GPIO_IDR_IDR11_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR11_Low = 0x0
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Input is logic high
	GPIO_IDR_IDR10_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR10_Low = 0x0
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Input is logic high
	GPIO_IDR_IDR9_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR9_Low = 0x0
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Input is logic high
	GPIO_IDR_IDR8_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR8_Low = 0x0
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Input is logic high
	GPIO_IDR_IDR7_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR7_Low = 0x0
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Input is logic high
	GPIO_IDR_IDR6_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR6_Low = 0x0
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Input is logic high
	GPIO_IDR_IDR5_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR5_Low = 0x0
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Input is logic high
	GPIO_IDR_IDR4_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR4_Low = 0x0
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Input is logic high
	GPIO_IDR_IDR3_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR3_Low = 0x0
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Input is logic high
	GPIO_IDR_IDR2_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR2_Low = 0x0
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Input is logic high
	GPIO_IDR_IDR1_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR1_Low = 0x0
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1
	// Input is logic high
	GPIO_IDR_IDR0_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR0_Low = 0x0

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Set output to logic high
	GPIO_ODR_ODR15_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR15_Low = 0x0
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Set output to logic high
	GPIO_ODR_ODR14_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR14_Low = 0x0
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Set output to logic high
	GPIO_ODR_ODR13_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR13_Low = 0x0
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Set output to logic high
	GPIO_ODR_ODR12_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR12_Low = 0x0
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Set output to logic high
	GPIO_ODR_ODR11_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR11_Low = 0x0
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Set output to logic high
	GPIO_ODR_ODR10_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR10_Low = 0x0
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Set output to logic high
	GPIO_ODR_ODR9_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR9_Low = 0x0
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Set output to logic high
	GPIO_ODR_ODR8_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR8_Low = 0x0
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Set output to logic high
	GPIO_ODR_ODR7_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR7_Low = 0x0
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Set output to logic high
	GPIO_ODR_ODR6_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR6_Low = 0x0
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Set output to logic high
	GPIO_ODR_ODR5_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR5_Low = 0x0
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Set output to logic high
	GPIO_ODR_ODR4_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR4_Low = 0x0
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Set output to logic high
	GPIO_ODR_ODR3_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR3_Low = 0x0
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Set output to logic high
	GPIO_ODR_ODR2_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR2_Low = 0x0
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Set output to logic high
	GPIO_ODR_ODR1_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR1_Low = 0x0
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1
	// Set output to logic high
	GPIO_ODR_ODR0_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR0_Low = 0x0

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR15_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS0_Set = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1

	// AFRL: AFRL
	// Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Pos = 0x1c
	// Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000
	// AF0
	GPIO_AFRL_AFRL7_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL7_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL7_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL7_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL7_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL7_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL7_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL7_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL7_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL7_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL7_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL7_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL7_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL7_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL7_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL7_AF15 = 0xf
	// Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Pos = 0x18
	// Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000
	// AF0
	GPIO_AFRL_AFRL6_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL6_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL6_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL6_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL6_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL6_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL6_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL6_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL6_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL6_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL6_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL6_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL6_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL6_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL6_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL6_AF15 = 0xf
	// Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Pos = 0x14
	// Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000
	// AF0
	GPIO_AFRL_AFRL5_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL5_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL5_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL5_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL5_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL5_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL5_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL5_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL5_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL5_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL5_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL5_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL5_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL5_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL5_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL5_AF15 = 0xf
	// Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Pos = 0x10
	// Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000
	// AF0
	GPIO_AFRL_AFRL4_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL4_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL4_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL4_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL4_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL4_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL4_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL4_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL4_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL4_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL4_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL4_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL4_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL4_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL4_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL4_AF15 = 0xf
	// Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Pos = 0xc
	// Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000
	// AF0
	GPIO_AFRL_AFRL3_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL3_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL3_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL3_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL3_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL3_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL3_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL3_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL3_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL3_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL3_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL3_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL3_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL3_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL3_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL3_AF15 = 0xf
	// Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Pos = 0x8
	// Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00
	// AF0
	GPIO_AFRL_AFRL2_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL2_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL2_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL2_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL2_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL2_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL2_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL2_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL2_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL2_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL2_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL2_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL2_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL2_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL2_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL2_AF15 = 0xf
	// Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Pos = 0x4
	// Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0
	// AF0
	GPIO_AFRL_AFRL1_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL1_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL1_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL1_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL1_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL1_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL1_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL1_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL1_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL1_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL1_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL1_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL1_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL1_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL1_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL1_AF15 = 0xf
	// Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Pos = 0x0
	// Bit mask of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf
	// AF0
	GPIO_AFRL_AFRL0_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL0_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL0_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL0_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL0_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL0_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL0_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL0_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL0_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL0_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL0_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL0_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL0_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL0_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL0_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL0_AF15 = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Pos = 0x1c
	// Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000
	// AF0
	GPIO_AFRH_AFRH15_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH15_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH15_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH15_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH15_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH15_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH15_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH15_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH15_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH15_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH15_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH15_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH15_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH15_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH15_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH15_AF15 = 0xf
	// Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Pos = 0x18
	// Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000
	// AF0
	GPIO_AFRH_AFRH14_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH14_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH14_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH14_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH14_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH14_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH14_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH14_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH14_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH14_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH14_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH14_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH14_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH14_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH14_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH14_AF15 = 0xf
	// Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Pos = 0x14
	// Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000
	// AF0
	GPIO_AFRH_AFRH13_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH13_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH13_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH13_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH13_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH13_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH13_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH13_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH13_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH13_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH13_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH13_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH13_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH13_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH13_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH13_AF15 = 0xf
	// Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Pos = 0x10
	// Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000
	// AF0
	GPIO_AFRH_AFRH12_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH12_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH12_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH12_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH12_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH12_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH12_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH12_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH12_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH12_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH12_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH12_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH12_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH12_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH12_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH12_AF15 = 0xf
	// Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Pos = 0xc
	// Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000
	// AF0
	GPIO_AFRH_AFRH11_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH11_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH11_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH11_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH11_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH11_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH11_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH11_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH11_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH11_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH11_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH11_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH11_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH11_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH11_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH11_AF15 = 0xf
	// Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Pos = 0x8
	// Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00
	// AF0
	GPIO_AFRH_AFRH10_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH10_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH10_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH10_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH10_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH10_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH10_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH10_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH10_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH10_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH10_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH10_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH10_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH10_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH10_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH10_AF15 = 0xf
	// Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Pos = 0x4
	// Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk = 0xf0
	// AF0
	GPIO_AFRH_AFRH9_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH9_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH9_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH9_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH9_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH9_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH9_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH9_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH9_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH9_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH9_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH9_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH9_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH9_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH9_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH9_AF15 = 0xf
	// Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Pos = 0x0
	// Bit mask of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk = 0xf
	// AF0
	GPIO_AFRH_AFRH8_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH8_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH8_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH8_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH8_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH8_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH8_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH8_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH8_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH8_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH8_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH8_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH8_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH8_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH8_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH8_AF15 = 0xf
)

// Constants for I2C1: Inter-integrated circuit
const (
	// CR1: CR1
	// Position of SWRST field.
	I2C_CR1_SWRST_Pos = 0xf
	// Bit mask of SWRST field.
	I2C_CR1_SWRST_Msk = 0x8000
	// Bit SWRST.
	I2C_CR1_SWRST = 0x8000
	// I2C peripheral not under reset
	I2C_CR1_SWRST_NotReset = 0x0
	// I2C peripheral under reset
	I2C_CR1_SWRST_Reset = 0x1
	// Position of ALERT field.
	I2C_CR1_ALERT_Pos = 0xd
	// Bit mask of ALERT field.
	I2C_CR1_ALERT_Msk = 0x2000
	// Bit ALERT.
	I2C_CR1_ALERT = 0x2000
	// SMBA pin released high
	I2C_CR1_ALERT_Release = 0x0
	// SMBA pin driven low
	I2C_CR1_ALERT_Drive = 0x1
	// Position of PEC field.
	I2C_CR1_PEC_Pos = 0xc
	// Bit mask of PEC field.
	I2C_CR1_PEC_Msk = 0x1000
	// Bit PEC.
	I2C_CR1_PEC = 0x1000
	// No PEC transfer
	I2C_CR1_PEC_Disabled = 0x0
	// PEC transfer
	I2C_CR1_PEC_Enabled = 0x1
	// Position of POS field.
	I2C_CR1_POS_Pos = 0xb
	// Bit mask of POS field.
	I2C_CR1_POS_Msk = 0x800
	// Bit POS.
	I2C_CR1_POS = 0x800
	// ACK bit controls the (N)ACK of the current byte being received
	I2C_CR1_POS_Current = 0x0
	// ACK bit controls the (N)ACK of the next byte to be received
	I2C_CR1_POS_Next = 0x1
	// Position of ACK field.
	I2C_CR1_ACK_Pos = 0xa
	// Bit mask of ACK field.
	I2C_CR1_ACK_Msk = 0x400
	// Bit ACK.
	I2C_CR1_ACK = 0x400
	// No acknowledge returned
	I2C_CR1_ACK_NAK = 0x0
	// Acknowledge returned after a byte is received
	I2C_CR1_ACK_ACK = 0x1
	// Position of STOP field.
	I2C_CR1_STOP_Pos = 0x9
	// Bit mask of STOP field.
	I2C_CR1_STOP_Msk = 0x200
	// Bit STOP.
	I2C_CR1_STOP = 0x200
	// No Stop generation
	I2C_CR1_STOP_NoStop = 0x0
	// In master mode: stop generation after current byte/start, in slave mode: release SCL and SDA after current byte
	I2C_CR1_STOP_Stop = 0x1
	// Position of START field.
	I2C_CR1_START_Pos = 0x8
	// Bit mask of START field.
	I2C_CR1_START_Msk = 0x100
	// Bit START.
	I2C_CR1_START = 0x100
	// No Start generation
	I2C_CR1_START_NoStart = 0x0
	// In master mode: repeated start generation, in slave mode: start generation when bus is free
	I2C_CR1_START_Start = 0x1
	// Position of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Pos = 0x7
	// Bit mask of NOSTRETCH field.
	I2C_CR1_NOSTRETCH_Msk = 0x80
	// Bit NOSTRETCH.
	I2C_CR1_NOSTRETCH = 0x80
	// Clock stretching enabled
	I2C_CR1_NOSTRETCH_Enabled = 0x0
	// Clock stretching disabled
	I2C_CR1_NOSTRETCH_Disabled = 0x1
	// Position of ENGC field.
	I2C_CR1_ENGC_Pos = 0x6
	// Bit mask of ENGC field.
	I2C_CR1_ENGC_Msk = 0x40
	// Bit ENGC.
	I2C_CR1_ENGC = 0x40
	// General call disabled
	I2C_CR1_ENGC_Disabled = 0x0
	// General call enabled
	I2C_CR1_ENGC_Enabled = 0x1
	// Position of ENPEC field.
	I2C_CR1_ENPEC_Pos = 0x5
	// Bit mask of ENPEC field.
	I2C_CR1_ENPEC_Msk = 0x20
	// Bit ENPEC.
	I2C_CR1_ENPEC = 0x20
	// PEC calculation disabled
	I2C_CR1_ENPEC_Disabled = 0x0
	// PEC calculation enabled
	I2C_CR1_ENPEC_Enabled = 0x1
	// Position of ENARP field.
	I2C_CR1_ENARP_Pos = 0x4
	// Bit mask of ENARP field.
	I2C_CR1_ENARP_Msk = 0x10
	// Bit ENARP.
	I2C_CR1_ENARP = 0x10
	// ARP disabled
	I2C_CR1_ENARP_Disabled = 0x0
	// ARP enabled
	I2C_CR1_ENARP_Enabled = 0x1
	// Position of SMBTYPE field.
	I2C_CR1_SMBTYPE_Pos = 0x3
	// Bit mask of SMBTYPE field.
	I2C_CR1_SMBTYPE_Msk = 0x8
	// Bit SMBTYPE.
	I2C_CR1_SMBTYPE = 0x8
	// SMBus Device
	I2C_CR1_SMBTYPE_Device = 0x0
	// SMBus Host
	I2C_CR1_SMBTYPE_Host = 0x1
	// Position of SMBUS field.
	I2C_CR1_SMBUS_Pos = 0x1
	// Bit mask of SMBUS field.
	I2C_CR1_SMBUS_Msk = 0x2
	// Bit SMBUS.
	I2C_CR1_SMBUS = 0x2
	// I2C Mode
	I2C_CR1_SMBUS_I2C = 0x0
	// SMBus
	I2C_CR1_SMBUS_SMBus = 0x1
	// Position of PE field.
	I2C_CR1_PE_Pos = 0x0
	// Bit mask of PE field.
	I2C_CR1_PE_Msk = 0x1
	// Bit PE.
	I2C_CR1_PE = 0x1
	// Peripheral disabled
	I2C_CR1_PE_Disabled = 0x0
	// Peripheral enabled
	I2C_CR1_PE_Enabled = 0x1

	// CR2: CR2
	// Position of LAST field.
	I2C_CR2_LAST_Pos = 0xc
	// Bit mask of LAST field.
	I2C_CR2_LAST_Msk = 0x1000
	// Bit LAST.
	I2C_CR2_LAST = 0x1000
	// Next DMA EOT is not the last transfer
	I2C_CR2_LAST_NotLast = 0x0
	// Next DMA EOT is the last transfer
	I2C_CR2_LAST_Last = 0x1
	// Position of DMAEN field.
	I2C_CR2_DMAEN_Pos = 0xb
	// Bit mask of DMAEN field.
	I2C_CR2_DMAEN_Msk = 0x800
	// Bit DMAEN.
	I2C_CR2_DMAEN = 0x800
	// DMA requests disabled
	I2C_CR2_DMAEN_Disabled = 0x0
	// DMA request enabled when TxE=1 or RxNE=1
	I2C_CR2_DMAEN_Enabled = 0x1
	// Position of ITBUFEN field.
	I2C_CR2_ITBUFEN_Pos = 0xa
	// Bit mask of ITBUFEN field.
	I2C_CR2_ITBUFEN_Msk = 0x400
	// Bit ITBUFEN.
	I2C_CR2_ITBUFEN = 0x400
	// TxE=1 or RxNE=1 does not generate any interrupt
	I2C_CR2_ITBUFEN_Disabled = 0x0
	// TxE=1 or RxNE=1 generates Event interrupt
	I2C_CR2_ITBUFEN_Enabled = 0x1
	// Position of ITEVTEN field.
	I2C_CR2_ITEVTEN_Pos = 0x9
	// Bit mask of ITEVTEN field.
	I2C_CR2_ITEVTEN_Msk = 0x200
	// Bit ITEVTEN.
	I2C_CR2_ITEVTEN = 0x200
	// Event interrupt disabled
	I2C_CR2_ITEVTEN_Disabled = 0x0
	// Event interrupt enabled
	I2C_CR2_ITEVTEN_Enabled = 0x1
	// Position of ITERREN field.
	I2C_CR2_ITERREN_Pos = 0x8
	// Bit mask of ITERREN field.
	I2C_CR2_ITERREN_Msk = 0x100
	// Bit ITERREN.
	I2C_CR2_ITERREN = 0x100
	// Error interrupt disabled
	I2C_CR2_ITERREN_Disabled = 0x0
	// Error interrupt enabled
	I2C_CR2_ITERREN_Enabled = 0x1
	// Position of FREQ field.
	I2C_CR2_FREQ_Pos = 0x0
	// Bit mask of FREQ field.
	I2C_CR2_FREQ_Msk = 0x3f

	// OAR1: OAR1
	// Position of ADDMODE field.
	I2C_OAR1_ADDMODE_Pos = 0xf
	// Bit mask of ADDMODE field.
	I2C_OAR1_ADDMODE_Msk = 0x8000
	// Bit ADDMODE.
	I2C_OAR1_ADDMODE = 0x8000
	// 7-bit slave address
	I2C_OAR1_ADDMODE_ADD7 = 0x0
	// 10-bit slave address
	I2C_OAR1_ADDMODE_ADD10 = 0x1
	// Position of ADD field.
	I2C_OAR1_ADD_Pos = 0x0
	// Bit mask of ADD field.
	I2C_OAR1_ADD_Msk = 0x3ff

	// OAR2: OAR2
	// Position of ADD2 field.
	I2C_OAR2_ADD2_Pos = 0x1
	// Bit mask of ADD2 field.
	I2C_OAR2_ADD2_Msk = 0xfe
	// Position of ENDUAL field.
	I2C_OAR2_ENDUAL_Pos = 0x0
	// Bit mask of ENDUAL field.
	I2C_OAR2_ENDUAL_Msk = 0x1
	// Bit ENDUAL.
	I2C_OAR2_ENDUAL = 0x1
	// Single addressing mode
	I2C_OAR2_ENDUAL_Single = 0x0
	// Dual addressing mode
	I2C_OAR2_ENDUAL_Dual = 0x1

	// DR: DR
	// Position of DR field.
	I2C_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	I2C_DR_DR_Msk = 0xff

	// SR1: SR1
	// Position of SMBALERT field.
	I2C_SR1_SMBALERT_Pos = 0xf
	// Bit mask of SMBALERT field.
	I2C_SR1_SMBALERT_Msk = 0x8000
	// Bit SMBALERT.
	I2C_SR1_SMBALERT = 0x8000
	// No SMBALERT occured
	I2C_SR1_SMBALERT_NoAlert = 0x0
	// SMBALERT occurred
	I2C_SR1_SMBALERT_Alert = 0x1
	// Position of TIMEOUT field.
	I2C_SR1_TIMEOUT_Pos = 0xe
	// Bit mask of TIMEOUT field.
	I2C_SR1_TIMEOUT_Msk = 0x4000
	// Bit TIMEOUT.
	I2C_SR1_TIMEOUT = 0x4000
	// No Timeout error
	I2C_SR1_TIMEOUT_NoTimeout = 0x0
	// SCL remained LOW for 25 ms
	I2C_SR1_TIMEOUT_Timeout = 0x1
	// Position of PECERR field.
	I2C_SR1_PECERR_Pos = 0xc
	// Bit mask of PECERR field.
	I2C_SR1_PECERR_Msk = 0x1000
	// Bit PECERR.
	I2C_SR1_PECERR = 0x1000
	// no PEC error: receiver returns ACK after PEC reception (if ACK=1)
	I2C_SR1_PECERR_NoError = 0x0
	// PEC error: receiver returns NACK after PEC reception (whatever ACK)
	I2C_SR1_PECERR_Error = 0x1
	// Position of OVR field.
	I2C_SR1_OVR_Pos = 0xb
	// Bit mask of OVR field.
	I2C_SR1_OVR_Msk = 0x800
	// Bit OVR.
	I2C_SR1_OVR = 0x800
	// No overrun/underrun occured
	I2C_SR1_OVR_NoOverrun = 0x0
	// Overrun/underrun occured
	I2C_SR1_OVR_Overrun = 0x1
	// Position of AF field.
	I2C_SR1_AF_Pos = 0xa
	// Bit mask of AF field.
	I2C_SR1_AF_Msk = 0x400
	// Bit AF.
	I2C_SR1_AF = 0x400
	// No acknowledge failure
	I2C_SR1_AF_NoFailure = 0x0
	// Acknowledge failure
	I2C_SR1_AF_Failure = 0x1
	// Position of ARLO field.
	I2C_SR1_ARLO_Pos = 0x9
	// Bit mask of ARLO field.
	I2C_SR1_ARLO_Msk = 0x200
	// Bit ARLO.
	I2C_SR1_ARLO = 0x200
	// No Arbitration Lost detected
	I2C_SR1_ARLO_NoLost = 0x0
	// Arbitration Lost detected
	I2C_SR1_ARLO_Lost = 0x1
	// Position of BERR field.
	I2C_SR1_BERR_Pos = 0x8
	// Bit mask of BERR field.
	I2C_SR1_BERR_Msk = 0x100
	// Bit BERR.
	I2C_SR1_BERR = 0x100
	// No misplaced Start or Stop condition
	I2C_SR1_BERR_NoError = 0x0
	// Misplaced Start or Stop condition
	I2C_SR1_BERR_Error = 0x1
	// Position of TxE field.
	I2C_SR1_TxE_Pos = 0x7
	// Bit mask of TxE field.
	I2C_SR1_TxE_Msk = 0x80
	// Bit TxE.
	I2C_SR1_TxE = 0x80
	// Data register not empty
	I2C_SR1_TxE_NotEmpty = 0x0
	// Data register empty
	I2C_SR1_TxE_Empty = 0x1
	// Position of RxNE field.
	I2C_SR1_RxNE_Pos = 0x6
	// Bit mask of RxNE field.
	I2C_SR1_RxNE_Msk = 0x40
	// Bit RxNE.
	I2C_SR1_RxNE = 0x40
	// Data register empty
	I2C_SR1_RxNE_Empty = 0x0
	// Data register not empty
	I2C_SR1_RxNE_NotEmpty = 0x1
	// Position of STOPF field.
	I2C_SR1_STOPF_Pos = 0x4
	// Bit mask of STOPF field.
	I2C_SR1_STOPF_Msk = 0x10
	// Bit STOPF.
	I2C_SR1_STOPF = 0x10
	// No Stop condition detected
	I2C_SR1_STOPF_NoStop = 0x0
	// Stop condition detected
	I2C_SR1_STOPF_Stop = 0x1
	// Position of ADD10 field.
	I2C_SR1_ADD10_Pos = 0x3
	// Bit mask of ADD10 field.
	I2C_SR1_ADD10_Msk = 0x8
	// Bit ADD10.
	I2C_SR1_ADD10 = 0x8
	// Position of BTF field.
	I2C_SR1_BTF_Pos = 0x2
	// Bit mask of BTF field.
	I2C_SR1_BTF_Msk = 0x4
	// Bit BTF.
	I2C_SR1_BTF = 0x4
	// Data byte transfer not done
	I2C_SR1_BTF_NotFinished = 0x0
	// Data byte transfer successful
	I2C_SR1_BTF_Finished = 0x1
	// Position of ADDR field.
	I2C_SR1_ADDR_Pos = 0x1
	// Bit mask of ADDR field.
	I2C_SR1_ADDR_Msk = 0x2
	// Bit ADDR.
	I2C_SR1_ADDR = 0x2
	// Adress mismatched or not received
	I2C_SR1_ADDR_NotMatch = 0x0
	// Received slave address matched with one of the enabled slave addresses
	I2C_SR1_ADDR_Match = 0x1
	// Position of SB field.
	I2C_SR1_SB_Pos = 0x0
	// Bit mask of SB field.
	I2C_SR1_SB_Msk = 0x1
	// Bit SB.
	I2C_SR1_SB = 0x1
	// No Start condition
	I2C_SR1_SB_NoStart = 0x0
	// Start condition generated
	I2C_SR1_SB_Start = 0x1

	// SR2: SR2
	// Position of PEC field.
	I2C_SR2_PEC_Pos = 0x8
	// Bit mask of PEC field.
	I2C_SR2_PEC_Msk = 0xff00
	// Position of DUALF field.
	I2C_SR2_DUALF_Pos = 0x7
	// Bit mask of DUALF field.
	I2C_SR2_DUALF_Msk = 0x80
	// Bit DUALF.
	I2C_SR2_DUALF = 0x80
	// Position of SMBHOST field.
	I2C_SR2_SMBHOST_Pos = 0x6
	// Bit mask of SMBHOST field.
	I2C_SR2_SMBHOST_Msk = 0x40
	// Bit SMBHOST.
	I2C_SR2_SMBHOST = 0x40
	// Position of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Pos = 0x5
	// Bit mask of SMBDEFAULT field.
	I2C_SR2_SMBDEFAULT_Msk = 0x20
	// Bit SMBDEFAULT.
	I2C_SR2_SMBDEFAULT = 0x20
	// Position of GENCALL field.
	I2C_SR2_GENCALL_Pos = 0x4
	// Bit mask of GENCALL field.
	I2C_SR2_GENCALL_Msk = 0x10
	// Bit GENCALL.
	I2C_SR2_GENCALL = 0x10
	// Position of TRA field.
	I2C_SR2_TRA_Pos = 0x2
	// Bit mask of TRA field.
	I2C_SR2_TRA_Msk = 0x4
	// Bit TRA.
	I2C_SR2_TRA = 0x4
	// Position of BUSY field.
	I2C_SR2_BUSY_Pos = 0x1
	// Bit mask of BUSY field.
	I2C_SR2_BUSY_Msk = 0x2
	// Bit BUSY.
	I2C_SR2_BUSY = 0x2
	// Position of MSL field.
	I2C_SR2_MSL_Pos = 0x0
	// Bit mask of MSL field.
	I2C_SR2_MSL_Msk = 0x1
	// Bit MSL.
	I2C_SR2_MSL = 0x1

	// CCR: CCR
	// Position of F_S field.
	I2C_CCR_F_S_Pos = 0xf
	// Bit mask of F_S field.
	I2C_CCR_F_S_Msk = 0x8000
	// Bit F_S.
	I2C_CCR_F_S = 0x8000
	// Standard mode I2C
	I2C_CCR_F_S_Standard = 0x0
	// Fast mode I2C
	I2C_CCR_F_S_Fast = 0x1
	// Position of DUTY field.
	I2C_CCR_DUTY_Pos = 0xe
	// Bit mask of DUTY field.
	I2C_CCR_DUTY_Msk = 0x4000
	// Bit DUTY.
	I2C_CCR_DUTY = 0x4000
	// Duty cycle t_low/t_high = 2/1
	I2C_CCR_DUTY_Duty2_1 = 0x0
	// Duty cycle t_low/t_high = 16/9
	I2C_CCR_DUTY_Duty16_9 = 0x1
	// Position of CCR field.
	I2C_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	I2C_CCR_CCR_Msk = 0xfff

	// TRISE: TRISE
	// Position of TRISE field.
	I2C_TRISE_TRISE_Pos = 0x0
	// Bit mask of TRISE field.
	I2C_TRISE_TRISE_Msk = 0x3f
)

// Constants for IWDG: Independent watchdog
const (
	// KR: Key register
	// Position of KEY field.
	IWDG_KR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	IWDG_KR_KEY_Msk = 0xffff
	// Enable access to PR, RLR and WINR registers (0x5555)
	IWDG_KR_KEY_Enable = 0x5555
	// Reset the watchdog value (0xAAAA)
	IWDG_KR_KEY_Reset = 0xaaaa
	// Start the watchdog (0xCCCC)
	IWDG_KR_KEY_Start = 0xcccc

	// PR: Prescaler register
	// Position of PR field.
	IWDG_PR_PR_Pos = 0x0
	// Bit mask of PR field.
	IWDG_PR_PR_Msk = 0x7
	// Divider /4
	IWDG_PR_PR_DivideBy4 = 0x0
	// Divider /8
	IWDG_PR_PR_DivideBy8 = 0x1
	// Divider /16
	IWDG_PR_PR_DivideBy16 = 0x2
	// Divider /32
	IWDG_PR_PR_DivideBy32 = 0x3
	// Divider /64
	IWDG_PR_PR_DivideBy64 = 0x4
	// Divider /128
	IWDG_PR_PR_DivideBy128 = 0x5
	// Divider /256
	IWDG_PR_PR_DivideBy256 = 0x6
	// Divider /256
	IWDG_PR_PR_DivideBy256bis = 0x7

	// RLR: Reload register
	// Position of RL field.
	IWDG_RLR_RL_Pos = 0x0
	// Bit mask of RL field.
	IWDG_RLR_RL_Msk = 0xfff

	// SR: Status register
	// Position of RVU field.
	IWDG_SR_RVU_Pos = 0x1
	// Bit mask of RVU field.
	IWDG_SR_RVU_Msk = 0x2
	// Bit RVU.
	IWDG_SR_RVU = 0x2
	// Position of PVU field.
	IWDG_SR_PVU_Pos = 0x0
	// Bit mask of PVU field.
	IWDG_SR_PVU_Msk = 0x1
	// Bit PVU.
	IWDG_SR_PVU = 0x1
)

// Constants for LCD: Liquid crystal display controller
const (
	// CR: control register
	// Position of MUX_SEG field.
	LCD_CR_MUX_SEG_Pos = 0x7
	// Bit mask of MUX_SEG field.
	LCD_CR_MUX_SEG_Msk = 0x80
	// Bit MUX_SEG.
	LCD_CR_MUX_SEG = 0x80
	// Position of BIAS field.
	LCD_CR_BIAS_Pos = 0x5
	// Bit mask of BIAS field.
	LCD_CR_BIAS_Msk = 0x60
	// Position of DUTY field.
	LCD_CR_DUTY_Pos = 0x2
	// Bit mask of DUTY field.
	LCD_CR_DUTY_Msk = 0x1c
	// Position of VSEL field.
	LCD_CR_VSEL_Pos = 0x1
	// Bit mask of VSEL field.
	LCD_CR_VSEL_Msk = 0x2
	// Bit VSEL.
	LCD_CR_VSEL = 0x2
	// Position of LCDEN field.
	LCD_CR_LCDEN_Pos = 0x0
	// Bit mask of LCDEN field.
	LCD_CR_LCDEN_Msk = 0x1
	// Bit LCDEN.
	LCD_CR_LCDEN = 0x1

	// FCR: frame control register
	// Position of PS field.
	LCD_FCR_PS_Pos = 0x16
	// Bit mask of PS field.
	LCD_FCR_PS_Msk = 0x3c00000
	// Position of DIV field.
	LCD_FCR_DIV_Pos = 0x12
	// Bit mask of DIV field.
	LCD_FCR_DIV_Msk = 0x3c0000
	// Position of BLINK field.
	LCD_FCR_BLINK_Pos = 0x10
	// Bit mask of BLINK field.
	LCD_FCR_BLINK_Msk = 0x30000
	// Position of BLINKF field.
	LCD_FCR_BLINKF_Pos = 0xd
	// Bit mask of BLINKF field.
	LCD_FCR_BLINKF_Msk = 0xe000
	// Position of CC field.
	LCD_FCR_CC_Pos = 0xa
	// Bit mask of CC field.
	LCD_FCR_CC_Msk = 0x1c00
	// Position of DEAD field.
	LCD_FCR_DEAD_Pos = 0x7
	// Bit mask of DEAD field.
	LCD_FCR_DEAD_Msk = 0x380
	// Position of PON field.
	LCD_FCR_PON_Pos = 0x4
	// Bit mask of PON field.
	LCD_FCR_PON_Msk = 0x70
	// Position of UDDIE field.
	LCD_FCR_UDDIE_Pos = 0x3
	// Bit mask of UDDIE field.
	LCD_FCR_UDDIE_Msk = 0x8
	// Bit UDDIE.
	LCD_FCR_UDDIE = 0x8
	// Position of SOFIE field.
	LCD_FCR_SOFIE_Pos = 0x1
	// Bit mask of SOFIE field.
	LCD_FCR_SOFIE_Msk = 0x2
	// Bit SOFIE.
	LCD_FCR_SOFIE = 0x2
	// Position of HD field.
	LCD_FCR_HD_Pos = 0x0
	// Bit mask of HD field.
	LCD_FCR_HD_Msk = 0x1
	// Bit HD.
	LCD_FCR_HD = 0x1

	// SR: status register
	// Position of FCRSF field.
	LCD_SR_FCRSF_Pos = 0x5
	// Bit mask of FCRSF field.
	LCD_SR_FCRSF_Msk = 0x20
	// Bit FCRSF.
	LCD_SR_FCRSF = 0x20
	// Position of RDY field.
	LCD_SR_RDY_Pos = 0x4
	// Bit mask of RDY field.
	LCD_SR_RDY_Msk = 0x10
	// Bit RDY.
	LCD_SR_RDY = 0x10
	// Position of UDD field.
	LCD_SR_UDD_Pos = 0x3
	// Bit mask of UDD field.
	LCD_SR_UDD_Msk = 0x8
	// Bit UDD.
	LCD_SR_UDD = 0x8
	// Position of UDR field.
	LCD_SR_UDR_Pos = 0x2
	// Bit mask of UDR field.
	LCD_SR_UDR_Msk = 0x4
	// Bit UDR.
	LCD_SR_UDR = 0x4
	// Position of SOF field.
	LCD_SR_SOF_Pos = 0x1
	// Bit mask of SOF field.
	LCD_SR_SOF_Msk = 0x2
	// Bit SOF.
	LCD_SR_SOF = 0x2
	// Position of ENS field.
	LCD_SR_ENS_Pos = 0x0
	// Bit mask of ENS field.
	LCD_SR_ENS_Msk = 0x1
	// Bit ENS.
	LCD_SR_ENS = 0x1

	// CLR: clear register
	// Position of UDDC field.
	LCD_CLR_UDDC_Pos = 0x3
	// Bit mask of UDDC field.
	LCD_CLR_UDDC_Msk = 0x8
	// Bit UDDC.
	LCD_CLR_UDDC = 0x8
	// Position of SOFC field.
	LCD_CLR_SOFC_Pos = 0x1
	// Bit mask of SOFC field.
	LCD_CLR_SOFC_Msk = 0x2
	// Bit SOFC.
	LCD_CLR_SOFC = 0x2

	// RAM_COM0: display memory
	// Position of S31 field.
	LCD_RAM_COM0_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM0_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM0_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM0_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM0_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM0_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM0_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM0_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM0_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM0_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM0_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM0_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM0_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM0_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM0_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM0_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM0_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM0_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM0_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM0_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM0_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM0_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM0_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM0_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM0_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM0_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM0_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM0_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM0_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM0_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM0_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM0_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM0_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM0_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM0_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM0_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM0_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM0_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM0_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM0_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM0_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM0_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM0_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM0_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM0_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM0_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM0_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM0_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM0_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM0_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM0_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM0_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM0_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM0_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM0_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM0_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM0_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM0_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM0_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM0_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM0_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM0_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM0_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM0_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM0_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM0_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM0_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM0_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM0_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM0_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM0_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM0_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM0_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM0_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM0_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM0_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM0_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM0_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM0_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM0_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM0_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM0_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM0_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM0_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM0_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM0_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM0_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM0_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM0_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM0_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM0_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM0_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM0_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM0_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM0_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM0_S00 = 0x1

	// RAM_COM1: display memory
	// Position of S31 field.
	LCD_RAM_COM1_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM1_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM1_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM1_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM1_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM1_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM1_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM1_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM1_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM1_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM1_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM1_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM1_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM1_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM1_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM1_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM1_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM1_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM1_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM1_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM1_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM1_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM1_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM1_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM1_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM1_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM1_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM1_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM1_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM1_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM1_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM1_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM1_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM1_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM1_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM1_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM1_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM1_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM1_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM1_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM1_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM1_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM1_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM1_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM1_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM1_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM1_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM1_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM1_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM1_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM1_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM1_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM1_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM1_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM1_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM1_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM1_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM1_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM1_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM1_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM1_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM1_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM1_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM1_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM1_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM1_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM1_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM1_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM1_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM1_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM1_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM1_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM1_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM1_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM1_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM1_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM1_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM1_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM1_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM1_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM1_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM1_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM1_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM1_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM1_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM1_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM1_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM1_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM1_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM1_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM1_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM1_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM1_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM1_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM1_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM1_S00 = 0x1

	// RAM_COM2: display memory
	// Position of S31 field.
	LCD_RAM_COM2_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM2_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM2_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM2_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM2_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM2_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM2_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM2_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM2_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM2_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM2_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM2_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM2_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM2_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM2_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM2_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM2_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM2_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM2_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM2_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM2_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM2_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM2_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM2_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM2_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM2_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM2_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM2_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM2_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM2_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM2_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM2_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM2_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM2_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM2_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM2_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM2_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM2_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM2_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM2_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM2_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM2_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM2_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM2_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM2_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM2_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM2_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM2_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM2_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM2_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM2_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM2_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM2_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM2_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM2_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM2_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM2_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM2_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM2_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM2_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM2_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM2_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM2_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM2_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM2_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM2_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM2_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM2_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM2_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM2_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM2_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM2_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM2_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM2_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM2_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM2_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM2_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM2_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM2_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM2_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM2_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM2_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM2_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM2_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM2_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM2_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM2_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM2_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM2_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM2_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM2_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM2_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM2_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM2_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM2_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM2_S00 = 0x1

	// RAM_COM3: display memory
	// Position of S31 field.
	LCD_RAM_COM3_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM3_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM3_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM3_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM3_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM3_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM3_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM3_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM3_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM3_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM3_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM3_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM3_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM3_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM3_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM3_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM3_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM3_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM3_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM3_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM3_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM3_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM3_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM3_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM3_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM3_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM3_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM3_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM3_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM3_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM3_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM3_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM3_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM3_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM3_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM3_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM3_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM3_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM3_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM3_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM3_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM3_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM3_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM3_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM3_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM3_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM3_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM3_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM3_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM3_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM3_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM3_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM3_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM3_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM3_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM3_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM3_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM3_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM3_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM3_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM3_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM3_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM3_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM3_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM3_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM3_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM3_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM3_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM3_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM3_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM3_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM3_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM3_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM3_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM3_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM3_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM3_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM3_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM3_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM3_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM3_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM3_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM3_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM3_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM3_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM3_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM3_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM3_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM3_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM3_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM3_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM3_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM3_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM3_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM3_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM3_S00 = 0x1

	// RAM_COM4: display memory
	// Position of S31 field.
	LCD_RAM_COM4_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM4_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM4_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM4_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM4_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM4_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM4_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM4_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM4_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM4_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM4_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM4_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM4_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM4_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM4_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM4_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM4_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM4_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM4_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM4_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM4_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM4_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM4_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM4_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM4_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM4_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM4_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM4_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM4_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM4_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM4_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM4_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM4_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM4_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM4_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM4_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM4_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM4_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM4_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM4_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM4_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM4_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM4_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM4_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM4_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM4_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM4_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM4_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM4_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM4_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM4_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM4_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM4_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM4_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM4_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM4_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM4_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM4_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM4_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM4_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM4_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM4_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM4_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM4_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM4_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM4_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM4_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM4_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM4_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM4_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM4_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM4_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM4_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM4_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM4_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM4_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM4_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM4_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM4_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM4_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM4_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM4_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM4_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM4_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM4_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM4_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM4_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM4_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM4_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM4_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM4_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM4_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM4_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM4_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM4_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM4_S00 = 0x1

	// RAM_COM5: display memory
	// Position of S31 field.
	LCD_RAM_COM5_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM5_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM5_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM5_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM5_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM5_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM5_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM5_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM5_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM5_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM5_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM5_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM5_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM5_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM5_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM5_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM5_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM5_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM5_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM5_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM5_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM5_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM5_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM5_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM5_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM5_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM5_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM5_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM5_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM5_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM5_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM5_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM5_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM5_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM5_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM5_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM5_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM5_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM5_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM5_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM5_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM5_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM5_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM5_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM5_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM5_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM5_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM5_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM5_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM5_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM5_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM5_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM5_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM5_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM5_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM5_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM5_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM5_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM5_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM5_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM5_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM5_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM5_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM5_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM5_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM5_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM5_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM5_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM5_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM5_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM5_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM5_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM5_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM5_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM5_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM5_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM5_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM5_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM5_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM5_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM5_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM5_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM5_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM5_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM5_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM5_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM5_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM5_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM5_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM5_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM5_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM5_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM5_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM5_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM5_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM5_S00 = 0x1

	// RAM_COM6: display memory
	// Position of S31 field.
	LCD_RAM_COM6_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM6_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM6_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM6_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM6_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM6_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM6_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM6_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM6_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM6_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM6_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM6_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM6_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM6_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM6_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM6_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM6_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM6_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM6_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM6_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM6_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM6_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM6_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM6_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM6_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM6_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM6_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM6_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM6_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM6_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM6_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM6_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM6_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM6_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM6_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM6_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM6_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM6_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM6_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM6_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM6_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM6_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM6_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM6_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM6_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM6_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM6_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM6_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM6_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM6_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM6_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM6_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM6_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM6_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM6_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM6_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM6_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM6_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM6_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM6_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM6_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM6_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM6_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM6_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM6_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM6_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM6_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM6_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM6_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM6_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM6_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM6_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM6_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM6_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM6_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM6_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM6_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM6_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM6_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM6_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM6_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM6_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM6_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM6_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM6_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM6_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM6_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM6_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM6_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM6_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM6_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM6_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM6_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM6_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM6_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM6_S00 = 0x1

	// RAM_COM7: display memory
	// Position of S31 field.
	LCD_RAM_COM7_S31_Pos = 0x1f
	// Bit mask of S31 field.
	LCD_RAM_COM7_S31_Msk = 0x80000000
	// Bit S31.
	LCD_RAM_COM7_S31 = 0x80000000
	// Position of S30 field.
	LCD_RAM_COM7_S30_Pos = 0x1e
	// Bit mask of S30 field.
	LCD_RAM_COM7_S30_Msk = 0x40000000
	// Bit S30.
	LCD_RAM_COM7_S30 = 0x40000000
	// Position of S29 field.
	LCD_RAM_COM7_S29_Pos = 0x1d
	// Bit mask of S29 field.
	LCD_RAM_COM7_S29_Msk = 0x20000000
	// Bit S29.
	LCD_RAM_COM7_S29 = 0x20000000
	// Position of S28 field.
	LCD_RAM_COM7_S28_Pos = 0x1c
	// Bit mask of S28 field.
	LCD_RAM_COM7_S28_Msk = 0x10000000
	// Bit S28.
	LCD_RAM_COM7_S28 = 0x10000000
	// Position of S27 field.
	LCD_RAM_COM7_S27_Pos = 0x1b
	// Bit mask of S27 field.
	LCD_RAM_COM7_S27_Msk = 0x8000000
	// Bit S27.
	LCD_RAM_COM7_S27 = 0x8000000
	// Position of S26 field.
	LCD_RAM_COM7_S26_Pos = 0x1a
	// Bit mask of S26 field.
	LCD_RAM_COM7_S26_Msk = 0x4000000
	// Bit S26.
	LCD_RAM_COM7_S26 = 0x4000000
	// Position of S25 field.
	LCD_RAM_COM7_S25_Pos = 0x19
	// Bit mask of S25 field.
	LCD_RAM_COM7_S25_Msk = 0x2000000
	// Bit S25.
	LCD_RAM_COM7_S25 = 0x2000000
	// Position of S24 field.
	LCD_RAM_COM7_S24_Pos = 0x18
	// Bit mask of S24 field.
	LCD_RAM_COM7_S24_Msk = 0x1000000
	// Bit S24.
	LCD_RAM_COM7_S24 = 0x1000000
	// Position of S23 field.
	LCD_RAM_COM7_S23_Pos = 0x17
	// Bit mask of S23 field.
	LCD_RAM_COM7_S23_Msk = 0x800000
	// Bit S23.
	LCD_RAM_COM7_S23 = 0x800000
	// Position of S22 field.
	LCD_RAM_COM7_S22_Pos = 0x16
	// Bit mask of S22 field.
	LCD_RAM_COM7_S22_Msk = 0x400000
	// Bit S22.
	LCD_RAM_COM7_S22 = 0x400000
	// Position of S21 field.
	LCD_RAM_COM7_S21_Pos = 0x15
	// Bit mask of S21 field.
	LCD_RAM_COM7_S21_Msk = 0x200000
	// Bit S21.
	LCD_RAM_COM7_S21 = 0x200000
	// Position of S20 field.
	LCD_RAM_COM7_S20_Pos = 0x14
	// Bit mask of S20 field.
	LCD_RAM_COM7_S20_Msk = 0x100000
	// Bit S20.
	LCD_RAM_COM7_S20 = 0x100000
	// Position of S19 field.
	LCD_RAM_COM7_S19_Pos = 0x13
	// Bit mask of S19 field.
	LCD_RAM_COM7_S19_Msk = 0x80000
	// Bit S19.
	LCD_RAM_COM7_S19 = 0x80000
	// Position of S18 field.
	LCD_RAM_COM7_S18_Pos = 0x12
	// Bit mask of S18 field.
	LCD_RAM_COM7_S18_Msk = 0x40000
	// Bit S18.
	LCD_RAM_COM7_S18 = 0x40000
	// Position of S17 field.
	LCD_RAM_COM7_S17_Pos = 0x11
	// Bit mask of S17 field.
	LCD_RAM_COM7_S17_Msk = 0x20000
	// Bit S17.
	LCD_RAM_COM7_S17 = 0x20000
	// Position of S16 field.
	LCD_RAM_COM7_S16_Pos = 0x10
	// Bit mask of S16 field.
	LCD_RAM_COM7_S16_Msk = 0x10000
	// Bit S16.
	LCD_RAM_COM7_S16 = 0x10000
	// Position of S15 field.
	LCD_RAM_COM7_S15_Pos = 0xf
	// Bit mask of S15 field.
	LCD_RAM_COM7_S15_Msk = 0x8000
	// Bit S15.
	LCD_RAM_COM7_S15 = 0x8000
	// Position of S14 field.
	LCD_RAM_COM7_S14_Pos = 0xe
	// Bit mask of S14 field.
	LCD_RAM_COM7_S14_Msk = 0x4000
	// Bit S14.
	LCD_RAM_COM7_S14 = 0x4000
	// Position of S13 field.
	LCD_RAM_COM7_S13_Pos = 0xd
	// Bit mask of S13 field.
	LCD_RAM_COM7_S13_Msk = 0x2000
	// Bit S13.
	LCD_RAM_COM7_S13 = 0x2000
	// Position of S12 field.
	LCD_RAM_COM7_S12_Pos = 0xc
	// Bit mask of S12 field.
	LCD_RAM_COM7_S12_Msk = 0x1000
	// Bit S12.
	LCD_RAM_COM7_S12 = 0x1000
	// Position of S11 field.
	LCD_RAM_COM7_S11_Pos = 0xb
	// Bit mask of S11 field.
	LCD_RAM_COM7_S11_Msk = 0x800
	// Bit S11.
	LCD_RAM_COM7_S11 = 0x800
	// Position of S10 field.
	LCD_RAM_COM7_S10_Pos = 0xa
	// Bit mask of S10 field.
	LCD_RAM_COM7_S10_Msk = 0x400
	// Bit S10.
	LCD_RAM_COM7_S10 = 0x400
	// Position of S09 field.
	LCD_RAM_COM7_S09_Pos = 0x9
	// Bit mask of S09 field.
	LCD_RAM_COM7_S09_Msk = 0x200
	// Bit S09.
	LCD_RAM_COM7_S09 = 0x200
	// Position of S08 field.
	LCD_RAM_COM7_S08_Pos = 0x8
	// Bit mask of S08 field.
	LCD_RAM_COM7_S08_Msk = 0x100
	// Bit S08.
	LCD_RAM_COM7_S08 = 0x100
	// Position of S07 field.
	LCD_RAM_COM7_S07_Pos = 0x7
	// Bit mask of S07 field.
	LCD_RAM_COM7_S07_Msk = 0x80
	// Bit S07.
	LCD_RAM_COM7_S07 = 0x80
	// Position of S06 field.
	LCD_RAM_COM7_S06_Pos = 0x6
	// Bit mask of S06 field.
	LCD_RAM_COM7_S06_Msk = 0x40
	// Bit S06.
	LCD_RAM_COM7_S06 = 0x40
	// Position of S05 field.
	LCD_RAM_COM7_S05_Pos = 0x5
	// Bit mask of S05 field.
	LCD_RAM_COM7_S05_Msk = 0x20
	// Bit S05.
	LCD_RAM_COM7_S05 = 0x20
	// Position of S04 field.
	LCD_RAM_COM7_S04_Pos = 0x4
	// Bit mask of S04 field.
	LCD_RAM_COM7_S04_Msk = 0x10
	// Bit S04.
	LCD_RAM_COM7_S04 = 0x10
	// Position of S03 field.
	LCD_RAM_COM7_S03_Pos = 0x3
	// Bit mask of S03 field.
	LCD_RAM_COM7_S03_Msk = 0x8
	// Bit S03.
	LCD_RAM_COM7_S03 = 0x8
	// Position of S02 field.
	LCD_RAM_COM7_S02_Pos = 0x2
	// Bit mask of S02 field.
	LCD_RAM_COM7_S02_Msk = 0x4
	// Bit S02.
	LCD_RAM_COM7_S02 = 0x4
	// Position of S01 field.
	LCD_RAM_COM7_S01_Pos = 0x1
	// Bit mask of S01 field.
	LCD_RAM_COM7_S01_Msk = 0x2
	// Bit S01.
	LCD_RAM_COM7_S01 = 0x2
	// Position of S00 field.
	LCD_RAM_COM7_S00_Pos = 0x0
	// Bit mask of S00 field.
	LCD_RAM_COM7_S00_Msk = 0x1
	// Bit S00.
	LCD_RAM_COM7_S00 = 0x1
)

// Constants for OPAMP: Operational amplifiers
const (
	// CSR: control/status register
	// Position of OPA3CALOUT field.
	OPAMP_CSR_OPA3CALOUT_Pos = 0x1f
	// Bit mask of OPA3CALOUT field.
	OPAMP_CSR_OPA3CALOUT_Msk = 0x80000000
	// Bit OPA3CALOUT.
	OPAMP_CSR_OPA3CALOUT = 0x80000000
	// Position of OPA2CALOUT field.
	OPAMP_CSR_OPA2CALOUT_Pos = 0x1e
	// Bit mask of OPA2CALOUT field.
	OPAMP_CSR_OPA2CALOUT_Msk = 0x40000000
	// Bit OPA2CALOUT.
	OPAMP_CSR_OPA2CALOUT = 0x40000000
	// Position of OPA1CALOUT field.
	OPAMP_CSR_OPA1CALOUT_Pos = 0x1d
	// Bit mask of OPA1CALOUT field.
	OPAMP_CSR_OPA1CALOUT_Msk = 0x20000000
	// Bit OPA1CALOUT.
	OPAMP_CSR_OPA1CALOUT = 0x20000000
	// Position of AOP_RANGE field.
	OPAMP_CSR_AOP_RANGE_Pos = 0x1c
	// Bit mask of AOP_RANGE field.
	OPAMP_CSR_AOP_RANGE_Msk = 0x10000000
	// Bit AOP_RANGE.
	OPAMP_CSR_AOP_RANGE = 0x10000000
	// Position of S7SEL2 field.
	OPAMP_CSR_S7SEL2_Pos = 0x1b
	// Bit mask of S7SEL2 field.
	OPAMP_CSR_S7SEL2_Msk = 0x8000000
	// Bit S7SEL2.
	OPAMP_CSR_S7SEL2 = 0x8000000
	// Position of ANAWSEL3 field.
	OPAMP_CSR_ANAWSEL3_Pos = 0x1a
	// Bit mask of ANAWSEL3 field.
	OPAMP_CSR_ANAWSEL3_Msk = 0x4000000
	// Bit ANAWSEL3.
	OPAMP_CSR_ANAWSEL3 = 0x4000000
	// Position of ANAWSEL2 field.
	OPAMP_CSR_ANAWSEL2_Pos = 0x19
	// Bit mask of ANAWSEL2 field.
	OPAMP_CSR_ANAWSEL2_Msk = 0x2000000
	// Bit ANAWSEL2.
	OPAMP_CSR_ANAWSEL2 = 0x2000000
	// Position of ANAWSEL1 field.
	OPAMP_CSR_ANAWSEL1_Pos = 0x18
	// Bit mask of ANAWSEL1 field.
	OPAMP_CSR_ANAWSEL1_Msk = 0x1000000
	// Bit ANAWSEL1.
	OPAMP_CSR_ANAWSEL1 = 0x1000000
	// Position of OPA3LPM field.
	OPAMP_CSR_OPA3LPM_Pos = 0x17
	// Bit mask of OPA3LPM field.
	OPAMP_CSR_OPA3LPM_Msk = 0x800000
	// Bit OPA3LPM.
	OPAMP_CSR_OPA3LPM = 0x800000
	// Position of OPA3CAL_H field.
	OPAMP_CSR_OPA3CAL_H_Pos = 0x16
	// Bit mask of OPA3CAL_H field.
	OPAMP_CSR_OPA3CAL_H_Msk = 0x400000
	// Bit OPA3CAL_H.
	OPAMP_CSR_OPA3CAL_H = 0x400000
	// Position of OPA3CAL_L field.
	OPAMP_CSR_OPA3CAL_L_Pos = 0x15
	// Bit mask of OPA3CAL_L field.
	OPAMP_CSR_OPA3CAL_L_Msk = 0x200000
	// Bit OPA3CAL_L.
	OPAMP_CSR_OPA3CAL_L = 0x200000
	// Position of S6SEL3 field.
	OPAMP_CSR_S6SEL3_Pos = 0x14
	// Bit mask of S6SEL3 field.
	OPAMP_CSR_S6SEL3_Msk = 0x100000
	// Bit S6SEL3.
	OPAMP_CSR_S6SEL3 = 0x100000
	// Position of S5SEL3 field.
	OPAMP_CSR_S5SEL3_Pos = 0x13
	// Bit mask of S5SEL3 field.
	OPAMP_CSR_S5SEL3_Msk = 0x80000
	// Bit S5SEL3.
	OPAMP_CSR_S5SEL3 = 0x80000
	// Position of S4SEL3 field.
	OPAMP_CSR_S4SEL3_Pos = 0x12
	// Bit mask of S4SEL3 field.
	OPAMP_CSR_S4SEL3_Msk = 0x40000
	// Bit S4SEL3.
	OPAMP_CSR_S4SEL3 = 0x40000
	// Position of S3SEL3 field.
	OPAMP_CSR_S3SEL3_Pos = 0x11
	// Bit mask of S3SEL3 field.
	OPAMP_CSR_S3SEL3_Msk = 0x20000
	// Bit S3SEL3.
	OPAMP_CSR_S3SEL3 = 0x20000
	// Position of OPA3PD field.
	OPAMP_CSR_OPA3PD_Pos = 0x10
	// Bit mask of OPA3PD field.
	OPAMP_CSR_OPA3PD_Msk = 0x10000
	// Bit OPA3PD.
	OPAMP_CSR_OPA3PD = 0x10000
	// Position of OPA2LPM field.
	OPAMP_CSR_OPA2LPM_Pos = 0xf
	// Bit mask of OPA2LPM field.
	OPAMP_CSR_OPA2LPM_Msk = 0x8000
	// Bit OPA2LPM.
	OPAMP_CSR_OPA2LPM = 0x8000
	// Position of OPA2CAL_H field.
	OPAMP_CSR_OPA2CAL_H_Pos = 0xe
	// Bit mask of OPA2CAL_H field.
	OPAMP_CSR_OPA2CAL_H_Msk = 0x4000
	// Bit OPA2CAL_H.
	OPAMP_CSR_OPA2CAL_H = 0x4000
	// Position of OPA2CAL_L field.
	OPAMP_CSR_OPA2CAL_L_Pos = 0xd
	// Bit mask of OPA2CAL_L field.
	OPAMP_CSR_OPA2CAL_L_Msk = 0x2000
	// Bit OPA2CAL_L.
	OPAMP_CSR_OPA2CAL_L = 0x2000
	// Position of S6SEL2 field.
	OPAMP_CSR_S6SEL2_Pos = 0xc
	// Bit mask of S6SEL2 field.
	OPAMP_CSR_S6SEL2_Msk = 0x1000
	// Bit S6SEL2.
	OPAMP_CSR_S6SEL2 = 0x1000
	// Position of S5SEL2 field.
	OPAMP_CSR_S5SEL2_Pos = 0xb
	// Bit mask of S5SEL2 field.
	OPAMP_CSR_S5SEL2_Msk = 0x800
	// Bit S5SEL2.
	OPAMP_CSR_S5SEL2 = 0x800
	// Position of S4SEL2 field.
	OPAMP_CSR_S4SEL2_Pos = 0xa
	// Bit mask of S4SEL2 field.
	OPAMP_CSR_S4SEL2_Msk = 0x400
	// Bit S4SEL2.
	OPAMP_CSR_S4SEL2 = 0x400
	// Position of S3SEL2 field.
	OPAMP_CSR_S3SEL2_Pos = 0x9
	// Bit mask of S3SEL2 field.
	OPAMP_CSR_S3SEL2_Msk = 0x200
	// Bit S3SEL2.
	OPAMP_CSR_S3SEL2 = 0x200
	// Position of OPA2PD field.
	OPAMP_CSR_OPA2PD_Pos = 0x8
	// Bit mask of OPA2PD field.
	OPAMP_CSR_OPA2PD_Msk = 0x100
	// Bit OPA2PD.
	OPAMP_CSR_OPA2PD = 0x100
	// Position of OPA1LPM field.
	OPAMP_CSR_OPA1LPM_Pos = 0x7
	// Bit mask of OPA1LPM field.
	OPAMP_CSR_OPA1LPM_Msk = 0x80
	// Bit OPA1LPM.
	OPAMP_CSR_OPA1LPM = 0x80
	// Position of OPA1CAL_H field.
	OPAMP_CSR_OPA1CAL_H_Pos = 0x6
	// Bit mask of OPA1CAL_H field.
	OPAMP_CSR_OPA1CAL_H_Msk = 0x40
	// Bit OPA1CAL_H.
	OPAMP_CSR_OPA1CAL_H = 0x40
	// Position of OPA1CAL_L field.
	OPAMP_CSR_OPA1CAL_L_Pos = 0x5
	// Bit mask of OPA1CAL_L field.
	OPAMP_CSR_OPA1CAL_L_Msk = 0x20
	// Bit OPA1CAL_L.
	OPAMP_CSR_OPA1CAL_L = 0x20
	// Position of S6SEL1 field.
	OPAMP_CSR_S6SEL1_Pos = 0x4
	// Bit mask of S6SEL1 field.
	OPAMP_CSR_S6SEL1_Msk = 0x10
	// Bit S6SEL1.
	OPAMP_CSR_S6SEL1 = 0x10
	// Position of S5SEL1 field.
	OPAMP_CSR_S5SEL1_Pos = 0x3
	// Bit mask of S5SEL1 field.
	OPAMP_CSR_S5SEL1_Msk = 0x8
	// Bit S5SEL1.
	OPAMP_CSR_S5SEL1 = 0x8
	// Position of S4SEL1 field.
	OPAMP_CSR_S4SEL1_Pos = 0x2
	// Bit mask of S4SEL1 field.
	OPAMP_CSR_S4SEL1_Msk = 0x4
	// Bit S4SEL1.
	OPAMP_CSR_S4SEL1 = 0x4
	// Position of S3SEL1 field.
	OPAMP_CSR_S3SEL1_Pos = 0x1
	// Bit mask of S3SEL1 field.
	OPAMP_CSR_S3SEL1_Msk = 0x2
	// Bit S3SEL1.
	OPAMP_CSR_S3SEL1 = 0x2
	// Position of OPA1PD field.
	OPAMP_CSR_OPA1PD_Pos = 0x0
	// Bit mask of OPA1PD field.
	OPAMP_CSR_OPA1PD_Msk = 0x1
	// Bit OPA1PD.
	OPAMP_CSR_OPA1PD = 0x1

	// OTR: offset trimming register for normal mode
	// Position of OT_USER field.
	OPAMP_OTR_OT_USER_Pos = 0x1f
	// Bit mask of OT_USER field.
	OPAMP_OTR_OT_USER_Msk = 0x80000000
	// Bit OT_USER.
	OPAMP_OTR_OT_USER = 0x80000000
	// Position of AO3_OPT_OFFSET_TRIM field.
	OPAMP_OTR_AO3_OPT_OFFSET_TRIM_Pos = 0x14
	// Bit mask of AO3_OPT_OFFSET_TRIM field.
	OPAMP_OTR_AO3_OPT_OFFSET_TRIM_Msk = 0x3ff00000
	// Position of AO2_OPT_OFFSET_TRIM field.
	OPAMP_OTR_AO2_OPT_OFFSET_TRIM_Pos = 0xa
	// Bit mask of AO2_OPT_OFFSET_TRIM field.
	OPAMP_OTR_AO2_OPT_OFFSET_TRIM_Msk = 0xffc00
	// Position of AO1_OPT_OFFSET_TRIM field.
	OPAMP_OTR_AO1_OPT_OFFSET_TRIM_Pos = 0x0
	// Bit mask of AO1_OPT_OFFSET_TRIM field.
	OPAMP_OTR_AO1_OPT_OFFSET_TRIM_Msk = 0x3ff

	// LPOTR: OPAMP offset trimming register for low power mode
	// Position of AO3_OPT_OFFSET_TRIM_LP field.
	OPAMP_LPOTR_AO3_OPT_OFFSET_TRIM_LP_Pos = 0x14
	// Bit mask of AO3_OPT_OFFSET_TRIM_LP field.
	OPAMP_LPOTR_AO3_OPT_OFFSET_TRIM_LP_Msk = 0x3ff00000
	// Position of AO2_OPT_OFFSET_TRIM_LP field.
	OPAMP_LPOTR_AO2_OPT_OFFSET_TRIM_LP_Pos = 0xa
	// Bit mask of AO2_OPT_OFFSET_TRIM_LP field.
	OPAMP_LPOTR_AO2_OPT_OFFSET_TRIM_LP_Msk = 0xffc00
	// Position of AO1_OPT_OFFSET_TRIM_LP field.
	OPAMP_LPOTR_AO1_OPT_OFFSET_TRIM_LP_Pos = 0x0
	// Bit mask of AO1_OPT_OFFSET_TRIM_LP field.
	OPAMP_LPOTR_AO1_OPT_OFFSET_TRIM_LP_Msk = 0x3ff
)

// Constants for PWR: Power control
const (
	// CR: power control register
	// Position of LPRUN field.
	PWR_CR_LPRUN_Pos = 0xe
	// Bit mask of LPRUN field.
	PWR_CR_LPRUN_Msk = 0x4000
	// Bit LPRUN.
	PWR_CR_LPRUN = 0x4000
	// Position of VOS field.
	PWR_CR_VOS_Pos = 0xb
	// Bit mask of VOS field.
	PWR_CR_VOS_Msk = 0x1800
	// Position of FWU field.
	PWR_CR_FWU_Pos = 0xa
	// Bit mask of FWU field.
	PWR_CR_FWU_Msk = 0x400
	// Bit FWU.
	PWR_CR_FWU = 0x400
	// Position of ULP field.
	PWR_CR_ULP_Pos = 0x9
	// Bit mask of ULP field.
	PWR_CR_ULP_Msk = 0x200
	// Bit ULP.
	PWR_CR_ULP = 0x200
	// Position of DBP field.
	PWR_CR_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR_DBP = 0x100
	// Position of PLS field.
	PWR_CR_PLS_Pos = 0x5
	// Bit mask of PLS field.
	PWR_CR_PLS_Msk = 0xe0
	// Position of PVDE field.
	PWR_CR_PVDE_Pos = 0x4
	// Bit mask of PVDE field.
	PWR_CR_PVDE_Msk = 0x10
	// Bit PVDE.
	PWR_CR_PVDE = 0x10
	// Position of CSBF field.
	PWR_CR_CSBF_Pos = 0x3
	// Bit mask of CSBF field.
	PWR_CR_CSBF_Msk = 0x8
	// Bit CSBF.
	PWR_CR_CSBF = 0x8
	// Position of CWUF field.
	PWR_CR_CWUF_Pos = 0x2
	// Bit mask of CWUF field.
	PWR_CR_CWUF_Msk = 0x4
	// Bit CWUF.
	PWR_CR_CWUF = 0x4
	// Position of PDDS field.
	PWR_CR_PDDS_Pos = 0x1
	// Bit mask of PDDS field.
	PWR_CR_PDDS_Msk = 0x2
	// Bit PDDS.
	PWR_CR_PDDS = 0x2
	// Enter Stop mode when the CPU enters deepsleep
	PWR_CR_PDDS_STOP_MODE = 0x0
	// Enter Standby mode when the CPU enters deepsleep
	PWR_CR_PDDS_STANDBY_MODE = 0x1
	// Position of LPSDSR field.
	PWR_CR_LPSDSR_Pos = 0x0
	// Bit mask of LPSDSR field.
	PWR_CR_LPSDSR_Msk = 0x1
	// Bit LPSDSR.
	PWR_CR_LPSDSR = 0x1

	// CSR: power control/status register
	// Position of EWUP3 field.
	PWR_CSR_EWUP3_Pos = 0xa
	// Bit mask of EWUP3 field.
	PWR_CSR_EWUP3_Msk = 0x400
	// Bit EWUP3.
	PWR_CSR_EWUP3 = 0x400
	// Position of EWUP2 field.
	PWR_CSR_EWUP2_Pos = 0x9
	// Bit mask of EWUP2 field.
	PWR_CSR_EWUP2_Msk = 0x200
	// Bit EWUP2.
	PWR_CSR_EWUP2 = 0x200
	// Position of EWUP1 field.
	PWR_CSR_EWUP1_Pos = 0x8
	// Bit mask of EWUP1 field.
	PWR_CSR_EWUP1_Msk = 0x100
	// Bit EWUP1.
	PWR_CSR_EWUP1 = 0x100
	// Position of REGLPF field.
	PWR_CSR_REGLPF_Pos = 0x5
	// Bit mask of REGLPF field.
	PWR_CSR_REGLPF_Msk = 0x20
	// Bit REGLPF.
	PWR_CSR_REGLPF = 0x20
	// Position of VOSF field.
	PWR_CSR_VOSF_Pos = 0x4
	// Bit mask of VOSF field.
	PWR_CSR_VOSF_Msk = 0x10
	// Bit VOSF.
	PWR_CSR_VOSF = 0x10
	// Position of VREFINTRDYF field.
	PWR_CSR_VREFINTRDYF_Pos = 0x3
	// Bit mask of VREFINTRDYF field.
	PWR_CSR_VREFINTRDYF_Msk = 0x8
	// Bit VREFINTRDYF.
	PWR_CSR_VREFINTRDYF = 0x8
	// Position of PVDO field.
	PWR_CSR_PVDO_Pos = 0x2
	// Bit mask of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4
	// Bit PVDO.
	PWR_CSR_PVDO = 0x4
	// Position of SBF field.
	PWR_CSR_SBF_Pos = 0x1
	// Bit mask of SBF field.
	PWR_CSR_SBF_Msk = 0x2
	// Bit SBF.
	PWR_CSR_SBF = 0x2
	// Position of WUF field.
	PWR_CSR_WUF_Pos = 0x0
	// Bit mask of WUF field.
	PWR_CSR_WUF_Msk = 0x1
	// Bit WUF.
	PWR_CSR_WUF = 0x1
)

// Constants for RCC: Reset and clock control
const (
	// CR: Clock control register
	// Position of RTCPRE1 field.
	RCC_CR_RTCPRE1_Pos = 0x1e
	// Bit mask of RTCPRE1 field.
	RCC_CR_RTCPRE1_Msk = 0x40000000
	// Bit RTCPRE1.
	RCC_CR_RTCPRE1 = 0x40000000
	// Position of RTCPRE0 field.
	RCC_CR_RTCPRE0_Pos = 0x1d
	// Bit mask of RTCPRE0 field.
	RCC_CR_RTCPRE0_Msk = 0x20000000
	// Bit RTCPRE0.
	RCC_CR_RTCPRE0 = 0x20000000
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x1c
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x10000000
	// Bit CSSON.
	RCC_CR_CSSON = 0x10000000
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Position of MSIRDY field.
	RCC_CR_MSIRDY_Pos = 0x9
	// Bit mask of MSIRDY field.
	RCC_CR_MSIRDY_Msk = 0x200
	// Bit MSIRDY.
	RCC_CR_MSIRDY = 0x200
	// Position of MSION field.
	RCC_CR_MSION_Pos = 0x8
	// Bit mask of MSION field.
	RCC_CR_MSION_Msk = 0x100
	// Bit MSION.
	RCC_CR_MSION = 0x100
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0x1
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x2
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x2
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x0
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x1
	// Bit HSION.
	RCC_CR_HSION = 0x1

	// ICSCR: Internal clock sources calibration register
	// Position of MSITRIM field.
	RCC_ICSCR_MSITRIM_Pos = 0x18
	// Bit mask of MSITRIM field.
	RCC_ICSCR_MSITRIM_Msk = 0xff000000
	// Position of MSICAL field.
	RCC_ICSCR_MSICAL_Pos = 0x10
	// Bit mask of MSICAL field.
	RCC_ICSCR_MSICAL_Msk = 0xff0000
	// Position of MSIRANGE field.
	RCC_ICSCR_MSIRANGE_Pos = 0xd
	// Bit mask of MSIRANGE field.
	RCC_ICSCR_MSIRANGE_Msk = 0xe000
	// Position of HSITRIM field.
	RCC_ICSCR_HSITRIM_Pos = 0x8
	// Bit mask of HSITRIM field.
	RCC_ICSCR_HSITRIM_Msk = 0x1f00
	// Position of HSICAL field.
	RCC_ICSCR_HSICAL_Pos = 0x0
	// Bit mask of HSICAL field.
	RCC_ICSCR_HSICAL_Msk = 0xff

	// CFGR: Clock configuration register
	// Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Pos = 0x1c
	// Bit mask of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000
	// Position of MCOSEL field.
	RCC_CFGR_MCOSEL_Pos = 0x18
	// Bit mask of MCOSEL field.
	RCC_CFGR_MCOSEL_Msk = 0x7000000
	// Position of PLLDIV field.
	RCC_CFGR_PLLDIV_Pos = 0x16
	// Bit mask of PLLDIV field.
	RCC_CFGR_PLLDIV_Msk = 0xc00000
	// Position of PLLMUL field.
	RCC_CFGR_PLLMUL_Pos = 0x12
	// Bit mask of PLLMUL field.
	RCC_CFGR_PLLMUL_Msk = 0x3c0000
	// Position of PLLSRC field.
	RCC_CFGR_PLLSRC_Pos = 0x10
	// Bit mask of PLLSRC field.
	RCC_CFGR_PLLSRC_Msk = 0x10000
	// Bit PLLSRC.
	RCC_CFGR_PLLSRC = 0x10000
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xb
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0x3800
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0x8
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x700
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3

	// CIR: Clock interrupt register
	// Position of CSSC field.
	RCC_CIR_CSSC_Pos = 0x17
	// Bit mask of CSSC field.
	RCC_CIR_CSSC_Msk = 0x800000
	// Bit CSSC.
	RCC_CIR_CSSC = 0x800000
	// Position of MSIRDYC field.
	RCC_CIR_MSIRDYC_Pos = 0x15
	// Bit mask of MSIRDYC field.
	RCC_CIR_MSIRDYC_Msk = 0x200000
	// Bit MSIRDYC.
	RCC_CIR_MSIRDYC = 0x200000
	// Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Pos = 0x14
	// Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk = 0x100000
	// Bit PLLRDYC.
	RCC_CIR_PLLRDYC = 0x100000
	// Position of HSERDYC field.
	RCC_CIR_HSERDYC_Pos = 0x13
	// Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC_Msk = 0x80000
	// Bit HSERDYC.
	RCC_CIR_HSERDYC = 0x80000
	// Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Pos = 0x12
	// Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk = 0x40000
	// Bit HSIRDYC.
	RCC_CIR_HSIRDYC = 0x40000
	// Position of LSERDYC field.
	RCC_CIR_LSERDYC_Pos = 0x11
	// Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC_Msk = 0x20000
	// Bit LSERDYC.
	RCC_CIR_LSERDYC = 0x20000
	// Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Pos = 0x10
	// Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk = 0x10000
	// Bit LSIRDYC.
	RCC_CIR_LSIRDYC = 0x10000
	// Position of MSIRDYIE field.
	RCC_CIR_MSIRDYIE_Pos = 0xd
	// Bit mask of MSIRDYIE field.
	RCC_CIR_MSIRDYIE_Msk = 0x2000
	// Bit MSIRDYIE.
	RCC_CIR_MSIRDYIE = 0x2000
	// Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Pos = 0xc
	// Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000
	// Bit PLLRDYIE.
	RCC_CIR_PLLRDYIE = 0x1000
	// Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Pos = 0xb
	// Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800
	// Bit HSERDYIE.
	RCC_CIR_HSERDYIE = 0x800
	// Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Pos = 0xa
	// Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400
	// Bit HSIRDYIE.
	RCC_CIR_HSIRDYIE = 0x400
	// Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Pos = 0x9
	// Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200
	// Bit LSERDYIE.
	RCC_CIR_LSERDYIE = 0x200
	// Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Pos = 0x8
	// Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100
	// Bit LSIRDYIE.
	RCC_CIR_LSIRDYIE = 0x100
	// Position of CSSF field.
	RCC_CIR_CSSF_Pos = 0x7
	// Bit mask of CSSF field.
	RCC_CIR_CSSF_Msk = 0x80
	// Bit CSSF.
	RCC_CIR_CSSF = 0x80
	// Position of MSIRDYF field.
	RCC_CIR_MSIRDYF_Pos = 0x5
	// Bit mask of MSIRDYF field.
	RCC_CIR_MSIRDYF_Msk = 0x20
	// Bit MSIRDYF.
	RCC_CIR_MSIRDYF = 0x20
	// Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Pos = 0x4
	// Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk = 0x10
	// Bit PLLRDYF.
	RCC_CIR_PLLRDYF = 0x10
	// Position of HSERDYF field.
	RCC_CIR_HSERDYF_Pos = 0x3
	// Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF_Msk = 0x8
	// Bit HSERDYF.
	RCC_CIR_HSERDYF = 0x8
	// Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Pos = 0x2
	// Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk = 0x4
	// Bit HSIRDYF.
	RCC_CIR_HSIRDYF = 0x4
	// Position of LSERDYF field.
	RCC_CIR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIR_LSERDYF = 0x2
	// Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIR_LSIRDYF = 0x1

	// AHBRSTR: AHB peripheral reset register
	// Position of FSMCRST field.
	RCC_AHBRSTR_FSMCRST_Pos = 0x1e
	// Bit mask of FSMCRST field.
	RCC_AHBRSTR_FSMCRST_Msk = 0x40000000
	// Bit FSMCRST.
	RCC_AHBRSTR_FSMCRST = 0x40000000
	// Position of DMA2RST field.
	RCC_AHBRSTR_DMA2RST_Pos = 0x19
	// Bit mask of DMA2RST field.
	RCC_AHBRSTR_DMA2RST_Msk = 0x2000000
	// Bit DMA2RST.
	RCC_AHBRSTR_DMA2RST = 0x2000000
	// Position of DMA1RST field.
	RCC_AHBRSTR_DMA1RST_Pos = 0x18
	// Bit mask of DMA1RST field.
	RCC_AHBRSTR_DMA1RST_Msk = 0x1000000
	// Bit DMA1RST.
	RCC_AHBRSTR_DMA1RST = 0x1000000
	// Position of FLITFRST field.
	RCC_AHBRSTR_FLITFRST_Pos = 0xf
	// Bit mask of FLITFRST field.
	RCC_AHBRSTR_FLITFRST_Msk = 0x8000
	// Bit FLITFRST.
	RCC_AHBRSTR_FLITFRST = 0x8000
	// Position of CRCRST field.
	RCC_AHBRSTR_CRCRST_Pos = 0xc
	// Bit mask of CRCRST field.
	RCC_AHBRSTR_CRCRST_Msk = 0x1000
	// Bit CRCRST.
	RCC_AHBRSTR_CRCRST = 0x1000
	// Position of GPIOGRST field.
	RCC_AHBRSTR_GPIOGRST_Pos = 0x7
	// Bit mask of GPIOGRST field.
	RCC_AHBRSTR_GPIOGRST_Msk = 0x80
	// Bit GPIOGRST.
	RCC_AHBRSTR_GPIOGRST = 0x80
	// Position of GPIOFRST field.
	RCC_AHBRSTR_GPIOFRST_Pos = 0x6
	// Bit mask of GPIOFRST field.
	RCC_AHBRSTR_GPIOFRST_Msk = 0x40
	// Bit GPIOFRST.
	RCC_AHBRSTR_GPIOFRST = 0x40
	// Position of GPIOHRST field.
	RCC_AHBRSTR_GPIOHRST_Pos = 0x5
	// Bit mask of GPIOHRST field.
	RCC_AHBRSTR_GPIOHRST_Msk = 0x20
	// Bit GPIOHRST.
	RCC_AHBRSTR_GPIOHRST = 0x20
	// Position of GPIOERST field.
	RCC_AHBRSTR_GPIOERST_Pos = 0x4
	// Bit mask of GPIOERST field.
	RCC_AHBRSTR_GPIOERST_Msk = 0x10
	// Bit GPIOERST.
	RCC_AHBRSTR_GPIOERST = 0x10
	// Position of GPIODRST field.
	RCC_AHBRSTR_GPIODRST_Pos = 0x3
	// Bit mask of GPIODRST field.
	RCC_AHBRSTR_GPIODRST_Msk = 0x8
	// Bit GPIODRST.
	RCC_AHBRSTR_GPIODRST = 0x8
	// Position of GPIOCRST field.
	RCC_AHBRSTR_GPIOCRST_Pos = 0x2
	// Bit mask of GPIOCRST field.
	RCC_AHBRSTR_GPIOCRST_Msk = 0x4
	// Bit GPIOCRST.
	RCC_AHBRSTR_GPIOCRST = 0x4
	// Position of GPIOBRST field.
	RCC_AHBRSTR_GPIOBRST_Pos = 0x1
	// Bit mask of GPIOBRST field.
	RCC_AHBRSTR_GPIOBRST_Msk = 0x2
	// Bit GPIOBRST.
	RCC_AHBRSTR_GPIOBRST = 0x2
	// Position of GPIOARST field.
	RCC_AHBRSTR_GPIOARST_Pos = 0x0
	// Bit mask of GPIOARST field.
	RCC_AHBRSTR_GPIOARST_Msk = 0x1
	// Bit GPIOARST.
	RCC_AHBRSTR_GPIOARST = 0x1

	// APB2RSTR: APB2 peripheral reset register
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0xe
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x4000
	// Position of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Pos = 0xc
	// Bit mask of SPI1RST field.
	RCC_APB2RSTR_SPI1RST_Msk = 0x1000
	// Bit SPI1RST.
	RCC_APB2RSTR_SPI1RST = 0x1000
	// Position of SDIORST field.
	RCC_APB2RSTR_SDIORST_Pos = 0xb
	// Bit mask of SDIORST field.
	RCC_APB2RSTR_SDIORST_Msk = 0x800
	// Bit SDIORST.
	RCC_APB2RSTR_SDIORST = 0x800
	// Position of ADC1RST field.
	RCC_APB2RSTR_ADC1RST_Pos = 0x9
	// Bit mask of ADC1RST field.
	RCC_APB2RSTR_ADC1RST_Msk = 0x200
	// Bit ADC1RST.
	RCC_APB2RSTR_ADC1RST = 0x200
	// Position of TM11RST field.
	RCC_APB2RSTR_TM11RST_Pos = 0x4
	// Bit mask of TM11RST field.
	RCC_APB2RSTR_TM11RST_Msk = 0x10
	// Bit TM11RST.
	RCC_APB2RSTR_TM11RST = 0x10
	// Position of TM10RST field.
	RCC_APB2RSTR_TM10RST_Pos = 0x3
	// Bit mask of TM10RST field.
	RCC_APB2RSTR_TM10RST_Msk = 0x8
	// Bit TM10RST.
	RCC_APB2RSTR_TM10RST = 0x8
	// Position of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Pos = 0x2
	// Bit mask of TIM9RST field.
	RCC_APB2RSTR_TIM9RST_Msk = 0x4
	// Bit TIM9RST.
	RCC_APB2RSTR_TIM9RST = 0x4
	// Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0
	// Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1
	// Bit SYSCFGRST.
	RCC_APB2RSTR_SYSCFGRST = 0x1

	// APB1RSTR: APB1 peripheral reset register
	// Position of COMPRST field.
	RCC_APB1RSTR_COMPRST_Pos = 0x1f
	// Bit mask of COMPRST field.
	RCC_APB1RSTR_COMPRST_Msk = 0x80000000
	// Bit COMPRST.
	RCC_APB1RSTR_COMPRST = 0x80000000
	// Position of DACRST field.
	RCC_APB1RSTR_DACRST_Pos = 0x1d
	// Bit mask of DACRST field.
	RCC_APB1RSTR_DACRST_Msk = 0x20000000
	// Bit DACRST.
	RCC_APB1RSTR_DACRST = 0x20000000
	// Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR_PWRRST = 0x10000000
	// Position of USBRST field.
	RCC_APB1RSTR_USBRST_Pos = 0x17
	// Bit mask of USBRST field.
	RCC_APB1RSTR_USBRST_Msk = 0x800000
	// Bit USBRST.
	RCC_APB1RSTR_USBRST = 0x800000
	// Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR_I2C2RST = 0x400000
	// Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR_I2C1RST = 0x200000
	// Position of UART5RST field.
	RCC_APB1RSTR_UART5RST_Pos = 0x14
	// Bit mask of UART5RST field.
	RCC_APB1RSTR_UART5RST_Msk = 0x100000
	// Bit UART5RST.
	RCC_APB1RSTR_UART5RST = 0x100000
	// Position of UART4RST field.
	RCC_APB1RSTR_UART4RST_Pos = 0x13
	// Bit mask of UART4RST field.
	RCC_APB1RSTR_UART4RST_Msk = 0x80000
	// Bit UART4RST.
	RCC_APB1RSTR_UART4RST = 0x80000
	// Position of USART3RST field.
	RCC_APB1RSTR_USART3RST_Pos = 0x12
	// Bit mask of USART3RST field.
	RCC_APB1RSTR_USART3RST_Msk = 0x40000
	// Bit USART3RST.
	RCC_APB1RSTR_USART3RST = 0x40000
	// Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Pos = 0x11
	// Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk = 0x20000
	// Bit USART2RST.
	RCC_APB1RSTR_USART2RST = 0x20000
	// Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Pos = 0xf
	// Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk = 0x8000
	// Bit SPI3RST.
	RCC_APB1RSTR_SPI3RST = 0x8000
	// Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR_SPI2RST = 0x4000
	// Position of WWDRST field.
	RCC_APB1RSTR_WWDRST_Pos = 0xb
	// Bit mask of WWDRST field.
	RCC_APB1RSTR_WWDRST_Msk = 0x800
	// Bit WWDRST.
	RCC_APB1RSTR_WWDRST = 0x800
	// Position of LCDRST field.
	RCC_APB1RSTR_LCDRST_Pos = 0x9
	// Bit mask of LCDRST field.
	RCC_APB1RSTR_LCDRST_Msk = 0x200
	// Bit LCDRST.
	RCC_APB1RSTR_LCDRST = 0x200
	// Position of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Pos = 0x5
	// Bit mask of TIM7RST field.
	RCC_APB1RSTR_TIM7RST_Msk = 0x20
	// Bit TIM7RST.
	RCC_APB1RSTR_TIM7RST = 0x20
	// Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Pos = 0x4
	// Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk = 0x10
	// Bit TIM6RST.
	RCC_APB1RSTR_TIM6RST = 0x10
	// Position of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Pos = 0x3
	// Bit mask of TIM5RST field.
	RCC_APB1RSTR_TIM5RST_Msk = 0x8
	// Bit TIM5RST.
	RCC_APB1RSTR_TIM5RST = 0x8
	// Position of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Pos = 0x2
	// Bit mask of TIM4RST field.
	RCC_APB1RSTR_TIM4RST_Msk = 0x4
	// Bit TIM4RST.
	RCC_APB1RSTR_TIM4RST = 0x4
	// Position of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Pos = 0x1
	// Bit mask of TIM3RST field.
	RCC_APB1RSTR_TIM3RST_Msk = 0x2
	// Bit TIM3RST.
	RCC_APB1RSTR_TIM3RST = 0x2
	// Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR_TIM2RST = 0x1

	// AHBENR: AHB peripheral clock enable register
	// Position of FSMCEN field.
	RCC_AHBENR_FSMCEN_Pos = 0x1e
	// Bit mask of FSMCEN field.
	RCC_AHBENR_FSMCEN_Msk = 0x40000000
	// Bit FSMCEN.
	RCC_AHBENR_FSMCEN = 0x40000000
	// Position of DMA2EN field.
	RCC_AHBENR_DMA2EN_Pos = 0x19
	// Bit mask of DMA2EN field.
	RCC_AHBENR_DMA2EN_Msk = 0x2000000
	// Bit DMA2EN.
	RCC_AHBENR_DMA2EN = 0x2000000
	// Position of DMA1EN field.
	RCC_AHBENR_DMA1EN_Pos = 0x18
	// Bit mask of DMA1EN field.
	RCC_AHBENR_DMA1EN_Msk = 0x1000000
	// Bit DMA1EN.
	RCC_AHBENR_DMA1EN = 0x1000000
	// Position of FLITFEN field.
	RCC_AHBENR_FLITFEN_Pos = 0xf
	// Bit mask of FLITFEN field.
	RCC_AHBENR_FLITFEN_Msk = 0x8000
	// Bit FLITFEN.
	RCC_AHBENR_FLITFEN = 0x8000
	// Position of CRCEN field.
	RCC_AHBENR_CRCEN_Pos = 0xc
	// Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN_Msk = 0x1000
	// Bit CRCEN.
	RCC_AHBENR_CRCEN = 0x1000
	// Position of GPIOPGEN field.
	RCC_AHBENR_GPIOPGEN_Pos = 0x7
	// Bit mask of GPIOPGEN field.
	RCC_AHBENR_GPIOPGEN_Msk = 0x80
	// Bit GPIOPGEN.
	RCC_AHBENR_GPIOPGEN = 0x80
	// Position of GPIOPFEN field.
	RCC_AHBENR_GPIOPFEN_Pos = 0x6
	// Bit mask of GPIOPFEN field.
	RCC_AHBENR_GPIOPFEN_Msk = 0x40
	// Bit GPIOPFEN.
	RCC_AHBENR_GPIOPFEN = 0x40
	// Position of GPIOPHEN field.
	RCC_AHBENR_GPIOPHEN_Pos = 0x5
	// Bit mask of GPIOPHEN field.
	RCC_AHBENR_GPIOPHEN_Msk = 0x20
	// Bit GPIOPHEN.
	RCC_AHBENR_GPIOPHEN = 0x20
	// Position of GPIOPEEN field.
	RCC_AHBENR_GPIOPEEN_Pos = 0x4
	// Bit mask of GPIOPEEN field.
	RCC_AHBENR_GPIOPEEN_Msk = 0x10
	// Bit GPIOPEEN.
	RCC_AHBENR_GPIOPEEN = 0x10
	// Position of GPIOPDEN field.
	RCC_AHBENR_GPIOPDEN_Pos = 0x3
	// Bit mask of GPIOPDEN field.
	RCC_AHBENR_GPIOPDEN_Msk = 0x8
	// Bit GPIOPDEN.
	RCC_AHBENR_GPIOPDEN = 0x8
	// Position of GPIOPCEN field.
	RCC_AHBENR_GPIOPCEN_Pos = 0x2
	// Bit mask of GPIOPCEN field.
	RCC_AHBENR_GPIOPCEN_Msk = 0x4
	// Bit GPIOPCEN.
	RCC_AHBENR_GPIOPCEN = 0x4
	// Position of GPIOPBEN field.
	RCC_AHBENR_GPIOPBEN_Pos = 0x1
	// Bit mask of GPIOPBEN field.
	RCC_AHBENR_GPIOPBEN_Msk = 0x2
	// Bit GPIOPBEN.
	RCC_AHBENR_GPIOPBEN = 0x2
	// Position of GPIOPAEN field.
	RCC_AHBENR_GPIOPAEN_Pos = 0x0
	// Bit mask of GPIOPAEN field.
	RCC_AHBENR_GPIOPAEN_Msk = 0x1
	// Bit GPIOPAEN.
	RCC_AHBENR_GPIOPAEN = 0x1

	// APB2ENR: APB2 peripheral clock enable register
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x4000
	// Position of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Pos = 0xc
	// Bit mask of SPI1EN field.
	RCC_APB2ENR_SPI1EN_Msk = 0x1000
	// Bit SPI1EN.
	RCC_APB2ENR_SPI1EN = 0x1000
	// Position of SDIOEN field.
	RCC_APB2ENR_SDIOEN_Pos = 0xb
	// Bit mask of SDIOEN field.
	RCC_APB2ENR_SDIOEN_Msk = 0x800
	// Bit SDIOEN.
	RCC_APB2ENR_SDIOEN = 0x800
	// Position of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Pos = 0x9
	// Bit mask of ADC1EN field.
	RCC_APB2ENR_ADC1EN_Msk = 0x200
	// Bit ADC1EN.
	RCC_APB2ENR_ADC1EN = 0x200
	// Position of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Pos = 0x4
	// Bit mask of TIM11EN field.
	RCC_APB2ENR_TIM11EN_Msk = 0x10
	// Bit TIM11EN.
	RCC_APB2ENR_TIM11EN = 0x10
	// Position of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Pos = 0x3
	// Bit mask of TIM10EN field.
	RCC_APB2ENR_TIM10EN_Msk = 0x8
	// Bit TIM10EN.
	RCC_APB2ENR_TIM10EN = 0x8
	// Position of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Pos = 0x2
	// Bit mask of TIM9EN field.
	RCC_APB2ENR_TIM9EN_Msk = 0x4
	// Bit TIM9EN.
	RCC_APB2ENR_TIM9EN = 0x4
	// Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0
	// Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1
	// Bit SYSCFGEN.
	RCC_APB2ENR_SYSCFGEN = 0x1

	// APB1ENR: APB1 peripheral clock enable register
	// Position of COMPEN field.
	RCC_APB1ENR_COMPEN_Pos = 0x1f
	// Bit mask of COMPEN field.
	RCC_APB1ENR_COMPEN_Msk = 0x80000000
	// Bit COMPEN.
	RCC_APB1ENR_COMPEN = 0x80000000
	// Position of DACEN field.
	RCC_APB1ENR_DACEN_Pos = 0x1d
	// Bit mask of DACEN field.
	RCC_APB1ENR_DACEN_Msk = 0x20000000
	// Bit DACEN.
	RCC_APB1ENR_DACEN = 0x20000000
	// Position of PWREN field.
	RCC_APB1ENR_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR_PWREN = 0x10000000
	// Position of USBEN field.
	RCC_APB1ENR_USBEN_Pos = 0x17
	// Bit mask of USBEN field.
	RCC_APB1ENR_USBEN_Msk = 0x800000
	// Bit USBEN.
	RCC_APB1ENR_USBEN = 0x800000
	// Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR_I2C2EN = 0x400000
	// Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR_I2C1EN = 0x200000
	// Position of USART5EN field.
	RCC_APB1ENR_USART5EN_Pos = 0x14
	// Bit mask of USART5EN field.
	RCC_APB1ENR_USART5EN_Msk = 0x100000
	// Bit USART5EN.
	RCC_APB1ENR_USART5EN = 0x100000
	// Position of USART4EN field.
	RCC_APB1ENR_USART4EN_Pos = 0x13
	// Bit mask of USART4EN field.
	RCC_APB1ENR_USART4EN_Msk = 0x80000
	// Bit USART4EN.
	RCC_APB1ENR_USART4EN = 0x80000
	// Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Pos = 0x12
	// Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000
	// Bit USART3EN.
	RCC_APB1ENR_USART3EN = 0x40000
	// Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR_USART2EN = 0x20000
	// Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Pos = 0xf
	// Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk = 0x8000
	// Bit SPI3EN.
	RCC_APB1ENR_SPI3EN = 0x8000
	// Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR_SPI2EN = 0x4000
	// Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR_WWDGEN = 0x800
	// Position of LCDEN field.
	RCC_APB1ENR_LCDEN_Pos = 0x9
	// Bit mask of LCDEN field.
	RCC_APB1ENR_LCDEN_Msk = 0x200
	// Bit LCDEN.
	RCC_APB1ENR_LCDEN = 0x200
	// Position of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Pos = 0x5
	// Bit mask of TIM7EN field.
	RCC_APB1ENR_TIM7EN_Msk = 0x20
	// Bit TIM7EN.
	RCC_APB1ENR_TIM7EN = 0x20
	// Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Pos = 0x4
	// Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk = 0x10
	// Bit TIM6EN.
	RCC_APB1ENR_TIM6EN = 0x10
	// Position of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Pos = 0x3
	// Bit mask of TIM5EN field.
	RCC_APB1ENR_TIM5EN_Msk = 0x8
	// Bit TIM5EN.
	RCC_APB1ENR_TIM5EN = 0x8
	// Position of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Pos = 0x2
	// Bit mask of TIM4EN field.
	RCC_APB1ENR_TIM4EN_Msk = 0x4
	// Bit TIM4EN.
	RCC_APB1ENR_TIM4EN = 0x4
	// Position of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Pos = 0x1
	// Bit mask of TIM3EN field.
	RCC_APB1ENR_TIM3EN_Msk = 0x2
	// Bit TIM3EN.
	RCC_APB1ENR_TIM3EN = 0x2
	// Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR_TIM2EN = 0x1

	// AHBLPENR: AHB peripheral clock enable in low power mode register
	// Position of DMA2LPEN field.
	RCC_AHBLPENR_DMA2LPEN_Pos = 0x19
	// Bit mask of DMA2LPEN field.
	RCC_AHBLPENR_DMA2LPEN_Msk = 0x2000000
	// Bit DMA2LPEN.
	RCC_AHBLPENR_DMA2LPEN = 0x2000000
	// Position of DMA1LPEN field.
	RCC_AHBLPENR_DMA1LPEN_Pos = 0x18
	// Bit mask of DMA1LPEN field.
	RCC_AHBLPENR_DMA1LPEN_Msk = 0x1000000
	// Bit DMA1LPEN.
	RCC_AHBLPENR_DMA1LPEN = 0x1000000
	// Position of SRAMLPEN field.
	RCC_AHBLPENR_SRAMLPEN_Pos = 0x10
	// Bit mask of SRAMLPEN field.
	RCC_AHBLPENR_SRAMLPEN_Msk = 0x10000
	// Bit SRAMLPEN.
	RCC_AHBLPENR_SRAMLPEN = 0x10000
	// Position of FLITFLPEN field.
	RCC_AHBLPENR_FLITFLPEN_Pos = 0xf
	// Bit mask of FLITFLPEN field.
	RCC_AHBLPENR_FLITFLPEN_Msk = 0x8000
	// Bit FLITFLPEN.
	RCC_AHBLPENR_FLITFLPEN = 0x8000
	// Position of CRCLPEN field.
	RCC_AHBLPENR_CRCLPEN_Pos = 0xc
	// Bit mask of CRCLPEN field.
	RCC_AHBLPENR_CRCLPEN_Msk = 0x1000
	// Bit CRCLPEN.
	RCC_AHBLPENR_CRCLPEN = 0x1000
	// Position of GPIOGLPEN field.
	RCC_AHBLPENR_GPIOGLPEN_Pos = 0x7
	// Bit mask of GPIOGLPEN field.
	RCC_AHBLPENR_GPIOGLPEN_Msk = 0x80
	// Bit GPIOGLPEN.
	RCC_AHBLPENR_GPIOGLPEN = 0x80
	// Position of GPIOFLPEN field.
	RCC_AHBLPENR_GPIOFLPEN_Pos = 0x6
	// Bit mask of GPIOFLPEN field.
	RCC_AHBLPENR_GPIOFLPEN_Msk = 0x40
	// Bit GPIOFLPEN.
	RCC_AHBLPENR_GPIOFLPEN = 0x40
	// Position of GPIOHLPEN field.
	RCC_AHBLPENR_GPIOHLPEN_Pos = 0x5
	// Bit mask of GPIOHLPEN field.
	RCC_AHBLPENR_GPIOHLPEN_Msk = 0x20
	// Bit GPIOHLPEN.
	RCC_AHBLPENR_GPIOHLPEN = 0x20
	// Position of GPIOELPEN field.
	RCC_AHBLPENR_GPIOELPEN_Pos = 0x4
	// Bit mask of GPIOELPEN field.
	RCC_AHBLPENR_GPIOELPEN_Msk = 0x10
	// Bit GPIOELPEN.
	RCC_AHBLPENR_GPIOELPEN = 0x10
	// Position of GPIODLPEN field.
	RCC_AHBLPENR_GPIODLPEN_Pos = 0x3
	// Bit mask of GPIODLPEN field.
	RCC_AHBLPENR_GPIODLPEN_Msk = 0x8
	// Bit GPIODLPEN.
	RCC_AHBLPENR_GPIODLPEN = 0x8
	// Position of GPIOCLPEN field.
	RCC_AHBLPENR_GPIOCLPEN_Pos = 0x2
	// Bit mask of GPIOCLPEN field.
	RCC_AHBLPENR_GPIOCLPEN_Msk = 0x4
	// Bit GPIOCLPEN.
	RCC_AHBLPENR_GPIOCLPEN = 0x4
	// Position of GPIOBLPEN field.
	RCC_AHBLPENR_GPIOBLPEN_Pos = 0x1
	// Bit mask of GPIOBLPEN field.
	RCC_AHBLPENR_GPIOBLPEN_Msk = 0x2
	// Bit GPIOBLPEN.
	RCC_AHBLPENR_GPIOBLPEN = 0x2
	// Position of GPIOALPEN field.
	RCC_AHBLPENR_GPIOALPEN_Pos = 0x0
	// Bit mask of GPIOALPEN field.
	RCC_AHBLPENR_GPIOALPEN_Msk = 0x1
	// Bit GPIOALPEN.
	RCC_AHBLPENR_GPIOALPEN = 0x1

	// APB2LPENR: APB2 peripheral clock enable in low power mode register
	// Position of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Pos = 0xe
	// Bit mask of USART1LPEN field.
	RCC_APB2LPENR_USART1LPEN_Msk = 0x4000
	// Bit USART1LPEN.
	RCC_APB2LPENR_USART1LPEN = 0x4000
	// Position of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Pos = 0xc
	// Bit mask of SPI1LPEN field.
	RCC_APB2LPENR_SPI1LPEN_Msk = 0x1000
	// Bit SPI1LPEN.
	RCC_APB2LPENR_SPI1LPEN = 0x1000
	// Position of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN_Pos = 0xb
	// Bit mask of SDIOLPEN field.
	RCC_APB2LPENR_SDIOLPEN_Msk = 0x800
	// Bit SDIOLPEN.
	RCC_APB2LPENR_SDIOLPEN = 0x800
	// Position of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Pos = 0x9
	// Bit mask of ADC1LPEN field.
	RCC_APB2LPENR_ADC1LPEN_Msk = 0x200
	// Bit ADC1LPEN.
	RCC_APB2LPENR_ADC1LPEN = 0x200
	// Position of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Pos = 0x4
	// Bit mask of TIM11LPEN field.
	RCC_APB2LPENR_TIM11LPEN_Msk = 0x10
	// Bit TIM11LPEN.
	RCC_APB2LPENR_TIM11LPEN = 0x10
	// Position of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Pos = 0x3
	// Bit mask of TIM10LPEN field.
	RCC_APB2LPENR_TIM10LPEN_Msk = 0x8
	// Bit TIM10LPEN.
	RCC_APB2LPENR_TIM10LPEN = 0x8
	// Position of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Pos = 0x2
	// Bit mask of TIM9LPEN field.
	RCC_APB2LPENR_TIM9LPEN_Msk = 0x4
	// Bit TIM9LPEN.
	RCC_APB2LPENR_TIM9LPEN = 0x4
	// Position of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Pos = 0x0
	// Bit mask of SYSCFGLPEN field.
	RCC_APB2LPENR_SYSCFGLPEN_Msk = 0x1
	// Bit SYSCFGLPEN.
	RCC_APB2LPENR_SYSCFGLPEN = 0x1

	// APB1LPENR: APB1 peripheral clock enable in low power mode register
	// Position of COMPLPEN field.
	RCC_APB1LPENR_COMPLPEN_Pos = 0x1f
	// Bit mask of COMPLPEN field.
	RCC_APB1LPENR_COMPLPEN_Msk = 0x80000000
	// Bit COMPLPEN.
	RCC_APB1LPENR_COMPLPEN = 0x80000000
	// Position of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Pos = 0x1d
	// Bit mask of DACLPEN field.
	RCC_APB1LPENR_DACLPEN_Msk = 0x20000000
	// Bit DACLPEN.
	RCC_APB1LPENR_DACLPEN = 0x20000000
	// Position of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Pos = 0x1c
	// Bit mask of PWRLPEN field.
	RCC_APB1LPENR_PWRLPEN_Msk = 0x10000000
	// Bit PWRLPEN.
	RCC_APB1LPENR_PWRLPEN = 0x10000000
	// Position of USBLPEN field.
	RCC_APB1LPENR_USBLPEN_Pos = 0x17
	// Bit mask of USBLPEN field.
	RCC_APB1LPENR_USBLPEN_Msk = 0x800000
	// Bit USBLPEN.
	RCC_APB1LPENR_USBLPEN = 0x800000
	// Position of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Pos = 0x16
	// Bit mask of I2C2LPEN field.
	RCC_APB1LPENR_I2C2LPEN_Msk = 0x400000
	// Bit I2C2LPEN.
	RCC_APB1LPENR_I2C2LPEN = 0x400000
	// Position of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Pos = 0x15
	// Bit mask of I2C1LPEN field.
	RCC_APB1LPENR_I2C1LPEN_Msk = 0x200000
	// Bit I2C1LPEN.
	RCC_APB1LPENR_I2C1LPEN = 0x200000
	// Position of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Pos = 0x12
	// Bit mask of USART3LPEN field.
	RCC_APB1LPENR_USART3LPEN_Msk = 0x40000
	// Bit USART3LPEN.
	RCC_APB1LPENR_USART3LPEN = 0x40000
	// Position of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Pos = 0x11
	// Bit mask of USART2LPEN field.
	RCC_APB1LPENR_USART2LPEN_Msk = 0x20000
	// Bit USART2LPEN.
	RCC_APB1LPENR_USART2LPEN = 0x20000
	// Position of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Pos = 0xe
	// Bit mask of SPI2LPEN field.
	RCC_APB1LPENR_SPI2LPEN_Msk = 0x4000
	// Bit SPI2LPEN.
	RCC_APB1LPENR_SPI2LPEN = 0x4000
	// Position of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Pos = 0xb
	// Bit mask of WWDGLPEN field.
	RCC_APB1LPENR_WWDGLPEN_Msk = 0x800
	// Bit WWDGLPEN.
	RCC_APB1LPENR_WWDGLPEN = 0x800
	// Position of LCDLPEN field.
	RCC_APB1LPENR_LCDLPEN_Pos = 0x9
	// Bit mask of LCDLPEN field.
	RCC_APB1LPENR_LCDLPEN_Msk = 0x200
	// Bit LCDLPEN.
	RCC_APB1LPENR_LCDLPEN = 0x200
	// Position of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Pos = 0x5
	// Bit mask of TIM7LPEN field.
	RCC_APB1LPENR_TIM7LPEN_Msk = 0x20
	// Bit TIM7LPEN.
	RCC_APB1LPENR_TIM7LPEN = 0x20
	// Position of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Pos = 0x4
	// Bit mask of TIM6LPEN field.
	RCC_APB1LPENR_TIM6LPEN_Msk = 0x10
	// Bit TIM6LPEN.
	RCC_APB1LPENR_TIM6LPEN = 0x10
	// Position of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Pos = 0x2
	// Bit mask of TIM4LPEN field.
	RCC_APB1LPENR_TIM4LPEN_Msk = 0x4
	// Bit TIM4LPEN.
	RCC_APB1LPENR_TIM4LPEN = 0x4
	// Position of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Pos = 0x1
	// Bit mask of TIM3LPEN field.
	RCC_APB1LPENR_TIM3LPEN_Msk = 0x2
	// Bit TIM3LPEN.
	RCC_APB1LPENR_TIM3LPEN = 0x2
	// Position of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Pos = 0x0
	// Bit mask of TIM2LPEN field.
	RCC_APB1LPENR_TIM2LPEN_Msk = 0x1
	// Bit TIM2LPEN.
	RCC_APB1LPENR_TIM2LPEN = 0x1

	// CSR: Control/status register
	// Position of LPWRSTF field.
	RCC_CSR_LPWRSTF_Pos = 0x1f
	// Bit mask of LPWRSTF field.
	RCC_CSR_LPWRSTF_Msk = 0x80000000
	// Bit LPWRSTF.
	RCC_CSR_LPWRSTF = 0x80000000
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Pos = 0x1d
	// Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000
	// Bit IWDGRSTF.
	RCC_CSR_IWDGRSTF = 0x20000000
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// Position of PORRSTF field.
	RCC_CSR_PORRSTF_Pos = 0x1b
	// Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF_Msk = 0x8000000
	// Bit PORRSTF.
	RCC_CSR_PORRSTF = 0x8000000
	// Position of PINRSTF field.
	RCC_CSR_PINRSTF_Pos = 0x1a
	// Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF_Msk = 0x4000000
	// Bit PINRSTF.
	RCC_CSR_PINRSTF = 0x4000000
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x18
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x1000000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x1000000
	// Position of RTCRST field.
	RCC_CSR_RTCRST_Pos = 0x17
	// Bit mask of RTCRST field.
	RCC_CSR_RTCRST_Msk = 0x800000
	// Bit RTCRST.
	RCC_CSR_RTCRST = 0x800000
	// Position of RTCEN field.
	RCC_CSR_RTCEN_Pos = 0x16
	// Bit mask of RTCEN field.
	RCC_CSR_RTCEN_Msk = 0x400000
	// Bit RTCEN.
	RCC_CSR_RTCEN = 0x400000
	// Position of RTCSEL field.
	RCC_CSR_RTCSEL_Pos = 0x10
	// Bit mask of RTCSEL field.
	RCC_CSR_RTCSEL_Msk = 0x30000
	// Position of LSEBYP field.
	RCC_CSR_LSEBYP_Pos = 0xa
	// Bit mask of LSEBYP field.
	RCC_CSR_LSEBYP_Msk = 0x400
	// Bit LSEBYP.
	RCC_CSR_LSEBYP = 0x400
	// Position of LSERDY field.
	RCC_CSR_LSERDY_Pos = 0x9
	// Bit mask of LSERDY field.
	RCC_CSR_LSERDY_Msk = 0x200
	// Bit LSERDY.
	RCC_CSR_LSERDY = 0x200
	// Position of LSEON field.
	RCC_CSR_LSEON_Pos = 0x8
	// Bit mask of LSEON field.
	RCC_CSR_LSEON_Msk = 0x100
	// Bit LSEON.
	RCC_CSR_LSEON = 0x100
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
)

// Constants for RI: Routing interface
const (
	// ICR: RI input capture register
	// Position of IC4 field.
	RI_ICR_IC4_Pos = 0x15
	// Bit mask of IC4 field.
	RI_ICR_IC4_Msk = 0x200000
	// Bit IC4.
	RI_ICR_IC4 = 0x200000
	// Position of IC3 field.
	RI_ICR_IC3_Pos = 0x14
	// Bit mask of IC3 field.
	RI_ICR_IC3_Msk = 0x100000
	// Bit IC3.
	RI_ICR_IC3 = 0x100000
	// Position of IC2 field.
	RI_ICR_IC2_Pos = 0x13
	// Bit mask of IC2 field.
	RI_ICR_IC2_Msk = 0x80000
	// Bit IC2.
	RI_ICR_IC2 = 0x80000
	// Position of IC1 field.
	RI_ICR_IC1_Pos = 0x12
	// Bit mask of IC1 field.
	RI_ICR_IC1_Msk = 0x40000
	// Bit IC1.
	RI_ICR_IC1 = 0x40000
	// Position of TIM field.
	RI_ICR_TIM_Pos = 0x10
	// Bit mask of TIM field.
	RI_ICR_TIM_Msk = 0x30000
	// Position of IC4IOS field.
	RI_ICR_IC4IOS_Pos = 0xc
	// Bit mask of IC4IOS field.
	RI_ICR_IC4IOS_Msk = 0xf000
	// Position of IC3IOS field.
	RI_ICR_IC3IOS_Pos = 0x8
	// Bit mask of IC3IOS field.
	RI_ICR_IC3IOS_Msk = 0xf00
	// Position of IC2IOS field.
	RI_ICR_IC2IOS_Pos = 0x4
	// Bit mask of IC2IOS field.
	RI_ICR_IC2IOS_Msk = 0xf0
	// Position of IC1IOS field.
	RI_ICR_IC1IOS_Pos = 0x0
	// Bit mask of IC1IOS field.
	RI_ICR_IC1IOS_Msk = 0xf

	// ASCR1: RI analog switches control register 1
	// Position of SCM field.
	RI_ASCR1_SCM_Pos = 0x1f
	// Bit mask of SCM field.
	RI_ASCR1_SCM_Msk = 0x80000000
	// Bit SCM.
	RI_ASCR1_SCM = 0x80000000
	// Position of CH30GR11_4 field.
	RI_ASCR1_CH30GR11_4_Pos = 0x1e
	// Bit mask of CH30GR11_4 field.
	RI_ASCR1_CH30GR11_4_Msk = 0x40000000
	// Bit CH30GR11_4.
	RI_ASCR1_CH30GR11_4 = 0x40000000
	// Position of CH29GR11_3 field.
	RI_ASCR1_CH29GR11_3_Pos = 0x1d
	// Bit mask of CH29GR11_3 field.
	RI_ASCR1_CH29GR11_3_Msk = 0x20000000
	// Bit CH29GR11_3.
	RI_ASCR1_CH29GR11_3 = 0x20000000
	// Position of CH28GR11_2 field.
	RI_ASCR1_CH28GR11_2_Pos = 0x1c
	// Bit mask of CH28GR11_2 field.
	RI_ASCR1_CH28GR11_2_Msk = 0x10000000
	// Bit CH28GR11_2.
	RI_ASCR1_CH28GR11_2 = 0x10000000
	// Position of CH27GR11_1 field.
	RI_ASCR1_CH27GR11_1_Pos = 0x1b
	// Bit mask of CH27GR11_1 field.
	RI_ASCR1_CH27GR11_1_Msk = 0x8000000
	// Bit CH27GR11_1.
	RI_ASCR1_CH27GR11_1 = 0x8000000
	// Position of VCOMP field.
	RI_ASCR1_VCOMP_Pos = 0x1a
	// Bit mask of VCOMP field.
	RI_ASCR1_VCOMP_Msk = 0x4000000
	// Bit VCOMP.
	RI_ASCR1_VCOMP = 0x4000000
	// Position of CH25 field.
	RI_ASCR1_CH25_Pos = 0x19
	// Bit mask of CH25 field.
	RI_ASCR1_CH25_Msk = 0x2000000
	// Bit CH25.
	RI_ASCR1_CH25 = 0x2000000
	// Position of CH24 field.
	RI_ASCR1_CH24_Pos = 0x18
	// Bit mask of CH24 field.
	RI_ASCR1_CH24_Msk = 0x1000000
	// Bit CH24.
	RI_ASCR1_CH24 = 0x1000000
	// Position of CH23 field.
	RI_ASCR1_CH23_Pos = 0x17
	// Bit mask of CH23 field.
	RI_ASCR1_CH23_Msk = 0x800000
	// Bit CH23.
	RI_ASCR1_CH23 = 0x800000
	// Position of CH22 field.
	RI_ASCR1_CH22_Pos = 0x16
	// Bit mask of CH22 field.
	RI_ASCR1_CH22_Msk = 0x400000
	// Bit CH22.
	RI_ASCR1_CH22 = 0x400000
	// Position of CH21GR7_4 field.
	RI_ASCR1_CH21GR7_4_Pos = 0x15
	// Bit mask of CH21GR7_4 field.
	RI_ASCR1_CH21GR7_4_Msk = 0x200000
	// Bit CH21GR7_4.
	RI_ASCR1_CH21GR7_4 = 0x200000
	// Position of CH20GR7_3 field.
	RI_ASCR1_CH20GR7_3_Pos = 0x14
	// Bit mask of CH20GR7_3 field.
	RI_ASCR1_CH20GR7_3_Msk = 0x100000
	// Bit CH20GR7_3.
	RI_ASCR1_CH20GR7_3 = 0x100000
	// Position of CH19GR7_2 field.
	RI_ASCR1_CH19GR7_2_Pos = 0x13
	// Bit mask of CH19GR7_2 field.
	RI_ASCR1_CH19GR7_2_Msk = 0x80000
	// Bit CH19GR7_2.
	RI_ASCR1_CH19GR7_2 = 0x80000
	// Position of CH18GR7_1 field.
	RI_ASCR1_CH18GR7_1_Pos = 0x12
	// Bit mask of CH18GR7_1 field.
	RI_ASCR1_CH18GR7_1_Msk = 0x40000
	// Bit CH18GR7_1.
	RI_ASCR1_CH18GR7_1 = 0x40000
	// Position of CH31GR7_1 field.
	RI_ASCR1_CH31GR7_1_Pos = 0x10
	// Bit mask of CH31GR7_1 field.
	RI_ASCR1_CH31GR7_1_Msk = 0x10000
	// Bit CH31GR7_1.
	RI_ASCR1_CH31GR7_1 = 0x10000
	// Position of CH15GR9_2 field.
	RI_ASCR1_CH15GR9_2_Pos = 0xf
	// Bit mask of CH15GR9_2 field.
	RI_ASCR1_CH15GR9_2_Msk = 0x8000
	// Bit CH15GR9_2.
	RI_ASCR1_CH15GR9_2 = 0x8000
	// Position of CH14GR9_1 field.
	RI_ASCR1_CH14GR9_1_Pos = 0xe
	// Bit mask of CH14GR9_1 field.
	RI_ASCR1_CH14GR9_1_Msk = 0x4000
	// Bit CH14GR9_1.
	RI_ASCR1_CH14GR9_1 = 0x4000
	// Position of CH13GR8_4 field.
	RI_ASCR1_CH13GR8_4_Pos = 0xd
	// Bit mask of CH13GR8_4 field.
	RI_ASCR1_CH13GR8_4_Msk = 0x2000
	// Bit CH13GR8_4.
	RI_ASCR1_CH13GR8_4 = 0x2000
	// Position of CH12GR8_3 field.
	RI_ASCR1_CH12GR8_3_Pos = 0xc
	// Bit mask of CH12GR8_3 field.
	RI_ASCR1_CH12GR8_3_Msk = 0x1000
	// Bit CH12GR8_3.
	RI_ASCR1_CH12GR8_3 = 0x1000
	// Position of CH11GR8_2 field.
	RI_ASCR1_CH11GR8_2_Pos = 0xb
	// Bit mask of CH11GR8_2 field.
	RI_ASCR1_CH11GR8_2_Msk = 0x800
	// Bit CH11GR8_2.
	RI_ASCR1_CH11GR8_2 = 0x800
	// Position of CH10GR8_1 field.
	RI_ASCR1_CH10GR8_1_Pos = 0xa
	// Bit mask of CH10GR8_1 field.
	RI_ASCR1_CH10GR8_1_Msk = 0x400
	// Bit CH10GR8_1.
	RI_ASCR1_CH10GR8_1 = 0x400
	// Position of CH9GR3_2 field.
	RI_ASCR1_CH9GR3_2_Pos = 0x9
	// Bit mask of CH9GR3_2 field.
	RI_ASCR1_CH9GR3_2_Msk = 0x200
	// Bit CH9GR3_2.
	RI_ASCR1_CH9GR3_2 = 0x200
	// Position of CH8GR3_1 field.
	RI_ASCR1_CH8GR3_1_Pos = 0x8
	// Bit mask of CH8GR3_1 field.
	RI_ASCR1_CH8GR3_1_Msk = 0x100
	// Bit CH8GR3_1.
	RI_ASCR1_CH8GR3_1 = 0x100
	// Position of CH7GR2_2 field.
	RI_ASCR1_CH7GR2_2_Pos = 0x7
	// Bit mask of CH7GR2_2 field.
	RI_ASCR1_CH7GR2_2_Msk = 0x80
	// Bit CH7GR2_2.
	RI_ASCR1_CH7GR2_2 = 0x80
	// Position of CH6GR2_1 field.
	RI_ASCR1_CH6GR2_1_Pos = 0x6
	// Bit mask of CH6GR2_1 field.
	RI_ASCR1_CH6GR2_1_Msk = 0x40
	// Bit CH6GR2_1.
	RI_ASCR1_CH6GR2_1 = 0x40
	// Position of COMP1_SW1 field.
	RI_ASCR1_COMP1_SW1_Pos = 0x5
	// Bit mask of COMP1_SW1 field.
	RI_ASCR1_COMP1_SW1_Msk = 0x20
	// Bit COMP1_SW1.
	RI_ASCR1_COMP1_SW1 = 0x20
	// Position of CH31GR11_5 field.
	RI_ASCR1_CH31GR11_5_Pos = 0x4
	// Bit mask of CH31GR11_5 field.
	RI_ASCR1_CH31GR11_5_Msk = 0x10
	// Bit CH31GR11_5.
	RI_ASCR1_CH31GR11_5 = 0x10
	// Position of CH3GR1_4 field.
	RI_ASCR1_CH3GR1_4_Pos = 0x3
	// Bit mask of CH3GR1_4 field.
	RI_ASCR1_CH3GR1_4_Msk = 0x8
	// Bit CH3GR1_4.
	RI_ASCR1_CH3GR1_4 = 0x8
	// Position of CH2GR1_3 field.
	RI_ASCR1_CH2GR1_3_Pos = 0x2
	// Bit mask of CH2GR1_3 field.
	RI_ASCR1_CH2GR1_3_Msk = 0x4
	// Bit CH2GR1_3.
	RI_ASCR1_CH2GR1_3 = 0x4
	// Position of CH1GR1_2 field.
	RI_ASCR1_CH1GR1_2_Pos = 0x1
	// Bit mask of CH1GR1_2 field.
	RI_ASCR1_CH1GR1_2_Msk = 0x2
	// Bit CH1GR1_2.
	RI_ASCR1_CH1GR1_2 = 0x2
	// Position of CH0GR1_1 field.
	RI_ASCR1_CH0GR1_1_Pos = 0x0
	// Bit mask of CH0GR1_1 field.
	RI_ASCR1_CH0GR1_1_Msk = 0x1
	// Bit CH0GR1_1.
	RI_ASCR1_CH0GR1_1 = 0x1

	// ASCR2: RI analog switches control register 2
	// Position of GR5_4 field.
	RI_ASCR2_GR5_4_Pos = 0x1d
	// Bit mask of GR5_4 field.
	RI_ASCR2_GR5_4_Msk = 0x20000000
	// Bit GR5_4.
	RI_ASCR2_GR5_4 = 0x20000000
	// Position of GR6_4 field.
	RI_ASCR2_GR6_4_Pos = 0x1c
	// Bit mask of GR6_4 field.
	RI_ASCR2_GR6_4_Msk = 0x10000000
	// Bit GR6_4.
	RI_ASCR2_GR6_4 = 0x10000000
	// Position of GR6_3 field.
	RI_ASCR2_GR6_3_Pos = 0x1b
	// Bit mask of GR6_3 field.
	RI_ASCR2_GR6_3_Msk = 0x8000000
	// Bit GR6_3.
	RI_ASCR2_GR6_3 = 0x8000000
	// Position of GR7_7 field.
	RI_ASCR2_GR7_7_Pos = 0x1a
	// Bit mask of GR7_7 field.
	RI_ASCR2_GR7_7_Msk = 0x4000000
	// Bit GR7_7.
	RI_ASCR2_GR7_7 = 0x4000000
	// Position of GR7_6 field.
	RI_ASCR2_GR7_6_Pos = 0x19
	// Bit mask of GR7_6 field.
	RI_ASCR2_GR7_6_Msk = 0x2000000
	// Bit GR7_6.
	RI_ASCR2_GR7_6 = 0x2000000
	// Position of GR7_5 field.
	RI_ASCR2_GR7_5_Pos = 0x18
	// Bit mask of GR7_5 field.
	RI_ASCR2_GR7_5_Msk = 0x1000000
	// Bit GR7_5.
	RI_ASCR2_GR7_5 = 0x1000000
	// Position of GR2_5 field.
	RI_ASCR2_GR2_5_Pos = 0x17
	// Bit mask of GR2_5 field.
	RI_ASCR2_GR2_5_Msk = 0x800000
	// Bit GR2_5.
	RI_ASCR2_GR2_5 = 0x800000
	// Position of GR2_4 field.
	RI_ASCR2_GR2_4_Pos = 0x16
	// Bit mask of GR2_4 field.
	RI_ASCR2_GR2_4_Msk = 0x400000
	// Bit GR2_4.
	RI_ASCR2_GR2_4 = 0x400000
	// Position of GR2_3 field.
	RI_ASCR2_GR2_3_Pos = 0x15
	// Bit mask of GR2_3 field.
	RI_ASCR2_GR2_3_Msk = 0x200000
	// Bit GR2_3.
	RI_ASCR2_GR2_3 = 0x200000
	// Position of GR9_4 field.
	RI_ASCR2_GR9_4_Pos = 0x14
	// Bit mask of GR9_4 field.
	RI_ASCR2_GR9_4_Msk = 0x100000
	// Bit GR9_4.
	RI_ASCR2_GR9_4 = 0x100000
	// Position of GR9_3 field.
	RI_ASCR2_GR9_3_Pos = 0x13
	// Bit mask of GR9_3 field.
	RI_ASCR2_GR9_3_Msk = 0x80000
	// Bit GR9_3.
	RI_ASCR2_GR9_3 = 0x80000
	// Position of GR3_5 field.
	RI_ASCR2_GR3_5_Pos = 0x12
	// Bit mask of GR3_5 field.
	RI_ASCR2_GR3_5_Msk = 0x40000
	// Bit GR3_5.
	RI_ASCR2_GR3_5 = 0x40000
	// Position of GR3_4 field.
	RI_ASCR2_GR3_4_Pos = 0x11
	// Bit mask of GR3_4 field.
	RI_ASCR2_GR3_4_Msk = 0x20000
	// Bit GR3_4.
	RI_ASCR2_GR3_4 = 0x20000
	// Position of GR3_3 field.
	RI_ASCR2_GR3_3_Pos = 0x10
	// Bit mask of GR3_3 field.
	RI_ASCR2_GR3_3_Msk = 0x10000
	// Bit GR3_3.
	RI_ASCR2_GR3_3 = 0x10000
	// Position of GR4_3 field.
	RI_ASCR2_GR4_3_Pos = 0xb
	// Bit mask of GR4_3 field.
	RI_ASCR2_GR4_3_Msk = 0x800
	// Bit GR4_3.
	RI_ASCR2_GR4_3 = 0x800
	// Position of GR4_2 field.
	RI_ASCR2_GR4_2_Pos = 0xa
	// Bit mask of GR4_2 field.
	RI_ASCR2_GR4_2_Msk = 0x400
	// Bit GR4_2.
	RI_ASCR2_GR4_2 = 0x400
	// Position of GR4_1 field.
	RI_ASCR2_GR4_1_Pos = 0x9
	// Bit mask of GR4_1 field.
	RI_ASCR2_GR4_1_Msk = 0x200
	// Bit GR4_1.
	RI_ASCR2_GR4_1 = 0x200
	// Position of GR5_3 field.
	RI_ASCR2_GR5_3_Pos = 0x8
	// Bit mask of GR5_3 field.
	RI_ASCR2_GR5_3_Msk = 0x100
	// Bit GR5_3.
	RI_ASCR2_GR5_3 = 0x100
	// Position of GR5_2 field.
	RI_ASCR2_GR5_2_Pos = 0x7
	// Bit mask of GR5_2 field.
	RI_ASCR2_GR5_2_Msk = 0x80
	// Bit GR5_2.
	RI_ASCR2_GR5_2 = 0x80
	// Position of GR5_1 field.
	RI_ASCR2_GR5_1_Pos = 0x6
	// Bit mask of GR5_1 field.
	RI_ASCR2_GR5_1_Msk = 0x40
	// Bit GR5_1.
	RI_ASCR2_GR5_1 = 0x40
	// Position of GR6_2 field.
	RI_ASCR2_GR6_2_Pos = 0x5
	// Bit mask of GR6_2 field.
	RI_ASCR2_GR6_2_Msk = 0x20
	// Bit GR6_2.
	RI_ASCR2_GR6_2 = 0x20
	// Position of GR6_1 field.
	RI_ASCR2_GR6_1_Pos = 0x4
	// Bit mask of GR6_1 field.
	RI_ASCR2_GR6_1_Msk = 0x10
	// Bit GR6_1.
	RI_ASCR2_GR6_1 = 0x10
	// Position of GR10_4 field.
	RI_ASCR2_GR10_4_Pos = 0x3
	// Bit mask of GR10_4 field.
	RI_ASCR2_GR10_4_Msk = 0x8
	// Bit GR10_4.
	RI_ASCR2_GR10_4 = 0x8
	// Position of GR10_3 field.
	RI_ASCR2_GR10_3_Pos = 0x2
	// Bit mask of GR10_3 field.
	RI_ASCR2_GR10_3_Msk = 0x4
	// Bit GR10_3.
	RI_ASCR2_GR10_3 = 0x4
	// Position of GR10_2 field.
	RI_ASCR2_GR10_2_Pos = 0x1
	// Bit mask of GR10_2 field.
	RI_ASCR2_GR10_2_Msk = 0x2
	// Bit GR10_2.
	RI_ASCR2_GR10_2 = 0x2
	// Position of GR10_1 field.
	RI_ASCR2_GR10_1_Pos = 0x0
	// Bit mask of GR10_1 field.
	RI_ASCR2_GR10_1_Msk = 0x1
	// Bit GR10_1.
	RI_ASCR2_GR10_1 = 0x1

	// HYSCR1: RI hysteresis control register 1
	// Position of PB field.
	RI_HYSCR1_PB_Pos = 0x10
	// Bit mask of PB field.
	RI_HYSCR1_PB_Msk = 0xffff0000
	// Position of PA field.
	RI_HYSCR1_PA_Pos = 0x0
	// Bit mask of PA field.
	RI_HYSCR1_PA_Msk = 0xffff

	// HYSCR2: RI hysteresis control register 2
	// Position of PD field.
	RI_HYSCR2_PD_Pos = 0x10
	// Bit mask of PD field.
	RI_HYSCR2_PD_Msk = 0xffff0000
	// Position of PC field.
	RI_HYSCR2_PC_Pos = 0x0
	// Bit mask of PC field.
	RI_HYSCR2_PC_Msk = 0xffff

	// HYSCR3: RI hysteresis control register 3
	// Position of PF field.
	RI_HYSCR3_PF_Pos = 0x10
	// Bit mask of PF field.
	RI_HYSCR3_PF_Msk = 0xffff0000
	// Position of PE field.
	RI_HYSCR3_PE_Pos = 0x0
	// Bit mask of PE field.
	RI_HYSCR3_PE_Msk = 0xffff

	// HYSCR4: Hysteresis control register
	// Position of PG field.
	RI_HYSCR4_PG_Pos = 0x0
	// Bit mask of PG field.
	RI_HYSCR4_PG_Msk = 0xffff
)

// Constants for RTC: Real-time clock
const (
	// TR: time register
	// Position of PM field.
	RTC_TR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TR_PM = 0x400000
	// Position of HT field.
	RTC_TR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TR_SU_Msk = 0xf

	// DR: date register
	// Position of YT field.
	RTC_DR_YT_Pos = 0x14
	// Bit mask of YT field.
	RTC_DR_YT_Msk = 0xf00000
	// Position of YU field.
	RTC_DR_YU_Pos = 0x10
	// Bit mask of YU field.
	RTC_DR_YU_Msk = 0xf0000
	// Position of WDU field.
	RTC_DR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_DR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_DR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_DR_MT_Msk = 0x1000
	// Bit MT.
	RTC_DR_MT = 0x1000
	// Position of MU field.
	RTC_DR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_DR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_DR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_DR_DT_Msk = 0x30
	// Position of DU field.
	RTC_DR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_DR_DU_Msk = 0xf

	// CR: control register
	// Position of COE field.
	RTC_CR_COE_Pos = 0x17
	// Bit mask of COE field.
	RTC_CR_COE_Msk = 0x800000
	// Bit COE.
	RTC_CR_COE = 0x800000
	// Position of OSEL field.
	RTC_CR_OSEL_Pos = 0x15
	// Bit mask of OSEL field.
	RTC_CR_OSEL_Msk = 0x600000
	// Position of POL field.
	RTC_CR_POL_Pos = 0x14
	// Bit mask of POL field.
	RTC_CR_POL_Msk = 0x100000
	// Bit POL.
	RTC_CR_POL = 0x100000
	// Position of COSEL field.
	RTC_CR_COSEL_Pos = 0x13
	// Bit mask of COSEL field.
	RTC_CR_COSEL_Msk = 0x80000
	// Bit COSEL.
	RTC_CR_COSEL = 0x80000
	// Position of BKP field.
	RTC_CR_BKP_Pos = 0x12
	// Bit mask of BKP field.
	RTC_CR_BKP_Msk = 0x40000
	// Bit BKP.
	RTC_CR_BKP = 0x40000
	// Position of SUB1H field.
	RTC_CR_SUB1H_Pos = 0x11
	// Bit mask of SUB1H field.
	RTC_CR_SUB1H_Msk = 0x20000
	// Bit SUB1H.
	RTC_CR_SUB1H = 0x20000
	// Position of ADD1H field.
	RTC_CR_ADD1H_Pos = 0x10
	// Bit mask of ADD1H field.
	RTC_CR_ADD1H_Msk = 0x10000
	// Bit ADD1H.
	RTC_CR_ADD1H = 0x10000
	// Position of TSIE field.
	RTC_CR_TSIE_Pos = 0xf
	// Bit mask of TSIE field.
	RTC_CR_TSIE_Msk = 0x8000
	// Bit TSIE.
	RTC_CR_TSIE = 0x8000
	// Position of WUTIE field.
	RTC_CR_WUTIE_Pos = 0xe
	// Bit mask of WUTIE field.
	RTC_CR_WUTIE_Msk = 0x4000
	// Bit WUTIE.
	RTC_CR_WUTIE = 0x4000
	// Position of ALRBIE field.
	RTC_CR_ALRBIE_Pos = 0xd
	// Bit mask of ALRBIE field.
	RTC_CR_ALRBIE_Msk = 0x2000
	// Bit ALRBIE.
	RTC_CR_ALRBIE = 0x2000
	// Position of ALRAIE field.
	RTC_CR_ALRAIE_Pos = 0xc
	// Bit mask of ALRAIE field.
	RTC_CR_ALRAIE_Msk = 0x1000
	// Bit ALRAIE.
	RTC_CR_ALRAIE = 0x1000
	// Position of TSE field.
	RTC_CR_TSE_Pos = 0xb
	// Bit mask of TSE field.
	RTC_CR_TSE_Msk = 0x800
	// Bit TSE.
	RTC_CR_TSE = 0x800
	// Position of WUTE field.
	RTC_CR_WUTE_Pos = 0xa
	// Bit mask of WUTE field.
	RTC_CR_WUTE_Msk = 0x400
	// Bit WUTE.
	RTC_CR_WUTE = 0x400
	// Position of ALRBE field.
	RTC_CR_ALRBE_Pos = 0x9
	// Bit mask of ALRBE field.
	RTC_CR_ALRBE_Msk = 0x200
	// Bit ALRBE.
	RTC_CR_ALRBE = 0x200
	// Position of ALRAE field.
	RTC_CR_ALRAE_Pos = 0x8
	// Bit mask of ALRAE field.
	RTC_CR_ALRAE_Msk = 0x100
	// Bit ALRAE.
	RTC_CR_ALRAE = 0x100
	// Position of DCE field.
	RTC_CR_DCE_Pos = 0x7
	// Bit mask of DCE field.
	RTC_CR_DCE_Msk = 0x80
	// Bit DCE.
	RTC_CR_DCE = 0x80
	// Position of FMT field.
	RTC_CR_FMT_Pos = 0x6
	// Bit mask of FMT field.
	RTC_CR_FMT_Msk = 0x40
	// Bit FMT.
	RTC_CR_FMT = 0x40
	// Position of BYPSHAD field.
	RTC_CR_BYPSHAD_Pos = 0x5
	// Bit mask of BYPSHAD field.
	RTC_CR_BYPSHAD_Msk = 0x20
	// Bit BYPSHAD.
	RTC_CR_BYPSHAD = 0x20
	// Position of REFCKON field.
	RTC_CR_REFCKON_Pos = 0x4
	// Bit mask of REFCKON field.
	RTC_CR_REFCKON_Msk = 0x10
	// Bit REFCKON.
	RTC_CR_REFCKON = 0x10
	// Position of TSEDGE field.
	RTC_CR_TSEDGE_Pos = 0x3
	// Bit mask of TSEDGE field.
	RTC_CR_TSEDGE_Msk = 0x8
	// Bit TSEDGE.
	RTC_CR_TSEDGE = 0x8
	// Position of WUCKSEL field.
	RTC_CR_WUCKSEL_Pos = 0x0
	// Bit mask of WUCKSEL field.
	RTC_CR_WUCKSEL_Msk = 0x7

	// ISR: initialization and status register
	// Position of RECALPF field.
	RTC_ISR_RECALPF_Pos = 0x10
	// Bit mask of RECALPF field.
	RTC_ISR_RECALPF_Msk = 0x10000
	// Bit RECALPF.
	RTC_ISR_RECALPF = 0x10000
	// Position of TAMP3F field.
	RTC_ISR_TAMP3F_Pos = 0xf
	// Bit mask of TAMP3F field.
	RTC_ISR_TAMP3F_Msk = 0x8000
	// Bit TAMP3F.
	RTC_ISR_TAMP3F = 0x8000
	// Position of TAMP2F field.
	RTC_ISR_TAMP2F_Pos = 0xe
	// Bit mask of TAMP2F field.
	RTC_ISR_TAMP2F_Msk = 0x4000
	// Bit TAMP2F.
	RTC_ISR_TAMP2F = 0x4000
	// Position of TAMP1F field.
	RTC_ISR_TAMP1F_Pos = 0xd
	// Bit mask of TAMP1F field.
	RTC_ISR_TAMP1F_Msk = 0x2000
	// Bit TAMP1F.
	RTC_ISR_TAMP1F = 0x2000
	// Position of TSOVF field.
	RTC_ISR_TSOVF_Pos = 0xc
	// Bit mask of TSOVF field.
	RTC_ISR_TSOVF_Msk = 0x1000
	// Bit TSOVF.
	RTC_ISR_TSOVF = 0x1000
	// Position of TSF field.
	RTC_ISR_TSF_Pos = 0xb
	// Bit mask of TSF field.
	RTC_ISR_TSF_Msk = 0x800
	// Bit TSF.
	RTC_ISR_TSF = 0x800
	// Position of WUTF field.
	RTC_ISR_WUTF_Pos = 0xa
	// Bit mask of WUTF field.
	RTC_ISR_WUTF_Msk = 0x400
	// Bit WUTF.
	RTC_ISR_WUTF = 0x400
	// Position of ALRBF field.
	RTC_ISR_ALRBF_Pos = 0x9
	// Bit mask of ALRBF field.
	RTC_ISR_ALRBF_Msk = 0x200
	// Bit ALRBF.
	RTC_ISR_ALRBF = 0x200
	// Position of ALRAF field.
	RTC_ISR_ALRAF_Pos = 0x8
	// Bit mask of ALRAF field.
	RTC_ISR_ALRAF_Msk = 0x100
	// Bit ALRAF.
	RTC_ISR_ALRAF = 0x100
	// Position of INIT field.
	RTC_ISR_INIT_Pos = 0x7
	// Bit mask of INIT field.
	RTC_ISR_INIT_Msk = 0x80
	// Bit INIT.
	RTC_ISR_INIT = 0x80
	// Position of INITF field.
	RTC_ISR_INITF_Pos = 0x6
	// Bit mask of INITF field.
	RTC_ISR_INITF_Msk = 0x40
	// Bit INITF.
	RTC_ISR_INITF = 0x40
	// Position of RSF field.
	RTC_ISR_RSF_Pos = 0x5
	// Bit mask of RSF field.
	RTC_ISR_RSF_Msk = 0x20
	// Bit RSF.
	RTC_ISR_RSF = 0x20
	// Position of INITS field.
	RTC_ISR_INITS_Pos = 0x4
	// Bit mask of INITS field.
	RTC_ISR_INITS_Msk = 0x10
	// Bit INITS.
	RTC_ISR_INITS = 0x10
	// Position of SHPF field.
	RTC_ISR_SHPF_Pos = 0x3
	// Bit mask of SHPF field.
	RTC_ISR_SHPF_Msk = 0x8
	// Bit SHPF.
	RTC_ISR_SHPF = 0x8
	// Position of WUTWF field.
	RTC_ISR_WUTWF_Pos = 0x2
	// Bit mask of WUTWF field.
	RTC_ISR_WUTWF_Msk = 0x4
	// Bit WUTWF.
	RTC_ISR_WUTWF = 0x4
	// Position of ALRBWF field.
	RTC_ISR_ALRBWF_Pos = 0x1
	// Bit mask of ALRBWF field.
	RTC_ISR_ALRBWF_Msk = 0x2
	// Bit ALRBWF.
	RTC_ISR_ALRBWF = 0x2
	// Position of ALRAWF field.
	RTC_ISR_ALRAWF_Pos = 0x0
	// Bit mask of ALRAWF field.
	RTC_ISR_ALRAWF_Msk = 0x1
	// Bit ALRAWF.
	RTC_ISR_ALRAWF = 0x1

	// PRER: prescaler register
	// Position of PREDIV_A field.
	RTC_PRER_PREDIV_A_Pos = 0x10
	// Bit mask of PREDIV_A field.
	RTC_PRER_PREDIV_A_Msk = 0x7f0000
	// Position of PREDIV_S field.
	RTC_PRER_PREDIV_S_Pos = 0x0
	// Bit mask of PREDIV_S field.
	RTC_PRER_PREDIV_S_Msk = 0x7fff

	// WUTR: wakeup timer register
	// Position of WUT field.
	RTC_WUTR_WUT_Pos = 0x0
	// Bit mask of WUT field.
	RTC_WUTR_WUT_Msk = 0xffff

	// CALIBR: calibration register
	// Position of DCS field.
	RTC_CALIBR_DCS_Pos = 0x7
	// Bit mask of DCS field.
	RTC_CALIBR_DCS_Msk = 0x80
	// Bit DCS.
	RTC_CALIBR_DCS = 0x80
	// Position of DC field.
	RTC_CALIBR_DC_Pos = 0x0
	// Bit mask of DC field.
	RTC_CALIBR_DC_Msk = 0x1f

	// ALRMAR: alarm A register
	// Position of MSK4 field.
	RTC_ALRMAR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMAR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMAR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMAR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMAR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMAR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMAR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMAR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMAR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMAR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMAR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMAR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMAR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMAR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMAR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMAR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMAR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMAR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMAR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMAR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMAR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMAR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMAR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMAR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMAR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMAR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMAR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMAR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMAR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMAR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMAR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMAR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMAR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMAR_SU_Msk = 0xf

	// ALRMBR: alarm B register
	// Position of MSK4 field.
	RTC_ALRMBR_MSK4_Pos = 0x1f
	// Bit mask of MSK4 field.
	RTC_ALRMBR_MSK4_Msk = 0x80000000
	// Bit MSK4.
	RTC_ALRMBR_MSK4 = 0x80000000
	// Position of WDSEL field.
	RTC_ALRMBR_WDSEL_Pos = 0x1e
	// Bit mask of WDSEL field.
	RTC_ALRMBR_WDSEL_Msk = 0x40000000
	// Bit WDSEL.
	RTC_ALRMBR_WDSEL = 0x40000000
	// Position of DT field.
	RTC_ALRMBR_DT_Pos = 0x1c
	// Bit mask of DT field.
	RTC_ALRMBR_DT_Msk = 0x30000000
	// Position of DU field.
	RTC_ALRMBR_DU_Pos = 0x18
	// Bit mask of DU field.
	RTC_ALRMBR_DU_Msk = 0xf000000
	// Position of MSK3 field.
	RTC_ALRMBR_MSK3_Pos = 0x17
	// Bit mask of MSK3 field.
	RTC_ALRMBR_MSK3_Msk = 0x800000
	// Bit MSK3.
	RTC_ALRMBR_MSK3 = 0x800000
	// Position of PM field.
	RTC_ALRMBR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_ALRMBR_PM_Msk = 0x400000
	// Bit PM.
	RTC_ALRMBR_PM = 0x400000
	// Position of HT field.
	RTC_ALRMBR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_ALRMBR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_ALRMBR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_ALRMBR_HU_Msk = 0xf0000
	// Position of MSK2 field.
	RTC_ALRMBR_MSK2_Pos = 0xf
	// Bit mask of MSK2 field.
	RTC_ALRMBR_MSK2_Msk = 0x8000
	// Bit MSK2.
	RTC_ALRMBR_MSK2 = 0x8000
	// Position of MNT field.
	RTC_ALRMBR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_ALRMBR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_ALRMBR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_ALRMBR_MNU_Msk = 0xf00
	// Position of MSK1 field.
	RTC_ALRMBR_MSK1_Pos = 0x7
	// Bit mask of MSK1 field.
	RTC_ALRMBR_MSK1_Msk = 0x80
	// Bit MSK1.
	RTC_ALRMBR_MSK1 = 0x80
	// Position of ST field.
	RTC_ALRMBR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_ALRMBR_ST_Msk = 0x70
	// Position of SU field.
	RTC_ALRMBR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_ALRMBR_SU_Msk = 0xf

	// WPR: write protection register
	// Position of KEY field.
	RTC_WPR_KEY_Pos = 0x0
	// Bit mask of KEY field.
	RTC_WPR_KEY_Msk = 0xff

	// SSR: sub second register
	// Position of SS field.
	RTC_SSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_SSR_SS_Msk = 0xffff

	// SHIFTR: shift control register
	// Position of ADD1S field.
	RTC_SHIFTR_ADD1S_Pos = 0x1f
	// Bit mask of ADD1S field.
	RTC_SHIFTR_ADD1S_Msk = 0x80000000
	// Bit ADD1S.
	RTC_SHIFTR_ADD1S = 0x80000000
	// Position of SUBFS field.
	RTC_SHIFTR_SUBFS_Pos = 0x0
	// Bit mask of SUBFS field.
	RTC_SHIFTR_SUBFS_Msk = 0x7fff

	// TSTR: TSTR
	// Position of PM field.
	RTC_TSTR_PM_Pos = 0x16
	// Bit mask of PM field.
	RTC_TSTR_PM_Msk = 0x400000
	// Bit PM.
	RTC_TSTR_PM = 0x400000
	// Position of HT field.
	RTC_TSTR_HT_Pos = 0x14
	// Bit mask of HT field.
	RTC_TSTR_HT_Msk = 0x300000
	// Position of HU field.
	RTC_TSTR_HU_Pos = 0x10
	// Bit mask of HU field.
	RTC_TSTR_HU_Msk = 0xf0000
	// Position of MNT field.
	RTC_TSTR_MNT_Pos = 0xc
	// Bit mask of MNT field.
	RTC_TSTR_MNT_Msk = 0x7000
	// Position of MNU field.
	RTC_TSTR_MNU_Pos = 0x8
	// Bit mask of MNU field.
	RTC_TSTR_MNU_Msk = 0xf00
	// Position of ST field.
	RTC_TSTR_ST_Pos = 0x4
	// Bit mask of ST field.
	RTC_TSTR_ST_Msk = 0x70
	// Position of SU field.
	RTC_TSTR_SU_Pos = 0x0
	// Bit mask of SU field.
	RTC_TSTR_SU_Msk = 0xf

	// TSDR: time stamp date register
	// Position of WDU field.
	RTC_TSDR_WDU_Pos = 0xd
	// Bit mask of WDU field.
	RTC_TSDR_WDU_Msk = 0xe000
	// Position of MT field.
	RTC_TSDR_MT_Pos = 0xc
	// Bit mask of MT field.
	RTC_TSDR_MT_Msk = 0x1000
	// Bit MT.
	RTC_TSDR_MT = 0x1000
	// Position of MU field.
	RTC_TSDR_MU_Pos = 0x8
	// Bit mask of MU field.
	RTC_TSDR_MU_Msk = 0xf00
	// Position of DT field.
	RTC_TSDR_DT_Pos = 0x4
	// Bit mask of DT field.
	RTC_TSDR_DT_Msk = 0x30
	// Position of DU field.
	RTC_TSDR_DU_Pos = 0x0
	// Bit mask of DU field.
	RTC_TSDR_DU_Msk = 0xf

	// TSSSR: timestamp sub second register
	// Position of SS field.
	RTC_TSSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_TSSSR_SS_Msk = 0xffff

	// CALR: calibration register
	// Position of CALP field.
	RTC_CALR_CALP_Pos = 0xf
	// Bit mask of CALP field.
	RTC_CALR_CALP_Msk = 0x8000
	// Bit CALP.
	RTC_CALR_CALP = 0x8000
	// Position of CALW8 field.
	RTC_CALR_CALW8_Pos = 0xe
	// Bit mask of CALW8 field.
	RTC_CALR_CALW8_Msk = 0x4000
	// Bit CALW8.
	RTC_CALR_CALW8 = 0x4000
	// Position of CALW16 field.
	RTC_CALR_CALW16_Pos = 0xd
	// Bit mask of CALW16 field.
	RTC_CALR_CALW16_Msk = 0x2000
	// Bit CALW16.
	RTC_CALR_CALW16 = 0x2000
	// Position of CALM field.
	RTC_CALR_CALM_Pos = 0x0
	// Bit mask of CALM field.
	RTC_CALR_CALM_Msk = 0x1ff

	// TAFCR: tamper and alternate function configuration register
	// Position of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Pos = 0x12
	// Bit mask of ALARMOUTTYPE field.
	RTC_TAFCR_ALARMOUTTYPE_Msk = 0x40000
	// Bit ALARMOUTTYPE.
	RTC_TAFCR_ALARMOUTTYPE = 0x40000
	// Position of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Pos = 0xf
	// Bit mask of TAMPPUDIS field.
	RTC_TAFCR_TAMPPUDIS_Msk = 0x8000
	// Bit TAMPPUDIS.
	RTC_TAFCR_TAMPPUDIS = 0x8000
	// Position of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Pos = 0xd
	// Bit mask of TAMPPRCH field.
	RTC_TAFCR_TAMPPRCH_Msk = 0x6000
	// Position of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Pos = 0xb
	// Bit mask of TAMPFLT field.
	RTC_TAFCR_TAMPFLT_Msk = 0x1800
	// Position of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Pos = 0x8
	// Bit mask of TAMPFREQ field.
	RTC_TAFCR_TAMPFREQ_Msk = 0x700
	// Position of TAMPTS field.
	RTC_TAFCR_TAMPTS_Pos = 0x7
	// Bit mask of TAMPTS field.
	RTC_TAFCR_TAMPTS_Msk = 0x80
	// Bit TAMPTS.
	RTC_TAFCR_TAMPTS = 0x80
	// Position of TAMP3TRG field.
	RTC_TAFCR_TAMP3TRG_Pos = 0x6
	// Bit mask of TAMP3TRG field.
	RTC_TAFCR_TAMP3TRG_Msk = 0x40
	// Bit TAMP3TRG.
	RTC_TAFCR_TAMP3TRG = 0x40
	// Position of TAMP3E field.
	RTC_TAFCR_TAMP3E_Pos = 0x5
	// Bit mask of TAMP3E field.
	RTC_TAFCR_TAMP3E_Msk = 0x20
	// Bit TAMP3E.
	RTC_TAFCR_TAMP3E = 0x20
	// Position of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Pos = 0x4
	// Bit mask of TAMP2TRG field.
	RTC_TAFCR_TAMP2TRG_Msk = 0x10
	// Bit TAMP2TRG.
	RTC_TAFCR_TAMP2TRG = 0x10
	// Position of TAMP2E field.
	RTC_TAFCR_TAMP2E_Pos = 0x3
	// Bit mask of TAMP2E field.
	RTC_TAFCR_TAMP2E_Msk = 0x8
	// Bit TAMP2E.
	RTC_TAFCR_TAMP2E = 0x8
	// Position of TAMPIE field.
	RTC_TAFCR_TAMPIE_Pos = 0x2
	// Bit mask of TAMPIE field.
	RTC_TAFCR_TAMPIE_Msk = 0x4
	// Bit TAMPIE.
	RTC_TAFCR_TAMPIE = 0x4
	// Position of TAMP1ETRG field.
	RTC_TAFCR_TAMP1ETRG_Pos = 0x1
	// Bit mask of TAMP1ETRG field.
	RTC_TAFCR_TAMP1ETRG_Msk = 0x2
	// Bit TAMP1ETRG.
	RTC_TAFCR_TAMP1ETRG = 0x2
	// Position of TAMP1E field.
	RTC_TAFCR_TAMP1E_Pos = 0x0
	// Bit mask of TAMP1E field.
	RTC_TAFCR_TAMP1E_Msk = 0x1
	// Bit TAMP1E.
	RTC_TAFCR_TAMP1E = 0x1

	// ALRMASSR: alarm A sub second register
	// Position of MASKSS field.
	RTC_ALRMASSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMASSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMASSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMASSR_SS_Msk = 0x7fff

	// ALRMBSSR: alarm B sub second register
	// Position of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Pos = 0x18
	// Bit mask of MASKSS field.
	RTC_ALRMBSSR_MASKSS_Msk = 0xf000000
	// Position of SS field.
	RTC_ALRMBSSR_SS_Pos = 0x0
	// Bit mask of SS field.
	RTC_ALRMBSSR_SS_Msk = 0x7fff

	// BKP0R: backup register
	// Position of BKP field.
	RTC_BKPR_BKP_Pos = 0x0
	// Bit mask of BKP field.
	RTC_BKPR_BKP_Msk = 0xffffffff
)

// Constants for SDIO: Secure digital input/output interface
const (
	// POWER: power control register
	// Position of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Pos = 0x0
	// Bit mask of PWRCTRL field.
	SDIO_POWER_PWRCTRL_Msk = 0x3

	// CLKCR: SDI clock control register
	// Position of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Pos = 0xe
	// Bit mask of HWFC_EN field.
	SDIO_CLKCR_HWFC_EN_Msk = 0x4000
	// Bit HWFC_EN.
	SDIO_CLKCR_HWFC_EN = 0x4000
	// Position of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Pos = 0xd
	// Bit mask of NEGEDGE field.
	SDIO_CLKCR_NEGEDGE_Msk = 0x2000
	// Bit NEGEDGE.
	SDIO_CLKCR_NEGEDGE = 0x2000
	// Position of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Pos = 0xb
	// Bit mask of WIDBUS field.
	SDIO_CLKCR_WIDBUS_Msk = 0x1800
	// Position of BYPASS field.
	SDIO_CLKCR_BYPASS_Pos = 0xa
	// Bit mask of BYPASS field.
	SDIO_CLKCR_BYPASS_Msk = 0x400
	// Bit BYPASS.
	SDIO_CLKCR_BYPASS = 0x400
	// Position of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Pos = 0x9
	// Bit mask of PWRSAV field.
	SDIO_CLKCR_PWRSAV_Msk = 0x200
	// Bit PWRSAV.
	SDIO_CLKCR_PWRSAV = 0x200
	// Position of CLKEN field.
	SDIO_CLKCR_CLKEN_Pos = 0x8
	// Bit mask of CLKEN field.
	SDIO_CLKCR_CLKEN_Msk = 0x100
	// Bit CLKEN.
	SDIO_CLKCR_CLKEN = 0x100
	// Position of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Pos = 0x0
	// Bit mask of CLKDIV field.
	SDIO_CLKCR_CLKDIV_Msk = 0xff

	// ARG: argument register
	// Position of CMDARG field.
	SDIO_ARG_CMDARG_Pos = 0x0
	// Bit mask of CMDARG field.
	SDIO_ARG_CMDARG_Msk = 0xffffffff

	// CMD: command register
	// Position of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD_Pos = 0xe
	// Bit mask of CE_ATACMD field.
	SDIO_CMD_CE_ATACMD_Msk = 0x4000
	// Bit CE_ATACMD.
	SDIO_CMD_CE_ATACMD = 0x4000
	// Position of NIEN field.
	SDIO_CMD_NIEN_Pos = 0xd
	// Bit mask of NIEN field.
	SDIO_CMD_NIEN_Msk = 0x2000
	// Bit NIEN.
	SDIO_CMD_NIEN = 0x2000
	// Position of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl_Pos = 0xc
	// Bit mask of ENCMDcompl field.
	SDIO_CMD_ENCMDcompl_Msk = 0x1000
	// Bit ENCMDcompl.
	SDIO_CMD_ENCMDcompl = 0x1000
	// Position of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Pos = 0xb
	// Bit mask of SDIOSuspend field.
	SDIO_CMD_SDIOSuspend_Msk = 0x800
	// Bit SDIOSuspend.
	SDIO_CMD_SDIOSuspend = 0x800
	// Position of CPSMEN field.
	SDIO_CMD_CPSMEN_Pos = 0xa
	// Bit mask of CPSMEN field.
	SDIO_CMD_CPSMEN_Msk = 0x400
	// Bit CPSMEN.
	SDIO_CMD_CPSMEN = 0x400
	// Position of WAITPEND field.
	SDIO_CMD_WAITPEND_Pos = 0x9
	// Bit mask of WAITPEND field.
	SDIO_CMD_WAITPEND_Msk = 0x200
	// Bit WAITPEND.
	SDIO_CMD_WAITPEND = 0x200
	// Position of WAITINT field.
	SDIO_CMD_WAITINT_Pos = 0x8
	// Bit mask of WAITINT field.
	SDIO_CMD_WAITINT_Msk = 0x100
	// Bit WAITINT.
	SDIO_CMD_WAITINT = 0x100
	// Position of WAITRESP field.
	SDIO_CMD_WAITRESP_Pos = 0x6
	// Bit mask of WAITRESP field.
	SDIO_CMD_WAITRESP_Msk = 0xc0
	// Position of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Pos = 0x0
	// Bit mask of CMDINDEX field.
	SDIO_CMD_CMDINDEX_Msk = 0x3f

	// RESPCMD: command response register
	// Position of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Pos = 0x0
	// Bit mask of RESPCMD field.
	SDIO_RESPCMD_RESPCMD_Msk = 0x3f

	// RESP1: response 1..4 register
	// Position of CARDSTATUS1 field.
	SDIO_RESP1_CARDSTATUS1_Pos = 0x0
	// Bit mask of CARDSTATUS1 field.
	SDIO_RESP1_CARDSTATUS1_Msk = 0xffffffff

	// RESP2: response 1..4 register
	// Position of CARDSTATUS2 field.
	SDIO_RESP2_CARDSTATUS2_Pos = 0x0
	// Bit mask of CARDSTATUS2 field.
	SDIO_RESP2_CARDSTATUS2_Msk = 0xffffffff

	// RESP3: response 1..4 register
	// Position of CARDSTATUS3 field.
	SDIO_RESP3_CARDSTATUS3_Pos = 0x0
	// Bit mask of CARDSTATUS3 field.
	SDIO_RESP3_CARDSTATUS3_Msk = 0xffffffff

	// RESP4: response 1..4 register
	// Position of CARDSTATUS4 field.
	SDIO_RESP4_CARDSTATUS4_Pos = 0x0
	// Bit mask of CARDSTATUS4 field.
	SDIO_RESP4_CARDSTATUS4_Msk = 0xffffffff

	// DTIMER: data timer register
	// Position of DATATIME field.
	SDIO_DTIMER_DATATIME_Pos = 0x0
	// Bit mask of DATATIME field.
	SDIO_DTIMER_DATATIME_Msk = 0xffffffff

	// DLEN: data length register
	// Position of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Pos = 0x0
	// Bit mask of DATALENGTH field.
	SDIO_DLEN_DATALENGTH_Msk = 0x1ffffff

	// DCTRL: data control register
	// Position of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Pos = 0xb
	// Bit mask of SDIOEN field.
	SDIO_DCTRL_SDIOEN_Msk = 0x800
	// Bit SDIOEN.
	SDIO_DCTRL_SDIOEN = 0x800
	// Position of RWMOD field.
	SDIO_DCTRL_RWMOD_Pos = 0xa
	// Bit mask of RWMOD field.
	SDIO_DCTRL_RWMOD_Msk = 0x400
	// Bit RWMOD.
	SDIO_DCTRL_RWMOD = 0x400
	// Position of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Pos = 0x9
	// Bit mask of RWSTOP field.
	SDIO_DCTRL_RWSTOP_Msk = 0x200
	// Bit RWSTOP.
	SDIO_DCTRL_RWSTOP = 0x200
	// Position of RWSTART field.
	SDIO_DCTRL_RWSTART_Pos = 0x8
	// Bit mask of RWSTART field.
	SDIO_DCTRL_RWSTART_Msk = 0x100
	// Bit RWSTART.
	SDIO_DCTRL_RWSTART = 0x100
	// Position of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Pos = 0x4
	// Bit mask of DBLOCKSIZE field.
	SDIO_DCTRL_DBLOCKSIZE_Msk = 0xf0
	// Position of DMAEN field.
	SDIO_DCTRL_DMAEN_Pos = 0x3
	// Bit mask of DMAEN field.
	SDIO_DCTRL_DMAEN_Msk = 0x8
	// Bit DMAEN.
	SDIO_DCTRL_DMAEN = 0x8
	// Position of DTMODE field.
	SDIO_DCTRL_DTMODE_Pos = 0x2
	// Bit mask of DTMODE field.
	SDIO_DCTRL_DTMODE_Msk = 0x4
	// Bit DTMODE.
	SDIO_DCTRL_DTMODE = 0x4
	// Position of DTDIR field.
	SDIO_DCTRL_DTDIR_Pos = 0x1
	// Bit mask of DTDIR field.
	SDIO_DCTRL_DTDIR_Msk = 0x2
	// Bit DTDIR.
	SDIO_DCTRL_DTDIR = 0x2
	// Position of DTEN field.
	SDIO_DCTRL_DTEN_Pos = 0x0
	// Bit mask of DTEN field.
	SDIO_DCTRL_DTEN_Msk = 0x1
	// Bit DTEN.
	SDIO_DCTRL_DTEN = 0x1

	// DCOUNT: data counter register
	// Position of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Pos = 0x0
	// Bit mask of DATACOUNT field.
	SDIO_DCOUNT_DATACOUNT_Msk = 0x1ffffff

	// STA: status register
	// Position of CEATAEND field.
	SDIO_STA_CEATAEND_Pos = 0x17
	// Bit mask of CEATAEND field.
	SDIO_STA_CEATAEND_Msk = 0x800000
	// Bit CEATAEND.
	SDIO_STA_CEATAEND = 0x800000
	// Position of SDIOIT field.
	SDIO_STA_SDIOIT_Pos = 0x16
	// Bit mask of SDIOIT field.
	SDIO_STA_SDIOIT_Msk = 0x400000
	// Bit SDIOIT.
	SDIO_STA_SDIOIT = 0x400000
	// Position of RXDAVL field.
	SDIO_STA_RXDAVL_Pos = 0x15
	// Bit mask of RXDAVL field.
	SDIO_STA_RXDAVL_Msk = 0x200000
	// Bit RXDAVL.
	SDIO_STA_RXDAVL = 0x200000
	// Position of TXDAVL field.
	SDIO_STA_TXDAVL_Pos = 0x14
	// Bit mask of TXDAVL field.
	SDIO_STA_TXDAVL_Msk = 0x100000
	// Bit TXDAVL.
	SDIO_STA_TXDAVL = 0x100000
	// Position of RXFIFOE field.
	SDIO_STA_RXFIFOE_Pos = 0x13
	// Bit mask of RXFIFOE field.
	SDIO_STA_RXFIFOE_Msk = 0x80000
	// Bit RXFIFOE.
	SDIO_STA_RXFIFOE = 0x80000
	// Position of TXFIFOE field.
	SDIO_STA_TXFIFOE_Pos = 0x12
	// Bit mask of TXFIFOE field.
	SDIO_STA_TXFIFOE_Msk = 0x40000
	// Bit TXFIFOE.
	SDIO_STA_TXFIFOE = 0x40000
	// Position of RXFIFOF field.
	SDIO_STA_RXFIFOF_Pos = 0x11
	// Bit mask of RXFIFOF field.
	SDIO_STA_RXFIFOF_Msk = 0x20000
	// Bit RXFIFOF.
	SDIO_STA_RXFIFOF = 0x20000
	// Position of TXFIFOF field.
	SDIO_STA_TXFIFOF_Pos = 0x10
	// Bit mask of TXFIFOF field.
	SDIO_STA_TXFIFOF_Msk = 0x10000
	// Bit TXFIFOF.
	SDIO_STA_TXFIFOF = 0x10000
	// Position of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Pos = 0xf
	// Bit mask of RXFIFOHF field.
	SDIO_STA_RXFIFOHF_Msk = 0x8000
	// Bit RXFIFOHF.
	SDIO_STA_RXFIFOHF = 0x8000
	// Position of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Pos = 0xe
	// Bit mask of TXFIFOHE field.
	SDIO_STA_TXFIFOHE_Msk = 0x4000
	// Bit TXFIFOHE.
	SDIO_STA_TXFIFOHE = 0x4000
	// Position of RXACT field.
	SDIO_STA_RXACT_Pos = 0xd
	// Bit mask of RXACT field.
	SDIO_STA_RXACT_Msk = 0x2000
	// Bit RXACT.
	SDIO_STA_RXACT = 0x2000
	// Position of TXACT field.
	SDIO_STA_TXACT_Pos = 0xc
	// Bit mask of TXACT field.
	SDIO_STA_TXACT_Msk = 0x1000
	// Bit TXACT.
	SDIO_STA_TXACT = 0x1000
	// Position of CMDACT field.
	SDIO_STA_CMDACT_Pos = 0xb
	// Bit mask of CMDACT field.
	SDIO_STA_CMDACT_Msk = 0x800
	// Bit CMDACT.
	SDIO_STA_CMDACT = 0x800
	// Position of DBCKEND field.
	SDIO_STA_DBCKEND_Pos = 0xa
	// Bit mask of DBCKEND field.
	SDIO_STA_DBCKEND_Msk = 0x400
	// Bit DBCKEND.
	SDIO_STA_DBCKEND = 0x400
	// Position of STBITERR field.
	SDIO_STA_STBITERR_Pos = 0x9
	// Bit mask of STBITERR field.
	SDIO_STA_STBITERR_Msk = 0x200
	// Bit STBITERR.
	SDIO_STA_STBITERR = 0x200
	// Position of DATAEND field.
	SDIO_STA_DATAEND_Pos = 0x8
	// Bit mask of DATAEND field.
	SDIO_STA_DATAEND_Msk = 0x100
	// Bit DATAEND.
	SDIO_STA_DATAEND = 0x100
	// Position of CMDSENT field.
	SDIO_STA_CMDSENT_Pos = 0x7
	// Bit mask of CMDSENT field.
	SDIO_STA_CMDSENT_Msk = 0x80
	// Bit CMDSENT.
	SDIO_STA_CMDSENT = 0x80
	// Position of CMDREND field.
	SDIO_STA_CMDREND_Pos = 0x6
	// Bit mask of CMDREND field.
	SDIO_STA_CMDREND_Msk = 0x40
	// Bit CMDREND.
	SDIO_STA_CMDREND = 0x40
	// Position of RXOVERR field.
	SDIO_STA_RXOVERR_Pos = 0x5
	// Bit mask of RXOVERR field.
	SDIO_STA_RXOVERR_Msk = 0x20
	// Bit RXOVERR.
	SDIO_STA_RXOVERR = 0x20
	// Position of TXUNDERR field.
	SDIO_STA_TXUNDERR_Pos = 0x4
	// Bit mask of TXUNDERR field.
	SDIO_STA_TXUNDERR_Msk = 0x10
	// Bit TXUNDERR.
	SDIO_STA_TXUNDERR = 0x10
	// Position of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Pos = 0x3
	// Bit mask of DTIMEOUT field.
	SDIO_STA_DTIMEOUT_Msk = 0x8
	// Bit DTIMEOUT.
	SDIO_STA_DTIMEOUT = 0x8
	// Position of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Pos = 0x2
	// Bit mask of CTIMEOUT field.
	SDIO_STA_CTIMEOUT_Msk = 0x4
	// Bit CTIMEOUT.
	SDIO_STA_CTIMEOUT = 0x4
	// Position of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Pos = 0x1
	// Bit mask of DCRCFAIL field.
	SDIO_STA_DCRCFAIL_Msk = 0x2
	// Bit DCRCFAIL.
	SDIO_STA_DCRCFAIL = 0x2
	// Position of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Pos = 0x0
	// Bit mask of CCRCFAIL field.
	SDIO_STA_CCRCFAIL_Msk = 0x1
	// Bit CCRCFAIL.
	SDIO_STA_CCRCFAIL = 0x1

	// ICR: interrupt clear register
	// Position of CEATAENDC field.
	SDIO_ICR_CEATAENDC_Pos = 0x17
	// Bit mask of CEATAENDC field.
	SDIO_ICR_CEATAENDC_Msk = 0x800000
	// Bit CEATAENDC.
	SDIO_ICR_CEATAENDC = 0x800000
	// Position of SDIOITC field.
	SDIO_ICR_SDIOITC_Pos = 0x16
	// Bit mask of SDIOITC field.
	SDIO_ICR_SDIOITC_Msk = 0x400000
	// Bit SDIOITC.
	SDIO_ICR_SDIOITC = 0x400000
	// Position of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Pos = 0xa
	// Bit mask of DBCKENDC field.
	SDIO_ICR_DBCKENDC_Msk = 0x400
	// Bit DBCKENDC.
	SDIO_ICR_DBCKENDC = 0x400
	// Position of STBITERRC field.
	SDIO_ICR_STBITERRC_Pos = 0x9
	// Bit mask of STBITERRC field.
	SDIO_ICR_STBITERRC_Msk = 0x200
	// Bit STBITERRC.
	SDIO_ICR_STBITERRC = 0x200
	// Position of DATAENDC field.
	SDIO_ICR_DATAENDC_Pos = 0x8
	// Bit mask of DATAENDC field.
	SDIO_ICR_DATAENDC_Msk = 0x100
	// Bit DATAENDC.
	SDIO_ICR_DATAENDC = 0x100
	// Position of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Pos = 0x7
	// Bit mask of CMDSENTC field.
	SDIO_ICR_CMDSENTC_Msk = 0x80
	// Bit CMDSENTC.
	SDIO_ICR_CMDSENTC = 0x80
	// Position of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Pos = 0x6
	// Bit mask of CMDRENDC field.
	SDIO_ICR_CMDRENDC_Msk = 0x40
	// Bit CMDRENDC.
	SDIO_ICR_CMDRENDC = 0x40
	// Position of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Pos = 0x5
	// Bit mask of RXOVERRC field.
	SDIO_ICR_RXOVERRC_Msk = 0x20
	// Bit RXOVERRC.
	SDIO_ICR_RXOVERRC = 0x20
	// Position of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Pos = 0x4
	// Bit mask of TXUNDERRC field.
	SDIO_ICR_TXUNDERRC_Msk = 0x10
	// Bit TXUNDERRC.
	SDIO_ICR_TXUNDERRC = 0x10
	// Position of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Pos = 0x3
	// Bit mask of DTIMEOUTC field.
	SDIO_ICR_DTIMEOUTC_Msk = 0x8
	// Bit DTIMEOUTC.
	SDIO_ICR_DTIMEOUTC = 0x8
	// Position of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Pos = 0x2
	// Bit mask of CTIMEOUTC field.
	SDIO_ICR_CTIMEOUTC_Msk = 0x4
	// Bit CTIMEOUTC.
	SDIO_ICR_CTIMEOUTC = 0x4
	// Position of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Pos = 0x1
	// Bit mask of DCRCFAILC field.
	SDIO_ICR_DCRCFAILC_Msk = 0x2
	// Bit DCRCFAILC.
	SDIO_ICR_DCRCFAILC = 0x2
	// Position of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Pos = 0x0
	// Bit mask of CCRCFAILC field.
	SDIO_ICR_CCRCFAILC_Msk = 0x1
	// Bit CCRCFAILC.
	SDIO_ICR_CCRCFAILC = 0x1

	// MASK: mask register
	// Position of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE_Pos = 0x17
	// Bit mask of CEATAENDIE field.
	SDIO_MASK_CEATAENDIE_Msk = 0x800000
	// Bit CEATAENDIE.
	SDIO_MASK_CEATAENDIE = 0x800000
	// Position of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Pos = 0x16
	// Bit mask of SDIOITIE field.
	SDIO_MASK_SDIOITIE_Msk = 0x400000
	// Bit SDIOITIE.
	SDIO_MASK_SDIOITIE = 0x400000
	// Position of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Pos = 0x15
	// Bit mask of RXDAVLIE field.
	SDIO_MASK_RXDAVLIE_Msk = 0x200000
	// Bit RXDAVLIE.
	SDIO_MASK_RXDAVLIE = 0x200000
	// Position of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Pos = 0x14
	// Bit mask of TXDAVLIE field.
	SDIO_MASK_TXDAVLIE_Msk = 0x100000
	// Bit TXDAVLIE.
	SDIO_MASK_TXDAVLIE = 0x100000
	// Position of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Pos = 0x13
	// Bit mask of RXFIFOEIE field.
	SDIO_MASK_RXFIFOEIE_Msk = 0x80000
	// Bit RXFIFOEIE.
	SDIO_MASK_RXFIFOEIE = 0x80000
	// Position of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Pos = 0x12
	// Bit mask of TXFIFOEIE field.
	SDIO_MASK_TXFIFOEIE_Msk = 0x40000
	// Bit TXFIFOEIE.
	SDIO_MASK_TXFIFOEIE = 0x40000
	// Position of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Pos = 0x11
	// Bit mask of RXFIFOFIE field.
	SDIO_MASK_RXFIFOFIE_Msk = 0x20000
	// Bit RXFIFOFIE.
	SDIO_MASK_RXFIFOFIE = 0x20000
	// Position of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Pos = 0x10
	// Bit mask of TXFIFOFIE field.
	SDIO_MASK_TXFIFOFIE_Msk = 0x10000
	// Bit TXFIFOFIE.
	SDIO_MASK_TXFIFOFIE = 0x10000
	// Position of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Pos = 0xf
	// Bit mask of RXFIFOHFIE field.
	SDIO_MASK_RXFIFOHFIE_Msk = 0x8000
	// Bit RXFIFOHFIE.
	SDIO_MASK_RXFIFOHFIE = 0x8000
	// Position of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Pos = 0xe
	// Bit mask of TXFIFOHEIE field.
	SDIO_MASK_TXFIFOHEIE_Msk = 0x4000
	// Bit TXFIFOHEIE.
	SDIO_MASK_TXFIFOHEIE = 0x4000
	// Position of RXACTIE field.
	SDIO_MASK_RXACTIE_Pos = 0xd
	// Bit mask of RXACTIE field.
	SDIO_MASK_RXACTIE_Msk = 0x2000
	// Bit RXACTIE.
	SDIO_MASK_RXACTIE = 0x2000
	// Position of TXACTIE field.
	SDIO_MASK_TXACTIE_Pos = 0xc
	// Bit mask of TXACTIE field.
	SDIO_MASK_TXACTIE_Msk = 0x1000
	// Bit TXACTIE.
	SDIO_MASK_TXACTIE = 0x1000
	// Position of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Pos = 0xb
	// Bit mask of CMDACTIE field.
	SDIO_MASK_CMDACTIE_Msk = 0x800
	// Bit CMDACTIE.
	SDIO_MASK_CMDACTIE = 0x800
	// Position of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Pos = 0xa
	// Bit mask of DBCKENDIE field.
	SDIO_MASK_DBCKENDIE_Msk = 0x400
	// Bit DBCKENDIE.
	SDIO_MASK_DBCKENDIE = 0x400
	// Position of STBITERRIE field.
	SDIO_MASK_STBITERRIE_Pos = 0x9
	// Bit mask of STBITERRIE field.
	SDIO_MASK_STBITERRIE_Msk = 0x200
	// Bit STBITERRIE.
	SDIO_MASK_STBITERRIE = 0x200
	// Position of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Pos = 0x8
	// Bit mask of DATAENDIE field.
	SDIO_MASK_DATAENDIE_Msk = 0x100
	// Bit DATAENDIE.
	SDIO_MASK_DATAENDIE = 0x100
	// Position of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Pos = 0x7
	// Bit mask of CMDSENTIE field.
	SDIO_MASK_CMDSENTIE_Msk = 0x80
	// Bit CMDSENTIE.
	SDIO_MASK_CMDSENTIE = 0x80
	// Position of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Pos = 0x6
	// Bit mask of CMDRENDIE field.
	SDIO_MASK_CMDRENDIE_Msk = 0x40
	// Bit CMDRENDIE.
	SDIO_MASK_CMDRENDIE = 0x40
	// Position of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Pos = 0x5
	// Bit mask of RXOVERRIE field.
	SDIO_MASK_RXOVERRIE_Msk = 0x20
	// Bit RXOVERRIE.
	SDIO_MASK_RXOVERRIE = 0x20
	// Position of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Pos = 0x4
	// Bit mask of TXUNDERRIE field.
	SDIO_MASK_TXUNDERRIE_Msk = 0x10
	// Bit TXUNDERRIE.
	SDIO_MASK_TXUNDERRIE = 0x10
	// Position of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Pos = 0x3
	// Bit mask of DTIMEOUTIE field.
	SDIO_MASK_DTIMEOUTIE_Msk = 0x8
	// Bit DTIMEOUTIE.
	SDIO_MASK_DTIMEOUTIE = 0x8
	// Position of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Pos = 0x2
	// Bit mask of CTIMEOUTIE field.
	SDIO_MASK_CTIMEOUTIE_Msk = 0x4
	// Bit CTIMEOUTIE.
	SDIO_MASK_CTIMEOUTIE = 0x4
	// Position of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Pos = 0x1
	// Bit mask of DCRCFAILIE field.
	SDIO_MASK_DCRCFAILIE_Msk = 0x2
	// Bit DCRCFAILIE.
	SDIO_MASK_DCRCFAILIE = 0x2
	// Position of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Pos = 0x0
	// Bit mask of CCRCFAILIE field.
	SDIO_MASK_CCRCFAILIE_Msk = 0x1
	// Bit CCRCFAILIE.
	SDIO_MASK_CCRCFAILIE = 0x1

	// FIFOCNT: FIFO counter register
	// Position of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Pos = 0x0
	// Bit mask of FIFOCOUNT field.
	SDIO_FIFOCNT_FIFOCOUNT_Msk = 0xffffff

	// FIFO: data FIFO register
	// Position of FIF0Data field.
	SDIO_FIFO_FIF0Data_Pos = 0x0
	// Bit mask of FIF0Data field.
	SDIO_FIFO_FIF0Data_Msk = 0xffffffff
)

// Constants for SPI1: Serial peripheral interface
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Position of DFF field.
	SPI_CR1_DFF_Pos = 0xb
	// Bit mask of DFF field.
	SPI_CR1_DFF_Msk = 0x800
	// Bit DFF.
	SPI_CR1_DFF = 0x800
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1

	// CR2: control register 2
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1

	// SR: status register
	// Position of TIFRFE field.
	SPI_SR_TIFRFE_Pos = 0x8
	// Bit mask of TIFRFE field.
	SPI_SR_TIFRFE_Msk = 0x100
	// Bit TIFRFE.
	SPI_SR_TIFRFE = 0x100
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// Position of UDR field.
	SPI_SR_UDR_Pos = 0x3
	// Bit mask of UDR field.
	SPI_SR_UDR_Msk = 0x8
	// Bit UDR.
	SPI_SR_UDR = 0x8
	// Position of CHSIDE field.
	SPI_SR_CHSIDE_Pos = 0x2
	// Bit mask of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4
	// Bit CHSIDE.
	SPI_SR_CHSIDE = 0x4
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff

	// I2SCFGR: I2S configuration register
	// Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Pos = 0xb
	// Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk = 0x800
	// Bit I2SMOD.
	SPI_I2SCFGR_I2SMOD = 0x800
	// Position of I2SE field.
	SPI_I2SCFGR_I2SE_Pos = 0xa
	// Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE_Msk = 0x400
	// Bit I2SE.
	SPI_I2SCFGR_I2SE = 0x400
	// Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Pos = 0x8
	// Bit mask of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk = 0x300
	// Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7
	// Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80
	// Bit PCMSYNC.
	SPI_I2SCFGR_PCMSYNC = 0x80
	// Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Pos = 0x4
	// Bit mask of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk = 0x30
	// Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Pos = 0x3
	// Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk = 0x8
	// Bit CKPOL.
	SPI_I2SCFGR_CKPOL = 0x8
	// Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Pos = 0x1
	// Bit mask of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk = 0x6
	// Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Pos = 0x0
	// Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk = 0x1
	// Bit CHLEN.
	SPI_I2SCFGR_CHLEN = 0x1

	// I2SPR: I2S prescaler register
	// Position of MCKOE field.
	SPI_I2SPR_MCKOE_Pos = 0x9
	// Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE_Msk = 0x200
	// Bit MCKOE.
	SPI_I2SPR_MCKOE = 0x200
	// Position of ODD field.
	SPI_I2SPR_ODD_Pos = 0x8
	// Bit mask of ODD field.
	SPI_I2SPR_ODD_Msk = 0x100
	// Bit ODD.
	SPI_I2SPR_ODD = 0x100
	// Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Pos = 0x0
	// Bit mask of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff
)

// Constants for SYSCFG: System configuration controller
const (
	// MEMRMP: memory remap register
	// Position of MEM_MODE field.
	SYSCFG_MEMRMP_MEM_MODE_Pos = 0x0
	// Bit mask of MEM_MODE field.
	SYSCFG_MEMRMP_MEM_MODE_Msk = 0x3
	// Position of BOOT_MODE field.
	SYSCFG_MEMRMP_BOOT_MODE_Pos = 0x8
	// Bit mask of BOOT_MODE field.
	SYSCFG_MEMRMP_BOOT_MODE_Msk = 0x300

	// PMC: peripheral mode configuration register
	// Position of USB_PU field.
	SYSCFG_PMC_USB_PU_Pos = 0x0
	// Bit mask of USB_PU field.
	SYSCFG_PMC_USB_PU_Msk = 0x1
	// Bit USB_PU.
	SYSCFG_PMC_USB_PU = 0x1
	// Position of LCD_CAPA field.
	SYSCFG_PMC_LCD_CAPA_Pos = 0x1
	// Bit mask of LCD_CAPA field.
	SYSCFG_PMC_LCD_CAPA_Msk = 0x3e

	// EXTICR1: external interrupt configuration register 1
	// Position of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Pos = 0xc
	// Bit mask of EXTI3 field.
	SYSCFG_EXTICR1_EXTI3_Msk = 0xf000
	// Position of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Pos = 0x8
	// Bit mask of EXTI2 field.
	SYSCFG_EXTICR1_EXTI2_Msk = 0xf00
	// Position of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Pos = 0x4
	// Bit mask of EXTI1 field.
	SYSCFG_EXTICR1_EXTI1_Msk = 0xf0
	// Position of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Pos = 0x0
	// Bit mask of EXTI0 field.
	SYSCFG_EXTICR1_EXTI0_Msk = 0xf

	// EXTICR2: external interrupt configuration register 2
	// Position of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Pos = 0xc
	// Bit mask of EXTI7 field.
	SYSCFG_EXTICR2_EXTI7_Msk = 0xf000
	// Position of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Pos = 0x8
	// Bit mask of EXTI6 field.
	SYSCFG_EXTICR2_EXTI6_Msk = 0xf00
	// Position of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Pos = 0x4
	// Bit mask of EXTI5 field.
	SYSCFG_EXTICR2_EXTI5_Msk = 0xf0
	// Position of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Pos = 0x0
	// Bit mask of EXTI4 field.
	SYSCFG_EXTICR2_EXTI4_Msk = 0xf

	// EXTICR3: external interrupt configuration register 3
	// Position of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Pos = 0xc
	// Bit mask of EXTI11 field.
	SYSCFG_EXTICR3_EXTI11_Msk = 0xf000
	// Position of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Pos = 0x8
	// Bit mask of EXTI10 field.
	SYSCFG_EXTICR3_EXTI10_Msk = 0xf00
	// Position of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Pos = 0x4
	// Bit mask of EXTI9 field.
	SYSCFG_EXTICR3_EXTI9_Msk = 0xf0
	// Position of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Pos = 0x0
	// Bit mask of EXTI8 field.
	SYSCFG_EXTICR3_EXTI8_Msk = 0xf

	// EXTICR4: external interrupt configuration register 4
	// Position of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Pos = 0xc
	// Bit mask of EXTI15 field.
	SYSCFG_EXTICR4_EXTI15_Msk = 0xf000
	// Position of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Pos = 0x8
	// Bit mask of EXTI14 field.
	SYSCFG_EXTICR4_EXTI14_Msk = 0xf00
	// Position of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Pos = 0x4
	// Bit mask of EXTI13 field.
	SYSCFG_EXTICR4_EXTI13_Msk = 0xf0
	// Position of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Pos = 0x0
	// Bit mask of EXTI12 field.
	SYSCFG_EXTICR4_EXTI12_Msk = 0xf
)

// Constants for TIM10: General-purpose timers
const (
	// CR1: control register 1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2

	// CR2: TIM10 control register 2
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70

	// SMCR: TIM10 slave mode control register
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000

	// DIER: Interrupt enable register
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2

	// SR: status register
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200

	// EGR: event generation register
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIM_EGR_UG_Update = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2

	// CCMR1_Output: capture/compare mode register
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs
	TIM_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register
	TIM_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy
	TIM_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low
	TIM_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high
	TIM_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active
	TIM_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1
	TIM_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0

	// CCER: capture/compare enable register
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffff

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffff

	// CCR1: capture/compare register
	// Position of CCR field.
	TIM_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR_CCR_Msk = 0xffff

	// OR: option register
	// Position of TI1_RMP field.
	TIM_OR_TI1_RMP_Pos = 0x0
	// Bit mask of TI1_RMP field.
	TIM_OR_TI1_RMP_Msk = 0x3
	// Position of ETR_RMP field.
	TIM_OR_ETR_RMP_Pos = 0x2
	// Bit mask of ETR_RMP field.
	TIM_OR_ETR_RMP_Msk = 0x4
	// Bit ETR_RMP.
	TIM_OR_ETR_RMP = 0x4
	// Position of TI1_RMP_RI field.
	TIM_OR_TI1_RMP_RI_Pos = 0x3
	// Bit mask of TI1_RMP_RI field.
	TIM_OR_TI1_RMP_RI_Msk = 0x8
	// Bit TI1_RMP_RI.
	TIM_OR_TI1_RMP_RI = 0x8
)

// Constants for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// SR: Status register
	// Position of CTS field.
	USART_SR_CTS_Pos = 0x9
	// Bit mask of CTS field.
	USART_SR_CTS_Msk = 0x200
	// Bit CTS.
	USART_SR_CTS = 0x200
	// Position of LBD field.
	USART_SR_LBD_Pos = 0x8
	// Bit mask of LBD field.
	USART_SR_LBD_Msk = 0x100
	// Bit LBD.
	USART_SR_LBD = 0x100
	// Position of TXE field.
	USART_SR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_SR_TXE_Msk = 0x80
	// Bit TXE.
	USART_SR_TXE = 0x80
	// Position of TC field.
	USART_SR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_SR_TC_Msk = 0x40
	// Bit TC.
	USART_SR_TC = 0x40
	// Position of RXNE field.
	USART_SR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_SR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_SR_RXNE = 0x20
	// Position of IDLE field.
	USART_SR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_SR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_SR_IDLE = 0x10
	// Position of ORE field.
	USART_SR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_SR_ORE_Msk = 0x8
	// Bit ORE.
	USART_SR_ORE = 0x8
	// Position of NF field.
	USART_SR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_SR_NF_Msk = 0x4
	// Bit NF.
	USART_SR_NF = 0x4
	// Position of FE field.
	USART_SR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_SR_FE_Msk = 0x2
	// Bit FE.
	USART_SR_FE = 0x2
	// Position of PE field.
	USART_SR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_SR_PE_Msk = 0x1
	// Bit PE.
	USART_SR_PE = 0x1

	// DR: Data register
	// Position of DR field.
	USART_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	USART_DR_DR_Msk = 0x1ff

	// BRR: Baud rate register
	// Position of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Pos = 0x4
	// Bit mask of DIV_Mantissa field.
	USART_BRR_DIV_Mantissa_Msk = 0xfff0
	// Position of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Pos = 0x0
	// Bit mask of DIV_Fraction field.
	USART_BRR_DIV_Fraction_Msk = 0xf

	// CR1: Control register 1
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Position of UE field.
	USART_CR1_UE_Pos = 0xd
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x2000
	// Bit UE.
	USART_CR1_UE = 0x2000
	// Position of M field.
	USART_CR1_M_Pos = 0xc
	// Bit mask of M field.
	USART_CR1_M_Msk = 0x1000
	// Bit M.
	USART_CR1_M = 0x1000
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Position of RWU field.
	USART_CR1_RWU_Pos = 0x1
	// Bit mask of RWU field.
	USART_CR1_RWU_Msk = 0x2
	// Bit RWU.
	USART_CR1_RWU = 0x2
	// Position of SBK field.
	USART_CR1_SBK_Pos = 0x0
	// Bit mask of SBK field.
	USART_CR1_SBK_Msk = 0x1
	// Bit SBK.
	USART_CR1_SBK = 0x1

	// CR2: Control register 2
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x0
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xf

	// CR3: Control register 3
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff
)

// Constants for USB: Universal serial bus full-speed device interface
const (
	// EP0R: endpoint 0 register
	// Position of EA field.
	USB_EP0R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP0R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP0R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP0R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP0R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP0R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP0R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP0R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP0R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP0R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP0R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP0R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP0R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP0R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP0R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP0R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP0R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP0R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP0R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP0R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP0R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP0R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP0R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP0R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP0R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP0R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP0R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP0R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP0R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP0R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP0R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP0R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP0R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP0R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP0R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP0R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP0R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP0R_CTR_RX = 0x8000

	// EP1R: endpoint 1 register
	// Position of EA field.
	USB_EP1R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP1R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP1R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP1R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP1R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP1R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP1R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP1R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP1R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP1R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP1R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP1R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP1R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP1R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP1R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP1R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP1R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP1R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP1R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP1R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP1R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP1R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP1R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP1R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP1R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP1R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP1R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP1R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP1R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP1R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP1R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP1R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP1R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP1R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP1R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP1R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP1R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP1R_CTR_RX = 0x8000

	// EP2R: endpoint 2 register
	// Position of EA field.
	USB_EP2R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP2R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP2R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP2R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP2R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP2R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP2R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP2R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP2R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP2R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP2R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP2R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP2R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP2R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP2R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP2R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP2R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP2R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP2R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP2R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP2R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP2R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP2R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP2R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP2R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP2R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP2R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP2R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP2R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP2R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP2R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP2R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP2R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP2R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP2R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP2R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP2R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP2R_CTR_RX = 0x8000

	// EP3R: endpoint 3 register
	// Position of EA field.
	USB_EP3R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP3R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP3R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP3R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP3R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP3R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP3R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP3R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP3R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP3R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP3R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP3R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP3R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP3R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP3R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP3R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP3R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP3R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP3R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP3R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP3R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP3R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP3R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP3R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP3R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP3R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP3R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP3R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP3R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP3R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP3R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP3R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP3R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP3R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP3R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP3R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP3R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP3R_CTR_RX = 0x8000

	// EP4R: endpoint 4 register
	// Position of EA field.
	USB_EP4R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP4R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP4R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP4R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP4R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP4R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP4R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP4R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP4R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP4R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP4R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP4R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP4R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP4R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP4R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP4R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP4R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP4R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP4R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP4R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP4R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP4R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP4R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP4R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP4R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP4R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP4R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP4R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP4R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP4R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP4R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP4R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP4R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP4R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP4R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP4R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP4R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP4R_CTR_RX = 0x8000

	// EP5R: endpoint 5 register
	// Position of EA field.
	USB_EP5R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP5R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP5R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP5R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP5R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP5R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP5R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP5R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP5R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP5R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP5R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP5R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP5R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP5R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP5R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP5R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP5R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP5R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP5R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP5R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP5R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP5R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP5R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP5R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP5R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP5R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP5R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP5R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP5R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP5R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP5R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP5R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP5R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP5R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP5R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP5R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP5R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP5R_CTR_RX = 0x8000

	// EP6R: endpoint 6 register
	// Position of EA field.
	USB_EP6R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP6R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP6R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP6R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP6R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP6R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP6R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP6R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP6R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP6R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP6R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP6R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP6R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP6R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP6R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP6R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP6R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP6R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP6R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP6R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP6R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP6R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP6R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP6R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP6R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP6R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP6R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP6R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP6R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP6R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP6R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP6R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP6R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP6R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP6R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP6R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP6R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP6R_CTR_RX = 0x8000

	// EP7R: endpoint 7 register
	// Position of EA field.
	USB_EP7R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP7R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP7R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP7R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP7R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP7R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP7R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP7R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP7R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP7R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP7R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP7R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP7R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP7R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP7R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP7R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP7R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP7R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP7R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP7R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP7R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP7R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP7R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP7R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP7R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP7R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP7R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP7R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP7R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP7R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP7R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP7R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP7R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP7R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP7R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP7R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP7R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP7R_CTR_RX = 0x8000

	// CNTR: control register
	// Position of FRES field.
	USB_CNTR_FRES_Pos = 0x0
	// Bit mask of FRES field.
	USB_CNTR_FRES_Msk = 0x1
	// Bit FRES.
	USB_CNTR_FRES = 0x1
	// Clear USB reset
	USB_CNTR_FRES_NoReset = 0x0
	// Force a reset of the USB peripheral, exactly like a RESET signaling on the USB
	USB_CNTR_FRES_Reset = 0x1
	// Position of PDWN field.
	USB_CNTR_PDWN_Pos = 0x1
	// Bit mask of PDWN field.
	USB_CNTR_PDWN_Msk = 0x2
	// Bit PDWN.
	USB_CNTR_PDWN = 0x2
	// No power down
	USB_CNTR_PDWN_Disabled = 0x0
	// Enter power down mode
	USB_CNTR_PDWN_Enabled = 0x1
	// Position of LPMODE field.
	USB_CNTR_LPMODE_Pos = 0x2
	// Bit mask of LPMODE field.
	USB_CNTR_LPMODE_Msk = 0x4
	// Bit LPMODE.
	USB_CNTR_LPMODE = 0x4
	// No low-power mode
	USB_CNTR_LPMODE_Disabled = 0x0
	// Enter low-power mode
	USB_CNTR_LPMODE_Enabled = 0x1
	// Position of FSUSP field.
	USB_CNTR_FSUSP_Pos = 0x3
	// Bit mask of FSUSP field.
	USB_CNTR_FSUSP_Msk = 0x8
	// Bit FSUSP.
	USB_CNTR_FSUSP = 0x8
	// No effect
	USB_CNTR_FSUSP_NoEffect = 0x0
	// Enter suspend mode. Clocks and static power dissipation in the analog transceiver are left unaffected
	USB_CNTR_FSUSP_Suspend = 0x1
	// Position of RESUME field.
	USB_CNTR_RESUME_Pos = 0x4
	// Bit mask of RESUME field.
	USB_CNTR_RESUME_Msk = 0x10
	// Bit RESUME.
	USB_CNTR_RESUME = 0x10
	// Resume requested
	USB_CNTR_RESUME_Requested = 0x1
	// Position of ESOFM field.
	USB_CNTR_ESOFM_Pos = 0x8
	// Bit mask of ESOFM field.
	USB_CNTR_ESOFM_Msk = 0x100
	// Bit ESOFM.
	USB_CNTR_ESOFM = 0x100
	// ESOF Interrupt disabled
	USB_CNTR_ESOFM_Disabled = 0x0
	// ESOF Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_ESOFM_Enabled = 0x1
	// Position of SOFM field.
	USB_CNTR_SOFM_Pos = 0x9
	// Bit mask of SOFM field.
	USB_CNTR_SOFM_Msk = 0x200
	// Bit SOFM.
	USB_CNTR_SOFM = 0x200
	// SOF Interrupt disabled
	USB_CNTR_SOFM_Disabled = 0x0
	// SOF Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_SOFM_Enabled = 0x1
	// Position of RESETM field.
	USB_CNTR_RESETM_Pos = 0xa
	// Bit mask of RESETM field.
	USB_CNTR_RESETM_Msk = 0x400
	// Bit RESETM.
	USB_CNTR_RESETM = 0x400
	// RESET Interrupt disabled
	USB_CNTR_RESETM_Disabled = 0x0
	// RESET Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_RESETM_Enabled = 0x1
	// Position of SUSPM field.
	USB_CNTR_SUSPM_Pos = 0xb
	// Bit mask of SUSPM field.
	USB_CNTR_SUSPM_Msk = 0x800
	// Bit SUSPM.
	USB_CNTR_SUSPM = 0x800
	// Suspend Mode Request SUSP Interrupt disabled
	USB_CNTR_SUSPM_Disabled = 0x0
	// SUSP Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_SUSPM_Enabled = 0x1
	// Position of WKUPM field.
	USB_CNTR_WKUPM_Pos = 0xc
	// Bit mask of WKUPM field.
	USB_CNTR_WKUPM_Msk = 0x1000
	// Bit WKUPM.
	USB_CNTR_WKUPM = 0x1000
	// WKUP Interrupt disabled
	USB_CNTR_WKUPM_Disabled = 0x0
	// WKUP Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_WKUPM_Enabled = 0x1
	// Position of ERRM field.
	USB_CNTR_ERRM_Pos = 0xd
	// Bit mask of ERRM field.
	USB_CNTR_ERRM_Msk = 0x2000
	// Bit ERRM.
	USB_CNTR_ERRM = 0x2000
	// ERR Interrupt disabled
	USB_CNTR_ERRM_Disabled = 0x0
	// ERR Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_ERRM_Enabled = 0x1
	// Position of PMAOVRM field.
	USB_CNTR_PMAOVRM_Pos = 0xe
	// Bit mask of PMAOVRM field.
	USB_CNTR_PMAOVRM_Msk = 0x4000
	// Bit PMAOVRM.
	USB_CNTR_PMAOVRM = 0x4000
	// PMAOVR Interrupt disabled
	USB_CNTR_PMAOVRM_Disabled = 0x0
	// PMAOVR Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_PMAOVRM_Enabled = 0x1
	// Position of CTRM field.
	USB_CNTR_CTRM_Pos = 0xf
	// Bit mask of CTRM field.
	USB_CNTR_CTRM_Msk = 0x8000
	// Bit CTRM.
	USB_CNTR_CTRM = 0x8000
	// Correct Transfer (CTR) Interrupt disabled
	USB_CNTR_CTRM_Disabled = 0x0
	// CTR Interrupt enabled, an interrupt request is generated when the corresponding bit in the USB_ISTR register is set
	USB_CNTR_CTRM_Enabled = 0x1

	// ISTR: interrupt status register
	// Position of EP_ID field.
	USB_ISTR_EP_ID_Pos = 0x0
	// Bit mask of EP_ID field.
	USB_ISTR_EP_ID_Msk = 0xf
	// Position of DIR field.
	USB_ISTR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	USB_ISTR_DIR_Msk = 0x10
	// Bit DIR.
	USB_ISTR_DIR = 0x10
	// data transmitted by the USB peripheral to the host PC
	USB_ISTR_DIR_To = 0x0
	// data received by the USB peripheral from the host PC
	USB_ISTR_DIR_From = 0x1
	// Position of ESOF field.
	USB_ISTR_ESOF_Pos = 0x8
	// Bit mask of ESOF field.
	USB_ISTR_ESOF_Msk = 0x100
	// Bit ESOF.
	USB_ISTR_ESOF = 0x100
	// an SOF packet is expected but not received
	USB_ISTR_ESOF_ExpectedStartOfFrame = 0x1
	// Position of SOF field.
	USB_ISTR_SOF_Pos = 0x9
	// Bit mask of SOF field.
	USB_ISTR_SOF_Msk = 0x200
	// Bit SOF.
	USB_ISTR_SOF = 0x200
	// beginning of a new USB frame and it is set when a SOF packet arrives through the USB bus
	USB_ISTR_SOF_StartOfFrame = 0x1
	// Position of RESET field.
	USB_ISTR_RESET_Pos = 0xa
	// Bit mask of RESET field.
	USB_ISTR_RESET_Msk = 0x400
	// Bit RESET.
	USB_ISTR_RESET = 0x400
	// peripheral detects an active USB RESET signal at its inputs
	USB_ISTR_RESET_Reset = 0x1
	// Position of SUSP field.
	USB_ISTR_SUSP_Pos = 0xb
	// Bit mask of SUSP field.
	USB_ISTR_SUSP_Msk = 0x800
	// Bit SUSP.
	USB_ISTR_SUSP = 0x800
	// no traffic has been received for 3 ms, indicating a suspend mode request from the USB bus
	USB_ISTR_SUSP_Suspend = 0x1
	// Position of WKUP field.
	USB_ISTR_WKUP_Pos = 0xc
	// Bit mask of WKUP field.
	USB_ISTR_WKUP_Msk = 0x1000
	// Bit WKUP.
	USB_ISTR_WKUP = 0x1000
	// activity is detected that wakes up the USB peripheral
	USB_ISTR_WKUP_Wakeup = 0x1
	// Position of ERR field.
	USB_ISTR_ERR_Pos = 0xd
	// Bit mask of ERR field.
	USB_ISTR_ERR_Msk = 0x2000
	// Bit ERR.
	USB_ISTR_ERR = 0x2000
	// One of No ANSwer, Cyclic Redundancy Check, Bit Stuffing or Framing format Violation error occurred
	USB_ISTR_ERR_Error = 0x1
	// Position of PMAOVR field.
	USB_ISTR_PMAOVR_Pos = 0xe
	// Bit mask of PMAOVR field.
	USB_ISTR_PMAOVR_Msk = 0x4000
	// Bit PMAOVR.
	USB_ISTR_PMAOVR = 0x4000
	// microcontroller has not been able to respond in time to an USB memory request
	USB_ISTR_PMAOVR_Overrun = 0x1
	// Position of CTR field.
	USB_ISTR_CTR_Pos = 0xf
	// Bit mask of CTR field.
	USB_ISTR_CTR_Msk = 0x8000
	// Bit CTR.
	USB_ISTR_CTR = 0x8000
	// endpoint has successfully completed a transaction
	USB_ISTR_CTR_Completed = 0x1

	// FNR: frame number register
	// Position of FN field.
	USB_FNR_FN_Pos = 0x0
	// Bit mask of FN field.
	USB_FNR_FN_Msk = 0x7ff
	// Position of LSOF field.
	USB_FNR_LSOF_Pos = 0xb
	// Bit mask of LSOF field.
	USB_FNR_LSOF_Msk = 0x1800
	// Position of LCK field.
	USB_FNR_LCK_Pos = 0xd
	// Bit mask of LCK field.
	USB_FNR_LCK_Msk = 0x2000
	// Bit LCK.
	USB_FNR_LCK = 0x2000
	// the frame timer remains in this state until an USB reset or USB suspend event occurs
	USB_FNR_LCK_Locked = 0x1
	// Position of RXDM field.
	USB_FNR_RXDM_Pos = 0xe
	// Bit mask of RXDM field.
	USB_FNR_RXDM_Msk = 0x4000
	// Bit RXDM.
	USB_FNR_RXDM = 0x4000
	// received data minus upstream port data line
	USB_FNR_RXDM_Received = 0x1
	// Position of RXDP field.
	USB_FNR_RXDP_Pos = 0xf
	// Bit mask of RXDP field.
	USB_FNR_RXDP_Msk = 0x8000
	// Bit RXDP.
	USB_FNR_RXDP = 0x8000
	// received data plus upstream port data line
	USB_FNR_RXDP_Received = 0x1

	// DADDR: device address
	// Position of ADD field.
	USB_DADDR_ADD_Pos = 0x0
	// Bit mask of ADD field.
	USB_DADDR_ADD_Msk = 0x7f
	// Position of EF field.
	USB_DADDR_EF_Pos = 0x7
	// Bit mask of EF field.
	USB_DADDR_EF_Msk = 0x80
	// Bit EF.
	USB_DADDR_EF = 0x80
	// USB device disabled
	USB_DADDR_EF_Disabled = 0x0
	// USB device enabled
	USB_DADDR_EF_Enabled = 0x1

	// BTABLE: Buffer table address
	// Position of BTABLE field.
	USB_BTABLE_BTABLE_Pos = 0x3
	// Bit mask of BTABLE field.
	USB_BTABLE_BTABLE_Msk = 0xfff8
)

// Constants for WWDG: Window watchdog
const (
	// CR: Control register
	// Position of WDGA field.
	WWDG_CR_WDGA_Pos = 0x7
	// Bit mask of WDGA field.
	WWDG_CR_WDGA_Msk = 0x80
	// Bit WDGA.
	WWDG_CR_WDGA = 0x80
	// Watchdog disabled
	WWDG_CR_WDGA_Disabled = 0x0
	// Watchdog enabled
	WWDG_CR_WDGA_Enabled = 0x1
	// Position of T field.
	WWDG_CR_T_Pos = 0x0
	// Bit mask of T field.
	WWDG_CR_T_Msk = 0x7f

	// CFR: Configuration register
	// Position of EWI field.
	WWDG_CFR_EWI_Pos = 0x9
	// Bit mask of EWI field.
	WWDG_CFR_EWI_Msk = 0x200
	// Bit EWI.
	WWDG_CFR_EWI = 0x200
	// interrupt occurs whenever the counter reaches the value 0x40
	WWDG_CFR_EWI_Enable = 0x1
	// Position of W field.
	WWDG_CFR_W_Pos = 0x0
	// Bit mask of W field.
	WWDG_CFR_W_Msk = 0x7f
	// Position of WDGTB field.
	WWDG_CFR_WDGTB_Pos = 0x7
	// Bit mask of WDGTB field.
	WWDG_CFR_WDGTB_Msk = 0x180
	// Counter clock (PCLK1 div 4096) div 1
	WWDG_CFR_WDGTB_Div1 = 0x0
	// Counter clock (PCLK1 div 4096) div 2
	WWDG_CFR_WDGTB_Div2 = 0x1
	// Counter clock (PCLK1 div 4096) div 4
	WWDG_CFR_WDGTB_Div4 = 0x2
	// Counter clock (PCLK1 div 4096) div 8
	WWDG_CFR_WDGTB_Div8 = 0x3

	// SR: SR
	// Position of EWIF field.
	WWDG_SR_EWIF_Pos = 0x0
	// Bit mask of EWIF field.
	WWDG_SR_EWIF_Msk = 0x1
	// Bit EWIF.
	WWDG_SR_EWIF = 0x1
	// The EWI Interrupt Service Routine has been triggered
	WWDG_SR_EWIF_Pending = 0x1
	// The EWI Interrupt Service Routine has been serviced
	WWDG_SR_EWIF_Finished = 0x0
)

// Constants for ADC: Analog-to-digital converter
const (
	// SR: status register
	// Position of JCNR field.
	ADC_SR_JCNR_Pos = 0x9
	// Bit mask of JCNR field.
	ADC_SR_JCNR_Msk = 0x200
	// Bit JCNR.
	ADC_SR_JCNR = 0x200
	// Position of RCNR field.
	ADC_SR_RCNR_Pos = 0x8
	// Bit mask of RCNR field.
	ADC_SR_RCNR_Msk = 0x100
	// Bit RCNR.
	ADC_SR_RCNR = 0x100
	// Position of ADONS field.
	ADC_SR_ADONS_Pos = 0x6
	// Bit mask of ADONS field.
	ADC_SR_ADONS_Msk = 0x40
	// Bit ADONS.
	ADC_SR_ADONS = 0x40
	// Position of OVR field.
	ADC_SR_OVR_Pos = 0x5
	// Bit mask of OVR field.
	ADC_SR_OVR_Msk = 0x20
	// Bit OVR.
	ADC_SR_OVR = 0x20
	// Position of STRT field.
	ADC_SR_STRT_Pos = 0x4
	// Bit mask of STRT field.
	ADC_SR_STRT_Msk = 0x10
	// Bit STRT.
	ADC_SR_STRT = 0x10
	// Position of JSTRT field.
	ADC_SR_JSTRT_Pos = 0x3
	// Bit mask of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8
	// Bit JSTRT.
	ADC_SR_JSTRT = 0x8
	// Position of JEOC field.
	ADC_SR_JEOC_Pos = 0x2
	// Bit mask of JEOC field.
	ADC_SR_JEOC_Msk = 0x4
	// Bit JEOC.
	ADC_SR_JEOC = 0x4
	// Position of EOC field.
	ADC_SR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	ADC_SR_EOC_Msk = 0x2
	// Bit EOC.
	ADC_SR_EOC = 0x2
	// Position of AWD field.
	ADC_SR_AWD_Pos = 0x0
	// Bit mask of AWD field.
	ADC_SR_AWD_Msk = 0x1
	// Bit AWD.
	ADC_SR_AWD = 0x1

	// CR1: control register 1
	// Position of OVRIE field.
	ADC_CR1_OVRIE_Pos = 0x1a
	// Bit mask of OVRIE field.
	ADC_CR1_OVRIE_Msk = 0x4000000
	// Bit OVRIE.
	ADC_CR1_OVRIE = 0x4000000
	// Position of RES field.
	ADC_CR1_RES_Pos = 0x18
	// Bit mask of RES field.
	ADC_CR1_RES_Msk = 0x3000000
	// Position of AWDEN field.
	ADC_CR1_AWDEN_Pos = 0x17
	// Bit mask of AWDEN field.
	ADC_CR1_AWDEN_Msk = 0x800000
	// Bit AWDEN.
	ADC_CR1_AWDEN = 0x800000
	// Position of JAWDEN field.
	ADC_CR1_JAWDEN_Pos = 0x16
	// Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN_Msk = 0x400000
	// Bit JAWDEN.
	ADC_CR1_JAWDEN = 0x400000
	// Position of PDI field.
	ADC_CR1_PDI_Pos = 0x11
	// Bit mask of PDI field.
	ADC_CR1_PDI_Msk = 0x20000
	// Bit PDI.
	ADC_CR1_PDI = 0x20000
	// Position of PDD field.
	ADC_CR1_PDD_Pos = 0x10
	// Bit mask of PDD field.
	ADC_CR1_PDD_Msk = 0x10000
	// Bit PDD.
	ADC_CR1_PDD = 0x10000
	// Position of DISCNUM field.
	ADC_CR1_DISCNUM_Pos = 0xd
	// Bit mask of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000
	// Position of JDISCEN field.
	ADC_CR1_JDISCEN_Pos = 0xc
	// Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000
	// Bit JDISCEN.
	ADC_CR1_JDISCEN = 0x1000
	// Position of DISCEN field.
	ADC_CR1_DISCEN_Pos = 0xb
	// Bit mask of DISCEN field.
	ADC_CR1_DISCEN_Msk = 0x800
	// Bit DISCEN.
	ADC_CR1_DISCEN = 0x800
	// Position of JAUTO field.
	ADC_CR1_JAUTO_Pos = 0xa
	// Bit mask of JAUTO field.
	ADC_CR1_JAUTO_Msk = 0x400
	// Bit JAUTO.
	ADC_CR1_JAUTO = 0x400
	// Position of AWDSGL field.
	ADC_CR1_AWDSGL_Pos = 0x9
	// Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL_Msk = 0x200
	// Bit AWDSGL.
	ADC_CR1_AWDSGL = 0x200
	// Position of SCAN field.
	ADC_CR1_SCAN_Pos = 0x8
	// Bit mask of SCAN field.
	ADC_CR1_SCAN_Msk = 0x100
	// Bit SCAN.
	ADC_CR1_SCAN = 0x100
	// Position of JEOCIE field.
	ADC_CR1_JEOCIE_Pos = 0x7
	// Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE_Msk = 0x80
	// Bit JEOCIE.
	ADC_CR1_JEOCIE = 0x80
	// Position of AWDIE field.
	ADC_CR1_AWDIE_Pos = 0x6
	// Bit mask of AWDIE field.
	ADC_CR1_AWDIE_Msk = 0x40
	// Bit AWDIE.
	ADC_CR1_AWDIE = 0x40
	// Position of EOCIE field.
	ADC_CR1_EOCIE_Pos = 0x5
	// Bit mask of EOCIE field.
	ADC_CR1_EOCIE_Msk = 0x20
	// Bit EOCIE.
	ADC_CR1_EOCIE = 0x20
	// Position of AWDCH field.
	ADC_CR1_AWDCH_Pos = 0x0
	// Bit mask of AWDCH field.
	ADC_CR1_AWDCH_Msk = 0x1f

	// CR2: control register 2
	// Position of SWSTART field.
	ADC_CR2_SWSTART_Pos = 0x1e
	// Bit mask of SWSTART field.
	ADC_CR2_SWSTART_Msk = 0x40000000
	// Bit SWSTART.
	ADC_CR2_SWSTART = 0x40000000
	// Position of EXTEN field.
	ADC_CR2_EXTEN_Pos = 0x1c
	// Bit mask of EXTEN field.
	ADC_CR2_EXTEN_Msk = 0x30000000
	// Position of EXTSEL field.
	ADC_CR2_EXTSEL_Pos = 0x18
	// Bit mask of EXTSEL field.
	ADC_CR2_EXTSEL_Msk = 0xf000000
	// Position of JSWSTART field.
	ADC_CR2_JSWSTART_Pos = 0x16
	// Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x400000
	// Bit JSWSTART.
	ADC_CR2_JSWSTART = 0x400000
	// Position of JEXTEN field.
	ADC_CR2_JEXTEN_Pos = 0x14
	// Bit mask of JEXTEN field.
	ADC_CR2_JEXTEN_Msk = 0x300000
	// Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Pos = 0x10
	// Bit mask of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk = 0xf0000
	// Position of ALIGN field.
	ADC_CR2_ALIGN_Pos = 0xb
	// Bit mask of ALIGN field.
	ADC_CR2_ALIGN_Msk = 0x800
	// Bit ALIGN.
	ADC_CR2_ALIGN = 0x800
	// Position of EOCS field.
	ADC_CR2_EOCS_Pos = 0xa
	// Bit mask of EOCS field.
	ADC_CR2_EOCS_Msk = 0x400
	// Bit EOCS.
	ADC_CR2_EOCS = 0x400
	// Position of DDS field.
	ADC_CR2_DDS_Pos = 0x9
	// Bit mask of DDS field.
	ADC_CR2_DDS_Msk = 0x200
	// Bit DDS.
	ADC_CR2_DDS = 0x200
	// Position of DMA field.
	ADC_CR2_DMA_Pos = 0x8
	// Bit mask of DMA field.
	ADC_CR2_DMA_Msk = 0x100
	// Bit DMA.
	ADC_CR2_DMA = 0x100
	// Position of DELS field.
	ADC_CR2_DELS_Pos = 0x4
	// Bit mask of DELS field.
	ADC_CR2_DELS_Msk = 0x70
	// Position of ADC_CFG field.
	ADC_CR2_ADC_CFG_Pos = 0x2
	// Bit mask of ADC_CFG field.
	ADC_CR2_ADC_CFG_Msk = 0x4
	// Bit ADC_CFG.
	ADC_CR2_ADC_CFG = 0x4
	// Position of CONT field.
	ADC_CR2_CONT_Pos = 0x1
	// Bit mask of CONT field.
	ADC_CR2_CONT_Msk = 0x2
	// Bit CONT.
	ADC_CR2_CONT = 0x2
	// Position of ADON field.
	ADC_CR2_ADON_Pos = 0x0
	// Bit mask of ADON field.
	ADC_CR2_ADON_Msk = 0x1
	// Bit ADON.
	ADC_CR2_ADON = 0x1

	// SMPR1: sample time register 1
	// Position of SMP field.
	ADC_SMPR1_SMP_Pos = 0x0
	// Bit mask of SMP field.
	ADC_SMPR1_SMP_Msk = 0x3fffffff

	// SMPR2: sample time register 2
	// Position of SMP field.
	ADC_SMPR2_SMP_Pos = 0x0
	// Bit mask of SMP field.
	ADC_SMPR2_SMP_Msk = 0x3fffffff

	// SMPR3: sample time register 3
	// Position of SMP field.
	ADC_SMPR3_SMP_Pos = 0x0
	// Bit mask of SMP field.
	ADC_SMPR3_SMP_Msk = 0x3fffffff

	// JOFR1: injected channel data offset register x
	// Position of JOFFSET1 field.
	ADC_JOFR1_JOFFSET1_Pos = 0x0
	// Bit mask of JOFFSET1 field.
	ADC_JOFR1_JOFFSET1_Msk = 0xfff

	// JOFR2: injected channel data offset register x
	// Position of JOFFSET2 field.
	ADC_JOFR2_JOFFSET2_Pos = 0x0
	// Bit mask of JOFFSET2 field.
	ADC_JOFR2_JOFFSET2_Msk = 0xfff

	// JOFR3: injected channel data offset register x
	// Position of JOFFSET3 field.
	ADC_JOFR3_JOFFSET3_Pos = 0x0
	// Bit mask of JOFFSET3 field.
	ADC_JOFR3_JOFFSET3_Msk = 0xfff

	// JOFR4: injected channel data offset register x
	// Position of JOFFSET4 field.
	ADC_JOFR4_JOFFSET4_Pos = 0x0
	// Bit mask of JOFFSET4 field.
	ADC_JOFR4_JOFFSET4_Msk = 0xfff

	// HTR: watchdog higher threshold register
	// Position of HT field.
	ADC_HTR_HT_Pos = 0x0
	// Bit mask of HT field.
	ADC_HTR_HT_Msk = 0xfff

	// LTR: watchdog lower threshold register
	// Position of LT field.
	ADC_LTR_LT_Pos = 0x0
	// Bit mask of LT field.
	ADC_LTR_LT_Msk = 0xfff

	// SQR1: regular sequence register 1
	// Position of L field.
	ADC_SQR1_L_Pos = 0x14
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf00000
	// Position of SQ28 field.
	ADC_SQR1_SQ28_Pos = 0xf
	// Bit mask of SQ28 field.
	ADC_SQR1_SQ28_Msk = 0xf8000
	// Position of SQ27 field.
	ADC_SQR1_SQ27_Pos = 0xa
	// Bit mask of SQ27 field.
	ADC_SQR1_SQ27_Msk = 0x7c00
	// Position of SQ26 field.
	ADC_SQR1_SQ26_Pos = 0x5
	// Bit mask of SQ26 field.
	ADC_SQR1_SQ26_Msk = 0x3e0
	// Position of SQ25 field.
	ADC_SQR1_SQ25_Pos = 0x0
	// Bit mask of SQ25 field.
	ADC_SQR1_SQ25_Msk = 0x1f

	// SQR2: regular sequence register 2
	// Position of SQ24 field.
	ADC_SQR2_SQ24_Pos = 0x19
	// Bit mask of SQ24 field.
	ADC_SQR2_SQ24_Msk = 0x3e000000
	// Position of SQ23 field.
	ADC_SQR2_SQ23_Pos = 0x14
	// Bit mask of SQ23 field.
	ADC_SQR2_SQ23_Msk = 0x1f00000
	// Position of SQ22 field.
	ADC_SQR2_SQ22_Pos = 0xf
	// Bit mask of SQ22 field.
	ADC_SQR2_SQ22_Msk = 0xf8000
	// Position of SQ21 field.
	ADC_SQR2_SQ21_Pos = 0xa
	// Bit mask of SQ21 field.
	ADC_SQR2_SQ21_Msk = 0x7c00
	// Position of SQ20 field.
	ADC_SQR2_SQ20_Pos = 0x5
	// Bit mask of SQ20 field.
	ADC_SQR2_SQ20_Msk = 0x3e0
	// Position of SQ19 field.
	ADC_SQR2_SQ19_Pos = 0x0
	// Bit mask of SQ19 field.
	ADC_SQR2_SQ19_Msk = 0x1f

	// SQR3: regular sequence register 3
	// Position of SQ18 field.
	ADC_SQR3_SQ18_Pos = 0x19
	// Bit mask of SQ18 field.
	ADC_SQR3_SQ18_Msk = 0x3e000000
	// Position of SQ17 field.
	ADC_SQR3_SQ17_Pos = 0x14
	// Bit mask of SQ17 field.
	ADC_SQR3_SQ17_Msk = 0x1f00000
	// Position of SQ16 field.
	ADC_SQR3_SQ16_Pos = 0xf
	// Bit mask of SQ16 field.
	ADC_SQR3_SQ16_Msk = 0xf8000
	// Position of SQ15 field.
	ADC_SQR3_SQ15_Pos = 0xa
	// Bit mask of SQ15 field.
	ADC_SQR3_SQ15_Msk = 0x7c00
	// Position of SQ14 field.
	ADC_SQR3_SQ14_Pos = 0x5
	// Bit mask of SQ14 field.
	ADC_SQR3_SQ14_Msk = 0x3e0
	// Position of SQ13 field.
	ADC_SQR3_SQ13_Pos = 0x0
	// Bit mask of SQ13 field.
	ADC_SQR3_SQ13_Msk = 0x1f

	// SQR4: regular sequence register 4
	// Position of SQ12 field.
	ADC_SQR4_SQ12_Pos = 0x19
	// Bit mask of SQ12 field.
	ADC_SQR4_SQ12_Msk = 0x3e000000
	// Position of SQ11 field.
	ADC_SQR4_SQ11_Pos = 0x14
	// Bit mask of SQ11 field.
	ADC_SQR4_SQ11_Msk = 0x1f00000
	// Position of SQ10 field.
	ADC_SQR4_SQ10_Pos = 0xf
	// Bit mask of SQ10 field.
	ADC_SQR4_SQ10_Msk = 0xf8000
	// Position of SQ9 field.
	ADC_SQR4_SQ9_Pos = 0xa
	// Bit mask of SQ9 field.
	ADC_SQR4_SQ9_Msk = 0x7c00
	// Position of SQ8 field.
	ADC_SQR4_SQ8_Pos = 0x5
	// Bit mask of SQ8 field.
	ADC_SQR4_SQ8_Msk = 0x3e0
	// Position of SQ7 field.
	ADC_SQR4_SQ7_Pos = 0x0
	// Bit mask of SQ7 field.
	ADC_SQR4_SQ7_Msk = 0x1f

	// SQR5: regular sequence register 5
	// Position of SQ6 field.
	ADC_SQR5_SQ6_Pos = 0x19
	// Bit mask of SQ6 field.
	ADC_SQR5_SQ6_Msk = 0x3e000000
	// Position of SQ5 field.
	ADC_SQR5_SQ5_Pos = 0x14
	// Bit mask of SQ5 field.
	ADC_SQR5_SQ5_Msk = 0x1f00000
	// Position of SQ4 field.
	ADC_SQR5_SQ4_Pos = 0xf
	// Bit mask of SQ4 field.
	ADC_SQR5_SQ4_Msk = 0xf8000
	// Position of SQ3 field.
	ADC_SQR5_SQ3_Pos = 0xa
	// Bit mask of SQ3 field.
	ADC_SQR5_SQ3_Msk = 0x7c00
	// Position of SQ2 field.
	ADC_SQR5_SQ2_Pos = 0x5
	// Bit mask of SQ2 field.
	ADC_SQR5_SQ2_Msk = 0x3e0
	// Position of SQ1 field.
	ADC_SQR5_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_SQR5_SQ1_Msk = 0x1f

	// JSQR: injected sequence register
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x14
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x300000
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0xf
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0xa
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0x5
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x0
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f

	// JDR1: injected data register x
	// Position of JDATA field.
	ADC_JDR1_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR1_JDATA_Msk = 0xffff

	// JDR2: injected data register x
	// Position of JDATA field.
	ADC_JDR2_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR2_JDATA_Msk = 0xffff

	// JDR3: injected data register x
	// Position of JDATA field.
	ADC_JDR3_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR3_JDATA_Msk = 0xffff

	// JDR4: injected data register x
	// Position of JDATA field.
	ADC_JDR4_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR4_JDATA_Msk = 0xffff

	// DR: regular data register
	// Position of RegularDATA field.
	ADC_DR_RegularDATA_Pos = 0x0
	// Bit mask of RegularDATA field.
	ADC_DR_RegularDATA_Msk = 0xffff

	// SMPR0: sample time register 0
	// Position of SMP field.
	ADC_SMPR0_SMP_Pos = 0x0
	// Bit mask of SMP field.
	ADC_SMPR0_SMP_Msk = 0x3f

	// CSR: ADC common status register
	// Position of AWD1 field.
	ADC_CSR_AWD1_Pos = 0x0
	// Bit mask of AWD1 field.
	ADC_CSR_AWD1_Msk = 0x1
	// Bit AWD1.
	ADC_CSR_AWD1 = 0x1
	// Position of EOC1 field.
	ADC_CSR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_CSR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_CSR_EOC1 = 0x2
	// Position of JEOC1 field.
	ADC_CSR_JEOC1_Pos = 0x2
	// Bit mask of JEOC1 field.
	ADC_CSR_JEOC1_Msk = 0x4
	// Bit JEOC1.
	ADC_CSR_JEOC1 = 0x4
	// Position of JSTRT1 field.
	ADC_CSR_JSTRT1_Pos = 0x3
	// Bit mask of JSTRT1 field.
	ADC_CSR_JSTRT1_Msk = 0x8
	// Bit JSTRT1.
	ADC_CSR_JSTRT1 = 0x8
	// Position of STRT1 field.
	ADC_CSR_STRT1_Pos = 0x4
	// Bit mask of STRT1 field.
	ADC_CSR_STRT1_Msk = 0x10
	// Bit STRT1.
	ADC_CSR_STRT1 = 0x10
	// Position of OVR1 field.
	ADC_CSR_OVR1_Pos = 0x5
	// Bit mask of OVR1 field.
	ADC_CSR_OVR1_Msk = 0x20
	// Bit OVR1.
	ADC_CSR_OVR1 = 0x20
	// Position of ADONS1 field.
	ADC_CSR_ADONS1_Pos = 0x6
	// Bit mask of ADONS1 field.
	ADC_CSR_ADONS1_Msk = 0x40
	// Bit ADONS1.
	ADC_CSR_ADONS1 = 0x40

	// CCR: ADC common control register
	// Position of ADCPRE field.
	ADC_CCR_ADCPRE_Pos = 0x10
	// Bit mask of ADCPRE field.
	ADC_CCR_ADCPRE_Msk = 0x30000
	// Position of TSVREFE field.
	ADC_CCR_TSVREFE_Pos = 0x17
	// Bit mask of TSVREFE field.
	ADC_CCR_TSVREFE_Msk = 0x800000
	// Bit TSVREFE.
	ADC_CCR_TSVREFE = 0x800000
)

// Constants for NVIC: Nested Vectored Interrupt Controller
const (
	// ISER0: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER0_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER0_SETENA_Msk = 0xffffffff

	// ISER1: Interrupt Set-Enable Register
	// Position of SETENA field.
	NVIC_ISER1_SETENA_Pos = 0x0
	// Bit mask of SETENA field.
	NVIC_ISER1_SETENA_Msk = 0xffffffff

	// ICER0: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER0_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER0_CLRENA_Msk = 0xffffffff

	// ICER1: Interrupt Clear-Enable Register
	// Position of CLRENA field.
	NVIC_ICER1_CLRENA_Pos = 0x0
	// Bit mask of CLRENA field.
	NVIC_ICER1_CLRENA_Msk = 0xffffffff

	// ISPR0: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR0_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR0_SETPEND_Msk = 0xffffffff

	// ISPR1: Interrupt Set-Pending Register
	// Position of SETPEND field.
	NVIC_ISPR1_SETPEND_Pos = 0x0
	// Bit mask of SETPEND field.
	NVIC_ISPR1_SETPEND_Msk = 0xffffffff

	// ICPR0: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR0_CLRPEND_Msk = 0xffffffff

	// ICPR1: Interrupt Clear-Pending Register
	// Position of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Pos = 0x0
	// Bit mask of CLRPEND field.
	NVIC_ICPR1_CLRPEND_Msk = 0xffffffff

	// IABR0: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR0_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR0_ACTIVE_Msk = 0xffffffff

	// IABR1: Interrupt Active Bit Register
	// Position of ACTIVE field.
	NVIC_IABR1_ACTIVE_Pos = 0x0
	// Bit mask of ACTIVE field.
	NVIC_IABR1_ACTIVE_Msk = 0xffffffff

	// IPR0: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR0_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR0_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR0_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR0_IPR_N3_Msk = 0xff000000

	// IPR1: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR1_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR1_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR1_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR1_IPR_N3_Msk = 0xff000000

	// IPR2: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR2_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR2_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR2_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR2_IPR_N3_Msk = 0xff000000

	// IPR3: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR3_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR3_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR3_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR3_IPR_N3_Msk = 0xff000000

	// IPR4: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR4_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR4_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR4_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR4_IPR_N3_Msk = 0xff000000

	// IPR5: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR5_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR5_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR5_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR5_IPR_N3_Msk = 0xff000000

	// IPR6: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR6_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR6_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR6_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR6_IPR_N3_Msk = 0xff000000

	// IPR7: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR7_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR7_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR7_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR7_IPR_N3_Msk = 0xff000000

	// IPR8: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR8_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR8_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR8_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR8_IPR_N3_Msk = 0xff000000

	// IPR9: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR9_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR9_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR9_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR9_IPR_N3_Msk = 0xff000000

	// IPR10: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR10_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR10_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR10_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR10_IPR_N3_Msk = 0xff000000

	// IPR11: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR11_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR11_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR11_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR11_IPR_N3_Msk = 0xff000000

	// IPR12: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR12_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR12_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR12_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR12_IPR_N3_Msk = 0xff000000

	// IPR13: Interrupt Priority Register
	// Position of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Pos = 0x0
	// Bit mask of IPR_N0 field.
	NVIC_IPR13_IPR_N0_Msk = 0xff
	// Position of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Pos = 0x8
	// Bit mask of IPR_N1 field.
	NVIC_IPR13_IPR_N1_Msk = 0xff00
	// Position of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Pos = 0x10
	// Bit mask of IPR_N2 field.
	NVIC_IPR13_IPR_N2_Msk = 0xff0000
	// Position of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Pos = 0x18
	// Bit mask of IPR_N3 field.
	NVIC_IPR13_IPR_N3_Msk = 0xff000000
)

// Constants for DBGMCU: debug support
const (
	// IDCODE: DBGMCU_IDCODE
	// Position of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Pos = 0x0
	// Bit mask of DEV_ID field.
	DBGMCU_IDCODE_DEV_ID_Msk = 0xfff
	// Position of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Pos = 0x10
	// Bit mask of REV_ID field.
	DBGMCU_IDCODE_REV_ID_Msk = 0xffff0000

	// CR: Debug MCU configuration register
	// Position of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Pos = 0x0
	// Bit mask of DBG_SLEEP field.
	DBGMCU_CR_DBG_SLEEP_Msk = 0x1
	// Bit DBG_SLEEP.
	DBGMCU_CR_DBG_SLEEP = 0x1
	// Position of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Pos = 0x1
	// Bit mask of DBG_STOP field.
	DBGMCU_CR_DBG_STOP_Msk = 0x2
	// Bit DBG_STOP.
	DBGMCU_CR_DBG_STOP = 0x2
	// Position of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Pos = 0x2
	// Bit mask of DBG_STANDBY field.
	DBGMCU_CR_DBG_STANDBY_Msk = 0x4
	// Bit DBG_STANDBY.
	DBGMCU_CR_DBG_STANDBY = 0x4
	// Position of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Pos = 0x5
	// Bit mask of TRACE_IOEN field.
	DBGMCU_CR_TRACE_IOEN_Msk = 0x20
	// Bit TRACE_IOEN.
	DBGMCU_CR_TRACE_IOEN = 0x20
	// Position of TRACE_MODE field.
	DBGMCU_CR_TRACE_MODE_Pos = 0x6
	// Bit mask of TRACE_MODE field.
	DBGMCU_CR_TRACE_MODE_Msk = 0xc0

	// APB1_FZ: Debug MCU APB1 freeze register1
	// Position of DBG_TIM2_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos = 0x0
	// Bit mask of DBG_TIM2_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk = 0x1
	// Bit DBG_TIM2_STOP.
	DBGMCU_APB1_FZ_DBG_TIM2_STOP = 0x1
	// Position of DBG_TIM3_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos = 0x1
	// Bit mask of DBG_TIM3_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk = 0x2
	// Bit DBG_TIM3_STOP.
	DBGMCU_APB1_FZ_DBG_TIM3_STOP = 0x2
	// Position of DBG_TIM4_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM4_STOP_Pos = 0x2
	// Bit mask of DBG_TIM4_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM4_STOP_Msk = 0x4
	// Bit DBG_TIM4_STOP.
	DBGMCU_APB1_FZ_DBG_TIM4_STOP = 0x4
	// Position of DBG_TIM5_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM5_STOP_Pos = 0x3
	// Bit mask of DBG_TIM5_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM5_STOP_Msk = 0x8
	// Bit DBG_TIM5_STOP.
	DBGMCU_APB1_FZ_DBG_TIM5_STOP = 0x8
	// Position of DBG_TIM6_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM6_STOP_Pos = 0x4
	// Bit mask of DBG_TIM6_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM6_STOP_Msk = 0x10
	// Bit DBG_TIM6_STOP.
	DBGMCU_APB1_FZ_DBG_TIM6_STOP = 0x10
	// Position of DBG_TIM7_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM7_STOP_Pos = 0x5
	// Bit mask of DBG_TIM7_STOP field.
	DBGMCU_APB1_FZ_DBG_TIM7_STOP_Msk = 0x20
	// Bit DBG_TIM7_STOP.
	DBGMCU_APB1_FZ_DBG_TIM7_STOP = 0x20
	// Position of DBG_RTC_STOP field.
	DBGMCU_APB1_FZ_DBG_RTC_STOP_Pos = 0xa
	// Bit mask of DBG_RTC_STOP field.
	DBGMCU_APB1_FZ_DBG_RTC_STOP_Msk = 0x400
	// Bit DBG_RTC_STOP.
	DBGMCU_APB1_FZ_DBG_RTC_STOP = 0x400
	// Position of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP_Pos = 0xb
	// Bit mask of DBG_WWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP_Msk = 0x800
	// Bit DBG_WWDG_STOP.
	DBGMCU_APB1_FZ_DBG_WWDG_STOP = 0x800
	// Position of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP_Pos = 0xc
	// Bit mask of DBG_IWDG_STOP field.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP_Msk = 0x1000
	// Bit DBG_IWDG_STOP.
	DBGMCU_APB1_FZ_DBG_IWDG_STOP = 0x1000
	// Position of DBG_I2C1_SMBUS_TIMEOUT field.
	DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Pos = 0x15
	// Bit mask of DBG_I2C1_SMBUS_TIMEOUT field.
	DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT_Msk = 0x200000
	// Bit DBG_I2C1_SMBUS_TIMEOUT.
	DBGMCU_APB1_FZ_DBG_I2C1_SMBUS_TIMEOUT = 0x200000
	// Position of DBG_I2C2_SMBUS_TIMEOUT field.
	DBGMCU_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT_Pos = 0x16
	// Bit mask of DBG_I2C2_SMBUS_TIMEOUT field.
	DBGMCU_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT_Msk = 0x400000
	// Bit DBG_I2C2_SMBUS_TIMEOUT.
	DBGMCU_APB1_FZ_DBG_I2C2_SMBUS_TIMEOUT = 0x400000

	// APB2_FZ: Debug MCU APB1 freeze register 2
	// Position of DBG_TIM9_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM9_STOP_Pos = 0x2
	// Bit mask of DBG_TIM9_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM9_STOP_Msk = 0x4
	// Bit DBG_TIM9_STOP.
	DBGMCU_APB2_FZ_DBG_TIM9_STOP = 0x4
	// Position of DBG_TIM10_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM10_STOP_Pos = 0x3
	// Bit mask of DBG_TIM10_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM10_STOP_Msk = 0x8
	// Bit DBG_TIM10_STOP.
	DBGMCU_APB2_FZ_DBG_TIM10_STOP = 0x8
	// Position of DBG_TIM11_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM11_STOP_Pos = 0x4
	// Bit mask of DBG_TIM11_STOP field.
	DBGMCU_APB2_FZ_DBG_TIM11_STOP_Msk = 0x10
	// Bit DBG_TIM11_STOP.
	DBGMCU_APB2_FZ_DBG_TIM11_STOP = 0x10
)

// Constants for MPU: Memory protection unit
const (
	// TYPER: MPU type register
	// Position of SEPARATE field.
	MPU_TYPER_SEPARATE_Pos = 0x0
	// Bit mask of SEPARATE field.
	MPU_TYPER_SEPARATE_Msk = 0x1
	// Bit SEPARATE.
	MPU_TYPER_SEPARATE = 0x1
	// Position of DREGION field.
	MPU_TYPER_DREGION_Pos = 0x8
	// Bit mask of DREGION field.
	MPU_TYPER_DREGION_Msk = 0xff00
	// Position of IREGION field.
	MPU_TYPER_IREGION_Pos = 0x10
	// Bit mask of IREGION field.
	MPU_TYPER_IREGION_Msk = 0xff0000

	// CTRL: MPU control register
	// Position of ENABLE field.
	MPU_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_CTRL_ENABLE = 0x1
	// Position of HFNMIENA field.
	MPU_CTRL_HFNMIENA_Pos = 0x1
	// Bit mask of HFNMIENA field.
	MPU_CTRL_HFNMIENA_Msk = 0x2
	// Bit HFNMIENA.
	MPU_CTRL_HFNMIENA = 0x2
	// Position of PRIVDEFENA field.
	MPU_CTRL_PRIVDEFENA_Pos = 0x2
	// Bit mask of PRIVDEFENA field.
	MPU_CTRL_PRIVDEFENA_Msk = 0x4
	// Bit PRIVDEFENA.
	MPU_CTRL_PRIVDEFENA = 0x4

	// RNR: MPU region number register
	// Position of REGION field.
	MPU_RNR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_RNR_REGION_Msk = 0xff

	// RBAR: MPU region base address register
	// Position of REGION field.
	MPU_RBAR_REGION_Pos = 0x0
	// Bit mask of REGION field.
	MPU_RBAR_REGION_Msk = 0xf
	// Position of VALID field.
	MPU_RBAR_VALID_Pos = 0x4
	// Bit mask of VALID field.
	MPU_RBAR_VALID_Msk = 0x10
	// Bit VALID.
	MPU_RBAR_VALID = 0x10
	// Position of ADDR field.
	MPU_RBAR_ADDR_Pos = 0x5
	// Bit mask of ADDR field.
	MPU_RBAR_ADDR_Msk = 0xffffffe0

	// RASR: MPU region attribute and size register
	// Position of ENABLE field.
	MPU_RASR_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	MPU_RASR_ENABLE_Msk = 0x1
	// Bit ENABLE.
	MPU_RASR_ENABLE = 0x1
	// Position of SIZE field.
	MPU_RASR_SIZE_Pos = 0x1
	// Bit mask of SIZE field.
	MPU_RASR_SIZE_Msk = 0x3e
	// Position of SRD field.
	MPU_RASR_SRD_Pos = 0x8
	// Bit mask of SRD field.
	MPU_RASR_SRD_Msk = 0xff00
	// Position of B field.
	MPU_RASR_B_Pos = 0x10
	// Bit mask of B field.
	MPU_RASR_B_Msk = 0x10000
	// Bit B.
	MPU_RASR_B = 0x10000
	// Position of C field.
	MPU_RASR_C_Pos = 0x11
	// Bit mask of C field.
	MPU_RASR_C_Msk = 0x20000
	// Bit C.
	MPU_RASR_C = 0x20000
	// Position of S field.
	MPU_RASR_S_Pos = 0x12
	// Bit mask of S field.
	MPU_RASR_S_Msk = 0x40000
	// Bit S.
	MPU_RASR_S = 0x40000
	// Position of TEX field.
	MPU_RASR_TEX_Pos = 0x13
	// Bit mask of TEX field.
	MPU_RASR_TEX_Msk = 0x380000
	// Position of AP field.
	MPU_RASR_AP_Pos = 0x18
	// Bit mask of AP field.
	MPU_RASR_AP_Msk = 0x7000000
	// Position of XN field.
	MPU_RASR_XN_Pos = 0x1c
	// Bit mask of XN field.
	MPU_RASR_XN_Msk = 0x10000000
	// Bit XN.
	MPU_RASR_XN = 0x10000000
)

// Constants for SCB_ACTRL: System control block ACTLR
const (
	// ACTRL: Auxiliary control register
	// Position of DISFOLD field.
	SCB_ACTRL_DISFOLD_Pos = 0x2
	// Bit mask of DISFOLD field.
	SCB_ACTRL_DISFOLD_Msk = 0x4
	// Bit DISFOLD.
	SCB_ACTRL_DISFOLD = 0x4
	// Position of FPEXCODIS field.
	SCB_ACTRL_FPEXCODIS_Pos = 0xa
	// Bit mask of FPEXCODIS field.
	SCB_ACTRL_FPEXCODIS_Msk = 0x400
	// Bit FPEXCODIS.
	SCB_ACTRL_FPEXCODIS = 0x400
	// Position of DISRAMODE field.
	SCB_ACTRL_DISRAMODE_Pos = 0xb
	// Bit mask of DISRAMODE field.
	SCB_ACTRL_DISRAMODE_Msk = 0x800
	// Bit DISRAMODE.
	SCB_ACTRL_DISRAMODE = 0x800
	// Position of DISITMATBFLUSH field.
	SCB_ACTRL_DISITMATBFLUSH_Pos = 0xc
	// Bit mask of DISITMATBFLUSH field.
	SCB_ACTRL_DISITMATBFLUSH_Msk = 0x1000
	// Bit DISITMATBFLUSH.
	SCB_ACTRL_DISITMATBFLUSH = 0x1000
)

// Constants for STK: SysTick timer
const (
	// CTRL: SysTick control and status register
	// Position of ENABLE field.
	STK_CTRL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	STK_CTRL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	STK_CTRL_ENABLE = 0x1
	// Position of TICKINT field.
	STK_CTRL_TICKINT_Pos = 0x1
	// Bit mask of TICKINT field.
	STK_CTRL_TICKINT_Msk = 0x2
	// Bit TICKINT.
	STK_CTRL_TICKINT = 0x2
	// Position of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Pos = 0x2
	// Bit mask of CLKSOURCE field.
	STK_CTRL_CLKSOURCE_Msk = 0x4
	// Bit CLKSOURCE.
	STK_CTRL_CLKSOURCE = 0x4
	// Position of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Pos = 0x10
	// Bit mask of COUNTFLAG field.
	STK_CTRL_COUNTFLAG_Msk = 0x10000
	// Bit COUNTFLAG.
	STK_CTRL_COUNTFLAG = 0x10000

	// LOAD_: SysTick reload value register
	// Position of RELOAD field.
	STK_LOAD__RELOAD_Pos = 0x0
	// Bit mask of RELOAD field.
	STK_LOAD__RELOAD_Msk = 0xffffff

	// VAL: SysTick current value register
	// Position of CURRENT field.
	STK_VAL_CURRENT_Pos = 0x0
	// Bit mask of CURRENT field.
	STK_VAL_CURRENT_Msk = 0xffffff

	// CALIB: SysTick calibration value register
	// Position of TENMS field.
	STK_CALIB_TENMS_Pos = 0x0
	// Bit mask of TENMS field.
	STK_CALIB_TENMS_Msk = 0xffffff
)
