/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class InstanceOfExpression
extends OperatorExpression {
    public Expression expression;
    public TypeReference type;
    public LocalDeclaration elementVariable;
    static final char[] SECRET_INSTANCEOF_PATTERN_EXPRESSION_VALUE = " instanceOfPatternExpressionValue".toCharArray();
    public LocalVariableBinding secretInstanceOfPatternExpressionValue = null;

    public InstanceOfExpression(Expression expression, TypeReference typeReference) {
        this.expression = expression;
        this.type = typeReference;
        typeReference.bits |= 0x40000000;
        this.bits |= 0x1F00;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = typeReference.sourceEnd;
    }

    public InstanceOfExpression(Expression expression, Pattern pattern) {
        this.expression = expression;
        this.elementVariable = pattern.getPatternVariableIntroduced();
        this.type = this.elementVariable.type;
        this.bits |= 0x1F00;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = this.elementVariable.declarationSourceEnd;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FieldBinding fieldBinding;
        LocalVariableBinding localVariableBinding = this.expression.localVariableBinding();
        FlowInfo flowInfo2 = null;
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L) {
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            flowInfo2 = flowInfo.copy();
            flowInfo2.markAsComparedEqualToNonNull(localVariableBinding);
            flowContext.recordUsingNullReference(blockScope, localVariableBinding, this.expression, 1025, flowInfo);
            flowInfo = FlowInfo.conditional(flowInfo2.copy(), flowInfo.copy());
        } else if (this.expression instanceof Reference && blockScope.compilerOptions().enableSyntacticNullAnalysisForFields && (fieldBinding = ((Reference)this.expression).lastFieldBinding()) != null && (fieldBinding.type.tagBits & 2L) == 0L) {
            flowContext.recordNullCheckedFieldReference((Reference)this.expression, 1);
        }
        if (flowInfo2 == null) {
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            if (this.elementVariable != null) {
                flowInfo2 = flowInfo.copy();
            }
        }
        if (this.elementVariable != null) {
            flowInfo2.markAsDefinitelyAssigned(this.elementVariable.binding);
        }
        return flowInfo2 == null ? flowInfo : FlowInfo.conditional(flowInfo2, flowInfo.copy());
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        if (this.elementVariable != null && this.elementVariable.binding != null) {
            this.elementVariable.binding.modifiers &= 0xEFFFFFFF;
        }
        this.addPatternVariables(blockScope, codeStream);
        int n = codeStream.position;
        if (this.elementVariable != null) {
            this.addAssignment(blockScope, codeStream, this.secretInstanceOfPatternExpressionValue);
            codeStream.load(this.secretInstanceOfPatternExpressionValue);
        } else {
            this.expression.generateCode(blockScope, codeStream, true);
        }
        codeStream.instance_of(this.type, this.type.resolvedType);
        if (this.elementVariable != null) {
            BranchLabel branchLabel = new BranchLabel(codeStream);
            codeStream.dup();
            codeStream.ifeq(branchLabel);
            codeStream.load(this.secretInstanceOfPatternExpressionValue);
            codeStream.removeVariable(this.secretInstanceOfPatternExpressionValue);
            codeStream.checkcast(this.type, this.type.resolvedType, codeStream.position);
            this.elementVariable.binding.recordInitializationStartPC(codeStream.position);
            codeStream.store(this.elementVariable.binding, false);
            codeStream.removeVariable(this.elementVariable.binding);
            codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
            branchLabel.place();
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        if (this.elementVariable == null) {
            super.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
            return;
        }
        Constant constant = this.optimizedBooleanConstant();
        this.addPatternVariables(blockScope, codeStream);
        int n = codeStream.position;
        this.addAssignment(blockScope, codeStream, this.secretInstanceOfPatternExpressionValue);
        codeStream.load(this.secretInstanceOfPatternExpressionValue);
        BranchLabel branchLabel3 = branchLabel2 != null ? branchLabel2 : new BranchLabel(codeStream);
        codeStream.instance_of(this.type, this.type.resolvedType);
        if (this.elementVariable != null) {
            codeStream.ifeq(branchLabel3);
            codeStream.load(this.secretInstanceOfPatternExpressionValue);
            codeStream.checkcast(this.type, this.type.resolvedType, codeStream.position);
            codeStream.dup();
            codeStream.store(this.elementVariable.binding, false);
            codeStream.load(this.secretInstanceOfPatternExpressionValue);
            codeStream.removeVariable(this.secretInstanceOfPatternExpressionValue);
            codeStream.checkcast(this.type, this.type.resolvedType, codeStream.position);
        }
        if (bl && constant == Constant.NotAConstant) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
        if (constant != Constant.NotAConstant && constant.typeID() == 5) {
            n = codeStream.position;
            if (constant.booleanValue()) {
                if (bl && branchLabel2 == null && branchLabel != null) {
                    codeStream.goto_(branchLabel);
                }
            } else if (bl && branchLabel2 != null && branchLabel == null) {
                codeStream.goto_(branchLabel2);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
        } else {
            int n2 = codeStream.position;
            if (bl) {
                if (branchLabel2 == null) {
                    if (branchLabel != null) {
                        codeStream.if_acmpeq(branchLabel);
                    }
                } else if (branchLabel == null) {
                    codeStream.if_acmpne(branchLabel2);
                }
            }
            codeStream.recordPositionsFrom(n2, this.sourceEnd);
        }
        if (branchLabel3 != branchLabel2) {
            branchLabel3.place();
        }
    }

    private void addAssignment(BlockScope blockScope, CodeStream codeStream, LocalVariableBinding localVariableBinding) {
        assert (localVariableBinding != null);
        SingleNameReference singleNameReference = new SingleNameReference(localVariableBinding.name, 0L);
        singleNameReference.binding = localVariableBinding;
        singleNameReference.bits &= 0xFFFFFFF8;
        singleNameReference.bits |= 2;
        singleNameReference.bits |= 0x10;
        ((LocalVariableBinding)singleNameReference.binding).markReferenced();
        Assignment assignment = new Assignment(singleNameReference, this.expression, 0);
        assignment.generateCode(blockScope, codeStream);
        codeStream.addVariable(this.secretInstanceOfPatternExpressionValue);
    }

    @Override
    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        this.expression.printExpression(n, stringBuffer).append(" instanceof ");
        return this.elementVariable == null ? this.type.print(0, stringBuffer) : this.elementVariable.printAsExpression(0, stringBuffer);
    }

    @Override
    public void addPatternVariables(BlockScope blockScope, CodeStream codeStream) {
        if (this.elementVariable != null) {
            codeStream.addVisibleLocalVariable(this.elementVariable.binding);
        }
    }

    public boolean resolvePatternVariable(BlockScope blockScope) {
        if (this.elementVariable == null) {
            return false;
        }
        if (this.elementVariable.binding == null) {
            this.elementVariable.modifiers |= 0x10000000;
            this.elementVariable.resolve(blockScope, true);
            this.elementVariable.modifiers &= 0xFBFFFFFF;
            this.elementVariable.binding.modifiers |= 0x10000000;
            this.elementVariable.binding.useFlag = 1;
            this.type = this.elementVariable.type;
        }
        return true;
    }

    @Override
    public void collectPatternVariablesToScope(LocalVariableBinding[] localVariableBindingArray, BlockScope blockScope) {
        this.expression.collectPatternVariablesToScope(localVariableBindingArray, blockScope);
        if (this.elementVariable != null) {
            if (this.elementVariable.binding == null) {
                this.resolvePatternVariable(blockScope);
                if (localVariableBindingArray != null) {
                    for (LocalVariableBinding localVariableBinding : localVariableBindingArray) {
                        if (!CharOperation.equals(this.elementVariable.name, localVariableBinding.name)) continue;
                        blockScope.problemReporter().redefineLocal(this.elementVariable);
                    }
                }
            }
            if (this.patternVarsWhenTrue == null) {
                this.patternVarsWhenTrue = new LocalVariableBinding[1];
                this.patternVarsWhenTrue[0] = this.elementVariable.binding;
            } else {
                this.addPatternVariablesWhenTrue(new LocalVariableBinding[]{this.elementVariable.binding});
            }
        }
    }

    @Override
    public boolean containsPatternVariable() {
        return this.elementVariable != null;
    }

    @Override
    public LocalDeclaration getPatternVariableIntroduced() {
        return this.elementVariable;
    }

    private void addSecretInstanceOfPatternExpressionValue(BlockScope blockScope) {
        LocalVariableBinding localVariableBinding = new LocalVariableBinding(SECRET_INSTANCEOF_PATTERN_EXPRESSION_VALUE, TypeBinding.wellKnownType(blockScope, 1), 0, false);
        localVariableBinding.setConstant(Constant.NotAConstant);
        localVariableBinding.useFlag = 1;
        localVariableBinding.declaration = new LocalDeclaration(SECRET_INSTANCEOF_PATTERN_EXPRESSION_VALUE, 0, 0);
        blockScope.addLocalVariable(localVariableBinding);
        this.secretInstanceOfPatternExpressionValue = localVariableBinding;
    }

    @Override
    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding;
        this.constant = Constant.NotAConstant;
        if (this.elementVariable != null) {
            this.addSecretInstanceOfPatternExpressionValue(blockScope);
        }
        this.resolvePatternVariable(blockScope);
        TypeBinding typeBinding2 = this.type.resolveType(blockScope, true);
        if (this.expression instanceof CastExpression) {
            ((CastExpression)this.expression).setInstanceofType(typeBinding2);
        }
        if ((typeBinding = this.expression.resolveType(blockScope)) != null && typeBinding2 != null && this.type.hasNullTypeAnnotation(TypeReference.AnnotationPosition.ANY) && (!typeBinding.isCompatibleWith(typeBinding2) || NullAnnotationMatching.analyse(typeBinding2, typeBinding, -1).isAnyMismatch())) {
            blockScope.problemReporter().nullAnnotationUnsupportedLocation(this.type);
        }
        if (typeBinding == null || typeBinding2 == null) {
            return null;
        }
        if (this.secretInstanceOfPatternExpressionValue != null && typeBinding != TypeBinding.NULL) {
            this.secretInstanceOfPatternExpressionValue.type = typeBinding;
        }
        if (!typeBinding2.isReifiable()) {
            boolean bl;
            CompilerOptions compilerOptions = blockScope.compilerOptions();
            if (compilerOptions.complianceLevel < 0x3C0000L) {
                blockScope.problemReporter().illegalInstanceOfGenericType(typeBinding2, this);
            } else if (!(typeBinding == TypeBinding.NULL || (bl = this.checkCastTypesCompatibility(blockScope, typeBinding2, typeBinding, this.expression, true)) && (this.bits & 0x80) == 0)) {
                blockScope.problemReporter().unsafeCastInInstanceof(this.expression, typeBinding2, typeBinding);
            }
        } else if (typeBinding2.isValidBinding() && (typeBinding != TypeBinding.NULL && typeBinding.isBaseType() || typeBinding2.isBaseType() || !this.checkCastTypesCompatibility(blockScope, typeBinding2, typeBinding, null, true))) {
            blockScope.problemReporter().notCompatibleTypesError(this, typeBinding, typeBinding2);
        }
        if (this.secretInstanceOfPatternExpressionValue != null && typeBinding.isSubtypeOf(typeBinding2, false)) {
            blockScope.problemReporter().patternCannotBeSubtypeOfExpression(this.elementVariable.binding, this);
        }
        this.resolvedType = TypeBinding.BOOLEAN;
        return this.resolvedType;
    }

    @Override
    public boolean checkUnsafeCast(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3, boolean bl) {
        if (!typeBinding.isReifiable()) {
            return CastExpression.checkUnsafeCast(this, scope, typeBinding, typeBinding2, typeBinding3, bl);
        }
        return super.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding3, bl);
    }

    @Override
    public void tagAsUnnecessaryCast(Scope scope, TypeBinding typeBinding) {
        if (this.expression.resolvedType != TypeBinding.NULL) {
            scope.problemReporter().unnecessaryInstanceof(this, typeBinding);
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, blockScope);
            if (this.elementVariable != null) {
                this.elementVariable.traverse(aSTVisitor, blockScope);
            } else {
                this.type.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

