/**
 * SECTION:individual
 * @short_description: A physical person, aggregated from the various <link linkend="FolksPersona"><type>FolksPersona</type></link>s the person might have, such as their different IM addresses or vCard entries. An individual must always contain at least one <link linkend="FolksPersona"><type>FolksPersona</type></link>.
 * 
 * <para>When choosing the values of single-valued properties (such as <link linkend="FolksIndividual--alias"><type>"alias"</type></link> and <link linkend="FolksIndividual--avatar"><type>"avatar"</type></link>; but not multi-valued properties such as <link linkend="FolksIndividual--groups"><type>"groups"</type></link> and <link linkend="FolksIndividual--im-addresses"><type>"im-addresses"</type></link>) from the <link linkend="FolksPersona"><type>FolksPersona</type></link>s in the individual to present as the values of those properties of the individual, it is guaranteed that if the individual contains a persona from the primary persona store (see <link linkend="FolksIndividualAggregator--primary-store"><type>"primary-store"</type></link>), its property values will be chosen above all others. This means that any changes to property values made through folks (which are normally written to the primary store) will always be used by <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>No further guarantees are made about the order of preference used for choosing which property values to use for the <link linkend="FolksIndividual"><type>FolksIndividual</type></link>, other than that the order may vary between properties, but is guaranteed to be stable for a given property.</para>
 */
/**
 * FOLKS_TYPE_INDIVIDUAL:
 * 
 * The type for <link linkend="FolksIndividual"><type>FolksIndividual</type></link>.
 */
/**
 * folks_individual_has_anti_link_with_persona:
 * @self: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance
 * @p: (in): &nbsp;.  <para>persona to check for anti-links with </para>
 * 
 * Anti-linked with a persona?
 * 
 * <para>Check whether this individual is anti-linked to <link linkend="FolksPersona"><type>FolksPersona</type></link> <code>p</code> at all. If so, <code>true</code> will be returned — <code>false</code> will be returned otherwise.</para><para>Note that this will check for anti-links in either direction, since anti-links are not necessarily symmetric.</para>
 * 
 * Returns: <para><code>true</code> if this individual is anti-linked with persona <code>p</code>; <code>false</code> otherwise </para>
 *
 * Since: 0.7.3
 */
/**
 * folks_individual_has_anti_link_with_individual:
 * @self: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance
 * @i: (in): &nbsp;.  <para>individual to check for anti-links with </para>
 * 
 * Anti-linked with an individual?
 * 
 * <para>Check whether this individual is anti-linked to any of the <link linkend="FolksPersona"><type>FolksPersona</type></link>s in <link linkend="FolksIndividual"><type>FolksIndividual</type></link> <code>i</code>. If so, <code>true</code> will be returned — <code>false</code> will be returned otherwise.</para><para>Note that this will check for anti-links in either direction, since anti-links are not necessarily symmetric.</para>
 * 
 * Returns: <para><code>true</code> if this individual is anti-linked with individual <code>i</code>; <code>false</code> otherwise </para>
 *
 * Since: 0.7.3
 */
/**
 * folks_individual_new:
 * @personas: (in) (allow-none): &nbsp;.  <para>a list of <link linkend="FolksPersona"><type>FolksPersona</type></link>s to initialise the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> with, or <code>null</code> </para>
 * 
 * Create a new Individual.
 * 
 * <para>The Individual can optionally be seeded with the <link linkend="FolksPersona"><type>FolksPersona</type></link>s in <code>personas</code>. Otherwise, it will have to have personas added using the <link linkend="FolksIndividual--personas"><type>"personas"</type></link> property after construction.</para>
 * 
 * Returns: <para>a new Individual </para>
 *
 * Since: 0.5.1
 */
/**
 * FolksIndividual:trust-level:
 * 
 * The trust level of the Individual.
 * 
 * <para>This specifies how far the Individual can be trusted to be who it claims to be. See the descriptions for the elements of <link linkend="FolksTrustLevel"><type>FolksTrustLevel</type></link>.</para><para>Clients should <emphasis role="bold">not</emphasis> allow linking of Individuals who have a trust level of <link linkend="FOLKS-TRUST-LEVEL-NONE"><type>FOLKS_TRUST_LEVEL_NONE</type></link>.</para>
 *
 * Since: 0.1.15
 */
/**
 * folks_individual_get_trust_level:
 * @self: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividual--trust-level"><type>"trust-level"</type></link> property.
 * 
 * The trust level of the Individual.
 * 
 * <para>This specifies how far the Individual can be trusted to be who it claims to be. See the descriptions for the elements of <link linkend="FolksTrustLevel"><type>FolksTrustLevel</type></link>.</para><para>Clients should <emphasis role="bold">not</emphasis> allow linking of Individuals who have a trust level of <link linkend="FOLKS-TRUST-LEVEL-NONE"><type>FOLKS_TRUST_LEVEL_NONE</type></link>.</para>
 * 
 * Returns: the value of the <link linkend="FolksIndividual--trust-level"><type>"trust-level"</type></link> property
 *
 * Since: 0.1.15
 */
/**
 * FolksIndividual:is-user:
 * 
 * Whether the Individual is the user.
 * 
 * <para>Iff the Individual represents the user – the person who owns the account in the backend for each <link linkend="FolksPersona"><type>FolksPersona</type></link> in the Individual – this is <code>true</code>.</para><para>It is <emphasis>not</emphasis> guaranteed that every <link linkend="FolksPersona"><type>FolksPersona</type></link> in the Individual has its <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> set to the same value as the Individual. For example, the user could own two Telepathy accounts, and have added the other account as a contact in each account. The accounts will expose a <link linkend="FolksPersona"><type>FolksPersona</type></link> for the user (which will have <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> set to <code>true</code>) <emphasis>and</emphasis> a <link linkend="FolksPersona"><type>FolksPersona</type></link> for the contact for the other account (which will have <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> set to <code>false</code>).</para><para>It is guaranteed that iff this property is set to <code>true</code> on an Individual, there will be at least one <link linkend="FolksPersona"><type>FolksPersona</type></link> in the Individual with its <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> set to <code>true</code>.</para><para>It is guaranteed that there will only ever be one Individual with this property set to <code>true</code>.</para>
 *
 * Since: 0.3.0
 */
/**
 * folks_individual_get_is_user:
 * @self: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividual--is-user"><type>"is-user"</type></link> property.
 * 
 * Whether the Individual is the user.
 * 
 * <para>Iff the Individual represents the user – the person who owns the account in the backend for each <link linkend="FolksPersona"><type>FolksPersona</type></link> in the Individual – this is <code>true</code>.</para><para>It is <emphasis>not</emphasis> guaranteed that every <link linkend="FolksPersona"><type>FolksPersona</type></link> in the Individual has its <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> set to the same value as the Individual. For example, the user could own two Telepathy accounts, and have added the other account as a contact in each account. The accounts will expose a <link linkend="FolksPersona"><type>FolksPersona</type></link> for the user (which will have <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> set to <code>true</code>) <emphasis>and</emphasis> a <link linkend="FolksPersona"><type>FolksPersona</type></link> for the contact for the other account (which will have <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> set to <code>false</code>).</para><para>It is guaranteed that iff this property is set to <code>true</code> on an Individual, there will be at least one <link linkend="FolksPersona"><type>FolksPersona</type></link> in the Individual with its <link linkend="FolksPersona--is-user"><type>"is-user"</type></link> set to <code>true</code>.</para><para>It is guaranteed that there will only ever be one Individual with this property set to <code>true</code>.</para>
 * 
 * Returns: the value of the <link linkend="FolksIndividual--is-user"><type>"is-user"</type></link> property
 *
 * Since: 0.3.0
 */
/**
 * FolksIndividual:id:
 * 
 * A unique identifier for the Individual.
 * 
 * <para>This uniquely identifies the Individual, and persists across <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instances. It may not persist across linking the Individual with other Individuals.</para><para>This is an opaque string and has no structure.</para><para>If an identifier is required which will be used for a long-lived link between different stored data, it may be more desirable to use the <link linkend="FolksPersona--uid"><type>"uid"</type></link> of the most relevant <link linkend="FolksPersona"><type>FolksPersona</type></link> in the Individual instead. For example, if storing references to Individuals who are tagged in a photo, it may be safer to store the UID of the Persona whose backend provided the photo (e.g. Facebook).</para><para>As a special case, the ID defaults to an empty string when the individual has no personas (i.e. if it’s just been constructed).</para>
 */
/**
 * folks_individual_get_id:
 * @self: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividual--id"><type>"id"</type></link> property.
 * 
 * A unique identifier for the Individual.
 * 
 * <para>This uniquely identifies the Individual, and persists across <link linkend="FolksIndividualAggregator"><type>FolksIndividualAggregator</type></link> instances. It may not persist across linking the Individual with other Individuals.</para><para>This is an opaque string and has no structure.</para><para>If an identifier is required which will be used for a long-lived link between different stored data, it may be more desirable to use the <link linkend="FolksPersona--uid"><type>"uid"</type></link> of the most relevant <link linkend="FolksPersona"><type>FolksPersona</type></link> in the Individual instead. For example, if storing references to Individuals who are tagged in a photo, it may be safer to store the UID of the Persona whose backend provided the photo (e.g. Facebook).</para><para>As a special case, the ID defaults to an empty string when the individual has no personas (i.e. if it’s just been constructed).</para>
 * 
 * Returns: the value of the <link linkend="FolksIndividual--id"><type>"id"</type></link> property
 */
/**
 * FolksIndividual:display-name:
 * 
 * The name of this Individual to display in the UI.
 * 
 * <para>This value is set according to the following list of possibilities, each one being tried first on the primary persona, then on all other personas in the Individual, before falling back to the next item on the list: # Alias # Full name, structured name or nickname # E-mail address # Phone number # Display ID (e.g. foo@example.org) # Postal address # _(&quot;Unnamed Person&quot;)</para>
 *
 * Since: 0.9.7
 */
/**
 * folks_individual_get_display_name:
 * @self: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividual--display-name"><type>"display-name"</type></link> property.
 * 
 * The name of this Individual to display in the UI.
 * 
 * <para>This value is set according to the following list of possibilities, each one being tried first on the primary persona, then on all other personas in the Individual, before falling back to the next item on the list: # Alias # Full name, structured name or nickname # E-mail address # Phone number # Display ID (e.g. foo@example.org) # Postal address # _(&quot;Unnamed Person&quot;)</para>
 * 
 * Returns: the value of the <link linkend="FolksIndividual--display-name"><type>"display-name"</type></link> property
 *
 * Since: 0.9.7
 */
/**
 * FolksIndividual:personas:
 * 
 * The set of <link linkend="FolksPersona"><type>FolksPersona</type></link>s encapsulated by this Individual.
 * 
 * <para>There must always be at least one Persona in this set.</para><para>No order is specified over the set of personas, as such an order may be different across each of the properties implemented by the personas (e.g. should they be ordered by presence, name, star sign, etc.?).</para><para>Changing the set of personas may cause updates to the aggregated properties provided by the Individual, resulting in property notifications for them.</para><para>Changing the set of personas will not cause permanent linking/unlinking of the added/removed personas to/from this Individual. To do that, call <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link> or <link linkend="folks-individual-aggregator-unlink-individual"><function>folks_individual_aggregator_unlink_individual()</function></link>, which will ensure the link changes are written to the appropriate backend.</para>
 *
 * Since: 0.5.1
 */
/**
 * folks_individual_get_personas:
 * @self: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksIndividual--personas"><type>"personas"</type></link> property.
 * 
 * The set of <link linkend="FolksPersona"><type>FolksPersona</type></link>s encapsulated by this Individual.
 * 
 * <para>There must always be at least one Persona in this set.</para><para>No order is specified over the set of personas, as such an order may be different across each of the properties implemented by the personas (e.g. should they be ordered by presence, name, star sign, etc.?).</para><para>Changing the set of personas may cause updates to the aggregated properties provided by the Individual, resulting in property notifications for them.</para><para>Changing the set of personas will not cause permanent linking/unlinking of the added/removed personas to/from this Individual. To do that, call <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link> or <link linkend="folks-individual-aggregator-unlink-individual"><function>folks_individual_aggregator_unlink_individual()</function></link>, which will ensure the link changes are written to the appropriate backend.</para>
 * 
 * Returns: the value of the <link linkend="FolksIndividual--personas"><type>"personas"</type></link> property
 *
 * Since: 0.5.1
 */
/**
 * folks_individual_set_personas:
 * @self: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksIndividual--personas"><type>"personas"</type></link> property
 * 
 * Set the value of the <link linkend="FolksIndividual--personas"><type>"personas"</type></link> property to @value.
 * 
 * The set of <link linkend="FolksPersona"><type>FolksPersona</type></link>s encapsulated by this Individual.
 * 
 * <para>There must always be at least one Persona in this set.</para><para>No order is specified over the set of personas, as such an order may be different across each of the properties implemented by the personas (e.g. should they be ordered by presence, name, star sign, etc.?).</para><para>Changing the set of personas may cause updates to the aggregated properties provided by the Individual, resulting in property notifications for them.</para><para>Changing the set of personas will not cause permanent linking/unlinking of the added/removed personas to/from this Individual. To do that, call <link linkend="folks-individual-aggregator-link-personas"><function>folks_individual_aggregator_link_personas()</function></link> or <link linkend="folks-individual-aggregator-unlink-individual"><function>folks_individual_aggregator_unlink_individual()</function></link>, which will ensure the link changes are written to the appropriate backend.</para>
 *
 * Since: 0.5.1
 */
/**
 * FolksIndividual::removed:
 * @individual: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance that received the signal
 * @replacement_individual: &nbsp;.  <para>the individual which has replaced this one due to linking, or <code>null</code> if this individual was removed for another reason </para><para></para>
 * 
 * Emitted when the last of the Individual&apos;s <link linkend="FolksPersona"><type>FolksPersona</type></link>s has been removed.
 * 
 * <para>At this point, the Individual is invalid, so any client referencing it should unreference it and remove it from their UI.</para>
 *
 * Since: 0.1.13
 */
/**
 * FolksIndividual::personas-changed:
 * @individual: the <link linkend="FolksIndividual"><type>FolksIndividual</type></link> instance that received the signal
 * @added: &nbsp;.  <para>a set of <link linkend="FolksPersona"><type>FolksPersona</type></link>s which have been added </para><para></para>
 * @removed: &nbsp;.  <para>a set of <link linkend="FolksPersona"><type>FolksPersona</type></link>s which have been removed </para><para></para>
 * 
 * Emitted when one or more <link linkend="FolksPersona"><type>FolksPersona</type></link>s are added to or removed from the Individual. As the parameters are (unordered) sets, the orders of their elements are undefined.
 *
 * Since: 0.5.1
 */
/**
 * FolksIndividual:
 * 
 * A physical person, aggregated from the various <link linkend="FolksPersona"><type>FolksPersona</type></link>s the person might have, such as their different IM addresses or vCard entries. An individual must always contain at least one <link linkend="FolksPersona"><type>FolksPersona</type></link>.
 * 
 * <para>When choosing the values of single-valued properties (such as <link linkend="FolksIndividual--alias"><type>"alias"</type></link> and <link linkend="FolksIndividual--avatar"><type>"avatar"</type></link>; but not multi-valued properties such as <link linkend="FolksIndividual--groups"><type>"groups"</type></link> and <link linkend="FolksIndividual--im-addresses"><type>"im-addresses"</type></link>) from the <link linkend="FolksPersona"><type>FolksPersona</type></link>s in the individual to present as the values of those properties of the individual, it is guaranteed that if the individual contains a persona from the primary persona store (see <link linkend="FolksIndividualAggregator--primary-store"><type>"primary-store"</type></link>), its property values will be chosen above all others. This means that any changes to property values made through folks (which are normally written to the primary store) will always be used by <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s.</para><para>No further guarantees are made about the order of preference used for choosing which property values to use for the <link linkend="FolksIndividual"><type>FolksIndividual</type></link>, other than that the order may vary between properties, but is guaranteed to be stable for a given property.</para>
 */
/**
 * FolksIndividualClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-INDIVIDUAL:CAPS"><literal>FOLKS_TYPE_INDIVIDUAL</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * FolksTrustLevel:
 * @FOLKS_TRUST_LEVEL_NONE: The <link linkend="FolksIndividual"><type>FolksIndividual</type></link>&apos;s <link linkend="FolksPersona"><type>FolksPersona</type></link>s aren&apos;t trusted at all.<para>This is the trust level for an <link linkend="FolksIndividual"><type>FolksIndividual</type></link> which contains one or more <link linkend="FolksPersona"><type>FolksPersona</type></link>s which cannot be guaranteed to be the same <link linkend="FolksPersona"><type>FolksPersona</type></link>s as were originally linked together.</para><para>For example, an <link linkend="FolksIndividual"><type>FolksIndividual</type></link> containing a link-local XMPP <link linkend="FolksPersona"><type>FolksPersona</type></link> would have this trust level, since someone else could easily spoof the link-local XMPP <link linkend="FolksPersona"><type>FolksPersona</type></link>&apos;s identity.</para>
 * @FOLKS_TRUST_LEVEL_PERSONAS: The <link linkend="FolksIndividual"><type>FolksIndividual</type></link>&apos;s <link linkend="FolksPersona"><type>FolksPersona</type></link>s are trusted.<para>This trust level is for <link linkend="FolksIndividual"><type>FolksIndividual</type></link>s where it can be guaranteed that all the <link linkend="FolksPersona"><type>FolksPersona</type></link>s are the same ones as when they were originally linked together.</para><para>Note that this doesn&apos;t guarantee that the user who behind each <link linkend="FolksPersona"><type>FolksPersona</type></link> is who they claim to be.</para>
 * 
 * Trust level for an <link linkend="FolksIndividual"><type>FolksIndividual</type></link> for use in the UI.
 *
 * Since: 0.1.15
 */
