/* window.c generated by valac 0.56.3, the Vala compiler
 * generated from window.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "config.h"
#include <libgweather/gweather.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_TYPE_WINDOW (clocks_window_get_type ())
#define CLOCKS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_WINDOW, ClocksWindow))
#define CLOCKS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_WINDOW, ClocksWindowClass))
#define CLOCKS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_WINDOW))
#define CLOCKS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_WINDOW))
#define CLOCKS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_WINDOW, ClocksWindowClass))

typedef struct _ClocksWindow ClocksWindow;
typedef struct _ClocksWindowClass ClocksWindowClass;
typedef struct _ClocksWindowPrivate ClocksWindowPrivate;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;

#define CLOCKS_WORLD_TYPE_FACE (clocks_world_face_get_type ())
#define CLOCKS_WORLD_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFace))
#define CLOCKS_WORLD_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))
#define CLOCKS_WORLD_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_FACE))
#define CLOCKS_WORLD_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_FACE, ClocksWorldFaceClass))

typedef struct _ClocksWorldFace ClocksWorldFace;
typedef struct _ClocksWorldFaceClass ClocksWorldFaceClass;

#define CLOCKS_ALARM_TYPE_FACE (clocks_alarm_face_get_type ())
#define CLOCKS_ALARM_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFace))
#define CLOCKS_ALARM_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFaceClass))
#define CLOCKS_ALARM_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_FACE))
#define CLOCKS_ALARM_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_FACE))
#define CLOCKS_ALARM_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_FACE, ClocksAlarmFaceClass))

typedef struct _ClocksAlarmFace ClocksAlarmFace;
typedef struct _ClocksAlarmFaceClass ClocksAlarmFaceClass;

#define CLOCKS_WORLD_TYPE_STANDALONE (clocks_world_standalone_get_type ())
#define CLOCKS_WORLD_STANDALONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_STANDALONE, ClocksWorldStandalone))
#define CLOCKS_WORLD_STANDALONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_STANDALONE, ClocksWorldStandaloneClass))
#define CLOCKS_WORLD_IS_STANDALONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_STANDALONE))
#define CLOCKS_WORLD_IS_STANDALONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_STANDALONE))
#define CLOCKS_WORLD_STANDALONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_STANDALONE, ClocksWorldStandaloneClass))

typedef struct _ClocksWorldStandalone ClocksWorldStandalone;
typedef struct _ClocksWorldStandaloneClass ClocksWorldStandaloneClass;

#define CLOCKS_ALARM_TYPE_RINGING_PANEL (clocks_alarm_ringing_panel_get_type ())
#define CLOCKS_ALARM_RINGING_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanel))
#define CLOCKS_ALARM_RINGING_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanelClass))
#define CLOCKS_ALARM_IS_RINGING_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_RINGING_PANEL))
#define CLOCKS_ALARM_IS_RINGING_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_RINGING_PANEL))
#define CLOCKS_ALARM_RINGING_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_RINGING_PANEL, ClocksAlarmRingingPanelClass))

typedef struct _ClocksAlarmRingingPanel ClocksAlarmRingingPanel;
typedef struct _ClocksAlarmRingingPanelClass ClocksAlarmRingingPanelClass;

#define CLOCKS_STOPWATCH_TYPE_FACE (clocks_stopwatch_face_get_type ())
#define CLOCKS_STOPWATCH_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFace))
#define CLOCKS_STOPWATCH_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFaceClass))
#define CLOCKS_STOPWATCH_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_STOPWATCH_TYPE_FACE))
#define CLOCKS_STOPWATCH_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_STOPWATCH_TYPE_FACE))
#define CLOCKS_STOPWATCH_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_STOPWATCH_TYPE_FACE, ClocksStopwatchFaceClass))

typedef struct _ClocksStopwatchFace ClocksStopwatchFace;
typedef struct _ClocksStopwatchFaceClass ClocksStopwatchFaceClass;

#define CLOCKS_TIMER_TYPE_FACE (clocks_timer_face_get_type ())
#define CLOCKS_TIMER_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace))
#define CLOCKS_TIMER_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFaceClass))
#define CLOCKS_TIMER_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_FACE))
#define CLOCKS_TIMER_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_FACE))
#define CLOCKS_TIMER_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFaceClass))

typedef struct _ClocksTimerFace ClocksTimerFace;
typedef struct _ClocksTimerFaceClass ClocksTimerFaceClass;
enum  {
	CLOCKS_WINDOW_0_PROPERTY,
	CLOCKS_WINDOW_NUM_PROPERTIES
};
static GParamSpec* clocks_window_properties[CLOCKS_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_TYPE_APPLICATION (clocks_application_get_type ())
#define CLOCKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplication))
#define CLOCKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))
#define CLOCKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_APPLICATION))
#define CLOCKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_APPLICATION, ClocksApplicationClass))

typedef struct _ClocksApplication ClocksApplication;
typedef struct _ClocksApplicationClass ClocksApplicationClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define CLOCKS_WORLD_TYPE_ITEM (clocks_world_item_get_type ())
#define CLOCKS_WORLD_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItem))
#define CLOCKS_WORLD_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))
#define CLOCKS_WORLD_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_WORLD_TYPE_ITEM))
#define CLOCKS_WORLD_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_WORLD_TYPE_ITEM, ClocksWorldItemClass))

typedef struct _ClocksWorldItem ClocksWorldItem;
typedef struct _ClocksWorldItemClass ClocksWorldItemClass;

#define CLOCKS_ALARM_TYPE_ITEM (clocks_alarm_item_get_type ())
#define CLOCKS_ALARM_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItem))
#define CLOCKS_ALARM_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))
#define CLOCKS_ALARM_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_ITEM))
#define CLOCKS_ALARM_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_ITEM, ClocksAlarmItemClass))

typedef struct _ClocksAlarmItem ClocksAlarmItem;
typedef struct _ClocksAlarmItemClass ClocksAlarmItemClass;
typedef enum  {
	CLOCKS_STOPWATCH_FACE_STATE_RESET,
	CLOCKS_STOPWATCH_FACE_STATE_RUNNING,
	CLOCKS_STOPWATCH_FACE_STATE_STOPPED
} ClocksStopwatchFaceState;

#define CLOCKS_STOPWATCH_FACE_TYPE_STATE (clocks_stopwatch_face_state_get_type ())

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;
typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())
typedef enum  {
	CLOCKS_BUTTON_MODE_NEW,
	CLOCKS_BUTTON_MODE_NONE
} ClocksButtonMode;

#define CLOCKS_TYPE_BUTTON_MODE (clocks_button_mode_get_type ())
enum  {
	CLOCKS_WINDOW_CHANGE_PAGE_SIGNAL,
	CLOCKS_WINDOW_SET_PAGE_SIGNAL,
	CLOCKS_WINDOW_NUM_SIGNALS
};
static guint clocks_window_signals[CLOCKS_WINDOW_NUM_SIGNALS] = {0};

struct _ClocksWindow {
	AdwApplicationWindow parent_instance;
	ClocksWindowPrivate * priv;
};

struct _ClocksWindowClass {
	AdwApplicationWindowClass parent_class;
	void (*change_page) (ClocksWindow* self, gint offset);
	void (*set_page) (ClocksWindow* self, const gchar* page);
};

struct _ClocksWindowPrivate {
	ClocksHeaderBar* header_bar;
	AdwLeaflet* alarm_leaflet;
	AdwLeaflet* world_leaflet;
	GtkBox* main_view;
	AdwViewStack* stack;
	ClocksWorldFace* world;
	ClocksAlarmFace* alarm;
	ClocksWorldStandalone* world_standalone;
	ClocksAlarmRingingPanel* alarm_ringing_panel;
	ClocksStopwatchFace* stopwatch;
	ClocksTimerFace* timer;
	GSettings* settings;
	GBinding* bind_button_mode;
	GBinding* bind_new_label;
	gboolean inited;
};

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
	ClocksButtonMode (*get_button_mode) (ClocksClock* self);
	void (*set_button_mode) (ClocksClock* self, ClocksButtonMode value);
	const gchar* (*get_new_label) (ClocksClock* self);
};

static gint ClocksWindow_private_offset;
static gpointer clocks_window_parent_class = NULL;

VALA_EXTERN GType clocks_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWindow, g_object_unref)
VALA_EXTERN GType clocks_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksHeaderBar, g_object_unref)
VALA_EXTERN GType clocks_world_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldFace, g_object_unref)
VALA_EXTERN GType clocks_alarm_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmFace, g_object_unref)
VALA_EXTERN GType clocks_world_standalone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldStandalone, g_object_unref)
VALA_EXTERN GType clocks_alarm_ringing_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmRingingPanel, g_object_unref)
VALA_EXTERN GType clocks_stopwatch_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksStopwatchFace, g_object_unref)
VALA_EXTERN GType clocks_timer_face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksTimerFace, g_object_unref)
static void clocks_window_on_show_primary_menu_activate (ClocksWindow* self);
static void _clocks_window_on_show_primary_menu_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
static void clocks_window_on_new_activate (ClocksWindow* self);
static void _clocks_window_on_new_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void clocks_window_on_back_activate (ClocksWindow* self);
static void _clocks_window_on_back_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void clocks_window_on_help_activate (ClocksWindow* self);
static void _clocks_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void clocks_window_on_navigate_forward (ClocksWindow* self);
static void _clocks_window_on_navigate_forward_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void clocks_window_on_navigate_backward (ClocksWindow* self);
static void _clocks_window_on_navigate_backward_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void clocks_window_on_about_activate (ClocksWindow* self);
static void _clocks_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
VALA_EXTERN GType clocks_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksApplication, g_object_unref)
VALA_EXTERN ClocksWindow* clocks_window_new (ClocksApplication* app);
VALA_EXTERN ClocksWindow* clocks_window_construct (GType object_type,
                                       ClocksApplication* app);
static void clocks_window_pane_changed (ClocksWindow* self);
static void clocks_window_load_window_state (ClocksWindow* self);
VALA_EXTERN GType clocks_world_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksWorldItem, g_object_unref)
static void __lambda49_ (ClocksWindow* self,
                  ClocksWorldFace* w,
                  ClocksWorldItem* l);
VALA_EXTERN void clocks_world_standalone_set_location (ClocksWorldStandalone* self,
                                           ClocksWorldItem* value);
static void ___lambda49__clocks_world_face_show_standalone (ClocksWorldFace* _sender,
                                                     ClocksWorldItem* location,
                                                     gpointer self);
VALA_EXTERN GType clocks_alarm_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmItem, g_object_unref)
static void __lambda50_ (ClocksWindow* self,
                  ClocksAlarmFace* w,
                  ClocksAlarmItem* a);
static void clocks_window_close_standalone (ClocksWindow* self);
VALA_EXTERN void clocks_alarm_ringing_panel_set_alarm (ClocksAlarmRingingPanel* self,
                                           ClocksAlarmItem* value);
static void ___lambda50__clocks_alarm_face_ring (ClocksAlarmFace* _sender,
                                          ClocksAlarmItem* item,
                                          gpointer self);
static void __lambda51_ (ClocksWindow* self,
                  GParamSpec* w);
VALA_EXTERN GType clocks_stopwatch_face_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ClocksStopwatchFaceState clocks_stopwatch_face_get_state (ClocksStopwatchFace* self);
static void ___lambda51__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda52_ (ClocksWindow* self,
                  ClocksTimerFace* w);
static void ___lambda52__clocks_timer_face_ring (ClocksTimerFace* _sender,
                                          gpointer self);
static void __lambda53_ (ClocksWindow* self,
                  GParamSpec* w);
VALA_EXTERN gboolean clocks_timer_face_get_is_running (ClocksTimerFace* self);
static void ___lambda53__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void clocks_header_bar_show_primary_menu (ClocksHeaderBar* self);
VALA_EXTERN GType clocks_panel_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_button_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType clocks_clock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksClock, g_object_unref)
VALA_EXTERN void clocks_clock_activate_new (ClocksClock* self);
VALA_EXTERN void clocks_window_show_world (ClocksWindow* self);
VALA_EXTERN void clocks_window_add_world_location (ClocksWindow* self,
                                       GWeatherLocation* location);
VALA_EXTERN void clocks_world_face_add_location (ClocksWorldFace* self,
                                     GWeatherLocation* location);
static gboolean clocks_window_real_close_request (GtkWindow* base);
static void clocks_window_save_window_state (ClocksWindow* self);
static void clocks_window_on_window_active (ClocksWindow* self);
VALA_EXTERN void clocks_application_withdraw_notifications (ClocksApplication* self);
static void _clocks_window_on_window_active_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static gboolean clocks_window_key_press_cb (ClocksWindow* self,
                                     GtkEventControllerKey* controller,
                                     guint keyval,
                                     guint keycode,
                                     GdkModifierType mod_state);
VALA_EXTERN gboolean clocks_clock_escape_pressed (ClocksClock* self);
static gboolean _clocks_window_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                           guint keyval,
                                                                           guint keycode,
                                                                           GdkModifierType state,
                                                                           gpointer self);
static gchar** _vala_array_dup5 (gchar** self,
                          gssize length);
VALA_EXTERN ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
static void _clocks_window_pane_changed_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
static void clocks_window_visible_child_changed (ClocksWindow* self);
VALA_EXTERN const gchar* clocks_world_standalone_get_title (ClocksWorldStandalone* self);
static void _clocks_window_visible_child_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void clocks_window_alarm_dismissed (ClocksWindow* self);
static void _clocks_window_alarm_dismissed_clocks_alarm_ringing_panel_dismiss (ClocksAlarmRingingPanel* _sender,
                                                                        gpointer self);
static void clocks_window_on_set_page (ClocksWindow* self,
                                const gchar* action_name,
                                GVariant* param);
static void clocks_window_real_change_page (ClocksWindow* self,
                                     gint offset);
static void clocks_window_real_set_page (ClocksWindow* self,
                                  const gchar* page);
static GObject * clocks_window_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void clocks_window_finalize (GObject * obj);
static GType clocks_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry CLOCKS_WINDOW_ACTION_ENTRIES[7] = {{"show-primary-menu", _clocks_window_on_show_primary_menu_activate_gsimple_action_activate_callback}, {"new", _clocks_window_on_new_activate_gsimple_action_activate_callback}, {"back", _clocks_window_on_back_activate_gsimple_action_activate_callback}, {"help", _clocks_window_on_help_activate_gsimple_action_activate_callback}, {"navigate-forward", _clocks_window_on_navigate_forward_gsimple_action_activate_callback}, {"navigate-backward", _clocks_window_on_navigate_backward_gsimple_action_activate_callback}, {"about", _clocks_window_on_about_activate_gsimple_action_activate_callback}};

static inline gpointer
clocks_window_get_instance_private (ClocksWindow* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksWindow_private_offset);
}

static void
_clocks_window_on_show_primary_menu_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	clocks_window_on_show_primary_menu_activate ((ClocksWindow*) self);
}

static void
_clocks_window_on_new_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	clocks_window_on_new_activate ((ClocksWindow*) self);
}

static void
_clocks_window_on_back_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	clocks_window_on_back_activate ((ClocksWindow*) self);
}

static void
_clocks_window_on_help_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	clocks_window_on_help_activate ((ClocksWindow*) self);
}

static void
_clocks_window_on_navigate_forward_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	clocks_window_on_navigate_forward ((ClocksWindow*) self);
}

static void
_clocks_window_on_navigate_backward_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	clocks_window_on_navigate_backward ((ClocksWindow*) self);
}

static void
_clocks_window_on_about_activate_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	clocks_window_on_about_activate ((ClocksWindow*) self);
}

static void
__lambda49_ (ClocksWindow* self,
             ClocksWorldFace* w,
             ClocksWorldItem* l)
{
	AdwViewStack* _tmp0_;
	ClocksWorldStandalone* _tmp1_;
	AdwLeaflet* _tmp2_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (l != NULL);
	_tmp0_ = self->priv->stack;
	adw_view_stack_set_visible_child (_tmp0_, (GtkWidget*) w);
	_tmp1_ = self->priv->world_standalone;
	clocks_world_standalone_set_location (_tmp1_, l);
	_tmp2_ = self->priv->world_leaflet;
	adw_leaflet_navigate (_tmp2_, ADW_NAVIGATION_DIRECTION_FORWARD);
}

static void
___lambda49__clocks_world_face_show_standalone (ClocksWorldFace* _sender,
                                                ClocksWorldItem* location,
                                                gpointer self)
{
	__lambda49_ ((ClocksWindow*) self, _sender, location);
}

static void
__lambda50_ (ClocksWindow* self,
             ClocksAlarmFace* w,
             ClocksAlarmItem* a)
{
	AdwViewStack* _tmp0_;
	ClocksAlarmRingingPanel* _tmp1_;
	AdwLeaflet* _tmp2_;
	ClocksAlarmRingingPanel* _tmp3_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (a != NULL);
	clocks_window_close_standalone (self);
	_tmp0_ = self->priv->stack;
	adw_view_stack_set_visible_child (_tmp0_, (GtkWidget*) w);
	_tmp1_ = self->priv->alarm_ringing_panel;
	clocks_alarm_ringing_panel_set_alarm (_tmp1_, a);
	_tmp2_ = self->priv->alarm_leaflet;
	_tmp3_ = self->priv->alarm_ringing_panel;
	adw_leaflet_set_visible_child (_tmp2_, (GtkWidget*) _tmp3_);
}

static void
___lambda50__clocks_alarm_face_ring (ClocksAlarmFace* _sender,
                                     ClocksAlarmItem* item,
                                     gpointer self)
{
	__lambda50_ ((ClocksWindow*) self, _sender, item);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda51_ (ClocksWindow* self,
             GParamSpec* w)
{
	AdwViewStackPage* stopwatch_stack_page = NULL;
	AdwViewStack* _tmp0_;
	ClocksStopwatchFace* _tmp1_;
	AdwViewStackPage* _tmp2_;
	AdwViewStackPage* _tmp3_;
	ClocksStopwatchFace* _tmp4_;
	ClocksStopwatchFaceState _tmp5_;
	ClocksStopwatchFaceState _tmp6_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->stopwatch;
	_tmp2_ = adw_view_stack_get_page (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	stopwatch_stack_page = _tmp3_;
	_tmp4_ = self->priv->stopwatch;
	_tmp5_ = clocks_stopwatch_face_get_state (_tmp4_);
	_tmp6_ = _tmp5_;
	adw_view_stack_page_set_needs_attention (stopwatch_stack_page, _tmp6_ == CLOCKS_STOPWATCH_FACE_STATE_RUNNING);
	_g_object_unref0 (stopwatch_stack_page);
}

static void
___lambda51__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda51_ ((ClocksWindow*) self, pspec);
}

static void
__lambda52_ (ClocksWindow* self,
             ClocksTimerFace* w)
{
	AdwViewStack* _tmp0_;
	g_return_if_fail (w != NULL);
	clocks_window_close_standalone (self);
	_tmp0_ = self->priv->stack;
	adw_view_stack_set_visible_child (_tmp0_, (GtkWidget*) w);
}

static void
___lambda52__clocks_timer_face_ring (ClocksTimerFace* _sender,
                                     gpointer self)
{
	__lambda52_ ((ClocksWindow*) self, _sender);
}

static void
__lambda53_ (ClocksWindow* self,
             GParamSpec* w)
{
	AdwViewStackPage* timer_stack_page = NULL;
	AdwViewStack* _tmp0_;
	ClocksTimerFace* _tmp1_;
	AdwViewStackPage* _tmp2_;
	AdwViewStackPage* _tmp3_;
	ClocksTimerFace* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->timer;
	_tmp2_ = adw_view_stack_get_page (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	timer_stack_page = _tmp3_;
	_tmp4_ = self->priv->timer;
	_tmp5_ = clocks_timer_face_get_is_running (_tmp4_);
	_tmp6_ = _tmp5_;
	adw_view_stack_page_set_needs_attention (timer_stack_page, _tmp6_);
	_g_object_unref0 (timer_stack_page);
}

static void
___lambda53__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda53_ ((ClocksWindow*) self, pspec);
}

ClocksWindow*
clocks_window_construct (GType object_type,
                         ClocksApplication* app)
{
	ClocksWindow * self = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	AdwViewStack* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ClocksWorldFace* _tmp6_;
	ClocksAlarmFace* _tmp7_;
	ClocksStopwatchFace* _tmp8_;
	ClocksTimerFace* _tmp9_;
	ClocksTimerFace* _tmp10_;
	g_return_val_if_fail (app != NULL, NULL);
	self = (ClocksWindow*) g_object_new (object_type, "application", app, NULL);
	g_action_map_add_action_entries ((GActionMap*) self, CLOCKS_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (CLOCKS_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = g_settings_new ("org.gnome.clocks.state.window");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_settings_delay (_tmp1_);
	_tmp2_ = self->priv->stack;
	_tmp3_ = self->priv->settings;
	_tmp4_ = g_settings_get_string (_tmp3_, "panel-id");
	_tmp5_ = _tmp4_;
	adw_view_stack_set_visible_child_name (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	self->priv->inited = TRUE;
	clocks_window_pane_changed (self);
	clocks_window_load_window_state (self);
	_tmp6_ = self->priv->world;
	g_signal_connect_object (_tmp6_, "show-standalone", (GCallback) ___lambda49__clocks_world_face_show_standalone, self, 0);
	_tmp7_ = self->priv->alarm;
	g_signal_connect_object (_tmp7_, "ring", (GCallback) ___lambda50__clocks_alarm_face_ring, self, 0);
	_tmp8_ = self->priv->stopwatch;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::state", (GCallback) ___lambda51__g_object_notify, self, 0);
	_tmp9_ = self->priv->timer;
	g_signal_connect_object (_tmp9_, "ring", (GCallback) ___lambda52__clocks_timer_face_ring, self, 0);
	_tmp10_ = self->priv->timer;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::is-running", (GCallback) ___lambda53__g_object_notify, self, 0);
	if (g_strcmp0 (PROFILE, "Devel") == 0) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	return self;
}

ClocksWindow*
clocks_window_new (ClocksApplication* app)
{
	return clocks_window_construct (CLOCKS_TYPE_WINDOW, app);
}

static void
clocks_window_on_show_primary_menu_activate (ClocksWindow* self)
{
	ClocksHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->header_bar;
	clocks_header_bar_show_primary_menu (_tmp0_);
}

static void
clocks_window_on_new_activate (ClocksWindow* self)
{
	AdwViewStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = adw_view_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	clocks_clock_activate_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CLOCKS_TYPE_CLOCK, ClocksClock));
}

static void
clocks_window_on_back_activate (ClocksWindow* self)
{
	AdwLeaflet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->world_leaflet;
	adw_leaflet_navigate (_tmp0_, ADW_NAVIGATION_DIRECTION_BACK);
}

void
clocks_window_show_world (ClocksWindow* self)
{
	AdwViewStack* _tmp0_;
	ClocksWorldFace* _tmp1_;
	g_return_if_fail (self != NULL);
	clocks_window_close_standalone (self);
	_tmp0_ = self->priv->stack;
	_tmp1_ = self->priv->world;
	adw_view_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
}

void
clocks_window_add_world_location (ClocksWindow* self,
                                  GWeatherLocation* location)
{
	ClocksWorldFace* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->world;
	clocks_world_face_add_location (_tmp0_, location);
}

static gboolean
clocks_window_real_close_request (GtkWindow* base)
{
	ClocksWindow * self;
	gboolean result;
	self = (ClocksWindow*) base;
	clocks_window_save_window_state (self);
	result = GTK_WINDOW_CLASS (clocks_window_parent_class)->close_request ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow));
	return result;
}

static void
clocks_window_load_window_state (ClocksWindow* self)
{
	gboolean window_maximized = FALSE;
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	window_maximized = g_settings_get_boolean (_tmp0_, "maximized");
	if (window_maximized) {
		gtk_window_maximize ((GtkWindow*) self);
	} else {
		gint width = 0;
		gint height = 0;
		GSettings* _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp1_ = self->priv->settings;
		g_settings_get (_tmp1_, "size", "(ii)", &_tmp2_, &_tmp3_);
		width = _tmp2_;
		height = _tmp3_;
		gtk_window_set_default_size ((GtkWindow*) self, width, height);
	}
}

static void
clocks_window_save_window_state (ClocksWindow* self)
{
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	width = 0;
	height = 0;
	gtk_window_get_default_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	g_debug ("window.vala:223: Saving window geometry: %i × %i", width, height);
	_tmp2_ = self->priv->settings;
	g_settings_set (_tmp2_, "size", "(ii)", width, height);
	_tmp3_ = self->priv->settings;
	g_settings_set_boolean (_tmp3_, "maximized", gtk_window_is_maximized ((GtkWindow*) self));
	_tmp4_ = self->priv->settings;
	g_settings_apply (_tmp4_);
}

static void
clocks_window_on_window_active (ClocksWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_object_get ((GtkWindow*) self, "is-active", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkApplication* _tmp2_;
		GtkApplication* _tmp3_;
		_tmp2_ = gtk_window_get_application ((GtkWindow*) self);
		_tmp3_ = _tmp2_;
		clocks_application_withdraw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, CLOCKS_TYPE_APPLICATION, ClocksApplication));
	}
}

static void
_clocks_window_on_window_active_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	clocks_window_on_window_active ((ClocksWindow*) self);
}

static gboolean
clocks_window_key_press_cb (ClocksWindow* self,
                            GtkEventControllerKey* controller,
                            guint keyval,
                            guint keycode,
                            GdkModifierType mod_state)
{
	gboolean handled = FALSE;
	GdkModifierType state = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (controller != NULL, FALSE);
	handled = FALSE;
	state = mod_state & (GDK_CONTROL_MASK | GDK_ALT_MASK);
	if (keyval == GDK_KEY_Escape) {
		_tmp0_ = state == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AdwLeaflet* _tmp1_;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkBox* _tmp4_;
		_tmp1_ = self->priv->world_leaflet;
		_tmp2_ = adw_leaflet_get_visible_child (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->main_view;
		if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
			AdwViewStack* _tmp5_;
			GtkWidget* _tmp6_;
			GtkWidget* _tmp7_;
			_tmp5_ = self->priv->stack;
			_tmp6_ = adw_view_stack_get_visible_child (_tmp5_);
			_tmp7_ = _tmp6_;
			handled = clocks_clock_escape_pressed (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, CLOCKS_TYPE_CLOCK, ClocksClock));
		} else {
			AdwLeaflet* _tmp8_;
			_tmp8_ = self->priv->world_leaflet;
			adw_leaflet_navigate (_tmp8_, ADW_NAVIGATION_DIRECTION_BACK);
		}
	}
	result = handled;
	return result;
}

static gboolean
_clocks_window_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                  guint keyval,
                                                                  guint keycode,
                                                                  GdkModifierType state,
                                                                  gpointer self)
{
	gboolean result;
	result = clocks_window_key_press_cb ((ClocksWindow*) self, _sender, keyval, keycode, state);
	return result;
}

static void
clocks_window_on_help_activate (ClocksWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_show_uri ((GtkWindow*) self, "help:gnome-clocks", (guint32) GDK_CURRENT_TIME);
}

static gchar**
_vala_array_dup5 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
clocks_window_on_about_activate (ClocksWindow* self)
{
	static const char COPYRIGHT[] = "\xc2\xa9 2011 Collabora Ltd.\n" "\xc2\xa9 2012-2013 Collabora Ltd., Seif Lotfy, Emily Gonyer, " "Eslam Mostafa, Paolo Borelli, Volker Sobek\n" "\xc2\xa9 2019-2020 Bilal Elmoussaoui &amp; Zander Brown et al";
	static const gchar* DEVELOPERS[16] = {"Alex Anthony", "Paolo Borelli", "Allan Day", "Piotr Drąg", "Emily Gonyer", "Evgeny Bobkin", "Maël Lavault", "Seif Lotfy", "William Jon McCann", "Eslam Mostafa", "Bastien Nocera", "Volker Sobek", "Jakub Steiner", "Bilal Elmoussaoui", "Zander Brown", NULL};
	AdwAboutWindow* about = NULL;
	GtkWindow* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* _tmp8_;
	AdwAboutWindow* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 ((GtkWindow*) self);
	_tmp1_ = g_strdup (_ ("Clocks"));
	_tmp2_ = g_strdup (APP_ID);
	_tmp3_ = g_strdup (_ ("The GNOME Project"));
	_tmp4_ = g_strdup (VERSION);
	_tmp5_ = g_strdup (COPYRIGHT);
	_tmp6_ = _vala_array_dup5 (DEVELOPERS, G_N_ELEMENTS (DEVELOPERS));
	_tmp6__length1 = G_N_ELEMENTS (DEVELOPERS);
	_tmp7_ = g_strdup ("https://gitlab.gnome.org/GNOME/gnome-clocks/-/issues/new");
	_tmp8_ = g_strdup (_ ("translator-credits"));
	_tmp9_ = (AdwAboutWindow*) adw_about_window_new ();
	gtk_window_set_transient_for ((GtkWindow*) _tmp9_, _tmp0_);
	_g_object_unref0 (_tmp0_);
	adw_about_window_set_application_name (_tmp9_, _tmp1_);
	_g_free0 (_tmp1_);
	adw_about_window_set_application_icon (_tmp9_, _tmp2_);
	_g_free0 (_tmp2_);
	adw_about_window_set_developer_name (_tmp9_, _tmp3_);
	_g_free0 (_tmp3_);
	adw_about_window_set_version (_tmp9_, _tmp4_);
	_g_free0 (_tmp4_);
	adw_about_window_set_copyright (_tmp9_, _tmp5_);
	_g_free0 (_tmp5_);
	adw_about_window_set_developers (_tmp9_, _tmp6_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	adw_about_window_set_issue_url (_tmp9_, _tmp7_);
	_g_free0 (_tmp7_);
	adw_about_window_set_license_type (_tmp9_, GTK_LICENSE_GPL_2_0);
	adw_about_window_set_translator_credits (_tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	about = _tmp9_;
	gtk_window_present ((GtkWindow*) about);
	_g_object_unref0 (about);
}

static void
clocks_window_pane_changed (ClocksWindow* self)
{
	GtkShortcutsWindow* help_overlay = NULL;
	GtkShortcutsWindow* _tmp0_;
	GtkShortcutsWindow* _tmp1_;
	ClocksClock* panel = NULL;
	AdwViewStack* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	ClocksClock* _tmp5_;
	AdwViewStack* _tmp6_;
	GtkShortcutsWindow* _tmp7_;
	ClocksClock* _tmp8_;
	const gchar* _tmp9_;
	GBinding* _tmp14_;
	ClocksClock* _tmp17_;
	ClocksHeaderBar* _tmp18_;
	GBinding* _tmp19_;
	GBinding* _tmp20_;
	GBinding* _tmp21_;
	ClocksClock* _tmp24_;
	ClocksHeaderBar* _tmp25_;
	GBinding* _tmp26_;
	GBinding* _tmp27_;
	AdwViewStack* _tmp28_;
	GtkWidget* _tmp29_;
	GtkWidget* _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_window_get_help_overlay ((GtkApplicationWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	help_overlay = _tmp1_;
	_tmp2_ = self->priv->stack;
	_tmp3_ = adw_view_stack_get_visible_child (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, CLOCKS_TYPE_CLOCK, ClocksClock));
	panel = _tmp5_;
	_tmp6_ = self->priv->stack;
	if (gtk_widget_in_destruction ((GtkWidget*) _tmp6_)) {
		_g_object_unref0 (panel);
		_g_object_unref0 (help_overlay);
		return;
	}
	_tmp7_ = help_overlay;
	_tmp8_ = panel;
	_tmp9_ = g_type_name (G_TYPE_FROM_INSTANCE (_tmp8_));
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_shortcuts_window_get_type (), GtkShortcutsWindow), "view-name", _tmp9_, NULL);
	if (self->priv->inited) {
		GSettings* _tmp10_;
		ClocksClock* _tmp11_;
		ClocksPanelId _tmp12_;
		ClocksPanelId _tmp13_;
		_tmp10_ = self->priv->settings;
		_tmp11_ = panel;
		_tmp12_ = clocks_clock_get_panel_id (_tmp11_);
		_tmp13_ = _tmp12_;
		g_settings_set_enum (_tmp10_, "panel-id", (gint) _tmp13_);
	}
	_tmp14_ = self->priv->bind_button_mode;
	if (_tmp14_ != NULL) {
		GBinding* _tmp15_;
		GBinding* _tmp16_;
		_tmp15_ = self->priv->bind_button_mode;
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, G_TYPE_BINDING, GBinding));
		g_binding_unbind (_tmp16_);
	}
	_tmp17_ = panel;
	_tmp18_ = self->priv->header_bar;
	_tmp19_ = g_object_bind_property_with_closures ((GObject*) _tmp17_, "button-mode", (GObject*) _tmp18_, "button-mode", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_g_object_unref0 (self->priv->bind_button_mode);
	self->priv->bind_button_mode = _tmp20_;
	_tmp21_ = self->priv->bind_new_label;
	if (_tmp21_ != NULL) {
		GBinding* _tmp22_;
		GBinding* _tmp23_;
		_tmp22_ = self->priv->bind_new_label;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, G_TYPE_BINDING, GBinding));
		g_binding_unbind (_tmp23_);
	}
	_tmp24_ = panel;
	_tmp25_ = self->priv->header_bar;
	_tmp26_ = g_object_bind_property_with_closures ((GObject*) _tmp24_, "new-label", (GObject*) _tmp25_, "new-label", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (self->priv->bind_new_label);
	self->priv->bind_new_label = _tmp27_;
	_tmp28_ = self->priv->stack;
	_tmp29_ = adw_view_stack_get_visible_child (_tmp28_);
	_tmp30_ = _tmp29_;
	gtk_widget_grab_focus (_tmp30_);
	_g_object_unref0 (panel);
	_g_object_unref0 (help_overlay);
}

static void
_clocks_window_pane_changed_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
	clocks_window_pane_changed ((ClocksWindow*) self);
}

static void
clocks_window_visible_child_changed (ClocksWindow* self)
{
	AdwLeaflet* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	ClocksAlarmRingingPanel* _tmp3_;
	AdwLeaflet* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	ClocksAlarmRingingPanel* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->alarm_leaflet;
	_tmp1_ = adw_leaflet_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->alarm_ringing_panel;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		gtk_window_set_title ((GtkWindow*) self, _ ("Alarm"));
	} else {
		AdwLeaflet* _tmp4_;
		GtkWidget* _tmp5_;
		GtkWidget* _tmp6_;
		ClocksWorldStandalone* _tmp7_;
		_tmp4_ = self->priv->world_leaflet;
		_tmp5_ = adw_leaflet_get_visible_child (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->world_standalone;
		if (_tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget)) {
			ClocksWorldStandalone* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = self->priv->world_standalone;
			_tmp9_ = clocks_world_standalone_get_title (_tmp8_);
			_tmp10_ = _tmp9_;
			gtk_window_set_title ((GtkWindow*) self, _tmp10_);
		} else {
			gtk_window_set_title ((GtkWindow*) self, _ ("Clocks"));
		}
	}
	_tmp11_ = self->priv->alarm_leaflet;
	_tmp12_ = adw_leaflet_get_visible_child (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->alarm_ringing_panel;
	gtk_window_set_deletable ((GtkWindow*) self, _tmp13_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
}

static void
_clocks_window_visible_child_changed_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	clocks_window_visible_child_changed ((ClocksWindow*) self);
}

static void
clocks_window_alarm_dismissed (ClocksWindow* self)
{
	AdwLeaflet* _tmp0_;
	AdwLeaflet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->alarm_leaflet;
	_tmp1_ = self->priv->world_leaflet;
	adw_leaflet_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
}

static void
_clocks_window_alarm_dismissed_clocks_alarm_ringing_panel_dismiss (ClocksAlarmRingingPanel* _sender,
                                                                   gpointer self)
{
	clocks_window_alarm_dismissed ((ClocksWindow*) self);
}

static void
clocks_window_close_standalone (ClocksWindow* self)
{
	AdwLeaflet* _tmp0_;
	GtkBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->world_leaflet;
	_tmp1_ = self->priv->main_view;
	adw_leaflet_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
}

static void
clocks_window_on_navigate_forward (ClocksWindow* self)
{
	gchar* current = NULL;
	AdwViewStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = adw_view_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	current = _tmp3_;
	_tmp4_ = current;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("world")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp8_;
				_tmp8_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp8_, "alarm");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("alarm")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp9_;
				_tmp9_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp9_, "stopwatch");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("stopwatch")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp10_;
				_tmp10_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp10_, "timer");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("timer")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp11_;
				_tmp11_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp11_, "world");
				break;
			}
		}
	}
	_g_free0 (current);
}

static void
clocks_window_on_navigate_backward (ClocksWindow* self)
{
	gchar* current = NULL;
	AdwViewStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = adw_view_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	current = _tmp3_;
	_tmp4_ = current;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("world")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp8_;
				_tmp8_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp8_, "timer");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("alarm")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp9_;
				_tmp9_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp9_, "world");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("stopwatch")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp10_;
				_tmp10_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp10_, "alarm");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("timer")))) {
		switch (0) {
			default:
			{
				AdwViewStack* _tmp11_;
				_tmp11_ = self->priv->stack;
				adw_view_stack_set_visible_child_name (_tmp11_, "stopwatch");
				break;
			}
		}
	}
	_g_free0 (current);
}

static void
clocks_window_on_set_page (ClocksWindow* self,
                           const gchar* action_name,
                           GVariant* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action_name != NULL);
	if (param != NULL) {
		gchar* page = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		AdwViewStack* _tmp2_;
		const gchar* _tmp3_;
		_tmp0_ = g_variant_get_string (param, NULL);
		_tmp1_ = g_strdup (_tmp0_);
		page = _tmp1_;
		_tmp2_ = self->priv->stack;
		_tmp3_ = page;
		adw_view_stack_set_visible_child_name (_tmp2_, _tmp3_);
		_g_free0 (page);
	}
}

static void
clocks_window_real_change_page (ClocksWindow* self,
                                gint offset)
{
	gboolean dir = FALSE;
	AdwViewStack* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	dir = FALSE;
	if (gtk_widget_get_direction ((GtkWidget*) self) == GTK_TEXT_DIR_RTL) {
		gboolean _tmp0_ = FALSE;
		if (offset == 0) {
			_tmp0_ = FALSE;
		} else {
			_tmp0_ = TRUE;
		}
		dir = _tmp0_;
	} else {
		gboolean _tmp1_ = FALSE;
		if (offset == 1) {
			_tmp1_ = FALSE;
		} else {
			_tmp1_ = TRUE;
		}
		dir = _tmp1_;
	}
	_tmp2_ = self->priv->stack;
	_tmp3_ = adw_view_stack_get_visible_child_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("world")))) {
		switch (0) {
			default:
			{
				if (dir) {
					AdwViewStack* _tmp8_;
					_tmp8_ = self->priv->stack;
					gtk_widget_error_bell ((GtkWidget*) _tmp8_);
				} else {
					AdwViewStack* _tmp9_;
					ClocksAlarmFace* _tmp10_;
					_tmp9_ = self->priv->stack;
					_tmp10_ = self->priv->alarm;
					adw_view_stack_set_visible_child (_tmp9_, (GtkWidget*) _tmp10_);
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("alarm")))) {
		switch (0) {
			default:
			{
				if (dir) {
					AdwViewStack* _tmp11_;
					ClocksWorldFace* _tmp12_;
					_tmp11_ = self->priv->stack;
					_tmp12_ = self->priv->world;
					adw_view_stack_set_visible_child (_tmp11_, (GtkWidget*) _tmp12_);
				} else {
					AdwViewStack* _tmp13_;
					ClocksStopwatchFace* _tmp14_;
					_tmp13_ = self->priv->stack;
					_tmp14_ = self->priv->stopwatch;
					adw_view_stack_set_visible_child (_tmp13_, (GtkWidget*) _tmp14_);
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("stopwatch")))) {
		switch (0) {
			default:
			{
				if (dir) {
					AdwViewStack* _tmp15_;
					ClocksAlarmFace* _tmp16_;
					_tmp15_ = self->priv->stack;
					_tmp16_ = self->priv->alarm;
					adw_view_stack_set_visible_child (_tmp15_, (GtkWidget*) _tmp16_);
				} else {
					AdwViewStack* _tmp17_;
					ClocksTimerFace* _tmp18_;
					_tmp17_ = self->priv->stack;
					_tmp18_ = self->priv->timer;
					adw_view_stack_set_visible_child (_tmp17_, (GtkWidget*) _tmp18_);
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("timer")))) {
		switch (0) {
			default:
			{
				if (dir) {
					AdwViewStack* _tmp19_;
					ClocksStopwatchFace* _tmp20_;
					_tmp19_ = self->priv->stack;
					_tmp20_ = self->priv->stopwatch;
					adw_view_stack_set_visible_child (_tmp19_, (GtkWidget*) _tmp20_);
				} else {
					AdwViewStack* _tmp21_;
					_tmp21_ = self->priv->stack;
					gtk_widget_error_bell ((GtkWidget*) _tmp21_);
				}
				break;
			}
		}
	}
}

static void
clocks_window_real_set_page (ClocksWindow* self,
                             const gchar* page)
{
	AdwViewStack* _tmp0_;
	g_return_if_fail (page != NULL);
	_tmp0_ = self->priv->stack;
	adw_view_stack_set_visible_child_name (_tmp0_, page);
}

static GObject *
clocks_window_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ClocksWindow * self;
	parent_class = G_OBJECT_CLASS (clocks_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_WINDOW, ClocksWindow);
	gtk_widget_class_install_action (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), "set-page", "s", (GtkWidgetActionActivateFunc) clocks_window_on_set_page);
	gtk_widget_class_add_binding_action (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GDK_KEY_1, GDK_ALT_MASK, "set-page", "s", "world", NULL);
	gtk_widget_class_add_binding_action (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GDK_KEY_2, GDK_ALT_MASK, "set-page", "s", "alarm", NULL);
	gtk_widget_class_add_binding_action (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GDK_KEY_3, GDK_ALT_MASK, "set-page", "s", "stopwatch", NULL);
	gtk_widget_class_add_binding_action (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GDK_KEY_4, GDK_ALT_MASK, "set-page", "s", "timer", NULL);
	return obj;
}

static void
clocks_window_class_init (ClocksWindowClass * klass,
                          gpointer klass_data)
{
	clocks_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksWindow_private_offset);
	((GtkWindowClass *) klass)->close_request = (gboolean (*) (GtkWindow*)) clocks_window_real_close_request;
	((ClocksWindowClass *) klass)->change_page = clocks_window_real_change_page;
	((ClocksWindowClass *) klass)->set_page = clocks_window_real_set_page;
	G_OBJECT_CLASS (klass)->constructor = clocks_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = clocks_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/window.ui");
	clocks_window_signals[CLOCKS_WINDOW_CHANGE_PAGE_SIGNAL] = g_signal_new ("change-page", CLOCKS_TYPE_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ClocksWindowClass, change_page), NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	clocks_window_signals[CLOCKS_WINDOW_SET_PAGE_SIGNAL] = g_signal_new ("set-page", CLOCKS_TYPE_WINDOW, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (ClocksWindowClass, set_page), NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_bar", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "alarm_leaflet", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, alarm_leaflet));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "world_leaflet", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, world_leaflet));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_view", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, main_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "world", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, world));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "alarm", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, alarm));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "world_standalone", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, world_standalone));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "alarm_ringing_panel", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, alarm_ringing_panel));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stopwatch", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, stopwatch));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "timer", FALSE, ClocksWindow_private_offset + G_STRUCT_OFFSET (ClocksWindowPrivate, timer));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_active", G_CALLBACK(_clocks_window_on_window_active_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_press_cb", G_CALLBACK(_clocks_window_key_press_cb_gtk_event_controller_key_key_pressed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "pane_changed", G_CALLBACK(_clocks_window_pane_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "visible_child_changed", G_CALLBACK(_clocks_window_visible_child_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "alarm_dismissed", G_CALLBACK(_clocks_window_alarm_dismissed_clocks_alarm_ringing_panel_dismiss));
}

static void
clocks_window_instance_init (ClocksWindow * self,
                             gpointer klass)
{
	self->priv = clocks_window_get_instance_private (self);
	self->priv->bind_button_mode = NULL;
	self->priv->bind_new_label = NULL;
	self->priv->inited = FALSE;
	g_type_ensure (CLOCKS_TYPE_HEADER_BAR);
	g_type_ensure (CLOCKS_WORLD_TYPE_FACE);
	g_type_ensure (CLOCKS_ALARM_TYPE_FACE);
	g_type_ensure (CLOCKS_WORLD_TYPE_STANDALONE);
	g_type_ensure (CLOCKS_ALARM_TYPE_RINGING_PANEL);
	g_type_ensure (CLOCKS_STOPWATCH_TYPE_FACE);
	g_type_ensure (CLOCKS_TIMER_TYPE_FACE);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_window_finalize (GObject * obj)
{
	ClocksWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TYPE_WINDOW, ClocksWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->bind_button_mode);
	_g_object_unref0 (self->priv->bind_new_label);
	G_OBJECT_CLASS (clocks_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksWindow), 0, (GInstanceInitFunc) clocks_window_instance_init, NULL };
	GType clocks_window_type_id;
	clocks_window_type_id = g_type_register_static (adw_application_window_get_type (), "ClocksWindow", &g_define_type_info, 0);
	ClocksWindow_private_offset = g_type_add_instance_private (clocks_window_type_id, sizeof (ClocksWindowPrivate));
	return clocks_window_type_id;
}

GType
clocks_window_get_type (void)
{
	static volatile gsize clocks_window_type_id__once = 0;
	if (g_once_init_enter (&clocks_window_type_id__once)) {
		GType clocks_window_type_id;
		clocks_window_type_id = clocks_window_get_type_once ();
		g_once_init_leave (&clocks_window_type_id__once, clocks_window_type_id);
	}
	return clocks_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

