/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.graalvm.visualvm.lib.jfluid.classfile.BaseClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.ClassRepository;
import org.graalvm.visualvm.lib.jfluid.classfile.DynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.classfile.PlaceholderClassInfo;
import org.graalvm.visualvm.lib.jfluid.client.RuntimeProfilingPoint;
import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.global.ProfilingSessionStatus;
import org.graalvm.visualvm.lib.jfluid.instrumentation.JavaClassConstants;
import org.graalvm.visualvm.lib.jfluid.utils.MiscUtils;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.RootClassLoadedCommand;

public class ClassManager
implements JavaClassConstants,
CommonConstants {
    private static final RuntimeProfilingPoint[] EMPTY_PROFILEPOINT_ARRAY = new RuntimeProfilingPoint[0];
    private static Comparator ByBciComparator = new Comparator(){

        public int compare(Object aa, Object bb) {
            RuntimeProfilingPoint a = (RuntimeProfilingPoint)aa;
            RuntimeProfilingPoint b = (RuntimeProfilingPoint)bb;
            return a.getBci() - b.getBci();
        }
    };
    protected ProfilingSessionStatus status;

    protected ClassManager(ProfilingSessionStatus status) {
        this.status = status;
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] points, ClassInfo classInfo) {
        ArrayList<RuntimeProfilingPoint> newPoints = null;
        String className = classInfo.getName().replace('/', '.');
        for (RuntimeProfilingPoint point : points) {
            if (!className.equals(point.getClassName()) || !point.resolve(classInfo)) continue;
            if (newPoints == null) {
                newPoints = new ArrayList<RuntimeProfilingPoint>(2);
            }
            newPoints.add(point);
        }
        if (newPoints == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        return newPoints.toArray(new RuntimeProfilingPoint[0]);
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] points, int methodIdx) {
        ArrayList<RuntimeProfilingPoint> newPoints = null;
        for (RuntimeProfilingPoint point : points) {
            if (point.getMethodIdx() != methodIdx) continue;
            if (newPoints == null) {
                newPoints = new ArrayList<RuntimeProfilingPoint>(2);
            }
            newPoints.add(point);
        }
        if (newPoints == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        if (newPoints.size() > 1) {
            Collections.sort(newPoints, ByBciComparator);
        }
        return newPoints.toArray(new RuntimeProfilingPoint[0]);
    }

    protected static RuntimeProfilingPoint[] getRuntimeProfilingPoints(RuntimeProfilingPoint[] points, ClassInfo classInfo, int methodIdx) {
        ArrayList<RuntimeProfilingPoint> newPoints = null;
        String className = classInfo.getName().replace('/', '.');
        for (RuntimeProfilingPoint point : points) {
            if (!className.equals(point.getClassName()) || !point.resolve(classInfo) || point.getMethodIdx() != methodIdx) continue;
            if (newPoints == null) {
                newPoints = new ArrayList<RuntimeProfilingPoint>(2);
            }
            newPoints.add(point);
        }
        if (newPoints == null) {
            return EMPTY_PROFILEPOINT_ARRAY;
        }
        if (newPoints.size() > 1) {
            Collections.sort(newPoints, ByBciComparator);
        }
        return newPoints.toArray(new RuntimeProfilingPoint[0]);
    }

    protected static DynamicClassInfo javaClassForName(String className, int classLoaderId) {
        try {
            return ClassRepository.lookupClass(className, classLoaderId);
        }
        catch (IOException ex2) {
            MiscUtils.printWarningMessage("Error reading class " + className);
            MiscUtils.printWarningMessage(ex2.getMessage());
        }
        catch (ClassFormatError er) {
            MiscUtils.printWarningMessage(er.getMessage());
        }
        return null;
    }

    protected static BaseClassInfo javaClassForObjectArrayType(String elementTypeName) {
        BaseClassInfo clazz = ClassRepository.lookupSpecialClass("[" + elementTypeName);
        return clazz;
    }

    protected static BaseClassInfo javaClassForPrimitiveArrayType(int arrayTypeId) {
        BaseClassInfo clazz = ClassRepository.lookupSpecialClass(PRIMITIVE_ARRAY_TYPE_NAMES[arrayTypeId]);
        return clazz;
    }

    protected static BaseClassInfo javaClassOrPlaceholderForName(String className, int classLoaderId) {
        return ClassRepository.lookupClassOrCreatePlaceholder(className, classLoaderId);
    }

    protected static BaseClassInfo loadedJavaClassOrExistingPlaceholderForName(String className, int classLoaderId) {
        return ClassRepository.lookupLoadedClass(className, classLoaderId, true);
    }

    protected static void registerPlaceholder(PlaceholderClassInfo pci) {
        ClassRepository.addClassInfo(pci);
    }

    protected static void resetLoadedClassData() {
        ClassRepository.clearCache();
    }

    protected static void storeClassFileBytesForCustomLoaderClasses(RootClassLoadedCommand rootLoaded) {
        String[] loadedClasses = rootLoaded.getAllLoadedClassNames();
        byte[][] cachedClassFileBytes = rootLoaded.getCachedClassFileBytes();
        int[] loadedClassLoaderIds = rootLoaded.getAllLoadedClassLoaderIds();
        int[] superClasses = rootLoaded.getAllLoaderSuperClassIds();
        int[][] interfaceNames = rootLoaded.getAllLoadedInterfaceIds();
        int nClasses = loadedClasses.length;
        HashSet<Integer> allInterfacesIndexes = new HashSet<Integer>();
        for (int i = 0; i < nClasses; ++i) {
            if (cachedClassFileBytes[i] == null) continue;
            String string = loadedClasses[i];
            int loaderId = loadedClassLoaderIds[i];
            byte[] bytes = cachedClassFileBytes[i];
            if (bytes != null && bytes.length == 0) {
                int sidx = superClasses[i];
                String superClass = sidx != -1 ? loadedClasses[sidx] : "java/lang/Object";
                int[] interfaceNamedIdxs = interfaceNames[i];
                ArrayList<String> interfaces = new ArrayList<String>();
                for (int j = 0; j < interfaceNamedIdxs.length; ++j) {
                    int iidx = interfaceNamedIdxs[j];
                    if (iidx == -1) continue;
                    interfaces.add(loadedClasses[iidx]);
                    allInterfacesIndexes.add(iidx);
                }
                ClassRepository.addVMSuppliedClassFile(string, loaderId, bytes, superClass, interfaces.toArray(new String[0]));
                continue;
            }
            ClassRepository.addVMSuppliedClassFile(string, loaderId, bytes);
        }
        for (Object e : allInterfacesIndexes) {
            int iidx = (Integer)e;
            if (cachedClassFileBytes[iidx] == null) continue;
            DynamicClassInfo iface = ClassManager.javaClassForName(loadedClasses[iidx], loadedClassLoaderIds[iidx]);
            iface.setInterface();
        }
    }
}

