/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Locale;
import org.apache.catalina.ssi.SSIProcessor;
import org.apache.catalina.ssi.SSIServletExternalResolver;
import org.apache.catalina.ssi.SSIServletRequestUtil;

public class SSIServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected int debug = 0;
    protected boolean buffered = false;
    protected Long expires = null;
    protected boolean isVirtualWebappRelative = false;
    protected String inputEncoding = null;
    protected String outputEncoding = "UTF-8";
    protected boolean allowExec = false;

    public void init() throws ServletException {
        if (this.getServletConfig().getInitParameter("debug") != null) {
            this.debug = Integer.parseInt(this.getServletConfig().getInitParameter("debug"));
        }
        this.isVirtualWebappRelative = Boolean.parseBoolean(this.getServletConfig().getInitParameter("isVirtualWebappRelative"));
        if (this.getServletConfig().getInitParameter("expires") != null) {
            this.expires = Long.valueOf(this.getServletConfig().getInitParameter("expires"));
        }
        this.buffered = Boolean.parseBoolean(this.getServletConfig().getInitParameter("buffered"));
        this.inputEncoding = this.getServletConfig().getInitParameter("inputEncoding");
        if (this.getServletConfig().getInitParameter("outputEncoding") != null) {
            this.outputEncoding = this.getServletConfig().getInitParameter("outputEncoding");
        }
        this.allowExec = Boolean.parseBoolean(this.getServletConfig().getInitParameter("allowExec"));
        if (this.debug > 0) {
            this.log("SSIServlet.init() SSI invoker started with 'debug'=" + this.debug);
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.debug > 0) {
            this.log("SSIServlet.doGet()");
        }
        this.requestHandler(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (this.debug > 0) {
            this.log("SSIServlet.doPost()");
        }
        this.requestHandler(httpServletRequest, httpServletResponse);
    }

    protected void requestHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        ServletContext servletContext = this.getServletContext();
        String string = SSIServletRequestUtil.getRelativePath(httpServletRequest);
        if (this.debug > 0) {
            this.log("SSIServlet.requestHandler()\nServing " + (this.buffered ? "buffered " : "unbuffered ") + "resource '" + string + "'");
        }
        if (string == null || string.toUpperCase(Locale.ENGLISH).startsWith("/WEB-INF") || string.toUpperCase(Locale.ENGLISH).startsWith("/META-INF")) {
            httpServletResponse.sendError(404);
            return;
        }
        URL uRL = servletContext.getResource(string);
        if (uRL == null) {
            httpServletResponse.sendError(404);
            return;
        }
        String string2 = servletContext.getMimeType(string);
        if (string2 == null) {
            string2 = "text/html";
        }
        httpServletResponse.setContentType(string2 + ";charset=" + this.outputEncoding);
        if (this.expires != null) {
            httpServletResponse.setDateHeader("Expires", new Date().getTime() + this.expires * 1000L);
        }
        this.processSSI(httpServletRequest, httpServletResponse, uRL);
    }

    protected void processSSI(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, URL uRL) throws IOException {
        InputStreamReader inputStreamReader;
        BufferedReader bufferedReader;
        long l;
        SSIServletExternalResolver sSIServletExternalResolver = new SSIServletExternalResolver(this.getServletContext(), httpServletRequest, httpServletResponse, this.isVirtualWebappRelative, this.debug, this.inputEncoding);
        SSIProcessor sSIProcessor = new SSIProcessor(sSIServletExternalResolver, this.debug, this.allowExec);
        PrintWriter printWriter = null;
        StringWriter stringWriter = null;
        if (this.buffered) {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
        } else {
            printWriter = httpServletResponse.getWriter();
        }
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        String string = uRLConnection.getContentEncoding();
        if (string == null) {
            string = this.inputEncoding;
        }
        if ((l = sSIProcessor.process(bufferedReader = new BufferedReader(inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string)), uRLConnection.getLastModified(), printWriter)) > 0L) {
            httpServletResponse.setDateHeader("last-modified", l);
        }
        if (this.buffered) {
            printWriter.flush();
            String string2 = stringWriter.toString();
            httpServletResponse.getWriter().write(string2);
        }
        bufferedReader.close();
    }
}

