/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.net.URLConnection;
import java.sql.DriverManager;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class JreMemoryLeakPreventionListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JreMemoryLeakPreventionListener.class);
    private static final StringManager sm = StringManager.getManager(JreMemoryLeakPreventionListener.class);
    private boolean appContextProtection = false;
    private boolean urlCacheProtection = true;
    private boolean driverManagerProtection = true;
    private String classesToInitialize = null;

    public boolean isAppContextProtection() {
        return this.appContextProtection;
    }

    public void setAppContextProtection(boolean bl) {
        this.appContextProtection = bl;
    }

    public boolean isUrlCacheProtection() {
        return this.urlCacheProtection;
    }

    public void setUrlCacheProtection(boolean bl) {
        this.urlCacheProtection = bl;
    }

    public boolean isDriverManagerProtection() {
        return this.driverManagerProtection;
    }

    public void setDriverManagerProtection(boolean bl) {
        this.driverManagerProtection = bl;
    }

    public String getClassesToInitialize() {
        return this.classesToInitialize;
    }

    public void setClassesToInitialize(String string) {
        this.classesToInitialize = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("before_init".equals(lifecycleEvent.getType())) {
            if (!(lifecycleEvent.getLifecycle() instanceof Server)) {
                log.warn((Object)sm.getString("listener.notServer", new Object[]{lifecycleEvent.getLifecycle().getClass().getSimpleName()}));
            }
            if (this.driverManagerProtection) {
                DriverManager.getDrivers();
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                if (this.appContextProtection) {
                    ImageIO.getCacheDirectory();
                }
                if (this.urlCacheProtection) {
                    URLConnection.setDefaultUseCaches("JAR", false);
                }
                if (this.classesToInitialize != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.classesToInitialize, ", \r\n\t");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string = stringTokenizer.nextToken();
                        try {
                            Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error((Object)sm.getString("jreLeakListener.classToInitializeFail", new Object[]{string}), (Throwable)classNotFoundException);
                        }
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }
}

