/* application-database-manager.c generated by valac 0.56.3, the Vala compiler
 * generated from application-database-manager.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <glib.h>
#include "geary-client-43.0.h"
#include <gtk/gtk.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define APPLICATION_TYPE_DATABASE_MANAGER (application_database_manager_get_type ())
#define APPLICATION_DATABASE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_DATABASE_MANAGER, ApplicationDatabaseManager))
#define APPLICATION_DATABASE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_DATABASE_MANAGER, ApplicationDatabaseManagerClass))
#define APPLICATION_IS_DATABASE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_DATABASE_MANAGER))
#define APPLICATION_IS_DATABASE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_DATABASE_MANAGER))
#define APPLICATION_DATABASE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_DATABASE_MANAGER, ApplicationDatabaseManagerClass))

typedef struct _ApplicationDatabaseManager ApplicationDatabaseManager;
typedef struct _ApplicationDatabaseManagerClass ApplicationDatabaseManagerClass;
typedef struct _ApplicationDatabaseManagerPrivate ApplicationDatabaseManagerPrivate;
enum  {
	APPLICATION_DATABASE_MANAGER_0_PROPERTY,
	APPLICATION_DATABASE_MANAGER_MONITOR_PROPERTY,
	APPLICATION_DATABASE_MANAGER_VISIBLE_PROPERTY,
	APPLICATION_DATABASE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* application_database_manager_properties[APPLICATION_DATABASE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _ApplicationDatabaseManager {
	GearyBaseObject parent_instance;
	ApplicationDatabaseManagerPrivate * priv;
};

struct _ApplicationDatabaseManagerClass {
	GearyBaseObjectClass parent_class;
};

struct _ApplicationDatabaseManagerPrivate {
	GearyAggregateProgressMonitor* _monitor;
	gboolean _visible;
	ApplicationClient* application;
	GtkDialog* dialog;
	GeeSet* cancellables;
};

static gint ApplicationDatabaseManager_private_offset;
static gpointer application_database_manager_parent_class = NULL;

VALA_EXTERN GType application_database_manager_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyAggregateProgressMonitor* application_database_manager_get_monitor (ApplicationDatabaseManager* self);
static void application_database_manager_set_monitor (ApplicationDatabaseManager* self,
                                               GearyAggregateProgressMonitor* value);
VALA_EXTERN gboolean application_database_manager_get_visible (ApplicationDatabaseManager* self);
VALA_EXTERN void application_database_manager_set_visible (ApplicationDatabaseManager* self,
                                               gboolean value);
VALA_EXTERN ApplicationDatabaseManager* application_database_manager_new (ApplicationClient* application);
VALA_EXTERN ApplicationDatabaseManager* application_database_manager_construct (GType object_type,
                                                                    ApplicationClient* application);
static void application_database_manager_on_start (ApplicationDatabaseManager* self);
static void _application_database_manager_on_start_geary_progress_monitor_start (GearyProgressMonitor* _sender,
                                                                          gpointer self);
static void application_database_manager_on_close (ApplicationDatabaseManager* self);
static void _application_database_manager_on_close_geary_progress_monitor_finish (GearyProgressMonitor* _sender,
                                                                           gpointer self);
VALA_EXTERN void application_database_manager_add_account (ApplicationDatabaseManager* self,
                                               GearyAccount* account,
                                               GCancellable* cancellable);
VALA_EXTERN void application_database_manager_remove_account (ApplicationDatabaseManager* self,
                                                  GearyAccount* account);
static gboolean application_database_manager_on_delete_event (ApplicationDatabaseManager* self);
static gboolean _application_database_manager_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                                                GdkEventAny* event,
                                                                                gpointer self);
static void _application_database_manager_on_close_gtk_dialog_close (GtkDialog* _sender,
                                                              gpointer self);
static void application_database_manager_finalize (GObject * obj);
static GType application_database_manager_get_type_once (void);
static void _vala_application_database_manager_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_application_database_manager_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
application_database_manager_get_instance_private (ApplicationDatabaseManager* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationDatabaseManager_private_offset);
}

GearyAggregateProgressMonitor*
application_database_manager_get_monitor (ApplicationDatabaseManager* self)
{
	GearyAggregateProgressMonitor* result;
	GearyAggregateProgressMonitor* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_DATABASE_MANAGER (self), NULL);
	_tmp0_ = self->priv->_monitor;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
application_database_manager_set_monitor (ApplicationDatabaseManager* self,
                                          GearyAggregateProgressMonitor* value)
{
	GearyAggregateProgressMonitor* old_value;
	g_return_if_fail (APPLICATION_IS_DATABASE_MANAGER (self));
	old_value = application_database_manager_get_monitor (self);
	if (old_value != value) {
		GearyAggregateProgressMonitor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_monitor);
		self->priv->_monitor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_database_manager_properties[APPLICATION_DATABASE_MANAGER_MONITOR_PROPERTY]);
	}
}

gboolean
application_database_manager_get_visible (ApplicationDatabaseManager* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_DATABASE_MANAGER (self), FALSE);
	result = self->priv->_visible;
	return result;
}

void
application_database_manager_set_visible (ApplicationDatabaseManager* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_DATABASE_MANAGER (self));
	old_value = application_database_manager_get_visible (self);
	if (old_value != value) {
		self->priv->_visible = value;
		g_object_notify_by_pspec ((GObject *) self, application_database_manager_properties[APPLICATION_DATABASE_MANAGER_VISIBLE_PROPERTY]);
	}
}

/**
     * Creates a new manager for the given application.
     */
static void
_application_database_manager_on_start_geary_progress_monitor_start (GearyProgressMonitor* _sender,
                                                                     gpointer self)
{
	application_database_manager_on_start ((ApplicationDatabaseManager*) self);
}

static void
_application_database_manager_on_close_geary_progress_monitor_finish (GearyProgressMonitor* _sender,
                                                                      gpointer self)
{
	application_database_manager_on_close ((ApplicationDatabaseManager*) self);
}

ApplicationDatabaseManager*
application_database_manager_construct (GType object_type,
                                        ApplicationClient* application)
{
	ApplicationDatabaseManager * self = NULL;
	GearyAggregateProgressMonitor* _tmp0_;
	GearyAggregateProgressMonitor* _tmp1_;
	g_return_val_if_fail (APPLICATION_IS_CLIENT (application), NULL);
	self = (ApplicationDatabaseManager*) geary_base_object_construct (object_type);
	self->priv->application = application;
	_tmp0_ = self->priv->_monitor;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), "start", (GCallback) _application_database_manager_on_start_geary_progress_monitor_start, self, 0);
	_tmp1_ = self->priv->_monitor;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), "finish", (GCallback) _application_database_manager_on_close_geary_progress_monitor_finish, self, 0);
	return self;
}

ApplicationDatabaseManager*
application_database_manager_new (ApplicationClient* application)
{
	return application_database_manager_construct (APPLICATION_TYPE_DATABASE_MANAGER, application);
}

/**
     * Adds an account to be monitored for upgrades by the dialog.
     *
     * Accounts should be added before being opened.
     */
void
application_database_manager_add_account (ApplicationDatabaseManager* self,
                                          GearyAccount* account,
                                          GCancellable* cancellable)
{
	GearyAggregateProgressMonitor* _tmp0_;
	GearyProgressMonitor* _tmp1_;
	GearyProgressMonitor* _tmp2_;
	GearyAggregateProgressMonitor* _tmp3_;
	GearyProgressMonitor* _tmp4_;
	GearyProgressMonitor* _tmp5_;
	g_return_if_fail (APPLICATION_IS_DATABASE_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = self->priv->_monitor;
	_tmp1_ = geary_account_get_db_upgrade_monitor (account);
	_tmp2_ = _tmp1_;
	geary_aggregate_progress_monitor_add (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->_monitor;
	_tmp4_ = geary_account_get_db_vacuum_monitor (account);
	_tmp5_ = _tmp4_;
	geary_aggregate_progress_monitor_add (_tmp3_, _tmp5_);
	if (cancellable != NULL) {
		GeeSet* _tmp6_;
		_tmp6_ = self->priv->cancellables;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection), cancellable);
	}
}

/**
     * Stops an account from being monitored.
     */
void
application_database_manager_remove_account (ApplicationDatabaseManager* self,
                                             GearyAccount* account)
{
	GearyAggregateProgressMonitor* _tmp0_;
	GearyProgressMonitor* _tmp1_;
	GearyProgressMonitor* _tmp2_;
	GearyAggregateProgressMonitor* _tmp3_;
	GearyProgressMonitor* _tmp4_;
	GearyProgressMonitor* _tmp5_;
	g_return_if_fail (APPLICATION_IS_DATABASE_MANAGER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT));
	_tmp0_ = self->priv->_monitor;
	_tmp1_ = geary_account_get_db_upgrade_monitor (account);
	_tmp2_ = _tmp1_;
	geary_aggregate_progress_monitor_remove (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->_monitor;
	_tmp4_ = geary_account_get_db_vacuum_monitor (account);
	_tmp5_ = _tmp4_;
	geary_aggregate_progress_monitor_remove (_tmp3_, _tmp5_);
}

static gboolean
_application_database_manager_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender,
                                                                       GdkEventAny* event,
                                                                       gpointer self)
{
	gboolean result;
	result = application_database_manager_on_delete_event ((ApplicationDatabaseManager*) self);
	return result;
}

static void
_application_database_manager_on_close_gtk_dialog_close (GtkDialog* _sender,
                                                         gpointer self)
{
	application_database_manager_on_close ((ApplicationDatabaseManager*) self);
}

static void
application_database_manager_on_start (ApplicationDatabaseManager* self)
{
	GtkSpinner* spinner = NULL;
	GtkSpinner* _tmp9_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	ApplicationClient* _tmp13_;
	ApplicationMainWindow* _tmp14_;
	ApplicationMainWindow* _tmp15_;
	GtkDialog* _tmp16_;
	GtkDialog* _tmp17_;
	GtkStyleContext* _tmp18_;
	GtkDialog* _tmp19_;
	GtkBox* _tmp20_;
	GtkDialog* _tmp21_;
	GtkDialog* _tmp22_;
	GtkDialog* _tmp23_;
	GtkDialog* _tmp24_;
	g_return_if_fail (APPLICATION_IS_DATABASE_MANAGER (self));
	{
		GeeIterator* _window_it = NULL;
		ApplicationClient* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->priv->application;
		_tmp1_ = application_client_get_main_windows (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_window_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			ApplicationMainWindow* window = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			ApplicationMainWindow* _tmp8_;
			_tmp5_ = _window_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _window_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			window = (ApplicationMainWindow*) _tmp7_;
			_tmp8_ = window;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
			_g_object_unref0 (window);
		}
		_g_object_unref0 (_window_it);
	}
	_tmp9_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp9_);
	spinner = _tmp9_;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (spinner, gtk_widget_get_type (), GtkWidget), 45, 45);
	gtk_spinner_start (spinner);
	_tmp10_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp10_);
	grid = _tmp10_;
	gtk_orientable_set_orientation (G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_orientable_get_type (), GtkOrientable), GTK_ORIENTATION_VERTICAL);
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (spinner, gtk_widget_get_type (), GtkWidget));
	_tmp11_ = (GtkLabel*) gtk_label_new (_ ("Account update in progress"));
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp12_);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_widget_get_type (), GtkWidget));
	_tmp13_ = self->priv->application;
	_tmp14_ = application_client_get_active_main_window (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = (GtkDialog*) gtk_dialog_new_with_buttons (_ ("Account update"), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_window_get_type (), GtkWindow), GTK_DIALOG_MODAL, NULL);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp16_;
	_g_object_unref0 (_tmp15_);
	_tmp17_ = self->priv->dialog;
	_tmp18_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp18_, "geary-upgrade");
	_tmp19_ = self->priv->dialog;
	_tmp20_ = gtk_dialog_get_content_area (_tmp19_);
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (grid, gtk_widget_get_type (), GtkWidget));
	_tmp21_ = self->priv->dialog;
	gtk_window_set_deletable (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_window_get_type (), GtkWindow), FALSE);
	_tmp22_ = self->priv->dialog;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), "delete-event", (GCallback) _application_database_manager_on_delete_event_gtk_widget_delete_event, self, 0);
	_tmp23_ = self->priv->dialog;
	g_signal_connect_object (_tmp23_, "close", (GCallback) _application_database_manager_on_close_gtk_dialog_close, self, 0);
	_tmp24_ = self->priv->dialog;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (grid);
	_g_object_unref0 (spinner);
}

static gboolean
application_database_manager_on_delete_event (ApplicationDatabaseManager* self)
{
	GearyAggregateProgressMonitor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_DATABASE_MANAGER (self), FALSE);
	_tmp0_ = self->priv->_monitor;
	_tmp1_ = geary_progress_monitor_get_is_in_progress (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp2_ = _tmp1_;
	result = !_tmp2_;
	return result;
}

static void
application_database_manager_on_close (ApplicationDatabaseManager* self)
{
	GearyAggregateProgressMonitor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp9_ = FALSE;
	GtkDialog* _tmp10_;
	g_return_if_fail (APPLICATION_IS_DATABASE_MANAGER (self));
	_tmp0_ = self->priv->_monitor;
	_tmp1_ = geary_progress_monitor_get_is_in_progress (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		{
			GeeIterator* _c_it = NULL;
			GeeSet* _tmp3_;
			GeeIterator* _tmp4_;
			_tmp3_ = self->priv->cancellables;
			_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
			_c_it = _tmp4_;
			while (TRUE) {
				GeeIterator* _tmp5_;
				GCancellable* c = NULL;
				GeeIterator* _tmp6_;
				gpointer _tmp7_;
				GCancellable* _tmp8_;
				_tmp5_ = _c_it;
				if (!gee_iterator_next (_tmp5_)) {
					break;
				}
				_tmp6_ = _c_it;
				_tmp7_ = gee_iterator_get (_tmp6_);
				c = (GCancellable*) _tmp7_;
				_tmp8_ = c;
				g_cancellable_cancel (_tmp8_);
				_g_object_unref0 (c);
			}
			_g_object_unref0 (_c_it);
		}
	}
	_tmp10_ = self->priv->dialog;
	if (_tmp10_ != NULL) {
		GtkDialog* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = self->priv->dialog;
		_tmp12_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
		_tmp13_ = _tmp12_;
		_tmp9_ = _tmp13_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GtkDialog* _tmp14_;
		GtkDialog* _tmp15_;
		_tmp14_ = self->priv->dialog;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
		_tmp15_ = self->priv->dialog;
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (self->priv->dialog);
		self->priv->dialog = NULL;
	}
	{
		GeeIterator* _window_it = NULL;
		ApplicationClient* _tmp16_;
		GeeCollection* _tmp17_;
		GeeCollection* _tmp18_;
		GeeIterator* _tmp19_;
		GeeIterator* _tmp20_;
		_tmp16_ = self->priv->application;
		_tmp17_ = application_client_get_main_windows (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_window_it = _tmp20_;
		while (TRUE) {
			GeeIterator* _tmp21_;
			ApplicationMainWindow* window = NULL;
			GeeIterator* _tmp22_;
			gpointer _tmp23_;
			ApplicationMainWindow* _tmp24_;
			_tmp21_ = _window_it;
			if (!gee_iterator_next (_tmp21_)) {
				break;
			}
			_tmp22_ = _window_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			window = (ApplicationMainWindow*) _tmp23_;
			_tmp24_ = window;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget), TRUE);
			_g_object_unref0 (window);
		}
		_g_object_unref0 (_window_it);
	}
}

static void
application_database_manager_class_init (ApplicationDatabaseManagerClass * klass,
                                         gpointer klass_data)
{
	application_database_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationDatabaseManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_application_database_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_database_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_database_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_DATABASE_MANAGER_MONITOR_PROPERTY, application_database_manager_properties[APPLICATION_DATABASE_MANAGER_MONITOR_PROPERTY] = g_param_spec_object ("monitor", "monitor", "monitor", GEARY_TYPE_AGGREGATE_PROGRESS_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines whether or not the database dialog is visible. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_DATABASE_MANAGER_VISIBLE_PROPERTY, application_database_manager_properties[APPLICATION_DATABASE_MANAGER_VISIBLE_PROPERTY] = g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
application_database_manager_instance_init (ApplicationDatabaseManager * self,
                                            gpointer klass)
{
	GearyAggregateProgressMonitor* _tmp0_;
	GeeHashSet* _tmp1_;
	self->priv = application_database_manager_get_instance_private (self);
	_tmp0_ = geary_aggregate_progress_monitor_new ();
	self->priv->_monitor = _tmp0_;
	self->priv->dialog = NULL;
	_tmp1_ = gee_hash_set_new (g_cancellable_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->cancellables = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_SET, GeeSet);
}

static void
application_database_manager_finalize (GObject * obj)
{
	ApplicationDatabaseManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_DATABASE_MANAGER, ApplicationDatabaseManager);
	_g_object_unref0 (self->priv->_monitor);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->cancellables);
	G_OBJECT_CLASS (application_database_manager_parent_class)->finalize (obj);
}

/** Manages progress when upgrading and rebuilding account databases. */
static GType
application_database_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationDatabaseManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_database_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationDatabaseManager), 0, (GInstanceInitFunc) application_database_manager_instance_init, NULL };
	GType application_database_manager_type_id;
	application_database_manager_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationDatabaseManager", &g_define_type_info, 0);
	ApplicationDatabaseManager_private_offset = g_type_add_instance_private (application_database_manager_type_id, sizeof (ApplicationDatabaseManagerPrivate));
	return application_database_manager_type_id;
}

GType
application_database_manager_get_type (void)
{
	static volatile gsize application_database_manager_type_id__once = 0;
	if (g_once_init_enter (&application_database_manager_type_id__once)) {
		GType application_database_manager_type_id;
		application_database_manager_type_id = application_database_manager_get_type_once ();
		g_once_init_leave (&application_database_manager_type_id__once, application_database_manager_type_id);
	}
	return application_database_manager_type_id__once;
}

static void
_vala_application_database_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ApplicationDatabaseManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_DATABASE_MANAGER, ApplicationDatabaseManager);
	switch (property_id) {
		case APPLICATION_DATABASE_MANAGER_MONITOR_PROPERTY:
		g_value_set_object (value, application_database_manager_get_monitor (self));
		break;
		case APPLICATION_DATABASE_MANAGER_VISIBLE_PROPERTY:
		g_value_set_boolean (value, application_database_manager_get_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_database_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ApplicationDatabaseManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_DATABASE_MANAGER, ApplicationDatabaseManager);
	switch (property_id) {
		case APPLICATION_DATABASE_MANAGER_MONITOR_PROPERTY:
		application_database_manager_set_monitor (self, g_value_get_object (value));
		break;
		case APPLICATION_DATABASE_MANAGER_VISIBLE_PROPERTY:
		application_database_manager_set_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

