/* status-bar.c generated by valac 0.56.3, the Vala compiler
 * generated from status-bar.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>

typedef enum  {
	STATUS_BAR_CONTEXT_OUTBOX
} StatusBarContext;

#define STATUS_BAR_TYPE_CONTEXT (status_bar_context_get_type ())
enum  {
	STATUS_BAR_0_PROPERTY,
	STATUS_BAR_NUM_PROPERTIES
};
static GParamSpec* status_bar_properties[STATUS_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _StatusBarPrivate {
	GeeHashMap* context_ids;
	GeeHashMap* message_ids;
	GeeHashMap* message_counts;
};

static gint StatusBar_private_offset;
static gpointer status_bar_parent_class = NULL;

VALA_EXTERN GType status_bar_context_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* status_bar_message_get_text (StatusBarMessage self);
VALA_EXTERN StatusBarContext status_bar_message_get_context (StatusBarMessage self);
static void status_bar_set_context_id (StatusBar* self,
                                StatusBarContext context);
static gint status_bar_get_count (StatusBar* self,
                           StatusBarMessage message);
static void status_bar_push_message (StatusBar* self,
                              StatusBarMessage message);
static void status_bar_remove_message (StatusBar* self,
                                StatusBarMessage message);
static void status_bar_finalize (GObject * obj);
static GType status_bar_get_type_once (void);

static inline gpointer
status_bar_get_instance_private (StatusBar* self)
{
	return G_STRUCT_MEMBER_P (self, StatusBar_private_offset);
}

gchar*
status_bar_message_get_text (StatusBarMessage self)
{
	gchar* result;
	switch (self) {
		case STATUS_BAR_MESSAGE_OUTBOX_SENDING:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Sending…"));
			result = _tmp0_;
			return result;
		}
		case STATUS_BAR_MESSAGE_OUTBOX_SEND_FAILURE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Error sending email"));
			result = _tmp1_;
			return result;
		}
		case STATUS_BAR_MESSAGE_OUTBOX_SAVE_SENT_MAIL_FAILED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Error saving sent mail"));
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

StatusBarContext
status_bar_message_get_context (StatusBarMessage self)
{
	StatusBarContext result;
	switch (self) {
		case STATUS_BAR_MESSAGE_OUTBOX_SENDING:
		{
			result = STATUS_BAR_CONTEXT_OUTBOX;
			return result;
		}
		case STATUS_BAR_MESSAGE_OUTBOX_SEND_FAILURE:
		{
			result = STATUS_BAR_CONTEXT_OUTBOX;
			return result;
		}
		case STATUS_BAR_MESSAGE_OUTBOX_SAVE_SENT_MAIL_FAILED:
		{
			result = STATUS_BAR_CONTEXT_OUTBOX;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
status_bar_message_get_type_once (void)
{
	static const GEnumValue values[] = {{STATUS_BAR_MESSAGE_OUTBOX_SENDING, "STATUS_BAR_MESSAGE_OUTBOX_SENDING", "outbox-sending"}, {STATUS_BAR_MESSAGE_OUTBOX_SEND_FAILURE, "STATUS_BAR_MESSAGE_OUTBOX_SEND_FAILURE", "outbox-send-failure"}, {STATUS_BAR_MESSAGE_OUTBOX_SAVE_SENT_MAIL_FAILED, "STATUS_BAR_MESSAGE_OUTBOX_SAVE_SENT_MAIL_FAILED", "outbox-save-sent-mail-failed"}, {0, NULL, NULL}};
	GType status_bar_message_type_id;
	status_bar_message_type_id = g_enum_register_static ("StatusBarMessage", values);
	return status_bar_message_type_id;
}

GType
status_bar_message_get_type (void)
{
	static volatile gsize status_bar_message_type_id__once = 0;
	if (g_once_init_enter (&status_bar_message_type_id__once)) {
		GType status_bar_message_type_id;
		status_bar_message_type_id = status_bar_message_get_type_once ();
		g_once_init_leave (&status_bar_message_type_id__once, status_bar_message_type_id);
	}
	return status_bar_message_type_id__once;
}

static GType
status_bar_context_get_type_once (void)
{
	static const GEnumValue values[] = {{STATUS_BAR_CONTEXT_OUTBOX, "STATUS_BAR_CONTEXT_OUTBOX", "outbox"}, {0, NULL, NULL}};
	GType status_bar_context_type_id;
	status_bar_context_type_id = g_enum_register_static ("StatusBarContext", values);
	return status_bar_context_type_id;
}

GType
status_bar_context_get_type (void)
{
	static volatile gsize status_bar_context_type_id__once = 0;
	if (g_once_init_enter (&status_bar_context_type_id__once)) {
		GType status_bar_context_type_id;
		status_bar_context_type_id = status_bar_context_get_type_once ();
		g_once_init_leave (&status_bar_context_type_id__once, status_bar_context_type_id);
	}
	return status_bar_context_type_id__once;
}

StatusBar*
status_bar_construct (GType object_type)
{
	StatusBar * self = NULL;
	self = (StatusBar*) g_object_new (object_type, NULL);
	status_bar_set_context_id (self, STATUS_BAR_CONTEXT_OUTBOX);
	return self;
}

StatusBar*
status_bar_new (void)
{
	return status_bar_construct (TYPE_STATUS_BAR);
}

static void
status_bar_set_context_id (StatusBar* self,
                           StatusBarContext context)
{
	GeeHashMap* _tmp0_;
	GEnumValue* _tmp1_;
	g_return_if_fail (IS_STATUS_BAR (self));
	_tmp0_ = self->priv->context_ids;
	_tmp1_ = g_enum_get_value (g_type_class_ref (STATUS_BAR_TYPE_CONTEXT), context);
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) context), (gpointer) ((guintptr) gtk_statusbar_get_context_id (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_statusbar_get_type (), GtkStatusbar), (_tmp1_ != NULL) ? _tmp1_->value_name : NULL)));
}

static gint
status_bar_get_count (StatusBar* self,
                      StatusBarMessage message)
{
	gint _tmp0_ = 0;
	GeeHashMap* _tmp1_;
	gint result;
	g_return_val_if_fail (IS_STATUS_BAR (self), 0);
	_tmp1_ = self->priv->message_counts;
	if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) message))) {
		GeeHashMap* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = self->priv->message_counts;
		_tmp3_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) message));
		_tmp0_ = (gint) ((gintptr) _tmp3_);
	} else {
		_tmp0_ = 0;
	}
	result = _tmp0_;
	return result;
}

static void
status_bar_push_message (StatusBar* self,
                         StatusBarMessage message)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (IS_STATUS_BAR (self));
	_tmp0_ = self->priv->message_ids;
	_tmp1_ = self->priv->context_ids;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) status_bar_message_get_context (message)));
	_tmp3_ = status_bar_message_get_text (message);
	_tmp4_ = _tmp3_;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) message), (gpointer) ((guintptr) gtk_statusbar_push (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_statusbar_get_type (), GtkStatusbar), (guint) ((guintptr) _tmp2_), _tmp4_)));
	_g_free0 (_tmp4_);
}

static void
status_bar_remove_message (StatusBar* self,
                           StatusBarMessage message)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	GeeHashMap* _tmp4_;
	g_return_if_fail (IS_STATUS_BAR (self));
	_tmp0_ = self->priv->context_ids;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) status_bar_message_get_context (message)));
	_tmp2_ = self->priv->message_ids;
	_tmp3_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) message));
	gtk_statusbar_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_statusbar_get_type (), GtkStatusbar), (guint) ((guintptr) _tmp1_), (guint) ((guintptr) _tmp3_));
	_tmp4_ = self->priv->message_ids;
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) message), NULL);
}

/**
     * Return whether the message has been activated more times than it has
     * been deactivated.
     */
gboolean
status_bar_is_message_active (StatusBar* self,
                              StatusBarMessage message)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_STATUS_BAR (self), FALSE);
	_tmp0_ = self->priv->message_ids;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) message));
	return result;
}

void
status_bar_activate_message (StatusBar* self,
                             StatusBarMessage message)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (IS_STATUS_BAR (self));
	if (status_bar_is_message_active (self, message)) {
		status_bar_remove_message (self, message);
	}
	status_bar_push_message (self, message);
	_tmp0_ = self->priv->message_counts;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) message), (gpointer) ((gintptr) (status_bar_get_count (self, message) + 1)));
}

void
status_bar_deactivate_message (StatusBar* self,
                               StatusBarMessage message)
{
	gint count = 0;
	GeeHashMap* _tmp0_;
	g_return_if_fail (IS_STATUS_BAR (self));
	if (!status_bar_is_message_active (self, message)) {
		return;
	}
	count = status_bar_get_count (self, message);
	if (count == 1) {
		status_bar_remove_message (self, message);
	}
	_tmp0_ = self->priv->message_counts;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) message), (gpointer) ((gintptr) (count - 1)));
}

static void
status_bar_class_init (StatusBarClass * klass,
                       gpointer klass_data)
{
	status_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &StatusBar_private_offset);
	G_OBJECT_CLASS (klass)->finalize = status_bar_finalize;
}

static void
status_bar_instance_init (StatusBar * self,
                          gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	self->priv = status_bar_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (STATUS_BAR_TYPE_CONTEXT, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->context_ids = _tmp0_;
	_tmp1_ = gee_hash_map_new (STATUS_BAR_TYPE_MESSAGE, NULL, NULL, G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->message_ids = _tmp1_;
	_tmp2_ = gee_hash_map_new (STATUS_BAR_TYPE_MESSAGE, NULL, NULL, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->message_counts = _tmp2_;
}

static void
status_bar_finalize (GObject * obj)
{
	StatusBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STATUS_BAR, StatusBar);
	_g_object_unref0 (self->priv->context_ids);
	_g_object_unref0 (self->priv->message_ids);
	_g_object_unref0 (self->priv->message_counts);
	G_OBJECT_CLASS (status_bar_parent_class)->finalize (obj);
}

/**
 * A wrapper around Gtk.Statusbar that predefines messages and context areas so
 * you don't have to keep track of them elsewhere.  You can activate and
 * deactivate messages, instead of worrying about context areas and stacks.
 * Internally, activations are reference counted, and every new activation
 * pushes the message to the top of its context area's stack.  Only when
 * the number of deactivations equals the number of activations is the message
 * removed from the stack entirely.
 */
static GType
status_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StatusBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) status_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StatusBar), 0, (GInstanceInitFunc) status_bar_instance_init, NULL };
	GType status_bar_type_id;
	status_bar_type_id = g_type_register_static (gtk_statusbar_get_type (), "StatusBar", &g_define_type_info, 0);
	StatusBar_private_offset = g_type_add_instance_private (status_bar_type_id, sizeof (StatusBarPrivate));
	return status_bar_type_id;
}

GType
status_bar_get_type (void)
{
	static volatile gsize status_bar_type_id__once = 0;
	if (g_once_init_enter (&status_bar_type_id__once)) {
		GType status_bar_type_id;
		status_bar_type_id = status_bar_get_type_once ();
		g_once_init_leave (&status_bar_type_id__once, status_bar_type_id);
	}
	return status_bar_type_id__once;
}

