/* conversation-viewer.c generated by valac 0.56.3, the Vala compiler
 * generated from conversation-viewer.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2016,2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>

enum  {
	CONVERSATION_VIEWER_0_PROPERTY,
	CONVERSATION_VIEWER_CURRENT_LIST_PROPERTY,
	CONVERSATION_VIEWER_CURRENT_COMPOSER_PROPERTY,
	CONVERSATION_VIEWER_PREVIOUS_WEB_VIEW_PROPERTY,
	CONVERSATION_VIEWER_NUM_PROPERTIES
};
static GParamSpec* conversation_viewer_properties[CONVERSATION_VIEWER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ConversationViewerLoadConversationData ConversationViewerLoadConversationData;
typedef struct _Block97Data Block97Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ConversationViewerUpdateFindResultsData ConversationViewerUpdateFindResultsData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block98Data Block98Data;
enum  {
	CONVERSATION_VIEWER_CONVERSATION_ADDED_SIGNAL,
	CONVERSATION_VIEWER_CONVERSATION_REMOVED_SIGNAL,
	CONVERSATION_VIEWER_NUM_SIGNALS
};
static guint conversation_viewer_signals[CONVERSATION_VIEWER_NUM_SIGNALS] = {0};

struct _ConversationViewerPrivate {
	ConversationListBox* _current_list;
	ComposerWidget* _current_composer;
	ConversationWebView* _previous_web_view;
	ApplicationConfiguration* config;
	GeeSet* selection_while_composing;
	GCancellable* find_cancellable;
	GtkSpinner* loading_page;
	GtkGrid* no_conversations_page;
	GtkGrid* conversation_page;
	GtkGrid* multiple_conversations_page;
	GtkGrid* empty_folder_page;
	GtkGrid* empty_search_page;
	GtkGrid* composer_page;
	GtkScrolledWindow* conversation_scroller;
	ComponentsEntryUndo* conversation_find_undo;
	GtkButton* conversation_find_next;
	GtkButton* conversation_find_prev;
};

struct _ConversationViewerLoadConversationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationViewer* self;
	GearyAppConversation* conversation;
	GeeCollection* scroll_to;
	GearyAppEmailStore* store;
	ApplicationContactStore* contacts;
	gboolean start_mark_timer;
	GtkScrolledWindow* old_scroller;
	GtkScrolledWindow* _tmp0_;
	ConversationListBox* new_list;
	ApplicationConfiguration* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GtkAdjustment* _tmp3_;
	ConversationListBox* _tmp4_;
	ConversationListBox* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	ConversationListBox* _tmp8_;
	ConversationListBoxSearchManager* _tmp9_;
	ConversationListBoxSearchManager* _tmp10_;
	ConversationListBox* _tmp11_;
	GtkGrid* _tmp12_;
	GearySearchQuery* query;
	GearyFolder* _tmp13_;
	GearyFolder* _tmp14_;
	GearyAccount* _tmp15_;
	GearyAccount* _tmp16_;
	GearySearchQuery* _tmp17_;
	GearySearchQuery* _tmp18_;
	GearyAppSearchFolder* search_folder;
	GearyFolder* _tmp19_;
	GearyFolder* _tmp20_;
	GearyAppSearchFolder* _tmp21_;
	GearyAppSearchFolder* _tmp22_;
	GearyAppSearchFolder* _tmp23_;
	GearySearchQuery* _tmp24_;
	GearySearchQuery* _tmp25_;
	GearySearchQuery* _tmp26_;
	ConversationListBox* _tmp27_;
	GearySearchQuery* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	GError* _inner_error0_;
};

struct _Block97Data {
	int _ref_count_;
	ConversationViewer* self;
	ConversationListBox* list;
	gpointer _async_data_;
};

struct _ConversationViewerUpdateFindResultsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ConversationViewer* self;
	Block97Data* _data97_;
	ConversationListBox* _tmp0_;
	ConversationListBox* _tmp1_;
	ConversationListBox* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* cancellable;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	GearySearchQuery* query;
	ConversationListBox* _tmp9_;
	GearyAppConversation* _tmp10_;
	GearyAppConversation* _tmp11_;
	GearyFolder* _tmp12_;
	GearyFolder* _tmp13_;
	GearyAccount* _tmp14_;
	GearyAccount* _tmp15_;
	GearySearchQuery* _tmp16_;
	GearySearchQuery* _tmp17_;
	ConversationListBox* _tmp18_;
	ConversationListBoxSearchManager* _tmp19_;
	ConversationListBoxSearchManager* _tmp20_;
	GearySearchQuery* _tmp21_;
	GError* err;
	GError* _tmp22_;
	const gchar* _tmp23_;
	GError* _inner_error0_;
};

struct _Block98Data {
	int _ref_count_;
	ConversationViewer* self;
	ConversationEmail* email_view;
};

static gint ConversationViewer_private_offset;
static gpointer conversation_viewer_parent_class = NULL;
static GearyBaseInterfaceIface * conversation_viewer_geary_base_interface_parent_iface = NULL;

static void conversation_viewer_set_current_list (ConversationViewer* self,
                                           ConversationListBox* value);
static void conversation_viewer_set_current_composer (ConversationViewer* self,
                                               ComposerWidget* value);
VALA_EXTERN ConversationWebView* conversation_viewer_get_previous_web_view (ConversationViewer* self);
VALA_EXTERN void conversation_viewer_set_previous_web_view (ConversationViewer* self,
                                                ConversationWebView* value);
static void conversation_viewer_new_conversation_scroller (ConversationViewer* self);
static void conversation_viewer_on_composer_closed (ConversationViewer* self);
static void _conversation_viewer_on_composer_closed_composer_box_vanished (ComposerBox* _sender,
                                                                    gpointer self);
static void conversation_viewer_set_visible_child (ConversationViewer* self,
                                            GtkWidget* widget);
static void _conversation_viewer_on_composer_closed_composer_embed_vanished (ComposerEmbed* _sender,
                                                                      gpointer self);
static void conversation_viewer_load_conversation_data_free (gpointer _data);
static gboolean conversation_viewer_load_conversation_co (ConversationViewerLoadConversationData* _data_);
static GtkScrolledWindow* conversation_viewer_remove_current_list (ConversationViewer* self);
static void __lambda155_ (ConversationViewer* self,
                   guint count);
static void ___lambda155__conversation_list_box_search_manager_matches_updated (ConversationListBoxSearchManager* _sender,
                                                                         guint matches,
                                                                         gpointer self);
static void conversation_viewer_add_new_list (ConversationViewer* self,
                                       ConversationListBox* list);
static GearySearchQuery* conversation_viewer_get_find_search_query (ConversationViewer* self,
                                                             GearyAccount* account,
                                                             GError** error);
static void conversation_viewer_load_conversation_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static gboolean conversation_viewer_on_conversation_scroll (ConversationViewer* self);
static gboolean _conversation_viewer_on_conversation_scroll_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                              GdkEventScroll* event,
                                                                              gpointer self);
static gboolean _conversation_viewer_on_conversation_scroll_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                      GdkEventButton* event,
                                                                                      gpointer self);
static void conversation_viewer_update_find_results_data_free (gpointer _data);
static void conversation_viewer_update_find_results (ConversationViewer* self,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void conversation_viewer_update_find_results_finish (ConversationViewer* self,
                                                     GAsyncResult* _res_);
static gboolean conversation_viewer_update_find_results_co (ConversationViewerUpdateFindResultsData* _data_);
static Block97Data* block97_data_ref (Block97Data* _data97_);
static void block97_data_unref (void * _userdata_);
static void ___lambda156_ (Block97Data* _data97_);
static void ____lambda156__g_cancellable_cancelled (GCancellable* _sender,
                                             gpointer self);
static void conversation_viewer_update_find_results_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void conversation_viewer_on_find_mode_changed (ConversationViewer* self,
                                               GObject* obj,
                                               GParamSpec* param);
static Block98Data* block98_data_ref (Block98Data* _data98_);
static void block98_data_unref (void * _userdata_);
static void _____lambda157_ (Block98Data* _data98_,
                      GObject* obj,
                      GAsyncResult* res);
static void ______lambda157__gasync_ready_callback (GObject* source_object,
                                             GAsyncResult* res,
                                             gpointer self);
static void _conversation_viewer_on_find_mode_changed_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void conversation_viewer_on_find_text_changed (ConversationViewer* self,
                                               GtkSearchEntry* entry);
static void _conversation_viewer_on_find_text_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                gpointer self);
static void conversation_viewer_on_find_next (ConversationViewer* self,
                                       GtkWidget* entry);
static void _conversation_viewer_on_find_next_gtk_button_activate (GtkButton* _sender,
                                                            gpointer self);
static void conversation_viewer_on_find_prev (ConversationViewer* self,
                                       GtkWidget* entry);
static void _conversation_viewer_on_find_prev_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self);
static void conversation_viewer_finalize (GObject * obj);
static GType conversation_viewer_get_type_once (void);
static void _vala_conversation_viewer_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_conversation_viewer_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
conversation_viewer_get_instance_private (ConversationViewer* self)
{
	return G_STRUCT_MEMBER_P (self, ConversationViewer_private_offset);
}

ConversationListBox*
conversation_viewer_get_current_list (ConversationViewer* self)
{
	ConversationListBox* result;
	ConversationListBox* _tmp0_;
	g_return_val_if_fail (IS_CONVERSATION_VIEWER (self), NULL);
	_tmp0_ = self->priv->_current_list;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
conversation_viewer_set_current_list (ConversationViewer* self,
                                      ConversationListBox* value)
{
	ConversationListBox* old_value;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	old_value = conversation_viewer_get_current_list (self);
	if (old_value != value) {
		ConversationListBox* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current_list);
		self->priv->_current_list = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_viewer_properties[CONVERSATION_VIEWER_CURRENT_LIST_PROPERTY]);
	}
}

ComposerWidget*
conversation_viewer_get_current_composer (ConversationViewer* self)
{
	ComposerWidget* result;
	ComposerWidget* _tmp0_;
	g_return_val_if_fail (IS_CONVERSATION_VIEWER (self), NULL);
	_tmp0_ = self->priv->_current_composer;
	result = _tmp0_;
	return result;
}

static void
conversation_viewer_set_current_composer (ConversationViewer* self,
                                          ComposerWidget* value)
{
	ComposerWidget* old_value;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	old_value = conversation_viewer_get_current_composer (self);
	if (old_value != value) {
		ComposerWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current_composer);
		self->priv->_current_composer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_viewer_properties[CONVERSATION_VIEWER_CURRENT_COMPOSER_PROPERTY]);
	}
}

ConversationWebView*
conversation_viewer_get_previous_web_view (ConversationViewer* self)
{
	ConversationWebView* result;
	ConversationWebView* _tmp0_;
	g_return_val_if_fail (IS_CONVERSATION_VIEWER (self), NULL);
	_tmp0_ = self->priv->_previous_web_view;
	result = _tmp0_;
	return result;
}

void
conversation_viewer_set_previous_web_view (ConversationViewer* self,
                                           ConversationWebView* value)
{
	ConversationWebView* old_value;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	old_value = conversation_viewer_get_previous_web_view (self);
	if (old_value != value) {
		ConversationWebView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_previous_web_view);
		self->priv->_previous_web_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, conversation_viewer_properties[CONVERSATION_VIEWER_PREVIOUS_WEB_VIEW_PROPERTY]);
	}
}

/**
     * Constructs a new conversation view instance.
     */
ConversationViewer*
conversation_viewer_construct (GType object_type,
                               ApplicationConfiguration* config)
{
	ConversationViewer * self = NULL;
	ApplicationConfiguration* _tmp0_;
	ComponentsPlaceholderPane* no_conversations = NULL;
	ComponentsPlaceholderPane* _tmp1_;
	GtkGrid* _tmp2_;
	ComponentsPlaceholderPane* multi_conversations = NULL;
	ComponentsPlaceholderPane* _tmp3_;
	GtkGrid* _tmp4_;
	ComponentsPlaceholderPane* empty_folder = NULL;
	ComponentsPlaceholderPane* _tmp5_;
	GtkGrid* _tmp6_;
	ComponentsPlaceholderPane* empty_search = NULL;
	ComponentsPlaceholderPane* _tmp7_;
	GtkGrid* _tmp8_;
	GtkSearchEntry* _tmp9_;
	ComponentsEntryUndo* _tmp10_;
	GtkSearchBar* _tmp11_;
	GtkSearchEntry* _tmp12_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	self = (ConversationViewer*) g_object_new (object_type, NULL);
	geary_base_interface_base_ref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp0_;
	_tmp1_ = components_placeholder_pane_new ();
	g_object_ref_sink (_tmp1_);
	no_conversations = _tmp1_;
	components_placeholder_pane_set_icon_name (no_conversations, "folder-symbolic");
	components_placeholder_pane_set_title (no_conversations, _ ("No conversations selected"));
	components_placeholder_pane_set_subtitle (no_conversations, _ ("Selecting a conversation from the list will display it here"));
	_tmp2_ = self->priv->no_conversations_page;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (no_conversations, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = components_placeholder_pane_new ();
	g_object_ref_sink (_tmp3_);
	multi_conversations = _tmp3_;
	components_placeholder_pane_set_icon_name (multi_conversations, "folder-symbolic");
	components_placeholder_pane_set_title (multi_conversations, _ ("Multiple conversations selected"));
	components_placeholder_pane_set_subtitle (multi_conversations, _ ("Choosing an action will apply to all selected conversations"));
	_tmp4_ = self->priv->multiple_conversations_page;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (multi_conversations, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = components_placeholder_pane_new ();
	g_object_ref_sink (_tmp5_);
	empty_folder = _tmp5_;
	components_placeholder_pane_set_icon_name (empty_folder, "folder-symbolic");
	components_placeholder_pane_set_title (empty_folder, _ ("No conversations found"));
	components_placeholder_pane_set_subtitle (empty_folder, _ ("This folder does not contain any conversations"));
	_tmp6_ = self->priv->empty_folder_page;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (empty_folder, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = components_placeholder_pane_new ();
	g_object_ref_sink (_tmp7_);
	empty_search = _tmp7_;
	components_placeholder_pane_set_icon_name (empty_search, "folder-symbolic");
	components_placeholder_pane_set_title (empty_search, _ ("No conversations found"));
	components_placeholder_pane_set_subtitle (empty_search, _ ("Your search returned no results, try refining your search terms"));
	_tmp8_ = self->priv->empty_search_page;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (empty_search, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = self->conversation_find_entry;
	_tmp10_ = components_entry_undo_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_entry_get_type (), GtkEntry));
	_g_object_unref0 (self->priv->conversation_find_undo);
	self->priv->conversation_find_undo = _tmp10_;
	conversation_viewer_new_conversation_scroller (self);
	_tmp11_ = self->conversation_find_bar;
	_tmp12_ = self->conversation_find_entry;
	gtk_search_bar_connect_entry (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_entry_get_type (), GtkEntry));
	_g_object_unref0 (empty_search);
	_g_object_unref0 (empty_folder);
	_g_object_unref0 (multi_conversations);
	_g_object_unref0 (no_conversations);
	return self;
}

ConversationViewer*
conversation_viewer_new (ApplicationConfiguration* config)
{
	return conversation_viewer_construct (TYPE_CONVERSATION_VIEWER, config);
}

/**
     * Puts the view into composer mode, showing a full-height composer.
     */
static void
_conversation_viewer_on_composer_closed_composer_box_vanished (ComposerBox* _sender,
                                                               gpointer self)
{
	conversation_viewer_on_composer_closed ((ConversationViewer*) self);
}

void
conversation_viewer_do_compose (ConversationViewer* self,
                                ComposerWidget* composer)
{
	ApplicationMainWindow* main_window = NULL;
	GtkWidget* _tmp0_;
	ApplicationMainWindow* _tmp1_;
	ApplicationMainWindow* _tmp2_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	g_return_if_fail (COMPOSER_IS_WIDGET (composer));
	_tmp0_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp0_) ? ((ApplicationMainWindow*) _tmp0_) : NULL);
	main_window = _tmp1_;
	_tmp2_ = main_window;
	if (_tmp2_ != NULL) {
		ComposerBox* box = NULL;
		ApplicationMainWindow* _tmp3_;
		ComponentsConversationHeaderBar* _tmp4_;
		ComposerBox* _tmp5_;
		ConversationListView* conversation_list = NULL;
		ApplicationMainWindow* _tmp6_;
		ConversationListView* _tmp7_;
		ConversationListView* _tmp8_;
		ConversationListView* _tmp9_;
		ConversationListView* _tmp10_;
		GeeSet* _tmp11_;
		ConversationListView* _tmp12_;
		GtkTreeSelection* _tmp13_;
		ComposerBox* _tmp14_;
		GtkGrid* _tmp15_;
		ComposerBox* _tmp16_;
		GtkGrid* _tmp17_;
		_tmp3_ = main_window;
		_tmp4_ = _tmp3_->conversation_headerbar;
		_tmp5_ = composer_box_new (composer, _tmp4_);
		g_object_ref_sink (_tmp5_);
		box = _tmp5_;
		conversation_viewer_set_current_composer (self, composer);
		_tmp6_ = main_window;
		_tmp7_ = application_main_window_get_conversation_list_view (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		conversation_list = _tmp9_;
		_tmp10_ = conversation_list;
		_tmp11_ = conversation_list_view_copy_selected (_tmp10_);
		_g_object_unref0 (self->priv->selection_while_composing);
		self->priv->selection_while_composing = _tmp11_;
		_tmp12_ = conversation_list;
		_tmp13_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_tree_view_get_type (), GtkTreeView));
		gtk_tree_selection_unselect_all (_tmp13_);
		_tmp14_ = box;
		g_signal_connect_object (_tmp14_, "vanished", (GCallback) _conversation_viewer_on_composer_closed_composer_box_vanished, self, 0);
		_tmp15_ = self->priv->composer_page;
		_tmp16_ = box;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
		_tmp17_ = self->priv->composer_page;
		conversation_viewer_set_visible_child (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
		composer_widget_update_window_title (composer);
		_g_object_unref0 (conversation_list);
		_g_object_unref0 (box);
	}
	_g_object_unref0 (main_window);
}

/**
     * Puts the view into composer mode, showing an embedded composer.
     */
static void
_conversation_viewer_on_composer_closed_composer_embed_vanished (ComposerEmbed* _sender,
                                                                 gpointer self)
{
	conversation_viewer_on_composer_closed ((ConversationViewer*) self);
}

void
conversation_viewer_do_compose_embedded (ConversationViewer* self,
                                         ComposerWidget* composer,
                                         GearyEmail* referred)
{
	ComposerEmbed* embed = NULL;
	GtkScrolledWindow* _tmp0_;
	ComposerEmbed* _tmp1_;
	ComposerEmbed* _tmp2_;
	gboolean kinetic = FALSE;
	GtkScrolledWindow* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ConversationListBox* _tmp7_;
	GtkScrolledWindow* _tmp13_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	g_return_if_fail (COMPOSER_IS_WIDGET (composer));
	g_return_if_fail ((referred == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (referred, GEARY_TYPE_EMAIL));
	conversation_viewer_set_current_composer (self, composer);
	_tmp0_ = self->priv->conversation_scroller;
	_tmp1_ = composer_embed_new (referred, composer, _tmp0_);
	g_object_ref_sink (_tmp1_);
	embed = _tmp1_;
	_tmp2_ = embed;
	g_signal_connect_object (_tmp2_, "vanished", (GCallback) _conversation_viewer_on_composer_closed_composer_embed_vanished, self, 0);
	_tmp3_ = self->priv->conversation_scroller;
	_tmp4_ = gtk_scrolled_window_get_kinetic_scrolling (_tmp3_);
	_tmp5_ = _tmp4_;
	kinetic = _tmp5_;
	if (kinetic) {
		GtkScrolledWindow* _tmp6_;
		_tmp6_ = self->priv->conversation_scroller;
		gtk_scrolled_window_set_kinetic_scrolling (_tmp6_, FALSE);
	}
	_tmp7_ = self->priv->_current_list;
	if (_tmp7_ != NULL) {
		ConversationListBox* _tmp8_;
		ComposerEmbed* _tmp9_;
		GearyEmailIdentifier* _tmp10_;
		GearyEmailIdentifier* _tmp11_;
		_tmp8_ = self->priv->_current_list;
		_tmp9_ = embed;
		_tmp10_ = composer_widget_get_saved_id (composer);
		_tmp11_ = _tmp10_;
		conversation_list_box_add_embedded_composer (_tmp8_, _tmp9_, _tmp11_ != NULL);
		composer_widget_update_window_title (composer);
	}
	if (kinetic) {
		GtkScrolledWindow* _tmp12_;
		_tmp12_ = self->priv->conversation_scroller;
		gtk_scrolled_window_set_kinetic_scrolling (_tmp12_, TRUE);
	}
	_tmp13_ = self->priv->conversation_scroller;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (composer, gtk_widget_get_type (), GtkWidget), -1, (gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget)) / 3) * 2);
	_g_object_unref0 (embed);
}

/**
     * Shows the loading UI.
     */
void
conversation_viewer_show_loading (ConversationViewer* self)
{
	GtkSpinner* _tmp0_;
	GtkSpinner* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	_tmp0_ = self->priv->loading_page;
	gtk_spinner_start (_tmp0_);
	_tmp1_ = self->priv->loading_page;
	conversation_viewer_set_visible_child (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
}

/**
     * Shows the UI when no conversations have been selected
     */
void
conversation_viewer_show_none_selected (ConversationViewer* self)
{
	GtkGrid* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	_tmp0_ = self->priv->no_conversations_page;
	conversation_viewer_set_visible_child (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}

/**
     * Shows the UI when multiple conversations have been selected
     */
void
conversation_viewer_show_multiple_selected (ConversationViewer* self)
{
	GtkGrid* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	_tmp0_ = self->priv->multiple_conversations_page;
	conversation_viewer_set_visible_child (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}

/**
     * Shows the empty folder UI.
     */
void
conversation_viewer_show_empty_folder (ConversationViewer* self)
{
	GtkGrid* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	_tmp0_ = self->priv->empty_folder_page;
	conversation_viewer_set_visible_child (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}

/**
     * Shows the empty search UI.
     */
void
conversation_viewer_show_empty_search (ConversationViewer* self)
{
	GtkGrid* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	_tmp0_ = self->priv->empty_search_page;
	conversation_viewer_set_visible_child (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
}

/** Shows and focuses the find entry. */
void
conversation_viewer_enable_find (ConversationViewer* self)
{
	GtkSearchBar* _tmp0_;
	GtkSearchEntry* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	_tmp0_ = self->conversation_find_bar;
	gtk_search_bar_set_search_mode (_tmp0_, TRUE);
	_tmp1_ = self->conversation_find_entry;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
}

static void
conversation_viewer_load_conversation_data_free (gpointer _data)
{
	ConversationViewerLoadConversationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->conversation);
	_g_object_unref0 (_data_->scroll_to);
	_g_object_unref0 (_data_->store);
	_g_object_unref0 (_data_->contacts);
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationViewerLoadConversationData, _data_);
}

void
conversation_viewer_load_conversation (ConversationViewer* self,
                                       GearyAppConversation* conversation,
                                       GeeCollection* scroll_to,
                                       GearyAppEmailStore* store,
                                       ApplicationContactStore* contacts,
                                       gboolean start_mark_timer,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	ConversationViewerLoadConversationData* _data_;
	ConversationViewer* _tmp0_;
	GearyAppConversation* _tmp1_;
	GeeCollection* _tmp2_;
	GearyAppEmailStore* _tmp3_;
	ApplicationContactStore* _tmp4_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversation, GEARY_APP_TYPE_CONVERSATION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (scroll_to, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (store, GEARY_APP_TYPE_EMAIL_STORE));
	g_return_if_fail (APPLICATION_IS_CONTACT_STORE (contacts));
	_data_ = g_slice_new0 (ConversationViewerLoadConversationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_viewer_load_conversation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (conversation);
	_g_object_unref0 (_data_->conversation);
	_data_->conversation = _tmp1_;
	_tmp2_ = _g_object_ref0 (scroll_to);
	_g_object_unref0 (_data_->scroll_to);
	_data_->scroll_to = _tmp2_;
	_tmp3_ = _g_object_ref0 (store);
	_g_object_unref0 (_data_->store);
	_data_->store = _tmp3_;
	_tmp4_ = _g_object_ref0 (contacts);
	_g_object_unref0 (_data_->contacts);
	_data_->contacts = _tmp4_;
	_data_->start_mark_timer = start_mark_timer;
	conversation_viewer_load_conversation_co (_data_);
}

void
conversation_viewer_load_conversation_finish (ConversationViewer* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	ConversationViewerLoadConversationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Shows a conversation in the viewer.
     */
static void
__lambda155_ (ConversationViewer* self,
              guint count)
{
	gboolean found = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkSearchEntry* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	found = count > ((guint) 0);
	if (found) {
		_tmp1_ = TRUE;
	} else {
		GtkSearchEntry* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->conversation_find_entry;
		_tmp3_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_entry_get_type (), GtkEntry));
		_tmp4_ = _tmp3_;
		_tmp1_ = geary_string_is_empty (_tmp4_);
	}
	if (_tmp1_) {
		_tmp0_ = "edit-find-symbolic";
	} else {
		_tmp0_ = "computer-fail-symbolic";
	}
	_tmp5_ = self->conversation_find_entry;
	gtk_entry_set_icon_from_icon_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_entry_get_type (), GtkEntry), GTK_ENTRY_ICON_PRIMARY, _tmp0_);
	_tmp6_ = self->priv->conversation_find_next;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), found);
	_tmp7_ = self->priv->conversation_find_prev;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), found);
}

static void
___lambda155__conversation_list_box_search_manager_matches_updated (ConversationListBoxSearchManager* _sender,
                                                                    guint matches,
                                                                    gpointer self)
{
	__lambda155_ ((ConversationViewer*) self, matches);
}

static void
conversation_viewer_load_conversation_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	ConversationViewerLoadConversationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_viewer_load_conversation_co (_data_);
}

static gboolean
conversation_viewer_load_conversation_co (ConversationViewerLoadConversationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = conversation_viewer_remove_current_list (_data_->self);
	_data_->old_scroller = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->config;
	_data_->_tmp2_ = _data_->self->priv->conversation_scroller;
	_data_->_tmp3_ = gtk_scrolled_window_get_vadjustment (_data_->_tmp2_);
	_data_->_tmp4_ = conversation_list_box_new (_data_->conversation, !_data_->start_mark_timer, _data_->store, _data_->contacts, _data_->_tmp1_, _data_->_tmp3_);
	g_object_ref_sink (_data_->_tmp4_);
	_data_->new_list = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->new_list;
	g_signal_emit (_data_->self, conversation_viewer_signals[CONVERSATION_VIEWER_CONVERSATION_ADDED_SIGNAL], 0, _data_->_tmp5_);
	_data_->_tmp6_ = _data_->self->priv->conversation_find_next;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, gtk_widget_get_type (), GtkWidget), FALSE);
	_data_->_tmp7_ = _data_->self->priv->conversation_find_prev;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, gtk_widget_get_type (), GtkWidget), FALSE);
	_data_->_tmp8_ = _data_->new_list;
	_data_->_tmp9_ = conversation_list_box_get_search (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	g_signal_connect_object (_data_->_tmp10_, "matches-updated", (GCallback) ___lambda155__conversation_list_box_search_manager_matches_updated, _data_->self, 0);
	_data_->_tmp11_ = _data_->new_list;
	conversation_viewer_add_new_list (_data_->self, _data_->_tmp11_);
	_data_->_tmp12_ = _data_->self->priv->conversation_page;
	conversation_viewer_set_visible_child (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, gtk_widget_get_type (), GtkWidget));
	_data_->_tmp13_ = geary_app_conversation_get_base_folder (_data_->conversation);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = geary_folder_get_account (_data_->_tmp14_);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = conversation_viewer_get_find_search_query (_data_->self, _data_->_tmp16_, &_data_->_inner_error0_);
	_data_->query = _data_->_tmp17_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->new_list);
		_g_object_unref0 (_data_->old_scroller);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp18_ = _data_->query;
	if (_data_->_tmp18_ == NULL) {
		_data_->_tmp19_ = geary_app_conversation_get_base_folder (_data_->conversation);
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp20_, GEARY_APP_TYPE_SEARCH_FOLDER) ? ((GearyAppSearchFolder*) _data_->_tmp20_) : NULL);
		_data_->search_folder = _data_->_tmp21_;
		_data_->_tmp22_ = _data_->search_folder;
		if (_data_->_tmp22_ != NULL) {
			_data_->_tmp23_ = _data_->search_folder;
			_data_->_tmp24_ = geary_app_search_folder_get_query (_data_->_tmp23_);
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->_tmp26_ = _g_object_ref0 (_data_->_tmp25_);
			_g_object_unref0 (_data_->query);
			_data_->query = _data_->_tmp26_;
		}
		_g_object_unref0 (_data_->search_folder);
	}
	_data_->_tmp27_ = _data_->new_list;
	_data_->_tmp28_ = _data_->query;
	_data_->_state_ = 1;
	conversation_list_box_load_conversation (_data_->_tmp27_, _data_->scroll_to, _data_->_tmp28_, conversation_viewer_load_conversation_ready, _data_);
	return FALSE;
	_state_1:
	conversation_list_box_load_conversation_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->query);
		_g_object_unref0 (_data_->new_list);
		_g_object_unref0 (_data_->old_scroller);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp29_ = _data_->old_scroller;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp29_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_data_->query);
	_g_object_unref0 (_data_->new_list);
	_g_object_unref0 (_data_->old_scroller);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
conversation_viewer_add_new_list (ConversationViewer* self,
                                  ConversationListBox* list)
{
	GtkViewport* viewport = NULL;
	GtkViewport* _tmp0_;
	GtkScrolledWindow* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	g_return_if_fail (IS_CONVERSATION_LIST_BOX (list));
	conversation_viewer_set_current_list (self, list);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (list, gtk_widget_get_type (), GtkWidget));
	_tmp0_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	viewport = _tmp0_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (viewport, gtk_widget_get_type (), GtkWidget));
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (viewport, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (list, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->conversation_scroller;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (viewport, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (viewport);
}

static GtkScrolledWindow*
conversation_viewer_remove_current_list (ConversationViewer* self)
{
	GCancellable* _tmp0_;
	ConversationListBox* _tmp2_;
	GtkScrolledWindow* old_scroller = NULL;
	GtkScrolledWindow* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkGrid* _tmp7_;
	GtkScrolledWindow* result;
	g_return_val_if_fail (IS_CONVERSATION_VIEWER (self), NULL);
	_tmp0_ = self->priv->find_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->find_cancellable;
		g_cancellable_cancel (_tmp1_);
		_g_object_unref0 (self->priv->find_cancellable);
		self->priv->find_cancellable = NULL;
	}
	_tmp2_ = self->priv->_current_list;
	if (_tmp2_ != NULL) {
		ConversationListBox* _tmp3_;
		ConversationListBox* _tmp4_;
		_tmp3_ = self->priv->_current_list;
		conversation_list_box_cancel_conversation_load (_tmp3_);
		_tmp4_ = self->priv->_current_list;
		g_signal_emit (self, conversation_viewer_signals[CONVERSATION_VIEWER_CONVERSATION_REMOVED_SIGNAL], 0, _tmp4_);
		conversation_viewer_set_current_list (self, NULL);
	}
	_tmp5_ = self->priv->conversation_scroller;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	old_scroller = _tmp6_;
	_tmp7_ = self->priv->conversation_page;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (old_scroller, gtk_widget_get_type (), GtkWidget));
	conversation_viewer_new_conversation_scroller (self);
	result = old_scroller;
	return result;
}

static gboolean
_conversation_viewer_on_conversation_scroll_gtk_widget_scroll_event (GtkWidget* _sender,
                                                                     GdkEventScroll* event,
                                                                     gpointer self)
{
	gboolean result;
	result = conversation_viewer_on_conversation_scroll ((ConversationViewer*) self);
	return result;
}

static gboolean
_conversation_viewer_on_conversation_scroll_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                             GdkEventButton* event,
                                                                             gpointer self)
{
	gboolean result;
	result = conversation_viewer_on_conversation_scroll ((ConversationViewer*) self);
	return result;
}

static void
conversation_viewer_new_conversation_scroller (ConversationViewer* self)
{
	GtkScrolledWindow* scroller = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkWidget* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkGrid* _tmp4_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	scroller = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp1_, "geary-conversation-scroller");
	g_object_set (scroller, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_widget_get_type (), GtkWidget), TRUE);
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_widget_get_type (), GtkWidget), TRUE);
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_widget_get_type (), GtkWidget));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_widget_get_type (), GtkWidget), "scroll-event", (GCallback) _conversation_viewer_on_conversation_scroll_gtk_widget_scroll_event, self, 0);
	_tmp2_ = gtk_scrolled_window_get_vscrollbar (scroller);
	g_signal_connect_object (_tmp2_, "button-release-event", (GCallback) _conversation_viewer_on_conversation_scroll_gtk_widget_button_release_event, self, 0);
	_tmp3_ = _g_object_ref0 (scroller);
	_g_object_unref0 (self->priv->conversation_scroller);
	self->priv->conversation_scroller = _tmp3_;
	_tmp4_ = self->priv->conversation_page;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (scroller);
}

/**
     * Sets the currently visible page of the stack.
     */
static void
conversation_viewer_set_visible_child (ConversationViewer* self,
                                       GtkWidget* widget)
{
	const gchar* _tmp0_;
	GtkWidget* current = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkGrid* _tmp4_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (widget, gtk_widget_get_type ()));
	_tmp0_ = gtk_buildable_get_name (G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_buildable_get_type (), GtkBuildable));
	g_debug ("conversation-viewer.vala:371: Showing: %s", _tmp0_);
	_tmp1_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack));
	_tmp2_ = _g_object_ref0 (_tmp1_);
	current = _tmp2_;
	_tmp3_ = current;
	_tmp4_ = self->priv->conversation_page;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		GtkGrid* _tmp5_;
		_tmp5_ = self->priv->conversation_page;
		if (widget != G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget)) {
			GtkScrolledWindow* _tmp6_;
			GtkScrolledWindow* _tmp7_;
			_tmp6_ = conversation_viewer_remove_current_list (self);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp7_);
		}
	} else {
		GtkWidget* _tmp8_;
		GtkSpinner* _tmp9_;
		_tmp8_ = current;
		_tmp9_ = self->priv->loading_page;
		if (_tmp8_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget)) {
			GtkSpinner* _tmp10_;
			_tmp10_ = self->priv->loading_page;
			gtk_spinner_stop (_tmp10_);
		}
	}
	gtk_stack_set_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack), widget);
	_g_object_unref0 (current);
}

static void
conversation_viewer_update_find_results_data_free (gpointer _data)
{
	ConversationViewerUpdateFindResultsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ConversationViewerUpdateFindResultsData, _data_);
}

static void
conversation_viewer_update_find_results (ConversationViewer* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	ConversationViewerUpdateFindResultsData* _data_;
	ConversationViewer* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	_data_ = g_slice_new0 (ConversationViewerUpdateFindResultsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, conversation_viewer_update_find_results_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	conversation_viewer_update_find_results_co (_data_);
}

static void
conversation_viewer_update_find_results_finish (ConversationViewer* self,
                                                GAsyncResult* _res_)
{
	ConversationViewerUpdateFindResultsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block97Data*
block97_data_ref (Block97Data* _data97_)
{
	g_atomic_int_inc (&_data97_->_ref_count_);
	return _data97_;
}

static void
block97_data_unref (void * _userdata_)
{
	Block97Data* _data97_;
	_data97_ = (Block97Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data97_->_ref_count_)) {
		ConversationViewer* self;
		self = _data97_->self;
		_g_object_unref0 (_data97_->list);
		_g_object_unref0 (self);
		g_slice_free (Block97Data, _data97_);
	}
}

static void
___lambda156_ (Block97Data* _data97_)
{
	ConversationViewer* self;
	ConversationListBox* _tmp0_;
	ConversationListBoxSearchManager* _tmp1_;
	ConversationListBoxSearchManager* _tmp2_;
	self = _data97_->self;
	_tmp0_ = _data97_->list;
	_tmp1_ = conversation_list_box_get_search (_tmp0_);
	_tmp2_ = _tmp1_;
	conversation_list_box_search_manager_cancel (_tmp2_);
}

static void
____lambda156__g_cancellable_cancelled (GCancellable* _sender,
                                        gpointer self)
{
	___lambda156_ (self);
}

static void
conversation_viewer_update_find_results_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	ConversationViewerUpdateFindResultsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	conversation_viewer_update_find_results_co (_data_);
}

static gboolean
conversation_viewer_update_find_results_co (ConversationViewerUpdateFindResultsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data97_ = g_slice_new0 (Block97Data);
	_data_->_data97_->_ref_count_ = 1;
	_data_->_data97_->self = g_object_ref (_data_->self);
	_data_->_data97_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->_current_list;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->_data97_->list = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->_data97_->list;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->self->priv->find_cancellable;
		if (_data_->_tmp3_ != NULL) {
			_data_->_tmp4_ = _data_->self->priv->find_cancellable;
			g_cancellable_cancel (_data_->_tmp4_);
		}
		_data_->_tmp5_ = g_cancellable_new ();
		_data_->cancellable = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->cancellable;
		g_signal_connect_data (_data_->_tmp6_, "cancelled", (GCallback) ____lambda156__g_cancellable_cancelled, block97_data_ref (_data_->_data97_), (GClosureNotify) block97_data_unref, 0);
		_data_->_tmp7_ = _data_->cancellable;
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
		_g_object_unref0 (_data_->self->priv->find_cancellable);
		_data_->self->priv->find_cancellable = _data_->_tmp8_;
		{
			_data_->_tmp9_ = _data_->_data97_->list;
			_data_->_tmp10_ = conversation_list_box_get_conversation (_data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_data_->_tmp12_ = geary_app_conversation_get_base_folder (_data_->_tmp11_);
			_data_->_tmp13_ = _data_->_tmp12_;
			_data_->_tmp14_ = geary_folder_get_account (_data_->_tmp13_);
			_data_->_tmp15_ = _data_->_tmp14_;
			_data_->_tmp16_ = conversation_viewer_get_find_search_query (_data_->self, _data_->_tmp15_, &_data_->_inner_error0_);
			_data_->query = _data_->_tmp16_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp17_ = _data_->query;
			if (_data_->_tmp17_ != NULL) {
				_data_->_tmp18_ = _data_->_data97_->list;
				_data_->_tmp19_ = conversation_list_box_get_search (_data_->_tmp18_);
				_data_->_tmp20_ = _data_->_tmp19_;
				_data_->_tmp21_ = _data_->query;
				_data_->_state_ = 1;
				conversation_list_box_search_manager_highlight_matching_email (_data_->_tmp20_, _data_->_tmp21_, TRUE, conversation_viewer_update_find_results_ready, _data_);
				return FALSE;
				_state_1:
				conversation_list_box_search_manager_highlight_matching_email_finish (_data_->_tmp20_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->query);
					goto __catch0_g_error;
				}
			}
			_g_object_unref0 (_data_->query);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp22_ = _data_->err;
			_data_->_tmp23_ = _data_->_tmp22_->message;
			g_warning ("conversation-viewer.vala:408: Error updating find results: %s", _data_->_tmp23_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->cancellable);
			block97_data_unref (_data_->_data97_);
			_data_->_data97_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->cancellable);
	}
	block97_data_unref (_data_->_data97_);
	_data_->_data97_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static GearySearchQuery*
conversation_viewer_get_find_search_query (ConversationViewer* self,
                                           GearyAccount* account,
                                           GError** error)
{
	GearySearchQuery* query = NULL;
	GtkSearchBar* _tmp0_;
	GError* _inner_error0_ = NULL;
	GearySearchQuery* result;
	g_return_val_if_fail (IS_CONVERSATION_VIEWER (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT), NULL);
	query = NULL;
	_tmp0_ = self->conversation_find_bar;
	if (gtk_search_bar_get_search_mode (_tmp0_)) {
		gchar* text = NULL;
		GtkSearchEntry* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp1_ = self->conversation_find_entry;
		_tmp2_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_entry_get_type (), GtkEntry));
		_tmp3_ = string_strip (_tmp2_);
		text = _tmp3_;
		_tmp4_ = text;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ >= 2) {
			UtilEmailSearchExpressionFactory* expr_factory = NULL;
			ApplicationConfiguration* _tmp7_;
			GearyAccountInformation* _tmp8_;
			GearyAccountInformation* _tmp9_;
			UtilEmailSearchExpressionFactory* _tmp10_;
			GearySearchQuery* _tmp11_ = NULL;
			UtilEmailSearchExpressionFactory* _tmp12_;
			const gchar* _tmp13_;
			GeeList* _tmp14_;
			GeeList* _tmp15_;
			const gchar* _tmp16_;
			GearySearchQuery* _tmp17_;
			GearySearchQuery* _tmp18_;
			GearySearchQuery* _tmp19_;
			_tmp7_ = self->priv->config;
			_tmp8_ = geary_account_get_information (account);
			_tmp9_ = _tmp8_;
			_tmp10_ = util_email_search_expression_factory_new (application_configuration_get_search_strategy (_tmp7_), _tmp9_);
			expr_factory = _tmp10_;
			_tmp12_ = expr_factory;
			_tmp13_ = text;
			_tmp14_ = util_email_search_expression_factory_parse_query (_tmp12_, _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = text;
			_tmp17_ = geary_account_new_search_query (account, _tmp15_, _tmp16_, &_inner_error0_);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp15_);
			_tmp11_ = _tmp18_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (expr_factory);
				_g_free0 (text);
				_g_object_unref0 (query);
				return NULL;
			}
			_tmp19_ = _tmp11_;
			_tmp11_ = NULL;
			_g_object_unref0 (query);
			query = _tmp19_;
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (expr_factory);
		}
		_g_free0 (text);
	}
	result = query;
	return result;
}

static Block98Data*
block98_data_ref (Block98Data* _data98_)
{
	g_atomic_int_inc (&_data98_->_ref_count_);
	return _data98_;
}

static void
block98_data_unref (void * _userdata_)
{
	Block98Data* _data98_;
	_data98_ = (Block98Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data98_->_ref_count_)) {
		ConversationViewer* self;
		self = _data98_->self;
		_g_object_unref0 (_data98_->email_view);
		_g_object_unref0 (self);
		g_slice_free (Block98Data, _data98_);
	}
}

static void
_____lambda157_ (Block98Data* _data98_,
                 GObject* obj,
                 GAsyncResult* res)
{
	ConversationViewer* self;
	gchar* text = NULL;
	ConversationEmail* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	self = _data98_->self;
	g_return_if_fail ((obj == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (res, g_async_result_get_type ()));
	_tmp0_ = _data98_->email_view;
	_tmp1_ = conversation_email_get_selection_for_find_finish (_tmp0_, res);
	text = _tmp1_;
	_tmp2_ = text;
	if (_tmp2_ != NULL) {
		GtkSearchEntry* _tmp3_;
		const gchar* _tmp4_;
		GtkSearchEntry* _tmp5_;
		_tmp3_ = self->conversation_find_entry;
		_tmp4_ = text;
		gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_entry_get_type (), GtkEntry), _tmp4_);
		_tmp5_ = self->conversation_find_entry;
		gtk_editable_select_region (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_editable_get_type (), GtkEditable), 0, -1);
	}
	_g_free0 (text);
}

static void
______lambda157__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self)
{
	_____lambda157_ (self, source_object, res);
	block98_data_unref (self);
}

static void
conversation_viewer_on_find_mode_changed (ConversationViewer* self,
                                          GObject* obj,
                                          GParamSpec* param)
{
	ConversationListBox* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (obj, G_TYPE_OBJECT));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (param, G_TYPE_PARAM));
	_tmp0_ = self->priv->_current_list;
	if (_tmp0_ != NULL) {
		GtkSearchBar* _tmp1_;
		_tmp1_ = self->conversation_find_bar;
		if (gtk_search_bar_get_search_mode (_tmp1_)) {
			Block98Data* _data98_;
			ConversationListBox* _tmp2_;
			ConversationEmail* _tmp3_;
			ConversationEmail* _tmp4_;
			_data98_ = g_slice_new0 (Block98Data);
			_data98_->_ref_count_ = 1;
			_data98_->self = g_object_ref (self);
			_tmp2_ = self->priv->_current_list;
			_tmp3_ = conversation_list_box_get_selection_view (_tmp2_);
			_data98_->email_view = _tmp3_;
			_tmp4_ = _data98_->email_view;
			if (_tmp4_ != NULL) {
				ConversationEmail* _tmp5_;
				_tmp5_ = _data98_->email_view;
				conversation_email_get_selection_for_find (_tmp5_, ______lambda157__gasync_ready_callback, block98_data_ref (_data98_));
			}
			block98_data_unref (_data98_);
			_data98_ = NULL;
		} else {
			ConversationListBox* _tmp6_;
			ConversationListBoxSearchManager* _tmp7_;
			ConversationListBoxSearchManager* _tmp8_;
			GearyAppSearchFolder* search_folder = NULL;
			ConversationListBox* _tmp9_;
			GearyAppConversation* _tmp10_;
			GearyAppConversation* _tmp11_;
			GearyFolder* _tmp12_;
			GearyFolder* _tmp13_;
			GearyAppSearchFolder* _tmp14_;
			ComponentsEntryUndo* _tmp15_;
			GearyAppSearchFolder* _tmp16_;
			_tmp6_ = self->priv->_current_list;
			_tmp7_ = conversation_list_box_get_search (_tmp6_);
			_tmp8_ = _tmp7_;
			conversation_list_box_search_manager_unmark_terms (_tmp8_);
			_tmp9_ = self->priv->_current_list;
			_tmp10_ = conversation_list_box_get_conversation (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = geary_app_conversation_get_base_folder (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, GEARY_APP_TYPE_SEARCH_FOLDER) ? ((GearyAppSearchFolder*) _tmp13_) : NULL);
			search_folder = _tmp14_;
			_tmp15_ = self->priv->conversation_find_undo;
			components_entry_undo_reset (_tmp15_);
			_tmp16_ = search_folder;
			if (_tmp16_ != NULL) {
				GearySearchQuery* query = NULL;
				GearyAppSearchFolder* _tmp17_;
				GearySearchQuery* _tmp18_;
				GearySearchQuery* _tmp19_;
				GearySearchQuery* _tmp20_;
				GearySearchQuery* _tmp21_;
				_tmp17_ = search_folder;
				_tmp18_ = geary_app_search_folder_get_query (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				query = _tmp20_;
				_tmp21_ = query;
				if (_tmp21_ != NULL) {
					ConversationListBox* _tmp22_;
					ConversationListBoxSearchManager* _tmp23_;
					ConversationListBoxSearchManager* _tmp24_;
					GearySearchQuery* _tmp25_;
					_tmp22_ = self->priv->_current_list;
					_tmp23_ = conversation_list_box_get_search (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = query;
					conversation_list_box_search_manager_highlight_matching_email (_tmp24_, _tmp25_, TRUE, NULL, NULL);
				}
				_g_object_unref0 (query);
			}
			_g_object_unref0 (search_folder);
		}
	}
}

static void
_conversation_viewer_on_find_mode_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	conversation_viewer_on_find_mode_changed ((ConversationViewer*) self, _sender, pspec);
}

static void
conversation_viewer_on_find_text_changed (ConversationViewer* self,
                                          GtkSearchEntry* entry)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (entry, gtk_search_entry_get_type ()));
	_tmp0_ = self->priv->conversation_find_next;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp1_ = self->priv->conversation_find_prev;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	conversation_viewer_update_find_results (self, NULL, NULL);
}

static void
_conversation_viewer_on_find_text_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                           gpointer self)
{
	conversation_viewer_on_find_text_changed ((ConversationViewer*) self, _sender);
}

static void
conversation_viewer_on_find_next (ConversationViewer* self,
                                  GtkWidget* entry)
{
	ConversationListBox* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (entry, gtk_widget_get_type ()));
	_tmp0_ = self->priv->_current_list;
	if (_tmp0_ != NULL) {
	}
}

static void
_conversation_viewer_on_find_next_gtk_button_activate (GtkButton* _sender,
                                                       gpointer self)
{
	conversation_viewer_on_find_next ((ConversationViewer*) self, _sender);
}

static void
conversation_viewer_on_find_prev (ConversationViewer* self,
                                  GtkWidget* entry)
{
	ConversationListBox* _tmp0_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (entry, gtk_widget_get_type ()));
	_tmp0_ = self->priv->_current_list;
	if (_tmp0_ != NULL) {
	}
}

static void
_conversation_viewer_on_find_prev_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self)
{
	conversation_viewer_on_find_prev ((ConversationViewer*) self, _sender);
}

static gboolean
conversation_viewer_on_conversation_scroll (ConversationViewer* self)
{
	ConversationListBox* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_CONVERSATION_VIEWER (self), FALSE);
	_tmp0_ = self->priv->_current_list;
	if (_tmp0_ != NULL) {
		ConversationListBox* _tmp1_;
		_tmp1_ = self->priv->_current_list;
		conversation_list_box_mark_visible_read (_tmp1_);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
conversation_viewer_on_composer_closed (ConversationViewer* self)
{
	GtkWidget* _tmp0_;
	GtkGrid* _tmp1_;
	g_return_if_fail (IS_CONVERSATION_VIEWER (self));
	conversation_viewer_set_current_composer (self, NULL);
	_tmp0_ = gtk_stack_get_visible_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_stack_get_type (), GtkStack));
	_tmp1_ = self->priv->composer_page;
	if (_tmp0_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget)) {
		GtkGrid* _tmp2_;
		ApplicationMainWindow* main_window = NULL;
		GtkWidget* _tmp3_;
		ApplicationMainWindow* _tmp4_;
		ApplicationMainWindow* _tmp5_;
		_tmp2_ = self->priv->conversation_page;
		conversation_viewer_set_visible_child (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
		_tmp3_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp4_ = _g_object_ref0 (APPLICATION_IS_MAIN_WINDOW (_tmp3_) ? ((ApplicationMainWindow*) _tmp3_) : NULL);
		main_window = _tmp4_;
		_tmp5_ = main_window;
		if (_tmp5_ != NULL) {
			ApplicationMainWindow* _tmp6_;
			GeeSet* _tmp7_;
			_tmp6_ = main_window;
			application_main_window_update_title (_tmp6_);
			_tmp7_ = self->priv->selection_while_composing;
			if (_tmp7_ != NULL) {
				ConversationListView* conversation_list = NULL;
				ApplicationMainWindow* _tmp8_;
				ConversationListView* _tmp9_;
				ConversationListView* _tmp10_;
				ConversationListView* _tmp11_;
				GeeSet* _tmp12_;
				gboolean _tmp13_;
				gboolean _tmp14_;
				_tmp8_ = main_window;
				_tmp9_ = application_main_window_get_conversation_list_view (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				conversation_list = _tmp11_;
				_tmp12_ = self->priv->selection_while_composing;
				_tmp13_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp14_ = _tmp13_;
				if (_tmp14_) {
					ConversationListView* _tmp15_;
					GeeSet* _tmp16_;
					_tmp15_ = conversation_list;
					_tmp16_ = self->priv->selection_while_composing;
					g_signal_emit_by_name (_tmp15_, "conversations-selected", _tmp16_);
				} else {
					ConversationListView* _tmp17_;
					GeeSet* _tmp18_;
					_tmp17_ = conversation_list;
					_tmp18_ = self->priv->selection_while_composing;
					conversation_list_view_select_conversations (_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_COLLECTION, GeeCollection));
				}
				_g_object_unref0 (self->priv->selection_while_composing);
				self->priv->selection_while_composing = NULL;
				_g_object_unref0 (conversation_list);
			}
		}
		_g_object_unref0 (main_window);
	}
}

static void
conversation_viewer_class_init (ConversationViewerClass * klass,
                                gpointer klass_data)
{
	conversation_viewer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ConversationViewer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_conversation_viewer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_conversation_viewer_set_property;
	G_OBJECT_CLASS (klass)->finalize = conversation_viewer_finalize;
	/**
	     * The current conversation listbox, if any.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_VIEWER_CURRENT_LIST_PROPERTY, conversation_viewer_properties[CONVERSATION_VIEWER_CURRENT_LIST_PROPERTY] = g_param_spec_object ("current-list", "current-list", "current-list", TYPE_CONVERSATION_LIST_BOX, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns the currently displayed composer if any. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_VIEWER_CURRENT_COMPOSER_PROPERTY, conversation_viewer_properties[CONVERSATION_VIEWER_CURRENT_COMPOSER_PROPERTY] = g_param_spec_object ("current-composer", "current-composer", "current-composer", COMPOSER_TYPE_WIDGET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The most recent web view created in this viewer.
	     *
	     * Keep the last created web view around so others can share the
	     * same WebKitGTK WebProcess.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONVERSATION_VIEWER_PREVIOUS_WEB_VIEW_PROPERTY, conversation_viewer_properties[CONVERSATION_VIEWER_PREVIOUS_WEB_VIEW_PROPERTY] = g_param_spec_object ("previous-web-view", "previous-web-view", "previous-web-view", TYPE_CONVERSATION_WEB_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Geary/conversation-viewer.ui");
	conversation_viewer_signals[CONVERSATION_VIEWER_CONVERSATION_ADDED_SIGNAL] = g_signal_new ("conversation-added", TYPE_CONVERSATION_VIEWER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CONVERSATION_LIST_BOX);
	conversation_viewer_signals[CONVERSATION_VIEWER_CONVERSATION_REMOVED_SIGNAL] = g_signal_new ("conversation-removed", TYPE_CONVERSATION_VIEWER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CONVERSATION_LIST_BOX);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "loading_page", FALSE, ConversationViewer_private_offset + G_STRUCT_OFFSET (ConversationViewerPrivate, loading_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "no_conversations_page", FALSE, ConversationViewer_private_offset + G_STRUCT_OFFSET (ConversationViewerPrivate, no_conversations_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_page", FALSE, ConversationViewer_private_offset + G_STRUCT_OFFSET (ConversationViewerPrivate, conversation_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "multiple_conversations_page", FALSE, ConversationViewer_private_offset + G_STRUCT_OFFSET (ConversationViewerPrivate, multiple_conversations_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "empty_folder_page", FALSE, ConversationViewer_private_offset + G_STRUCT_OFFSET (ConversationViewerPrivate, empty_folder_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "empty_search_page", FALSE, ConversationViewer_private_offset + G_STRUCT_OFFSET (ConversationViewerPrivate, empty_search_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "composer_page", FALSE, ConversationViewer_private_offset + G_STRUCT_OFFSET (ConversationViewerPrivate, composer_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_find_bar", FALSE, G_STRUCT_OFFSET (ConversationViewer, conversation_find_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_find_entry", FALSE, G_STRUCT_OFFSET (ConversationViewer, conversation_find_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_find_next", FALSE, ConversationViewer_private_offset + G_STRUCT_OFFSET (ConversationViewerPrivate, conversation_find_next));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_find_prev", FALSE, ConversationViewer_private_offset + G_STRUCT_OFFSET (ConversationViewerPrivate, conversation_find_prev));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_find_mode_changed", G_CALLBACK(_conversation_viewer_on_find_mode_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_find_text_changed", G_CALLBACK(_conversation_viewer_on_find_text_changed_gtk_search_entry_search_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_find_next", G_CALLBACK(_conversation_viewer_on_find_next_gtk_button_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_find_prev", G_CALLBACK(_conversation_viewer_on_find_prev_gtk_button_clicked));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "geary-conversation-viewer");
}

static void
conversation_viewer_geary_base_interface_interface_init (GearyBaseInterfaceIface * iface,
                                                         gpointer iface_data)
{
	conversation_viewer_geary_base_interface_parent_iface = g_type_interface_peek_parent (iface);
}

static void
conversation_viewer_instance_init (ConversationViewer * self,
                                   gpointer klass)
{
	self->priv = conversation_viewer_get_instance_private (self);
	self->priv->_current_list = NULL;
	self->priv->_current_composer = NULL;
	self->priv->_previous_web_view = NULL;
	self->priv->selection_while_composing = NULL;
	self->priv->find_cancellable = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
conversation_viewer_finalize (GObject * obj)
{
	ConversationViewer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONVERSATION_VIEWER, ConversationViewer);
	geary_base_interface_base_unref (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_BASE_INTERFACE, GearyBaseInterface));
	_g_object_unref0 (self->priv->_current_list);
	_g_object_unref0 (self->priv->_current_composer);
	_g_object_unref0 (self->priv->_previous_web_view);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->selection_while_composing);
	_g_object_unref0 (self->priv->find_cancellable);
	_g_object_unref0 (self->priv->conversation_scroller);
	_g_object_unref0 (self->priv->conversation_find_undo);
	G_OBJECT_CLASS (conversation_viewer_parent_class)->finalize (obj);
}

/**
 * Displays the messages in a conversation and in-window composers.
 */
static GType
conversation_viewer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConversationViewerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) conversation_viewer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConversationViewer), 0, (GInstanceInitFunc) conversation_viewer_instance_init, NULL };
	static const GInterfaceInfo geary_base_interface_info = { (GInterfaceInitFunc) conversation_viewer_geary_base_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType conversation_viewer_type_id;
	conversation_viewer_type_id = g_type_register_static (gtk_stack_get_type (), "ConversationViewer", &g_define_type_info, 0);
	g_type_add_interface_static (conversation_viewer_type_id, GEARY_TYPE_BASE_INTERFACE, &geary_base_interface_info);
	ConversationViewer_private_offset = g_type_add_instance_private (conversation_viewer_type_id, sizeof (ConversationViewerPrivate));
	return conversation_viewer_type_id;
}

GType
conversation_viewer_get_type (void)
{
	static volatile gsize conversation_viewer_type_id__once = 0;
	if (g_once_init_enter (&conversation_viewer_type_id__once)) {
		GType conversation_viewer_type_id;
		conversation_viewer_type_id = conversation_viewer_get_type_once ();
		g_once_init_leave (&conversation_viewer_type_id__once, conversation_viewer_type_id);
	}
	return conversation_viewer_type_id__once;
}

static void
_vala_conversation_viewer_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ConversationViewer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CONVERSATION_VIEWER, ConversationViewer);
	switch (property_id) {
		case CONVERSATION_VIEWER_CURRENT_LIST_PROPERTY:
		g_value_set_object (value, conversation_viewer_get_current_list (self));
		break;
		case CONVERSATION_VIEWER_CURRENT_COMPOSER_PROPERTY:
		g_value_set_object (value, conversation_viewer_get_current_composer (self));
		break;
		case CONVERSATION_VIEWER_PREVIOUS_WEB_VIEW_PROPERTY:
		g_value_set_object (value, conversation_viewer_get_previous_web_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_conversation_viewer_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ConversationViewer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CONVERSATION_VIEWER, ConversationViewer);
	switch (property_id) {
		case CONVERSATION_VIEWER_CURRENT_LIST_PROPERTY:
		conversation_viewer_set_current_list (self, g_value_get_object (value));
		break;
		case CONVERSATION_VIEWER_CURRENT_COMPOSER_PROPERTY:
		conversation_viewer_set_current_composer (self, g_value_get_object (value));
		break;
		case CONVERSATION_VIEWER_PREVIOUS_WEB_VIEW_PROPERTY:
		conversation_viewer_set_previous_web_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

