/* attachment-dialog.c generated by valac 0.56.3, the Vala compiler
 * generated from attachment-dialog.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define ATTACHMENT_DIALOG_PREVIEW_SIZE 180
#define ATTACHMENT_DIALOG_PREVIEW_PADDING 3

enum  {
	ATTACHMENT_DIALOG_0_PROPERTY,
	ATTACHMENT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* attachment_dialog_properties[ATTACHMENT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GdkPixbufFormat_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkPixbufFormat_free (var), NULL)))

struct _AttachmentDialogPrivate {
	ApplicationConfiguration* config;
	GtkFileChooserNative* chooser;
	GtkImage* preview_image;
};

static gint AttachmentDialog_private_offset;
static gpointer attachment_dialog_parent_class = NULL;

static void attachment_dialog_on_update_preview (AttachmentDialog* self);
static void _attachment_dialog_on_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender,
                                                                           gpointer self);
static GdkPixbufFormat* _vala_GdkPixbufFormat_copy (GdkPixbufFormat* self);
static void _vala_GdkPixbufFormat_free (GdkPixbufFormat* self);
static void attachment_dialog_finalize (GObject * obj);
static GType attachment_dialog_get_type_once (void);

static inline gpointer
attachment_dialog_get_instance_private (AttachmentDialog* self)
{
	return G_STRUCT_MEMBER_P (self, AttachmentDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_attachment_dialog_on_update_preview_gtk_file_chooser_update_preview (GtkFileChooser* _sender,
                                                                      gpointer self)
{
	attachment_dialog_on_update_preview ((AttachmentDialog*) self);
}

AttachmentDialog*
attachment_dialog_construct (GType object_type,
                             GtkWindow* parent,
                             ApplicationConfiguration* config)
{
	AttachmentDialog * self = NULL;
	ApplicationConfiguration* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	GtkFileChooserNative* _tmp3_;
	GtkFileChooserNative* _tmp4_;
	GtkImage* _tmp5_;
	GtkFileChooserNative* _tmp6_;
	GtkFileChooserNative* _tmp7_;
	g_return_val_if_fail ((parent == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (parent, gtk_window_get_type ()), NULL);
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	self = (AttachmentDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->config);
	self->priv->config = _tmp0_;
	_tmp1_ = gtk_file_chooser_native_new (_ ("Choose a file"), parent, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Attach"), STOCK__CANCEL);
	_g_object_unref0 (self->priv->chooser);
	self->priv->chooser = _tmp1_;
	_tmp2_ = self->priv->chooser;
	gtk_file_chooser_set_local_only (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_file_chooser_get_type (), GtkFileChooser), FALSE);
	_tmp3_ = self->priv->chooser;
	gtk_file_chooser_set_select_multiple (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_file_chooser_get_type (), GtkFileChooser), TRUE);
	_tmp4_ = self->priv->chooser;
	_tmp5_ = self->priv->preview_image;
	gtk_file_chooser_set_preview_widget (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_file_chooser_get_type (), GtkFileChooser), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = self->priv->chooser;
	gtk_file_chooser_set_use_preview_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_file_chooser_get_type (), GtkFileChooser), FALSE);
	_tmp7_ = self->priv->chooser;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_file_chooser_get_type (), GtkFileChooser), "update-preview", (GCallback) _attachment_dialog_on_update_preview_gtk_file_chooser_update_preview, self, 0);
	return self;
}

AttachmentDialog*
attachment_dialog_new (GtkWindow* parent,
                       ApplicationConfiguration* config)
{
	return attachment_dialog_construct (TYPE_ATTACHMENT_DIALOG, parent, config);
}

void
attachment_dialog_add_filter (AttachmentDialog* self,
                              GtkFileFilter* filter)
{
	GtkFileChooserNative* _tmp0_;
	GtkFileFilter* _tmp1_;
	g_return_if_fail (IS_ATTACHMENT_DIALOG (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (filter, gtk_file_filter_get_type ()));
	_tmp0_ = self->priv->chooser;
	_tmp1_ = _g_object_ref0 (filter);
	gtk_file_chooser_add_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_file_chooser_get_type (), GtkFileChooser), _tmp1_);
	_g_object_unref0 (filter);
}

GSList*
attachment_dialog_get_files (AttachmentDialog* self)
{
	GtkFileChooserNative* _tmp0_;
	GSList* _tmp1_;
	GSList* result;
	g_return_val_if_fail (IS_ATTACHMENT_DIALOG (self), NULL);
	_tmp0_ = self->priv->chooser;
	_tmp1_ = gtk_file_chooser_get_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_file_chooser_get_type (), GtkFileChooser));
	result = _tmp1_;
	return result;
}

gint
attachment_dialog_run (AttachmentDialog* self)
{
	GtkFileChooserNative* _tmp0_;
	gint result;
	g_return_val_if_fail (IS_ATTACHMENT_DIALOG (self), 0);
	_tmp0_ = self->priv->chooser;
	result = gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_native_dialog_get_type (), GtkNativeDialog));
	return result;
}

void
attachment_dialog_hide (AttachmentDialog* self)
{
	GtkFileChooserNative* _tmp0_;
	g_return_if_fail (IS_ATTACHMENT_DIALOG (self));
	_tmp0_ = self->priv->chooser;
	gtk_native_dialog_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_native_dialog_get_type (), GtkNativeDialog));
}

void
attachment_dialog_destroy (AttachmentDialog* self)
{
	GtkFileChooserNative* _tmp0_;
	g_return_if_fail (IS_ATTACHMENT_DIALOG (self));
	_tmp0_ = self->priv->chooser;
	gtk_native_dialog_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_native_dialog_get_type (), GtkNativeDialog));
}

static GdkPixbufFormat*
_vala_GdkPixbufFormat_copy (GdkPixbufFormat* self)
{
	return g_boxed_copy (gdk_pixbuf_format_get_type (), self);
}

static gpointer
__vala_GdkPixbufFormat_copy0 (gpointer self)
{
	return self ? _vala_GdkPixbufFormat_copy (self) : NULL;
}

static void
_vala_GdkPixbufFormat_free (GdkPixbufFormat* self)
{
	g_boxed_free (gdk_pixbuf_format_get_type (), self);
}

static void
attachment_dialog_on_update_preview (AttachmentDialog* self)
{
	gchar* filename = NULL;
	GtkFileChooserNative* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint width = 0;
	gint height = 0;
	GdkPixbufFormat* format = NULL;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GdkPixbufFormat* _tmp7_;
	GdkPixbufFormat* _tmp8_;
	GdkPixbufFormat* _tmp9_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp16_;
	GdkPixbuf* _tmp18_;
	GdkPixbuf* _tmp19_;
	gint extra_space = 0;
	GdkPixbuf* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint smaller_half = 0;
	gint larger_half = 0;
	GtkImage* _tmp23_;
	GtkImage* _tmp24_;
	GtkImage* _tmp25_;
	GdkPixbuf* _tmp26_;
	GtkFileChooserNative* _tmp27_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_ATTACHMENT_DIALOG (self));
	_tmp0_ = self->priv->chooser;
	_tmp1_ = gtk_file_chooser_get_preview_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_file_chooser_get_type (), GtkFileChooser));
	filename = _tmp1_;
	_tmp2_ = filename;
	if (_tmp2_ == NULL) {
		GtkFileChooserNative* _tmp3_;
		_tmp3_ = self->priv->chooser;
		gtk_file_chooser_set_preview_widget_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_file_chooser_get_type (), GtkFileChooser), FALSE);
		_g_free0 (filename);
		return;
	}
	width = 0;
	height = 0;
	_tmp4_ = filename;
	_tmp7_ = gdk_pixbuf_get_file_info (_tmp4_, &_tmp5_, &_tmp6_);
	width = _tmp5_;
	height = _tmp6_;
	_tmp8_ = __vala_GdkPixbufFormat_copy0 (_tmp7_);
	format = _tmp8_;
	_tmp9_ = format;
	if (_tmp9_ == NULL) {
		GtkFileChooserNative* _tmp10_;
		_tmp10_ = self->priv->chooser;
		gtk_file_chooser_set_preview_widget_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_file_chooser_get_type (), GtkFileChooser), FALSE);
		__vala_GdkPixbufFormat_free0 (format);
		_g_free0 (filename);
		return;
	}
	{
		GdkPixbuf* _tmp11_ = NULL;
		const gchar* _tmp12_;
		GdkPixbuf* _tmp13_;
		GdkPixbuf* _tmp14_;
		_tmp12_ = filename;
		_tmp13_ = gdk_pixbuf_new_from_file_at_scale (_tmp12_, ATTACHMENT_DIALOG_PREVIEW_SIZE, ATTACHMENT_DIALOG_PREVIEW_SIZE, TRUE, &_inner_error0_);
		_tmp11_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp14_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp14_;
		_g_object_unref0 (_tmp11_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GtkFileChooserNative* _tmp15_;
		g_clear_error (&_inner_error0_);
		_tmp15_ = self->priv->chooser;
		gtk_file_chooser_set_preview_widget_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_file_chooser_get_type (), GtkFileChooser), FALSE);
		_g_object_unref0 (pixbuf);
		__vala_GdkPixbufFormat_free0 (format);
		_g_free0 (filename);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		__vala_GdkPixbufFormat_free0 (format);
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp16_ = pixbuf;
	if (_tmp16_ == NULL) {
		GtkFileChooserNative* _tmp17_;
		_tmp17_ = self->priv->chooser;
		gtk_file_chooser_set_preview_widget_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_file_chooser_get_type (), GtkFileChooser), FALSE);
		_g_object_unref0 (pixbuf);
		__vala_GdkPixbufFormat_free0 (format);
		_g_free0 (filename);
		return;
	}
	_tmp18_ = pixbuf;
	_tmp19_ = gdk_pixbuf_apply_embedded_orientation (_tmp18_);
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp19_;
	_tmp20_ = pixbuf;
	_tmp21_ = gdk_pixbuf_get_width (_tmp20_);
	_tmp22_ = _tmp21_;
	extra_space = ATTACHMENT_DIALOG_PREVIEW_SIZE - _tmp22_;
	smaller_half = extra_space / 2;
	larger_half = extra_space - smaller_half;
	_tmp23_ = self->priv->preview_image;
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), ATTACHMENT_DIALOG_PREVIEW_PADDING + smaller_half);
	_tmp24_ = self->priv->preview_image;
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget), ATTACHMENT_DIALOG_PREVIEW_PADDING + larger_half);
	_tmp25_ = self->priv->preview_image;
	_tmp26_ = pixbuf;
	gtk_image_set_from_pixbuf (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->chooser;
	gtk_file_chooser_set_preview_widget_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_file_chooser_get_type (), GtkFileChooser), TRUE);
	_g_object_unref0 (pixbuf);
	__vala_GdkPixbufFormat_free0 (format);
	_g_free0 (filename);
}

static void
attachment_dialog_class_init (AttachmentDialogClass * klass,
                              gpointer klass_data)
{
	attachment_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AttachmentDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = attachment_dialog_finalize;
}

static void
attachment_dialog_instance_init (AttachmentDialog * self,
                                 gpointer klass)
{
	GtkImage* _tmp0_;
	self->priv = attachment_dialog_get_instance_private (self);
	self->priv->chooser = NULL;
	_tmp0_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->preview_image = _tmp0_;
}

static void
attachment_dialog_finalize (GObject * obj)
{
	AttachmentDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ATTACHMENT_DIALOG, AttachmentDialog);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->chooser);
	_g_object_unref0 (self->priv->preview_image);
	G_OBJECT_CLASS (attachment_dialog_parent_class)->finalize (obj);
}

/**
 * A FileChooser-like object for choosing attachments for a message.
 */
static GType
attachment_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AttachmentDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) attachment_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AttachmentDialog), 0, (GInstanceInitFunc) attachment_dialog_instance_init, NULL };
	GType attachment_dialog_type_id;
	attachment_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "AttachmentDialog", &g_define_type_info, 0);
	AttachmentDialog_private_offset = g_type_add_instance_private (attachment_dialog_type_id, sizeof (AttachmentDialogPrivate));
	return attachment_dialog_type_id;
}

GType
attachment_dialog_get_type (void)
{
	static volatile gsize attachment_dialog_type_id__once = 0;
	if (g_once_init_enter (&attachment_dialog_type_id__once)) {
		GType attachment_dialog_type_id;
		attachment_dialog_type_id = attachment_dialog_get_type_once ();
		g_once_init_leave (&attachment_dialog_type_id__once, attachment_dialog_type_id);
	}
	return attachment_dialog_type_id__once;
}

