/* util-avatar.c generated by valac 0.56.3, the Vala compiler
 * generated from util-avatar.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>

#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

static void _vala_PangoFontDescription_free (PangoFontDescription* self);

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

GdkPixbuf*
util_avatar_generate_user_picture (const gchar* name,
                                   gint size)
{
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	GdkRGBA color = {0};
	GdkRGBA _tmp4_ = {0};
	cairo_t* _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	cairo_t* _tmp9_;
	gchar* initials = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	cairo_surface_t* _tmp29_;
	GdkPixbuf* _tmp30_;
	GdkPixbuf* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, size, size);
	surface = _tmp0_;
	_tmp1_ = surface;
	_tmp2_ = cairo_create (_tmp1_);
	cr = _tmp2_;
	_tmp3_ = cr;
	cairo_rectangle (_tmp3_, (gdouble) 0, (gdouble) 0, (gdouble) size, (gdouble) size);
	util_avatar_get_color_for_name (name, &_tmp4_);
	color = _tmp4_;
	_tmp5_ = cr;
	_tmp6_ = color;
	_tmp7_ = color;
	_tmp8_ = color;
	cairo_set_source_rgb (_tmp5_, _tmp6_.red / 255.0, _tmp7_.green / 255.0, _tmp8_.blue / 255.0);
	_tmp9_ = cr;
	cairo_fill (_tmp9_);
	_tmp10_ = util_avatar_extract_initials_from_name (name);
	initials = _tmp10_;
	_tmp11_ = initials;
	if (_tmp11_ != NULL) {
		gchar* font = NULL;
		gchar* _tmp12_;
		cairo_t* _tmp13_;
		PangoLayout* layout = NULL;
		cairo_t* _tmp14_;
		PangoLayout* _tmp15_;
		PangoLayout* _tmp16_;
		const gchar* _tmp17_;
		PangoLayout* _tmp18_;
		const gchar* _tmp19_;
		PangoFontDescription* _tmp20_;
		PangoFontDescription* _tmp21_;
		gint width = 0;
		gint height = 0;
		PangoLayout* _tmp22_;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		cairo_t* _tmp25_;
		cairo_t* _tmp26_;
		cairo_t* _tmp27_;
		PangoLayout* _tmp28_;
		_tmp12_ = g_strdup_printf ("Sans %d", (gint) ceil (size / 2.5));
		font = _tmp12_;
		_tmp13_ = cr;
		cairo_set_source_rgb (_tmp13_, 1.0, 1.0, 1.0);
		_tmp14_ = cr;
		_tmp15_ = pango_cairo_create_layout (_tmp14_);
		layout = _tmp15_;
		_tmp16_ = layout;
		_tmp17_ = initials;
		pango_layout_set_text (_tmp16_, _tmp17_, -1);
		_tmp18_ = layout;
		_tmp19_ = font;
		_tmp20_ = pango_font_description_from_string (_tmp19_);
		_tmp21_ = _tmp20_;
		pango_layout_set_font_description (_tmp18_, _tmp21_);
		__vala_PangoFontDescription_free0 (_tmp21_);
		_tmp22_ = layout;
		pango_layout_get_size (_tmp22_, &_tmp23_, &_tmp24_);
		width = _tmp23_;
		height = _tmp24_;
		_tmp25_ = cr;
		cairo_translate (_tmp25_, (gdouble) (size / 2), (gdouble) (size / 2));
		_tmp26_ = cr;
		cairo_move_to (_tmp26_, (-(((gdouble) width) / PANGO_SCALE)) / 2, (-(((gdouble) height) / PANGO_SCALE)) / 2);
		_tmp27_ = cr;
		_tmp28_ = layout;
		pango_cairo_show_layout (_tmp27_, _tmp28_);
		_g_object_unref0 (layout);
		_g_free0 (font);
	}
	_tmp29_ = surface;
	_tmp30_ = gdk_pixbuf_get_from_surface (_tmp29_, 0, 0, size, size);
	result = _tmp30_;
	_g_free0 (initials);
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	return result;
}

GdkPixbuf*
util_avatar_round_image (GdkPixbuf* source)
{
	gint size = 0;
	gint _tmp0_;
	gint _tmp1_;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp2_;
	cairo_t* cr = NULL;
	cairo_t* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (source, gdk_pixbuf_get_type ()), NULL);
	_tmp0_ = gdk_pixbuf_get_width (source);
	_tmp1_ = _tmp0_;
	size = _tmp1_;
	_tmp2_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, size, size);
	surface = _tmp2_;
	_tmp3_ = cairo_create (surface);
	cr = _tmp3_;
	cairo_arc (cr, (gdouble) (size / 2), (gdouble) (size / 2), (gdouble) (size / 2), (gdouble) 0, 2 * G_PI);
	cairo_clip (cr);
	cairo_new_path (cr);
	gdk_cairo_set_source_pixbuf (cr, source, (gdouble) 0, (gdouble) 0);
	cairo_paint (cr);
	_tmp4_ = gdk_pixbuf_get_from_surface (surface, 0, 0, size, size);
	result = _tmp4_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static guint8*
g_string_get_data (GString* self,
                   gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	const gchar* _tmp0_;
	gint res_length1;
	gint _res_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->str;
	res = (guint8*) _tmp0_;
	res_length1 = -1;
	_res_size_ = res_length1;
	res_length1 = (gint) self->len;
	_tmp1_ = res;
	_tmp1__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

gchar*
util_avatar_extract_initials_from_name (const gchar* name)
{
	gchar* normalized = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* initials = NULL;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = string_strip (name);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_normalize (_tmp1_, (gssize) -1, G_NORMALIZE_DEFAULT_COMPOSE);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	normalized = _tmp3_;
	initials = NULL;
	_tmp4_ = normalized;
	if (g_strcmp0 (_tmp4_, "") != 0) {
		GString* buf = NULL;
		GString* _tmp5_;
		gunichar c = 0U;
		gint index = 0;
		const gchar* _tmp12_;
		GString* _tmp19_;
		guint8* _tmp20_;
		gint _tmp20__length1;
		gint _tmp21_ = 0;
		guint8* _tmp22_;
		gint _tmp22__length1;
		_tmp5_ = g_string_new ("");
		buf = _tmp5_;
		c = (gunichar) 0;
		index = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					const gchar* _tmp8_;
					gunichar _tmp9_ = 0U;
					gboolean _tmp10_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = normalized;
					_tmp10_ = string_get_next_char (_tmp8_, &index, &_tmp9_);
					c = _tmp9_;
					if (!_tmp10_) {
						break;
					}
					if (g_unichar_isalnum (c)) {
						GString* _tmp11_;
						_tmp11_ = buf;
						g_string_append_unichar (_tmp11_, g_unichar_toupper (c));
						break;
					}
				}
			}
		}
		_tmp12_ = normalized;
		index = string_last_index_of_char (_tmp12_, (gunichar) ' ', 0);
		if (index >= 0) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp13_ = FALSE;
					_tmp13_ = TRUE;
					while (TRUE) {
						const gchar* _tmp15_;
						gunichar _tmp16_ = 0U;
						gboolean _tmp17_;
						if (!_tmp13_) {
							gint _tmp14_;
							_tmp14_ = i;
							i = _tmp14_ + 1;
						}
						_tmp13_ = FALSE;
						_tmp15_ = normalized;
						_tmp17_ = string_get_next_char (_tmp15_, &index, &_tmp16_);
						c = _tmp16_;
						if (!_tmp17_) {
							break;
						}
						if (g_unichar_isalnum (c)) {
							GString* _tmp18_;
							_tmp18_ = buf;
							g_string_append_unichar (_tmp18_, g_unichar_toupper (c));
							break;
						}
					}
				}
			}
		}
		_tmp19_ = buf;
		_tmp20_ = g_string_get_data (_tmp19_, &_tmp21_);
		_tmp20__length1 = _tmp21_;
		_tmp22_ = _tmp20_;
		_tmp22__length1 = _tmp20__length1;
		if (_tmp22__length1 > 0) {
			GString* _tmp23_;
			guint8* _tmp24_;
			gint _tmp24__length1;
			gint _tmp25_ = 0;
			guint8* _tmp26_;
			gint _tmp26__length1;
			gchar* _tmp27_;
			_tmp23_ = buf;
			_tmp24_ = g_string_get_data (_tmp23_, &_tmp25_);
			_tmp24__length1 = _tmp25_;
			_tmp26_ = _tmp24_;
			_tmp26__length1 = _tmp24__length1;
			_tmp27_ = g_strdup ((const gchar*) _tmp26_);
			_g_free0 (initials);
			initials = _tmp27_;
		}
		_g_string_free0 (buf);
	}
	result = initials;
	_g_free0 (normalized);
	return result;
}

void
util_avatar_get_color_for_name (const gchar* name,
                                GdkRGBA* result)
{
	static const gdouble GNOME_COLOR_PALETTE[28][3] = {{(gdouble) 98, (gdouble) 160, (gdouble) 234}, {(gdouble) 53, (gdouble) 132, (gdouble) 228}, {(gdouble) 28, (gdouble) 113, (gdouble) 216}, {(gdouble) 26, (gdouble) 95, (gdouble) 180}, {(gdouble) 87, (gdouble) 227, (gdouble) 137}, {(gdouble) 51, (gdouble) 209, (gdouble) 122}, {(gdouble) 46, (gdouble) 194, (gdouble) 126}, {(gdouble) 38, (gdouble) 162, (gdouble) 105}, {(gdouble) 248, (gdouble) 228, (gdouble) 92}, {(gdouble) 246, (gdouble) 211, (gdouble) 45}, {(gdouble) 245, (gdouble) 194, (gdouble) 17}, {(gdouble) 229, (gdouble) 165, (gdouble) 10}, {(gdouble) 255, (gdouble) 163, (gdouble) 72}, {(gdouble) 255, (gdouble) 120, (gdouble) 0}, {(gdouble) 230, (gdouble) 97, (gdouble) 0}, {(gdouble) 198, (gdouble) 70, (gdouble) 0}, {(gdouble) 237, (gdouble) 51, (gdouble) 59}, {(gdouble) 224, (gdouble) 27, (gdouble) 36}, {(gdouble) 192, (gdouble) 28, (gdouble) 40}, {(gdouble) 165, (gdouble) 29, (gdouble) 45}, {(gdouble) 192, (gdouble) 97, (gdouble) 203}, {(gdouble) 163, (gdouble) 71, (gdouble) 186}, {(gdouble) 129, (gdouble) 61, (gdouble) 156}, {(gdouble) 97, (gdouble) 53, (gdouble) 131}, {(gdouble) 181, (gdouble) 131, (gdouble) 90}, {(gdouble) 152, (gdouble) 106, (gdouble) 68}, {(gdouble) 134, (gdouble) 94, (gdouble) 60}, {(gdouble) 99, (gdouble) 69, (gdouble) 44}};
	GdkRGBA color = {0};
	GdkRGBA _tmp0_ = {0};
	guint hash = 0U;
	guint number_of_colors = 0U;
	guint idx = 0U;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_if_fail (name != NULL);
	_tmp0_.red = (gdouble) 255;
	_tmp0_.green = (gdouble) 255;
	_tmp0_.blue = (gdouble) 255;
	_tmp0_.alpha = 1.0;
	color = _tmp0_;
	if (g_strcmp0 (name, "") == 0) {
		*result = color;
		return;
	}
	hash = g_str_hash (name);
	_tmp1_ = G_N_ELEMENTS (GNOME_COLOR_PALETTE);
	number_of_colors = (guint) _tmp1_;
	idx = hash % number_of_colors;
	_tmp2_ = GNOME_COLOR_PALETTE[idx][0];
	color.red = _tmp2_;
	_tmp3_ = GNOME_COLOR_PALETTE[idx][1];
	color.green = _tmp3_;
	_tmp4_ = GNOME_COLOR_PALETTE[idx][2];
	color.blue = _tmp4_;
	*result = color;
	return;
}

