/* util-js.c generated by valac 0.56.3, the Vala compiler
 * generated from util-js.vala, do not modify */

/*
 * Copyright © 2017-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-43.0.h"
#include <jsc/jsc.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <webkit2/webkit2.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _UtilJSParamSpecCallable UtilJSParamSpecCallable;

/**
     * Errors produced by functions in {@link Util.JS}.
     */
struct _UtilJSCallablePrivate {
	gchar* name;
	GVariant** args;
	gint args_length1;
	gint _args_size_;
};

struct _UtilJSParamSpecCallable {
	GParamSpec parent_instance;
};

static gint UtilJSCallable_private_offset;
static gpointer util_js_callable_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void util_js_callable_add_param (UtilJSCallable* self,
                                 GVariant* value);
static void _vala_array_add25 (GVariant** * array,
                        gint* length,
                        gint* size,
                        GVariant* value);
static void util_js_callable_finalize (UtilJSCallable * obj);
static GType util_js_callable_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

GQuark
util_js_error_quark (void)
{
	return g_quark_from_static_string ("util-js-error-quark");
}

static GType
util_js_error_get_type_once (void)
{
	static const GEnumValue values[] = {{UTIL_JS_ERROR_EXCEPTION, "UTIL_JS_ERROR_EXCEPTION", "exception"}, {UTIL_JS_ERROR_TYPE, "UTIL_JS_ERROR_TYPE", "type"}, {0, NULL, NULL}};
	GType util_js_error_type_id;
	util_js_error_type_id = g_enum_register_static ("UtilJSError", values);
	return util_js_error_type_id;
}

GType
util_js_error_get_type (void)
{
	static volatile gsize util_js_error_type_id__once = 0;
	if (g_once_init_enter (&util_js_error_type_id__once)) {
		GType util_js_error_type_id;
		util_js_error_type_id = util_js_error_get_type_once ();
		g_once_init_leave (&util_js_error_type_id__once, util_js_error_type_id);
	}
	return util_js_error_type_id__once;
}

/** Supported types of JSC values. */
/**
         * Determines the type of a JSC value.
         *
         * Returns the type of the given value, or {@link UNKNOWN} if
         * it could not be determined.
         */
UtilJSJscType
util_js_jsc_type_to_type (JSCValue* value)
{
	UtilJSJscType result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (value, jsc_value_get_type ()), 0);
	if (jsc_value_is_undefined (value)) {
		result = UTIL_JS_JSC_TYPE_UNDEFINED;
		return result;
	}
	if (jsc_value_is_null (value)) {
		result = UTIL_JS_JSC_TYPE_NULL;
		return result;
	}
	if (jsc_value_is_string (value)) {
		result = UTIL_JS_JSC_TYPE_STRING;
		return result;
	}
	if (jsc_value_is_number (value)) {
		result = UTIL_JS_JSC_TYPE_NUMBER;
		return result;
	}
	if (jsc_value_is_boolean (value)) {
		result = UTIL_JS_JSC_TYPE_BOOLEAN;
		return result;
	}
	if (jsc_value_is_array (value)) {
		result = UTIL_JS_JSC_TYPE_ARRAY;
		return result;
	}
	if (jsc_value_is_object (value)) {
		result = UTIL_JS_JSC_TYPE_OBJECT;
		return result;
	}
	if (jsc_value_is_function (value)) {
		result = UTIL_JS_JSC_TYPE_FUNCTION;
		return result;
	}
	if (jsc_value_is_constructor (value)) {
		result = UTIL_JS_JSC_TYPE_CONSTRUCTOR;
		return result;
	}
	result = UTIL_JS_JSC_TYPE_UNKNOWN;
	return result;
}

static GType
util_js_jsc_type_get_type_once (void)
{
	static const GEnumValue values[] = {{UTIL_JS_JSC_TYPE_UNKNOWN, "UTIL_JS_JSC_TYPE_UNKNOWN", "unknown"}, {UTIL_JS_JSC_TYPE_UNDEFINED, "UTIL_JS_JSC_TYPE_UNDEFINED", "undefined"}, {UTIL_JS_JSC_TYPE_NULL, "UTIL_JS_JSC_TYPE_NULL", "null"}, {UTIL_JS_JSC_TYPE_FUNCTION, "UTIL_JS_JSC_TYPE_FUNCTION", "function"}, {UTIL_JS_JSC_TYPE_STRING, "UTIL_JS_JSC_TYPE_STRING", "string"}, {UTIL_JS_JSC_TYPE_NUMBER, "UTIL_JS_JSC_TYPE_NUMBER", "number"}, {UTIL_JS_JSC_TYPE_BOOLEAN, "UTIL_JS_JSC_TYPE_BOOLEAN", "boolean"}, {UTIL_JS_JSC_TYPE_ARRAY, "UTIL_JS_JSC_TYPE_ARRAY", "array"}, {UTIL_JS_JSC_TYPE_CONSTRUCTOR, "UTIL_JS_JSC_TYPE_CONSTRUCTOR", "constructor"}, {UTIL_JS_JSC_TYPE_OBJECT, "UTIL_JS_JSC_TYPE_OBJECT", "object"}, {0, NULL, NULL}};
	GType util_js_jsc_type_type_id;
	util_js_jsc_type_type_id = g_enum_register_static ("UtilJSJscType", values);
	return util_js_jsc_type_type_id;
}

GType
util_js_jsc_type_get_type (void)
{
	static volatile gsize util_js_jsc_type_type_id__once = 0;
	if (g_once_init_enter (&util_js_jsc_type_type_id__once)) {
		GType util_js_jsc_type_type_id;
		util_js_jsc_type_type_id = util_js_jsc_type_get_type_once ();
		g_once_init_leave (&util_js_jsc_type_type_id__once, util_js_jsc_type_type_id);
	}
	return util_js_jsc_type_type_id__once;
}

/**
     * Returns a JSC Value as a bool.
     *
     * This will raise a {@link Util.JS.Error.TYPE} error if the
     * value is not a JavaScript `Boolean`.
     */
gboolean
util_js_to_bool (JSCValue* value,
                 GError** error)
{
	gboolean boolean = FALSE;
	JSCContext* _tmp3_;
	JSCContext* _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (value, jsc_value_get_type ()), FALSE);
	if (!jsc_value_is_boolean (value)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Value is not a JS Boolean object");
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	boolean = jsc_value_to_boolean (value);
	_tmp3_ = jsc_value_get_context (value);
	_tmp4_ = _tmp3_;
	util_js_check_exception (_tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			gboolean _tmp5_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp5_;
		} else {
			gboolean _tmp6_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	result = boolean;
	return result;
}

/**
     * Returns a JSC Value as a double.
     *
     * This will raise a {@link Util.JS.Error.TYPE} error if the
     * value is not a JavaScript `Number`.
     */
gdouble
util_js_to_double (JSCValue* value,
                   GError** error)
{
	gdouble number = 0.0;
	JSCContext* _tmp3_;
	JSCContext* _tmp4_;
	GError* _inner_error0_ = NULL;
	gdouble result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (value, jsc_value_get_type ()), 0.0);
	if (!jsc_value_is_number (value)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Value is not a JS Number object");
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			gdouble _tmp1_ = -1.0;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gdouble _tmp2_ = -1.0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	number = jsc_value_to_double (value);
	_tmp3_ = jsc_value_get_context (value);
	_tmp4_ = _tmp3_;
	util_js_check_exception (_tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			gdouble _tmp5_ = -1.0;
			g_propagate_error (error, _inner_error0_);
			return _tmp5_;
		} else {
			gdouble _tmp6_ = -1.0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	result = number;
	return result;
}

/**
     * Returns a JSC Value as an int32.
     *
     * This will raise a {@link Util.JS.Error.TYPE} error if the
     * value is not a JavaScript `Number`.
     */
gint32
util_js_to_int32 (JSCValue* value,
                  GError** error)
{
	gint32 number = 0;
	JSCContext* _tmp3_;
	JSCContext* _tmp4_;
	GError* _inner_error0_ = NULL;
	gint32 result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (value, jsc_value_get_type ()), 0);
	if (!jsc_value_is_number (value)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Value is not a JS Number object");
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			gint32 _tmp1_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gint32 _tmp2_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	number = jsc_value_to_int32 (value);
	_tmp3_ = jsc_value_get_context (value);
	_tmp4_ = _tmp3_;
	util_js_check_exception (_tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			gint32 _tmp5_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp5_;
		} else {
			gint32 _tmp6_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	result = number;
	return result;
}

/**
     * Returns a JSC Value as a string.
     *
     * This will raise a {@link Util.JS.Error.TYPE} error if the
     * value is not a JavaScript `String`.
     */
gchar*
util_js_to_string (JSCValue* value,
                   GError** error)
{
	gchar* str = NULL;
	gchar* _tmp1_;
	JSCContext* _tmp2_;
	JSCContext* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (value, jsc_value_get_type ()), NULL);
	if (!jsc_value_is_string (value)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Value is not a JS String object");
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = jsc_value_to_string (value);
	str = _tmp1_;
	_tmp2_ = jsc_value_get_context (value);
	_tmp3_ = _tmp2_;
	util_js_check_exception (_tmp3_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (str);
			return NULL;
		} else {
			_g_free0 (str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = str;
	return result;
}

/**
     * Returns the value of an object property.
     *
     * This will raise a {@link Util.JS.Error.TYPE} error if the
     * value is not an object or does not contain the named property.
     */
inline JSCValue*
util_js_get_property (JSCValue* value,
                      const gchar* name,
                      GError** error)
{
	JSCValue* property = NULL;
	JSCValue* _tmp1_;
	JSCContext* _tmp2_;
	JSCContext* _tmp3_;
	GError* _inner_error0_ = NULL;
	JSCValue* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (value, jsc_value_get_type ()), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	if (!jsc_value_is_object (value)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Value is not a JS Object");
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp1_ = jsc_value_object_get_property (value, name);
	property = _tmp1_;
	_tmp2_ = jsc_value_get_context (value);
	_tmp3_ = _tmp2_;
	util_js_check_exception (_tmp3_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (property);
			return NULL;
		} else {
			_g_object_unref0 (property);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = property;
	return result;
}

/**
     * Checks an JS exception returned from a JSC call.
     *
     * If the given context has a current exception, it will cleared
     * and a {@link Util.JS.Error} will be thrown.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

inline void
util_js_check_exception (JSCContext* context,
                         GError** error)
{
	JSCException* exception = NULL;
	JSCException* _tmp0_;
	JSCException* _tmp1_;
	JSCException* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, jsc_context_get_type ()));
	_tmp0_ = jsc_context_get_exception (context);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	exception = _tmp1_;
	_tmp2_ = exception;
	if (_tmp2_ != NULL) {
		JSCException* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		jsc_context_clear_exception (context);
		_tmp3_ = exception;
		_tmp4_ = jsc_exception_to_string (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (UTIL_JS_ERROR, UTIL_JS_ERROR_EXCEPTION, "JS exception thrown: %s", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp7_;
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (exception);
			return;
		} else {
			_g_object_unref0 (exception);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (exception);
}

/**
     * Converts a JS value to a GLib variant.
     *
     * Simple value objects (string, number, and Boolean values),
     * arrays of these, and objects with these types as properties are
     * supported. Arrays containing objects of the same type are
     * converted to arrays, otherwise they are converted to tuples,
     * empty arrays are converted to the unit tuple, and objects are
     * converted to vardict containing property names as keys and
     * values. Null and undefined values are returned as an empty
     * maybe variant type, since it is not possible to determine the
     * actual type.
     *
     * Throws a type error if the given value's type is not supported.
     */
inline GVariant*
util_js_value_to_variant (JSCValue* value,
                          GError** error)
{
	GVariant* variant = NULL;
	GError* _inner_error0_ = NULL;
	GVariant* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (value, jsc_value_get_type ()), NULL);
	variant = NULL;
	switch (util_js_jsc_type_to_type (value)) {
		case UTIL_JS_JSC_TYPE_UNDEFINED:
		case UTIL_JS_JSC_TYPE_NULL:
		{
			const GVariantType* _tmp0_;
			GVariant* _tmp1_;
			_tmp0_ = G_VARIANT_TYPE_VARIANT;
			_tmp1_ = g_variant_new_maybe (_tmp0_, NULL);
			g_variant_ref_sink (_tmp1_);
			_g_variant_unref0 (variant);
			variant = _tmp1_;
			break;
		}
		case UTIL_JS_JSC_TYPE_STRING:
		{
			gchar* _tmp2_;
			gchar* _tmp3_;
			GVariant* _tmp4_;
			_tmp2_ = jsc_value_to_string (value);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_variant_new_string (_tmp3_);
			g_variant_ref_sink (_tmp4_);
			_g_variant_unref0 (variant);
			variant = _tmp4_;
			_g_free0 (_tmp3_);
			break;
		}
		case UTIL_JS_JSC_TYPE_NUMBER:
		{
			GVariant* _tmp5_;
			_tmp5_ = g_variant_new_double (jsc_value_to_double (value));
			g_variant_ref_sink (_tmp5_);
			_g_variant_unref0 (variant);
			variant = _tmp5_;
			break;
		}
		case UTIL_JS_JSC_TYPE_BOOLEAN:
		{
			GVariant* _tmp6_;
			_tmp6_ = g_variant_new_boolean (jsc_value_to_boolean (value));
			g_variant_ref_sink (_tmp6_);
			_g_variant_unref0 (variant);
			variant = _tmp6_;
			break;
		}
		case UTIL_JS_JSC_TYPE_ARRAY:
		{
			gint len = 0;
			JSCValue* _tmp7_;
			JSCValue* _tmp8_;
			gint _tmp9_;
			_tmp7_ = jsc_value_object_get_property (value, "length");
			_tmp8_ = _tmp7_;
			_tmp9_ = (gint) util_js_to_int32 (_tmp8_, &_inner_error0_);
			_g_object_unref0 (_tmp8_);
			len = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == UTIL_JS_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_variant_unref0 (variant);
					return NULL;
				} else {
					_g_variant_unref0 (variant);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			if (len == 0) {
				GVariant** _tmp10_;
				GVariant** _tmp11_;
				gint _tmp11__length1;
				GVariant* _tmp12_;
				_tmp10_ = g_new0 (GVariant*, 0 + 1);
				_tmp11_ = _tmp10_;
				_tmp11__length1 = 0;
				_tmp12_ = g_variant_new_tuple (_tmp11_, 0);
				g_variant_ref_sink (_tmp12_);
				_g_variant_unref0 (variant);
				variant = _tmp12_;
				_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_variant_unref), NULL);
			} else {
				JSCValue* element = NULL;
				JSCValue* _tmp13_;
				UtilJSJscType first_type = 0;
				JSCValue* _tmp14_;
				gboolean all_same_type = FALSE;
				GVariant** values = NULL;
				GVariant** _tmp15_;
				gint values_length1;
				gint _values_size_;
				GVariant* _tmp16_ = NULL;
				JSCValue* _tmp17_;
				GVariant* _tmp18_;
				GVariant** _tmp19_;
				gint _tmp19__length1;
				GVariant* _tmp20_;
				_tmp13_ = jsc_value_object_get_property_at_index (value, (guint) 0);
				element = _tmp13_;
				_tmp14_ = element;
				first_type = util_js_jsc_type_to_type (_tmp14_);
				all_same_type = TRUE;
				_tmp15_ = g_new0 (GVariant*, len + 1);
				values = _tmp15_;
				values_length1 = len;
				_values_size_ = values_length1;
				_tmp17_ = element;
				_tmp18_ = util_js_value_to_variant (_tmp17_, &_inner_error0_);
				_tmp16_ = _tmp18_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == UTIL_JS_ERROR) {
						g_propagate_error (error, _inner_error0_);
						values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_variant_unref), NULL);
						_g_object_unref0 (element);
						_g_variant_unref0 (variant);
						return NULL;
					} else {
						values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_variant_unref), NULL);
						_g_object_unref0 (element);
						_g_variant_unref0 (variant);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp19_ = values;
				_tmp19__length1 = values_length1;
				_tmp20_ = _tmp16_;
				_tmp16_ = NULL;
				_g_variant_unref0 (_tmp19_[0]);
				_tmp19_[0] = _tmp20_;
				{
					gint i = 0;
					i = 1;
					{
						gboolean _tmp21_ = FALSE;
						_tmp21_ = TRUE;
						while (TRUE) {
							JSCValue* _tmp23_;
							GVariant* _tmp24_ = NULL;
							JSCValue* _tmp25_;
							GVariant* _tmp26_;
							GVariant** _tmp27_;
							gint _tmp27__length1;
							GVariant* _tmp28_;
							JSCValue* _tmp29_;
							if (!_tmp21_) {
								gint _tmp22_;
								_tmp22_ = i;
								i = _tmp22_ + 1;
							}
							_tmp21_ = FALSE;
							if (!(i < len)) {
								break;
							}
							_tmp23_ = jsc_value_object_get_property_at_index (value, (guint) i);
							_g_object_unref0 (element);
							element = _tmp23_;
							_tmp25_ = element;
							_tmp26_ = util_js_value_to_variant (_tmp25_, &_inner_error0_);
							_tmp24_ = _tmp26_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == UTIL_JS_ERROR) {
									g_propagate_error (error, _inner_error0_);
									_g_variant_unref0 (_tmp16_);
									values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_variant_unref), NULL);
									_g_object_unref0 (element);
									_g_variant_unref0 (variant);
									return NULL;
								} else {
									_g_variant_unref0 (_tmp16_);
									values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_variant_unref), NULL);
									_g_object_unref0 (element);
									_g_variant_unref0 (variant);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return NULL;
								}
							}
							_tmp27_ = values;
							_tmp27__length1 = values_length1;
							_tmp28_ = _tmp24_;
							_tmp24_ = NULL;
							_g_variant_unref0 (_tmp27_[i]);
							_tmp27_[i] = _tmp28_;
							_tmp29_ = element;
							all_same_type &= first_type == util_js_jsc_type_to_type (_tmp29_);
							_g_variant_unref0 (_tmp24_);
						}
					}
				}
				if (!all_same_type) {
					GVariant** _tmp30_;
					gint _tmp30__length1;
					GVariant* _tmp31_;
					_tmp30_ = values;
					_tmp30__length1 = values_length1;
					_tmp31_ = g_variant_new_tuple (_tmp30_, _tmp30__length1);
					g_variant_ref_sink (_tmp31_);
					_g_variant_unref0 (variant);
					variant = _tmp31_;
				} else {
					GVariant** _tmp32_;
					gint _tmp32__length1;
					GVariant* _tmp33_;
					const GVariantType* _tmp34_;
					GVariant** _tmp35_;
					gint _tmp35__length1;
					GVariant* _tmp36_;
					_tmp32_ = values;
					_tmp32__length1 = values_length1;
					_tmp33_ = _tmp32_[0];
					_tmp34_ = g_variant_get_type (_tmp33_);
					_tmp35_ = values;
					_tmp35__length1 = values_length1;
					_tmp36_ = g_variant_new_array (_tmp34_, _tmp35_, _tmp35__length1);
					g_variant_ref_sink (_tmp36_);
					_g_variant_unref0 (variant);
					variant = _tmp36_;
				}
				_g_variant_unref0 (_tmp16_);
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_variant_unref), NULL);
				_g_object_unref0 (element);
			}
			break;
		}
		case UTIL_JS_JSC_TYPE_OBJECT:
		{
			GVariantDict* dict = NULL;
			GVariantDict* _tmp37_;
			gchar** names = NULL;
			gchar** _tmp38_;
			gchar** _tmp39_;
			gint names_length1;
			gint _names_size_;
			gchar** _tmp40_;
			gint _tmp40__length1;
			GVariantDict* _tmp51_;
			GVariant* _tmp52_;
			_tmp37_ = g_variant_dict_new (NULL);
			dict = _tmp37_;
			_tmp39_ = _tmp38_ = jsc_value_object_enumerate_properties (value);
			names = _tmp39_;
			names_length1 = _vala_array_length (_tmp38_);
			_names_size_ = names_length1;
			_tmp40_ = names;
			_tmp40__length1 = names_length1;
			if (_tmp40_ != NULL) {
				gchar** _tmp41_;
				gint _tmp41__length1;
				_tmp41_ = names;
				_tmp41__length1 = names_length1;
				{
					gchar** name_collection = NULL;
					gint name_collection_length1 = 0;
					gint _name_collection_size_ = 0;
					gint name_it = 0;
					name_collection = _tmp41_;
					name_collection_length1 = _tmp41__length1;
					for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
						gchar* _tmp42_;
						gchar* name = NULL;
						_tmp42_ = g_strdup (name_collection[name_it]);
						name = _tmp42_;
						{
							GVariant* _tmp43_ = NULL;
							const gchar* _tmp44_;
							JSCValue* _tmp45_;
							JSCValue* _tmp46_;
							GVariant* _tmp47_;
							GVariant* _tmp48_;
							GVariantDict* _tmp49_;
							const gchar* _tmp50_;
							_tmp44_ = name;
							_tmp45_ = jsc_value_object_get_property (value, _tmp44_);
							_tmp46_ = _tmp45_;
							_tmp47_ = util_js_value_to_variant (_tmp46_, &_inner_error0_);
							_tmp48_ = _tmp47_;
							_g_object_unref0 (_tmp46_);
							_tmp43_ = _tmp48_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == UTIL_JS_ERROR) {
									g_propagate_error (error, _inner_error0_);
									_g_free0 (name);
									names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
									_g_variant_dict_unref0 (dict);
									_g_variant_unref0 (variant);
									return NULL;
								} else {
									_g_free0 (name);
									names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
									_g_variant_dict_unref0 (dict);
									_g_variant_unref0 (variant);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return NULL;
								}
							}
							_tmp49_ = dict;
							_tmp50_ = name;
							g_variant_dict_insert_value (_tmp49_, _tmp50_, _tmp43_);
							_g_variant_unref0 (_tmp43_);
							_g_free0 (name);
						}
					}
				}
			}
			_tmp51_ = dict;
			_tmp52_ = g_variant_dict_end (_tmp51_);
			g_variant_ref_sink (_tmp52_);
			_g_variant_unref0 (variant);
			variant = _tmp52_;
			names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
			_g_variant_dict_unref0 (dict);
			break;
		}
		default:
		{
			gchar* _tmp53_;
			gchar* _tmp54_;
			GError* _tmp55_;
			GError* _tmp56_;
			_tmp53_ = jsc_value_to_string (value);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_error_new (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Unsupported JS type: %s", _tmp54_);
			_tmp56_ = _tmp55_;
			_g_free0 (_tmp54_);
			_inner_error0_ = _tmp56_;
			if (_inner_error0_->domain == UTIL_JS_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_variant_unref0 (variant);
				return NULL;
			} else {
				_g_variant_unref0 (variant);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	result = variant;
	return result;
}

/**
     * Converts a GLib variant to a JS value.
     *
     * Simple value objects (string, number, and Boolean values),
     * arrays and tuples of these, and dictionaries with string keys
     * are supported. Tuples and arrays are converted to JS arrays,
     * and dictionaries or tuples containing dictionary entries are
     * converted to JS objects.
     *
     * Throws a type error if the given variant's type is not supported.
     */
static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

inline JSCValue*
util_js_variant_to_value (JSCContext* context,
                          GVariant* variant,
                          GError** error)
{
	JSCValue* value = NULL;
	GVariantClass type = 0;
	JSCValue* _tmp68_;
	GError* _inner_error0_ = NULL;
	JSCValue* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (context, jsc_context_get_type ()), NULL);
	g_return_val_if_fail (variant != NULL, NULL);
	value = NULL;
	type = g_variant_classify (variant);
	if (type == G_VARIANT_CLASS_MAYBE) {
		GVariant* maybe = NULL;
		GVariant* _tmp0_;
		GVariant* _tmp1_;
		_tmp0_ = g_variant_get_maybe (variant);
		maybe = _tmp0_;
		_tmp1_ = maybe;
		if (_tmp1_ != NULL) {
			JSCValue* _tmp2_ = NULL;
			GVariant* _tmp3_;
			JSCValue* _tmp4_;
			JSCValue* _tmp5_;
			_tmp3_ = maybe;
			_tmp4_ = util_js_variant_to_value (context, _tmp3_, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == UTIL_JS_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_variant_unref0 (maybe);
					_g_object_unref0 (value);
					return NULL;
				} else {
					_g_variant_unref0 (maybe);
					_g_object_unref0 (value);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			_g_object_unref0 (value);
			value = _tmp5_;
			_g_object_unref0 (_tmp2_);
		} else {
			JSCValue* _tmp6_;
			_tmp6_ = jsc_value_new_null (context);
			_g_object_unref0 (value);
			value = _tmp6_;
		}
		_g_variant_unref0 (maybe);
	} else {
		if (type == G_VARIANT_CLASS_VARIANT) {
			JSCValue* _tmp7_ = NULL;
			GVariant* _tmp8_;
			GVariant* _tmp9_;
			JSCValue* _tmp10_;
			JSCValue* _tmp11_;
			JSCValue* _tmp12_;
			_tmp8_ = g_variant_get_variant (variant);
			_tmp9_ = _tmp8_;
			_tmp10_ = util_js_variant_to_value (context, _tmp9_, &_inner_error0_);
			_tmp11_ = _tmp10_;
			_g_variant_unref0 (_tmp9_);
			_tmp7_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == UTIL_JS_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (value);
					return NULL;
				} else {
					_g_object_unref0 (value);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_tmp12_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (value);
			value = _tmp12_;
			_g_object_unref0 (_tmp7_);
		} else {
			if (type == G_VARIANT_CLASS_STRING) {
				const gchar* _tmp13_;
				JSCValue* _tmp14_;
				_tmp13_ = g_variant_get_string (variant, NULL);
				_tmp14_ = jsc_value_new_string (context, _tmp13_);
				_g_object_unref0 (value);
				value = _tmp14_;
			} else {
				if (type == G_VARIANT_CLASS_BOOLEAN) {
					JSCValue* _tmp15_;
					_tmp15_ = jsc_value_new_boolean (context, g_variant_get_boolean (variant));
					_g_object_unref0 (value);
					value = _tmp15_;
				} else {
					if (type == G_VARIANT_CLASS_DOUBLE) {
						JSCValue* _tmp16_;
						_tmp16_ = jsc_value_new_number (context, g_variant_get_double (variant));
						_g_object_unref0 (value);
						value = _tmp16_;
					} else {
						if (type == G_VARIANT_CLASS_INT64) {
							JSCValue* _tmp17_;
							_tmp17_ = jsc_value_new_number (context, (gdouble) g_variant_get_int64 (variant));
							_g_object_unref0 (value);
							value = _tmp17_;
						} else {
							if (type == G_VARIANT_CLASS_INT32) {
								JSCValue* _tmp18_;
								_tmp18_ = jsc_value_new_number (context, (gdouble) g_variant_get_int32 (variant));
								_g_object_unref0 (value);
								value = _tmp18_;
							} else {
								if (type == G_VARIANT_CLASS_INT16) {
									JSCValue* _tmp19_;
									_tmp19_ = jsc_value_new_number (context, (gdouble) g_variant_get_int16 (variant));
									_g_object_unref0 (value);
									value = _tmp19_;
								} else {
									if (type == G_VARIANT_CLASS_UINT64) {
										JSCValue* _tmp20_;
										_tmp20_ = jsc_value_new_number (context, (gdouble) g_variant_get_uint64 (variant));
										_g_object_unref0 (value);
										value = _tmp20_;
									} else {
										if (type == G_VARIANT_CLASS_UINT32) {
											JSCValue* _tmp21_;
											_tmp21_ = jsc_value_new_number (context, (gdouble) g_variant_get_uint32 (variant));
											_g_object_unref0 (value);
											value = _tmp21_;
										} else {
											if (type == G_VARIANT_CLASS_UINT16) {
												JSCValue* _tmp22_;
												_tmp22_ = jsc_value_new_number (context, (gdouble) g_variant_get_uint16 (variant));
												_g_object_unref0 (value);
												value = _tmp22_;
											} else {
												if (type == G_VARIANT_CLASS_BYTE) {
													JSCValue* _tmp23_;
													_tmp23_ = jsc_value_new_number (context, (gdouble) g_variant_get_byte (variant));
													_g_object_unref0 (value);
													value = _tmp23_;
												} else {
													gboolean _tmp24_ = FALSE;
													if (type == G_VARIANT_CLASS_ARRAY) {
														_tmp24_ = TRUE;
													} else {
														_tmp24_ = type == G_VARIANT_CLASS_TUPLE;
													}
													if (_tmp24_) {
														gsize len = 0UL;
														len = g_variant_n_children (variant);
														if (len == ((gsize) 0)) {
															gboolean _tmp25_ = FALSE;
															if (type == G_VARIANT_CLASS_ARRAY) {
																_tmp25_ = TRUE;
															} else {
																_tmp25_ = type == G_VARIANT_CLASS_TUPLE;
															}
															if (_tmp25_) {
																JSCValue* _tmp26_;
																_tmp26_ = jsc_value_new_array_from_garray (context, NULL);
																_g_object_unref0 (value);
																value = _tmp26_;
															} else {
																JSCValue* _tmp27_;
																_tmp27_ = jsc_value_new_object (context, NULL, NULL);
																_g_object_unref0 (value);
																value = _tmp27_;
															}
														} else {
															GVariant* first = NULL;
															GVariant* _tmp28_;
															GVariant* _tmp29_;
															_tmp28_ = g_variant_get_child_value (variant, (gsize) 0);
															first = _tmp28_;
															_tmp29_ = first;
															if (g_variant_classify (_tmp29_) == G_VARIANT_CLASS_DICT_ENTRY) {
																JSCValue* _tmp30_;
																_tmp30_ = jsc_value_new_object (context, NULL, NULL);
																_g_object_unref0 (value);
																value = _tmp30_;
																{
																	gsize i = 0UL;
																	i = (gsize) 0;
																	{
																		gboolean _tmp31_ = FALSE;
																		_tmp31_ = TRUE;
																		while (TRUE) {
																			GVariant* entry = NULL;
																			GVariant* _tmp33_;
																			GVariant* _tmp34_;
																			GVariant* key = NULL;
																			GVariant* _tmp39_;
																			GVariant* _tmp40_;
																			GVariant* _tmp41_;
																			JSCValue* _tmp47_ = NULL;
																			GVariant* _tmp48_;
																			GVariant* _tmp49_;
																			GVariant* _tmp50_;
																			JSCValue* _tmp51_;
																			JSCValue* _tmp52_;
																			JSCValue* _tmp53_;
																			GVariant* _tmp54_;
																			const gchar* _tmp55_;
																			if (!_tmp31_) {
																				gsize _tmp32_;
																				_tmp32_ = i;
																				i = _tmp32_ + 1;
																			}
																			_tmp31_ = FALSE;
																			if (!(i < len)) {
																				break;
																			}
																			_tmp33_ = g_variant_get_child_value (variant, i);
																			entry = _tmp33_;
																			_tmp34_ = entry;
																			if (g_variant_classify (_tmp34_) != G_VARIANT_CLASS_DICT_ENTRY) {
																				gchar* _tmp35_;
																				gchar* _tmp36_;
																				GError* _tmp37_;
																				GError* _tmp38_;
																				_tmp35_ = g_variant_print (variant, TRUE);
																				_tmp36_ = _tmp35_;
																				_tmp37_ = g_error_new (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Variant mixes dict entries with others: %s", _tmp36_);
																				_tmp38_ = _tmp37_;
																				_g_free0 (_tmp36_);
																				_inner_error0_ = _tmp38_;
																				if (_inner_error0_->domain == UTIL_JS_ERROR) {
																					g_propagate_error (error, _inner_error0_);
																					_g_variant_unref0 (entry);
																					_g_variant_unref0 (first);
																					_g_object_unref0 (value);
																					return NULL;
																				} else {
																					_g_variant_unref0 (entry);
																					_g_variant_unref0 (first);
																					_g_object_unref0 (value);
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
																					g_clear_error (&_inner_error0_);
																					return NULL;
																				}
																			}
																			_tmp39_ = entry;
																			_tmp40_ = g_variant_get_child_value (_tmp39_, (gsize) 0);
																			key = _tmp40_;
																			_tmp41_ = key;
																			if (g_variant_classify (_tmp41_) != G_VARIANT_CLASS_STRING) {
																				GVariant* _tmp42_;
																				gchar* _tmp43_;
																				gchar* _tmp44_;
																				GError* _tmp45_;
																				GError* _tmp46_;
																				_tmp42_ = entry;
																				_tmp43_ = g_variant_print (_tmp42_, TRUE);
																				_tmp44_ = _tmp43_;
																				_tmp45_ = g_error_new (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Dict entry key is not a string: %s", _tmp44_);
																				_tmp46_ = _tmp45_;
																				_g_free0 (_tmp44_);
																				_inner_error0_ = _tmp46_;
																				if (_inner_error0_->domain == UTIL_JS_ERROR) {
																					g_propagate_error (error, _inner_error0_);
																					_g_variant_unref0 (key);
																					_g_variant_unref0 (entry);
																					_g_variant_unref0 (first);
																					_g_object_unref0 (value);
																					return NULL;
																				} else {
																					_g_variant_unref0 (key);
																					_g_variant_unref0 (entry);
																					_g_variant_unref0 (first);
																					_g_object_unref0 (value);
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
																					g_clear_error (&_inner_error0_);
																					return NULL;
																				}
																			}
																			_tmp48_ = entry;
																			_tmp49_ = g_variant_get_child_value (_tmp48_, (gsize) 1);
																			_tmp50_ = _tmp49_;
																			_tmp51_ = util_js_variant_to_value (context, _tmp50_, &_inner_error0_);
																			_tmp52_ = _tmp51_;
																			_g_variant_unref0 (_tmp50_);
																			_tmp47_ = _tmp52_;
																			if (G_UNLIKELY (_inner_error0_ != NULL)) {
																				if (_inner_error0_->domain == UTIL_JS_ERROR) {
																					g_propagate_error (error, _inner_error0_);
																					_g_variant_unref0 (key);
																					_g_variant_unref0 (entry);
																					_g_variant_unref0 (first);
																					_g_object_unref0 (value);
																					return NULL;
																				} else {
																					_g_variant_unref0 (key);
																					_g_variant_unref0 (entry);
																					_g_variant_unref0 (first);
																					_g_object_unref0 (value);
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
																					g_clear_error (&_inner_error0_);
																					return NULL;
																				}
																			}
																			_tmp53_ = value;
																			_tmp54_ = key;
																			_tmp55_ = g_variant_get_string (_tmp54_, NULL);
																			jsc_value_object_set_property (_tmp53_, _tmp55_, _tmp47_);
																			_g_object_unref0 (_tmp47_);
																			_g_variant_unref0 (key);
																			_g_variant_unref0 (entry);
																		}
																	}
																}
															} else {
																GPtrArray* values = NULL;
																GPtrArray* _tmp56_;
																GPtrArray* _tmp66_;
																JSCValue* _tmp67_;
																_tmp56_ = g_ptr_array_new_full ((guint) len, _g_object_unref0_);
																values = _tmp56_;
																{
																	gsize i = 0UL;
																	i = (gsize) 0;
																	{
																		gboolean _tmp57_ = FALSE;
																		_tmp57_ = TRUE;
																		while (TRUE) {
																			JSCValue* _tmp59_ = NULL;
																			GVariant* _tmp60_;
																			GVariant* _tmp61_;
																			JSCValue* _tmp62_;
																			JSCValue* _tmp63_;
																			GPtrArray* _tmp64_;
																			JSCValue* _tmp65_;
																			if (!_tmp57_) {
																				gsize _tmp58_;
																				_tmp58_ = i;
																				i = _tmp58_ + 1;
																			}
																			_tmp57_ = FALSE;
																			if (!(i < len)) {
																				break;
																			}
																			_tmp60_ = g_variant_get_child_value (variant, i);
																			_tmp61_ = _tmp60_;
																			_tmp62_ = util_js_variant_to_value (context, _tmp61_, &_inner_error0_);
																			_tmp63_ = _tmp62_;
																			_g_variant_unref0 (_tmp61_);
																			_tmp59_ = _tmp63_;
																			if (G_UNLIKELY (_inner_error0_ != NULL)) {
																				if (_inner_error0_->domain == UTIL_JS_ERROR) {
																					g_propagate_error (error, _inner_error0_);
																					_g_ptr_array_unref0 (values);
																					_g_variant_unref0 (first);
																					_g_object_unref0 (value);
																					return NULL;
																				} else {
																					_g_ptr_array_unref0 (values);
																					_g_variant_unref0 (first);
																					_g_object_unref0 (value);
																					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
																					g_clear_error (&_inner_error0_);
																					return NULL;
																				}
																			}
																			_tmp64_ = values;
																			_tmp65_ = _tmp59_;
																			_tmp59_ = NULL;
																			g_ptr_array_add (_tmp64_, _tmp65_);
																			_g_object_unref0 (_tmp59_);
																		}
																	}
																}
																_tmp66_ = values;
																_tmp67_ = jsc_value_new_array_from_garray (context, _tmp66_);
																_g_object_unref0 (value);
																value = _tmp67_;
																_g_ptr_array_unref0 (values);
															}
															_g_variant_unref0 (first);
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp68_ = value;
	if (_tmp68_ == NULL) {
		gchar* _tmp69_;
		gchar* _tmp70_;
		GError* _tmp71_;
		GError* _tmp72_;
		_tmp69_ = g_variant_print (variant, TRUE);
		_tmp70_ = _tmp69_;
		_tmp71_ = g_error_new (UTIL_JS_ERROR, UTIL_JS_ERROR_TYPE, "Unsupported variant type %s", _tmp70_);
		_tmp72_ = _tmp71_;
		_g_free0 (_tmp70_);
		_inner_error0_ = _tmp72_;
		if (_inner_error0_->domain == UTIL_JS_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (value);
			return NULL;
		} else {
			_g_object_unref0 (value);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = value;
	return result;
}

/**
     * Convenience method for returning a new Callable instance.
     */
UtilJSCallable*
util_js_callable (const gchar* base_name)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* result;
	g_return_val_if_fail (base_name != NULL, NULL);
	_tmp0_ = util_js_callable_new (base_name);
	result = _tmp0_;
	return result;
}

static inline gpointer
util_js_callable_get_instance_private (UtilJSCallable* self)
{
	return G_STRUCT_MEMBER_P (self, UtilJSCallable_private_offset);
}

UtilJSCallable*
util_js_callable_construct (GType object_type,
                            const gchar* name)
{
	UtilJSCallable* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (UtilJSCallable*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp0_;
	return self;
}

UtilJSCallable*
util_js_callable_new (const gchar* name)
{
	return util_js_callable_construct (UTIL_JS_TYPE_CALLABLE, name);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

WebKitUserMessage*
util_js_callable_to_message (UtilJSCallable* self)
{
	GVariant* args = NULL;
	GVariant** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp7_;
	GVariant* _tmp8_;
	WebKitUserMessage* _tmp9_;
	WebKitUserMessage* result;
	g_return_val_if_fail (UTIL_JS_IS_CALLABLE (self), NULL);
	args = NULL;
	_tmp0_ = self->priv->args;
	_tmp0__length1 = self->priv->args_length1;
	if (_tmp0__length1 == 1) {
		GVariant** _tmp1_;
		gint _tmp1__length1;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		_tmp1_ = self->priv->args;
		_tmp1__length1 = self->priv->args_length1;
		_tmp2_ = _tmp1_[0];
		_tmp3_ = _g_variant_ref0 (_tmp2_);
		_g_variant_unref0 (args);
		args = _tmp3_;
	} else {
		GVariant** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = self->priv->args;
		_tmp4__length1 = self->priv->args_length1;
		if (_tmp4__length1 > 1) {
			GVariant** _tmp5_;
			gint _tmp5__length1;
			GVariant* _tmp6_;
			_tmp5_ = self->priv->args;
			_tmp5__length1 = self->priv->args_length1;
			_tmp6_ = g_variant_new_tuple (_tmp5_, _tmp5__length1);
			g_variant_ref_sink (_tmp6_);
			_g_variant_unref0 (args);
			args = _tmp6_;
		}
	}
	_tmp7_ = self->priv->name;
	_tmp8_ = args;
	_tmp9_ = webkit_user_message_new (_tmp7_, _tmp8_);
	g_object_ref_sink (_tmp9_);
	result = _tmp9_;
	_g_variant_unref0 (args);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
util_js_callable_to_string (UtilJSCallable* self)
{
	gchar** args = NULL;
	GVariant** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint args_length1;
	gint _args_size_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result;
	g_return_val_if_fail (UTIL_JS_IS_CALLABLE (self), NULL);
	_tmp0_ = self->priv->args;
	_tmp0__length1 = self->priv->args_length1;
	_tmp1_ = g_new0 (gchar*, _tmp0__length1 + 1);
	args = _tmp1_;
	args_length1 = _tmp0__length1;
	_args_size_ = args_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				GVariant** _tmp6_;
				gint _tmp6__length1;
				GVariant* _tmp7_;
				gchar* _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = args;
				_tmp4__length1 = args_length1;
				if (!(i < _tmp4__length1)) {
					break;
				}
				_tmp5_ = args;
				_tmp5__length1 = args_length1;
				_tmp6_ = self->priv->args;
				_tmp6__length1 = self->priv->args_length1;
				_tmp7_ = _tmp6_[i];
				_tmp8_ = g_variant_print (_tmp7_, TRUE);
				_g_free0 (_tmp5_[i]);
				_tmp5_[i] = _tmp8_;
			}
		}
	}
	_tmp9_ = self->priv->name;
	_tmp10_ = g_strconcat (_tmp9_, "(", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = args;
	_tmp12__length1 = args_length1;
	_tmp13_ = _vala_g_strjoinv (",", _tmp12_, (gint) _tmp12__length1);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, ")", NULL);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp11_);
	result = _tmp18_;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gpointer
_util_js_callable_ref0 (gpointer self)
{
	return self ? util_js_callable_ref (self) : NULL;
}

UtilJSCallable*
util_js_callable_string (UtilJSCallable* self,
                         const gchar* value)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* result;
	g_return_val_if_fail (UTIL_JS_IS_CALLABLE (self), NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = g_variant_new_string (value);
	g_variant_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	util_js_callable_add_param (self, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	_tmp2_ = _util_js_callable_ref0 (self);
	result = _tmp2_;
	return result;
}

UtilJSCallable*
util_js_callable_double (UtilJSCallable* self,
                         gdouble value)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* result;
	g_return_val_if_fail (UTIL_JS_IS_CALLABLE (self), NULL);
	_tmp0_ = g_variant_new_double (value);
	g_variant_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	util_js_callable_add_param (self, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	_tmp2_ = _util_js_callable_ref0 (self);
	result = _tmp2_;
	return result;
}

UtilJSCallable*
util_js_callable_int (UtilJSCallable* self,
                      gint value)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* result;
	g_return_val_if_fail (UTIL_JS_IS_CALLABLE (self), NULL);
	_tmp0_ = g_variant_new_int32 ((gint32) value);
	g_variant_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	util_js_callable_add_param (self, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	_tmp2_ = _util_js_callable_ref0 (self);
	result = _tmp2_;
	return result;
}

UtilJSCallable*
util_js_callable_bool (UtilJSCallable* self,
                       gboolean value)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* result;
	g_return_val_if_fail (UTIL_JS_IS_CALLABLE (self), NULL);
	_tmp0_ = g_variant_new_boolean (value);
	g_variant_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	util_js_callable_add_param (self, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	_tmp2_ = _util_js_callable_ref0 (self);
	result = _tmp2_;
	return result;
}

static void
_vala_array_add25 (GVariant** * array,
                   gint* length,
                   gint* size,
                   GVariant* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static inline void
util_js_callable_add_param (UtilJSCallable* self,
                            GVariant* value)
{
	GVariant* _tmp0_;
	g_return_if_fail (UTIL_JS_IS_CALLABLE (self));
	g_return_if_fail (value != NULL);
	_tmp0_ = _g_variant_ref0 (value);
	_vala_array_add25 (&self->priv->args, &self->priv->args_length1, &self->priv->_args_size_, _tmp0_);
}

static void
util_js_value_callable_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
util_js_value_callable_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		util_js_callable_unref (value->data[0].v_pointer);
	}
}

static void
util_js_value_callable_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = util_js_callable_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
util_js_value_callable_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
util_js_value_callable_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UtilJSCallable * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = util_js_callable_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
util_js_value_callable_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	UtilJSCallable ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = util_js_callable_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
util_js_param_spec_callable (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	UtilJSParamSpecCallable* spec;
	g_return_val_if_fail (g_type_is_a (object_type, UTIL_JS_TYPE_CALLABLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
util_js_value_get_callable (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_JS_TYPE_CALLABLE), NULL);
	return value->data[0].v_pointer;
}

void
util_js_value_set_callable (GValue* value,
                            gpointer v_object)
{
	UtilJSCallable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_JS_TYPE_CALLABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UTIL_JS_TYPE_CALLABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		util_js_callable_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		util_js_callable_unref (old);
	}
}

void
util_js_value_take_callable (GValue* value,
                             gpointer v_object)
{
	UtilJSCallable * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, UTIL_JS_TYPE_CALLABLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, UTIL_JS_TYPE_CALLABLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		util_js_callable_unref (old);
	}
}

static void
util_js_callable_class_init (UtilJSCallableClass * klass,
                             gpointer klass_data)
{
	util_js_callable_parent_class = g_type_class_peek_parent (klass);
	((UtilJSCallableClass *) klass)->finalize = util_js_callable_finalize;
	g_type_class_adjust_private_offset (klass, &UtilJSCallable_private_offset);
}

static void
util_js_callable_instance_init (UtilJSCallable * self,
                                gpointer klass)
{
	GVariant** _tmp0_;
	self->priv = util_js_callable_get_instance_private (self);
	_tmp0_ = g_new0 (GVariant*, 0 + 1);
	self->priv->args = _tmp0_;
	self->priv->args_length1 = 0;
	self->priv->_args_size_ = self->priv->args_length1;
	self->ref_count = 1;
}

static void
util_js_callable_finalize (UtilJSCallable * obj)
{
	UtilJSCallable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, UTIL_JS_TYPE_CALLABLE, UtilJSCallable);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->name);
	self->priv->args = (_vala_array_free (self->priv->args, self->priv->args_length1, (GDestroyNotify) g_variant_unref), NULL);
}

/**
     * A class for constructing a well formed, safe, invocable JS call.
     */
static GType
util_js_callable_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { util_js_value_callable_init, util_js_value_callable_free_value, util_js_value_callable_copy_value, util_js_value_callable_peek_pointer, "p", util_js_value_callable_collect_value, "p", util_js_value_callable_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UtilJSCallableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) util_js_callable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UtilJSCallable), 0, (GInstanceInitFunc) util_js_callable_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType util_js_callable_type_id;
	util_js_callable_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UtilJSCallable", &g_define_type_info, &g_define_type_fundamental_info, 0);
	UtilJSCallable_private_offset = g_type_add_instance_private (util_js_callable_type_id, sizeof (UtilJSCallablePrivate));
	return util_js_callable_type_id;
}

GType
util_js_callable_get_type (void)
{
	static volatile gsize util_js_callable_type_id__once = 0;
	if (g_once_init_enter (&util_js_callable_type_id__once)) {
		GType util_js_callable_type_id;
		util_js_callable_type_id = util_js_callable_get_type_once ();
		g_once_init_leave (&util_js_callable_type_id__once, util_js_callable_type_id);
	}
	return util_js_callable_type_id__once;
}

gpointer
util_js_callable_ref (gpointer instance)
{
	UtilJSCallable * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
util_js_callable_unref (gpointer instance)
{
	UtilJSCallable * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		UTIL_JS_CALLABLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

