/* app-conversation-set.c generated by valac 0.56.3, the Vala compiler
 * generated from app-conversation-set.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2017-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_APP_TYPE_CONVERSATION_SET (geary_app_conversation_set_get_type ())
#define GEARY_APP_CONVERSATION_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_APP_TYPE_CONVERSATION_SET, GearyAppConversationSet))
#define GEARY_APP_CONVERSATION_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_APP_TYPE_CONVERSATION_SET, GearyAppConversationSetClass))
#define GEARY_APP_IS_CONVERSATION_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_APP_TYPE_CONVERSATION_SET))
#define GEARY_APP_IS_CONVERSATION_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_APP_TYPE_CONVERSATION_SET))
#define GEARY_APP_CONVERSATION_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_APP_TYPE_CONVERSATION_SET, GearyAppConversationSetClass))

typedef struct _GearyAppConversationSet GearyAppConversationSet;
typedef struct _GearyAppConversationSetClass GearyAppConversationSetClass;
typedef struct _GearyAppConversationSetPrivate GearyAppConversationSetPrivate;
enum  {
	GEARY_APP_CONVERSATION_SET_0_PROPERTY,
	GEARY_APP_CONVERSATION_SET_BASE_FOLDER_PROPERTY,
	GEARY_APP_CONVERSATION_SET_SIZE_PROPERTY,
	GEARY_APP_CONVERSATION_SET_IS_EMPTY_PROPERTY,
	GEARY_APP_CONVERSATION_SET_READ_ONLY_VIEW_PROPERTY,
	GEARY_APP_CONVERSATION_SET_LOGGING_PARENT_PROPERTY,
	GEARY_APP_CONVERSATION_SET_NUM_PROPERTIES
};
static GParamSpec* geary_app_conversation_set_properties[GEARY_APP_CONVERSATION_SET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyAppConversationSet {
	GearyBaseObject parent_instance;
	GearyAppConversationSetPrivate * priv;
};

struct _GearyAppConversationSetClass {
	GearyBaseObjectClass parent_class;
};

struct _GearyAppConversationSetPrivate {
	GearyFolder* _base_folder;
	GeeSet* _conversations;
	GeeHashMap* email_id_map;
	GeeHashMap* logical_message_id_map;
};

static gint GearyAppConversationSet_private_offset;
static gpointer geary_app_conversation_set_parent_class = NULL;
static GearyLoggingSourceIface * geary_app_conversation_set_geary_logging_source_parent_iface = NULL;

VALA_EXTERN GType geary_app_conversation_set_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyFolder* geary_app_conversation_set_get_base_folder (GearyAppConversationSet* self);
static void geary_app_conversation_set_set_base_folder (GearyAppConversationSet* self,
                                                 GearyFolder* value);
VALA_EXTERN gint geary_app_conversation_set_get_size (GearyAppConversationSet* self);
VALA_EXTERN gboolean geary_app_conversation_set_get_is_empty (GearyAppConversationSet* self);
VALA_EXTERN GeeSet* geary_app_conversation_set_get_read_only_view (GearyAppConversationSet* self);
VALA_EXTERN GearyAppConversationSet* geary_app_conversation_set_new (GearyFolder* base_folder);
VALA_EXTERN GearyAppConversationSet* geary_app_conversation_set_construct (GType object_type,
                                                               GearyFolder* base_folder);
VALA_EXTERN gint geary_app_conversation_set_get_email_count (GearyAppConversationSet* self);
VALA_EXTERN gboolean geary_app_conversation_set_has_message_id (GearyAppConversationSet* self,
                                                    GearyRFC822MessageID* message_id);
VALA_EXTERN GearyAppConversation* geary_app_conversation_set_get_by_email_identifier (GearyAppConversationSet* self,
                                                                          GearyEmailIdentifier* id);
VALA_EXTERN void geary_app_conversation_set_add_all_emails (GearyAppConversationSet* self,
                                                GeeCollection* emails,
                                                GeeMultiMap* id_to_paths,
                                                GeeCollection** added,
                                                GeeMultiMap** appended,
                                                GeeCollection** removed_due_to_merge);
static GeeSet* geary_app_conversation_set_get_associated_conversations (GearyAppConversationSet* self,
                                                                 GearyEmail* email);
static GearyAppConversation* geary_app_conversation_set_merge_conversations (GearyAppConversationSet* self,
                                                                      GeeSet* conversations,
                                                                      GeeSet* moved_email);
static GearyAppConversation* geary_app_conversation_set_add_email (GearyAppConversationSet* self,
                                                            GearyEmail* email,
                                                            GeeCollection* known_paths,
                                                            gboolean* added_conversation);
VALA_EXTERN void geary_app_conversation_set_remove_all_emails_by_identifier (GearyAppConversationSet* self,
                                                                 GearyFolderPath* source_path,
                                                                 GeeCollection* ids,
                                                                 GeeCollection* removed,
                                                                 GeeMultiMap* trimmed);
static void geary_app_conversation_set_remove_email_from_conversation (GearyAppConversationSet* self,
                                                                GearyAppConversation* conversation,
                                                                GearyEmail* email);
VALA_EXTERN void geary_app_conversation_remove_path (GearyAppConversation* self,
                                         GearyEmailIdentifier* id,
                                         GearyFolderPath* path);
VALA_EXTERN void geary_app_conversation_set_remove_conversation (GearyAppConversationSet* self,
                                                     GearyAppConversation* conversation);
static GearyLoggingState* geary_app_conversation_set_real_to_logging_state (GearyLoggingSource* base);
static GearyAppConversation* ___lambda164_ (GearyAppConversationSet* self,
                                     GearyRFC822MessageID* a);
static gpointer ____lambda164__gee_map_func (gpointer g,
                                      gpointer self);
VALA_EXTERN gboolean geary_app_conversation_add (GearyAppConversation* self,
                                     GearyEmail* email,
                                     GeeCollection* known_paths);
VALA_EXTERN GearyAppConversation* geary_app_conversation_new (GearyFolder* base_folder);
VALA_EXTERN GearyAppConversation* geary_app_conversation_construct (GType object_type,
                                                        GearyFolder* base_folder);
static void geary_app_conversation_set_add_email_to_conversation (GearyAppConversationSet* self,
                                                           GearyAppConversation* conversation,
                                                           GearyEmail* email,
                                                           GeeCollection* known_paths);
VALA_EXTERN GeeHashMultiMap* geary_app_conversation_get_path_map (GearyAppConversation* self);
VALA_EXTERN GeeSet* geary_app_conversation_remove (GearyAppConversation* self,
                                       GearyEmail* email);
static void geary_app_conversation_set_finalize (GObject * obj);
static GType geary_app_conversation_set_get_type_once (void);
static void _vala_geary_app_conversation_set_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_geary_app_conversation_set_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
geary_app_conversation_set_get_instance_private (GearyAppConversationSet* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAppConversationSet_private_offset);
}

GearyFolder*
geary_app_conversation_set_get_base_folder (GearyAppConversationSet* self)
{
	GearyFolder* result;
	GearyFolder* _tmp0_;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_SET (self), NULL);
	_tmp0_ = self->priv->_base_folder;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_app_conversation_set_set_base_folder (GearyAppConversationSet* self,
                                            GearyFolder* value)
{
	GearyFolder* old_value;
	g_return_if_fail (GEARY_APP_IS_CONVERSATION_SET (self));
	old_value = geary_app_conversation_set_get_base_folder (self);
	if (old_value != value) {
		GearyFolder* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_base_folder);
		self->priv->_base_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_app_conversation_set_properties[GEARY_APP_CONVERSATION_SET_BASE_FOLDER_PROPERTY]);
	}
}

gint
geary_app_conversation_set_get_size (GearyAppConversationSet* self)
{
	gint result;
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_SET (self), 0);
	_tmp0_ = self->priv->_conversations;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
geary_app_conversation_set_get_is_empty (GearyAppConversationSet* self)
{
	gboolean result;
	GeeSet* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_SET (self), FALSE);
	_tmp0_ = self->priv->_conversations;
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

GeeSet*
geary_app_conversation_set_get_read_only_view (GearyAppConversationSet* self)
{
	GeeSet* result;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_SET (self), NULL);
	_tmp0_ = self->priv->_conversations;
	_tmp1_ = gee_set_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static const gchar*
geary_app_conversation_set_real_get_logging_domain (GearyLoggingSource* base)
{
	const gchar* result;
	GearyAppConversationSet* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_CONVERSATION_SET, GearyAppConversationSet);
	result = GEARY_APP_CONVERSATION_MONITOR_LOGGING_DOMAIN;
	return result;
}

static GearyLoggingSource*
geary_app_conversation_set_real_get_logging_parent (GearyLoggingSource* base)
{
	GearyLoggingSource* result;
	GearyAppConversationSet* self;
	GearyFolder* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_CONVERSATION_SET, GearyAppConversationSet);
	_tmp0_ = self->priv->_base_folder;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource);
	return result;
}

/**
     * Constructs a new conversation set.
     *
     * The `base_folder` argument is the base folder for the
     * conversation monitor that owns this set.
     */
GearyAppConversationSet*
geary_app_conversation_set_construct (GType object_type,
                                      GearyFolder* base_folder)
{
	GearyAppConversationSet * self = NULL;
	g_return_val_if_fail (GEARY_IS_FOLDER (base_folder), NULL);
	self = (GearyAppConversationSet*) geary_base_object_construct (object_type);
	geary_app_conversation_set_set_base_folder (self, base_folder);
	return self;
}

GearyAppConversationSet*
geary_app_conversation_set_new (GearyFolder* base_folder)
{
	return geary_app_conversation_set_construct (GEARY_APP_TYPE_CONVERSATION_SET, base_folder);
}

gint
geary_app_conversation_set_get_email_count (GearyAppConversationSet* self)
{
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_SET (self), 0);
	_tmp0_ = self->priv->email_id_map;
	_tmp1_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
     * Return whether the set has the given Message ID.  If logical_set,
     * there's no requirement that any conversation actually contain a message
     * with a matching Message-ID header, and any Message ID matching any
     * ancestor of any message in any conversation will match.
     */
gboolean
geary_app_conversation_set_has_message_id (GearyAppConversationSet* self,
                                           GearyRFC822MessageID* message_id)
{
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_SET (self), FALSE);
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID (message_id), FALSE);
	_tmp0_ = self->priv->logical_message_id_map;
	result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), message_id);
	return result;
}

GearyAppConversation*
geary_app_conversation_set_get_by_email_identifier (GearyAppConversationSet* self,
                                                    GearyEmailIdentifier* id)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GearyAppConversation* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_SET (self), NULL);
	g_return_val_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id), NULL);
	_tmp0_ = self->priv->email_id_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), id);
	result = (GearyAppConversation*) _tmp1_;
	return result;
}

/**
     * Adds a collection of emails to conversations in this set.
     *
     * This method will create and/or merge conversations as
     * needed. The collection `emails` contains the messages to be
     * added, and for each email in the collection, there should be an
     * entry in `id_to_paths` that indicates the folders each message
     * is known to belong to.
     *
     * The three collections returned include any conversation that
     * were created, any that had email appended to them (and the
     * messages that were appended), and any that were removed due to
     * being merged into another.
     */
void
geary_app_conversation_set_add_all_emails (GearyAppConversationSet* self,
                                           GeeCollection* emails,
                                           GeeMultiMap* id_to_paths,
                                           GeeCollection** added,
                                           GeeMultiMap** appended,
                                           GeeCollection** removed_due_to_merge)
{
	GeeCollection* _vala_added = NULL;
	GeeMultiMap* _vala_appended = NULL;
	GeeCollection* _vala_removed_due_to_merge = NULL;
	GeeHashSet* _added = NULL;
	GeeHashSet* _tmp0_;
	GeeHashMultiMap* _appended = NULL;
	GeeHashMultiMap* _tmp1_;
	GeeHashSet* _removed_due_to_merge = NULL;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp59_;
	GeeCollection* _tmp60_;
	GeeHashMultiMap* _tmp61_;
	GeeMultiMap* _tmp62_;
	GeeHashSet* _tmp63_;
	GeeCollection* _tmp64_;
	g_return_if_fail (GEARY_APP_IS_CONVERSATION_SET (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emails, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (id_to_paths, GEE_TYPE_MULTI_MAP));
	_tmp0_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_added = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_appended = _tmp1_;
	_tmp2_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_removed_due_to_merge = _tmp2_;
	{
		GeeIterator* _email_it = NULL;
		GeeIterator* _tmp3_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (emails, GEE_TYPE_ITERABLE, GeeIterable));
		_email_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GearyEmail* email = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GeeSet* associated = NULL;
			GearyEmail* _tmp7_;
			GeeSet* _tmp8_;
			GeeSet* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GearyAppConversation* conversation = NULL;
			gboolean added_conversation = FALSE;
			GeeCollection* known_paths = NULL;
			GearyEmail* _tmp42_;
			GearyEmailIdentifier* _tmp43_;
			GearyEmailIdentifier* _tmp44_;
			GeeCollection* _tmp45_;
			GeeCollection* _tmp46_;
			GearyAppConversation* _tmp51_;
			_tmp4_ = _email_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _email_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			email = (GearyEmail*) _tmp6_;
			_tmp7_ = email;
			_tmp8_ = geary_app_conversation_set_get_associated_conversations (self, _tmp7_);
			associated = _tmp8_;
			_tmp9_ = associated;
			_tmp10_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp11_ = _tmp10_;
			if (_tmp11_ > 1) {
				GeeSet* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				GeeSet* moved_email = NULL;
				GeeHashSet* _tmp15_;
				GearyAppConversation* dest = NULL;
				GeeSet* _tmp16_;
				GeeSet* _tmp17_;
				GearyAppConversation* _tmp18_;
				GeeSet* _tmp19_;
				GearyAppConversation* _tmp20_;
				GeeHashSet* _tmp21_;
				GeeSet* _tmp22_;
				GeeHashSet* _tmp30_;
				GeeSet* _tmp31_;
				GeeHashSet* _tmp32_;
				GearyAppConversation* _tmp33_;
				_tmp12_ = associated;
				_tmp13_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp14_ = _tmp13_;
				geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Merging %d conversations due new email associating with all...", _tmp14_);
				_tmp15_ = gee_hash_set_new (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
				moved_email = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_SET, GeeSet);
				_tmp16_ = associated;
				_tmp17_ = moved_email;
				_tmp18_ = geary_app_conversation_set_merge_conversations (self, _tmp16_, _tmp17_);
				dest = _tmp18_;
				_tmp19_ = associated;
				_tmp20_ = dest;
				_vala_assert (!gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_COLLECTION, GeeCollection), _tmp20_), "!associated.contains(dest)");
				_tmp21_ = _added;
				_tmp22_ = associated;
				gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_COLLECTION, GeeCollection));
				{
					GeeIterator* _removed_conversation_it = NULL;
					GeeSet* _tmp23_;
					GeeIterator* _tmp24_;
					_tmp23_ = associated;
					_tmp24_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ITERABLE, GeeIterable));
					_removed_conversation_it = _tmp24_;
					while (TRUE) {
						GeeIterator* _tmp25_;
						GearyAppConversation* removed_conversation = NULL;
						GeeIterator* _tmp26_;
						gpointer _tmp27_;
						GeeHashMultiMap* _tmp28_;
						GearyAppConversation* _tmp29_;
						_tmp25_ = _removed_conversation_it;
						if (!gee_iterator_next (_tmp25_)) {
							break;
						}
						_tmp26_ = _removed_conversation_it;
						_tmp27_ = gee_iterator_get (_tmp26_);
						removed_conversation = (GearyAppConversation*) _tmp27_;
						_tmp28_ = _appended;
						_tmp29_ = removed_conversation;
						gee_multi_map_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp29_);
						_g_object_unref0 (removed_conversation);
					}
					_g_object_unref0 (_removed_conversation_it);
				}
				_tmp30_ = _removed_due_to_merge;
				_tmp31_ = associated;
				gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp32_ = _added;
				_tmp33_ = dest;
				if (!gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp33_)) {
					{
						GeeIterator* _moved_it = NULL;
						GeeSet* _tmp34_;
						GeeIterator* _tmp35_;
						_tmp34_ = moved_email;
						_tmp35_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ITERABLE, GeeIterable));
						_moved_it = _tmp35_;
						while (TRUE) {
							GeeIterator* _tmp36_;
							GearyEmail* moved = NULL;
							GeeIterator* _tmp37_;
							gpointer _tmp38_;
							GeeHashMultiMap* _tmp39_;
							GearyAppConversation* _tmp40_;
							GearyEmail* _tmp41_;
							_tmp36_ = _moved_it;
							if (!gee_iterator_next (_tmp36_)) {
								break;
							}
							_tmp37_ = _moved_it;
							_tmp38_ = gee_iterator_get (_tmp37_);
							moved = (GearyEmail*) _tmp38_;
							_tmp39_ = _appended;
							_tmp40_ = dest;
							_tmp41_ = moved;
							gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp40_, _tmp41_);
							_g_object_unref0 (moved);
						}
						_g_object_unref0 (_moved_it);
					}
				}
				_g_object_unref0 (dest);
				_g_object_unref0 (moved_email);
			}
			conversation = NULL;
			added_conversation = FALSE;
			_tmp42_ = email;
			_tmp43_ = geary_email_get_id (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = gee_multi_map_get (id_to_paths, _tmp44_);
			known_paths = _tmp45_;
			_tmp46_ = known_paths;
			if (_tmp46_ != NULL) {
				GearyEmail* _tmp47_;
				GeeCollection* _tmp48_;
				gboolean _tmp49_ = FALSE;
				GearyAppConversation* _tmp50_;
				_tmp47_ = email;
				_tmp48_ = known_paths;
				_tmp50_ = geary_app_conversation_set_add_email (self, _tmp47_, _tmp48_, &_tmp49_);
				added_conversation = _tmp49_;
				_g_object_unref0 (conversation);
				conversation = _tmp50_;
			}
			_tmp51_ = conversation;
			if (_tmp51_ != NULL) {
				if (added_conversation) {
					GeeHashSet* _tmp52_;
					GearyAppConversation* _tmp53_;
					_tmp52_ = _added;
					_tmp53_ = conversation;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp53_);
				} else {
					GeeHashSet* _tmp54_;
					GearyAppConversation* _tmp55_;
					_tmp54_ = _added;
					_tmp55_ = conversation;
					if (!gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp55_)) {
						GeeHashMultiMap* _tmp56_;
						GearyAppConversation* _tmp57_;
						GearyEmail* _tmp58_;
						_tmp56_ = _appended;
						_tmp57_ = conversation;
						_tmp58_ = email;
						gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp57_, _tmp58_);
					}
				}
			}
			_g_object_unref0 (known_paths);
			_g_object_unref0 (conversation);
			_g_object_unref0 (associated);
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	_tmp59_ = _added;
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (_vala_added);
	_vala_added = _tmp60_;
	_tmp61_ = _appended;
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
	_g_object_unref0 (_vala_appended);
	_vala_appended = _tmp62_;
	_tmp63_ = _removed_due_to_merge;
	_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (_vala_removed_due_to_merge);
	_vala_removed_due_to_merge = _tmp64_;
	_g_object_unref0 (_removed_due_to_merge);
	_g_object_unref0 (_appended);
	_g_object_unref0 (_added);
	if (added) {
		*added = _vala_added;
	} else {
		_g_object_unref0 (_vala_added);
	}
	if (appended) {
		*appended = _vala_appended;
	} else {
		_g_object_unref0 (_vala_appended);
	}
	if (removed_due_to_merge) {
		*removed_due_to_merge = _vala_removed_due_to_merge;
	} else {
		_g_object_unref0 (_vala_removed_due_to_merge);
	}
}

/**
     * Removes a number of emails from conversations in this set.
     *
     * This method will remove and/or trim conversations as
     * needed. The collection `emails_ids` contains the identifiers
     * of emails to be removed.
     *
     * The returned collections include any conversations that were
     * removed (if all of their emails were removed), and any that
     * were trimmed and the emails that were trimmed from it,
     * respectively.
     */
void
geary_app_conversation_set_remove_all_emails_by_identifier (GearyAppConversationSet* self,
                                                            GearyFolderPath* source_path,
                                                            GeeCollection* ids,
                                                            GeeCollection* removed,
                                                            GeeMultiMap* trimmed)
{
	GeeSet* remaining = NULL;
	GeeHashSet* _tmp0_;
	GearyFolder* _tmp38_;
	GearyFolderPath* _tmp39_;
	GearyFolderPath* _tmp40_;
	g_return_if_fail (GEARY_APP_IS_CONVERSATION_SET (self));
	g_return_if_fail (GEARY_IS_FOLDER_PATH (source_path));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (trimmed, GEE_TYPE_MULTI_MAP));
	_tmp0_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	remaining = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
	{
		GeeIterator* _id_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (ids, GEE_TYPE_ITERABLE, GeeIterable));
		_id_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			GearyEmailIdentifier* id = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GearyAppConversation* conversation = NULL;
			GeeHashMap* _tmp5_;
			GearyEmailIdentifier* _tmp6_;
			gpointer _tmp7_;
			GearyAppConversation* _tmp8_;
			_tmp2_ = _id_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _id_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			id = (GearyEmailIdentifier*) _tmp4_;
			_tmp5_ = self->priv->email_id_map;
			_tmp6_ = id;
			_tmp7_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_);
			conversation = (GearyAppConversation*) _tmp7_;
			_tmp8_ = conversation;
			if (_tmp8_ != NULL) {
				GearyEmail* email = NULL;
				GearyAppConversation* _tmp9_;
				GearyEmailIdentifier* _tmp10_;
				GearyEmail* _tmp11_;
				GearyEmail* _tmp12_;
				GearyAppConversation* _tmp27_;
				_tmp9_ = conversation;
				_tmp10_ = id;
				_tmp11_ = geary_app_conversation_get_email_by_id (_tmp9_, _tmp10_);
				email = _tmp11_;
				_tmp12_ = email;
				if (_tmp12_ != NULL) {
					GearyAppConversation* _tmp13_;
					GearyEmailIdentifier* _tmp14_;
					_tmp13_ = conversation;
					_tmp14_ = id;
					switch (geary_app_conversation_get_folder_count (_tmp13_, _tmp14_)) {
						case 0:
						{
							GearyEmailIdentifier* _tmp15_;
							gchar* _tmp16_;
							gchar* _tmp17_;
							GearyAppConversation* _tmp18_;
							gchar* _tmp19_;
							gchar* _tmp20_;
							_tmp15_ = id;
							_tmp16_ = geary_email_identifier_to_string (_tmp15_);
							_tmp17_ = _tmp16_;
							_tmp18_ = conversation;
							_tmp19_ = geary_app_conversation_to_string (_tmp18_);
							_tmp20_ = _tmp19_;
							geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Email %s conversation %s not in any folders", _tmp17_, _tmp20_);
							_g_free0 (_tmp20_);
							_g_free0 (_tmp17_);
							break;
						}
						case 1:
						{
							GearyAppConversation* _tmp21_;
							GearyEmail* _tmp22_;
							GearyAppConversation* _tmp23_;
							GearyEmail* _tmp24_;
							_tmp21_ = conversation;
							_tmp22_ = email;
							geary_app_conversation_set_remove_email_from_conversation (self, _tmp21_, _tmp22_);
							_tmp23_ = conversation;
							_tmp24_ = email;
							gee_multi_map_set (trimmed, _tmp23_, _tmp24_);
							break;
						}
						default:
						{
							GearyAppConversation* _tmp25_;
							GearyEmailIdentifier* _tmp26_;
							_tmp25_ = conversation;
							_tmp26_ = id;
							geary_app_conversation_remove_path (_tmp25_, _tmp26_, source_path);
							break;
						}
					}
				}
				_tmp27_ = conversation;
				if (geary_app_conversation_get_count (_tmp27_) == 0) {
					GearyAppConversation* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					GearyAppConversation* _tmp31_;
					GeeSet* _tmp32_;
					GearyAppConversation* _tmp33_;
					GearyAppConversation* _tmp34_;
					GearyAppConversation* _tmp35_;
					_tmp28_ = conversation;
					_tmp29_ = geary_app_conversation_to_string (_tmp28_);
					_tmp30_ = _tmp29_;
					geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Conversation %s evaporated: No messages remains", _tmp30_);
					_g_free0 (_tmp30_);
					_tmp31_ = conversation;
					gee_collection_add (removed, _tmp31_);
					_tmp32_ = remaining;
					_tmp33_ = conversation;
					gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_COLLECTION, GeeCollection), _tmp33_);
					_tmp34_ = conversation;
					gee_multi_map_remove_all (trimmed, _tmp34_);
					_tmp35_ = conversation;
					geary_app_conversation_set_remove_conversation (self, _tmp35_);
				} else {
					GeeSet* _tmp36_;
					GearyAppConversation* _tmp37_;
					_tmp36_ = remaining;
					_tmp37_ = conversation;
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_COLLECTION, GeeCollection), _tmp37_);
				}
				_g_object_unref0 (email);
			}
			_g_object_unref0 (conversation);
			_g_object_unref0 (id);
		}
		_g_object_unref0 (_id_it);
	}
	_tmp38_ = self->priv->_base_folder;
	_tmp39_ = geary_folder_get_path (_tmp38_);
	_tmp40_ = _tmp39_;
	if (gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (source_path, GEE_TYPE_HASHABLE, GeeHashable), _tmp40_)) {
		{
			GeeIterator* _conversation_it = NULL;
			GeeSet* _tmp41_;
			GeeIterator* _tmp42_;
			_tmp41_ = remaining;
			_tmp42_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, GEE_TYPE_ITERABLE, GeeIterable));
			_conversation_it = _tmp42_;
			while (TRUE) {
				GeeIterator* _tmp43_;
				GearyAppConversation* conversation = NULL;
				GeeIterator* _tmp44_;
				gpointer _tmp45_;
				GearyAppConversation* _tmp46_;
				_tmp43_ = _conversation_it;
				if (!gee_iterator_next (_tmp43_)) {
					break;
				}
				_tmp44_ = _conversation_it;
				_tmp45_ = gee_iterator_get (_tmp44_);
				conversation = (GearyAppConversation*) _tmp45_;
				_tmp46_ = conversation;
				if (geary_app_conversation_get_count_in_folder (_tmp46_, source_path) == ((guint) 0)) {
					GearyAppConversation* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					GearyAppConversation* _tmp50_;
					GearyAppConversation* _tmp51_;
					GearyAppConversation* _tmp52_;
					_tmp47_ = conversation;
					_tmp48_ = geary_app_conversation_to_string (_tmp47_);
					_tmp49_ = _tmp48_;
					geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Conversation %s dropped: No messages in base folder remain", _tmp49_);
					_g_free0 (_tmp49_);
					_tmp50_ = conversation;
					gee_collection_add (removed, _tmp50_);
					_tmp51_ = conversation;
					gee_multi_map_remove_all (trimmed, _tmp51_);
					_tmp52_ = conversation;
					geary_app_conversation_set_remove_conversation (self, _tmp52_);
				}
				_g_object_unref0 (conversation);
			}
			_g_object_unref0 (_conversation_it);
		}
	}
	_g_object_unref0 (remaining);
}

/**
     * Removes a conversation from the set.
     */
void
geary_app_conversation_set_remove_conversation (GearyAppConversationSet* self,
                                                GearyAppConversation* conversation)
{
	GeeCollection* conversation_emails = NULL;
	GeeList* _tmp0_;
	GeeSet* _tmp7_;
	g_return_if_fail (GEARY_APP_IS_CONVERSATION_SET (self));
	g_return_if_fail (GEARY_APP_IS_CONVERSATION (conversation));
	_tmp0_ = geary_app_conversation_get_emails (conversation, GEARY_APP_CONVERSATION_ORDERING_NONE, GEARY_APP_CONVERSATION_LOCATION_ANYWHERE, NULL, FALSE);
	conversation_emails = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	{
		GeeIterator* _conversation_email_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = conversation_emails;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_conversation_email_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			GearyEmail* conversation_email = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GearyEmail* _tmp6_;
			_tmp3_ = _conversation_email_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _conversation_email_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			conversation_email = (GearyEmail*) _tmp5_;
			_tmp6_ = conversation_email;
			geary_app_conversation_set_remove_email_from_conversation (self, conversation, _tmp6_);
			_g_object_unref0 (conversation_email);
		}
		_g_object_unref0 (_conversation_email_it);
	}
	_tmp7_ = self->priv->_conversations;
	if (!gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection), conversation)) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = geary_app_conversation_to_string (conversation);
		_tmp9_ = _tmp8_;
		geary_logging_source_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Conversation %s already removed from set", _tmp9_);
		_g_free0 (_tmp9_);
	}
	_g_object_unref0 (conversation_emails);
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_app_conversation_set_real_to_logging_state (GearyLoggingSource* base)
{
	GearyAppConversationSet * self;
	gint _tmp0_;
	gint _tmp1_;
	GearyLoggingState* _tmp2_;
	GearyLoggingState* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_APP_TYPE_CONVERSATION_SET, GearyAppConversationSet);
	_tmp0_ = geary_app_conversation_set_get_size (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "size=%d", _tmp1_);
	result = _tmp2_;
	return result;
}

static GearyAppConversation*
___lambda164_ (GearyAppConversationSet* self,
               GearyRFC822MessageID* a)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GearyAppConversation* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE_ID (a), NULL);
	_tmp0_ = self->priv->logical_message_id_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), a);
	result = (GearyAppConversation*) _tmp1_;
	_g_object_unref0 (a);
	return result;
}

static gpointer
____lambda164__gee_map_func (gpointer g,
                             gpointer self)
{
	gpointer result;
	result = ___lambda164_ ((GearyAppConversationSet*) self, (GearyRFC822MessageID*) g);
	return result;
}

static GeeSet*
geary_app_conversation_set_get_associated_conversations (GearyAppConversationSet* self,
                                                         GearyEmail* email)
{
	GeeSet* ancestors = NULL;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp9_;
	GeeSet* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_SET (self), NULL);
	g_return_val_if_fail (GEARY_IS_EMAIL (email), NULL);
	_tmp0_ = geary_email_get_ancestors (email);
	ancestors = _tmp0_;
	_tmp1_ = ancestors;
	if (_tmp1_ != NULL) {
		GeeSet* _tmp2_;
		GearyIterable* _tmp3_;
		GearyIterable* _tmp4_;
		GearyIterable* _tmp5_;
		GearyIterable* _tmp6_;
		GeeHashSet* _tmp7_;
		GeeSet* _tmp8_;
		_tmp2_ = ancestors;
		_tmp3_ = geary_traverse (GEARY_RF_C822_TYPE_MESSAGE_ID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_iterable_map_nonnull (_tmp4_, GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, ____lambda164__gee_map_func, self);
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_iterable_to_hash_set (_tmp6_, NULL, NULL, NULL, NULL, NULL, NULL);
		_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_SET, GeeSet);
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp4_);
		result = _tmp8_;
		_g_object_unref0 (ancestors);
		return result;
	}
	_tmp9_ = gee_set_empty (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
	result = _tmp9_;
	_g_object_unref0 (ancestors);
	return result;
}

/**
     * Conditionally adds an email to a conversation.
     *
     * The given email will be added to new conversation if there are
     * not any associated conversations, added to an existing
     * conversation if it does not exist in an associated
     * conversation, otherwise if in an existing conversation,
     * `known_paths` will be merged with the email's paths in that
     * conversation.
     *
     * Returns the conversation the email was strictly added to, else
     * `null` if the conversation was simply merged. The parameter
     * `added_conversation` is set `true` if the returned conversation
     * was created, else it is set to `false`.
     */
static GearyAppConversation*
geary_app_conversation_set_add_email (GearyAppConversationSet* self,
                                      GearyEmail* email,
                                      GeeCollection* known_paths,
                                      gboolean* added_conversation)
{
	gboolean _vala_added_conversation = FALSE;
	GearyAppConversation* conversation = NULL;
	GeeHashMap* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GearyEmailIdentifier* _tmp2_;
	gpointer _tmp3_;
	GearyAppConversation* _tmp4_;
	GearyAppConversation* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_SET (self), NULL);
	g_return_val_if_fail (GEARY_IS_EMAIL (email), NULL);
	g_return_val_if_fail ((known_paths == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (known_paths, GEE_TYPE_COLLECTION), NULL);
	_vala_added_conversation = FALSE;
	_tmp0_ = self->priv->email_id_map;
	_tmp1_ = geary_email_get_id (email);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_);
	conversation = (GearyAppConversation*) _tmp3_;
	_tmp4_ = conversation;
	if (_tmp4_ != NULL) {
		GearyAppConversation* _tmp5_;
		_tmp5_ = conversation;
		geary_app_conversation_add (_tmp5_, email, known_paths);
		_g_object_unref0 (conversation);
		conversation = NULL;
	} else {
		GeeSet* associated = NULL;
		GeeSet* _tmp6_;
		GeeSet* _tmp7_;
		gpointer _tmp8_;
		GearyAppConversation* _tmp9_;
		GearyAppConversation* _tmp14_;
		_tmp6_ = geary_app_conversation_set_get_associated_conversations (self, email);
		associated = _tmp6_;
		_tmp7_ = associated;
		_tmp8_ = geary_collection_first (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (conversation);
		conversation = (GearyAppConversation*) _tmp8_;
		_tmp9_ = conversation;
		if (_tmp9_ == NULL) {
			GearyFolder* _tmp10_;
			GearyAppConversation* _tmp11_;
			GeeSet* _tmp12_;
			GearyAppConversation* _tmp13_;
			_tmp10_ = self->priv->_base_folder;
			_tmp11_ = geary_app_conversation_new (_tmp10_);
			_g_object_unref0 (conversation);
			conversation = _tmp11_;
			_tmp12_ = self->priv->_conversations;
			_tmp13_ = conversation;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection), _tmp13_);
			_vala_added_conversation = TRUE;
		}
		_tmp14_ = conversation;
		geary_app_conversation_set_add_email_to_conversation (self, _tmp14_, email, known_paths);
		_g_object_unref0 (associated);
	}
	result = conversation;
	if (added_conversation) {
		*added_conversation = _vala_added_conversation;
	}
	return result;
}

/**
     * Unconditionally adds an email to a conversation.
     */
static void
geary_app_conversation_set_add_email_to_conversation (GearyAppConversationSet* self,
                                                      GearyAppConversation* conversation,
                                                      GearyEmail* email,
                                                      GeeCollection* known_paths)
{
	GeeHashMap* _tmp6_;
	GearyEmailIdentifier* _tmp7_;
	GearyEmailIdentifier* _tmp8_;
	GeeSet* ancestors = NULL;
	GeeSet* _tmp9_;
	GeeSet* _tmp10_;
	g_return_if_fail (GEARY_APP_IS_CONVERSATION_SET (self));
	g_return_if_fail (GEARY_APP_IS_CONVERSATION (conversation));
	g_return_if_fail (GEARY_IS_EMAIL (email));
	g_return_if_fail ((known_paths == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (known_paths, GEE_TYPE_COLLECTION));
	if (!geary_app_conversation_add (conversation, email, known_paths)) {
		GearyEmailIdentifier* _tmp0_;
		GearyEmailIdentifier* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = geary_email_get_id (email);
		_tmp1_ = _tmp0_;
		_tmp2_ = geary_email_identifier_to_string (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = geary_app_conversation_to_string (conversation);
		_tmp5_ = _tmp4_;
		geary_logging_source_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Couldn't add duplicate email %s to conversation %s", _tmp3_, _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
	_tmp6_ = self->priv->email_id_map;
	_tmp7_ = geary_email_get_id (email);
	_tmp8_ = _tmp7_;
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_, conversation);
	_tmp9_ = geary_email_get_ancestors (email);
	ancestors = _tmp9_;
	_tmp10_ = ancestors;
	if (_tmp10_ != NULL) {
		{
			GeeIterator* _ancestor_it = NULL;
			GeeSet* _tmp11_;
			GeeIterator* _tmp12_;
			_tmp11_ = ancestors;
			_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
			_ancestor_it = _tmp12_;
			while (TRUE) {
				GeeIterator* _tmp13_;
				GearyRFC822MessageID* ancestor = NULL;
				GeeIterator* _tmp14_;
				gpointer _tmp15_;
				GeeHashMap* _tmp16_;
				GearyRFC822MessageID* _tmp17_;
				_tmp13_ = _ancestor_it;
				if (!gee_iterator_next (_tmp13_)) {
					break;
				}
				_tmp14_ = _ancestor_it;
				_tmp15_ = gee_iterator_get (_tmp14_);
				ancestor = (GearyRFC822MessageID*) _tmp15_;
				_tmp16_ = self->priv->logical_message_id_map;
				_tmp17_ = ancestor;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp17_, conversation);
				_g_object_unref0 (ancestor);
			}
			_g_object_unref0 (_ancestor_it);
		}
	}
	_g_object_unref0 (ancestors);
}

static GearyAppConversation*
geary_app_conversation_set_merge_conversations (GearyAppConversationSet* self,
                                                GeeSet* conversations,
                                                GeeSet* moved_email)
{
	gint _tmp0_;
	gint _tmp1_;
	GearyAppConversation* dest = NULL;
	gboolean removed = FALSE;
	GearyAppConversation* _tmp12_;
	GeeMultiMap* id_to_paths = NULL;
	GeeHashMultiMap* _tmp13_;
	GearyAppConversation* result;
	g_return_val_if_fail (GEARY_APP_IS_CONVERSATION_SET (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (conversations, GEE_TYPE_SET), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (moved_email, GEE_TYPE_SET), NULL);
	_tmp0_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (conversations, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ > 0, "conversations.size > 0");
	dest = NULL;
	{
		GeeIterator* _conversation_it = NULL;
		GeeIterator* _tmp2_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (conversations, GEE_TYPE_ITERABLE, GeeIterable));
		_conversation_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			GearyAppConversation* conversation = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			gboolean _tmp6_ = FALSE;
			GearyAppConversation* _tmp7_;
			_tmp3_ = _conversation_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _conversation_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			conversation = (GearyAppConversation*) _tmp5_;
			_tmp7_ = dest;
			if (_tmp7_ == NULL) {
				_tmp6_ = TRUE;
			} else {
				GearyAppConversation* _tmp8_;
				GearyAppConversation* _tmp9_;
				_tmp8_ = conversation;
				_tmp9_ = dest;
				_tmp6_ = geary_app_conversation_get_count (_tmp8_) > geary_app_conversation_get_count (_tmp9_);
			}
			if (_tmp6_) {
				GearyAppConversation* _tmp10_;
				GearyAppConversation* _tmp11_;
				_tmp10_ = conversation;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_g_object_unref0 (dest);
				dest = _tmp11_;
			}
			_g_object_unref0 (conversation);
		}
		_g_object_unref0 (_conversation_it);
	}
	_tmp12_ = dest;
	removed = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (conversations, GEE_TYPE_COLLECTION, GeeCollection), _tmp12_);
	_vala_assert (removed, "removed");
	_tmp13_ = gee_hash_multi_map_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_TYPE_FOLDER_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	id_to_paths = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
	{
		GeeIterator* _conversation_it = NULL;
		GeeIterator* _tmp14_;
		_tmp14_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (conversations, GEE_TYPE_ITERABLE, GeeIterable));
		_conversation_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			GearyAppConversation* conversation = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			GearyAppConversation* _tmp46_;
			_tmp15_ = _conversation_it;
			if (!gee_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _conversation_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			conversation = (GearyAppConversation*) _tmp17_;
			{
				GeeIterator* _id_it = NULL;
				GearyAppConversation* _tmp18_;
				GeeHashMultiMap* _tmp19_;
				GeeHashMultiMap* _tmp20_;
				GeeSet* _tmp21_;
				GeeSet* _tmp22_;
				GeeIterator* _tmp23_;
				GeeIterator* _tmp24_;
				_tmp18_ = conversation;
				_tmp19_ = geary_app_conversation_get_path_map (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gee_multi_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
				_tmp22_ = _tmp21_;
				_tmp23_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ITERABLE, GeeIterable));
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp22_);
				_id_it = _tmp24_;
				while (TRUE) {
					GeeIterator* _tmp25_;
					GearyEmailIdentifier* id = NULL;
					GeeIterator* _tmp26_;
					gpointer _tmp27_;
					GearyAppConversation* _tmp28_;
					GearyEmailIdentifier* _tmp29_;
					GearyEmail* _tmp30_;
					GearyEmail* _tmp31_;
					_tmp25_ = _id_it;
					if (!gee_iterator_next (_tmp25_)) {
						break;
					}
					_tmp26_ = _id_it;
					_tmp27_ = gee_iterator_get (_tmp26_);
					id = (GearyEmailIdentifier*) _tmp27_;
					_tmp28_ = conversation;
					_tmp29_ = id;
					_tmp30_ = geary_app_conversation_get_email_by_id (_tmp28_, _tmp29_);
					_tmp31_ = _tmp30_;
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (moved_email, GEE_TYPE_COLLECTION, GeeCollection), _tmp31_);
					_g_object_unref0 (_tmp31_);
					{
						GeeIterator* _path_it = NULL;
						GearyAppConversation* _tmp32_;
						GeeHashMultiMap* _tmp33_;
						GeeHashMultiMap* _tmp34_;
						GearyEmailIdentifier* _tmp35_;
						GeeCollection* _tmp36_;
						GeeCollection* _tmp37_;
						GeeIterator* _tmp38_;
						GeeIterator* _tmp39_;
						_tmp32_ = conversation;
						_tmp33_ = geary_app_conversation_get_path_map (_tmp32_);
						_tmp34_ = _tmp33_;
						_tmp35_ = id;
						_tmp36_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp35_);
						_tmp37_ = _tmp36_;
						_tmp38_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_ITERABLE, GeeIterable));
						_tmp39_ = _tmp38_;
						_g_object_unref0 (_tmp37_);
						_path_it = _tmp39_;
						while (TRUE) {
							GeeIterator* _tmp40_;
							GearyFolderPath* path = NULL;
							GeeIterator* _tmp41_;
							gpointer _tmp42_;
							GeeMultiMap* _tmp43_;
							GearyEmailIdentifier* _tmp44_;
							GearyFolderPath* _tmp45_;
							_tmp40_ = _path_it;
							if (!gee_iterator_next (_tmp40_)) {
								break;
							}
							_tmp41_ = _path_it;
							_tmp42_ = gee_iterator_get (_tmp41_);
							path = (GearyFolderPath*) _tmp42_;
							_tmp43_ = id_to_paths;
							_tmp44_ = id;
							_tmp45_ = path;
							gee_multi_map_set (_tmp43_, _tmp44_, _tmp45_);
							_g_object_unref0 (path);
						}
						_g_object_unref0 (_path_it);
					}
					_g_object_unref0 (id);
				}
				_g_object_unref0 (_id_it);
			}
			_tmp46_ = conversation;
			geary_app_conversation_set_remove_conversation (self, _tmp46_);
			_g_object_unref0 (conversation);
		}
		_g_object_unref0 (_conversation_it);
	}
	{
		GeeIterator* _moved_it = NULL;
		GeeIterator* _tmp47_;
		_tmp47_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (moved_email, GEE_TYPE_ITERABLE, GeeIterable));
		_moved_it = _tmp47_;
		while (TRUE) {
			GeeIterator* _tmp48_;
			GearyEmail* moved = NULL;
			GeeIterator* _tmp49_;
			gpointer _tmp50_;
			GearyAppConversation* _tmp51_;
			GearyEmail* _tmp52_;
			GeeMultiMap* _tmp53_;
			GearyEmail* _tmp54_;
			GearyEmailIdentifier* _tmp55_;
			GearyEmailIdentifier* _tmp56_;
			GeeCollection* _tmp57_;
			GeeCollection* _tmp58_;
			_tmp48_ = _moved_it;
			if (!gee_iterator_next (_tmp48_)) {
				break;
			}
			_tmp49_ = _moved_it;
			_tmp50_ = gee_iterator_get (_tmp49_);
			moved = (GearyEmail*) _tmp50_;
			_tmp51_ = dest;
			_tmp52_ = moved;
			_tmp53_ = id_to_paths;
			_tmp54_ = moved;
			_tmp55_ = geary_email_get_id (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = gee_multi_map_get (_tmp53_, _tmp56_);
			_tmp58_ = _tmp57_;
			geary_app_conversation_set_add_email_to_conversation (self, _tmp51_, _tmp52_, _tmp58_);
			_g_object_unref0 (_tmp58_);
			_g_object_unref0 (moved);
		}
		_g_object_unref0 (_moved_it);
	}
	result = dest;
	_g_object_unref0 (id_to_paths);
	return result;
}

/**
     * Unconditionally removes an email from a conversation.
     */
static void
geary_app_conversation_set_remove_email_from_conversation (GearyAppConversationSet* self,
                                                           GearyAppConversation* conversation,
                                                           GearyEmail* email)
{
	GeeHashMap* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GearyEmailIdentifier* _tmp2_;
	GeeSet* removed_message_ids = NULL;
	GeeSet* _tmp7_;
	gint _tmp8_ = 0;
	GeeSet* _tmp9_;
	GeeSet* _tmp13_;
	g_return_if_fail (GEARY_APP_IS_CONVERSATION_SET (self));
	g_return_if_fail (GEARY_APP_IS_CONVERSATION (conversation));
	g_return_if_fail (GEARY_IS_EMAIL (email));
	_tmp0_ = self->priv->email_id_map;
	_tmp1_ = geary_email_get_id (email);
	_tmp2_ = _tmp1_;
	if (!gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp2_, NULL)) {
		GearyEmailIdentifier* _tmp3_;
		GearyEmailIdentifier* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = geary_email_get_id (email);
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_email_identifier_to_string (_tmp4_);
		_tmp6_ = _tmp5_;
		geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Email %s already removed from conversation set", _tmp6_);
		_g_free0 (_tmp6_);
	}
	_tmp7_ = geary_app_conversation_remove (conversation, email);
	removed_message_ids = _tmp7_;
	_tmp9_ = removed_message_ids;
	if (_tmp9_ != NULL) {
		GeeSet* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp10_ = removed_message_ids;
		_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_;
	} else {
		_tmp8_ = 0;
	}
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Removed %d messages from conversation", _tmp8_);
	_tmp13_ = removed_message_ids;
	if (_tmp13_ != NULL) {
		{
			GeeIterator* _removed_message_id_it = NULL;
			GeeSet* _tmp14_;
			GeeIterator* _tmp15_;
			_tmp14_ = removed_message_ids;
			_tmp15_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ITERABLE, GeeIterable));
			_removed_message_id_it = _tmp15_;
			while (TRUE) {
				GeeIterator* _tmp16_;
				GearyRFC822MessageID* removed_message_id = NULL;
				GeeIterator* _tmp17_;
				gpointer _tmp18_;
				GeeHashMap* _tmp19_;
				GearyRFC822MessageID* _tmp20_;
				_tmp16_ = _removed_message_id_it;
				if (!gee_iterator_next (_tmp16_)) {
					break;
				}
				_tmp17_ = _removed_message_id_it;
				_tmp18_ = gee_iterator_get (_tmp17_);
				removed_message_id = (GearyRFC822MessageID*) _tmp18_;
				_tmp19_ = self->priv->logical_message_id_map;
				_tmp20_ = removed_message_id;
				if (!gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp20_, NULL)) {
					GearyRFC822MessageID* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp21_ = removed_message_id;
					_tmp22_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
					_tmp23_ = _tmp22_;
					geary_logging_source_error (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Message ID %s already removed from conversation set logical map", _tmp23_);
					_g_free0 (_tmp23_);
				}
				_g_object_unref0 (removed_message_id);
			}
			_g_object_unref0 (_removed_message_id_it);
		}
	}
	_g_object_unref0 (removed_message_ids);
}

static void
geary_app_conversation_set_class_init (GearyAppConversationSetClass * klass,
                                       gpointer klass_data)
{
	geary_app_conversation_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAppConversationSet_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_app_conversation_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_app_conversation_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_app_conversation_set_finalize;
	/** The base folder for this set of conversations. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_CONVERSATION_SET_BASE_FOLDER_PROPERTY, geary_app_conversation_set_properties[GEARY_APP_CONVERSATION_SET_BASE_FOLDER_PROPERTY] = g_param_spec_object ("base-folder", "base-folder", "base-folder", GEARY_TYPE_FOLDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines the number of conversations in the set. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_CONVERSATION_SET_SIZE_PROPERTY, geary_app_conversation_set_properties[GEARY_APP_CONVERSATION_SET_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines the set contains no conversations.  */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_CONVERSATION_SET_IS_EMPTY_PROPERTY, geary_app_conversation_set_properties[GEARY_APP_CONVERSATION_SET_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns a read-only view of conversations in the set.  */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_CONVERSATION_SET_READ_ONLY_VIEW_PROPERTY, geary_app_conversation_set_properties[GEARY_APP_CONVERSATION_SET_READ_ONLY_VIEW_PROPERTY] = g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_APP_CONVERSATION_SET_LOGGING_PARENT_PROPERTY, geary_app_conversation_set_properties[GEARY_APP_CONVERSATION_SET_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_app_conversation_set_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                                gpointer iface_data)
{
	geary_app_conversation_set_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_app_conversation_set_real_to_logging_state;
	iface->get_logging_domain = geary_app_conversation_set_real_get_logging_domain;
	iface->get_logging_parent = geary_app_conversation_set_real_get_logging_parent;
}

static void
geary_app_conversation_set_instance_init (GearyAppConversationSet * self,
                                          gpointer klass)
{
	GeeHashSet* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	self->priv = geary_app_conversation_set_get_instance_private (self);
	_tmp0_ = gee_hash_set_new (GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_conversations = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
	_tmp1_ = gee_hash_map_new (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->email_id_map = _tmp1_;
	_tmp2_ = gee_hash_map_new (GEARY_RF_C822_TYPE_MESSAGE_ID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GEARY_APP_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->logical_message_id_map = _tmp2_;
}

static void
geary_app_conversation_set_finalize (GObject * obj)
{
	GearyAppConversationSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_APP_TYPE_CONVERSATION_SET, GearyAppConversationSet);
	_g_object_unref0 (self->priv->_base_folder);
	_g_object_unref0 (self->priv->_conversations);
	_g_object_unref0 (self->priv->email_id_map);
	_g_object_unref0 (self->priv->logical_message_id_map);
	G_OBJECT_CLASS (geary_app_conversation_set_parent_class)->finalize (obj);
}

/**
 * Creates and maintains set of conversations by adding and removing email.
 */
 G_GNUC_NO_INLINE static GType
geary_app_conversation_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAppConversationSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_app_conversation_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAppConversationSet), 0, (GInstanceInitFunc) geary_app_conversation_set_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_app_conversation_set_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_app_conversation_set_type_id;
	geary_app_conversation_set_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyAppConversationSet", &g_define_type_info, 0);
	g_type_add_interface_static (geary_app_conversation_set_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	GearyAppConversationSet_private_offset = g_type_add_instance_private (geary_app_conversation_set_type_id, sizeof (GearyAppConversationSetPrivate));
	return geary_app_conversation_set_type_id;
}

GType
geary_app_conversation_set_get_type (void)
{
	static gsize geary_app_conversation_set_type_id__once = 0;
	if (g_once_init_enter (&geary_app_conversation_set_type_id__once)) {
		GType geary_app_conversation_set_type_id;
		geary_app_conversation_set_type_id = geary_app_conversation_set_get_type_once ();
		g_once_init_leave (&geary_app_conversation_set_type_id__once, geary_app_conversation_set_type_id);
	}
	return geary_app_conversation_set_type_id__once;
}

static void
_vala_geary_app_conversation_set_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GearyAppConversationSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_CONVERSATION_SET, GearyAppConversationSet);
	switch (property_id) {
		case GEARY_APP_CONVERSATION_SET_BASE_FOLDER_PROPERTY:
		g_value_set_object (value, geary_app_conversation_set_get_base_folder (self));
		break;
		case GEARY_APP_CONVERSATION_SET_SIZE_PROPERTY:
		g_value_set_int (value, geary_app_conversation_set_get_size (self));
		break;
		case GEARY_APP_CONVERSATION_SET_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, geary_app_conversation_set_get_is_empty (self));
		break;
		case GEARY_APP_CONVERSATION_SET_READ_ONLY_VIEW_PROPERTY:
		g_value_take_object (value, geary_app_conversation_set_get_read_only_view (self));
		break;
		case GEARY_APP_CONVERSATION_SET_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_logging_source_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_app_conversation_set_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	GearyAppConversationSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_APP_TYPE_CONVERSATION_SET, GearyAppConversationSet);
	switch (property_id) {
		case GEARY_APP_CONVERSATION_SET_BASE_FOLDER_PROPERTY:
		geary_app_conversation_set_set_base_folder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

