/* imap-db-attachment.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-db-attachment.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gmime/gmime.h>
#include <gee.h>

#define GEARY_IMAP_DB_ATTACHMENT_REQUIRED_FIELDS GEARY_EMAIL_REQUIRED_FOR_MESSAGE
#define GEARY_IMAP_DB_ATTACHMENT_NULL_FILE_NAME "none"

#define GEARY_IMAP_DB_TYPE_ATTACHMENT (geary_imap_db_attachment_get_type ())
#define GEARY_IMAP_DB_ATTACHMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachment))
#define GEARY_IMAP_DB_ATTACHMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachmentClass))
#define GEARY_IMAP_DB_IS_ATTACHMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_ATTACHMENT))
#define GEARY_IMAP_DB_IS_ATTACHMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_ATTACHMENT))
#define GEARY_IMAP_DB_ATTACHMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachmentClass))

typedef struct _GearyImapDBAttachment GearyImapDBAttachment;
typedef struct _GearyImapDBAttachmentClass GearyImapDBAttachmentClass;
typedef struct _GearyImapDBAttachmentPrivate GearyImapDBAttachmentPrivate;
enum  {
	GEARY_IMAP_DB_ATTACHMENT_0_PROPERTY,
	GEARY_IMAP_DB_ATTACHMENT_MESSAGE_ID_PROPERTY,
	GEARY_IMAP_DB_ATTACHMENT_NUM_PROPERTIES
};
static GParamSpec* geary_imap_db_attachment_properties[GEARY_IMAP_DB_ATTACHMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GearyImapDBAttachment {
	GearyAttachment parent_instance;
	GearyImapDBAttachmentPrivate * priv;
};

struct _GearyImapDBAttachmentClass {
	GearyAttachmentClass parent_class;
};

struct _GearyImapDBAttachmentPrivate {
	gint64 _message_id;
	gint64 attachment_id;
};

static gint GearyImapDBAttachment_private_offset;
static gpointer geary_imap_db_attachment_parent_class = NULL;

VALA_EXTERN GType geary_imap_db_attachment_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gint64 geary_imap_db_attachment_get_message_id (GearyImapDBAttachment* self);
static void geary_imap_db_attachment_set_message_id (GearyImapDBAttachment* self,
                                              gint64 value);
static GearyImapDBAttachment* geary_imap_db_attachment_new (gint64 message_id,
                                                     GearyMimeContentType* content_type,
                                                     const gchar* content_id,
                                                     const gchar* content_description,
                                                     GearyMimeContentDisposition* content_disposition,
                                                     const gchar* content_filename);
static GearyImapDBAttachment* geary_imap_db_attachment_construct (GType object_type,
                                                           gint64 message_id,
                                                           GearyMimeContentType* content_type,
                                                           const gchar* content_id,
                                                           const gchar* content_description,
                                                           GearyMimeContentDisposition* content_disposition,
                                                           const gchar* content_filename);
VALA_EXTERN GearyImapDBAttachment* geary_imap_db_attachment_new_from_part (gint64 message_id,
                                                               GearyRFC822Part* part,
                                                               GError** error);
VALA_EXTERN GearyImapDBAttachment* geary_imap_db_attachment_construct_from_part (GType object_type,
                                                                     gint64 message_id,
                                                                     GearyRFC822Part* part,
                                                                     GError** error);
VALA_EXTERN GearyImapDBAttachment* geary_imap_db_attachment_new_from_row (GearyDbResult* _result_,
                                                              GFile* attachments_dir,
                                                              GError** error);
VALA_EXTERN GearyImapDBAttachment* geary_imap_db_attachment_construct_from_row (GType object_type,
                                                                    GearyDbResult* _result_,
                                                                    GFile* attachments_dir,
                                                                    GError** error);
VALA_EXTERN GearyMimeDispositionType geary_mime_disposition_type_from_int (gint i);
static GFile* geary_imap_db_attachment_generate_file (GearyImapDBAttachment* self,
                                               GFile* attachments_dir);
VALA_EXTERN void geary_imap_db_attachment_save (GearyImapDBAttachment* self,
                                    GearyDbConnection* cx,
                                    GearyRFC822Part* part,
                                    GFile* attachments_dir,
                                    GCancellable* cancellable,
                                    GError** error);
static void geary_imap_db_attachment_insert_db (GearyImapDBAttachment* self,
                                         GearyDbConnection* cx,
                                         GCancellable* cancellable,
                                         GError** error);
static void geary_imap_db_attachment_save_file (GearyImapDBAttachment* self,
                                         GearyRFC822Part* part,
                                         GFile* attachments_dir,
                                         GCancellable* cancellable,
                                         GError** error);
static void geary_imap_db_attachment_update_db (GearyImapDBAttachment* self,
                                         GearyDbConnection* cx,
                                         GCancellable* cancellable,
                                         GError** error);
VALA_EXTERN void geary_imap_db_attachment_delete (GearyImapDBAttachment* self,
                                      GearyDbConnection* cx,
                                      GCancellable* cancellable);
VALA_EXTERN void geary_rf_c822_part_write_to_stream (GearyRFC822Part* self,
                                         GMimeStream* destination,
                                         GearyRFC822PartEncodingConversion conversion,
                                         GearyRFC822PartBodyFormatting format,
                                         GError** error);
VALA_EXTERN GeeList* geary_imap_db_attachment_save_attachments (GearyDbConnection* cx,
                                                    GFile* attachments_path,
                                                    gint64 message_id,
                                                    GeeList* attachments,
                                                    GCancellable* cancellable,
                                                    GError** error);
VALA_EXTERN void geary_imap_db_attachment_delete_attachments (GearyDbConnection* cx,
                                                  GFile* attachments_path,
                                                  gint64 message_id,
                                                  GCancellable* cancellable,
                                                  GError** error);
VALA_EXTERN GeeList* geary_imap_db_attachment_list_attachments (GearyDbConnection* cx,
                                                    GFile* attachments_path,
                                                    gint64 message_id,
                                                    GCancellable* cancellable,
                                                    GError** error);
VALA_EXTERN void geary_imap_db_attachment_add_attachments (GearyDbConnection* cx,
                                               GFile* attachments_path,
                                               GearyEmail* email,
                                               gint64 message_id,
                                               GCancellable* cancellable,
                                               GError** error);
static void geary_imap_db_attachment_finalize (GObject * obj);
static GType geary_imap_db_attachment_get_type_once (void);
static void _vala_geary_imap_db_attachment_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_geary_imap_db_attachment_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
geary_imap_db_attachment_get_instance_private (GearyImapDBAttachment* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapDBAttachment_private_offset);
}

gint64
geary_imap_db_attachment_get_message_id (GearyImapDBAttachment* self)
{
	gint64 result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_ATTACHMENT (self), 0LL);
	result = self->priv->_message_id;
	return result;
}

static void
geary_imap_db_attachment_set_message_id (GearyImapDBAttachment* self,
                                         gint64 value)
{
	gint64 old_value;
	g_return_if_fail (GEARY_IMAP_DB_IS_ATTACHMENT (self));
	old_value = geary_imap_db_attachment_get_message_id (self);
	if (old_value != value) {
		self->priv->_message_id = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_db_attachment_properties[GEARY_IMAP_DB_ATTACHMENT_MESSAGE_ID_PROPERTY]);
	}
}

static GearyImapDBAttachment*
geary_imap_db_attachment_construct (GType object_type,
                                    gint64 message_id,
                                    GearyMimeContentType* content_type,
                                    const gchar* content_id,
                                    const gchar* content_description,
                                    GearyMimeContentDisposition* content_disposition,
                                    const gchar* content_filename)
{
	GearyImapDBAttachment * self = NULL;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (content_type), NULL);
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_DISPOSITION (content_disposition), NULL);
	self = (GearyImapDBAttachment*) geary_attachment_construct (object_type, content_type, content_id, content_description, content_disposition, content_filename);
	geary_imap_db_attachment_set_message_id (self, message_id);
	return self;
}

static GearyImapDBAttachment*
geary_imap_db_attachment_new (gint64 message_id,
                              GearyMimeContentType* content_type,
                              const gchar* content_id,
                              const gchar* content_description,
                              GearyMimeContentDisposition* content_disposition,
                              const gchar* content_filename)
{
	return geary_imap_db_attachment_construct (GEARY_IMAP_DB_TYPE_ATTACHMENT, message_id, content_type, content_id, content_description, content_disposition, content_filename);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapDBAttachment*
geary_imap_db_attachment_construct_from_part (GType object_type,
                                              gint64 message_id,
                                              GearyRFC822Part* part,
                                              GError** error)
{
	GearyImapDBAttachment * self = NULL;
	GearyMimeContentDisposition* disposition = NULL;
	GearyMimeContentDisposition* _tmp0_;
	GearyMimeContentDisposition* _tmp1_;
	GearyMimeContentDisposition* _tmp2_;
	GearyMimeContentDisposition* _tmp3_;
	GearyMimeContentType* _tmp5_;
	GearyMimeContentType* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GearyMimeContentDisposition* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (GEARY_RF_C822_IS_PART (part), NULL);
	_tmp0_ = geary_rf_c822_part_get_content_disposition (part);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	disposition = _tmp2_;
	_tmp3_ = disposition;
	if (_tmp3_ == NULL) {
		GearyMimeContentDisposition* _tmp4_;
		_tmp4_ = geary_mime_content_disposition_new_simple (GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED);
		_g_object_unref0 (disposition);
		disposition = _tmp4_;
	}
	_tmp5_ = geary_rf_c822_part_get_content_type (part);
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_rf_c822_part_get_content_id (part);
	_tmp8_ = _tmp7_;
	_tmp9_ = geary_rf_c822_part_get_content_description (part);
	_tmp10_ = _tmp9_;
	_tmp11_ = disposition;
	_tmp12_ = geary_rf_c822_part_get_clean_filename (part);
	_tmp13_ = _tmp12_;
	self = (GearyImapDBAttachment*) geary_imap_db_attachment_construct (object_type, message_id, _tmp6_, _tmp8_, _tmp10_, _tmp11_, _tmp13_);
	_g_free0 (_tmp13_);
	_g_object_unref0 (disposition);
	return self;
}

GearyImapDBAttachment*
geary_imap_db_attachment_new_from_part (gint64 message_id,
                                        GearyRFC822Part* part,
                                        GError** error)
{
	return geary_imap_db_attachment_construct_from_part (GEARY_IMAP_DB_TYPE_ATTACHMENT, message_id, part, error);
}

GearyImapDBAttachment*
geary_imap_db_attachment_construct_from_row (GType object_type,
                                             GearyDbResult* _result_,
                                             GFile* attachments_dir,
                                             GError** error)
{
	GearyImapDBAttachment * self = NULL;
	gchar* content_filename = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	GearyMimeContentDisposition* disposition = NULL;
	GearyMimeContentDisposition* _tmp4_;
	gint64 _tmp5_ = 0LL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	GearyMimeContentType* _tmp8_ = NULL;
	GearyMimeContentType* _tmp9_;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	GearyMimeContentDisposition* _tmp14_;
	const gchar* _tmp15_;
	gint64 _tmp16_ = 0LL;
	gint64 _tmp17_ = 0LL;
	GFile* _tmp18_;
	GFile* _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (_result_), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments_dir, g_file_get_type ()), NULL);
	_tmp0_ = geary_db_result_string_for (_result_, "filename", &_inner_error0_);
	_tmp1_ = g_strdup (_tmp0_);
	content_filename = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = content_filename;
	if (g_strcmp0 (_tmp2_, GEARY_IMAP_DB_ATTACHMENT_NULL_FILE_NAME) == 0) {
		_g_free0 (content_filename);
		content_filename = NULL;
	}
	_tmp3_ = geary_db_result_int_for (_result_, "disposition", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (content_filename);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp4_ = geary_mime_content_disposition_new_simple (geary_mime_disposition_type_from_int (_tmp3_));
	disposition = _tmp4_;
	_tmp5_ = geary_db_result_rowid_for (_result_, "message_id", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (disposition);
		_g_free0 (content_filename);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp7_ = geary_db_result_nonnull_string_for (_result_, "mime_type", &_inner_error0_);
	_tmp6_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (disposition);
		_g_free0 (content_filename);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp9_ = geary_mime_content_type_parse (_tmp6_, &_inner_error0_);
	_tmp8_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (disposition);
		_g_free0 (content_filename);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp11_ = geary_db_result_string_for (_result_, "content_id", &_inner_error0_);
	_tmp10_ = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (disposition);
		_g_free0 (content_filename);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp13_ = geary_db_result_string_for (_result_, "description", &_inner_error0_);
	_tmp12_ = _tmp13_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (disposition);
		_g_free0 (content_filename);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp14_ = disposition;
	_tmp15_ = content_filename;
	self = (GearyImapDBAttachment*) geary_imap_db_attachment_construct (object_type, _tmp5_, _tmp8_, _tmp10_, _tmp12_, _tmp14_, _tmp15_);
	_tmp16_ = geary_db_result_rowid_for (_result_, "id", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (disposition);
		_g_free0 (content_filename);
		_g_object_unref0 (self);
		return NULL;
	}
	self->priv->attachment_id = _tmp16_;
	_tmp17_ = geary_db_result_int64_for (_result_, "filesize", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (disposition);
		_g_free0 (content_filename);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp18_ = geary_imap_db_attachment_generate_file (self, attachments_dir);
	_tmp19_ = _tmp18_;
	geary_attachment_set_file_info (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment), _tmp19_, _tmp17_);
	_g_object_unref0 (_tmp19_);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (disposition);
	_g_free0 (content_filename);
	return self;
}

GearyImapDBAttachment*
geary_imap_db_attachment_new_from_row (GearyDbResult* _result_,
                                       GFile* attachments_dir,
                                       GError** error)
{
	return geary_imap_db_attachment_construct_from_row (GEARY_IMAP_DB_TYPE_ATTACHMENT, _result_, attachments_dir, error);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

void
geary_imap_db_attachment_save (GearyImapDBAttachment* self,
                               GearyDbConnection* cx,
                               GearyRFC822Part* part,
                               GFile* attachments_dir,
                               GCancellable* cancellable,
                               GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_DB_IS_ATTACHMENT (self));
	g_return_if_fail (GEARY_DB_IS_CONNECTION (cx));
	g_return_if_fail (GEARY_RF_C822_IS_PART (part));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments_dir, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	geary_imap_db_attachment_insert_db (self, cx, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	{
		geary_imap_db_attachment_save_file (self, part, attachments_dir, cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		geary_imap_db_attachment_update_db (self, cx, cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp0_;
		GError* _tmp1_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		geary_imap_db_attachment_delete (self, cx, NULL);
		_tmp0_ = err;
		_tmp1_ = _g_error_copy0 (_tmp0_);
		_inner_error0_ = _tmp1_;
		_g_error_free0 (err);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
geary_imap_db_attachment_delete (GearyImapDBAttachment* self,
                                 GearyDbConnection* cx,
                                 GCancellable* cancellable)
{
	GFile* _tmp13_;
	GFile* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_DB_IS_ATTACHMENT (self));
	g_return_if_fail (GEARY_DB_IS_CONNECTION (cx));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	if (self->priv->attachment_id >= ((gint64) 0)) {
		{
			GearyDbStatement* remove_stmt = NULL;
			GearyDbStatement* _tmp0_;
			GearyDbStatement* _tmp1_;
			GearyDbStatement* _tmp2_;
			GearyDbStatement* _tmp3_;
			GearyDbStatement* _tmp4_;
			GearyDbResult* _tmp5_;
			GearyDbResult* _tmp6_;
			_tmp0_ = geary_db_connection_prepare (cx, "DELETE FROM MessageAttachmentTable WHERE id=?", &_inner_error0_);
			remove_stmt = _tmp0_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp1_ = remove_stmt;
			_tmp2_ = geary_db_statement_bind_rowid (_tmp1_, 0, self->priv->attachment_id, &_inner_error0_);
			_tmp3_ = _tmp2_;
			_g_object_unref0 (_tmp3_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (remove_stmt);
				goto __catch0_g_error;
			}
			_tmp4_ = remove_stmt;
			_tmp5_ = geary_db_statement_exec (_tmp4_, NULL, &_inner_error0_);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp6_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (remove_stmt);
				goto __catch0_g_error;
			}
			_g_object_unref0 (remove_stmt);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GFile* _tmp7_;
			GFile* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = geary_attachment_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
			_tmp8_ = _tmp7_;
			_tmp9_ = g_file_get_path (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = err;
			_tmp12_ = _tmp11_->message;
			g_debug ("imap-db-attachment.vala:116: Error attempting to remove added attachme" \
"nt row for %s: %s", _tmp10_, _tmp12_);
			_g_free0 (_tmp10_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp13_ = geary_attachment_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		{
			GFile* _tmp15_;
			GFile* _tmp16_;
			_tmp15_ = geary_attachment_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
			_tmp16_ = _tmp15_;
			g_file_delete (_tmp16_, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GFile* _tmp17_;
			GFile* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			GError* _tmp21_;
			const gchar* _tmp22_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp17_ = geary_attachment_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
			_tmp18_ = _tmp17_;
			_tmp19_ = g_file_get_path (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = err;
			_tmp22_ = _tmp21_->message;
			g_debug ("imap-db-attachment.vala:125: Error attempting to remove attachment fil" \
"e %s: %s", _tmp20_, _tmp22_);
			_g_free0 (_tmp20_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
geary_imap_db_attachment_insert_db (GearyImapDBAttachment* self,
                                    GearyDbConnection* cx,
                                    GCancellable* cancellable,
                                    GError** error)
{
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	gint64 _tmp2_;
	GearyDbStatement* _tmp3_;
	GearyDbStatement* _tmp4_;
	GearyDbStatement* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GearyDbStatement* _tmp8_;
	GearyDbStatement* _tmp9_;
	GearyDbStatement* _tmp10_;
	GearyMimeContentType* _tmp11_;
	GearyMimeContentType* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GearyDbStatement* _tmp15_;
	GearyDbStatement* _tmp16_;
	GearyDbStatement* _tmp17_;
	GearyDbStatement* _tmp18_;
	GearyDbStatement* _tmp19_;
	GearyDbStatement* _tmp20_;
	GearyMimeContentDisposition* _tmp21_;
	GearyMimeContentDisposition* _tmp22_;
	GearyMimeDispositionType _tmp23_;
	GearyMimeDispositionType _tmp24_;
	GearyDbStatement* _tmp25_;
	GearyDbStatement* _tmp26_;
	GearyDbStatement* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	GearyDbStatement* _tmp30_;
	GearyDbStatement* _tmp31_;
	GearyDbStatement* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GearyDbStatement* _tmp35_;
	GearyDbStatement* _tmp36_;
	gint64 _tmp37_ = 0LL;
	GearyDbStatement* _tmp38_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_DB_IS_ATTACHMENT (self));
	g_return_if_fail (GEARY_DB_IS_CONNECTION (cx));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"                INSERT INTO MessageAttachmentTable (message_id, filena" \
"me, mime_type, filesize, disposition, content_id, description)\n" \
"                VALUES (?, ?, ?, ?, ?, ?, ?)\n" \
"                ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = stmt;
	_tmp2_ = self->priv->_message_id;
	_tmp3_ = geary_db_statement_bind_rowid (_tmp1_, 0, _tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp5_ = stmt;
	_tmp6_ = geary_attachment_get_content_filename (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
	_tmp7_ = _tmp6_;
	_tmp8_ = geary_db_statement_bind_string (_tmp5_, 1, _tmp7_, &_inner_error0_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp9_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp10_ = stmt;
	_tmp11_ = geary_attachment_get_content_type (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
	_tmp12_ = _tmp11_;
	_tmp13_ = geary_mime_content_type_to_string (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = geary_db_statement_bind_string (_tmp10_, 2, _tmp14_, &_inner_error0_);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp16_);
	_g_free0 (_tmp14_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp17_ = stmt;
	_tmp18_ = geary_db_statement_bind_int64 (_tmp17_, 3, (gint64) 0, &_inner_error0_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp19_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp20_ = stmt;
	_tmp21_ = geary_attachment_get_content_disposition (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
	_tmp22_ = _tmp21_;
	_tmp23_ = geary_mime_content_disposition_get_disposition_type (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = geary_db_statement_bind_int (_tmp20_, 4, (gint) _tmp24_, &_inner_error0_);
	_tmp26_ = _tmp25_;
	_g_object_unref0 (_tmp26_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp27_ = stmt;
	_tmp28_ = geary_attachment_get_content_id (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
	_tmp29_ = _tmp28_;
	_tmp30_ = geary_db_statement_bind_string (_tmp27_, 5, _tmp29_, &_inner_error0_);
	_tmp31_ = _tmp30_;
	_g_object_unref0 (_tmp31_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp32_ = stmt;
	_tmp33_ = geary_attachment_get_content_description (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
	_tmp34_ = _tmp33_;
	_tmp35_ = geary_db_statement_bind_string (_tmp32_, 6, _tmp34_, &_inner_error0_);
	_tmp36_ = _tmp35_;
	_g_object_unref0 (_tmp36_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp38_ = stmt;
	_tmp37_ = geary_db_statement_exec_insert (_tmp38_, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	self->priv->attachment_id = _tmp37_;
	_g_object_unref0 (stmt);
}

static void
geary_imap_db_attachment_save_file (GearyImapDBAttachment* self,
                                    GearyRFC822Part* part,
                                    GFile* attachments_dir,
                                    GCancellable* cancellable,
                                    GError** error)
{
	GFile* target = NULL;
	GFile* _tmp1_;
	GOutputStream* target_stream = NULL;
	GFile* _tmp6_;
	GFileOutputStream* _tmp7_;
	GMimeStream* stream = NULL;
	GOutputStream* _tmp8_;
	GearyStreamMimeOutputStream* _tmp9_;
	GMimeStream* _tmp10_;
	GMimeStreamBuffer* _tmp11_;
	GMimeStream* _tmp12_;
	gint64 file_size = 0LL;
	GMimeStream* _tmp13_;
	GMimeStream* _tmp14_;
	GFile* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_DB_IS_ATTACHMENT (self));
	g_return_if_fail (GEARY_RF_C822_IS_PART (part));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments_dir, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	if (self->priv->attachment_id < ((gint64) 0)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "No attachment id assigned");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = geary_imap_db_attachment_generate_file (self, attachments_dir);
	target = _tmp1_;
	{
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp2_ = target;
		_tmp3_ = g_file_get_parent (_tmp2_);
		_tmp4_ = _tmp3_;
		g_file_make_directory_with_parents (_tmp4_, cancellable, &_inner_error0_);
		_g_object_unref0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch0_g_io_error_exists;
			}
			goto __finally0;
		}
	}
	goto __finally0;
	__catch0_g_io_error_exists:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (target);
		return;
	}
	{
		GFile* _tmp5_;
		_tmp5_ = target;
		g_file_delete (_tmp5_, cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			goto __finally1;
		}
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (target);
		return;
	}
	_tmp6_ = target;
	_tmp7_ = g_file_create (_tmp6_, G_FILE_CREATE_NONE, cancellable, &_inner_error0_);
	target_stream = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_output_stream_get_type (), GOutputStream);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (target);
		return;
	}
	_tmp8_ = target_stream;
	_tmp9_ = geary_stream_mime_output_stream_new (_tmp8_);
	stream = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_mime_stream_get_type (), GMimeStream);
	_tmp10_ = stream;
	_tmp11_ = (GMimeStreamBuffer*) g_mime_stream_buffer_new (_tmp10_, GMIME_STREAM_BUFFER_BLOCK_WRITE);
	_g_object_unref0 (stream);
	stream = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_mime_stream_get_type (), GMimeStream);
	_tmp12_ = stream;
	geary_rf_c822_part_write_to_stream (part, _tmp12_, GEARY_RF_C822_PART_ENCODING_CONVERSION_NONE, GEARY_RF_C822_PART_BODY_FORMATTING_NONE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		_g_object_unref0 (target_stream);
		_g_object_unref0 (target);
		return;
	}
	_tmp13_ = stream;
	file_size = g_mime_stream_length (_tmp13_);
	_tmp14_ = stream;
	g_mime_stream_close (_tmp14_);
	_tmp15_ = target;
	geary_attachment_set_file_info (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment), _tmp15_, file_size);
	_g_object_unref0 (stream);
	_g_object_unref0 (target_stream);
	_g_object_unref0 (target);
}

static void
geary_imap_db_attachment_update_db (GearyImapDBAttachment* self,
                                    GearyDbConnection* cx,
                                    GCancellable* cancellable,
                                    GError** error)
{
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	GearyDbStatement* _tmp4_;
	GearyDbStatement* _tmp5_;
	GearyDbStatement* _tmp6_;
	GearyDbStatement* _tmp7_;
	GearyDbStatement* _tmp8_;
	GearyDbStatement* _tmp9_;
	GearyDbResult* _tmp10_;
	GearyDbResult* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_DB_IS_ATTACHMENT (self));
	g_return_if_fail (GEARY_DB_IS_CONNECTION (cx));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"            UPDATE MessageAttachmentTable\n" \
"            SET filesize = ?\n" \
"            WHERE id = ?\n" \
"        ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = stmt;
	_tmp2_ = geary_attachment_get_filesize (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_db_statement_bind_int64 (_tmp1_, 0, _tmp3_, &_inner_error0_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp6_ = stmt;
	_tmp7_ = geary_db_statement_bind_rowid (_tmp6_, 1, self->priv->attachment_id, &_inner_error0_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_tmp9_ = stmt;
	_tmp10_ = geary_db_statement_exec (_tmp9_, cancellable, &_inner_error0_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp11_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return;
	}
	_g_object_unref0 (stmt);
}

static GFile*
geary_imap_db_attachment_generate_file (GearyImapDBAttachment* self,
                                        GFile* attachments_dir)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_ATTACHMENT (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments_dir, g_file_get_type ()), NULL);
	_tmp1_ = geary_attachment_get_content_filename (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_ATTACHMENT, GearyAttachment));
	_tmp2_ = _tmp1_;
	_tmp0_ = _tmp2_;
	if (_tmp0_ == NULL) {
		_tmp0_ = GEARY_IMAP_DB_ATTACHMENT_NULL_FILE_NAME;
	}
	_tmp3_ = self->priv->_message_id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_child (attachments_dir, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, self->priv->attachment_id);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_child (_tmp7_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_get_child (_tmp11_, _tmp0_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	_g_free0 (_tmp5_);
	result = _tmp13_;
	return result;
}

GeeList*
geary_imap_db_attachment_save_attachments (GearyDbConnection* cx,
                                           GFile* attachments_path,
                                           gint64 message_id,
                                           GeeList* attachments,
                                           GCancellable* cancellable,
                                           GError** error)
{
	GeeList* list = NULL;
	GeeLinkedList* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments_path, g_file_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments, GEE_TYPE_LIST), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = gee_linked_list_new (GEARY_IMAP_DB_TYPE_ATTACHMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	{
		GeeList* _part_list = NULL;
		gint _part_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _part_index = 0;
		_part_list = attachments;
		_tmp1_ = _part_list;
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		_part_size = _tmp3_;
		_part_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GearyRFC822Part* part = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			GearyImapDBAttachment* attachment = NULL;
			GearyRFC822Part* _tmp8_;
			GearyImapDBAttachment* _tmp9_;
			GearyImapDBAttachment* _tmp10_;
			GearyRFC822Part* _tmp11_;
			GeeList* _tmp12_;
			GearyImapDBAttachment* _tmp13_;
			_part_index = _part_index + 1;
			_tmp4_ = _part_index;
			_tmp5_ = _part_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _part_list;
			_tmp7_ = gee_list_get (_tmp6_, _part_index);
			part = (GearyRFC822Part*) _tmp7_;
			_tmp8_ = part;
			_tmp9_ = geary_imap_db_attachment_new_from_part (message_id, _tmp8_, &_inner_error0_);
			attachment = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (part);
				_g_object_unref0 (list);
				return NULL;
			}
			_tmp10_ = attachment;
			_tmp11_ = part;
			geary_imap_db_attachment_save (_tmp10_, cx, _tmp11_, attachments_path, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (attachment);
				_g_object_unref0 (part);
				_g_object_unref0 (list);
				return NULL;
			}
			_tmp12_ = list;
			_tmp13_ = attachment;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection), _tmp13_);
			_g_object_unref0 (attachment);
			_g_object_unref0 (part);
		}
	}
	result = list;
	return result;
}

void
geary_imap_db_attachment_delete_attachments (GearyDbConnection* cx,
                                             GFile* attachments_path,
                                             gint64 message_id,
                                             GCancellable* cancellable,
                                             GError** error)
{
	GeeList* attachments = NULL;
	GeeList* _tmp0_;
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp10_;
	GearyDbStatement* _tmp11_;
	GearyDbStatement* _tmp12_;
	GearyDbStatement* _tmp13_;
	GearyDbStatement* _tmp14_;
	GearyDbResult* _tmp15_;
	GearyDbResult* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_DB_IS_CONNECTION (cx));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments_path, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = geary_imap_db_attachment_list_attachments (cx, attachments_path, message_id, cancellable, &_inner_error0_);
	attachments = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	{
		GeeList* _attachment_list = NULL;
		GeeList* _tmp1_;
		gint _attachment_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _attachment_index = 0;
		_tmp1_ = attachments;
		_attachment_list = _tmp1_;
		_tmp2_ = _attachment_list;
		_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp4_ = _tmp3_;
		_attachment_size = _tmp4_;
		_attachment_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GearyImapDBAttachment* attachment = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			GearyImapDBAttachment* _tmp9_;
			_attachment_index = _attachment_index + 1;
			_tmp5_ = _attachment_index;
			_tmp6_ = _attachment_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _attachment_list;
			_tmp8_ = gee_list_get (_tmp7_, _attachment_index);
			attachment = (GearyImapDBAttachment*) _tmp8_;
			_tmp9_ = attachment;
			geary_imap_db_attachment_delete (_tmp9_, cx, cancellable);
			_g_object_unref0 (attachment);
		}
	}
	_tmp10_ = geary_db_connection_prepare (cx, "\n" \
"            DELETE FROM MessageAttachmentTable WHERE message_id = ?\n" \
"        ", &_inner_error0_);
	stmt = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (attachments);
		return;
	}
	_tmp11_ = stmt;
	_tmp12_ = geary_db_statement_bind_rowid (_tmp11_, 0, message_id, &_inner_error0_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp13_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		_g_object_unref0 (attachments);
		return;
	}
	_tmp14_ = stmt;
	_tmp15_ = geary_db_statement_exec (_tmp14_, NULL, &_inner_error0_);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp16_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		_g_object_unref0 (attachments);
		return;
	}
	_g_object_unref0 (stmt);
	_g_object_unref0 (attachments);
}

void
geary_imap_db_attachment_add_attachments (GearyDbConnection* cx,
                                          GFile* attachments_path,
                                          GearyEmail* email,
                                          gint64 message_id,
                                          GCancellable* cancellable,
                                          GError** error)
{
	GearyEmailField _tmp0_;
	GearyEmailField _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_DB_IS_CONNECTION (cx));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments_path, g_file_get_type ()));
	g_return_if_fail (GEARY_IS_EMAIL (email));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = geary_email_get_fields (email);
	_tmp1_ = _tmp0_;
	if (geary_email_field_fulfills (_tmp1_, GEARY_IMAP_DB_ATTACHMENT_REQUIRED_FIELDS)) {
		GeeList* _tmp2_ = NULL;
		GeeList* _tmp3_;
		_tmp3_ = geary_imap_db_attachment_list_attachments (cx, attachments_path, message_id, cancellable, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		geary_email_add_attachments (email, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (_tmp2_);
	}
}

GeeList*
geary_imap_db_attachment_list_attachments (GearyDbConnection* cx,
                                           GFile* attachments_path,
                                           gint64 message_id,
                                           GCancellable* cancellable,
                                           GError** error)
{
	GearyDbStatement* stmt = NULL;
	GearyDbStatement* _tmp0_;
	GearyDbStatement* _tmp1_;
	GearyDbStatement* _tmp2_;
	GearyDbStatement* _tmp3_;
	GearyDbResult* results = NULL;
	GearyDbStatement* _tmp4_;
	GearyDbResult* _tmp5_;
	GeeList* list = NULL;
	GeeLinkedList* _tmp6_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (GEARY_DB_IS_CONNECTION (cx), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments_path, g_file_get_type ()), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = geary_db_connection_prepare (cx, "\n" \
"            SELECT *\n" \
"            FROM MessageAttachmentTable\n" \
"            WHERE message_id = ?\n" \
"            ORDER BY id\n" \
"            ", &_inner_error0_);
	stmt = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = stmt;
	_tmp2_ = geary_db_statement_bind_rowid (_tmp1_, 0, message_id, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return NULL;
	}
	_tmp4_ = stmt;
	_tmp5_ = geary_db_statement_exec (_tmp4_, cancellable, &_inner_error0_);
	results = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stmt);
		return NULL;
	}
	_tmp6_ = gee_linked_list_new (GEARY_IMAP_DB_TYPE_ATTACHMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_LIST, GeeList);
	while (TRUE) {
		GearyDbResult* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		GearyImapDBAttachment* _tmp10_ = NULL;
		GearyDbResult* _tmp11_;
		GearyImapDBAttachment* _tmp12_;
		GeeList* _tmp13_;
		GearyDbResult* _tmp14_;
		_tmp7_ = results;
		_tmp8_ = geary_db_result_get_finished (_tmp7_);
		_tmp9_ = _tmp8_;
		if (!(!_tmp9_)) {
			break;
		}
		_tmp11_ = results;
		_tmp12_ = geary_imap_db_attachment_new_from_row (_tmp11_, attachments_path, &_inner_error0_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (list);
			_g_object_unref0 (results);
			_g_object_unref0 (stmt);
			return NULL;
		}
		_tmp13_ = list;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_COLLECTION, GeeCollection), _tmp10_);
		_tmp14_ = results;
		geary_db_result_next (_tmp14_, cancellable, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp10_);
			_g_object_unref0 (list);
			_g_object_unref0 (results);
			_g_object_unref0 (stmt);
			return NULL;
		}
		_g_object_unref0 (_tmp10_);
	}
	result = list;
	_g_object_unref0 (results);
	_g_object_unref0 (stmt);
	return result;
}

static void
geary_imap_db_attachment_class_init (GearyImapDBAttachmentClass * klass,
                                     gpointer klass_data)
{
	geary_imap_db_attachment_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapDBAttachment_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_db_attachment_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_db_attachment_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_db_attachment_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_DB_ATTACHMENT_MESSAGE_ID_PROPERTY, geary_imap_db_attachment_properties[GEARY_IMAP_DB_ATTACHMENT_MESSAGE_ID_PROPERTY] = g_param_spec_int64 ("message-id", "message-id", "message-id", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_db_attachment_instance_init (GearyImapDBAttachment * self,
                                        gpointer klass)
{
	self->priv = geary_imap_db_attachment_get_instance_private (self);
	self->priv->attachment_id = (gint64) -1;
}

static void
geary_imap_db_attachment_finalize (GObject * obj)
{
	GearyImapDBAttachment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachment);
	G_OBJECT_CLASS (geary_imap_db_attachment_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_imap_db_attachment_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapDBAttachmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_db_attachment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapDBAttachment), 0, (GInstanceInitFunc) geary_imap_db_attachment_instance_init, NULL };
	GType geary_imap_db_attachment_type_id;
	geary_imap_db_attachment_type_id = g_type_register_static (GEARY_TYPE_ATTACHMENT, "GearyImapDBAttachment", &g_define_type_info, 0);
	GearyImapDBAttachment_private_offset = g_type_add_instance_private (geary_imap_db_attachment_type_id, sizeof (GearyImapDBAttachmentPrivate));
	return geary_imap_db_attachment_type_id;
}

GType
geary_imap_db_attachment_get_type (void)
{
	static gsize geary_imap_db_attachment_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_db_attachment_type_id__once)) {
		GType geary_imap_db_attachment_type_id;
		geary_imap_db_attachment_type_id = geary_imap_db_attachment_get_type_once ();
		g_once_init_leave (&geary_imap_db_attachment_type_id__once, geary_imap_db_attachment_type_id);
	}
	return geary_imap_db_attachment_type_id__once;
}

static void
_vala_geary_imap_db_attachment_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GearyImapDBAttachment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachment);
	switch (property_id) {
		case GEARY_IMAP_DB_ATTACHMENT_MESSAGE_ID_PROPERTY:
		g_value_set_int64 (value, geary_imap_db_attachment_get_message_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_db_attachment_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GearyImapDBAttachment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_DB_TYPE_ATTACHMENT, GearyImapDBAttachment);
	switch (property_id) {
		case GEARY_IMAP_DB_ATTACHMENT_MESSAGE_ID_PROPERTY:
		geary_imap_db_attachment_set_message_id (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

