/* imap-create-command.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-create-command.vala, do not modify */

/*
 * Copyright 2017 Michael Gratton <mike@vee.net>
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_CREATE_COMMAND_0_PROPERTY,
	GEARY_IMAP_CREATE_COMMAND_MAILBOX_PROPERTY,
	GEARY_IMAP_CREATE_COMMAND_USE_PROPERTY,
	GEARY_IMAP_CREATE_COMMAND_NUM_PROPERTIES
};
static GParamSpec* geary_imap_create_command_properties[GEARY_IMAP_CREATE_COMMAND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapCreateCommandPrivate {
	GearyImapMailboxSpecifier* _mailbox;
	GearyFolderSpecialUse _use;
};

static gint GearyImapCreateCommand_private_offset;
static gpointer geary_imap_create_command_parent_class = NULL;

static void geary_imap_create_command_set_mailbox (GearyImapCreateCommand* self,
                                            GearyImapMailboxSpecifier* value);
static void geary_imap_create_command_set_use (GearyImapCreateCommand* self,
                                        GearyFolderSpecialUse value);
static GearyImapMailboxAttribute* geary_imap_create_command_get_special_folder_type (GearyFolderSpecialUse use);
static void geary_imap_create_command_finalize (GObject * obj);
static GType geary_imap_create_command_get_type_once (void);
static void _vala_geary_imap_create_command_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_geary_imap_create_command_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
geary_imap_create_command_get_instance_private (GearyImapCreateCommand* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapCreateCommand_private_offset);
}

GearyImapMailboxSpecifier*
geary_imap_create_command_get_mailbox (GearyImapCreateCommand* self)
{
	GearyImapMailboxSpecifier* result;
	GearyImapMailboxSpecifier* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_CREATE_COMMAND (self), NULL);
	_tmp0_ = self->priv->_mailbox;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_create_command_set_mailbox (GearyImapCreateCommand* self,
                                       GearyImapMailboxSpecifier* value)
{
	GearyImapMailboxSpecifier* old_value;
	g_return_if_fail (GEARY_IMAP_IS_CREATE_COMMAND (self));
	old_value = geary_imap_create_command_get_mailbox (self);
	if (old_value != value) {
		GearyImapMailboxSpecifier* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_mailbox);
		self->priv->_mailbox = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_create_command_properties[GEARY_IMAP_CREATE_COMMAND_MAILBOX_PROPERTY]);
	}
}

GearyFolderSpecialUse
geary_imap_create_command_get_use (GearyImapCreateCommand* self)
{
	GearyFolderSpecialUse result;
	g_return_val_if_fail (GEARY_IMAP_IS_CREATE_COMMAND (self), 0);
	result = self->priv->_use;
	return result;
}

static void
geary_imap_create_command_set_use (GearyImapCreateCommand* self,
                                   GearyFolderSpecialUse value)
{
	GearyFolderSpecialUse old_value;
	g_return_if_fail (GEARY_IMAP_IS_CREATE_COMMAND (self));
	old_value = geary_imap_create_command_get_use (self);
	if (old_value != value) {
		self->priv->_use = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_create_command_properties[GEARY_IMAP_CREATE_COMMAND_USE_PROPERTY]);
	}
}

static GearyImapMailboxAttribute*
geary_imap_create_command_get_special_folder_type (GearyFolderSpecialUse use)
{
	GearyImapMailboxAttribute* result;
	switch (use) {
		case GEARY_FOLDER_SPECIAL_USE_ALL_MAIL:
		{
			GearyImapMailboxAttribute* _tmp0_;
			GearyImapMailboxAttribute* _tmp1_;
			GearyImapMailboxAttribute* _tmp2_;
			_tmp0_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_ALL ();
			_tmp1_ = _tmp0_;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case GEARY_FOLDER_SPECIAL_USE_ARCHIVE:
		{
			GearyImapMailboxAttribute* _tmp3_;
			GearyImapMailboxAttribute* _tmp4_;
			GearyImapMailboxAttribute* _tmp5_;
			_tmp3_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_ARCHIVE ();
			_tmp4_ = _tmp3_;
			_tmp5_ = _g_object_ref0 (_tmp4_);
			result = _tmp5_;
			return result;
		}
		case GEARY_FOLDER_SPECIAL_USE_DRAFTS:
		{
			GearyImapMailboxAttribute* _tmp6_;
			GearyImapMailboxAttribute* _tmp7_;
			GearyImapMailboxAttribute* _tmp8_;
			_tmp6_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_DRAFTS ();
			_tmp7_ = _tmp6_;
			_tmp8_ = _g_object_ref0 (_tmp7_);
			result = _tmp8_;
			return result;
		}
		case GEARY_FOLDER_SPECIAL_USE_FLAGGED:
		{
			GearyImapMailboxAttribute* _tmp9_;
			GearyImapMailboxAttribute* _tmp10_;
			GearyImapMailboxAttribute* _tmp11_;
			_tmp9_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_FLAGGED ();
			_tmp10_ = _tmp9_;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			result = _tmp11_;
			return result;
		}
		case GEARY_FOLDER_SPECIAL_USE_JUNK:
		{
			GearyImapMailboxAttribute* _tmp12_;
			GearyImapMailboxAttribute* _tmp13_;
			GearyImapMailboxAttribute* _tmp14_;
			_tmp12_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_JUNK ();
			_tmp13_ = _tmp12_;
			_tmp14_ = _g_object_ref0 (_tmp13_);
			result = _tmp14_;
			return result;
		}
		case GEARY_FOLDER_SPECIAL_USE_SENT:
		{
			GearyImapMailboxAttribute* _tmp15_;
			GearyImapMailboxAttribute* _tmp16_;
			GearyImapMailboxAttribute* _tmp17_;
			_tmp15_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_SENT ();
			_tmp16_ = _tmp15_;
			_tmp17_ = _g_object_ref0 (_tmp16_);
			result = _tmp17_;
			return result;
		}
		case GEARY_FOLDER_SPECIAL_USE_TRASH:
		{
			GearyImapMailboxAttribute* _tmp18_;
			GearyImapMailboxAttribute* _tmp19_;
			GearyImapMailboxAttribute* _tmp20_;
			_tmp18_ = geary_imap_mailbox_attribute_get_SPECIAL_FOLDER_TRASH ();
			_tmp19_ = _tmp18_;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			result = _tmp20_;
			return result;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
}

GearyImapCreateCommand*
geary_imap_create_command_construct (GType object_type,
                                     GearyImapMailboxSpecifier* mailbox,
                                     GCancellable* should_send)
{
	GearyImapCreateCommand * self = NULL;
	GearyImapListParameter* _tmp0_;
	GearyImapListParameter* _tmp1_;
	GearyImapParameter* _tmp2_;
	GearyImapParameter* _tmp3_;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (mailbox), NULL);
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	self = (GearyImapCreateCommand*) geary_imap_command_construct (object_type, GEARY_IMAP_CREATE_COMMAND_NAME_ATOM, NULL, (gint) 0, should_send);
	geary_imap_create_command_set_mailbox (self, mailbox);
	_tmp0_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_mailbox_specifier_to_parameter (mailbox);
	_tmp3_ = _tmp2_;
	geary_imap_list_parameter_add (_tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
	return self;
}

GearyImapCreateCommand*
geary_imap_create_command_new (GearyImapMailboxSpecifier* mailbox,
                               GCancellable* should_send)
{
	return geary_imap_create_command_construct (GEARY_IMAP_TYPE_CREATE_COMMAND, mailbox, should_send);
}

GearyImapCreateCommand*
geary_imap_create_command_construct_special_use (GType object_type,
                                                 GearyImapMailboxSpecifier* mailbox,
                                                 GearyFolderSpecialUse use,
                                                 GCancellable* should_send)
{
	GearyImapCreateCommand * self = NULL;
	GearyImapMailboxAttribute* attr = NULL;
	GearyImapMailboxAttribute* _tmp0_;
	GearyImapMailboxAttribute* _tmp1_;
	g_return_val_if_fail (GEARY_IMAP_IS_MAILBOX_SPECIFIER (mailbox), NULL);
	g_return_val_if_fail ((should_send == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (should_send, g_cancellable_get_type ()), NULL);
	self = (GearyImapCreateCommand*) geary_imap_create_command_construct (object_type, mailbox, should_send);
	geary_imap_create_command_set_use (self, use);
	_tmp0_ = geary_imap_create_command_get_special_folder_type (use);
	attr = _tmp0_;
	_tmp1_ = attr;
	if (_tmp1_ != NULL) {
		GearyImapListParameter* use_types = NULL;
		GearyImapListParameter* _tmp2_;
		GearyImapListParameter* _tmp3_;
		GearyImapMailboxAttribute* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GearyImapAtomParameter* _tmp7_;
		GearyImapAtomParameter* _tmp8_;
		GearyImapListParameter* use_param = NULL;
		GearyImapListParameter* _tmp9_;
		GearyImapListParameter* _tmp10_;
		GearyImapAtomParameter* _tmp11_;
		GearyImapAtomParameter* _tmp12_;
		GearyImapListParameter* _tmp13_;
		GearyImapListParameter* _tmp14_;
		GearyImapListParameter* _tmp15_;
		GearyImapListParameter* _tmp16_;
		GearyImapListParameter* _tmp17_;
		_tmp2_ = geary_imap_list_parameter_new ();
		use_types = _tmp2_;
		_tmp3_ = use_types;
		_tmp4_ = attr;
		_tmp5_ = geary_imap_flag_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_IMAP_TYPE_FLAG, GearyImapFlag));
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_imap_atom_parameter_new (_tmp6_);
		_tmp8_ = _tmp7_;
		geary_imap_list_parameter_add (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_g_object_unref0 (_tmp8_);
		_g_free0 (_tmp6_);
		_tmp9_ = geary_imap_list_parameter_new ();
		use_param = _tmp9_;
		_tmp10_ = use_param;
		_tmp11_ = geary_imap_atom_parameter_new (GEARY_IMAP_CREATE_COMMAND_USE_ATOM);
		_tmp12_ = _tmp11_;
		geary_imap_list_parameter_add (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_g_object_unref0 (_tmp12_);
		_tmp13_ = use_param;
		_tmp14_ = use_types;
		geary_imap_list_parameter_add (_tmp13_, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp15_ = geary_imap_command_get_args (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_COMMAND, GearyImapCommand));
		_tmp16_ = _tmp15_;
		_tmp17_ = use_param;
		geary_imap_list_parameter_add (_tmp16_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_g_object_unref0 (use_param);
		_g_object_unref0 (use_types);
	}
	_g_object_unref0 (attr);
	return self;
}

GearyImapCreateCommand*
geary_imap_create_command_new_special_use (GearyImapMailboxSpecifier* mailbox,
                                           GearyFolderSpecialUse use,
                                           GCancellable* should_send)
{
	return geary_imap_create_command_construct_special_use (GEARY_IMAP_TYPE_CREATE_COMMAND, mailbox, use, should_send);
}

static void
geary_imap_create_command_class_init (GearyImapCreateCommandClass * klass,
                                      gpointer klass_data)
{
	geary_imap_create_command_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapCreateCommand_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_create_command_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_create_command_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_create_command_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CREATE_COMMAND_MAILBOX_PROPERTY, geary_imap_create_command_properties[GEARY_IMAP_CREATE_COMMAND_MAILBOX_PROPERTY] = g_param_spec_object ("mailbox", "mailbox", "mailbox", GEARY_IMAP_TYPE_MAILBOX_SPECIFIER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_CREATE_COMMAND_USE_PROPERTY, geary_imap_create_command_properties[GEARY_IMAP_CREATE_COMMAND_USE_PROPERTY] = g_param_spec_enum ("use", "use", "use", GEARY_FOLDER_TYPE_SPECIAL_USE, GEARY_FOLDER_SPECIAL_USE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_create_command_instance_init (GearyImapCreateCommand * self,
                                         gpointer klass)
{
	self->priv = geary_imap_create_command_get_instance_private (self);
	self->priv->_use = GEARY_FOLDER_SPECIAL_USE_NONE;
}

static void
geary_imap_create_command_finalize (GObject * obj)
{
	GearyImapCreateCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_CREATE_COMMAND, GearyImapCreateCommand);
	_g_object_unref0 (self->priv->_mailbox);
	G_OBJECT_CLASS (geary_imap_create_command_parent_class)->finalize (obj);
}

/**
 * The IMAP CREATE command.
 *
 * This command also supports the RFC 6154 Special-Use CREATE
 * extension.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-6.3.3]] and
 * [[https://tools.ietf.org/html/rfc6154#section-3]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_create_command_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapCreateCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_create_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapCreateCommand), 0, (GInstanceInitFunc) geary_imap_create_command_instance_init, NULL };
	GType geary_imap_create_command_type_id;
	geary_imap_create_command_type_id = g_type_register_static (GEARY_IMAP_TYPE_COMMAND, "GearyImapCreateCommand", &g_define_type_info, 0);
	GearyImapCreateCommand_private_offset = g_type_add_instance_private (geary_imap_create_command_type_id, sizeof (GearyImapCreateCommandPrivate));
	return geary_imap_create_command_type_id;
}

GType
geary_imap_create_command_get_type (void)
{
	static gsize geary_imap_create_command_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_create_command_type_id__once)) {
		GType geary_imap_create_command_type_id;
		geary_imap_create_command_type_id = geary_imap_create_command_get_type_once ();
		g_once_init_leave (&geary_imap_create_command_type_id__once, geary_imap_create_command_type_id);
	}
	return geary_imap_create_command_type_id__once;
}

static void
_vala_geary_imap_create_command_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GearyImapCreateCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_CREATE_COMMAND, GearyImapCreateCommand);
	switch (property_id) {
		case GEARY_IMAP_CREATE_COMMAND_MAILBOX_PROPERTY:
		g_value_set_object (value, geary_imap_create_command_get_mailbox (self));
		break;
		case GEARY_IMAP_CREATE_COMMAND_USE_PROPERTY:
		g_value_set_enum (value, geary_imap_create_command_get_use (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_create_command_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GearyImapCreateCommand * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_CREATE_COMMAND, GearyImapCreateCommand);
	switch (property_id) {
		case GEARY_IMAP_CREATE_COMMAND_MAILBOX_PROPERTY:
		geary_imap_create_command_set_mailbox (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_CREATE_COMMAND_USE_PROPERTY:
		geary_imap_create_command_set_use (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

