/* imap-status-data-type.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-status-data-type.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))

/**
 * A representation of the types of data to be found in a STATUS response.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7.2.4]]
 *
 * @see StatusData
 */
GearyImapStatusDataType*
geary_imap_status_data_type_all (gint* result_length1)
{
	GearyImapStatusDataType* _tmp0_;
	GearyImapStatusDataType* _tmp1_;
	gint _tmp1__length1;
	GearyImapStatusDataType* result;
	_tmp0_ = g_new0 (GearyImapStatusDataType, 5);
	_tmp0_[0] = GEARY_IMAP_STATUS_DATA_TYPE_MESSAGES;
	_tmp0_[1] = GEARY_IMAP_STATUS_DATA_TYPE_RECENT;
	_tmp0_[2] = GEARY_IMAP_STATUS_DATA_TYPE_UIDNEXT;
	_tmp0_[3] = GEARY_IMAP_STATUS_DATA_TYPE_UIDVALIDITY;
	_tmp0_[4] = GEARY_IMAP_STATUS_DATA_TYPE_UNSEEN;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 5;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

gchar*
geary_imap_status_data_type_to_string (GearyImapStatusDataType self)
{
	gchar* result;
	switch (self) {
		case GEARY_IMAP_STATUS_DATA_TYPE_MESSAGES:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("MESSAGES");
			result = _tmp0_;
			return result;
		}
		case GEARY_IMAP_STATUS_DATA_TYPE_RECENT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("RECENT");
			result = _tmp1_;
			return result;
		}
		case GEARY_IMAP_STATUS_DATA_TYPE_UIDNEXT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("UIDNEXT");
			result = _tmp2_;
			return result;
		}
		case GEARY_IMAP_STATUS_DATA_TYPE_UIDVALIDITY:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("UIDVALIDITY");
			result = _tmp3_;
			return result;
		}
		case GEARY_IMAP_STATUS_DATA_TYPE_UNSEEN:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("UNSEEN");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GearyImapStatusDataType
geary_imap_status_data_type_from_parameter (GearyImapStringParameter* stringp,
                                            GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	GError* _inner_error0_ = NULL;
	GearyImapStatusDataType result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (stringp), 0);
	_tmp0_ = geary_imap_string_parameter_as_lower (stringp);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("messages")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_STATUS_DATA_TYPE_MESSAGES;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("recent")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_STATUS_DATA_TYPE_RECENT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("uidnext")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_STATUS_DATA_TYPE_UIDNEXT;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("uidvalidity")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_STATUS_DATA_TYPE_UIDVALIDITY;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("unseen")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_STATUS_DATA_TYPE_UNSEEN;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				GError* _tmp6_;
				GError* _tmp7_;
				_tmp4_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (stringp, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
				_tmp5_ = _tmp4_;
				_tmp6_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Unknown status data type \"%s\"", _tmp5_);
				_tmp7_ = _tmp6_;
				_g_free0 (_tmp5_);
				_inner_error0_ = _tmp7_;
				if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return 0;
				}
			}
		}
	}
}

GearyImapStringParameter*
geary_imap_status_data_type_to_parameter (GearyImapStatusDataType self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GearyImapAtomParameter* _tmp2_;
	GearyImapStringParameter* _tmp3_;
	GearyImapStringParameter* result;
	_tmp0_ = geary_imap_status_data_type_to_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_atom_parameter_new (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_imap_status_data_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_IMAP_STATUS_DATA_TYPE_MESSAGES, "GEARY_IMAP_STATUS_DATA_TYPE_MESSAGES", "messages"}, {GEARY_IMAP_STATUS_DATA_TYPE_RECENT, "GEARY_IMAP_STATUS_DATA_TYPE_RECENT", "recent"}, {GEARY_IMAP_STATUS_DATA_TYPE_UIDNEXT, "GEARY_IMAP_STATUS_DATA_TYPE_UIDNEXT", "uidnext"}, {GEARY_IMAP_STATUS_DATA_TYPE_UIDVALIDITY, "GEARY_IMAP_STATUS_DATA_TYPE_UIDVALIDITY", "uidvalidity"}, {GEARY_IMAP_STATUS_DATA_TYPE_UNSEEN, "GEARY_IMAP_STATUS_DATA_TYPE_UNSEEN", "unseen"}, {0, NULL, NULL}};
	GType geary_imap_status_data_type_type_id;
	geary_imap_status_data_type_type_id = g_enum_register_static ("GearyImapStatusDataType", values);
	return geary_imap_status_data_type_type_id;
}

GType
geary_imap_status_data_type_get_type (void)
{
	static gsize geary_imap_status_data_type_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_status_data_type_type_id__once)) {
		GType geary_imap_status_data_type_type_id;
		geary_imap_status_data_type_type_id = geary_imap_status_data_type_get_type_once ();
		g_once_init_leave (&geary_imap_status_data_type_type_id__once, geary_imap_status_data_type_type_id);
	}
	return geary_imap_status_data_type_type_id__once;
}

