/* imap-server-data.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-server-data.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_SERVER_DATA_0_PROPERTY,
	GEARY_IMAP_SERVER_DATA_SERVER_DATA_TYPE_PROPERTY,
	GEARY_IMAP_SERVER_DATA_NUM_PROPERTIES
};
static GParamSpec* geary_imap_server_data_properties[GEARY_IMAP_SERVER_DATA_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapServerDataPrivate {
	GearyImapServerDataType _server_data_type;
};

static gint GearyImapServerData_private_offset;
static gpointer geary_imap_server_data_parent_class = NULL;

static void geary_imap_server_data_set_server_data_type (GearyImapServerData* self,
                                                  GearyImapServerDataType value);
static GearyImapServerData* geary_imap_server_data_new (GearyImapTag* tag,
                                                 GearyImapServerDataType server_data_type,
                                                 GearyImapQuirks* quirks);
static GearyImapServerData* geary_imap_server_data_construct (GType object_type,
                                                       GearyImapTag* tag,
                                                       GearyImapServerDataType server_data_type,
                                                       GearyImapQuirks* quirks);
static void geary_imap_server_data_finalize (GObject * obj);
static GType geary_imap_server_data_get_type_once (void);
static void _vala_geary_imap_server_data_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_geary_imap_server_data_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_imap_server_data_get_instance_private (GearyImapServerData* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapServerData_private_offset);
}

GearyImapServerDataType
geary_imap_server_data_get_server_data_type (GearyImapServerData* self)
{
	GearyImapServerDataType result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), 0);
	result = self->priv->_server_data_type;
	return result;
}

static void
geary_imap_server_data_set_server_data_type (GearyImapServerData* self,
                                             GearyImapServerDataType value)
{
	GearyImapServerDataType old_value;
	g_return_if_fail (GEARY_IMAP_IS_SERVER_DATA (self));
	old_value = geary_imap_server_data_get_server_data_type (self);
	if (old_value != value) {
		self->priv->_server_data_type = value;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_server_data_properties[GEARY_IMAP_SERVER_DATA_SERVER_DATA_TYPE_PROPERTY]);
	}
}

static GearyImapServerData*
geary_imap_server_data_construct (GType object_type,
                                  GearyImapTag* tag,
                                  GearyImapServerDataType server_data_type,
                                  GearyImapQuirks* quirks)
{
	GearyImapServerData * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_TAG (tag), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	self = (GearyImapServerData*) geary_imap_server_response_construct (object_type, tag, quirks);
	geary_imap_server_data_set_server_data_type (self, server_data_type);
	return self;
}

static GearyImapServerData*
geary_imap_server_data_new (GearyImapTag* tag,
                            GearyImapServerDataType server_data_type,
                            GearyImapQuirks* quirks)
{
	return geary_imap_server_data_construct (GEARY_IMAP_TYPE_SERVER_DATA, tag, server_data_type, quirks);
}

/**
     * Converts the {@link RootParameters} into {@link ServerData}.
     *
     * The supplied root is "stripped" of its children.  This may happen even if an exception is
     * thrown.  It's recommended to use {@link is_server_data} prior to this call.
     */
GearyImapServerData*
geary_imap_server_data_construct_migrate (GType object_type,
                                          GearyImapRootParameters* root,
                                          GearyImapQuirks* quirks,
                                          GError** error)
{
	GearyImapServerData * self = NULL;
	GearyImapServerDataType _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_ROOT_PARAMETERS (root), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	self = (GearyImapServerData*) geary_imap_server_response_construct_migrate (object_type, root, quirks, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp0_ = geary_imap_server_data_type_from_response (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_ROOT_PARAMETERS, GearyImapRootParameters), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	geary_imap_server_data_set_server_data_type (self, _tmp0_);
	return self;
}

GearyImapServerData*
geary_imap_server_data_new_migrate (GearyImapRootParameters* root,
                                    GearyImapQuirks* quirks,
                                    GError** error)
{
	return geary_imap_server_data_construct_migrate (GEARY_IMAP_TYPE_SERVER_DATA, root, quirks, error);
}

/**
     * Returns true if {@link RootParameters} is recognized by {@link ServerDataType.from_response}.
     */
gboolean
geary_imap_server_data_is_server_data (GearyImapRootParameters* root)
{
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_ROOT_PARAMETERS (root), FALSE);
	if (!geary_imap_root_parameters_has_tag (root)) {
		result = FALSE;
		return result;
	}
	{
		geary_imap_server_data_type_from_response (root, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp0_ = FALSE;
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				goto __catch0_geary_imap_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp0_;
		}
		result = TRUE;
		return result;
	}
	goto __finally0;
	__catch0_geary_imap_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp1_;
}

/**
     * Parses the {@link ServerData} into {@link Capabilities}, if possible.
     *
     * @throws ImapError.INVALID if not a Capability.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapCapabilities*
geary_imap_server_data_get_capabilities (GearyImapServerData* self,
                                         gint revision,
                                         GError** error)
{
	GearyImapServerDataType _tmp0_;
	GearyImapStringParameter** params = NULL;
	gint _tmp5_;
	gint _tmp6_;
	GearyImapStringParameter** _tmp7_;
	gint params_length1;
	gint _params_size_;
	gint count = 0;
	GearyImapStringParameter** _tmp18_;
	gint _tmp18__length1;
	GearyImapCapabilities* _tmp19_;
	GError* _inner_error0_ = NULL;
	GearyImapCapabilities* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), NULL);
	_tmp0_ = self->priv->_server_data_type;
	if (_tmp0_ != GEARY_IMAP_SERVER_DATA_TYPE_CAPABILITY) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not CAPABILITY data: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (GearyImapStringParameter*, _tmp6_ + 1);
	params = _tmp7_;
	params_length1 = _tmp6_;
	_params_size_ = params_length1;
	count = 0;
	{
		gint ctr = 0;
		ctr = 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				GearyImapStringParameter* param = NULL;
				GearyImapStringParameter* _tmp12_;
				GearyImapStringParameter* _tmp13_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = ctr;
					ctr = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
				_tmp11_ = _tmp10_;
				if (!(ctr < _tmp11_)) {
					break;
				}
				_tmp12_ = geary_imap_list_parameter_get_if_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), ctr);
				param = _tmp12_;
				_tmp13_ = param;
				if (_tmp13_ != NULL) {
					GearyImapStringParameter** _tmp14_;
					gint _tmp14__length1;
					gint _tmp15_;
					GearyImapStringParameter* _tmp16_;
					GearyImapStringParameter* _tmp17_;
					_tmp14_ = params;
					_tmp14__length1 = params_length1;
					_tmp15_ = count;
					count = _tmp15_ + 1;
					_tmp16_ = param;
					_tmp17_ = _g_object_ref0 (_tmp16_);
					_g_object_unref0 (_tmp14_[_tmp15_]);
					_tmp14_[_tmp15_] = _tmp17_;
				}
				_g_object_unref0 (param);
			}
		}
	}
	_tmp18_ = params;
	_tmp18__length1 = params_length1;
	_tmp19_ = geary_imap_capabilities_new (_tmp18_ + 0, count - 0, revision);
	result = _tmp19_;
	params = (_vala_array_free (params, params_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}

/**
     * Parses the {@link ServerData} into an {@link ServerDataType.EXISTS} value, if possible.
     *
     * @throws ImapError.INVALID if not EXISTS.
     */
gint
geary_imap_server_data_get_exists (GearyImapServerData* self,
                                   GError** error)
{
	GearyImapServerDataType _tmp0_;
	GearyImapStringParameter* _tmp7_ = NULL;
	GearyImapStringParameter* _tmp8_;
	gint32 _tmp11_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), 0);
	_tmp0_ = self->priv->_server_data_type;
	if (_tmp0_ != GEARY_IMAP_SERVER_DATA_TYPE_EXISTS) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not EXISTS data: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint _tmp5_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp5_;
		} else {
			gint _tmp6_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	_tmp8_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp7_ = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint _tmp9_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp9_;
		} else {
			gint _tmp10_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	_tmp11_ = geary_imap_string_parameter_as_int32 (_tmp7_, (gint32) 0, G_MAXINT32, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint _tmp12_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp7_);
			return _tmp12_;
		} else {
			gint _tmp13_ = -1;
			_g_object_unref0 (_tmp7_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp13_;
		}
	}
	result = (gint) _tmp11_;
	_g_object_unref0 (_tmp7_);
	return result;
}

/**
     * Parses the {@link ServerData} into an expunged {@link SequenceNumber}, if possible.
     *
     * @throws ImapError.INVALID if not an expunged MessageNumber.
     */
GearyImapSequenceNumber*
geary_imap_server_data_get_expunge (GearyImapServerData* self,
                                    GError** error)
{
	GearyImapServerDataType _tmp0_;
	GearyImapStringParameter* _tmp5_ = NULL;
	GearyImapStringParameter* _tmp6_;
	gint64 _tmp7_ = 0LL;
	GearyImapSequenceNumber* _tmp8_ = NULL;
	GearyImapSequenceNumber* _tmp9_;
	GearyImapSequenceNumber* _tmp10_;
	GError* _inner_error0_ = NULL;
	GearyImapSequenceNumber* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), NULL);
	_tmp0_ = self->priv->_server_data_type;
	if (_tmp0_ != GEARY_IMAP_SERVER_DATA_TYPE_EXPUNGE) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not EXPUNGE data: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp5_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = geary_imap_string_parameter_as_int64 (_tmp5_, G_MININT64, G_MAXINT64, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp5_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp5_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = geary_imap_sequence_number_new_checked (_tmp7_, &_inner_error0_);
	_tmp8_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp5_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp5_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp10_ = _tmp8_;
	_tmp8_ = NULL;
	result = _tmp10_;
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp5_);
	return result;
}

/**
     * Parses the {@link ServerData} into {@link FetchedData}, if possible.
     *
     * @throws ImapError.INVALID if not FetchData.
     */
GearyImapFetchedData*
geary_imap_server_data_get_fetch (GearyImapServerData* self,
                                  GError** error)
{
	GearyImapServerDataType _tmp0_;
	GearyImapFetchedData* _tmp5_ = NULL;
	GearyImapFetchedData* _tmp6_;
	GearyImapFetchedData* _tmp7_;
	GError* _inner_error0_ = NULL;
	GearyImapFetchedData* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), NULL);
	_tmp0_ = self->priv->_server_data_type;
	if (_tmp0_ != GEARY_IMAP_SERVER_DATA_TYPE_FETCH) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not FETCH data: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_fetched_data_decode (self, &_inner_error0_);
	_tmp5_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = _tmp5_;
	_tmp5_ = NULL;
	result = _tmp7_;
	_g_object_unref0 (_tmp5_);
	return result;
}

/**
     * Parses the {@link ServerData} into {@link MailboxAttributes}, if possible.
     *
     * @throws ImapError.INVALID if not MailboxAttributes.
     */
GearyImapMailboxAttributes*
geary_imap_server_data_get_flags (GearyImapServerData* self,
                                  GError** error)
{
	GearyImapServerDataType _tmp0_;
	GearyImapListParameter* _tmp5_ = NULL;
	GearyImapListParameter* _tmp6_;
	GearyImapMailboxAttributes* _tmp7_ = NULL;
	GearyImapMailboxAttributes* _tmp8_;
	GearyImapMailboxAttributes* _tmp9_;
	GError* _inner_error0_ = NULL;
	GearyImapMailboxAttributes* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), NULL);
	_tmp0_ = self->priv->_server_data_type;
	if (_tmp0_ != GEARY_IMAP_SERVER_DATA_TYPE_FLAGS) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not FLAGS data: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_list_parameter_get_as_list (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 2, &_inner_error0_);
	_tmp5_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = geary_imap_mailbox_attributes_from_list (_tmp5_, &_inner_error0_);
	_tmp7_ = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp5_);
			return NULL;
		} else {
			_g_object_unref0 (_tmp5_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = _tmp7_;
	_tmp7_ = NULL;
	result = _tmp9_;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	return result;
}

/**
     * Parses the {@link ServerData} into {@link MailboxInformation}, if possible.
     *
     * @throws ImapError.INVALID if not MailboxInformation.
     */
GearyImapMailboxInformation*
geary_imap_server_data_get_list (GearyImapServerData* self,
                                 GError** error)
{
	gboolean _tmp0_ = FALSE;
	GearyImapServerDataType _tmp1_;
	GearyImapMailboxInformation* _tmp7_ = NULL;
	GearyImapMailboxInformation* _tmp8_;
	GearyImapMailboxInformation* _tmp9_;
	GError* _inner_error0_ = NULL;
	GearyImapMailboxInformation* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), NULL);
	_tmp1_ = self->priv->_server_data_type;
	if (_tmp1_ != GEARY_IMAP_SERVER_DATA_TYPE_LIST) {
		GearyImapServerDataType _tmp2_;
		_tmp2_ = self->priv->_server_data_type;
		_tmp0_ = _tmp2_ != GEARY_IMAP_SERVER_DATA_TYPE_XLIST;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		GError* _tmp6_;
		_tmp3_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp4_ = _tmp3_;
		_tmp5_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not LIST/XLIST data: %s", _tmp4_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_inner_error0_ = _tmp6_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = geary_imap_mailbox_information_decode (self, TRUE, &_inner_error0_);
	_tmp7_ = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp9_ = _tmp7_;
	_tmp7_ = NULL;
	result = _tmp9_;
	_g_object_unref0 (_tmp7_);
	return result;
}

/**
     * Parses the {@link ServerData} into {@link MailboxInformation}, if possible.
     *
     * @throws ImapError.INVALID if not a NAMESPACE response.
     */
GearyImapNamespaceResponse*
geary_imap_server_data_get_namespace (GearyImapServerData* self,
                                      GError** error)
{
	GearyImapServerDataType _tmp0_;
	GearyImapNamespaceResponse* _tmp5_ = NULL;
	GearyImapNamespaceResponse* _tmp6_;
	GearyImapNamespaceResponse* _tmp7_;
	GError* _inner_error0_ = NULL;
	GearyImapNamespaceResponse* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), NULL);
	_tmp0_ = self->priv->_server_data_type;
	if (_tmp0_ != GEARY_IMAP_SERVER_DATA_TYPE_NAMESPACE) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not NAMESPACE data: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_namespace_response_decode (self, &_inner_error0_);
	_tmp5_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = _tmp5_;
	_tmp5_ = NULL;
	result = _tmp7_;
	_g_object_unref0 (_tmp5_);
	return result;
}

/**
     * Parses the {@link ServerData} into a {@link ServerDataType.RECENT} value, if possible.
     *
     * @throws ImapError.INVALID if not a {@link ServerDataType.RECENT} value.
     */
gint
geary_imap_server_data_get_recent (GearyImapServerData* self,
                                   GError** error)
{
	GearyImapServerDataType _tmp0_;
	GearyImapStringParameter* _tmp7_ = NULL;
	GearyImapStringParameter* _tmp8_;
	gint32 _tmp11_ = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), 0);
	_tmp0_ = self->priv->_server_data_type;
	if (_tmp0_ != GEARY_IMAP_SERVER_DATA_TYPE_RECENT) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not RECENT data: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint _tmp5_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp5_;
		} else {
			gint _tmp6_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	_tmp8_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), 1, &_inner_error0_);
	_tmp7_ = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint _tmp9_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp9_;
		} else {
			gint _tmp10_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	_tmp11_ = geary_imap_string_parameter_as_int32 (_tmp7_, (gint32) 0, G_MAXINT32, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint _tmp12_ = -1;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp7_);
			return _tmp12_;
		} else {
			gint _tmp13_ = -1;
			_g_object_unref0 (_tmp7_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp13_;
		}
	}
	result = (gint) _tmp11_;
	_g_object_unref0 (_tmp7_);
	return result;
}

/**
     * Parses the {@link ServerData} into a {@link ServerDataType.SEARCH} value, if possible.
     *
     * @throws ImapError.INVALID if not a {@link ServerDataType.SEARCH} value.
     */
gint64*
geary_imap_server_data_get_search (GearyImapServerData* self,
                                   gint* result_length1,
                                   GError** error)
{
	GearyImapServerDataType _tmp0_;
	gint _tmp5_;
	gint _tmp6_;
	gint64* results = NULL;
	gint _tmp9_;
	gint _tmp10_;
	gint64* _tmp11_;
	gint results_length1;
	gint _results_size_;
	gint64* _tmp20_;
	gint _tmp20__length1;
	GError* _inner_error0_ = NULL;
	gint64* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), NULL);
	_tmp0_ = self->priv->_server_data_type;
	if (_tmp0_ != GEARY_IMAP_SERVER_DATA_TYPE_SEARCH) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not SEARCH data: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
	_tmp6_ = _tmp5_;
	if (_tmp6_ <= 2) {
		gint64* _tmp7_;
		gint64* _tmp8_;
		gint _tmp8__length1;
		_tmp7_ = g_new0 (gint64, 0);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp8__length1;
		}
		result = _tmp8_;
		return result;
	}
	_tmp9_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_new0 (gint64, _tmp10_ - 2);
	results = _tmp11_;
	results_length1 = _tmp10_ - 2;
	_results_size_ = results_length1;
	{
		gint ctr = 0;
		ctr = 2;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_;
				gint _tmp15_;
				GearyImapStringParameter* _tmp16_ = NULL;
				GearyImapStringParameter* _tmp17_;
				gint64 _tmp18_ = 0LL;
				gint64* _tmp19_;
				gint _tmp19__length1;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = ctr;
					ctr = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = geary_imap_list_parameter_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter));
				_tmp15_ = _tmp14_;
				if (!(ctr < _tmp15_)) {
					break;
				}
				_tmp17_ = geary_imap_list_parameter_get_as_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_LIST_PARAMETER, GearyImapListParameter), ctr, &_inner_error0_);
				_tmp16_ = _tmp17_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						results = (g_free (results), NULL);
						return NULL;
					} else {
						results = (g_free (results), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp18_ = geary_imap_string_parameter_as_int64 (_tmp16_, (gint64) 0, G_MAXINT64, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (_tmp16_);
						results = (g_free (results), NULL);
						return NULL;
					} else {
						_g_object_unref0 (_tmp16_);
						results = (g_free (results), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp19_ = results;
				_tmp19__length1 = results_length1;
				_tmp19_[ctr - 2] = _tmp18_;
				_g_object_unref0 (_tmp16_);
			}
		}
	}
	_tmp20_ = results;
	_tmp20__length1 = results_length1;
	if (result_length1) {
		*result_length1 = _tmp20__length1;
	}
	result = _tmp20_;
	return result;
}

/**
     * Parses the {@link ServerData} into {@link StatusData}, if possible.
     *
     * @throws ImapError.INVALID if not {@link StatusData}.
     */
GearyImapStatusData*
geary_imap_server_data_get_status (GearyImapServerData* self,
                                   GError** error)
{
	GearyImapServerDataType _tmp0_;
	GearyImapStatusData* _tmp5_ = NULL;
	GearyImapStatusData* _tmp6_;
	GearyImapStatusData* _tmp7_;
	GError* _inner_error0_ = NULL;
	GearyImapStatusData* result;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_DATA (self), NULL);
	_tmp0_ = self->priv->_server_data_type;
	if (_tmp0_ != GEARY_IMAP_SERVER_DATA_TYPE_STATUS) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Not STATUS data: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = geary_imap_status_data_decode (self, &_inner_error0_);
	_tmp5_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = _tmp5_;
	_tmp5_ = NULL;
	result = _tmp7_;
	_g_object_unref0 (_tmp5_);
	return result;
}

static void
geary_imap_server_data_class_init (GearyImapServerDataClass * klass,
                                   gpointer klass_data)
{
	geary_imap_server_data_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapServerData_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_server_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_server_data_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_server_data_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_SERVER_DATA_SERVER_DATA_TYPE_PROPERTY, geary_imap_server_data_properties[GEARY_IMAP_SERVER_DATA_SERVER_DATA_TYPE_PROPERTY] = g_param_spec_enum ("server-data-type", "server-data-type", "server-data-type", GEARY_IMAP_TYPE_SERVER_DATA_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_server_data_instance_init (GearyImapServerData * self,
                                      gpointer klass)
{
	self->priv = geary_imap_server_data_get_instance_private (self);
}

static void
geary_imap_server_data_finalize (GObject * obj)
{
	GearyImapServerData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_SERVER_DATA, GearyImapServerData);
	G_OBJECT_CLASS (geary_imap_server_data_parent_class)->finalize (obj);
}

/**
 * Email data sent from the server to client in response to a command or unsolicited.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7.2]] for more information.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_server_data_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapServerDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_server_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapServerData), 0, (GInstanceInitFunc) geary_imap_server_data_instance_init, NULL };
	GType geary_imap_server_data_type_id;
	geary_imap_server_data_type_id = g_type_register_static (GEARY_IMAP_TYPE_SERVER_RESPONSE, "GearyImapServerData", &g_define_type_info, 0);
	GearyImapServerData_private_offset = g_type_add_instance_private (geary_imap_server_data_type_id, sizeof (GearyImapServerDataPrivate));
	return geary_imap_server_data_type_id;
}

GType
geary_imap_server_data_get_type (void)
{
	static gsize geary_imap_server_data_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_server_data_type_id__once)) {
		GType geary_imap_server_data_type_id;
		geary_imap_server_data_type_id = geary_imap_server_data_get_type_once ();
		g_once_init_leave (&geary_imap_server_data_type_id__once, geary_imap_server_data_type_id);
	}
	return geary_imap_server_data_type_id__once;
}

static void
_vala_geary_imap_server_data_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GearyImapServerData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_SERVER_DATA, GearyImapServerData);
	switch (property_id) {
		case GEARY_IMAP_SERVER_DATA_SERVER_DATA_TYPE_PROPERTY:
		g_value_set_enum (value, geary_imap_server_data_get_server_data_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_server_data_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GearyImapServerData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_SERVER_DATA, GearyImapServerData);
	switch (property_id) {
		case GEARY_IMAP_SERVER_DATA_SERVER_DATA_TYPE_PROPERTY:
		geary_imap_server_data_set_server_data_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

