/* rfc822-message.c generated by valac 0.56.3, the Vala compiler
 * generated from rfc822-message.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gmime/gmime.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <ytnef.h>

#define GEARY_RF_C822_MESSAGE_HEADER_IN_REPLY_TO "In-Reply-To"
#define GEARY_RF_C822_MESSAGE_HEADER_REFERENCES "References"
#define GEARY_RF_C822_MESSAGE_HEADER_MAILER "X-Mailer"
#define GEARY_RF_C822_MESSAGE_HEADER_BCC "Bcc"

enum  {
	GEARY_RF_C822_MESSAGE_0_PROPERTY,
	GEARY_RF_C822_MESSAGE_FROM_PROPERTY,
	GEARY_RF_C822_MESSAGE_SENDER_PROPERTY,
	GEARY_RF_C822_MESSAGE_REPLY_TO_PROPERTY,
	GEARY_RF_C822_MESSAGE_TO_PROPERTY,
	GEARY_RF_C822_MESSAGE_CC_PROPERTY,
	GEARY_RF_C822_MESSAGE_BCC_PROPERTY,
	GEARY_RF_C822_MESSAGE_MESSAGE_ID_PROPERTY,
	GEARY_RF_C822_MESSAGE_IN_REPLY_TO_PROPERTY,
	GEARY_RF_C822_MESSAGE_REFERENCES_PROPERTY,
	GEARY_RF_C822_MESSAGE_SUBJECT_PROPERTY,
	GEARY_RF_C822_MESSAGE_DATE_PROPERTY,
	GEARY_RF_C822_MESSAGE_AUTH_RESULTS_PROPERTY,
	GEARY_RF_C822_MESSAGE_MAILER_PROPERTY,
	GEARY_RF_C822_MESSAGE_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GMimeParserOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMimeParserOptions_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyRfC822MessageNewFromComposedEmailData GearyRfC822MessageNewFromComposedEmailData;
typedef struct _GearyRfC822MessageGetFilePartData GearyRfC822MessageGetFilePartData;
typedef struct _GearyRfC822MessageGetBufferPartData GearyRfC822MessageGetBufferPartData;
#define __vala_GMimeFormatOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMimeFormatOptions_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
typedef struct _GearyRfC822MessageBodyDataToPartData GearyRfC822MessageBodyDataToPartData;

struct _GearyRFC822MessagePrivate {
	GearyRFC822MailboxAddresses* _from;
	GearyRFC822MailboxAddress* _sender;
	GearyRFC822MailboxAddresses* _reply_to;
	GearyRFC822MailboxAddresses* _to;
	GearyRFC822MailboxAddresses* _cc;
	GearyRFC822MailboxAddresses* _bcc;
	GearyRFC822MessageID* _message_id;
	GearyRFC822MessageIDList* _in_reply_to;
	GearyRFC822MessageIDList* _references;
	GearyRFC822Subject* _subject;
	GearyRFC822Date* _date;
	GearyRFC822AuthenticationResults* _auth_results;
	gchar* _mailer;
	GMimeMessage* message;
};

struct _GearyRfC822MessageNewFromComposedEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GType object_type;
	GearyRFC822Message* self;
	GearyComposedEmail* email;
	gchar* message_id;
	GCancellable* cancellable;
	GMimeMessage* _tmp0_;
	GearyRFC822MailboxAddresses* _tmp1_;
	GearyRFC822MailboxAddresses* _tmp2_;
	GearyRFC822MailboxAddresses* _tmp3_;
	GearyRFC822MailboxAddresses* _mailbox_list;
	GearyRFC822MailboxAddresses* _tmp4_;
	GearyRFC822MailboxAddresses* _tmp5_;
	gint _mailbox_size;
	GearyRFC822MailboxAddresses* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _mailbox_index;
	gint _tmp9_;
	gint _tmp10_;
	GearyRFC822MailboxAddress* mailbox;
	GearyRFC822MailboxAddresses* _tmp11_;
	GearyRFC822MailboxAddress* _tmp12_;
	GMimeMessage* _tmp13_;
	GearyRFC822MailboxAddress* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GearyRFC822MailboxAddress* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	GearyRFC822Date* _tmp20_;
	GearyRFC822Date* _tmp21_;
	GearyRFC822Date* _tmp22_;
	GMimeMessage* _tmp23_;
	GearyRFC822Date* _tmp24_;
	GearyRFC822Date* _tmp25_;
	GDateTime* _tmp26_;
	GDateTime* _tmp27_;
	GearyRFC822MailboxAddresses* _tmp28_;
	GearyRFC822MailboxAddresses* _tmp29_;
	GearyRFC822MailboxAddresses* _tmp30_;
	GearyRFC822MailboxAddresses* _tmp31_;
	GearyRFC822MailboxAddresses* _tmp32_;
	GearyRFC822MailboxAddresses* _vala1__mailbox_list;
	GearyRFC822MailboxAddresses* _tmp33_;
	GearyRFC822MailboxAddresses* _tmp34_;
	gint _vala1__mailbox_size;
	GearyRFC822MailboxAddresses* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _vala1__mailbox_index;
	gint _tmp38_;
	gint _tmp39_;
	GearyRFC822MailboxAddress* _vala1_mailbox;
	GearyRFC822MailboxAddresses* _tmp40_;
	GearyRFC822MailboxAddress* _tmp41_;
	GMimeMessage* _tmp42_;
	GearyRFC822MailboxAddress* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	GearyRFC822MailboxAddress* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	GearyRFC822MailboxAddresses* _tmp49_;
	GearyRFC822MailboxAddresses* _tmp50_;
	GearyRFC822MailboxAddresses* _tmp51_;
	GearyRFC822MailboxAddresses* _tmp52_;
	GearyRFC822MailboxAddresses* _tmp53_;
	GearyRFC822MailboxAddresses* _vala2__mailbox_list;
	GearyRFC822MailboxAddresses* _tmp54_;
	GearyRFC822MailboxAddresses* _tmp55_;
	gint _vala2__mailbox_size;
	GearyRFC822MailboxAddresses* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gint _vala2__mailbox_index;
	gint _tmp59_;
	gint _tmp60_;
	GearyRFC822MailboxAddress* _vala2_mailbox;
	GearyRFC822MailboxAddresses* _tmp61_;
	GearyRFC822MailboxAddress* _tmp62_;
	GMimeMessage* _tmp63_;
	GearyRFC822MailboxAddress* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	GearyRFC822MailboxAddress* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	GearyRFC822MailboxAddresses* _tmp70_;
	GearyRFC822MailboxAddresses* _tmp71_;
	GearyRFC822MailboxAddresses* _tmp72_;
	GearyRFC822MailboxAddresses* _tmp73_;
	GearyRFC822MailboxAddresses* _tmp74_;
	GearyRFC822MailboxAddresses* _vala3__mailbox_list;
	GearyRFC822MailboxAddresses* _tmp75_;
	GearyRFC822MailboxAddresses* _tmp76_;
	gint _vala3__mailbox_size;
	GearyRFC822MailboxAddresses* _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	gint _vala3__mailbox_index;
	gint _tmp80_;
	gint _tmp81_;
	GearyRFC822MailboxAddress* _vala3_mailbox;
	GearyRFC822MailboxAddresses* _tmp82_;
	GearyRFC822MailboxAddress* _tmp83_;
	GMimeMessage* _tmp84_;
	GearyRFC822MailboxAddress* _tmp85_;
	const gchar* _tmp86_;
	const gchar* _tmp87_;
	GearyRFC822MailboxAddress* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	GearyRFC822MailboxAddress* _tmp91_;
	GearyRFC822MailboxAddress* _tmp92_;
	GearyRFC822MailboxAddress* _tmp93_;
	GearyRFC822MailboxAddress* _tmp94_;
	GearyRFC822MailboxAddress* _tmp95_;
	GMimeMessage* _tmp96_;
	GearyRFC822MailboxAddress* _tmp97_;
	GearyRFC822MailboxAddress* _tmp98_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	GearyRFC822MailboxAddress* _tmp101_;
	GearyRFC822MailboxAddress* _tmp102_;
	const gchar* _tmp103_;
	const gchar* _tmp104_;
	GearyRFC822MailboxAddresses* _tmp105_;
	GearyRFC822MailboxAddresses* _tmp106_;
	GearyRFC822MailboxAddresses* _tmp107_;
	GearyRFC822MailboxAddresses* _tmp108_;
	GearyRFC822MailboxAddresses* _tmp109_;
	GearyRFC822MailboxAddresses* _vala4__mailbox_list;
	GearyRFC822MailboxAddresses* _tmp110_;
	GearyRFC822MailboxAddresses* _tmp111_;
	gint _vala4__mailbox_size;
	GearyRFC822MailboxAddresses* _tmp112_;
	gint _tmp113_;
	gint _tmp114_;
	gint _vala4__mailbox_index;
	gint _tmp115_;
	gint _tmp116_;
	GearyRFC822MailboxAddress* _vala4_mailbox;
	GearyRFC822MailboxAddresses* _tmp117_;
	GearyRFC822MailboxAddress* _tmp118_;
	GMimeMessage* _tmp119_;
	GearyRFC822MailboxAddress* _tmp120_;
	const gchar* _tmp121_;
	const gchar* _tmp122_;
	GearyRFC822MailboxAddress* _tmp123_;
	const gchar* _tmp124_;
	const gchar* _tmp125_;
	GearyRFC822MessageID* _tmp126_;
	GMimeMessage* _tmp127_;
	GearyRFC822MessageIDList* _tmp128_;
	GearyRFC822MessageIDList* _tmp129_;
	GearyRFC822MessageIDList* _tmp130_;
	GearyRFC822MessageIDList* _tmp131_;
	GearyRFC822MessageIDList* _tmp132_;
	GMimeMessage* _tmp133_;
	GearyRFC822MessageIDList* _tmp134_;
	GearyRFC822MessageIDList* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	gchar* _tmp138_;
	gchar* _tmp139_;
	GearyRFC822MessageIDList* _tmp140_;
	GearyRFC822MessageIDList* _tmp141_;
	GearyRFC822MessageIDList* _tmp142_;
	GearyRFC822MessageIDList* _tmp143_;
	GearyRFC822MessageIDList* _tmp144_;
	GMimeMessage* _tmp145_;
	GearyRFC822MessageIDList* _tmp146_;
	GearyRFC822MessageIDList* _tmp147_;
	gchar* _tmp148_;
	gchar* _tmp149_;
	gchar* _tmp150_;
	gchar* _tmp151_;
	GearyRFC822Subject* _tmp152_;
	GearyRFC822Subject* _tmp153_;
	GearyRFC822Subject* _tmp154_;
	GearyRFC822Subject* _tmp155_;
	GearyRFC822Subject* _tmp156_;
	GMimeMessage* _tmp157_;
	GearyRFC822Subject* _tmp158_;
	GearyRFC822Subject* _tmp159_;
	const gchar* _tmp160_;
	const gchar* _tmp161_;
	gchar* _tmp162_;
	gchar* _tmp163_;
	const gchar* _tmp164_;
	const gchar* _tmp165_;
	const gchar* _tmp166_;
	const gchar* _tmp167_;
	GMimeMessage* _tmp168_;
	const gchar* _tmp169_;
	const gchar* _tmp170_;
	gchar* _tmp171_;
	gchar* _tmp172_;
	GeeList* body_parts;
	GeeLinkedList* _tmp173_;
	gchar* body_charset;
	const gchar* _tmp174_;
	const gchar* _tmp175_;
	GMimePart* body_text;
	GMimePart* _tmp176_;
	const gchar* _tmp177_;
	const gchar* _tmp178_;
	guint8* _tmp179_;
	gint _tmp179__length1;
	gint _tmp180_;
	guint8* _tmp181_;
	gint _tmp181__length1;
	GMimePart* _tmp182_;
	GMimePart* _tmp183_;
	GError* err;
	GError* _tmp184_;
	const gchar* _tmp185_;
	GMimePart* _tmp186_;
	GMimePart* _tmp187_;
	GMimeContentType* _tmp188_;
	const gchar* _tmp189_;
	gchar* _tmp190_;
	GeeList* _tmp191_;
	GMimePart* _tmp192_;
	const gchar* _tmp193_;
	const gchar* _tmp194_;
	GeeList* related_parts;
	GeeLinkedList* _tmp195_;
	GeeMap* inline_files;
	GeeHashMap* _tmp196_;
	GeeMap* _tmp197_;
	GeeMap* _tmp198_;
	GeeMap* _tmp199_;
	GeeIterator* _cid_it;
	GeeMap* _tmp200_;
	GeeMap* _tmp201_;
	GeeSet* _tmp202_;
	GeeSet* _tmp203_;
	GeeSet* _tmp204_;
	GeeIterator* _tmp205_;
	GeeIterator* _tmp206_;
	GeeIterator* _tmp207_;
	gchar* cid;
	GeeIterator* _tmp208_;
	gpointer _tmp209_;
	const gchar* _tmp210_;
	gchar* _tmp211_;
	gchar* _tmp212_;
	gboolean _tmp213_;
	GMimeObject* inline_part;
	GMimePart* _tmp214_;
	GeeMap* _tmp215_;
	GeeMap* _tmp216_;
	const gchar* _tmp217_;
	gpointer _tmp218_;
	GearyMemoryBuffer* _tmp219_;
	const gchar* _tmp220_;
	gchar* _tmp221_;
	gchar* _tmp222_;
	GMimePart* _tmp223_;
	GMimePart* _tmp224_;
	GMimePart* _tmp225_;
	GError* _vala1_err;
	const gchar* _tmp226_;
	GError* _tmp227_;
	const gchar* _tmp228_;
	GMimeObject* _tmp229_;
	GMimeObject* _tmp230_;
	const gchar* _tmp231_;
	GeeList* _tmp232_;
	GMimeObject* _tmp233_;
	GeeMap* _tmp234_;
	const gchar* _tmp235_;
	GeeMap* _tmp236_;
	gboolean _tmp237_;
	gboolean _tmp238_;
	guint cid_index;
	GeeIterator* _name_it;
	GeeMap* _tmp239_;
	GeeSet* _tmp240_;
	GeeSet* _tmp241_;
	GeeSet* _tmp242_;
	GeeIterator* _tmp243_;
	GeeIterator* _tmp244_;
	GeeIterator* _tmp245_;
	gchar* name;
	GeeIterator* _tmp246_;
	gpointer _tmp247_;
	gchar* _vala1_cid;
	gchar* _tmp248_;
	gboolean _tmp249_;
	GeeMap* _tmp250_;
	GeeMap* _tmp251_;
	const gchar* _tmp252_;
	guint _tmp253_;
	gchar* _tmp254_;
	const gchar* _tmp255_;
	const gchar* _tmp256_;
	gchar* _tmp257_;
	gchar* _tmp258_;
	gboolean _tmp259_;
	GMimeObject* _vala1_inline_part;
	GMimePart* _tmp260_;
	GeeMap* _tmp261_;
	const gchar* _tmp262_;
	gpointer _tmp263_;
	GearyMemoryBuffer* _tmp264_;
	const gchar* _tmp265_;
	gchar* _tmp266_;
	gchar* _tmp267_;
	GMimePart* _tmp268_;
	GMimePart* _tmp269_;
	GMimePart* _tmp270_;
	GError* _vala2_err;
	const gchar* _tmp271_;
	GError* _tmp272_;
	const gchar* _tmp273_;
	GMimeObject* _tmp274_;
	GMimeObject* _tmp275_;
	const gchar* _tmp276_;
	GeeList* _tmp277_;
	GMimeObject* _tmp278_;
	GMimeObject* body_html;
	GMimePart* _tmp279_;
	const gchar* _tmp280_;
	const gchar* _tmp281_;
	guint8* _tmp282_;
	gint _tmp282__length1;
	gint _tmp283_;
	guint8* _tmp284_;
	gint _tmp284__length1;
	const gchar* _tmp285_;
	GMimePart* _tmp286_;
	GMimePart* _tmp287_;
	GError* _vala3_err;
	GError* _tmp288_;
	const gchar* _tmp289_;
	GeeList* _tmp290_;
	gboolean _tmp291_;
	gboolean _tmp292_;
	GeeList* _tmp293_;
	GMimeObject* _tmp294_;
	GMimeObject* related_part;
	GeeList* _tmp295_;
	GMimeObject* _tmp296_;
	GMimeObject* _tmp297_;
	GMimeObject* _tmp298_;
	GMimeObject* _tmp299_;
	GeeList* _tmp300_;
	GMimeObject* _tmp301_;
	GeeList* main_parts;
	GeeLinkedList* _tmp302_;
	GMimeObject* body_part;
	GeeList* _tmp303_;
	GMimeObject* _tmp304_;
	GMimeObject* _tmp305_;
	GeeList* _tmp306_;
	GMimeObject* _tmp307_;
	GeeList* attachment_parts;
	GeeLinkedList* _tmp308_;
	GeeIterator* _file_it;
	GeeSet* _tmp309_;
	GeeSet* _tmp310_;
	GeeIterator* _tmp311_;
	GeeIterator* _tmp312_;
	GFile* file;
	GeeIterator* _tmp313_;
	gpointer _tmp314_;
	GMimeObject* attachment_part;
	GMimePart* _tmp315_;
	GFile* _tmp316_;
	GMimePart* _tmp317_;
	GMimePart* _tmp318_;
	GError* _vala4_err;
	GFile* _tmp319_;
	gchar* _tmp320_;
	gchar* _tmp321_;
	GError* _tmp322_;
	const gchar* _tmp323_;
	GMimeObject* _tmp324_;
	GeeList* _tmp325_;
	GMimeObject* _tmp326_;
	GMimeObject* _vala1_attachment_part;
	GeeList* _tmp327_;
	GMimeObject* _tmp328_;
	GMimeObject* _tmp329_;
	GeeList* _tmp330_;
	GMimeObject* _tmp331_;
	GMimeObject* main_part;
	GeeList* _tmp332_;
	GMimeObject* _tmp333_;
	GMimeMessage* _tmp334_;
	GError* _inner_error0_;
};

struct _GearyRfC822MessageGetFilePartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyRFC822Message* self;
	GFile* file;
	GearyMimeDispositionType disposition;
	GCancellable* cancellable;
	GMimePart* result;
	GFileInfo* file_info;
	GFileInfo* _tmp0_;
	GMimePart* part;
	GMimePart* _tmp1_;
	GMimePart* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GMimePart* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GMimeContentType* content_type;
	GMimeParserOptions* _tmp8_;
	GMimeParserOptions* _tmp9_;
	const gchar* _tmp10_;
	GMimeContentType* _tmp11_;
	GMimeContentType* _tmp12_;
	GMimePart* _tmp13_;
	GMimeContentType* _tmp14_;
	GMimePart* _tmp15_;
	GMimeStreamGIO* stream;
	GMimeStreamGIO* _tmp16_;
	GMimeStreamGIO* _tmp17_;
	GMimePart* _tmp18_;
	GMimeStreamGIO* _tmp19_;
	GMimeDataWrapper* _tmp20_;
	GMimeDataWrapper* _tmp21_;
	GError* _inner_error0_;
};

struct _GearyRfC822MessageGetBufferPartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyRFC822Message* self;
	GearyMemoryBuffer* buffer;
	gchar* basename;
	GearyMimeDispositionType disposition;
	GCancellable* cancellable;
	GMimePart* result;
	GearyMimeContentType* mime_type;
	GearyMimeContentType* _tmp0_;
	GearyMimeContentType* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	GMimeContentType* content_type;
	GMimeParserOptions* _tmp6_;
	GMimeParserOptions* _tmp7_;
	GearyMimeContentType* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GMimeContentType* _tmp11_;
	GMimeContentType* _tmp12_;
	GMimeContentType* _tmp13_;
	GearyMimeContentType* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	GMimePart* part;
	GMimePart* _tmp21_;
	GMimePart* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GMimePart* _tmp25_;
	GMimePart* _tmp26_;
	GMimeContentType* _tmp27_;
	GMimePart* _tmp28_;
	GMimeStreamMem* stream;
	GMimeStreamMem* _tmp29_;
	GMimePart* _tmp30_;
	GMimeStreamMem* _tmp31_;
	GMimeDataWrapper* _tmp32_;
	GMimeDataWrapper* _tmp33_;
	GError* _inner_error0_;
};

struct _GearyRfC822MessageBodyDataToPartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyRFC822Message* self;
	guint8* content;
	gint content_length1;
	gchar* charset;
	gchar* content_type;
	gboolean is_flowed;
	GCancellable* cancellable;
	GMimePart* result;
	GMimeStream* content_stream;
	GMimeStreamMem* _tmp0_;
	gchar* _tmp1_;
	GMimeStream* _tmp2_;
	gchar* _tmp3_;
	GMimeStreamFilter* filter_stream;
	GMimeStream* _tmp5_;
	GMimeStreamFilter* _tmp6_;
	GMimeStreamFilter* _tmp7_;
	GMimeFilterCharset* _tmp8_;
	GMimeFilterCharset* _tmp9_;
	GMimeContentEncoding encoding;
	GMimeStreamFilter* _tmp10_;
	gboolean _tmp11_;
	GMimeStreamFilter* _tmp12_;
	GMimeFilterUnix2Dos* _tmp13_;
	GMimeFilterUnix2Dos* _tmp14_;
	GMimeContentType* complete_type;
	GMimeParserOptions* _tmp15_;
	GMimeParserOptions* _tmp16_;
	GMimeContentType* _tmp17_;
	GMimeContentType* _tmp18_;
	GMimeContentType* _tmp19_;
	GMimeContentType* _tmp20_;
	GMimeDataWrapper* body;
	GMimeStreamFilter* _tmp21_;
	GMimeDataWrapper* _tmp22_;
	GMimePart* body_part;
	GMimePart* _tmp23_;
	GMimePart* _tmp24_;
	GMimeContentType* _tmp25_;
	GMimePart* _tmp26_;
	GMimeDataWrapper* _tmp27_;
	GMimePart* _tmp28_;
	GError* _inner_error0_;
};

static gint GearyRFC822Message_private_offset;
static gpointer geary_rf_c822_message_parent_class = NULL;
static GearyEmailHeaderSetIface * geary_rf_c822_message_geary_email_header_set_parent_iface = NULL;

VALA_EXTERN GMimeStreamMem* geary_rf_c822_utils_create_stream_mem (GearyMemoryBuffer* buffer);
static void _vala_GMimeParserOptions_free (GMimeParserOptions* self);
static GearyRFC822MailboxAddresses* geary_rf_c822_message_to_addresses (GearyRFC822Message* self,
                                                                 InternetAddressList* list,
                                                                 GError** error);
static GearyRFC822MessageIDList* geary_rf_c822_message_append_message_id (GearyRFC822Message* self,
                                                                   GearyRFC822MessageIDList* existing,
                                                                   const gchar* header_value,
                                                                   GError** error);
static void geary_rf_c822_message_construct_from_composed_email_data_free (gpointer _data);
static gboolean geary_rf_c822_message_construct_from_composed_email_co (GearyRfC822MessageNewFromComposedEmailData* _data_);
static void geary_rf_c822_message_body_data_to_part (GearyRFC822Message* self,
                                              guint8* content,
                                              gint content_length1,
                                              const gchar* charset,
                                              const gchar* content_type,
                                              gboolean is_flowed,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static GMimePart* geary_rf_c822_message_body_data_to_part_finish (GearyRFC822Message* self,
                                                           GAsyncResult* _res_,
                                                           GError** error);
static void geary_rf_c822_message_new_from_composed_email_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void geary_rf_c822_message_get_buffer_part (GearyRFC822Message* self,
                                            GearyMemoryBuffer* buffer,
                                            const gchar* basename,
                                            GearyMimeDispositionType disposition,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static GMimePart* geary_rf_c822_message_get_buffer_part_finish (GearyRFC822Message* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static GMimeObject* geary_rf_c822_message_coalesce_related (GearyRFC822Message* self,
                                                     GeeList* parts,
                                                     const gchar* type);
static GMimeObject* geary_rf_c822_message_coalesce_parts (GearyRFC822Message* self,
                                                   GeeList* parts,
                                                   const gchar* subtype);
static void geary_rf_c822_message_get_file_part (GearyRFC822Message* self,
                                          GFile* file,
                                          GearyMimeDispositionType disposition,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static GMimePart* geary_rf_c822_message_get_file_part_finish (GearyRFC822Message* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void geary_rf_c822_message_get_file_part_data_free (gpointer _data);
static gboolean geary_rf_c822_message_get_file_part_co (GearyRfC822MessageGetFilePartData* _data_);
static void geary_rf_c822_message_get_file_part_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void geary_rf_c822_message_get_buffer_part_data_free (gpointer _data);
static gboolean geary_rf_c822_message_get_buffer_part_co (GearyRfC822MessageGetBufferPartData* _data_);
static void _vala_GMimeFormatOptions_free (GMimeFormatOptions* self);
static GearyMemoryBuffer* geary_rf_c822_message_message_to_memory_buffer (GearyRFC822Message* self,
                                                                   gboolean encode_lf,
                                                                   GearyRFC822MessageRFC822FormatOptions options,
                                                                   GError** error);
static gboolean geary_rf_c822_message_has_body_parts (GearyRFC822Message* self,
                                               GMimeObject* node,
                                               const gchar* text_subtype);
VALA_EXTERN GearyRFC822Part* geary_rf_c822_part_new (GMimeObject* source);
VALA_EXTERN GearyRFC822Part* geary_rf_c822_part_construct (GType object_type,
                                               GMimeObject* source);
static gboolean geary_rf_c822_message_construct_body_from_mime_parts (GearyRFC822Message* self,
                                                               GMimeObject* node,
                                                               GearyMimeMultipartSubtype container_subtype,
                                                               const gchar* text_subtype,
                                                               gboolean to_html,
                                                               GearyRFC822MessageInlinePartReplacer replacer,
                                                               gpointer replacer_target,
                                                               gchar** body,
                                                               GError** error);
static gchar* geary_rf_c822_message_internal_get_body (GearyRFC822Message* self,
                                                const gchar* text_subtype,
                                                gboolean to_html,
                                                GearyRFC822MessageInlinePartReplacer replacer,
                                                gpointer replacer_target,
                                                GError** error);
VALA_EXTERN GeeList* geary_rf_c822_message_get_attachments (GearyRFC822Message* self,
                                                GearyMimeDispositionType disposition,
                                                GError** error);
static void geary_rf_c822_message_get_attachments_recursively (GearyRFC822Message* self,
                                                        GeeList* attachments,
                                                        GMimeObject* root,
                                                        GearyMimeDispositionType requested_disposition,
                                                        GError** error);
static GMimePart* geary_rf_c822_message_tnef_attachment_to_gmime_part (GearyRFC822Message* self,
                                                                Attachment* a);
static void geary_rf_c822_message_find_sub_messages (GearyRFC822Message* self,
                                              GeeList* messages,
                                              GMimeObject* root,
                                              GError** error);
static void geary_rf_c822_message_body_data_to_part_data_free (gpointer _data);
static gboolean geary_rf_c822_message_body_data_to_part_co (GearyRfC822MessageBodyDataToPartData* _data_);
VALA_EXTERN void geary_rf_c822_utils_get_best_charset (GMimeStream* in_stream,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN gchar* geary_rf_c822_utils_get_best_charset_finish (GAsyncResult* _res_,
                                                    GError** error);
static void geary_rf_c822_message_body_data_to_part_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
VALA_EXTERN void geary_rf_c822_utils_get_best_encoding (GMimeStream* in_stream,
                                            GMimeEncodingConstraint constraint,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN GMimeContentEncoding geary_rf_c822_utils_get_best_encoding_finish (GAsyncResult* _res_,
                                                                   GError** error);
static void geary_rf_c822_message_finalize (GObject * obj);
static GType geary_rf_c822_message_get_type_once (void);
static void _vala_geary_rf_c822_message_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_geary_rf_c822_message_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static const gchar* GEARY_RF_C822_MESSAGE_HEADER_AUTH_RESULTS[3] = {"ARC-Authentication-Results", "Authentication-Results", "X-Original-Authentication-Results"};

static inline gpointer
geary_rf_c822_message_get_instance_private (GearyRFC822Message* self)
{
	return G_STRUCT_MEMBER_P (self, GearyRFC822Message_private_offset);
}

/** Options to use when serialising a message in RFC 822 format. */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_message_rf_c822_format_options_get_type_once (void)
{
	static const GFlagsValue values[] = {{GEARY_RF_C822_MESSAGE_RF_C822_FORMAT_OPTIONS_NONE, "GEARY_RF_C822_MESSAGE_RF_C822_FORMAT_OPTIONS_NONE", "none"}, {GEARY_RF_C822_MESSAGE_RF_C822_FORMAT_OPTIONS_SMTP_FORMAT, "GEARY_RF_C822_MESSAGE_RF_C822_FORMAT_OPTIONS_SMTP_FORMAT", "smtp-format"}, {0, NULL, NULL}};
	GType geary_rf_c822_message_rf_c822_format_options_type_id;
	geary_rf_c822_message_rf_c822_format_options_type_id = g_flags_register_static ("GearyRFC822MessageRFC822FormatOptions", values);
	return geary_rf_c822_message_rf_c822_format_options_type_id;
}

GType
geary_rf_c822_message_rf_c822_format_options_get_type (void)
{
	static gsize geary_rf_c822_message_rf_c822_format_options_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_message_rf_c822_format_options_type_id__once)) {
		GType geary_rf_c822_message_rf_c822_format_options_type_id;
		geary_rf_c822_message_rf_c822_format_options_type_id = geary_rf_c822_message_rf_c822_format_options_get_type_once ();
		g_once_init_leave (&geary_rf_c822_message_rf_c822_format_options_type_id__once, geary_rf_c822_message_rf_c822_format_options_type_id);
	}
	return geary_rf_c822_message_rf_c822_format_options_type_id__once;
}

static GearyRFC822MailboxAddresses*
geary_rf_c822_message_real_get_from (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyRFC822Message* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_from;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddress*
geary_rf_c822_message_real_get_sender (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddress* result;
	GearyRFC822Message* self;
	GearyRFC822MailboxAddress* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_sender;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_rf_c822_message_real_get_reply_to (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyRFC822Message* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_reply_to;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_rf_c822_message_real_get_to (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyRFC822Message* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_to;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_rf_c822_message_real_get_cc (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyRFC822Message* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_cc;
	result = _tmp0_;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_rf_c822_message_real_get_bcc (GearyEmailHeaderSet* base)
{
	GearyRFC822MailboxAddresses* result;
	GearyRFC822Message* self;
	GearyRFC822MailboxAddresses* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_bcc;
	result = _tmp0_;
	return result;
}

static GearyRFC822MessageID*
geary_rf_c822_message_real_get_message_id (GearyEmailHeaderSet* base)
{
	GearyRFC822MessageID* result;
	GearyRFC822Message* self;
	GearyRFC822MessageID* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_message_id;
	result = _tmp0_;
	return result;
}

static GearyRFC822MessageIDList*
geary_rf_c822_message_real_get_in_reply_to (GearyEmailHeaderSet* base)
{
	GearyRFC822MessageIDList* result;
	GearyRFC822Message* self;
	GearyRFC822MessageIDList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_in_reply_to;
	result = _tmp0_;
	return result;
}

static GearyRFC822MessageIDList*
geary_rf_c822_message_real_get_references (GearyEmailHeaderSet* base)
{
	GearyRFC822MessageIDList* result;
	GearyRFC822Message* self;
	GearyRFC822MessageIDList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_references;
	result = _tmp0_;
	return result;
}

static GearyRFC822Subject*
geary_rf_c822_message_real_get_subject (GearyEmailHeaderSet* base)
{
	GearyRFC822Subject* result;
	GearyRFC822Message* self;
	GearyRFC822Subject* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_subject;
	result = _tmp0_;
	return result;
}

static GearyRFC822Date*
geary_rf_c822_message_real_get_date (GearyEmailHeaderSet* base)
{
	GearyRFC822Date* result;
	GearyRFC822Message* self;
	GearyRFC822Date* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}

GearyRFC822AuthenticationResults*
geary_rf_c822_message_get_auth_results (GearyRFC822Message* self)
{
	GearyRFC822AuthenticationResults* result;
	GearyRFC822AuthenticationResults* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp0_ = self->priv->_auth_results;
	result = _tmp0_;
	return result;
}

const gchar*
geary_rf_c822_message_get_mailer (GearyRFC822Message* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp0_ = self->priv->_mailer;
	result = _tmp0_;
	return result;
}

void
geary_rf_c822_message_set_mailer (GearyRFC822Message* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (self));
	old_value = geary_rf_c822_message_get_mailer (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mailer);
		self->priv->_mailer = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_MAILER_PROPERTY]);
	}
}

static void
_vala_GMimeParserOptions_free (GMimeParserOptions* self)
{
	g_boxed_free (g_mime_parser_options_get_type (), self);
}

GearyRFC822Message*
geary_rf_c822_message_construct (GType object_type,
                                 GearyRFC822Full* full,
                                 GError** error)
{
	GearyRFC822Message * self = NULL;
	GMimeParser* parser = NULL;
	GearyMemoryBuffer* _tmp0_;
	GearyMemoryBuffer* _tmp1_;
	GMimeStreamMem* _tmp2_;
	GMimeStreamMem* _tmp3_;
	GMimeParser* _tmp4_;
	GMimeParser* _tmp5_;
	GMimeMessage* message = NULL;
	GMimeParser* _tmp6_;
	GMimeParserOptions* _tmp7_;
	GMimeParserOptions* _tmp8_;
	GMimeMessage* _tmp9_;
	GMimeMessage* _tmp10_;
	GMimeMessage* _tmp11_;
	GMimeMessage* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_RF_C822_IS_FULL (full), NULL);
	_tmp0_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (full, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_rf_c822_utils_create_stream_mem (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_mime_parser_new_with_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_mime_stream_get_type (), GMimeStream));
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	parser = _tmp5_;
	_tmp6_ = parser;
	_tmp7_ = geary_rf_c822_get_parser_options ();
	_tmp8_ = _tmp7_;
	_tmp9_ = g_mime_parser_construct_message (_tmp6_, _tmp8_);
	_tmp10_ = _tmp9_;
	__vala_GMimeParserOptions_free0 (_tmp8_);
	message = _tmp10_;
	_tmp11_ = message;
	if (_tmp11_ == NULL) {
		GError* _tmp12_;
		_tmp12_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Unable to parse RFC 822 message");
		_inner_error0_ = _tmp12_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (message);
			_g_object_unref0 (parser);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (message);
			_g_object_unref0 (parser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp13_ = message;
	self = (GearyRFC822Message*) geary_rf_c822_message_construct_from_gmime_message (object_type, _tmp13_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (message);
			_g_object_unref0 (parser);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (message);
			_g_object_unref0 (parser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_object_unref0 (message);
	_g_object_unref0 (parser);
	return self;
}

GearyRFC822Message*
geary_rf_c822_message_new (GearyRFC822Full* full,
                           GError** error)
{
	return geary_rf_c822_message_construct (GEARY_RF_C822_TYPE_MESSAGE, full, error);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyRFC822Message*
geary_rf_c822_message_construct_from_gmime_message (GType object_type,
                                                    GMimeMessage* message,
                                                    GError** error)
{
	GearyRFC822Message * self = NULL;
	GMimeMessage* _tmp0_;
	GearyRFC822MailboxAddresses* _tmp1_ = NULL;
	InternetAddressList* _tmp2_;
	GearyRFC822MailboxAddresses* _tmp3_;
	GearyRFC822MailboxAddresses* _tmp4_;
	GearyRFC822MailboxAddresses* _tmp5_ = NULL;
	InternetAddressList* _tmp6_;
	GearyRFC822MailboxAddresses* _tmp7_;
	GearyRFC822MailboxAddresses* _tmp8_;
	GearyRFC822MailboxAddresses* _tmp9_ = NULL;
	InternetAddressList* _tmp10_;
	GearyRFC822MailboxAddresses* _tmp11_;
	GearyRFC822MailboxAddresses* _tmp12_;
	GearyRFC822MailboxAddresses* _tmp13_ = NULL;
	InternetAddressList* _tmp14_;
	GearyRFC822MailboxAddresses* _tmp15_;
	GearyRFC822MailboxAddresses* _tmp16_;
	GearyRFC822MailboxAddresses* _tmp17_ = NULL;
	InternetAddressList* _tmp18_;
	GearyRFC822MailboxAddresses* _tmp19_;
	GearyRFC822MailboxAddresses* _tmp20_;
	InternetAddressMailbox* sender = NULL;
	InternetAddressList* _tmp21_;
	InternetAddress* _tmp22_;
	InternetAddressMailbox* _tmp23_;
	InternetAddressMailbox* _tmp24_;
	gchar* subject = NULL;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	GDateTime* date = NULL;
	GDateTime* _tmp32_;
	GDateTime* _tmp33_;
	gchar* message_id = NULL;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	GMimeHeaderList* headers = NULL;
	GMimeHeaderList* _tmp48_;
	GMimeHeaderList* _tmp49_;
	const gchar* _tmp74_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (message, g_mime_message_get_type ()), NULL);
	self = (GearyRFC822Message*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (message);
	_g_object_unref0 (self->priv->message);
	self->priv->message = _tmp0_;
	_tmp2_ = g_mime_message_get_from (message);
	_tmp3_ = geary_rf_c822_message_to_addresses (self, _tmp2_, &_inner_error0_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = _tmp1_;
	_tmp1_ = NULL;
	_g_object_unref0 (self->priv->_from);
	self->priv->_from = _tmp4_;
	_tmp6_ = g_mime_message_get_to (message);
	_tmp7_ = geary_rf_c822_message_to_addresses (self, _tmp6_, &_inner_error0_);
	_tmp5_ = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp1_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp8_ = _tmp5_;
	_tmp5_ = NULL;
	_g_object_unref0 (self->priv->_to);
	self->priv->_to = _tmp8_;
	_tmp10_ = g_mime_message_get_cc (message);
	_tmp11_ = geary_rf_c822_message_to_addresses (self, _tmp10_, &_inner_error0_);
	_tmp9_ = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp1_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp12_ = _tmp9_;
	_tmp9_ = NULL;
	_g_object_unref0 (self->priv->_cc);
	self->priv->_cc = _tmp12_;
	_tmp14_ = g_mime_message_get_bcc (message);
	_tmp15_ = geary_rf_c822_message_to_addresses (self, _tmp14_, &_inner_error0_);
	_tmp13_ = _tmp15_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp1_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp16_ = _tmp13_;
	_tmp13_ = NULL;
	_g_object_unref0 (self->priv->_bcc);
	self->priv->_bcc = _tmp16_;
	_tmp18_ = g_mime_message_get_reply_to (message);
	_tmp19_ = geary_rf_c822_message_to_addresses (self, _tmp18_, &_inner_error0_);
	_tmp17_ = _tmp19_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp1_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp20_ = _tmp17_;
	_tmp17_ = NULL;
	_g_object_unref0 (self->priv->_reply_to);
	self->priv->_reply_to = _tmp20_;
	_tmp21_ = g_mime_message_get_sender (message);
	_tmp22_ = internet_address_list_get_address (_tmp21_, 0);
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, internet_address_mailbox_get_type ()) ? ((InternetAddressMailbox*) _tmp22_) : NULL);
	sender = _tmp23_;
	_tmp24_ = sender;
	if (_tmp24_ != NULL) {
		InternetAddressMailbox* _tmp25_;
		GearyRFC822MailboxAddress* _tmp26_;
		_tmp25_ = sender;
		_tmp26_ = geary_rf_c822_mailbox_address_new_from_gmime (_tmp25_);
		_g_object_unref0 (self->priv->_sender);
		self->priv->_sender = _tmp26_;
	}
	_tmp27_ = g_mime_message_get_subject (message);
	_tmp28_ = g_strdup (_tmp27_);
	subject = _tmp28_;
	_tmp29_ = subject;
	if (_tmp29_ != NULL) {
		const gchar* _tmp30_;
		GearyRFC822Subject* _tmp31_;
		_tmp30_ = subject;
		_tmp31_ = geary_rf_c822_subject_new (_tmp30_);
		_g_object_unref0 (self->priv->_subject);
		self->priv->_subject = _tmp31_;
	}
	_tmp32_ = g_mime_message_get_date (message);
	date = _tmp32_;
	_tmp33_ = date;
	if (_tmp33_ != NULL) {
		GDateTime* _tmp34_;
		GearyRFC822Date* _tmp35_;
		_tmp34_ = date;
		_tmp35_ = geary_rf_c822_date_new (_tmp34_);
		_g_object_unref0 (self->priv->_date);
		self->priv->_date = _tmp35_;
	}
	_tmp36_ = g_mime_message_get_message_id (message);
	_tmp37_ = g_strdup (_tmp36_);
	message_id = _tmp37_;
	_tmp38_ = message_id;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_;
		GearyRFC822MessageID* _tmp40_;
		_tmp39_ = message_id;
		_tmp40_ = geary_rf_c822_message_id_new (_tmp39_);
		_g_object_unref0 (self->priv->_message_id);
		self->priv->_message_id = _tmp40_;
	}
	{
		const gchar** field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = GEARY_RF_C822_MESSAGE_HEADER_AUTH_RESULTS;
		field_collection_length1 = G_N_ELEMENTS (GEARY_RF_C822_MESSAGE_HEADER_AUTH_RESULTS);
		for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
			gchar* _tmp41_;
			gchar* field = NULL;
			_tmp41_ = g_strdup (field_collection[field_it]);
			field = _tmp41_;
			{
				gchar* auth_results = NULL;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp44_;
				const gchar* _tmp45_;
				_tmp42_ = field;
				_tmp43_ = g_mime_object_get_header (G_TYPE_CHECK_INSTANCE_CAST (message, g_mime_object_get_type (), GMimeObject), _tmp42_);
				_tmp44_ = g_strdup (_tmp43_);
				auth_results = _tmp44_;
				_tmp45_ = auth_results;
				if (_tmp45_ != NULL) {
					const gchar* _tmp46_;
					GearyRFC822AuthenticationResults* _tmp47_;
					_tmp46_ = auth_results;
					_tmp47_ = geary_rf_c822_authentication_results_new (_tmp46_);
					_g_object_unref0 (self->priv->_auth_results);
					self->priv->_auth_results = _tmp47_;
					_g_free0 (auth_results);
					_g_free0 (field);
					break;
				}
				_g_free0 (auth_results);
				_g_free0 (field);
			}
		}
	}
	_tmp48_ = g_mime_object_get_header_list (G_TYPE_CHECK_INSTANCE_CAST (message, g_mime_object_get_type (), GMimeObject));
	_tmp49_ = _g_object_ref0 (_tmp48_);
	headers = _tmp49_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp50_ = FALSE;
			_tmp50_ = TRUE;
			while (TRUE) {
				GMimeHeaderList* _tmp52_;
				GMimeHeader* header = NULL;
				GMimeHeaderList* _tmp53_;
				GMimeHeader* _tmp54_;
				GMimeHeader* _tmp55_;
				GMimeHeader* _tmp56_;
				const gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				GQuark _tmp61_ = 0U;
				static GQuark _tmp60_label0 = 0;
				static GQuark _tmp60_label1 = 0;
				if (!_tmp50_) {
					gint _tmp51_;
					_tmp51_ = i;
					i = _tmp51_ + 1;
				}
				_tmp50_ = FALSE;
				_tmp52_ = headers;
				if (!(i < g_mime_header_list_get_count (_tmp52_))) {
					break;
				}
				_tmp53_ = headers;
				_tmp54_ = g_mime_header_list_get_header_at (_tmp53_, i);
				_tmp55_ = _g_object_ref0 (_tmp54_);
				header = _tmp55_;
				_tmp56_ = header;
				_tmp57_ = g_mime_header_get_name (_tmp56_);
				_tmp58_ = g_utf8_strdown (_tmp57_, (gssize) -1);
				_tmp59_ = _tmp58_;
				_tmp61_ = (NULL == _tmp59_) ? 0 : g_quark_from_string (_tmp59_);
				g_free (_tmp59_);
				if (_tmp61_ == ((0 != _tmp60_label0) ? _tmp60_label0 : (_tmp60_label0 = g_quark_from_static_string ("in-reply-to")))) {
					switch (0) {
						default:
						{
							GearyRFC822MessageIDList* _tmp62_ = NULL;
							GearyRFC822MessageIDList* _tmp63_;
							GMimeHeader* _tmp64_;
							const gchar* _tmp65_;
							GearyRFC822MessageIDList* _tmp66_;
							GearyRFC822MessageIDList* _tmp67_;
							_tmp63_ = self->priv->_in_reply_to;
							_tmp64_ = header;
							_tmp65_ = g_mime_header_get_raw_value (_tmp64_);
							_tmp66_ = geary_rf_c822_message_append_message_id (self, _tmp63_, _tmp65_, &_inner_error0_);
							_tmp62_ = _tmp66_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
									g_propagate_error (error, _inner_error0_);
									_g_object_unref0 (header);
									_g_object_unref0 (headers);
									_g_free0 (message_id);
									_g_free0 (subject);
									_g_object_unref0 (sender);
									_g_object_unref0 (_tmp17_);
									_g_object_unref0 (_tmp13_);
									_g_object_unref0 (_tmp9_);
									_g_object_unref0 (_tmp5_);
									_g_object_unref0 (_tmp1_);
									_g_object_unref0 (self);
									return NULL;
								} else {
									_g_object_unref0 (header);
									_g_object_unref0 (headers);
									_g_free0 (message_id);
									_g_free0 (subject);
									_g_object_unref0 (sender);
									_g_object_unref0 (_tmp17_);
									_g_object_unref0 (_tmp13_);
									_g_object_unref0 (_tmp9_);
									_g_object_unref0 (_tmp5_);
									_g_object_unref0 (_tmp1_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return NULL;
								}
							}
							_tmp67_ = _tmp62_;
							_tmp62_ = NULL;
							_g_object_unref0 (self->priv->_in_reply_to);
							self->priv->_in_reply_to = _tmp67_;
							_g_object_unref0 (_tmp62_);
							break;
						}
					}
				} else if (_tmp61_ == ((0 != _tmp60_label1) ? _tmp60_label1 : (_tmp60_label1 = g_quark_from_static_string ("references")))) {
					switch (0) {
						default:
						{
							GearyRFC822MessageIDList* _tmp68_ = NULL;
							GearyRFC822MessageIDList* _tmp69_;
							GMimeHeader* _tmp70_;
							const gchar* _tmp71_;
							GearyRFC822MessageIDList* _tmp72_;
							GearyRFC822MessageIDList* _tmp73_;
							_tmp69_ = self->priv->_references;
							_tmp70_ = header;
							_tmp71_ = g_mime_header_get_raw_value (_tmp70_);
							_tmp72_ = geary_rf_c822_message_append_message_id (self, _tmp69_, _tmp71_, &_inner_error0_);
							_tmp68_ = _tmp72_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
									g_propagate_error (error, _inner_error0_);
									_g_object_unref0 (header);
									_g_object_unref0 (headers);
									_g_free0 (message_id);
									_g_free0 (subject);
									_g_object_unref0 (sender);
									_g_object_unref0 (_tmp17_);
									_g_object_unref0 (_tmp13_);
									_g_object_unref0 (_tmp9_);
									_g_object_unref0 (_tmp5_);
									_g_object_unref0 (_tmp1_);
									_g_object_unref0 (self);
									return NULL;
								} else {
									_g_object_unref0 (header);
									_g_object_unref0 (headers);
									_g_free0 (message_id);
									_g_free0 (subject);
									_g_object_unref0 (sender);
									_g_object_unref0 (_tmp17_);
									_g_object_unref0 (_tmp13_);
									_g_object_unref0 (_tmp9_);
									_g_object_unref0 (_tmp5_);
									_g_object_unref0 (_tmp1_);
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return NULL;
								}
							}
							_tmp73_ = _tmp68_;
							_tmp68_ = NULL;
							_g_object_unref0 (self->priv->_references);
							self->priv->_references = _tmp73_;
							_g_object_unref0 (_tmp68_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
				_g_object_unref0 (header);
			}
		}
	}
	_tmp74_ = g_mime_object_get_header (G_TYPE_CHECK_INSTANCE_CAST (message, g_mime_object_get_type (), GMimeObject), "X-Mailer");
	geary_rf_c822_message_set_mailer (self, _tmp74_);
	_g_object_unref0 (headers);
	_g_free0 (message_id);
	_g_free0 (subject);
	_g_object_unref0 (sender);
	_g_object_unref0 (_tmp17_);
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
	return self;
}

GearyRFC822Message*
geary_rf_c822_message_new_from_gmime_message (GMimeMessage* message,
                                              GError** error)
{
	return geary_rf_c822_message_construct_from_gmime_message (GEARY_RF_C822_TYPE_MESSAGE, message, error);
}

GearyRFC822Message*
geary_rf_c822_message_construct_from_buffer (GType object_type,
                                             GearyMemoryBuffer* full_email,
                                             GError** error)
{
	GearyRFC822Message * self = NULL;
	GearyRFC822Full* _tmp0_;
	GearyRFC822Full* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_MEMORY_IS_BUFFER (full_email), NULL);
	_tmp0_ = geary_rf_c822_full_new (full_email);
	_tmp1_ = _tmp0_;
	self = (GearyRFC822Message*) geary_rf_c822_message_construct (object_type, _tmp1_, &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	return self;
}

GearyRFC822Message*
geary_rf_c822_message_new_from_buffer (GearyMemoryBuffer* full_email,
                                       GError** error)
{
	return geary_rf_c822_message_construct_from_buffer (GEARY_RF_C822_TYPE_MESSAGE, full_email, error);
}

GearyRFC822Message*
geary_rf_c822_message_construct_from_parts (GType object_type,
                                            GearyRFC822Header* header,
                                            GearyRFC822Text* body,
                                            GError** error)
{
	GearyRFC822Message * self = NULL;
	GMimeStreamCat* stream_cat = NULL;
	GMimeStreamCat* _tmp0_;
	GearyMemoryBuffer* _tmp1_;
	GearyMemoryBuffer* _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	GearyMemoryBuffer* _tmp15_;
	GearyMemoryBuffer* _tmp16_;
	gsize _tmp17_;
	gsize _tmp18_;
	GMimeParser* parser = NULL;
	GMimeStreamCat* _tmp28_;
	GMimeParser* _tmp29_;
	GMimeMessage* message = NULL;
	GMimeParser* _tmp30_;
	GMimeParserOptions* _tmp31_;
	GMimeParserOptions* _tmp32_;
	GMimeMessage* _tmp33_;
	GMimeMessage* _tmp34_;
	GMimeMessage* _tmp35_;
	GMimeMessage* _tmp37_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_RF_C822_IS_HEADER (header), NULL);
	g_return_val_if_fail (GEARY_RF_C822_IS_TEXT (body), NULL);
	_tmp0_ = (GMimeStreamCat*) g_mime_stream_cat_new ();
	stream_cat = _tmp0_;
	_tmp1_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (header, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_memory_buffer_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != ((gsize) 0)) {
		GMimeStreamCat* _tmp5_;
		GearyMemoryBuffer* _tmp6_;
		GearyMemoryBuffer* _tmp7_;
		GBytes* _tmp8_;
		GBytes* _tmp9_;
		gsize _tmp10_ = 0;
		guint8* _tmp11_;
		GMimeStreamMem* _tmp12_;
		GMimeStreamMem* _tmp13_;
		_tmp5_ = stream_cat;
		_tmp6_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (header, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
		_tmp7_ = _tmp6_;
		_tmp8_ = geary_memory_buffer_get_bytes (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp11_ = g_bytes_get_data (_tmp9_, &_tmp10_);
		_tmp12_ = (GMimeStreamMem*) g_mime_stream_mem_new_with_buffer (_tmp11_, _tmp10_);
		_tmp13_ = _tmp12_;
		g_mime_stream_cat_add_source (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_mime_stream_get_type (), GMimeStream));
		_g_object_unref0 (_tmp13_);
		_g_bytes_unref0 (_tmp9_);
	} else {
		GError* _tmp14_;
		_tmp14_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Missing header in RFC 822 message");
		_inner_error0_ = _tmp14_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stream_cat);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (stream_cat);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp15_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (body, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
	_tmp16_ = _tmp15_;
	_tmp17_ = geary_memory_buffer_get_size (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != ((gsize) 0)) {
		GMimeStreamCat* _tmp19_;
		GearyMemoryBuffer* _tmp20_;
		GearyMemoryBuffer* _tmp21_;
		GBytes* _tmp22_;
		GBytes* _tmp23_;
		gsize _tmp24_ = 0;
		guint8* _tmp25_;
		GMimeStreamMem* _tmp26_;
		GMimeStreamMem* _tmp27_;
		_tmp19_ = stream_cat;
		_tmp20_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (body, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
		_tmp21_ = _tmp20_;
		_tmp22_ = geary_memory_buffer_get_bytes (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp25_ = g_bytes_get_data (_tmp23_, &_tmp24_);
		_tmp26_ = (GMimeStreamMem*) g_mime_stream_mem_new_with_buffer (_tmp25_, _tmp24_);
		_tmp27_ = _tmp26_;
		g_mime_stream_cat_add_source (_tmp19_, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, g_mime_stream_get_type (), GMimeStream));
		_g_object_unref0 (_tmp27_);
		_g_bytes_unref0 (_tmp23_);
	}
	_tmp28_ = stream_cat;
	_tmp29_ = g_mime_parser_new_with_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, g_mime_stream_get_type (), GMimeStream));
	parser = _tmp29_;
	_tmp30_ = parser;
	_tmp31_ = geary_rf_c822_get_parser_options ();
	_tmp32_ = _tmp31_;
	_tmp33_ = g_mime_parser_construct_message (_tmp30_, _tmp32_);
	_tmp34_ = _tmp33_;
	__vala_GMimeParserOptions_free0 (_tmp32_);
	message = _tmp34_;
	_tmp35_ = message;
	if (_tmp35_ == NULL) {
		GError* _tmp36_;
		_tmp36_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Unable to parse RFC 822 message");
		_inner_error0_ = _tmp36_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (message);
			_g_object_unref0 (parser);
			_g_object_unref0 (stream_cat);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (message);
			_g_object_unref0 (parser);
			_g_object_unref0 (stream_cat);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp37_ = message;
	self = (GearyRFC822Message*) geary_rf_c822_message_construct_from_gmime_message (object_type, _tmp37_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (message);
			_g_object_unref0 (parser);
			_g_object_unref0 (stream_cat);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (message);
			_g_object_unref0 (parser);
			_g_object_unref0 (stream_cat);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_object_unref0 (message);
	_g_object_unref0 (parser);
	_g_object_unref0 (stream_cat);
	return self;
}

GearyRFC822Message*
geary_rf_c822_message_new_from_parts (GearyRFC822Header* header,
                                      GearyRFC822Text* body,
                                      GError** error)
{
	return geary_rf_c822_message_construct_from_parts (GEARY_RF_C822_TYPE_MESSAGE, header, body, error);
}

static void
geary_rf_c822_message_construct_from_composed_email_data_free (gpointer _data)
{
	GearyRfC822MessageNewFromComposedEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->email);
	_g_free0 (_data_->message_id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyRfC822MessageNewFromComposedEmailData, _data_);
}

void
geary_rf_c822_message_construct_from_composed_email (GType object_type,
                                                     GearyComposedEmail* email,
                                                     const gchar* message_id,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	GearyRfC822MessageNewFromComposedEmailData* _data_;
	GearyComposedEmail* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (email));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyRfC822MessageNewFromComposedEmailData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_rf_c822_message_construct_from_composed_email_data_free);
	_data_->object_type = object_type;
	_tmp0_ = _g_object_ref0 (email);
	_g_object_unref0 (_data_->email);
	_data_->email = _tmp0_;
	_tmp1_ = g_strdup (message_id);
	_g_free0 (_data_->message_id);
	_data_->message_id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_rf_c822_message_construct_from_composed_email_co (_data_);
}

GearyRFC822Message*
geary_rf_c822_message_construct_from_composed_email_finish (GAsyncResult* _res_,
                                                            GError** error)
{
	GearyRFC822Message* result;
	GearyRfC822MessageNewFromComposedEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->self;
	_data_->self = NULL;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
geary_rf_c822_message_new_from_composed_email_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	GearyRfC822MessageNewFromComposedEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_rf_c822_message_construct_from_composed_email_co (_data_);
}

static gboolean
geary_rf_c822_message_construct_from_composed_email_co (GearyRfC822MessageNewFromComposedEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self = (GearyRFC822Message*) geary_base_object_construct (_data_->object_type);
	_data_->_tmp0_ = g_mime_message_new (TRUE);
	_g_object_unref0 (_data_->self->priv->message);
	_data_->self->priv->message = _data_->_tmp0_;
	_data_->_tmp1_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
	_g_object_unref0 (_data_->self->priv->_from);
	_data_->self->priv->_from = _data_->_tmp3_;
	{
		_data_->_tmp4_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_mailbox_list = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->_mailbox_list;
		_data_->_tmp7_ = geary_rf_c822_mailbox_addresses_get_size (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_mailbox_size = _data_->_tmp8_;
		_data_->_mailbox_index = -1;
		while (TRUE) {
			_data_->_mailbox_index = _data_->_mailbox_index + 1;
			_data_->_tmp9_ = _data_->_mailbox_index;
			_data_->_tmp10_ = _data_->_mailbox_size;
			if (!(_data_->_tmp9_ < _data_->_tmp10_)) {
				break;
			}
			_data_->_tmp11_ = _data_->_mailbox_list;
			_data_->_tmp12_ = geary_rf_c822_mailbox_addresses_get (_data_->_tmp11_, _data_->_mailbox_index);
			_data_->mailbox = _data_->_tmp12_;
			_data_->_tmp13_ = _data_->self->priv->message;
			_data_->_tmp14_ = _data_->mailbox;
			_data_->_tmp15_ = geary_rf_c822_mailbox_address_get_name (_data_->_tmp14_);
			_data_->_tmp16_ = _data_->_tmp15_;
			_data_->_tmp17_ = _data_->mailbox;
			_data_->_tmp18_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			g_mime_message_add_mailbox (_data_->_tmp13_, GMIME_ADDRESS_TYPE_FROM, _data_->_tmp16_, _data_->_tmp19_);
			_g_object_unref0 (_data_->mailbox);
		}
	}
	_data_->_tmp20_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = _g_object_ref0 (_data_->_tmp21_);
	_g_object_unref0 (_data_->self->priv->_date);
	_data_->self->priv->_date = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->self->priv->message;
	_data_->_tmp24_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = geary_rf_c822_date_get_value (_data_->_tmp25_);
	_data_->_tmp27_ = _data_->_tmp26_;
	g_mime_message_set_date (_data_->_tmp23_, _data_->_tmp27_);
	_data_->_tmp28_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp29_ = _data_->_tmp28_;
	if (_data_->_tmp29_ != NULL) {
		_data_->_tmp30_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp31_ = _data_->_tmp30_;
		_data_->_tmp32_ = _g_object_ref0 (_data_->_tmp31_);
		_g_object_unref0 (_data_->self->priv->_to);
		_data_->self->priv->_to = _data_->_tmp32_;
		{
			_data_->_tmp33_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_data_->_tmp34_ = _data_->_tmp33_;
			_data_->_vala1__mailbox_list = _data_->_tmp34_;
			_data_->_tmp35_ = _data_->_vala1__mailbox_list;
			_data_->_tmp36_ = geary_rf_c822_mailbox_addresses_get_size (_data_->_tmp35_);
			_data_->_tmp37_ = _data_->_tmp36_;
			_data_->_vala1__mailbox_size = _data_->_tmp37_;
			_data_->_vala1__mailbox_index = -1;
			while (TRUE) {
				_data_->_vala1__mailbox_index = _data_->_vala1__mailbox_index + 1;
				_data_->_tmp38_ = _data_->_vala1__mailbox_index;
				_data_->_tmp39_ = _data_->_vala1__mailbox_size;
				if (!(_data_->_tmp38_ < _data_->_tmp39_)) {
					break;
				}
				_data_->_tmp40_ = _data_->_vala1__mailbox_list;
				_data_->_tmp41_ = geary_rf_c822_mailbox_addresses_get (_data_->_tmp40_, _data_->_vala1__mailbox_index);
				_data_->_vala1_mailbox = _data_->_tmp41_;
				_data_->_tmp42_ = _data_->self->priv->message;
				_data_->_tmp43_ = _data_->_vala1_mailbox;
				_data_->_tmp44_ = geary_rf_c822_mailbox_address_get_name (_data_->_tmp43_);
				_data_->_tmp45_ = _data_->_tmp44_;
				_data_->_tmp46_ = _data_->_vala1_mailbox;
				_data_->_tmp47_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp46_);
				_data_->_tmp48_ = _data_->_tmp47_;
				g_mime_message_add_mailbox (_data_->_tmp42_, GMIME_ADDRESS_TYPE_TO, _data_->_tmp45_, _data_->_tmp48_);
				_g_object_unref0 (_data_->_vala1_mailbox);
			}
		}
	}
	_data_->_tmp49_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp50_ = _data_->_tmp49_;
	if (_data_->_tmp50_ != NULL) {
		_data_->_tmp51_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp52_ = _data_->_tmp51_;
		_data_->_tmp53_ = _g_object_ref0 (_data_->_tmp52_);
		_g_object_unref0 (_data_->self->priv->_cc);
		_data_->self->priv->_cc = _data_->_tmp53_;
		{
			_data_->_tmp54_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_data_->_tmp55_ = _data_->_tmp54_;
			_data_->_vala2__mailbox_list = _data_->_tmp55_;
			_data_->_tmp56_ = _data_->_vala2__mailbox_list;
			_data_->_tmp57_ = geary_rf_c822_mailbox_addresses_get_size (_data_->_tmp56_);
			_data_->_tmp58_ = _data_->_tmp57_;
			_data_->_vala2__mailbox_size = _data_->_tmp58_;
			_data_->_vala2__mailbox_index = -1;
			while (TRUE) {
				_data_->_vala2__mailbox_index = _data_->_vala2__mailbox_index + 1;
				_data_->_tmp59_ = _data_->_vala2__mailbox_index;
				_data_->_tmp60_ = _data_->_vala2__mailbox_size;
				if (!(_data_->_tmp59_ < _data_->_tmp60_)) {
					break;
				}
				_data_->_tmp61_ = _data_->_vala2__mailbox_list;
				_data_->_tmp62_ = geary_rf_c822_mailbox_addresses_get (_data_->_tmp61_, _data_->_vala2__mailbox_index);
				_data_->_vala2_mailbox = _data_->_tmp62_;
				_data_->_tmp63_ = _data_->self->priv->message;
				_data_->_tmp64_ = _data_->_vala2_mailbox;
				_data_->_tmp65_ = geary_rf_c822_mailbox_address_get_name (_data_->_tmp64_);
				_data_->_tmp66_ = _data_->_tmp65_;
				_data_->_tmp67_ = _data_->_vala2_mailbox;
				_data_->_tmp68_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp67_);
				_data_->_tmp69_ = _data_->_tmp68_;
				g_mime_message_add_mailbox (_data_->_tmp63_, GMIME_ADDRESS_TYPE_CC, _data_->_tmp66_, _data_->_tmp69_);
				_g_object_unref0 (_data_->_vala2_mailbox);
			}
		}
	}
	_data_->_tmp70_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp71_ = _data_->_tmp70_;
	if (_data_->_tmp71_ != NULL) {
		_data_->_tmp72_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp73_ = _data_->_tmp72_;
		_data_->_tmp74_ = _g_object_ref0 (_data_->_tmp73_);
		_g_object_unref0 (_data_->self->priv->_bcc);
		_data_->self->priv->_bcc = _data_->_tmp74_;
		{
			_data_->_tmp75_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_data_->_tmp76_ = _data_->_tmp75_;
			_data_->_vala3__mailbox_list = _data_->_tmp76_;
			_data_->_tmp77_ = _data_->_vala3__mailbox_list;
			_data_->_tmp78_ = geary_rf_c822_mailbox_addresses_get_size (_data_->_tmp77_);
			_data_->_tmp79_ = _data_->_tmp78_;
			_data_->_vala3__mailbox_size = _data_->_tmp79_;
			_data_->_vala3__mailbox_index = -1;
			while (TRUE) {
				_data_->_vala3__mailbox_index = _data_->_vala3__mailbox_index + 1;
				_data_->_tmp80_ = _data_->_vala3__mailbox_index;
				_data_->_tmp81_ = _data_->_vala3__mailbox_size;
				if (!(_data_->_tmp80_ < _data_->_tmp81_)) {
					break;
				}
				_data_->_tmp82_ = _data_->_vala3__mailbox_list;
				_data_->_tmp83_ = geary_rf_c822_mailbox_addresses_get (_data_->_tmp82_, _data_->_vala3__mailbox_index);
				_data_->_vala3_mailbox = _data_->_tmp83_;
				_data_->_tmp84_ = _data_->self->priv->message;
				_data_->_tmp85_ = _data_->_vala3_mailbox;
				_data_->_tmp86_ = geary_rf_c822_mailbox_address_get_name (_data_->_tmp85_);
				_data_->_tmp87_ = _data_->_tmp86_;
				_data_->_tmp88_ = _data_->_vala3_mailbox;
				_data_->_tmp89_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp88_);
				_data_->_tmp90_ = _data_->_tmp89_;
				g_mime_message_add_mailbox (_data_->_tmp84_, GMIME_ADDRESS_TYPE_BCC, _data_->_tmp87_, _data_->_tmp90_);
				_g_object_unref0 (_data_->_vala3_mailbox);
			}
		}
	}
	_data_->_tmp91_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp92_ = _data_->_tmp91_;
	if (_data_->_tmp92_ != NULL) {
		_data_->_tmp93_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp94_ = _data_->_tmp93_;
		_data_->_tmp95_ = _g_object_ref0 (_data_->_tmp94_);
		_g_object_unref0 (_data_->self->priv->_sender);
		_data_->self->priv->_sender = _data_->_tmp95_;
		_data_->_tmp96_ = _data_->self->priv->message;
		_data_->_tmp97_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp98_ = _data_->_tmp97_;
		_data_->_tmp99_ = geary_rf_c822_mailbox_address_get_name (_data_->_tmp98_);
		_data_->_tmp100_ = _data_->_tmp99_;
		_data_->_tmp101_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp102_ = _data_->_tmp101_;
		_data_->_tmp103_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp102_);
		_data_->_tmp104_ = _data_->_tmp103_;
		g_mime_message_add_mailbox (_data_->_tmp96_, GMIME_ADDRESS_TYPE_SENDER, _data_->_tmp100_, _data_->_tmp104_);
	}
	_data_->_tmp105_ = geary_email_header_set_get_reply_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp106_ = _data_->_tmp105_;
	if (_data_->_tmp106_ != NULL) {
		_data_->_tmp107_ = geary_email_header_set_get_reply_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp108_ = _data_->_tmp107_;
		_data_->_tmp109_ = _g_object_ref0 (_data_->_tmp108_);
		_g_object_unref0 (_data_->self->priv->_reply_to);
		_data_->self->priv->_reply_to = _data_->_tmp109_;
		{
			_data_->_tmp110_ = geary_email_header_set_get_reply_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_data_->_tmp111_ = _data_->_tmp110_;
			_data_->_vala4__mailbox_list = _data_->_tmp111_;
			_data_->_tmp112_ = _data_->_vala4__mailbox_list;
			_data_->_tmp113_ = geary_rf_c822_mailbox_addresses_get_size (_data_->_tmp112_);
			_data_->_tmp114_ = _data_->_tmp113_;
			_data_->_vala4__mailbox_size = _data_->_tmp114_;
			_data_->_vala4__mailbox_index = -1;
			while (TRUE) {
				_data_->_vala4__mailbox_index = _data_->_vala4__mailbox_index + 1;
				_data_->_tmp115_ = _data_->_vala4__mailbox_index;
				_data_->_tmp116_ = _data_->_vala4__mailbox_size;
				if (!(_data_->_tmp115_ < _data_->_tmp116_)) {
					break;
				}
				_data_->_tmp117_ = _data_->_vala4__mailbox_list;
				_data_->_tmp118_ = geary_rf_c822_mailbox_addresses_get (_data_->_tmp117_, _data_->_vala4__mailbox_index);
				_data_->_vala4_mailbox = _data_->_tmp118_;
				_data_->_tmp119_ = _data_->self->priv->message;
				_data_->_tmp120_ = _data_->_vala4_mailbox;
				_data_->_tmp121_ = geary_rf_c822_mailbox_address_get_name (_data_->_tmp120_);
				_data_->_tmp122_ = _data_->_tmp121_;
				_data_->_tmp123_ = _data_->_vala4_mailbox;
				_data_->_tmp124_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp123_);
				_data_->_tmp125_ = _data_->_tmp124_;
				g_mime_message_add_mailbox (_data_->_tmp119_, GMIME_ADDRESS_TYPE_REPLY_TO, _data_->_tmp122_, _data_->_tmp125_);
				_g_object_unref0 (_data_->_vala4_mailbox);
			}
		}
	}
	if (_data_->message_id != NULL) {
		_data_->_tmp126_ = geary_rf_c822_message_id_new (_data_->message_id);
		_g_object_unref0 (_data_->self->priv->_message_id);
		_data_->self->priv->_message_id = _data_->_tmp126_;
		_data_->_tmp127_ = _data_->self->priv->message;
		g_mime_message_set_message_id (_data_->_tmp127_, _data_->message_id);
	}
	_data_->_tmp128_ = geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp129_ = _data_->_tmp128_;
	if (_data_->_tmp129_ != NULL) {
		_data_->_tmp130_ = geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp131_ = _data_->_tmp130_;
		_data_->_tmp132_ = _g_object_ref0 (_data_->_tmp131_);
		_g_object_unref0 (_data_->self->priv->_in_reply_to);
		_data_->self->priv->_in_reply_to = _data_->_tmp132_;
		_data_->_tmp133_ = _data_->self->priv->message;
		_data_->_tmp134_ = geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp135_ = _data_->_tmp134_;
		_data_->_tmp136_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp135_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
		_data_->_tmp137_ = _data_->_tmp136_;
		_data_->_tmp138_ = geary_rf_c822_get_charset ();
		_data_->_tmp139_ = _data_->_tmp138_;
		g_mime_object_set_header (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp133_, g_mime_object_get_type (), GMimeObject), GEARY_RF_C822_MESSAGE_HEADER_IN_REPLY_TO, _data_->_tmp137_, _data_->_tmp139_);
		_g_free0 (_data_->_tmp139_);
		_g_free0 (_data_->_tmp137_);
	}
	_data_->_tmp140_ = geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp141_ = _data_->_tmp140_;
	if (_data_->_tmp141_ != NULL) {
		_data_->_tmp142_ = geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp143_ = _data_->_tmp142_;
		_data_->_tmp144_ = _g_object_ref0 (_data_->_tmp143_);
		_g_object_unref0 (_data_->self->priv->_references);
		_data_->self->priv->_references = _data_->_tmp144_;
		_data_->_tmp145_ = _data_->self->priv->message;
		_data_->_tmp146_ = geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp147_ = _data_->_tmp146_;
		_data_->_tmp148_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp147_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
		_data_->_tmp149_ = _data_->_tmp148_;
		_data_->_tmp150_ = geary_rf_c822_get_charset ();
		_data_->_tmp151_ = _data_->_tmp150_;
		g_mime_object_set_header (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp145_, g_mime_object_get_type (), GMimeObject), GEARY_RF_C822_MESSAGE_HEADER_REFERENCES, _data_->_tmp149_, _data_->_tmp151_);
		_g_free0 (_data_->_tmp151_);
		_g_free0 (_data_->_tmp149_);
	}
	_data_->_tmp152_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp153_ = _data_->_tmp152_;
	if (_data_->_tmp153_ != NULL) {
		_data_->_tmp154_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp155_ = _data_->_tmp154_;
		_data_->_tmp156_ = _g_object_ref0 (_data_->_tmp155_);
		_g_object_unref0 (_data_->self->priv->_subject);
		_data_->self->priv->_subject = _data_->_tmp156_;
		_data_->_tmp157_ = _data_->self->priv->message;
		_data_->_tmp158_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp159_ = _data_->_tmp158_;
		_data_->_tmp160_ = geary_message_data_string_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp159_, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
		_data_->_tmp161_ = _data_->_tmp160_;
		_data_->_tmp162_ = geary_rf_c822_get_charset ();
		_data_->_tmp163_ = _data_->_tmp162_;
		g_mime_message_set_subject (_data_->_tmp157_, _data_->_tmp161_, _data_->_tmp163_);
		_g_free0 (_data_->_tmp163_);
	}
	_data_->_tmp164_ = geary_composed_email_get_mailer (_data_->email);
	_data_->_tmp165_ = _data_->_tmp164_;
	if (!geary_string_is_empty (_data_->_tmp165_)) {
		_data_->_tmp166_ = geary_composed_email_get_mailer (_data_->email);
		_data_->_tmp167_ = _data_->_tmp166_;
		geary_rf_c822_message_set_mailer (_data_->self, _data_->_tmp167_);
		_data_->_tmp168_ = _data_->self->priv->message;
		_data_->_tmp169_ = geary_composed_email_get_mailer (_data_->email);
		_data_->_tmp170_ = _data_->_tmp169_;
		_data_->_tmp171_ = geary_rf_c822_get_charset ();
		_data_->_tmp172_ = _data_->_tmp171_;
		g_mime_object_set_header (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp168_, g_mime_object_get_type (), GMimeObject), GEARY_RF_C822_MESSAGE_HEADER_MAILER, _data_->_tmp170_, _data_->_tmp172_);
		_g_free0 (_data_->_tmp172_);
	}
	_data_->_tmp173_ = gee_linked_list_new (g_mime_object_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->body_parts = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp173_, GEE_TYPE_LIST, GeeList);
	_data_->body_charset = NULL;
	_data_->_tmp174_ = geary_composed_email_get_body_text (_data_->email);
	_data_->_tmp175_ = _data_->_tmp174_;
	if (_data_->_tmp175_ != NULL) {
		_data_->body_text = NULL;
		{
			_data_->_tmp177_ = geary_composed_email_get_body_text (_data_->email);
			_data_->_tmp178_ = _data_->_tmp177_;
			_data_->_tmp180_ = 0;
			_data_->_tmp179_ = string_get_data (_data_->_tmp178_, &_data_->_tmp180_);
			_data_->_tmp179__length1 = _data_->_tmp180_;
			_data_->_tmp181_ = _data_->_tmp179_;
			_data_->_tmp181__length1 = _data_->_tmp179__length1;
			_data_->_state_ = 1;
			geary_rf_c822_message_body_data_to_part (_data_->self, _data_->_tmp181_, (gint) _data_->_tmp181__length1, NULL, "text/plain", TRUE, _data_->cancellable, geary_rf_c822_message_new_from_composed_email_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp182_ = geary_rf_c822_message_body_data_to_part_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp176_ = _data_->_tmp182_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp183_ = _data_->_tmp176_;
			_data_->_tmp176_ = NULL;
			_g_object_unref0 (_data_->body_text);
			_data_->body_text = _data_->_tmp183_;
			_g_object_unref0 (_data_->_tmp176_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp184_ = _data_->err;
			_data_->_tmp185_ = _data_->_tmp184_->message;
			g_warning ("rfc822-message.vala:344: Error creating text body part: %s", _data_->_tmp185_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->body_text);
				_g_free0 (_data_->body_charset);
				_g_object_unref0 (_data_->body_parts);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->body_text);
				_g_free0 (_data_->body_charset);
				_g_object_unref0 (_data_->body_parts);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				return NULL;
			}
		}
		_data_->_tmp186_ = _data_->body_text;
		if (_data_->_tmp186_ != NULL) {
			_data_->_tmp187_ = _data_->body_text;
			_data_->_tmp188_ = g_mime_object_get_content_type (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp187_, g_mime_object_get_type (), GMimeObject));
			_data_->_tmp189_ = g_mime_content_type_get_parameter (_data_->_tmp188_, "charset");
			_data_->_tmp190_ = g_strdup (_data_->_tmp189_);
			_g_free0 (_data_->body_charset);
			_data_->body_charset = _data_->_tmp190_;
			_data_->_tmp191_ = _data_->body_parts;
			_data_->_tmp192_ = _data_->body_text;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp191_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp192_, g_mime_object_get_type (), GMimeObject));
		}
		_g_object_unref0 (_data_->body_text);
	}
	_data_->_tmp193_ = geary_composed_email_get_body_html (_data_->email);
	_data_->_tmp194_ = _data_->_tmp193_;
	if (_data_->_tmp194_ != NULL) {
		static const char CID_URL_PREFIX[] = "cid:";
		_data_->_tmp195_ = gee_linked_list_new (g_mime_object_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_data_->related_parts = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp195_, GEE_TYPE_LIST, GeeList);
		_data_->_tmp196_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEARY_MEMORY_TYPE_BUFFER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->inline_files = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp196_, GEE_TYPE_MAP, GeeMap);
		_data_->_tmp197_ = _data_->inline_files;
		_data_->_tmp198_ = geary_composed_email_get_inline_files (_data_->email);
		_data_->_tmp199_ = _data_->_tmp198_;
		gee_map_set_all (_data_->_tmp197_, _data_->_tmp199_);
		{
			_data_->_tmp200_ = geary_composed_email_get_cid_files (_data_->email);
			_data_->_tmp201_ = _data_->_tmp200_;
			_data_->_tmp202_ = gee_map_get_keys (_data_->_tmp201_);
			_data_->_tmp203_ = _data_->_tmp202_;
			_data_->_tmp204_ = _data_->_tmp203_;
			_data_->_tmp205_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp204_, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_tmp206_ = _data_->_tmp205_;
			_g_object_unref0 (_data_->_tmp204_);
			_data_->_cid_it = _data_->_tmp206_;
			while (TRUE) {
				_data_->_tmp207_ = _data_->_cid_it;
				if (!gee_iterator_next (_data_->_tmp207_)) {
					break;
				}
				_data_->_tmp208_ = _data_->_cid_it;
				_data_->_tmp209_ = gee_iterator_get (_data_->_tmp208_);
				_data_->cid = (gchar*) _data_->_tmp209_;
				_data_->_tmp210_ = _data_->cid;
				_data_->_tmp211_ = g_strconcat (CID_URL_PREFIX, _data_->_tmp210_, NULL);
				_data_->_tmp212_ = _data_->_tmp211_;
				_data_->_tmp213_ = geary_composed_email_contains_inline_img_src (_data_->email, _data_->_tmp212_);
				_g_free0 (_data_->_tmp212_);
				if (_data_->_tmp213_) {
					_data_->inline_part = NULL;
					{
						_data_->_tmp215_ = geary_composed_email_get_cid_files (_data_->email);
						_data_->_tmp216_ = _data_->_tmp215_;
						_data_->_tmp217_ = _data_->cid;
						_data_->_tmp218_ = gee_map_get (_data_->_tmp216_, _data_->_tmp217_);
						_data_->_tmp219_ = (GearyMemoryBuffer*) _data_->_tmp218_;
						_data_->_tmp220_ = _data_->cid;
						_data_->_tmp221_ = g_path_get_basename (_data_->_tmp220_);
						_data_->_tmp222_ = _data_->_tmp221_;
						_data_->_state_ = 2;
						geary_rf_c822_message_get_buffer_part (_data_->self, _data_->_tmp219_, _data_->_tmp222_, GEARY_MIME_DISPOSITION_TYPE_INLINE, _data_->cancellable, geary_rf_c822_message_new_from_composed_email_ready, _data_);
						return FALSE;
						_state_2:
						_data_->_tmp223_ = geary_rf_c822_message_get_buffer_part_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
						_data_->_tmp224_ = _data_->_tmp223_;
						_g_free0 (_data_->_tmp222_);
						_g_object_unref0 (_data_->_tmp219_);
						_data_->_tmp214_ = _data_->_tmp224_;
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
						_data_->_tmp225_ = _data_->_tmp214_;
						_data_->_tmp214_ = NULL;
						_g_object_unref0 (_data_->inline_part);
						_data_->inline_part = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp225_, g_mime_object_get_type (), GMimeObject);
						_g_object_unref0 (_data_->_tmp214_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						_data_->_vala1_err = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp226_ = _data_->cid;
						_data_->_tmp227_ = _data_->_vala1_err;
						_data_->_tmp228_ = _data_->_tmp227_->message;
						g_warning ("rfc822-message.vala:382: Error creating CID part %s: %s", _data_->_tmp226_, _data_->_tmp228_);
						_g_error_free0 (_data_->_vala1_err);
					}
					__finally1:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						if (_data_->_inner_error0_->domain == GEARY_RF_C822_ERROR) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_g_object_unref0 (_data_->inline_part);
							_g_free0 (_data_->cid);
							_g_object_unref0 (_data_->_cid_it);
							_g_object_unref0 (_data_->inline_files);
							_g_object_unref0 (_data_->related_parts);
							_g_free0 (_data_->body_charset);
							_g_object_unref0 (_data_->body_parts);
							g_object_unref (_data_->_async_result);
							return FALSE;
						} else {
							_g_object_unref0 (_data_->inline_part);
							_g_free0 (_data_->cid);
							_g_object_unref0 (_data_->_cid_it);
							_g_object_unref0 (_data_->inline_files);
							_g_object_unref0 (_data_->related_parts);
							_g_free0 (_data_->body_charset);
							_g_object_unref0 (_data_->body_parts);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
							g_clear_error (&_data_->_inner_error0_);
							return NULL;
						}
					}
					_data_->_tmp229_ = _data_->inline_part;
					if (_data_->_tmp229_ != NULL) {
						_data_->_tmp230_ = _data_->inline_part;
						_data_->_tmp231_ = _data_->cid;
						g_mime_object_set_content_id (_data_->_tmp230_, _data_->_tmp231_);
						_data_->_tmp232_ = _data_->related_parts;
						_data_->_tmp233_ = _data_->inline_part;
						gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp232_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp233_);
					}
					_data_->_tmp234_ = _data_->inline_files;
					_data_->_tmp235_ = _data_->cid;
					gee_map_unset (_data_->_tmp234_, _data_->_tmp235_, NULL);
					_g_object_unref0 (_data_->inline_part);
				}
				_g_free0 (_data_->cid);
			}
			_g_object_unref0 (_data_->_cid_it);
		}
		_data_->_tmp236_ = _data_->inline_files;
		_data_->_tmp237_ = gee_map_get_is_empty (_data_->_tmp236_);
		_data_->_tmp238_ = _data_->_tmp237_;
		if (!_data_->_tmp238_) {
			static const char CID_TEMPLATE[] = "inline_%02u@geary";
			_data_->cid_index = (guint) 0;
			{
				_data_->_tmp239_ = _data_->inline_files;
				_data_->_tmp240_ = gee_map_get_keys (_data_->_tmp239_);
				_data_->_tmp241_ = _data_->_tmp240_;
				_data_->_tmp242_ = _data_->_tmp241_;
				_data_->_tmp243_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp242_, GEE_TYPE_ITERABLE, GeeIterable));
				_data_->_tmp244_ = _data_->_tmp243_;
				_g_object_unref0 (_data_->_tmp242_);
				_data_->_name_it = _data_->_tmp244_;
				while (TRUE) {
					_data_->_tmp245_ = _data_->_name_it;
					if (!gee_iterator_next (_data_->_tmp245_)) {
						break;
					}
					_data_->_tmp246_ = _data_->_name_it;
					_data_->_tmp247_ = gee_iterator_get (_data_->_tmp246_);
					_data_->name = (gchar*) _data_->_tmp247_;
					_data_->_tmp248_ = g_strdup ("");
					_data_->_vala1_cid = _data_->_tmp248_;
					{
						_data_->_tmp249_ = TRUE;
						while (TRUE) {
							if (!_data_->_tmp249_) {
								_data_->_tmp250_ = geary_composed_email_get_cid_files (_data_->email);
								_data_->_tmp251_ = _data_->_tmp250_;
								_data_->_tmp252_ = _data_->_vala1_cid;
								if (!gee_map_has_key (_data_->_tmp251_, _data_->_tmp252_)) {
									break;
								}
							}
							_data_->_tmp249_ = FALSE;
							_data_->_tmp253_ = _data_->cid_index;
							_data_->cid_index = _data_->_tmp253_ + 1;
							_data_->_tmp254_ = g_strdup_printf (CID_TEMPLATE, _data_->_tmp253_);
							_g_free0 (_data_->_vala1_cid);
							_data_->_vala1_cid = _data_->_tmp254_;
						}
					}
					_data_->_tmp255_ = _data_->name;
					_data_->_tmp256_ = _data_->_vala1_cid;
					_data_->_tmp257_ = g_strconcat (CID_URL_PREFIX, _data_->_tmp256_, NULL);
					_data_->_tmp258_ = _data_->_tmp257_;
					_data_->_tmp259_ = geary_composed_email_replace_inline_img_src (_data_->email, _data_->_tmp255_, _data_->_tmp258_);
					_g_free0 (_data_->_tmp258_);
					if (_data_->_tmp259_) {
						_data_->_vala1_inline_part = NULL;
						{
							_data_->_tmp261_ = _data_->inline_files;
							_data_->_tmp262_ = _data_->name;
							_data_->_tmp263_ = gee_map_get (_data_->_tmp261_, _data_->_tmp262_);
							_data_->_tmp264_ = (GearyMemoryBuffer*) _data_->_tmp263_;
							_data_->_tmp265_ = _data_->name;
							_data_->_tmp266_ = g_path_get_basename (_data_->_tmp265_);
							_data_->_tmp267_ = _data_->_tmp266_;
							_data_->_state_ = 3;
							geary_rf_c822_message_get_buffer_part (_data_->self, _data_->_tmp264_, _data_->_tmp267_, GEARY_MIME_DISPOSITION_TYPE_INLINE, _data_->cancellable, geary_rf_c822_message_new_from_composed_email_ready, _data_);
							return FALSE;
							_state_3:
							_data_->_tmp268_ = geary_rf_c822_message_get_buffer_part_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
							_data_->_tmp269_ = _data_->_tmp268_;
							_g_free0 (_data_->_tmp267_);
							_g_object_unref0 (_data_->_tmp264_);
							_data_->_tmp260_ = _data_->_tmp269_;
							if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
								goto __catch2_g_error;
							}
							_data_->_tmp270_ = _data_->_tmp260_;
							_data_->_tmp260_ = NULL;
							_g_object_unref0 (_data_->_vala1_inline_part);
							_data_->_vala1_inline_part = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp270_, g_mime_object_get_type (), GMimeObject);
							_g_object_unref0 (_data_->_tmp260_);
						}
						goto __finally2;
						__catch2_g_error:
						{
							_data_->_vala2_err = _data_->_inner_error0_;
							_data_->_inner_error0_ = NULL;
							_data_->_tmp271_ = _data_->name;
							_data_->_tmp272_ = _data_->_vala2_err;
							_data_->_tmp273_ = _data_->_tmp272_->message;
							g_warning ("rfc822-message.vala:420: Error creating inline file part %s: %s", _data_->_tmp271_, _data_->_tmp273_);
							_g_error_free0 (_data_->_vala2_err);
						}
						__finally2:
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							if (_data_->_inner_error0_->domain == GEARY_RF_C822_ERROR) {
								g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
								_g_object_unref0 (_data_->_vala1_inline_part);
								_g_free0 (_data_->_vala1_cid);
								_g_free0 (_data_->name);
								_g_object_unref0 (_data_->_name_it);
								_g_object_unref0 (_data_->inline_files);
								_g_object_unref0 (_data_->related_parts);
								_g_free0 (_data_->body_charset);
								_g_object_unref0 (_data_->body_parts);
								g_object_unref (_data_->_async_result);
								return FALSE;
							} else {
								_g_object_unref0 (_data_->_vala1_inline_part);
								_g_free0 (_data_->_vala1_cid);
								_g_free0 (_data_->name);
								_g_object_unref0 (_data_->_name_it);
								_g_object_unref0 (_data_->inline_files);
								_g_object_unref0 (_data_->related_parts);
								_g_free0 (_data_->body_charset);
								_g_object_unref0 (_data_->body_parts);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
								g_clear_error (&_data_->_inner_error0_);
								return NULL;
							}
						}
						_data_->_tmp274_ = _data_->_vala1_inline_part;
						if (_data_->_tmp274_ != NULL) {
							_data_->_tmp275_ = _data_->_vala1_inline_part;
							_data_->_tmp276_ = _data_->_vala1_cid;
							g_mime_object_set_content_id (_data_->_tmp275_, _data_->_tmp276_);
							_data_->_tmp277_ = _data_->related_parts;
							_data_->_tmp278_ = _data_->_vala1_inline_part;
							gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp277_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp278_);
						}
						_g_object_unref0 (_data_->_vala1_inline_part);
					}
					_g_free0 (_data_->_vala1_cid);
					_g_free0 (_data_->name);
				}
				_g_object_unref0 (_data_->_name_it);
			}
		}
		_data_->body_html = NULL;
		{
			_data_->_tmp280_ = geary_composed_email_get_body_html (_data_->email);
			_data_->_tmp281_ = _data_->_tmp280_;
			_data_->_tmp283_ = 0;
			_data_->_tmp282_ = string_get_data (_data_->_tmp281_, &_data_->_tmp283_);
			_data_->_tmp282__length1 = _data_->_tmp283_;
			_data_->_tmp284_ = _data_->_tmp282_;
			_data_->_tmp284__length1 = _data_->_tmp282__length1;
			_data_->_tmp285_ = _data_->body_charset;
			_data_->_state_ = 4;
			geary_rf_c822_message_body_data_to_part (_data_->self, _data_->_tmp284_, (gint) _data_->_tmp284__length1, _data_->_tmp285_, "text/html", FALSE, _data_->cancellable, geary_rf_c822_message_new_from_composed_email_ready, _data_);
			return FALSE;
			_state_4:
			_data_->_tmp286_ = geary_rf_c822_message_body_data_to_part_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp279_ = _data_->_tmp286_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			_data_->_tmp287_ = _data_->_tmp279_;
			_data_->_tmp279_ = NULL;
			_g_object_unref0 (_data_->body_html);
			_data_->body_html = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp287_, g_mime_object_get_type (), GMimeObject);
			_g_object_unref0 (_data_->_tmp279_);
		}
		goto __finally3;
		__catch3_g_error:
		{
			_data_->_vala3_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp288_ = _data_->_vala3_err;
			_data_->_tmp289_ = _data_->_tmp288_->message;
			g_warning ("rfc822-message.vala:444: Error creating html body part: %s", _data_->_tmp289_);
			_g_error_free0 (_data_->_vala3_err);
		}
		__finally3:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (_data_->_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->body_html);
				_g_object_unref0 (_data_->inline_files);
				_g_object_unref0 (_data_->related_parts);
				_g_free0 (_data_->body_charset);
				_g_object_unref0 (_data_->body_parts);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->body_html);
				_g_object_unref0 (_data_->inline_files);
				_g_object_unref0 (_data_->related_parts);
				_g_free0 (_data_->body_charset);
				_g_object_unref0 (_data_->body_parts);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				return NULL;
			}
		}
		_data_->_tmp290_ = _data_->related_parts;
		_data_->_tmp291_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp290_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp292_ = _data_->_tmp291_;
		if (!_data_->_tmp292_) {
			_data_->_tmp293_ = _data_->related_parts;
			_data_->_tmp294_ = _data_->body_html;
			gee_list_insert (_data_->_tmp293_, 0, _data_->_tmp294_);
			_data_->_tmp295_ = _data_->related_parts;
			_data_->_tmp296_ = geary_rf_c822_message_coalesce_related (_data_->self, _data_->_tmp295_, "text/html");
			_data_->related_part = _data_->_tmp296_;
			_data_->_tmp297_ = _data_->related_part;
			if (_data_->_tmp297_ != NULL) {
				_data_->_tmp298_ = _data_->related_part;
				_data_->_tmp299_ = _g_object_ref0 (_data_->_tmp298_);
				_g_object_unref0 (_data_->body_html);
				_data_->body_html = _data_->_tmp299_;
			}
			_g_object_unref0 (_data_->related_part);
		}
		_data_->_tmp300_ = _data_->body_parts;
		_data_->_tmp301_ = _data_->body_html;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp300_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp301_);
		_g_object_unref0 (_data_->body_html);
		_g_object_unref0 (_data_->inline_files);
		_g_object_unref0 (_data_->related_parts);
	}
	_data_->_tmp302_ = gee_linked_list_new (g_mime_object_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->main_parts = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp302_, GEE_TYPE_LIST, GeeList);
	_data_->_tmp303_ = _data_->body_parts;
	_data_->_tmp304_ = geary_rf_c822_message_coalesce_parts (_data_->self, _data_->_tmp303_, "alternative");
	_data_->body_part = _data_->_tmp304_;
	_data_->_tmp305_ = _data_->body_part;
	if (_data_->_tmp305_ != NULL) {
		_data_->_tmp306_ = _data_->main_parts;
		_data_->_tmp307_ = _data_->body_part;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp306_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp307_);
	}
	_data_->_tmp308_ = gee_linked_list_new (g_mime_object_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data_->attachment_parts = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp308_, GEE_TYPE_LIST, GeeList);
	{
		_data_->_tmp309_ = geary_composed_email_get_attached_files (_data_->email);
		_data_->_tmp310_ = _data_->_tmp309_;
		_data_->_tmp311_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp310_, GEE_TYPE_ITERABLE, GeeIterable));
		_data_->_file_it = _data_->_tmp311_;
		while (TRUE) {
			_data_->_tmp312_ = _data_->_file_it;
			if (!gee_iterator_next (_data_->_tmp312_)) {
				break;
			}
			_data_->_tmp313_ = _data_->_file_it;
			_data_->_tmp314_ = gee_iterator_get (_data_->_tmp313_);
			_data_->file = (GFile*) _data_->_tmp314_;
			_data_->attachment_part = NULL;
			{
				_data_->_tmp316_ = _data_->file;
				_data_->_state_ = 5;
				geary_rf_c822_message_get_file_part (_data_->self, _data_->_tmp316_, GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT, _data_->cancellable, geary_rf_c822_message_new_from_composed_email_ready, _data_);
				return FALSE;
				_state_5:
				_data_->_tmp317_ = geary_rf_c822_message_get_file_part_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp315_ = _data_->_tmp317_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch4_g_error;
				}
				_data_->_tmp318_ = _data_->_tmp315_;
				_data_->_tmp315_ = NULL;
				_g_object_unref0 (_data_->attachment_part);
				_data_->attachment_part = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp318_, g_mime_object_get_type (), GMimeObject);
				_g_object_unref0 (_data_->_tmp315_);
			}
			goto __finally4;
			__catch4_g_error:
			{
				_data_->_vala4_err = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp319_ = _data_->file;
				_data_->_tmp320_ = g_file_get_path (_data_->_tmp319_);
				_data_->_tmp321_ = _data_->_tmp320_;
				_data_->_tmp322_ = _data_->_vala4_err;
				_data_->_tmp323_ = _data_->_tmp322_->message;
				g_warning ("rfc822-message.vala:476: Error creating attachment file part %s: %s", _data_->_tmp321_, _data_->_tmp323_);
				_g_free0 (_data_->_tmp321_);
				_g_error_free0 (_data_->_vala4_err);
			}
			__finally4:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->attachment_part);
					_g_object_unref0 (_data_->file);
					_g_object_unref0 (_data_->_file_it);
					_g_object_unref0 (_data_->attachment_parts);
					_g_object_unref0 (_data_->body_part);
					_g_object_unref0 (_data_->main_parts);
					_g_free0 (_data_->body_charset);
					_g_object_unref0 (_data_->body_parts);
					g_object_unref (_data_->_async_result);
					return FALSE;
				} else {
					_g_object_unref0 (_data_->attachment_part);
					_g_object_unref0 (_data_->file);
					_g_object_unref0 (_data_->_file_it);
					_g_object_unref0 (_data_->attachment_parts);
					_g_object_unref0 (_data_->body_part);
					_g_object_unref0 (_data_->main_parts);
					_g_free0 (_data_->body_charset);
					_g_object_unref0 (_data_->body_parts);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					return NULL;
				}
			}
			_data_->_tmp324_ = _data_->attachment_part;
			if (_data_->_tmp324_ != NULL) {
				_data_->_tmp325_ = _data_->attachment_parts;
				_data_->_tmp326_ = _data_->attachment_part;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp325_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp326_);
			}
			_g_object_unref0 (_data_->attachment_part);
			_g_object_unref0 (_data_->file);
		}
		_g_object_unref0 (_data_->_file_it);
	}
	_data_->_tmp327_ = _data_->attachment_parts;
	_data_->_tmp328_ = geary_rf_c822_message_coalesce_parts (_data_->self, _data_->_tmp327_, "mixed");
	_data_->_vala1_attachment_part = _data_->_tmp328_;
	_data_->_tmp329_ = _data_->_vala1_attachment_part;
	if (_data_->_tmp329_ != NULL) {
		_data_->_tmp330_ = _data_->main_parts;
		_data_->_tmp331_ = _data_->_vala1_attachment_part;
		gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp330_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp331_);
	}
	_data_->_tmp332_ = _data_->main_parts;
	_data_->_tmp333_ = geary_rf_c822_message_coalesce_parts (_data_->self, _data_->_tmp332_, "mixed");
	_data_->main_part = _data_->_tmp333_;
	_data_->_tmp334_ = _data_->self->priv->message;
	g_mime_message_set_mime_part (_data_->_tmp334_, _data_->main_part);
	_g_object_unref0 (_data_->main_part);
	_g_object_unref0 (_data_->_vala1_attachment_part);
	_g_object_unref0 (_data_->attachment_parts);
	_g_object_unref0 (_data_->body_part);
	_g_object_unref0 (_data_->main_parts);
	_g_free0 (_data_->body_charset);
	_g_object_unref0 (_data_->body_parts);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
geary_rf_c822_message_new_from_composed_email (GearyComposedEmail* email,
                                               const gchar* message_id,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	geary_rf_c822_message_construct_from_composed_email (GEARY_RF_C822_TYPE_MESSAGE, email, message_id, cancellable, _callback_, _user_data_);
}

GearyRFC822Message*
geary_rf_c822_message_new_from_composed_email_finish (GAsyncResult* _res_,
                                                      GError** error)
{
	return geary_rf_c822_message_construct_from_composed_email_finish (_res_, error);
}

static GMimeObject*
geary_rf_c822_message_coalesce_related (GearyRFC822Message* self,
                                        GeeList* parts,
                                        const gchar* type)
{
	GMimeObject* part = NULL;
	GMimeObject* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GMimeObject* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (parts, GEE_TYPE_LIST), NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = geary_rf_c822_message_coalesce_parts (self, parts, "related");
	part = _tmp0_;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (parts, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 1) {
		GMimeObject* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = part;
		_tmp4_ = geary_rf_c822_get_charset ();
		_tmp5_ = _tmp4_;
		g_mime_object_set_header (_tmp3_, "Type", type, _tmp5_);
		_g_free0 (_tmp5_);
	}
	result = part;
	return result;
}

static GMimeObject*
geary_rf_c822_message_coalesce_parts (GearyRFC822Message* self,
                                      GeeList* parts,
                                      const gchar* subtype)
{
	gint _tmp0_;
	gint _tmp1_;
	GMimeObject* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (parts, GEE_TYPE_LIST), NULL);
	g_return_val_if_fail (subtype != NULL, NULL);
	_tmp0_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (parts, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = NULL;
		return result;
	} else {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (parts, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp3_ = _tmp2_;
		if (_tmp3_ == 1) {
			gpointer _tmp4_;
			_tmp4_ = gee_list_first (parts);
			result = (GMimeObject*) _tmp4_;
			return result;
		} else {
			GMimeMultipart* multipart = NULL;
			GMimeMultipart* _tmp5_;
			_tmp5_ = g_mime_multipart_new_with_subtype (subtype);
			multipart = _tmp5_;
			{
				GeeList* _part_list = NULL;
				gint _part_size = 0;
				GeeList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gint _part_index = 0;
				_part_list = parts;
				_tmp6_ = _part_list;
				_tmp7_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp8_ = _tmp7_;
				_part_size = _tmp8_;
				_part_index = -1;
				while (TRUE) {
					gint _tmp9_;
					gint _tmp10_;
					GMimeObject* part = NULL;
					GeeList* _tmp11_;
					gpointer _tmp12_;
					GMimeMultipart* _tmp13_;
					GMimeObject* _tmp14_;
					_part_index = _part_index + 1;
					_tmp9_ = _part_index;
					_tmp10_ = _part_size;
					if (!(_tmp9_ < _tmp10_)) {
						break;
					}
					_tmp11_ = _part_list;
					_tmp12_ = gee_list_get (_tmp11_, _part_index);
					part = (GMimeObject*) _tmp12_;
					_tmp13_ = multipart;
					_tmp14_ = part;
					g_mime_multipart_add (_tmp13_, _tmp14_);
					_g_object_unref0 (part);
				}
			}
			result = G_TYPE_CHECK_INSTANCE_CAST (multipart, g_mime_object_get_type (), GMimeObject);
			return result;
		}
	}
}

static void
geary_rf_c822_message_get_file_part_data_free (gpointer _data)
{
	GearyRfC822MessageGetFilePartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyRfC822MessageGetFilePartData, _data_);
}

static void
geary_rf_c822_message_get_file_part (GearyRFC822Message* self,
                                     GFile* file,
                                     GearyMimeDispositionType disposition,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GearyRfC822MessageGetFilePartData* _data_;
	GearyRFC822Message* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyRfC822MessageGetFilePartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_rf_c822_message_get_file_part_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_data_->disposition = disposition;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_rf_c822_message_get_file_part_co (_data_);
}

static GMimePart*
geary_rf_c822_message_get_file_part_finish (GearyRFC822Message* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GMimePart* result;
	GearyRfC822MessageGetFilePartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_rf_c822_message_get_file_part_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	GearyRfC822MessageGetFilePartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_rf_c822_message_get_file_part_co (_data_);
}

static gboolean
geary_rf_c822_message_get_file_part_co (GearyRfC822MessageGetFilePartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	g_file_query_info_async (_data_->file, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, geary_rf_c822_message_get_file_part_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
	_data_->file_info = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_mime_part_new ();
	_data_->part = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->part;
	_data_->_tmp3_ = geary_mime_disposition_type_serialize (_data_->disposition);
	_data_->_tmp4_ = _data_->_tmp3_;
	g_mime_object_set_disposition (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, g_mime_object_get_type (), GMimeObject), _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	_data_->_tmp5_ = _data_->part;
	_data_->_tmp6_ = g_file_get_basename (_data_->file);
	_data_->_tmp7_ = _data_->_tmp6_;
	g_mime_part_set_filename (_data_->_tmp5_, _data_->_tmp7_);
	_g_free0 (_data_->_tmp7_);
	_data_->_tmp8_ = geary_rf_c822_get_parser_options ();
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = g_file_info_get_content_type (_data_->file_info);
	_data_->_tmp11_ = g_mime_content_type_parse (_data_->_tmp9_, _data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	__vala_GMimeParserOptions_free0 (_data_->_tmp9_);
	_data_->content_type = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->part;
	_data_->_tmp14_ = _data_->content_type;
	g_mime_object_set_content_type (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, g_mime_object_get_type (), GMimeObject), _data_->_tmp14_);
	_data_->_tmp15_ = _data_->part;
	g_mime_part_set_content_encoding (_data_->_tmp15_, GMIME_CONTENT_ENCODING_BASE64);
	_data_->_tmp16_ = (GMimeStreamGIO*) g_mime_stream_gio_new (_data_->file);
	_data_->stream = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->stream;
	g_mime_stream_gio_set_owner (_data_->_tmp17_, FALSE);
	_data_->_tmp18_ = _data_->part;
	_data_->_tmp19_ = _data_->stream;
	_data_->_tmp20_ = g_mime_data_wrapper_new_with_stream (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, g_mime_stream_get_type (), GMimeStream), GMIME_CONTENT_ENCODING_BINARY);
	_data_->_tmp21_ = _data_->_tmp20_;
	g_mime_part_set_content (_data_->_tmp18_, _data_->_tmp21_);
	_g_object_unref0 (_data_->_tmp21_);
	_data_->result = _data_->part;
	_g_object_unref0 (_data_->stream);
	_g_object_unref0 (_data_->content_type);
	_g_object_unref0 (_data_->file_info);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_rf_c822_message_get_buffer_part_data_free (gpointer _data)
{
	GearyRfC822MessageGetBufferPartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->buffer);
	_g_free0 (_data_->basename);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyRfC822MessageGetBufferPartData, _data_);
}

static void
geary_rf_c822_message_get_buffer_part (GearyRFC822Message* self,
                                       GearyMemoryBuffer* buffer,
                                       const gchar* basename,
                                       GearyMimeDispositionType disposition,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	GearyRfC822MessageGetBufferPartData* _data_;
	GearyRFC822Message* _tmp0_;
	GearyMemoryBuffer* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (self));
	g_return_if_fail (GEARY_MEMORY_IS_BUFFER (buffer));
	g_return_if_fail (basename != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyRfC822MessageGetBufferPartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_rf_c822_message_get_buffer_part_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (buffer);
	_g_object_unref0 (_data_->buffer);
	_data_->buffer = _tmp1_;
	_tmp2_ = g_strdup (basename);
	_g_free0 (_data_->basename);
	_data_->basename = _tmp2_;
	_data_->disposition = disposition;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_rf_c822_message_get_buffer_part_co (_data_);
}

static GMimePart*
geary_rf_c822_message_get_buffer_part_finish (GearyRFC822Message* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GMimePart* result;
	GearyRfC822MessageGetBufferPartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Create a GMime part for the provided attachment buffer
     */
static gboolean
geary_rf_c822_message_get_buffer_part_co (GearyRfC822MessageGetBufferPartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_mime_content_type_guess_type (_data_->basename, _data_->buffer, &_data_->_inner_error0_);
	_data_->mime_type = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->mime_type;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp2_ = g_strdup_printf (_ ("Could not determine mime type for “%s”."), _data_->basename);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, _data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_g_free0 (_data_->_tmp3_);
		_data_->_inner_error0_ = _data_->_tmp5_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->mime_type);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = geary_rf_c822_get_parser_options ();
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = _data_->mime_type;
	_data_->_tmp9_ = geary_mime_content_type_get_mime_type (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_mime_content_type_parse (_data_->_tmp7_, _data_->_tmp10_);
	_data_->_tmp12_ = _data_->_tmp11_;
	_g_free0 (_data_->_tmp10_);
	__vala_GMimeParserOptions_free0 (_data_->_tmp7_);
	_data_->content_type = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->content_type;
	if (_data_->_tmp13_ == NULL) {
		_data_->_tmp14_ = _data_->mime_type;
		_data_->_tmp15_ = geary_mime_content_type_to_string (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = g_strdup_printf (_ ("Could not determine content type for mime type “%s” on “%s”."), _data_->_tmp16_, _data_->basename);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, _data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_g_free0 (_data_->_tmp18_);
		_g_free0 (_data_->_tmp16_);
		_data_->_inner_error0_ = _data_->_tmp20_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->content_type);
		_g_object_unref0 (_data_->mime_type);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = g_mime_part_new ();
	_data_->part = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->part;
	_data_->_tmp23_ = geary_mime_disposition_type_serialize (_data_->disposition);
	_data_->_tmp24_ = _data_->_tmp23_;
	g_mime_object_set_disposition (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, g_mime_object_get_type (), GMimeObject), _data_->_tmp24_);
	_g_free0 (_data_->_tmp24_);
	_data_->_tmp25_ = _data_->part;
	g_mime_part_set_filename (_data_->_tmp25_, _data_->basename);
	_data_->_tmp26_ = _data_->part;
	_data_->_tmp27_ = _data_->content_type;
	g_mime_object_set_content_type (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp26_, g_mime_object_get_type (), GMimeObject), _data_->_tmp27_);
	_data_->_tmp28_ = _data_->part;
	g_mime_part_set_content_encoding (_data_->_tmp28_, GMIME_CONTENT_ENCODING_BASE64);
	_data_->_tmp29_ = geary_rf_c822_utils_create_stream_mem (_data_->buffer);
	_data_->stream = _data_->_tmp29_;
	_data_->_tmp30_ = _data_->part;
	_data_->_tmp31_ = _data_->stream;
	_data_->_tmp32_ = g_mime_data_wrapper_new_with_stream (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, g_mime_stream_get_type (), GMimeStream), GMIME_CONTENT_ENCODING_BINARY);
	_data_->_tmp33_ = _data_->_tmp32_;
	g_mime_part_set_content (_data_->_tmp30_, _data_->_tmp33_);
	_g_object_unref0 (_data_->_tmp33_);
	_data_->result = _data_->part;
	_g_object_unref0 (_data_->stream);
	_g_object_unref0 (_data_->content_type);
	_g_object_unref0 (_data_->mime_type);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Generates a preview from the email's message body.
     *
     * If there is no body, the empty string will be returned.
     */
gchar*
geary_rf_c822_message_get_preview (GearyRFC822Message* self)
{
	GearyRFC822TextFormat format = 0;
	gchar* preview = NULL;
	gchar* _tmp10_ = NULL;
	const gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	format = GEARY_RF_C822_TEXT_FORMAT_PLAIN;
	preview = NULL;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = geary_rf_c822_message_get_plain_body (self, FALSE, NULL, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				goto __catch0_geary_rf_c822_error;
			}
			_g_free0 (preview);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (preview);
		preview = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_geary_rf_c822_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		{
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			format = GEARY_RF_C822_TEXT_FORMAT_HTML;
			_tmp4_ = geary_rf_c822_message_get_html_body (self, NULL, NULL, &_inner_error0_);
			_tmp3_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch1_geary_rf_c822_error;
				}
				_g_error_free0 (e);
				_g_free0 (preview);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp5_ = _tmp3_;
			_tmp3_ = NULL;
			_g_free0 (preview);
			preview = _tmp5_;
			_g_free0 (_tmp3_);
		}
		goto __finally1;
		__catch1_geary_rf_c822_error:
		{
			GError* _error_ = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			_tmp8_ = _error_;
			_tmp9_ = _tmp8_->message;
			g_debug ("rfc822-message.vala:628: Could not generate message preview: %s\n" \
" and: %s", _tmp7_, _tmp9_);
			_g_error_free0 (_error_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_error_free0 (e);
			_g_free0 (preview);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (preview);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp11_ = preview;
	if (_tmp11_ != NULL) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = preview;
		_tmp13_ = geary_rf_c822_utils_to_preview_text (_tmp12_, format);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp13_;
	} else {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("");
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp14_;
	}
	result = _tmp10_;
	_g_free0 (preview);
	return result;
}

GeeList*
geary_rf_c822_message_get_recipients (GearyRFC822Message* self)
{
	GeeList* addrs = NULL;
	GeeArrayList* _tmp0_;
	GearyRFC822MailboxAddresses* _tmp1_;
	GearyRFC822MailboxAddresses* _tmp2_;
	GearyRFC822MailboxAddresses* _tmp8_;
	GearyRFC822MailboxAddresses* _tmp9_;
	GearyRFC822MailboxAddresses* _tmp15_;
	GearyRFC822MailboxAddresses* _tmp16_;
	GeeList* _tmp22_ = NULL;
	GeeList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GeeList* _tmp27_;
	GeeList* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp0_ = gee_array_list_new (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	addrs = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	_tmp1_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GeeList* _tmp3_;
		GearyRFC822MailboxAddresses* _tmp4_;
		GearyRFC822MailboxAddresses* _tmp5_;
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		_tmp3_ = addrs;
		_tmp4_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_rf_c822_mailbox_addresses_get_all (_tmp5_);
		_tmp7_ = _tmp6_;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (_tmp7_);
	}
	_tmp8_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		GeeList* _tmp10_;
		GearyRFC822MailboxAddresses* _tmp11_;
		GearyRFC822MailboxAddresses* _tmp12_;
		GeeList* _tmp13_;
		GeeList* _tmp14_;
		_tmp10_ = addrs;
		_tmp11_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp12_ = _tmp11_;
		_tmp13_ = geary_rf_c822_mailbox_addresses_get_all (_tmp12_);
		_tmp14_ = _tmp13_;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		GeeList* _tmp17_;
		GearyRFC822MailboxAddresses* _tmp18_;
		GearyRFC822MailboxAddresses* _tmp19_;
		GeeList* _tmp20_;
		GeeList* _tmp21_;
		_tmp17_ = addrs;
		_tmp18_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp19_ = _tmp18_;
		_tmp20_ = geary_rf_c822_mailbox_addresses_get_all (_tmp19_);
		_tmp21_ = _tmp20_;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (_tmp21_);
	}
	_tmp23_ = addrs;
	_tmp24_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp25_ = _tmp24_;
	if (_tmp25_ > 0) {
		GeeList* _tmp26_;
		_tmp26_ = addrs;
		_tmp22_ = _tmp26_;
	} else {
		_tmp22_ = NULL;
	}
	_tmp27_ = _g_object_ref0 (_tmp22_);
	result = _tmp27_;
	_g_object_unref0 (addrs);
	return result;
}

/**
     * Returns the header of the message.
     */
GearyRFC822Header*
geary_rf_c822_message_get_header (GearyRFC822Message* self)
{
	GMimeMessage* _tmp0_;
	GearyRFC822Header* _tmp1_;
	GearyRFC822Header* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp0_ = self->priv->message;
	_tmp1_ = geary_rf_c822_header_new_from_gmime (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_mime_object_get_type (), GMimeObject));
	result = _tmp1_;
	return result;
}

/**
     * Returns the body of the message.
     */
static void
_vala_GMimeFormatOptions_free (GMimeFormatOptions* self)
{
	g_boxed_free (g_mime_format_options_get_type (), self);
}

GearyRFC822Text*
geary_rf_c822_message_get_body (GearyRFC822Message* self)
{
	GearyRFC822Text* body = NULL;
	GMimeObject* gmime = NULL;
	GMimeMessage* _tmp0_;
	GMimeObject* _tmp1_;
	GMimeObject* _tmp2_;
	GMimeObject* _tmp3_;
	GearyRFC822Text* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	body = NULL;
	_tmp0_ = self->priv->message;
	_tmp1_ = g_mime_message_get_mime_part (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	gmime = _tmp2_;
	_tmp3_ = gmime;
	if (_tmp3_ != NULL) {
		GMimeStreamMem* stream = NULL;
		GMimeStreamMem* _tmp4_;
		GMimeFormatOptions* options = NULL;
		GMimeFormatOptions* _tmp5_;
		GMimeFormatOptions* _tmp6_;
		GMimeFormatOptions* _tmp7_;
		GMimeFormatOptions* _tmp8_;
		GMimeHeaderList* headers = NULL;
		GMimeMessage* _tmp9_;
		GMimeHeaderList* _tmp10_;
		GMimeHeaderList* _tmp11_;
		gint count = 0;
		GMimeHeaderList* _tmp12_;
		GMimeObject* _tmp19_;
		GMimeFormatOptions* _tmp20_;
		GMimeStreamMem* _tmp21_;
		GMimeStreamMem* _tmp22_;
		GearyRFC822Text* _tmp23_;
		_tmp4_ = (GMimeStreamMem*) g_mime_stream_mem_new ();
		stream = _tmp4_;
		_tmp5_ = geary_rf_c822_get_format_options ();
		_tmp6_ = _tmp5_;
		_tmp7_ = g_mime_format_options_clone (_tmp6_);
		_tmp8_ = _tmp7_;
		__vala_GMimeFormatOptions_free0 (_tmp6_);
		options = _tmp8_;
		_tmp9_ = self->priv->message;
		_tmp10_ = g_mime_object_get_header_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_mime_object_get_type (), GMimeObject));
		_tmp11_ = _g_object_ref0 (_tmp10_);
		headers = _tmp11_;
		_tmp12_ = headers;
		count = g_mime_header_list_get_count (_tmp12_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = TRUE;
				while (TRUE) {
					GMimeFormatOptions* _tmp15_;
					GMimeHeaderList* _tmp16_;
					GMimeHeader* _tmp17_;
					const gchar* _tmp18_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = i;
						i = _tmp14_ + 1;
					}
					_tmp13_ = FALSE;
					if (!(i < count)) {
						break;
					}
					_tmp15_ = options;
					_tmp16_ = headers;
					_tmp17_ = g_mime_header_list_get_header_at (_tmp16_, i);
					_tmp18_ = g_mime_header_get_name (_tmp17_);
					g_mime_format_options_add_hidden_header (_tmp15_, _tmp18_);
				}
			}
		}
		_tmp19_ = gmime;
		_tmp20_ = options;
		_tmp21_ = stream;
		g_mime_object_write_to_stream (_tmp19_, _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_mime_stream_get_type (), GMimeStream));
		_tmp22_ = stream;
		_tmp23_ = geary_rf_c822_text_new_from_gmime (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_mime_stream_get_type (), GMimeStream));
		_g_object_unref0 (body);
		body = _tmp23_;
		_g_object_unref0 (headers);
		__vala_GMimeFormatOptions_free0 (options);
		_g_object_unref0 (stream);
	} else {
		GearyMemoryEmptyBuffer* _tmp24_;
		GearyMemoryEmptyBuffer* _tmp25_;
		GearyRFC822Text* _tmp26_;
		_tmp24_ = geary_memory_empty_buffer_get_instance ();
		_tmp25_ = _tmp24_;
		_tmp26_ = geary_rf_c822_text_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
		_g_object_unref0 (body);
		body = _tmp26_;
	}
	result = body;
	_g_object_unref0 (gmime);
	return result;
}

/**
     * Serialises the message using native (i.e. LF) line endings.
     */
GearyMemoryBuffer*
geary_rf_c822_message_get_native_buffer (GearyRFC822Message* self,
                                         GError** error)
{
	GearyMemoryBuffer* _tmp0_ = NULL;
	GearyMemoryBuffer* _tmp1_;
	GearyMemoryBuffer* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyMemoryBuffer* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp1_ = geary_rf_c822_message_message_to_memory_buffer (self, FALSE, GEARY_RF_C822_MESSAGE_RF_C822_FORMAT_OPTIONS_NONE, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Serialises the message using RFC 822 (i.e. CRLF) line endings.
     *
     * Returns the message as a memory buffer suitable for network
     * transmission and interoperability with other RFC 822 consumers.
     */
GearyMemoryBuffer*
geary_rf_c822_message_get_rfc822_buffer (GearyRFC822Message* self,
                                         GearyRFC822MessageRFC822FormatOptions options,
                                         GError** error)
{
	GearyMemoryBuffer* _tmp0_ = NULL;
	GearyMemoryBuffer* _tmp1_;
	GearyMemoryBuffer* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyMemoryBuffer* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp1_ = geary_rf_c822_message_message_to_memory_buffer (self, TRUE, options, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * Determines if the message has one or display HTML parts.
     */
gboolean
geary_rf_c822_message_has_html_body (GearyRFC822Message* self)
{
	GMimeMessage* _tmp0_;
	GMimeObject* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), FALSE);
	_tmp0_ = self->priv->message;
	_tmp1_ = g_mime_message_get_mime_part (_tmp0_);
	result = geary_rf_c822_message_has_body_parts (self, _tmp1_, "html");
	return result;
}

/**
     * Determines if the message has one or plain text display parts.
     */
gboolean
geary_rf_c822_message_has_plain_body (GearyRFC822Message* self)
{
	GMimeMessage* _tmp0_;
	GMimeObject* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), FALSE);
	_tmp0_ = self->priv->message;
	_tmp1_ = g_mime_message_get_mime_part (_tmp0_);
	result = geary_rf_c822_message_has_body_parts (self, _tmp1_, "plain");
	return result;
}

/**
     * Determines if the message has any body text/subtype MIME parts.
     *
     * A body part is one that would be displayed to the user,
     * i.e. parts returned by {@link get_html_body} or {@link
     * get_plain_body}.
     *
     * The logic for selecting text nodes here must match that in
     * construct_body_from_mime_parts.
     */
static gboolean
geary_rf_c822_message_has_body_parts (GearyRFC822Message* self,
                                      GMimeObject* node,
                                      const gchar* text_subtype)
{
	GearyRFC822Part* part = NULL;
	GearyRFC822Part* _tmp0_;
	gboolean is_matching_part = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (node, g_mime_object_get_type ()), FALSE);
	g_return_val_if_fail (text_subtype != NULL, FALSE);
	_tmp0_ = geary_rf_c822_part_new (node);
	part = _tmp0_;
	is_matching_part = FALSE;
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, g_mime_multipart_get_type ())) {
		GMimeMultipart* multipart = NULL;
		GMimeMultipart* _tmp1_;
		gint count = 0;
		GMimeMultipart* _tmp2_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, g_mime_multipart_get_type (), GMimeMultipart));
		multipart = _tmp1_;
		_tmp2_ = multipart;
		count = g_mime_multipart_get_count (_tmp2_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gboolean _tmp5_ = FALSE;
					GMimeMultipart* _tmp6_;
					GMimeObject* _tmp7_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					if (i < count) {
						_tmp5_ = !is_matching_part;
					} else {
						_tmp5_ = FALSE;
					}
					if (!_tmp5_) {
						break;
					}
					_tmp6_ = multipart;
					_tmp7_ = g_mime_multipart_get_part (_tmp6_, i);
					is_matching_part = geary_rf_c822_message_has_body_parts (self, _tmp7_, text_subtype);
				}
			}
		}
		_g_object_unref0 (multipart);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (node, g_mime_part_get_type ())) {
			GearyMimeDispositionType disposition = 0;
			GearyRFC822Part* _tmp8_;
			GearyMimeContentDisposition* _tmp9_;
			GearyMimeContentDisposition* _tmp10_;
			gboolean _tmp16_ = FALSE;
			disposition = GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED;
			_tmp8_ = part;
			_tmp9_ = geary_rf_c822_part_get_content_disposition (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				GearyRFC822Part* _tmp11_;
				GearyMimeContentDisposition* _tmp12_;
				GearyMimeContentDisposition* _tmp13_;
				GearyMimeDispositionType _tmp14_;
				GearyMimeDispositionType _tmp15_;
				_tmp11_ = part;
				_tmp12_ = geary_rf_c822_part_get_content_disposition (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = geary_mime_content_disposition_get_disposition_type (_tmp13_);
				_tmp15_ = _tmp14_;
				disposition = _tmp15_;
			}
			if (disposition != GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT) {
				GearyRFC822Part* _tmp17_;
				GearyMimeContentType* _tmp18_;
				GearyMimeContentType* _tmp19_;
				_tmp17_ = part;
				_tmp18_ = geary_rf_c822_part_get_content_type (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp16_ = geary_mime_content_type_is_type (_tmp19_, "text", text_subtype);
			} else {
				_tmp16_ = FALSE;
			}
			is_matching_part = _tmp16_;
		}
	}
	result = is_matching_part;
	_g_object_unref0 (part);
	return result;
}

/**
     * This method is the main utility method used by the other body-generating constructors.
     *
     * Only text/* MIME parts of the specified subtype are added to body.  If a non-text part is
     * within a multipart/mixed container, the {@link InlinePartReplacer} is invoked.
     *
     * If to_html is true, the text is run through a filter to HTML-ize it.  (Obviously, this
     * should be false if text/html is being searched for.).
     *
     * The final constructed body is stored in the body string.
     *
     * The initial call should pass the root of this message and UNSPECIFIED as its container
     * subtype.
     *
     * @return Whether a text part with the desired text_subtype was found
     */
static gboolean
geary_rf_c822_message_construct_body_from_mime_parts (GearyRFC822Message* self,
                                                      GMimeObject* node,
                                                      GearyMimeMultipartSubtype container_subtype,
                                                      const gchar* text_subtype,
                                                      gboolean to_html,
                                                      GearyRFC822MessageInlinePartReplacer replacer,
                                                      gpointer replacer_target,
                                                      gchar** body,
                                                      GError** error)
{
	GearyRFC822Part* part = NULL;
	GearyRFC822Part* _tmp0_;
	GearyMimeContentType* content_type = NULL;
	GearyRFC822Part* _tmp1_;
	GearyMimeContentType* _tmp2_;
	GearyMimeContentType* _tmp3_;
	GearyMimeContentType* _tmp4_;
	GMimeMultipart* multipart = NULL;
	GMimeMultipart* _tmp5_;
	GMimeMultipart* _tmp6_;
	GearyMimeDispositionType disposition = 0;
	GearyRFC822Part* _tmp28_;
	GearyMimeContentDisposition* _tmp29_;
	GearyMimeContentDisposition* _tmp30_;
	gboolean _tmp36_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (node, g_mime_object_get_type ()), FALSE);
	g_return_val_if_fail (text_subtype != NULL, FALSE);
	_tmp0_ = geary_rf_c822_part_new (node);
	part = _tmp0_;
	_tmp1_ = part;
	_tmp2_ = geary_rf_c822_part_get_content_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	content_type = _tmp4_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (node, g_mime_multipart_get_type ()) ? ((GMimeMultipart*) node) : NULL);
	multipart = _tmp5_;
	_tmp6_ = multipart;
	if (_tmp6_ != NULL) {
		GearyMimeMultipartSubtype this_subtype = 0;
		GearyMimeContentType* _tmp7_;
		gboolean found_text_subtype = FALSE;
		GString* builder = NULL;
		GString* _tmp8_;
		gint count = 0;
		GMimeMultipart* _tmp9_;
		GString* _tmp23_;
		const gchar* _tmp24_;
		_tmp7_ = content_type;
		this_subtype = geary_mime_multipart_subtype_from_content_type (_tmp7_, NULL);
		found_text_subtype = FALSE;
		_tmp8_ = g_string_new ("");
		builder = _tmp8_;
		_tmp9_ = multipart;
		count = g_mime_multipart_get_count (_tmp9_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					GMimeObject* child = NULL;
					GMimeMultipart* _tmp12_;
					GMimeObject* _tmp13_;
					GMimeObject* _tmp14_;
					gchar* child_body = NULL;
					gboolean _tmp15_ = FALSE;
					GMimeObject* _tmp16_;
					gboolean _tmp17_;
					const gchar* _tmp20_;
					if (!_tmp10_) {
						gint _tmp11_;
						i = i + 1;
						_tmp11_ = i;
					}
					_tmp10_ = FALSE;
					if (!(i < count)) {
						break;
					}
					_tmp12_ = multipart;
					_tmp13_ = g_mime_multipart_get_part (_tmp12_, i);
					_tmp14_ = _g_object_ref0 (_tmp13_);
					child = _tmp14_;
					child_body = NULL;
					_tmp16_ = child;
					_tmp17_ = geary_rf_c822_message_construct_body_from_mime_parts (self, _tmp16_, this_subtype, text_subtype, to_html, replacer, replacer_target, &child_body, &_inner_error0_);
					_tmp15_ = _tmp17_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
							gboolean _tmp18_ = FALSE;
							g_propagate_error (error, _inner_error0_);
							_g_free0 (child_body);
							_g_object_unref0 (child);
							_g_string_free0 (builder);
							_g_object_unref0 (multipart);
							_g_object_unref0 (content_type);
							_g_object_unref0 (part);
							return _tmp18_;
						} else {
							gboolean _tmp19_ = FALSE;
							_g_free0 (child_body);
							_g_object_unref0 (child);
							_g_string_free0 (builder);
							_g_object_unref0 (multipart);
							_g_object_unref0 (content_type);
							_g_object_unref0 (part);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return _tmp19_;
						}
					}
					found_text_subtype |= _tmp15_;
					_tmp20_ = child_body;
					if (_tmp20_ != NULL) {
						GString* _tmp21_;
						const gchar* _tmp22_;
						_tmp21_ = builder;
						_tmp22_ = child_body;
						g_string_append (_tmp21_, _tmp22_);
					}
					_g_free0 (child_body);
					_g_object_unref0 (child);
				}
			}
		}
		_tmp23_ = builder;
		_tmp24_ = _tmp23_->str;
		if (!geary_string_is_empty (_tmp24_)) {
			GString* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp25_ = builder;
			_tmp26_ = _tmp25_->str;
			_tmp27_ = g_strdup (_tmp26_);
			_g_free0 (*body);
			*body = _tmp27_;
		}
		result = found_text_subtype;
		_g_string_free0 (builder);
		_g_object_unref0 (multipart);
		_g_object_unref0 (content_type);
		_g_object_unref0 (part);
		return result;
	}
	disposition = GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED;
	_tmp28_ = part;
	_tmp29_ = geary_rf_c822_part_get_content_disposition (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		GearyRFC822Part* _tmp31_;
		GearyMimeContentDisposition* _tmp32_;
		GearyMimeContentDisposition* _tmp33_;
		GearyMimeDispositionType _tmp34_;
		GearyMimeDispositionType _tmp35_;
		_tmp31_ = part;
		_tmp32_ = geary_rf_c822_part_get_content_disposition (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = geary_mime_content_disposition_get_disposition_type (_tmp33_);
		_tmp35_ = _tmp34_;
		disposition = _tmp35_;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, g_mime_part_get_type ())) {
		_tmp36_ = disposition != GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT;
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		GearyMimeContentType* _tmp37_;
		_tmp37_ = content_type;
		if (geary_mime_content_type_is_type (_tmp37_, "text", text_subtype)) {
			GearyRFC822PartBodyFormatting _tmp38_ = 0;
			GearyMemoryBuffer* _tmp39_ = NULL;
			GearyRFC822Part* _tmp40_;
			GearyMemoryBuffer* _tmp41_;
			gchar* _tmp44_;
			if (to_html) {
				_tmp38_ = GEARY_RF_C822_PART_BODY_FORMATTING_HTML;
			} else {
				_tmp38_ = GEARY_RF_C822_PART_BODY_FORMATTING_NONE;
			}
			_tmp40_ = part;
			_tmp41_ = geary_rf_c822_part_write_to_buffer (_tmp40_, GEARY_RF_C822_PART_ENCODING_CONVERSION_UTF8, _tmp38_, &_inner_error0_);
			_tmp39_ = _tmp41_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					gboolean _tmp42_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (multipart);
					_g_object_unref0 (content_type);
					_g_object_unref0 (part);
					return _tmp42_;
				} else {
					gboolean _tmp43_ = FALSE;
					_g_object_unref0 (multipart);
					_g_object_unref0 (content_type);
					_g_object_unref0 (part);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp43_;
				}
			}
			_tmp44_ = geary_memory_buffer_to_string (_tmp39_);
			_g_free0 (*body);
			*body = _tmp44_;
			_g_object_unref0 (_tmp39_);
		} else {
			gboolean _tmp45_ = FALSE;
			gboolean _tmp46_ = FALSE;
			if (replacer != NULL) {
				_tmp46_ = disposition == GEARY_MIME_DISPOSITION_TYPE_INLINE;
			} else {
				_tmp46_ = FALSE;
			}
			if (_tmp46_) {
				_tmp45_ = container_subtype == GEARY_MIME_MULTIPART_SUBTYPE_MIXED;
			} else {
				_tmp45_ = FALSE;
			}
			if (_tmp45_) {
				GearyRFC822Part* _tmp47_;
				gchar* _tmp48_;
				_tmp47_ = part;
				_tmp48_ = replacer (_tmp47_, replacer_target);
				_g_free0 (*body);
				*body = _tmp48_;
			}
		}
	}
	result = (*body) != NULL;
	_g_object_unref0 (multipart);
	_g_object_unref0 (content_type);
	_g_object_unref0 (part);
	return result;
}

/**
     * A front-end to construct_body_from_mime_parts() that converts its output parameters into
     * something that front-facing methods want to return.
     */
static gchar*
geary_rf_c822_message_internal_get_body (GearyRFC822Message* self,
                                         const gchar* text_subtype,
                                         gboolean to_html,
                                         GearyRFC822MessageInlinePartReplacer replacer,
                                         gpointer replacer_target,
                                         GError** error)
{
	gchar* body = NULL;
	gboolean _tmp0_ = FALSE;
	GMimeMessage* _tmp1_;
	GMimeObject* _tmp2_;
	gboolean _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	g_return_val_if_fail (text_subtype != NULL, NULL);
	body = NULL;
	_tmp1_ = self->priv->message;
	_tmp2_ = g_mime_message_get_mime_part (_tmp1_);
	_tmp3_ = geary_rf_c822_message_construct_body_from_mime_parts (self, _tmp2_, GEARY_MIME_MULTIPART_SUBTYPE_UNSPECIFIED, text_subtype, to_html, replacer, replacer_target, &body, &_inner_error0_);
	_tmp0_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (body);
			return NULL;
		} else {
			_g_free0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!_tmp0_) {
		GError* _tmp4_;
		_tmp4_ = g_error_new (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_NOT_FOUND, "Could not find any \"text/%s\" parts", text_subtype);
		_inner_error0_ = _tmp4_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (body);
			return NULL;
		} else {
			_g_free0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = body;
	return result;
}

/**
     * Returns the HTML portion of the message body, if present.
     *
     * Recursively walks the MIME structure (depth-first) serializing
     * all text/html MIME parts of the specified type into a single
     * UTF-8 string.  Non-text MIME parts inside of multipart/mixed
     * containers are offered to the {@link InlinePartReplacer}, which
     * can either return null or return a string that is inserted in
     * lieu of the MIME part into the final document.  All other MIME
     * parts are ignored.
     *
     * @throws Error.NOT_FOUND if an HTML body is not present.
     */
gchar*
geary_rf_c822_message_get_html_body (GearyRFC822Message* self,
                                     GearyRFC822MessageInlinePartReplacer replacer,
                                     gpointer replacer_target,
                                     GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp1_ = geary_rf_c822_message_internal_get_body (self, "html", FALSE, replacer, replacer_target, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

/**
     * Returns the plaintext portion of the message body, if present.
     *
     * Recursively walks the MIME structure (depth-first) serializing
     * all text/plain MIME parts of the specified type into a single
     * UTF-8 string.  Non-text MIME parts inside of multipart/mixed
     * containers are offered to the {@link InlinePartReplacer}, which
     * can either return null or return a string that is inserted in
     * lieu of the MIME part into the final document.  All other MIME
     * parts are ignored.
     *
     * The convert_to_html flag indicates if the plaintext body should
     * be converted into HTML.  Note that the InlinePartReplacer's
     * output is not converted; it's up to the caller to know what
     * format to return when invoked.
     *
     * @throws Error.NOT_FOUND if a plaintext body is not present.
     */
gchar*
geary_rf_c822_message_get_plain_body (GearyRFC822Message* self,
                                      gboolean convert_to_html,
                                      GearyRFC822MessageInlinePartReplacer replacer,
                                      gpointer replacer_target,
                                      GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp1_ = geary_rf_c822_message_internal_get_body (self, "plain", convert_to_html, replacer, replacer_target, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

/**
     * Return the body as a searchable string.  The body in this case should
     * include everything visible in the message's body in the client, which
     * would be only one body part, plus any visible attachments (which can be
     * disabled by passing false in include_sub_messages).  Note that values
     * that come out of this function are persisted.
     */
gchar*
geary_rf_c822_message_get_searchable_body (GearyRFC822Message* self,
                                           gboolean include_sub_messages,
                                           GError** error)
{
	gchar* body = NULL;
	gboolean html = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	body = NULL;
	html = FALSE;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = geary_rf_c822_message_get_html_body (self, NULL, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				goto __catch0_geary_rf_c822_error;
			}
			_g_free0 (body);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (body);
		body = _tmp2_;
		html = TRUE;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_geary_rf_c822_error:
	{
		g_clear_error (&_inner_error0_);
		{
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = geary_rf_c822_message_get_plain_body (self, FALSE, NULL, NULL, &_inner_error0_);
			_tmp3_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch1_geary_rf_c822_error;
				}
				_g_free0 (body);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp5_ = _tmp3_;
			_tmp3_ = NULL;
			_g_free0 (body);
			body = _tmp5_;
			_g_free0 (_tmp3_);
		}
		goto __finally1;
		__catch1_geary_rf_c822_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (body);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (body);
			return NULL;
		} else {
			_g_free0 (body);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp7_ = body;
	if (_tmp7_ != NULL) {
		_tmp6_ = html;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = body;
		_tmp9_ = geary_html_html_to_text (_tmp8_, TRUE, GEARY_RF_C822_UTF8_CHARSET);
		_g_free0 (body);
		body = _tmp9_;
	}
	if (include_sub_messages) {
		GeeList* _tmp10_ = NULL;
		GeeList* _tmp11_;
		_tmp11_ = geary_rf_c822_message_get_sub_messages (self, &_inner_error0_);
		_tmp10_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (body);
				return NULL;
			} else {
				_g_free0 (body);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		{
			GeeList* _sub_message_list = NULL;
			gint _sub_message_size = 0;
			GeeList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _sub_message_index = 0;
			_sub_message_list = _tmp10_;
			_tmp12_ = _sub_message_list;
			_tmp13_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp14_ = _tmp13_;
			_sub_message_size = _tmp14_;
			_sub_message_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				GearyRFC822Message* sub_message = NULL;
				GeeList* _tmp17_;
				gpointer _tmp18_;
				GString* sub_full = NULL;
				GString* _tmp19_;
				GearyRFC822Message* _tmp20_;
				GearyRFC822Subject* _tmp21_;
				GearyRFC822Subject* _tmp22_;
				GearyRFC822Message* _tmp30_;
				GearyRFC822MailboxAddresses* _tmp31_;
				GearyRFC822MailboxAddresses* _tmp32_;
				gchar* recipients = NULL;
				GearyRFC822Message* _tmp40_;
				gchar* _tmp41_;
				const gchar* _tmp42_;
				gchar* sub_body = NULL;
				GearyRFC822Message* _tmp46_;
				gchar* _tmp47_;
				const gchar* _tmp48_;
				GString* _tmp51_;
				_sub_message_index = _sub_message_index + 1;
				_tmp15_ = _sub_message_index;
				_tmp16_ = _sub_message_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = _sub_message_list;
				_tmp18_ = gee_list_get (_tmp17_, _sub_message_index);
				sub_message = (GearyRFC822Message*) _tmp18_;
				_tmp19_ = g_string_new ("");
				sub_full = _tmp19_;
				_tmp20_ = sub_message;
				_tmp21_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
				_tmp22_ = _tmp21_;
				if (_tmp22_ != NULL) {
					GString* _tmp23_;
					GearyRFC822Message* _tmp24_;
					GearyRFC822Subject* _tmp25_;
					GearyRFC822Subject* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					GString* _tmp29_;
					_tmp23_ = sub_full;
					_tmp24_ = sub_message;
					_tmp25_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
					_tmp26_ = _tmp25_;
					_tmp27_ = geary_message_data_searchable_message_data_to_searchable_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEARY_MESSAGE_DATA_TYPE_SEARCHABLE_MESSAGE_DATA, GearyMessageDataSearchableMessageData));
					_tmp28_ = _tmp27_;
					g_string_append (_tmp23_, _tmp28_);
					_g_free0 (_tmp28_);
					_tmp29_ = sub_full;
					g_string_append (_tmp29_, "\n");
				}
				_tmp30_ = sub_message;
				_tmp31_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
				_tmp32_ = _tmp31_;
				if (_tmp32_ != NULL) {
					GString* _tmp33_;
					GearyRFC822Message* _tmp34_;
					GearyRFC822MailboxAddresses* _tmp35_;
					GearyRFC822MailboxAddresses* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					GString* _tmp39_;
					_tmp33_ = sub_full;
					_tmp34_ = sub_message;
					_tmp35_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
					_tmp36_ = _tmp35_;
					_tmp37_ = geary_message_data_searchable_message_data_to_searchable_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEARY_MESSAGE_DATA_TYPE_SEARCHABLE_MESSAGE_DATA, GearyMessageDataSearchableMessageData));
					_tmp38_ = _tmp37_;
					g_string_append (_tmp33_, _tmp38_);
					_g_free0 (_tmp38_);
					_tmp39_ = sub_full;
					g_string_append (_tmp39_, "\n");
				}
				_tmp40_ = sub_message;
				_tmp41_ = geary_rf_c822_message_get_searchable_recipients (_tmp40_);
				recipients = _tmp41_;
				_tmp42_ = recipients;
				if (_tmp42_ != NULL) {
					GString* _tmp43_;
					const gchar* _tmp44_;
					GString* _tmp45_;
					_tmp43_ = sub_full;
					_tmp44_ = recipients;
					g_string_append (_tmp43_, _tmp44_);
					_tmp45_ = sub_full;
					g_string_append (_tmp45_, "\n");
				}
				_tmp46_ = sub_message;
				_tmp47_ = geary_rf_c822_message_get_searchable_body (_tmp46_, FALSE, &_inner_error0_);
				sub_body = _tmp47_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (recipients);
						_g_string_free0 (sub_full);
						_g_object_unref0 (sub_message);
						_g_object_unref0 (_tmp10_);
						_g_free0 (body);
						return NULL;
					} else {
						_g_free0 (recipients);
						_g_string_free0 (sub_full);
						_g_object_unref0 (sub_message);
						_g_object_unref0 (_tmp10_);
						_g_free0 (body);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp48_ = sub_body;
				if (_tmp48_ != NULL) {
					GString* _tmp49_;
					const gchar* _tmp50_;
					_tmp49_ = sub_full;
					_tmp50_ = sub_body;
					g_string_append (_tmp49_, _tmp50_);
				}
				_tmp51_ = sub_full;
				if (_tmp51_->len > ((gssize) 0)) {
					const gchar* _tmp52_;
					const gchar* _tmp54_;
					GString* _tmp55_;
					const gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					gchar* _tmp59_;
					_tmp52_ = body;
					if (_tmp52_ == NULL) {
						gchar* _tmp53_;
						_tmp53_ = g_strdup ("");
						_g_free0 (body);
						body = _tmp53_;
					}
					_tmp54_ = body;
					_tmp55_ = sub_full;
					_tmp56_ = _tmp55_->str;
					_tmp57_ = g_strconcat ("\n", _tmp56_, NULL);
					_tmp58_ = _tmp57_;
					_tmp59_ = g_strconcat (_tmp54_, _tmp58_, NULL);
					_g_free0 (body);
					body = _tmp59_;
					_g_free0 (_tmp58_);
				}
				_g_free0 (sub_body);
				_g_free0 (recipients);
				_g_string_free0 (sub_full);
				_g_object_unref0 (sub_message);
			}
		}
		_g_object_unref0 (_tmp10_);
	}
	result = body;
	return result;
}

/**
     * Return the full list of recipients (to, cc, and bcc) as a searchable
     * string.  Note that values that come out of this function are persisted.
     */
gchar*
geary_rf_c822_message_get_searchable_recipients (GearyRFC822Message* self)
{
	gchar* searchable = NULL;
	GeeList* recipient_list = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	searchable = NULL;
	_tmp0_ = geary_rf_c822_message_get_recipients (self);
	recipient_list = _tmp0_;
	_tmp1_ = recipient_list;
	if (_tmp1_ != NULL) {
		GearyRFC822MailboxAddresses* recipients = NULL;
		GeeList* _tmp2_;
		GearyRFC822MailboxAddresses* _tmp3_;
		GearyRFC822MailboxAddresses* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = recipient_list;
		_tmp3_ = geary_rf_c822_mailbox_addresses_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		recipients = _tmp3_;
		_tmp4_ = recipients;
		_tmp5_ = geary_message_data_searchable_message_data_to_searchable_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEARY_MESSAGE_DATA_TYPE_SEARCHABLE_MESSAGE_DATA, GearyMessageDataSearchableMessageData));
		_g_free0 (searchable);
		searchable = _tmp5_;
		_g_object_unref0 (recipients);
	}
	result = searchable;
	_g_object_unref0 (recipient_list);
	return result;
}

GeeList*
geary_rf_c822_message_get_attachments (GearyRFC822Message* self,
                                       GearyMimeDispositionType disposition,
                                       GError** error)
{
	GeeList* attachments = NULL;
	GeeLinkedList* _tmp0_;
	GMimeMessage* _tmp1_;
	GMimeObject* _tmp2_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp0_ = gee_linked_list_new (GEARY_RF_C822_TYPE_PART, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	attachments = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	_tmp1_ = self->priv->message;
	_tmp2_ = g_mime_message_get_mime_part (_tmp1_);
	geary_rf_c822_message_get_attachments_recursively (self, attachments, _tmp2_, disposition, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (attachments);
			return NULL;
		} else {
			_g_object_unref0 (attachments);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = attachments;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_rf_c822_message_to_addresses (GearyRFC822Message* self,
                                    InternetAddressList* list,
                                    GError** error)
{
	GearyRFC822MailboxAddresses* addresses = NULL;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	GearyRFC822MailboxAddresses* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	g_return_val_if_fail ((list == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (list, internet_address_list_get_type ()), NULL);
	addresses = NULL;
	if (list != NULL) {
		_tmp0_ = internet_address_list_length (list) > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GearyRFC822MailboxAddresses* _tmp1_ = NULL;
		GearyRFC822MailboxAddresses* _tmp2_;
		GearyRFC822MailboxAddresses* _tmp3_;
		_tmp2_ = geary_rf_c822_mailbox_addresses_new_from_gmime (list, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (addresses);
				return NULL;
			} else {
				_g_object_unref0 (addresses);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (addresses);
		addresses = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	result = addresses;
	return result;
}

static GearyRFC822MessageIDList*
geary_rf_c822_message_append_message_id (GearyRFC822Message* self,
                                         GearyRFC822MessageIDList* existing,
                                         const gchar* header_value,
                                         GError** error)
{
	GearyRFC822MessageIDList* ids = NULL;
	GearyRFC822MessageIDList* _tmp0_;
	GError* _inner_error0_ = NULL;
	GearyRFC822MessageIDList* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	g_return_val_if_fail ((existing == NULL) || GEARY_RF_C822_IS_MESSAGE_ID_LIST (existing), NULL);
	g_return_val_if_fail (header_value != NULL, NULL);
	_tmp0_ = _g_object_ref0 (existing);
	ids = _tmp0_;
	if (!geary_string_is_empty_or_whitespace (header_value)) {
		{
			GearyRFC822MessageIDList* _tmp1_ = NULL;
			GearyRFC822MessageIDList* _tmp2_;
			GearyRFC822MessageIDList* _tmp3_;
			_tmp2_ = geary_rf_c822_message_id_list_new_from_rfc822_string (header_value, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch0_geary_rf_c822_error;
				}
				_g_object_unref0 (ids);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (ids);
			ids = _tmp3_;
			if (existing != NULL) {
				GearyRFC822MessageIDList* _tmp4_;
				GearyRFC822MessageIDList* _tmp5_;
				_tmp4_ = ids;
				_tmp5_ = geary_rf_c822_message_id_list_concatenate_list (existing, _tmp4_);
				_g_object_unref0 (ids);
				ids = _tmp5_;
			}
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_geary_rf_c822_error:
		{
			GError* err = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = err;
			_tmp7_ = _tmp6_->message;
			g_debug ("rfc822-message.vala:1002: Error parsing message id list: %s", _tmp7_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (ids);
				return NULL;
			} else {
				_g_object_unref0 (ids);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	result = ids;
	return result;
}

static gpointer
_g_byte_array_ref0 (gpointer self)
{
	return self ? g_byte_array_ref (self) : NULL;
}

static void
geary_rf_c822_message_get_attachments_recursively (GearyRFC822Message* self,
                                                   GeeList* attachments,
                                                   GMimeObject* root,
                                                   GearyMimeDispositionType requested_disposition,
                                                   GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (attachments, GEE_TYPE_LIST));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (root, g_mime_object_get_type ()));
	if (G_TYPE_CHECK_INSTANCE_TYPE (root, g_mime_multipart_get_type ())) {
		GMimeMultipart* multipart = NULL;
		GMimeMultipart* _tmp0_;
		gint count = 0;
		GMimeMultipart* _tmp1_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (root, g_mime_multipart_get_type (), GMimeMultipart));
		multipart = _tmp0_;
		_tmp1_ = multipart;
		count = g_mime_multipart_get_count (_tmp1_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					GMimeMultipart* _tmp4_;
					GMimeObject* _tmp5_;
					if (!_tmp2_) {
						gint _tmp3_;
						i = i + 1;
						_tmp3_ = i;
					}
					_tmp2_ = FALSE;
					if (!(i < count)) {
						break;
					}
					_tmp4_ = multipart;
					_tmp5_ = g_mime_multipart_get_part (_tmp4_, i);
					geary_rf_c822_message_get_attachments_recursively (self, attachments, _tmp5_, requested_disposition, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (multipart);
							return;
						} else {
							_g_object_unref0 (multipart);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
			}
		}
		_g_object_unref0 (multipart);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (root, g_mime_message_part_get_type ())) {
			GMimeMessagePart* messagepart = NULL;
			GMimeMessagePart* _tmp6_;
			GMimeMessage* message = NULL;
			GMimeMessagePart* _tmp7_;
			GMimeMessage* _tmp8_;
			GMimeMessage* _tmp9_;
			gboolean is_unknown = FALSE;
			GearyMimeDispositionType disposition = 0;
			const gchar* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GearyMimeDispositionType _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			GMimeMessage* _tmp34_;
			GMimeObject* _tmp35_;
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (root, g_mime_message_part_get_type (), GMimeMessagePart));
			messagepart = _tmp6_;
			_tmp7_ = messagepart;
			_tmp8_ = g_mime_message_part_get_message (_tmp7_);
			_tmp9_ = _g_object_ref0 (_tmp8_);
			message = _tmp9_;
			_tmp10_ = g_mime_object_get_disposition (root);
			_tmp12_ = geary_mime_disposition_type_deserialize (_tmp10_, &_tmp11_);
			is_unknown = _tmp11_;
			disposition = _tmp12_;
			if (disposition == GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED) {
				_tmp13_ = TRUE;
			} else {
				_tmp13_ = is_unknown;
			}
			if (_tmp13_) {
				disposition = GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT;
			}
			if (requested_disposition == GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED) {
				_tmp14_ = TRUE;
			} else {
				_tmp14_ = disposition == requested_disposition;
			}
			if (_tmp14_) {
				GMimeStream* stream = NULL;
				GMimeStreamMem* _tmp15_;
				GMimeMessage* _tmp16_;
				GMimeFormatOptions* _tmp17_;
				GMimeFormatOptions* _tmp18_;
				GMimeStream* _tmp19_;
				GMimeDataWrapper* data = NULL;
				GMimeStream* _tmp20_;
				GMimeDataWrapper* _tmp21_;
				GMimePart* part = NULL;
				GMimePart* _tmp22_;
				GMimePart* _tmp23_;
				GMimeDataWrapper* _tmp24_;
				const gchar* _tmp25_ = NULL;
				GMimeMessage* _tmp26_;
				const gchar* _tmp27_;
				GMimePart* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				GMimePart* _tmp31_;
				GearyRFC822Part* _tmp32_;
				GearyRFC822Part* _tmp33_;
				_tmp15_ = (GMimeStreamMem*) g_mime_stream_mem_new ();
				stream = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_mime_stream_get_type (), GMimeStream);
				_tmp16_ = message;
				_tmp17_ = geary_rf_c822_get_format_options ();
				_tmp18_ = _tmp17_;
				_tmp19_ = stream;
				g_mime_object_write_to_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, g_mime_object_get_type (), GMimeObject), _tmp18_, _tmp19_);
				__vala_GMimeFormatOptions_free0 (_tmp18_);
				_tmp20_ = stream;
				_tmp21_ = g_mime_data_wrapper_new_with_stream (_tmp20_, GMIME_CONTENT_ENCODING_BINARY);
				data = _tmp21_;
				_tmp22_ = g_mime_part_new_with_type ("message", "rfc822");
				part = _tmp22_;
				_tmp23_ = part;
				_tmp24_ = data;
				g_mime_part_set_content (_tmp23_, _tmp24_);
				_tmp26_ = message;
				_tmp27_ = g_mime_message_get_subject (_tmp26_);
				_tmp25_ = _tmp27_;
				if (_tmp25_ == NULL) {
					_tmp25_ = _ ("(no subject)");
				}
				_tmp28_ = part;
				_tmp29_ = g_strconcat (_tmp25_, ".eml", NULL);
				_tmp30_ = _tmp29_;
				g_mime_part_set_filename (_tmp28_, _tmp30_);
				_g_free0 (_tmp30_);
				_tmp31_ = part;
				_tmp32_ = geary_rf_c822_part_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, g_mime_object_get_type (), GMimeObject));
				_tmp33_ = _tmp32_;
				gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (attachments, GEE_TYPE_COLLECTION, GeeCollection), _tmp33_);
				_g_object_unref0 (_tmp33_);
				_g_object_unref0 (part);
				_g_object_unref0 (data);
				_g_object_unref0 (stream);
			}
			_tmp34_ = message;
			_tmp35_ = g_mime_message_get_mime_part (_tmp34_);
			geary_rf_c822_message_get_attachments_recursively (self, attachments, _tmp35_, requested_disposition, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (message);
					_g_object_unref0 (messagepart);
					return;
				} else {
					_g_object_unref0 (message);
					_g_object_unref0 (messagepart);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_g_object_unref0 (message);
			_g_object_unref0 (messagepart);
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (root, g_mime_part_get_type ())) {
				GearyRFC822Part* part = NULL;
				GearyRFC822Part* _tmp36_;
				GearyMimeDispositionType actual_disposition = 0;
				GearyRFC822Part* _tmp37_;
				GearyMimeContentDisposition* _tmp38_;
				GearyMimeContentDisposition* _tmp39_;
				gboolean _tmp45_ = FALSE;
				_tmp36_ = geary_rf_c822_part_new (root);
				part = _tmp36_;
				actual_disposition = GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED;
				_tmp37_ = part;
				_tmp38_ = geary_rf_c822_part_get_content_disposition (_tmp37_);
				_tmp39_ = _tmp38_;
				if (_tmp39_ != NULL) {
					GearyRFC822Part* _tmp40_;
					GearyMimeContentDisposition* _tmp41_;
					GearyMimeContentDisposition* _tmp42_;
					GearyMimeDispositionType _tmp43_;
					GearyMimeDispositionType _tmp44_;
					_tmp40_ = part;
					_tmp41_ = geary_rf_c822_part_get_content_disposition (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp43_ = geary_mime_content_disposition_get_disposition_type (_tmp42_);
					_tmp44_ = _tmp43_;
					actual_disposition = _tmp44_;
				}
				if (requested_disposition == GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED) {
					_tmp45_ = TRUE;
				} else {
					_tmp45_ = actual_disposition == requested_disposition;
				}
				if (_tmp45_) {
					GearyMimeContentType* content_type = NULL;
					GearyRFC822Part* _tmp46_;
					GearyMimeContentType* _tmp47_;
					GearyMimeContentType* _tmp48_;
					GearyMimeContentType* _tmp49_;
					GearyMimeContentType* _tmp50_;
					_tmp46_ = part;
					_tmp47_ = geary_rf_c822_part_get_content_type (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = _g_object_ref0 (_tmp48_);
					content_type = _tmp49_;
					_tmp50_ = content_type;
					if (geary_mime_content_type_is_type (_tmp50_, "application", "vnd.ms-tnef")) {
						GMimeStreamMem* stream = NULL;
						GMimeStreamMem* _tmp51_;
						GMimeDataWrapper* _tmp52_;
						GMimeStreamMem* _tmp53_;
						GByteArray* tnef_data = NULL;
						GMimeStreamMem* _tmp54_;
						GByteArray* _tmp55_;
						GByteArray* _tmp56_;
						TNEFStruct tn = {0};
						GByteArray* _tmp57_;
						guint8* _tmp58_;
						gint _tmp58__length1;
						gint _tmp59_;
						_tmp51_ = (GMimeStreamMem*) g_mime_stream_mem_new ();
						stream = _tmp51_;
						_tmp52_ = g_mime_part_get_content (G_TYPE_CHECK_INSTANCE_CAST (root, g_mime_part_get_type (), GMimePart));
						_tmp53_ = stream;
						g_mime_data_wrapper_write_to_stream (_tmp52_, G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, g_mime_stream_get_type (), GMimeStream));
						_tmp54_ = stream;
						_tmp55_ = g_mime_stream_mem_get_byte_array (_tmp54_);
						_tmp56_ = _g_byte_array_ref0 (_tmp55_);
						tnef_data = _tmp56_;
						TNEFInitialize (&tn);
						_tmp57_ = tnef_data;
						_tmp58_ = _tmp57_->data;
						_tmp58__length1 = _tmp57_->len;
						_tmp59_ = TNEFParseMemory (_tmp58_, (gint) _tmp58__length1, &tn);
						if (_tmp59_ == 0) {
							{
								Attachment* a = NULL;
								TNEFStruct _tmp60_;
								Attachment _tmp61_;
								Attachment* _tmp62_;
								_tmp60_ = tn;
								_tmp61_ = _tmp60_.starting_attach;
								_tmp62_ = _tmp61_.next;
								a = _tmp62_;
								{
									gboolean _tmp63_ = FALSE;
									_tmp63_ = TRUE;
									while (TRUE) {
										Attachment* _tmp66_;
										Attachment* _tmp67_;
										Attachment _tmp68_;
										GMimePart* _tmp69_;
										GMimePart* _tmp70_;
										GearyRFC822Part* _tmp71_;
										GearyRFC822Part* _tmp72_;
										if (!_tmp63_) {
											Attachment* _tmp64_;
											Attachment* _tmp65_;
											_tmp64_ = a;
											_tmp65_ = (*_tmp64_).next;
											a = _tmp65_;
										}
										_tmp63_ = FALSE;
										_tmp66_ = a;
										if (!(_tmp66_ != NULL)) {
											break;
										}
										_tmp67_ = a;
										_tmp68_ = *_tmp67_;
										_tmp69_ = geary_rf_c822_message_tnef_attachment_to_gmime_part (self, &_tmp68_);
										_tmp70_ = _tmp69_;
										_tmp71_ = geary_rf_c822_part_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, g_mime_object_get_type (), GMimeObject));
										_tmp72_ = _tmp71_;
										gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (attachments, GEE_TYPE_COLLECTION, GeeCollection), _tmp72_);
										_g_object_unref0 (_tmp72_);
										_g_object_unref0 (_tmp70_);
									}
								}
							}
						}
						TNEFFree (&tn);
						_g_byte_array_unref0 (tnef_data);
						_g_object_unref0 (stream);
					} else {
						gboolean _tmp73_ = FALSE;
						if (actual_disposition == GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT) {
							_tmp73_ = TRUE;
						} else {
							gboolean _tmp74_ = FALSE;
							GearyMimeContentType* _tmp75_;
							_tmp75_ = content_type;
							if (!geary_mime_content_type_is_type (_tmp75_, "text", "plain")) {
								GearyMimeContentType* _tmp76_;
								_tmp76_ = content_type;
								_tmp74_ = !geary_mime_content_type_is_type (_tmp76_, "text", "html");
							} else {
								_tmp74_ = FALSE;
							}
							_tmp73_ = _tmp74_;
						}
						if (_tmp73_) {
							GearyRFC822Part* _tmp77_;
							_tmp77_ = part;
							gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (attachments, GEE_TYPE_COLLECTION, GeeCollection), _tmp77_);
						}
					}
					_g_object_unref0 (content_type);
				}
				_g_object_unref0 (part);
			}
		}
	}
}

static GMimePart*
geary_rf_c822_message_tnef_attachment_to_gmime_part (GearyRFC822Message* self,
                                                     Attachment* a)
{
	variableLength* filenameProp = NULL;
	Attachment _tmp0_;
	MAPIProps _tmp1_;
	variableLength* _tmp2_;
	variableLength* _tmp3_;
	variableLength* _tmp4_;
	gchar* filename = NULL;
	variableLength* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	guint8* data = NULL;
	Attachment _tmp13_;
	variableLength _tmp14_;
	guint8* _tmp15_;
	gint _tmp15__length1;
	GBytes* _tmp16_;
	gsize _tmp17_ = 0;
	guint8* _tmp18_;
	gint data_length1;
	gint _data_size_;
	GMimePart* part = NULL;
	GMimePart* _tmp19_;
	GMimeParserOptions* _tmp20_;
	GMimeParserOptions* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GMimeContentType* _tmp24_;
	GMimeContentType* _tmp25_;
	GMimeStreamMem* _tmp26_;
	GMimeStreamMem* _tmp27_;
	GMimeDataWrapper* _tmp28_;
	GMimeDataWrapper* _tmp29_;
	GMimePart* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	g_return_val_if_fail (a != NULL, NULL);
	_tmp0_ = *a;
	_tmp1_ = _tmp0_.MAPI;
	_tmp2_ = MAPIFindProperty (&_tmp1_, (guint) PROP_TAG (PT_STRING8, PR_ATTACH_LONG_FILENAME));
	filenameProp = _tmp2_;
	_tmp3_ = filenameProp;
	_tmp4_ = MAPI_UNDEFINED;
	if (_tmp3_ == _tmp4_) {
		Attachment _tmp5_;
		MAPIProps _tmp6_;
		variableLength* _tmp7_;
		variableLength* _tmp8_;
		variableLength* _tmp9_;
		_tmp5_ = *a;
		_tmp6_ = _tmp5_.MAPI;
		_tmp7_ = MAPIFindProperty (&_tmp6_, (guint) PROP_TAG (PT_STRING8, PR_DISPLAY_NAME));
		filenameProp = _tmp7_;
		_tmp8_ = filenameProp;
		_tmp9_ = MAPI_UNDEFINED;
		if (_tmp8_ == _tmp9_) {
			filenameProp = &(*a).Title;
		}
	}
	_tmp10_ = filenameProp;
	_tmp11_ = (*_tmp10_).data;
	_tmp11__length1 = (*_tmp10_).size;
	_tmp12_ = g_strdup ((const gchar*) _tmp11_);
	filename = _tmp12_;
	_tmp13_ = *a;
	_tmp14_ = _tmp13_.FileData;
	_tmp15_ = _tmp14_.data;
	_tmp15__length1 = _tmp14_.size;
	_tmp16_ = g_bytes_new (_tmp15_, _tmp15__length1);
	_tmp18_ = g_bytes_unref_to_data (_tmp16_, &_tmp17_);
	data = _tmp18_;
	data_length1 = _tmp17_;
	_data_size_ = data_length1;
	_tmp19_ = g_mime_part_new_with_type ("text", "plain");
	part = _tmp19_;
	g_mime_part_set_filename (part, filename);
	_tmp20_ = geary_rf_c822_get_parser_options ();
	_tmp21_ = _tmp20_;
	_tmp22_ = g_content_type_guess (filename, data, (gsize) data_length1, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_mime_content_type_parse (_tmp21_, _tmp23_);
	_tmp25_ = _tmp24_;
	g_mime_object_set_content_type (G_TYPE_CHECK_INSTANCE_CAST (part, g_mime_object_get_type (), GMimeObject), _tmp25_);
	_g_object_unref0 (_tmp25_);
	_g_free0 (_tmp23_);
	__vala_GMimeParserOptions_free0 (_tmp21_);
	_tmp26_ = (GMimeStreamMem*) g_mime_stream_mem_new_with_buffer (data, data_length1);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_mime_data_wrapper_new_with_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, g_mime_stream_get_type (), GMimeStream), GMIME_CONTENT_ENCODING_BINARY);
	_tmp29_ = _tmp28_;
	g_mime_part_set_content (part, _tmp29_);
	_g_object_unref0 (_tmp29_);
	_g_object_unref0 (_tmp27_);
	result = part;
	data = (g_free (data), NULL);
	_g_free0 (filename);
	return result;
}

GeeList*
geary_rf_c822_message_get_sub_messages (GearyRFC822Message* self,
                                        GError** error)
{
	GeeList* messages = NULL;
	GeeArrayList* _tmp0_;
	GMimeMessage* _tmp1_;
	GMimeObject* _tmp2_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp0_ = gee_array_list_new (GEARY_RF_C822_TYPE_MESSAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	messages = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
	_tmp1_ = self->priv->message;
	_tmp2_ = g_mime_message_get_mime_part (_tmp1_);
	geary_rf_c822_message_find_sub_messages (self, messages, _tmp2_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (messages);
			return NULL;
		} else {
			_g_object_unref0 (messages);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = messages;
	return result;
}

static void
geary_rf_c822_message_find_sub_messages (GearyRFC822Message* self,
                                         GeeList* messages,
                                         GMimeObject* root,
                                         GError** error)
{
	GMimeMultipart* multipart = NULL;
	GMimeMultipart* _tmp0_;
	GMimeMultipart* _tmp1_;
	GMimeMessagePart* messagepart = NULL;
	GMimeMessagePart* _tmp7_;
	GMimeMessagePart* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (messages, GEE_TYPE_LIST));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (root, g_mime_object_get_type ()));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (root, g_mime_multipart_get_type ()) ? ((GMimeMultipart*) root) : NULL);
	multipart = _tmp0_;
	_tmp1_ = multipart;
	if (_tmp1_ != NULL) {
		gint count = 0;
		GMimeMultipart* _tmp2_;
		_tmp2_ = multipart;
		count = g_mime_multipart_get_count (_tmp2_);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					GMimeMultipart* _tmp5_;
					GMimeObject* _tmp6_;
					if (!_tmp3_) {
						gint _tmp4_;
						i = i + 1;
						_tmp4_ = i;
					}
					_tmp3_ = FALSE;
					if (!(i < count)) {
						break;
					}
					_tmp5_ = multipart;
					_tmp6_ = g_mime_multipart_get_part (_tmp5_, i);
					geary_rf_c822_message_find_sub_messages (self, messages, _tmp6_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (multipart);
							return;
						} else {
							_g_object_unref0 (multipart);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
			}
		}
		_g_object_unref0 (multipart);
		return;
	}
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (root, g_mime_message_part_get_type ()) ? ((GMimeMessagePart*) root) : NULL);
	messagepart = _tmp7_;
	_tmp8_ = messagepart;
	if (_tmp8_ != NULL) {
		GMimeMessage* sub_message = NULL;
		GMimeMessagePart* _tmp9_;
		GMimeMessage* _tmp10_;
		GMimeMessage* _tmp11_;
		GMimeMessage* _tmp12_;
		_tmp9_ = messagepart;
		_tmp10_ = g_mime_message_part_get_message (_tmp9_);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		sub_message = _tmp11_;
		_tmp12_ = sub_message;
		if (_tmp12_ != NULL) {
			GearyRFC822Message* _tmp13_ = NULL;
			GMimeMessage* _tmp14_;
			GearyRFC822Message* _tmp15_;
			_tmp14_ = sub_message;
			_tmp15_ = geary_rf_c822_message_new_from_gmime_message (_tmp14_, &_inner_error0_);
			_tmp13_ = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (sub_message);
					_g_object_unref0 (messagepart);
					_g_object_unref0 (multipart);
					return;
				} else {
					_g_object_unref0 (sub_message);
					_g_object_unref0 (messagepart);
					_g_object_unref0 (multipart);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (messages, GEE_TYPE_COLLECTION, GeeCollection), _tmp13_);
			_g_object_unref0 (_tmp13_);
		} else {
			g_warning ("rfc822-message.vala:1125: Corrupt message, possibly bug 769697");
		}
		_g_object_unref0 (sub_message);
	}
	_g_object_unref0 (messagepart);
	_g_object_unref0 (multipart);
}

static GearyMemoryBuffer*
geary_rf_c822_message_message_to_memory_buffer (GearyRFC822Message* self,
                                                gboolean encode_lf,
                                                GearyRFC822MessageRFC822FormatOptions options,
                                                GError** error)
{
	GByteArray* byte_array = NULL;
	GByteArray* _tmp0_;
	GMimeStreamMem* stream = NULL;
	GByteArray* _tmp1_;
	GMimeStreamMem* _tmp2_;
	GMimeStreamMem* _tmp3_;
	GMimeStreamFilter* stream_filter = NULL;
	GMimeStreamMem* _tmp4_;
	GMimeStreamFilter* _tmp5_;
	GMimeFormatOptions* format = NULL;
	GMimeFormatOptions* _tmp15_;
	GMimeMessage* _tmp19_;
	GMimeFormatOptions* _tmp20_;
	GMimeStreamFilter* _tmp21_;
	GMimeStreamFilter* _tmp23_;
	GMimeStreamMem* _tmp25_;
	GByteArray* _tmp27_;
	GearyMemoryByteBuffer* _tmp28_;
	GError* _inner_error0_ = NULL;
	GearyMemoryBuffer* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp0_ = g_byte_array_new ();
	byte_array = _tmp0_;
	_tmp1_ = byte_array;
	_tmp2_ = (GMimeStreamMem*) g_mime_stream_mem_new_with_byte_array (_tmp1_);
	stream = _tmp2_;
	_tmp3_ = stream;
	g_mime_stream_mem_set_owner (_tmp3_, FALSE);
	_tmp4_ = stream;
	_tmp5_ = (GMimeStreamFilter*) g_mime_stream_filter_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_mime_stream_get_type (), GMimeStream));
	stream_filter = _tmp5_;
	if (encode_lf) {
		GMimeStreamFilter* _tmp6_;
		GMimeFilterUnix2Dos* _tmp7_;
		GMimeFilterUnix2Dos* _tmp8_;
		_tmp6_ = stream_filter;
		_tmp7_ = (GMimeFilterUnix2Dos*) g_mime_filter_unix2dos_new (FALSE);
		_tmp8_ = _tmp7_;
		g_mime_stream_filter_add (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_mime_filter_get_type (), GMimeFilter));
		_g_object_unref0 (_tmp8_);
	} else {
		GMimeStreamFilter* _tmp9_;
		GMimeFilterDos2Unix* _tmp10_;
		GMimeFilterDos2Unix* _tmp11_;
		_tmp9_ = stream_filter;
		_tmp10_ = (GMimeFilterDos2Unix*) g_mime_filter_dos2unix_new (FALSE);
		_tmp11_ = _tmp10_;
		g_mime_stream_filter_add (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_mime_filter_get_type (), GMimeFilter));
		_g_object_unref0 (_tmp11_);
	}
	if ((options & GEARY_RF_C822_MESSAGE_RF_C822_FORMAT_OPTIONS_SMTP_FORMAT) == GEARY_RF_C822_MESSAGE_RF_C822_FORMAT_OPTIONS_SMTP_FORMAT) {
		GMimeStreamFilter* _tmp12_;
		GMimeFilterSmtpData* _tmp13_;
		GMimeFilterSmtpData* _tmp14_;
		_tmp12_ = stream_filter;
		_tmp13_ = (GMimeFilterSmtpData*) g_mime_filter_smtp_data_new ();
		_tmp14_ = _tmp13_;
		g_mime_stream_filter_add (_tmp12_, G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_mime_filter_get_type (), GMimeFilter));
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = geary_rf_c822_get_format_options ();
	format = _tmp15_;
	if ((options & GEARY_RF_C822_MESSAGE_RF_C822_FORMAT_OPTIONS_SMTP_FORMAT) == GEARY_RF_C822_MESSAGE_RF_C822_FORMAT_OPTIONS_SMTP_FORMAT) {
		GMimeFormatOptions* _tmp16_;
		GMimeFormatOptions* _tmp17_;
		GMimeFormatOptions* _tmp18_;
		_tmp16_ = format;
		_tmp17_ = g_mime_format_options_clone (_tmp16_);
		__vala_GMimeFormatOptions_free0 (format);
		format = _tmp17_;
		_tmp18_ = format;
		g_mime_format_options_add_hidden_header (_tmp18_, "Bcc");
	}
	_tmp19_ = self->priv->message;
	_tmp20_ = format;
	_tmp21_ = stream_filter;
	if (g_mime_object_write_to_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, g_mime_object_get_type (), GMimeObject), _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_mime_stream_get_type (), GMimeStream)) < ((gssize) 0)) {
		GError* _tmp22_;
		_tmp22_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_FAILED, "Unable to write RFC822 message to filter stream");
		_inner_error0_ = _tmp22_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			__vala_GMimeFormatOptions_free0 (format);
			_g_object_unref0 (stream_filter);
			_g_object_unref0 (stream);
			_g_byte_array_unref0 (byte_array);
			return NULL;
		} else {
			__vala_GMimeFormatOptions_free0 (format);
			_g_object_unref0 (stream_filter);
			_g_object_unref0 (stream);
			_g_byte_array_unref0 (byte_array);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp23_ = stream_filter;
	if (g_mime_stream_flush (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, g_mime_stream_get_type (), GMimeStream)) != 0) {
		GError* _tmp24_;
		_tmp24_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_FAILED, "Unable to flush RFC822 message to memory stream");
		_inner_error0_ = _tmp24_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			__vala_GMimeFormatOptions_free0 (format);
			_g_object_unref0 (stream_filter);
			_g_object_unref0 (stream);
			_g_byte_array_unref0 (byte_array);
			return NULL;
		} else {
			__vala_GMimeFormatOptions_free0 (format);
			_g_object_unref0 (stream_filter);
			_g_object_unref0 (stream);
			_g_byte_array_unref0 (byte_array);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp25_ = stream;
	if (g_mime_stream_flush (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, g_mime_stream_get_type (), GMimeStream)) != 0) {
		GError* _tmp26_;
		_tmp26_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_FAILED, "Unable to flush RFC822 message to memory buffer");
		_inner_error0_ = _tmp26_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			__vala_GMimeFormatOptions_free0 (format);
			_g_object_unref0 (stream_filter);
			_g_object_unref0 (stream);
			_g_byte_array_unref0 (byte_array);
			return NULL;
		} else {
			__vala_GMimeFormatOptions_free0 (format);
			_g_object_unref0 (stream_filter);
			_g_object_unref0 (stream);
			_g_byte_array_unref0 (byte_array);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp27_ = byte_array;
	_tmp28_ = geary_memory_byte_buffer_new_from_byte_array (_tmp27_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
	__vala_GMimeFormatOptions_free0 (format);
	_g_object_unref0 (stream_filter);
	_g_object_unref0 (stream);
	_g_byte_array_unref0 (byte_array);
	return result;
}

gchar*
geary_rf_c822_message_to_string (GearyRFC822Message* self)
{
	GMimeMessage* _tmp0_;
	GMimeFormatOptions* _tmp1_;
	GMimeFormatOptions* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_MESSAGE (self), NULL);
	_tmp0_ = self->priv->message;
	_tmp1_ = geary_rf_c822_get_format_options ();
	_tmp2_ = _tmp1_;
	_tmp3_ = g_mime_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_mime_object_get_type (), GMimeObject), _tmp2_);
	_tmp4_ = _tmp3_;
	__vala_GMimeFormatOptions_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static void
geary_rf_c822_message_body_data_to_part_data_free (gpointer _data)
{
	GearyRfC822MessageBodyDataToPartData* _data_;
	_data_ = _data;
	_g_free0 (_data_->charset);
	_g_free0 (_data_->content_type);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyRfC822MessageBodyDataToPartData, _data_);
}

static void
geary_rf_c822_message_body_data_to_part (GearyRFC822Message* self,
                                         guint8* content,
                                         gint content_length1,
                                         const gchar* charset,
                                         const gchar* content_type,
                                         gboolean is_flowed,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GearyRfC822MessageBodyDataToPartData* _data_;
	GearyRFC822Message* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (self));
	g_return_if_fail (content_type != NULL);
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyRfC822MessageBodyDataToPartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_rf_c822_message_body_data_to_part_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->content = content;
	_data_->content_length1 = content_length1;
	_tmp1_ = g_strdup (charset);
	_g_free0 (_data_->charset);
	_data_->charset = _tmp1_;
	_tmp2_ = g_strdup (content_type);
	_g_free0 (_data_->content_type);
	_data_->content_type = _tmp2_;
	_data_->is_flowed = is_flowed;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_rf_c822_message_body_data_to_part_co (_data_);
}

static GMimePart*
geary_rf_c822_message_body_data_to_part_finish (GearyRFC822Message* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GMimePart* result;
	GearyRfC822MessageBodyDataToPartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns a MIME part for some body content.
     *
     * Determining the appropriate body charset and encoding is
     * unfortunately a multi-step process that involves reading it
     * completely, several times:
     *
     * 1. Guess the best charset by scanning the complete body.
     * 2. Convert the body into the preferred charset, essential
     *    to avoid e.g. guessing Base64 encoding for ISO-8859-1
     *    because of the 0x0's present in UTF bytes with high-bit
     *    chars.
     * 3. Determine, given the correctly encoded charset
     *    what the appropriate encoding is by scanning the
     *    complete, encoded body.
     *
     * This applies to both text/plain and text/html parts, but we
     * don't need to do it repeatedly for each, since HTML is 7-bit
     * clean ASCII. So if we have guessed both already for a plain
     * text body, it will still apply for any HTML part.
     */
static void
geary_rf_c822_message_body_data_to_part_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GearyRfC822MessageBodyDataToPartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_rf_c822_message_body_data_to_part_co (_data_);
}

static gboolean
geary_rf_c822_message_body_data_to_part_co (GearyRfC822MessageBodyDataToPartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = (GMimeStreamMem*) g_mime_stream_mem_new_with_buffer (_data_->content, _data_->content_length1);
	_data_->content_stream = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, g_mime_stream_get_type (), GMimeStream);
	if (_data_->charset == NULL) {
		gchar* _tmp4_;
		_data_->_tmp2_ = _data_->content_stream;
		_data_->_state_ = 1;
		geary_rf_c822_utils_get_best_charset (_data_->_tmp2_, _data_->cancellable, geary_rf_c822_message_body_data_to_part_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = geary_rf_c822_utils_get_best_charset_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->content_stream);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_tmp4_ = g_strdup (_data_->_tmp1_);
		_g_free0 (_data_->charset);
		_data_->charset = _tmp4_;
		_g_free0 (_data_->_tmp1_);
	}
	_data_->_tmp5_ = _data_->content_stream;
	_data_->_tmp6_ = (GMimeStreamFilter*) g_mime_stream_filter_new (_data_->_tmp5_);
	_data_->filter_stream = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->filter_stream;
	_data_->_tmp8_ = (GMimeFilterCharset*) g_mime_filter_charset_new (GEARY_RF_C822_UTF8_CHARSET, _data_->charset);
	_data_->_tmp9_ = _data_->_tmp8_;
	g_mime_stream_filter_add (_data_->_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, g_mime_filter_get_type (), GMimeFilter));
	_g_object_unref0 (_data_->_tmp9_);
	_data_->_tmp10_ = _data_->filter_stream;
	_data_->_state_ = 2;
	geary_rf_c822_utils_get_best_encoding (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, g_mime_stream_get_type (), GMimeStream), GMIME_ENCODING_CONSTRAINT_7BIT, _data_->cancellable, geary_rf_c822_message_body_data_to_part_ready, _data_);
	return FALSE;
	_state_2:
	_data_->encoding = geary_rf_c822_utils_get_best_encoding_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->filter_stream);
		_g_object_unref0 (_data_->content_stream);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->is_flowed) {
		_data_->_tmp11_ = _data_->encoding == GMIME_CONTENT_ENCODING_BASE64;
	} else {
		_data_->_tmp11_ = FALSE;
	}
	if (_data_->_tmp11_) {
		_data_->_tmp12_ = _data_->filter_stream;
		_data_->_tmp13_ = (GMimeFilterUnix2Dos*) g_mime_filter_unix2dos_new (FALSE);
		_data_->_tmp14_ = _data_->_tmp13_;
		g_mime_stream_filter_add (_data_->_tmp12_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, g_mime_filter_get_type (), GMimeFilter));
		_g_object_unref0 (_data_->_tmp14_);
	}
	_data_->_tmp15_ = geary_rf_c822_get_parser_options ();
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_mime_content_type_parse (_data_->_tmp16_, _data_->content_type);
	_data_->_tmp18_ = _data_->_tmp17_;
	__vala_GMimeParserOptions_free0 (_data_->_tmp16_);
	_data_->complete_type = _data_->_tmp18_;
	_data_->_tmp19_ = _data_->complete_type;
	g_mime_content_type_set_parameter (_data_->_tmp19_, "charset", _data_->charset);
	if (_data_->is_flowed) {
		_data_->_tmp20_ = _data_->complete_type;
		g_mime_content_type_set_parameter (_data_->_tmp20_, "format", "flowed");
	}
	_data_->_tmp21_ = _data_->filter_stream;
	_data_->_tmp22_ = g_mime_data_wrapper_new_with_stream (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, g_mime_stream_get_type (), GMimeStream), GMIME_CONTENT_ENCODING_DEFAULT);
	_data_->body = _data_->_tmp22_;
	_data_->_tmp23_ = g_mime_part_new_with_type ("text", "plain");
	_data_->body_part = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->body_part;
	_data_->_tmp25_ = _data_->complete_type;
	g_mime_object_set_content_type (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, g_mime_object_get_type (), GMimeObject), _data_->_tmp25_);
	_data_->_tmp26_ = _data_->body_part;
	_data_->_tmp27_ = _data_->body;
	g_mime_part_set_content (_data_->_tmp26_, _data_->_tmp27_);
	_data_->_tmp28_ = _data_->body_part;
	g_mime_part_set_content_encoding (_data_->_tmp28_, _data_->encoding);
	_data_->result = _data_->body_part;
	_g_object_unref0 (_data_->body);
	_g_object_unref0 (_data_->complete_type);
	_g_object_unref0 (_data_->filter_stream);
	_g_object_unref0 (_data_->content_stream);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_rf_c822_message_class_init (GearyRFC822MessageClass * klass,
                                  gpointer klass_data)
{
	geary_rf_c822_message_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyRFC822Message_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_rf_c822_message_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_rf_c822_message_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_rf_c822_message_finalize;
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_FROM_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_FROM_PROPERTY] = g_param_spec_object ("from", "from", "from", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_SENDER_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_SENDER_PROPERTY] = g_param_spec_object ("sender", "sender", "sender", GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_REPLY_TO_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_REPLY_TO_PROPERTY] = g_param_spec_object ("reply-to", "reply-to", "reply-to", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_TO_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_TO_PROPERTY] = g_param_spec_object ("to", "to", "to", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_CC_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_CC_PROPERTY] = g_param_spec_object ("cc", "cc", "cc", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_BCC_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_BCC_PROPERTY] = g_param_spec_object ("bcc", "bcc", "bcc", GEARY_RF_C822_TYPE_MAILBOX_ADDRESSES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_MESSAGE_ID_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_MESSAGE_ID_PROPERTY] = g_param_spec_object ("message-id", "message-id", "message-id", GEARY_RF_C822_TYPE_MESSAGE_ID, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_IN_REPLY_TO_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_IN_REPLY_TO_PROPERTY] = g_param_spec_object ("in-reply-to", "in-reply-to", "in-reply-to", GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_REFERENCES_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_REFERENCES_PROPERTY] = g_param_spec_object ("references", "references", "references", GEARY_RF_C822_TYPE_MESSAGE_ID_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_SUBJECT_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_SUBJECT_PROPERTY] = g_param_spec_object ("subject", "subject", "subject", GEARY_RF_C822_TYPE_SUBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_DATE_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_DATE_PROPERTY] = g_param_spec_object ("date", "date", "date", GEARY_RF_C822_TYPE_DATE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     *
	     * Value will be valid if {@link Field.AUTH_RESULTS} is set.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_AUTH_RESULTS_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_AUTH_RESULTS_PROPERTY] = g_param_spec_object ("auth-results", "auth-results", "auth-results", GEARY_RF_C822_TYPE_AUTHENTICATION_RESULTS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Value of the X-Mailer header. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_MESSAGE_MAILER_PROPERTY, geary_rf_c822_message_properties[GEARY_RF_C822_MESSAGE_MAILER_PROPERTY] = g_param_spec_string ("mailer", "mailer", "mailer", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
geary_rf_c822_message_geary_email_header_set_interface_init (GearyEmailHeaderSetIface * iface,
                                                             gpointer iface_data)
{
	geary_rf_c822_message_geary_email_header_set_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_from = geary_rf_c822_message_real_get_from;
	iface->get_sender = geary_rf_c822_message_real_get_sender;
	iface->get_reply_to = geary_rf_c822_message_real_get_reply_to;
	iface->get_to = geary_rf_c822_message_real_get_to;
	iface->get_cc = geary_rf_c822_message_real_get_cc;
	iface->get_bcc = geary_rf_c822_message_real_get_bcc;
	iface->get_message_id = geary_rf_c822_message_real_get_message_id;
	iface->get_in_reply_to = geary_rf_c822_message_real_get_in_reply_to;
	iface->get_references = geary_rf_c822_message_real_get_references;
	iface->get_subject = geary_rf_c822_message_real_get_subject;
	iface->get_date = geary_rf_c822_message_real_get_date;
}

static void
geary_rf_c822_message_instance_init (GearyRFC822Message * self,
                                     gpointer klass)
{
	self->priv = geary_rf_c822_message_get_instance_private (self);
	self->priv->_from = NULL;
	self->priv->_sender = NULL;
	self->priv->_reply_to = NULL;
	self->priv->_to = NULL;
	self->priv->_cc = NULL;
	self->priv->_bcc = NULL;
	self->priv->_message_id = NULL;
	self->priv->_in_reply_to = NULL;
	self->priv->_references = NULL;
	self->priv->_subject = NULL;
	self->priv->_date = NULL;
	self->priv->_auth_results = NULL;
	self->priv->_mailer = NULL;
}

static void
geary_rf_c822_message_finalize (GObject * obj)
{
	GearyRFC822Message * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	_g_object_unref0 (self->priv->_from);
	_g_object_unref0 (self->priv->_sender);
	_g_object_unref0 (self->priv->_reply_to);
	_g_object_unref0 (self->priv->_to);
	_g_object_unref0 (self->priv->_cc);
	_g_object_unref0 (self->priv->_bcc);
	_g_object_unref0 (self->priv->_message_id);
	_g_object_unref0 (self->priv->_in_reply_to);
	_g_object_unref0 (self->priv->_references);
	_g_object_unref0 (self->priv->_subject);
	_g_object_unref0 (self->priv->_date);
	_g_object_unref0 (self->priv->_auth_results);
	_g_free0 (self->priv->_mailer);
	_g_object_unref0 (self->priv->message);
	G_OBJECT_CLASS (geary_rf_c822_message_parent_class)->finalize (obj);
}

/**
 * An RFC-822 style email message.
 *
 * Unlike {@link Email}, these objects are always a complete
 * representation of an email message, and contain no information
 * other than what RFC-822 and its successor RFC documents specify.
 */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_message_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822MessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822Message), 0, (GInstanceInitFunc) geary_rf_c822_message_instance_init, NULL };
	static const GInterfaceInfo geary_email_header_set_info = { (GInterfaceInitFunc) geary_rf_c822_message_geary_email_header_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_rf_c822_message_type_id;
	geary_rf_c822_message_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyRFC822Message", &g_define_type_info, 0);
	g_type_add_interface_static (geary_rf_c822_message_type_id, GEARY_TYPE_EMAIL_HEADER_SET, &geary_email_header_set_info);
	GearyRFC822Message_private_offset = g_type_add_instance_private (geary_rf_c822_message_type_id, sizeof (GearyRFC822MessagePrivate));
	return geary_rf_c822_message_type_id;
}

GType
geary_rf_c822_message_get_type (void)
{
	static gsize geary_rf_c822_message_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_message_type_id__once)) {
		GType geary_rf_c822_message_type_id;
		geary_rf_c822_message_type_id = geary_rf_c822_message_get_type_once ();
		g_once_init_leave (&geary_rf_c822_message_type_id__once, geary_rf_c822_message_type_id);
	}
	return geary_rf_c822_message_type_id__once;
}

static void
_vala_geary_rf_c822_message_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GearyRFC822Message * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	switch (property_id) {
		case GEARY_RF_C822_MESSAGE_FROM_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_SENDER_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_REPLY_TO_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_reply_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_TO_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_CC_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_BCC_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_MESSAGE_ID_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_IN_REPLY_TO_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_REFERENCES_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_SUBJECT_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_DATE_PROPERTY:
		g_value_set_object (value, geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet)));
		break;
		case GEARY_RF_C822_MESSAGE_AUTH_RESULTS_PROPERTY:
		g_value_set_object (value, geary_rf_c822_message_get_auth_results (self));
		break;
		case GEARY_RF_C822_MESSAGE_MAILER_PROPERTY:
		g_value_set_string (value, geary_rf_c822_message_get_mailer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_rf_c822_message_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GearyRFC822Message * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TYPE_MESSAGE, GearyRFC822Message);
	switch (property_id) {
		case GEARY_RF_C822_MESSAGE_MAILER_PROPERTY:
		geary_rf_c822_message_set_mailer (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

