/* rfc822-part.c generated by valac 0.56.3, the Vala compiler
 * generated from rfc822-part.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gmime/gmime.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	GEARY_RF_C822_PART_0_PROPERTY,
	GEARY_RF_C822_PART_CONTENT_TYPE_PROPERTY,
	GEARY_RF_C822_PART_CONTENT_ID_PROPERTY,
	GEARY_RF_C822_PART_CONTENT_DESCRIPTION_PROPERTY,
	GEARY_RF_C822_PART_CONTENT_DISPOSITION_PROPERTY,
	GEARY_RF_C822_PART_NUM_PROPERTIES
};
static GParamSpec* geary_rf_c822_part_properties[GEARY_RF_C822_PART_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))

#define GEARY_RF_C822_TYPE_FILTER_FLOWED (geary_rf_c822_filter_flowed_get_type ())
#define GEARY_RF_C822_FILTER_FLOWED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_RF_C822_TYPE_FILTER_FLOWED, GearyRFC822FilterFlowed))
#define GEARY_RF_C822_FILTER_FLOWED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_RF_C822_TYPE_FILTER_FLOWED, GearyRFC822FilterFlowedClass))
#define GEARY_RF_C822_IS_FILTER_FLOWED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_RF_C822_TYPE_FILTER_FLOWED))
#define GEARY_RF_C822_IS_FILTER_FLOWED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_RF_C822_TYPE_FILTER_FLOWED))
#define GEARY_RF_C822_FILTER_FLOWED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_RF_C822_TYPE_FILTER_FLOWED, GearyRFC822FilterFlowedClass))

typedef struct _GearyRFC822FilterFlowed GearyRFC822FilterFlowed;
typedef struct _GearyRFC822FilterFlowedClass GearyRFC822FilterFlowedClass;

#define GEARY_RF_C822_TYPE_FILTER_PLAIN (geary_rf_c822_filter_plain_get_type ())
#define GEARY_RF_C822_FILTER_PLAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_RF_C822_TYPE_FILTER_PLAIN, GearyRFC822FilterPlain))
#define GEARY_RF_C822_FILTER_PLAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_RF_C822_TYPE_FILTER_PLAIN, GearyRFC822FilterPlainClass))
#define GEARY_RF_C822_IS_FILTER_PLAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_RF_C822_TYPE_FILTER_PLAIN))
#define GEARY_RF_C822_IS_FILTER_PLAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_RF_C822_TYPE_FILTER_PLAIN))
#define GEARY_RF_C822_FILTER_PLAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_RF_C822_TYPE_FILTER_PLAIN, GearyRFC822FilterPlainClass))

typedef struct _GearyRFC822FilterPlain GearyRFC822FilterPlain;
typedef struct _GearyRFC822FilterPlainClass GearyRFC822FilterPlainClass;

#define GEARY_RF_C822_TYPE_FILTER_BLOCKQUOTES (geary_rf_c822_filter_blockquotes_get_type ())
#define GEARY_RF_C822_FILTER_BLOCKQUOTES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_RF_C822_TYPE_FILTER_BLOCKQUOTES, GearyRFC822FilterBlockquotes))
#define GEARY_RF_C822_FILTER_BLOCKQUOTES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_RF_C822_TYPE_FILTER_BLOCKQUOTES, GearyRFC822FilterBlockquotesClass))
#define GEARY_RF_C822_IS_FILTER_BLOCKQUOTES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_RF_C822_TYPE_FILTER_BLOCKQUOTES))
#define GEARY_RF_C822_IS_FILTER_BLOCKQUOTES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_RF_C822_TYPE_FILTER_BLOCKQUOTES))
#define GEARY_RF_C822_FILTER_BLOCKQUOTES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_RF_C822_TYPE_FILTER_BLOCKQUOTES, GearyRFC822FilterBlockquotesClass))

typedef struct _GearyRFC822FilterBlockquotes GearyRFC822FilterBlockquotes;
typedef struct _GearyRFC822FilterBlockquotesClass GearyRFC822FilterBlockquotesClass;

struct _GearyRFC822PartPrivate {
	GearyMimeContentType* _content_type;
	gchar* _content_id;
	gchar* _content_description;
	GearyMimeContentDisposition* _content_disposition;
	GMimeObject* source_object;
	GMimePart* source_part;
};

static gint GearyRFC822Part_private_offset;
static gpointer geary_rf_c822_part_parent_class = NULL;
static GeeSet* geary_rf_c822_part_CR_PRESERVING_TEXT_TYPES;
static GeeSet* geary_rf_c822_part_CR_PRESERVING_TEXT_TYPES = NULL;
VALA_EXTERN GRegex* geary_rf_c822_invalid_filename_character_re;

static void geary_rf_c822_part_set_content_type (GearyRFC822Part* self,
                                          GearyMimeContentType* value);
static void geary_rf_c822_part_set_content_id (GearyRFC822Part* self,
                                        const gchar* value);
static void geary_rf_c822_part_set_content_description (GearyRFC822Part* self,
                                                 const gchar* value);
static void geary_rf_c822_part_set_content_disposition (GearyRFC822Part* self,
                                                 GearyMimeContentDisposition* value);
VALA_EXTERN GearyRFC822Part* geary_rf_c822_part_new (GMimeObject* source);
VALA_EXTERN GearyRFC822Part* geary_rf_c822_part_construct (GType object_type,
                                               GMimeObject* source);
VALA_EXTERN GearyMimeContentDisposition* geary_mime_content_disposition_new_from_gmime (GMimeContentDisposition* content_disposition);
VALA_EXTERN GearyMimeContentDisposition* geary_mime_content_disposition_construct_from_gmime (GType object_type,
                                                                                  GMimeContentDisposition* content_disposition);
VALA_EXTERN GearyMimeContentType* geary_mime_content_type_new_from_gmime (GMimeContentType* content_type);
VALA_EXTERN GearyMimeContentType* geary_mime_content_type_construct_from_gmime (GType object_type,
                                                                    GMimeContentType* content_type);
VALA_EXTERN void geary_rf_c822_part_write_to_stream (GearyRFC822Part* self,
                                         GMimeStream* destination,
                                         GearyRFC822PartEncodingConversion conversion,
                                         GearyRFC822PartBodyFormatting format,
                                         GError** error);
VALA_EXTERN gboolean geary_rf_c822_is_utf_8 (const gchar* charset);
VALA_EXTERN GearyRFC822FilterFlowed* geary_rf_c822_filter_flowed_new (gboolean to_html,
                                                          gboolean delsp);
VALA_EXTERN GearyRFC822FilterFlowed* geary_rf_c822_filter_flowed_construct (GType object_type,
                                                                gboolean to_html,
                                                                gboolean delsp);
VALA_EXTERN GType geary_rf_c822_filter_flowed_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyRFC822FilterPlain* geary_rf_c822_filter_plain_new (void);
VALA_EXTERN GearyRFC822FilterPlain* geary_rf_c822_filter_plain_construct (GType object_type);
VALA_EXTERN GType geary_rf_c822_filter_plain_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyRFC822FilterBlockquotes* geary_rf_c822_filter_blockquotes_new (void);
VALA_EXTERN GearyRFC822FilterBlockquotes* geary_rf_c822_filter_blockquotes_construct (GType object_type);
VALA_EXTERN GType geary_rf_c822_filter_blockquotes_get_type (void) G_GNUC_CONST ;
static void geary_rf_c822_part_finalize (GObject * obj);
static GType geary_rf_c822_part_get_type_once (void);
static void _vala_geary_rf_c822_part_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_geary_rf_c822_part_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);

static inline gpointer
geary_rf_c822_part_get_instance_private (GearyRFC822Part* self)
{
	return G_STRUCT_MEMBER_P (self, GearyRFC822Part_private_offset);
}

/** Specifies a character set encoding when writing text bodies. */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_part_encoding_conversion_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_RF_C822_PART_ENCODING_CONVERSION_NONE, "GEARY_RF_C822_PART_ENCODING_CONVERSION_NONE", "none"}, {GEARY_RF_C822_PART_ENCODING_CONVERSION_UTF8, "GEARY_RF_C822_PART_ENCODING_CONVERSION_UTF8", "utf8"}, {0, NULL, NULL}};
	GType geary_rf_c822_part_encoding_conversion_type_id;
	geary_rf_c822_part_encoding_conversion_type_id = g_enum_register_static ("GearyRFC822PartEncodingConversion", values);
	return geary_rf_c822_part_encoding_conversion_type_id;
}

GType
geary_rf_c822_part_encoding_conversion_get_type (void)
{
	static gsize geary_rf_c822_part_encoding_conversion_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_part_encoding_conversion_type_id__once)) {
		GType geary_rf_c822_part_encoding_conversion_type_id;
		geary_rf_c822_part_encoding_conversion_type_id = geary_rf_c822_part_encoding_conversion_get_type_once ();
		g_once_init_leave (&geary_rf_c822_part_encoding_conversion_type_id__once, geary_rf_c822_part_encoding_conversion_type_id);
	}
	return geary_rf_c822_part_encoding_conversion_type_id__once;
}

/** Specifies a format to apply when writing text bodies. */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_part_body_formatting_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_RF_C822_PART_BODY_FORMATTING_NONE, "GEARY_RF_C822_PART_BODY_FORMATTING_NONE", "none"}, {GEARY_RF_C822_PART_BODY_FORMATTING_HTML, "GEARY_RF_C822_PART_BODY_FORMATTING_HTML", "html"}, {0, NULL, NULL}};
	GType geary_rf_c822_part_body_formatting_type_id;
	geary_rf_c822_part_body_formatting_type_id = g_enum_register_static ("GearyRFC822PartBodyFormatting", values);
	return geary_rf_c822_part_body_formatting_type_id;
}

GType
geary_rf_c822_part_body_formatting_get_type (void)
{
	static gsize geary_rf_c822_part_body_formatting_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_part_body_formatting_type_id__once)) {
		GType geary_rf_c822_part_body_formatting_type_id;
		geary_rf_c822_part_body_formatting_type_id = geary_rf_c822_part_body_formatting_get_type_once ();
		g_once_init_leave (&geary_rf_c822_part_body_formatting_type_id__once, geary_rf_c822_part_body_formatting_type_id);
	}
	return geary_rf_c822_part_body_formatting_type_id__once;
}

GearyMimeContentType*
geary_rf_c822_part_get_content_type (GearyRFC822Part* self)
{
	GearyMimeContentType* result;
	GearyMimeContentType* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_PART (self), NULL);
	_tmp0_ = self->priv->_content_type;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_rf_c822_part_set_content_type (GearyRFC822Part* self,
                                     GearyMimeContentType* value)
{
	GearyMimeContentType* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_PART (self));
	old_value = geary_rf_c822_part_get_content_type (self);
	if (old_value != value) {
		GearyMimeContentType* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_content_type);
		self->priv->_content_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_part_properties[GEARY_RF_C822_PART_CONTENT_TYPE_PROPERTY]);
	}
}

const gchar*
geary_rf_c822_part_get_content_id (GearyRFC822Part* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_PART (self), NULL);
	_tmp0_ = self->priv->_content_id;
	result = _tmp0_;
	return result;
}

static void
geary_rf_c822_part_set_content_id (GearyRFC822Part* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_PART (self));
	old_value = geary_rf_c822_part_get_content_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_content_id);
		self->priv->_content_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_part_properties[GEARY_RF_C822_PART_CONTENT_ID_PROPERTY]);
	}
}

const gchar*
geary_rf_c822_part_get_content_description (GearyRFC822Part* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_PART (self), NULL);
	_tmp0_ = self->priv->_content_description;
	result = _tmp0_;
	return result;
}

static void
geary_rf_c822_part_set_content_description (GearyRFC822Part* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_PART (self));
	old_value = geary_rf_c822_part_get_content_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_content_description);
		self->priv->_content_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_part_properties[GEARY_RF_C822_PART_CONTENT_DESCRIPTION_PROPERTY]);
	}
}

GearyMimeContentDisposition*
geary_rf_c822_part_get_content_disposition (GearyRFC822Part* self)
{
	GearyMimeContentDisposition* result;
	GearyMimeContentDisposition* _tmp0_;
	g_return_val_if_fail (GEARY_RF_C822_IS_PART (self), NULL);
	_tmp0_ = self->priv->_content_disposition;
	result = _tmp0_;
	return result;
}

static void
geary_rf_c822_part_set_content_disposition (GearyRFC822Part* self,
                                            GearyMimeContentDisposition* value)
{
	GearyMimeContentDisposition* old_value;
	g_return_if_fail (GEARY_RF_C822_IS_PART (self));
	old_value = geary_rf_c822_part_get_content_disposition (self);
	if (old_value != value) {
		GearyMimeContentDisposition* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_content_disposition);
		self->priv->_content_disposition = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_rf_c822_part_properties[GEARY_RF_C822_PART_CONTENT_DISPOSITION_PROPERTY]);
	}
}

GearyRFC822Part*
geary_rf_c822_part_construct (GType object_type,
                              GMimeObject* source)
{
	GearyRFC822Part * self = NULL;
	GMimeObject* _tmp0_;
	GMimePart* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	GMimePart* _tmp4_;
	GMimeContentDisposition* part_disposition = NULL;
	GMimeContentDisposition* _tmp7_;
	GMimeContentDisposition* _tmp8_;
	GMimeContentDisposition* _tmp9_;
	GMimeContentType* part_type = NULL;
	GMimeContentType* _tmp13_;
	GMimeContentType* _tmp14_;
	GMimeContentType* _tmp15_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (source, g_mime_object_get_type ()), NULL);
	self = (GearyRFC822Part*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (self->priv->source_object);
	self->priv->source_object = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (source, g_mime_part_get_type ()) ? ((GMimePart*) source) : NULL);
	_g_object_unref0 (self->priv->source_part);
	self->priv->source_part = _tmp1_;
	_tmp2_ = g_mime_object_get_content_id (source);
	geary_rf_c822_part_set_content_id (self, _tmp2_);
	_tmp4_ = self->priv->source_part;
	if (_tmp4_ != NULL) {
		GMimePart* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->priv->source_part;
		_tmp6_ = g_mime_part_get_content_description (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = NULL;
	}
	geary_rf_c822_part_set_content_description (self, _tmp3_);
	_tmp7_ = g_mime_object_get_content_disposition (source);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	part_disposition = _tmp8_;
	_tmp9_ = part_disposition;
	if (_tmp9_ != NULL) {
		GMimeContentDisposition* _tmp10_;
		GearyMimeContentDisposition* _tmp11_;
		GearyMimeContentDisposition* _tmp12_;
		_tmp10_ = part_disposition;
		_tmp11_ = geary_mime_content_disposition_new_from_gmime (_tmp10_);
		_tmp12_ = _tmp11_;
		geary_rf_c822_part_set_content_disposition (self, _tmp12_);
		_g_object_unref0 (_tmp12_);
	}
	_tmp13_ = g_mime_object_get_content_type (source);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	part_type = _tmp14_;
	_tmp15_ = part_type;
	if (_tmp15_ != NULL) {
		GMimeContentType* _tmp16_;
		GearyMimeContentType* _tmp17_;
		GearyMimeContentType* _tmp18_;
		_tmp16_ = part_type;
		_tmp17_ = geary_mime_content_type_new_from_gmime (_tmp16_);
		_tmp18_ = _tmp17_;
		geary_rf_c822_part_set_content_type (self, _tmp18_);
		_g_object_unref0 (_tmp18_);
	} else {
		GearyMimeDispositionType disposition = 0;
		GearyMimeContentDisposition* _tmp19_;
		GearyMimeContentType* _tmp23_ = NULL;
		disposition = GEARY_MIME_DISPOSITION_TYPE_UNSPECIFIED;
		_tmp19_ = self->priv->_content_disposition;
		if (_tmp19_ != NULL) {
			GearyMimeContentDisposition* _tmp20_;
			GearyMimeDispositionType _tmp21_;
			GearyMimeDispositionType _tmp22_;
			_tmp20_ = self->priv->_content_disposition;
			_tmp21_ = geary_mime_content_disposition_get_disposition_type (_tmp20_);
			_tmp22_ = _tmp21_;
			disposition = _tmp22_;
		}
		if (disposition != GEARY_MIME_DISPOSITION_TYPE_ATTACHMENT) {
			GearyMimeContentType* _tmp24_;
			_tmp24_ = geary_mime_content_type_DISPLAY_DEFAULT;
			_tmp23_ = _tmp24_;
		} else {
			GearyMimeContentType* _tmp25_;
			_tmp25_ = geary_mime_content_type_ATTACHMENT_DEFAULT;
			_tmp23_ = _tmp25_;
		}
		geary_rf_c822_part_set_content_type (self, _tmp23_);
	}
	_g_object_unref0 (part_type);
	_g_object_unref0 (part_disposition);
	return self;
}

GearyRFC822Part*
geary_rf_c822_part_new (GMimeObject* source)
{
	return geary_rf_c822_part_construct (GEARY_RF_C822_TYPE_PART, source);
}

/**
     * Returns the entity's filename, cleaned for use in the file system.
     */
gchar*
geary_rf_c822_part_get_clean_filename (GearyRFC822Part* self)
{
	const gchar* _tmp0_ = NULL;
	GMimePart* _tmp1_;
	gchar* filename = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_PART (self), NULL);
	_tmp1_ = self->priv->source_part;
	if (_tmp1_ != NULL) {
		GMimePart* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->source_part;
		_tmp3_ = g_mime_part_get_filename (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp4_ = g_strdup (_tmp0_);
	filename = _tmp4_;
	_tmp5_ = filename;
	if (_tmp5_ != NULL) {
		{
			gchar* _tmp6_ = NULL;
			GRegex* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp7_ = geary_rf_c822_invalid_filename_character_re;
			_tmp8_ = filename;
			_tmp9_ = filename;
			_tmp10_ = strlen (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_regex_replace_literal (_tmp7_, _tmp8_, (gssize) _tmp11_, 0, "_", 0, &_inner_error0_);
			_tmp6_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				_g_free0 (filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp13_ = _tmp6_;
			_tmp6_ = NULL;
			_g_free0 (filename);
			filename = _tmp13_;
			_g_free0 (_tmp6_);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_debug ("rfc822-part.vala:140: Error sanitizing attachment filename: %s", _tmp15_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = filename;
	return result;
}

GearyMemoryBuffer*
geary_rf_c822_part_write_to_buffer (GearyRFC822Part* self,
                                    GearyRFC822PartEncodingConversion conversion,
                                    GearyRFC822PartBodyFormatting format,
                                    GError** error)
{
	GByteArray* byte_array = NULL;
	GByteArray* _tmp0_;
	GMimeStreamMem* stream = NULL;
	GMimeStreamMem* _tmp1_;
	GearyMemoryByteBuffer* _tmp2_;
	GError* _inner_error0_ = NULL;
	GearyMemoryBuffer* result;
	g_return_val_if_fail (GEARY_RF_C822_IS_PART (self), NULL);
	_tmp0_ = g_byte_array_new ();
	byte_array = _tmp0_;
	_tmp1_ = (GMimeStreamMem*) g_mime_stream_mem_new_with_byte_array (byte_array);
	stream = _tmp1_;
	g_mime_stream_mem_set_owner (stream, FALSE);
	geary_rf_c822_part_write_to_stream (self, G_TYPE_CHECK_INSTANCE_CAST (stream, g_mime_stream_get_type (), GMimeStream), conversion, format, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (stream);
			_g_byte_array_unref0 (byte_array);
			return NULL;
		} else {
			_g_object_unref0 (stream);
			_g_byte_array_unref0 (byte_array);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = geary_memory_byte_buffer_new_from_byte_array (byte_array);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
	_g_object_unref0 (stream);
	_g_byte_array_unref0 (byte_array);
	return result;
}

void
geary_rf_c822_part_write_to_stream (GearyRFC822Part* self,
                                    GMimeStream* destination,
                                    GearyRFC822PartEncodingConversion conversion,
                                    GearyRFC822PartBodyFormatting format,
                                    GError** error)
{
	GMimeDataWrapper* _tmp0_ = NULL;
	GMimePart* _tmp1_;
	GMimeDataWrapper* wrapper = NULL;
	GMimeDataWrapper* _tmp4_;
	GMimeDataWrapper* _tmp5_;
	GearyMimeContentType* _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_RF_C822_IS_PART (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (destination, g_mime_stream_get_type ()));
	_tmp1_ = self->priv->source_part;
	if (_tmp1_ != NULL) {
		GMimePart* _tmp2_;
		GMimeDataWrapper* _tmp3_;
		_tmp2_ = self->priv->source_part;
		_tmp3_ = g_mime_part_get_content (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp4_ = _g_object_ref0 (_tmp0_);
	wrapper = _tmp4_;
	_tmp5_ = wrapper;
	if (_tmp5_ == NULL) {
		GearyMimeContentType* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		GError* _tmp10_;
		_tmp6_ = self->priv->_content_type;
		_tmp7_ = geary_mime_content_type_to_string (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_error_new (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_INVALID, "Could not get the content wrapper for content-type %s", _tmp8_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_inner_error0_ = _tmp10_;
		if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (wrapper);
			return;
		} else {
			_g_object_unref0 (wrapper);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp11_ = self->priv->_content_type;
	if (geary_mime_content_type_is_type (_tmp11_, "text", GEARY_MIME_CONTENT_TYPE_WILDCARD)) {
		GMimeStreamFilter* filter = NULL;
		GMimeStreamFilter* _tmp12_;
		gchar* charset = NULL;
		GearyMimeContentType* _tmp13_;
		GearyMimeContentParameters* _tmp14_;
		GearyMimeContentParameters* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gboolean _tmp19_ = FALSE;
		gboolean flowed = FALSE;
		GearyMimeContentType* _tmp27_;
		GearyMimeContentParameters* _tmp28_;
		GearyMimeContentParameters* _tmp29_;
		gboolean delsp = FALSE;
		GearyMimeContentType* _tmp30_;
		GearyMimeContentParameters* _tmp31_;
		GearyMimeContentParameters* _tmp32_;
		gboolean _tmp33_ = FALSE;
		gboolean _tmp34_ = FALSE;
		GMimePart* _tmp35_;
		GMimeDataWrapper* _tmp56_;
		GMimeStreamFilter* _tmp57_;
		GMimeStreamFilter* _tmp59_;
		_tmp12_ = (GMimeStreamFilter*) g_mime_stream_filter_new (destination);
		filter = _tmp12_;
		_tmp13_ = self->priv->_content_type;
		_tmp14_ = geary_mime_content_type_get_params (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = geary_mime_content_parameters_get_value (_tmp15_, "charset");
		charset = _tmp16_;
		_tmp17_ = charset;
		if (geary_string_is_empty (_tmp17_)) {
			gchar* _tmp18_;
			_tmp18_ = g_strdup ("US-ASCII");
			_g_free0 (charset);
			charset = _tmp18_;
		}
		if (conversion == GEARY_RF_C822_PART_ENCODING_CONVERSION_UTF8) {
			const gchar* _tmp20_;
			_tmp20_ = charset;
			_tmp19_ = !geary_rf_c822_is_utf_8 (_tmp20_);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			GMimeFilterCharset* filter_charset = NULL;
			const gchar* _tmp21_;
			GMimeFilterCharset* _tmp22_;
			GMimeFilterCharset* _tmp23_;
			GMimeStreamFilter* _tmp25_;
			GMimeFilterCharset* _tmp26_;
			_tmp21_ = charset;
			_tmp22_ = (GMimeFilterCharset*) g_mime_filter_charset_new (_tmp21_, GEARY_RF_C822_UTF8_CHARSET);
			filter_charset = _tmp22_;
			_tmp23_ = filter_charset;
			if (_tmp23_ == NULL) {
				GMimeFilterCharset* _tmp24_;
				_tmp24_ = (GMimeFilterCharset*) g_mime_filter_charset_new ("US-ASCII", GEARY_RF_C822_UTF8_CHARSET);
				_g_object_unref0 (filter_charset);
				filter_charset = _tmp24_;
			}
			_tmp25_ = filter;
			_tmp26_ = filter_charset;
			g_mime_stream_filter_add (_tmp25_, G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, g_mime_filter_get_type (), GMimeFilter));
			_g_object_unref0 (filter_charset);
		}
		_tmp27_ = self->priv->_content_type;
		_tmp28_ = geary_mime_content_type_get_params (_tmp27_);
		_tmp29_ = _tmp28_;
		flowed = geary_mime_content_parameters_has_value_ci (_tmp29_, "format", "flowed");
		_tmp30_ = self->priv->_content_type;
		_tmp31_ = geary_mime_content_type_get_params (_tmp30_);
		_tmp32_ = _tmp31_;
		delsp = geary_mime_content_parameters_has_value_ci (_tmp32_, "DelSp", "yes");
		_tmp35_ = self->priv->source_part;
		if (_tmp35_ == NULL) {
			_tmp34_ = TRUE;
		} else {
			GMimePart* _tmp36_;
			_tmp36_ = self->priv->source_part;
			_tmp34_ = _tmp36_->encoding != GMIME_CONTENT_ENCODING_BASE64;
		}
		if (_tmp34_) {
			GeeSet* _tmp37_;
			GearyMimeContentType* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			_tmp37_ = geary_rf_c822_part_CR_PRESERVING_TEXT_TYPES;
			_tmp38_ = self->priv->_content_type;
			_tmp39_ = geary_mime_content_type_get_media_subtype (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp33_ = !gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_COLLECTION, GeeCollection), _tmp40_);
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			GMimeStreamFilter* _tmp41_;
			GMimeFilterDos2Unix* _tmp42_;
			GMimeFilterDos2Unix* _tmp43_;
			_tmp41_ = filter;
			_tmp42_ = (GMimeFilterDos2Unix*) g_mime_filter_dos2unix_new (FALSE);
			_tmp43_ = _tmp42_;
			g_mime_stream_filter_add (_tmp41_, G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, g_mime_filter_get_type (), GMimeFilter));
			_g_object_unref0 (_tmp43_);
		}
		if (flowed) {
			GMimeStreamFilter* _tmp44_;
			GearyRFC822FilterFlowed* _tmp45_;
			GearyRFC822FilterFlowed* _tmp46_;
			_tmp44_ = filter;
			_tmp45_ = geary_rf_c822_filter_flowed_new (format == GEARY_RF_C822_PART_BODY_FORMATTING_HTML, delsp);
			_tmp46_ = _tmp45_;
			g_mime_stream_filter_add (_tmp44_, G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, g_mime_filter_get_type (), GMimeFilter));
			_g_object_unref0 (_tmp46_);
		}
		if (format == GEARY_RF_C822_PART_BODY_FORMATTING_HTML) {
			GMimeStreamFilter* _tmp50_;
			GMimeFilterHTML* _tmp51_;
			GMimeFilterHTML* _tmp52_;
			GMimeStreamFilter* _tmp53_;
			GearyRFC822FilterBlockquotes* _tmp54_;
			GearyRFC822FilterBlockquotes* _tmp55_;
			if (!flowed) {
				GMimeStreamFilter* _tmp47_;
				GearyRFC822FilterPlain* _tmp48_;
				GearyRFC822FilterPlain* _tmp49_;
				_tmp47_ = filter;
				_tmp48_ = geary_rf_c822_filter_plain_new ();
				_tmp49_ = _tmp48_;
				g_mime_stream_filter_add (_tmp47_, G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, g_mime_filter_get_type (), GMimeFilter));
				_g_object_unref0 (_tmp49_);
			}
			_tmp50_ = filter;
			_tmp51_ = (GMimeFilterHTML*) g_mime_filter_html_new ((guint32) (GMIME_FILTER_HTML_CONVERT_URLS | GMIME_FILTER_HTML_CONVERT_ADDRESSES), (guint32) 0);
			_tmp52_ = _tmp51_;
			g_mime_stream_filter_add (_tmp50_, G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, g_mime_filter_get_type (), GMimeFilter));
			_g_object_unref0 (_tmp52_);
			_tmp53_ = filter;
			_tmp54_ = geary_rf_c822_filter_blockquotes_new ();
			_tmp55_ = _tmp54_;
			g_mime_stream_filter_add (_tmp53_, G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, g_mime_filter_get_type (), GMimeFilter));
			_g_object_unref0 (_tmp55_);
		}
		_tmp56_ = wrapper;
		_tmp57_ = filter;
		if (g_mime_data_wrapper_write_to_stream (_tmp56_, G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, g_mime_stream_get_type (), GMimeStream)) < ((gssize) 0)) {
			GError* _tmp58_;
			_tmp58_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_FAILED, "Unable to write textual RFC822 part to filter stream");
			_inner_error0_ = _tmp58_;
			if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (charset);
				_g_object_unref0 (filter);
				_g_object_unref0 (wrapper);
				return;
			} else {
				_g_free0 (charset);
				_g_object_unref0 (filter);
				_g_object_unref0 (wrapper);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp59_ = filter;
		if (g_mime_stream_flush (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, g_mime_stream_get_type (), GMimeStream)) != 0) {
			GError* _tmp60_;
			_tmp60_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_FAILED, "Unable to flush textual RFC822 part to destination stream");
			_inner_error0_ = _tmp60_;
			if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (charset);
				_g_object_unref0 (filter);
				_g_object_unref0 (wrapper);
				return;
			} else {
				_g_free0 (charset);
				_g_object_unref0 (filter);
				_g_object_unref0 (wrapper);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (g_mime_stream_flush (destination) != 0) {
			GError* _tmp61_;
			_tmp61_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_FAILED, "Unable to flush textual RFC822 part to destination");
			_inner_error0_ = _tmp61_;
			if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (charset);
				_g_object_unref0 (filter);
				_g_object_unref0 (wrapper);
				return;
			} else {
				_g_free0 (charset);
				_g_object_unref0 (filter);
				_g_object_unref0 (wrapper);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_free0 (charset);
		_g_object_unref0 (filter);
	} else {
		GMimeDataWrapper* _tmp62_;
		_tmp62_ = wrapper;
		if (g_mime_data_wrapper_write_to_stream (_tmp62_, destination) < ((gssize) 0)) {
			GError* _tmp63_;
			_tmp63_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_FAILED, "Unable to write binary RFC822 part to destination stream");
			_inner_error0_ = _tmp63_;
			if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (wrapper);
				return;
			} else {
				_g_object_unref0 (wrapper);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (g_mime_stream_flush (destination) != 0) {
			GError* _tmp64_;
			_tmp64_ = g_error_new_literal (GEARY_RF_C822_ERROR, GEARY_RF_C822_ERROR_FAILED, "Unable to flush binary RFC822 part to destination");
			_inner_error0_ = _tmp64_;
			if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (wrapper);
				return;
			} else {
				_g_object_unref0 (wrapper);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_g_object_unref0 (wrapper);
}

static void
geary_rf_c822_part_class_init (GearyRFC822PartClass * klass,
                               gpointer klass_data)
{
	GeeHashSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	geary_rf_c822_part_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyRFC822Part_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_rf_c822_part_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_rf_c822_part_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_rf_c822_part_finalize;
	/**
	     * The entity's Content-Type.
	     *
	     * See [[https://tools.ietf.org/html/rfc2045#section-5]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_PART_CONTENT_TYPE_PROPERTY, geary_rf_c822_part_properties[GEARY_RF_C822_PART_CONTENT_TYPE_PROPERTY] = g_param_spec_object ("content-type", "content-type", "content-type", GEARY_MIME_TYPE_CONTENT_TYPE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The entity's Content-ID.
	     *
	     * See [[https://tools.ietf.org/html/rfc2045#section-5]],
	     * [[https://tools.ietf.org/html/rfc2111]] and {@link
	     * Email.get_attachment_by_content_id}.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_PART_CONTENT_ID_PROPERTY, geary_rf_c822_part_properties[GEARY_RF_C822_PART_CONTENT_ID_PROPERTY] = g_param_spec_string ("content-id", "content-id", "content-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The entity's Content-Description.
	     *
	     * See [[https://tools.ietf.org/html/rfc2045#section-8]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_PART_CONTENT_DESCRIPTION_PROPERTY, geary_rf_c822_part_properties[GEARY_RF_C822_PART_CONTENT_DESCRIPTION_PROPERTY] = g_param_spec_string ("content-description", "content-description", "content-description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The entity's Content-Disposition.
	     *
	     * See [[https://tools.ietf.org/html/rfc2183]]
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_RF_C822_PART_CONTENT_DISPOSITION_PROPERTY, geary_rf_c822_part_properties[GEARY_RF_C822_PART_CONTENT_DISPOSITION_PROPERTY] = g_param_spec_object ("content-disposition", "content-disposition", "content-disposition", GEARY_MIME_TYPE_CONTENT_DISPOSITION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	geary_rf_c822_part_CR_PRESERVING_TEXT_TYPES = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
	_tmp1_ = geary_rf_c822_part_CR_PRESERVING_TEXT_TYPES;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), "vcard");
	_tmp2_ = geary_rf_c822_part_CR_PRESERVING_TEXT_TYPES;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection), "x-vcard");
	_tmp3_ = geary_rf_c822_part_CR_PRESERVING_TEXT_TYPES;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection), "directory");
	_tmp4_ = geary_rf_c822_part_CR_PRESERVING_TEXT_TYPES;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection), "calendar");
	_tmp5_ = geary_rf_c822_part_CR_PRESERVING_TEXT_TYPES;
	gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection), "rtf");
}

static void
geary_rf_c822_part_instance_init (GearyRFC822Part * self,
                                  gpointer klass)
{
	self->priv = geary_rf_c822_part_get_instance_private (self);
}

static void
geary_rf_c822_part_finalize (GObject * obj)
{
	GearyRFC822Part * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_RF_C822_TYPE_PART, GearyRFC822Part);
	_g_object_unref0 (self->priv->_content_type);
	_g_free0 (self->priv->_content_id);
	_g_free0 (self->priv->_content_description);
	_g_object_unref0 (self->priv->_content_disposition);
	_g_object_unref0 (self->priv->source_object);
	_g_object_unref0 (self->priv->source_part);
	G_OBJECT_CLASS (geary_rf_c822_part_parent_class)->finalize (obj);
}

/**
 * An RFC-2045 style MIME entity.
 *
 * This object provides a convenient means accessing the high-level
 * MIME entity header field values that are useful to applications and
 * decoded forms of the entity body.
 */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_part_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyRFC822PartClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_rf_c822_part_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyRFC822Part), 0, (GInstanceInitFunc) geary_rf_c822_part_instance_init, NULL };
	GType geary_rf_c822_part_type_id;
	geary_rf_c822_part_type_id = g_type_register_static (G_TYPE_OBJECT, "GearyRFC822Part", &g_define_type_info, 0);
	GearyRFC822Part_private_offset = g_type_add_instance_private (geary_rf_c822_part_type_id, sizeof (GearyRFC822PartPrivate));
	return geary_rf_c822_part_type_id;
}

GType
geary_rf_c822_part_get_type (void)
{
	static gsize geary_rf_c822_part_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_part_type_id__once)) {
		GType geary_rf_c822_part_type_id;
		geary_rf_c822_part_type_id = geary_rf_c822_part_get_type_once ();
		g_once_init_leave (&geary_rf_c822_part_type_id__once, geary_rf_c822_part_type_id);
	}
	return geary_rf_c822_part_type_id__once;
}

static void
_vala_geary_rf_c822_part_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GearyRFC822Part * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TYPE_PART, GearyRFC822Part);
	switch (property_id) {
		case GEARY_RF_C822_PART_CONTENT_TYPE_PROPERTY:
		g_value_set_object (value, geary_rf_c822_part_get_content_type (self));
		break;
		case GEARY_RF_C822_PART_CONTENT_ID_PROPERTY:
		g_value_set_string (value, geary_rf_c822_part_get_content_id (self));
		break;
		case GEARY_RF_C822_PART_CONTENT_DESCRIPTION_PROPERTY:
		g_value_set_string (value, geary_rf_c822_part_get_content_description (self));
		break;
		case GEARY_RF_C822_PART_CONTENT_DISPOSITION_PROPERTY:
		g_value_set_object (value, geary_rf_c822_part_get_content_disposition (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_rf_c822_part_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GearyRFC822Part * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_RF_C822_TYPE_PART, GearyRFC822Part);
	switch (property_id) {
		case GEARY_RF_C822_PART_CONTENT_TYPE_PROPERTY:
		geary_rf_c822_part_set_content_type (self, g_value_get_object (value));
		break;
		case GEARY_RF_C822_PART_CONTENT_ID_PROPERTY:
		geary_rf_c822_part_set_content_id (self, g_value_get_string (value));
		break;
		case GEARY_RF_C822_PART_CONTENT_DESCRIPTION_PROPERTY:
		geary_rf_c822_part_set_content_description (self, g_value_get_string (value));
		break;
		case GEARY_RF_C822_PART_CONTENT_DISPOSITION_PROPERTY:
		geary_rf_c822_part_set_content_disposition (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

