/* rfc822.c generated by valac 0.56.3, the Vala compiler
 * generated from rfc822.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gmime/gmime.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define __vala_GMimeParserOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMimeParserOptions_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN GMimeParserOptions* geary_rf_c822_gmime_parser_options;
GMimeParserOptions* geary_rf_c822_gmime_parser_options = NULL;
VALA_EXTERN GRegex* geary_rf_c822_invalid_filename_character_re;
GRegex* geary_rf_c822_invalid_filename_character_re = NULL;
VALA_EXTERN gint geary_rf_c822_init_count;
gint geary_rf_c822_init_count = 0;

static void _vala_GMimeParserOptions_free (GMimeParserOptions* self);
static GMimeParserOptions* _vala_GMimeParserOptions_copy (GMimeParserOptions* self);
VALA_EXTERN gboolean geary_rf_c822_is_utf_8 (const gchar* charset);

/**
     * Common text formats supported by {@link Geary.RFC822}.
     */
 G_GNUC_NO_INLINE static GType
geary_rf_c822_text_format_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_RF_C822_TEXT_FORMAT_PLAIN, "GEARY_RF_C822_TEXT_FORMAT_PLAIN", "plain"}, {GEARY_RF_C822_TEXT_FORMAT_HTML, "GEARY_RF_C822_TEXT_FORMAT_HTML", "html"}, {0, NULL, NULL}};
	GType geary_rf_c822_text_format_type_id;
	geary_rf_c822_text_format_type_id = g_enum_register_static ("GearyRFC822TextFormat", values);
	return geary_rf_c822_text_format_type_id;
}

GType
geary_rf_c822_text_format_get_type (void)
{
	static gsize geary_rf_c822_text_format_type_id__once = 0;
	if (g_once_init_enter (&geary_rf_c822_text_format_type_id__once)) {
		GType geary_rf_c822_text_format_type_id;
		geary_rf_c822_text_format_type_id = geary_rf_c822_text_format_get_type_once ();
		g_once_init_leave (&geary_rf_c822_text_format_type_id__once, geary_rf_c822_text_format_type_id);
	}
	return geary_rf_c822_text_format_type_id__once;
}

static void
_vala_GMimeParserOptions_free (GMimeParserOptions* self)
{
	g_boxed_free (g_mime_parser_options_get_type (), self);
}

void
geary_rf_c822_init (void)
{
	gint _tmp0_;
	GMimeParserOptions* _tmp1_;
	GMimeParserOptions* _tmp2_;
	GMimeParserOptions* _tmp3_;
	GMimeParserOptions* _tmp4_;
	GMimeParserOptions* _tmp5_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = geary_rf_c822_init_count;
	geary_rf_c822_init_count = _tmp0_ + 1;
	if (_tmp0_ != 0) {
		return;
	}
	g_mime_init ();
	_tmp1_ = g_mime_parser_options_get_default ();
	__vala_GMimeParserOptions_free0 (geary_rf_c822_gmime_parser_options);
	geary_rf_c822_gmime_parser_options = _tmp1_;
	_tmp2_ = geary_rf_c822_gmime_parser_options;
	g_mime_parser_options_set_allow_addresses_without_domain (_tmp2_, TRUE);
	_tmp3_ = geary_rf_c822_gmime_parser_options;
	g_mime_parser_options_set_address_compliance_mode (_tmp3_, GMIME_RFC_COMPLIANCE_LOOSE);
	_tmp4_ = geary_rf_c822_gmime_parser_options;
	g_mime_parser_options_set_parameter_compliance_mode (_tmp4_, GMIME_RFC_COMPLIANCE_LOOSE);
	_tmp5_ = geary_rf_c822_gmime_parser_options;
	g_mime_parser_options_set_rfc2047_compliance_mode (_tmp5_, GMIME_RFC_COMPLIANCE_LOOSE);
	{
		GRegex* _tmp6_ = NULL;
		GRegex* _tmp7_;
		GRegex* _tmp8_;
		_tmp7_ = g_regex_new ("[/\\0]", 0, 0, &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp8_ = _tmp6_;
		_tmp6_ = NULL;
		_g_regex_unref0 (geary_rf_c822_invalid_filename_character_re);
		geary_rf_c822_invalid_filename_character_re = _tmp8_;
		_g_regex_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GMimeFormatOptions*
geary_rf_c822_get_format_options (void)
{
	GMimeFormatOptions* _tmp0_;
	GMimeFormatOptions* result;
	_tmp0_ = g_mime_format_options_get_default ();
	result = _tmp0_;
	return result;
}

static GMimeParserOptions*
_vala_GMimeParserOptions_copy (GMimeParserOptions* self)
{
	return g_boxed_copy (g_mime_parser_options_get_type (), self);
}

static gpointer
__vala_GMimeParserOptions_copy0 (gpointer self)
{
	return self ? _vala_GMimeParserOptions_copy (self) : NULL;
}

GMimeParserOptions*
geary_rf_c822_get_parser_options (void)
{
	GMimeParserOptions* _tmp0_;
	GMimeParserOptions* _tmp1_;
	GMimeParserOptions* result;
	_tmp0_ = geary_rf_c822_gmime_parser_options;
	_tmp1_ = __vala_GMimeParserOptions_copy0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
geary_rf_c822_get_charset (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (GEARY_RF_C822_UTF8_CHARSET);
	result = _tmp0_;
	return result;
}

gboolean
geary_rf_c822_is_utf_8 (const gchar* charset)
{
	gchar* up = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (charset != NULL, FALSE);
	_tmp0_ = g_utf8_strup (charset, (gssize) -1);
	up = _tmp0_;
	_tmp6_ = up;
	if (g_strcmp0 (_tmp6_, "ASCII") == 0) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = up;
		_tmp5_ = g_strcmp0 (_tmp7_, "US-ASCII") == 0;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = up;
		_tmp4_ = g_strcmp0 (_tmp8_, "US_ASCII") == 0;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = up;
		_tmp3_ = g_strcmp0 (_tmp9_, "UTF-8") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = up;
		_tmp2_ = g_strcmp0 (_tmp10_, "UTF8") == 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = up;
		_tmp1_ = g_strcmp0 (_tmp11_, "UTF_8") == 0;
	}
	result = _tmp1_;
	_g_free0 (up);
	return result;
}

