/* smtp-client-service.c generated by valac 0.56.3, the Vala compiler
 * generated from smtp-client-service.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2018, 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gmime/gmime.h>
#include <gee.h>

enum  {
	GEARY_SMTP_CLIENT_SERVICE_0_PROPERTY,
	GEARY_SMTP_CLIENT_SERVICE_OUTBOX_PROPERTY,
	GEARY_SMTP_CLIENT_SERVICE_SENDING_MONITOR_PROPERTY,
	GEARY_SMTP_CLIENT_SERVICE_LOGGING_DOMAIN_PROPERTY,
	GEARY_SMTP_CLIENT_SERVICE_NUM_PROPERTIES
};
static GParamSpec* geary_smtp_client_service_properties[GEARY_SMTP_CLIENT_SERVICE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearySmtpClientServiceStartData GearySmtpClientServiceStartData;
typedef struct _GearySmtpClientServiceStopData GearySmtpClientServiceStopData;
typedef struct _GearySmtpClientServiceSendEmailData GearySmtpClientServiceSendEmailData;
typedef struct _GearySmtpClientServiceSaveEmailData GearySmtpClientServiceSaveEmailData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearySmtpClientServiceStartPostieData GearySmtpClientServiceStartPostieData;
typedef struct _GearySmtpClientServiceFillOutboxQueueData GearySmtpClientServiceFillOutboxQueueData;
typedef struct _GearySmtpClientServiceProcessEmailData GearySmtpClientServiceProcessEmailData;
#define _geary_smtp_response_unref0(var) ((var == NULL) ? NULL : (var = (geary_smtp_response_unref (var), NULL)))
typedef struct _GearySmtpClientServiceSendEmailInternalData GearySmtpClientServiceSendEmailInternalData;
typedef struct _GearySmtpClientServiceSaveSentMailData GearySmtpClientServiceSaveSentMailData;
typedef struct _GearySmtpClientServiceSyncSentMailData GearySmtpClientServiceSyncSentMailData;
typedef struct _GearySmtpClientServiceWaitForMessageData GearySmtpClientServiceWaitForMessageData;
enum  {
	GEARY_SMTP_CLIENT_SERVICE_EMAIL_SENT_SIGNAL,
	GEARY_SMTP_CLIENT_SERVICE_REPORT_PROBLEM_SIGNAL,
	GEARY_SMTP_CLIENT_SERVICE_NUM_SIGNALS
};
static guint geary_smtp_client_service_signals[GEARY_SMTP_CLIENT_SERVICE_NUM_SIGNALS] = {0};

struct _GearySmtpClientServicePrivate {
	GearyOutboxFolder* _outbox;
	GearyProgressMonitor* _sending_monitor;
	GearyNonblockingQueue* outbox_queue;
	GCancellable* queue_cancellable;
};

struct _GearySmtpClientServiceStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GCancellable* cancellable;
	GearyOutboxFolder* _tmp0_;
	GError* _inner_error0_;
};

struct _GearySmtpClientServiceStopData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GCancellable* cancellable;
	GCancellable* _tmp0_;
	GearyOutboxFolder* _tmp1_;
	GError* _inner_error0_;
};

struct _GearySmtpClientServiceSendEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GearyComposedEmail* composed;
	GCancellable* cancellable;
	GearyEmailIdentifier* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GError* _inner_error0_;
};

struct _GearySmtpClientServiceSaveEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GearyComposedEmail* composed;
	GCancellable* cancellable;
	GearyEmailIdentifier* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GearyRFC822MailboxAddresses* from;
	GearyRFC822MailboxAddresses* _tmp2_;
	GearyRFC822MailboxAddresses* _tmp3_;
	GearyRFC822MailboxAddresses* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	GearyRFC822MailboxAddresses* _tmp7_;
	GearyRFC822MailboxAddresses* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GearyRFC822MailboxAddresses* _tmp11_;
	GearyRFC822MailboxAddress* _tmp12_;
	GearyRFC822MailboxAddress* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GearyAccountInformation* _tmp16_;
	GearyAccountInformation* _tmp17_;
	GearyRFC822MailboxAddress* _tmp18_;
	GearyRFC822MailboxAddress* _tmp19_;
	GearyRFC822MailboxAddress* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* domain;
	gchar* _tmp23_;
	GearyRFC822Message* rfc822;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GearyRFC822Message* _tmp27_;
	GearyRFC822Message* _tmp28_;
	GearyEmailIdentifier* id;
	GearyOutboxFolder* _tmp29_;
	GearyRFC822Message* _tmp30_;
	GearyEmailIdentifier* _tmp31_;
	GearyEmailIdentifier* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GError* _inner_error0_;
};

struct _GearySmtpClientServiceStartPostieData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GearyNonblockingQueue* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* cancellable;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	GearyEmailIdentifier* id;
	gboolean email_handled;
	GearyEmailIdentifier* _tmp8_;
	GearyNonblockingQueue* _tmp9_;
	GCancellable* _tmp10_;
	gpointer _tmp11_;
	GearyEmailIdentifier* _tmp12_;
	GearyEmailIdentifier* _tmp13_;
	GCancellable* _tmp14_;
	GError* err;
	GError* _tmp15_;
	gboolean _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GearyErrorContext* _tmp20_;
	GearyErrorContext* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	GError* _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	GError* _tmp27_;
	GearyErrorContext* _tmp28_;
	GearyErrorContext* _tmp29_;
	GCancellable* _tmp30_;
	GError* _vala1_err;
	GearyEmailIdentifier* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	GError* _vala2_err;
	GError* _tmp36_;
	GearyErrorContext* _tmp37_;
	GearyErrorContext* _tmp38_;
	GCancellable* _tmp39_;
	gboolean _tmp40_;
	GearyEmailIdentifier* _tmp41_;
	GearyNonblockingQueue* _tmp42_;
	GearyEmailIdentifier* _tmp43_;
	GError* _inner_error0_;
};

struct _GearySmtpClientServiceFillOutboxQueueData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GCancellable* cancellable;
	GeeList* queued;
	GearyOutboxFolder* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _email_list;
	gint _email_size;
	GeeList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _email_index;
	gint _tmp5_;
	gint _tmp6_;
	GearyEmail* email;
	GeeList* _tmp7_;
	gpointer _tmp8_;
	GearyNonblockingQueue* _tmp9_;
	GearyEmail* _tmp10_;
	GearyEmailIdentifier* _tmp11_;
	GearyEmailIdentifier* _tmp12_;
	GError* err;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _inner_error0_;
};

struct _GearySmtpClientServiceProcessEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GearyEmailIdentifier* id;
	GCancellable* cancellable;
	gboolean _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyAccountInformation* _tmp2_;
	GError* _tmp3_;
	GearyEmail* email;
	GearyOutboxFolder* _tmp4_;
	GearyEmail* _tmp5_;
	GearyEmail* _tmp6_;
	GearyEmailFlags* _tmp7_;
	GearyEmailFlags* _tmp8_;
	GearyNamedFlag* _tmp9_;
	GearyNamedFlag* _tmp10_;
	GearyNamedFlag* _tmp11_;
	gboolean _tmp12_;
	GearyRFC822Message* message;
	GearyEmail* _tmp13_;
	GearyRFC822Message* _tmp14_;
	GearyRFC822Message* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GearyEmail* _tmp18_;
	GearyEmailIdentifier* _tmp19_;
	GearyEmailIdentifier* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GearyRFC822Message* _tmp23_;
	GearyEmail* _tmp24_;
	GearyEmail* _tmp25_;
	GearyEmailIdentifier* _tmp26_;
	GearyEmailIdentifier* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GearyEmailFlags* flags;
	GearyEmailFlags* _tmp30_;
	GearyEmailFlags* _tmp31_;
	GearyNamedFlag* _tmp32_;
	GearyNamedFlag* _tmp33_;
	GearyNamedFlag* _tmp34_;
	GearyOutboxFolder* _tmp35_;
	GearyEmail* _tmp36_;
	GearyEmailIdentifier* _tmp37_;
	GearyEmailIdentifier* _tmp38_;
	GeeCollection* _tmp39_;
	GeeCollection* _tmp40_;
	GearyEmailFlags* _tmp41_;
	GError* _tmp42_;
	GearyAccountInformation* _tmp43_;
	GearyAccountInformation* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	GearyEmail* _tmp47_;
	GearyEmailIdentifier* _tmp48_;
	GearyEmailIdentifier* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	GearyEmail* _tmp52_;
	GearyEmail* _tmp53_;
	GearyEmailIdentifier* _tmp54_;
	GearyEmailIdentifier* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GearyEmail* _tmp58_;
	GearyEmail* _tmp59_;
	GearyEmailIdentifier* _tmp60_;
	GearyEmailIdentifier* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	GearyOutboxFolder* _tmp64_;
	GearyEmail* _tmp65_;
	GearyEmailIdentifier* _tmp66_;
	GearyEmailIdentifier* _tmp67_;
	GeeCollection* _tmp68_;
	GeeCollection* _tmp69_;
	GError* _inner_error0_;
};

struct _GearySmtpClientServiceSendEmailInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GearyRFC822Message* rfc822;
	GCancellable* cancellable;
	GearyCredentials* login;
	GearyAccountInformation* _tmp0_;
	GearyAccountInformation* _tmp1_;
	GearyCredentials* _tmp2_;
	gboolean _tmp3_;
	GearyCredentials* _tmp4_;
	GearyCredentials* _tmp5_;
	GError* _tmp6_;
	GearySmtpClientSession* smtp;
	GearyEndpoint* _tmp7_;
	GearyEndpoint* _tmp8_;
	GearySmtpClientSession* _tmp9_;
	GearySmtpClientSession* _tmp10_;
	GearyProgressMonitor* _tmp11_;
	GError* smtp_err;
	GearySmtpClientSession* _tmp12_;
	GearyCredentials* _tmp13_;
	GearySmtpGreeting* _tmp14_;
	GearySmtpGreeting* _tmp15_;
	GError* login_err;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	GearyRFC822MailboxAddress* reverse_path;
	GearyRFC822MailboxAddress* _tmp21_;
	GearyRFC822MailboxAddress* _tmp22_;
	GearyRFC822MailboxAddress* _tmp23_;
	GearyRFC822MailboxAddress* _tmp24_;
	GearyRFC822MailboxAddresses* _tmp25_;
	GearyRFC822MailboxAddresses* _tmp26_;
	GearyRFC822MailboxAddresses* _from_list;
	GearyRFC822MailboxAddresses* _tmp27_;
	GearyRFC822MailboxAddresses* _tmp28_;
	gint _from_size;
	GearyRFC822MailboxAddresses* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint _from_index;
	gint _tmp32_;
	gint _tmp33_;
	GearyRFC822MailboxAddress* from;
	GearyRFC822MailboxAddresses* _tmp34_;
	GearyRFC822MailboxAddress* _tmp35_;
	GearyAccountInformation* _tmp36_;
	GearyAccountInformation* _tmp37_;
	GearyRFC822MailboxAddress* _tmp38_;
	GearyRFC822MailboxAddress* _tmp39_;
	GearyRFC822MailboxAddress* _tmp40_;
	GearyRFC822MailboxAddress* _tmp41_;
	GearyAccountInformation* _tmp42_;
	GearyAccountInformation* _tmp43_;
	GearyRFC822MailboxAddress* _tmp44_;
	GearyRFC822MailboxAddress* _tmp45_;
	GearySmtpClientSession* _tmp46_;
	GearyRFC822MailboxAddress* _tmp47_;
	GError* send_err;
	GError* _tmp48_;
	const gchar* _tmp49_;
	GError* _tmp50_;
	GError* _tmp51_;
	GearySmtpClientSession* _tmp52_;
	GearySmtpResponse* _tmp53_;
	GearySmtpResponse* _tmp54_;
	GError* err;
	GearySmtpClientSession* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GError* _tmp58_;
	const gchar* _tmp59_;
	GearyProgressMonitor* _tmp60_;
	GError* _tmp61_;
	GError* _tmp62_;
	GError* _tmp63_;
	GError* _inner_error0_;
};

struct _GearySmtpClientServiceSaveSentMailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GearyEmail* message;
	GCancellable* cancellable;
	GearyFolder* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccount* _tmp2_;
	GearyFolder* _tmp3_;
	GearyFolderSupportCreate* create;
	GearyFolderSupportCreate* _tmp4_;
	GearyFolderSupportCreate* _tmp5_;
	GError* _tmp6_;
	GearyRFC822Message* raw;
	GearyRFC822Message* _tmp7_;
	gboolean open;
	GearyFolderSupportCreate* _tmp8_;
	GearyFolderSupportCreate* _tmp9_;
	GearyRFC822Message* _tmp10_;
	GearyEmailIdentifier* _tmp11_;
	GearyEmailIdentifier* _tmp12_;
	GearyFolderSupportCreate* _tmp13_;
	GError* _inner_error1_;
	GearyFolderSupportCreate* _tmp14_;
	GError* e;
	GearyFolderSupportCreate* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_;
};

struct _GearySmtpClientServiceSyncSentMailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GearyEmail* message;
	GCancellable* cancellable;
	GearyFolder* sent;
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	GearyFolder* _tmp2_;
	GearyFolder* _tmp3_;
	gboolean open;
	GearyFolder* _tmp4_;
	GearyFolder* _tmp5_;
	GearyFolder* _tmp6_;
	GError* _inner_error1_;
	GearyFolder* _tmp7_;
	GError* e;
	GearyFolder* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _GearySmtpClientServiceWaitForMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientService* self;
	GearyFolder* location;
	GearyEmail* sent;
	GCancellable* cancellable;
	GearyRFC822MessageID* id;
	GearyRFC822MessageID* _tmp0_;
	GearyRFC822MessageID* _tmp1_;
	GearyRFC822MessageID* _tmp2_;
	GearyRFC822MessageID* _tmp3_;
	gint i;
	gboolean _tmp4_;
	gint _tmp5_;
	GeeList* list;
	GeeList* _tmp6_;
	gboolean _tmp7_;
	GeeList* _tmp8_;
	GeeList* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	GearyEmail* listed;
	GeeList* _tmp12_;
	gpointer _tmp13_;
	gboolean _tmp14_;
	GearyEmail* _tmp15_;
	GearyRFC822MessageID* _tmp16_;
	GearyRFC822MessageID* _tmp17_;
	GearyEmail* _tmp18_;
	GearyRFC822MessageID* _tmp19_;
	GearyRFC822MessageID* _tmp20_;
	GearyRFC822MessageID* _tmp21_;
	GError* _inner_error0_;
};

static gint GearySmtpClientService_private_offset;
static gpointer geary_smtp_client_service_parent_class = NULL;

static gchar* geary_smtp_client_service_email_subject (GearyEmailHeaderSet* email);
VALA_EXTERN void geary_smtp_client_service_set_outbox (GearySmtpClientService* self,
                                           GearyOutboxFolder* value);
static void geary_smtp_client_service_set_sending_monitor (GearySmtpClientService* self,
                                                    GearyProgressMonitor* value);
static GearyAccount* geary_smtp_client_service_get_owner (GearySmtpClientService* self);
static void geary_smtp_client_service_real_start_data_free (gpointer _data);
static void geary_smtp_client_service_real_start (GearyClientService* base,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean geary_smtp_client_service_real_start_co (GearySmtpClientServiceStartData* _data_);
static void geary_smtp_client_service_start_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void geary_smtp_client_service_fill_outbox_queue (GearySmtpClientService* self,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void geary_smtp_client_service_fill_outbox_queue_finish (GearySmtpClientService* self,
                                                         GAsyncResult* _res_);
static void geary_smtp_client_service_real_stop_data_free (gpointer _data);
static void geary_smtp_client_service_real_stop (GearyClientService* base,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean geary_smtp_client_service_real_stop_co (GearySmtpClientServiceStopData* _data_);
static void geary_smtp_client_service_stop_postie (GearySmtpClientService* self);
static gboolean _geary_smtp_client_service_real_stop_co_gsource_func (gpointer self);
static void geary_smtp_client_service_stop_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void geary_smtp_client_service_send_email_data_free (gpointer _data);
static gboolean geary_smtp_client_service_send_email_co (GearySmtpClientServiceSendEmailData* _data_);
static void geary_smtp_client_service_send_email_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void geary_smtp_client_service_save_email_data_free (gpointer _data);
static gboolean geary_smtp_client_service_save_email_co (GearySmtpClientServiceSaveEmailData* _data_);
static void geary_smtp_client_service_save_email_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void geary_smtp_client_service_real_became_reachable (GearyClientService* base);
static void geary_smtp_client_service_start_postie (GearySmtpClientService* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void geary_smtp_client_service_start_postie_finish (GearySmtpClientService* self,
                                                    GAsyncResult* _res_);
static void geary_smtp_client_service_real_became_unreachable (GearyClientService* base);
static void geary_smtp_client_service_start_postie_data_free (gpointer _data);
static gboolean geary_smtp_client_service_start_postie_co (GearySmtpClientServiceStartPostieData* _data_);
static void geary_smtp_client_service_start_postie_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void geary_smtp_client_service_process_email (GearySmtpClientService* self,
                                              GearyEmailIdentifier* id,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static void geary_smtp_client_service_process_email_finish (GearySmtpClientService* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static void geary_smtp_client_service_fill_outbox_queue_data_free (gpointer _data);
static gboolean geary_smtp_client_service_fill_outbox_queue_co (GearySmtpClientServiceFillOutboxQueueData* _data_);
static void geary_smtp_client_service_fill_outbox_queue_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void geary_smtp_client_service_process_email_data_free (gpointer _data);
static gboolean geary_smtp_client_service_process_email_co (GearySmtpClientServiceProcessEmailData* _data_);
static void geary_smtp_client_service_process_email_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void geary_smtp_client_service_send_email_internal (GearySmtpClientService* self,
                                                    GearyRFC822Message* rfc822,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static void geary_smtp_client_service_send_email_internal_finish (GearySmtpClientService* self,
                                                           GAsyncResult* _res_,
                                                           GError** error);
static void geary_smtp_client_service_save_sent_mail (GearySmtpClientService* self,
                                               GearyEmail* message,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void geary_smtp_client_service_save_sent_mail_finish (GearySmtpClientService* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void geary_smtp_client_service_sync_sent_mail (GearySmtpClientService* self,
                                               GearyEmail* message,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void geary_smtp_client_service_sync_sent_mail_finish (GearySmtpClientService* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void geary_smtp_client_service_send_email_internal_data_free (gpointer _data);
static gboolean geary_smtp_client_service_send_email_internal_co (GearySmtpClientServiceSendEmailInternalData* _data_);
VALA_EXTERN void geary_smtp_client_session_set_logging_parent (GearySmtpClientSession* self,
                                                   GearyLoggingSource* parent);
static void geary_smtp_client_service_send_email_internal_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void geary_smtp_client_service_save_sent_mail_data_free (gpointer _data);
static gboolean geary_smtp_client_service_save_sent_mail_co (GearySmtpClientServiceSaveSentMailData* _data_);
static void geary_smtp_client_service_save_sent_mail_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void geary_smtp_client_service_wait_for_message (GearySmtpClientService* self,
                                                 GearyFolder* location,
                                                 GearyEmail* sent,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void geary_smtp_client_service_wait_for_message_finish (GearySmtpClientService* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void geary_smtp_client_service_sync_sent_mail_data_free (gpointer _data);
static gboolean geary_smtp_client_service_sync_sent_mail_co (GearySmtpClientServiceSyncSentMailData* _data_);
static void geary_smtp_client_service_sync_sent_mail_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void geary_smtp_client_service_wait_for_message_data_free (gpointer _data);
static gboolean geary_smtp_client_service_wait_for_message_co (GearySmtpClientServiceWaitForMessageData* _data_);
static void geary_smtp_client_service_wait_for_message_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static gboolean _geary_smtp_client_service_wait_for_message_co_gsource_func (gpointer self);
static void geary_smtp_client_service_finalize (GObject * obj);
static GType geary_smtp_client_service_get_type_once (void);
static void _vala_geary_smtp_client_service_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_geary_smtp_client_service_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);

static inline gpointer
geary_smtp_client_service_get_instance_private (GearySmtpClientService* self)
{
	return G_STRUCT_MEMBER_P (self, GearySmtpClientService_private_offset);
}

static gchar*
geary_smtp_client_service_email_subject (GearyEmailHeaderSet* email)
{
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GearyRFC822Subject* _tmp2_;
	GearyRFC822Subject* _tmp3_;
	gchar* result;
	g_return_val_if_fail (GEARY_IS_EMAIL_HEADER_SET (email), NULL);
	_tmp2_ = geary_email_header_set_get_subject (email);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GearyRFC822Subject* _tmp4_;
		GearyRFC822Subject* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = geary_email_header_set_get_subject (email);
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_tmp7_ = _tmp6_;
		_tmp1_ = !geary_string_is_empty (_tmp7_);
		_g_free0 (_tmp7_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GearyRFC822Subject* _tmp8_;
		GearyRFC822Subject* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = geary_email_header_set_get_subject (email);
		_tmp9_ = _tmp8_;
		_tmp10_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp10_;
	} else {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("(no subject)");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp11_;
	}
	result = _tmp0_;
	return result;
}

GearyOutboxFolder*
geary_smtp_client_service_get_outbox (GearySmtpClientService* self)
{
	GearyOutboxFolder* result;
	GearyOutboxFolder* _tmp0_;
	g_return_val_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self), NULL);
	_tmp0_ = self->priv->_outbox;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_smtp_client_service_set_outbox (GearySmtpClientService* self,
                                      GearyOutboxFolder* value)
{
	GearyOutboxFolder* old_value;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	old_value = geary_smtp_client_service_get_outbox (self);
	if (old_value != value) {
		GearyOutboxFolder* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_outbox);
		self->priv->_outbox = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_smtp_client_service_properties[GEARY_SMTP_CLIENT_SERVICE_OUTBOX_PROPERTY]);
	}
}

GearyProgressMonitor*
geary_smtp_client_service_get_sending_monitor (GearySmtpClientService* self)
{
	GearyProgressMonitor* result;
	GearyProgressMonitor* _tmp0_;
	g_return_val_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self), NULL);
	_tmp0_ = self->priv->_sending_monitor;
	result = _tmp0_;
	return result;
}

static void
geary_smtp_client_service_set_sending_monitor (GearySmtpClientService* self,
                                               GearyProgressMonitor* value)
{
	GearyProgressMonitor* old_value;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	old_value = geary_smtp_client_service_get_sending_monitor (self);
	if (old_value != value) {
		GearyProgressMonitor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sending_monitor);
		self->priv->_sending_monitor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_smtp_client_service_properties[GEARY_SMTP_CLIENT_SERVICE_SENDING_MONITOR_PROPERTY]);
	}
}

static const gchar*
geary_smtp_client_service_real_get_logging_domain (GearyClientService* base)
{
	const gchar* result;
	GearySmtpClientService* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_CLIENT_SERVICE, GearySmtpClientService);
	result = GEARY_SMTP_CLIENT_SERVICE_LOGGING_DOMAIN;
	return result;
}

static GearyAccount*
geary_smtp_client_service_get_owner (GearySmtpClientService* self)
{
	GearyAccount* result;
	GearyOutboxFolder* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccount* _tmp2_;
	g_return_val_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self), NULL);
	_tmp0_ = self->priv->_outbox;
	_tmp1_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_FOLDER, GearyFolder));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

GearySmtpClientService*
geary_smtp_client_service_construct (GType object_type,
                                     GearyAccountInformation* account,
                                     GearyServiceInformation* service,
                                     GearyEndpoint* remote)
{
	GearySmtpClientService * self = NULL;
	g_return_val_if_fail (GEARY_IS_ACCOUNT_INFORMATION (account), NULL);
	g_return_val_if_fail (GEARY_IS_SERVICE_INFORMATION (service), NULL);
	g_return_val_if_fail (GEARY_IS_ENDPOINT (remote), NULL);
	self = (GearySmtpClientService*) geary_client_service_construct (object_type, account, service, remote);
	return self;
}

GearySmtpClientService*
geary_smtp_client_service_new (GearyAccountInformation* account,
                               GearyServiceInformation* service,
                               GearyEndpoint* remote)
{
	return geary_smtp_client_service_construct (GEARY_SMTP_TYPE_CLIENT_SERVICE, account, service, remote);
}

static void
geary_smtp_client_service_real_start_data_free (gpointer _data)
{
	GearySmtpClientServiceStartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceStartData, _data_);
}

static void
geary_smtp_client_service_real_start (GearyClientService* base,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearySmtpClientService * self;
	GearySmtpClientServiceStartData* _data_;
	GearySmtpClientService* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_CLIENT_SERVICE, GearySmtpClientService);
	_data_ = g_slice_new0 (GearySmtpClientServiceStartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_real_start_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_service_real_start_co (_data_);
}

static void
geary_smtp_client_service_start_finish (GearyClientService* base,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GearySmtpClientServiceStartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Starts the manager opening IMAP client sessions.
     */
static void
geary_smtp_client_service_start_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	GearySmtpClientServiceStartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_real_start_co (_data_);
}

static gboolean
geary_smtp_client_service_real_start_co (GearySmtpClientServiceStartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_outbox;
	_data_->_state_ = 1;
	geary_folder_open_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_TYPE_FOLDER, GearyFolder), GEARY_FOLDER_OPEN_FLAGS_NONE, _data_->cancellable, geary_smtp_client_service_start_ready, _data_);
	return FALSE;
	_state_1:
	geary_folder_open_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_TYPE_FOLDER, GearyFolder), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	geary_smtp_client_service_fill_outbox_queue (_data_->self, _data_->cancellable, geary_smtp_client_service_start_ready, _data_);
	return FALSE;
	_state_2:
	geary_smtp_client_service_fill_outbox_queue_finish (_data_->self, _data_->_res_);
	geary_client_service_notify_started (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_service_real_stop_data_free (gpointer _data)
{
	GearySmtpClientServiceStopData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceStopData, _data_);
}

static void
geary_smtp_client_service_real_stop (GearyClientService* base,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	GearySmtpClientService * self;
	GearySmtpClientServiceStopData* _data_;
	GearySmtpClientService* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_CLIENT_SERVICE, GearySmtpClientService);
	_data_ = g_slice_new0 (GearySmtpClientServiceStopData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_real_stop_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_service_real_stop_co (_data_);
}

static void
geary_smtp_client_service_stop_finish (GearyClientService* base,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GearySmtpClientServiceStopData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Stops the manager running, closing any existing sessions.
     */
static gboolean
_geary_smtp_client_service_real_stop_co_gsource_func (gpointer self)
{
	gboolean result;
	result = geary_smtp_client_service_real_stop_co (self);
	return result;
}

static void
geary_smtp_client_service_stop_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	GearySmtpClientServiceStopData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_real_stop_co (_data_);
}

static gboolean
geary_smtp_client_service_real_stop_co (GearySmtpClientServiceStopData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_client_service_notify_stopped (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	geary_smtp_client_service_stop_postie (_data_->self);
	while (TRUE) {
		_data_->_tmp0_ = _data_->self->priv->queue_cancellable;
		if (!(_data_->_tmp0_ != NULL)) {
			break;
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _geary_smtp_client_service_real_stop_co_gsource_func, _data_, NULL);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_data_->_tmp1_ = _data_->self->priv->_outbox;
	_data_->_state_ = 2;
	geary_folder_close_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEARY_TYPE_FOLDER, GearyFolder), _data_->cancellable, geary_smtp_client_service_stop_ready, _data_);
	return FALSE;
	_state_2:
	geary_folder_close_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, GEARY_TYPE_FOLDER, GearyFolder), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_service_send_email_data_free (gpointer _data)
{
	GearySmtpClientServiceSendEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->composed);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceSendEmailData, _data_);
}

void
geary_smtp_client_service_send_email (GearySmtpClientService* self,
                                      GearyComposedEmail* composed,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearySmtpClientServiceSendEmailData* _data_;
	GearySmtpClientService* _tmp0_;
	GearyComposedEmail* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (composed));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientServiceSendEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_send_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (composed);
	_g_object_unref0 (_data_->composed);
	_data_->composed = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_service_send_email_co (_data_);
}

void
geary_smtp_client_service_send_email_finish (GearySmtpClientService* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearySmtpClientServiceSendEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Saves and queues email for immediate delivery.
     *
     * This is a convenience method that calls {@link save_email} then
     * {@link queue_email} with the resulting id.
     */
static void
geary_smtp_client_service_send_email_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GearySmtpClientServiceSendEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_send_email_co (_data_);
}

static gboolean
geary_smtp_client_service_send_email_co (GearySmtpClientServiceSendEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_smtp_client_service_save_email (_data_->self, _data_->composed, _data_->cancellable, geary_smtp_client_service_send_email_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = geary_smtp_client_service_save_email_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	geary_smtp_client_service_queue_email (_data_->self, _data_->_tmp0_);
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_service_save_email_data_free (gpointer _data)
{
	GearySmtpClientServiceSaveEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->composed);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceSaveEmailData, _data_);
}

void
geary_smtp_client_service_save_email (GearySmtpClientService* self,
                                      GearyComposedEmail* composed,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GearySmtpClientServiceSaveEmailData* _data_;
	GearySmtpClientService* _tmp0_;
	GearyComposedEmail* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IS_COMPOSED_EMAIL (composed));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientServiceSaveEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_save_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (composed);
	_g_object_unref0 (_data_->composed);
	_data_->composed = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_service_save_email_co (_data_);
}

GearyEmailIdentifier*
geary_smtp_client_service_save_email_finish (GearySmtpClientService* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearyEmailIdentifier* result;
	GearySmtpClientServiceSaveEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Saves a composed email in the outbox.
     *
     * This sets a suitable MessageID header for the message, then
     * saves the updated message in {@link outbox}. Returns the
     * identifier for the saved email, suitable for use with {@link
     * queue_email}.
     *
     * @see send_email
     */
static void
geary_smtp_client_service_save_email_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	GearySmtpClientServiceSaveEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_save_email_co (_data_);
}

static gboolean
geary_smtp_client_service_save_email_co (GearySmtpClientServiceSaveEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_smtp_client_service_email_subject (G_TYPE_CHECK_INSTANCE_CAST (_data_->composed, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp1_ = _data_->_tmp0_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Saving composed email: %s", _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	_data_->_tmp2_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_data_->composed, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->from = _data_->_tmp4_;
	_data_->_tmp7_ = _data_->from;
	if (_data_->_tmp7_ != NULL) {
		_data_->_tmp8_ = _data_->from;
		_data_->_tmp9_ = geary_rf_c822_mailbox_addresses_get_is_empty (_data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp6_ = !_data_->_tmp10_;
	} else {
		_data_->_tmp6_ = FALSE;
	}
	if (_data_->_tmp6_) {
		_data_->_tmp11_ = _data_->from;
		_data_->_tmp12_ = geary_rf_c822_mailbox_addresses_get (_data_->_tmp11_, 0);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = geary_rf_c822_mailbox_address_get_domain (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp5_ = _data_->_tmp15_;
		_g_object_unref0 (_data_->_tmp13_);
	} else {
		_data_->_tmp16_ = geary_client_service_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = geary_account_information_get_primary_mailbox (_data_->_tmp17_);
		_data_->_tmp19_ = _data_->_tmp18_;
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = geary_rf_c822_mailbox_address_get_domain (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp5_ = _data_->_tmp22_;
		_g_object_unref0 (_data_->_tmp20_);
	}
	_data_->_tmp23_ = g_strdup (_data_->_tmp5_);
	_data_->domain = _data_->_tmp23_;
	_data_->_tmp24_ = _data_->domain;
	_data_->_tmp25_ = g_mime_utils_generate_message_id (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_state_ = 1;
	geary_rf_c822_message_new_from_composed_email (_data_->composed, _data_->_tmp26_, _data_->cancellable, geary_smtp_client_service_save_email_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp27_ = geary_rf_c822_message_new_from_composed_email_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp28_ = _data_->_tmp27_;
	_g_free0 (_data_->_tmp26_);
	_data_->rfc822 = _data_->_tmp28_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->domain);
		_g_object_unref0 (_data_->from);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp29_ = _data_->self->priv->_outbox;
	_data_->_tmp30_ = _data_->rfc822;
	_data_->_state_ = 2;
	geary_outbox_folder_create_email_async (_data_->_tmp29_, _data_->_tmp30_, NULL, NULL, _data_->cancellable, geary_smtp_client_service_save_email_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp31_ = geary_outbox_folder_create_email_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error0_);
	_data_->id = _data_->_tmp31_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->rfc822);
		_g_free0 (_data_->domain);
		_g_object_unref0 (_data_->from);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = _data_->id;
	_data_->_tmp33_ = geary_email_identifier_to_string (_data_->_tmp32_);
	_data_->_tmp34_ = _data_->_tmp33_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Saved composed email as %s", _data_->_tmp34_);
	_g_free0 (_data_->_tmp34_);
	_data_->result = _data_->id;
	_g_object_unref0 (_data_->rfc822);
	_g_free0 (_data_->domain);
	_g_object_unref0 (_data_->from);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Queues an email for immediate delivery.
     *
     * The given identifier must be for {@link outbox}, for example as
     * given by {@link save_email}.
     *
     * @see send_email
     */
void
geary_smtp_client_service_queue_email (GearySmtpClientService* self,
                                       GearyEmailIdentifier* outbox_identifier)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GearyNonblockingQueue* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IS_EMAIL_IDENTIFIER (outbox_identifier));
	_tmp0_ = geary_email_identifier_to_string (outbox_identifier);
	_tmp1_ = _tmp0_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Queuing email for sending: %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->outbox_queue;
	geary_nonblocking_queue_send (_tmp2_, outbox_identifier);
}

/** Starts the postie delivering messages. */
static void
geary_smtp_client_service_real_became_reachable (GearyClientService* base)
{
	GearySmtpClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_CLIENT_SERVICE, GearySmtpClientService);
	geary_smtp_client_service_start_postie (self, NULL, NULL);
}

/** Stops the postie delivering. */
static void
geary_smtp_client_service_real_became_unreachable (GearyClientService* base)
{
	GearySmtpClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_CLIENT_SERVICE, GearySmtpClientService);
	geary_smtp_client_service_stop_postie (self);
}

static void
geary_smtp_client_service_start_postie_data_free (gpointer _data)
{
	GearySmtpClientServiceStartPostieData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceStartPostieData, _data_);
}

static void
geary_smtp_client_service_start_postie (GearySmtpClientService* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	GearySmtpClientServiceStartPostieData* _data_;
	GearySmtpClientService* _tmp0_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	_data_ = g_slice_new0 (GearySmtpClientServiceStartPostieData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_start_postie_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_smtp_client_service_start_postie_co (_data_);
}

static void
geary_smtp_client_service_start_postie_finish (GearySmtpClientService* self,
                                               GAsyncResult* _res_)
{
	GearySmtpClientServiceStartPostieData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
     * Starts delivery of messages in the queue.
     */
static void
geary_smtp_client_service_start_postie_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	GearySmtpClientServiceStartPostieData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_start_postie_co (_data_);
}

static gboolean
geary_smtp_client_service_start_postie_co (GearySmtpClientServiceStartPostieData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->outbox_queue;
	_data_->_tmp1_ = geary_nonblocking_queue_get_size (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Starting outbox postie with %u messages queued", (guint) _data_->_tmp2_);
	_data_->_tmp3_ = _data_->self->priv->queue_cancellable;
	if (_data_->_tmp3_ != NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->queue_cancellable);
	_data_->self->priv->queue_cancellable = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->queue_cancellable;
	_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
	_data_->cancellable = _data_->_tmp6_;
	while (TRUE) {
		_data_->_tmp7_ = _data_->cancellable;
		if (!(!g_cancellable_is_cancelled (_data_->_tmp7_))) {
			break;
		}
		_data_->id = NULL;
		_data_->email_handled = FALSE;
		{
			_data_->_tmp9_ = _data_->self->priv->outbox_queue;
			_data_->_tmp10_ = _data_->cancellable;
			_data_->_state_ = 1;
			geary_nonblocking_queue_receive (_data_->_tmp9_, _data_->_tmp10_, geary_smtp_client_service_start_postie_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp11_ = geary_nonblocking_queue_receive_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp8_ = (GearyEmailIdentifier*) _data_->_tmp11_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == GEARY_SMTP_ERROR) {
					goto __catch0_geary_smtp_error;
				}
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					goto __catch0_g_io_error_cancelled;
				}
				if (g_error_matches (_data_->_inner_error0_, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND)) {
					goto __catch0_geary_engine_error_not_found;
				}
				goto __catch0_g_error;
			}
			_data_->_tmp12_ = _data_->_tmp8_;
			_data_->_tmp8_ = NULL;
			_g_object_unref0 (_data_->id);
			_data_->id = _data_->_tmp12_;
			_data_->_tmp13_ = _data_->id;
			_data_->_tmp14_ = _data_->cancellable;
			_data_->_state_ = 2;
			geary_smtp_client_service_process_email (_data_->self, _data_->_tmp13_, _data_->_tmp14_, geary_smtp_client_service_start_postie_ready, _data_);
			return FALSE;
			_state_2:
			geary_smtp_client_service_process_email_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->_tmp8_);
				if (_data_->_inner_error0_->domain == GEARY_SMTP_ERROR) {
					goto __catch0_geary_smtp_error;
				}
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
					goto __catch0_g_io_error_cancelled;
				}
				if (g_error_matches (_data_->_inner_error0_, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND)) {
					goto __catch0_geary_engine_error_not_found;
				}
				goto __catch0_g_error;
			}
			_data_->email_handled = TRUE;
			_g_object_unref0 (_data_->_tmp8_);
		}
		goto __finally0;
		__catch0_geary_smtp_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp15_ = _data_->err;
			if (g_error_matches (_data_->_tmp15_, GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_AUTHENTICATION_FAILED)) {
				geary_client_service_notify_authentication_failed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
			} else {
				_data_->_tmp17_ = _data_->err;
				if (g_error_matches (_data_->_tmp17_, GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_STARTTLS_FAILED)) {
					_data_->_tmp16_ = TRUE;
				} else {
					_data_->_tmp18_ = _data_->err;
					_data_->_tmp16_ = g_error_matches (_data_->_tmp18_, GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_NOT_CONNECTED);
				}
				if (_data_->_tmp16_) {
					_data_->_tmp19_ = _data_->err;
					_data_->_tmp20_ = geary_error_context_new (_data_->_tmp19_);
					_data_->_tmp21_ = _data_->_tmp20_;
					geary_client_service_notify_connection_failed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService), _data_->_tmp21_);
					_g_object_unref0 (_data_->_tmp21_);
				} else {
					_data_->_tmp24_ = _data_->err;
					if (g_error_matches (_data_->_tmp24_, GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_PARSE_ERROR)) {
						_data_->_tmp23_ = TRUE;
					} else {
						_data_->_tmp25_ = _data_->err;
						_data_->_tmp23_ = g_error_matches (_data_->_tmp25_, GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_SERVER_ERROR);
					}
					if (_data_->_tmp23_) {
						_data_->_tmp22_ = TRUE;
					} else {
						_data_->_tmp26_ = _data_->err;
						_data_->_tmp22_ = g_error_matches (_data_->_tmp26_, GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_NOT_SUPPORTED);
					}
					if (_data_->_tmp22_) {
						_data_->_tmp27_ = _data_->err;
						_data_->_tmp28_ = geary_error_context_new (_data_->_tmp27_);
						_data_->_tmp29_ = _data_->_tmp28_;
						geary_client_service_notify_unrecoverable_error (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService), _data_->_tmp29_);
						_g_object_unref0 (_data_->_tmp29_);
					}
				}
			}
			_data_->_tmp30_ = _data_->cancellable;
			g_cancellable_cancel (_data_->_tmp30_);
			_g_error_free0 (_data_->err);
		}
		goto __finally0;
		__catch0_g_io_error_cancelled:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		goto __finally0;
		__catch0_geary_engine_error_not_found:
		{
			_data_->_vala1_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->email_handled = TRUE;
			_data_->_tmp31_ = _data_->id;
			_data_->_tmp32_ = geary_email_identifier_to_string (_data_->_tmp31_);
			_data_->_tmp33_ = _data_->_tmp32_;
			_data_->_tmp34_ = _data_->_vala1_err;
			_data_->_tmp35_ = _data_->_tmp34_->message;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Queued email %s not found in outbox, ignoring: %s", _data_->_tmp33_, _data_->_tmp35_);
			_g_free0 (_data_->_tmp33_);
			_g_error_free0 (_data_->_vala1_err);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_vala2_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp36_ = _data_->_vala2_err;
			_data_->_tmp37_ = geary_error_context_new (_data_->_tmp36_);
			_data_->_tmp38_ = _data_->_tmp37_;
			geary_client_service_notify_connection_failed (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService), _data_->_tmp38_);
			_g_object_unref0 (_data_->_tmp38_);
			_data_->_tmp39_ = _data_->cancellable;
			g_cancellable_cancel (_data_->_tmp39_);
			_g_error_free0 (_data_->_vala2_err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->id);
			_g_object_unref0 (_data_->cancellable);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (!_data_->email_handled) {
			_data_->_tmp41_ = _data_->id;
			_data_->_tmp40_ = _data_->_tmp41_ != NULL;
		} else {
			_data_->_tmp40_ = FALSE;
		}
		if (_data_->_tmp40_) {
			_data_->_tmp42_ = _data_->self->priv->outbox_queue;
			_data_->_tmp43_ = _data_->id;
			geary_nonblocking_queue_send (_data_->_tmp42_, _data_->_tmp43_);
		}
		_g_object_unref0 (_data_->id);
	}
	_g_object_unref0 (_data_->self->priv->queue_cancellable);
	_data_->self->priv->queue_cancellable = NULL;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Outbox postie exited");
	_g_object_unref0 (_data_->cancellable);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Stops delivery of messages in the queue.
     */
static void
geary_smtp_client_service_stop_postie (GearySmtpClientService* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Stopping outbox postie");
	_tmp0_ = self->priv->queue_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->queue_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static void
geary_smtp_client_service_fill_outbox_queue_data_free (gpointer _data)
{
	GearySmtpClientServiceFillOutboxQueueData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceFillOutboxQueueData, _data_);
}

static void
geary_smtp_client_service_fill_outbox_queue (GearySmtpClientService* self,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GearySmtpClientServiceFillOutboxQueueData* _data_;
	GearySmtpClientService* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientServiceFillOutboxQueueData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_fill_outbox_queue_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_service_fill_outbox_queue_co (_data_);
}

static void
geary_smtp_client_service_fill_outbox_queue_finish (GearySmtpClientService* self,
                                                    GAsyncResult* _res_)
{
	GearySmtpClientServiceFillOutboxQueueData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Loads any email in the outbox and adds them to the queue.
     */
static void
geary_smtp_client_service_fill_outbox_queue_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	GearySmtpClientServiceFillOutboxQueueData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_fill_outbox_queue_co (_data_);
}

static gboolean
geary_smtp_client_service_fill_outbox_queue_co (GearySmtpClientServiceFillOutboxQueueData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Filling queue");
	{
		_data_->_tmp0_ = _data_->self->priv->_outbox;
		_data_->_state_ = 1;
		geary_folder_list_email_by_id_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_TYPE_FOLDER, GearyFolder), NULL, G_MAXINT, GEARY_EMAIL_FIELD_NONE, GEARY_FOLDER_LIST_FLAGS_OLDEST_TO_NEWEST, _data_->cancellable, geary_smtp_client_service_fill_outbox_queue_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = geary_folder_list_email_by_id_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_TYPE_FOLDER, GearyFolder), _data_->_res_, &_data_->_inner_error0_);
		_data_->queued = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data_->queued != NULL) {
			{
				_data_->_email_list = _data_->queued;
				_data_->_tmp2_ = _data_->_email_list;
				_data_->_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
				_data_->_tmp4_ = _data_->_tmp3_;
				_data_->_email_size = _data_->_tmp4_;
				_data_->_email_index = -1;
				while (TRUE) {
					_data_->_email_index = _data_->_email_index + 1;
					_data_->_tmp5_ = _data_->_email_index;
					_data_->_tmp6_ = _data_->_email_size;
					if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
						break;
					}
					_data_->_tmp7_ = _data_->_email_list;
					_data_->_tmp8_ = gee_list_get (_data_->_tmp7_, _data_->_email_index);
					_data_->email = (GearyEmail*) _data_->_tmp8_;
					_data_->_tmp9_ = _data_->self->priv->outbox_queue;
					_data_->_tmp10_ = _data_->email;
					_data_->_tmp11_ = geary_email_get_id (_data_->_tmp10_);
					_data_->_tmp12_ = _data_->_tmp11_;
					geary_nonblocking_queue_send (_data_->_tmp9_, _data_->_tmp12_);
					_g_object_unref0 (_data_->email);
				}
			}
		}
		_g_object_unref0 (_data_->queued);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->err;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		geary_logging_source_warning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error filling queue: %s", _data_->_tmp14_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_service_process_email_data_free (gpointer _data)
{
	GearySmtpClientServiceProcessEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceProcessEmailData, _data_);
}

static void
geary_smtp_client_service_process_email (GearySmtpClientService* self,
                                         GearyEmailIdentifier* id,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GearySmtpClientServiceProcessEmailData* _data_;
	GearySmtpClientService* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IS_EMAIL_IDENTIFIER (id));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientServiceProcessEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_process_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (id);
	_g_object_unref0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_service_process_email_co (_data_);
}

static void
geary_smtp_client_service_process_email_finish (GearySmtpClientService* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	GearySmtpClientServiceProcessEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_smtp_client_service_process_email_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GearySmtpClientServiceProcessEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_process_email_co (_data_);
}

static gboolean
geary_smtp_client_service_process_email_co (GearySmtpClientServiceProcessEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = geary_client_service_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	geary_account_information_load_outgoing_credentials (_data_->_tmp2_, _data_->cancellable, geary_smtp_client_service_process_email_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = geary_account_information_load_outgoing_credentials_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!_data_->_tmp0_) {
		_data_->_tmp3_ = g_error_new_literal (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_AUTHENTICATION_FAILED, "Credentials not loaded");
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->_outbox;
	_data_->_state_ = 2;
	geary_folder_fetch_email_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEARY_TYPE_FOLDER, GearyFolder), _data_->id, GEARY_EMAIL_FIELD_ALL, GEARY_FOLDER_LIST_FLAGS_NONE, _data_->cancellable, geary_smtp_client_service_process_email_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp5_ = geary_folder_fetch_email_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEARY_TYPE_FOLDER, GearyFolder), _data_->_res_, &_data_->_inner_error0_);
	_data_->email = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->email;
	_data_->_tmp7_ = geary_email_get_email_flags (_data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = geary_email_flags_get_OUTBOX_SENT ();
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_tmp12_ = !geary_named_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), _data_->_tmp11_);
	_g_object_unref0 (_data_->_tmp11_);
	if (_data_->_tmp12_) {
		_data_->_tmp13_ = _data_->email;
		_data_->_tmp14_ = geary_email_get_message (_data_->_tmp13_, &_data_->_inner_error0_);
		_data_->message = _data_->_tmp14_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->email);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp15_ = _data_->message;
		_data_->_tmp16_ = geary_smtp_client_service_email_subject (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = _data_->email;
		_data_->_tmp19_ = geary_email_get_id (_data_->_tmp18_);
		_data_->_tmp20_ = _data_->_tmp19_;
		_data_->_tmp21_ = geary_email_identifier_to_string (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Outbox postie: Sending \"%s\" (ID:%s)...", _data_->_tmp17_, _data_->_tmp22_);
		_g_free0 (_data_->_tmp22_);
		_g_free0 (_data_->_tmp17_);
		_data_->_tmp23_ = _data_->message;
		_data_->_state_ = 3;
		geary_smtp_client_service_send_email_internal (_data_->self, _data_->_tmp23_, _data_->cancellable, geary_smtp_client_service_process_email_ready, _data_);
		return FALSE;
		_state_3:
		geary_smtp_client_service_send_email_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->message);
			_g_object_unref0 (_data_->email);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp24_ = _data_->email;
		g_signal_emit (_data_->self, geary_smtp_client_service_signals[GEARY_SMTP_CLIENT_SERVICE_EMAIL_SENT_SIGNAL], 0, _data_->_tmp24_);
		_data_->_tmp25_ = _data_->email;
		_data_->_tmp26_ = geary_email_get_id (_data_->_tmp25_);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = geary_email_identifier_to_string (_data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Outbox postie: Marking %s as sent", _data_->_tmp29_);
		_g_free0 (_data_->_tmp29_);
		_data_->_tmp30_ = geary_email_flags_new ();
		_data_->flags = _data_->_tmp30_;
		_data_->_tmp31_ = _data_->flags;
		_data_->_tmp32_ = geary_email_flags_get_OUTBOX_SENT ();
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = _data_->_tmp33_;
		geary_named_flags_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), _data_->_tmp34_);
		_g_object_unref0 (_data_->_tmp34_);
		_data_->_tmp35_ = _data_->self->priv->_outbox;
		_data_->_tmp36_ = _data_->email;
		_data_->_tmp37_ = geary_email_get_id (_data_->_tmp36_);
		_data_->_tmp38_ = _data_->_tmp37_;
		_data_->_tmp39_ = geary_collection_single (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp38_);
		_data_->_tmp40_ = _data_->_tmp39_;
		_data_->_tmp41_ = _data_->flags;
		_data_->_state_ = 4;
		geary_outbox_folder_mark_email_async (_data_->_tmp35_, _data_->_tmp40_, _data_->_tmp41_, NULL, NULL, geary_smtp_client_service_process_email_ready, _data_);
		return FALSE;
		_state_4:
		geary_outbox_folder_mark_email_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp40_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->flags);
			_g_object_unref0 (_data_->message);
			_g_object_unref0 (_data_->email);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (g_cancellable_is_cancelled (_data_->cancellable)) {
			_data_->_tmp42_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Send has been cancelled");
			_data_->_inner_error0_ = _data_->_tmp42_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->flags);
			_g_object_unref0 (_data_->message);
			_g_object_unref0 (_data_->email);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->flags);
		_g_object_unref0 (_data_->message);
	}
	_data_->_tmp43_ = geary_client_service_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp44_ = _data_->_tmp43_;
	_data_->_tmp45_ = geary_account_information_get_save_sent (_data_->_tmp44_);
	_data_->_tmp46_ = _data_->_tmp45_;
	if (_data_->_tmp46_) {
		_data_->_tmp47_ = _data_->email;
		_data_->_tmp48_ = geary_email_get_id (_data_->_tmp47_);
		_data_->_tmp49_ = _data_->_tmp48_;
		_data_->_tmp50_ = geary_email_identifier_to_string (_data_->_tmp49_);
		_data_->_tmp51_ = _data_->_tmp50_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Outbox postie: Saving %s to sent mail", _data_->_tmp51_);
		_g_free0 (_data_->_tmp51_);
		_data_->_tmp52_ = _data_->email;
		_data_->_state_ = 5;
		geary_smtp_client_service_save_sent_mail (_data_->self, _data_->_tmp52_, _data_->cancellable, geary_smtp_client_service_process_email_ready, _data_);
		return FALSE;
		_state_5:
		geary_smtp_client_service_save_sent_mail_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->email);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp53_ = _data_->email;
		_data_->_tmp54_ = geary_email_get_id (_data_->_tmp53_);
		_data_->_tmp55_ = _data_->_tmp54_;
		_data_->_tmp56_ = geary_email_identifier_to_string (_data_->_tmp55_);
		_data_->_tmp57_ = _data_->_tmp56_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Outbox postie: Syncing sent mail to find %s", _data_->_tmp57_);
		_g_free0 (_data_->_tmp57_);
		_data_->_tmp58_ = _data_->email;
		_data_->_state_ = 6;
		geary_smtp_client_service_sync_sent_mail (_data_->self, _data_->_tmp58_, _data_->cancellable, geary_smtp_client_service_process_email_ready, _data_);
		return FALSE;
		_state_6:
		geary_smtp_client_service_sync_sent_mail_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->email);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp59_ = _data_->email;
	_data_->_tmp60_ = geary_email_get_id (_data_->_tmp59_);
	_data_->_tmp61_ = _data_->_tmp60_;
	_data_->_tmp62_ = geary_email_identifier_to_string (_data_->_tmp61_);
	_data_->_tmp63_ = _data_->_tmp62_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Outbox postie: Deleting row %s", _data_->_tmp63_);
	_g_free0 (_data_->_tmp63_);
	_data_->_tmp64_ = _data_->self->priv->_outbox;
	_data_->_tmp65_ = _data_->email;
	_data_->_tmp66_ = geary_email_get_id (_data_->_tmp65_);
	_data_->_tmp67_ = _data_->_tmp66_;
	_data_->_tmp68_ = geary_collection_single (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp67_);
	_data_->_tmp69_ = _data_->_tmp68_;
	_data_->_state_ = 7;
	geary_outbox_folder_remove_email_async (_data_->_tmp64_, _data_->_tmp69_, NULL, geary_smtp_client_service_process_email_ready, _data_);
	return FALSE;
	_state_7:
	geary_outbox_folder_remove_email_finish (_data_->_tmp64_, _data_->_res_, &_data_->_inner_error0_);
	_g_object_unref0 (_data_->_tmp69_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->email);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->email);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_service_send_email_internal_data_free (gpointer _data)
{
	GearySmtpClientServiceSendEmailInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->rfc822);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceSendEmailInternalData, _data_);
}

static void
geary_smtp_client_service_send_email_internal (GearySmtpClientService* self,
                                               GearyRFC822Message* rfc822,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	GearySmtpClientServiceSendEmailInternalData* _data_;
	GearySmtpClientService* _tmp0_;
	GearyRFC822Message* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (rfc822));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientServiceSendEmailInternalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_send_email_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (rfc822);
	_g_object_unref0 (_data_->rfc822);
	_data_->rfc822 = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_service_send_email_internal_co (_data_);
}

static void
geary_smtp_client_service_send_email_internal_finish (GearySmtpClientService* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	GearySmtpClientServiceSendEmailInternalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_smtp_client_service_send_email_internal_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	GearySmtpClientServiceSendEmailInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_send_email_internal_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
geary_smtp_client_service_send_email_internal_co (GearySmtpClientServiceSendEmailInternalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_client_service_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_account_information_get_outgoing_credentials (_data_->_tmp1_);
	_data_->login = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->login;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->login;
		_data_->_tmp3_ = !geary_credentials_is_complete (_data_->_tmp5_);
	} else {
		_data_->_tmp3_ = FALSE;
	}
	if (_data_->_tmp3_) {
		_data_->_tmp6_ = g_error_new_literal (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_AUTHENTICATION_FAILED, "Token not loaded");
		_data_->_inner_error0_ = _data_->_tmp6_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->login);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = geary_client_service_get_remote (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = geary_smtp_client_session_new (_data_->_tmp8_);
	_data_->smtp = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->smtp;
	geary_smtp_client_session_set_logging_parent (_data_->_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp11_ = _data_->self->priv->_sending_monitor;
	geary_progress_monitor_notify_start (_data_->_tmp11_);
	_data_->smtp_err = NULL;
	{
		_data_->_tmp12_ = _data_->smtp;
		_data_->_tmp13_ = _data_->login;
		_data_->_state_ = 1;
		geary_smtp_client_session_login_async (_data_->_tmp12_, _data_->_tmp13_, _data_->cancellable, geary_smtp_client_service_send_email_internal_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp14_ = geary_smtp_client_session_login_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_geary_smtp_response_unref0 (_data_->_tmp15_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->login_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp16_ = _data_->login_err;
		_data_->_tmp17_ = _data_->_tmp16_->message;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "SMTP login error: %s", _data_->_tmp17_);
		_data_->_tmp18_ = _data_->login_err;
		_data_->_tmp19_ = _g_error_copy0 (_data_->_tmp18_);
		_g_error_free0 (_data_->smtp_err);
		_data_->smtp_err = _data_->_tmp19_;
		_g_error_free0 (_data_->login_err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->smtp_err);
		_g_object_unref0 (_data_->smtp);
		_g_object_unref0 (_data_->login);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->smtp_err;
	if (_data_->_tmp20_ == NULL) {
		_data_->_tmp21_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (_data_->rfc822, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = _g_object_ref0 (_data_->_tmp22_);
		_data_->reverse_path = _data_->_tmp23_;
		_data_->_tmp24_ = _data_->reverse_path;
		if (_data_->_tmp24_ == NULL) {
			_data_->_tmp25_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_data_->rfc822, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_data_->_tmp26_ = _data_->_tmp25_;
			if (_data_->_tmp26_ != NULL) {
				{
					_data_->_tmp27_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_data_->rfc822, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
					_data_->_tmp28_ = _data_->_tmp27_;
					_data_->_from_list = _data_->_tmp28_;
					_data_->_tmp29_ = _data_->_from_list;
					_data_->_tmp30_ = geary_rf_c822_mailbox_addresses_get_size (_data_->_tmp29_);
					_data_->_tmp31_ = _data_->_tmp30_;
					_data_->_from_size = _data_->_tmp31_;
					_data_->_from_index = -1;
					while (TRUE) {
						_data_->_from_index = _data_->_from_index + 1;
						_data_->_tmp32_ = _data_->_from_index;
						_data_->_tmp33_ = _data_->_from_size;
						if (!(_data_->_tmp32_ < _data_->_tmp33_)) {
							break;
						}
						_data_->_tmp34_ = _data_->_from_list;
						_data_->_tmp35_ = geary_rf_c822_mailbox_addresses_get (_data_->_tmp34_, _data_->_from_index);
						_data_->from = _data_->_tmp35_;
						_data_->_tmp36_ = geary_client_service_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
						_data_->_tmp37_ = _data_->_tmp36_;
						_data_->_tmp38_ = _data_->from;
						if (geary_account_information_has_sender_mailbox (_data_->_tmp37_, _data_->_tmp38_)) {
							_data_->_tmp39_ = _data_->from;
							_data_->_tmp40_ = _g_object_ref0 (_data_->_tmp39_);
							_g_object_unref0 (_data_->reverse_path);
							_data_->reverse_path = _data_->_tmp40_;
							_g_object_unref0 (_data_->from);
							break;
						}
						_g_object_unref0 (_data_->from);
					}
				}
			}
			_data_->_tmp41_ = _data_->reverse_path;
			if (_data_->_tmp41_ == NULL) {
				_data_->_tmp42_ = geary_client_service_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
				_data_->_tmp43_ = _data_->_tmp42_;
				_data_->_tmp44_ = geary_account_information_get_primary_mailbox (_data_->_tmp43_);
				_data_->_tmp45_ = _data_->_tmp44_;
				_g_object_unref0 (_data_->reverse_path);
				_data_->reverse_path = _data_->_tmp45_;
			}
		}
		{
			_data_->_tmp46_ = _data_->smtp;
			_data_->_tmp47_ = _data_->reverse_path;
			_data_->_state_ = 2;
			geary_smtp_client_session_send_email_async (_data_->_tmp46_, _data_->_tmp47_, _data_->rfc822, _data_->cancellable, geary_smtp_client_service_send_email_internal_ready, _data_);
			return FALSE;
			_state_2:
			geary_smtp_client_session_send_email_finish (_data_->_tmp46_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->send_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp48_ = _data_->send_err;
			_data_->_tmp49_ = _data_->_tmp48_->message;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "SMTP send mail error: %s", _data_->_tmp49_);
			_data_->_tmp50_ = _data_->send_err;
			_data_->_tmp51_ = _g_error_copy0 (_data_->_tmp50_);
			_g_error_free0 (_data_->smtp_err);
			_data_->smtp_err = _data_->_tmp51_;
			_g_error_free0 (_data_->send_err);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->reverse_path);
			_g_error_free0 (_data_->smtp_err);
			_g_object_unref0 (_data_->smtp);
			_g_object_unref0 (_data_->login);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->reverse_path);
	}
	{
		_data_->_tmp52_ = _data_->smtp;
		_data_->_state_ = 3;
		geary_smtp_client_session_logout_async (_data_->_tmp52_, FALSE, NULL, geary_smtp_client_service_send_email_internal_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp53_ = geary_smtp_client_session_logout_finish (_data_->_tmp52_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp54_ = _data_->_tmp53_;
		_geary_smtp_response_unref0 (_data_->_tmp54_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp55_ = _data_->smtp;
		_data_->_tmp56_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp55_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp57_ = _data_->_tmp56_;
		_data_->_tmp58_ = _data_->err;
		_data_->_tmp59_ = _data_->_tmp58_->message;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Unable to disconnect from SMTP server %s: %s", _data_->_tmp57_, _data_->_tmp59_);
		_g_free0 (_data_->_tmp57_);
		_g_error_free0 (_data_->err);
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->smtp_err);
		_g_object_unref0 (_data_->smtp);
		_g_object_unref0 (_data_->login);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp60_ = _data_->self->priv->_sending_monitor;
	geary_progress_monitor_notify_finish (_data_->_tmp60_);
	_data_->_tmp61_ = _data_->smtp_err;
	if (_data_->_tmp61_ != NULL) {
		_data_->_tmp62_ = _data_->smtp_err;
		_data_->_tmp63_ = _g_error_copy0 (_data_->_tmp62_);
		_data_->_inner_error0_ = _data_->_tmp63_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->smtp_err);
		_g_object_unref0 (_data_->smtp);
		_g_object_unref0 (_data_->login);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_error_free0 (_data_->smtp_err);
	_g_object_unref0 (_data_->smtp);
	_g_object_unref0 (_data_->login);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_service_save_sent_mail_data_free (gpointer _data)
{
	GearySmtpClientServiceSaveSentMailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceSaveSentMailData, _data_);
}

static void
geary_smtp_client_service_save_sent_mail (GearySmtpClientService* self,
                                          GearyEmail* message,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GearySmtpClientServiceSaveSentMailData* _data_;
	GearySmtpClientService* _tmp0_;
	GearyEmail* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IS_EMAIL (message));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientServiceSaveSentMailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_save_sent_mail_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_service_save_sent_mail_co (_data_);
}

static void
geary_smtp_client_service_save_sent_mail_finish (GearySmtpClientService* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GearySmtpClientServiceSaveSentMailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_smtp_client_service_save_sent_mail_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	GearySmtpClientServiceSaveSentMailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_save_sent_mail_co (_data_);
}

static gboolean
geary_smtp_client_service_save_sent_mail_co (GearySmtpClientServiceSaveSentMailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = geary_smtp_client_service_get_owner (_data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	geary_account_get_required_special_folder_async (_data_->_tmp2_, GEARY_FOLDER_SPECIAL_USE_SENT, _data_->cancellable, geary_smtp_client_service_save_sent_mail_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = geary_account_get_required_special_folder_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _g_object_ref0 (GEARY_FOLDER_SUPPORT_IS_CREATE (_data_->_tmp0_) ? ((GearyFolderSupportCreate*) _data_->_tmp0_) : NULL);
	_data_->create = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->create;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp6_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_UNSUPPORTED, "Save sent mail enabled, but no writable sent mail folder");
		_data_->_inner_error0_ = _data_->_tmp6_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->create);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = geary_email_get_message (_data_->message, &_data_->_inner_error0_);
	_data_->raw = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->create);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->open = FALSE;
	{
		_data_->_tmp8_ = _data_->create;
		_data_->_state_ = 2;
		geary_folder_open_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEARY_TYPE_FOLDER, GearyFolder), GEARY_FOLDER_OPEN_FLAGS_NO_DELAY, _data_->cancellable, geary_smtp_client_service_save_sent_mail_ready, _data_);
		return FALSE;
		_state_2:
		geary_folder_open_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEARY_TYPE_FOLDER, GearyFolder), _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_data_->open = TRUE;
		_data_->_tmp9_ = _data_->create;
		_data_->_tmp10_ = _data_->raw;
		_data_->_state_ = 3;
		geary_folder_support_create_create_email_async (_data_->_tmp9_, _data_->_tmp10_, NULL, NULL, _data_->cancellable, geary_smtp_client_service_save_sent_mail_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp11_ = geary_folder_support_create_create_email_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_g_object_unref0 (_data_->_tmp12_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
		_data_->_tmp13_ = _data_->create;
		_data_->_state_ = 4;
		geary_smtp_client_service_wait_for_message (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp13_, GEARY_TYPE_FOLDER, GearyFolder), _data_->message, _data_->cancellable, geary_smtp_client_service_save_sent_mail_ready, _data_);
		return FALSE;
		_state_4:
		geary_smtp_client_service_wait_for_message_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		if (_data_->open) {
			{
				_data_->_tmp14_ = _data_->create;
				_data_->_state_ = 5;
				geary_folder_close_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, GEARY_TYPE_FOLDER, GearyFolder), NULL, geary_smtp_client_service_save_sent_mail_ready, _data_);
				return FALSE;
				_state_5:
				geary_folder_close_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, GEARY_TYPE_FOLDER, GearyFolder), _data_->_res_, &_data_->_inner_error1_);
				if (G_UNLIKELY (_data_->_inner_error1_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				_data_->e = _data_->_inner_error1_;
				_data_->_inner_error1_ = NULL;
				_data_->_tmp15_ = _data_->create;
				_data_->_tmp16_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
				_data_->_tmp17_ = _data_->_tmp16_;
				_data_->_tmp18_ = _data_->e;
				_data_->_tmp19_ = _data_->_tmp18_->message;
				geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error closing folder %s: %s", _data_->_tmp17_, _data_->_tmp19_);
				_g_free0 (_data_->_tmp17_);
				_g_error_free0 (_data_->e);
			}
			__finally1:
			if (G_UNLIKELY (_data_->_inner_error1_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error1_);
				_g_object_unref0 (_data_->raw);
				_g_object_unref0 (_data_->create);
				_g_object_unref0 (_data_->_tmp0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->raw);
		_g_object_unref0 (_data_->create);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->raw);
	_g_object_unref0 (_data_->create);
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_service_sync_sent_mail_data_free (gpointer _data)
{
	GearySmtpClientServiceSyncSentMailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceSyncSentMailData, _data_);
}

static void
geary_smtp_client_service_sync_sent_mail (GearySmtpClientService* self,
                                          GearyEmail* message,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GearySmtpClientServiceSyncSentMailData* _data_;
	GearySmtpClientService* _tmp0_;
	GearyEmail* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IS_EMAIL (message));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientServiceSyncSentMailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_sync_sent_mail_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_service_sync_sent_mail_co (_data_);
}

static void
geary_smtp_client_service_sync_sent_mail_finish (GearySmtpClientService* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GearySmtpClientServiceSyncSentMailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_smtp_client_service_sync_sent_mail_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	GearySmtpClientServiceSyncSentMailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_sync_sent_mail_co (_data_);
}

static gboolean
geary_smtp_client_service_sync_sent_mail_co (GearySmtpClientServiceSyncSentMailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_smtp_client_service_get_owner (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_account_get_special_folder (_data_->_tmp1_, GEARY_FOLDER_SPECIAL_USE_SENT);
	_data_->sent = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->sent;
	if (_data_->_tmp3_ != NULL) {
		_data_->open = FALSE;
		{
			_data_->_tmp4_ = _data_->sent;
			_data_->_state_ = 1;
			geary_folder_open_async (_data_->_tmp4_, GEARY_FOLDER_OPEN_FLAGS_NO_DELAY, _data_->cancellable, geary_smtp_client_service_sync_sent_mail_ready, _data_);
			return FALSE;
			_state_1:
			geary_folder_open_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __finally0;
			}
			_data_->open = TRUE;
			_data_->_tmp5_ = _data_->sent;
			_data_->_state_ = 2;
			geary_folder_synchronise_remote (_data_->_tmp5_, _data_->cancellable, geary_smtp_client_service_sync_sent_mail_ready, _data_);
			return FALSE;
			_state_2:
			geary_folder_synchronise_remote_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __finally0;
			}
			_data_->_tmp6_ = _data_->sent;
			_data_->_state_ = 3;
			geary_smtp_client_service_wait_for_message (_data_->self, _data_->_tmp6_, _data_->message, _data_->cancellable, geary_smtp_client_service_sync_sent_mail_ready, _data_);
			return FALSE;
			_state_3:
			geary_smtp_client_service_wait_for_message_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __finally0;
			}
		}
		__finally0:
		{
			if (_data_->open) {
				{
					_data_->_tmp7_ = _data_->sent;
					_data_->_state_ = 4;
					geary_folder_close_async (_data_->_tmp7_, NULL, geary_smtp_client_service_sync_sent_mail_ready, _data_);
					return FALSE;
					_state_4:
					geary_folder_close_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error1_);
					if (G_UNLIKELY (_data_->_inner_error1_ != NULL)) {
						goto __catch1_g_error;
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					_data_->e = _data_->_inner_error1_;
					_data_->_inner_error1_ = NULL;
					_data_->_tmp8_ = _data_->sent;
					_data_->_tmp9_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
					_data_->_tmp10_ = _data_->_tmp9_;
					_data_->_tmp11_ = _data_->e;
					_data_->_tmp12_ = _data_->_tmp11_->message;
					geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Error closing folder %s: %s", _data_->_tmp10_, _data_->_tmp12_);
					_g_free0 (_data_->_tmp10_);
					_g_error_free0 (_data_->e);
				}
				__finally1:
				if (G_UNLIKELY (_data_->_inner_error1_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error1_);
					_g_object_unref0 (_data_->sent);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->sent);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->sent);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_service_wait_for_message_data_free (gpointer _data)
{
	GearySmtpClientServiceWaitForMessageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->location);
	_g_object_unref0 (_data_->sent);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientServiceWaitForMessageData, _data_);
}

static void
geary_smtp_client_service_wait_for_message (GearySmtpClientService* self,
                                            GearyFolder* location,
                                            GearyEmail* sent,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearySmtpClientServiceWaitForMessageData* _data_;
	GearySmtpClientService* _tmp0_;
	GearyFolder* _tmp1_;
	GearyEmail* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_SERVICE (self));
	g_return_if_fail (GEARY_IS_FOLDER (location));
	g_return_if_fail (GEARY_IS_EMAIL (sent));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientServiceWaitForMessageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_service_wait_for_message_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (location);
	_g_object_unref0 (_data_->location);
	_data_->location = _tmp1_;
	_tmp2_ = _g_object_ref0 (sent);
	_g_object_unref0 (_data_->sent);
	_data_->sent = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_smtp_client_service_wait_for_message_co (_data_);
}

static void
geary_smtp_client_service_wait_for_message_finish (GearySmtpClientService* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GearySmtpClientServiceWaitForMessageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_smtp_client_service_wait_for_message_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GearySmtpClientServiceWaitForMessageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_service_wait_for_message_co (_data_);
}

static gboolean
_geary_smtp_client_service_wait_for_message_co_gsource_func (gpointer self)
{
	gboolean result;
	result = geary_smtp_client_service_wait_for_message_co (self);
	return result;
}

static gboolean
geary_smtp_client_service_wait_for_message_co (GearySmtpClientServiceWaitForMessageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (_data_->sent, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->id = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->id;
	if (_data_->_tmp3_ != NULL) {
		static const gint MAX_RETRIES = 3;
		{
			_data_->i = 0;
			{
				_data_->_tmp4_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp4_) {
						_data_->_tmp5_ = _data_->i;
						_data_->i = _data_->_tmp5_ + 1;
					}
					_data_->_tmp4_ = FALSE;
					if (!(_data_->i < MAX_RETRIES)) {
						break;
					}
					_data_->_state_ = 1;
					geary_folder_list_email_by_id_async (_data_->location, NULL, 1, GEARY_EMAIL_FIELD_REFERENCES, GEARY_FOLDER_LIST_FLAGS_NONE, _data_->cancellable, geary_smtp_client_service_wait_for_message_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp6_ = geary_folder_list_email_by_id_finish (_data_->location, _data_->_res_, &_data_->_inner_error0_);
					_data_->list = _data_->_tmp6_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->id);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp8_ = _data_->list;
					if (_data_->_tmp8_ != NULL) {
						_data_->_tmp9_ = _data_->list;
						_data_->_tmp10_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, GEE_TYPE_COLLECTION, GeeCollection));
						_data_->_tmp11_ = _data_->_tmp10_;
						_data_->_tmp7_ = !_data_->_tmp11_;
					} else {
						_data_->_tmp7_ = FALSE;
					}
					if (_data_->_tmp7_) {
						_data_->_tmp12_ = _data_->list;
						_data_->_tmp13_ = geary_collection_first (GEARY_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
						_data_->listed = (GearyEmail*) _data_->_tmp13_;
						_data_->_tmp15_ = _data_->listed;
						_data_->_tmp16_ = geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
						_data_->_tmp17_ = _data_->_tmp16_;
						if (_data_->_tmp17_ != NULL) {
							_data_->_tmp18_ = _data_->listed;
							_data_->_tmp19_ = geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
							_data_->_tmp20_ = _data_->_tmp19_;
							_data_->_tmp21_ = _data_->id;
							_data_->_tmp14_ = geary_message_data_string_message_data_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData), G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, GEARY_MESSAGE_DATA_TYPE_STRING_MESSAGE_DATA, GearyMessageDataStringMessageData));
						} else {
							_data_->_tmp14_ = FALSE;
						}
						if (_data_->_tmp14_) {
							_g_object_unref0 (_data_->listed);
							_g_object_unref0 (_data_->list);
							break;
						}
						_g_object_unref0 (_data_->listed);
					}
					geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Waiting for sent mail...");
					g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _geary_smtp_client_service_wait_for_message_co_gsource_func, _data_, NULL);
					_data_->_state_ = 2;
					return FALSE;
					_state_2:
					;
					_g_object_unref0 (_data_->list);
				}
			}
		}
	}
	_g_object_unref0 (_data_->id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_service_class_init (GearySmtpClientServiceClass * klass,
                                      gpointer klass_data)
{
	geary_smtp_client_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearySmtpClientService_private_offset);
	((GearyClientServiceClass *) klass)->start = (void (*) (GearyClientService*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_smtp_client_service_real_start;
	((GearyClientServiceClass *) klass)->start_finish = (void (*) (GearyClientService*, GAsyncResult*, GError**)) geary_smtp_client_service_start_finish;
	((GearyClientServiceClass *) klass)->stop = (void (*) (GearyClientService*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_smtp_client_service_real_stop;
	((GearyClientServiceClass *) klass)->stop_finish = (void (*) (GearyClientService*, GAsyncResult*, GError**)) geary_smtp_client_service_stop_finish;
	((GearyClientServiceClass *) klass)->became_reachable = (void (*) (GearyClientService*)) geary_smtp_client_service_real_became_reachable;
	((GearyClientServiceClass *) klass)->became_unreachable = (void (*) (GearyClientService*)) geary_smtp_client_service_real_became_unreachable;
	GEARY_CLIENT_SERVICE_CLASS (klass)->get_logging_domain = geary_smtp_client_service_real_get_logging_domain;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_smtp_client_service_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_smtp_client_service_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_smtp_client_service_finalize;
	/** Folder used for storing and retrieving queued mail. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SMTP_CLIENT_SERVICE_OUTBOX_PROPERTY, geary_smtp_client_service_properties[GEARY_SMTP_CLIENT_SERVICE_OUTBOX_PROPERTY] = g_param_spec_object ("outbox", "outbox", "outbox", GEARY_OUTBOX_TYPE_FOLDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Progress monitor indicating when email is being sent. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SMTP_CLIENT_SERVICE_SENDING_MONITOR_PROPERTY, geary_smtp_client_service_properties[GEARY_SMTP_CLIENT_SERVICE_SENDING_MONITOR_PROPERTY] = g_param_spec_object ("sending-monitor", "sending-monitor", "sending-monitor", GEARY_TYPE_PROGRESS_MONITOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SMTP_CLIENT_SERVICE_LOGGING_DOMAIN_PROPERTY, geary_smtp_client_service_properties[GEARY_SMTP_CLIENT_SERVICE_LOGGING_DOMAIN_PROPERTY] = g_param_spec_string ("logging-domain", "logging-domain", "logging-domain", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Emitted when the manager has sent an email. */
	geary_smtp_client_service_signals[GEARY_SMTP_CLIENT_SERVICE_EMAIL_SENT_SIGNAL] = g_signal_new ("email-sent", GEARY_SMTP_TYPE_CLIENT_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_EMAIL);
	/** Emitted when an error occurred sending an email. */
	geary_smtp_client_service_signals[GEARY_SMTP_CLIENT_SERVICE_REPORT_PROBLEM_SIGNAL] = g_signal_new ("report-problem", GEARY_SMTP_TYPE_CLIENT_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEARY_TYPE_PROBLEM_REPORT);
}

static void
geary_smtp_client_service_instance_init (GearySmtpClientService * self,
                                         gpointer klass)
{
	GearySimpleProgressMonitor* _tmp0_;
	GearyNonblockingQueue* _tmp1_;
	self->priv = geary_smtp_client_service_get_instance_private (self);
	self->priv->_outbox = NULL;
	_tmp0_ = geary_simple_progress_monitor_new (GEARY_PROGRESS_TYPE_ACTIVITY);
	self->priv->_sending_monitor = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor);
	_tmp1_ = geary_nonblocking_queue_new_fifo (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->outbox_queue = _tmp1_;
	self->priv->queue_cancellable = NULL;
}

static void
geary_smtp_client_service_finalize (GObject * obj)
{
	GearySmtpClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SMTP_TYPE_CLIENT_SERVICE, GearySmtpClientService);
	_g_object_unref0 (self->priv->_outbox);
	_g_object_unref0 (self->priv->_sending_monitor);
	_g_object_unref0 (self->priv->outbox_queue);
	_g_object_unref0 (self->priv->queue_cancellable);
	G_OBJECT_CLASS (geary_smtp_client_service_parent_class)->finalize (obj);
}

/**
 * Manages connecting to an SMTP network service.
 *
 * This class maintains a queue of email messages to be delivered, and
 * opens SMTP connections to deliver queued messages as needed.
 */
 G_GNUC_NO_INLINE static GType
geary_smtp_client_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpClientServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_client_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpClientService), 0, (GInstanceInitFunc) geary_smtp_client_service_instance_init, NULL };
	GType geary_smtp_client_service_type_id;
	geary_smtp_client_service_type_id = g_type_register_static (GEARY_TYPE_CLIENT_SERVICE, "GearySmtpClientService", &g_define_type_info, 0);
	GearySmtpClientService_private_offset = g_type_add_instance_private (geary_smtp_client_service_type_id, sizeof (GearySmtpClientServicePrivate));
	return geary_smtp_client_service_type_id;
}

GType
geary_smtp_client_service_get_type (void)
{
	static gsize geary_smtp_client_service_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_client_service_type_id__once)) {
		GType geary_smtp_client_service_type_id;
		geary_smtp_client_service_type_id = geary_smtp_client_service_get_type_once ();
		g_once_init_leave (&geary_smtp_client_service_type_id__once, geary_smtp_client_service_type_id);
	}
	return geary_smtp_client_service_type_id__once;
}

static void
_vala_geary_smtp_client_service_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GearySmtpClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SMTP_TYPE_CLIENT_SERVICE, GearySmtpClientService);
	switch (property_id) {
		case GEARY_SMTP_CLIENT_SERVICE_OUTBOX_PROPERTY:
		g_value_set_object (value, geary_smtp_client_service_get_outbox (self));
		break;
		case GEARY_SMTP_CLIENT_SERVICE_SENDING_MONITOR_PROPERTY:
		g_value_set_object (value, geary_smtp_client_service_get_sending_monitor (self));
		break;
		case GEARY_SMTP_CLIENT_SERVICE_LOGGING_DOMAIN_PROPERTY:
		g_value_set_string (value, geary_client_service_get_logging_domain (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_CLIENT_SERVICE, GearyClientService)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_smtp_client_service_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GearySmtpClientService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SMTP_TYPE_CLIENT_SERVICE, GearySmtpClientService);
	switch (property_id) {
		case GEARY_SMTP_CLIENT_SERVICE_OUTBOX_PROPERTY:
		geary_smtp_client_service_set_outbox (self, g_value_get_object (value));
		break;
		case GEARY_SMTP_CLIENT_SERVICE_SENDING_MONITOR_PROPERTY:
		geary_smtp_client_service_set_sending_monitor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

