/* smtp-oauth2-authenticator.c generated by valac 0.56.3, the Vala compiler
 * generated from smtp-oauth2-authenticator.vala, do not modify */

/*
 * Copyright 2018 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_SMTP_OAUTH2_AUTHENTICATOR_OAUTH2_RESP "user=%s\001auth=Bearer %s\001\001"

enum  {
	GEARY_SMTP_OAUTH2_AUTHENTICATOR_0_PROPERTY,
	GEARY_SMTP_OAUTH2_AUTHENTICATOR_NUM_PROPERTIES
};
static GParamSpec* geary_smtp_oauth2_authenticator_properties[GEARY_SMTP_OAUTH2_AUTHENTICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

static gpointer geary_smtp_oauth2_authenticator_parent_class = NULL;

static GearySmtpRequest* geary_smtp_oauth2_authenticator_real_initiate (GearySmtpAuthenticator* base);
static GearyMemoryBuffer* geary_smtp_oauth2_authenticator_real_challenge (GearySmtpAuthenticator* base,
                                                                   gint step,
                                                                   GearySmtpResponse* response,
                                                                   GError** error);
static GType geary_smtp_oauth2_authenticator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GearySmtpOAuth2Authenticator*
geary_smtp_oauth2_authenticator_construct (GType object_type,
                                           GearyCredentials* credentials)
{
	GearySmtpOAuth2Authenticator * self = NULL;
	g_return_val_if_fail (GEARY_IS_CREDENTIALS (credentials), NULL);
	self = (GearySmtpOAuth2Authenticator*) geary_smtp_authenticator_construct (object_type, "XOAUTH2", credentials);
	return self;
}

GearySmtpOAuth2Authenticator*
geary_smtp_oauth2_authenticator_new (GearyCredentials* credentials)
{
	return geary_smtp_oauth2_authenticator_construct (GEARY_SMTP_TYPE_OAUTH2_AUTHENTICATOR, credentials);
}

static GearySmtpRequest*
geary_smtp_oauth2_authenticator_real_initiate (GearySmtpAuthenticator* base)
{
	GearySmtpOAuth2Authenticator * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GearySmtpRequest* _tmp3_;
	GearySmtpRequest* _tmp4_;
	GearySmtpRequest* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_OAUTH2_AUTHENTICATOR, GearySmtpOAuth2Authenticator);
	_tmp0_ = g_strdup ("xoauth2");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = geary_smtp_request_new (GEARY_SMTP_COMMAND_AUTH, _tmp2_, 1);
	_tmp4_ = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp4_;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GearyMemoryBuffer*
geary_smtp_oauth2_authenticator_real_challenge (GearySmtpAuthenticator* base,
                                                gint step,
                                                GearySmtpResponse* response,
                                                GError** error)
{
	GearySmtpOAuth2Authenticator * self;
	GearyMemoryBuffer* buf = NULL;
	GearyMemoryBuffer* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_OAUTH2_AUTHENTICATOR, GearySmtpOAuth2Authenticator);
	g_return_val_if_fail (GEARY_SMTP_IS_RESPONSE (response), NULL);
	buf = NULL;
	switch (step) {
		case 0:
		{
			const gchar* _tmp0_ = NULL;
			GearyCredentials* _tmp1_;
			GearyCredentials* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_ = NULL;
			GearyCredentials* _tmp6_;
			GearyCredentials* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			guint8* _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_ = 0;
			guint8* _tmp14_;
			gint _tmp14__length1;
			gchar* _tmp15_;
			gchar* _tmp16_;
			GearyMemoryStringBuffer* _tmp17_;
			_tmp1_ = geary_smtp_authenticator_get_credentials (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SMTP_TYPE_AUTHENTICATOR, GearySmtpAuthenticator));
			_tmp2_ = _tmp1_;
			_tmp3_ = geary_credentials_get_user (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp0_ = _tmp4_;
			if (_tmp0_ == NULL) {
				_tmp0_ = "";
			}
			_tmp6_ = geary_smtp_authenticator_get_credentials (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SMTP_TYPE_AUTHENTICATOR, GearySmtpAuthenticator));
			_tmp7_ = _tmp6_;
			_tmp8_ = geary_credentials_get_token (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_;
			if (_tmp5_ == NULL) {
				_tmp5_ = "";
			}
			_tmp10_ = g_strdup_printf (GEARY_SMTP_OAUTH2_AUTHENTICATOR_OAUTH2_RESP, _tmp0_, _tmp5_);
			_tmp11_ = _tmp10_;
			_tmp12_ = string_get_data (_tmp11_, &_tmp13_);
			_tmp12__length1 = _tmp13_;
			_tmp14_ = _tmp12_;
			_tmp14__length1 = _tmp12__length1;
			_tmp15_ = g_base64_encode (_tmp14_, (gint) _tmp14__length1);
			_tmp16_ = _tmp15_;
			_tmp17_ = geary_memory_string_buffer_new (_tmp16_);
			_g_object_unref0 (buf);
			buf = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp11_);
			break;
		}
		case 1:
		{
			GearyMemoryStringBuffer* _tmp18_;
			_tmp18_ = geary_memory_string_buffer_new ("");
			_g_object_unref0 (buf);
			buf = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
			break;
		}
		default:
		break;
	}
	result = buf;
	return result;
}

static void
geary_smtp_oauth2_authenticator_class_init (GearySmtpOAuth2AuthenticatorClass * klass,
                                            gpointer klass_data)
{
	geary_smtp_oauth2_authenticator_parent_class = g_type_class_peek_parent (klass);
	((GearySmtpAuthenticatorClass *) klass)->initiate = (GearySmtpRequest* (*) (GearySmtpAuthenticator*)) geary_smtp_oauth2_authenticator_real_initiate;
	((GearySmtpAuthenticatorClass *) klass)->challenge = (GearyMemoryBuffer* (*) (GearySmtpAuthenticator*, gint, GearySmtpResponse*, GError**)) geary_smtp_oauth2_authenticator_real_challenge;
}

static void
geary_smtp_oauth2_authenticator_instance_init (GearySmtpOAuth2Authenticator * self,
                                               gpointer klass)
{
}

/**
 * Google's proprietary OAuth 2 authentication.
 *
 * See [[http://tools.ietf.org/html/rfc4616]]
 */
 G_GNUC_NO_INLINE static GType
geary_smtp_oauth2_authenticator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpOAuth2AuthenticatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_oauth2_authenticator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpOAuth2Authenticator), 0, (GInstanceInitFunc) geary_smtp_oauth2_authenticator_instance_init, NULL };
	GType geary_smtp_oauth2_authenticator_type_id;
	geary_smtp_oauth2_authenticator_type_id = g_type_register_static (GEARY_SMTP_TYPE_AUTHENTICATOR, "GearySmtpOAuth2Authenticator", &g_define_type_info, 0);
	return geary_smtp_oauth2_authenticator_type_id;
}

GType
geary_smtp_oauth2_authenticator_get_type (void)
{
	static gsize geary_smtp_oauth2_authenticator_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_oauth2_authenticator_type_id__once)) {
		GType geary_smtp_oauth2_authenticator_type_id;
		geary_smtp_oauth2_authenticator_type_id = geary_smtp_oauth2_authenticator_get_type_once ();
		g_once_init_leave (&geary_smtp_oauth2_authenticator_type_id__once, geary_smtp_oauth2_authenticator_type_id);
	}
	return geary_smtp_oauth2_authenticator_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

