/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.ConversionException;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.ErrorOutboundVariable;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.RealRawData;
import org.directwebremoting.io.RawData;
import org.directwebremoting.util.ClasspathScanner;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Loggers;

public class DefaultConverterManager
implements ConverterManager {
    protected Map<Property, Property> propertyOverrideMap = new HashMap<Property, Property>();
    protected Map<String, Class<? extends Converter>> converterTypes = new HashMap<String, Class<? extends Converter>>();
    protected Map<String, Converter> convertersByMatch = new HashMap<String, Converter>();
    protected Map<Class<?>, Converter> convertersByClass = new HashMap();
    protected final Map<String, NamedConverter> convertersByJavascript = new HashMap<String, NamedConverter>();
    protected final ConcurrentMap<Class<?>, Converter> converterCache = new ConcurrentHashMap();
    private static final List<String> ignore = Arrays.asList("converter", "match");
    private static final Log log = LogFactory.getLog(DefaultConverterManager.class);

    @Override
    public void addConverterType(String id, String className) {
        if (!LocalUtil.isJavaIdentifier(id)) {
            Loggers.STARTUP.error((Object)("Illegal identifier: '" + id + "'"));
            return;
        }
        Class<Converter> clazz = LocalUtil.classForName(id, className, Converter.class);
        if (clazz != null) {
            Loggers.STARTUP.debug((Object)("- adding converter type: " + id + " = " + clazz.getName()));
            this.converterTypes.put(id, clazz);
        }
    }

    @Override
    public void addConverter(String match, String type, Map<String, String> params) throws IllegalArgumentException, InstantiationException, IllegalAccessException {
        Class<? extends Converter> clazz = this.converterTypes.get(type);
        if (clazz == null) {
            log.debug((Object)("Probably not an issue: " + match + " is not available so the " + type + " converter will not load. This is only an problem if you wanted to use it."));
            return;
        }
        Converter converter = clazz.newInstance();
        LocalUtil.setParams(converter, params, ignore);
        this.addConverter(match, converter);
    }

    @Override
    public void addConverter(String match, Converter converter) throws IllegalArgumentException {
        if (LocalUtil.hasText(match) && match.contains("*") && !match.startsWith("[")) {
            boolean recursive = match.endsWith("**");
            String scan = recursive ? match.substring(0, match.length() - 1) : match;
            ClasspathScanner scanner = new ClasspathScanner(scan, recursive);
            for (String clazz : scanner.getClasses()) {
                this.addConverter(clazz, converter);
            }
        } else {
            Converter other = this.convertersByMatch.get(match);
            if (other != null) {
                Loggers.STARTUP.warn((Object)("Clash of converters for " + match + ". Using " + converter.getClass().getName() + " in place of " + other.getClass().getName()));
            }
            Loggers.STARTUP.debug((Object)("- adding converter: " + converter.getClass().getSimpleName() + " for " + match));
            converter.setConverterManager(this);
            if (converter instanceof NamedConverter) {
                try {
                    NamedConverter namedConverter = (NamedConverter)converter;
                    Class<?> javaClass = LocalUtil.classForName(match);
                    this.setUpClassMapping(namedConverter, javaClass);
                }
                catch (Exception cne) {
                    Loggers.STARTUP.warn((Object)("Could not load class [" + match + "]. Conversion will try to work upon other runtime information"));
                }
            }
            this.convertersByMatch.put(match, converter);
            this.converterCache.clear();
        }
    }

    @Override
    public void addConverter(Class<?> clazz, Converter converter) {
        Converter other = this.convertersByClass.get(clazz);
        if (other != null) {
            Loggers.STARTUP.warn((Object)("Clash of converters for " + clazz.getName() + ". Using " + converter.getClass().getName() + " in place of " + other.getClass().getName()));
        }
        Loggers.STARTUP.debug((Object)("- adding converter: " + converter.getClass().getSimpleName() + " for " + clazz.getName()));
        converter.setConverterManager(this);
        if (converter instanceof NamedConverter) {
            NamedConverter namedConverter = (NamedConverter)converter;
            this.setUpClassMapping(namedConverter, clazz);
        }
        this.convertersByClass.put(clazz, converter);
        this.converterCache.clear();
    }

    protected void setUpClassMapping(NamedConverter namedConverter, Class<?> clazz) {
        if (LocalUtil.hasLength(namedConverter.getJavascript())) {
            namedConverter.setJavascript(LocalUtil.inferWildcardReplacements(clazz.getName(), namedConverter.getJavascript()));
            namedConverter.setInstanceType(clazz);
            if (!LocalUtil.hasLength(namedConverter.getJavascriptSuperClass())) {
                for (Class<?> javaSuperClass = clazz.getSuperclass(); javaSuperClass != null; javaSuperClass = javaSuperClass.getSuperclass()) {
                    String jsSuperClassName = this.getMappedJavaScriptClassName(javaSuperClass);
                    if (jsSuperClassName == null) continue;
                    namedConverter.setJavascriptSuperClass(jsSuperClassName);
                    break;
                }
                if (!LocalUtil.hasLength(namedConverter.getJavascriptSuperClass())) {
                    for (Class<?> checkInterfacesOnClass = clazz; checkInterfacesOnClass != null; checkInterfacesOnClass = checkInterfacesOnClass.getSuperclass()) {
                        String jsSuperClassName = this.findMappedJavaScriptClassNameForAnyInterface(checkInterfacesOnClass);
                        if (jsSuperClassName == null) continue;
                        namedConverter.setJavascriptSuperClass(jsSuperClassName);
                        break;
                    }
                }
            }
            this.convertersByJavascript.put(namedConverter.getJavascript(), namedConverter);
            this.converterCache.clear();
        }
    }

    protected String getMappedJavaScriptClassName(Class<?> clazz) {
        NamedConverter namedConv;
        Converter conv = this.getConverter(clazz);
        if (conv != null && conv instanceof NamedConverter && LocalUtil.hasLength((namedConv = (NamedConverter)conv).getJavascript())) {
            return namedConv.getJavascript();
        }
        return null;
    }

    protected String findMappedJavaScriptClassNameForAnyInterface(Class<?> checkInterfacesOnClass) {
        Class<?>[] interfaces;
        for (Class<?> intfc : interfaces = checkInterfacesOnClass.getInterfaces()) {
            String jsClassName = this.getMappedJavaScriptClassName(intfc);
            if (jsClassName != null) {
                return jsClassName;
            }
            jsClassName = this.findMappedJavaScriptClassNameForAnyInterface(intfc);
            if (jsClassName == null) continue;
            return jsClassName;
        }
        return null;
    }

    @Override
    public Collection<String> getConverterMatchStrings() {
        return Collections.unmodifiableSet(this.convertersByMatch.keySet());
    }

    @Override
    public Converter getConverterByMatchString(String match) {
        return this.convertersByMatch.get(match);
    }

    @Override
    public Collection<String> getNamedConverterJavaScriptNames() {
        return this.convertersByJavascript.keySet();
    }

    @Override
    public NamedConverter getNamedConverter(String javascriptClassName) {
        return this.convertersByJavascript.get(javascriptClassName);
    }

    @Override
    public boolean isConvertable(Class<?> clazz) {
        return this.getConverter(clazz) != null;
    }

    @Override
    public Class<?> getClientDeclaredType(InboundVariable data) {
        if (data == null) {
            return null;
        }
        String objectName = data.getNamedObjectType();
        if (objectName != null) {
            NamedConverter converter = this.getNamedConverter(objectName, Object.class);
            if (converter != null) {
                return converter.getInstanceType();
            }
            return null;
        }
        return null;
    }

    @Override
    public <T> T convertInbound(Class<T> paramType, InboundVariable data, Property thc) throws ConversionException {
        InboundContext context = data.getContext();
        Object converted = context.getConverted(data, paramType);
        if (converted == null) {
            Converter converter = null;
            String type = data.getNamedObjectType();
            if (type != null) {
                converter = this.getNamedConverter(type, paramType);
            }
            if (converter == null) {
                converter = this.getConverter(paramType);
            }
            if (converter == null) {
                log.error((Object)("Missing converter. Context of conversion: " + thc));
                throw new ConversionException(paramType, "No inbound converter found for property '" + thc.getName() + "' of type '" + paramType.getName() + "'");
            }
            context.pushContext(thc);
            converted = converter.convertInbound(paramType, data);
            context.popContext();
        }
        return (T)converted;
    }

    @Override
    public <T> T convertInbound(Class<T> paramType, RawData rawData) throws ConversionException {
        RealRawData realRawData = (RealRawData)rawData;
        InboundVariable inboundVariable = realRawData.getInboundVariable();
        return this.convertInbound(paramType, inboundVariable, null);
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext converted) throws ConversionException {
        OutboundVariable ov;
        if (data == null) {
            return new NonNestedOutboundVariable("null");
        }
        if (!converted.isJsonMode() && (ov = converted.get(data)) != null) {
            return ov.getReferenceVariable();
        }
        Converter converter = this.getConverter(data);
        if (converter == null) {
            String message = "No outbound converter found for '" + data.getClass().getName() + "'";
            log.error((Object)message);
            return new ErrorOutboundVariable(message);
        }
        return converter.convertOutbound(data, converted);
    }

    @Override
    public void setOverrideProperty(Property original, Property replacement) {
        this.propertyOverrideMap.put(original, replacement);
    }

    @Override
    public Property checkOverride(Property property) {
        Property override = this.propertyOverrideMap.get(property);
        if (override != null) {
            return override;
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConverters(Map<String, Converter> converters) {
        Map<String, Converter> map = this.convertersByMatch;
        synchronized (map) {
            this.convertersByMatch.clear();
            this.convertersByMatch.putAll(converters);
            this.converterCache.clear();
        }
    }

    private Converter getConverter(Object object) {
        if (object == null) {
            return this.getConverter(Void.TYPE);
        }
        return this.getConverter(object.getClass());
    }

    protected NamedConverter getNamedConverter(String javascriptClassName, Class<?> paramType) throws ConversionException {
        NamedConverter namedConv = this.getNamedConverter(javascriptClassName);
        if (namedConv != null && paramType.isAssignableFrom(namedConv.getInstanceType())) {
            return namedConv;
        }
        return null;
    }

    private Converter getConverter(Class<?> clazz) {
        block7: {
            Converter converter = this.getConverterAssignableFrom(clazz);
            if (converter != null) {
                return converter;
            }
            String lookup = LocalUtil.originalDwrClassName(clazz.getName());
            if (lookup.startsWith("$Proxy") && (converter = this.convertersByMatch.get("$Proxy*")) != null) {
                this.converterCache.putIfAbsent(clazz, converter);
                return converter;
            }
            while (true) {
                if ((converter = this.convertersByMatch.get(lookup + ".*")) != null) {
                    this.converterCache.putIfAbsent(clazz, converter);
                    return converter;
                }
                converter = this.convertersByMatch.get(lookup + '*');
                if (converter != null) {
                    this.converterCache.putIfAbsent(clazz, converter);
                    return converter;
                }
                if (lookup.length() == 0) break block7;
                int lastdot = lookup.lastIndexOf(46);
                if (lastdot != -1) {
                    lookup = lookup.substring(0, lastdot);
                    continue;
                }
                int arrayMarkers = 0;
                while (lookup.charAt(arrayMarkers) == '[') {
                    ++arrayMarkers;
                }
                if (arrayMarkers == 0) break block7;
                converter = this.convertersByMatch.get(lookup = lookup.substring(arrayMarkers - 1, arrayMarkers + 1));
                if (converter != null) break;
            }
            this.converterCache.putIfAbsent(clazz, converter);
            return converter;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Converter getConverterAssignableFrom(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        Converter converter = (Converter)this.converterCache.get(clazz);
        if (converter != null) {
            return converter;
        }
        try {
            Converter converter2;
            converter = this.convertersByClass.get(clazz);
            if (converter != null) {
                Converter converter3 = converter;
                return converter3;
            }
            converter = this.convertersByMatch.get(LocalUtil.originalDwrClassName(clazz.getName()));
            if (converter != null) {
                Converter converter4 = converter;
                return converter4;
            }
            for (Class<?> anInterface : clazz.getInterfaces()) {
                converter = this.getConverterAssignableFrom(anInterface);
                if (converter == null) continue;
                Converter converter5 = converter;
                return converter5;
            }
            converter = this.getConverterAssignableFrom(clazz.getSuperclass());
            if (converter != null) {
                converter2 = converter;
                return converter2;
            }
            converter2 = null;
            return converter2;
        }
        finally {
            if (converter != null) {
                this.converterCache.putIfAbsent(clazz, converter);
            }
        }
    }
}

