/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.decommission.awareness.delete;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.decommission.awareness.delete.DeleteDecommissionStateRequest;
import org.opensearch.action.admin.cluster.decommission.awareness.delete.DeleteDecommissionStateResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.decommission.DecommissionService;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportDeleteDecommissionStateAction
extends TransportClusterManagerNodeAction<DeleteDecommissionStateRequest, DeleteDecommissionStateResponse> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteDecommissionStateAction.class);
    private final DecommissionService decommissionService;

    @Inject
    public TransportDeleteDecommissionStateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DecommissionService decommissionService) {
        super("cluster:admin/decommission/awareness/delete", transportService, clusterService, threadPool, actionFilters, DeleteDecommissionStateRequest::new, indexNameExpressionResolver);
        this.decommissionService = decommissionService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected DeleteDecommissionStateResponse read(StreamInput in) throws IOException {
        return new DeleteDecommissionStateResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteDecommissionStateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void clusterManagerOperation(DeleteDecommissionStateRequest request, ClusterState state, ActionListener<DeleteDecommissionStateResponse> listener) {
        logger.info("Received delete decommission Request [{}]", (Object)request);
        this.decommissionService.startRecommissionAction(listener);
    }
}

