/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.rollover.Condition;
import org.opensearch.action.admin.indices.rollover.MetadataRolloverService;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.rollover.RolloverResponse;
import org.opensearch.action.admin.indices.stats.IndicesStatsAction;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.ActiveShardsObserver;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.index.shard.DocsStats;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportRolloverAction
extends TransportClusterManagerNodeAction<RolloverRequest, RolloverResponse> {
    private final MetadataRolloverService rolloverService;
    private final ActiveShardsObserver activeShardsObserver;
    private final Client client;

    @Inject
    public TransportRolloverAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataRolloverService rolloverService, Client client) {
        super("indices:admin/rollover", transportService, clusterService, threadPool, actionFilters, RolloverRequest::new, indexNameExpressionResolver);
        this.rolloverService = rolloverService;
        this.client = client;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected RolloverResponse read(StreamInput in) throws IOException {
        return new RolloverResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(RolloverRequest request, ClusterState state) {
        IndicesOptions indicesOptions = IndicesOptions.fromOptions(true, true, request.indicesOptions().expandWildcardsOpen(), request.indicesOptions().expandWildcardsClosed());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, request));
    }

    @Override
    protected void clusterManagerOperation(RolloverRequest request, ClusterState state, ActionListener<RolloverResponse> listener) throws Exception {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    @Override
    protected void clusterManagerOperation(Task task, final RolloverRequest rolloverRequest, ClusterState state, final ActionListener<RolloverResponse> listener) throws Exception {
        MetadataRolloverService.RolloverResult preResult = this.rolloverService.rolloverClusterState(state, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), Collections.emptyList(), true, true);
        final Metadata metadata = state.metadata();
        final String sourceIndexName = preResult.sourceIndexName;
        final String rolloverIndexName = preResult.rolloverIndexName;
        IndicesStatsRequest statsRequest = ((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{rolloverRequest.getRolloverTarget()})).clear().indicesOptions(IndicesOptions.fromOptions(true, false, true, true))).docs(true);
        statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.execute(IndicesStatsAction.INSTANCE, statsRequest, new ActionListener<IndicesStatsResponse>(){

            @Override
            public void onResponse(IndicesStatsResponse statsResponse) {
                final Map<String, Boolean> conditionResults = TransportRolloverAction.evaluateConditions(rolloverRequest.getConditions().values(), metadata.index(sourceIndexName), statsResponse);
                if (rolloverRequest.isDryRun()) {
                    listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, true, false, false, false));
                    return;
                }
                final List metConditions = rolloverRequest.getConditions().values().stream().filter(condition -> (Boolean)conditionResults.get(condition.toString())).collect(Collectors.toList());
                if (conditionResults.size() == 0 || metConditions.size() > 0) {
                    TransportRolloverAction.this.clusterService.submitStateUpdateTask("rollover_index source [" + sourceIndexName + "] to target [" + rolloverIndexName + "]", new ClusterStateUpdateTask(){

                        @Override
                        public ClusterState execute(ClusterState currentState) throws Exception {
                            MetadataRolloverService.RolloverResult rolloverResult = TransportRolloverAction.this.rolloverService.rolloverClusterState(currentState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), metConditions, false, false);
                            if (!rolloverResult.sourceIndexName.equals(sourceIndexName)) {
                                throw new OpenSearchException("Concurrent modification of alias [{}] during rollover", rolloverRequest.getRolloverTarget());
                            }
                            return rolloverResult.clusterState;
                        }

                        @Override
                        public void onFailure(String source, Exception e) {
                            listener.onFailure(e);
                        }

                        @Override
                        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                            if (!newState.equals(oldState)) {
                                TransportRolloverAction.this.activeShardsObserver.waitForActiveShards(new String[]{rolloverIndexName}, rolloverRequest.getCreateIndexRequest().waitForActiveShards(), rolloverRequest.clusterManagerNodeTimeout(), isShardsAcknowledged -> listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, false, true, true, (boolean)isShardsAcknowledged)), listener::onFailure);
                            }
                        }
                    });
                } else {
                    listener.onResponse(new RolloverResponse(sourceIndexName, rolloverIndexName, conditionResults, false, false, false, false));
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    static Map<String, Boolean> evaluateConditions(Collection<Condition<?>> conditions, @Nullable DocsStats docsStats, @Nullable IndexMetadata metadata) {
        if (metadata == null) {
            return conditions.stream().collect(Collectors.toMap(Condition::toString, cond -> false));
        }
        long numDocs = docsStats == null ? 0L : docsStats.getCount();
        long indexSize = docsStats == null ? 0L : docsStats.getTotalSizeInBytes();
        Condition.Stats stats = new Condition.Stats(numDocs, metadata.getCreationDate(), new ByteSizeValue(indexSize));
        return conditions.stream().map(condition -> condition.evaluate(stats)).collect(Collectors.toMap(result -> result.condition.toString(), result -> result.matched));
    }

    static Map<String, Boolean> evaluateConditions(Collection<Condition<?>> conditions, @Nullable IndexMetadata metadata, @Nullable IndicesStatsResponse statsResponse) {
        if (metadata == null) {
            return conditions.stream().collect(Collectors.toMap(Condition::toString, cond -> false));
        }
        DocsStats docsStats = Optional.ofNullable(statsResponse).map(stats -> stats.getIndex(metadata.getIndex().getName())).map(indexStats -> indexStats.getPrimaries().getDocs()).orElse(null);
        return TransportRolloverAction.evaluateConditions(conditions, docsStats, metadata);
    }
}

