/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.geo;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.util.SloppyMath;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.geo.GeoDistance;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.unit.DistanceUnit;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentSubParser;
import org.opensearch.common.xcontent.support.MapXContentParser;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.geometry.ShapeType;
import org.opensearch.index.fielddata.FieldData;
import org.opensearch.index.fielddata.GeoPointValues;
import org.opensearch.index.fielddata.MultiGeoPointValues;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.index.fielddata.SortedNumericDoubleValues;
import org.opensearch.index.fielddata.SortingNumericDoubleValues;

public class GeoUtils {
    private static final String ERR_MSG_INVALID_TOKEN = "token [{}] not allowed";
    private static final String ERR_MSG_INVALID_FIELDS = "field must be either [lon|lat], [type|coordinates], or [geohash]";
    public static final double MAX_LAT = 90.0;
    public static final double MIN_LAT = -90.0;
    public static final double MAX_LON = 180.0;
    public static final double MIN_LON = -180.0;
    public static final String LATITUDE = "lat";
    public static final String LONGITUDE = "lon";
    public static final String GEOHASH = "geohash";
    public static final String GEOJSON_TYPE = "type";
    public static final String GEOJSON_COORDS = "coordinates";
    public static final double EARTH_SEMI_MAJOR_AXIS = 6378137.0;
    public static final double EARTH_SEMI_MINOR_AXIS = 6356752.314245;
    public static final double EARTH_MEAN_RADIUS = 6371008.7714;
    public static final double EARTH_AXIS_RATIO = 0.9966471893352243;
    public static final double EARTH_EQUATOR = 4.007501668557849E7;
    public static final double EARTH_POLAR_DISTANCE = 1.9970326371122006E7;
    public static final double TOLERANCE = 1.0E-6;

    public static boolean isValidLatitude(double latitude) {
        return !Double.isNaN(latitude) && !Double.isInfinite(latitude) && !(latitude < -90.0) && !(latitude > 90.0);
    }

    public static boolean isValidLongitude(double longitude) {
        return !Double.isNaN(longitude) && !Double.isInfinite(longitude) && !(longitude < -180.0) && !(longitude > 180.0);
    }

    public static double geoHashCellWidth(int level) {
        assert (level >= 0);
        return 4.007501668557849E7 / (double)(1L << (level + 1) / 2 * 3 + level / 2 * 2);
    }

    public static double quadTreeCellWidth(int level) {
        assert (level >= 0);
        return 4.007501668557849E7 / (double)(1L << level);
    }

    public static double geoHashCellHeight(int level) {
        assert (level >= 0);
        return 1.9970326371122006E7 / (double)(1L << (level + 1) / 2 * 2 + level / 2 * 3);
    }

    public static double quadTreeCellHeight(int level) {
        assert (level >= 0);
        return 1.9970326371122006E7 / (double)(1L << level);
    }

    public static double geoHashCellSize(int level) {
        assert (level >= 0);
        double w = GeoUtils.geoHashCellWidth(level);
        double h = GeoUtils.geoHashCellHeight(level);
        return Math.sqrt(w * w + h * h);
    }

    public static double quadTreeCellSize(int level) {
        assert (level >= 0);
        return Math.sqrt(2.0048208977185252E15) / (double)(1L << level);
    }

    public static int quadTreeLevelsForPrecision(double meters) {
        int level;
        assert (meters >= 0.0);
        if (meters == 0.0) {
            return 50;
        }
        double ratio = 1.4983235946676121;
        double width = Math.sqrt(meters * meters / 2.244973594337675);
        long part = Math.round(Math.ceil(4.007501668557849E7 / width));
        return part <= 1L << (level = 64 - Long.numberOfLeadingZeros(part) - 1) ? level : level + 1;
    }

    public static int quadTreeLevelsForPrecision(String distance) {
        return GeoUtils.quadTreeLevelsForPrecision(DistanceUnit.METERS.parse(distance, DistanceUnit.DEFAULT));
    }

    public static int geoHashLevelsForPrecision(double meters) {
        int full;
        assert (meters >= 0.0);
        if (meters == 0.0) {
            return GeohashPrefixTree.getMaxLevelsPossible();
        }
        double ratio = 1.4983235946676121;
        double width = Math.sqrt(meters * meters / 2.244973594337675);
        double part = Math.ceil(4.007501668557849E7 / width);
        if (part == 1.0) {
            return 1;
        }
        int bits = (int)Math.round(Math.ceil(Math.log(part) / Math.log(2.0)));
        int left = bits - (full = bits / 5) * 5;
        int even = full + (left > 0 ? 1 : 0);
        int odd = full + (left > 3 ? 1 : 0);
        return even + odd;
    }

    public static int geoHashLevelsForPrecision(String distance) {
        return GeoUtils.geoHashLevelsForPrecision(DistanceUnit.METERS.parse(distance, DistanceUnit.DEFAULT));
    }

    public static double normalizeLon(double lon) {
        if (lon > 180.0 || lon <= -180.0) {
            lon = GeoUtils.centeredModulus(lon, 360.0);
        }
        return lon + 0.0;
    }

    public static double normalizeLat(double lat) {
        if (lat > 90.0 || lat < -90.0) {
            if ((lat = GeoUtils.centeredModulus(lat, 360.0)) < -90.0) {
                lat = -180.0 - lat;
            } else if (lat > 90.0) {
                lat = 180.0 - lat;
            }
        }
        return lat + 0.0;
    }

    public static void normalizePoint(GeoPoint point) {
        GeoUtils.normalizePoint(point, true, true);
    }

    public static void normalizePoint(GeoPoint point, boolean normLat, boolean normLon) {
        double[] pt = new double[]{point.lon(), point.lat()};
        GeoUtils.normalizePoint(pt, normLon, normLat);
        point.reset(pt[1], pt[0]);
    }

    public static void normalizePoint(double[] lonLat) {
        GeoUtils.normalizePoint(lonLat, true, true);
    }

    public static void normalizePoint(double[] lonLat, boolean normLon, boolean normLat) {
        assert (lonLat != null && lonLat.length == 2);
        normLat = normLat && (lonLat[1] > 90.0 || lonLat[1] < -90.0);
        boolean bl = normLon = normLon && (lonLat[0] > 180.0 || lonLat[0] < -180.0 || normLat);
        if (normLat) {
            lonLat[1] = GeoUtils.centeredModulus(lonLat[1], 360.0);
            boolean shift = true;
            if (lonLat[1] < -90.0) {
                lonLat[1] = -180.0 - lonLat[1];
            } else if (lonLat[1] > 90.0) {
                lonLat[1] = 180.0 - lonLat[1];
            } else {
                shift = false;
            }
            if (shift) {
                lonLat[0] = normLon ? lonLat[0] + 180.0 : lonLat[0] + (GeoUtils.normalizeLon(lonLat[0]) > 0.0 ? -180.0 : 180.0);
            }
        }
        if (normLon) {
            lonLat[0] = GeoUtils.centeredModulus(lonLat[0], 360.0);
        }
    }

    public static double centeredModulus(double dividend, double divisor) {
        double rtn = dividend % divisor;
        if (rtn <= 0.0) {
            rtn += divisor;
        }
        if (rtn > divisor / 2.0) {
            rtn -= divisor;
        }
        return rtn;
    }

    public static GeoPoint parseGeoPoint(XContentParser parser) throws IOException, OpenSearchParseException {
        return GeoUtils.parseGeoPoint(parser, new GeoPoint());
    }

    public static GeoPoint parseGeoPoint(XContentParser parser, GeoPoint point) throws IOException, OpenSearchParseException {
        return GeoUtils.parseGeoPoint(parser, point, false);
    }

    public static GeoPoint parseGeoPoint(Object value, boolean ignoreZValue) throws OpenSearchParseException {
        return GeoUtils.parseGeoPoint(value, new GeoPoint(), ignoreZValue);
    }

    public static GeoPoint parseGeoPoint(Object value, GeoPoint point, boolean ignoreZValue) throws OpenSearchParseException {
        GeoPoint geoPoint;
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Collections.singletonMap("null_value", value), null);
        try {
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            geoPoint = GeoUtils.parseGeoPoint((XContentParser)parser, point, ignoreZValue);
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new OpenSearchParseException("error parsing geopoint", (Throwable)ex, new Object[0]);
            }
        }
        parser.close();
        return geoPoint;
    }

    public static GeoPoint parseGeoPoint(XContentParser parser, GeoPoint point, boolean ignoreZValue) throws IOException, OpenSearchParseException {
        return GeoUtils.parseGeoPoint(parser, point, ignoreZValue, EffectivePoint.BOTTOM_LEFT);
    }

    public static GeoPoint parseGeoPoint(XContentParser parser, GeoPoint point, boolean ignoreZValue, EffectivePoint effectivePoint) throws IOException, OpenSearchParseException {
        switch (parser.currentToken()) {
            case START_OBJECT: {
                GeoUtils.parseGeoPointObject(parser, point, ignoreZValue, effectivePoint);
                break;
            }
            case START_ARRAY: {
                GeoUtils.parseGeoPointArray(parser, point, ignoreZValue);
                break;
            }
            case VALUE_STRING: {
                String val = parser.text();
                point.resetFromString(val, ignoreZValue, effectivePoint);
                break;
            }
            default: {
                throw new OpenSearchParseException("geo_point expected", new Object[0]);
            }
        }
        return point;
    }

    private static GeoPoint parseGeoPointObject(XContentParser parser, GeoPoint point, boolean ignoreZValue, EffectivePoint effectivePoint) throws IOException {
        try (XContentSubParser subParser = new XContentSubParser(parser);){
            if (subParser.nextToken() != XContentParser.Token.FIELD_NAME) {
                throw new OpenSearchParseException(ERR_MSG_INVALID_TOKEN, subParser.currentToken());
            }
            String field = subParser.currentName();
            if (LONGITUDE.equals(field) || LATITUDE.equals(field)) {
                GeoUtils.parseGeoPointObjectBasicFields((XContentParser)subParser, point);
            } else if (GEOHASH.equals(field)) {
                GeoUtils.parseGeoHashFields((XContentParser)subParser, point, effectivePoint);
            } else if (GEOJSON_TYPE.equals(field) || GEOJSON_COORDS.equals(field)) {
                GeoUtils.parseGeoJsonFields((XContentParser)subParser, point, ignoreZValue);
            } else {
                throw new OpenSearchParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
            }
            if (subParser.nextToken() != XContentParser.Token.END_OBJECT) {
                throw new OpenSearchParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
            }
            GeoPoint geoPoint = point;
            return geoPoint;
        }
    }

    private static GeoPoint parseGeoPointObjectBasicFields(XContentParser parser, GeoPoint point) throws IOException {
        HashMap<String, Double> data = new HashMap<String, Double>();
        block5: for (int i = 0; i < 2; ++i) {
            if (i != 0) {
                parser.nextToken();
            }
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) break;
            String field = parser.currentName();
            if (!LONGITUDE.equals(field) && !LATITUDE.equals(field)) {
                throw new OpenSearchParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
            }
            switch (parser.nextToken()) {
                case VALUE_STRING: 
                case VALUE_NUMBER: {
                    try {
                        data.put(field, parser.doubleValue(true));
                        continue block5;
                    }
                    catch (NumberFormatException e) {
                        throw new OpenSearchParseException("[{}] and [{}] must be valid double values", (Throwable)e, LONGITUDE, LATITUDE);
                    }
                }
                default: {
                    throw new OpenSearchParseException("{} must be a number", field);
                }
            }
        }
        if (data.get(LONGITUDE) == null) {
            throw new OpenSearchParseException("field [{}] missing", LONGITUDE);
        }
        if (data.get(LATITUDE) == null) {
            throw new OpenSearchParseException("field [{}] missing", LATITUDE);
        }
        return point.reset((Double)data.get(LATITUDE), (Double)data.get(LONGITUDE));
    }

    private static GeoPoint parseGeoHashFields(XContentParser parser, GeoPoint point, EffectivePoint effectivePoint) throws IOException {
        if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
            throw new OpenSearchParseException(ERR_MSG_INVALID_TOKEN, parser.currentToken());
        }
        if (!GEOHASH.equals(parser.currentName())) {
            throw new OpenSearchParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
        }
        if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
            throw new OpenSearchParseException("{} must be a string", GEOHASH);
        }
        return point.parseGeoHash(parser.text(), effectivePoint);
    }

    private static GeoPoint parseGeoJsonFields(XContentParser parser, GeoPoint point, boolean ignoreZValue) throws IOException {
        boolean hasTypePoint = false;
        boolean hasCoordinates = false;
        for (int i = 0; i < 2; ++i) {
            if (i != 0) {
                parser.nextToken();
            }
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                if (!hasTypePoint) {
                    throw new OpenSearchParseException("field [{}] missing", GEOJSON_TYPE);
                }
                if (!hasCoordinates) {
                    throw new OpenSearchParseException("field [{}] missing", GEOJSON_COORDS);
                }
            }
            if (GEOJSON_TYPE.equals(parser.currentName())) {
                if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                    throw new OpenSearchParseException("{} must be a string", GEOJSON_TYPE);
                }
                if (!ShapeType.POINT.name().equalsIgnoreCase(parser.text())) {
                    throw new OpenSearchParseException("{} must be Point", GEOJSON_TYPE);
                }
                hasTypePoint = true;
                continue;
            }
            if (GEOJSON_COORDS.equals(parser.currentName())) {
                if (parser.nextToken() != XContentParser.Token.START_ARRAY) {
                    throw new OpenSearchParseException("{} must be an array", GEOJSON_COORDS);
                }
                GeoUtils.parseGeoPointArray(parser, point, ignoreZValue);
                hasCoordinates = true;
                continue;
            }
            throw new OpenSearchParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
        }
        return point;
    }

    private static GeoPoint parseGeoPointArray(XContentParser parser, GeoPoint point, boolean ignoreZValue) throws IOException {
        try (XContentSubParser subParser = new XContentSubParser(parser);){
            double x = Double.NaN;
            double y = Double.NaN;
            int element = 0;
            while (subParser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
                    throw new OpenSearchParseException("numeric value expected", new Object[0]);
                }
                if (++element == 1) {
                    x = parser.doubleValue();
                    continue;
                }
                if (element == 2) {
                    y = parser.doubleValue();
                    continue;
                }
                if (element == 3) {
                    GeoPoint.assertZValue(ignoreZValue, parser.doubleValue());
                    continue;
                }
                throw new OpenSearchParseException("[geo_point] field type does not accept more than 3 values", new Object[0]);
            }
            if (element < 2) {
                throw new OpenSearchParseException("[geo_point] field type should have at least two dimensions", new Object[0]);
            }
            GeoPoint geoPoint = point.reset(y, x);
            return geoPoint;
        }
    }

    public static GeoPoint parseFromString(String val) {
        GeoPoint point = new GeoPoint();
        return point.resetFromString(val, false, EffectivePoint.BOTTOM_LEFT);
    }

    public static int parsePrecision(XContentParser parser) throws IOException, OpenSearchParseException {
        XContentParser.Token token = parser.currentToken();
        if (token.equals((Object)XContentParser.Token.VALUE_NUMBER)) {
            return XContentMapValues.nodeIntegerValue(parser.intValue());
        }
        String precision = parser.text();
        try {
            return XContentMapValues.nodeIntegerValue(precision);
        }
        catch (NumberFormatException e) {
            int parsedPrecision = GeoUtils.geoHashLevelsForPrecision(precision);
            try {
                return GeoUtils.checkPrecisionRange(parsedPrecision);
            }
            catch (IllegalArgumentException e2) {
                throw new IllegalArgumentException("precision too high [" + precision + "]", e2);
            }
        }
    }

    public static int checkPrecisionRange(int precision) {
        if (precision < 1 || precision > 12) {
            throw new IllegalArgumentException("Invalid geohash aggregation precision of " + precision + ". Must be between 1 and 12.");
        }
        return precision;
    }

    public static double maxRadialDistanceMeters(double centerLat, double centerLon) {
        if (Math.abs(centerLat) == 90.0) {
            return SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)0.0, (double)centerLon);
        }
        return SloppyMath.haversinMeters((double)centerLat, (double)centerLon, (double)centerLat, (double)((180.0 + centerLon) % 360.0));
    }

    public static double arcDistance(double lat1, double lon1, double lat2, double lon2) {
        return SloppyMath.haversinMeters((double)lat1, (double)lon1, (double)lat2, (double)lon2);
    }

    public static double planeDistance(double lat1, double lon1, double lat2, double lon2) {
        double x = Math.toRadians(lon2 - lon1) * Math.cos(Math.toRadians((lat2 + lat1) / 2.0));
        double y = Math.toRadians(lat2 - lat1);
        return Math.sqrt(x * x + y * y) * 6371008.7714;
    }

    public static SortedNumericDoubleValues distanceValues(final GeoDistance distance, final DistanceUnit unit, final MultiGeoPointValues geoPointValues, final GeoPoint ... fromPoints) {
        final GeoPointValues singleValues = FieldData.unwrapSingleton(geoPointValues);
        if (singleValues != null && fromPoints.length == 1) {
            return FieldData.singleton(new NumericDoubleValues(){

                public boolean advanceExact(int doc) throws IOException {
                    return singleValues.advanceExact(doc);
                }

                public double doubleValue() throws IOException {
                    GeoPoint from = fromPoints[0];
                    GeoPoint to = singleValues.geoPointValue();
                    return distance.calculate(from.lat(), from.lon(), to.lat(), to.lon(), unit);
                }
            });
        }
        return new SortingNumericDoubleValues(){

            @Override
            public boolean advanceExact(int target) throws IOException {
                if (geoPointValues.advanceExact(target)) {
                    this.resize(geoPointValues.docValueCount() * fromPoints.length);
                    int v = 0;
                    for (int i = 0; i < geoPointValues.docValueCount(); ++i) {
                        GeoPoint point = geoPointValues.nextValue();
                        for (GeoPoint from : fromPoints) {
                            this.values[v] = distance.calculate(from.lat(), from.lon(), point.lat(), point.lon(), unit);
                            ++v;
                        }
                    }
                    this.sort();
                    return true;
                }
                return false;
            }
        };
    }

    private GeoUtils() {
    }

    public static enum EffectivePoint {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

