/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.settings;

import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.monitor.jvm.JvmStats;

public class SearchShardTaskSettings {
    private static final long HEAP_SIZE_BYTES = JvmStats.jvmStats().getMem().getHeapMax().getBytes();
    private volatile double totalHeapPercentThreshold;
    public static final Setting<Double> SETTING_TOTAL_HEAP_PERCENT_THRESHOLD = Setting.doubleSetting("search_backpressure.search_shard_task.total_heap_percent_threshold", 0.05, 0.0, 1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);

    public SearchShardTaskSettings(Settings settings, ClusterSettings clusterSettings) {
        this.totalHeapPercentThreshold = SETTING_TOTAL_HEAP_PERCENT_THRESHOLD.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SETTING_TOTAL_HEAP_PERCENT_THRESHOLD, this::setTotalHeapPercentThreshold);
    }

    public double getTotalHeapPercentThreshold() {
        return this.totalHeapPercentThreshold;
    }

    public long getTotalHeapBytesThreshold() {
        return (long)((double)HEAP_SIZE_BYTES * this.getTotalHeapPercentThreshold());
    }

    private void setTotalHeapPercentThreshold(double totalHeapPercentThreshold) {
        this.totalHeapPercentThreshold = totalHeapPercentThreshold;
    }

    private static class Defaults {
        private static final double TOTAL_HEAP_PERCENT_THRESHOLD = 0.05;

        private Defaults() {
        }
    }
}

