/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.settings;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.ad.settings.AbstractSetting;
import org.opensearch.common.settings.Setting;

public class EnabledSetting
extends AbstractSetting {
    private static EnabledSetting INSTANCE;
    public static final String AD_PLUGIN_ENABLED = "plugins.anomaly_detection.enabled";
    public static final String AD_BREAKER_ENABLED = "plugins.anomaly_detection.breaker.enabled";
    public static final String LEGACY_OPENDISTRO_AD_PLUGIN_ENABLED = "opendistro.anomaly_detection.enabled";
    public static final String LEGACY_OPENDISTRO_AD_BREAKER_ENABLED = "opendistro.anomaly_detection.breaker.enabled";
    public static final String INTERPOLATION_IN_HCAD_COLD_START_ENABLED = "plugins.anomaly_detection.hcad_cold_start_interpolation.enabled";
    public static final Map<String, Setting<?>> settings;

    private EnabledSetting(Map<String, Setting<?>> settings) {
        super(settings);
    }

    public static synchronized EnabledSetting getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EnabledSetting(settings);
        }
        return INSTANCE;
    }

    public static boolean isADPluginEnabled() {
        return (Boolean)EnabledSetting.getInstance().getSettingValue(AD_PLUGIN_ENABLED);
    }

    public static boolean isADBreakerEnabled() {
        return (Boolean)EnabledSetting.getInstance().getSettingValue(AD_BREAKER_ENABLED);
    }

    public static boolean isInterpolationInColdStartEnabled() {
        return (Boolean)EnabledSetting.getInstance().getSettingValue(INTERPOLATION_IN_HCAD_COLD_START_ENABLED);
    }

    static {
        settings = Collections.unmodifiableMap(new HashMap<String, Setting<?>>(){
            {
                Setting LegacyADPluginEnabledSetting = Setting.boolSetting((String)EnabledSetting.LEGACY_OPENDISTRO_AD_PLUGIN_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated});
                this.put(EnabledSetting.LEGACY_OPENDISTRO_AD_PLUGIN_ENABLED, LegacyADPluginEnabledSetting);
                Setting LegacyADBreakerEnabledSetting = Setting.boolSetting((String)EnabledSetting.LEGACY_OPENDISTRO_AD_BREAKER_ENABLED, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated});
                this.put(EnabledSetting.LEGACY_OPENDISTRO_AD_BREAKER_ENABLED, LegacyADBreakerEnabledSetting);
                this.put(EnabledSetting.AD_PLUGIN_ENABLED, Setting.boolSetting((String)EnabledSetting.AD_PLUGIN_ENABLED, (Setting)LegacyADPluginEnabledSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(EnabledSetting.AD_BREAKER_ENABLED, Setting.boolSetting((String)EnabledSetting.AD_BREAKER_ENABLED, (Setting)LegacyADBreakerEnabledSetting, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
                this.put(EnabledSetting.INTERPOLATION_IN_HCAD_COLD_START_ENABLED, Setting.boolSetting((String)EnabledSetting.INTERPOLATION_IN_HCAD_COLD_START_ENABLED, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic}));
            }
        });
    }
}

