/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.context;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;

public class AsynchronousSearchContextId
implements Writeable {
    private long id;
    private String contextId;

    public AsynchronousSearchContextId(String contextId, long id) {
        this.id = id;
        this.contextId = contextId;
    }

    public AsynchronousSearchContextId(StreamInput in) throws IOException {
        this.id = in.readLong();
        this.contextId = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.id);
        out.writeString(this.contextId);
    }

    public String getContextId() {
        return this.contextId;
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsynchronousSearchContextId other = (AsynchronousSearchContextId)o;
        return this.id == other.id && this.contextId.equals(other.contextId);
    }

    public int hashCode() {
        return Objects.hash(this.contextId, this.id);
    }

    public String toString() {
        return "[" + this.contextId + "][" + this.id + "]";
    }
}

