"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternManagementPlugin = void 0;

var _ismPlugin = _interopRequireDefault(require("./clusters/ism/ismPlugin"));

var _services = require("./services");

var _routes = require("../server/routes");

var _dataStreams = _interopRequireDefault(require("./routes/dataStreams"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class IndexPatternManagementPlugin {
  async setup(core) {
    // create OpenSearch client that aware of ISM API endpoints
    const osDriver = core.opensearch.legacy.createClient("index_management", {
      plugins: [_ismPlugin.default]
    }); // Initialize services

    const indexService = new _services.IndexService(osDriver);
    const dataStreamService = new _services.DataStreamService(osDriver);
    const policyService = new _services.PolicyService(osDriver);
    const managedIndexService = new _services.ManagedIndexService(osDriver);
    const rollupService = new _services.RollupService(osDriver);
    const transformService = new _services.TransformService(osDriver);
    const notificationService = new _services.NotificationService(osDriver);
    const snapshotManagementService = new _services.SnapshotManagementService(osDriver);
    const services = {
      indexService,
      dataStreamService,
      policyService,
      managedIndexService,
      rollupService,
      transformService,
      notificationService,
      snapshotManagementService
    }; // create router

    const router = core.http.createRouter(); // Add server routes

    (0, _routes.indices)(services, router);
    (0, _dataStreams.default)(services, router);
    (0, _routes.policies)(services, router);
    (0, _routes.managedIndices)(services, router);
    (0, _routes.rollups)(services, router);
    (0, _routes.transforms)(services, router);
    (0, _routes.notifications)(services, router);
    (0, _routes.snapshotManagement)(services, router);
    return {};
  }

  async start(core) {
    return {};
  }

}

exports.IndexPatternManagementPlugin = IndexPatternManagementPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBsdWdpbi50cyJdLCJuYW1lcyI6WyJJbmRleFBhdHRlcm5NYW5hZ2VtZW50UGx1Z2luIiwic2V0dXAiLCJjb3JlIiwib3NEcml2ZXIiLCJvcGVuc2VhcmNoIiwibGVnYWN5IiwiY3JlYXRlQ2xpZW50IiwicGx1Z2lucyIsImlzbVBsdWdpbiIsImluZGV4U2VydmljZSIsIkluZGV4U2VydmljZSIsImRhdGFTdHJlYW1TZXJ2aWNlIiwiRGF0YVN0cmVhbVNlcnZpY2UiLCJwb2xpY3lTZXJ2aWNlIiwiUG9saWN5U2VydmljZSIsIm1hbmFnZWRJbmRleFNlcnZpY2UiLCJNYW5hZ2VkSW5kZXhTZXJ2aWNlIiwicm9sbHVwU2VydmljZSIsIlJvbGx1cFNlcnZpY2UiLCJ0cmFuc2Zvcm1TZXJ2aWNlIiwiVHJhbnNmb3JtU2VydmljZSIsIm5vdGlmaWNhdGlvblNlcnZpY2UiLCJOb3RpZmljYXRpb25TZXJ2aWNlIiwic25hcHNob3RNYW5hZ2VtZW50U2VydmljZSIsIlNuYXBzaG90TWFuYWdlbWVudFNlcnZpY2UiLCJzZXJ2aWNlcyIsInJvdXRlciIsImh0dHAiLCJjcmVhdGVSb3V0ZXIiLCJzdGFydCJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQU9BOztBQUNBOztBQVVBOztBQUNBOzs7O0FBbkJBO0FBQ0E7QUFDQTtBQUNBO0FBa0JPLE1BQU1BLDRCQUFOLENBQTZHO0FBQ2hHLFFBQUxDLEtBQUssQ0FBQ0MsSUFBRCxFQUFrQjtBQUNsQztBQUNBLFVBQU1DLFFBQW9DLEdBQUdELElBQUksQ0FBQ0UsVUFBTCxDQUFnQkMsTUFBaEIsQ0FBdUJDLFlBQXZCLENBQW9DLGtCQUFwQyxFQUF3RDtBQUNuR0MsTUFBQUEsT0FBTyxFQUFFLENBQUNDLGtCQUFEO0FBRDBGLEtBQXhELENBQTdDLENBRmtDLENBTWxDOztBQUNBLFVBQU1DLFlBQVksR0FBRyxJQUFJQyxzQkFBSixDQUFpQlAsUUFBakIsQ0FBckI7QUFDQSxVQUFNUSxpQkFBaUIsR0FBRyxJQUFJQywyQkFBSixDQUFzQlQsUUFBdEIsQ0FBMUI7QUFDQSxVQUFNVSxhQUFhLEdBQUcsSUFBSUMsdUJBQUosQ0FBa0JYLFFBQWxCLENBQXRCO0FBQ0EsVUFBTVksbUJBQW1CLEdBQUcsSUFBSUMsNkJBQUosQ0FBd0JiLFFBQXhCLENBQTVCO0FBQ0EsVUFBTWMsYUFBYSxHQUFHLElBQUlDLHVCQUFKLENBQWtCZixRQUFsQixDQUF0QjtBQUNBLFVBQU1nQixnQkFBZ0IsR0FBRyxJQUFJQywwQkFBSixDQUFxQmpCLFFBQXJCLENBQXpCO0FBQ0EsVUFBTWtCLG1CQUFtQixHQUFHLElBQUlDLDZCQUFKLENBQXdCbkIsUUFBeEIsQ0FBNUI7QUFDQSxVQUFNb0IseUJBQXlCLEdBQUcsSUFBSUMsbUNBQUosQ0FBOEJyQixRQUE5QixDQUFsQztBQUNBLFVBQU1zQixRQUFRLEdBQUc7QUFDZmhCLE1BQUFBLFlBRGU7QUFFZkUsTUFBQUEsaUJBRmU7QUFHZkUsTUFBQUEsYUFIZTtBQUlmRSxNQUFBQSxtQkFKZTtBQUtmRSxNQUFBQSxhQUxlO0FBTWZFLE1BQUFBLGdCQU5lO0FBT2ZFLE1BQUFBLG1CQVBlO0FBUWZFLE1BQUFBO0FBUmUsS0FBakIsQ0Fma0MsQ0EwQmxDOztBQUNBLFVBQU1HLE1BQU0sR0FBR3hCLElBQUksQ0FBQ3lCLElBQUwsQ0FBVUMsWUFBVixFQUFmLENBM0JrQyxDQTRCbEM7O0FBQ0EseUJBQVFILFFBQVIsRUFBa0JDLE1BQWxCO0FBQ0EsOEJBQVlELFFBQVosRUFBc0JDLE1BQXRCO0FBQ0EsMEJBQVNELFFBQVQsRUFBbUJDLE1BQW5CO0FBQ0EsZ0NBQWVELFFBQWYsRUFBeUJDLE1BQXpCO0FBQ0EseUJBQVFELFFBQVIsRUFBa0JDLE1BQWxCO0FBQ0EsNEJBQVdELFFBQVgsRUFBcUJDLE1BQXJCO0FBQ0EsK0JBQWNELFFBQWQsRUFBd0JDLE1BQXhCO0FBQ0Esb0NBQW1CRCxRQUFuQixFQUE2QkMsTUFBN0I7QUFFQSxXQUFPLEVBQVA7QUFDRDs7QUFFaUIsUUFBTEcsS0FBSyxDQUFDM0IsSUFBRCxFQUFrQjtBQUNsQyxXQUFPLEVBQVA7QUFDRDs7QUE1Q2lIIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBJbmRleE1hbmFnZW1lbnRQbHVnaW5TZXR1cCwgSW5kZXhNYW5hZ2VtZW50UGx1Z2luU3RhcnQgfSBmcm9tIFwiLlwiO1xuaW1wb3J0IHsgUGx1Z2luLCBDb3JlU2V0dXAsIENvcmVTdGFydCwgSUxlZ2FjeUN1c3RvbUNsdXN0ZXJDbGllbnQgfSBmcm9tIFwiLi4vLi4vLi4vc3JjL2NvcmUvc2VydmVyXCI7XG5pbXBvcnQgaXNtUGx1Z2luIGZyb20gXCIuL2NsdXN0ZXJzL2lzbS9pc21QbHVnaW5cIjtcbmltcG9ydCB7XG4gIFBvbGljeVNlcnZpY2UsXG4gIE1hbmFnZWRJbmRleFNlcnZpY2UsXG4gIEluZGV4U2VydmljZSxcbiAgUm9sbHVwU2VydmljZSxcbiAgVHJhbnNmb3JtU2VydmljZSxcbiAgRGF0YVN0cmVhbVNlcnZpY2UsXG4gIE5vdGlmaWNhdGlvblNlcnZpY2UsXG4gIFNuYXBzaG90TWFuYWdlbWVudFNlcnZpY2UsXG59IGZyb20gXCIuL3NlcnZpY2VzXCI7XG5pbXBvcnQgeyBpbmRpY2VzLCBwb2xpY2llcywgbWFuYWdlZEluZGljZXMsIHJvbGx1cHMsIHRyYW5zZm9ybXMsIG5vdGlmaWNhdGlvbnMsIHNuYXBzaG90TWFuYWdlbWVudCB9IGZyb20gXCIuLi9zZXJ2ZXIvcm91dGVzXCI7XG5pbXBvcnQgZGF0YVN0cmVhbXMgZnJvbSBcIi4vcm91dGVzL2RhdGFTdHJlYW1zXCI7XG5cbmV4cG9ydCBjbGFzcyBJbmRleFBhdHRlcm5NYW5hZ2VtZW50UGx1Z2luIGltcGxlbWVudHMgUGx1Z2luPEluZGV4TWFuYWdlbWVudFBsdWdpblNldHVwLCBJbmRleE1hbmFnZW1lbnRQbHVnaW5TdGFydD4ge1xuICBwdWJsaWMgYXN5bmMgc2V0dXAoY29yZTogQ29yZVNldHVwKSB7XG4gICAgLy8gY3JlYXRlIE9wZW5TZWFyY2ggY2xpZW50IHRoYXQgYXdhcmUgb2YgSVNNIEFQSSBlbmRwb2ludHNcbiAgICBjb25zdCBvc0RyaXZlcjogSUxlZ2FjeUN1c3RvbUNsdXN0ZXJDbGllbnQgPSBjb3JlLm9wZW5zZWFyY2gubGVnYWN5LmNyZWF0ZUNsaWVudChcImluZGV4X21hbmFnZW1lbnRcIiwge1xuICAgICAgcGx1Z2luczogW2lzbVBsdWdpbl0sXG4gICAgfSk7XG5cbiAgICAvLyBJbml0aWFsaXplIHNlcnZpY2VzXG4gICAgY29uc3QgaW5kZXhTZXJ2aWNlID0gbmV3IEluZGV4U2VydmljZShvc0RyaXZlcik7XG4gICAgY29uc3QgZGF0YVN0cmVhbVNlcnZpY2UgPSBuZXcgRGF0YVN0cmVhbVNlcnZpY2Uob3NEcml2ZXIpO1xuICAgIGNvbnN0IHBvbGljeVNlcnZpY2UgPSBuZXcgUG9saWN5U2VydmljZShvc0RyaXZlcik7XG4gICAgY29uc3QgbWFuYWdlZEluZGV4U2VydmljZSA9IG5ldyBNYW5hZ2VkSW5kZXhTZXJ2aWNlKG9zRHJpdmVyKTtcbiAgICBjb25zdCByb2xsdXBTZXJ2aWNlID0gbmV3IFJvbGx1cFNlcnZpY2Uob3NEcml2ZXIpO1xuICAgIGNvbnN0IHRyYW5zZm9ybVNlcnZpY2UgPSBuZXcgVHJhbnNmb3JtU2VydmljZShvc0RyaXZlcik7XG4gICAgY29uc3Qgbm90aWZpY2F0aW9uU2VydmljZSA9IG5ldyBOb3RpZmljYXRpb25TZXJ2aWNlKG9zRHJpdmVyKTtcbiAgICBjb25zdCBzbmFwc2hvdE1hbmFnZW1lbnRTZXJ2aWNlID0gbmV3IFNuYXBzaG90TWFuYWdlbWVudFNlcnZpY2Uob3NEcml2ZXIpO1xuICAgIGNvbnN0IHNlcnZpY2VzID0ge1xuICAgICAgaW5kZXhTZXJ2aWNlLFxuICAgICAgZGF0YVN0cmVhbVNlcnZpY2UsXG4gICAgICBwb2xpY3lTZXJ2aWNlLFxuICAgICAgbWFuYWdlZEluZGV4U2VydmljZSxcbiAgICAgIHJvbGx1cFNlcnZpY2UsXG4gICAgICB0cmFuc2Zvcm1TZXJ2aWNlLFxuICAgICAgbm90aWZpY2F0aW9uU2VydmljZSxcbiAgICAgIHNuYXBzaG90TWFuYWdlbWVudFNlcnZpY2UsXG4gICAgfTtcblxuICAgIC8vIGNyZWF0ZSByb3V0ZXJcbiAgICBjb25zdCByb3V0ZXIgPSBjb3JlLmh0dHAuY3JlYXRlUm91dGVyKCk7XG4gICAgLy8gQWRkIHNlcnZlciByb3V0ZXNcbiAgICBpbmRpY2VzKHNlcnZpY2VzLCByb3V0ZXIpO1xuICAgIGRhdGFTdHJlYW1zKHNlcnZpY2VzLCByb3V0ZXIpO1xuICAgIHBvbGljaWVzKHNlcnZpY2VzLCByb3V0ZXIpO1xuICAgIG1hbmFnZWRJbmRpY2VzKHNlcnZpY2VzLCByb3V0ZXIpO1xuICAgIHJvbGx1cHMoc2VydmljZXMsIHJvdXRlcik7XG4gICAgdHJhbnNmb3JtcyhzZXJ2aWNlcywgcm91dGVyKTtcbiAgICBub3RpZmljYXRpb25zKHNlcnZpY2VzLCByb3V0ZXIpO1xuICAgIHNuYXBzaG90TWFuYWdlbWVudChzZXJ2aWNlcywgcm91dGVyKTtcblxuICAgIHJldHVybiB7fTtcbiAgfVxuXG4gIHB1YmxpYyBhc3luYyBzdGFydChjb3JlOiBDb3JlU3RhcnQpIHtcbiAgICByZXR1cm4ge307XG4gIH1cbn1cbiJdfQ==