"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _configSchema = require("@osd/config-schema");

var _constants = require("../../utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(services, router) {
  const {
    indexService
  } = services;
  router.post({
    path: _constants.NODE_API._SEARCH,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.search);
  router.get({
    path: _constants.NODE_API._INDICES,
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.string(),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        terms: _configSchema.schema.maybe(_configSchema.schema.any()),
        indices: _configSchema.schema.maybe(_configSchema.schema.any()),
        dataStreams: _configSchema.schema.maybe(_configSchema.schema.any()),
        showDataStreams: _configSchema.schema.boolean()
      })
    }
  }, indexService.getIndices);
  router.post({
    path: _constants.NODE_API.APPLY_POLICY,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.applyPolicy);
  router.post({
    path: _constants.NODE_API.EDIT_ROLLOVER_ALIAS,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.editRolloverAlias);
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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