/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.index.query.xypoint;

import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.opensearch.geometry.Circle;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.GeometryCollection;
import org.opensearch.geometry.GeometryVisitor;
import org.opensearch.geometry.Line;
import org.opensearch.geometry.LinearRing;
import org.opensearch.geometry.MultiLine;
import org.opensearch.geometry.MultiPoint;
import org.opensearch.geometry.MultiPolygon;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.Polygon;
import org.opensearch.geometry.Rectangle;
import org.opensearch.geometry.ShapeType;
import org.opensearch.geospatial.index.common.xyshape.XYShapeConverter;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;

public class XYPointQueryVisitor
implements GeometryVisitor<Query, RuntimeException> {
    private final String fieldName;
    private final MappedFieldType fieldType;
    private final QueryShardContext context;

    public Query visit(Line line) {
        return this.geometryNotSupported(ShapeType.LINESTRING);
    }

    public Query visit(LinearRing ring) {
        return this.geometryNotSupported(ShapeType.LINEARRING);
    }

    public Query visit(MultiLine multiLine) {
        return this.geometryNotSupported(ShapeType.MULTILINESTRING);
    }

    public Query visit(MultiPoint multiPoint) {
        return this.geometryNotSupported(ShapeType.MULTIPOINT);
    }

    public Query visit(Point point) {
        return this.geometryNotSupported(ShapeType.POINT);
    }

    public Query visit(Circle circle) throws RuntimeException {
        Objects.requireNonNull(circle, "Circle cannot be null");
        XYCircle xyCircle = XYShapeConverter.toXYCircle(circle);
        Query query = XYPointField.newDistanceQuery((String)this.fieldName, (float)xyCircle.getX(), (float)xyCircle.getY(), (float)xyCircle.getRadius());
        if (!this.fieldType.hasDocValues()) {
            return query;
        }
        Query dvQuery = XYDocValuesField.newSlowDistanceQuery((String)this.fieldName, (float)xyCircle.getX(), (float)xyCircle.getY(), (float)xyCircle.getRadius());
        return new IndexOrDocValuesQuery(query, dvQuery);
    }

    public Query visit(Rectangle rectangle) {
        Objects.requireNonNull(rectangle, "Rectangle cannot be null");
        XYRectangle xyRectangle = XYShapeConverter.toXYRectangle(rectangle);
        Query query = XYPointField.newBoxQuery((String)this.fieldName, (float)xyRectangle.minX, (float)xyRectangle.maxX, (float)xyRectangle.minY, (float)xyRectangle.maxY);
        if (!this.fieldType.hasDocValues()) {
            return query;
        }
        Query dvQuery = XYDocValuesField.newSlowBoxQuery((String)this.fieldName, (float)xyRectangle.minX, (float)xyRectangle.maxX, (float)xyRectangle.minY, (float)xyRectangle.maxY);
        return new IndexOrDocValuesQuery(query, dvQuery);
    }

    public Query visit(MultiPolygon multiPolygon) {
        Objects.requireNonNull(multiPolygon, "Multi Polygon cannot be null");
        return this.visitCollection((GeometryCollection<Polygon>)multiPolygon);
    }

    public Query visit(Polygon polygon) {
        Objects.requireNonNull(polygon, "Polygon cannot be null");
        return this.visitCollection((GeometryCollection<Polygon>)new GeometryCollection(Collections.singletonList(polygon)));
    }

    public Query visit(GeometryCollection<?> collection) {
        if (collection.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        this.visit(booleanQueryBuilder, collection);
        return booleanQueryBuilder.build();
    }

    private void visit(BooleanQuery.Builder booleanQueryBuilder, GeometryCollection<?> collection) {
        BooleanClause.Occur occur = BooleanClause.Occur.FILTER;
        for (Geometry shape : collection) {
            booleanQueryBuilder.add((Query)shape.visit((GeometryVisitor)this), occur);
        }
    }

    private Query visitCollection(GeometryCollection<Polygon> collection) {
        if (collection.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        XYPolygon[] xyPolygons = new XYPolygon[collection.size()];
        for (int i = 0; i < collection.size(); ++i) {
            xyPolygons[i] = XYShapeConverter.toXYPolygon((Polygon)collection.get(i));
        }
        Query query = XYPointField.newPolygonQuery((String)this.fieldName, (XYPolygon[])xyPolygons);
        if (!this.fieldType.hasDocValues()) {
            return query;
        }
        Query dvQuery = XYDocValuesField.newSlowPolygonQuery((String)this.fieldName, (XYPolygon[])xyPolygons);
        return new IndexOrDocValuesQuery(query, dvQuery);
    }

    private Query geometryNotSupported(ShapeType shapeType) {
        throw new QueryShardException(this.context, String.format(Locale.getDefault(), "Field [%s] found an unsupported shape [%s]", this.fieldName, shapeType.name()), new Object[0]);
    }

    public XYPointQueryVisitor(String fieldName, MappedFieldType fieldType, QueryShardContext context) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.context = context;
    }
}

