/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.plugin;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.geospatial.action.upload.geojson.UploadGeoJSONAction;
import org.opensearch.geospatial.action.upload.geojson.UploadGeoJSONTransportAction;
import org.opensearch.geospatial.index.mapper.xypoint.XYPointFieldTypeParser;
import org.opensearch.geospatial.index.mapper.xyshape.XYShapeFieldTypeParser;
import org.opensearch.geospatial.index.query.xyshape.XYShapeQueryBuilder;
import org.opensearch.geospatial.processor.FeatureProcessor;
import org.opensearch.geospatial.rest.action.upload.geojson.RestUploadGeoJSONAction;
import org.opensearch.geospatial.search.aggregations.bucket.geogrid.GeoHexGrid;
import org.opensearch.geospatial.search.aggregations.bucket.geogrid.GeoHexGridAggregationBuilder;
import org.opensearch.geospatial.stats.upload.RestUploadStatsAction;
import org.opensearch.geospatial.stats.upload.UploadStats;
import org.opensearch.geospatial.stats.upload.UploadStatsAction;
import org.opensearch.geospatial.stats.upload.UploadStatsTransportAction;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.ingest.Processor;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.IngestPlugin;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.watcher.ResourceWatcherService;

public class GeospatialPlugin
extends Plugin
implements IngestPlugin,
ActionPlugin,
MapperPlugin,
SearchPlugin {
    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        return MapBuilder.newMapBuilder().put((Object)"geojson-feature", (Object)new FeatureProcessor.Factory()).immutableMap();
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        return List.of(UploadStats.getInstance());
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestUploadGeoJSONAction uploadGeoJSONAction = new RestUploadGeoJSONAction();
        RestUploadStatsAction statsAction = new RestUploadStatsAction();
        return List.of(statsAction, uploadGeoJSONAction);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)UploadGeoJSONAction.INSTANCE, UploadGeoJSONTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UploadStatsAction.INSTANCE, UploadStatsTransportAction.class, new Class[0]));
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Map.of("xy_shape", new XYShapeFieldTypeParser(), "xy_point", new XYPointFieldTypeParser());
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return List.of(new SearchPlugin.QuerySpec("xy_shape", XYShapeQueryBuilder::new, XYShapeQueryBuilder::fromXContent));
    }

    public List<SearchPlugin.AggregationSpec> getAggregations() {
        SearchPlugin.AggregationSpec geoHexGridSpec = new SearchPlugin.AggregationSpec("geohex_grid", GeoHexGridAggregationBuilder::new, GeoHexGridAggregationBuilder.PARSER).addResultReader(GeoHexGrid::new).setAggregatorRegistrar(GeoHexGridAggregationBuilder::registerAggregators);
        return List.of(geoHexGridSpec);
    }
}

