/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.getpolicy;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.commons.authuser.User;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPolicyRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPolicyResponse;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.rest.RestStatus;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001&B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006'"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/TransportGetPolicyAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/GetPolicyRequest;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/GetPolicyResponse;", "client", "Lorg/opensearch/client/node/NodeClient;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/node/NodeClient;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/action/ActionListener;", "GetPolicyHandler", "opensearch-index-management"})
public final class TransportGetPolicyAction
extends HandledTransportAction<GetPolicyRequest, GetPolicyResponse> {
    @NotNull
    private final NodeClient client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportGetPolicyAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/ism/policy/get", transportService, actionFilters, GetPolicyRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportGetPolicyAction._init_$lambda-0(this, arg_0));
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    protected void doExecute(@NotNull Task task, @NotNull GetPolicyRequest request, @NotNull ActionListener<GetPolicyResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new GetPolicyHandler(this.client, listener, request, null, 8, null).start();
    }

    private static final void _init_$lambda-0(TransportGetPolicyAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/TransportGetPolicyAction$GetPolicyHandler;", "", "client", "Lorg/opensearch/client/node/NodeClient;", "actionListener", "Lorg/opensearch/action/ActionListener;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/GetPolicyResponse;", "request", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/GetPolicyRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/TransportGetPolicyAction;Lorg/opensearch/client/node/NodeClient;Lorg/opensearch/action/ActionListener;Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/GetPolicyRequest;Lorg/opensearch/commons/authuser/User;)V", "onGetResponse", "", "response", "Lorg/opensearch/action/get/GetResponse;", "start", "opensearch-index-management"})
    public final class GetPolicyHandler {
        @NotNull
        private final NodeClient client;
        @NotNull
        private final ActionListener<GetPolicyResponse> actionListener;
        @NotNull
        private final GetPolicyRequest request;
        @Nullable
        private final User user;

        public GetPolicyHandler(@NotNull NodeClient client, @NotNull ActionListener<GetPolicyResponse> actionListener, @Nullable GetPolicyRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)((Object)TransportGetPolicyAction.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public /* synthetic */ GetPolicyHandler(NodeClient nodeClient, ActionListener actionListener, GetPolicyRequest getPolicyRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = nodeClient.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"class GetPolicyHandler(\n\u2026        }\n        }\n    }");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            this(nodeClient, (ActionListener<GetPolicyResponse>)actionListener, getPolicyRequest, user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            TransportGetPolicyAction.this.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getPolicyID()).version(this.request.getVersion());
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this){
                    final /* synthetic */ GetPolicyHandler this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onResponse(@NotNull GetResponse response2) {
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        this.this$0.onGetResponse(response2);
                    }

                    public void onFailure(@NotNull Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                        if (throwable == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                        }
                        GetPolicyHandler.access$getActionListener$p(this.this$0).onFailure((Exception)throwable);
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        public final void onGetResponse(@NotNull GetResponse response2) {
            GetPolicyResponse getPolicyResponse;
            String string;
            Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
            if (!response2.isExists()) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Policy not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            Policy policy2 = null;
            try {
                policy2 = (Policy)OpenSearchExtensionsKt.parseFromGetResponse(response2, TransportGetPolicyAction.this.getXContentRegistry(), (Function4)new Function4<XContentParser, String, Long, Long, Policy>((Object)Policy.Companion){

                    @NotNull
                    public final Policy invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((Policy.Companion)this.receiver).parse(p0, p1, p2, p3);
                    }
                });
            }
            catch (IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("Policy not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            User user = policy2.getUser();
            Boolean e = TransportGetPolicyAction.this.filterByEnabled;
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"filterByEnabled");
            if (!SecurityUtils.Companion.userHasPermissionForResource(this.user, user, e, "policy", this.request.getPolicyID(), this.actionListener)) {
                return;
            }
            if (!this.request.getFetchSrcContext().fetchSource()) {
                string = response2.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                GetPolicyResponse getPolicyResponse2 = new GetPolicyResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), null);
                getPolicyResponse = getPolicyResponse2;
            } else {
                string = response2.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                GetPolicyResponse getPolicyResponse3 = new GetPolicyResponse(string, response2.getVersion(), response2.getSeqNo(), response2.getPrimaryTerm(), policy2);
                getPolicyResponse = getPolicyResponse3;
            }
            GetPolicyResponse policyResponse = getPolicyResponse;
            this.actionListener.onResponse((Object)policyResponse);
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(GetPolicyHandler $this) {
            return $this.actionListener;
        }
    }
}

