/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.transform.TransformIndexer;
import org.opensearch.indexmanagement.transform.exceptions.TransformIndexException;
import org.opensearch.indexmanagement.transform.settings.TransformSettings;
import org.opensearch.rest.RestStatus;
import org.opensearch.transport.RemoteTransportException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J#\u0010\u0010\u001a\u00020\u00132\u0010\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/indexmanagement/transform/TransformIndexer;", "", "settings", "Lorg/opensearch/common/settings/Settings;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "client", "Lorg/opensearch/client/Client;", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/client/Client;)V", "backoffPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "kotlin.jvm.PlatformType", "logger", "Lorg/apache/logging/log4j/Logger;", "createTargetIndex", "", "index", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "docsToIndex", "", "Lorg/opensearch/action/DocWriteRequest;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "opensearch-index-management"})
public final class TransformIndexer {
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Client client;
    private final Logger logger;
    private volatile BackoffPolicy backoffPolicy;

    public TransformIndexer(@NotNull Settings settings, @NotNull ClusterService clusterService, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.clusterService = clusterService;
        this.client = client;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue timeValue = (TimeValue)TransformSettings.Companion.getTRANSFORM_JOB_INDEX_BACKOFF_MILLIS().get(settings);
        Object object = TransformSettings.Companion.getTRANSFORM_JOB_INDEX_BACKOFF_COUNT().get(settings);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"TransformSettings.TRANSF\u2026CKOFF_COUNT.get(settings)");
        this.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)timeValue, (int)((Number)object).intValue());
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(TransformSettings.Companion.getTRANSFORM_JOB_INDEX_BACKOFF_MILLIS(), TransformSettings.Companion.getTRANSFORM_JOB_INDEX_BACKOFF_COUNT(), (arg_0, arg_1) -> TransformIndexer._init_$lambda-0(this, arg_0, arg_1));
    }

    /*
     * Unable to fully structure code
     */
    private final Object createTargetIndex(String var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof createTargetIndex.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ TransformIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TransformIndexer.access$createTargetIndex(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.clusterService.state().getRoutingTable().hasIndex(index)) ** GOTO lbl29
                request = new CreateIndexRequest(index).mapping(IndexManagementIndices.Companion.getTransformTargetMappings());
                $continuation.L$0 = this;
                $continuation.L$1 = index;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client.admin().indices(), (Function2)new Function2<IndicesAdminClient, ActionListener<CreateIndexResponse>, Unit>(request){
                    final /* synthetic */ CreateIndexRequest $request;
                    {
                        this.$request = $request;
                        super(2);
                    }

                    public final void invoke(IndicesAdminClient $this$suspendUntil, @NotNull ActionListener<CreateIndexResponse> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.create(this.$request, it);
                    }
                }, $continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl26
            }
            case 1: {
                index = (String)$continuation.L$1;
                this = (TransformIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                if (!(response = (CreateIndexResponse)v0).isAcknowledged()) {
                    this.logger.error("Failed to create the target index " + index);
                    throw new TransformIndexException("Failed to create the target index", null, 2, null);
                }
lbl29:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object index(@NotNull List<? extends DocWriteRequest<?>> var1_1, @NotNull Continuation<? super Long> var2_2) {
        if (!(var2_2 instanceof index.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ TransformIndexer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.index(null, (Continuation<? super Long>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                updatableDocsToIndex = new Ref.ObjectRef();
                updatableDocsToIndex.element = docsToIndex;
                indexTimeInMillis = new Ref.LongRef();
                nonRetryableFailures = new ArrayList<E>();
                if (!(((Collection)updatableDocsToIndex.element).isEmpty() == false)) ** GOTO lbl62
                targetIndex /* !! */  = ((DocWriteRequest)CollectionsKt.first((List)((List)updatableDocsToIndex.element))).index();
                this.logger.debug("Attempting to index " + ((List)updatableDocsToIndex.element).size() + " documents to " + targetIndex /* !! */ );
                Intrinsics.checkNotNullExpressionValue((Object)targetIndex /* !! */ , (String)"targetIndex");
                $continuation.L$0 = this;
                $continuation.L$1 = updatableDocsToIndex;
                $continuation.L$2 = indexTimeInMillis;
                $continuation.L$3 = nonRetryableFailures;
                $continuation.label = 1;
                v0 = this.createTargetIndex(targetIndex /* !! */ , (Continuation<? super Unit>)$continuation);
                ** if (v0 != var10_5) goto lbl30
lbl29:
                // 1 sources

                return var10_5;
lbl30:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                nonRetryableFailures = (List)$continuation.L$3;
                indexTimeInMillis = (Ref.LongRef)$continuation.L$2;
                updatableDocsToIndex = (Ref.ObjectRef)$continuation.L$1;
                this = (TransformIndexer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl40:
                // 2 sources

                var7_14 = this.backoffPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)var7_14, (String)"backoffPolicy");
                v1 = var7_14;
                var7_14 = this.logger;
                Intrinsics.checkNotNullExpressionValue((Object)var7_14, (String)"logger");
                $continuation.L$0 = this;
                $continuation.L$1 = indexTimeInMillis;
                $continuation.L$2 = nonRetryableFailures;
                $continuation.L$3 = null;
                $continuation.label = 2;
                v2 = OpenSearchExtensionsKt.retry(v1, (Logger)var7_14, CollectionsKt.listOf((Object)RestStatus.TOO_MANY_REQUESTS), (Function2)new Function2<TimeValue, Continuation<? super Unit>, Object>(updatableDocsToIndex, this, indexTimeInMillis, (List<BulkItemResponse>)nonRetryableFailures, null){
                    int label;
                    final /* synthetic */ Ref.ObjectRef<List<DocWriteRequest<?>>> $updatableDocsToIndex;
                    final /* synthetic */ TransformIndexer this$0;
                    final /* synthetic */ Ref.LongRef $indexTimeInMillis;
                    final /* synthetic */ List<BulkItemResponse> $nonRetryableFailures;
                    {
                        this.$updatableDocsToIndex = $updatableDocsToIndex;
                        this.this$0 = $receiver;
                        this.$indexTimeInMillis = $indexTimeInMillis;
                        this.$nonRetryableFailures = $nonRetryableFailures;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                bulkRequest = new BulkRequest().add((Iterable)this.$updatableDocsToIndex.element);
                                this.label = 1;
                                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)TransformIndexer.access$getClient$p(this.this$0), (Function2)new Function2<Client, ActionListener<BulkResponse>, Unit>(bulkRequest){
                                    final /* synthetic */ BulkRequest $bulkRequest;
                                    {
                                        this.$bulkRequest = $bulkRequest;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<BulkResponse> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.bulk(this.$bulkRequest, it);
                                    }
                                }, (Continuation)this);
                                if (v0 == var18_2) {
                                    return var18_2;
                                }
                                ** GOTO lbl14
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl14:
                                // 2 sources

                                bulkResponse = (BulkResponse)v0;
                                this.$indexTimeInMillis.element += bulkResponse.getTook().getMillis();
                                retryableFailures = new ArrayList<E>();
                                v1 = bulkResponse.getItems();
                                if (v1 == null) {
                                    v1 = new BulkItemResponse[]{};
                                }
                                $this$filter$iv = v1;
                                $i$f$filter = false;
                                var7_9 = $this$filter$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterTo = false;
                                for (BulkItemResponse element$iv$iv : $this$filterTo$iv$iv) {
                                    it = element$iv$iv;
                                    $i$a$-filter-TransformIndexer$index$2$1 = false;
                                    if (!it.isFailed()) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                $this$forEach$iv = (List)destination$iv$iv;
                                var6_8 = this.$nonRetryableFailures;
                                $i$f$forEach = false;
                                for (E element$iv : $this$forEach$iv) {
                                    failedResponse = (BulkItemResponse)element$iv;
                                    $i$a$-forEach-TransformIndexer$index$2$2 = false;
                                    if (failedResponse.status() == RestStatus.TOO_MANY_REQUESTS) {
                                        Intrinsics.checkNotNullExpressionValue((Object)failedResponse, (String)"failedResponse");
                                        retryableFailures.add(failedResponse);
                                        continue;
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)failedResponse, (String)"failedResponse");
                                    var6_8.add(failedResponse);
                                }
                                $this$forEach$iv = retryableFailures;
                                var6_8 = this.$updatableDocsToIndex;
                                var16_25 = this.$updatableDocsToIndex;
                                $i$f$map = false;
                                destination$iv$iv = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    element$iv$iv = (BulkItemResponse)item$iv$iv;
                                    var17_26 = destination$iv$iv;
                                    $i$a$-map-TransformIndexer$index$2$3 = false;
                                    var17_26.add((IndexRequest)((List)var6_8.element).get(failure.getItemId()));
                                }
                                var16_25.element = (List)destination$iv$iv;
                                if (((Collection)this.$updatableDocsToIndex.element).isEmpty() == false) {
                                    var5_6 = ExceptionsHelper.convertToOpenSearchException((Exception)((BulkItemResponse)CollectionsKt.first((List)retryableFailures)).getFailure().getCause());
                                    Intrinsics.checkNotNullExpressionValue((Object)var5_6, (String)"convertToOpenSearchExcep\u2026es.first().failure.cause)");
                                    throw (Throwable)var5_6;
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull TimeValue p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v2 != var10_5) goto lbl53
lbl52:
                // 1 sources

                return var10_5;
lbl53:
                // 1 sources

                ** GOTO lbl62
            }
            case 2: {
                nonRetryableFailures = (List)$continuation.L$2;
                indexTimeInMillis = (Ref.LongRef)$continuation.L$1;
                this = (TransformIndexer)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl62:
                    // 3 sources

                    if (((Collection)nonRetryableFailures).isEmpty() == false) {
                        this.logger.error("Failed to index " + nonRetryableFailures.size() + " documents");
                        targetIndex /* !! */  = ExceptionsHelper.convertToOpenSearchException((Exception)((BulkItemResponse)CollectionsKt.first((List)nonRetryableFailures)).getFailure().getCause());
                        Intrinsics.checkNotNullExpressionValue((Object)targetIndex /* !! */ , (String)"convertToOpenSearchExcep\u2026es.first().failure.cause)");
                        throw (Throwable)targetIndex /* !! */ ;
                    }
                    return Boxing.boxLong((long)indexTimeInMillis.element);
                }
                catch (TransformIndexException e) {
                    throw e;
                }
                catch (RemoteTransportException e) {
                    v3 = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (v3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    unwrappedException = (Exception)v3;
                    throw new TransformIndexException("Failed to index the documents", unwrappedException);
                }
                catch (OpenSearchSecurityException e) {
                    throw new TransformIndexException("Failed to index the documents - missing required index permissions: " + e.getLocalizedMessage(), e);
                }
                catch (Exception e) {
                    throw new TransformIndexException("Failed to index the documents", e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void _init_$lambda-0(TransformIndexer this$0, TimeValue millis, Integer count) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)count, (String)"count");
        this$0.backoffPolicy = BackoffPolicy.constantBackoff((TimeValue)millis, (int)count);
    }

    public static final /* synthetic */ Object access$createTargetIndex(TransformIndexer $this, String index2, Continuation $completion) {
        return $this.createTargetIndex(index2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Client access$getClient$p(TransformIndexer $this) {
        return $this.client;
    }
}

