/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.ExistsQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.indexmanagement.util.IndexManagementException;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/opensearch/indexmanagement/util/SecurityUtils;", "", "()V", "Companion", "opensearch-index-management"})
public final class SecurityUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String INTERNAL_REQUEST = "index_management_plugin_internal_user";
    @NotNull
    public static final String ADMIN_ROLE = "all_access";
    @NotNull
    private static final List<String> DEFAULT_INJECT_ROLES;

    static {
        Object[] objectArray = new String[]{ADMIN_ROLE, "AmazonES_all_access"};
        DEFAULT_INJECT_ROLES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0017\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rJ$\u0010\u0018\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011JH\u0010\u0018\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001eJ\u0018\u0010\u001f\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u001f\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u001a2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001eJ4\u0010 \u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/opensearch/indexmanagement/util/SecurityUtils$Companion;", "", "()V", "ADMIN_ROLE", "", "DEFAULT_INJECT_ROLES", "", "getDEFAULT_INJECT_ROLES", "()Ljava/util/List;", "INTERNAL_REQUEST", "addUserFilter", "", "user", "Lorg/opensearch/commons/authuser/User;", "queryBuilder", "Lorg/opensearch/index/query/BoolQueryBuilder;", "filterEnabled", "", "filterPathPrefix", "buildUser", "threadContext", "Lorg/opensearch/common/util/concurrent/ThreadContext;", "requestedUser", "generateUserString", "userHasPermissionForResource", "resourceUser", "T", "resourceName", "resourceId", "actionListener", "Lorg/opensearch/action/ActionListener;", "validateUserConfiguration", "verifyUserHasPermissionForResource", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDEFAULT_INJECT_ROLES() {
            return DEFAULT_INJECT_ROLES;
        }

        @Nullable
        public final User buildUser(@NotNull ThreadContext threadContext, @Nullable User requestedUser) {
            User injectedUser;
            Intrinsics.checkNotNullParameter((Object)threadContext, (String)"threadContext");
            if (threadContext.getTransient(SecurityUtils.INTERNAL_REQUEST) != null) {
                Object object = threadContext.getTransient(SecurityUtils.INTERNAL_REQUEST);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"threadContext.getTransie\u2026oolean>(INTERNAL_REQUEST)");
                if (((Boolean)object).booleanValue()) {
                    return requestedUser;
                }
            }
            return (injectedUser = User.parse((String)((String)threadContext.getTransient("_opendistro_security_user_info")))) == null ? (User)null : new User(injectedUser.getName(), injectedUser.getBackendRoles(), injectedUser.getRoles(), injectedUser.getCustomAttNames());
        }

        public static /* synthetic */ User buildUser$default(Companion companion, ThreadContext threadContext, User user, int n, Object object) {
            if ((n & 2) != 0) {
                user = null;
            }
            return companion.buildUser(threadContext, user);
        }

        public final void validateUserConfiguration(@Nullable User user, boolean filterEnabled) {
            if (filterEnabled) {
                if (user == null) {
                    throw IndexManagementException.Companion.wrap((Exception)new OpenSearchStatusException("Filter by user backend roles in IndexManagement is not supported with security disabled", RestStatus.FORBIDDEN, new Object[0]));
                }
                if (user.getBackendRoles().isEmpty()) {
                    throw IndexManagementException.Companion.wrap((Exception)new OpenSearchStatusException("User doesn't have backend roles configured. Contact administrator", RestStatus.FORBIDDEN, new Object[0]));
                }
            }
        }

        public final <T> boolean validateUserConfiguration(@Nullable User user, boolean filterEnabled, @NotNull ActionListener<T> actionListener) {
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            if (filterEnabled) {
                if (user == null) {
                    actionListener.onFailure((Exception)IndexManagementException.Companion.wrap((Exception)new OpenSearchStatusException("Filter by user backend roles in IndexManagement is not supported with security disabled", RestStatus.FORBIDDEN, new Object[0])));
                    return false;
                }
                if (user.getBackendRoles().isEmpty()) {
                    actionListener.onFailure((Exception)IndexManagementException.Companion.wrap((Exception)new OpenSearchStatusException("User doesn't have backend roles configured. Contact administrator", RestStatus.FORBIDDEN, new Object[0])));
                    return false;
                }
            }
            return true;
        }

        public final <T> boolean userHasPermissionForResource(@Nullable User requestedUser, @Nullable User resourceUser, boolean filterEnabled, @NotNull String resourceName, @NotNull String resourceId, @NotNull ActionListener<T> actionListener) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            if (!this.userHasPermissionForResource(requestedUser, resourceUser, filterEnabled)) {
                actionListener.onFailure((Exception)IndexManagementException.Companion.wrap((Exception)new OpenSearchStatusException("Do not have permission for " + resourceName + " [" + resourceId + "]", RestStatus.FORBIDDEN, new Object[0])));
                return false;
            }
            return true;
        }

        public static /* synthetic */ boolean userHasPermissionForResource$default(Companion companion, User user, User user2, boolean bl, String string, String string2, ActionListener actionListener, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.userHasPermissionForResource(user, user2, bl, string, string2, actionListener);
        }

        public final void verifyUserHasPermissionForResource(@Nullable User requestedUser, @Nullable User resourceUser, boolean filterEnabled, @NotNull String resourceName, @NotNull String resourceId) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
            if (!this.userHasPermissionForResource(requestedUser, resourceUser, filterEnabled)) {
                throw IndexManagementException.Companion.wrap((Exception)new OpenSearchStatusException("Do not have permission for " + resourceName + " [" + resourceId + "]", RestStatus.FORBIDDEN, new Object[0]));
            }
        }

        public static /* synthetic */ void verifyUserHasPermissionForResource$default(Companion companion, User user, User user2, boolean bl, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            companion.verifyUserHasPermissionForResource(user, user2, bl, string, string2);
        }

        public final boolean userHasPermissionForResource(@Nullable User requestedUser, @Nullable User resourceUser, boolean filterEnabled) {
            if (!filterEnabled || resourceUser == null || requestedUser == null || requestedUser.getRoles().contains(SecurityUtils.ADMIN_ROLE)) {
                return true;
            }
            List resourceBackendRoles = resourceUser.getBackendRoles();
            List requestedBackendRoles = requestedUser.getBackendRoles();
            return resourceBackendRoles != null && requestedBackendRoles != null && !CollectionsKt.intersect((Iterable)resourceBackendRoles, (Iterable)requestedBackendRoles).isEmpty();
        }

        public static /* synthetic */ boolean userHasPermissionForResource$default(Companion companion, User user, User user2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.userHasPermissionForResource(user, user2, bl);
        }

        public final void addUserFilter(@Nullable User user, @NotNull BoolQueryBuilder queryBuilder, boolean filterEnabled, @NotNull String filterPathPrefix) {
            Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
            Intrinsics.checkNotNullParameter((Object)filterPathPrefix, (String)"filterPathPrefix");
            if (!filterEnabled || user == null || user.getRoles().contains(SecurityUtils.ADMIN_ROLE)) {
                return;
            }
            BoolQueryBuilder filterQuery = new BoolQueryBuilder().should((QueryBuilder)new TermsQueryBuilder(filterPathPrefix + ".backend_roles.keyword", (Iterable)user.getBackendRoles())).should((QueryBuilder)new BoolQueryBuilder().mustNot((QueryBuilder)new ExistsQueryBuilder(filterPathPrefix)));
            queryBuilder.filter((QueryBuilder)filterQuery);
        }

        public static /* synthetic */ void addUserFilter$default(Companion companion, User user, BoolQueryBuilder boolQueryBuilder, boolean bl, String string, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            companion.addUserFilter(user, boolQueryBuilder, bl, string);
        }

        @NotNull
        public final String generateUserString(@Nullable User user) {
            if (user == null) {
                return "";
            }
            List list = user.getBackendRoles();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"user.backendRoles");
            String backendRoles = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            List list2 = user.getRoles();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"user.roles");
            String roles = CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            String requestedTenant = user.getRequestedTenant();
            String userName = user.getName();
            return userName + "|" + backendRoles + "|" + roles + "|" + requestedTenant;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

