/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.spi.schedule;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.opensearch.common.Strings;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.jobscheduler.repackage.com.cronutils.utils.VisibleForTesting;
import org.opensearch.jobscheduler.spi.schedule.Schedule;

public class IntervalSchedule
implements Schedule {
    static final String START_TIME_FIELD = "start_time";
    static final String INTERVAL_FIELD = "interval";
    static final String PERIOD_FIELD = "period";
    static final String UNIT_FIELD = "unit";
    private static final Set<ChronoUnit> SUPPORTED_UNITS;
    private Instant initialStartTime;
    private Instant startTimeWithDelay;
    private int interval;
    private ChronoUnit unit;
    private transient long intervalInMillis;
    private Clock clock;
    private Long scheduleDelay;

    public IntervalSchedule(Instant startTime, int interval, ChronoUnit unit) {
        if (!SUPPORTED_UNITS.contains(unit)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Interval unit %s is not supported, expects %s", unit, SUPPORTED_UNITS));
        }
        this.initialStartTime = startTime;
        this.startTimeWithDelay = startTime;
        this.interval = interval;
        this.unit = unit;
        this.intervalInMillis = Duration.of(interval, this.unit).toMillis();
        this.clock = Clock.system(ZoneId.systemDefault());
    }

    public IntervalSchedule(Instant startTime, int interval, ChronoUnit unit, long scheduleDelay) {
        this(startTime, interval, unit);
        this.startTimeWithDelay = startTime.plusMillis(scheduleDelay);
        this.scheduleDelay = scheduleDelay;
    }

    public IntervalSchedule(StreamInput input) throws IOException {
        this.initialStartTime = input.readInstant();
        this.interval = input.readInt();
        this.unit = (ChronoUnit)input.readEnum(ChronoUnit.class);
        this.scheduleDelay = input.readOptionalLong();
        this.startTimeWithDelay = this.scheduleDelay == null ? this.initialStartTime : this.initialStartTime.plusMillis(this.scheduleDelay);
        this.intervalInMillis = Duration.of(this.interval, this.unit).toMillis();
        this.clock = Clock.system(ZoneId.systemDefault());
    }

    public Instant getStartTime() {
        return this.startTimeWithDelay;
    }

    public int getInterval() {
        return this.interval;
    }

    public ChronoUnit getUnit() {
        return this.unit;
    }

    @Override
    public Long getDelay() {
        return this.scheduleDelay;
    }

    @Override
    public Instant getNextExecutionTime(Instant time) {
        Instant baseTime = time == null ? this.clock.instant() : time;
        long delta = baseTime.toEpochMilli() - this.startTimeWithDelay.toEpochMilli();
        if (delta >= 0L) {
            long remaining = this.intervalInMillis - delta % this.intervalInMillis;
            return baseTime.plus(remaining, ChronoUnit.MILLIS);
        }
        return this.startTimeWithDelay;
    }

    @Override
    public Duration nextTimeToExecute() {
        long enabledTimeEpochMillis = this.startTimeWithDelay.toEpochMilli();
        Instant currentTime = this.clock.instant();
        long delta = currentTime.toEpochMilli() - enabledTimeEpochMillis;
        if (delta >= 0L) {
            long remainingScheduleTime = this.intervalInMillis - delta % this.intervalInMillis;
            return Duration.of(remainingScheduleTime, ChronoUnit.MILLIS);
        }
        return Duration.ofMillis(enabledTimeEpochMillis - currentTime.toEpochMilli());
    }

    @Override
    public Tuple<Instant, Instant> getPeriodStartingAt(Instant startTime) {
        Instant realStartTime = startTime == null ? this.clock.instant() : startTime;
        Instant newEndTime = realStartTime.plusMillis(this.intervalInMillis);
        return new Tuple((Object)realStartTime, (Object)newEndTime);
    }

    @Override
    @SuppressForbidden(reason="Ignore forbidden api Math.abs()")
    public Boolean runningOnTime(Instant lastExecutionTime) {
        if (lastExecutionTime == null) {
            return true;
        }
        long enabledTimeEpochMillis = this.startTimeWithDelay.toEpochMilli();
        Instant now = this.clock.instant();
        long expectedMillisSinceLastExecution = (now.toEpochMilli() - enabledTimeEpochMillis) % this.intervalInMillis;
        if (expectedMillisSinceLastExecution < 1000L) {
            expectedMillisSinceLastExecution = this.intervalInMillis + expectedMillisSinceLastExecution;
        }
        long expectedLastExecutionTime = now.toEpochMilli() - expectedMillisSinceLastExecution;
        long expectedCurrentExecutionTime = expectedLastExecutionTime + this.intervalInMillis;
        return Math.abs(lastExecutionTime.toEpochMilli() - expectedLastExecutionTime) < 1000L || Math.abs(lastExecutionTime.toEpochMilli() - expectedCurrentExecutionTime) < 1000L;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.scheduleDelay == null ? this.toXContentNoDelay(builder) : this.toXContentWithDelay(builder);
    }

    private XContentBuilder toXContentNoDelay(XContentBuilder builder) throws IOException {
        builder.startObject().startObject(INTERVAL_FIELD).field(START_TIME_FIELD, this.initialStartTime.toEpochMilli()).field(PERIOD_FIELD, this.interval).field(UNIT_FIELD, (Object)this.unit).endObject().endObject();
        return builder;
    }

    private XContentBuilder toXContentWithDelay(XContentBuilder builder) throws IOException {
        builder.startObject().startObject(INTERVAL_FIELD).field(START_TIME_FIELD, this.initialStartTime.toEpochMilli()).field(PERIOD_FIELD, this.interval).field(UNIT_FIELD, (Object)this.unit).field("schedule_delay", this.scheduleDelay).endObject().endObject();
        return builder;
    }

    @VisibleForTesting
    void setClock(Clock clock) {
        this.clock = clock;
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)false, (boolean)true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalSchedule intervalSchedule = (IntervalSchedule)o;
        return this.initialStartTime.equals(intervalSchedule.initialStartTime) && this.interval == intervalSchedule.interval && this.unit == intervalSchedule.unit && this.intervalInMillis == intervalSchedule.intervalInMillis && Objects.equals(this.scheduleDelay, intervalSchedule.scheduleDelay);
    }

    public int hashCode() {
        return this.scheduleDelay == null ? Objects.hash(this.initialStartTime, this.interval, this.unit, this.intervalInMillis) : Objects.hash(this.initialStartTime, this.interval, this.unit, this.intervalInMillis, this.scheduleDelay);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInstant(this.initialStartTime);
        out.writeInt(this.interval);
        out.writeEnum((Enum)this.unit);
        out.writeOptionalLong(this.scheduleDelay);
    }

    static {
        HashSet<ChronoUnit> set = new HashSet<ChronoUnit>();
        set.add(ChronoUnit.MINUTES);
        set.add(ChronoUnit.HOURS);
        set.add(ChronoUnit.DAYS);
        SUPPORTED_UNITS = Collections.unmodifiableSet(set);
    }
}

