/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.script;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.opensearch.knn.plugin.script.KNNScoreScriptFactory;
import org.opensearch.knn.plugin.stats.KNNCounter;
import org.opensearch.script.ScoreScript;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;

public class KNNScoringScriptEngine
implements ScriptEngine {
    public static final String NAME = "knn";
    public static final String SCRIPT_SOURCE = "knn_score";

    public String getType() {
        return NAME;
    }

    public <FactoryType> FactoryType compile(String name, String code, ScriptContext<FactoryType> context, Map<String, String> params) {
        KNNCounter.SCRIPT_COMPILATIONS.increment();
        if (!ScoreScript.CONTEXT.equals(context)) {
            KNNCounter.SCRIPT_COMPILATION_ERRORS.increment();
            throw new IllegalArgumentException(this.getType() + " KNN scoring scripts cannot be used for context [" + context.name + "]");
        }
        if (!SCRIPT_SOURCE.equals(code)) {
            KNNCounter.SCRIPT_COMPILATION_ERRORS.increment();
            throw new IllegalArgumentException("Unknown script name " + code);
        }
        ScoreScript.Factory factory = KNNScoreScriptFactory::new;
        return (FactoryType)context.factoryClazz.cast(factory);
    }

    public Set<ScriptContext<?>> getSupportedContexts() {
        return Collections.singleton(ScoreScript.CONTEXT);
    }
}

