/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionResponse;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;

public class MLPredictActionResponse
extends ActionResponse
implements ToXContentObject {
    @Generated
    private static final Logger log = LogManager.getLogger(MLPredictActionResponse.class);
    private static final String INFERENCE_VECTORS = "inference_vectors";
    private List<List<Float>> inferenceVectorsList;

    public MLPredictActionResponse(StreamInput streamInput) throws IOException {
        super(streamInput);
        int inferenceVectorsListSize = streamInput.readVInt();
        this.inferenceVectorsList = new ArrayList<List<Float>>(inferenceVectorsListSize);
        for (int i = 0; i < inferenceVectorsListSize; ++i) {
            int vectorSize = streamInput.readVInt();
            ArrayList<Float> vector = new ArrayList<Float>();
            for (int j = 0; j < vectorSize; ++j) {
                vector.add(Float.valueOf(streamInput.readFloat()));
            }
            this.inferenceVectorsList.add(vector);
        }
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        streamOutput.writeVInt(this.inferenceVectorsList.size());
        for (List<Float> vector : this.inferenceVectorsList) {
            streamOutput.writeCollection(vector, StreamOutput::writeFloat);
        }
    }

    public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        xContentBuilder.startObject().startArray(INFERENCE_VECTORS);
        for (List<Float> floats : this.inferenceVectorsList) {
            xContentBuilder.startArray();
            for (Float value : floats) {
                xContentBuilder.value(value);
            }
            xContentBuilder.endArray();
        }
        return xContentBuilder.endArray().endObject();
    }

    @Generated
    public List<List<Float>> getInferenceVectorsList() {
        return this.inferenceVectorsList;
    }

    @Generated
    public void setInferenceVectorsList(List<List<Float>> inferenceVectorsList) {
        this.inferenceVectorsList = inferenceVectorsList;
    }

    @Generated
    public String toString() {
        return "MLPredictActionResponse(inferenceVectorsList=" + this.getInferenceVectorsList() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLPredictActionResponse)) {
            return false;
        }
        MLPredictActionResponse other = (MLPredictActionResponse)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<List<Float>> this$inferenceVectorsList = this.getInferenceVectorsList();
        List<List<Float>> other$inferenceVectorsList = other.getInferenceVectorsList();
        return !(this$inferenceVectorsList == null ? other$inferenceVectorsList != null : !((Object)this$inferenceVectorsList).equals(other$inferenceVectorsList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLPredictActionResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<Float>> $inferenceVectorsList = this.getInferenceVectorsList();
        result = result * 59 + ($inferenceVectorsList == null ? 43 : ((Object)$inferenceVectorsList).hashCode());
        return result;
    }

    @Generated
    public MLPredictActionResponse(List<List<Float>> inferenceVectorsList) {
        this.inferenceVectorsList = inferenceVectorsList;
    }
}

