/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.transport;

import java.util.List;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.transport.MLPredictActionRequest;
import org.opensearch.neuralsearch.transport.MLPredictActionResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class MLPredictTransportAction
extends HandledTransportAction<MLPredictActionRequest, MLPredictActionResponse> {
    private final MLCommonsClientAccessor clientAccessor;

    @Inject
    public MLPredictTransportAction(TransportService transportService, ActionFilters filters, MLCommonsClientAccessor clientAccessor) {
        super("cluster:admin/opensearch/neural-search/ml_predict_action", transportService, filters, MLPredictActionRequest::new);
        this.clientAccessor = clientAccessor;
    }

    protected void doExecute(Task task, MLPredictActionRequest request, ActionListener<MLPredictActionResponse> actionListener) {
        this.clientAccessor.inferenceSentences(request.getModelId(), request.getInputSentencesList(), (ActionListener<List<List<Float>>>)ActionListener.wrap(inferenceResponse -> actionListener.onResponse((Object)new MLPredictActionResponse((List<List<Float>>)inferenceResponse)), arg_0 -> actionListener.onFailure(arg_0)));
    }
}

