/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import reactor.core.publisher.Mono;

public class AddDatePolicy
implements HttpPipelinePolicy {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZone(ZoneOffset.UTC).withLocale(Locale.US);

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return Mono.defer(() -> {
            OffsetDateTime now = OffsetDateTime.now();
            try {
                context.getHttpRequest().getHeaders().set("Date", DateTimeRfc1123.toRfc1123String(now));
            }
            catch (IllegalArgumentException ignored) {
                context.getHttpRequest().getHeaders().set("Date", FORMATTER.format(now));
            }
            return next.process();
        });
    }
}

