/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.azure;

import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Strings;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.repositories.azure.AzureBlobStore;
import org.opensearch.repositories.azure.AzureStorageService;
import org.opensearch.repositories.azure.LocationMode;
import org.opensearch.repositories.blobstore.MeteredBlobStoreRepository;

public class AzureRepository
extends MeteredBlobStoreRepository {
    private static final Logger logger = LogManager.getLogger(AzureRepository.class);
    public static final String TYPE = "azure";
    private final BlobPath basePath;
    private final ByteSizeValue chunkSize;
    private final AzureStorageService storageService;
    private final boolean readonly;

    public AzureRepository(RepositoryMetadata metadata, NamedXContentRegistry namedXContentRegistry, AzureStorageService storageService, ClusterService clusterService, RecoverySettings recoverySettings) {
        super(metadata, ((Boolean)Repository.COMPRESS_SETTING.get(metadata.settings())).booleanValue(), namedXContentRegistry, clusterService, recoverySettings, AzureRepository.buildLocation(metadata));
        this.chunkSize = (ByteSizeValue)Repository.CHUNK_SIZE_SETTING.get(metadata.settings());
        this.storageService = storageService;
        String basePath = Strings.trimLeadingCharacter((String)((String)Repository.BASE_PATH_SETTING.get(metadata.settings())), (char)'/');
        if (Strings.hasLength((String)basePath)) {
            BlobPath path = new BlobPath();
            for (String elem : basePath.split("/")) {
                path = path.add(elem);
            }
            this.basePath = path;
        } else {
            this.basePath = BlobPath.cleanPath();
        }
        LocationMode locationMode = (LocationMode)((Object)Repository.LOCATION_MODE_SETTING.get(metadata.settings()));
        this.readonly = Repository.READONLY_SETTING.exists(metadata.settings()) ? (Boolean)Repository.READONLY_SETTING.get(metadata.settings()) : locationMode == LocationMode.SECONDARY_ONLY;
    }

    private static Map<String, String> buildLocation(RepositoryMetadata metadata) {
        return org.opensearch.common.collect.Map.of((Object)"base_path", (Object)((String)Repository.BASE_PATH_SETTING.get(metadata.settings())), (Object)"container", (Object)((String)Repository.CONTAINER_SETTING.get(metadata.settings())));
    }

    protected BlobStore getBlobStore() {
        return super.getBlobStore();
    }

    protected AzureBlobStore createBlobStore() {
        AzureBlobStore blobStore = new AzureBlobStore(this.metadata, this.storageService, this.threadPool);
        logger.debug(() -> new ParameterizedMessage("using container [{}], chunk_size [{}], compress [{}], base_path [{}]", new Object[]{blobStore, this.chunkSize, this.isCompress(), this.basePath}));
        return blobStore;
    }

    public BlobPath basePath() {
        return this.basePath;
    }

    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public static final class Repository {
        @Deprecated
        public static final Setting<String> ACCOUNT_SETTING = new Setting("account", "default", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
        public static final Setting<String> CLIENT_NAME = new Setting("client", ACCOUNT_SETTING, Function.identity(), new Setting.Property[0]);
        public static final Setting<String> CONTAINER_SETTING = new Setting("container", "opensearch-snapshots", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<String> BASE_PATH_SETTING = Setting.simpleString((String)"base_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<LocationMode> LOCATION_MODE_SETTING = new Setting("location_mode", s -> LocationMode.PRIMARY_ONLY.toString(), s -> LocationMode.valueOf(s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting((String)"chunk_size", (ByteSizeValue)AzureStorageService.MAX_CHUNK_SIZE, (ByteSizeValue)AzureStorageService.MIN_CHUNK_SIZE, (ByteSizeValue)AzureStorageService.MAX_CHUNK_SIZE, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting((String)"compress", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        public static final Setting<Boolean> READONLY_SETTING = Setting.boolSetting((String)"readonly", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    }
}

