/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.data.value;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.common.time.DateFormatters;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprByteValue;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprDateValue;
import org.opensearch.sql.data.model.ExprDatetimeValue;
import org.opensearch.sql.data.model.ExprDoubleValue;
import org.opensearch.sql.data.model.ExprFloatValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprLongValue;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprShortValue;
import org.opensearch.sql.data.model.ExprStringValue;
import org.opensearch.sql.data.model.ExprTimeValue;
import org.opensearch.sql.data.model.ExprTimestampValue;
import org.opensearch.sql.data.model.ExprTupleValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.opensearch.data.type.OpenSearchDataType;
import org.opensearch.sql.opensearch.data.utils.Content;
import org.opensearch.sql.opensearch.data.utils.ObjectContent;
import org.opensearch.sql.opensearch.data.utils.OpenSearchJsonContent;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprBinaryValue;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprGeoPointValue;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprIpValue;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprTextKeywordValue;
import org.opensearch.sql.opensearch.data.value.OpenSearchExprTextValue;
import org.opensearch.sql.opensearch.response.agg.OpenSearchAggregationResponseParser;
import org.opensearch.sql.utils.DateTimeFormatters;

public class OpenSearchExprValueFactory {
    private Map<String, ExprType> typeMapping;
    private OpenSearchAggregationResponseParser parser;
    private static final String TOP_PATH = "";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Map<ExprType, Function<Content, ExprValue>> typeActionMap = new ImmutableMap.Builder().put((Object)ExprCoreType.INTEGER, c -> new ExprIntegerValue((Number)c.intValue())).put((Object)ExprCoreType.LONG, c -> new ExprLongValue((Number)c.longValue())).put((Object)ExprCoreType.SHORT, c -> new ExprShortValue((Number)c.shortValue())).put((Object)ExprCoreType.BYTE, c -> new ExprByteValue((Number)c.byteValue())).put((Object)ExprCoreType.FLOAT, c -> new ExprFloatValue((Number)c.floatValue())).put((Object)ExprCoreType.DOUBLE, c -> new ExprDoubleValue((Number)c.doubleValue())).put((Object)ExprCoreType.STRING, c -> new ExprStringValue(c.stringValue())).put((Object)ExprCoreType.BOOLEAN, c -> ExprBooleanValue.of((Boolean)c.booleanValue())).put((Object)ExprCoreType.TIMESTAMP, this::parseTimestamp).put((Object)ExprCoreType.DATE, c -> new ExprDateValue(this.parseTimestamp((Content)c).dateValue().toString())).put((Object)ExprCoreType.TIME, c -> new ExprTimeValue(this.parseTimestamp((Content)c).timeValue().toString())).put((Object)ExprCoreType.DATETIME, c -> new ExprDatetimeValue(this.parseTimestamp((Content)c).datetimeValue())).put((Object)OpenSearchDataType.OPENSEARCH_TEXT, c -> new OpenSearchExprTextValue(c.stringValue())).put((Object)OpenSearchDataType.OPENSEARCH_TEXT_KEYWORD, c -> new OpenSearchExprTextKeywordValue(c.stringValue())).put((Object)OpenSearchDataType.OPENSEARCH_IP, c -> new OpenSearchExprIpValue(c.stringValue())).put((Object)OpenSearchDataType.OPENSEARCH_GEO_POINT, c -> new OpenSearchExprGeoPointValue((Double)c.geoValue().getLeft(), (Double)c.geoValue().getRight())).put((Object)OpenSearchDataType.OPENSEARCH_BINARY, c -> new OpenSearchExprBinaryValue(c.stringValue())).build();

    public OpenSearchExprValueFactory(Map<String, ExprType> typeMapping) {
        this.typeMapping = typeMapping;
    }

    public ExprValue construct(String jsonString) {
        try {
            return this.parse(new OpenSearchJsonContent(OBJECT_MAPPER.readTree(jsonString)), TOP_PATH, Optional.of(ExprCoreType.STRUCT));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(String.format("invalid json: %s.", jsonString), e);
        }
    }

    public ExprValue construct(String field, Object value) {
        return this.parse(new ObjectContent(value), field, this.type(field));
    }

    private ExprValue parse(Content content, String field, Optional<ExprType> fieldType) {
        if (content.isNull() || !fieldType.isPresent()) {
            return ExprNullValue.of();
        }
        ExprType type = fieldType.get();
        if (type == ExprCoreType.STRUCT) {
            return this.parseStruct(content, field);
        }
        if (type == ExprCoreType.ARRAY) {
            return this.parseArray(content, field);
        }
        if (this.typeActionMap.containsKey(type)) {
            return this.typeActionMap.get(type).apply(content);
        }
        throw new IllegalStateException(String.format("Unsupported type: %s for value: %s.", type.typeName(), content.objectValue()));
    }

    private Optional<ExprType> type(String field) {
        return Optional.ofNullable(this.typeMapping.get(field));
    }

    private ExprValue constructTimestamp(String value) {
        try {
            return new ExprTimestampValue(DateFormatters.from((TemporalAccessor)DateTimeFormatters.DATE_TIME_FORMATTER.parse(value)).toInstant());
        }
        catch (DateTimeParseException e) {
            throw new IllegalStateException(String.format("Construct ExprTimestampValue from \"%s\" failed, unsupported date format.", value), e);
        }
    }

    private ExprValue parseTimestamp(Content value) {
        if (value.isNumber()) {
            return new ExprTimestampValue(Instant.ofEpochMilli(value.longValue()));
        }
        if (value.isString()) {
            return this.constructTimestamp(value.stringValue());
        }
        return new ExprTimestampValue((Instant)value.objectValue());
    }

    private ExprValue parseStruct(Content content, String prefix) {
        LinkedHashMap result = new LinkedHashMap();
        content.map().forEachRemaining(entry -> result.put((String)entry.getKey(), this.parse((Content)entry.getValue(), this.makeField(prefix, (String)entry.getKey()), this.type(this.makeField(prefix, (String)entry.getKey())))));
        return new ExprTupleValue(result);
    }

    private ExprValue parseArray(Content content, String prefix) {
        ArrayList result = new ArrayList();
        content.array().forEachRemaining(v -> {
            if (v.isString()) {
                result.add(this.parse((Content)v, prefix, (Optional<ExprType>)Optional.of(ExprCoreType.STRING)));
            } else {
                result.add(this.parse((Content)v, prefix, (Optional<ExprType>)Optional.of(ExprCoreType.STRUCT)));
            }
        });
        return new ExprCollectionValue(result);
    }

    private String makeField(String path, String field) {
        return path.equalsIgnoreCase(TOP_PATH) ? field : String.join((CharSequence)".", path, field);
    }

    @Generated
    public void setTypeMapping(Map<String, ExprType> typeMapping) {
        this.typeMapping = typeMapping;
    }

    @Generated
    public OpenSearchAggregationResponseParser getParser() {
        return this.parser;
    }

    @Generated
    public void setParser(OpenSearchAggregationResponseParser parser) {
        this.parser = parser;
    }
}

