/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.script.aggregation.dsl;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.opensearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ExtendedStats;
import org.opensearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.expression.ReferenceExpression;
import org.opensearch.sql.expression.aggregation.NamedAggregator;
import org.opensearch.sql.opensearch.response.agg.FilterParser;
import org.opensearch.sql.opensearch.response.agg.MetricParser;
import org.opensearch.sql.opensearch.response.agg.SingleValueParser;
import org.opensearch.sql.opensearch.response.agg.StatsParser;
import org.opensearch.sql.opensearch.response.agg.TopHitsParser;
import org.opensearch.sql.opensearch.storage.script.aggregation.dsl.AggregationBuilderHelper;
import org.opensearch.sql.opensearch.storage.script.filter.FilterQueryBuilder;
import org.opensearch.sql.opensearch.storage.serialization.ExpressionSerializer;

public class MetricAggregationBuilder
extends ExpressionNodeVisitor<Pair<AggregationBuilder, MetricParser>, Object> {
    private final AggregationBuilderHelper helper;
    private final FilterQueryBuilder filterBuilder;

    public MetricAggregationBuilder(ExpressionSerializer serializer) {
        this.helper = new AggregationBuilderHelper(serializer);
        this.filterBuilder = new FilterQueryBuilder(serializer);
    }

    public Pair<AggregatorFactories.Builder, List<MetricParser>> build(List<NamedAggregator> aggregatorList) {
        AggregatorFactories.Builder builder = new AggregatorFactories.Builder();
        ArrayList<MetricParser> metricParserList = new ArrayList<MetricParser>();
        for (NamedAggregator aggregator : aggregatorList) {
            Pair pair = (Pair)aggregator.accept((ExpressionNodeVisitor)this, null);
            builder.addAggregator((AggregationBuilder)pair.getLeft());
            metricParserList.add((MetricParser)pair.getRight());
        }
        return Pair.of((Object)builder, metricParserList);
    }

    public Pair<AggregationBuilder, MetricParser> visitNamedAggregator(NamedAggregator node, Object context) {
        Expression expression = (Expression)node.getArguments().get(0);
        Expression condition = node.getDelegated().condition();
        Boolean distinct = node.getDelegated().distinct();
        String name = node.getName();
        String functionName = node.getFunctionName().getFunctionName().toLowerCase(Locale.ROOT);
        if (distinct.booleanValue()) {
            switch (functionName) {
                case "count": {
                    return this.make(AggregationBuilders.cardinality((String)name), expression, condition, name, (MetricParser)new SingleValueParser(name));
                }
            }
            throw new IllegalStateException(String.format("unsupported distinct aggregator %s", node.getFunctionName().getFunctionName()));
        }
        switch (functionName) {
            case "avg": {
                return this.make((ValuesSourceAggregationBuilder<?>)AggregationBuilders.avg((String)name), expression, condition, name, (MetricParser)new SingleValueParser(name));
            }
            case "sum": {
                return this.make((ValuesSourceAggregationBuilder<?>)AggregationBuilders.sum((String)name), expression, condition, name, (MetricParser)new SingleValueParser(name));
            }
            case "count": {
                return this.make((ValuesSourceAggregationBuilder<?>)AggregationBuilders.count((String)name), this.replaceStarOrLiteral(expression), condition, name, (MetricParser)new SingleValueParser(name));
            }
            case "min": {
                return this.make((ValuesSourceAggregationBuilder<?>)AggregationBuilders.min((String)name), expression, condition, name, (MetricParser)new SingleValueParser(name));
            }
            case "max": {
                return this.make((ValuesSourceAggregationBuilder<?>)AggregationBuilders.max((String)name), expression, condition, name, (MetricParser)new SingleValueParser(name));
            }
            case "var_samp": {
                return this.make((ValuesSourceAggregationBuilder<?>)AggregationBuilders.extendedStats((String)name), expression, condition, name, (MetricParser)new StatsParser(ExtendedStats::getVarianceSampling, name));
            }
            case "var_pop": {
                return this.make((ValuesSourceAggregationBuilder<?>)AggregationBuilders.extendedStats((String)name), expression, condition, name, (MetricParser)new StatsParser(ExtendedStats::getVariancePopulation, name));
            }
            case "stddev_samp": {
                return this.make((ValuesSourceAggregationBuilder<?>)AggregationBuilders.extendedStats((String)name), expression, condition, name, (MetricParser)new StatsParser(ExtendedStats::getStdDeviationSampling, name));
            }
            case "stddev_pop": {
                return this.make((ValuesSourceAggregationBuilder<?>)AggregationBuilders.extendedStats((String)name), expression, condition, name, (MetricParser)new StatsParser(ExtendedStats::getStdDeviationPopulation, name));
            }
            case "take": {
                return this.make(AggregationBuilders.topHits((String)name), expression, (Expression)node.getArguments().get(1), condition, name, new TopHitsParser(name));
            }
        }
        throw new IllegalStateException(String.format("unsupported aggregator %s", node.getFunctionName().getFunctionName()));
    }

    private Pair<AggregationBuilder, MetricParser> make(ValuesSourceAggregationBuilder<?> builder, Expression expression, Expression condition, String name, MetricParser parser) {
        ValuesSourceAggregationBuilder aggregationBuilder = this.helper.build(expression, arg_0 -> builder.field(arg_0), arg_0 -> builder.script(arg_0));
        if (condition != null) {
            return Pair.of((Object)this.makeFilterAggregation((AggregationBuilder)aggregationBuilder, condition, name), (Object)FilterParser.builder().name(name).metricsParser(parser).build());
        }
        return Pair.of((Object)aggregationBuilder, (Object)parser);
    }

    private Pair<AggregationBuilder, MetricParser> make(CardinalityAggregationBuilder builder, Expression expression, Expression condition, String name, MetricParser parser) {
        CardinalityAggregationBuilder aggregationBuilder = this.helper.build(expression, arg_0 -> ((CardinalityAggregationBuilder)builder).field(arg_0), arg_0 -> ((CardinalityAggregationBuilder)builder).script(arg_0));
        if (condition != null) {
            return Pair.of((Object)this.makeFilterAggregation((AggregationBuilder)aggregationBuilder, condition, name), (Object)FilterParser.builder().name(name).metricsParser(parser).build());
        }
        return Pair.of((Object)aggregationBuilder, (Object)parser);
    }

    private Pair<AggregationBuilder, MetricParser> make(TopHitsAggregationBuilder builder, Expression expression, Expression size, Expression condition, String name, MetricParser parser) {
        String fieldName = ((ReferenceExpression)expression).getAttr();
        builder.fetchSource(fieldName, null);
        builder.size(size.valueOf(null).integerValue().intValue());
        builder.from(0);
        if (condition != null) {
            return Pair.of((Object)this.makeFilterAggregation((AggregationBuilder)builder, condition, name), (Object)FilterParser.builder().name(name).metricsParser(parser).build());
        }
        return Pair.of((Object)builder, (Object)parser);
    }

    private Expression replaceStarOrLiteral(Expression countArg) {
        if (countArg instanceof LiteralExpression) {
            return new ReferenceExpression("_index", (ExprType)ExprCoreType.INTEGER);
        }
        return countArg;
    }

    private FilterAggregationBuilder makeFilterAggregation(AggregationBuilder subAggBuilder, Expression condition, String name) {
        return (FilterAggregationBuilder)AggregationBuilders.filter((String)name, (QueryBuilder)this.filterBuilder.build(condition)).subAggregation(subAggBuilder);
    }
}

