/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.data.model;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.sql.data.model.AbstractExprValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.utils.DateTimeFormatters;

public class ExprTimeValue
extends AbstractExprValue {
    private final LocalTime time;

    public ExprTimeValue(String time) {
        try {
            this.time = LocalTime.parse(time, DateTimeFormatters.TIME_FORMATTER_VARIABLE_NANOS);
        }
        catch (DateTimeParseException e) {
            throw new SemanticCheckException(String.format("time:%s in unsupported format, please use HH:mm:ss[.SSSSSSSSS]", time));
        }
    }

    @Override
    public String value() {
        return DateTimeFormatter.ISO_LOCAL_TIME.format(this.time);
    }

    @Override
    public ExprType type() {
        return ExprCoreType.TIME;
    }

    @Override
    public LocalTime timeValue() {
        return this.time;
    }

    public String toString() {
        return String.format("TIME '%s'", this.value());
    }

    @Override
    public int compare(ExprValue other) {
        return this.time.compareTo(other.timeValue());
    }

    @Override
    public boolean equal(ExprValue other) {
        return this.time.equals(other.timeValue());
    }

    public int hashCode() {
        return Objects.hashCode(this.time);
    }

    @Generated
    public ExprTimeValue(LocalTime time) {
        this.time = time;
    }
}

