/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.asciiart.BasicCharArea;
import net.sourceforge.plantuml.awt.geom.XCubicCurve2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.posimo.BezierUtils;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterPosition;
import net.sourceforge.plantuml.svek.MinFinder;
import net.sourceforge.plantuml.svek.PointAndAngle;
import net.sourceforge.plantuml.svek.SvgResult;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.UShape;

public class DotPath
implements UShape,
Moveable {
    private final List<XCubicCurve2D> beziers = new ArrayList<XCubicCurve2D>();
    private String comment;
    private String codeLine;

    public DotPath copy() {
        DotPath result = new DotPath();
        for (XCubicCurve2D c : this.beziers) {
            result.beziers.add(new XCubicCurve2D(c.x1, c.y1, c.ctrlx1, c.ctrly1, c.ctrlx2, c.ctrly2, c.x2, c.y2));
        }
        return result;
    }

    private static DotPath fromBeziers(List<XCubicCurve2D> beziers) {
        DotPath result = new DotPath();
        result.beziers.addAll((Collection<XCubicCurve2D>)Objects.requireNonNull(beziers));
        return result;
    }

    public DotPath() {
    }

    public DotPath(SvgResult fullSvg) {
        if (!DotPath.isPathConsistent(fullSvg.getSvg())) {
            throw new IllegalArgumentException();
        }
        int posC = fullSvg.indexOf("C", 0);
        if (posC == -1) {
            throw new IllegalArgumentException();
        }
        XPoint2D start = fullSvg.substring(1, posC).getNextPoint();
        ArrayList<TriPoints> triPoints = new ArrayList<TriPoints>();
        Iterator<XPoint2D> it = fullSvg.substring(posC + 1).getPoints(" ").iterator();
        while (it.hasNext()) {
            XPoint2D p1 = it.next();
            XPoint2D p2 = it.next();
            XPoint2D p = it.next();
            triPoints.add(new TriPoints(p1, p2, p));
        }
        double x = start.getX();
        double y = start.getY();
        for (TriPoints p : triPoints) {
            XCubicCurve2D bezier = new XCubicCurve2D(x, y, p.x1, p.y1, p.x2, p.y2, p.x, p.y);
            this.beziers.add(bezier);
            x = p.x;
            y = p.y;
        }
    }

    public DotPath addCurve(XPoint2D pt1, XPoint2D pt2, XPoint2D pt3, XPoint2D pt4) {
        ArrayList<XCubicCurve2D> beziersNew = new ArrayList<XCubicCurve2D>(this.beziers);
        beziersNew.add(new XCubicCurve2D(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY(), pt3.getX(), pt3.getY(), pt4.getX(), pt4.getY()));
        return DotPath.fromBeziers(beziersNew);
    }

    public DotPath addCurve(XPoint2D pt2, XPoint2D pt3, XPoint2D pt4) {
        XCubicCurve2D last = this.beziers.get(this.beziers.size() - 1);
        XPoint2D p1 = last.getP2();
        return this.addCurve(p1, pt2, pt3, pt4);
    }

    public static boolean isPathConsistent(String init) {
        return init.startsWith("M");
    }

    public XPoint2D getStartPoint() {
        return this.beziers.get(0).getP1();
    }

    public Set<XPoint2D> sample() {
        HashSet<XPoint2D> result = new HashSet<XPoint2D>();
        for (XCubicCurve2D bez : this.beziers) {
            DotPath.sample(bez, result);
        }
        return Collections.unmodifiableSet(result);
    }

    private static void sample(XCubicCurve2D bez, Set<XPoint2D> result) {
        XPoint2D p1 = bez.getCtrlP1();
        XPoint2D p2 = bez.getCtrlP2();
        if (bez.getFlatnessSq() > 0.5 || p1.distance(p2) > 4.0) {
            XCubicCurve2D left = new XCubicCurve2D();
            XCubicCurve2D right = new XCubicCurve2D();
            bez.subdivide(left, right);
            DotPath.sample(left, result);
            DotPath.sample(right, result);
        } else {
            result.add(p1);
            result.add(p2);
        }
    }

    public PointAndAngle getMiddle() {
        XPoint2D result = null;
        double angle = 0.0;
        for (XCubicCurve2D bez : this.beziers) {
            XCubicCurve2D left = new XCubicCurve2D();
            XCubicCurve2D right = new XCubicCurve2D();
            bez.subdivide(left, right);
            XPoint2D p1 = left.getP1();
            XPoint2D p2 = left.getP2();
            XPoint2D p3 = right.getP1();
            XPoint2D p4 = right.getP2();
            if (result == null || this.getCost(p1) < this.getCost(result)) {
                result = p1;
                angle = BezierUtils.getStartingAngle(left);
            }
            if (this.getCost(p2) < this.getCost(result)) {
                result = p2;
                angle = BezierUtils.getEndingAngle(left);
            }
            if (this.getCost(p3) < this.getCost(result)) {
                result = p3;
                angle = BezierUtils.getStartingAngle(right);
            }
            if (!(this.getCost(p4) < this.getCost(result))) continue;
            result = p4;
            angle = BezierUtils.getEndingAngle(right);
        }
        return new PointAndAngle(result, angle);
    }

    private double getCost(XPoint2D pt) {
        XPoint2D start = this.getStartPoint();
        XPoint2D end = this.getEndPoint();
        return pt.distanceSq(start) + pt.distanceSq(end);
    }

    public void forceStartPoint(double x, double y) {
        this.beziers.get((int)0).x1 = x;
        this.beziers.get((int)0).y1 = y;
        this.beziers.get((int)0).ctrlx1 = x;
        this.beziers.get((int)0).ctrly1 = y;
    }

    public void moveStartPoint(double dx, double dy) {
        this.beziers.get((int)0).x1 += dx;
        this.beziers.get((int)0).y1 += dy;
        this.beziers.get((int)0).ctrlx1 += dx;
        this.beziers.get((int)0).ctrly1 += dy;
    }

    public XPoint2D getEndPoint() {
        return this.beziers.get(this.beziers.size() - 1).getP2();
    }

    public void forceEndPoint(double x, double y) {
        this.beziers.get((int)(this.beziers.size() - 1)).x2 = x;
        this.beziers.get((int)(this.beziers.size() - 1)).y2 = y;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrlx2 = x;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrly2 = y;
    }

    public void moveEndPoint(double dx, double dy) {
        this.beziers.get((int)(this.beziers.size() - 1)).x2 += dx;
        this.beziers.get((int)(this.beziers.size() - 1)).y2 += dy;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrlx2 += dx;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrly2 += dy;
    }

    public MinFinder getMinFinder() {
        MinFinder result = new MinFinder();
        for (XCubicCurve2D c : this.beziers) {
            result.manage(c.x1, c.y1);
            result.manage(c.x2, c.y2);
            result.manage(c.ctrlx1, c.ctrly1);
            result.manage(c.ctrlx2, c.ctrly2);
        }
        return result;
    }

    public MinMax getMinMax() {
        MinMax result = MinMax.getEmpty(false);
        for (XCubicCurve2D c : this.beziers) {
            result = result.addPoint(c.x1, c.y1);
            result = result.addPoint(c.x2, c.y2);
            result = result.addPoint(c.ctrlx1, c.ctrly1);
            result = result.addPoint(c.ctrlx2, c.ctrly2);
        }
        return result;
    }

    public double getMinDist(XPoint2D ref) {
        double result = Double.MAX_VALUE;
        for (XCubicCurve2D c : this.beziers) {
            double d4;
            double d3;
            double d2;
            double d1 = ref.distance(c.x1, c.y1);
            if (d1 < result) {
                result = d1;
            }
            if ((d2 = ref.distance(c.x2, c.y2)) < result) {
                result = d2;
            }
            if ((d3 = ref.distance(c.ctrlx1, c.ctrly1)) < result) {
                result = d3;
            }
            if (!((d4 = ref.distance(c.ctrlx2, c.ctrly2)) < result)) continue;
            result = d4;
        }
        return result;
    }

    public Line2D getEndTangeante() {
        XCubicCurve2D last = this.beziers.get(this.beziers.size() - 1);
        double dx = last.x2 - last.ctrlx2;
        double dy = last.y2 - last.ctrly2;
        if (dx == 0.0 && dy == 0.0) {
            dx = last.x2 - last.x1;
            dy = last.y2 - last.y1;
        }
        return new Line2D.Double(last.x2, last.y2, last.x2 + dx, last.y2 + dy);
    }

    public double getEndAngle() {
        Line2D tan = this.getEndTangeante();
        double theta1 = Math.atan2(tan.getY2() - tan.getY1(), tan.getX2() - tan.getX1());
        return theta1;
    }

    public double getStartAngle() {
        Line2D tan = this.getStartTangeante();
        double theta1 = Math.atan2(tan.getY2() - tan.getY1(), tan.getX2() - tan.getX1());
        return theta1;
    }

    public Line2D getStartTangeante() {
        XCubicCurve2D first = this.beziers.get(0);
        double dx = first.ctrlx1 - first.x1;
        double dy = first.ctrly1 - first.y1;
        if (dx == 0.0 && dy == 0.0) {
            dx = first.x2 - first.x1;
            dy = first.y2 - first.y1;
        }
        return new Line2D.Double(first.x1, first.y1, first.x1 + dx, first.y1 + dy);
    }

    public DotPath addBefore(XCubicCurve2D before) {
        ArrayList<XCubicCurve2D> copy = new ArrayList<XCubicCurve2D>(this.beziers);
        copy.add(0, before);
        return DotPath.fromBeziers(copy);
    }

    private DotPath addBefore(DotPath other) {
        ArrayList<XCubicCurve2D> copy = new ArrayList<XCubicCurve2D>(this.beziers);
        copy.addAll(0, other.beziers);
        return DotPath.fromBeziers(copy);
    }

    public DotPath addAfter(XCubicCurve2D after) {
        ArrayList<XCubicCurve2D> copy = new ArrayList<XCubicCurve2D>(this.beziers);
        copy.add(after);
        return DotPath.fromBeziers(copy);
    }

    public DotPath addAfter(DotPath other) {
        ArrayList<XCubicCurve2D> copy = new ArrayList<XCubicCurve2D>(this.beziers);
        copy.addAll(other.beziers);
        return DotPath.fromBeziers(copy);
    }

    public void draw(Graphics2D g2d, double x, double y) {
        GeneralPath p = new GeneralPath();
        for (XCubicCurve2D bez : this.beziers) {
            CubicCurve2D.Double bez2 = new CubicCurve2D.Double(x + bez.x1, y + bez.y1, x + bez.ctrlx1, y + bez.ctrly1, x + bez.ctrlx2, y + bez.ctrly2, x + bez.x2, y + bez.y2);
            p.append(bez2, true);
        }
        g2d.draw(p);
    }

    public void manageEnsureVisible(double x, double y, EnsureVisible visible) {
        for (XCubicCurve2D bez : this.beziers) {
            visible.ensureVisible(x + bez.x1, y + bez.y1);
            visible.ensureVisible(x + bez.x2, y + bez.y2);
        }
    }

    public void drawOk(EpsGraphics eps, double x, double y) {
        for (XCubicCurve2D bez : this.beziers) {
            bez = new XCubicCurve2D(x + bez.x1, y + bez.y1, x + bez.ctrlx1, y + bez.ctrly1, x + bez.ctrlx2, y + bez.ctrly2, x + bez.x2, y + bez.y2);
            eps.epsLine(bez.x1, bez.y1, bez.x2, bez.y2);
        }
    }

    public void draw(EpsGraphics eps, double x, double y) {
        eps.newpathDot();
        boolean dashed = false;
        boolean first = true;
        for (XCubicCurve2D bez : this.beziers) {
            bez = new XCubicCurve2D(x + bez.x1, y + bez.y1, x + bez.ctrlx1, y + bez.ctrly1, x + bez.ctrlx2, y + bez.ctrly2, x + bez.x2, y + bez.y2);
            if (first) {
                eps.movetoNoMacro(bez.x1, bez.y1);
                first = false;
            }
            eps.curvetoNoMacro(bez.ctrlx1, bez.ctrly1, bez.ctrlx2, bez.ctrly2, bez.x2, bez.y2);
        }
        eps.closepathDot();
    }

    public UPath toUPath() {
        UPath result = new UPath(this.comment, this.codeLine);
        boolean start = true;
        for (XCubicCurve2D bez : this.beziers) {
            if (start) {
                result.add(new double[]{bez.x1, bez.y1}, USegmentType.SEG_MOVETO);
                start = false;
            }
            result.add(new double[]{bez.ctrlx1, bez.ctrly1, bez.ctrlx2, bez.ctrly2, bez.x2, bez.y2}, USegmentType.SEG_CUBICTO);
        }
        return result;
    }

    public void draw(BasicCharArea area, double pixelXPerChar, double pixelYPerChar) {
        for (XCubicCurve2D bez : this.beziers) {
            if (bez.x1 == bez.x2) {
                area.drawVLine('|', (int)(bez.x1 / pixelXPerChar), (int)(bez.y1 / pixelYPerChar), (int)(bez.y2 / pixelYPerChar));
                continue;
            }
            if (bez.y1 != bez.y2) continue;
            area.drawHLine('-', (int)(bez.y1 / pixelYPerChar), (int)(bez.x1 / pixelXPerChar), (int)(bez.x2 / pixelXPerChar));
        }
    }

    static String toString(XCubicCurve2D c) {
        return "(" + c.x1 + "," + c.y1 + ") (" + c.ctrlx1 + "," + c.ctrly1 + ") (" + c.ctrlx2 + "," + c.ctrly2 + ") (" + c.x2 + "," + c.y2 + ") ";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (XCubicCurve2D c : this.beziers) {
            sb.append(DotPath.toString(c));
            sb.append(" - ");
        }
        return sb.toString();
    }

    public static XCubicCurve2D reverse(XCubicCurve2D curv) {
        return new XCubicCurve2D(curv.getX2(), curv.getY2(), curv.getCtrlX2(), curv.getCtrlY2(), curv.getCtrlX1(), curv.getCtrlY1(), curv.getX1(), curv.getY1());
    }

    public DotPath reverse() {
        ArrayList<XCubicCurve2D> reverse = new ArrayList<XCubicCurve2D>(this.beziers);
        Collections.reverse(reverse);
        ArrayList<XCubicCurve2D> copy = new ArrayList<XCubicCurve2D>();
        for (XCubicCurve2D cub : reverse) {
            copy.add(DotPath.reverse(cub));
        }
        return DotPath.fromBeziers(copy);
    }

    @Override
    public void moveSvek(double deltaX, double deltaY) {
        for (int i = 0; i < this.beziers.size(); ++i) {
            XCubicCurve2D c = this.beziers.get(i);
            this.beziers.set(i, new XCubicCurve2D(c.x1 + deltaX, c.y1 + deltaY, c.ctrlx1 + deltaX, c.ctrly1 + deltaY, c.ctrlx2 + deltaX, c.ctrly2 + deltaY, c.x2 + deltaX, c.y2 + deltaY));
        }
    }

    public final List<XCubicCurve2D> getBeziers() {
        return Collections.unmodifiableList(this.beziers);
    }

    public DotPath simulateCompound(Cluster head, Cluster tail) {
        XCubicCurve2D part2;
        XCubicCurve2D part1;
        int k;
        ClusterPosition clusterPosition;
        if (head == null && tail == null) {
            return this;
        }
        DotPath me = this;
        if (tail != null && (clusterPosition = tail.getClusterPosition()).contains(this.getStartPoint())) {
            DotPath result = new DotPath();
            int idx = 0;
            while (idx + 1 < this.beziers.size() && clusterPosition.contains(this.beziers.get(idx).getP2())) {
                if (!clusterPosition.contains(this.beziers.get(idx).getP1())) {
                    throw new IllegalStateException();
                }
                ++idx;
            }
            if (!clusterPosition.contains(this.beziers.get(idx).getP2())) {
                assert (clusterPosition.contains(this.beziers.get(idx).getP1()));
                assert (!clusterPosition.contains(this.beziers.get(idx).getP2()));
                XCubicCurve2D current = this.beziers.get(idx);
                for (k = 0; k < 8; ++k) {
                    part1 = new XCubicCurve2D();
                    part2 = new XCubicCurve2D();
                    current.subdivide(part1, part2);
                    assert (part1.getP2().equals(part2.getP1()));
                    if (clusterPosition.contains(part1.getP2())) {
                        current = part2;
                        continue;
                    }
                    result.beziers.add(0, part2);
                    current = part1;
                }
                for (int i = idx + 1; i < this.beziers.size(); ++i) {
                    result.beziers.add(this.beziers.get(i));
                }
                me = result;
            }
        }
        if (head != null) {
            DotPath result = new DotPath();
            ClusterPosition clusterPosition2 = head.getClusterPosition();
            if (clusterPosition2.contains(this.getEndPoint())) {
                for (XCubicCurve2D current : me.beziers) {
                    if (!clusterPosition2.contains(current.getP2())) {
                        result.beziers.add(current);
                        continue;
                    }
                    if (clusterPosition2.contains(current.getP1())) {
                        return me;
                    }
                    assert (!clusterPosition2.contains(current.getP1()));
                    assert (clusterPosition2.contains(current.getP2()));
                    for (k = 0; k < 8; ++k) {
                        part1 = new XCubicCurve2D();
                        part2 = new XCubicCurve2D();
                        current.subdivide(part1, part2);
                        assert (part1.getP2().equals(part2.getP1()));
                        if (clusterPosition2.contains(part1.getP2())) {
                            current = part1;
                            continue;
                        }
                        result.beziers.add(part1);
                        current = part2;
                    }
                    return result;
                }
            }
        }
        return me;
    }

    public boolean isLine() {
        for (XCubicCurve2D curve : this.beziers) {
            if (!(curve.getFlatnessSq() > 0.001)) continue;
            return false;
        }
        return true;
    }

    public void setCommentAndCodeLine(String comment, String codeLine) {
        this.comment = comment;
        this.codeLine = codeLine;
    }

    static class TriPoints {
        private final double x1;
        private final double y1;
        private final double x2;
        private final double y2;
        private final double x;
        private final double y;

        public TriPoints(XPoint2D p1, XPoint2D p2, XPoint2D p) {
            this.x1 = p1.getX();
            this.y1 = p1.getY();
            this.x2 = p2.getX();
            this.y2 = p2.getY();
            this.x = p.getX();
            this.y = p.getY();
        }
    }
}

