# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
TFunction module, see official documentation at
https://www.opencascade.com/doc/occt-7.6.0/refman/html/package_tfunction.html
"""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _TFunction
else:
    import _TFunction

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _TFunction.delete_SwigPyIterator

    def value(self) -> "PyObject *":
        return _TFunction.SwigPyIterator_value(self)

    def incr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _TFunction.SwigPyIterator_incr(self, n)

    def decr(self, n: "size_t"=1) -> "swig::SwigPyIterator *":
        return _TFunction.SwigPyIterator_decr(self, n)

    def distance(self, x: "SwigPyIterator") -> "ptrdiff_t":
        return _TFunction.SwigPyIterator_distance(self, x)

    def equal(self, x: "SwigPyIterator") -> "bool":
        return _TFunction.SwigPyIterator_equal(self, x)

    def copy(self) -> "swig::SwigPyIterator *":
        return _TFunction.SwigPyIterator_copy(self)

    def next(self) -> "PyObject *":
        return _TFunction.SwigPyIterator_next(self)

    def __next__(self) -> "PyObject *":
        return _TFunction.SwigPyIterator___next__(self)

    def previous(self) -> "PyObject *":
        return _TFunction.SwigPyIterator_previous(self)

    def advance(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _TFunction.SwigPyIterator_advance(self, n)

    def __eq__(self, x: "SwigPyIterator") -> "bool":
        return _TFunction.SwigPyIterator___eq__(self, x)

    def __ne__(self, x: "SwigPyIterator") -> "bool":
        return _TFunction.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _TFunction.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator &":
        return _TFunction.SwigPyIterator___isub__(self, n)

    def __add__(self, n: "ptrdiff_t") -> "swig::SwigPyIterator *":
        return _TFunction.SwigPyIterator___add__(self, n)

    def __sub__(self, *args) -> "ptrdiff_t":
        return _TFunction.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _TFunction:
_TFunction.SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error: "Standard_Failure", method_name: "std::string", class_name: "std::string") -> "void":
    return _TFunction.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TDF
import OCC.Core.TCollection
import OCC.Core.TColStd

from enum import IntEnum
from OCC.Core.Exception import *

TFunction_ES_WrongDefinition = _TFunction.TFunction_ES_WrongDefinition
TFunction_ES_NotExecuted = _TFunction.TFunction_ES_NotExecuted
TFunction_ES_Executing = _TFunction.TFunction_ES_Executing
TFunction_ES_Succeeded = _TFunction.TFunction_ES_Succeeded
TFunction_ES_Failed = _TFunction.TFunction_ES_Failed


class TFunction_ExecutionStatus(IntEnum):
	TFunction_ES_WrongDefinition = 0
	TFunction_ES_NotExecuted = 1
	TFunction_ES_Executing = 2
	TFunction_ES_Succeeded = 3
	TFunction_ES_Failed = 4
TFunction_ES_WrongDefinition = TFunction_ExecutionStatus.TFunction_ES_WrongDefinition
TFunction_ES_NotExecuted = TFunction_ExecutionStatus.TFunction_ES_NotExecuted
TFunction_ES_Executing = TFunction_ExecutionStatus.TFunction_ES_Executing
TFunction_ES_Succeeded = TFunction_ExecutionStatus.TFunction_ES_Succeeded
TFunction_ES_Failed = TFunction_ExecutionStatus.TFunction_ES_Failed


def Handle_TFunction_Driver_Create() -> "opencascade::handle< TFunction_Driver >":
    return _TFunction.Handle_TFunction_Driver_Create()

def Handle_TFunction_Driver_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TFunction_Driver >":
    return _TFunction.Handle_TFunction_Driver_DownCast(t)

def Handle_TFunction_Driver_IsNull(t: "opencascade::handle< TFunction_Driver > const &") -> "bool":
    return _TFunction.Handle_TFunction_Driver_IsNull(t)

def Handle_TFunction_DriverTable_Create() -> "opencascade::handle< TFunction_DriverTable >":
    return _TFunction.Handle_TFunction_DriverTable_Create()

def Handle_TFunction_DriverTable_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TFunction_DriverTable >":
    return _TFunction.Handle_TFunction_DriverTable_DownCast(t)

def Handle_TFunction_DriverTable_IsNull(t: "opencascade::handle< TFunction_DriverTable > const &") -> "bool":
    return _TFunction.Handle_TFunction_DriverTable_IsNull(t)

def Handle_TFunction_Function_Create() -> "opencascade::handle< TFunction_Function >":
    return _TFunction.Handle_TFunction_Function_Create()

def Handle_TFunction_Function_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TFunction_Function >":
    return _TFunction.Handle_TFunction_Function_DownCast(t)

def Handle_TFunction_Function_IsNull(t: "opencascade::handle< TFunction_Function > const &") -> "bool":
    return _TFunction.Handle_TFunction_Function_IsNull(t)

def Handle_TFunction_GraphNode_Create() -> "opencascade::handle< TFunction_GraphNode >":
    return _TFunction.Handle_TFunction_GraphNode_Create()

def Handle_TFunction_GraphNode_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TFunction_GraphNode >":
    return _TFunction.Handle_TFunction_GraphNode_DownCast(t)

def Handle_TFunction_GraphNode_IsNull(t: "opencascade::handle< TFunction_GraphNode > const &") -> "bool":
    return _TFunction.Handle_TFunction_GraphNode_IsNull(t)

def Handle_TFunction_Logbook_Create() -> "opencascade::handle< TFunction_Logbook >":
    return _TFunction.Handle_TFunction_Logbook_Create()

def Handle_TFunction_Logbook_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TFunction_Logbook >":
    return _TFunction.Handle_TFunction_Logbook_DownCast(t)

def Handle_TFunction_Logbook_IsNull(t: "opencascade::handle< TFunction_Logbook > const &") -> "bool":
    return _TFunction.Handle_TFunction_Logbook_IsNull(t)

def Handle_TFunction_Scope_Create() -> "opencascade::handle< TFunction_Scope >":
    return _TFunction.Handle_TFunction_Scope_Create()

def Handle_TFunction_Scope_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TFunction_Scope >":
    return _TFunction.Handle_TFunction_Scope_DownCast(t)

def Handle_TFunction_Scope_IsNull(t: "opencascade::handle< TFunction_Scope > const &") -> "bool":
    return _TFunction.Handle_TFunction_Scope_IsNull(t)

def Handle_TFunction_HArray1OfDataMapOfGUIDDriver_Create() -> "opencascade::handle< TFunction_HArray1OfDataMapOfGUIDDriver >":
    return _TFunction.Handle_TFunction_HArray1OfDataMapOfGUIDDriver_Create()

def Handle_TFunction_HArray1OfDataMapOfGUIDDriver_DownCast(t: "opencascade::handle< Standard_Transient > const &") -> "opencascade::handle< TFunction_HArray1OfDataMapOfGUIDDriver >":
    return _TFunction.Handle_TFunction_HArray1OfDataMapOfGUIDDriver_DownCast(t)

def Handle_TFunction_HArray1OfDataMapOfGUIDDriver_IsNull(t: "opencascade::handle< TFunction_HArray1OfDataMapOfGUIDDriver > const &") -> "bool":
    return _TFunction.Handle_TFunction_HArray1OfDataMapOfGUIDDriver_IsNull(t)
class TFunction_Array1OfDataMapOfGUIDDriver(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_Array1< TFunction_DataMapOfGUIDDriver >::iterator":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_begin(self)

    def end(self) -> "NCollection_Array1< TFunction_DataMapOfGUIDDriver >::iterator":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_end(self)

    def cbegin(self) -> "NCollection_Array1< TFunction_DataMapOfGUIDDriver >::const_iterator":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_cbegin(self)

    def cend(self) -> "NCollection_Array1< TFunction_DataMapOfGUIDDriver >::const_iterator":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_cend(self)

    def __init__(self, *args):
        _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_swiginit(self, _TFunction.new_TFunction_Array1OfDataMapOfGUIDDriver(*args))

    def Init(self, theValue: "TFunction_DataMapOfGUIDDriver") -> "void":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Init(self, theValue)

    def Size(self) -> "Standard_Integer":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Size(self)

    def Length(self) -> "Standard_Integer":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Length(self)

    def IsEmpty(self) -> "Standard_Boolean":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_IsEmpty(self)

    def Lower(self) -> "Standard_Integer":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Lower(self)

    def Upper(self) -> "Standard_Integer":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Upper(self)

    def IsDeletable(self) -> "Standard_Boolean":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_IsDeletable(self)

    def IsAllocated(self) -> "Standard_Boolean":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_IsAllocated(self)

    def Assign(self, theOther: "TFunction_Array1OfDataMapOfGUIDDriver") -> "NCollection_Array1< TFunction_DataMapOfGUIDDriver > &":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Assign(self, theOther)

    def Move(self, theOther: "TFunction_Array1OfDataMapOfGUIDDriver") -> "NCollection_Array1< TFunction_DataMapOfGUIDDriver > &":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Move(self, theOther)

    def Set(self, *args) -> "NCollection_Array1< TFunction_DataMapOfGUIDDriver > &":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Set(self, *args)

    def First(self) -> "TFunction_DataMapOfGUIDDriver const &":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_First(self)

    def ChangeFirst(self) -> "TFunction_DataMapOfGUIDDriver &":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_ChangeFirst(self)

    def Last(self) -> "TFunction_DataMapOfGUIDDriver const &":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Last(self)

    def ChangeLast(self) -> "TFunction_DataMapOfGUIDDriver &":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_ChangeLast(self)

    def Value(self, theIndex: "Standard_Integer const") -> "TFunction_DataMapOfGUIDDriver const &":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Value(self, theIndex)

    def ChangeValue(self, theIndex: "Standard_Integer const") -> "TFunction_DataMapOfGUIDDriver &":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_ChangeValue(self, theIndex)

    def __call__(self, *args) -> "TFunction_DataMapOfGUIDDriver &":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver___call__(self, *args)

    def SetValue(self, theIndex: "Standard_Integer const", theItem: "TFunction_DataMapOfGUIDDriver") -> "void":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_SetValue(self, theIndex, theItem)

    def Resize(self, theLower: "Standard_Integer const", theUpper: "Standard_Integer const", theToCopyData: "Standard_Boolean const") -> "void":
        return _TFunction.TFunction_Array1OfDataMapOfGUIDDriver_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _TFunction.delete_TFunction_Array1OfDataMapOfGUIDDriver

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register TFunction_Array1OfDataMapOfGUIDDriver in _TFunction:
_TFunction.TFunction_Array1OfDataMapOfGUIDDriver_swigregister(TFunction_Array1OfDataMapOfGUIDDriver)

class TFunction_DataMapOfGUIDDriver(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_DataMap< Standard_GUID,opencascade::handle< TFunction_Driver >,Standard_GUID >::iterator":
        return _TFunction.TFunction_DataMapOfGUIDDriver_begin(self)

    def end(self) -> "NCollection_DataMap< Standard_GUID,opencascade::handle< TFunction_Driver >,Standard_GUID >::iterator":
        return _TFunction.TFunction_DataMapOfGUIDDriver_end(self)

    def cbegin(self) -> "NCollection_DataMap< Standard_GUID,opencascade::handle< TFunction_Driver >,Standard_GUID >::const_iterator":
        return _TFunction.TFunction_DataMapOfGUIDDriver_cbegin(self)

    def cend(self) -> "NCollection_DataMap< Standard_GUID,opencascade::handle< TFunction_Driver >,Standard_GUID >::const_iterator":
        return _TFunction.TFunction_DataMapOfGUIDDriver_cend(self)

    def __init__(self, *args):
        _TFunction.TFunction_DataMapOfGUIDDriver_swiginit(self, _TFunction.new_TFunction_DataMapOfGUIDDriver(*args))

    def Exchange(self, theOther: "TFunction_DataMapOfGUIDDriver") -> "void":
        return _TFunction.TFunction_DataMapOfGUIDDriver_Exchange(self, theOther)

    def Assign(self, theOther: "TFunction_DataMapOfGUIDDriver") -> "NCollection_DataMap< Standard_GUID,opencascade::handle< TFunction_Driver >,Standard_GUID > &":
        return _TFunction.TFunction_DataMapOfGUIDDriver_Assign(self, theOther)

    def Set(self, theOther: "TFunction_DataMapOfGUIDDriver") -> "NCollection_DataMap< Standard_GUID,opencascade::handle< TFunction_Driver >,Standard_GUID > &":
        return _TFunction.TFunction_DataMapOfGUIDDriver_Set(self, theOther)

    def ReSize(self, N: "Standard_Integer const") -> "void":
        return _TFunction.TFunction_DataMapOfGUIDDriver_ReSize(self, N)

    def Bind(self, theKey: "Standard_GUID", theItem: "opencascade::handle< TFunction_Driver > const &") -> "Standard_Boolean":
        return _TFunction.TFunction_DataMapOfGUIDDriver_Bind(self, theKey, theItem)

    def Bound(self, theKey: "Standard_GUID", theItem: "opencascade::handle< TFunction_Driver > const &") -> "opencascade::handle< TFunction_Driver > *":
        return _TFunction.TFunction_DataMapOfGUIDDriver_Bound(self, theKey, theItem)

    def IsBound(self, theKey: "Standard_GUID") -> "Standard_Boolean":
        return _TFunction.TFunction_DataMapOfGUIDDriver_IsBound(self, theKey)

    def UnBind(self, theKey: "Standard_GUID") -> "Standard_Boolean":
        return _TFunction.TFunction_DataMapOfGUIDDriver_UnBind(self, theKey)

    def Seek(self, theKey: "Standard_GUID") -> "opencascade::handle< TFunction_Driver > const *":
        return _TFunction.TFunction_DataMapOfGUIDDriver_Seek(self, theKey)

    def Find(self, *args) -> "Standard_Boolean":
        return _TFunction.TFunction_DataMapOfGUIDDriver_Find(self, *args)

    def ChangeSeek(self, theKey: "Standard_GUID") -> "opencascade::handle< TFunction_Driver > *":
        return _TFunction.TFunction_DataMapOfGUIDDriver_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey: "Standard_GUID") -> "opencascade::handle< TFunction_Driver > &":
        return _TFunction.TFunction_DataMapOfGUIDDriver_ChangeFind(self, theKey)

    def __call__(self, *args) -> "opencascade::handle< TFunction_Driver > &":
        return _TFunction.TFunction_DataMapOfGUIDDriver___call__(self, *args)

    def Clear(self, *args) -> "void":
        return _TFunction.TFunction_DataMapOfGUIDDriver_Clear(self, *args)
    __swig_destroy__ = _TFunction.delete_TFunction_DataMapOfGUIDDriver

    def Size(self) -> "Standard_Integer":
        return _TFunction.TFunction_DataMapOfGUIDDriver_Size(self)

# Register TFunction_DataMapOfGUIDDriver in _TFunction:
_TFunction.TFunction_DataMapOfGUIDDriver_swigregister(TFunction_DataMapOfGUIDDriver)

class TFunction_DataMapOfLabelListOfLabel(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self) -> "NCollection_DataMap< TDF_Label,NCollection_List< TDF_Label >,TDF_LabelMapHasher >::iterator":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_begin(self)

    def end(self) -> "NCollection_DataMap< TDF_Label,NCollection_List< TDF_Label >,TDF_LabelMapHasher >::iterator":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_end(self)

    def cbegin(self) -> "NCollection_DataMap< TDF_Label,NCollection_List< TDF_Label >,TDF_LabelMapHasher >::const_iterator":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_cbegin(self)

    def cend(self) -> "NCollection_DataMap< TDF_Label,NCollection_List< TDF_Label >,TDF_LabelMapHasher >::const_iterator":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_cend(self)

    def __init__(self, *args):
        _TFunction.TFunction_DataMapOfLabelListOfLabel_swiginit(self, _TFunction.new_TFunction_DataMapOfLabelListOfLabel(*args))

    def Exchange(self, theOther: "TFunction_DataMapOfLabelListOfLabel") -> "void":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_Exchange(self, theOther)

    def Assign(self, theOther: "TFunction_DataMapOfLabelListOfLabel") -> "NCollection_DataMap< TDF_Label,TDF_LabelList,TDF_LabelMapHasher > &":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_Assign(self, theOther)

    def Set(self, theOther: "TFunction_DataMapOfLabelListOfLabel") -> "NCollection_DataMap< TDF_Label,TDF_LabelList,TDF_LabelMapHasher > &":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_Set(self, theOther)

    def ReSize(self, N: "Standard_Integer const") -> "void":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_ReSize(self, N)

    def Bind(self, theKey: "TDF_Label", theItem: "TDF_LabelList") -> "Standard_Boolean":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_Bind(self, theKey, theItem)

    def Bound(self, theKey: "TDF_Label", theItem: "TDF_LabelList") -> "NCollection_List< TDF_Label > *":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_Bound(self, theKey, theItem)

    def IsBound(self, theKey: "TDF_Label") -> "Standard_Boolean":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_IsBound(self, theKey)

    def UnBind(self, theKey: "TDF_Label") -> "Standard_Boolean":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_UnBind(self, theKey)

    def Seek(self, theKey: "TDF_Label") -> "NCollection_List< TDF_Label > const *":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_Seek(self, theKey)

    def Find(self, *args) -> "Standard_Boolean":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_Find(self, *args)

    def ChangeSeek(self, theKey: "TDF_Label") -> "NCollection_List< TDF_Label > *":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_ChangeSeek(self, theKey)

    def ChangeFind(self, theKey: "TDF_Label") -> "NCollection_List< TDF_Label > &":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_ChangeFind(self, theKey)

    def __call__(self, *args) -> "NCollection_List< TDF_Label > &":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel___call__(self, *args)

    def Clear(self, *args) -> "void":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_Clear(self, *args)
    __swig_destroy__ = _TFunction.delete_TFunction_DataMapOfLabelListOfLabel

    def Size(self) -> "Standard_Integer":
        return _TFunction.TFunction_DataMapOfLabelListOfLabel_Size(self)

# Register TFunction_DataMapOfLabelListOfLabel in _TFunction:
_TFunction.TFunction_DataMapOfLabelListOfLabel_swigregister(TFunction_DataMapOfLabelListOfLabel)

class TFunction_DoubleMapOfIntegerLabel(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _TFunction.TFunction_DoubleMapOfIntegerLabel_swiginit(self, _TFunction.new_TFunction_DoubleMapOfIntegerLabel(*args))

    def Exchange(self, theOther: "TFunction_DoubleMapOfIntegerLabel") -> "void":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_Exchange(self, theOther)

    def Assign(self, theOther: "TFunction_DoubleMapOfIntegerLabel") -> "NCollection_DoubleMap< Standard_Integer,TDF_Label,TColStd_MapIntegerHasher,TDF_LabelMapHasher > &":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_Assign(self, theOther)

    def Set(self, theOther: "TFunction_DoubleMapOfIntegerLabel") -> "NCollection_DoubleMap< Standard_Integer,TDF_Label,TColStd_MapIntegerHasher,TDF_LabelMapHasher > &":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_Set(self, theOther)

    def ReSize(self, N: "Standard_Integer const") -> "void":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_ReSize(self, N)

    def Bind(self, theKey1: "int const &", theKey2: "TDF_Label") -> "void":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_Bind(self, theKey1, theKey2)

    def AreBound(self, theKey1: "int const &", theKey2: "TDF_Label") -> "Standard_Boolean":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_AreBound(self, theKey1, theKey2)

    def IsBound1(self, theKey1: "int const &") -> "Standard_Boolean":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_IsBound1(self, theKey1)

    def IsBound2(self, theKey2: "TDF_Label") -> "Standard_Boolean":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_IsBound2(self, theKey2)

    def UnBind1(self, theKey1: "int const &") -> "Standard_Boolean":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_UnBind1(self, theKey1)

    def UnBind2(self, theKey2: "TDF_Label") -> "Standard_Boolean":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_UnBind2(self, theKey2)

    def Find1(self, *args) -> "Standard_Boolean":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_Find1(self, *args)

    def Seek1(self, theKey1: "int const &") -> "TDF_Label const *":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_Seek1(self, theKey1)

    def Find2(self, *args) -> "Standard_Boolean":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_Find2(self, *args)

    def Seek2(self, theKey2: "TDF_Label") -> "int const *":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_Seek2(self, theKey2)

    def Clear(self, *args) -> "void":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_Clear(self, *args)
    __swig_destroy__ = _TFunction.delete_TFunction_DoubleMapOfIntegerLabel

    def Size(self) -> "Standard_Integer":
        return _TFunction.TFunction_DoubleMapOfIntegerLabel_Size(self)

# Register TFunction_DoubleMapOfIntegerLabel in _TFunction:
_TFunction.TFunction_DoubleMapOfIntegerLabel_swigregister(TFunction_DoubleMapOfIntegerLabel)

class TFunction_Driver(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Arguments(self, *args) -> "void":
        r"""
        The method fills-in the list by labels, where the arguments of the function are located.

        Parameters
        ----------
        args: TDF_LabelList

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Driver_Arguments(self, *args)

    def Execute(self, *args) -> "Standard_Integer":
        r"""
        Executes the function in this function driver and puts the impacted labels in the logbook log. arguments & results of functions ================================.

        Parameters
        ----------
        log: TFunction_Logbook

        Returns
        -------
        int

        """
        return _TFunction.TFunction_Driver_Execute(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Initializes the label l for this function prior to its execution.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Driver_Init(self, *args)

    def Label(self, *args) -> "TDF_Label":
        r"""
        Returns the label of the driver for this function.

        Returns
        -------
        TDF_Label

        """
        return _TFunction.TFunction_Driver_Label(self, *args)

    def MustExecute(self, *args) -> "Standard_Boolean":
        r"""
        Analyzes the labels in the logbook log. returns true if attributes have been modified. if the function label itself has been modified, the function must be executed.

        Parameters
        ----------
        log: TFunction_Logbook

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_Driver_MustExecute(self, *args)

    def Results(self, *args) -> "void":
        r"""
        The method fills-in the list by labels, where the results of the function are located.

        Parameters
        ----------
        res: TDF_LabelList

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Driver_Results(self, *args)

    def Validate(self, *args) -> "void":
        r"""
        Validates labels of a function in <log>. this function is the one initialized in this function driver. warning in regeneration mode, the solver must call this method even if the function is not executed. execution of function =====================.

        Parameters
        ----------
        log: TFunction_Logbook

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Driver_Validate(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TFunction_Driver_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TFunction.delete_TFunction_Driver

# Register TFunction_Driver in _TFunction:
_TFunction.TFunction_Driver_swigregister(TFunction_Driver)

class TFunction_DriverTable(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Default constructor.

        Returns
        -------
        None

        """
        _TFunction.TFunction_DriverTable_swiginit(self, _TFunction.new_TFunction_DriverTable(*args))

    def AddDriver(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the driver has been added successfully to the driver table.

        Parameters
        ----------
        guid: Standard_GUID
        driver: TFunction_Driver
        thread: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_DriverTable_AddDriver(self, *args)

    def Clear(self, *args) -> "void":
        r"""
        Removes all drivers. returns true if the driver has been removed successfully.

        Returns
        -------
        None

        """
        return _TFunction.TFunction_DriverTable_Clear(self, *args)

    def DumpToString(self) -> "std::string":
        r"""DumpToString(TFunction_DriverTable self) -> std::string"""
        return _TFunction.TFunction_DriverTable_DumpToString(self)

    def FindDriver(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the driver was found.

        Parameters
        ----------
        guid: Standard_GUID
        driver: TFunction_Driver
        thread: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_DriverTable_FindDriver(self, *args)

    @staticmethod
    def Get(*args) -> "opencascade::handle< TFunction_DriverTable >":
        r"""
        Returns the driver table. if a driver does not exist, creates it.

        Returns
        -------
        opencascade::handle<TFunction_DriverTable>

        """
        return _TFunction.TFunction_DriverTable_Get(*args)

    def HasDriver(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the driver exists in the driver table.

        Parameters
        ----------
        guid: Standard_GUID
        thread: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_DriverTable_HasDriver(self, *args)

    def RemoveDriver(self, *args) -> "Standard_Boolean":
        r"""
        Removes a driver with the given guid. returns true if the driver has been removed successfully.

        Parameters
        ----------
        guid: Standard_GUID
        thread: int,optional
        	default value is 0

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_DriverTable_RemoveDriver(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TFunction_DriverTable_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TFunction.delete_TFunction_DriverTable

# Register TFunction_DriverTable in _TFunction:
_TFunction.TFunction_DriverTable_swigregister(TFunction_DriverTable)

def TFunction_DriverTable_Get(*args) -> "opencascade::handle< TFunction_DriverTable >":
    r"""
    Returns the driver table. if a driver does not exist, creates it.

    Returns
    -------
    opencascade::handle<TFunction_DriverTable>

    """
    return _TFunction.TFunction_DriverTable_Get(*args)

class TFunction_Function(OCC.Core.TDF.TDF_Attribute):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _TFunction.TFunction_Function_swiginit(self, _TFunction.new_TFunction_Function(*args))

    def DumpToString(self) -> "std::string":
        r"""DumpToString(TFunction_Function self) -> std::string"""
        return _TFunction.TFunction_Function_DumpToString(self)

    def DumpJsonToString(self, depth: "int"=-1) -> "std::string":
        r"""DumpJsonToString(TFunction_Function self, int depth=-1) -> std::string"""
        return _TFunction.TFunction_Function_DumpJsonToString(self, depth)

    def Failed(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the execution failed.

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_Function_Failed(self, *args)

    def GetDriverGUID(self, *args) -> "Standard_GUID const &":
        r"""
        Returns the guid for this function's driver.

        Returns
        -------
        Standard_GUID

        """
        return _TFunction.TFunction_Function_GetDriverGUID(self, *args)

    def GetFailure(self, *args) -> "Standard_Integer":
        r"""
        Returns an index of failure if the execution of this function failed. if this integer value is 0, no failure has occurred. implementation of attribute methods: ===================================.

        Returns
        -------
        int

        """
        return _TFunction.TFunction_Function_GetFailure(self, *args)

    @staticmethod
    def GetID(*args) -> "Standard_GUID const &":
        r"""
        Returns the guid for functions. returns a function found on the label. instance methods: ================.

        Returns
        -------
        Standard_GUID

        """
        return _TFunction.TFunction_Function_GetID(*args)

    @staticmethod
    def Set(*args) -> "opencascade::handle< TFunction_Function >":
        r"""
        Static methods: ============== finds or creates a function attribute on the label <l>. returns the function attribute.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        opencascade::handle<TFunction_Function>
        Finds or creates a function attribute on the label <l>. sets a driver id to the function. returns the function attribute.

        Parameters
        ----------
        L: TDF_Label
        DriverID: Standard_GUID

        Returns
        -------
        opencascade::handle<TFunction_Function>

        """
        return _TFunction.TFunction_Function_Set(*args)

    def SetDriverGUID(self, *args) -> "void":
        r"""
        Sets the driver for this function as that identified by the guid guid.

        Parameters
        ----------
        guid: Standard_GUID

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Function_SetDriverGUID(self, *args)

    def SetFailure(self, *args) -> "void":
        r"""
        Sets the failed index.

        Parameters
        ----------
        mode: int,optional
        	default value is 0

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Function_SetFailure(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TFunction_Function_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TFunction.delete_TFunction_Function

# Register TFunction_Function in _TFunction:
_TFunction.TFunction_Function_swigregister(TFunction_Function)

def TFunction_Function_GetID(*args) -> "Standard_GUID const &":
    r"""
    Returns the guid for functions. returns a function found on the label. instance methods: ================.

    Returns
    -------
    Standard_GUID

    """
    return _TFunction.TFunction_Function_GetID(*args)

def TFunction_Function_Set(*args) -> "opencascade::handle< TFunction_Function >":
    r"""
    Static methods: ============== finds or creates a function attribute on the label <l>. returns the function attribute.

    Parameters
    ----------
    L: TDF_Label

    Returns
    -------
    opencascade::handle<TFunction_Function>
    Finds or creates a function attribute on the label <l>. sets a driver id to the function. returns the function attribute.

    Parameters
    ----------
    L: TDF_Label
    DriverID: Standard_GUID

    Returns
    -------
    opencascade::handle<TFunction_Function>

    """
    return _TFunction.TFunction_Function_Set(*args)

class TFunction_GraphNode(OCC.Core.TDF.TDF_Attribute):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _TFunction.TFunction_GraphNode_swiginit(self, _TFunction.new_TFunction_GraphNode(*args))

    def AddNext(self, *args) -> "Standard_Boolean":
        r"""
        Defines a reference to the function as a next one.

        Parameters
        ----------
        funcID: int

        Returns
        -------
        bool
        Defines a reference to the function as a next one.

        Parameters
        ----------
        func: TDF_Label

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_GraphNode_AddNext(self, *args)

    def AddPrevious(self, *args) -> "Standard_Boolean":
        r"""
        Defines a reference to the function as a previous one.

        Parameters
        ----------
        funcID: int

        Returns
        -------
        bool
        Defines a reference to the function as a previous one.

        Parameters
        ----------
        func: TDF_Label

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_GraphNode_AddPrevious(self, *args)

    def DumpToString(self) -> "std::string":
        r"""DumpToString(TFunction_GraphNode self) -> std::string"""
        return _TFunction.TFunction_GraphNode_DumpToString(self)

    @staticmethod
    def GetID(*args) -> "Standard_GUID const &":
        r"""
        Returns the guid for graphnode attribute. instant methods =============== constructor (empty).

        Returns
        -------
        Standard_GUID

        """
        return _TFunction.TFunction_GraphNode_GetID(*args)

    def GetNext(self, *args) -> "TColStd_MapOfInteger const &":
        r"""
        Returns a map of next functions.

        Returns
        -------
        TColStd_MapOfInteger

        """
        return _TFunction.TFunction_GraphNode_GetNext(self, *args)

    def GetPrevious(self, *args) -> "TColStd_MapOfInteger const &":
        r"""
        Returns a map of previous functions.

        Returns
        -------
        TColStd_MapOfInteger

        """
        return _TFunction.TFunction_GraphNode_GetPrevious(self, *args)

    def GetStatus(self, *args) -> "TFunction_ExecutionStatus":
        r"""
        Returns the execution status of the function.

        Returns
        -------
        TFunction_ExecutionStatus

        """
        return _TFunction.TFunction_GraphNode_GetStatus(self, *args)

    def RemoveAllNext(self, *args) -> "void":
        r"""
        Clears a map of next functions.

        Returns
        -------
        None

        """
        return _TFunction.TFunction_GraphNode_RemoveAllNext(self, *args)

    def RemoveAllPrevious(self, *args) -> "void":
        r"""
        Clears a map of previous functions.

        Returns
        -------
        None

        """
        return _TFunction.TFunction_GraphNode_RemoveAllPrevious(self, *args)

    def RemoveNext(self, *args) -> "Standard_Boolean":
        r"""
        Removes a reference to the function as a next one.

        Parameters
        ----------
        funcID: int

        Returns
        -------
        bool
        Removes a reference to the function as a next one.

        Parameters
        ----------
        func: TDF_Label

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_GraphNode_RemoveNext(self, *args)

    def RemovePrevious(self, *args) -> "Standard_Boolean":
        r"""
        Removes a reference to the function as a previous one.

        Parameters
        ----------
        funcID: int

        Returns
        -------
        bool
        Removes a reference to the function as a previous one.

        Parameters
        ----------
        func: TDF_Label

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_GraphNode_RemovePrevious(self, *args)

    @staticmethod
    def Set(*args) -> "opencascade::handle< TFunction_GraphNode >":
        r"""
        Static methods ============== finds or creates a graph node attribute at the label <l>. returns the attribute.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        opencascade::handle<TFunction_GraphNode>

        """
        return _TFunction.TFunction_GraphNode_Set(*args)

    def SetStatus(self, *args) -> "void":
        r"""
        Defines an execution status for a function. implementation of attribute methods ===================================.

        Parameters
        ----------
        status: TFunction_ExecutionStatus

        Returns
        -------
        None

        """
        return _TFunction.TFunction_GraphNode_SetStatus(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TFunction_GraphNode_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TFunction.delete_TFunction_GraphNode

# Register TFunction_GraphNode in _TFunction:
_TFunction.TFunction_GraphNode_swigregister(TFunction_GraphNode)

def TFunction_GraphNode_GetID(*args) -> "Standard_GUID const &":
    r"""
    Returns the guid for graphnode attribute. instant methods =============== constructor (empty).

    Returns
    -------
    Standard_GUID

    """
    return _TFunction.TFunction_GraphNode_GetID(*args)

def TFunction_GraphNode_Set(*args) -> "opencascade::handle< TFunction_GraphNode >":
    r"""
    Static methods ============== finds or creates a graph node attribute at the label <l>. returns the attribute.

    Parameters
    ----------
    L: TDF_Label

    Returns
    -------
    opencascade::handle<TFunction_GraphNode>

    """
    return _TFunction.TFunction_GraphNode_Set(*args)

class TFunction_IFunction(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None
        A constructor. initializes the interface by the label of function.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        None

        """
        _TFunction.TFunction_IFunction_swiginit(self, _TFunction.new_TFunction_IFunction(*args))

    def Arguments(self, *args) -> "void":
        r"""
        The method fills-in the list by labels, where the arguments of the function are located.

        Parameters
        ----------
        args: TDF_LabelList

        Returns
        -------
        None

        """
        return _TFunction.TFunction_IFunction_Arguments(self, *args)

    @staticmethod
    def DeleteFunction(*args) -> "Standard_Boolean":
        r"""
        Deletes a function attached to a label <l>. it deletes a tfunction_function attribute and a tfunction_graphnode. it deletes the functions from the scope of function of this document.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_IFunction_DeleteFunction(*args)

    def GetAllFunctions(self, *args) -> "TFunction_DoubleMapOfIntegerLabel const &":
        r"""
        Returns the scope of all functions.

        Returns
        -------
        TFunction_DoubleMapOfIntegerLabel

        """
        return _TFunction.TFunction_IFunction_GetAllFunctions(self, *args)

    def GetDriver(self, *args) -> "opencascade::handle< TFunction_Driver >":
        r"""
        Returns a driver of the function.

        Parameters
        ----------
        thread: int,optional
        	default value is 0

        Returns
        -------
        opencascade::handle<TFunction_Driver>

        """
        return _TFunction.TFunction_IFunction_GetDriver(self, *args)

    def GetGraphNode(self, *args) -> "opencascade::handle< TFunction_GraphNode >":
        r"""
        Returns a graph node of the function.

        Returns
        -------
        opencascade::handle<TFunction_GraphNode>

        """
        return _TFunction.TFunction_IFunction_GetGraphNode(self, *args)

    def GetLogbook(self, *args) -> "opencascade::handle< TFunction_Logbook >":
        r"""
        Returns the logbook - keeper of modifications.

        Returns
        -------
        opencascade::handle<TFunction_Logbook>

        """
        return _TFunction.TFunction_IFunction_GetLogbook(self, *args)

    def GetNext(self, *args) -> "void":
        r"""
        Returns a list of next functions.

        Parameters
        ----------
        prev: TDF_LabelList

        Returns
        -------
        None

        """
        return _TFunction.TFunction_IFunction_GetNext(self, *args)

    def GetPrevious(self, *args) -> "void":
        r"""
        Returns a list of previous functions.

        Parameters
        ----------
        prev: TDF_LabelList

        Returns
        -------
        None

        """
        return _TFunction.TFunction_IFunction_GetPrevious(self, *args)

    def GetStatus(self, *args) -> "TFunction_ExecutionStatus":
        r"""
        Returns the execution status of the function.

        Returns
        -------
        TFunction_ExecutionStatus

        """
        return _TFunction.TFunction_IFunction_GetStatus(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Initializes the interface by the label of function.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        None

        """
        return _TFunction.TFunction_IFunction_Init(self, *args)

    def Label(self, *args) -> "TDF_Label const &":
        r"""
        Returns a label of the function.

        Returns
        -------
        TDF_Label

        """
        return _TFunction.TFunction_IFunction_Label(self, *args)

    @staticmethod
    def NewFunction(*args) -> "Standard_Boolean":
        r"""
        Sets a new function attached to a label <l> with <id>. it creates a new tfunction_function attribute initialized by the <id>, a new tfunction_graphnode with an empty list of dependencies and the status equal to tfunction_es_wrongdefinition. it registers the function in the scope of functions for this document.

        Parameters
        ----------
        L: TDF_Label
        ID: Standard_GUID

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_IFunction_NewFunction(*args)

    def Results(self, *args) -> "void":
        r"""
        The method fills-in the list by labels, where the results of the function are located.

        Parameters
        ----------
        res: TDF_LabelList

        Returns
        -------
        None

        """
        return _TFunction.TFunction_IFunction_Results(self, *args)

    def SetStatus(self, *args) -> "void":
        r"""
        Defines an execution status for a function.

        Parameters
        ----------
        status: TFunction_ExecutionStatus

        Returns
        -------
        None

        """
        return _TFunction.TFunction_IFunction_SetStatus(self, *args)

    def UpdateDependencies(self, *args) -> "Standard_Boolean":
        r"""
        Updates dependencies for all functions of the scope. it returns false in case of an error. an empty constructor.

        Parameters
        ----------
        Access: TDF_Label

        Returns
        -------
        bool
        Updates the dependencies of this function only.

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_IFunction_UpdateDependencies(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TFunction.delete_TFunction_IFunction

# Register TFunction_IFunction in _TFunction:
_TFunction.TFunction_IFunction_swigregister(TFunction_IFunction)

def TFunction_IFunction_DeleteFunction(*args) -> "Standard_Boolean":
    r"""
    Deletes a function attached to a label <l>. it deletes a tfunction_function attribute and a tfunction_graphnode. it deletes the functions from the scope of function of this document.

    Parameters
    ----------
    L: TDF_Label

    Returns
    -------
    bool

    """
    return _TFunction.TFunction_IFunction_DeleteFunction(*args)

def TFunction_IFunction_NewFunction(*args) -> "Standard_Boolean":
    r"""
    Sets a new function attached to a label <l> with <id>. it creates a new tfunction_function attribute initialized by the <id>, a new tfunction_graphnode with an empty list of dependencies and the status equal to tfunction_es_wrongdefinition. it registers the function in the scope of functions for this document.

    Parameters
    ----------
    L: TDF_Label
    ID: Standard_GUID

    Returns
    -------
    bool

    """
    return _TFunction.TFunction_IFunction_NewFunction(*args)

class TFunction_Iterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        An empty constructor.

        Returns
        -------
        None
        A constructor. initializes the iterator.

        Parameters
        ----------
        Access: TDF_Label

        Returns
        -------
        None

        """
        _TFunction.TFunction_Iterator_swiginit(self, _TFunction.new_TFunction_Iterator(*args))

    def Current(self, *args) -> "TDF_LabelList const &":
        r"""
        Returns the current list of functions. if the iterator uses the execution status, the returned list contains only the functions with 'not executed' status.

        Returns
        -------
        TDF_LabelList

        """
        return _TFunction.TFunction_Iterator_Current(self, *args)

    def DumpToString(self) -> "std::string":
        r"""DumpToString(TFunction_Iterator self) -> std::string"""
        return _TFunction.TFunction_Iterator_DumpToString(self)

    def GetMaxNbThreads(self, *args) -> "Standard_Integer":
        r"""
        Analyses the graph of dependencies and returns maximum number of threads may be used to calculate the model.

        Returns
        -------
        int

        """
        return _TFunction.TFunction_Iterator_GetMaxNbThreads(self, *args)

    def GetStatus(self, *args) -> "TFunction_ExecutionStatus":
        r"""
        A help-function aimed to help the user to check the status of retrurned function. it calls tfunction_graphnode::getstatus() inside.

        Parameters
        ----------
        func: TDF_Label

        Returns
        -------
        TFunction_ExecutionStatus

        """
        return _TFunction.TFunction_Iterator_GetStatus(self, *args)

    def GetUsageOfExecutionStatus(self, *args) -> "Standard_Boolean":
        r"""
        Returns usage of execution status by the iterator.

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_Iterator_GetUsageOfExecutionStatus(self, *args)

    def Init(self, *args) -> "void":
        r"""
        Initializes the iterator.

        Parameters
        ----------
        Access: TDF_Label

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Iterator_Init(self, *args)

    def More(self, *args) -> "Standard_Boolean":
        r"""
        Returns false if the graph of functions is fully iterated.

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_Iterator_More(self, *args)

    def Next(self, *args) -> "void":
        r"""
        Switches the iterator to the next list of current functions.

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Iterator_Next(self, *args)

    def SetStatus(self, *args) -> "void":
        r"""
        A help-function aimed to help the user to change the execution status of a function. it calls tfunction_graphnode::setstatus() inside.

        Parameters
        ----------
        func: TDF_Label
        status: TFunction_ExecutionStatus

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Iterator_SetStatus(self, *args)

    def SetUsageOfExecutionStatus(self, *args) -> "void":
        r"""
        Defines the mode of iteration - usage or not of the execution status. if the iterator takes into account the execution status, the method ::current() returns only 'not executed' functions while their status is not changed. if the iterator ignores the execution status, the method ::current() returns the functions following their dependencies and ignoring the execution status.

        Parameters
        ----------
        usage: bool

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Iterator_SetUsageOfExecutionStatus(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TFunction.delete_TFunction_Iterator

# Register TFunction_Iterator in _TFunction:
_TFunction.TFunction_Iterator_swigregister(TFunction_Iterator)

class TFunction_Logbook(OCC.Core.TDF.TDF_Attribute):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Constructor (empty).

        Returns
        -------
        None

        """
        _TFunction.TFunction_Logbook_swiginit(self, _TFunction.new_TFunction_Logbook(*args))

    def Clear(self, *args) -> "void":
        r"""
        Clears this logbook to its default, empty state.

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Logbook_Clear(self, *args)

    def Done(self, *args) -> "void":
        r"""
        Sets status of execution.

        Parameters
        ----------
        status: bool

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Logbook_Done(self, *args)

    def DumpToString(self) -> "std::string":
        r"""DumpToString(TFunction_Logbook self) -> std::string"""
        return _TFunction.TFunction_Logbook_DumpToString(self)

    @staticmethod
    def GetID(*args) -> "Standard_GUID const &":
        r"""
        Returns the guid for logbook attribute.

        Returns
        -------
        Standard_GUID

        """
        return _TFunction.TFunction_Logbook_GetID(*args)

    def GetImpacted(self, *args) -> "TDF_LabelMap const &":
        r"""
        Returns the map of impacted labels contained in this logbook.

        Returns
        -------
        TDF_LabelMap

        """
        return _TFunction.TFunction_Logbook_GetImpacted(self, *args)

    def GetTouched(self, *args) -> "TDF_LabelMap const &":
        r"""
        Returns the map of touched labels in this logbook. a touched label is the one modified by the end user.

        Returns
        -------
        TDF_LabelMap

        """
        return _TFunction.TFunction_Logbook_GetTouched(self, *args)

    def GetValid(self, *args) -> "void":
        r"""
        Returns the map of valid labels in this logbook.

        Returns
        -------
        TDF_LabelMap
        No available documentation.

        Parameters
        ----------
        Ls: TDF_LabelMap

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Logbook_GetValid(self, *args)

    def IsDone(self, *args) -> "Standard_Boolean":
        r"""
        Returns status of execution.

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_Logbook_IsDone(self, *args)

    def IsEmpty(self, *args) -> "Standard_Boolean":
        r"""
        No available documentation.

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_Logbook_IsEmpty(self, *args)

    def IsModified(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the label l is touched or impacted. this method is called by <tfunction_functiondriver::mustexecute>. if <withchildren> is set to true, the method checks all the sublabels of <l> too.

        Parameters
        ----------
        L: TDF_Label
        WithChildren: bool,optional
        	default value is Standard_False

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_Logbook_IsModified(self, *args)

    @staticmethod
    def Set(*args) -> "opencascade::handle< TFunction_Logbook >":
        r"""
        Finds or creates a tfunction_logbook attribute at the root label accessed by <access>. returns the attribute.

        Parameters
        ----------
        Access: TDF_Label

        Returns
        -------
        opencascade::handle<TFunction_Logbook>

        """
        return _TFunction.TFunction_Logbook_Set(*args)

    def SetImpacted(self, *args) -> "void":
        r"""
        Sets the label l as an impacted label in this logbook. this method is called by execution of the function driver.

        Parameters
        ----------
        L: TDF_Label
        WithChildren: bool,optional
        	default value is Standard_False

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Logbook_SetImpacted(self, *args)

    def SetTouched(self, *args) -> "void":
        r"""
        Sets the label l as a touched label in this logbook. in other words, l is understood to have been modified by the end user.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Logbook_SetTouched(self, *args)

    def SetValid(self, *args) -> "void":
        r"""
        Sets the label l as a valid label in this logbook.

        Parameters
        ----------
        L: TDF_Label
        WithChildren: bool,optional
        	default value is Standard_False

        Returns
        -------
        None
        No available documentation.

        Parameters
        ----------
        Ls: TDF_LabelMap

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Logbook_SetValid(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TFunction_Logbook_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TFunction.delete_TFunction_Logbook

# Register TFunction_Logbook in _TFunction:
_TFunction.TFunction_Logbook_swigregister(TFunction_Logbook)

def TFunction_Logbook_GetID(*args) -> "Standard_GUID const &":
    r"""
    Returns the guid for logbook attribute.

    Returns
    -------
    Standard_GUID

    """
    return _TFunction.TFunction_Logbook_GetID(*args)

def TFunction_Logbook_Set(*args) -> "opencascade::handle< TFunction_Logbook >":
    r"""
    Finds or creates a tfunction_logbook attribute at the root label accessed by <access>. returns the attribute.

    Parameters
    ----------
    Access: TDF_Label

    Returns
    -------
    opencascade::handle<TFunction_Logbook>

    """
    return _TFunction.TFunction_Logbook_Set(*args)

class TFunction_Scope(OCC.Core.TDF.TDF_Attribute):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        No available documentation.

        Returns
        -------
        None

        """
        _TFunction.TFunction_Scope_swiginit(self, _TFunction.new_TFunction_Scope(*args))

    def AddFunction(self, *args) -> "Standard_Boolean":
        r"""
        Adds a function to the scope of functions.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_Scope_AddFunction(self, *args)

    def ChangeFunctions(self, *args) -> "TFunction_DoubleMapOfIntegerLabel &":
        r"""
        Returns the scope of functions for modification. warning: don't use this method if you are not sure what you do!.

        Returns
        -------
        TFunction_DoubleMapOfIntegerLabel

        """
        return _TFunction.TFunction_Scope_ChangeFunctions(self, *args)

    def DumpToString(self) -> "std::string":
        r"""DumpToString(TFunction_Scope self) -> std::string"""
        return _TFunction.TFunction_Scope_DumpToString(self)

    def GetFreeID(self, *args) -> "Standard_Integer":
        r"""
        No available documentation.

        Returns
        -------
        int

        """
        return _TFunction.TFunction_Scope_GetFreeID(self, *args)

    def GetFunction(self, *args) -> "TDF_Label const &":
        r"""
        Returns an id of the function.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        int
        Returns the label of the function with this id.

        Parameters
        ----------
        ID: int

        Returns
        -------
        TDF_Label

        """
        return _TFunction.TFunction_Scope_GetFunction(self, *args)

    def GetFunctions(self, *args) -> "TFunction_DoubleMapOfIntegerLabel const &":
        r"""
        Returns the scope of functions.

        Returns
        -------
        TFunction_DoubleMapOfIntegerLabel

        """
        return _TFunction.TFunction_Scope_GetFunctions(self, *args)

    @staticmethod
    def GetID(*args) -> "Standard_GUID const &":
        r"""
        Returns the guid for scope attribute. instant methods =============== constructor (empty).

        Returns
        -------
        Standard_GUID

        """
        return _TFunction.TFunction_Scope_GetID(*args)

    def GetLogbook(self, *args) -> "opencascade::handle< TFunction_Logbook >":
        r"""
        Returns the logbook used in tfunction_driver methods. implementation of attribute methods ===================================.

        Returns
        -------
        opencascade::handle<TFunction_Logbook>

        """
        return _TFunction.TFunction_Scope_GetLogbook(self, *args)

    def HasFunction(self, *args) -> "Standard_Boolean":
        r"""
        Returns true if the function exists with such an id.

        Parameters
        ----------
        ID: int

        Returns
        -------
        bool
        Returns true if the label contains a function of this scope.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_Scope_HasFunction(self, *args)

    def RemoveAllFunctions(self, *args) -> "void":
        r"""
        Removes all functions from the scope of functions.

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Scope_RemoveAllFunctions(self, *args)

    def RemoveFunction(self, *args) -> "Standard_Boolean":
        r"""
        Removes a function from the scope of functions.

        Parameters
        ----------
        L: TDF_Label

        Returns
        -------
        bool
        Removes a function from the scope of functions.

        Parameters
        ----------
        ID: int

        Returns
        -------
        bool

        """
        return _TFunction.TFunction_Scope_RemoveFunction(self, *args)

    @staticmethod
    def Set(*args) -> "opencascade::handle< TFunction_Scope >":
        r"""
        Static methods ============== finds or creates a tfunction_scope attribute at the root label accessed by <access>. returns the attribute.

        Parameters
        ----------
        Access: TDF_Label

        Returns
        -------
        opencascade::handle<TFunction_Scope>

        """
        return _TFunction.TFunction_Scope_Set(*args)

    def SetFreeID(self, *args) -> "void":
        r"""
        No available documentation.

        Parameters
        ----------
        ID: int

        Returns
        -------
        None

        """
        return _TFunction.TFunction_Scope_SetFreeID(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_TFunction_Scope_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _TFunction.delete_TFunction_Scope

# Register TFunction_Scope in _TFunction:
_TFunction.TFunction_Scope_swigregister(TFunction_Scope)

def TFunction_Scope_GetID(*args) -> "Standard_GUID const &":
    r"""
    Returns the guid for scope attribute. instant methods =============== constructor (empty).

    Returns
    -------
    Standard_GUID

    """
    return _TFunction.TFunction_Scope_GetID(*args)

def TFunction_Scope_Set(*args) -> "opencascade::handle< TFunction_Scope >":
    r"""
    Static methods ============== finds or creates a tfunction_scope attribute at the root label accessed by <access>. returns the attribute.

    Parameters
    ----------
    Access: TDF_Label

    Returns
    -------
    opencascade::handle<TFunction_Scope>

    """
    return _TFunction.TFunction_Scope_Set(*args)

class TFunction_HArray1OfDataMapOfGUIDDriver(TFunction_Array1OfDataMapOfGUIDDriver, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _TFunction.TFunction_HArray1OfDataMapOfGUIDDriver_swiginit(self, _TFunction.new_TFunction_HArray1OfDataMapOfGUIDDriver(*args))

    def Array1(self) -> "TFunction_Array1OfDataMapOfGUIDDriver const &":
        return _TFunction.TFunction_HArray1OfDataMapOfGUIDDriver_Array1(self)

    def ChangeArray1(self) -> "TFunction_Array1OfDataMapOfGUIDDriver &":
        return _TFunction.TFunction_HArray1OfDataMapOfGUIDDriver_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_TFunction_HArray1OfDataMapOfGUIDDriver_DownCast(t)

    __swig_destroy__ = _TFunction.delete_TFunction_HArray1OfDataMapOfGUIDDriver

# Register TFunction_HArray1OfDataMapOfGUIDDriver in _TFunction:
_TFunction.TFunction_HArray1OfDataMapOfGUIDDriver_swigregister(TFunction_HArray1OfDataMapOfGUIDDriver)





